/*
 * Copyright 2010-2021 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.test.runners;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.jetbrains.kotlin.test.utils.TransformersFunctions;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link GenerateNewCompilerTests.kt}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
public class DiagnosticTestGenerated extends AbstractDiagnosticTest {
    @Nested
    @TestMetadata("compiler/testData/diagnostics/tests")
    @TestDataPath("$PROJECT_ROOT")
    public class Tests {
        @Test
        @TestMetadata("Abstract.kt")
        public void testAbstract() throws Exception {
            runTest("compiler/testData/diagnostics/tests/Abstract.kt");
        }

        @Test
        @TestMetadata("AbstractAccessor.kt")
        public void testAbstractAccessor() throws Exception {
            runTest("compiler/testData/diagnostics/tests/AbstractAccessor.kt");
        }

        @Test
        @TestMetadata("AbstractInAbstractClass.kt")
        public void testAbstractInAbstractClass() throws Exception {
            runTest("compiler/testData/diagnostics/tests/AbstractInAbstractClass.kt");
        }

        @Test
        @TestMetadata("AbstractInClass.kt")
        public void testAbstractInClass() throws Exception {
            runTest("compiler/testData/diagnostics/tests/AbstractInClass.kt");
        }

        @Test
        @TestMetadata("AbstractInTrait.kt")
        public void testAbstractInTrait() throws Exception {
            runTest("compiler/testData/diagnostics/tests/AbstractInTrait.kt");
        }

        @Test
        public void testAllFilesPresentInTests() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
        }

        @Test
        @TestMetadata("AnonymousInitializerVarAndConstructor.kt")
        public void testAnonymousInitializerVarAndConstructor() throws Exception {
            runTest("compiler/testData/diagnostics/tests/AnonymousInitializerVarAndConstructor.kt");
        }

        @Test
        @TestMetadata("AnonymousInitializers.kt")
        public void testAnonymousInitializers() throws Exception {
            runTest("compiler/testData/diagnostics/tests/AnonymousInitializers.kt");
        }

        @Test
        @TestMetadata("AssignToArrayElement.kt")
        public void testAssignToArrayElement() throws Exception {
            runTest("compiler/testData/diagnostics/tests/AssignToArrayElement.kt");
        }

        @Test
        @TestMetadata("AutoCreatedIt.kt")
        public void testAutoCreatedIt() throws Exception {
            runTest("compiler/testData/diagnostics/tests/AutoCreatedIt.kt");
        }

        @Test
        @TestMetadata("BacktickNames.kt")
        public void testBacktickNames() throws Exception {
            runTest("compiler/testData/diagnostics/tests/BacktickNames.kt");
        }

        @Test
        @TestMetadata("Basic.kt")
        public void testBasic() throws Exception {
            runTest("compiler/testData/diagnostics/tests/Basic.kt");
        }

        @Test
        @TestMetadata("BinaryCallsOnNullableValues.kt")
        public void testBinaryCallsOnNullableValues() throws Exception {
            runTest("compiler/testData/diagnostics/tests/BinaryCallsOnNullableValues.kt");
        }

        @Test
        @TestMetadata("Bounds.kt")
        public void testBounds() throws Exception {
            runTest("compiler/testData/diagnostics/tests/Bounds.kt");
        }

        @Test
        @TestMetadata("BreakContinue.kt")
        public void testBreakContinue() throws Exception {
            runTest("compiler/testData/diagnostics/tests/BreakContinue.kt");
        }

        @Test
        @TestMetadata("BreakContinueInWhen_after.kt")
        public void testBreakContinueInWhen_after() throws Exception {
            runTest("compiler/testData/diagnostics/tests/BreakContinueInWhen_after.kt");
        }

        @Test
        @TestMetadata("BreakContinueInWhen_before.kt")
        public void testBreakContinueInWhen_before() throws Exception {
            runTest("compiler/testData/diagnostics/tests/BreakContinueInWhen_before.kt");
        }

        @Test
        @TestMetadata("Builders.kt")
        public void testBuilders() throws Exception {
            runTest("compiler/testData/diagnostics/tests/Builders.kt");
        }

        @Test
        @TestMetadata("Casts.kt")
        public void testCasts() throws Exception {
            runTest("compiler/testData/diagnostics/tests/Casts.kt");
        }

        @Test
        @TestMetadata("CharacterLiterals.kt")
        public void testCharacterLiterals() throws Exception {
            runTest("compiler/testData/diagnostics/tests/CharacterLiterals.kt");
        }

        @Test
        @TestMetadata("checkTypeTest.kt")
        public void testCheckTypeTest() throws Exception {
            runTest("compiler/testData/diagnostics/tests/checkTypeTest.kt");
        }

        @Test
        @TestMetadata("CompareToWithErrorType.kt")
        public void testCompareToWithErrorType() throws Exception {
            runTest("compiler/testData/diagnostics/tests/CompareToWithErrorType.kt");
        }

        @Test
        @TestMetadata("Constants.kt")
        public void testConstants() throws Exception {
            runTest("compiler/testData/diagnostics/tests/Constants.kt");
        }

        @Test
        @TestMetadata("Constructors.kt")
        public void testConstructors() throws Exception {
            runTest("compiler/testData/diagnostics/tests/Constructors.kt");
        }

        @Test
        @TestMetadata("ConstructorsOfPrimitives.kt")
        public void testConstructorsOfPrimitives() throws Exception {
            runTest("compiler/testData/diagnostics/tests/ConstructorsOfPrimitives.kt");
        }

        @Test
        @TestMetadata("CovariantOverrideType.kt")
        public void testCovariantOverrideType() throws Exception {
            runTest("compiler/testData/diagnostics/tests/CovariantOverrideType.kt");
        }

        @Test
        @TestMetadata("DefaultValueForParameterInFunctionType.kt")
        public void testDefaultValueForParameterInFunctionType() throws Exception {
            runTest("compiler/testData/diagnostics/tests/DefaultValueForParameterInFunctionType.kt");
        }

        @Test
        @TestMetadata("DefaultValuesCheckWithoutBody.kt")
        public void testDefaultValuesCheckWithoutBody() throws Exception {
            runTest("compiler/testData/diagnostics/tests/DefaultValuesCheckWithoutBody.kt");
        }

        @Test
        @TestMetadata("DefaultValuesTypechecking.kt")
        public void testDefaultValuesTypechecking() throws Exception {
            runTest("compiler/testData/diagnostics/tests/DefaultValuesTypechecking.kt");
        }

        @Test
        @TestMetadata("DeferredTypes.kt")
        public void testDeferredTypes() throws Exception {
            runTest("compiler/testData/diagnostics/tests/DeferredTypes.kt");
        }

        @Test
        @TestMetadata("DeprecatedGetSetPropertyDelegateConvention.kt")
        public void testDeprecatedGetSetPropertyDelegateConvention() throws Exception {
            runTest("compiler/testData/diagnostics/tests/DeprecatedGetSetPropertyDelegateConvention.kt");
        }

        @Test
        @TestMetadata("DeprecatedUnaryOperatorConventions.kt")
        public void testDeprecatedUnaryOperatorConventions() throws Exception {
            runTest("compiler/testData/diagnostics/tests/DeprecatedUnaryOperatorConventions.kt");
        }

        @Test
        @TestMetadata("DiamondFunction.kt")
        public void testDiamondFunction() throws Exception {
            runTest("compiler/testData/diagnostics/tests/DiamondFunction.kt");
        }

        @Test
        @TestMetadata("DiamondFunctionGeneric.kt")
        public void testDiamondFunctionGeneric() throws Exception {
            runTest("compiler/testData/diagnostics/tests/DiamondFunctionGeneric.kt");
        }

        @Test
        @TestMetadata("DiamondProperty.kt")
        public void testDiamondProperty() throws Exception {
            runTest("compiler/testData/diagnostics/tests/DiamondProperty.kt");
        }

        @Test
        @TestMetadata("Dollar.kt")
        public void testDollar() throws Exception {
            runTest("compiler/testData/diagnostics/tests/Dollar.kt");
        }

        @Test
        @TestMetadata("EnumEntryAsType.kt")
        public void testEnumEntryAsType() throws Exception {
            runTest("compiler/testData/diagnostics/tests/EnumEntryAsType.kt");
        }

        @Test
        @TestMetadata("ExtensionCallInvoke.kt")
        public void testExtensionCallInvoke() throws Exception {
            runTest("compiler/testData/diagnostics/tests/ExtensionCallInvoke.kt");
        }

        @Test
        @TestMetadata("ExternalAccessors.kt")
        public void testExternalAccessors() throws Exception {
            runTest("compiler/testData/diagnostics/tests/ExternalAccessors.kt");
        }

        @Test
        @TestMetadata("ExternalAndAbstract.kt")
        public void testExternalAndAbstract() throws Exception {
            runTest("compiler/testData/diagnostics/tests/ExternalAndAbstract.kt");
        }

        @Test
        @TestMetadata("fileDependencyRecursion.kt")
        public void testFileDependencyRecursion() throws Exception {
            runTest("compiler/testData/diagnostics/tests/fileDependencyRecursion.kt");
        }

        @Test
        @TestMetadata("ForRangeConventions.kt")
        public void testForRangeConventions() throws Exception {
            runTest("compiler/testData/diagnostics/tests/ForRangeConventions.kt");
        }

        @Test
        @TestMetadata("FreeFunctionCalledAsExtension.kt")
        public void testFreeFunctionCalledAsExtension() throws Exception {
            runTest("compiler/testData/diagnostics/tests/FreeFunctionCalledAsExtension.kt");
        }

        @Test
        @TestMetadata("FunctionCalleeExpressions.kt")
        public void testFunctionCalleeExpressions() throws Exception {
            runTest("compiler/testData/diagnostics/tests/FunctionCalleeExpressions.kt");
        }

        @Test
        @TestMetadata("FunctionParameterWithoutType.kt")
        public void testFunctionParameterWithoutType() throws Exception {
            runTest("compiler/testData/diagnostics/tests/FunctionParameterWithoutType.kt");
        }

        @Test
        @TestMetadata("FunctionReturnTypes.kt")
        public void testFunctionReturnTypes() throws Exception {
            runTest("compiler/testData/diagnostics/tests/FunctionReturnTypes.kt");
        }

        @Test
        @TestMetadata("GenericArgumentConsistency.kt")
        public void testGenericArgumentConsistency() throws Exception {
            runTest("compiler/testData/diagnostics/tests/GenericArgumentConsistency.kt");
        }

        @Test
        @TestMetadata("GenericFunctionIsLessSpecific.kt")
        public void testGenericFunctionIsLessSpecific() throws Exception {
            runTest("compiler/testData/diagnostics/tests/GenericFunctionIsLessSpecific.kt");
        }

        @Test
        @TestMetadata("IdentityComparisonWithPrimitives.kt")
        public void testIdentityComparisonWithPrimitives() throws Exception {
            runTest("compiler/testData/diagnostics/tests/IdentityComparisonWithPrimitives.kt");
        }

        @Test
        @TestMetadata("implicitIntersection.kt")
        public void testImplicitIntersection() throws Exception {
            runTest("compiler/testData/diagnostics/tests/implicitIntersection.kt");
        }

        @Test
        @TestMetadata("implicitNestedIntersection.kt")
        public void testImplicitNestedIntersection() throws Exception {
            runTest("compiler/testData/diagnostics/tests/implicitNestedIntersection.kt");
        }

        @Test
        @TestMetadata("implicitNothing.kt")
        public void testImplicitNothing() throws Exception {
            runTest("compiler/testData/diagnostics/tests/implicitNothing.kt");
        }

        @Test
        @TestMetadata("IncDec.kt")
        public void testIncDec() throws Exception {
            runTest("compiler/testData/diagnostics/tests/IncDec.kt");
        }

        @Test
        @TestMetadata("IncDecOperatorsInExpectClass.kt")
        public void testIncDecOperatorsInExpectClass() throws Exception {
            runTest("compiler/testData/diagnostics/tests/IncDecOperatorsInExpectClass.kt");
        }

        @Test
        @TestMetadata("IncorrectCharacterLiterals.kt")
        public void testIncorrectCharacterLiterals() throws Exception {
            runTest("compiler/testData/diagnostics/tests/IncorrectCharacterLiterals.kt");
        }

        @Test
        @TestMetadata("InferNullabilityInThenBlock.kt")
        public void testInferNullabilityInThenBlock() throws Exception {
            runTest("compiler/testData/diagnostics/tests/InferNullabilityInThenBlock.kt");
        }

        @Test
        @TestMetadata("Infix.kt")
        public void testInfix() throws Exception {
            runTest("compiler/testData/diagnostics/tests/Infix.kt");
        }

        @Test
        @TestMetadata("InfixModifierApplicability.kt")
        public void testInfixModifierApplicability() throws Exception {
            runTest("compiler/testData/diagnostics/tests/InfixModifierApplicability.kt");
        }

        @Test
        @TestMetadata("initializedAfterRethrow.kt")
        public void testInitializedAfterRethrow() throws Exception {
            runTest("compiler/testData/diagnostics/tests/initializedAfterRethrow.kt");
        }

        @Test
        @TestMetadata("InvokeAndRecursiveResolve.kt")
        public void testInvokeAndRecursiveResolve() throws Exception {
            runTest("compiler/testData/diagnostics/tests/InvokeAndRecursiveResolve.kt");
        }

        @Test
        @TestMetadata("IsExpressions.kt")
        public void testIsExpressions() throws Exception {
            runTest("compiler/testData/diagnostics/tests/IsExpressions.kt");
        }

        @Test
        @TestMetadata("kt11167.kt")
        public void testKt11167() throws Exception {
            runTest("compiler/testData/diagnostics/tests/kt11167.kt");
        }

        @Test
        @TestMetadata("kt13401.kt")
        public void testKt13401() throws Exception {
            runTest("compiler/testData/diagnostics/tests/kt13401.kt");
        }

        @Test
        @TestMetadata("kt310.kt")
        public void testKt310() throws Exception {
            runTest("compiler/testData/diagnostics/tests/kt310.kt");
        }

        @Test
        @TestMetadata("kt34440.kt")
        public void testKt34440() throws Exception {
            runTest("compiler/testData/diagnostics/tests/kt34440.kt");
        }

        @Test
        @TestMetadata("kt34857.kt")
        public void testKt34857() throws Exception {
            runTest("compiler/testData/diagnostics/tests/kt34857.kt");
        }

        @Test
        @TestMetadata("kt435.kt")
        public void testKt435() throws Exception {
            runTest("compiler/testData/diagnostics/tests/kt435.kt");
        }

        @Test
        @TestMetadata("kt49438.kt")
        public void testKt49438() throws Exception {
            runTest("compiler/testData/diagnostics/tests/kt49438.kt");
        }

        @Test
        @TestMetadata("kt53.kt")
        public void testKt53() throws Exception {
            runTest("compiler/testData/diagnostics/tests/kt53.kt");
        }

        @Test
        @TestMetadata("LValueAssignment.kt")
        public void testLValueAssignment() throws Exception {
            runTest("compiler/testData/diagnostics/tests/LValueAssignment.kt");
        }

        @Test
        @TestMetadata("LiteralAsResult.kt")
        public void testLiteralAsResult() throws Exception {
            runTest("compiler/testData/diagnostics/tests/LiteralAsResult.kt");
        }

        @Test
        @TestMetadata("LocalClassAndShortSubpackageNames.kt")
        public void testLocalClassAndShortSubpackageNames() throws Exception {
            runTest("compiler/testData/diagnostics/tests/LocalClassAndShortSubpackageNames.kt");
        }

        @Test
        @TestMetadata("localInterfaces.kt")
        public void testLocalInterfaces() throws Exception {
            runTest("compiler/testData/diagnostics/tests/localInterfaces.kt");
        }

        @Test
        @TestMetadata("MultilineStringTemplates.kt")
        public void testMultilineStringTemplates() throws Exception {
            runTest("compiler/testData/diagnostics/tests/MultilineStringTemplates.kt");
        }

        @Test
        @TestMetadata("MultipleBounds.kt")
        public void testMultipleBounds() throws Exception {
            runTest("compiler/testData/diagnostics/tests/MultipleBounds.kt");
        }

        @Test
        @TestMetadata("NamedFunctionTypeParameterInSupertype.kt")
        public void testNamedFunctionTypeParameterInSupertype() throws Exception {
            runTest("compiler/testData/diagnostics/tests/NamedFunctionTypeParameterInSupertype.kt");
        }

        @Test
        @TestMetadata("Nullability.kt")
        public void testNullability() throws Exception {
            runTest("compiler/testData/diagnostics/tests/Nullability.kt");
        }

        @Test
        @TestMetadata("NumberPrefixAndSuffix.kt")
        public void testNumberPrefixAndSuffix() throws Exception {
            runTest("compiler/testData/diagnostics/tests/NumberPrefixAndSuffix.kt");
        }

        @Test
        @TestMetadata("ObjectWithConstructor.kt")
        public void testObjectWithConstructor() throws Exception {
            runTest("compiler/testData/diagnostics/tests/ObjectWithConstructor.kt");
        }

        @Test
        @TestMetadata("OperatorChecks.kt")
        public void testOperatorChecks() throws Exception {
            runTest("compiler/testData/diagnostics/tests/OperatorChecks.kt");
        }

        @Test
        @TestMetadata("Operators.kt")
        public void testOperators() throws Exception {
            runTest("compiler/testData/diagnostics/tests/Operators.kt");
        }

        @Test
        @TestMetadata("OperatorsWithWrongNames.kt")
        public void testOperatorsWithWrongNames() throws Exception {
            runTest("compiler/testData/diagnostics/tests/OperatorsWithWrongNames.kt");
        }

        @Test
        @TestMetadata("OverrideFunctionWithParamDefaultValue.kt")
        public void testOverrideFunctionWithParamDefaultValue() throws Exception {
            runTest("compiler/testData/diagnostics/tests/OverrideFunctionWithParamDefaultValue.kt");
        }

        @Test
        @TestMetadata("OverridenFunctionAndSpecifiedTypeParameter.kt")
        public void testOverridenFunctionAndSpecifiedTypeParameter() throws Exception {
            runTest("compiler/testData/diagnostics/tests/OverridenFunctionAndSpecifiedTypeParameter.kt");
        }

        @Test
        @TestMetadata("OverridenSetterVisibility.kt")
        public void testOverridenSetterVisibility() throws Exception {
            runTest("compiler/testData/diagnostics/tests/OverridenSetterVisibility.kt");
        }

        @Test
        @TestMetadata("OverridingVarByVal.kt")
        public void testOverridingVarByVal() throws Exception {
            runTest("compiler/testData/diagnostics/tests/OverridingVarByVal.kt");
        }

        @Test
        @TestMetadata("PackageInExpressionPosition.kt")
        public void testPackageInExpressionPosition() throws Exception {
            runTest("compiler/testData/diagnostics/tests/PackageInExpressionPosition.kt");
        }

        @Test
        @TestMetadata("PackageInTypePosition.kt")
        public void testPackageInTypePosition() throws Exception {
            runTest("compiler/testData/diagnostics/tests/PackageInTypePosition.kt");
        }

        @Test
        @TestMetadata("PackageQualified.kt")
        public void testPackageQualified() throws Exception {
            runTest("compiler/testData/diagnostics/tests/PackageQualified.kt");
        }

        @Test
        @TestMetadata("PrimaryConstructors.kt")
        public void testPrimaryConstructors() throws Exception {
            runTest("compiler/testData/diagnostics/tests/PrimaryConstructors.kt");
        }

        @Test
        @TestMetadata("PrivateFromOuterPackage.kt")
        public void testPrivateFromOuterPackage() throws Exception {
            runTest("compiler/testData/diagnostics/tests/PrivateFromOuterPackage.kt");
        }

        @Test
        @TestMetadata("PrivateSetterForOverridden.kt")
        public void testPrivateSetterForOverridden() throws Exception {
            runTest("compiler/testData/diagnostics/tests/PrivateSetterForOverridden.kt");
        }

        @Test
        @TestMetadata("ProcessingEmptyImport.kt")
        public void testProcessingEmptyImport() throws Exception {
            runTest("compiler/testData/diagnostics/tests/ProcessingEmptyImport.kt");
        }

        @Test
        @TestMetadata("ProjectionOnFunctionArgumentErrror.kt")
        public void testProjectionOnFunctionArgumentErrror() throws Exception {
            runTest("compiler/testData/diagnostics/tests/ProjectionOnFunctionArgumentErrror.kt");
        }

        @Test
        @TestMetadata("ProjectionsInSupertypes.kt")
        public void testProjectionsInSupertypes() throws Exception {
            runTest("compiler/testData/diagnostics/tests/ProjectionsInSupertypes.kt");
        }

        @Test
        @TestMetadata("properDefaultInitializationInTailrec.kt")
        public void testProperDefaultInitializationInTailrec() throws Exception {
            runTest("compiler/testData/diagnostics/tests/properDefaultInitializationInTailrec.kt");
        }

        @Test
        @TestMetadata("Properties.kt")
        public void testProperties() throws Exception {
            runTest("compiler/testData/diagnostics/tests/Properties.kt");
        }

        @Test
        @TestMetadata("PropertyInitializers.kt")
        public void testPropertyInitializers() throws Exception {
            runTest("compiler/testData/diagnostics/tests/PropertyInitializers.kt");
        }

        @Test
        @TestMetadata("protectedWithGenericsInDifferentPackage.kt")
        public void testProtectedWithGenericsInDifferentPackage() throws Exception {
            runTest("compiler/testData/diagnostics/tests/protectedWithGenericsInDifferentPackage.kt");
        }

        @Test
        @TestMetadata("publishedApi.kt")
        public void testPublishedApi() throws Exception {
            runTest("compiler/testData/diagnostics/tests/publishedApi.kt");
        }

        @Test
        @TestMetadata("QualifiedExpressions.kt")
        public void testQualifiedExpressions() throws Exception {
            runTest("compiler/testData/diagnostics/tests/QualifiedExpressions.kt");
        }

        @Test
        @TestMetadata("RecursiveResolve.kt")
        public void testRecursiveResolve() throws Exception {
            runTest("compiler/testData/diagnostics/tests/RecursiveResolve.kt");
        }

        @Test
        @TestMetadata("RecursiveTypeInference.kt")
        public void testRecursiveTypeInference() throws Exception {
            runTest("compiler/testData/diagnostics/tests/RecursiveTypeInference.kt");
        }

        @Test
        @TestMetadata("RecursiveTypeParameterEqualityCheck.kt")
        public void testRecursiveTypeParameterEqualityCheck() throws Exception {
            runTest("compiler/testData/diagnostics/tests/RecursiveTypeParameterEqualityCheck.kt");
        }

        @Test
        @TestMetadata("ReserveYield.kt")
        public void testReserveYield() throws Exception {
            runTest("compiler/testData/diagnostics/tests/ReserveYield.kt");
        }

        @Test
        @TestMetadata("ReserveYield2.kt")
        public void testReserveYield2() throws Exception {
            runTest("compiler/testData/diagnostics/tests/ReserveYield2.kt");
        }

        @Test
        @TestMetadata("ReserveYieldNoMore.kt")
        public void testReserveYieldNoMore() throws Exception {
            runTest("compiler/testData/diagnostics/tests/ReserveYieldNoMore.kt");
        }

        @Test
        @TestMetadata("ReserveYieldNoMore2.kt")
        public void testReserveYieldNoMore2() throws Exception {
            runTest("compiler/testData/diagnostics/tests/ReserveYieldNoMore2.kt");
        }

        @Test
        @TestMetadata("ResolveOfJavaGenerics.kt")
        public void testResolveOfJavaGenerics() throws Exception {
            runTest("compiler/testData/diagnostics/tests/ResolveOfJavaGenerics.kt");
        }

        @Test
        @TestMetadata("ResolveToJava.kt")
        public void testResolveToJava() throws Exception {
            runTest("compiler/testData/diagnostics/tests/ResolveToJava.kt");
        }

        @Test
        @TestMetadata("Return.kt")
        public void testReturn() throws Exception {
            runTest("compiler/testData/diagnostics/tests/Return.kt");
        }

        @Test
        @TestMetadata("ReturnInFunctionWithoutBody.kt")
        public void testReturnInFunctionWithoutBody() throws Exception {
            runTest("compiler/testData/diagnostics/tests/ReturnInFunctionWithoutBody.kt");
        }

        @Test
        @TestMetadata("safeCall.kt")
        public void testSafeCall() throws Exception {
            runTest("compiler/testData/diagnostics/tests/safeCall.kt");
        }

        @Test
        @TestMetadata("SafeCallInvoke.kt")
        public void testSafeCallInvoke() throws Exception {
            runTest("compiler/testData/diagnostics/tests/SafeCallInvoke.kt");
        }

        @Test
        @TestMetadata("SafeCallNonNullReceiver.kt")
        public void testSafeCallNonNullReceiver() throws Exception {
            runTest("compiler/testData/diagnostics/tests/SafeCallNonNullReceiver.kt");
        }

        @Test
        @TestMetadata("SafeCallNonNullReceiver2.kt")
        public void testSafeCallNonNullReceiver2() throws Exception {
            runTest("compiler/testData/diagnostics/tests/SafeCallNonNullReceiver2.kt");
        }

        @Test
        @TestMetadata("SafeCallNonNullReceiverReturnNull.kt")
        public void testSafeCallNonNullReceiverReturnNull() throws Exception {
            runTest("compiler/testData/diagnostics/tests/SafeCallNonNullReceiverReturnNull.kt");
        }

        @Test
        @TestMetadata("SafeCallOnFakePackage.kt")
        public void testSafeCallOnFakePackage() throws Exception {
            runTest("compiler/testData/diagnostics/tests/SafeCallOnFakePackage.kt");
        }

        @Test
        @TestMetadata("SafeCallOnSuperReceiver.kt")
        public void testSafeCallOnSuperReceiver() throws Exception {
            runTest("compiler/testData/diagnostics/tests/SafeCallOnSuperReceiver.kt");
        }

        @Test
        @TestMetadata("SafeCallUnknownType.kt")
        public void testSafeCallUnknownType() throws Exception {
            runTest("compiler/testData/diagnostics/tests/SafeCallUnknownType.kt");
        }

        @Test
        @TestMetadata("Serializable.kt")
        public void testSerializable() throws Exception {
            runTest("compiler/testData/diagnostics/tests/Serializable.kt");
        }

        @Test
        @TestMetadata("SetterVisibility.kt")
        public void testSetterVisibility() throws Exception {
            runTest("compiler/testData/diagnostics/tests/SetterVisibility.kt");
        }

        @Test
        @TestMetadata("ShiftFunctionTypes.kt")
        public void testShiftFunctionTypes() throws Exception {
            runTest("compiler/testData/diagnostics/tests/ShiftFunctionTypes.kt");
        }

        @Test
        @TestMetadata("StarsInFunctionCalls.kt")
        public void testStarsInFunctionCalls() throws Exception {
            runTest("compiler/testData/diagnostics/tests/StarsInFunctionCalls.kt");
        }

        @Test
        @TestMetadata("StringPrefixAndSuffix.kt")
        public void testStringPrefixAndSuffix() throws Exception {
            runTest("compiler/testData/diagnostics/tests/StringPrefixAndSuffix.kt");
        }

        @Test
        @TestMetadata("StringTemplates.kt")
        public void testStringTemplates() throws Exception {
            runTest("compiler/testData/diagnostics/tests/StringTemplates.kt");
        }

        @Test
        @TestMetadata("SupertypeListChecks.kt")
        public void testSupertypeListChecks() throws Exception {
            runTest("compiler/testData/diagnostics/tests/SupertypeListChecks.kt");
        }

        @Test
        @TestMetadata("SyntaxErrorInTestHighlighting.kt")
        public void testSyntaxErrorInTestHighlighting() throws Exception {
            runTest("compiler/testData/diagnostics/tests/SyntaxErrorInTestHighlighting.kt");
        }

        @Test
        @TestMetadata("SyntaxErrorInTestHighlightingEof.kt")
        public void testSyntaxErrorInTestHighlightingEof() throws Exception {
            runTest("compiler/testData/diagnostics/tests/SyntaxErrorInTestHighlightingEof.kt");
        }

        @Test
        @TestMetadata("tailRecBasic.kt")
        public void testTailRecBasic() throws Exception {
            runTest("compiler/testData/diagnostics/tests/tailRecBasic.kt");
        }

        @Test
        @TestMetadata("tailRecInNestedScopes.kt")
        public void testTailRecInNestedScopes() throws Exception {
            runTest("compiler/testData/diagnostics/tests/tailRecInNestedScopes.kt");
        }

        @Test
        @TestMetadata("tailRecInTry.kt")
        public void testTailRecInTry() throws Exception {
            runTest("compiler/testData/diagnostics/tests/tailRecInTry.kt");
        }

        @Test
        @TestMetadata("tailRecOnVirtualMember.kt")
        public void testTailRecOnVirtualMember() throws Exception {
            runTest("compiler/testData/diagnostics/tests/tailRecOnVirtualMember.kt");
        }

        @Test
        @TestMetadata("tailRecOnVirtualMemberError.kt")
        public void testTailRecOnVirtualMemberError() throws Exception {
            runTest("compiler/testData/diagnostics/tests/tailRecOnVirtualMemberError.kt");
        }

        @Test
        @TestMetadata("tailRecOverridden.kt")
        public void testTailRecOverridden() throws Exception {
            runTest("compiler/testData/diagnostics/tests/tailRecOverridden.kt");
        }

        @Test
        @TestMetadata("tailRecSingleton.kt")
        public void testTailRecSingleton() throws Exception {
            runTest("compiler/testData/diagnostics/tests/tailRecSingleton.kt");
        }

        @Test
        @TestMetadata("tailRecWithDispatchReceiver.kt")
        public void testTailRecWithDispatchReceiver() throws Exception {
            runTest("compiler/testData/diagnostics/tests/tailRecWithDispatchReceiver.kt");
        }

        @Test
        @TestMetadata("tailRecWithExtensionReceiver.kt")
        public void testTailRecWithExtensionReceiver() throws Exception {
            runTest("compiler/testData/diagnostics/tests/tailRecWithExtensionReceiver.kt");
        }

        @Test
        @TestMetadata("tailRecursionComplex.kt")
        public void testTailRecursionComplex() throws Exception {
            runTest("compiler/testData/diagnostics/tests/tailRecursionComplex.kt");
        }

        @Test
        @TestMetadata("TraitOverrideObjectMethods.kt")
        public void testTraitOverrideObjectMethods() throws Exception {
            runTest("compiler/testData/diagnostics/tests/TraitOverrideObjectMethods.kt");
        }

        @Test
        @TestMetadata("TraitWithConstructor.kt")
        public void testTraitWithConstructor() throws Exception {
            runTest("compiler/testData/diagnostics/tests/TraitWithConstructor.kt");
        }

        @Test
        @TestMetadata("TypeInference.kt")
        public void testTypeInference() throws Exception {
            runTest("compiler/testData/diagnostics/tests/TypeInference.kt");
        }

        @Test
        @TestMetadata("TypeMismatchOnOverrideWithSyntaxErrors.kt")
        public void testTypeMismatchOnOverrideWithSyntaxErrors() throws Exception {
            runTest("compiler/testData/diagnostics/tests/TypeMismatchOnOverrideWithSyntaxErrors.kt");
        }

        @Test
        @TestMetadata("Underscore.kt")
        public void testUnderscore() throws Exception {
            runTest("compiler/testData/diagnostics/tests/Underscore.kt");
        }

        @Test
        @TestMetadata("UnderscoreUsageInAnnotation.kt")
        public void testUnderscoreUsageInAnnotation() throws Exception {
            runTest("compiler/testData/diagnostics/tests/UnderscoreUsageInAnnotation.kt");
        }

        @Test
        @TestMetadata("UnderscoreUsageInCall.kt")
        public void testUnderscoreUsageInCall() throws Exception {
            runTest("compiler/testData/diagnostics/tests/UnderscoreUsageInCall.kt");
        }

        @Test
        @TestMetadata("UnderscoreUsageInCallableRefTypeLHS.kt")
        public void testUnderscoreUsageInCallableRefTypeLHS() throws Exception {
            runTest("compiler/testData/diagnostics/tests/UnderscoreUsageInCallableRefTypeLHS.kt");
        }

        @Test
        @TestMetadata("UnderscoreUsageInType.kt")
        public void testUnderscoreUsageInType() throws Exception {
            runTest("compiler/testData/diagnostics/tests/UnderscoreUsageInType.kt");
        }

        @Test
        @TestMetadata("UnderscoreUsageInVariableAsFunctionCall.kt")
        public void testUnderscoreUsageInVariableAsFunctionCall() throws Exception {
            runTest("compiler/testData/diagnostics/tests/UnderscoreUsageInVariableAsFunctionCall.kt");
        }

        @Test
        @TestMetadata("UnitByDefaultForFunctionTypes.kt")
        public void testUnitByDefaultForFunctionTypes() throws Exception {
            runTest("compiler/testData/diagnostics/tests/UnitByDefaultForFunctionTypes.kt");
        }

        @Test
        @TestMetadata("UnitValue.kt")
        public void testUnitValue() throws Exception {
            runTest("compiler/testData/diagnostics/tests/UnitValue.kt");
        }

        @Test
        @TestMetadata("unproperDefaultInitializationInTailrec.kt")
        public void testUnproperDefaultInitializationInTailrec() throws Exception {
            runTest("compiler/testData/diagnostics/tests/unproperDefaultInitializationInTailrec.kt");
        }

        @Test
        @TestMetadata("Unresolved.kt")
        public void testUnresolved() throws Exception {
            runTest("compiler/testData/diagnostics/tests/Unresolved.kt");
        }

        @Test
        @TestMetadata("UnusedInDestructuring.kt")
        public void testUnusedInDestructuring() throws Exception {
            runTest("compiler/testData/diagnostics/tests/UnusedInDestructuring.kt");
        }

        @Test
        @TestMetadata("UnusedParameters.kt")
        public void testUnusedParameters() throws Exception {
            runTest("compiler/testData/diagnostics/tests/UnusedParameters.kt");
        }

        @Test
        @TestMetadata("UnusedVariables.kt")
        public void testUnusedVariables() throws Exception {
            runTest("compiler/testData/diagnostics/tests/UnusedVariables.kt");
        }

        @Test
        @TestMetadata("ValAndFunOverrideCompatibilityClash.kt")
        public void testValAndFunOverrideCompatibilityClash() throws Exception {
            runTest("compiler/testData/diagnostics/tests/ValAndFunOverrideCompatibilityClash.kt");
        }

        @Test
        @TestMetadata("VarargTypes.kt")
        public void testVarargTypes() throws Exception {
            runTest("compiler/testData/diagnostics/tests/VarargTypes.kt");
        }

        @Test
        @TestMetadata("Varargs.kt")
        public void testVarargs() throws Exception {
            runTest("compiler/testData/diagnostics/tests/Varargs.kt");
        }

        @Test
        @TestMetadata("Variance.kt")
        public void testVariance() throws Exception {
            runTest("compiler/testData/diagnostics/tests/Variance.kt");
        }

        @Nested
        @TestMetadata("compiler/testData/diagnostics/tests/annotations")
        @TestDataPath("$PROJECT_ROOT")
        public class Annotations {
            @Test
            public void testAllFilesPresentInAnnotations() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/annotations"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
            }

            @Test
            @TestMetadata("AmbigiousAnnotationConstructor.kt")
            public void testAmbigiousAnnotationConstructor() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/AmbigiousAnnotationConstructor.kt");
            }

            @Test
            @TestMetadata("AnnotatedConstructor.kt")
            public void testAnnotatedConstructor() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/AnnotatedConstructor.kt");
            }

            @Test
            @TestMetadata("AnnotatedConstructorParams.kt")
            public void testAnnotatedConstructorParams() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/AnnotatedConstructorParams.kt");
            }

            @Test
            @TestMetadata("annotatedExpressionInsideAnnotation.kt")
            public void testAnnotatedExpressionInsideAnnotation() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/annotatedExpressionInsideAnnotation.kt");
            }

            @Test
            @TestMetadata("AnnotatedLocalObjectFun.kt")
            public void testAnnotatedLocalObjectFun() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/AnnotatedLocalObjectFun.kt");
            }

            @Test
            @TestMetadata("AnnotatedLocalObjectProperty.kt")
            public void testAnnotatedLocalObjectProperty() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/AnnotatedLocalObjectProperty.kt");
            }

            @Test
            @TestMetadata("AnnotatedLoop.kt")
            public void testAnnotatedLoop() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/AnnotatedLoop.kt");
            }

            @Test
            @TestMetadata("AnnotatedResultType.kt")
            public void testAnnotatedResultType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/AnnotatedResultType.kt");
            }

            @Test
            @TestMetadata("AnnotatedTryCatch.kt")
            public void testAnnotatedTryCatch() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/AnnotatedTryCatch.kt");
            }

            @Test
            @TestMetadata("AnnotationAsDefaultParameter.kt")
            public void testAnnotationAsDefaultParameter() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/AnnotationAsDefaultParameter.kt");
            }

            @Test
            @TestMetadata("AnnotationForClassTypeParameter_15.kt")
            public void testAnnotationForClassTypeParameter_15() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/AnnotationForClassTypeParameter_15.kt");
            }

            @Test
            @TestMetadata("AnnotationForClassTypeParameter_16.kt")
            public void testAnnotationForClassTypeParameter_16() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/AnnotationForClassTypeParameter_16.kt");
            }

            @Test
            @TestMetadata("AnnotationForClassTypeParameter_typeUseFlag.kt")
            public void testAnnotationForClassTypeParameter_typeUseFlag() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/AnnotationForClassTypeParameter_typeUseFlag.kt");
            }

            @Test
            @TestMetadata("AnnotationForFunctionTypeParameter.kt")
            public void testAnnotationForFunctionTypeParameter() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/AnnotationForFunctionTypeParameter.kt");
            }

            @Test
            @TestMetadata("AnnotationForObject.kt")
            public void testAnnotationForObject() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/AnnotationForObject.kt");
            }

            @Test
            @TestMetadata("AnnotationIdentifier.kt")
            public void testAnnotationIdentifier() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/AnnotationIdentifier.kt");
            }

            @Test
            @TestMetadata("annotationInheritance.kt")
            public void testAnnotationInheritance() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/annotationInheritance.kt");
            }

            @Test
            @TestMetadata("annotationModifier.kt")
            public void testAnnotationModifier() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/annotationModifier.kt");
            }

            @Test
            @TestMetadata("AnnotationOnObject.kt")
            public void testAnnotationOnObject() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/AnnotationOnObject.kt");
            }

            @Test
            @TestMetadata("annotationOnParameterInFunctionType.kt")
            public void testAnnotationOnParameterInFunctionType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/annotationOnParameterInFunctionType.kt");
            }

            @Test
            @TestMetadata("annotationRenderingInTypes.kt")
            public void testAnnotationRenderingInTypes() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/annotationRenderingInTypes.kt");
            }

            @Test
            @TestMetadata("AnnotationsForClasses.kt")
            public void testAnnotationsForClasses() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/AnnotationsForClasses.kt");
            }

            @Test
            @TestMetadata("AnnotationsForPropertyTypeParameter.kt")
            public void testAnnotationsForPropertyTypeParameter() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/AnnotationsForPropertyTypeParameter.kt");
            }

            @Test
            @TestMetadata("annotationsOnLambdaAsCallArgument.kt")
            public void testAnnotationsOnLambdaAsCallArgument() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/annotationsOnLambdaAsCallArgument.kt");
            }

            @Test
            @TestMetadata("annotationsOnNullableTypes.kt")
            public void testAnnotationsOnNullableTypes() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/annotationsOnNullableTypes.kt");
            }

            @Test
            @TestMetadata("arrayLiteralInAnnotationCompanion_after.kt")
            public void testArrayLiteralInAnnotationCompanion_after() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/arrayLiteralInAnnotationCompanion_after.kt");
            }

            @Test
            @TestMetadata("arrayLiteralInAnnotationCompanion_before.kt")
            public void testArrayLiteralInAnnotationCompanion_before() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/arrayLiteralInAnnotationCompanion_before.kt");
            }

            @Test
            @TestMetadata("atAnnotationResolve.kt")
            public void testAtAnnotationResolve() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/atAnnotationResolve.kt");
            }

            @Test
            @TestMetadata("BasicAnnotations.kt")
            public void testBasicAnnotations() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/BasicAnnotations.kt");
            }

            @Test
            @TestMetadata("blockLevelOnTheSameLineWarning.kt")
            public void testBlockLevelOnTheSameLineWarning() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/blockLevelOnTheSameLineWarning.kt");
            }

            @Test
            @TestMetadata("ConstructorCall.kt")
            public void testConstructorCall() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/ConstructorCall.kt");
            }

            @Test
            @TestMetadata("ConstructorCallAllowed.kt")
            public void testConstructorCallAllowed() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/ConstructorCallAllowed.kt");
            }

            @Test
            @TestMetadata("cycleInParameters_after.kt")
            public void testCycleInParameters_after() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/cycleInParameters_after.kt");
            }

            @Test
            @TestMetadata("cycleInParameters_before.kt")
            public void testCycleInParameters_before() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/cycleInParameters_before.kt");
            }

            @Test
            @TestMetadata("DanglingInScript.kts")
            public void testDanglingInScript() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/DanglingInScript.kts");
            }

            @Test
            @TestMetadata("DanglingMixed.kt")
            public void testDanglingMixed() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/DanglingMixed.kt");
            }

            @Test
            @TestMetadata("DanglingNoBrackets.kt")
            public void testDanglingNoBrackets() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/DanglingNoBrackets.kt");
            }

            @Test
            @TestMetadata("DanglingWithBrackets.kt")
            public void testDanglingWithBrackets() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/DanglingWithBrackets.kt");
            }

            @Test
            @TestMetadata("Deprecated.kt")
            public void testDeprecated() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/Deprecated.kt");
            }

            @Test
            @TestMetadata("dontReportWarningAboutChangingExecutionOrderForVararg.kt")
            public void testDontReportWarningAboutChangingExecutionOrderForVararg() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/dontReportWarningAboutChangingExecutionOrderForVararg.kt");
            }

            @Test
            @TestMetadata("extensionFunctionType.kt")
            public void testExtensionFunctionType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/extensionFunctionType.kt");
            }

            @Test
            @TestMetadata("forParameterAnnotationResolve.kt")
            public void testForParameterAnnotationResolve() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/forParameterAnnotationResolve.kt");
            }

            @Test
            @TestMetadata("illegalRequireKotlinValue.kt")
            public void testIllegalRequireKotlinValue() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/illegalRequireKotlinValue.kt");
            }

            @Test
            @TestMetadata("illegalSinceKotlinValue.kt")
            public void testIllegalSinceKotlinValue() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/illegalSinceKotlinValue.kt");
            }

            @Test
            @TestMetadata("inheritFromAnnotationClass.kt")
            public void testInheritFromAnnotationClass() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/inheritFromAnnotationClass.kt");
            }

            @Test
            @TestMetadata("inheritFromAnnotationClass2.kt")
            public void testInheritFromAnnotationClass2() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/inheritFromAnnotationClass2.kt");
            }

            @Test
            @TestMetadata("invalidTypesInAnnotationConstructor.kt")
            public void testInvalidTypesInAnnotationConstructor() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/invalidTypesInAnnotationConstructor.kt");
            }

            @Test
            @TestMetadata("JavaAnnotationConstructors.kt")
            public void testJavaAnnotationConstructors() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/JavaAnnotationConstructors.kt");
            }

            @Test
            @TestMetadata("javaAnnotationWithClassArray.kt")
            public void testJavaAnnotationWithClassArray() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/javaAnnotationWithClassArray.kt");
            }

            @Test
            @TestMetadata("kt1860-negative.kt")
            public void testKt1860_negative() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/kt1860-negative.kt");
            }

            @Test
            @TestMetadata("kt1860-positive.kt")
            public void testKt1860_positive() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/kt1860-positive.kt");
            }

            @Test
            @TestMetadata("kt1886annotationBody_after.kt")
            public void testKt1886annotationBody_after() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/kt1886annotationBody_after.kt");
            }

            @Test
            @TestMetadata("kt1886annotationBody_before.kt")
            public void testKt1886annotationBody_before() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/kt1886annotationBody_before.kt");
            }

            @Test
            @TestMetadata("missingValOnParameter.kt")
            public void testMissingValOnParameter() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/missingValOnParameter.kt");
            }

            @Test
            @TestMetadata("MultiDeclaration.kt")
            public void testMultiDeclaration() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/MultiDeclaration.kt");
            }

            @Test
            @TestMetadata("MutuallyRecursivelyAnnotatedGlobalFunction.kt")
            public void testMutuallyRecursivelyAnnotatedGlobalFunction() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/MutuallyRecursivelyAnnotatedGlobalFunction.kt");
            }

            @Test
            @TestMetadata("nestedClassesInAnnotations.kt")
            public void testNestedClassesInAnnotations() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/nestedClassesInAnnotations.kt");
            }

            @Test
            @TestMetadata("noNameProperty.kt")
            public void testNoNameProperty() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/noNameProperty.kt");
            }

            @Test
            @TestMetadata("NonAnnotationClass.kt")
            public void testNonAnnotationClass() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/NonAnnotationClass.kt");
            }

            @Test
            @TestMetadata("onExpression.kt")
            public void testOnExpression() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/onExpression.kt");
            }

            @Test
            @TestMetadata("onFunctionParameter.kt")
            public void testOnFunctionParameter() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/onFunctionParameter.kt");
            }

            @Test
            @TestMetadata("onInitializer.kt")
            public void testOnInitializer() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/onInitializer.kt");
            }

            @Test
            @TestMetadata("onLoops.kt")
            public void testOnLoops() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/onLoops.kt");
            }

            @Test
            @TestMetadata("onLoopsUnreachable.kt")
            public void testOnLoopsUnreachable() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/onLoopsUnreachable.kt");
            }

            @Test
            @TestMetadata("onMultiDeclaration.kt")
            public void testOnMultiDeclaration() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/onMultiDeclaration.kt");
            }

            @Test
            @TestMetadata("RecursivelyAnnotated.kt")
            public void testRecursivelyAnnotated() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/RecursivelyAnnotated.kt");
            }

            @Test
            @TestMetadata("RecursivelyAnnotatedFunctionParameter.kt")
            public void testRecursivelyAnnotatedFunctionParameter() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/RecursivelyAnnotatedFunctionParameter.kt");
            }

            @Test
            @TestMetadata("RecursivelyAnnotatedGlobalFunction.kt")
            public void testRecursivelyAnnotatedGlobalFunction() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/RecursivelyAnnotatedGlobalFunction.kt");
            }

            @Test
            @TestMetadata("RecursivelyAnnotatedGlobalProperty.kt")
            public void testRecursivelyAnnotatedGlobalProperty() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/RecursivelyAnnotatedGlobalProperty.kt");
            }

            @Test
            @TestMetadata("RecursivelyAnnotatedParameter.kt")
            public void testRecursivelyAnnotatedParameter() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/RecursivelyAnnotatedParameter.kt");
            }

            @Test
            @TestMetadata("RecursivelyAnnotatedParameterType.kt")
            public void testRecursivelyAnnotatedParameterType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/RecursivelyAnnotatedParameterType.kt");
            }

            @Test
            @TestMetadata("RecursivelyAnnotatedParameterWithAt.kt")
            public void testRecursivelyAnnotatedParameterWithAt() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/RecursivelyAnnotatedParameterWithAt.kt");
            }

            @Test
            @TestMetadata("RecursivelyAnnotatedProperty.kt")
            public void testRecursivelyAnnotatedProperty() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/RecursivelyAnnotatedProperty.kt");
            }

            @Test
            @TestMetadata("RecursivelyIncorrectlyAnnotatedParameter.kt")
            public void testRecursivelyIncorrectlyAnnotatedParameter() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/RecursivelyIncorrectlyAnnotatedParameter.kt");
            }

            @Test
            @TestMetadata("requireKotlin.kt")
            public void testRequireKotlin() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/requireKotlin.kt");
            }

            @Test
            @TestMetadata("RetentionsOfAnnotationWithExpressionTarget_after.kt")
            public void testRetentionsOfAnnotationWithExpressionTarget_after() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/RetentionsOfAnnotationWithExpressionTarget_after.kt");
            }

            @Test
            @TestMetadata("RetentionsOfAnnotationWithExpressionTarget_before.kt")
            public void testRetentionsOfAnnotationWithExpressionTarget_before() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/RetentionsOfAnnotationWithExpressionTarget_before.kt");
            }

            @Test
            @TestMetadata("typeAnnotations.kt")
            public void testTypeAnnotations() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/typeAnnotations.kt");
            }

            @Test
            @TestMetadata("typeArgumentsInAnnotation.kt")
            public void testTypeArgumentsInAnnotation() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/typeArgumentsInAnnotation.kt");
            }

            @Test
            @TestMetadata("typeParameterAsAnnotation.kt")
            public void testTypeParameterAsAnnotation() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/typeParameterAsAnnotation.kt");
            }

            @Test
            @TestMetadata("UnresolvedAnnotationOnObject.kt")
            public void testUnresolvedAnnotationOnObject() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/UnresolvedAnnotationOnObject.kt");
            }

            @Test
            @TestMetadata("unresolvedReferenceRange.kt")
            public void testUnresolvedReferenceRange() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/unresolvedReferenceRange.kt");
            }

            @Test
            @TestMetadata("WrongAnnotationArgsOnObject.kt")
            public void testWrongAnnotationArgsOnObject() throws Exception {
                runTest("compiler/testData/diagnostics/tests/annotations/WrongAnnotationArgsOnObject.kt");
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/annotations/annotationParameterMustBeConstant")
            @TestDataPath("$PROJECT_ROOT")
            public class AnnotationParameterMustBeConstant {
                @Test
                public void testAllFilesPresentInAnnotationParameterMustBeConstant() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/annotations/annotationParameterMustBeConstant"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("annotationConstructorDefaultParameter.kt")
                public void testAnnotationConstructorDefaultParameter() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/annotationParameterMustBeConstant/annotationConstructorDefaultParameter.kt");
                }

                @Test
                @TestMetadata("booleanLocalVal.kt")
                public void testBooleanLocalVal() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/annotationParameterMustBeConstant/booleanLocalVal.kt");
                }

                @Test
                @TestMetadata("compareAndEquals.kt")
                public void testCompareAndEquals() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/annotationParameterMustBeConstant/compareAndEquals.kt");
                }

                @Test
                @TestMetadata("enumConst_after.kt")
                public void testEnumConst_after() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/annotationParameterMustBeConstant/enumConst_after.kt");
                }

                @Test
                @TestMetadata("enumConst_before.kt")
                public void testEnumConst_before() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/annotationParameterMustBeConstant/enumConst_before.kt");
                }

                @Test
                @TestMetadata("javaProperties.kt")
                public void testJavaProperties() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/annotationParameterMustBeConstant/javaProperties.kt");
                }

                @Test
                @TestMetadata("kotlinProperties.kt")
                public void testKotlinProperties() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/annotationParameterMustBeConstant/kotlinProperties.kt");
                }

                @Test
                @TestMetadata("standaloneInExpression.kt")
                public void testStandaloneInExpression() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/annotationParameterMustBeConstant/standaloneInExpression.kt");
                }

                @Test
                @TestMetadata("strings.kt")
                public void testStrings() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/annotationParameterMustBeConstant/strings.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/annotations/functionalTypes")
            @TestDataPath("$PROJECT_ROOT")
            public class FunctionalTypes {
                @Test
                public void testAllFilesPresentInFunctionalTypes() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/annotations/functionalTypes"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("nonParenthesizedAnnotationsWithError.kt")
                public void testNonParenthesizedAnnotationsWithError() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/functionalTypes/nonParenthesizedAnnotationsWithError.kt");
                }

                @Test
                @TestMetadata("nonParenthesizedAnnotationsWithoutError.kt")
                public void testNonParenthesizedAnnotationsWithoutError() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/functionalTypes/nonParenthesizedAnnotationsWithoutError.kt");
                }

                @Test
                @TestMetadata("parenthesizedAnnotations.kt")
                public void testParenthesizedAnnotations() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/functionalTypes/parenthesizedAnnotations.kt");
                }

                @Test
                @TestMetadata("propagteAnyAnnotations.kt")
                public void testPropagteAnyAnnotations() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/functionalTypes/propagteAnyAnnotations.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/annotations/options")
            @TestDataPath("$PROJECT_ROOT")
            public class Options {
                @Test
                public void testAllFilesPresentInOptions() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/annotations/options"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("annotationAsArg.kt")
                public void testAnnotationAsArg() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/options/annotationAsArg.kt");
                }

                @Test
                @TestMetadata("annotationAsArgComplex.kt")
                public void testAnnotationAsArgComplex() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/options/annotationAsArgComplex.kt");
                }

                @Test
                @TestMetadata("assignment.kt")
                public void testAssignment() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/options/assignment.kt");
                }

                @Test
                @TestMetadata("documented.kt")
                public void testDocumented() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/options/documented.kt");
                }

                @Test
                @TestMetadata("forParam.kt")
                public void testForParam() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/options/forParam.kt");
                }

                @Test
                @TestMetadata("functionExpression.kt")
                public void testFunctionExpression() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/options/functionExpression.kt");
                }

                @Test
                @TestMetadata("functions.kt")
                public void testFunctions() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/options/functions.kt");
                }

                @Test
                @TestMetadata("javaDocumented.kt")
                public void testJavaDocumented() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/options/javaDocumented.kt");
                }

                @Test
                @TestMetadata("javaKotlinTargetRetention.kt")
                public void testJavaKotlinTargetRetention() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/options/javaKotlinTargetRetention.kt");
                }

                @Test
                @TestMetadata("javaretention.kt")
                public void testJavaretention() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/options/javaretention.kt");
                }

                @Test
                @TestMetadata("multiDeclaration.kt")
                public void testMultiDeclaration() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/options/multiDeclaration.kt");
                }

                @Test
                @TestMetadata("objectLiteral.kt")
                public void testObjectLiteral() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/options/objectLiteral.kt");
                }

                @Test
                @TestMetadata("prefix.kt")
                public void testPrefix() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/options/prefix.kt");
                }

                @Test
                @TestMetadata("retention.kt")
                public void testRetention() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/options/retention.kt");
                }

                @Test
                @TestMetadata("setterParam.kt")
                public void testSetterParam() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/options/setterParam.kt");
                }

                @Test
                @TestMetadata("target.kt")
                public void testTarget() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/options/target.kt");
                }

                @Test
                @TestMetadata("unrepeatable.kt")
                public void testUnrepeatable() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/options/unrepeatable.kt");
                }

                @Nested
                @TestMetadata("compiler/testData/diagnostics/tests/annotations/options/targets")
                @TestDataPath("$PROJECT_ROOT")
                public class Targets {
                    @Test
                    @TestMetadata("accessors.kt")
                    public void testAccessors() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/annotations/options/targets/accessors.kt");
                    }

                    @Test
                    public void testAllFilesPresentInTargets() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/annotations/options/targets"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                    }

                    @Test
                    @TestMetadata("annotation.kt")
                    public void testAnnotation() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/annotations/options/targets/annotation.kt");
                    }

                    @Test
                    @TestMetadata("classifier.kt")
                    public void testClassifier() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/annotations/options/targets/classifier.kt");
                    }

                    @Test
                    @TestMetadata("constructor.kt")
                    public void testConstructor() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/annotations/options/targets/constructor.kt");
                    }

                    @Test
                    @TestMetadata("empty.kt")
                    public void testEmpty() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/annotations/options/targets/empty.kt");
                    }

                    @Test
                    @TestMetadata("expr.kt")
                    public void testExpr() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/annotations/options/targets/expr.kt");
                    }

                    @Test
                    @TestMetadata("field.kt")
                    public void testField() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/annotations/options/targets/field.kt");
                    }

                    @Test
                    @TestMetadata("file.kt")
                    public void testFile() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/annotations/options/targets/file.kt");
                    }

                    @Test
                    @TestMetadata("function.kt")
                    public void testFunction() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/annotations/options/targets/function.kt");
                    }

                    @Test
                    @TestMetadata("funtypeargs.kt")
                    public void testFuntypeargs() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/annotations/options/targets/funtypeargs.kt");
                    }

                    @Test
                    @TestMetadata("incorrect.kt")
                    public void testIncorrect() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/annotations/options/targets/incorrect.kt");
                    }

                    @Test
                    @TestMetadata("init.kt")
                    public void testInit() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/annotations/options/targets/init.kt");
                    }

                    @Test
                    @TestMetadata("java.kt")
                    public void testJava() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/annotations/options/targets/java.kt");
                    }

                    @Test
                    @TestMetadata("local.kt")
                    public void testLocal() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/annotations/options/targets/local.kt");
                    }

                    @Test
                    @TestMetadata("nested.kt")
                    public void testNested() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/annotations/options/targets/nested.kt");
                    }

                    @Test
                    @TestMetadata("property.kt")
                    public void testProperty() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/annotations/options/targets/property.kt");
                    }

                    @Test
                    @TestMetadata("returntype.kt")
                    public void testReturntype() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/annotations/options/targets/returntype.kt");
                    }

                    @Test
                    @TestMetadata("suppress.kt")
                    public void testSuppress() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/annotations/options/targets/suppress.kt");
                    }

                    @Test
                    @TestMetadata("type.kt")
                    public void testType() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/annotations/options/targets/type.kt");
                    }

                    @Test
                    @TestMetadata("typeParams.kt")
                    public void testTypeParams() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/annotations/options/targets/typeParams.kt");
                    }

                    @Test
                    @TestMetadata("typeargs.kt")
                    public void testTypeargs() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/annotations/options/targets/typeargs.kt");
                    }

                    @Test
                    @TestMetadata("valueparam.kt")
                    public void testValueparam() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/annotations/options/targets/valueparam.kt");
                    }
                }
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/annotations/parameters")
            @TestDataPath("$PROJECT_ROOT")
            public class Parameters {
                @Test
                public void testAllFilesPresentInParameters() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/annotations/parameters"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("byte.kt")
                public void testByte() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/parameters/byte.kt");
                }

                @Test
                @TestMetadata("char.kt")
                public void testChar() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/parameters/char.kt");
                }

                @Test
                @TestMetadata("double.kt")
                public void testDouble() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/parameters/double.kt");
                }

                @Test
                @TestMetadata("float.kt")
                public void testFloat() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/parameters/float.kt");
                }

                @Test
                @TestMetadata("int.kt")
                public void testInt() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/parameters/int.kt");
                }

                @Test
                @TestMetadata("long.kt")
                public void testLong() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/parameters/long.kt");
                }

                @Test
                @TestMetadata("short.kt")
                public void testShort() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/parameters/short.kt");
                }

                @Nested
                @TestMetadata("compiler/testData/diagnostics/tests/annotations/parameters/expressions")
                @TestDataPath("$PROJECT_ROOT")
                public class Expressions {
                    @Test
                    public void testAllFilesPresentInExpressions() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/annotations/parameters/expressions"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                    }

                    @Test
                    @TestMetadata("andAnd.kt")
                    public void testAndAnd() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/annotations/parameters/expressions/andAnd.kt");
                    }

                    @Test
                    @TestMetadata("boolean.kt")
                    public void testBoolean() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/annotations/parameters/expressions/boolean.kt");
                    }

                    @Test
                    @TestMetadata("char.kt")
                    public void testChar() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/annotations/parameters/expressions/char.kt");
                    }

                    @Test
                    @TestMetadata("compositeCallBinary.kt")
                    public void testCompositeCallBinary() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/annotations/parameters/expressions/compositeCallBinary.kt");
                    }

                    @Test
                    @TestMetadata("divide.kt")
                    public void testDivide() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/annotations/parameters/expressions/divide.kt");
                    }

                    @Test
                    @TestMetadata("double.kt")
                    public void testDouble() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/annotations/parameters/expressions/double.kt");
                    }

                    @Test
                    @TestMetadata("eqeq.kt")
                    public void testEqeq() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/annotations/parameters/expressions/eqeq.kt");
                    }

                    @Test
                    @TestMetadata("escapedString.kt")
                    public void testEscapedString() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/annotations/parameters/expressions/escapedString.kt");
                    }

                    @Test
                    @TestMetadata("float.kt")
                    public void testFloat() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/annotations/parameters/expressions/float.kt");
                    }

                    @Test
                    @TestMetadata("gt.kt")
                    public void testGt() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/annotations/parameters/expressions/gt.kt");
                    }

                    @Test
                    @TestMetadata("gteq.kt")
                    public void testGteq() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/annotations/parameters/expressions/gteq.kt");
                    }

                    @Test
                    @TestMetadata("intrincics.kt")
                    public void testIntrincics() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/annotations/parameters/expressions/intrincics.kt");
                    }

                    @Test
                    @TestMetadata("labeled.kt")
                    public void testLabeled() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/annotations/parameters/expressions/labeled.kt");
                    }

                    @Test
                    @TestMetadata("long.kt")
                    public void testLong() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/annotations/parameters/expressions/long.kt");
                    }

                    @Test
                    @TestMetadata("lt.kt")
                    public void testLt() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/annotations/parameters/expressions/lt.kt");
                    }

                    @Test
                    @TestMetadata("lteq.kt")
                    public void testLteq() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/annotations/parameters/expressions/lteq.kt");
                    }

                    @Test
                    @TestMetadata("maxValue.kt")
                    public void testMaxValue() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/annotations/parameters/expressions/maxValue.kt");
                    }

                    @Test
                    @TestMetadata("maxValueByte.kt")
                    public void testMaxValueByte() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/annotations/parameters/expressions/maxValueByte.kt");
                    }

                    @Test
                    @TestMetadata("maxValueInt.kt")
                    public void testMaxValueInt() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/annotations/parameters/expressions/maxValueInt.kt");
                    }

                    @Test
                    @TestMetadata("miltiply.kt")
                    public void testMiltiply() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/annotations/parameters/expressions/miltiply.kt");
                    }

                    @Test
                    @TestMetadata("minus.kt")
                    public void testMinus() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/annotations/parameters/expressions/minus.kt");
                    }

                    @Test
                    @TestMetadata("mod.kt")
                    public void testMod() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/annotations/parameters/expressions/mod.kt");
                    }

                    @Test
                    @TestMetadata("multilineString.kt")
                    public void testMultilineString() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/annotations/parameters/expressions/multilineString.kt");
                    }

                    @Test
                    @TestMetadata("not.kt")
                    public void testNot() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/annotations/parameters/expressions/not.kt");
                    }

                    @Test
                    @TestMetadata("noteq.kt")
                    public void testNoteq() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/annotations/parameters/expressions/noteq.kt");
                    }

                    @Test
                    @TestMetadata("orOr.kt")
                    public void testOrOr() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/annotations/parameters/expressions/orOr.kt");
                    }

                    @Test
                    @TestMetadata("paranthesized.kt")
                    public void testParanthesized() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/annotations/parameters/expressions/paranthesized.kt");
                    }

                    @Test
                    @TestMetadata("plus.kt")
                    public void testPlus() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/annotations/parameters/expressions/plus.kt");
                    }

                    @Test
                    @TestMetadata("simpleCallBinary.kt")
                    public void testSimpleCallBinary() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/annotations/parameters/expressions/simpleCallBinary.kt");
                    }

                    @Test
                    @TestMetadata("stringPlusInt.kt")
                    public void testStringPlusInt() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/annotations/parameters/expressions/stringPlusInt.kt");
                    }

                    @Test
                    @TestMetadata("stringTemplate.kt")
                    public void testStringTemplate() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/annotations/parameters/expressions/stringTemplate.kt");
                    }

                    @Test
                    @TestMetadata("strings.kt")
                    public void testStrings() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/annotations/parameters/expressions/strings.kt");
                    }

                    @Test
                    @TestMetadata("unaryMinus.kt")
                    public void testUnaryMinus() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/annotations/parameters/expressions/unaryMinus.kt");
                    }

                    @Test
                    @TestMetadata("unaryPlus.kt")
                    public void testUnaryPlus() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/annotations/parameters/expressions/unaryPlus.kt");
                    }
                }
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/annotations/rendering")
            @TestDataPath("$PROJECT_ROOT")
            public class Rendering {
                @Test
                public void testAllFilesPresentInRendering() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/annotations/rendering"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("cannotOverrideInvisibleMember.kt")
                public void testCannotOverrideInvisibleMember() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/rendering/cannotOverrideInvisibleMember.kt");
                }

                @Test
                @TestMetadata("conflictingOverloads.kt")
                public void testConflictingOverloads() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/rendering/conflictingOverloads.kt");
                }

                @Test
                @TestMetadata("differentNamesForParameter.kt")
                public void testDifferentNamesForParameter() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/rendering/differentNamesForParameter.kt");
                }

                @Test
                @TestMetadata("memberProjectedOut.kt")
                public void testMemberProjectedOut() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/rendering/memberProjectedOut.kt");
                }

                @Test
                @TestMetadata("multipleInheritedDefaults.kt")
                public void testMultipleInheritedDefaults() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/rendering/multipleInheritedDefaults.kt");
                }

                @Test
                @TestMetadata("notImplementedMembers.kt")
                public void testNotImplementedMembers() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/rendering/notImplementedMembers.kt");
                }

                @Test
                @TestMetadata("notImplementedMembersAroundJava.kt")
                public void testNotImplementedMembersAroundJava() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/rendering/notImplementedMembersAroundJava.kt");
                }

                @Test
                @TestMetadata("tooManyArguments.kt")
                public void testTooManyArguments() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/rendering/tooManyArguments.kt");
                }

                @Test
                @TestMetadata("typeMismatchDueToTypeProjections.kt")
                public void testTypeMismatchDueToTypeProjections() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/rendering/typeMismatchDueToTypeProjections.kt");
                }

                @Test
                @TestMetadata("typeMismatchOnOverride.kt")
                public void testTypeMismatchOnOverride() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/rendering/typeMismatchOnOverride.kt");
                }

                @Test
                @TestMetadata("typeMismatchOnOverrideJavaNullable.kt")
                public void testTypeMismatchOnOverrideJavaNullable() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/rendering/typeMismatchOnOverrideJavaNullable.kt");
                }

                @Test
                @TestMetadata("unusedValue.kt")
                public void testUnusedValue() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/rendering/unusedValue.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/annotations/repeatable")
            @TestDataPath("$PROJECT_ROOT")
            public class Repeatable {
                @Test
                public void testAllFilesPresentInRepeatable() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/annotations/repeatable"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("containerAndAnnotationAreBothApplied_1_5.kt")
                public void testContainerAndAnnotationAreBothApplied_1_5() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/repeatable/containerAndAnnotationAreBothApplied_1_5.kt");
                }

                @Test
                @TestMetadata("containerAndAnnotationAreBothApplied_1_6.kt")
                public void testContainerAndAnnotationAreBothApplied_1_6() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/repeatable/containerAndAnnotationAreBothApplied_1_6.kt");
                }

                @Test
                @TestMetadata("containerArguments_1_5.kt")
                public void testContainerArguments_1_5() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/repeatable/containerArguments_1_5.kt");
                }

                @Test
                @TestMetadata("containerArguments_1_6.kt")
                public void testContainerArguments_1_6() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/repeatable/containerArguments_1_6.kt");
                }

                @Test
                @TestMetadata("containerRetention_1_5.kt")
                public void testContainerRetention_1_5() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/repeatable/containerRetention_1_5.kt");
                }

                @Test
                @TestMetadata("containerRetention_1_6.kt")
                public void testContainerRetention_1_6() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/repeatable/containerRetention_1_6.kt");
                }

                @Test
                @TestMetadata("containerTarget_1_6.kt")
                public void testContainerTarget_1_6() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/repeatable/containerTarget_1_6.kt");
                }

                @Test
                @TestMetadata("javaRepeatableJvmTarget6.kt")
                public void testJavaRepeatableJvmTarget6() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/repeatable/javaRepeatableJvmTarget6.kt");
                }

                @Test
                @TestMetadata("javaRepeatable_1_5.kt")
                public void testJavaRepeatable_1_5() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/repeatable/javaRepeatable_1_5.kt");
                }

                @Test
                @TestMetadata("javaRepeatable_1_6.kt")
                public void testJavaRepeatable_1_6() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/repeatable/javaRepeatable_1_6.kt");
                }

                @Test
                @TestMetadata("javaUnrepeatable_1_5.kt")
                public void testJavaUnrepeatable_1_5() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/repeatable/javaUnrepeatable_1_5.kt");
                }

                @Test
                @TestMetadata("javaUnrepeatable_1_6.kt")
                public void testJavaUnrepeatable_1_6() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/repeatable/javaUnrepeatable_1_6.kt");
                }

                @Test
                @TestMetadata("kotlinRepeatable_1_5.kt")
                public void testKotlinRepeatable_1_5() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/repeatable/kotlinRepeatable_1_5.kt");
                }

                @Test
                @TestMetadata("kotlinRepeatable_1_6.kt")
                public void testKotlinRepeatable_1_6() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/repeatable/kotlinRepeatable_1_6.kt");
                }

                @Test
                @TestMetadata("nestedClassContainer_1_5.kt")
                public void testNestedClassContainer_1_5() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/repeatable/nestedClassContainer_1_5.kt");
                }

                @Test
                @TestMetadata("nestedClassContainer_1_6.kt")
                public void testNestedClassContainer_1_6() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/repeatable/nestedClassContainer_1_6.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/annotations/typeUse")
            @TestDataPath("$PROJECT_ROOT")
            public class TypeUse {
                @Test
                public void testAllFilesPresentInTypeUse() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/annotations/typeUse"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("kt19455.kt")
                public void testKt19455() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/typeUse/kt19455.kt");
                }

                @Test
                @TestMetadata("kt25876.kt")
                public void testKt25876() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/typeUse/kt25876.kt");
                }

                @Test
                @TestMetadata("kt45905.kt")
                public void testKt45905() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/typeUse/kt45905.kt");
                }

                @Test
                @TestMetadata("kt46173.kt")
                public void testKt46173() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/typeUse/kt46173.kt");
                }

                @Test
                @TestMetadata("kt47772.kt")
                public void testKt47772() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/typeUse/kt47772.kt");
                }

                @Test
                @TestMetadata("kt8325.kt")
                public void testKt8325() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/typeUse/kt8325.kt");
                }

                @Test
                @TestMetadata("nonTypeUseAnnotationOnType.kt")
                public void testNonTypeUseAnnotationOnType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/typeUse/nonTypeUseAnnotationOnType.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/annotations/withUseSiteTarget")
            @TestDataPath("$PROJECT_ROOT")
            public class WithUseSiteTarget {
                @Test
                public void testAllFilesPresentInWithUseSiteTarget() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/annotations/withUseSiteTarget"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("DelegateAnnotations.kt")
                public void testDelegateAnnotations() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/withUseSiteTarget/DelegateAnnotations.kt");
                }

                @Test
                @TestMetadata("diagnosticFileAnnotationInWrongPlace.kt")
                public void testDiagnosticFileAnnotationInWrongPlace() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/withUseSiteTarget/diagnosticFileAnnotationInWrongPlace.kt");
                }

                @Test
                @TestMetadata("diagnosticWithoutPackage.kt")
                public void testDiagnosticWithoutPackage() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/withUseSiteTarget/diagnosticWithoutPackage.kt");
                }

                @Test
                @TestMetadata("diagnosticWithoutPackageWithSimpleAnnotation.kt")
                public void testDiagnosticWithoutPackageWithSimpleAnnotation() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/withUseSiteTarget/diagnosticWithoutPackageWithSimpleAnnotation.kt");
                }

                @Test
                @TestMetadata("FieldAnnotations.kt")
                public void testFieldAnnotations() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/withUseSiteTarget/FieldAnnotations.kt");
                }

                @Test
                @TestMetadata("fileAnnotationWithoutColon_after.kt")
                public void testFileAnnotationWithoutColon_after() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/withUseSiteTarget/fileAnnotationWithoutColon_after.kt");
                }

                @Test
                @TestMetadata("fileAnnotationWithoutColon_before.kt")
                public void testFileAnnotationWithoutColon_before() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/withUseSiteTarget/fileAnnotationWithoutColon_before.kt");
                }

                @Test
                @TestMetadata("FileAnnotations.kt")
                public void testFileAnnotations() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/withUseSiteTarget/FileAnnotations.kt");
                }

                @Test
                @TestMetadata("GetterAnnotations.kt")
                public void testGetterAnnotations() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/withUseSiteTarget/GetterAnnotations.kt");
                }

                @Test
                @TestMetadata("kt23992.kt")
                public void testKt23992() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/withUseSiteTarget/kt23992.kt");
                }

                @Test
                @TestMetadata("kt23992_after.kt")
                public void testKt23992_after() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/withUseSiteTarget/kt23992_after.kt");
                }

                @Test
                @TestMetadata("kt26638.kt")
                public void testKt26638() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/withUseSiteTarget/kt26638.kt");
                }

                @Test
                @TestMetadata("kt26638_after.kt")
                public void testKt26638_after() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/withUseSiteTarget/kt26638_after.kt");
                }

                @Test
                @TestMetadata("ParamAnnotations.kt")
                public void testParamAnnotations() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/withUseSiteTarget/ParamAnnotations.kt");
                }

                @Test
                @TestMetadata("PropertyAnnotations.kt")
                public void testPropertyAnnotations() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/withUseSiteTarget/PropertyAnnotations.kt");
                }

                @Test
                @TestMetadata("ReceiverAnnotations.kt")
                public void testReceiverAnnotations() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/withUseSiteTarget/ReceiverAnnotations.kt");
                }

                @Test
                @TestMetadata("receiverUseSiteTargetOnExtensionFunction_after.kt")
                public void testReceiverUseSiteTargetOnExtensionFunction_after() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/withUseSiteTarget/receiverUseSiteTargetOnExtensionFunction_after.kt");
                }

                @Test
                @TestMetadata("receiverUseSiteTargetOnExtensionFunction_before.kt")
                public void testReceiverUseSiteTargetOnExtensionFunction_before() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/withUseSiteTarget/receiverUseSiteTargetOnExtensionFunction_before.kt");
                }

                @Test
                @TestMetadata("repeatable.kt")
                public void testRepeatable() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/withUseSiteTarget/repeatable.kt");
                }

                @Test
                @TestMetadata("SetterAnnotations.kt")
                public void testSetterAnnotations() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/withUseSiteTarget/SetterAnnotations.kt");
                }

                @Test
                @TestMetadata("SparamAnnotations.kt")
                public void testSparamAnnotations() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/withUseSiteTarget/SparamAnnotations.kt");
                }

                @Test
                @TestMetadata("wrongParamAnnotationsOnTypesError.kt")
                public void testWrongParamAnnotationsOnTypesError() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/withUseSiteTarget/wrongParamAnnotationsOnTypesError.kt");
                }

                @Test
                @TestMetadata("wrongParamAnnotationsOnTypes_after.kt")
                public void testWrongParamAnnotationsOnTypes_after() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/withUseSiteTarget/wrongParamAnnotationsOnTypes_after.kt");
                }

                @Test
                @TestMetadata("wrongParamAnnotationsOnTypes_before.kt")
                public void testWrongParamAnnotationsOnTypes_before() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/annotations/withUseSiteTarget/wrongParamAnnotationsOnTypes_before.kt");
                }
            }
        }

        @Nested
        @TestMetadata("compiler/testData/diagnostics/tests/backingField")
        @TestDataPath("$PROJECT_ROOT")
        public class BackingField {
            @Test
            public void testAllFilesPresentInBackingField() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/backingField"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
            }

            @Test
            @TestMetadata("CustomGetSet.kt")
            public void testCustomGetSet() throws Exception {
                runTest("compiler/testData/diagnostics/tests/backingField/CustomGetSet.kt");
            }

            @Test
            @TestMetadata("CustomGetVal.kt")
            public void testCustomGetVal() throws Exception {
                runTest("compiler/testData/diagnostics/tests/backingField/CustomGetVal.kt");
            }

            @Test
            @TestMetadata("CustomGetValGlobal.kt")
            public void testCustomGetValGlobal() throws Exception {
                runTest("compiler/testData/diagnostics/tests/backingField/CustomGetValGlobal.kt");
            }

            @Test
            @TestMetadata("CustomGetVar.kt")
            public void testCustomGetVar() throws Exception {
                runTest("compiler/testData/diagnostics/tests/backingField/CustomGetVar.kt");
            }

            @Test
            @TestMetadata("CustomSet.kt")
            public void testCustomSet() throws Exception {
                runTest("compiler/testData/diagnostics/tests/backingField/CustomSet.kt");
            }

            @Test
            @TestMetadata("ExtensionProperty.kt")
            public void testExtensionProperty() throws Exception {
                runTest("compiler/testData/diagnostics/tests/backingField/ExtensionProperty.kt");
            }

            @Test
            @TestMetadata("FieldAsParam.kt")
            public void testFieldAsParam() throws Exception {
                runTest("compiler/testData/diagnostics/tests/backingField/FieldAsParam.kt");
            }

            @Test
            @TestMetadata("FieldAsProperty.kt")
            public void testFieldAsProperty() throws Exception {
                runTest("compiler/testData/diagnostics/tests/backingField/FieldAsProperty.kt");
            }

            @Test
            @TestMetadata("FieldDerived.kt")
            public void testFieldDerived() throws Exception {
                runTest("compiler/testData/diagnostics/tests/backingField/FieldDerived.kt");
            }

            @Test
            @TestMetadata("FieldInInterface.kt")
            public void testFieldInInterface() throws Exception {
                runTest("compiler/testData/diagnostics/tests/backingField/FieldInInterface.kt");
            }

            @Test
            @TestMetadata("FieldInLocal.kt")
            public void testFieldInLocal() throws Exception {
                runTest("compiler/testData/diagnostics/tests/backingField/FieldInLocal.kt");
            }

            @Test
            @TestMetadata("FieldOnVal.kt")
            public void testFieldOnVal() throws Exception {
                runTest("compiler/testData/diagnostics/tests/backingField/FieldOnVal.kt");
            }

            @Test
            @TestMetadata("FieldOnVar.kt")
            public void testFieldOnVar() throws Exception {
                runTest("compiler/testData/diagnostics/tests/backingField/FieldOnVar.kt");
            }

            @Test
            @TestMetadata("FieldReassignment_after.kt")
            public void testFieldReassignment_after() throws Exception {
                runTest("compiler/testData/diagnostics/tests/backingField/FieldReassignment_after.kt");
            }

            @Test
            @TestMetadata("FieldReassignment_before.kt")
            public void testFieldReassignment_before() throws Exception {
                runTest("compiler/testData/diagnostics/tests/backingField/FieldReassignment_before.kt");
            }

            @Test
            @TestMetadata("FieldShadow.kt")
            public void testFieldShadow() throws Exception {
                runTest("compiler/testData/diagnostics/tests/backingField/FieldShadow.kt");
            }

            @Test
            @TestMetadata("InitCustomSetter.kt")
            public void testInitCustomSetter() throws Exception {
                runTest("compiler/testData/diagnostics/tests/backingField/InitCustomSetter.kt");
            }

            @Test
            @TestMetadata("InitOpenSetter.kt")
            public void testInitOpenSetter() throws Exception {
                runTest("compiler/testData/diagnostics/tests/backingField/InitOpenSetter.kt");
            }

            @Test
            @TestMetadata("kt782packageLevel.kt")
            public void testKt782packageLevel() throws Exception {
                runTest("compiler/testData/diagnostics/tests/backingField/kt782packageLevel.kt");
            }

            @Test
            @TestMetadata("LocalDeclarations.kt")
            public void testLocalDeclarations() throws Exception {
                runTest("compiler/testData/diagnostics/tests/backingField/LocalDeclarations.kt");
            }

            @Test
            @TestMetadata("SetterWithExplicitType.kt")
            public void testSetterWithExplicitType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/backingField/SetterWithExplicitType.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/diagnostics/tests/callableReference")
        @TestDataPath("$PROJECT_ROOT")
        public class CallableReference {
            @Test
            public void testAllFilesPresentInCallableReference() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/callableReference"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
            }

            @Test
            @TestMetadata("bareType.kt")
            public void testBareType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/callableReference/bareType.kt");
            }

            @Test
            @TestMetadata("callableReferenceAsLastExpressionInBlock.kt")
            public void testCallableReferenceAsLastExpressionInBlock() throws Exception {
                runTest("compiler/testData/diagnostics/tests/callableReference/callableReferenceAsLastExpressionInBlock.kt");
            }

            @Test
            @TestMetadata("callableReferenceAssignmentToVar.kt")
            public void testCallableReferenceAssignmentToVar() throws Exception {
                runTest("compiler/testData/diagnostics/tests/callableReference/callableReferenceAssignmentToVar.kt");
            }

            @Test
            @TestMetadata("callableReferenceInWhenExpression.kt")
            public void testCallableReferenceInWhenExpression() throws Exception {
                runTest("compiler/testData/diagnostics/tests/callableReference/callableReferenceInWhenExpression.kt");
            }

            @Test
            @TestMetadata("callableReferenceWithMostSpecificGenericTypeParameter.kt")
            public void testCallableReferenceWithMostSpecificGenericTypeParameter() throws Exception {
                runTest("compiler/testData/diagnostics/tests/callableReference/callableReferenceWithMostSpecificGenericTypeParameter.kt");
            }

            @Test
            @TestMetadata("classVsPackage.kt")
            public void testClassVsPackage() throws Exception {
                runTest("compiler/testData/diagnostics/tests/callableReference/classVsPackage.kt");
            }

            @Test
            @TestMetadata("compatibilityResolveWithVarargAndOperatorCall.kt")
            public void testCompatibilityResolveWithVarargAndOperatorCall() throws Exception {
                runTest("compiler/testData/diagnostics/tests/callableReference/compatibilityResolveWithVarargAndOperatorCall.kt");
            }

            @Test
            @TestMetadata("constraintFromLHSWithCorrectDirection.kt")
            public void testConstraintFromLHSWithCorrectDirection() throws Exception {
                runTest("compiler/testData/diagnostics/tests/callableReference/constraintFromLHSWithCorrectDirection.kt");
            }

            @Test
            @TestMetadata("constraintFromLHSWithCorrectDirectionError.kt")
            public void testConstraintFromLHSWithCorrectDirectionError() throws Exception {
                runTest("compiler/testData/diagnostics/tests/callableReference/constraintFromLHSWithCorrectDirectionError.kt");
            }

            @Test
            @TestMetadata("correctCandidateWithCompatibilityForSeveralCandidates.kt")
            public void testCorrectCandidateWithCompatibilityForSeveralCandidates() throws Exception {
                runTest("compiler/testData/diagnostics/tests/callableReference/correctCandidateWithCompatibilityForSeveralCandidates.kt");
            }

            @Test
            @TestMetadata("correctInfoAfterArrayLikeCall.kt")
            public void testCorrectInfoAfterArrayLikeCall() throws Exception {
                runTest("compiler/testData/diagnostics/tests/callableReference/correctInfoAfterArrayLikeCall.kt");
            }

            @Test
            @TestMetadata("deprecatedCompanionReceiverInParentheses.kt")
            public void testDeprecatedCompanionReceiverInParentheses() throws Exception {
                runTest("compiler/testData/diagnostics/tests/callableReference/deprecatedCompanionReceiverInParentheses.kt");
            }

            @Test
            @TestMetadata("ea81649_errorPropertyLHS.kt")
            public void testEa81649_errorPropertyLHS() throws Exception {
                runTest("compiler/testData/diagnostics/tests/callableReference/ea81649_errorPropertyLHS.kt");
            }

            @Test
            @TestMetadata("emptyLhs.kt")
            public void testEmptyLhs() throws Exception {
                runTest("compiler/testData/diagnostics/tests/callableReference/emptyLhs.kt");
            }

            @Test
            @TestMetadata("expectedTypeAsSubtypeOfFunctionType.kt")
            public void testExpectedTypeAsSubtypeOfFunctionType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/callableReference/expectedTypeAsSubtypeOfFunctionType.kt");
            }

            @Test
            @TestMetadata("functionReferenceWithDefaultValueAsOtherFunctionType.kt")
            public void testFunctionReferenceWithDefaultValueAsOtherFunctionType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/callableReference/functionReferenceWithDefaultValueAsOtherFunctionType.kt");
            }

            @Test
            @TestMetadata("functionReferenceWithDefaultValueAsOtherFunctionType_enabled.kt")
            public void testFunctionReferenceWithDefaultValueAsOtherFunctionType_enabled() throws Exception {
                runTest("compiler/testData/diagnostics/tests/callableReference/functionReferenceWithDefaultValueAsOtherFunctionType_enabled.kt");
            }

            @Test
            @TestMetadata("genericCallWithReferenceAgainstVararg.kt")
            public void testGenericCallWithReferenceAgainstVararg() throws Exception {
                runTest("compiler/testData/diagnostics/tests/callableReference/genericCallWithReferenceAgainstVararg.kt");
            }

            @Test
            @TestMetadata("genericCallWithReferenceAgainstVarargAndKFunction.kt")
            public void testGenericCallWithReferenceAgainstVarargAndKFunction() throws Exception {
                runTest("compiler/testData/diagnostics/tests/callableReference/genericCallWithReferenceAgainstVarargAndKFunction.kt");
            }

            @Test
            @TestMetadata("kt15439_completeCall.kt")
            public void testKt15439_completeCall() throws Exception {
                runTest("compiler/testData/diagnostics/tests/callableReference/kt15439_completeCall.kt");
            }

            @Test
            @TestMetadata("kt25433.kt")
            public void testKt25433() throws Exception {
                runTest("compiler/testData/diagnostics/tests/callableReference/kt25433.kt");
            }

            @Test
            @TestMetadata("kt31981.kt")
            public void testKt31981() throws Exception {
                runTest("compiler/testData/diagnostics/tests/callableReference/kt31981.kt");
            }

            @Test
            @TestMetadata("kt32256.kt")
            public void testKt32256() throws Exception {
                runTest("compiler/testData/diagnostics/tests/callableReference/kt32256.kt");
            }

            @Test
            @TestMetadata("kt32267.kt")
            public void testKt32267() throws Exception {
                runTest("compiler/testData/diagnostics/tests/callableReference/kt32267.kt");
            }

            @Test
            @TestMetadata("kt34314.kt")
            public void testKt34314() throws Exception {
                runTest("compiler/testData/diagnostics/tests/callableReference/kt34314.kt");
            }

            @Test
            @TestMetadata("kt34314_lambda.kt")
            public void testKt34314_lambda() throws Exception {
                runTest("compiler/testData/diagnostics/tests/callableReference/kt34314_lambda.kt");
            }

            @Test
            @TestMetadata("kt35105.kt")
            public void testKt35105() throws Exception {
                runTest("compiler/testData/diagnostics/tests/callableReference/kt35105.kt");
            }

            @Test
            @TestMetadata("kt35959.kt")
            public void testKt35959() throws Exception {
                runTest("compiler/testData/diagnostics/tests/callableReference/kt35959.kt");
            }

            @Test
            @TestMetadata("kt37530.kt")
            public void testKt37530() throws Exception {
                runTest("compiler/testData/diagnostics/tests/callableReference/kt37530.kt");
            }

            @Test
            @TestMetadata("kt46437.kt")
            public void testKt46437() throws Exception {
                runTest("compiler/testData/diagnostics/tests/callableReference/kt46437.kt");
            }

            @Test
            @TestMetadata("kt49038.kt")
            public void testKt49038() throws Exception {
                runTest("compiler/testData/diagnostics/tests/callableReference/kt49038.kt");
            }

            @Test
            @TestMetadata("kt7430_wrongClassOnLHS.kt")
            public void testKt7430_wrongClassOnLHS() throws Exception {
                runTest("compiler/testData/diagnostics/tests/callableReference/kt7430_wrongClassOnLHS.kt");
            }

            @Test
            @TestMetadata("lambdaResult.kt")
            public void testLambdaResult() throws Exception {
                runTest("compiler/testData/diagnostics/tests/callableReference/lambdaResult.kt");
            }

            @Test
            @TestMetadata("memberExtensionsImportedFromObjectsUnsupported.kt")
            public void testMemberExtensionsImportedFromObjectsUnsupported() throws Exception {
                runTest("compiler/testData/diagnostics/tests/callableReference/memberExtensionsImportedFromObjectsUnsupported.kt");
            }

            @Test
            @TestMetadata("noAmbiguityWhenAllReferencesAreInapplicable.kt")
            public void testNoAmbiguityWhenAllReferencesAreInapplicable() throws Exception {
                runTest("compiler/testData/diagnostics/tests/callableReference/noAmbiguityWhenAllReferencesAreInapplicable.kt");
            }

            @Test
            @TestMetadata("noCompatibilityResolveWithProressiveModeForNI.kt")
            public void testNoCompatibilityResolveWithProressiveModeForNI() throws Exception {
                runTest("compiler/testData/diagnostics/tests/callableReference/noCompatibilityResolveWithProressiveModeForNI.kt");
            }

            @Test
            @TestMetadata("noExceptionOnRedCodeWithArrayLikeCall.kt")
            public void testNoExceptionOnRedCodeWithArrayLikeCall() throws Exception {
                runTest("compiler/testData/diagnostics/tests/callableReference/noExceptionOnRedCodeWithArrayLikeCall.kt");
            }

            @Test
            @TestMetadata("overloadResolutionWithDefaults.kt")
            public void testOverloadResolutionWithDefaults() throws Exception {
                runTest("compiler/testData/diagnostics/tests/callableReference/overloadResolutionWithDefaults.kt");
            }

            @Test
            @TestMetadata("packageInLhs.kt")
            public void testPackageInLhs() throws Exception {
                runTest("compiler/testData/diagnostics/tests/callableReference/packageInLhs.kt");
            }

            @Test
            @TestMetadata("parsingPriorityOfGenericArgumentsVsLess.kt")
            public void testParsingPriorityOfGenericArgumentsVsLess() throws Exception {
                runTest("compiler/testData/diagnostics/tests/callableReference/parsingPriorityOfGenericArgumentsVsLess.kt");
            }

            @Test
            @TestMetadata("propertyOfNestedGenericClass.kt")
            public void testPropertyOfNestedGenericClass() throws Exception {
                runTest("compiler/testData/diagnostics/tests/callableReference/propertyOfNestedGenericClass.kt");
            }

            @Test
            @TestMetadata("referenceAdaptationCompatibility.kt")
            public void testReferenceAdaptationCompatibility() throws Exception {
                runTest("compiler/testData/diagnostics/tests/callableReference/referenceAdaptationCompatibility.kt");
            }

            @Test
            @TestMetadata("referenceToCompanionObjectMemberViaClassName.kt")
            public void testReferenceToCompanionObjectMemberViaClassName() throws Exception {
                runTest("compiler/testData/diagnostics/tests/callableReference/referenceToCompanionObjectMemberViaClassName.kt");
            }

            @Test
            @TestMetadata("referenceToCompanionObjectMemberViaClassNameCompatibility.kt")
            public void testReferenceToCompanionObjectMemberViaClassNameCompatibility() throws Exception {
                runTest("compiler/testData/diagnostics/tests/callableReference/referenceToCompanionObjectMemberViaClassNameCompatibility.kt");
            }

            @Test
            @TestMetadata("rewriteAtSliceOnGetOperator.kt")
            public void testRewriteAtSliceOnGetOperator() throws Exception {
                runTest("compiler/testData/diagnostics/tests/callableReference/rewriteAtSliceOnGetOperator.kt");
            }

            @Test
            @TestMetadata("sam.kt")
            public void testSam() throws Exception {
                runTest("compiler/testData/diagnostics/tests/callableReference/sam.kt");
            }

            @Test
            @TestMetadata("subtypeArgumentFromRHSForReference.kt")
            public void testSubtypeArgumentFromRHSForReference() throws Exception {
                runTest("compiler/testData/diagnostics/tests/callableReference/subtypeArgumentFromRHSForReference.kt");
            }

            @Test
            @TestMetadata("suspendCallableReference.kt")
            public void testSuspendCallableReference() throws Exception {
                runTest("compiler/testData/diagnostics/tests/callableReference/suspendCallableReference.kt");
            }

            @Test
            @TestMetadata("typealiases.kt")
            public void testTypealiases() throws Exception {
                runTest("compiler/testData/diagnostics/tests/callableReference/typealiases.kt");
            }

            @Test
            @TestMetadata("unitAdaptationForReferenceCompatibility.kt")
            public void testUnitAdaptationForReferenceCompatibility() throws Exception {
                runTest("compiler/testData/diagnostics/tests/callableReference/unitAdaptationForReferenceCompatibility.kt");
            }

            @Test
            @TestMetadata("unused.kt")
            public void testUnused() throws Exception {
                runTest("compiler/testData/diagnostics/tests/callableReference/unused.kt");
            }

            @Test
            @TestMetadata("whitespacesInExpression.kt")
            public void testWhitespacesInExpression() throws Exception {
                runTest("compiler/testData/diagnostics/tests/callableReference/whitespacesInExpression.kt");
            }

            @Test
            @TestMetadata("withQuestionMarks.kt")
            public void testWithQuestionMarks() throws Exception {
                runTest("compiler/testData/diagnostics/tests/callableReference/withQuestionMarks.kt");
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/callableReference/bound")
            @TestDataPath("$PROJECT_ROOT")
            public class Bound {
                @Test
                public void testAllFilesPresentInBound() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/callableReference/bound"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("classVsStarImportedCompanion.kt")
                public void testClassVsStarImportedCompanion() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/bound/classVsStarImportedCompanion.kt");
                }

                @Test
                @TestMetadata("classVsStarImportedObject.kt")
                public void testClassVsStarImportedObject() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/bound/classVsStarImportedObject.kt");
                }

                @Test
                @TestMetadata("companionObject.kt")
                public void testCompanionObject() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/bound/companionObject.kt");
                }

                @Test
                @TestMetadata("controlFlow.kt")
                public void testControlFlow() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/bound/controlFlow.kt");
                }

                @Test
                @TestMetadata("dataFlow.kt")
                public void testDataFlow() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/bound/dataFlow.kt");
                }

                @Test
                @TestMetadata("expectedType.kt")
                public void testExpectedType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/bound/expectedType.kt");
                }

                @Test
                @TestMetadata("expressionWithNullableType.kt")
                public void testExpressionWithNullableType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/bound/expressionWithNullableType.kt");
                }

                @Test
                @TestMetadata("functionCallWithoutArguments.kt")
                public void testFunctionCallWithoutArguments() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/bound/functionCallWithoutArguments.kt");
                }

                @Test
                @TestMetadata("innerNested.kt")
                public void testInnerNested() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/bound/innerNested.kt");
                }

                @Test
                @TestMetadata("kt12843.kt")
                public void testKt12843() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/bound/kt12843.kt");
                }

                @Test
                @TestMetadata("noThisInSuperCall.kt")
                public void testNoThisInSuperCall() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/bound/noThisInSuperCall.kt");
                }

                @Test
                @TestMetadata("object.kt")
                public void testObject() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/bound/object.kt");
                }

                @Test
                @TestMetadata("privateToThis.kt")
                public void testPrivateToThis() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/bound/privateToThis.kt");
                }

                @Test
                @TestMetadata("referenceToStaticMethodOnInstance.kt")
                public void testReferenceToStaticMethodOnInstance() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/bound/referenceToStaticMethodOnInstance.kt");
                }

                @Test
                @TestMetadata("reservedExpressionSyntax.kt")
                public void testReservedExpressionSyntax() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/bound/reservedExpressionSyntax.kt");
                }

                @Test
                @TestMetadata("reservedExpressionSyntax2.kt")
                public void testReservedExpressionSyntax2() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/bound/reservedExpressionSyntax2.kt");
                }

                @Test
                @TestMetadata("reservedExpressionSyntax3.kt")
                public void testReservedExpressionSyntax3() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/bound/reservedExpressionSyntax3.kt");
                }

                @Test
                @TestMetadata("syntheticExtensionOnLHS.kt")
                public void testSyntheticExtensionOnLHS() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/bound/syntheticExtensionOnLHS.kt");
                }

                @Test
                @TestMetadata("valueOfTypeParameterType.kt")
                public void testValueOfTypeParameterType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/bound/valueOfTypeParameterType.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/callableReference/function")
            @TestDataPath("$PROJECT_ROOT")
            public class Function {
                @Test
                @TestMetadata("abstractClassConstructors.kt")
                public void testAbstractClassConstructors() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/function/abstractClassConstructors.kt");
                }

                @Test
                public void testAllFilesPresentInFunction() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/callableReference/function"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("ambiguityTopLevelVsTopLevel.kt")
                public void testAmbiguityTopLevelVsTopLevel() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/function/ambiguityTopLevelVsTopLevel.kt");
                }

                @Test
                @TestMetadata("annotationClassConstructor.kt")
                public void testAnnotationClassConstructor() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/function/annotationClassConstructor.kt");
                }

                @Test
                @TestMetadata("callableRefrenceOnNestedObject.kt")
                public void testCallableRefrenceOnNestedObject() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/function/callableRefrenceOnNestedObject.kt");
                }

                @Test
                @TestMetadata("classMemberVsConstructorLikeFunction.kt")
                public void testClassMemberVsConstructorLikeFunction() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/function/classMemberVsConstructorLikeFunction.kt");
                }

                @Test
                @TestMetadata("constructorFromClass.kt")
                public void testConstructorFromClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/function/constructorFromClass.kt");
                }

                @Test
                @TestMetadata("constructorFromCompanion.kt")
                public void testConstructorFromCompanion() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/function/constructorFromCompanion.kt");
                }

                @Test
                @TestMetadata("constructorFromExtension.kt")
                public void testConstructorFromExtension() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/function/constructorFromExtension.kt");
                }

                @Test
                @TestMetadata("constructorFromExtensionInClass.kt")
                public void testConstructorFromExtensionInClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/function/constructorFromExtensionInClass.kt");
                }

                @Test
                @TestMetadata("constructorFromTopLevel.kt")
                public void testConstructorFromTopLevel() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/function/constructorFromTopLevel.kt");
                }

                @Test
                @TestMetadata("constructorOfNestedClassInObject.kt")
                public void testConstructorOfNestedClassInObject() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/function/constructorOfNestedClassInObject.kt");
                }

                @Test
                @TestMetadata("differentPackageClass.kt")
                public void testDifferentPackageClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/function/differentPackageClass.kt");
                }

                @Test
                @TestMetadata("differentPackageExtension.kt")
                public void testDifferentPackageExtension() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/function/differentPackageExtension.kt");
                }

                @Test
                @TestMetadata("differentPackageTopLevel.kt")
                public void testDifferentPackageTopLevel() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/function/differentPackageTopLevel.kt");
                }

                @Test
                @TestMetadata("empty.kt")
                public void testEmpty() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/function/empty.kt");
                }

                @Test
                @TestMetadata("extensionFromTopLevel.kt")
                public void testExtensionFromTopLevel() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/function/extensionFromTopLevel.kt");
                }

                @Test
                @TestMetadata("extensionInClassDisallowed.kt")
                public void testExtensionInClassDisallowed() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/function/extensionInClassDisallowed.kt");
                }

                @Test
                @TestMetadata("extensionOnNullable.kt")
                public void testExtensionOnNullable() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/function/extensionOnNullable.kt");
                }

                @Test
                @TestMetadata("extensionToSupertype.kt")
                public void testExtensionToSupertype() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/function/extensionToSupertype.kt");
                }

                @Test
                @TestMetadata("fakeOverrideType.kt")
                public void testFakeOverrideType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/function/fakeOverrideType.kt");
                }

                @Test
                @TestMetadata("genericClassFromTopLevel.kt")
                public void testGenericClassFromTopLevel() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/function/genericClassFromTopLevel.kt");
                }

                @Test
                @TestMetadata("importedInnerConstructor.kt")
                public void testImportedInnerConstructor() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/function/importedInnerConstructor.kt");
                }

                @Test
                @TestMetadata("innerConstructorFromClass.kt")
                public void testInnerConstructorFromClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/function/innerConstructorFromClass.kt");
                }

                @Test
                @TestMetadata("innerConstructorFromExtension.kt")
                public void testInnerConstructorFromExtension() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/function/innerConstructorFromExtension.kt");
                }

                @Test
                @TestMetadata("innerConstructorFromTopLevel.kt")
                public void testInnerConstructorFromTopLevel() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/function/innerConstructorFromTopLevel.kt");
                }

                @Test
                @TestMetadata("javaStaticMethod.kt")
                public void testJavaStaticMethod() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/function/javaStaticMethod.kt");
                }

                @Test
                @TestMetadata("lhsNotAClass.kt")
                public void testLhsNotAClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/function/lhsNotAClass.kt");
                }

                @Test
                @TestMetadata("localConstructor.kt")
                public void testLocalConstructor() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/function/localConstructor.kt");
                }

                @Test
                @TestMetadata("localConstructorFromExtensionInLocalClass.kt")
                public void testLocalConstructorFromExtensionInLocalClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/function/localConstructorFromExtensionInLocalClass.kt");
                }

                @Test
                @TestMetadata("localConstructorFromLocalClass.kt")
                public void testLocalConstructorFromLocalClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/function/localConstructorFromLocalClass.kt");
                }

                @Test
                @TestMetadata("localConstructorFromLocalExtension.kt")
                public void testLocalConstructorFromLocalExtension() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/function/localConstructorFromLocalExtension.kt");
                }

                @Test
                @TestMetadata("localNamedFun.kt")
                public void testLocalNamedFun() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/function/localNamedFun.kt");
                }

                @Test
                @TestMetadata("localNamedFunFromExtensionInLocalClass.kt")
                public void testLocalNamedFunFromExtensionInLocalClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/function/localNamedFunFromExtensionInLocalClass.kt");
                }

                @Test
                @TestMetadata("localNamedFunFromLocalClass.kt")
                public void testLocalNamedFunFromLocalClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/function/localNamedFunFromLocalClass.kt");
                }

                @Test
                @TestMetadata("localNamedFunFromLocalExtension.kt")
                public void testLocalNamedFunFromLocalExtension() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/function/localNamedFunFromLocalExtension.kt");
                }

                @Test
                @TestMetadata("longQualifiedName.kt")
                public void testLongQualifiedName() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/function/longQualifiedName.kt");
                }

                @Test
                @TestMetadata("longQualifiedNameGeneric.kt")
                public void testLongQualifiedNameGeneric() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/function/longQualifiedNameGeneric.kt");
                }

                @Test
                @TestMetadata("memberFromTopLevel.kt")
                public void testMemberFromTopLevel() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/function/memberFromTopLevel.kt");
                }

                @Test
                @TestMetadata("nestedConstructorFromClass.kt")
                public void testNestedConstructorFromClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/function/nestedConstructorFromClass.kt");
                }

                @Test
                @TestMetadata("nestedConstructorFromExtension.kt")
                public void testNestedConstructorFromExtension() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/function/nestedConstructorFromExtension.kt");
                }

                @Test
                @TestMetadata("nestedConstructorFromTopLevel.kt")
                public void testNestedConstructorFromTopLevel() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/function/nestedConstructorFromTopLevel.kt");
                }

                @Test
                @TestMetadata("noAmbiguityLocalVsTopLevel.kt")
                public void testNoAmbiguityLocalVsTopLevel() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/function/noAmbiguityLocalVsTopLevel.kt");
                }

                @Test
                @TestMetadata("noAmbiguityMemberVsExtension.kt")
                public void testNoAmbiguityMemberVsExtension() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/function/noAmbiguityMemberVsExtension.kt");
                }

                @Test
                @TestMetadata("noAmbiguityMemberVsTopLevel.kt")
                public void testNoAmbiguityMemberVsTopLevel() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/function/noAmbiguityMemberVsTopLevel.kt");
                }

                @Test
                @TestMetadata("privateStaticAndPublicMember.kt")
                public void testPrivateStaticAndPublicMember() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/function/privateStaticAndPublicMember.kt");
                }

                @Test
                @TestMetadata("renameOnImport.kt")
                public void testRenameOnImport() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/function/renameOnImport.kt");
                }

                @Test
                @TestMetadata("topLevelFromClass.kt")
                public void testTopLevelFromClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/function/topLevelFromClass.kt");
                }

                @Test
                @TestMetadata("topLevelFromExtension.kt")
                public void testTopLevelFromExtension() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/function/topLevelFromExtension.kt");
                }

                @Test
                @TestMetadata("topLevelFromExtensionInClass.kt")
                public void testTopLevelFromExtensionInClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/function/topLevelFromExtensionInClass.kt");
                }

                @Test
                @TestMetadata("topLevelFromTopLevel.kt")
                public void testTopLevelFromTopLevel() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/function/topLevelFromTopLevel.kt");
                }

                @Test
                @TestMetadata("unresolved.kt")
                public void testUnresolved() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/function/unresolved.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/callableReference/generic")
            @TestDataPath("$PROJECT_ROOT")
            public class Generic {
                @Test
                public void testAllFilesPresentInGeneric() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/callableReference/generic"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("argumentAndReturnExpectedType.kt")
                public void testArgumentAndReturnExpectedType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/generic/argumentAndReturnExpectedType.kt");
                }

                @Test
                @TestMetadata("argumentExpectedType.kt")
                public void testArgumentExpectedType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/generic/argumentExpectedType.kt");
                }

                @Test
                @TestMetadata("dependOnArgumentType.kt")
                public void testDependOnArgumentType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/generic/dependOnArgumentType.kt");
                }

                @Test
                @TestMetadata("expectedFunctionType.kt")
                public void testExpectedFunctionType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/generic/expectedFunctionType.kt");
                }

                @Test
                @TestMetadata("explicitTypeArguments.kt")
                public void testExplicitTypeArguments() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/generic/explicitTypeArguments.kt");
                }

                @Test
                @TestMetadata("genericExtensionFunction.kt")
                public void testGenericExtensionFunction() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/generic/genericExtensionFunction.kt");
                }

                @Test
                @TestMetadata("genericFunctionsWithNullableTypes.kt")
                public void testGenericFunctionsWithNullableTypes() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/generic/genericFunctionsWithNullableTypes.kt");
                }

                @Test
                @TestMetadata("kt10968.kt")
                public void testKt10968() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/generic/kt10968.kt");
                }

                @Test
                @TestMetadata("kt11075.kt")
                public void testKt11075() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/generic/kt11075.kt");
                }

                @Test
                @TestMetadata("kt12286.kt")
                public void testKt12286() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/generic/kt12286.kt");
                }

                @Test
                @TestMetadata("kt35896.kt")
                public void testKt35896() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/generic/kt35896.kt");
                }

                @Test
                @TestMetadata("kt7470.kt")
                public void testKt7470() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/generic/kt7470.kt");
                }

                @Test
                @TestMetadata("nestedCallWithOverload.kt")
                public void testNestedCallWithOverload() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/generic/nestedCallWithOverload.kt");
                }

                @Test
                @TestMetadata("resolutionGenericCallableWithNullableTypes.kt")
                public void testResolutionGenericCallableWithNullableTypes() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/generic/resolutionGenericCallableWithNullableTypes.kt");
                }

                @Test
                @TestMetadata("resolutionWithGenericCallable.kt")
                public void testResolutionWithGenericCallable() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/generic/resolutionWithGenericCallable.kt");
                }

                @Test
                @TestMetadata("specialCalls.kt")
                public void testSpecialCalls() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/generic/specialCalls.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/callableReference/property")
            @TestDataPath("$PROJECT_ROOT")
            public class Property {
                @Test
                @TestMetadata("abstractPropertyViaSubclasses.kt")
                public void testAbstractPropertyViaSubclasses() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/property/abstractPropertyViaSubclasses.kt");
                }

                @Test
                @TestMetadata("accessViaSubclass.kt")
                public void testAccessViaSubclass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/property/accessViaSubclass.kt");
                }

                @Test
                public void testAllFilesPresentInProperty() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/callableReference/property"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("backingField.kt")
                public void testBackingField() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/property/backingField.kt");
                }

                @Test
                @TestMetadata("classFromClass.kt")
                public void testClassFromClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/property/classFromClass.kt");
                }

                @Test
                @TestMetadata("extensionFromTopLevel.kt")
                public void testExtensionFromTopLevel() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/property/extensionFromTopLevel.kt");
                }

                @Test
                @TestMetadata("extensionPropertyOnNullable.kt")
                public void testExtensionPropertyOnNullable() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/property/extensionPropertyOnNullable.kt");
                }

                @Test
                @TestMetadata("extensionsSameName.kt")
                public void testExtensionsSameName() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/property/extensionsSameName.kt");
                }

                @Test
                @TestMetadata("genericClass.kt")
                public void testGenericClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/property/genericClass.kt");
                }

                @Test
                @TestMetadata("javaInstanceField.kt")
                public void testJavaInstanceField() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/property/javaInstanceField.kt");
                }

                @Test
                @TestMetadata("javaStaticFieldViaImport.kt")
                public void testJavaStaticFieldViaImport() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/property/javaStaticFieldViaImport.kt");
                }

                @Test
                @TestMetadata("kt7564.kt")
                public void testKt7564() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/property/kt7564.kt");
                }

                @Test
                @TestMetadata("kt7945_unrelatedClass.kt")
                public void testKt7945_unrelatedClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/property/kt7945_unrelatedClass.kt");
                }

                @Test
                @TestMetadata("memberFromTopLevel.kt")
                public void testMemberFromTopLevel() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/property/memberFromTopLevel.kt");
                }

                @Test
                @TestMetadata("propertyFromAbstractSuperClass.kt")
                public void testPropertyFromAbstractSuperClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/property/propertyFromAbstractSuperClass.kt");
                }

                @Test
                @TestMetadata("protectedVarFromClass.kt")
                public void testProtectedVarFromClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/property/protectedVarFromClass.kt");
                }

                @Test
                @TestMetadata("returnTypeDependentOnGenericProperty.kt")
                public void testReturnTypeDependentOnGenericProperty() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/property/returnTypeDependentOnGenericProperty.kt");
                }

                @Test
                @TestMetadata("samePriorityForFunctionsAndProperties.kt")
                public void testSamePriorityForFunctionsAndProperties() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/property/samePriorityForFunctionsAndProperties.kt");
                }

                @Test
                @TestMetadata("topLevelFromTopLevel.kt")
                public void testTopLevelFromTopLevel() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/property/topLevelFromTopLevel.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/callableReference/resolve")
            @TestDataPath("$PROJECT_ROOT")
            public class Resolve {
                @Test
                @TestMetadata("adaptedReferenceAgainstKCallable.kt")
                public void testAdaptedReferenceAgainstKCallable() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/resolve/adaptedReferenceAgainstKCallable.kt");
                }

                @Test
                @TestMetadata("adaptedReferenceAgainstReflectionType.kt")
                public void testAdaptedReferenceAgainstReflectionType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/resolve/adaptedReferenceAgainstReflectionType.kt");
                }

                @Test
                public void testAllFilesPresentInResolve() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/callableReference/resolve"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("ambiguityWhenNoApplicableCallableReferenceCandidate.kt")
                public void testAmbiguityWhenNoApplicableCallableReferenceCandidate() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/resolve/ambiguityWhenNoApplicableCallableReferenceCandidate.kt");
                }

                @Test
                @TestMetadata("ambiguityWithBoundExtensionReceiver.kt")
                public void testAmbiguityWithBoundExtensionReceiver() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/resolve/ambiguityWithBoundExtensionReceiver.kt");
                }

                @Test
                @TestMetadata("ambiguousWithVararg.kt")
                public void testAmbiguousWithVararg() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/resolve/ambiguousWithVararg.kt");
                }

                @Test
                @TestMetadata("applicableCallableReferenceFromDistantScope.kt")
                public void testApplicableCallableReferenceFromDistantScope() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/resolve/applicableCallableReferenceFromDistantScope.kt");
                }

                @Test
                @TestMetadata("byArgType.kt")
                public void testByArgType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/resolve/byArgType.kt");
                }

                @Test
                @TestMetadata("byGenericArgType.kt")
                public void testByGenericArgType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/resolve/byGenericArgType.kt");
                }

                @Test
                @TestMetadata("byValType.kt")
                public void testByValType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/resolve/byValType.kt");
                }

                @Test
                @TestMetadata("callableReferenceToVarargWithOverload.kt")
                public void testCallableReferenceToVarargWithOverload() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/resolve/callableReferenceToVarargWithOverload.kt");
                }

                @Test
                @TestMetadata("chooseCallableReferenceDependingOnInferredReceiver.kt")
                public void testChooseCallableReferenceDependingOnInferredReceiver() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/resolve/chooseCallableReferenceDependingOnInferredReceiver.kt");
                }

                @Test
                @TestMetadata("chooseMostSpecificCandidateUsingCandidateDescriptorNotReflectionType.kt")
                public void testChooseMostSpecificCandidateUsingCandidateDescriptorNotReflectionType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/resolve/chooseMostSpecificCandidateUsingCandidateDescriptorNotReflectionType.kt");
                }

                @Test
                @TestMetadata("chooseOuterCallBySingleCallableReference.kt")
                public void testChooseOuterCallBySingleCallableReference() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/resolve/chooseOuterCallBySingleCallableReference.kt");
                }

                @Test
                @TestMetadata("commonSupertypeFromReturnTypesOfCallableReference.kt")
                public void testCommonSupertypeFromReturnTypesOfCallableReference() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/resolve/commonSupertypeFromReturnTypesOfCallableReference.kt");
                }

                @Test
                @TestMetadata("compatibilityWarningOnReferenceAgainstReflectiveType.kt")
                public void testCompatibilityWarningOnReferenceAgainstReflectiveType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/resolve/compatibilityWarningOnReferenceAgainstReflectiveType.kt");
                }

                @Test
                @TestMetadata("constructor.kt")
                public void testConstructor() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/resolve/constructor.kt");
                }

                @Test
                @TestMetadata("eagerAndPostponedCallableReferences.kt")
                public void testEagerAndPostponedCallableReferences() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/resolve/eagerAndPostponedCallableReferences.kt");
                }

                @Test
                @TestMetadata("eagerResolveOfSingleCallableReference.kt")
                public void testEagerResolveOfSingleCallableReference() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/resolve/eagerResolveOfSingleCallableReference.kt");
                }

                @Test
                @TestMetadata("innerClassConstructorOnOuterClassInstance.kt")
                public void testInnerClassConstructorOnOuterClassInstance() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/resolve/innerClassConstructorOnOuterClassInstance.kt");
                }

                @Test
                @TestMetadata("intersectionTypeOverloadWithWrongParameter.kt")
                public void testIntersectionTypeOverloadWithWrongParameter() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/resolve/intersectionTypeOverloadWithWrongParameter.kt");
                }

                @Test
                @TestMetadata("kt10036.kt")
                public void testKt10036() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/resolve/kt10036.kt");
                }

                @Test
                @TestMetadata("kt10036_bound.kt")
                public void testKt10036_bound() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/resolve/kt10036_bound.kt");
                }

                @Test
                @TestMetadata("kt12338.kt")
                public void testKt12338() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/resolve/kt12338.kt");
                }

                @Test
                @TestMetadata("kt12751.kt")
                public void testKt12751() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/resolve/kt12751.kt");
                }

                @Test
                @TestMetadata("kt35887.kt")
                public void testKt35887() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/resolve/kt35887.kt");
                }

                @Test
                @TestMetadata("kt35887_simple.kt")
                public void testKt35887_simple() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/resolve/kt35887_simple.kt");
                }

                @Test
                @TestMetadata("kt35920.kt")
                public void testKt35920() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/resolve/kt35920.kt");
                }

                @Test
                @TestMetadata("kt8596.kt")
                public void testKt8596() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/resolve/kt8596.kt");
                }

                @Test
                @TestMetadata("kt9601.kt")
                public void testKt9601() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/resolve/kt9601.kt");
                }

                @Test
                @TestMetadata("moreSpecificAmbiguousExtensions.kt")
                public void testMoreSpecificAmbiguousExtensions() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/resolve/moreSpecificAmbiguousExtensions.kt");
                }

                @Test
                @TestMetadata("moreSpecificSimple.kt")
                public void testMoreSpecificSimple() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/resolve/moreSpecificSimple.kt");
                }

                @Test
                @TestMetadata("multipleOutersAndMultipleCallableReferences.kt")
                public void testMultipleOutersAndMultipleCallableReferences() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/resolve/multipleOutersAndMultipleCallableReferences.kt");
                }

                @Test
                @TestMetadata("nestedReferenceCallAgainstExpectedType.kt")
                public void testNestedReferenceCallAgainstExpectedType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/resolve/nestedReferenceCallAgainstExpectedType.kt");
                }

                @Test
                @TestMetadata("noAmbiguityBetweenTopLevelAndMemberProperty.kt")
                public void testNoAmbiguityBetweenTopLevelAndMemberProperty() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/resolve/noAmbiguityBetweenTopLevelAndMemberProperty.kt");
                }

                @Test
                @TestMetadata("noFakeDescriptorForObject.kt")
                public void testNoFakeDescriptorForObject() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/resolve/noFakeDescriptorForObject.kt");
                }

                @Test
                @TestMetadata("overloadAmbiguityForSimpleLastExpressionOfBlock.kt")
                public void testOverloadAmbiguityForSimpleLastExpressionOfBlock() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/resolve/overloadAmbiguityForSimpleLastExpressionOfBlock.kt");
                }

                @Test
                @TestMetadata("overloads.kt")
                public void testOverloads() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/resolve/overloads.kt");
                }

                @Test
                @TestMetadata("overloadsBound.kt")
                public void testOverloadsBound() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/resolve/overloadsBound.kt");
                }

                @Test
                @TestMetadata("overloadsMember.kt")
                public void testOverloadsMember() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/resolve/overloadsMember.kt");
                }

                @Test
                @TestMetadata("postponedResolveOfManyCallableReference.kt")
                public void testPostponedResolveOfManyCallableReference() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/resolve/postponedResolveOfManyCallableReference.kt");
                }

                @Test
                @TestMetadata("resolveCallableReferencesAfterAllSimpleArguments.kt")
                public void testResolveCallableReferencesAfterAllSimpleArguments() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/resolve/resolveCallableReferencesAfterAllSimpleArguments.kt");
                }

                @Test
                @TestMetadata("resolveEqualsOperatorWithAnyExpectedType.kt")
                public void testResolveEqualsOperatorWithAnyExpectedType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/resolve/resolveEqualsOperatorWithAnyExpectedType.kt");
                }

                @Test
                @TestMetadata("resolveReferenceAgainstKFunctionAndKPrpoerty.kt")
                public void testResolveReferenceAgainstKFunctionAndKPrpoerty() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/resolve/resolveReferenceAgainstKFunctionAndKPrpoerty.kt");
                }

                @Test
                @TestMetadata("resolveTwoReferencesAgainstGenerics.kt")
                public void testResolveTwoReferencesAgainstGenerics() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/resolve/resolveTwoReferencesAgainstGenerics.kt");
                }

                @Test
                @TestMetadata("valVsFun.kt")
                public void testValVsFun() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/resolve/valVsFun.kt");
                }

                @Test
                @TestMetadata("withAs.kt")
                public void testWithAs() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/resolve/withAs.kt");
                }

                @Test
                @TestMetadata("withExtFun.kt")
                public void testWithExtFun() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/resolve/withExtFun.kt");
                }

                @Test
                @TestMetadata("withGenericFun.kt")
                public void testWithGenericFun() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/resolve/withGenericFun.kt");
                }

                @Test
                @TestMetadata("withPlaceholderTypes.kt")
                public void testWithPlaceholderTypes() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/resolve/withPlaceholderTypes.kt");
                }

                @Test
                @TestMetadata("withVararg.kt")
                public void testWithVararg() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/resolve/withVararg.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/callableReference/unsupported")
            @TestDataPath("$PROJECT_ROOT")
            public class Unsupported {
                @Test
                public void testAllFilesPresentInUnsupported() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/callableReference/unsupported"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("callableReferenceToLocalVariable.kt")
                public void testCallableReferenceToLocalVariable() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/unsupported/callableReferenceToLocalVariable.kt");
                }

                @Test
                @TestMetadata("localVariable.kt")
                public void testLocalVariable() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/unsupported/localVariable.kt");
                }

                @Test
                @TestMetadata("localVariableWithSubstitution.kt")
                public void testLocalVariableWithSubstitution() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/unsupported/localVariableWithSubstitution.kt");
                }

                @Test
                @TestMetadata("parameterWithSubstitution.kt")
                public void testParameterWithSubstitution() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/unsupported/parameterWithSubstitution.kt");
                }

                @Test
                @TestMetadata("syntheticProperties.kt")
                public void testSyntheticProperties() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/callableReference/unsupported/syntheticProperties.kt");
                }
            }
        }

        @Nested
        @TestMetadata("compiler/testData/diagnostics/tests/cast")
        @TestDataPath("$PROJECT_ROOT")
        public class Cast {
            @Test
            public void testAllFilesPresentInCast() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/cast"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
            }

            @Test
            @TestMetadata("AsArray.kt")
            public void testAsArray() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/AsArray.kt");
            }

            @Test
            @TestMetadata("AsErasedError.kt")
            public void testAsErasedError() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/AsErasedError.kt");
            }

            @Test
            @TestMetadata("AsErasedFine.kt")
            public void testAsErasedFine() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/AsErasedFine.kt");
            }

            @Test
            @TestMetadata("AsErasedStar.kt")
            public void testAsErasedStar() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/AsErasedStar.kt");
            }

            @Test
            @TestMetadata("AsErasedWarning.kt")
            public void testAsErasedWarning() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/AsErasedWarning.kt");
            }

            @Test
            @TestMetadata("AsInBinaryUnary.kt")
            public void testAsInBinaryUnary() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/AsInBinaryUnary.kt");
            }

            @Test
            @TestMetadata("AsInBlockWithReturnType.kt")
            public void testAsInBlockWithReturnType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/AsInBlockWithReturnType.kt");
            }

            @Test
            @TestMetadata("AsInExpressionBody.kt")
            public void testAsInExpressionBody() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/AsInExpressionBody.kt");
            }

            @Test
            @TestMetadata("AsInPropertyAndPropertyAccessor.kt")
            public void testAsInPropertyAndPropertyAccessor() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/AsInPropertyAndPropertyAccessor.kt");
            }

            @Test
            @TestMetadata("AsNothing.kt")
            public void testAsNothing() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/AsNothing.kt");
            }

            @Test
            @TestMetadata("AsTypeAlias.kt")
            public void testAsTypeAlias() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/AsTypeAlias.kt");
            }

            @Test
            @TestMetadata("AsWithOtherParameter.kt")
            public void testAsWithOtherParameter() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/AsWithOtherParameter.kt");
            }

            @Test
            @TestMetadata("checkCastToNullableType.kt")
            public void testCheckCastToNullableType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/checkCastToNullableType.kt");
            }

            @Test
            @TestMetadata("constants.kt")
            public void testConstants() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/constants.kt");
            }

            @Test
            @TestMetadata("DowncastMap.kt")
            public void testDowncastMap() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/DowncastMap.kt");
            }

            @Test
            @TestMetadata("ExtensionAsNonExtension.kt")
            public void testExtensionAsNonExtension() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/ExtensionAsNonExtension.kt");
            }

            @Test
            @TestMetadata("FlexibleTargetType.kt")
            public void testFlexibleTargetType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/FlexibleTargetType.kt");
            }

            @Test
            @TestMetadata("isAlwaysFalse.kt")
            public void testIsAlwaysFalse() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/isAlwaysFalse.kt");
            }

            @Test
            @TestMetadata("IsErasedAllowForDerivedWithOneSubstitutedAndOneSameGeneric.kt")
            public void testIsErasedAllowForDerivedWithOneSubstitutedAndOneSameGeneric() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/IsErasedAllowForDerivedWithOneSubstitutedAndOneSameGeneric.kt");
            }

            @Test
            @TestMetadata("IsErasedAllowForExactSupertypeCheck.kt")
            public void testIsErasedAllowForExactSupertypeCheck() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/IsErasedAllowForExactSupertypeCheck.kt");
            }

            @Test
            @TestMetadata("IsErasedAllowForOverridenVarianceWithProjection.kt")
            public void testIsErasedAllowForOverridenVarianceWithProjection() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/IsErasedAllowForOverridenVarianceWithProjection.kt");
            }

            @Test
            @TestMetadata("IsErasedAllowForSupertypeCheckWithContrvariance.kt")
            public void testIsErasedAllowForSupertypeCheckWithContrvariance() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/IsErasedAllowForSupertypeCheckWithContrvariance.kt");
            }

            @Test
            @TestMetadata("IsErasedAllowForSupertypeCheckWithCovariance.kt")
            public void testIsErasedAllowForSupertypeCheckWithCovariance() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/IsErasedAllowForSupertypeCheckWithCovariance.kt");
            }

            @Test
            @TestMetadata("IsErasedAllowForTypeWithIrrelevantMixin.kt")
            public void testIsErasedAllowForTypeWithIrrelevantMixin() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/IsErasedAllowForTypeWithIrrelevantMixin.kt");
            }

            @Test
            @TestMetadata("IsErasedAllowForTypeWithTwoSameTypeSubstitutions.kt")
            public void testIsErasedAllowForTypeWithTwoSameTypeSubstitutions() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/IsErasedAllowForTypeWithTwoSameTypeSubstitutions.kt");
            }

            @Test
            @TestMetadata("IsErasedAllowForTypeWithoutTypeArguments.kt")
            public void testIsErasedAllowForTypeWithoutTypeArguments() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/IsErasedAllowForTypeWithoutTypeArguments.kt");
            }

            @Test
            @TestMetadata("IsErasedAllowFromOut.kt")
            public void testIsErasedAllowFromOut() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/IsErasedAllowFromOut.kt");
            }

            @Test
            @TestMetadata("IsErasedAllowFromOut2.kt")
            public void testIsErasedAllowFromOut2() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/IsErasedAllowFromOut2.kt");
            }

            @Test
            @TestMetadata("IsErasedAllowFromOut3.kt")
            public void testIsErasedAllowFromOut3() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/IsErasedAllowFromOut3.kt");
            }

            @Test
            @TestMetadata("IsErasedAllowFromOutAtClass.kt")
            public void testIsErasedAllowFromOutAtClass() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/IsErasedAllowFromOutAtClass.kt");
            }

            @Test
            @TestMetadata("IsErasedAllowParameterSubtype.kt")
            public void testIsErasedAllowParameterSubtype() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/IsErasedAllowParameterSubtype.kt");
            }

            @Test
            @TestMetadata("IsErasedAllowSameClassParameter.kt")
            public void testIsErasedAllowSameClassParameter() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/IsErasedAllowSameClassParameter.kt");
            }

            @Test
            @TestMetadata("IsErasedAllowSameParameterParameter.kt")
            public void testIsErasedAllowSameParameterParameter() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/IsErasedAllowSameParameterParameter.kt");
            }

            @Test
            @TestMetadata("isErasedAnyAndStarred.kt")
            public void testIsErasedAnyAndStarred() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/isErasedAnyAndStarred.kt");
            }

            @Test
            @TestMetadata("IsErasedDisallowDifferentArgInvariantPosition.kt")
            public void testIsErasedDisallowDifferentArgInvariantPosition() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/IsErasedDisallowDifferentArgInvariantPosition.kt");
            }

            @Test
            @TestMetadata("IsErasedDisallowForOverridenVariance.kt")
            public void testIsErasedDisallowForOverridenVariance() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/IsErasedDisallowForOverridenVariance.kt");
            }

            @Test
            @TestMetadata("IsErasedDisallowForTypeWithConstraints.kt")
            public void testIsErasedDisallowForTypeWithConstraints() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/IsErasedDisallowForTypeWithConstraints.kt");
            }

            @Test
            @TestMetadata("IsErasedDisallowFromAny.kt")
            public void testIsErasedDisallowFromAny() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/IsErasedDisallowFromAny.kt");
            }

            @Test
            @TestMetadata("IsErasedDisallowFromIn.kt")
            public void testIsErasedDisallowFromIn() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/IsErasedDisallowFromIn.kt");
            }

            @Test
            @TestMetadata("IsErasedDisallowFromOut.kt")
            public void testIsErasedDisallowFromOut() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/IsErasedDisallowFromOut.kt");
            }

            @Test
            @TestMetadata("IsErasedDisallowFromOutAtClass.kt")
            public void testIsErasedDisallowFromOutAtClass() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/IsErasedDisallowFromOutAtClass.kt");
            }

            @Test
            @TestMetadata("IsErasedDissallowForSubtypeMappedToTwoParamsWithFirstInvalid.kt")
            public void testIsErasedDissallowForSubtypeMappedToTwoParamsWithFirstInvalid() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/IsErasedDissallowForSubtypeMappedToTwoParamsWithFirstInvalid.kt");
            }

            @Test
            @TestMetadata("IsErasedDissallowForSubtypeMappedToTwoParamsWithSecondInvalid.kt")
            public void testIsErasedDissallowForSubtypeMappedToTwoParamsWithSecondInvalid() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/IsErasedDissallowForSubtypeMappedToTwoParamsWithSecondInvalid.kt");
            }

            @Test
            @TestMetadata("IsErasedNonGeneric.kt")
            public void testIsErasedNonGeneric() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/IsErasedNonGeneric.kt");
            }

            @Test
            @TestMetadata("IsErasedNullableTasT.kt")
            public void testIsErasedNullableTasT() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/IsErasedNullableTasT.kt");
            }

            @Test
            @TestMetadata("IsErasedStar.kt")
            public void testIsErasedStar() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/IsErasedStar.kt");
            }

            @Test
            @TestMetadata("isErasedTAndStarred.kt")
            public void testIsErasedTAndStarred() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/isErasedTAndStarred.kt");
            }

            @Test
            @TestMetadata("IsErasedTasT.kt")
            public void testIsErasedTasT() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/IsErasedTasT.kt");
            }

            @Test
            @TestMetadata("IsErasedToErrorType.kt")
            public void testIsErasedToErrorType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/IsErasedToErrorType.kt");
            }

            @Test
            @TestMetadata("isErasedUnrelatedAndStarred.kt")
            public void testIsErasedUnrelatedAndStarred() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/isErasedUnrelatedAndStarred.kt");
            }

            @Test
            @TestMetadata("IsErasedUpcastToNonReified.kt")
            public void testIsErasedUpcastToNonReified() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/IsErasedUpcastToNonReified.kt");
            }

            @Test
            @TestMetadata("IsForTypeWithComplexUpperBound.kt")
            public void testIsForTypeWithComplexUpperBound() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/IsForTypeWithComplexUpperBound.kt");
            }

            @Test
            @TestMetadata("IsRecursionSustainable.kt")
            public void testIsRecursionSustainable() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/IsRecursionSustainable.kt");
            }

            @Test
            @TestMetadata("IsTraits.kt")
            public void testIsTraits() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/IsTraits.kt");
            }

            @Test
            @TestMetadata("IsWithCycleUpperBounds.kt")
            public void testIsWithCycleUpperBounds() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/IsWithCycleUpperBounds.kt");
            }

            @Test
            @TestMetadata("kt15161.kt")
            public void testKt15161() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/kt15161.kt");
            }

            @Test
            @TestMetadata("kt47685.kt")
            public void testKt47685() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/kt47685.kt");
            }

            @Test
            @TestMetadata("kt614.kt")
            public void testKt614() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/kt614.kt");
            }

            @Test
            @TestMetadata("nothingAs.kt")
            public void testNothingAs() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/nothingAs.kt");
            }

            @Test
            @TestMetadata("NullableToNullable.kt")
            public void testNullableToNullable() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/NullableToNullable.kt");
            }

            @Test
            @TestMetadata("StableTypeForUselessCast.kt")
            public void testStableTypeForUselessCast() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/StableTypeForUselessCast.kt");
            }

            @Test
            @TestMetadata("UselessSafeCast.kt")
            public void testUselessSafeCast() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/UselessSafeCast.kt");
            }

            @Test
            @TestMetadata("WhenErasedDisallowFromAny.kt")
            public void testWhenErasedDisallowFromAny() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/WhenErasedDisallowFromAny.kt");
            }

            @Test
            @TestMetadata("WhenWithExpression.kt")
            public void testWhenWithExpression() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cast/WhenWithExpression.kt");
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/cast/bare")
            @TestDataPath("$PROJECT_ROOT")
            public class Bare {
                @Test
                public void testAllFilesPresentInBare() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/cast/bare"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("AsNestedBare.kt")
                public void testAsNestedBare() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/cast/bare/AsNestedBare.kt");
                }

                @Test
                @TestMetadata("AsNullable.kt")
                public void testAsNullable() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/cast/bare/AsNullable.kt");
                }

                @Test
                @TestMetadata("AsNullableNotEnough.kt")
                public void testAsNullableNotEnough() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/cast/bare/AsNullableNotEnough.kt");
                }

                @Test
                @TestMetadata("EitherAs.kt")
                public void testEitherAs() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/cast/bare/EitherAs.kt");
                }

                @Test
                @TestMetadata("EitherIs.kt")
                public void testEitherIs() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/cast/bare/EitherIs.kt");
                }

                @Test
                @TestMetadata("EitherNotIs.kt")
                public void testEitherNotIs() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/cast/bare/EitherNotIs.kt");
                }

                @Test
                @TestMetadata("EitherSafeAs.kt")
                public void testEitherSafeAs() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/cast/bare/EitherSafeAs.kt");
                }

                @Test
                @TestMetadata("EitherWhen.kt")
                public void testEitherWhen() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/cast/bare/EitherWhen.kt");
                }

                @Test
                @TestMetadata("ErrorsInSubstitution.kt")
                public void testErrorsInSubstitution() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/cast/bare/ErrorsInSubstitution.kt");
                }

                @Test
                @TestMetadata("FromErrorType.kt")
                public void testFromErrorType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/cast/bare/FromErrorType.kt");
                }

                @Test
                @TestMetadata("NullableAs.kt")
                public void testNullableAs() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/cast/bare/NullableAs.kt");
                }

                @Test
                @TestMetadata("NullableAsNotEnough.kt")
                public void testNullableAsNotEnough() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/cast/bare/NullableAsNotEnough.kt");
                }

                @Test
                @TestMetadata("NullableAsNullable.kt")
                public void testNullableAsNullable() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/cast/bare/NullableAsNullable.kt");
                }

                @Test
                @TestMetadata("NullableAsNullableNotEnough.kt")
                public void testNullableAsNullableNotEnough() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/cast/bare/NullableAsNullableNotEnough.kt");
                }

                @Test
                @TestMetadata("RedundantNullable.kt")
                public void testRedundantNullable() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/cast/bare/RedundantNullable.kt");
                }

                @Test
                @TestMetadata("SupertypeChain.kt")
                public void testSupertypeChain() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/cast/bare/SupertypeChain.kt");
                }

                @Test
                @TestMetadata("ToErrorType.kt")
                public void testToErrorType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/cast/bare/ToErrorType.kt");
                }

                @Test
                @TestMetadata("UnrelatedAs.kt")
                public void testUnrelatedAs() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/cast/bare/UnrelatedAs.kt");
                }

                @Test
                @TestMetadata("UnrelatedColon.kt")
                public void testUnrelatedColon() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/cast/bare/UnrelatedColon.kt");
                }

                @Test
                @TestMetadata("UnrelatedIs.kt")
                public void testUnrelatedIs() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/cast/bare/UnrelatedIs.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/cast/neverSucceeds")
            @TestDataPath("$PROJECT_ROOT")
            public class NeverSucceeds {
                @Test
                public void testAllFilesPresentInNeverSucceeds() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/cast/neverSucceeds"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("CastToNotNullSuper.kt")
                public void testCastToNotNullSuper() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/cast/neverSucceeds/CastToNotNullSuper.kt");
                }

                @Test
                @TestMetadata("MappedDirect.kt")
                public void testMappedDirect() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/cast/neverSucceeds/MappedDirect.kt");
                }

                @Test
                @TestMetadata("MappedSubtypes.kt")
                public void testMappedSubtypes() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/cast/neverSucceeds/MappedSubtypes.kt");
                }

                @Test
                @TestMetadata("NoGenericsRelated.kt")
                public void testNoGenericsRelated() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/cast/neverSucceeds/NoGenericsRelated.kt");
                }

                @Test
                @TestMetadata("NoGenericsUnrelated.kt")
                public void testNoGenericsUnrelated() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/cast/neverSucceeds/NoGenericsUnrelated.kt");
                }
            }
        }

        @Nested
        @TestMetadata("compiler/testData/diagnostics/tests/checkArguments")
        @TestDataPath("$PROJECT_ROOT")
        public class CheckArguments {
            @Test
            public void testAllFilesPresentInCheckArguments() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/checkArguments"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
            }

            @Test
            @TestMetadata("arrayAccessSet.kt")
            public void testArrayAccessSet() throws Exception {
                runTest("compiler/testData/diagnostics/tests/checkArguments/arrayAccessSet.kt");
            }

            @Test
            @TestMetadata("arrayAccessSetNotEnoughArgs.kt")
            public void testArrayAccessSetNotEnoughArgs() throws Exception {
                runTest("compiler/testData/diagnostics/tests/checkArguments/arrayAccessSetNotEnoughArgs.kt");
            }

            @Test
            @TestMetadata("arrayAccessSetTooManyArgs.kt")
            public void testArrayAccessSetTooManyArgs() throws Exception {
                runTest("compiler/testData/diagnostics/tests/checkArguments/arrayAccessSetTooManyArgs.kt");
            }

            @Test
            @TestMetadata("booleanExpressions.kt")
            public void testBooleanExpressions() throws Exception {
                runTest("compiler/testData/diagnostics/tests/checkArguments/booleanExpressions.kt");
            }

            @Test
            @TestMetadata("kt17691.kt")
            public void testKt17691() throws Exception {
                runTest("compiler/testData/diagnostics/tests/checkArguments/kt17691.kt");
            }

            @Test
            @TestMetadata("kt17691WithEnabledFeature.kt")
            public void testKt17691WithEnabledFeature() throws Exception {
                runTest("compiler/testData/diagnostics/tests/checkArguments/kt17691WithEnabledFeature.kt");
            }

            @Test
            @TestMetadata("kt1897_diagnostic_part.kt")
            public void testKt1897_diagnostic_part() throws Exception {
                runTest("compiler/testData/diagnostics/tests/checkArguments/kt1897_diagnostic_part.kt");
            }

            @Test
            @TestMetadata("kt1940.kt")
            public void testKt1940() throws Exception {
                runTest("compiler/testData/diagnostics/tests/checkArguments/kt1940.kt");
            }

            @Test
            @TestMetadata("kt49276.kt")
            public void testKt49276() throws Exception {
                runTest("compiler/testData/diagnostics/tests/checkArguments/kt49276.kt");
            }

            @Test
            @TestMetadata("kt49276Disabled.kt")
            public void testKt49276Disabled() throws Exception {
                runTest("compiler/testData/diagnostics/tests/checkArguments/kt49276Disabled.kt");
            }

            @Test
            @TestMetadata("kt49276Error.kt")
            public void testKt49276Error() throws Exception {
                runTest("compiler/testData/diagnostics/tests/checkArguments/kt49276Error.kt");
            }

            @Test
            @TestMetadata("kt51062.kt")
            public void testKt51062() throws Exception {
                runTest("compiler/testData/diagnostics/tests/checkArguments/kt51062.kt");
            }

            @Test
            @TestMetadata("overloadedFunction.kt")
            public void testOverloadedFunction() throws Exception {
                runTest("compiler/testData/diagnostics/tests/checkArguments/overloadedFunction.kt");
            }

            @Test
            @TestMetadata("SpreadVarargs.kt")
            public void testSpreadVarargs() throws Exception {
                runTest("compiler/testData/diagnostics/tests/checkArguments/SpreadVarargs.kt");
            }

            @Test
            @TestMetadata("twoLambdasFunction.kt")
            public void testTwoLambdasFunction() throws Exception {
                runTest("compiler/testData/diagnostics/tests/checkArguments/twoLambdasFunction.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/diagnostics/tests/classLiteral")
        @TestDataPath("$PROJECT_ROOT")
        public class ClassLiteral {
            @Test
            public void testAllFilesPresentInClassLiteral() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/classLiteral"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
            }

            @Test
            @TestMetadata("arrays.kt")
            public void testArrays() throws Exception {
                runTest("compiler/testData/diagnostics/tests/classLiteral/arrays.kt");
            }

            @Test
            @TestMetadata("classAndObjectLiteralType.kt")
            public void testClassAndObjectLiteralType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/classLiteral/classAndObjectLiteralType.kt");
            }

            @Test
            @TestMetadata("classLiteralType.kt")
            public void testClassLiteralType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/classLiteral/classLiteralType.kt");
            }

            @Test
            @TestMetadata("expressionWithNullableType.kt")
            public void testExpressionWithNullableType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/classLiteral/expressionWithNullableType.kt");
            }

            @Test
            @TestMetadata("genericArrays.kt")
            public void testGenericArrays() throws Exception {
                runTest("compiler/testData/diagnostics/tests/classLiteral/genericArrays.kt");
            }

            @Test
            @TestMetadata("genericClasses.kt")
            public void testGenericClasses() throws Exception {
                runTest("compiler/testData/diagnostics/tests/classLiteral/genericClasses.kt");
            }

            @Test
            @TestMetadata("inAnnotationArguments.kt")
            public void testInAnnotationArguments() throws Exception {
                runTest("compiler/testData/diagnostics/tests/classLiteral/inAnnotationArguments.kt");
            }

            @Test
            @TestMetadata("inAnnotationArguments_noTypeParams.kt")
            public void testInAnnotationArguments_noTypeParams() throws Exception {
                runTest("compiler/testData/diagnostics/tests/classLiteral/inAnnotationArguments_noTypeParams.kt");
            }

            @Test
            @TestMetadata("integerValueType.kt")
            public void testIntegerValueType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/classLiteral/integerValueType.kt");
            }

            @Test
            @TestMetadata("nonClassesOnLHS.kt")
            public void testNonClassesOnLHS() throws Exception {
                runTest("compiler/testData/diagnostics/tests/classLiteral/nonClassesOnLHS.kt");
            }

            @Test
            @TestMetadata("qualifiedClassLiteral.kt")
            public void testQualifiedClassLiteral() throws Exception {
                runTest("compiler/testData/diagnostics/tests/classLiteral/qualifiedClassLiteral.kt");
            }

            @Test
            @TestMetadata("simpleClassLiteral.kt")
            public void testSimpleClassLiteral() throws Exception {
                runTest("compiler/testData/diagnostics/tests/classLiteral/simpleClassLiteral.kt");
            }

            @Test
            @TestMetadata("smartCast.kt")
            public void testSmartCast() throws Exception {
                runTest("compiler/testData/diagnostics/tests/classLiteral/smartCast.kt");
            }

            @Test
            @TestMetadata("typealiases.kt")
            public void testTypealiases() throws Exception {
                runTest("compiler/testData/diagnostics/tests/classLiteral/typealiases.kt");
            }

            @Test
            @TestMetadata("unresolvedClass.kt")
            public void testUnresolvedClass() throws Exception {
                runTest("compiler/testData/diagnostics/tests/classLiteral/unresolvedClass.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/diagnostics/tests/classObjects")
        @TestDataPath("$PROJECT_ROOT")
        public class ClassObjects {
            @Test
            public void testAllFilesPresentInClassObjects() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/classObjects"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
            }

            @Test
            @TestMetadata("builtInClassObjects.kt")
            public void testBuiltInClassObjects() throws Exception {
                runTest("compiler/testData/diagnostics/tests/classObjects/builtInClassObjects.kt");
            }

            @Test
            @TestMetadata("ClassObjectCannotAccessClassFields.kt")
            public void testClassObjectCannotAccessClassFields() throws Exception {
                runTest("compiler/testData/diagnostics/tests/classObjects/ClassObjectCannotAccessClassFields.kt");
            }

            @Test
            @TestMetadata("classObjectHeader.kt")
            public void testClassObjectHeader() throws Exception {
                runTest("compiler/testData/diagnostics/tests/classObjects/classObjectHeader.kt");
            }

            @Test
            @TestMetadata("classObjectInLocalClass.kt")
            public void testClassObjectInLocalClass() throws Exception {
                runTest("compiler/testData/diagnostics/tests/classObjects/classObjectInLocalClass.kt");
            }

            @Test
            @TestMetadata("classObjectRedeclaration.kt")
            public void testClassObjectRedeclaration() throws Exception {
                runTest("compiler/testData/diagnostics/tests/classObjects/classObjectRedeclaration.kt");
            }

            @Test
            @TestMetadata("ClassObjectVisibility.kt")
            public void testClassObjectVisibility() throws Exception {
                runTest("compiler/testData/diagnostics/tests/classObjects/ClassObjectVisibility.kt");
            }

            @Test
            @TestMetadata("ClassObjects.kt")
            public void testClassObjects() throws Exception {
                runTest("compiler/testData/diagnostics/tests/classObjects/ClassObjects.kt");
            }

            @Test
            @TestMetadata("classWithFunctionSupertype_after.kt")
            public void testClassWithFunctionSupertype_after() throws Exception {
                runTest("compiler/testData/diagnostics/tests/classObjects/classWithFunctionSupertype_after.kt");
            }

            @Test
            @TestMetadata("classWithFunctionSupertype_before.kt")
            public void testClassWithFunctionSupertype_before() throws Exception {
                runTest("compiler/testData/diagnostics/tests/classObjects/classWithFunctionSupertype_before.kt");
            }

            @Test
            @TestMetadata("companionObjectOfPrivateClassVisibility.kt")
            public void testCompanionObjectOfPrivateClassVisibility() throws Exception {
                runTest("compiler/testData/diagnostics/tests/classObjects/companionObjectOfPrivateClassVisibility.kt");
            }

            @Test
            @TestMetadata("importClassInClassObject.kt")
            public void testImportClassInClassObject() throws Exception {
                runTest("compiler/testData/diagnostics/tests/classObjects/importClassInClassObject.kt");
            }

            @Test
            @TestMetadata("InnerClassAccessThroughClassObject.kt")
            public void testInnerClassAccessThroughClassObject() throws Exception {
                runTest("compiler/testData/diagnostics/tests/classObjects/InnerClassAccessThroughClassObject.kt");
            }

            @Test
            @TestMetadata("InnerClassAccessThroughEnum_after.kt")
            public void testInnerClassAccessThroughEnum_after() throws Exception {
                runTest("compiler/testData/diagnostics/tests/classObjects/InnerClassAccessThroughEnum_after.kt");
            }

            @Test
            @TestMetadata("InnerClassAccessThroughEnum_before.kt")
            public void testInnerClassAccessThroughEnum_before() throws Exception {
                runTest("compiler/testData/diagnostics/tests/classObjects/InnerClassAccessThroughEnum_before.kt");
            }

            @Test
            @TestMetadata("InnerClassClassObject.kt")
            public void testInnerClassClassObject() throws Exception {
                runTest("compiler/testData/diagnostics/tests/classObjects/InnerClassClassObject.kt");
            }

            @Test
            @TestMetadata("invisibleClassObjects.kt")
            public void testInvisibleClassObjects() throws Exception {
                runTest("compiler/testData/diagnostics/tests/classObjects/invisibleClassObjects.kt");
            }

            @Test
            @TestMetadata("kt3866.kt")
            public void testKt3866() throws Exception {
                runTest("compiler/testData/diagnostics/tests/classObjects/kt3866.kt");
            }

            @Test
            @TestMetadata("multipleDissallowedDefaultObjects.kt")
            public void testMultipleDissallowedDefaultObjects() throws Exception {
                runTest("compiler/testData/diagnostics/tests/classObjects/multipleDissallowedDefaultObjects.kt");
            }

            @Test
            @TestMetadata("nestedClassInPrivateClassObject.kt")
            public void testNestedClassInPrivateClassObject() throws Exception {
                runTest("compiler/testData/diagnostics/tests/classObjects/nestedClassInPrivateClassObject.kt");
            }

            @Test
            @TestMetadata("resolveFunctionInsideClassObject.kt")
            public void testResolveFunctionInsideClassObject() throws Exception {
                runTest("compiler/testData/diagnostics/tests/classObjects/resolveFunctionInsideClassObject.kt");
            }

            @Test
            @TestMetadata("selfCallsInCompanionSuperConstructor_error.kt")
            public void testSelfCallsInCompanionSuperConstructor_error() throws Exception {
                runTest("compiler/testData/diagnostics/tests/classObjects/selfCallsInCompanionSuperConstructor_error.kt");
            }

            @Test
            @TestMetadata("selfCallsInCompanionSuperConstructor_warning.kt")
            public void testSelfCallsInCompanionSuperConstructor_warning() throws Exception {
                runTest("compiler/testData/diagnostics/tests/classObjects/selfCallsInCompanionSuperConstructor_warning.kt");
            }

            @Test
            @TestMetadata("typeParametersInAnnonymousObject.kt")
            public void testTypeParametersInAnnonymousObject() throws Exception {
                runTest("compiler/testData/diagnostics/tests/classObjects/typeParametersInAnnonymousObject.kt");
            }

            @Test
            @TestMetadata("typeParametersInAnnonymousObject_after.kt")
            public void testTypeParametersInAnnonymousObject_after() throws Exception {
                runTest("compiler/testData/diagnostics/tests/classObjects/typeParametersInAnnonymousObject_after.kt");
            }

            @Test
            @TestMetadata("typeParametersInObject.kt")
            public void testTypeParametersInObject() throws Exception {
                runTest("compiler/testData/diagnostics/tests/classObjects/typeParametersInObject.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/diagnostics/tests/collectionLiterals")
        @TestDataPath("$PROJECT_ROOT")
        public class CollectionLiterals {
            @Test
            public void testAllFilesPresentInCollectionLiterals() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/collectionLiterals"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
            }

            @Test
            @TestMetadata("argumentsOfAnnotation.kt")
            public void testArgumentsOfAnnotation() throws Exception {
                runTest("compiler/testData/diagnostics/tests/collectionLiterals/argumentsOfAnnotation.kt");
            }

            @Test
            @TestMetadata("argumentsOfAnnotationWithKClass.kt")
            public void testArgumentsOfAnnotationWithKClass() throws Exception {
                runTest("compiler/testData/diagnostics/tests/collectionLiterals/argumentsOfAnnotationWithKClass.kt");
            }

            @Test
            @TestMetadata("basicCollectionLiterals.kt")
            public void testBasicCollectionLiterals() throws Exception {
                runTest("compiler/testData/diagnostics/tests/collectionLiterals/basicCollectionLiterals.kt");
            }

            @Test
            @TestMetadata("collectionLiteralsAsPrimitiveArrays.kt")
            public void testCollectionLiteralsAsPrimitiveArrays() throws Exception {
                runTest("compiler/testData/diagnostics/tests/collectionLiterals/collectionLiteralsAsPrimitiveArrays.kt");
            }

            @Test
            @TestMetadata("collectionLiteralsOutsideOfAnnotations.kt")
            public void testCollectionLiteralsOutsideOfAnnotations() throws Exception {
                runTest("compiler/testData/diagnostics/tests/collectionLiterals/collectionLiteralsOutsideOfAnnotations.kt");
            }

            @Test
            @TestMetadata("collectionLiteralsWithVarargs.kt")
            public void testCollectionLiteralsWithVarargs() throws Exception {
                runTest("compiler/testData/diagnostics/tests/collectionLiterals/collectionLiteralsWithVarargs.kt");
            }

            @Test
            @TestMetadata("defaultValuesInAnnotation.kt")
            public void testDefaultValuesInAnnotation() throws Exception {
                runTest("compiler/testData/diagnostics/tests/collectionLiterals/defaultValuesInAnnotation.kt");
            }

            @Test
            @TestMetadata("defaultValuesWithConstantsInAnnotation.kt")
            public void testDefaultValuesWithConstantsInAnnotation() throws Exception {
                runTest("compiler/testData/diagnostics/tests/collectionLiterals/defaultValuesWithConstantsInAnnotation.kt");
            }

            @Test
            @TestMetadata("kt34515.kt")
            public void testKt34515() throws Exception {
                runTest("compiler/testData/diagnostics/tests/collectionLiterals/kt34515.kt");
            }

            @Test
            @TestMetadata("noCollectionLiterals.kt")
            public void testNoCollectionLiterals() throws Exception {
                runTest("compiler/testData/diagnostics/tests/collectionLiterals/noCollectionLiterals.kt");
            }

            @Test
            @TestMetadata("resolveToFunctionFromBuiltIns.kt")
            public void testResolveToFunctionFromBuiltIns() throws Exception {
                runTest("compiler/testData/diagnostics/tests/collectionLiterals/resolveToFunctionFromBuiltIns.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/diagnostics/tests/constantEvaluator")
        @TestDataPath("$PROJECT_ROOT")
        public class ConstantEvaluator {
            @Test
            public void testAllFilesPresentInConstantEvaluator() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/constantEvaluator"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/constantEvaluator/constant")
            @TestDataPath("$PROJECT_ROOT")
            public class Constant {
                @Test
                public void testAllFilesPresentInConstant() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/constantEvaluator/constant"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("classObjectProperty.kt")
                public void testClassObjectProperty() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/constantEvaluator/constant/classObjectProperty.kt");
                }

                @Test
                @TestMetadata("compareTo.kt")
                public void testCompareTo() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/constantEvaluator/constant/compareTo.kt");
                }

                @Test
                @TestMetadata("differentTypes.kt")
                public void testDifferentTypes() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/constantEvaluator/constant/differentTypes.kt");
                }

                @Test
                @TestMetadata("divideByZero.kt")
                public void testDivideByZero() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/constantEvaluator/constant/divideByZero.kt");
                }

                @Test
                @TestMetadata("duplicateLabelWithNonTrivialCondition_disabled.kt")
                public void testDuplicateLabelWithNonTrivialCondition_disabled() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/constantEvaluator/constant/duplicateLabelWithNonTrivialCondition_disabled.kt");
                }

                @Test
                @TestMetadata("duplicateLabelWithNonTrivialCondition_enabled.kt")
                public void testDuplicateLabelWithNonTrivialCondition_enabled() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/constantEvaluator/constant/duplicateLabelWithNonTrivialCondition_enabled.kt");
                }

                @Test
                @TestMetadata("equals.kt")
                public void testEquals() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/constantEvaluator/constant/equals.kt");
                }

                @Test
                @TestMetadata("exceptionWhenEvaluate.kt")
                public void testExceptionWhenEvaluate() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/constantEvaluator/constant/exceptionWhenEvaluate.kt");
                }

                @Test
                @TestMetadata("finalProperty.kt")
                public void testFinalProperty() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/constantEvaluator/constant/finalProperty.kt");
                }

                @Test
                @TestMetadata("float.kt")
                public void testFloat() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/constantEvaluator/constant/float.kt");
                }

                @Test
                @TestMetadata("floatsAndDoubles.kt")
                public void testFloatsAndDoubles() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/constantEvaluator/constant/floatsAndDoubles.kt");
                }

                @Test
                @TestMetadata("integer.kt")
                public void testInteger() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/constantEvaluator/constant/integer.kt");
                }

                @Test
                @TestMetadata("integerOperations.kt")
                public void testIntegerOperations() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/constantEvaluator/constant/integerOperations.kt");
                }

                @Test
                @TestMetadata("integers.kt")
                public void testIntegers() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/constantEvaluator/constant/integers.kt");
                }

                @Test
                @TestMetadata("invAsCompileTimeCall.kt")
                public void testInvAsCompileTimeCall() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/constantEvaluator/constant/invAsCompileTimeCall.kt");
                }

                @Test
                @TestMetadata("localVal.kt")
                public void testLocalVal() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/constantEvaluator/constant/localVal.kt");
                }

                @Test
                @TestMetadata("localVar.kt")
                public void testLocalVar() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/constantEvaluator/constant/localVar.kt");
                }

                @Test
                @TestMetadata("nonFinalProperty.kt")
                public void testNonFinalProperty() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/constantEvaluator/constant/nonFinalProperty.kt");
                }

                @Test
                @TestMetadata("objectProperty.kt")
                public void testObjectProperty() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/constantEvaluator/constant/objectProperty.kt");
                }

                @Test
                @TestMetadata("strings.kt")
                public void testStrings() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/constantEvaluator/constant/strings.kt");
                }

                @Test
                @TestMetadata("topLevelVal.kt")
                public void testTopLevelVal() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/constantEvaluator/constant/topLevelVal.kt");
                }

                @Test
                @TestMetadata("topLevelVar.kt")
                public void testTopLevelVar() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/constantEvaluator/constant/topLevelVar.kt");
                }

                @Test
                @TestMetadata("unaryMinusIndepWoExpType.kt")
                public void testUnaryMinusIndepWoExpType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/constantEvaluator/constant/unaryMinusIndepWoExpType.kt");
                }

                @Test
                @TestMetadata("unaryMinusIndependentExpType.kt")
                public void testUnaryMinusIndependentExpType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/constantEvaluator/constant/unaryMinusIndependentExpType.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/constantEvaluator/isPure")
            @TestDataPath("$PROJECT_ROOT")
            public class IsPure {
                @Test
                public void testAllFilesPresentInIsPure() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/constantEvaluator/isPure"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("innerToType.kt")
                public void testInnerToType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/constantEvaluator/isPure/innerToType.kt");
                }

                @Test
                @TestMetadata("namedConstants.kt")
                public void testNamedConstants() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/constantEvaluator/isPure/namedConstants.kt");
                }

                @Test
                @TestMetadata("toType.kt")
                public void testToType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/constantEvaluator/isPure/toType.kt");
                }

                @Test
                @TestMetadata("unaryMinusIndepWoExpType.kt")
                public void testUnaryMinusIndepWoExpType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/constantEvaluator/isPure/unaryMinusIndepWoExpType.kt");
                }

                @Test
                @TestMetadata("unaryMinusIndependentExpType.kt")
                public void testUnaryMinusIndependentExpType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/constantEvaluator/isPure/unaryMinusIndependentExpType.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/constantEvaluator/usesVariableAsConstant")
            @TestDataPath("$PROJECT_ROOT")
            public class UsesVariableAsConstant {
                @Test
                public void testAllFilesPresentInUsesVariableAsConstant() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/constantEvaluator/usesVariableAsConstant"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("binaryTypes.kt")
                public void testBinaryTypes() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/constantEvaluator/usesVariableAsConstant/binaryTypes.kt");
                }

                @Test
                @TestMetadata("NamedConstants.kt")
                public void testNamedConstants() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/constantEvaluator/usesVariableAsConstant/NamedConstants.kt");
                }

                @Test
                @TestMetadata("OtherTypes.kt")
                public void testOtherTypes() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/constantEvaluator/usesVariableAsConstant/OtherTypes.kt");
                }

                @Test
                @TestMetadata("simpleTypes.kt")
                public void testSimpleTypes() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/constantEvaluator/usesVariableAsConstant/simpleTypes.kt");
                }
            }
        }

        @Nested
        @TestMetadata("compiler/testData/diagnostics/tests/constructorConsistency")
        @TestDataPath("$PROJECT_ROOT")
        public class ConstructorConsistency {
            @Test
            @TestMetadata("afterInitialization.kt")
            public void testAfterInitialization() throws Exception {
                runTest("compiler/testData/diagnostics/tests/constructorConsistency/afterInitialization.kt");
            }

            @Test
            @TestMetadata("aliencall.kt")
            public void testAliencall() throws Exception {
                runTest("compiler/testData/diagnostics/tests/constructorConsistency/aliencall.kt");
            }

            @Test
            public void testAllFilesPresentInConstructorConsistency() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/constructorConsistency"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
            }

            @Test
            @TestMetadata("assignment.kt")
            public void testAssignment() throws Exception {
                runTest("compiler/testData/diagnostics/tests/constructorConsistency/assignment.kt");
            }

            @Test
            @TestMetadata("backing.kt")
            public void testBacking() throws Exception {
                runTest("compiler/testData/diagnostics/tests/constructorConsistency/backing.kt");
            }

            @Test
            @TestMetadata("basic.kt")
            public void testBasic() throws Exception {
                runTest("compiler/testData/diagnostics/tests/constructorConsistency/basic.kt");
            }

            @Test
            @TestMetadata("companion.kt")
            public void testCompanion() throws Exception {
                runTest("compiler/testData/diagnostics/tests/constructorConsistency/companion.kt");
            }

            @Test
            @TestMetadata("comparison.kt")
            public void testComparison() throws Exception {
                runTest("compiler/testData/diagnostics/tests/constructorConsistency/comparison.kt");
            }

            @Test
            @TestMetadata("delegate.kt")
            public void testDelegate() throws Exception {
                runTest("compiler/testData/diagnostics/tests/constructorConsistency/delegate.kt");
            }

            @Test
            @TestMetadata("derived.kt")
            public void testDerived() throws Exception {
                runTest("compiler/testData/diagnostics/tests/constructorConsistency/derived.kt");
            }

            @Test
            @TestMetadata("derivedProperty.kt")
            public void testDerivedProperty() throws Exception {
                runTest("compiler/testData/diagnostics/tests/constructorConsistency/derivedProperty.kt");
            }

            @Test
            @TestMetadata("getset.kt")
            public void testGetset() throws Exception {
                runTest("compiler/testData/diagnostics/tests/constructorConsistency/getset.kt");
            }

            @Test
            @TestMetadata("init.kt")
            public void testInit() throws Exception {
                runTest("compiler/testData/diagnostics/tests/constructorConsistency/init.kt");
            }

            @Test
            @TestMetadata("initializerWithSecondaryConstructor.kt")
            public void testInitializerWithSecondaryConstructor() throws Exception {
                runTest("compiler/testData/diagnostics/tests/constructorConsistency/initializerWithSecondaryConstructor.kt");
            }

            @Test
            @TestMetadata("initwithgetter.kt")
            public void testInitwithgetter() throws Exception {
                runTest("compiler/testData/diagnostics/tests/constructorConsistency/initwithgetter.kt");
            }

            @Test
            @TestMetadata("inspection.kt")
            public void testInspection() throws Exception {
                runTest("compiler/testData/diagnostics/tests/constructorConsistency/inspection.kt");
            }

            @Test
            @TestMetadata("lambdaInObject.kt")
            public void testLambdaInObject() throws Exception {
                runTest("compiler/testData/diagnostics/tests/constructorConsistency/lambdaInObject.kt");
            }

            @Test
            @TestMetadata("lateInit.kt")
            public void testLateInit() throws Exception {
                runTest("compiler/testData/diagnostics/tests/constructorConsistency/lateInit.kt");
            }

            @Test
            @TestMetadata("localObject.kt")
            public void testLocalObject() throws Exception {
                runTest("compiler/testData/diagnostics/tests/constructorConsistency/localObject.kt");
            }

            @Test
            @TestMetadata("multipleAreNull.kt")
            public void testMultipleAreNull() throws Exception {
                runTest("compiler/testData/diagnostics/tests/constructorConsistency/multipleAreNull.kt");
            }

            @Test
            @TestMetadata("nobacking.kt")
            public void testNobacking() throws Exception {
                runTest("compiler/testData/diagnostics/tests/constructorConsistency/nobacking.kt");
            }

            @Test
            @TestMetadata("open.kt")
            public void testOpen() throws Exception {
                runTest("compiler/testData/diagnostics/tests/constructorConsistency/open.kt");
            }

            @Test
            @TestMetadata("openProperty.kt")
            public void testOpenProperty() throws Exception {
                runTest("compiler/testData/diagnostics/tests/constructorConsistency/openProperty.kt");
            }

            @Test
            @TestMetadata("outer.kt")
            public void testOuter() throws Exception {
                runTest("compiler/testData/diagnostics/tests/constructorConsistency/outer.kt");
            }

            @Test
            @TestMetadata("property.kt")
            public void testProperty() throws Exception {
                runTest("compiler/testData/diagnostics/tests/constructorConsistency/property.kt");
            }

            @Test
            @TestMetadata("propertyAccess.kt")
            public void testPropertyAccess() throws Exception {
                runTest("compiler/testData/diagnostics/tests/constructorConsistency/propertyAccess.kt");
            }

            @Test
            @TestMetadata("twoSecondaryConstructors.kt")
            public void testTwoSecondaryConstructors() throws Exception {
                runTest("compiler/testData/diagnostics/tests/constructorConsistency/twoSecondaryConstructors.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis")
        @TestDataPath("$PROJECT_ROOT")
        public class ControlFlowAnalysis {
            @Test
            @TestMetadata("accessValueParameterInDefaultValue_after.kt")
            public void testAccessValueParameterInDefaultValue_after() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/accessValueParameterInDefaultValue_after.kt");
            }

            @Test
            @TestMetadata("accessValueParameterInDefaultValue_before.kt")
            public void testAccessValueParameterInDefaultValue_before() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/accessValueParameterInDefaultValue_before.kt");
            }

            @Test
            public void testAllFilesPresentInControlFlowAnalysis() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/controlFlowAnalysis"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
            }

            @Test
            @TestMetadata("assignedInFinally.kt")
            public void testAssignedInFinally() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/assignedInFinally.kt");
            }

            @Test
            @TestMetadata("assignedInIfElse.kt")
            public void testAssignedInIfElse() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/assignedInIfElse.kt");
            }

            @Test
            @TestMetadata("assignedInTryWithCatch.kt")
            public void testAssignedInTryWithCatch() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/assignedInTryWithCatch.kt");
            }

            @Test
            @TestMetadata("assignedInTryWithoutCatch.kt")
            public void testAssignedInTryWithoutCatch() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/assignedInTryWithoutCatch.kt");
            }

            @Test
            @TestMetadata("assignmentInLocalsInConstructor.kt")
            public void testAssignmentInLocalsInConstructor() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/assignmentInLocalsInConstructor.kt");
            }

            @Test
            @TestMetadata("backingFieldInsideGetter_after.kt")
            public void testBackingFieldInsideGetter_after() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/backingFieldInsideGetter_after.kt");
            }

            @Test
            @TestMetadata("backingFieldInsideGetter_before.kt")
            public void testBackingFieldInsideGetter_before() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/backingFieldInsideGetter_before.kt");
            }

            @Test
            @TestMetadata("breakContinueInTryFinally.kt")
            public void testBreakContinueInTryFinally() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/breakContinueInTryFinally.kt");
            }

            @Test
            @TestMetadata("breakContinueInTryFinallyInLoop.kt")
            public void testBreakContinueInTryFinallyInLoop() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/breakContinueInTryFinallyInLoop.kt");
            }

            @Test
            @TestMetadata("breakInsideLocal.kt")
            public void testBreakInsideLocal() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/breakInsideLocal.kt");
            }

            @Test
            @TestMetadata("breakOrContinueInLoopCondition.kt")
            public void testBreakOrContinueInLoopCondition() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/breakOrContinueInLoopCondition.kt");
            }

            @Test
            @TestMetadata("checkInnerLocalDeclarations.kt")
            public void testCheckInnerLocalDeclarations() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/checkInnerLocalDeclarations.kt");
            }

            @Test
            @TestMetadata("checkPropertyAccessor.kt")
            public void testCheckPropertyAccessor() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/checkPropertyAccessor.kt");
            }

            @Test
            @TestMetadata("constructorPropertyInterdependence.kt")
            public void testConstructorPropertyInterdependence() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/constructorPropertyInterdependence.kt");
            }

            @Test
            @TestMetadata("definiteReturnInWhen.kt")
            public void testDefiniteReturnInWhen() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/definiteReturnInWhen.kt");
            }

            @Test
            @TestMetadata("delegatedPropertyEarlyAccess.kt")
            public void testDelegatedPropertyEarlyAccess() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/delegatedPropertyEarlyAccess.kt");
            }

            @Test
            @TestMetadata("doWhileAssignment.kt")
            public void testDoWhileAssignment() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/doWhileAssignment.kt");
            }

            @Test
            @TestMetadata("doWhileNotDefined.kt")
            public void testDoWhileNotDefined() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/doWhileNotDefined.kt");
            }

            @Test
            @TestMetadata("elvisNotProcessed.kt")
            public void testElvisNotProcessed() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/elvisNotProcessed.kt");
            }

            @Test
            @TestMetadata("enumCompanionInterdependence.kt")
            public void testEnumCompanionInterdependence() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/enumCompanionInterdependence.kt");
            }

            @Test
            @TestMetadata("enumInterdependence.kt")
            public void testEnumInterdependence() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/enumInterdependence.kt");
            }

            @Test
            @TestMetadata("fieldAsClassDelegate.kt")
            public void testFieldAsClassDelegate() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/fieldAsClassDelegate.kt");
            }

            @Test
            @TestMetadata("fieldInitialization.kt")
            public void testFieldInitialization() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/fieldInitialization.kt");
            }

            @Test
            @TestMetadata("infiniteLoops.kt")
            public void testInfiniteLoops() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/infiniteLoops.kt");
            }

            @Test
            @TestMetadata("initializationInLambda.kt")
            public void testInitializationInLambda() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/initializationInLambda.kt");
            }

            @Test
            @TestMetadata("initializationInLocalClass.kt")
            public void testInitializationInLocalClass() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/initializationInLocalClass.kt");
            }

            @Test
            @TestMetadata("initializationInLocalFun.kt")
            public void testInitializationInLocalFun() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/initializationInLocalFun.kt");
            }

            @Test
            @TestMetadata("initializationInLocalViaExplicitThis_after.kt")
            public void testInitializationInLocalViaExplicitThis_after() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/initializationInLocalViaExplicitThis_after.kt");
            }

            @Test
            @TestMetadata("initializationInLocalViaExplicitThis_before.kt")
            public void testInitializationInLocalViaExplicitThis_before() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/initializationInLocalViaExplicitThis_before.kt");
            }

            @Test
            @TestMetadata("kt1001.kt")
            public void testKt1001() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt1001.kt");
            }

            @Test
            @TestMetadata("kt1027.kt")
            public void testKt1027() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt1027.kt");
            }

            @Test
            @TestMetadata("kt1066.kt")
            public void testKt1066() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt1066.kt");
            }

            @Test
            @TestMetadata("kt10805.kt")
            public void testKt10805() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt10805.kt");
            }

            @Test
            @TestMetadata("kt10823.kt")
            public void testKt10823() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt10823.kt");
            }

            @Test
            @TestMetadata("kt1156.kt")
            public void testKt1156() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt1156.kt");
            }

            @Test
            @TestMetadata("kt1185enums.kt")
            public void testKt1185enums() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt1185enums.kt");
            }

            @Test
            @TestMetadata("kt1189.kt")
            public void testKt1189() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt1189.kt");
            }

            @Test
            @TestMetadata("kt1191.kt")
            public void testKt1191() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt1191.kt");
            }

            @Test
            @TestMetadata("kt1219.1301.kt")
            public void testKt1219_1301() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt1219.1301.kt");
            }

            @Test
            @TestMetadata("kt1571.kt")
            public void testKt1571() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt1571.kt");
            }

            @Test
            @TestMetadata("kt1977.kt")
            public void testKt1977() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt1977.kt");
            }

            @Test
            @TestMetadata("kt2166_kt2103.kt")
            public void testKt2166_kt2103() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt2166_kt2103.kt");
            }

            @Test
            @TestMetadata("kt2226.kt")
            public void testKt2226() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt2226.kt");
            }

            @Test
            @TestMetadata("kt2330.kt")
            public void testKt2330() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt2330.kt");
            }

            @Test
            @TestMetadata("kt2334.kt")
            public void testKt2334() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt2334.kt");
            }

            @Test
            @TestMetadata("kt2369.kt")
            public void testKt2369() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt2369.kt");
            }

            @Test
            @TestMetadata("kt2845.kt")
            public void testKt2845() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt2845.kt");
            }

            @Test
            @TestMetadata("kt2960.kt")
            public void testKt2960() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt2960.kt");
            }

            @Test
            @TestMetadata("kt2972.kt")
            public void testKt2972() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt2972.kt");
            }

            @Test
            @TestMetadata("kt3444.kt")
            public void testKt3444() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt3444.kt");
            }

            @Test
            @TestMetadata("kt3501.kt")
            public void testKt3501() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt3501.kt");
            }

            @Test
            @TestMetadata("kt4126.kt")
            public void testKt4126() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt4126.kt");
            }

            @Test
            @TestMetadata("kt4405.kt")
            public void testKt4405() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt4405.kt");
            }

            @Test
            @TestMetadata("kt510.kt")
            public void testKt510() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt510.kt");
            }

            @Test
            @TestMetadata("kt52131.kt")
            public void testKt52131() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt52131.kt");
            }

            @Test
            @TestMetadata("kt607.kt")
            public void testKt607() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt607.kt");
            }

            @Test
            @TestMetadata("kt609.kt")
            public void testKt609() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt609.kt");
            }

            @Test
            @TestMetadata("kt610.kt")
            public void testKt610() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt610.kt");
            }

            @Test
            @TestMetadata("kt6788.kt")
            public void testKt6788() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt6788.kt");
            }

            @Test
            @TestMetadata("kt776.kt")
            public void testKt776() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt776.kt");
            }

            @Test
            @TestMetadata("kt843.kt")
            public void testKt843() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt843.kt");
            }

            @Test
            @TestMetadata("kt897.kt")
            public void testKt897() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/kt897.kt");
            }

            @Test
            @TestMetadata("localClasses.kt")
            public void testLocalClasses() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/localClasses.kt");
            }

            @Test
            @TestMetadata("localObjectInConstructor.kt")
            public void testLocalObjectInConstructor() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/localObjectInConstructor.kt");
            }

            @Test
            @TestMetadata("loopWithNonTrivialBooleanConst_error.kt")
            public void testLoopWithNonTrivialBooleanConst_error() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/loopWithNonTrivialBooleanConst_error.kt");
            }

            @Test
            @TestMetadata("loopWithNonTrivialBooleanConst_warning.kt")
            public void testLoopWithNonTrivialBooleanConst_warning() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/loopWithNonTrivialBooleanConst_warning.kt");
            }

            @Test
            @TestMetadata("mainWithWarningOnUnusedParam.kt")
            public void testMainWithWarningOnUnusedParam() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/mainWithWarningOnUnusedParam.kt");
            }

            @Test
            @TestMetadata("mainWithoutWarningOnUnusedParam.kt")
            public void testMainWithoutWarningOnUnusedParam() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/mainWithoutWarningOnUnusedParam.kt");
            }

            @Test
            @TestMetadata("nestedTryFinally.kt")
            public void testNestedTryFinally() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/nestedTryFinally.kt");
            }

            @Test
            @TestMetadata("nonLocalReturnUnreachable.kt")
            public void testNonLocalReturnUnreachable() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/nonLocalReturnUnreachable.kt");
            }

            @Test
            @TestMetadata("nonLocalReturnWithFinally.kt")
            public void testNonLocalReturnWithFinally() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/nonLocalReturnWithFinally.kt");
            }

            @Test
            @TestMetadata("privateSetter.kt")
            public void testPrivateSetter() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/privateSetter.kt");
            }

            @Test
            @TestMetadata("propertiesInitWithOtherInstance.kt")
            public void testPropertiesInitWithOtherInstance() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/propertiesInitWithOtherInstance.kt");
            }

            @Test
            @TestMetadata("propertiesInitWithOtherInstanceInner.kt")
            public void testPropertiesInitWithOtherInstanceInner() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/propertiesInitWithOtherInstanceInner.kt");
            }

            @Test
            @TestMetadata("propertiesInitWithOtherInstanceThisLabel.kt")
            public void testPropertiesInitWithOtherInstanceThisLabel() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/propertiesInitWithOtherInstanceThisLabel.kt");
            }

            @Test
            @TestMetadata("propertiesOrderInPackage.kt")
            public void testPropertiesOrderInPackage() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/propertiesOrderInPackage.kt");
            }

            @Test
            @TestMetadata("reassignmentInTryCatch.kt")
            public void testReassignmentInTryCatch() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/reassignmentInTryCatch.kt");
            }

            @Test
            @TestMetadata("reassignmentInTryCatchWithJumps.kt")
            public void testReassignmentInTryCatchWithJumps() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/reassignmentInTryCatchWithJumps.kt");
            }

            @Test
            @TestMetadata("referenceToPropertyInitializer.kt")
            public void testReferenceToPropertyInitializer() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/referenceToPropertyInitializer.kt");
            }

            @Test
            @TestMetadata("repeatUnitializedErrorOnlyForLocalVars.kt")
            public void testRepeatUnitializedErrorOnlyForLocalVars() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/repeatUnitializedErrorOnlyForLocalVars.kt");
            }

            @Test
            @TestMetadata("scopeOfAnonymousInitializer.kt")
            public void testScopeOfAnonymousInitializer() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/scopeOfAnonymousInitializer.kt");
            }

            @Test
            @TestMetadata("throwInLambda.kt")
            public void testThrowInLambda() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/throwInLambda.kt");
            }

            @Test
            @TestMetadata("tryWithAssignmentUsedInCatch.kt")
            public void testTryWithAssignmentUsedInCatch() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/tryWithAssignmentUsedInCatch.kt");
            }

            @Test
            @TestMetadata("uninitializedCompanionOfEnum_after.kt")
            public void testUninitializedCompanionOfEnum_after() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/uninitializedCompanionOfEnum_after.kt");
            }

            @Test
            @TestMetadata("uninitializedCompanionOfEnum_before.kt")
            public void testUninitializedCompanionOfEnum_before() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/uninitializedCompanionOfEnum_before.kt");
            }

            @Test
            @TestMetadata("UninitializedEnumCompanionVals.kt")
            public void testUninitializedEnumCompanionVals() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/UninitializedEnumCompanionVals.kt");
            }

            @Test
            @TestMetadata("uninitializedInLocalDeclarations.kt")
            public void testUninitializedInLocalDeclarations() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/uninitializedInLocalDeclarations.kt");
            }

            @Test
            @TestMetadata("UninitializedOrReassignedVariables.kt")
            public void testUninitializedOrReassignedVariables() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/UninitializedOrReassignedVariables.kt");
            }

            @Test
            @TestMetadata("uninitializedQualifiedEnumEntry.kt")
            public void testUninitializedQualifiedEnumEntry() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/uninitializedQualifiedEnumEntry.kt");
            }

            @Test
            @TestMetadata("unmappedArgs.kt")
            public void testUnmappedArgs() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/unmappedArgs.kt");
            }

            @Test
            @TestMetadata("unresolvedReference.kt")
            public void testUnresolvedReference() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/unresolvedReference.kt");
            }

            @Test
            @TestMetadata("useUninitializedInLambda.kt")
            public void testUseUninitializedInLambda() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/useUninitializedInLambda.kt");
            }

            @Test
            @TestMetadata("varInitializationInIfInCycle.kt")
            public void testVarInitializationInIfInCycle() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/varInitializationInIfInCycle.kt");
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode")
            @TestDataPath("$PROJECT_ROOT")
            public class DeadCode {
                @Test
                public void testAllFilesPresentInDeadCode() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("commasAndWhitespaces.kt")
                public void testCommasAndWhitespaces() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/commasAndWhitespaces.kt");
                }

                @Test
                @TestMetadata("commentsInDeadCode.kt")
                public void testCommentsInDeadCode() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/commentsInDeadCode.kt");
                }

                @Test
                @TestMetadata("deadCallInInvokeCall.kt")
                public void testDeadCallInInvokeCall() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/deadCallInInvokeCall.kt");
                }

                @Test
                @TestMetadata("deadCallInReceiver.kt")
                public void testDeadCallInReceiver() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/deadCallInReceiver.kt");
                }

                @Test
                @TestMetadata("deadCodeDifferentExamples.kt")
                public void testDeadCodeDifferentExamples() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/deadCodeDifferentExamples.kt");
                }

                @Test
                @TestMetadata("deadCodeFromDifferentSources.kt")
                public void testDeadCodeFromDifferentSources() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/deadCodeFromDifferentSources.kt");
                }

                @Test
                @TestMetadata("deadCodeInArrayAccess.kt")
                public void testDeadCodeInArrayAccess() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/deadCodeInArrayAccess.kt");
                }

                @Test
                @TestMetadata("deadCodeInAssignment.kt")
                public void testDeadCodeInAssignment() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/deadCodeInAssignment.kt");
                }

                @Test
                @TestMetadata("deadCodeInBinaryExpressions.kt")
                public void testDeadCodeInBinaryExpressions() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/deadCodeInBinaryExpressions.kt");
                }

                @Test
                @TestMetadata("deadCodeInCalls.kt")
                public void testDeadCodeInCalls() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/deadCodeInCalls.kt");
                }

                @Test
                @TestMetadata("deadCodeInDeadCode.kt")
                public void testDeadCodeInDeadCode() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/deadCodeInDeadCode.kt");
                }

                @Test
                @TestMetadata("deadCodeInIf.kt")
                public void testDeadCodeInIf() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/deadCodeInIf.kt");
                }

                @Test
                @TestMetadata("deadCodeInInnerExpressions.kt")
                public void testDeadCodeInInnerExpressions() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/deadCodeInInnerExpressions.kt");
                }

                @Test
                @TestMetadata("deadCodeInLocalDeclarations.kt")
                public void testDeadCodeInLocalDeclarations() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/deadCodeInLocalDeclarations.kt");
                }

                @Test
                @TestMetadata("deadCodeInLoops.kt")
                public void testDeadCodeInLoops() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/deadCodeInLoops.kt");
                }

                @Test
                @TestMetadata("deadCodeInReturn.kt")
                public void testDeadCodeInReturn() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/deadCodeInReturn.kt");
                }

                @Test
                @TestMetadata("deadCodeInUnaryExpr.kt")
                public void testDeadCodeInUnaryExpr() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/deadCodeInUnaryExpr.kt");
                }

                @Test
                @TestMetadata("deadCodeInWhileFromBreak.kt")
                public void testDeadCodeInWhileFromBreak() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/deadCodeInWhileFromBreak.kt");
                }

                @Test
                @TestMetadata("expressionInUnitLiteral.kt")
                public void testExpressionInUnitLiteral() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/expressionInUnitLiteral.kt");
                }

                @Test
                @TestMetadata("kt2585_1.kt")
                public void testKt2585_1() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/kt2585_1.kt");
                }

                @Test
                @TestMetadata("kt2585_2.kt")
                public void testKt2585_2() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/kt2585_2.kt");
                }

                @Test
                @TestMetadata("kt2585_3.kt")
                public void testKt2585_3() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/kt2585_3.kt");
                }

                @Test
                @TestMetadata("kt3162tryAsInitializer.kt")
                public void testKt3162tryAsInitializer() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/kt3162tryAsInitializer.kt");
                }

                @Test
                @TestMetadata("kt5200DeadCodeInLambdas.kt")
                public void testKt5200DeadCodeInLambdas() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/kt5200DeadCodeInLambdas.kt");
                }

                @Test
                @TestMetadata("returnInDeadLambda.kt")
                public void testReturnInDeadLambda() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/deadCode/returnInDeadLambda.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/definiteReturn")
            @TestDataPath("$PROJECT_ROOT")
            public class DefiniteReturn {
                @Test
                public void testAllFilesPresentInDefiniteReturn() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/controlFlowAnalysis/definiteReturn"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("kt3444_ReturnFromLocalFunctions.kt")
                public void testKt3444_ReturnFromLocalFunctions() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/definiteReturn/kt3444_ReturnFromLocalFunctions.kt");
                }

                @Test
                @TestMetadata("kt4034.kt")
                public void testKt4034() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/definiteReturn/kt4034.kt");
                }

                @Test
                @TestMetadata("lambdaInTryFalsePositive.kt")
                public void testLambdaInTryFalsePositive() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/definiteReturn/lambdaInTryFalsePositive.kt");
                }

                @Test
                @TestMetadata("ReturnFromFunctionInObject.kt")
                public void testReturnFromFunctionInObject() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/definiteReturn/ReturnFromFunctionInObject.kt");
                }

                @Test
                @TestMetadata("simpleClass.kt")
                public void testSimpleClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/definiteReturn/simpleClass.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/controlFlowAnalysis/unnecessaryLateinit")
            @TestDataPath("$PROJECT_ROOT")
            public class UnnecessaryLateinit {
                @Test
                public void testAllFilesPresentInUnnecessaryLateinit() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/controlFlowAnalysis/unnecessaryLateinit"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("lateinitRecursiveInLambda.kt")
                public void testLateinitRecursiveInLambda() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/unnecessaryLateinit/lateinitRecursiveInLambda.kt");
                }

                @Test
                @TestMetadata("lateinitWithConstructor.kt")
                public void testLateinitWithConstructor() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/unnecessaryLateinit/lateinitWithConstructor.kt");
                }

                @Test
                @TestMetadata("lateinitWithErroneousDelegation.kt")
                public void testLateinitWithErroneousDelegation() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/unnecessaryLateinit/lateinitWithErroneousDelegation.kt");
                }

                @Test
                @TestMetadata("lateinitWithInit.kt")
                public void testLateinitWithInit() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/unnecessaryLateinit/lateinitWithInit.kt");
                }

                @Test
                @TestMetadata("lateinitWithMultipleConstructors.kt")
                public void testLateinitWithMultipleConstructors() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/unnecessaryLateinit/lateinitWithMultipleConstructors.kt");
                }

                @Test
                @TestMetadata("lateinitWithMultipleConstructorsAndDelegation.kt")
                public void testLateinitWithMultipleConstructorsAndDelegation() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/unnecessaryLateinit/lateinitWithMultipleConstructorsAndDelegation.kt");
                }

                @Test
                @TestMetadata("lateinitWithPlusAssign.kt")
                public void testLateinitWithPlusAssign() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/unnecessaryLateinit/lateinitWithPlusAssign.kt");
                }

                @Test
                @TestMetadata("lateinitWithPrimaryConstructorAndConstructor.kt")
                public void testLateinitWithPrimaryConstructorAndConstructor() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/unnecessaryLateinit/lateinitWithPrimaryConstructorAndConstructor.kt");
                }

                @Test
                @TestMetadata("normalLateinit.kt")
                public void testNormalLateinit() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/unnecessaryLateinit/normalLateinit.kt");
                }

                @Test
                @TestMetadata("normalLateinitWithTwoConstructors.kt")
                public void testNormalLateinitWithTwoConstructors() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/unnecessaryLateinit/normalLateinitWithTwoConstructors.kt");
                }

                @Test
                @TestMetadata("secondaryConstructorDelegateItself.kt")
                public void testSecondaryConstructorDelegateItself() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/unnecessaryLateinit/secondaryConstructorDelegateItself.kt");
                }

                @Test
                @TestMetadata("secondaryConstructorDelegateLoop.kt")
                public void testSecondaryConstructorDelegateLoop() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/controlFlowAnalysis/unnecessaryLateinit/secondaryConstructorDelegateLoop.kt");
                }
            }
        }

        @Nested
        @TestMetadata("compiler/testData/diagnostics/tests/controlStructures")
        @TestDataPath("$PROJECT_ROOT")
        public class ControlStructures {
            @Test
            public void testAllFilesPresentInControlStructures() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/controlStructures"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
            }

            @Test
            @TestMetadata("breakToLabel.kt")
            public void testBreakToLabel() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlStructures/breakToLabel.kt");
            }

            @Test
            @TestMetadata("catchGenerics.kt")
            public void testCatchGenerics() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlStructures/catchGenerics.kt");
            }

            @Test
            @TestMetadata("catchInnerClassesOfGenerics.kt")
            public void testCatchInnerClassesOfGenerics() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlStructures/catchInnerClassesOfGenerics.kt");
            }

            @Test
            @TestMetadata("catchInnerClassesOfGenerics_deprecation.kt")
            public void testCatchInnerClassesOfGenerics_deprecation() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlStructures/catchInnerClassesOfGenerics_deprecation.kt");
            }

            @Test
            @TestMetadata("catchWithDefault.kt")
            public void testCatchWithDefault() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlStructures/catchWithDefault.kt");
            }

            @Test
            @TestMetadata("catchingLocalClassesCapturingTypeParameters.kt")
            public void testCatchingLocalClassesCapturingTypeParameters() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlStructures/catchingLocalClassesCapturingTypeParameters.kt");
            }

            @Test
            @TestMetadata("commonSupertypeOfT.kt")
            public void testCommonSupertypeOfT() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlStructures/commonSupertypeOfT.kt");
            }

            @Test
            @TestMetadata("continueAndBreakLabelWithSameFunctionName.kt")
            public void testContinueAndBreakLabelWithSameFunctionName() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlStructures/continueAndBreakLabelWithSameFunctionName.kt");
            }

            @Test
            @TestMetadata("emptyIf.kt")
            public void testEmptyIf() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlStructures/emptyIf.kt");
            }

            @Test
            @TestMetadata("ForLoopWithExtensionIteratorOnNullable.kt")
            public void testForLoopWithExtensionIteratorOnNullable() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlStructures/ForLoopWithExtensionIteratorOnNullable.kt");
            }

            @Test
            @TestMetadata("forLoopWithNullableRange.kt")
            public void testForLoopWithNullableRange() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlStructures/forLoopWithNullableRange.kt");
            }

            @Test
            @TestMetadata("forWithNullableIterator.kt")
            public void testForWithNullableIterator() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlStructures/forWithNullableIterator.kt");
            }

            @Test
            @TestMetadata("ForWithoutBraces.kt")
            public void testForWithoutBraces() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlStructures/ForWithoutBraces.kt");
            }

            @Test
            @TestMetadata("ForbidStatementAsDirectFunctionBody.kt")
            public void testForbidStatementAsDirectFunctionBody() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlStructures/ForbidStatementAsDirectFunctionBody.kt");
            }

            @Test
            @TestMetadata("ifElseIntersection.kt")
            public void testIfElseIntersection() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlStructures/ifElseIntersection.kt");
            }

            @Test
            @TestMetadata("ifInResultOfLambda.kt")
            public void testIfInResultOfLambda() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlStructures/ifInResultOfLambda.kt");
            }

            @Test
            @TestMetadata("ifToAnyDiscriminatingUsages.kt")
            public void testIfToAnyDiscriminatingUsages() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlStructures/ifToAnyDiscriminatingUsages.kt");
            }

            @Test
            @TestMetadata("ifWhenToAnyComplexExpressions.kt")
            public void testIfWhenToAnyComplexExpressions() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlStructures/ifWhenToAnyComplexExpressions.kt");
            }

            @Test
            @TestMetadata("ifWhenWithoutElse.kt")
            public void testIfWhenWithoutElse() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlStructures/ifWhenWithoutElse.kt");
            }

            @Test
            @TestMetadata("improperElseInExpression.kt")
            public void testImproperElseInExpression() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlStructures/improperElseInExpression.kt");
            }

            @Test
            @TestMetadata("jumpAcrossFunctionBoundary.kt")
            public void testJumpAcrossFunctionBoundary() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlStructures/jumpAcrossFunctionBoundary.kt");
            }

            @Test
            @TestMetadata("kt10322.kt")
            public void testKt10322() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlStructures/kt10322.kt");
            }

            @Test
            @TestMetadata("kt10706.kt")
            public void testKt10706() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlStructures/kt10706.kt");
            }

            @Test
            @TestMetadata("kt10717.kt")
            public void testKt10717() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlStructures/kt10717.kt");
            }

            @Test
            @TestMetadata("kt1075.kt")
            public void testKt1075() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlStructures/kt1075.kt");
            }

            @Test
            @TestMetadata("kt30406.kt")
            public void testKt30406() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlStructures/kt30406.kt");
            }

            @Test
            @TestMetadata("kt4310.kt")
            public void testKt4310() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlStructures/kt4310.kt");
            }

            @Test
            @TestMetadata("kt51711.kt")
            public void testKt51711() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlStructures/kt51711.kt");
            }

            @Test
            @TestMetadata("kt657.kt")
            public void testKt657() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlStructures/kt657.kt");
            }

            @Test
            @TestMetadata("kt770.kt351.kt735_StatementType.kt")
            public void testKt770_kt351_kt735_StatementType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlStructures/kt770.kt351.kt735_StatementType.kt");
            }

            @Test
            @TestMetadata("kt786.kt")
            public void testKt786() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlStructures/kt786.kt");
            }

            @Test
            @TestMetadata("kt799.kt")
            public void testKt799() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlStructures/kt799.kt");
            }

            @Test
            @TestMetadata("lambdasInExclExclAndElvis.kt")
            public void testLambdasInExclExclAndElvis() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlStructures/lambdasInExclExclAndElvis.kt");
            }

            @Test
            @TestMetadata("localReturnInsidePropertyAccessor.kt")
            public void testLocalReturnInsidePropertyAccessor() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlStructures/localReturnInsidePropertyAccessor.kt");
            }

            @Test
            @TestMetadata("nestedLoopsWithMultipleLabels.kt")
            public void testNestedLoopsWithMultipleLabels() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlStructures/nestedLoopsWithMultipleLabels.kt");
            }

            @Test
            @TestMetadata("nonExhaustiveIfInElvis_after.kt")
            public void testNonExhaustiveIfInElvis_after() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlStructures/nonExhaustiveIfInElvis_after.kt");
            }

            @Test
            @TestMetadata("nonExhaustiveIfInElvis_before.kt")
            public void testNonExhaustiveIfInElvis_before() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlStructures/nonExhaustiveIfInElvis_before.kt");
            }

            @Test
            @TestMetadata("notAFunctionLabel_after.kt")
            public void testNotAFunctionLabel_after() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlStructures/notAFunctionLabel_after.kt");
            }

            @Test
            @TestMetadata("notAFunctionLabel_before.kt")
            public void testNotAFunctionLabel_before() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlStructures/notAFunctionLabel_before.kt");
            }

            @Test
            @TestMetadata("redundantLabel.kt")
            public void testRedundantLabel() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlStructures/redundantLabel.kt");
            }

            @Test
            @TestMetadata("specialConstructsAndPlatformTypes.kt")
            public void testSpecialConstructsAndPlatformTypes() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlStructures/specialConstructsAndPlatformTypes.kt");
            }

            @Test
            @TestMetadata("specialConstructsWithNullableExpectedType.kt")
            public void testSpecialConstructsWithNullableExpectedType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlStructures/specialConstructsWithNullableExpectedType.kt");
            }

            @Test
            @TestMetadata("tryReturnType.kt")
            public void testTryReturnType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlStructures/tryReturnType.kt");
            }

            @Test
            @TestMetadata("typeInferenceForExclExcl.kt")
            public void testTypeInferenceForExclExcl() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlStructures/typeInferenceForExclExcl.kt");
            }

            @Test
            @TestMetadata("valVarCatchParameter.kt")
            public void testValVarCatchParameter() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlStructures/valVarCatchParameter.kt");
            }

            @Test
            @TestMetadata("valVarLoopParameter.kt")
            public void testValVarLoopParameter() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlStructures/valVarLoopParameter.kt");
            }

            @Test
            @TestMetadata("whenInResultOfLambda.kt")
            public void testWhenInResultOfLambda() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlStructures/whenInResultOfLambda.kt");
            }

            @Test
            @TestMetadata("whenToAnyDiscriminatingUsages.kt")
            public void testWhenToAnyDiscriminatingUsages() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlStructures/whenToAnyDiscriminatingUsages.kt");
            }

            @Test
            @TestMetadata("whenWithNothingTypedSubject.kt")
            public void testWhenWithNothingTypedSubject() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlStructures/whenWithNothingTypedSubject.kt");
            }

            @Test
            @TestMetadata("when.kt234.kt973.kt")
            public void testWhen_kt234_kt973() throws Exception {
                runTest("compiler/testData/diagnostics/tests/controlStructures/when.kt234.kt973.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/diagnostics/tests/coroutines")
        @TestDataPath("$PROJECT_ROOT")
        public class Coroutines {
            @Test
            public void testAllFilesPresentInCoroutines() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/coroutines"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
            }

            @Test
            @TestMetadata("modifierFormBuiltinSuspendFun.kt")
            public void testModifierFormBuiltinSuspendFun() throws Exception {
                runTest("compiler/testData/diagnostics/tests/coroutines/modifierFormBuiltinSuspendFun.kt");
            }

            @Test
            @TestMetadata("suspendInvokeInsideTry.kt")
            public void testSuspendInvokeInsideTry() throws Exception {
                runTest("compiler/testData/diagnostics/tests/coroutines/suspendInvokeInsideTry.kt");
            }

            @Test
            @TestMetadata("suspendInvokeInsideWhen.kt")
            public void testSuspendInvokeInsideWhen() throws Exception {
                runTest("compiler/testData/diagnostics/tests/coroutines/suspendInvokeInsideWhen.kt");
            }

            @Test
            @TestMetadata("suspendInvokeWithReceiver.kt")
            public void testSuspendInvokeWithReceiver() throws Exception {
                runTest("compiler/testData/diagnostics/tests/coroutines/suspendInvokeWithReceiver.kt");
            }

            @Test
            @TestMetadata("suspendLambdaFromExpectedType.kt")
            public void testSuspendLambdaFromExpectedType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/coroutines/suspendLambdaFromExpectedType.kt");
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/coroutines/callableReference")
            @TestDataPath("$PROJECT_ROOT")
            public class CallableReference {
                @Test
                public void testAllFilesPresentInCallableReference() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/coroutines/callableReference"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("invokeOutideSuspend.kt")
                public void testInvokeOutideSuspend() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/coroutines/callableReference/invokeOutideSuspend.kt");
                }

                @Test
                @TestMetadata("outsideSuspend.kt")
                public void testOutsideSuspend() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/coroutines/callableReference/outsideSuspend.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/coroutines/suspendFunctionAsSupertype")
            @TestDataPath("$PROJECT_ROOT")
            public class SuspendFunctionAsSupertype {
                @Test
                public void testAllFilesPresentInSuspendFunctionAsSupertype() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/coroutines/suspendFunctionAsSupertype"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Nested
                @TestMetadata("compiler/testData/diagnostics/tests/coroutines/suspendFunctionAsSupertype/kSuspendFunctionN")
                @TestDataPath("$PROJECT_ROOT")
                public class KSuspendFunctionN {
                    @Test
                    public void testAllFilesPresentInKSuspendFunctionN() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/coroutines/suspendFunctionAsSupertype/kSuspendFunctionN"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                    }

                    @Test
                    @TestMetadata("mixingSuspendAndNonSuspendSupertypes.kt")
                    public void testMixingSuspendAndNonSuspendSupertypes() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/coroutines/suspendFunctionAsSupertype/kSuspendFunctionN/mixingSuspendAndNonSuspendSupertypes.kt");
                    }

                    @Test
                    @TestMetadata("mixingSuspendAndNonSuspendSupertypesThruSuperClass.kt")
                    public void testMixingSuspendAndNonSuspendSupertypesThruSuperClass() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/coroutines/suspendFunctionAsSupertype/kSuspendFunctionN/mixingSuspendAndNonSuspendSupertypesThruSuperClass.kt");
                    }

                    @Test
                    @TestMetadata("mixingSuspendAndNonSuspendSupertypesThruSuperFunInterface.kt")
                    public void testMixingSuspendAndNonSuspendSupertypesThruSuperFunInterface() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/coroutines/suspendFunctionAsSupertype/kSuspendFunctionN/mixingSuspendAndNonSuspendSupertypesThruSuperFunInterface.kt");
                    }

                    @Test
                    @TestMetadata("mixingSuspendAndNonSuspendSupertypesThruSuperinterface.kt")
                    public void testMixingSuspendAndNonSuspendSupertypesThruSuperinterface() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/coroutines/suspendFunctionAsSupertype/kSuspendFunctionN/mixingSuspendAndNonSuspendSupertypesThruSuperinterface.kt");
                    }

                    @Test
                    @TestMetadata("simple.kt")
                    public void testSimple() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/coroutines/suspendFunctionAsSupertype/kSuspendFunctionN/simple.kt");
                    }
                }

                @Nested
                @TestMetadata("compiler/testData/diagnostics/tests/coroutines/suspendFunctionAsSupertype/simple")
                @TestDataPath("$PROJECT_ROOT")
                public class Simple {
                    @Test
                    public void testAllFilesPresentInSimple() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/coroutines/suspendFunctionAsSupertype/simple"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                    }

                    @Test
                    @TestMetadata("mixingSuspendAndNonSuspendSupertypes.kt")
                    public void testMixingSuspendAndNonSuspendSupertypes() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/coroutines/suspendFunctionAsSupertype/simple/mixingSuspendAndNonSuspendSupertypes.kt");
                    }

                    @Test
                    @TestMetadata("mixingSuspendAndNonSuspendSupertypesThruSuperClass.kt")
                    public void testMixingSuspendAndNonSuspendSupertypesThruSuperClass() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/coroutines/suspendFunctionAsSupertype/simple/mixingSuspendAndNonSuspendSupertypesThruSuperClass.kt");
                    }

                    @Test
                    @TestMetadata("mixingSuspendAndNonSuspendSupertypesThruSuperFunInterface.kt")
                    public void testMixingSuspendAndNonSuspendSupertypesThruSuperFunInterface() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/coroutines/suspendFunctionAsSupertype/simple/mixingSuspendAndNonSuspendSupertypesThruSuperFunInterface.kt");
                    }

                    @Test
                    @TestMetadata("mixingSuspendAndNonSuspendSupertypesThruSuperinterface.kt")
                    public void testMixingSuspendAndNonSuspendSupertypesThruSuperinterface() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/coroutines/suspendFunctionAsSupertype/simple/mixingSuspendAndNonSuspendSupertypesThruSuperinterface.kt");
                    }

                    @Test
                    @TestMetadata("simple.kt")
                    public void testSimple() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/coroutines/suspendFunctionAsSupertype/simple/simple.kt");
                    }
                }

                @Nested
                @TestMetadata("compiler/testData/diagnostics/tests/coroutines/suspendFunctionAsSupertype/suspendFunctionN")
                @TestDataPath("$PROJECT_ROOT")
                public class SuspendFunctionN {
                    @Test
                    public void testAllFilesPresentInSuspendFunctionN() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/coroutines/suspendFunctionAsSupertype/suspendFunctionN"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                    }

                    @Test
                    @TestMetadata("mixingSuspendAndNonSuspendSupertypes.kt")
                    public void testMixingSuspendAndNonSuspendSupertypes() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/coroutines/suspendFunctionAsSupertype/suspendFunctionN/mixingSuspendAndNonSuspendSupertypes.kt");
                    }

                    @Test
                    @TestMetadata("mixingSuspendAndNonSuspendSupertypesThruSuperClass.kt")
                    public void testMixingSuspendAndNonSuspendSupertypesThruSuperClass() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/coroutines/suspendFunctionAsSupertype/suspendFunctionN/mixingSuspendAndNonSuspendSupertypesThruSuperClass.kt");
                    }

                    @Test
                    @TestMetadata("mixingSuspendAndNonSuspendSupertypesThruSuperFunInterface.kt")
                    public void testMixingSuspendAndNonSuspendSupertypesThruSuperFunInterface() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/coroutines/suspendFunctionAsSupertype/suspendFunctionN/mixingSuspendAndNonSuspendSupertypesThruSuperFunInterface.kt");
                    }

                    @Test
                    @TestMetadata("mixingSuspendAndNonSuspendSupertypesThruSuperinterface.kt")
                    public void testMixingSuspendAndNonSuspendSupertypesThruSuperinterface() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/coroutines/suspendFunctionAsSupertype/suspendFunctionN/mixingSuspendAndNonSuspendSupertypesThruSuperinterface.kt");
                    }

                    @Test
                    @TestMetadata("simple.kt")
                    public void testSimple() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/coroutines/suspendFunctionAsSupertype/suspendFunctionN/simple.kt");
                    }
                }
            }
        }

        @Nested
        @TestMetadata("compiler/testData/diagnostics/tests/cyclicHierarchy")
        @TestDataPath("$PROJECT_ROOT")
        public class CyclicHierarchy {
            @Test
            public void testAllFilesPresentInCyclicHierarchy() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/cyclicHierarchy"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
            }

            @Test
            @TestMetadata("classIndirectlyInheritsNested.kt")
            public void testClassIndirectlyInheritsNested() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cyclicHierarchy/classIndirectlyInheritsNested.kt");
            }

            @Test
            @TestMetadata("classInheritsNested.kt")
            public void testClassInheritsNested() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cyclicHierarchy/classInheritsNested.kt");
            }

            @Test
            @TestMetadata("commonSupertypeForCyclicAndUsualTypes.kt")
            public void testCommonSupertypeForCyclicAndUsualTypes() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cyclicHierarchy/commonSupertypeForCyclicAndUsualTypes.kt");
            }

            @Test
            @TestMetadata("commonSupertypeForCyclicTypes.kt")
            public void testCommonSupertypeForCyclicTypes() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cyclicHierarchy/commonSupertypeForCyclicTypes.kt");
            }

            @Test
            @TestMetadata("cyclicHierarchy.kt")
            public void testCyclicHierarchy() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cyclicHierarchy/cyclicHierarchy.kt");
            }

            @Test
            @TestMetadata("javaJavaCycle.kt")
            public void testJavaJavaCycle() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cyclicHierarchy/javaJavaCycle.kt");
            }

            @Test
            @TestMetadata("javaJavaNested.kt")
            public void testJavaJavaNested() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cyclicHierarchy/javaJavaNested.kt");
            }

            @Test
            @TestMetadata("javaKotlinJavaCycle.kt")
            public void testJavaKotlinJavaCycle() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cyclicHierarchy/javaKotlinJavaCycle.kt");
            }

            @Test
            @TestMetadata("kotlinJavaCycle.kt")
            public void testKotlinJavaCycle() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cyclicHierarchy/kotlinJavaCycle.kt");
            }

            @Test
            @TestMetadata("kotlinJavaKotlinCycle.kt")
            public void testKotlinJavaKotlinCycle() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cyclicHierarchy/kotlinJavaKotlinCycle.kt");
            }

            @Test
            @TestMetadata("kotlinJavaNestedCycle.kt")
            public void testKotlinJavaNestedCycle() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cyclicHierarchy/kotlinJavaNestedCycle.kt");
            }

            @Test
            @TestMetadata("kt303.kt")
            public void testKt303() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cyclicHierarchy/kt303.kt");
            }

            @Test
            @TestMetadata("nestedClassInSuperClassParameter.kt")
            public void testNestedClassInSuperClassParameter() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cyclicHierarchy/nestedClassInSuperClassParameter.kt");
            }

            @Test
            @TestMetadata("objectInheritsNested.kt")
            public void testObjectInheritsNested() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cyclicHierarchy/objectInheritsNested.kt");
            }

            @Test
            @TestMetadata("twoClassesWithNestedCycle.kt")
            public void testTwoClassesWithNestedCycle() throws Exception {
                runTest("compiler/testData/diagnostics/tests/cyclicHierarchy/twoClassesWithNestedCycle.kt");
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/cyclicHierarchy/withCompanion")
            @TestDataPath("$PROJECT_ROOT")
            public class WithCompanion {
                @Test
                public void testAllFilesPresentInWithCompanion() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/cyclicHierarchy/withCompanion"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("everythingInOneScope_after.kt")
                public void testEverythingInOneScope_after() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/cyclicHierarchy/withCompanion/everythingInOneScope_after.kt");
                }

                @Test
                @TestMetadata("everythingInOneScope_before.kt")
                public void testEverythingInOneScope_before() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/cyclicHierarchy/withCompanion/everythingInOneScope_before.kt");
                }

                @Test
                @TestMetadata("noMembers_after.kt")
                public void testNoMembers_after() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/cyclicHierarchy/withCompanion/noMembers_after.kt");
                }

                @Test
                @TestMetadata("noMembers_before.kt")
                public void testNoMembers_before() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/cyclicHierarchy/withCompanion/noMembers_before.kt");
                }

                @Test
                @TestMetadata("onlyInterfaces_after.kt")
                public void testOnlyInterfaces_after() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/cyclicHierarchy/withCompanion/onlyInterfaces_after.kt");
                }

                @Test
                @TestMetadata("onlyInterfaces_before.kt")
                public void testOnlyInterfaces_before() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/cyclicHierarchy/withCompanion/onlyInterfaces_before.kt");
                }

                @Test
                @TestMetadata("typeIsLowEnough.kt")
                public void testTypeIsLowEnough() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/cyclicHierarchy/withCompanion/typeIsLowEnough.kt");
                }

                @Test
                @TestMetadata("withIrrelevantInterface_after.kt")
                public void testWithIrrelevantInterface_after() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/cyclicHierarchy/withCompanion/withIrrelevantInterface_after.kt");
                }

                @Test
                @TestMetadata("withIrrelevantInterface_before.kt")
                public void testWithIrrelevantInterface_before() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/cyclicHierarchy/withCompanion/withIrrelevantInterface_before.kt");
                }

                @Test
                @TestMetadata("withMembers_after.kt")
                public void testWithMembers_after() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/cyclicHierarchy/withCompanion/withMembers_after.kt");
                }

                @Test
                @TestMetadata("withMembers_before.kt")
                public void testWithMembers_before() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/cyclicHierarchy/withCompanion/withMembers_before.kt");
                }

                @Test
                @TestMetadata("withoutTypeReference.kt")
                public void testWithoutTypeReference() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/cyclicHierarchy/withCompanion/withoutTypeReference.kt");
                }
            }
        }

        @Nested
        @TestMetadata("compiler/testData/diagnostics/tests/dataClasses")
        @TestDataPath("$PROJECT_ROOT")
        public class DataClasses {
            @Test
            public void testAllFilesPresentInDataClasses() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/dataClasses"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
            }

            @Test
            @TestMetadata("componentNamedComponent1.kt")
            public void testComponentNamedComponent1() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataClasses/componentNamedComponent1.kt");
            }

            @Test
            @TestMetadata("conflictingCopyOverloads.kt")
            public void testConflictingCopyOverloads() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataClasses/conflictingCopyOverloads.kt");
            }

            @Test
            @TestMetadata("conflictingOverloads.kt")
            public void testConflictingOverloads() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataClasses/conflictingOverloads.kt");
            }

            @Test
            @TestMetadata("copyOfPrivateClass.kt")
            public void testCopyOfPrivateClass() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataClasses/copyOfPrivateClass.kt");
            }

            @Test
            @TestMetadata("dataClassExplicitlyOverridingCopyNoDefaults.kt")
            public void testDataClassExplicitlyOverridingCopyNoDefaults() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataClasses/dataClassExplicitlyOverridingCopyNoDefaults.kt");
            }

            @Test
            @TestMetadata("dataClassExplicitlyOverridingCopyWithDefaults.kt")
            public void testDataClassExplicitlyOverridingCopyWithDefaults() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataClasses/dataClassExplicitlyOverridingCopyWithDefaults.kt");
            }

            @Test
            @TestMetadata("dataClassNoName.kt")
            public void testDataClassNoName() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataClasses/dataClassNoName.kt");
            }

            @Test
            @TestMetadata("dataClassNotOverridingCopy.kt")
            public void testDataClassNotOverridingCopy() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataClasses/dataClassNotOverridingCopy.kt");
            }

            @Test
            @TestMetadata("dataClassOverridingCopy_lv12.kt")
            public void testDataClassOverridingCopy_lv12() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataClasses/dataClassOverridingCopy_lv12.kt");
            }

            @Test
            @TestMetadata("dataClassOverridingCopy_lv13.kt")
            public void testDataClassOverridingCopy_lv13() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataClasses/dataClassOverridingCopy_lv13.kt");
            }

            @Test
            @TestMetadata("dataClassVarargParam.kt")
            public void testDataClassVarargParam() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataClasses/dataClassVarargParam.kt");
            }

            @Test
            @TestMetadata("dataInheritance.kt")
            public void testDataInheritance() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataClasses/dataInheritance.kt");
            }

            @Test
            @TestMetadata("dataObject.kt")
            public void testDataObject() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataClasses/dataObject.kt");
            }

            @Test
            @TestMetadata("emptyConstructor.kt")
            public void testEmptyConstructor() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataClasses/emptyConstructor.kt");
            }

            @Test
            @TestMetadata("errorTypesInDataClasses.kt")
            public void testErrorTypesInDataClasses() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataClasses/errorTypesInDataClasses.kt");
            }

            @Test
            @TestMetadata("extensionComponentsOnNullable.kt")
            public void testExtensionComponentsOnNullable() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataClasses/extensionComponentsOnNullable.kt");
            }

            @Test
            @TestMetadata("finalMembersInBaseClass.kt")
            public void testFinalMembersInBaseClass() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataClasses/finalMembersInBaseClass.kt");
            }

            @Test
            @TestMetadata("implementMethodsFromInterface.kt")
            public void testImplementMethodsFromInterface() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataClasses/implementMethodsFromInterface.kt");
            }

            @Test
            @TestMetadata("implementTraitWhichHasComponent1.kt")
            public void testImplementTraitWhichHasComponent1() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataClasses/implementTraitWhichHasComponent1.kt");
            }

            @Test
            @TestMetadata("implementTraitWhichHasFinalComponent1.kt")
            public void testImplementTraitWhichHasFinalComponent1() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataClasses/implementTraitWhichHasFinalComponent1.kt");
            }

            @Test
            @TestMetadata("innerDataClass.kt")
            public void testInnerDataClass() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataClasses/innerDataClass.kt");
            }

            @Test
            @TestMetadata("innerOuterDataClass.kt")
            public void testInnerOuterDataClass() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataClasses/innerOuterDataClass.kt");
            }

            @Test
            @TestMetadata("multiDeclaration.kt")
            public void testMultiDeclaration() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataClasses/multiDeclaration.kt");
            }

            @Test
            @TestMetadata("multiDeclarationFor.kt")
            public void testMultiDeclarationFor() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataClasses/multiDeclarationFor.kt");
            }

            @Test
            @TestMetadata("noConstructor.kt")
            public void testNoConstructor() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataClasses/noConstructor.kt");
            }

            @Test
            @TestMetadata("notADataClass.kt")
            public void testNotADataClass() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataClasses/notADataClass.kt");
            }

            @Test
            @TestMetadata("oneValParam.kt")
            public void testOneValParam() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataClasses/oneValParam.kt");
            }

            @Test
            @TestMetadata("repeatedProperties.kt")
            public void testRepeatedProperties() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataClasses/repeatedProperties.kt");
            }

            @Test
            @TestMetadata("sealedDataClass.kt")
            public void testSealedDataClass() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataClasses/sealedDataClass.kt");
            }

            @Test
            @TestMetadata("strange.kt")
            public void testStrange() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataClasses/strange.kt");
            }

            @Test
            @TestMetadata("twoValParams.kt")
            public void testTwoValParams() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataClasses/twoValParams.kt");
            }

            @Test
            @TestMetadata("twoVarParams.kt")
            public void testTwoVarParams() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataClasses/twoVarParams.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/diagnostics/tests/dataFlow")
        @TestDataPath("$PROJECT_ROOT")
        public class DataFlow {
            @Test
            public void testAllFilesPresentInDataFlow() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/dataFlow"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
            }

            @Test
            @TestMetadata("CalleeExpression.kt")
            public void testCalleeExpression() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlow/CalleeExpression.kt");
            }

            @Test
            @TestMetadata("EmptyIf.kt")
            public void testEmptyIf() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlow/EmptyIf.kt");
            }

            @Test
            @TestMetadata("IsExpression.kt")
            public void testIsExpression() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlow/IsExpression.kt");
            }

            @Test
            @TestMetadata("WhenSubject.kt")
            public void testWhenSubject() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlow/WhenSubject.kt");
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/dataFlow/assignment")
            @TestDataPath("$PROJECT_ROOT")
            public class Assignment {
                @Test
                public void testAllFilesPresentInAssignment() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/dataFlow/assignment"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("assignToNewVal.kt")
                public void testAssignToNewVal() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/dataFlow/assignment/assignToNewVal.kt");
                }

                @Test
                @TestMetadata("kt6118.kt")
                public void testKt6118() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/dataFlow/assignment/kt6118.kt");
                }

                @Test
                @TestMetadata("uninitializedValIsCheck.kt")
                public void testUninitializedValIsCheck() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/dataFlow/assignment/uninitializedValIsCheck.kt");
                }

                @Test
                @TestMetadata("uninitializedValNullability.kt")
                public void testUninitializedValNullability() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/dataFlow/assignment/uninitializedValNullability.kt");
                }

                @Test
                @TestMetadata("when.kt")
                public void testWhen() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/dataFlow/assignment/when.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/dataFlow/local")
            @TestDataPath("$PROJECT_ROOT")
            public class Local {
                @Test
                public void testAllFilesPresentInLocal() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/dataFlow/local"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("kt2835.kt")
                public void testKt2835() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/dataFlow/local/kt2835.kt");
                }

                @Test
                @TestMetadata("LocalClassBase.kt")
                public void testLocalClassBase() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/dataFlow/local/LocalClassBase.kt");
                }

                @Test
                @TestMetadata("LocalClassDefaultParameters.kt")
                public void testLocalClassDefaultParameters() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/dataFlow/local/LocalClassDefaultParameters.kt");
                }

                @Test
                @TestMetadata("LocalClassDelegatedProperties.kt")
                public void testLocalClassDelegatedProperties() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/dataFlow/local/LocalClassDelegatedProperties.kt");
                }

                @Test
                @TestMetadata("LocalClassDelegation.kt")
                public void testLocalClassDelegation() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/dataFlow/local/LocalClassDelegation.kt");
                }

                @Test
                @TestMetadata("LocalClassFunctions.kt")
                public void testLocalClassFunctions() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/dataFlow/local/LocalClassFunctions.kt");
                }

                @Test
                @TestMetadata("LocalClassInMemberOfLocalClass.kt")
                public void testLocalClassInMemberOfLocalClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/dataFlow/local/LocalClassInMemberOfLocalClass.kt");
                }

                @Test
                @TestMetadata("LocalClassInitializer.kt")
                public void testLocalClassInitializer() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/dataFlow/local/LocalClassInitializer.kt");
                }

                @Test
                @TestMetadata("LocalClassProperty.kt")
                public void testLocalClassProperty() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/dataFlow/local/LocalClassProperty.kt");
                }

                @Test
                @TestMetadata("LocalObject.kt")
                public void testLocalObject() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/dataFlow/local/LocalObject.kt");
                }

                @Test
                @TestMetadata("LocalObjectDelegation.kt")
                public void testLocalObjectDelegation() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/dataFlow/local/LocalObjectDelegation.kt");
                }

                @Test
                @TestMetadata("NestedLocalClass.kt")
                public void testNestedLocalClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/dataFlow/local/NestedLocalClass.kt");
                }
            }
        }

        @Nested
        @TestMetadata("compiler/testData/diagnostics/tests/dataFlowInfoTraversal")
        @TestDataPath("$PROJECT_ROOT")
        public class DataFlowInfoTraversal {
            @Test
            public void testAllFilesPresentInDataFlowInfoTraversal() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/dataFlowInfoTraversal"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
            }

            @Test
            @TestMetadata("AndOr.kt")
            public void testAndOr() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/AndOr.kt");
            }

            @Test
            @TestMetadata("ArrayAccess.kt")
            public void testArrayAccess() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/ArrayAccess.kt");
            }

            @Test
            @TestMetadata("ArrayExpression.kt")
            public void testArrayExpression() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/ArrayExpression.kt");
            }

            @Test
            @TestMetadata("ArrayGetSetConvention.kt")
            public void testArrayGetSetConvention() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/ArrayGetSetConvention.kt");
            }

            @Test
            @TestMetadata("ArrayIndices.kt")
            public void testArrayIndices() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/ArrayIndices.kt");
            }

            @Test
            @TestMetadata("Assignment.kt")
            public void testAssignment() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/Assignment.kt");
            }

            @Test
            @TestMetadata("AssignmentInInitializer.kt")
            public void testAssignmentInInitializer() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/AssignmentInInitializer.kt");
            }

            @Test
            @TestMetadata("AssignmentOperation.kt")
            public void testAssignmentOperation() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/AssignmentOperation.kt");
            }

            @Test
            @TestMetadata("AssignmentToArrayElement.kt")
            public void testAssignmentToArrayElement() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/AssignmentToArrayElement.kt");
            }

            @Test
            @TestMetadata("BinaryExpression.kt")
            public void testBinaryExpression() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/BinaryExpression.kt");
            }

            @Test
            @TestMetadata("BinaryExpressionBooleanOperations.kt")
            public void testBinaryExpressionBooleanOperations() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/BinaryExpressionBooleanOperations.kt");
            }

            @Test
            @TestMetadata("BinaryExpressionCompareToConvention.kt")
            public void testBinaryExpressionCompareToConvention() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/BinaryExpressionCompareToConvention.kt");
            }

            @Test
            @TestMetadata("BinaryExpressionContainsConvention.kt")
            public void testBinaryExpressionContainsConvention() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/BinaryExpressionContainsConvention.kt");
            }

            @Test
            @TestMetadata("BinaryExpressionElvis.kt")
            public void testBinaryExpressionElvis() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/BinaryExpressionElvis.kt");
            }

            @Test
            @TestMetadata("BinaryExpressionEqualsConvention.kt")
            public void testBinaryExpressionEqualsConvention() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/BinaryExpressionEqualsConvention.kt");
            }

            @Test
            @TestMetadata("BinaryExpressionIdentifier.kt")
            public void testBinaryExpressionIdentifier() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/BinaryExpressionIdentifier.kt");
            }

            @Test
            @TestMetadata("BinaryExpressionPlusConvention.kt")
            public void testBinaryExpressionPlusConvention() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/BinaryExpressionPlusConvention.kt");
            }

            @Test
            @TestMetadata("Condition.kt")
            public void testCondition() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/Condition.kt");
            }

            @Test
            @TestMetadata("ContinueOuterLoop.kt")
            public void testContinueOuterLoop() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/ContinueOuterLoop.kt");
            }

            @Test
            @TestMetadata("DeepIf.kt")
            public void testDeepIf() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/DeepIf.kt");
            }

            @Test
            @TestMetadata("DoWhile.kt")
            public void testDoWhile() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/DoWhile.kt");
            }

            @Test
            @TestMetadata("DoWhileCondition.kt")
            public void testDoWhileCondition() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/DoWhileCondition.kt");
            }

            @Test
            @TestMetadata("Elvis.kt")
            public void testElvis() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/Elvis.kt");
            }

            @Test
            @TestMetadata("ExclExcl.kt")
            public void testExclExcl() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/ExclExcl.kt");
            }

            @Test
            @TestMetadata("For.kt")
            public void testFor() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/For.kt");
            }

            @Test
            @TestMetadata("ForLoopRange.kt")
            public void testForLoopRange() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/ForLoopRange.kt");
            }

            @Test
            @TestMetadata("FunctionLiteral.kt")
            public void testFunctionLiteral() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/FunctionLiteral.kt");
            }

            @Test
            @TestMetadata("IfStatement.kt")
            public void testIfStatement() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/IfStatement.kt");
            }

            @Test
            @TestMetadata("IfThenElse.kt")
            public void testIfThenElse() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/IfThenElse.kt");
            }

            @Test
            @TestMetadata("IfThenElseBothInvalid.kt")
            public void testIfThenElseBothInvalid() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/IfThenElseBothInvalid.kt");
            }

            @Test
            @TestMetadata("IsExpression.kt")
            public void testIsExpression() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/IsExpression.kt");
            }

            @Test
            @TestMetadata("kt4332WhenBranches.kt")
            public void testKt4332WhenBranches() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/kt4332WhenBranches.kt");
            }

            @Test
            @TestMetadata("kt5155WhenBranches.kt")
            public void testKt5155WhenBranches() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/kt5155WhenBranches.kt");
            }

            @Test
            @TestMetadata("kt5182WhenBranches.kt")
            public void testKt5182WhenBranches() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/kt5182WhenBranches.kt");
            }

            @Test
            @TestMetadata("ManyIfs.kt")
            public void testManyIfs() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/ManyIfs.kt");
            }

            @Test
            @TestMetadata("MultiDeclaration.kt")
            public void testMultiDeclaration() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/MultiDeclaration.kt");
            }

            @Test
            @TestMetadata("ObjectExpression.kt")
            public void testObjectExpression() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/ObjectExpression.kt");
            }

            @Test
            @TestMetadata("QualifiedExpression.kt")
            public void testQualifiedExpression() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/QualifiedExpression.kt");
            }

            @Test
            @TestMetadata("Return.kt")
            public void testReturn() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/Return.kt");
            }

            @Test
            @TestMetadata("StringTemplate.kt")
            public void testStringTemplate() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/StringTemplate.kt");
            }

            @Test
            @TestMetadata("ThisSuper.kt")
            public void testThisSuper() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/ThisSuper.kt");
            }

            @Test
            @TestMetadata("Throw.kt")
            public void testThrow() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/Throw.kt");
            }

            @Test
            @TestMetadata("TryCatch.kt")
            public void testTryCatch() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/TryCatch.kt");
            }

            @Test
            @TestMetadata("TryFinally.kt")
            public void testTryFinally() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/TryFinally.kt");
            }

            @Test
            @TestMetadata("UnaryExpression.kt")
            public void testUnaryExpression() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/UnaryExpression.kt");
            }

            @Test
            @TestMetadata("When.kt")
            public void testWhen() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/When.kt");
            }

            @Test
            @TestMetadata("WhenEntryAs.kt")
            public void testWhenEntryAs() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/WhenEntryAs.kt");
            }

            @Test
            @TestMetadata("WhenEntryIs.kt")
            public void testWhenEntryIs() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/WhenEntryIs.kt");
            }

            @Test
            @TestMetadata("WhenIn.kt")
            public void testWhenIn() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/WhenIn.kt");
            }

            @Test
            @TestMetadata("WhenSubject.kt")
            public void testWhenSubject() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/WhenSubject.kt");
            }

            @Test
            @TestMetadata("While.kt")
            public void testWhile() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/While.kt");
            }

            @Test
            @TestMetadata("WhileCondition.kt")
            public void testWhileCondition() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/WhileCondition.kt");
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/smartcasts")
            @TestDataPath("$PROJECT_ROOT")
            public class Smartcasts {
                @Test
                public void testAllFilesPresentInSmartcasts() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/smartcasts"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("SmartcastAmbiguitites.kt")
                public void testSmartcastAmbiguitites() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/smartcasts/SmartcastAmbiguitites.kt");
                }

                @Test
                @TestMetadata("SmartcastsForStableIdentifiers.kt")
                public void testSmartcastsForStableIdentifiers() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/dataFlowInfoTraversal/smartcasts/SmartcastsForStableIdentifiers.kt");
                }
            }
        }

        @Nested
        @TestMetadata("compiler/testData/diagnostics/tests/declarationChecks")
        @TestDataPath("$PROJECT_ROOT")
        public class DeclarationChecks {
            @Test
            public void testAllFilesPresentInDeclarationChecks() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/declarationChecks"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
            }

            @Test
            @TestMetadata("ambiguousObjectExpressionType.kt")
            public void testAmbiguousObjectExpressionType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/declarationChecks/ambiguousObjectExpressionType.kt");
            }

            @Test
            @TestMetadata("anonymousFunAsLastExpressionInBlock.kt")
            public void testAnonymousFunAsLastExpressionInBlock() throws Exception {
                runTest("compiler/testData/diagnostics/tests/declarationChecks/anonymousFunAsLastExpressionInBlock.kt");
            }

            @Test
            @TestMetadata("anonymousFunUnusedLastExpressionInBlock.kt")
            public void testAnonymousFunUnusedLastExpressionInBlock() throws Exception {
                runTest("compiler/testData/diagnostics/tests/declarationChecks/anonymousFunUnusedLastExpressionInBlock.kt");
            }

            @Test
            @TestMetadata("ComponentFunctionReturnTypeMismatch.kt")
            public void testComponentFunctionReturnTypeMismatch() throws Exception {
                runTest("compiler/testData/diagnostics/tests/declarationChecks/ComponentFunctionReturnTypeMismatch.kt");
            }

            @Test
            @TestMetadata("ConflictingAndRedundantProjections.kt")
            public void testConflictingAndRedundantProjections() throws Exception {
                runTest("compiler/testData/diagnostics/tests/declarationChecks/ConflictingAndRedundantProjections.kt");
            }

            @Test
            @TestMetadata("DataFlowInMultiDeclInFor.kt")
            public void testDataFlowInMultiDeclInFor() throws Exception {
                runTest("compiler/testData/diagnostics/tests/declarationChecks/DataFlowInMultiDeclInFor.kt");
            }

            @Test
            @TestMetadata("DataFlowInfoInMultiDecl.kt")
            public void testDataFlowInfoInMultiDecl() throws Exception {
                runTest("compiler/testData/diagnostics/tests/declarationChecks/DataFlowInfoInMultiDecl.kt");
            }

            @Test
            @TestMetadata("FunctionWithMissingNames.kt")
            public void testFunctionWithMissingNames() throws Exception {
                runTest("compiler/testData/diagnostics/tests/declarationChecks/FunctionWithMissingNames.kt");
            }

            @Test
            @TestMetadata("illegalModifiersOnClass.kt")
            public void testIllegalModifiersOnClass() throws Exception {
                runTest("compiler/testData/diagnostics/tests/declarationChecks/illegalModifiersOnClass.kt");
            }

            @Test
            @TestMetadata("kClassInSignature.kt")
            public void testKClassInSignature() throws Exception {
                runTest("compiler/testData/diagnostics/tests/declarationChecks/kClassInSignature.kt");
            }

            @Test
            @TestMetadata("kt1141.kt")
            public void testKt1141() throws Exception {
                runTest("compiler/testData/diagnostics/tests/declarationChecks/kt1141.kt");
            }

            @Test
            @TestMetadata("kt1193.kt")
            public void testKt1193() throws Exception {
                runTest("compiler/testData/diagnostics/tests/declarationChecks/kt1193.kt");
            }

            @Test
            @TestMetadata("kt2096.kt")
            public void testKt2096() throws Exception {
                runTest("compiler/testData/diagnostics/tests/declarationChecks/kt2096.kt");
            }

            @Test
            @TestMetadata("kt2142.kt")
            public void testKt2142() throws Exception {
                runTest("compiler/testData/diagnostics/tests/declarationChecks/kt2142.kt");
            }

            @Test
            @TestMetadata("kt2397.kt")
            public void testKt2397() throws Exception {
                runTest("compiler/testData/diagnostics/tests/declarationChecks/kt2397.kt");
            }

            @Test
            @TestMetadata("kt2631_MultipleDeclaration.kt")
            public void testKt2631_MultipleDeclaration() throws Exception {
                runTest("compiler/testData/diagnostics/tests/declarationChecks/kt2631_MultipleDeclaration.kt");
            }

            @Test
            @TestMetadata("kt2643MultiDeclInControlFlow.kt")
            public void testKt2643MultiDeclInControlFlow() throws Exception {
                runTest("compiler/testData/diagnostics/tests/declarationChecks/kt2643MultiDeclInControlFlow.kt");
            }

            @Test
            @TestMetadata("kt559.kt")
            public void testKt559() throws Exception {
                runTest("compiler/testData/diagnostics/tests/declarationChecks/kt559.kt");
            }

            @Test
            @TestMetadata("localDeclarationModifiers.kt")
            public void testLocalDeclarationModifiers() throws Exception {
                runTest("compiler/testData/diagnostics/tests/declarationChecks/localDeclarationModifiers.kt");
            }

            @Test
            @TestMetadata("localFunctionNoInheritVisibility.kt")
            public void testLocalFunctionNoInheritVisibility() throws Exception {
                runTest("compiler/testData/diagnostics/tests/declarationChecks/localFunctionNoInheritVisibility.kt");
            }

            @Test
            @TestMetadata("localObjectInInnerClass.kt")
            public void testLocalObjectInInnerClass() throws Exception {
                runTest("compiler/testData/diagnostics/tests/declarationChecks/localObjectInInnerClass.kt");
            }

            @Test
            @TestMetadata("LocalVariableWithNoTypeInformation.kt")
            public void testLocalVariableWithNoTypeInformation() throws Exception {
                runTest("compiler/testData/diagnostics/tests/declarationChecks/LocalVariableWithNoTypeInformation.kt");
            }

            @Test
            @TestMetadata("localVariablesWithTypeParameters_1_3.kt")
            public void testLocalVariablesWithTypeParameters_1_3() throws Exception {
                runTest("compiler/testData/diagnostics/tests/declarationChecks/localVariablesWithTypeParameters_1_3.kt");
            }

            @Test
            @TestMetadata("localVariablesWithTypeParameters_1_4.kt")
            public void testLocalVariablesWithTypeParameters_1_4() throws Exception {
                runTest("compiler/testData/diagnostics/tests/declarationChecks/localVariablesWithTypeParameters_1_4.kt");
            }

            @Test
            @TestMetadata("mappedFunctionNotImplemented.kt")
            public void testMappedFunctionNotImplemented() throws Exception {
                runTest("compiler/testData/diagnostics/tests/declarationChecks/mappedFunctionNotImplemented.kt");
            }

            @Test
            @TestMetadata("mulitpleVarargParameters.kt")
            public void testMulitpleVarargParameters() throws Exception {
                runTest("compiler/testData/diagnostics/tests/declarationChecks/mulitpleVarargParameters.kt");
            }

            @Test
            @TestMetadata("MultiDeclarationErrors.kt")
            public void testMultiDeclarationErrors() throws Exception {
                runTest("compiler/testData/diagnostics/tests/declarationChecks/MultiDeclarationErrors.kt");
            }

            @Test
            @TestMetadata("nameWithDangerousCharacters.kt")
            public void testNameWithDangerousCharacters() throws Exception {
                runTest("compiler/testData/diagnostics/tests/declarationChecks/nameWithDangerousCharacters.kt");
            }

            @Test
            @TestMetadata("namedFunAsLastExpressionInBlock.kt")
            public void testNamedFunAsLastExpressionInBlock() throws Exception {
                runTest("compiler/testData/diagnostics/tests/declarationChecks/namedFunAsLastExpressionInBlock.kt");
            }

            @Test
            @TestMetadata("packageDeclarationModifiers.kt")
            public void testPackageDeclarationModifiers() throws Exception {
                runTest("compiler/testData/diagnostics/tests/declarationChecks/packageDeclarationModifiers.kt");
            }

            @Test
            @TestMetadata("propertyInPackageHasNoInheritVisibility.kt")
            public void testPropertyInPackageHasNoInheritVisibility() throws Exception {
                runTest("compiler/testData/diagnostics/tests/declarationChecks/propertyInPackageHasNoInheritVisibility.kt");
            }

            @Test
            @TestMetadata("RedeclarationsInMultiDecl.kt")
            public void testRedeclarationsInMultiDecl() throws Exception {
                runTest("compiler/testData/diagnostics/tests/declarationChecks/RedeclarationsInMultiDecl.kt");
            }

            @Test
            @TestMetadata("ScalaLikeNamedFun.kt")
            public void testScalaLikeNamedFun() throws Exception {
                runTest("compiler/testData/diagnostics/tests/declarationChecks/ScalaLikeNamedFun.kt");
            }

            @Test
            @TestMetadata("sealedOnMembers.kt")
            public void testSealedOnMembers() throws Exception {
                runTest("compiler/testData/diagnostics/tests/declarationChecks/sealedOnMembers.kt");
            }

            @Test
            @TestMetadata("unambiguousObjectExpressionType.kt")
            public void testUnambiguousObjectExpressionType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/declarationChecks/unambiguousObjectExpressionType.kt");
            }

            @Test
            @TestMetadata("valVarFunctionParameter.kt")
            public void testValVarFunctionParameter() throws Exception {
                runTest("compiler/testData/diagnostics/tests/declarationChecks/valVarFunctionParameter.kt");
            }

            @Test
            @TestMetadata("VarianceOnFunctionAndPropertyTypeParameters.kt")
            public void testVarianceOnFunctionAndPropertyTypeParameters() throws Exception {
                runTest("compiler/testData/diagnostics/tests/declarationChecks/VarianceOnFunctionAndPropertyTypeParameters.kt");
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/declarationChecks/destructuringDeclarations")
            @TestDataPath("$PROJECT_ROOT")
            public class DestructuringDeclarations {
                @Test
                public void testAllFilesPresentInDestructuringDeclarations() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/declarationChecks/destructuringDeclarations"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("destructuringDeclarationAssignedUnresolved.kt")
                public void testDestructuringDeclarationAssignedUnresolved() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/declarationChecks/destructuringDeclarations/destructuringDeclarationAssignedUnresolved.kt");
                }

                @Test
                @TestMetadata("destructuringDeclarationMissingInitializer.kt")
                public void testDestructuringDeclarationMissingInitializer() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/declarationChecks/destructuringDeclarations/destructuringDeclarationMissingInitializer.kt");
                }

                @Test
                @TestMetadata("DoubleDeclForLoop.kt")
                public void testDoubleDeclForLoop() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/declarationChecks/destructuringDeclarations/DoubleDeclForLoop.kt");
                }

                @Test
                @TestMetadata("FolLoopTypeComponentTypeMismatch.kt")
                public void testFolLoopTypeComponentTypeMismatch() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/declarationChecks/destructuringDeclarations/FolLoopTypeComponentTypeMismatch.kt");
                }

                @Test
                @TestMetadata("ForLoopComponentFunctionAmbiguity.kt")
                public void testForLoopComponentFunctionAmbiguity() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/declarationChecks/destructuringDeclarations/ForLoopComponentFunctionAmbiguity.kt");
                }

                @Test
                @TestMetadata("ForLoopComponentFunctionMissing.kt")
                public void testForLoopComponentFunctionMissing() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/declarationChecks/destructuringDeclarations/ForLoopComponentFunctionMissing.kt");
                }

                @Test
                @TestMetadata("ForLoopMissingLoopParameter.kt")
                public void testForLoopMissingLoopParameter() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/declarationChecks/destructuringDeclarations/ForLoopMissingLoopParameter.kt");
                }

                @Test
                @TestMetadata("ForLoopWithExtensions.kt")
                public void testForLoopWithExtensions() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/declarationChecks/destructuringDeclarations/ForLoopWithExtensions.kt");
                }

                @Test
                @TestMetadata("ForWithExplicitTypes.kt")
                public void testForWithExplicitTypes() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/declarationChecks/destructuringDeclarations/ForWithExplicitTypes.kt");
                }

                @Test
                @TestMetadata("kt2829.kt")
                public void testKt2829() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/declarationChecks/destructuringDeclarations/kt2829.kt");
                }

                @Test
                @TestMetadata("lastDestructuringDeclarationInBlock.kt")
                public void testLastDestructuringDeclarationInBlock() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/declarationChecks/destructuringDeclarations/lastDestructuringDeclarationInBlock.kt");
                }

                @Test
                @TestMetadata("RedeclarationInForLoop.kt")
                public void testRedeclarationInForLoop() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/declarationChecks/destructuringDeclarations/RedeclarationInForLoop.kt");
                }

                @Test
                @TestMetadata("SingleDeclForLoop.kt")
                public void testSingleDeclForLoop() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/declarationChecks/destructuringDeclarations/SingleDeclForLoop.kt");
                }

                @Test
                @TestMetadata("underscore.kt")
                public void testUnderscore() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/declarationChecks/destructuringDeclarations/underscore.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/declarationChecks/finiteBoundRestriction")
            @TestDataPath("$PROJECT_ROOT")
            public class FiniteBoundRestriction {
                @Test
                public void testAllFilesPresentInFiniteBoundRestriction() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/declarationChecks/finiteBoundRestriction"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("CasesWithOneTypeParameter.kt")
                public void testCasesWithOneTypeParameter() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/declarationChecks/finiteBoundRestriction/CasesWithOneTypeParameter.kt");
                }

                @Test
                @TestMetadata("CasesWithTwoTypeParameters.kt")
                public void testCasesWithTwoTypeParameters() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/declarationChecks/finiteBoundRestriction/CasesWithTwoTypeParameters.kt");
                }

                @Test
                @TestMetadata("JavaSuperType.kt")
                public void testJavaSuperType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/declarationChecks/finiteBoundRestriction/JavaSuperType.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/declarationChecks/nonExpansiveInheritanceRestriction")
            @TestDataPath("$PROJECT_ROOT")
            public class NonExpansiveInheritanceRestriction {
                @Test
                public void testAllFilesPresentInNonExpansiveInheritanceRestriction() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/declarationChecks/nonExpansiveInheritanceRestriction"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("JavaWithKotlin.kt")
                public void testJavaWithKotlin() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/declarationChecks/nonExpansiveInheritanceRestriction/JavaWithKotlin.kt");
                }

                @Test
                @TestMetadata("JavaWithKotlin2.kt")
                public void testJavaWithKotlin2() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/declarationChecks/nonExpansiveInheritanceRestriction/JavaWithKotlin2.kt");
                }

                @Test
                @TestMetadata("PureKotlin.kt")
                public void testPureKotlin() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/declarationChecks/nonExpansiveInheritanceRestriction/PureKotlin.kt");
                }
            }
        }

        @Nested
        @TestMetadata("compiler/testData/diagnostics/tests/defaultArguments")
        @TestDataPath("$PROJECT_ROOT")
        public class DefaultArguments {
            @Test
            public void testAllFilesPresentInDefaultArguments() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/defaultArguments"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
            }

            @Test
            @TestMetadata("kt5232.kt")
            public void testKt5232() throws Exception {
                runTest("compiler/testData/diagnostics/tests/defaultArguments/kt5232.kt");
            }

            @Test
            @TestMetadata("superCall.kt")
            public void testSuperCall() throws Exception {
                runTest("compiler/testData/diagnostics/tests/defaultArguments/superCall.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/diagnostics/tests/delegatedProperty")
        @TestDataPath("$PROJECT_ROOT")
        public class DelegatedProperty {
            @Test
            @TestMetadata("absentErrorAboutInitializer.kt")
            public void testAbsentErrorAboutInitializer() throws Exception {
                runTest("compiler/testData/diagnostics/tests/delegatedProperty/absentErrorAboutInitializer.kt");
            }

            @Test
            @TestMetadata("absentErrorAboutType.kt")
            public void testAbsentErrorAboutType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/delegatedProperty/absentErrorAboutType.kt");
            }

            @Test
            @TestMetadata("abstractDelegatedProperty.kt")
            public void testAbstractDelegatedProperty() throws Exception {
                runTest("compiler/testData/diagnostics/tests/delegatedProperty/abstractDelegatedProperty.kt");
            }

            @Test
            public void testAllFilesPresentInDelegatedProperty() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/delegatedProperty"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
            }

            @Test
            @TestMetadata("backingField.kt")
            public void testBackingField() throws Exception {
                runTest("compiler/testData/diagnostics/tests/delegatedProperty/backingField.kt");
            }

            @Test
            @TestMetadata("defaultGetter.kt")
            public void testDefaultGetter() throws Exception {
                runTest("compiler/testData/diagnostics/tests/delegatedProperty/defaultGetter.kt");
            }

            @Test
            @TestMetadata("defaultSetter.kt")
            public void testDefaultSetter() throws Exception {
                runTest("compiler/testData/diagnostics/tests/delegatedProperty/defaultSetter.kt");
            }

            @Test
            @TestMetadata("delegatedPropertyOverridedInTrait.kt")
            public void testDelegatedPropertyOverridedInTrait() throws Exception {
                runTest("compiler/testData/diagnostics/tests/delegatedProperty/delegatedPropertyOverridedInTrait.kt");
            }

            @Test
            @TestMetadata("delegatedPropertyOverridedInTraitTypeMismatch.kt")
            public void testDelegatedPropertyOverridedInTraitTypeMismatch() throws Exception {
                runTest("compiler/testData/diagnostics/tests/delegatedProperty/delegatedPropertyOverridedInTraitTypeMismatch.kt");
            }

            @Test
            @TestMetadata("disallowImplInTypeParameter.kt")
            public void testDisallowImplInTypeParameter() throws Exception {
                runTest("compiler/testData/diagnostics/tests/delegatedProperty/disallowImplInTypeParameter.kt");
            }

            @Test
            @TestMetadata("genericGetter.kt")
            public void testGenericGetter() throws Exception {
                runTest("compiler/testData/diagnostics/tests/delegatedProperty/genericGetter.kt");
            }

            @Test
            @TestMetadata("getterWithSubtype.kt")
            public void testGetterWithSubtype() throws Exception {
                runTest("compiler/testData/diagnostics/tests/delegatedProperty/getterWithSubtype.kt");
            }

            @Test
            @TestMetadata("inTrait.kt")
            public void testInTrait() throws Exception {
                runTest("compiler/testData/diagnostics/tests/delegatedProperty/inTrait.kt");
            }

            @Test
            @TestMetadata("incompleteTypeInference.kt")
            public void testIncompleteTypeInference() throws Exception {
                runTest("compiler/testData/diagnostics/tests/delegatedProperty/incompleteTypeInference.kt");
            }

            @Test
            @TestMetadata("kt4640.kt")
            public void testKt4640() throws Exception {
                runTest("compiler/testData/diagnostics/tests/delegatedProperty/kt4640.kt");
            }

            @Test
            @TestMetadata("kt48546.kt")
            public void testKt48546() throws Exception {
                runTest("compiler/testData/diagnostics/tests/delegatedProperty/kt48546.kt");
            }

            @Test
            @TestMetadata("kt48546Strict.kt")
            public void testKt48546Strict() throws Exception {
                runTest("compiler/testData/diagnostics/tests/delegatedProperty/kt48546Strict.kt");
            }

            @Test
            @TestMetadata("localVariable.kt")
            public void testLocalVariable() throws Exception {
                runTest("compiler/testData/diagnostics/tests/delegatedProperty/localVariable.kt");
            }

            @Test
            @TestMetadata("localWithSmartCast.kt")
            public void testLocalWithSmartCast() throws Exception {
                runTest("compiler/testData/diagnostics/tests/delegatedProperty/localWithSmartCast.kt");
            }

            @Test
            @TestMetadata("missedGetter.kt")
            public void testMissedGetter() throws Exception {
                runTest("compiler/testData/diagnostics/tests/delegatedProperty/missedGetter.kt");
            }

            @Test
            @TestMetadata("missedSetter.kt")
            public void testMissedSetter() throws Exception {
                runTest("compiler/testData/diagnostics/tests/delegatedProperty/missedSetter.kt");
            }

            @Test
            @TestMetadata("nonDefaultAccessors.kt")
            public void testNonDefaultAccessors() throws Exception {
                runTest("compiler/testData/diagnostics/tests/delegatedProperty/nonDefaultAccessors.kt");
            }

            @Test
            @TestMetadata("propertyDefferedType.kt")
            public void testPropertyDefferedType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/delegatedProperty/propertyDefferedType.kt");
            }

            @Test
            @TestMetadata("recursiveType.kt")
            public void testRecursiveType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/delegatedProperty/recursiveType.kt");
            }

            @Test
            @TestMetadata("redundantGetter.kt")
            public void testRedundantGetter() throws Exception {
                runTest("compiler/testData/diagnostics/tests/delegatedProperty/redundantGetter.kt");
            }

            @Test
            @TestMetadata("redundantSetter.kt")
            public void testRedundantSetter() throws Exception {
                runTest("compiler/testData/diagnostics/tests/delegatedProperty/redundantSetter.kt");
            }

            @Test
            @TestMetadata("setterThisTypeMismatch.kt")
            public void testSetterThisTypeMismatch() throws Exception {
                runTest("compiler/testData/diagnostics/tests/delegatedProperty/setterThisTypeMismatch.kt");
            }

            @Test
            @TestMetadata("setterWithSupertype.kt")
            public void testSetterWithSupertype() throws Exception {
                runTest("compiler/testData/diagnostics/tests/delegatedProperty/setterWithSupertype.kt");
            }

            @Test
            @TestMetadata("severalReceivers.kt")
            public void testSeveralReceivers() throws Exception {
                runTest("compiler/testData/diagnostics/tests/delegatedProperty/severalReceivers.kt");
            }

            @Test
            @TestMetadata("thisInDelegate.kt")
            public void testThisInDelegate() throws Exception {
                runTest("compiler/testData/diagnostics/tests/delegatedProperty/thisInDelegate.kt");
            }

            @Test
            @TestMetadata("thisOfAnyType.kt")
            public void testThisOfAnyType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/delegatedProperty/thisOfAnyType.kt");
            }

            @Test
            @TestMetadata("thisOfNothingNullableType.kt")
            public void testThisOfNothingNullableType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/delegatedProperty/thisOfNothingNullableType.kt");
            }

            @Test
            @TestMetadata("thisOfNothingType.kt")
            public void testThisOfNothingType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/delegatedProperty/thisOfNothingType.kt");
            }

            @Test
            @TestMetadata("twoGetMethods.kt")
            public void testTwoGetMethods() throws Exception {
                runTest("compiler/testData/diagnostics/tests/delegatedProperty/twoGetMethods.kt");
            }

            @Test
            @TestMetadata("typeMismatchForGetReturnType.kt")
            public void testTypeMismatchForGetReturnType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/delegatedProperty/typeMismatchForGetReturnType.kt");
            }

            @Test
            @TestMetadata("typeMismatchForGetWithGeneric.kt")
            public void testTypeMismatchForGetWithGeneric() throws Exception {
                runTest("compiler/testData/diagnostics/tests/delegatedProperty/typeMismatchForGetWithGeneric.kt");
            }

            @Test
            @TestMetadata("typeMismatchForSetParameter.kt")
            public void testTypeMismatchForSetParameter() throws Exception {
                runTest("compiler/testData/diagnostics/tests/delegatedProperty/typeMismatchForSetParameter.kt");
            }

            @Test
            @TestMetadata("typeMismatchForThisGetParameter.kt")
            public void testTypeMismatchForThisGetParameter() throws Exception {
                runTest("compiler/testData/diagnostics/tests/delegatedProperty/typeMismatchForThisGetParameter.kt");
            }

            @Test
            @TestMetadata("useTypeParameterOfExtensionProperty.kt")
            public void testUseTypeParameterOfExtensionProperty() throws Exception {
                runTest("compiler/testData/diagnostics/tests/delegatedProperty/useTypeParameterOfExtensionProperty.kt");
            }

            @Test
            @TestMetadata("useTypeParameterOfExtensionProperty_Disabled.kt")
            public void testUseTypeParameterOfExtensionProperty_Disabled() throws Exception {
                runTest("compiler/testData/diagnostics/tests/delegatedProperty/useTypeParameterOfExtensionProperty_Disabled.kt");
            }

            @Test
            @TestMetadata("wrongCountOfParametersInGet.kt")
            public void testWrongCountOfParametersInGet() throws Exception {
                runTest("compiler/testData/diagnostics/tests/delegatedProperty/wrongCountOfParametersInGet.kt");
            }

            @Test
            @TestMetadata("wrongCountOfParametersInSet.kt")
            public void testWrongCountOfParametersInSet() throws Exception {
                runTest("compiler/testData/diagnostics/tests/delegatedProperty/wrongCountOfParametersInSet.kt");
            }

            @Test
            @TestMetadata("wrongSetterReturnType.kt")
            public void testWrongSetterReturnType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/delegatedProperty/wrongSetterReturnType.kt");
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/delegatedProperty/inference")
            @TestDataPath("$PROJECT_ROOT")
            public class Inference {
                @Test
                public void testAllFilesPresentInInference() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/delegatedProperty/inference"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("callableReferenceArgumentInDelegatedExpression.kt")
                public void testCallableReferenceArgumentInDelegatedExpression() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegatedProperty/inference/callableReferenceArgumentInDelegatedExpression.kt");
                }

                @Test
                @TestMetadata("delegateExpressionAsLambda.kt")
                public void testDelegateExpressionAsLambda() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegatedProperty/inference/delegateExpressionAsLambda.kt");
                }

                @Test
                @TestMetadata("delegatedExpressionWithLabeledReturnInsideLambda.kt")
                public void testDelegatedExpressionWithLabeledReturnInsideLambda() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegatedProperty/inference/delegatedExpressionWithLabeledReturnInsideLambda.kt");
                }

                @Test
                @TestMetadata("differentDelegatedExpressions.kt")
                public void testDifferentDelegatedExpressions() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegatedProperty/inference/differentDelegatedExpressions.kt");
                }

                @Test
                @TestMetadata("extensionGet.kt")
                public void testExtensionGet() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegatedProperty/inference/extensionGet.kt");
                }

                @Test
                @TestMetadata("extensionProperty.kt")
                public void testExtensionProperty() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegatedProperty/inference/extensionProperty.kt");
                }

                @Test
                @TestMetadata("genericMethodInGenericClass.kt")
                public void testGenericMethodInGenericClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegatedProperty/inference/genericMethodInGenericClass.kt");
                }

                @Test
                @TestMetadata("genericMethods.kt")
                public void testGenericMethods() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegatedProperty/inference/genericMethods.kt");
                }

                @Test
                @TestMetadata("labeledDelegatedExpression.kt")
                public void testLabeledDelegatedExpression() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegatedProperty/inference/labeledDelegatedExpression.kt");
                }

                @Test
                @TestMetadata("manyIncompleteCandidates.kt")
                public void testManyIncompleteCandidates() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegatedProperty/inference/manyIncompleteCandidates.kt");
                }

                @Test
                @TestMetadata("noErrorsForImplicitConstraints.kt")
                public void testNoErrorsForImplicitConstraints() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegatedProperty/inference/noErrorsForImplicitConstraints.kt");
                }

                @Test
                @TestMetadata("noExpectedTypeForSupertypeConstraint.kt")
                public void testNoExpectedTypeForSupertypeConstraint() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegatedProperty/inference/noExpectedTypeForSupertypeConstraint.kt");
                }

                @Test
                @TestMetadata("resultTypeOfLambdaForConventionMethods.kt")
                public void testResultTypeOfLambdaForConventionMethods() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegatedProperty/inference/resultTypeOfLambdaForConventionMethods.kt");
                }

                @Test
                @TestMetadata("typeOfLazyDelegatedPropertyWithObject.kt")
                public void testTypeOfLazyDelegatedPropertyWithObject() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegatedProperty/inference/typeOfLazyDelegatedPropertyWithObject.kt");
                }

                @Test
                @TestMetadata("useCompleterWithoutExpectedType.kt")
                public void testUseCompleterWithoutExpectedType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegatedProperty/inference/useCompleterWithoutExpectedType.kt");
                }

                @Test
                @TestMetadata("useExpectedType.kt")
                public void testUseExpectedType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegatedProperty/inference/useExpectedType.kt");
                }

                @Test
                @TestMetadata("useExpectedTypeForVal.kt")
                public void testUseExpectedTypeForVal() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegatedProperty/inference/useExpectedTypeForVal.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/delegatedProperty/provideDelegate")
            @TestDataPath("$PROJECT_ROOT")
            public class ProvideDelegate {
                @Test
                public void testAllFilesPresentInProvideDelegate() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/delegatedProperty/provideDelegate"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("commonCaseForInference.kt")
                public void testCommonCaseForInference() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegatedProperty/provideDelegate/commonCaseForInference.kt");
                }

                @Test
                @TestMetadata("genericProvideDelegate.kt")
                public void testGenericProvideDelegate() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegatedProperty/provideDelegate/genericProvideDelegate.kt");
                }

                @Test
                @TestMetadata("hostAndReceiver1.kt")
                public void testHostAndReceiver1() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegatedProperty/provideDelegate/hostAndReceiver1.kt");
                }

                @Test
                @TestMetadata("hostAndReceiver2.kt")
                public void testHostAndReceiver2() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegatedProperty/provideDelegate/hostAndReceiver2.kt");
                }

                @Test
                @TestMetadata("hostAndReceiver3.kt")
                public void testHostAndReceiver3() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegatedProperty/provideDelegate/hostAndReceiver3.kt");
                }

                @Test
                @TestMetadata("inferenceFromReceiver1.kt")
                public void testInferenceFromReceiver1() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegatedProperty/provideDelegate/inferenceFromReceiver1.kt");
                }

                @Test
                @TestMetadata("inferenceFromReceiver2.kt")
                public void testInferenceFromReceiver2() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegatedProperty/provideDelegate/inferenceFromReceiver2.kt");
                }

                @Test
                @TestMetadata("kt38714.kt")
                public void testKt38714() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegatedProperty/provideDelegate/kt38714.kt");
                }

                @Test
                @TestMetadata("localDelegatedProperty.kt")
                public void testLocalDelegatedProperty() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegatedProperty/provideDelegate/localDelegatedProperty.kt");
                }

                @Test
                @TestMetadata("noOperatorModifierOnProvideDelegate.kt")
                public void testNoOperatorModifierOnProvideDelegate() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegatedProperty/provideDelegate/noOperatorModifierOnProvideDelegate.kt");
                }

                @Test
                @TestMetadata("overloadResolutionForSeveralProvideDelegates.kt")
                public void testOverloadResolutionForSeveralProvideDelegates() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegatedProperty/provideDelegate/overloadResolutionForSeveralProvideDelegates.kt");
                }

                @Test
                @TestMetadata("provideDelegateOnFunctionalTypeWithThis.kt")
                public void testProvideDelegateOnFunctionalTypeWithThis() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegatedProperty/provideDelegate/provideDelegateOnFunctionalTypeWithThis.kt");
                }

                @Test
                @TestMetadata("provideDelegateOperatorDeclaration.kt")
                public void testProvideDelegateOperatorDeclaration() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegatedProperty/provideDelegate/provideDelegateOperatorDeclaration.kt");
                }

                @Test
                @TestMetadata("provideDelegateResolutionWithStubTypes.kt")
                public void testProvideDelegateResolutionWithStubTypes() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegatedProperty/provideDelegate/provideDelegateResolutionWithStubTypes.kt");
                }

                @Test
                @TestMetadata("setValue.kt")
                public void testSetValue() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegatedProperty/provideDelegate/setValue.kt");
                }

                @Test
                @TestMetadata("simpleProvideDelegate.kt")
                public void testSimpleProvideDelegate() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegatedProperty/provideDelegate/simpleProvideDelegate.kt");
                }
            }
        }

        @Nested
        @TestMetadata("compiler/testData/diagnostics/tests/delegation")
        @TestDataPath("$PROJECT_ROOT")
        public class Delegation {
            @Test
            public void testAllFilesPresentInDelegation() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/delegation"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
            }

            @Test
            @TestMetadata("DelegationAndOverriding.kt")
            public void testDelegationAndOverriding() throws Exception {
                runTest("compiler/testData/diagnostics/tests/delegation/DelegationAndOverriding.kt");
            }

            @Test
            @TestMetadata("DelegationExpectedType.kt")
            public void testDelegationExpectedType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/delegation/DelegationExpectedType.kt");
            }

            @Test
            @TestMetadata("DelegationNotTotrait.kt")
            public void testDelegationNotTotrait() throws Exception {
                runTest("compiler/testData/diagnostics/tests/delegation/DelegationNotTotrait.kt");
            }

            @Test
            @TestMetadata("DelegationToJavaIface.kt")
            public void testDelegationToJavaIface() throws Exception {
                runTest("compiler/testData/diagnostics/tests/delegation/DelegationToJavaIface.kt");
            }

            @Test
            @TestMetadata("Delegation_ClashingFunctions.kt")
            public void testDelegation_ClashingFunctions() throws Exception {
                runTest("compiler/testData/diagnostics/tests/delegation/Delegation_ClashingFunctions.kt");
            }

            @Test
            @TestMetadata("Delegation_Hierarchy.kt")
            public void testDelegation_Hierarchy() throws Exception {
                runTest("compiler/testData/diagnostics/tests/delegation/Delegation_Hierarchy.kt");
            }

            @Test
            @TestMetadata("Delegation_MultipleDelegates.kt")
            public void testDelegation_MultipleDelegates() throws Exception {
                runTest("compiler/testData/diagnostics/tests/delegation/Delegation_MultipleDelegates.kt");
            }

            @Test
            @TestMetadata("Delegation_ScopeInitializationOrder.kt")
            public void testDelegation_ScopeInitializationOrder() throws Exception {
                runTest("compiler/testData/diagnostics/tests/delegation/Delegation_ScopeInitializationOrder.kt");
            }

            @Test
            @TestMetadata("kt40510.kt")
            public void testKt40510() throws Exception {
                runTest("compiler/testData/diagnostics/tests/delegation/kt40510.kt");
            }

            @Test
            @TestMetadata("kt44843.kt")
            public void testKt44843() throws Exception {
                runTest("compiler/testData/diagnostics/tests/delegation/kt44843.kt");
            }

            @Test
            @TestMetadata("kt48546.kt")
            public void testKt48546() throws Exception {
                runTest("compiler/testData/diagnostics/tests/delegation/kt48546.kt");
            }

            @Test
            @TestMetadata("kt49477.kt")
            public void testKt49477() throws Exception {
                runTest("compiler/testData/diagnostics/tests/delegation/kt49477.kt");
            }

            @Test
            @TestMetadata("kt49477Error.kt")
            public void testKt49477Error() throws Exception {
                runTest("compiler/testData/diagnostics/tests/delegation/kt49477Error.kt");
            }

            @Test
            @TestMetadata("kt8154.kt")
            public void testKt8154() throws Exception {
                runTest("compiler/testData/diagnostics/tests/delegation/kt8154.kt");
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/delegation/clashes")
            @TestDataPath("$PROJECT_ROOT")
            public class Clashes {
                @Test
                public void testAllFilesPresentInClashes() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/delegation/clashes"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("finalMemberOverridden.kt")
                public void testFinalMemberOverridden() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegation/clashes/finalMemberOverridden.kt");
                }

                @Test
                @TestMetadata("propertyTypeMismatch.kt")
                public void testPropertyTypeMismatch() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegation/clashes/propertyTypeMismatch.kt");
                }

                @Test
                @TestMetadata("returnTypeMismatch.kt")
                public void testReturnTypeMismatch() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegation/clashes/returnTypeMismatch.kt");
                }

                @Test
                @TestMetadata("varOverriddenByVal.kt")
                public void testVarOverriddenByVal() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegation/clashes/varOverriddenByVal.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/delegation/covariantOverrides")
            @TestDataPath("$PROJECT_ROOT")
            public class CovariantOverrides {
                @Test
                public void testAllFilesPresentInCovariantOverrides() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/delegation/covariantOverrides"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("fromClass.kt")
                public void testFromClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegation/covariantOverrides/fromClass.kt");
                }

                @Test
                @TestMetadata("irrelevant.kt")
                public void testIrrelevant() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegation/covariantOverrides/irrelevant.kt");
                }

                @Test
                @TestMetadata("kt13952.kt")
                public void testKt13952() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegation/covariantOverrides/kt13952.kt");
                }

                @Test
                @TestMetadata("simple.kt")
                public void testSimple() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegation/covariantOverrides/simple.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/delegation/memberHidesSupertypeOverride")
            @TestDataPath("$PROJECT_ROOT")
            public class MemberHidesSupertypeOverride {
                @Test
                @TestMetadata("abstractOverride.kt")
                public void testAbstractOverride() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegation/memberHidesSupertypeOverride/abstractOverride.kt");
                }

                @Test
                public void testAllFilesPresentInMemberHidesSupertypeOverride() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/delegation/memberHidesSupertypeOverride"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("delegationToSubType.kt")
                public void testDelegationToSubType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegation/memberHidesSupertypeOverride/delegationToSubType.kt");
                }

                @Test
                @TestMetadata("delegationToSubTypeProperty.kt")
                public void testDelegationToSubTypeProperty() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegation/memberHidesSupertypeOverride/delegationToSubTypeProperty.kt");
                }

                @Test
                @TestMetadata("delegationToSubTypeWithOverride.kt")
                public void testDelegationToSubTypeWithOverride() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegation/memberHidesSupertypeOverride/delegationToSubTypeWithOverride.kt");
                }

                @Test
                @TestMetadata("delegationToSubTypeWithOverrideProperty.kt")
                public void testDelegationToSubTypeWithOverrideProperty() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegation/memberHidesSupertypeOverride/delegationToSubTypeWithOverrideProperty.kt");
                }

                @Test
                @TestMetadata("diamond.kt")
                public void testDiamond() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegation/memberHidesSupertypeOverride/diamond.kt");
                }

                @Test
                @TestMetadata("explicitOverride.kt")
                public void testExplicitOverride() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegation/memberHidesSupertypeOverride/explicitOverride.kt");
                }

                @Test
                @TestMetadata("fakeOverrideInTheMiddle.kt")
                public void testFakeOverrideInTheMiddle() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegation/memberHidesSupertypeOverride/fakeOverrideInTheMiddle.kt");
                }

                @Test
                @TestMetadata("generic.kt")
                public void testGeneric() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegation/memberHidesSupertypeOverride/generic.kt");
                }

                @Test
                @TestMetadata("sameDelegationInHierarchy.kt")
                public void testSameDelegationInHierarchy() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegation/memberHidesSupertypeOverride/sameDelegationInHierarchy.kt");
                }

                @Test
                @TestMetadata("sameDelegationInHierarchy2.kt")
                public void testSameDelegationInHierarchy2() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegation/memberHidesSupertypeOverride/sameDelegationInHierarchy2.kt");
                }

                @Test
                @TestMetadata("severalDelegates.kt")
                public void testSeveralDelegates() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegation/memberHidesSupertypeOverride/severalDelegates.kt");
                }

                @Test
                @TestMetadata("simple.kt")
                public void testSimple() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegation/memberHidesSupertypeOverride/simple.kt");
                }

                @Test
                @TestMetadata("simpleNoOverride.kt")
                public void testSimpleNoOverride() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegation/memberHidesSupertypeOverride/simpleNoOverride.kt");
                }

                @Test
                @TestMetadata("simpleProp.kt")
                public void testSimpleProp() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/delegation/memberHidesSupertypeOverride/simpleProp.kt");
                }
            }
        }

        @Nested
        @TestMetadata("compiler/testData/diagnostics/tests/deparenthesize")
        @TestDataPath("$PROJECT_ROOT")
        public class Deparenthesize {
            @Test
            public void testAllFilesPresentInDeparenthesize() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/deparenthesize"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
            }

            @Test
            @TestMetadata("annotatedSafeCall.kt")
            public void testAnnotatedSafeCall() throws Exception {
                runTest("compiler/testData/diagnostics/tests/deparenthesize/annotatedSafeCall.kt");
            }

            @Test
            @TestMetadata("checkDeparenthesizedType.kt")
            public void testCheckDeparenthesizedType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/deparenthesize/checkDeparenthesizedType.kt");
            }

            @Test
            @TestMetadata("labeledSafeCall.kt")
            public void testLabeledSafeCall() throws Exception {
                runTest("compiler/testData/diagnostics/tests/deparenthesize/labeledSafeCall.kt");
            }

            @Test
            @TestMetadata("multiParenthesizedSafeCall.kt")
            public void testMultiParenthesizedSafeCall() throws Exception {
                runTest("compiler/testData/diagnostics/tests/deparenthesize/multiParenthesizedSafeCall.kt");
            }

            @Test
            @TestMetadata("parenthesizedSafeCall.kt")
            public void testParenthesizedSafeCall() throws Exception {
                runTest("compiler/testData/diagnostics/tests/deparenthesize/parenthesizedSafeCall.kt");
            }

            @Test
            @TestMetadata("ParenthesizedVariable.kt")
            public void testParenthesizedVariable() throws Exception {
                runTest("compiler/testData/diagnostics/tests/deparenthesize/ParenthesizedVariable.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/diagnostics/tests/deprecated")
        @TestDataPath("$PROJECT_ROOT")
        public class Deprecated {
            @Test
            public void testAllFilesPresentInDeprecated() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/deprecated"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
            }

            @Test
            @TestMetadata("annotationUsage.kt")
            public void testAnnotationUsage() throws Exception {
                runTest("compiler/testData/diagnostics/tests/deprecated/annotationUsage.kt");
            }

            @Test
            @TestMetadata("candidateBehindHiddenPropertyAccessors.kt")
            public void testCandidateBehindHiddenPropertyAccessors() throws Exception {
                runTest("compiler/testData/diagnostics/tests/deprecated/candidateBehindHiddenPropertyAccessors.kt");
            }

            @Test
            @TestMetadata("classWithCompanionObject.kt")
            public void testClassWithCompanionObject() throws Exception {
                runTest("compiler/testData/diagnostics/tests/deprecated/classWithCompanionObject.kt");
            }

            @Test
            @TestMetadata("companionObjectUsage.kt")
            public void testCompanionObjectUsage() throws Exception {
                runTest("compiler/testData/diagnostics/tests/deprecated/companionObjectUsage.kt");
            }

            @Test
            @TestMetadata("componentUsage.kt")
            public void testComponentUsage() throws Exception {
                runTest("compiler/testData/diagnostics/tests/deprecated/componentUsage.kt");
            }

            @Test
            @TestMetadata("deprecatedConstructor.kt")
            public void testDeprecatedConstructor() throws Exception {
                runTest("compiler/testData/diagnostics/tests/deprecated/deprecatedConstructor.kt");
            }

            @Test
            @TestMetadata("deprecatedError.kt")
            public void testDeprecatedError() throws Exception {
                runTest("compiler/testData/diagnostics/tests/deprecated/deprecatedError.kt");
            }

            @Test
            @TestMetadata("deprecatedErrorBuilder.kt")
            public void testDeprecatedErrorBuilder() throws Exception {
                runTest("compiler/testData/diagnostics/tests/deprecated/deprecatedErrorBuilder.kt");
            }

            @Test
            @TestMetadata("deprecatedHidden.kt")
            public void testDeprecatedHidden() throws Exception {
                runTest("compiler/testData/diagnostics/tests/deprecated/deprecatedHidden.kt");
            }

            @Test
            @TestMetadata("deprecatedHiddenOnCallableReferenceArgument.kt")
            public void testDeprecatedHiddenOnCallableReferenceArgument() throws Exception {
                runTest("compiler/testData/diagnostics/tests/deprecated/deprecatedHiddenOnCallableReferenceArgument.kt");
            }

            @Test
            @TestMetadata("deprecatedInheritance_after.kt")
            public void testDeprecatedInheritance_after() throws Exception {
                runTest("compiler/testData/diagnostics/tests/deprecated/deprecatedInheritance_after.kt");
            }

            @Test
            @TestMetadata("deprecatedInheritance_before.kt")
            public void testDeprecatedInheritance_before() throws Exception {
                runTest("compiler/testData/diagnostics/tests/deprecated/deprecatedInheritance_before.kt");
            }

            @Test
            @TestMetadata("deprecatedPropertyInheritance_after.kt")
            public void testDeprecatedPropertyInheritance_after() throws Exception {
                runTest("compiler/testData/diagnostics/tests/deprecated/deprecatedPropertyInheritance_after.kt");
            }

            @Test
            @TestMetadata("deprecatedPropertyInheritance_before.kt")
            public void testDeprecatedPropertyInheritance_before() throws Exception {
                runTest("compiler/testData/diagnostics/tests/deprecated/deprecatedPropertyInheritance_before.kt");
            }

            @Test
            @TestMetadata("duplicatedOverrideDeprecationOnProperty.kt")
            public void testDuplicatedOverrideDeprecationOnProperty() throws Exception {
                runTest("compiler/testData/diagnostics/tests/deprecated/duplicatedOverrideDeprecationOnProperty.kt");
            }

            @Test
            @TestMetadata("functionUsage.kt")
            public void testFunctionUsage() throws Exception {
                runTest("compiler/testData/diagnostics/tests/deprecated/functionUsage.kt");
            }

            @Test
            @TestMetadata("genericConstructorUsage.kt")
            public void testGenericConstructorUsage() throws Exception {
                runTest("compiler/testData/diagnostics/tests/deprecated/genericConstructorUsage.kt");
            }

            @Test
            @TestMetadata("hiddenPropertyAccessors.kt")
            public void testHiddenPropertyAccessors() throws Exception {
                runTest("compiler/testData/diagnostics/tests/deprecated/hiddenPropertyAccessors.kt");
            }

            @Test
            @TestMetadata("importJavaSamInterface.kt")
            public void testImportJavaSamInterface() throws Exception {
                runTest("compiler/testData/diagnostics/tests/deprecated/importJavaSamInterface.kt");
            }

            @Test
            @TestMetadata("imports.kt")
            public void testImports() throws Exception {
                runTest("compiler/testData/diagnostics/tests/deprecated/imports.kt");
            }

            @Test
            @TestMetadata("iteratorUsage.kt")
            public void testIteratorUsage() throws Exception {
                runTest("compiler/testData/diagnostics/tests/deprecated/iteratorUsage.kt");
            }

            @Test
            @TestMetadata("javaDeprecated.kt")
            public void testJavaDeprecated() throws Exception {
                runTest("compiler/testData/diagnostics/tests/deprecated/javaDeprecated.kt");
            }

            @Test
            @TestMetadata("javaDeprecatedInheritance.kt")
            public void testJavaDeprecatedInheritance() throws Exception {
                runTest("compiler/testData/diagnostics/tests/deprecated/javaDeprecatedInheritance.kt");
            }

            @Test
            @TestMetadata("javaDocDeprecated.kt")
            public void testJavaDocDeprecated() throws Exception {
                runTest("compiler/testData/diagnostics/tests/deprecated/javaDocDeprecated.kt");
            }

            @Test
            @TestMetadata("nestedTypesUsage.kt")
            public void testNestedTypesUsage() throws Exception {
                runTest("compiler/testData/diagnostics/tests/deprecated/nestedTypesUsage.kt");
            }

            @Test
            @TestMetadata("objectUsage.kt")
            public void testObjectUsage() throws Exception {
                runTest("compiler/testData/diagnostics/tests/deprecated/objectUsage.kt");
            }

            @Test
            @TestMetadata("propertyUsage.kt")
            public void testPropertyUsage() throws Exception {
                runTest("compiler/testData/diagnostics/tests/deprecated/propertyUsage.kt");
            }

            @Test
            @TestMetadata("propertyUseSiteTargetedAnnotations.kt")
            public void testPropertyUseSiteTargetedAnnotations() throws Exception {
                runTest("compiler/testData/diagnostics/tests/deprecated/propertyUseSiteTargetedAnnotations.kt");
            }

            @Test
            @TestMetadata("propertyWithInvoke.kt")
            public void testPropertyWithInvoke() throws Exception {
                runTest("compiler/testData/diagnostics/tests/deprecated/propertyWithInvoke.kt");
            }

            @Test
            @TestMetadata("thisUsage.kt")
            public void testThisUsage() throws Exception {
                runTest("compiler/testData/diagnostics/tests/deprecated/thisUsage.kt");
            }

            @Test
            @TestMetadata("typeUsage.kt")
            public void testTypeUsage() throws Exception {
                runTest("compiler/testData/diagnostics/tests/deprecated/typeUsage.kt");
            }

            @Test
            @TestMetadata("typealiasCompanionObject.kt")
            public void testTypealiasCompanionObject() throws Exception {
                runTest("compiler/testData/diagnostics/tests/deprecated/typealiasCompanionObject.kt");
            }

            @Test
            @TestMetadata("typealiasConstructor.kt")
            public void testTypealiasConstructor() throws Exception {
                runTest("compiler/testData/diagnostics/tests/deprecated/typealiasConstructor.kt");
            }

            @Test
            @TestMetadata("typealiasForDeprecatedClass.kt")
            public void testTypealiasForDeprecatedClass() throws Exception {
                runTest("compiler/testData/diagnostics/tests/deprecated/typealiasForDeprecatedClass.kt");
            }

            @Test
            @TestMetadata("typealiasUsage.kt")
            public void testTypealiasUsage() throws Exception {
                runTest("compiler/testData/diagnostics/tests/deprecated/typealiasUsage.kt");
            }

            @Test
            @TestMetadata("unusedImport.kt")
            public void testUnusedImport() throws Exception {
                runTest("compiler/testData/diagnostics/tests/deprecated/unusedImport.kt");
            }

            @Test
            @TestMetadata("usageOnEnum.kt")
            public void testUsageOnEnum() throws Exception {
                runTest("compiler/testData/diagnostics/tests/deprecated/usageOnEnum.kt");
            }

            @Test
            @TestMetadata("warningOnConstructorErrorOnClass.kt")
            public void testWarningOnConstructorErrorOnClass() throws Exception {
                runTest("compiler/testData/diagnostics/tests/deprecated/warningOnConstructorErrorOnClass.kt");
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/deprecated/deprecatedSinceKotlin")
            @TestDataPath("$PROJECT_ROOT")
            public class DeprecatedSinceKotlin {
                @Test
                public void testAllFilesPresentInDeprecatedSinceKotlin() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/deprecated/deprecatedSinceKotlin"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("checkValuesAreParseableAsVersion.kt")
                public void testCheckValuesAreParseableAsVersion() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/deprecated/deprecatedSinceKotlin/checkValuesAreParseableAsVersion.kt");
                }

                @Test
                @TestMetadata("deprecatedSinceKotlinDeclaration.kt")
                public void testDeprecatedSinceKotlinDeclaration() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/deprecated/deprecatedSinceKotlin/deprecatedSinceKotlinDeclaration.kt");
                }

                @Test
                @TestMetadata("deprecatedSinceKotlinHiddenOnReferenceArgument.kt")
                public void testDeprecatedSinceKotlinHiddenOnReferenceArgument() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/deprecated/deprecatedSinceKotlin/deprecatedSinceKotlinHiddenOnReferenceArgument.kt");
                }

                @Test
                @TestMetadata("deprecatedSinceKotlinOutsideKotlinPackage.kt")
                public void testDeprecatedSinceKotlinOutsideKotlinPackage() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/deprecated/deprecatedSinceKotlin/deprecatedSinceKotlinOutsideKotlinPackage.kt");
                }

                @Test
                @TestMetadata("deprecatedSinceKotlinWithoutArguments.kt")
                public void testDeprecatedSinceKotlinWithoutArguments() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/deprecated/deprecatedSinceKotlin/deprecatedSinceKotlinWithoutArguments.kt");
                }

                @Test
                @TestMetadata("error.kt")
                public void testError() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/deprecated/deprecatedSinceKotlin/error.kt");
                }

                @Test
                @TestMetadata("hidden.kt")
                public void testHidden() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/deprecated/deprecatedSinceKotlin/hidden.kt");
                }

                @Test
                @TestMetadata("messageFromDeprecatedAnnotation.kt")
                public void testMessageFromDeprecatedAnnotation() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/deprecated/deprecatedSinceKotlin/messageFromDeprecatedAnnotation.kt");
                }

                @Test
                @TestMetadata("warning.kt")
                public void testWarning() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/deprecated/deprecatedSinceKotlin/warning.kt");
                }
            }
        }

        @Nested
        @TestMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature")
        @TestDataPath("$PROJECT_ROOT")
        public class DuplicateJvmSignature {
            @Test
            public void testAllFilesPresentInDuplicateJvmSignature() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/duplicateJvmSignature"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
            }

            @Test
            @TestMetadata("caseInProperties.kt")
            public void testCaseInProperties() throws Exception {
                runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/caseInProperties.kt");
            }

            @Test
            @TestMetadata("missingNames.kt")
            public void testMissingNames() throws Exception {
                runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/missingNames.kt");
            }

            @Test
            @TestMetadata("vararg.kt")
            public void testVararg() throws Exception {
                runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/vararg.kt");
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/accidentalOverrides")
            @TestDataPath("$PROJECT_ROOT")
            public class AccidentalOverrides {
                @Test
                @TestMetadata("accidentalOverrideFromGrandparent.kt")
                public void testAccidentalOverrideFromGrandparent() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/accidentalOverrides/accidentalOverrideFromGrandparent.kt");
                }

                @Test
                public void testAllFilesPresentInAccidentalOverrides() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/duplicateJvmSignature/accidentalOverrides"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("classFunctionOverriddenByProperty.kt")
                public void testClassFunctionOverriddenByProperty() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/accidentalOverrides/classFunctionOverriddenByProperty.kt");
                }

                @Test
                @TestMetadata("classFunctionOverriddenByPropertyInConstructor.kt")
                public void testClassFunctionOverriddenByPropertyInConstructor() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/accidentalOverrides/classFunctionOverriddenByPropertyInConstructor.kt");
                }

                @Test
                @TestMetadata("classFunctionOverriddenByPropertyNoGetter.kt")
                public void testClassFunctionOverriddenByPropertyNoGetter() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/accidentalOverrides/classFunctionOverriddenByPropertyNoGetter.kt");
                }

                @Test
                @TestMetadata("classPropertyOverriddenByFunction.kt")
                public void testClassPropertyOverriddenByFunction() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/accidentalOverrides/classPropertyOverriddenByFunction.kt");
                }

                @Test
                @TestMetadata("defaultFunction.kt")
                public void testDefaultFunction() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/accidentalOverrides/defaultFunction.kt");
                }

                @Test
                @TestMetadata("delegatedFunctionOverriddenByProperty.kt")
                public void testDelegatedFunctionOverriddenByProperty() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/accidentalOverrides/delegatedFunctionOverriddenByProperty.kt");
                }

                @Test
                @TestMetadata("genericClassFunction.kt")
                public void testGenericClassFunction() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/accidentalOverrides/genericClassFunction.kt");
                }

                @Test
                @TestMetadata("overridesNothing.kt")
                public void testOverridesNothing() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/accidentalOverrides/overridesNothing.kt");
                }

                @Test
                @TestMetadata("privateClassFunctionOverriddenByProperty.kt")
                public void testPrivateClassFunctionOverriddenByProperty() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/accidentalOverrides/privateClassFunctionOverriddenByProperty.kt");
                }

                @Test
                @TestMetadata("require.kt")
                public void testRequire() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/accidentalOverrides/require.kt");
                }

                @Test
                @TestMetadata("traitFunctionOverriddenByProperty.kt")
                public void testTraitFunctionOverriddenByProperty() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/accidentalOverrides/traitFunctionOverriddenByProperty.kt");
                }

                @Test
                @TestMetadata("traitFunctionOverriddenByPropertyNoImpl.kt")
                public void testTraitFunctionOverriddenByPropertyNoImpl() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/accidentalOverrides/traitFunctionOverriddenByPropertyNoImpl.kt");
                }

                @Test
                @TestMetadata("traitPropertyOverriddenByFunction.kt")
                public void testTraitPropertyOverriddenByFunction() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/accidentalOverrides/traitPropertyOverriddenByFunction.kt");
                }

                @Test
                @TestMetadata("traitPropertyOverriddenByFunctionNoImpl.kt")
                public void testTraitPropertyOverriddenByFunctionNoImpl() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/accidentalOverrides/traitPropertyOverriddenByFunctionNoImpl.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/bridges")
            @TestDataPath("$PROJECT_ROOT")
            public class Bridges {
                @Test
                public void testAllFilesPresentInBridges() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/duplicateJvmSignature/bridges"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("class.kt")
                public void testClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/bridges/class.kt");
                }

                @Test
                @TestMetadata("fakeOverrideTrait.kt")
                public void testFakeOverrideTrait() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/bridges/fakeOverrideTrait.kt");
                }

                @Test
                @TestMetadata("trait.kt")
                public void testTrait() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/bridges/trait.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/erasure")
            @TestDataPath("$PROJECT_ROOT")
            public class Erasure {
                @Test
                public void testAllFilesPresentInErasure() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/duplicateJvmSignature/erasure"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("clashFromInterfaceAndSuperClass.kt")
                public void testClashFromInterfaceAndSuperClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/erasure/clashFromInterfaceAndSuperClass.kt");
                }

                @Test
                @TestMetadata("collections.kt")
                public void testCollections() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/erasure/collections.kt");
                }

                @Test
                @TestMetadata("delegateToTwoTraits.kt")
                public void testDelegateToTwoTraits() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/erasure/delegateToTwoTraits.kt");
                }

                @Test
                @TestMetadata("delegationAndOwnMethod.kt")
                public void testDelegationAndOwnMethod() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/erasure/delegationAndOwnMethod.kt");
                }

                @Test
                @TestMetadata("delegationToTraitImplAndOwnMethod.kt")
                public void testDelegationToTraitImplAndOwnMethod() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/erasure/delegationToTraitImplAndOwnMethod.kt");
                }

                @Test
                @TestMetadata("extensionProperties.kt")
                public void testExtensionProperties() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/erasure/extensionProperties.kt");
                }

                @Test
                @TestMetadata("genericType.kt")
                public void testGenericType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/erasure/genericType.kt");
                }

                @Test
                @TestMetadata("inheritFromTwoTraits.kt")
                public void testInheritFromTwoTraits() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/erasure/inheritFromTwoTraits.kt");
                }

                @Test
                @TestMetadata("kotlinAndJavaCollections.kt")
                public void testKotlinAndJavaCollections() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/erasure/kotlinAndJavaCollections.kt");
                }

                @Test
                @TestMetadata("nullableType.kt")
                public void testNullableType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/erasure/nullableType.kt");
                }

                @Test
                @TestMetadata("superTraitAndDelegationToTraitImpl.kt")
                public void testSuperTraitAndDelegationToTraitImpl() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/erasure/superTraitAndDelegationToTraitImpl.kt");
                }

                @Test
                @TestMetadata("twoTraitsAndOwnFunction.kt")
                public void testTwoTraitsAndOwnFunction() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/erasure/twoTraitsAndOwnFunction.kt");
                }

                @Test
                @TestMetadata("typeMappedToJava.kt")
                public void testTypeMappedToJava() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/erasure/typeMappedToJava.kt");
                }

                @Test
                @TestMetadata("typeParameter.kt")
                public void testTypeParameter() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/erasure/typeParameter.kt");
                }

                @Test
                @TestMetadata("typeParameterWithBound.kt")
                public void testTypeParameterWithBound() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/erasure/typeParameterWithBound.kt");
                }

                @Test
                @TestMetadata("typeParameterWithTwoBounds.kt")
                public void testTypeParameterWithTwoBounds() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/erasure/typeParameterWithTwoBounds.kt");
                }

                @Test
                @TestMetadata("typeParameterWithTwoBoundsInWhere.kt")
                public void testTypeParameterWithTwoBoundsInWhere() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/erasure/typeParameterWithTwoBoundsInWhere.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/finalMembersFromBuiltIns")
            @TestDataPath("$PROJECT_ROOT")
            public class FinalMembersFromBuiltIns {
                @Test
                public void testAllFilesPresentInFinalMembersFromBuiltIns() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/duplicateJvmSignature/finalMembersFromBuiltIns"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("enumMembers.kt")
                public void testEnumMembers() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/finalMembersFromBuiltIns/enumMembers.kt");
                }

                @Test
                @TestMetadata("waitNotifyGetClass.kt")
                public void testWaitNotifyGetClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/finalMembersFromBuiltIns/waitNotifyGetClass.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/functionAndProperty")
            @TestDataPath("$PROJECT_ROOT")
            public class FunctionAndProperty {
                @Test
                public void testAllFilesPresentInFunctionAndProperty() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/duplicateJvmSignature/functionAndProperty"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("class.kt")
                public void testClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/functionAndProperty/class.kt");
                }

                @Test
                @TestMetadata("classObject.kt")
                public void testClassObject() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/functionAndProperty/classObject.kt");
                }

                @Test
                @TestMetadata("classPropertyInConstructor.kt")
                public void testClassPropertyInConstructor() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/functionAndProperty/classPropertyInConstructor.kt");
                }

                @Test
                @TestMetadata("extensionFunctionAndNormalFunction.kt")
                public void testExtensionFunctionAndNormalFunction() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/functionAndProperty/extensionFunctionAndNormalFunction.kt");
                }

                @Test
                @TestMetadata("extensionPropertyAndFunction.kt")
                public void testExtensionPropertyAndFunction() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/functionAndProperty/extensionPropertyAndFunction.kt");
                }

                @Test
                @TestMetadata("functionAndSetter.kt")
                public void testFunctionAndSetter() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/functionAndProperty/functionAndSetter.kt");
                }

                @Test
                @TestMetadata("functionAndVar.kt")
                public void testFunctionAndVar() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/functionAndProperty/functionAndVar.kt");
                }

                @Test
                @TestMetadata("localClass.kt")
                public void testLocalClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/functionAndProperty/localClass.kt");
                }

                @Test
                @TestMetadata("localClassInClass.kt")
                public void testLocalClassInClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/functionAndProperty/localClassInClass.kt");
                }

                @Test
                @TestMetadata("nestedClass.kt")
                public void testNestedClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/functionAndProperty/nestedClass.kt");
                }

                @Test
                @TestMetadata("object.kt")
                public void testObject() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/functionAndProperty/object.kt");
                }

                @Test
                @TestMetadata("objectExpression.kt")
                public void testObjectExpression() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/functionAndProperty/objectExpression.kt");
                }

                @Test
                @TestMetadata("objectExpressionInConstructor.kt")
                public void testObjectExpressionInConstructor() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/functionAndProperty/objectExpressionInConstructor.kt");
                }

                @Test
                @TestMetadata("privateClassPropertyNoClash.kt")
                public void testPrivateClassPropertyNoClash() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/functionAndProperty/privateClassPropertyNoClash.kt");
                }

                @Test
                @TestMetadata("topLevel.kt")
                public void testTopLevel() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/functionAndProperty/topLevel.kt");
                }

                @Test
                @TestMetadata("topLevelDifferentFiles.kt")
                public void testTopLevelDifferentFiles() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/functionAndProperty/topLevelDifferentFiles.kt");
                }

                @Test
                @TestMetadata("topLevelGetter.kt")
                public void testTopLevelGetter() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/functionAndProperty/topLevelGetter.kt");
                }

                @Test
                @TestMetadata("trait.kt")
                public void testTrait() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/functionAndProperty/trait.kt");
                }

                @Test
                @TestMetadata("withErrorTypes.kt")
                public void testWithErrorTypes() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/functionAndProperty/withErrorTypes.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/specialNames")
            @TestDataPath("$PROJECT_ROOT")
            public class SpecialNames {
                @Test
                public void testAllFilesPresentInSpecialNames() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/duplicateJvmSignature/specialNames"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("classObject.kt")
                public void testClassObject() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/specialNames/classObject.kt");
                }

                @Test
                @TestMetadata("classObjectCopiedField.kt")
                public void testClassObjectCopiedField() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/specialNames/classObjectCopiedField.kt");
                }

                @Test
                @TestMetadata("classObjectCopiedFieldObject.kt")
                public void testClassObjectCopiedFieldObject() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/specialNames/classObjectCopiedFieldObject.kt");
                }

                @Test
                @TestMetadata("dataClassCopy.kt")
                public void testDataClassCopy() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/specialNames/dataClassCopy.kt");
                }

                @Test
                @TestMetadata("delegationBy.kt")
                public void testDelegationBy() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/specialNames/delegationBy.kt");
                }

                @Test
                @TestMetadata("enum.kt")
                public void testEnum() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/specialNames/enum.kt");
                }

                @Test
                @TestMetadata("innerClassField.kt")
                public void testInnerClassField() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/specialNames/innerClassField.kt");
                }

                @Test
                @TestMetadata("instance.kt")
                public void testInstance() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/specialNames/instance.kt");
                }

                @Test
                @TestMetadata("propertyMetadataCache.kt")
                public void testPropertyMetadataCache() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/specialNames/propertyMetadataCache.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/statics")
            @TestDataPath("$PROJECT_ROOT")
            public class Statics {
                @Test
                public void testAllFilesPresentInStatics() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/duplicateJvmSignature/statics"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("jkjk.kt")
                public void testJkjk() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/statics/jkjk.kt");
                }

                @Test
                @TestMetadata("kotlinClassExtendsJavaClass.kt")
                public void testKotlinClassExtendsJavaClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/statics/kotlinClassExtendsJavaClass.kt");
                }

                @Test
                @TestMetadata("kotlinClassExtendsJavaClassExtendsJavaClass.kt")
                public void testKotlinClassExtendsJavaClassExtendsJavaClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/statics/kotlinClassExtendsJavaClassExtendsJavaClass.kt");
                }

                @Test
                @TestMetadata("kotlinClassImplementsJavaInterface.kt")
                public void testKotlinClassImplementsJavaInterface() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/statics/kotlinClassImplementsJavaInterface.kt");
                }

                @Test
                @TestMetadata("kotlinClassImplementsJavaInterfaceExtendsJavaInteface.kt")
                public void testKotlinClassImplementsJavaInterfaceExtendsJavaInteface() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/statics/kotlinClassImplementsJavaInterfaceExtendsJavaInteface.kt");
                }

                @Test
                @TestMetadata("kotlinMembersVsJavaNonVisibleStatics.kt")
                public void testKotlinMembersVsJavaNonVisibleStatics() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/statics/kotlinMembersVsJavaNonVisibleStatics.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/synthesized")
            @TestDataPath("$PROJECT_ROOT")
            public class Synthesized {
                @Test
                public void testAllFilesPresentInSynthesized() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/duplicateJvmSignature/synthesized"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("enumValuesValueOf.kt")
                public void testEnumValuesValueOf() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/synthesized/enumValuesValueOf.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/duplicateJvmSignature/traitImpl")
            @TestDataPath("$PROJECT_ROOT")
            public class TraitImpl {
                @Test
                public void testAllFilesPresentInTraitImpl() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/duplicateJvmSignature/traitImpl"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("oneTrait.kt")
                public void testOneTrait() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/traitImpl/oneTrait.kt");
                }

                @Test
                @TestMetadata("traitFunctionOverriddenByPropertyInTrait.kt")
                public void testTraitFunctionOverriddenByPropertyInTrait() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/traitImpl/traitFunctionOverriddenByPropertyInTrait.kt");
                }

                @Test
                @TestMetadata("traitPropertyOverriddenByFunctionInTrait.kt")
                public void testTraitPropertyOverriddenByFunctionInTrait() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/traitImpl/traitPropertyOverriddenByFunctionInTrait.kt");
                }

                @Test
                @TestMetadata("twoTraits.kt")
                public void testTwoTraits() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/duplicateJvmSignature/traitImpl/twoTraits.kt");
                }
            }
        }

        @Nested
        @TestMetadata("compiler/testData/diagnostics/tests/dynamicTypes")
        @TestDataPath("$PROJECT_ROOT")
        public class DynamicTypes {
            @Test
            public void testAllFilesPresentInDynamicTypes() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/dynamicTypes"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
            }

            @Test
            @TestMetadata("delegationBy.kt")
            public void testDelegationBy() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dynamicTypes/delegationBy.kt");
            }

            @Test
            @TestMetadata("unsupported.kt")
            public void testUnsupported() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dynamicTypes/unsupported.kt");
            }

            @Test
            @TestMetadata("withInvisibleSynthesized.kt")
            public void testWithInvisibleSynthesized() throws Exception {
                runTest("compiler/testData/diagnostics/tests/dynamicTypes/withInvisibleSynthesized.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/diagnostics/tests/enum")
        @TestDataPath("$PROJECT_ROOT")
        public class Enum {
            @Test
            @TestMetadata("AbstractEnum.kt")
            public void testAbstractEnum() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/AbstractEnum.kt");
            }

            @Test
            @TestMetadata("AbstractInEnum.kt")
            public void testAbstractInEnum() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/AbstractInEnum.kt");
            }

            @Test
            @TestMetadata("AbstractOverrideInEnum.kt")
            public void testAbstractOverrideInEnum() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/AbstractOverrideInEnum.kt");
            }

            @Test
            public void testAllFilesPresentInEnum() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/enum"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
            }

            @Test
            @TestMetadata("classObjectInEnum.kt")
            public void testClassObjectInEnum() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/classObjectInEnum.kt");
            }

            @Test
            @TestMetadata("classObjectInEnumPrivate.kt")
            public void testClassObjectInEnumPrivate() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/classObjectInEnumPrivate.kt");
            }

            @Test
            @TestMetadata("commonSupertype.kt")
            public void testCommonSupertype() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/commonSupertype.kt");
            }

            @Test
            @TestMetadata("compareTwoDifferentEnums.kt")
            public void testCompareTwoDifferentEnums() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/compareTwoDifferentEnums.kt");
            }

            @Test
            @TestMetadata("ConstructorCallFromOutside.kt")
            public void testConstructorCallFromOutside() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/ConstructorCallFromOutside.kt");
            }

            @Test
            @TestMetadata("constructorWithDefaultParametersOnly.kt")
            public void testConstructorWithDefaultParametersOnly() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/constructorWithDefaultParametersOnly.kt");
            }

            @Test
            @TestMetadata("declaringClass.kt")
            public void testDeclaringClass() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/declaringClass.kt");
            }

            @Test
            @TestMetadata("dontCreatePackageTypeForEnumEntry_after.kt")
            public void testDontCreatePackageTypeForEnumEntry_after() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/dontCreatePackageTypeForEnumEntry_after.kt");
            }

            @Test
            @TestMetadata("dontCreatePackageTypeForEnumEntry_before.kt")
            public void testDontCreatePackageTypeForEnumEntry_before() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/dontCreatePackageTypeForEnumEntry_before.kt");
            }

            @Test
            @TestMetadata("emptyConstructor.kt")
            public void testEmptyConstructor() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/emptyConstructor.kt");
            }

            @Test
            @TestMetadata("entryShouldBeOfEnumType.kt")
            public void testEntryShouldBeOfEnumType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/entryShouldBeOfEnumType.kt");
            }

            @Test
            @TestMetadata("enumEntryCannotHaveClassObject.kt")
            public void testEnumEntryCannotHaveClassObject() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/enumEntryCannotHaveClassObject.kt");
            }

            @Test
            @TestMetadata("enumEntryInAbstractEnum.kt")
            public void testEnumEntryInAbstractEnum() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/enumEntryInAbstractEnum.kt");
            }

            @Test
            @TestMetadata("enumImplementingTrait.kt")
            public void testEnumImplementingTrait() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/enumImplementingTrait.kt");
            }

            @Test
            @TestMetadata("enumInheritance.kt")
            public void testEnumInheritance() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/enumInheritance.kt");
            }

            @Test
            @TestMetadata("enumIsAssignableToBuiltInEnum.kt")
            public void testEnumIsAssignableToBuiltInEnum() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/enumIsAssignableToBuiltInEnum.kt");
            }

            @Test
            @TestMetadata("enumMissingName.kt")
            public void testEnumMissingName() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/enumMissingName.kt");
            }

            @Test
            @TestMetadata("enumModifier.kt")
            public void testEnumModifier() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/enumModifier.kt");
            }

            @Test
            @TestMetadata("enumStarImport.kt")
            public void testEnumStarImport() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/enumStarImport.kt");
            }

            @Test
            @TestMetadata("enumSubjectTypeCheck.kt")
            public void testEnumSubjectTypeCheck() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/enumSubjectTypeCheck.kt");
            }

            @Test
            @TestMetadata("enumWithAnnotationKeyword.kt")
            public void testEnumWithAnnotationKeyword() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/enumWithAnnotationKeyword.kt");
            }

            @Test
            @TestMetadata("enumWithEmptyName.kt")
            public void testEnumWithEmptyName() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/enumWithEmptyName.kt");
            }

            @Test
            @TestMetadata("ExplicitConstructorCall.kt")
            public void testExplicitConstructorCall() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/ExplicitConstructorCall.kt");
            }

            @Test
            @TestMetadata("extendingEnumDirectly.kt")
            public void testExtendingEnumDirectly() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/extendingEnumDirectly.kt");
            }

            @Test
            @TestMetadata("extensionNamedAsEnumEntry.kt")
            public void testExtensionNamedAsEnumEntry() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/extensionNamedAsEnumEntry.kt");
            }

            @Test
            @TestMetadata("ifEnumEntry.kt")
            public void testIfEnumEntry() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/ifEnumEntry.kt");
            }

            @Test
            @TestMetadata("importEnumFromJava.kt")
            public void testImportEnumFromJava() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/importEnumFromJava.kt");
            }

            @Test
            @TestMetadata("incompatibleEnumEntryClasses.kt")
            public void testIncompatibleEnumEntryClasses() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/incompatibleEnumEntryClasses.kt");
            }

            @Test
            @TestMetadata("incompatibleEnums.kt")
            public void testIncompatibleEnums() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/incompatibleEnums.kt");
            }

            @Test
            @TestMetadata("incompatibleEnums_1_4.kt")
            public void testIncompatibleEnums_1_4() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/incompatibleEnums_1_4.kt");
            }

            @Test
            @TestMetadata("inheritFromEnumEntry.kt")
            public void testInheritFromEnumEntry() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/inheritFromEnumEntry.kt");
            }

            @Test
            @TestMetadata("inheritanceFromEnum.kt")
            public void testInheritanceFromEnum() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/inheritanceFromEnum.kt");
            }

            @Test
            @TestMetadata("inline.kt")
            public void testInline() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/inline.kt");
            }

            @Test
            @TestMetadata("InsideEntryConstructorCall.kt")
            public void testInsideEntryConstructorCall() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/InsideEntryConstructorCall.kt");
            }

            @Test
            @TestMetadata("InsideSecondaryConstructorCall.kt")
            public void testInsideSecondaryConstructorCall() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/InsideSecondaryConstructorCall.kt");
            }

            @Test
            @TestMetadata("interfaceWithEnumKeyword.kt")
            public void testInterfaceWithEnumKeyword() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/interfaceWithEnumKeyword.kt");
            }

            @Test
            @TestMetadata("isEnumEntry.kt")
            public void testIsEnumEntry() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/isEnumEntry.kt");
            }

            @Test
            @TestMetadata("javaEnumValueOfMethod.kt")
            public void testJavaEnumValueOfMethod() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/javaEnumValueOfMethod.kt");
            }

            @Test
            @TestMetadata("javaEnumValuesMethod.kt")
            public void testJavaEnumValuesMethod() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/javaEnumValuesMethod.kt");
            }

            @Test
            @TestMetadata("javaEnumWithAbstractFun.kt")
            public void testJavaEnumWithAbstractFun() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/javaEnumWithAbstractFun.kt");
            }

            @Test
            @TestMetadata("javaEnumWithFuns.kt")
            public void testJavaEnumWithFuns() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/javaEnumWithFuns.kt");
            }

            @Test
            @TestMetadata("javaEnumWithNameClashing.kt")
            public void testJavaEnumWithNameClashing() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/javaEnumWithNameClashing.kt");
            }

            @Test
            @TestMetadata("javaEnumWithProperty.kt")
            public void testJavaEnumWithProperty() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/javaEnumWithProperty.kt");
            }

            @Test
            @TestMetadata("kt2834.kt")
            public void testKt2834() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/kt2834.kt");
            }

            @Test
            @TestMetadata("kt8972_cloneNotAllowed.kt")
            public void testKt8972_cloneNotAllowed() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/kt8972_cloneNotAllowed.kt");
            }

            @Test
            @TestMetadata("localEnums.kt")
            public void testLocalEnums() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/localEnums.kt");
            }

            @Test
            @TestMetadata("modifiersOnEnumEntry.kt")
            public void testModifiersOnEnumEntry() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/modifiersOnEnumEntry.kt");
            }

            @Test
            @TestMetadata("multipleConstructors.kt")
            public void testMultipleConstructors() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/multipleConstructors.kt");
            }

            @Test
            @TestMetadata("NonPrivateConstructor.kt")
            public void testNonPrivateConstructor() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/NonPrivateConstructor.kt");
            }

            @Test
            @TestMetadata("openMemberInEnum.kt")
            public void testOpenMemberInEnum() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/openMemberInEnum.kt");
            }

            @Test
            @TestMetadata("overrideFinalEnumMethods.kt")
            public void testOverrideFinalEnumMethods() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/overrideFinalEnumMethods.kt");
            }

            @Test
            @TestMetadata("SecondaryConstructorCall.kt")
            public void testSecondaryConstructorCall() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/SecondaryConstructorCall.kt");
            }

            @Test
            @TestMetadata("secondaryConstructorWithoutDelegatingToPrimaryOne.kt")
            public void testSecondaryConstructorWithoutDelegatingToPrimaryOne() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/secondaryConstructorWithoutDelegatingToPrimaryOne.kt");
            }

            @Test
            @TestMetadata("secondaryConstructorWithoutDelegatingToPrimaryOneWithEnabledFeature.kt")
            public void testSecondaryConstructorWithoutDelegatingToPrimaryOneWithEnabledFeature() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/secondaryConstructorWithoutDelegatingToPrimaryOneWithEnabledFeature.kt");
            }

            @Test
            @TestMetadata("starImportNestedClassAndEntries.kt")
            public void testStarImportNestedClassAndEntries() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/starImportNestedClassAndEntries.kt");
            }

            @Test
            @TestMetadata("typeCompatibility.kt")
            public void testTypeCompatibility() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/typeCompatibility.kt");
            }

            @Test
            @TestMetadata("typeParametersInEnum.kt")
            public void testTypeParametersInEnum() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/typeParametersInEnum.kt");
            }

            @Test
            @TestMetadata("valuesValueOfAndEntriesAccessibility.kt")
            public void testValuesValueOfAndEntriesAccessibility() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/valuesValueOfAndEntriesAccessibility.kt");
            }

            @Test
            @TestMetadata("wrongUnitializedEnumCompanion.kt")
            public void testWrongUnitializedEnumCompanion() throws Exception {
                runTest("compiler/testData/diagnostics/tests/enum/wrongUnitializedEnumCompanion.kt");
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/enum/inner")
            @TestDataPath("$PROJECT_ROOT")
            public class Inner {
                @Test
                public void testAllFilesPresentInInner() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/enum/inner"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("existingClassObject.kt")
                public void testExistingClassObject() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/enum/inner/existingClassObject.kt");
                }

                @Test
                @TestMetadata("insideClass.kt")
                public void testInsideClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/enum/inner/insideClass.kt");
                }

                @Test
                @TestMetadata("insideClassObject.kt")
                public void testInsideClassObject() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/enum/inner/insideClassObject.kt");
                }

                @Test
                @TestMetadata("insideEnum.kt")
                public void testInsideEnum() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/enum/inner/insideEnum.kt");
                }

                @Test
                @TestMetadata("insideEnumEntry_after.kt")
                public void testInsideEnumEntry_after() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/enum/inner/insideEnumEntry_after.kt");
                }

                @Test
                @TestMetadata("insideEnumEntry_before.kt")
                public void testInsideEnumEntry_before() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/enum/inner/insideEnumEntry_before.kt");
                }

                @Test
                @TestMetadata("insideInnerClassNotAllowed.kt")
                public void testInsideInnerClassNotAllowed() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/enum/inner/insideInnerClassNotAllowed.kt");
                }

                @Test
                @TestMetadata("insideObject.kt")
                public void testInsideObject() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/enum/inner/insideObject.kt");
                }

                @Test
                @TestMetadata("insideTrait.kt")
                public void testInsideTrait() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/enum/inner/insideTrait.kt");
                }

                @Test
                @TestMetadata("redeclarationInClassObject.kt")
                public void testRedeclarationInClassObject() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/enum/inner/redeclarationInClassObject.kt");
                }

                @Test
                @TestMetadata("twoEnums.kt")
                public void testTwoEnums() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/enum/inner/twoEnums.kt");
                }

                @Test
                @TestMetadata("twoEnumsInClassObjectAndInnerClass.kt")
                public void testTwoEnumsInClassObjectAndInnerClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/enum/inner/twoEnumsInClassObjectAndInnerClass.kt");
                }
            }
        }

        @Nested
        @TestMetadata("compiler/testData/diagnostics/tests/evaluate")
        @TestDataPath("$PROJECT_ROOT")
        public class Evaluate {
            @Test
            public void testAllFilesPresentInEvaluate() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/evaluate"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
            }

            @Test
            @TestMetadata("binaryMinusDepOnExpType.kt")
            public void testBinaryMinusDepOnExpType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/evaluate/binaryMinusDepOnExpType.kt");
            }

            @Test
            @TestMetadata("binaryMinusIndepWoExpType.kt")
            public void testBinaryMinusIndepWoExpType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/evaluate/binaryMinusIndepWoExpType.kt");
            }

            @Test
            @TestMetadata("binaryMinusIndependentExpType.kt")
            public void testBinaryMinusIndependentExpType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/evaluate/binaryMinusIndependentExpType.kt");
            }

            @Test
            @TestMetadata("customExtensionOverKotlinExtensionInConst.kt")
            public void testCustomExtensionOverKotlinExtensionInConst() throws Exception {
                runTest("compiler/testData/diagnostics/tests/evaluate/customExtensionOverKotlinExtensionInConst.kt");
            }

            @Test
            @TestMetadata("divisionByZero.kt")
            public void testDivisionByZero() throws Exception {
                runTest("compiler/testData/diagnostics/tests/evaluate/divisionByZero.kt");
            }

            @Test
            @TestMetadata("float.kt")
            public void testFloat() throws Exception {
                runTest("compiler/testData/diagnostics/tests/evaluate/float.kt");
            }

            @Test
            @TestMetadata("floatLiteralOutOfRange.kt")
            public void testFloatLiteralOutOfRange() throws Exception {
                runTest("compiler/testData/diagnostics/tests/evaluate/floatLiteralOutOfRange.kt");
            }

            @Test
            @TestMetadata("infixFunOverBuiltinMemberInConst.kt")
            public void testInfixFunOverBuiltinMemberInConst() throws Exception {
                runTest("compiler/testData/diagnostics/tests/evaluate/infixFunOverBuiltinMemberInConst.kt");
            }

            @Test
            @TestMetadata("intOverflow.kt")
            public void testIntOverflow() throws Exception {
                runTest("compiler/testData/diagnostics/tests/evaluate/intOverflow.kt");
            }

            @Test
            @TestMetadata("intOverflowWithJavaProperties.kt")
            public void testIntOverflowWithJavaProperties() throws Exception {
                runTest("compiler/testData/diagnostics/tests/evaluate/intOverflowWithJavaProperties.kt");
            }

            @Test
            @TestMetadata("integer.kt")
            public void testInteger() throws Exception {
                runTest("compiler/testData/diagnostics/tests/evaluate/integer.kt");
            }

            @Test
            @TestMetadata("logicWithNumber.kt")
            public void testLogicWithNumber() throws Exception {
                runTest("compiler/testData/diagnostics/tests/evaluate/logicWithNumber.kt");
            }

            @Test
            @TestMetadata("longOverflow.kt")
            public void testLongOverflow() throws Exception {
                runTest("compiler/testData/diagnostics/tests/evaluate/longOverflow.kt");
            }

            @Test
            @TestMetadata("noOverflowWithZero.kt")
            public void testNoOverflowWithZero() throws Exception {
                runTest("compiler/testData/diagnostics/tests/evaluate/noOverflowWithZero.kt");
            }

            @Test
            @TestMetadata("numberBinaryOperations.kt")
            public void testNumberBinaryOperations() throws Exception {
                runTest("compiler/testData/diagnostics/tests/evaluate/numberBinaryOperations.kt");
            }

            @Test
            @TestMetadata("numberBinaryOperationsCall.kt")
            public void testNumberBinaryOperationsCall() throws Exception {
                runTest("compiler/testData/diagnostics/tests/evaluate/numberBinaryOperationsCall.kt");
            }

            @Test
            @TestMetadata("numberBinaryOperationsInfixCall.kt")
            public void testNumberBinaryOperationsInfixCall() throws Exception {
                runTest("compiler/testData/diagnostics/tests/evaluate/numberBinaryOperationsInfixCall.kt");
            }

            @Test
            @TestMetadata("otherOverflow.kt")
            public void testOtherOverflow() throws Exception {
                runTest("compiler/testData/diagnostics/tests/evaluate/otherOverflow.kt");
            }

            @Test
            @TestMetadata("parentesized.kt")
            public void testParentesized() throws Exception {
                runTest("compiler/testData/diagnostics/tests/evaluate/parentesized.kt");
            }

            @Test
            @TestMetadata("qualifiedExpressions.kt")
            public void testQualifiedExpressions() throws Exception {
                runTest("compiler/testData/diagnostics/tests/evaluate/qualifiedExpressions.kt");
            }

            @Test
            @TestMetadata("unaryMinusDepOnExpType.kt")
            public void testUnaryMinusDepOnExpType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/evaluate/unaryMinusDepOnExpType.kt");
            }

            @Test
            @TestMetadata("unaryMinusIndepWoExpType.kt")
            public void testUnaryMinusIndepWoExpType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/evaluate/unaryMinusIndepWoExpType.kt");
            }

            @Test
            @TestMetadata("unaryMinusIndependentExpType.kt")
            public void testUnaryMinusIndependentExpType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/evaluate/unaryMinusIndependentExpType.kt");
            }

            @Test
            @TestMetadata("wrongLongSuffix.kt")
            public void testWrongLongSuffix() throws Exception {
                runTest("compiler/testData/diagnostics/tests/evaluate/wrongLongSuffix.kt");
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/evaluate/inlineClasses")
            @TestDataPath("$PROJECT_ROOT")
            public class InlineClasses {
                @Test
                public void testAllFilesPresentInInlineClasses() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/evaluate/inlineClasses"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("constructorOfUnsignedType.kt")
                public void testConstructorOfUnsignedType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/evaluate/inlineClasses/constructorOfUnsignedType.kt");
                }
            }
        }

        @Nested
        @TestMetadata("compiler/testData/diagnostics/tests/exceptions")
        @TestDataPath("$PROJECT_ROOT")
        public class Exceptions {
            @Test
            public void testAllFilesPresentInExceptions() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/exceptions"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
            }

            @Test
            @TestMetadata("expectedSomeTypesOnBranchForWhenExpressionOfErroneousType.kt")
            public void testExpectedSomeTypesOnBranchForWhenExpressionOfErroneousType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/exceptions/expectedSomeTypesOnBranchForWhenExpressionOfErroneousType.kt");
            }

            @Test
            @TestMetadata("kt24158.kt")
            public void testKt24158() throws Exception {
                runTest("compiler/testData/diagnostics/tests/exceptions/kt24158.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/diagnostics/tests/explicitDefinitelyNotNullableViaIntersection")
        @TestDataPath("$PROJECT_ROOT")
        public class ExplicitDefinitelyNotNullableViaIntersection {
            @Test
            public void testAllFilesPresentInExplicitDefinitelyNotNullableViaIntersection() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/explicitDefinitelyNotNullableViaIntersection"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
            }

            @Test
            @TestMetadata("approximation.kt")
            public void testApproximation() throws Exception {
                runTest("compiler/testData/diagnostics/tests/explicitDefinitelyNotNullableViaIntersection/approximation.kt");
            }

            @Test
            @TestMetadata("bareTypes.kt")
            public void testBareTypes() throws Exception {
                runTest("compiler/testData/diagnostics/tests/explicitDefinitelyNotNullableViaIntersection/bareTypes.kt");
            }

            @Test
            @TestMetadata("disabledFeature.kt")
            public void testDisabledFeature() throws Exception {
                runTest("compiler/testData/diagnostics/tests/explicitDefinitelyNotNullableViaIntersection/disabledFeature.kt");
            }

            @Test
            @TestMetadata("inference.kt")
            public void testInference() throws Exception {
                runTest("compiler/testData/diagnostics/tests/explicitDefinitelyNotNullableViaIntersection/inference.kt");
            }

            @Test
            @TestMetadata("isAsOperators.kt")
            public void testIsAsOperators() throws Exception {
                runTest("compiler/testData/diagnostics/tests/explicitDefinitelyNotNullableViaIntersection/isAsOperators.kt");
            }

            @Test
            @TestMetadata("isAsOperatorsEnabled.kt")
            public void testIsAsOperatorsEnabled() throws Exception {
                runTest("compiler/testData/diagnostics/tests/explicitDefinitelyNotNullableViaIntersection/isAsOperatorsEnabled.kt");
            }

            @Test
            @TestMetadata("notApplicable.kt")
            public void testNotApplicable() throws Exception {
                runTest("compiler/testData/diagnostics/tests/explicitDefinitelyNotNullableViaIntersection/notApplicable.kt");
            }

            @Test
            @TestMetadata("overrides.kt")
            public void testOverrides() throws Exception {
                runTest("compiler/testData/diagnostics/tests/explicitDefinitelyNotNullableViaIntersection/overrides.kt");
            }

            @Test
            @TestMetadata("overridesJavaAnnotated.kt")
            public void testOverridesJavaAnnotated() throws Exception {
                runTest("compiler/testData/diagnostics/tests/explicitDefinitelyNotNullableViaIntersection/overridesJavaAnnotated.kt");
            }

            @Test
            @TestMetadata("recursiveBounds.kt")
            public void testRecursiveBounds() throws Exception {
                runTest("compiler/testData/diagnostics/tests/explicitDefinitelyNotNullableViaIntersection/recursiveBounds.kt");
            }

            @Test
            @TestMetadata("reifiedArguments.kt")
            public void testReifiedArguments() throws Exception {
                runTest("compiler/testData/diagnostics/tests/explicitDefinitelyNotNullableViaIntersection/reifiedArguments.kt");
            }

            @Test
            @TestMetadata("simple.kt")
            public void testSimple() throws Exception {
                runTest("compiler/testData/diagnostics/tests/explicitDefinitelyNotNullableViaIntersection/simple.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/diagnostics/tests/exposed")
        @TestDataPath("$PROJECT_ROOT")
        public class Exposed {
            @Test
            public void testAllFilesPresentInExposed() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/exposed"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
            }

            @Test
            @TestMetadata("delegate.kt")
            public void testDelegate() throws Exception {
                runTest("compiler/testData/diagnostics/tests/exposed/delegate.kt");
            }

            @Test
            @TestMetadata("exceptionOnFakeInvisible.kt")
            public void testExceptionOnFakeInvisible() throws Exception {
                runTest("compiler/testData/diagnostics/tests/exposed/exceptionOnFakeInvisible.kt");
            }

            @Test
            @TestMetadata("functional.kt")
            public void testFunctional() throws Exception {
                runTest("compiler/testData/diagnostics/tests/exposed/functional.kt");
            }

            @Test
            @TestMetadata("implements.kt")
            public void testImplements() throws Exception {
                runTest("compiler/testData/diagnostics/tests/exposed/implements.kt");
            }

            @Test
            @TestMetadata("inaccessibleType.kt")
            public void testInaccessibleType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/exposed/inaccessibleType.kt");
            }

            @Test
            @TestMetadata("internal.kt")
            public void testInternal() throws Exception {
                runTest("compiler/testData/diagnostics/tests/exposed/internal.kt");
            }

            @Test
            @TestMetadata("internalAndProtected.kt")
            public void testInternalAndProtected() throws Exception {
                runTest("compiler/testData/diagnostics/tests/exposed/internalAndProtected.kt");
            }

            @Test
            @TestMetadata("internalFromLocal.kt")
            public void testInternalFromLocal() throws Exception {
                runTest("compiler/testData/diagnostics/tests/exposed/internalFromLocal.kt");
            }

            @Test
            @TestMetadata("local.kt")
            public void testLocal() throws Exception {
                runTest("compiler/testData/diagnostics/tests/exposed/local.kt");
            }

            @Test
            @TestMetadata("localFromInternal.kt")
            public void testLocalFromInternal() throws Exception {
                runTest("compiler/testData/diagnostics/tests/exposed/localFromInternal.kt");
            }

            @Test
            @TestMetadata("localFromPrivate.kt")
            public void testLocalFromPrivate() throws Exception {
                runTest("compiler/testData/diagnostics/tests/exposed/localFromPrivate.kt");
            }

            @Test
            @TestMetadata("localInFunReturnType.kt")
            public void testLocalInFunReturnType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/exposed/localInFunReturnType.kt");
            }

            @Test
            @TestMetadata("localInMemberType.kt")
            public void testLocalInMemberType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/exposed/localInMemberType.kt");
            }

            @Test
            @TestMetadata("localInPropertyType.kt")
            public void testLocalInPropertyType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/exposed/localInPropertyType.kt");
            }

            @Test
            @TestMetadata("nested.kt")
            public void testNested() throws Exception {
                runTest("compiler/testData/diagnostics/tests/exposed/nested.kt");
            }

            @Test
            @TestMetadata("object.kt")
            public void testObject() throws Exception {
                runTest("compiler/testData/diagnostics/tests/exposed/object.kt");
            }

            @Test
            @TestMetadata("packagePrivate.kt")
            public void testPackagePrivate() throws Exception {
                runTest("compiler/testData/diagnostics/tests/exposed/packagePrivate.kt");
            }

            @Test
            @TestMetadata("privateFromLocal.kt")
            public void testPrivateFromLocal() throws Exception {
                runTest("compiler/testData/diagnostics/tests/exposed/privateFromLocal.kt");
            }

            @Test
            @TestMetadata("privateInFile.kt")
            public void testPrivateInFile() throws Exception {
                runTest("compiler/testData/diagnostics/tests/exposed/privateInFile.kt");
            }

            @Test
            @TestMetadata("privateInFileDisabled.kt")
            public void testPrivateInFileDisabled() throws Exception {
                runTest("compiler/testData/diagnostics/tests/exposed/privateInFileDisabled.kt");
            }

            @Test
            @TestMetadata("privatePropertyInPrivateConstructor.kt")
            public void testPrivatePropertyInPrivateConstructor() throws Exception {
                runTest("compiler/testData/diagnostics/tests/exposed/privatePropertyInPrivateConstructor.kt");
            }

            @Test
            @TestMetadata("propertyInConstructorOfPrivateClass.kt")
            public void testPropertyInConstructorOfPrivateClass() throws Exception {
                runTest("compiler/testData/diagnostics/tests/exposed/propertyInConstructorOfPrivateClass.kt");
            }

            @Test
            @TestMetadata("propertyInPrivateConstructor.kt")
            public void testPropertyInPrivateConstructor() throws Exception {
                runTest("compiler/testData/diagnostics/tests/exposed/propertyInPrivateConstructor.kt");
            }

            @Test
            @TestMetadata("propertyInPrivateConstructorError.kt")
            public void testPropertyInPrivateConstructorError() throws Exception {
                runTest("compiler/testData/diagnostics/tests/exposed/propertyInPrivateConstructorError.kt");
            }

            @Test
            @TestMetadata("propertyInSimpleConstructor.kt")
            public void testPropertyInSimpleConstructor() throws Exception {
                runTest("compiler/testData/diagnostics/tests/exposed/propertyInSimpleConstructor.kt");
            }

            @Test
            @TestMetadata("protected.kt")
            public void testProtected() throws Exception {
                runTest("compiler/testData/diagnostics/tests/exposed/protected.kt");
            }

            @Test
            @TestMetadata("protectedInProtected.kt")
            public void testProtectedInProtected() throws Exception {
                runTest("compiler/testData/diagnostics/tests/exposed/protectedInProtected.kt");
            }

            @Test
            @TestMetadata("protectedJava.kt")
            public void testProtectedJava() throws Exception {
                runTest("compiler/testData/diagnostics/tests/exposed/protectedJava.kt");
            }

            @Test
            @TestMetadata("protectedSameWay.kt")
            public void testProtectedSameWay() throws Exception {
                runTest("compiler/testData/diagnostics/tests/exposed/protectedSameWay.kt");
            }

            @Test
            @TestMetadata("simple.kt")
            public void testSimple() throws Exception {
                runTest("compiler/testData/diagnostics/tests/exposed/simple.kt");
            }

            @Test
            @TestMetadata("typeArgs.kt")
            public void testTypeArgs() throws Exception {
                runTest("compiler/testData/diagnostics/tests/exposed/typeArgs.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/diagnostics/tests/extensions")
        @TestDataPath("$PROJECT_ROOT")
        public class Extensions {
            @Test
            public void testAllFilesPresentInExtensions() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/extensions"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
            }

            @Test
            @TestMetadata("classObject.kt")
            public void testClassObject() throws Exception {
                runTest("compiler/testData/diagnostics/tests/extensions/classObject.kt");
            }

            @Test
            @TestMetadata("ExtensionFunctions.kt")
            public void testExtensionFunctions() throws Exception {
                runTest("compiler/testData/diagnostics/tests/extensions/ExtensionFunctions.kt");
            }

            @Test
            @TestMetadata("extensionMemberInClassObject.kt")
            public void testExtensionMemberInClassObject() throws Exception {
                runTest("compiler/testData/diagnostics/tests/extensions/extensionMemberInClassObject.kt");
            }

            @Test
            @TestMetadata("extensionPropertyVsParameter.kt")
            public void testExtensionPropertyVsParameter() throws Exception {
                runTest("compiler/testData/diagnostics/tests/extensions/extensionPropertyVsParameter.kt");
            }

            @Test
            @TestMetadata("ExtensionsCalledOnSuper.kt")
            public void testExtensionsCalledOnSuper() throws Exception {
                runTest("compiler/testData/diagnostics/tests/extensions/ExtensionsCalledOnSuper.kt");
            }

            @Test
            @TestMetadata("GenericIterator.kt")
            public void testGenericIterator() throws Exception {
                runTest("compiler/testData/diagnostics/tests/extensions/GenericIterator.kt");
            }

            @Test
            @TestMetadata("GenericIterator2.kt")
            public void testGenericIterator2() throws Exception {
                runTest("compiler/testData/diagnostics/tests/extensions/GenericIterator2.kt");
            }

            @Test
            @TestMetadata("kt1875.kt")
            public void testKt1875() throws Exception {
                runTest("compiler/testData/diagnostics/tests/extensions/kt1875.kt");
            }

            @Test
            @TestMetadata("kt2317.kt")
            public void testKt2317() throws Exception {
                runTest("compiler/testData/diagnostics/tests/extensions/kt2317.kt");
            }

            @Test
            @TestMetadata("kt3470.kt")
            public void testKt3470() throws Exception {
                runTest("compiler/testData/diagnostics/tests/extensions/kt3470.kt");
            }

            @Test
            @TestMetadata("kt3563.kt")
            public void testKt3563() throws Exception {
                runTest("compiler/testData/diagnostics/tests/extensions/kt3563.kt");
            }

            @Test
            @TestMetadata("kt819ExtensionProperties.kt")
            public void testKt819ExtensionProperties() throws Exception {
                runTest("compiler/testData/diagnostics/tests/extensions/kt819ExtensionProperties.kt");
            }

            @Test
            @TestMetadata("noClassObjectsInJava.kt")
            public void testNoClassObjectsInJava() throws Exception {
                runTest("compiler/testData/diagnostics/tests/extensions/noClassObjectsInJava.kt");
            }

            @Test
            @TestMetadata("object.kt")
            public void testObject() throws Exception {
                runTest("compiler/testData/diagnostics/tests/extensions/object.kt");
            }

            @Test
            @TestMetadata("throwOutCandidatesByReceiver.kt")
            public void testThrowOutCandidatesByReceiver() throws Exception {
                runTest("compiler/testData/diagnostics/tests/extensions/throwOutCandidatesByReceiver.kt");
            }

            @Test
            @TestMetadata("throwOutCandidatesByReceiver2.kt")
            public void testThrowOutCandidatesByReceiver2() throws Exception {
                runTest("compiler/testData/diagnostics/tests/extensions/throwOutCandidatesByReceiver2.kt");
            }

            @Test
            @TestMetadata("variableInvoke.kt")
            public void testVariableInvoke() throws Exception {
                runTest("compiler/testData/diagnostics/tests/extensions/variableInvoke.kt");
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/extensions/contextReceivers")
            @TestDataPath("$PROJECT_ROOT")
            public class ContextReceivers {
                @Test
                public void testAllFilesPresentInContextReceivers() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/extensions/contextReceivers"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("ambiguityInGroup.kt")
                public void testAmbiguityInGroup() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/ambiguityInGroup.kt");
                }

                @Test
                @TestMetadata("conflicting.kt")
                public void testConflicting() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/conflicting.kt");
                }

                @Test
                @TestMetadata("conflictingWithDifferentOrder.kt")
                public void testConflictingWithDifferentOrder() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/conflictingWithDifferentOrder.kt");
                }

                @Test
                @TestMetadata("contextKeywordWithElvis.kt")
                public void testContextKeywordWithElvis() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/contextKeywordWithElvis.kt");
                }

                @Test
                @TestMetadata("contextReceiverTypeParamsUsage.kt")
                public void testContextReceiverTypeParamsUsage() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/contextReceiverTypeParamsUsage.kt");
                }

                @Test
                @TestMetadata("contextReceiverTypeParamsUsageError.kt")
                public void testContextReceiverTypeParamsUsageError() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/contextReceiverTypeParamsUsageError.kt");
                }

                @Test
                @TestMetadata("contextualFunctionalTypeConversion.kt")
                public void testContextualFunctionalTypeConversion() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/contextualFunctionalTypeConversion.kt");
                }

                @Test
                @TestMetadata("functionalType.kt")
                public void testFunctionalType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/functionalType.kt");
                }

                @Test
                @TestMetadata("genericOuterClass.kt")
                public void testGenericOuterClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/genericOuterClass.kt");
                }

                @Test
                @TestMetadata("insideDeclaration.kt")
                public void testInsideDeclaration() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/insideDeclaration.kt");
                }

                @Test
                @TestMetadata("labelFromFunctionName.kt")
                public void testLabelFromFunctionName() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/labelFromFunctionName.kt");
                }

                @Test
                @TestMetadata("labelsFromClassNameForbidden.kt")
                public void testLabelsFromClassNameForbidden() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/labelsFromClassNameForbidden.kt");
                }

                @Test
                @TestMetadata("lazy.kt")
                public void testLazy() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/lazy.kt");
                }

                @Test
                @TestMetadata("manyReceivers.kt")
                public void testManyReceivers() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/manyReceivers.kt");
                }

                @Test
                @TestMetadata("noBackingField.kt")
                public void testNoBackingField() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/noBackingField.kt");
                }

                @Test
                @TestMetadata("noContextReceiversOnInlineClasses.kt")
                public void testNoContextReceiversOnInlineClasses() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/noContextReceiversOnInlineClasses.kt");
                }

                @Test
                @TestMetadata("noExplicitReceiver.kt")
                public void testNoExplicitReceiver() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/noExplicitReceiver.kt");
                }

                @Test
                @TestMetadata("noLabelsByClassName.kt")
                public void testNoLabelsByClassName() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/noLabelsByClassName.kt");
                }

                @Test
                @TestMetadata("nonConflicting.kt")
                public void testNonConflicting() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/nonConflicting.kt");
                }

                @Test
                @TestMetadata("outerClass.kt")
                public void testOuterClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/outerClass.kt");
                }

                @Test
                @TestMetadata("overloadPriority.kt")
                public void testOverloadPriority() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/overloadPriority.kt");
                }

                @Test
                @TestMetadata("overloading.kt")
                public void testOverloading() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/overloading.kt");
                }

                @Test
                @TestMetadata("plusMatrix.kt")
                public void testPlusMatrix() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/plusMatrix.kt");
                }

                @Test
                @TestMetadata("superWithContext.kt")
                public void testSuperWithContext() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/superWithContext.kt");
                }

                @Test
                @TestMetadata("syntaxError.kt")
                public void testSyntaxError() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/syntaxError.kt");
                }

                @Test
                @TestMetadata("thisIdentifierInfo.kt")
                public void testThisIdentifierInfo() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/thisIdentifierInfo.kt");
                }

                @Test
                @TestMetadata("thisWithCustomLabel.kt")
                public void testThisWithCustomLabel() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/thisWithCustomLabel.kt");
                }

                @Test
                @TestMetadata("thisWithReceiverLabelsClasses.kt")
                public void testThisWithReceiverLabelsClasses() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/thisWithReceiverLabelsClasses.kt");
                }

                @Test
                @TestMetadata("thisWithReceiverLabelsFunctions.kt")
                public void testThisWithReceiverLabelsFunctions() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/thisWithReceiverLabelsFunctions.kt");
                }

                @Test
                @TestMetadata("thisWithReceiverLabelsProperties.kt")
                public void testThisWithReceiverLabelsProperties() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/thisWithReceiverLabelsProperties.kt");
                }

                @Test
                @TestMetadata("typeParameterAsContextReceiver.kt")
                public void testTypeParameterAsContextReceiver() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/typeParameterAsContextReceiver.kt");
                }

                @Test
                @TestMetadata("typeParameterized.kt")
                public void testTypeParameterized() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/typeParameterized.kt");
                }

                @Test
                @TestMetadata("typeParameterizedList.kt")
                public void testTypeParameterizedList() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/typeParameterizedList.kt");
                }

                @Test
                @TestMetadata("unsupported.kt")
                public void testUnsupported() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/unsupported.kt");
                }

                @Test
                @TestMetadata("withExplicitReceiver.kt")
                public void testWithExplicitReceiver() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/withExplicitReceiver.kt");
                }

                @Test
                @TestMetadata("withExplicitReceiverError.kt")
                public void testWithExplicitReceiverError() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/withExplicitReceiverError.kt");
                }

                @Nested
                @TestMetadata("compiler/testData/diagnostics/tests/extensions/contextReceivers/fromKEEP")
                @TestDataPath("$PROJECT_ROOT")
                public class FromKEEP {
                    @Test
                    public void testAllFilesPresentInFromKEEP() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/extensions/contextReceivers/fromKEEP"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                    }

                    @Test
                    @TestMetadata("autoCloseScope.kt")
                    public void testAutoCloseScope() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/fromKEEP/autoCloseScope.kt");
                    }

                    @Test
                    @TestMetadata("canvas.kt")
                    public void testCanvas() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/fromKEEP/canvas.kt");
                    }

                    @Test
                    @TestMetadata("clickHandler.kt")
                    public void testClickHandler() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/fromKEEP/clickHandler.kt");
                    }

                    @Test
                    @TestMetadata("compareTo.kt")
                    public void testCompareTo() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/fromKEEP/compareTo.kt");
                    }

                    @Test
                    @TestMetadata("decimateEveryEvenThird.kt")
                    public void testDecimateEveryEvenThird() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/fromKEEP/decimateEveryEvenThird.kt");
                    }

                    @Test
                    @TestMetadata("dp.kt")
                    public void testDp() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/fromKEEP/dp.kt");
                    }

                    @Test
                    @TestMetadata("functionalType.kt")
                    public void testFunctionalType() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/fromKEEP/functionalType.kt");
                    }

                    @Test
                    @TestMetadata("iterableClass.kt")
                    public void testIterableClass() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/fromKEEP/iterableClass.kt");
                    }

                    @Test
                    @TestMetadata("json.kt")
                    public void testJson() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/fromKEEP/json.kt");
                    }

                    @Test
                    @TestMetadata("loggingContext.kt")
                    public void testLoggingContext() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/fromKEEP/loggingContext.kt");
                    }

                    @Test
                    @TestMetadata("monoidSum.kt")
                    public void testMonoidSum() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/fromKEEP/monoidSum.kt");
                    }

                    @Test
                    @TestMetadata("transaction.kt")
                    public void testTransaction() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/fromKEEP/transaction.kt");
                    }

                    @Test
                    @TestMetadata("userStorage.kt")
                    public void testUserStorage() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/extensions/contextReceivers/fromKEEP/userStorage.kt");
                    }
                }
            }
        }

        @Nested
        @TestMetadata("compiler/testData/diagnostics/tests/external")
        @TestDataPath("$PROJECT_ROOT")
        public class External {
            @Test
            public void testAllFilesPresentInExternal() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/external"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
            }

            @Test
            @TestMetadata("noExternalModifierInheritance.kt")
            public void testNoExternalModifierInheritance() throws Exception {
                runTest("compiler/testData/diagnostics/tests/external/noExternalModifierInheritance.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/diagnostics/tests/funInterface")
        @TestDataPath("$PROJECT_ROOT")
        public class FunInterface {
            @Test
            public void testAllFilesPresentInFunInterface() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/funInterface"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
            }

            @Test
            @TestMetadata("basicFunInterface.kt")
            public void testBasicFunInterface() throws Exception {
                runTest("compiler/testData/diagnostics/tests/funInterface/basicFunInterface.kt");
            }

            @Test
            @TestMetadata("basicFunInterfaceConversion.kt")
            public void testBasicFunInterfaceConversion() throws Exception {
                runTest("compiler/testData/diagnostics/tests/funInterface/basicFunInterfaceConversion.kt");
            }

            @Test
            @TestMetadata("basicFunInterfaceDisabled.kt")
            public void testBasicFunInterfaceDisabled() throws Exception {
                runTest("compiler/testData/diagnostics/tests/funInterface/basicFunInterfaceDisabled.kt");
            }

            @Test
            @TestMetadata("funInterfaceConstructorReferences_after.kt")
            public void testFunInterfaceConstructorReferences_after() throws Exception {
                runTest("compiler/testData/diagnostics/tests/funInterface/funInterfaceConstructorReferences_after.kt");
            }

            @Test
            @TestMetadata("funInterfaceConstructorReferences_before.kt")
            public void testFunInterfaceConstructorReferences_before() throws Exception {
                runTest("compiler/testData/diagnostics/tests/funInterface/funInterfaceConstructorReferences_before.kt");
            }

            @Test
            @TestMetadata("funInterfaceConversionOnReceiver.kt")
            public void testFunInterfaceConversionOnReceiver() throws Exception {
                runTest("compiler/testData/diagnostics/tests/funInterface/funInterfaceConversionOnReceiver.kt");
            }

            @Test
            @TestMetadata("funInterfaceDeclarationCheck.kt")
            public void testFunInterfaceDeclarationCheck() throws Exception {
                runTest("compiler/testData/diagnostics/tests/funInterface/funInterfaceDeclarationCheck.kt");
            }

            @Test
            @TestMetadata("funInterfaceSyntheticConstructors.kt")
            public void testFunInterfaceSyntheticConstructors() throws Exception {
                runTest("compiler/testData/diagnostics/tests/funInterface/funInterfaceSyntheticConstructors.kt");
            }

            @Test
            @TestMetadata("funIsNotInheritedFromBaseInterface.kt")
            public void testFunIsNotInheritedFromBaseInterface() throws Exception {
                runTest("compiler/testData/diagnostics/tests/funInterface/funIsNotInheritedFromBaseInterface.kt");
            }

            @Test
            @TestMetadata("functionDelegateClashOnJvm.kt")
            public void testFunctionDelegateClashOnJvm() throws Exception {
                runTest("compiler/testData/diagnostics/tests/funInterface/functionDelegateClashOnJvm.kt");
            }

            @Test
            @TestMetadata("genericSubstitutionForFunInterface.kt")
            public void testGenericSubstitutionForFunInterface() throws Exception {
                runTest("compiler/testData/diagnostics/tests/funInterface/genericSubstitutionForFunInterface.kt");
            }

            @Test
            @TestMetadata("noCompatibilityResolveForFunInterfaces.kt")
            public void testNoCompatibilityResolveForFunInterfaces() throws Exception {
                runTest("compiler/testData/diagnostics/tests/funInterface/noCompatibilityResolveForFunInterfaces.kt");
            }

            @Test
            @TestMetadata("resolveFunInterfaceWithoutMainMethod.kt")
            public void testResolveFunInterfaceWithoutMainMethod() throws Exception {
                runTest("compiler/testData/diagnostics/tests/funInterface/resolveFunInterfaceWithoutMainMethod.kt");
            }

            @Test
            @TestMetadata("severalConversionsForFunInterface.kt")
            public void testSeveralConversionsForFunInterface() throws Exception {
                runTest("compiler/testData/diagnostics/tests/funInterface/severalConversionsForFunInterface.kt");
            }

            @Test
            @TestMetadata("suspendFunInterfaceConversion.kt")
            public void testSuspendFunInterfaceConversion() throws Exception {
                runTest("compiler/testData/diagnostics/tests/funInterface/suspendFunInterfaceConversion.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/diagnostics/tests/functionAsExpression")
        @TestDataPath("$PROJECT_ROOT")
        public class FunctionAsExpression {
            @Test
            public void testAllFilesPresentInFunctionAsExpression() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/functionAsExpression"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
            }

            @Test
            @TestMetadata("AutoLabels.kt")
            public void testAutoLabels() throws Exception {
                runTest("compiler/testData/diagnostics/tests/functionAsExpression/AutoLabels.kt");
            }

            @Test
            @TestMetadata("Common.kt")
            public void testCommon() throws Exception {
                runTest("compiler/testData/diagnostics/tests/functionAsExpression/Common.kt");
            }

            @Test
            @TestMetadata("DifficultInferenceForParameter.kt")
            public void testDifficultInferenceForParameter() throws Exception {
                runTest("compiler/testData/diagnostics/tests/functionAsExpression/DifficultInferenceForParameter.kt");
            }

            @Test
            @TestMetadata("ForbiddenNonLocalReturn.kt")
            public void testForbiddenNonLocalReturn() throws Exception {
                runTest("compiler/testData/diagnostics/tests/functionAsExpression/ForbiddenNonLocalReturn.kt");
            }

            @Test
            @TestMetadata("FunctionType.kt")
            public void testFunctionType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/functionAsExpression/FunctionType.kt");
            }

            @Test
            @TestMetadata("InferenceParametersTypes.kt")
            public void testInferenceParametersTypes() throws Exception {
                runTest("compiler/testData/diagnostics/tests/functionAsExpression/InferenceParametersTypes.kt");
            }

            @Test
            @TestMetadata("MissingParameterTypes.kt")
            public void testMissingParameterTypes() throws Exception {
                runTest("compiler/testData/diagnostics/tests/functionAsExpression/MissingParameterTypes.kt");
            }

            @Test
            @TestMetadata("NameDeprecation.kt")
            public void testNameDeprecation() throws Exception {
                runTest("compiler/testData/diagnostics/tests/functionAsExpression/NameDeprecation.kt");
            }

            @Test
            @TestMetadata("NoOverloadError.kt")
            public void testNoOverloadError() throws Exception {
                runTest("compiler/testData/diagnostics/tests/functionAsExpression/NoOverloadError.kt");
            }

            @Test
            @TestMetadata("Parameters.kt")
            public void testParameters() throws Exception {
                runTest("compiler/testData/diagnostics/tests/functionAsExpression/Parameters.kt");
            }

            @Test
            @TestMetadata("ReceiverByExpectedType.kt")
            public void testReceiverByExpectedType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/functionAsExpression/ReceiverByExpectedType.kt");
            }

            @Test
            @TestMetadata("ReturnAndLabels.kt")
            public void testReturnAndLabels() throws Exception {
                runTest("compiler/testData/diagnostics/tests/functionAsExpression/ReturnAndLabels.kt");
            }

            @Test
            @TestMetadata("ReturnTypeCheck.kt")
            public void testReturnTypeCheck() throws Exception {
                runTest("compiler/testData/diagnostics/tests/functionAsExpression/ReturnTypeCheck.kt");
            }

            @Test
            @TestMetadata("ScopeCheck.kt")
            public void testScopeCheck() throws Exception {
                runTest("compiler/testData/diagnostics/tests/functionAsExpression/ScopeCheck.kt");
            }

            @Test
            @TestMetadata("WithGenericParameters.kt")
            public void testWithGenericParameters() throws Exception {
                runTest("compiler/testData/diagnostics/tests/functionAsExpression/WithGenericParameters.kt");
            }

            @Test
            @TestMetadata("WithOuterGeneric.kt")
            public void testWithOuterGeneric() throws Exception {
                runTest("compiler/testData/diagnostics/tests/functionAsExpression/WithOuterGeneric.kt");
            }

            @Test
            @TestMetadata("WithoutBody.kt")
            public void testWithoutBody() throws Exception {
                runTest("compiler/testData/diagnostics/tests/functionAsExpression/WithoutBody.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/diagnostics/tests/functionLiterals")
        @TestDataPath("$PROJECT_ROOT")
        public class FunctionLiterals {
            @Test
            public void testAllFilesPresentInFunctionLiterals() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/functionLiterals"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
            }

            @Test
            @TestMetadata("assignmentOperationInLambda.kt")
            public void testAssignmentOperationInLambda() throws Exception {
                runTest("compiler/testData/diagnostics/tests/functionLiterals/assignmentOperationInLambda.kt");
            }

            @Test
            @TestMetadata("assignmentOperationInLambdaWithExpectedType.kt")
            public void testAssignmentOperationInLambdaWithExpectedType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/functionLiterals/assignmentOperationInLambdaWithExpectedType.kt");
            }

            @Test
            @TestMetadata("DeprecatedSyntax.kt")
            public void testDeprecatedSyntax() throws Exception {
                runTest("compiler/testData/diagnostics/tests/functionLiterals/DeprecatedSyntax.kt");
            }

            @Test
            @TestMetadata("ExpectedParameterTypeMismatchVariance.kt")
            public void testExpectedParameterTypeMismatchVariance() throws Exception {
                runTest("compiler/testData/diagnostics/tests/functionLiterals/ExpectedParameterTypeMismatchVariance.kt");
            }

            @Test
            @TestMetadata("ExpectedParametersTypesMismatch.kt")
            public void testExpectedParametersTypesMismatch() throws Exception {
                runTest("compiler/testData/diagnostics/tests/functionLiterals/ExpectedParametersTypesMismatch.kt");
            }

            @Test
            @TestMetadata("functionExpressionAsLastExpressionInBlock.kt")
            public void testFunctionExpressionAsLastExpressionInBlock() throws Exception {
                runTest("compiler/testData/diagnostics/tests/functionLiterals/functionExpressionAsLastExpressionInBlock.kt");
            }

            @Test
            @TestMetadata("functionLIteralInBlockInIf.kt")
            public void testFunctionLIteralInBlockInIf() throws Exception {
                runTest("compiler/testData/diagnostics/tests/functionLiterals/functionLIteralInBlockInIf.kt");
            }

            @Test
            @TestMetadata("functionLiteralAsArgumentForFunction.kt")
            public void testFunctionLiteralAsArgumentForFunction() throws Exception {
                runTest("compiler/testData/diagnostics/tests/functionLiterals/functionLiteralAsArgumentForFunction.kt");
            }

            @Test
            @TestMetadata("functionLiteralInIf.kt")
            public void testFunctionLiteralInIf() throws Exception {
                runTest("compiler/testData/diagnostics/tests/functionLiterals/functionLiteralInIf.kt");
            }

            @Test
            @TestMetadata("functionLiteralWithoutArgumentList.kt")
            public void testFunctionLiteralWithoutArgumentList() throws Exception {
                runTest("compiler/testData/diagnostics/tests/functionLiterals/functionLiteralWithoutArgumentList.kt");
            }

            @Test
            @TestMetadata("genericFunctionalTypeOnRHSOfPlusAssign.kt")
            public void testGenericFunctionalTypeOnRHSOfPlusAssign() throws Exception {
                runTest("compiler/testData/diagnostics/tests/functionLiterals/genericFunctionalTypeOnRHSOfPlusAssign.kt");
            }

            @Test
            @TestMetadata("higherOrderCallMissingParameters.kt")
            public void testHigherOrderCallMissingParameters() throws Exception {
                runTest("compiler/testData/diagnostics/tests/functionLiterals/higherOrderCallMissingParameters.kt");
            }

            @Test
            @TestMetadata("kt11733.kt")
            public void testKt11733() throws Exception {
                runTest("compiler/testData/diagnostics/tests/functionLiterals/kt11733.kt");
            }

            @Test
            @TestMetadata("kt11733_1.kt")
            public void testKt11733_1() throws Exception {
                runTest("compiler/testData/diagnostics/tests/functionLiterals/kt11733_1.kt");
            }

            @Test
            @TestMetadata("kt16016.kt")
            public void testKt16016() throws Exception {
                runTest("compiler/testData/diagnostics/tests/functionLiterals/kt16016.kt");
            }

            @Test
            @TestMetadata("kt2906.kt")
            public void testKt2906() throws Exception {
                runTest("compiler/testData/diagnostics/tests/functionLiterals/kt2906.kt");
            }

            @Test
            @TestMetadata("kt3343.kt")
            public void testKt3343() throws Exception {
                runTest("compiler/testData/diagnostics/tests/functionLiterals/kt3343.kt");
            }

            @Test
            @TestMetadata("kt4529.kt")
            public void testKt4529() throws Exception {
                runTest("compiler/testData/diagnostics/tests/functionLiterals/kt4529.kt");
            }

            @Test
            @TestMetadata("kt47493.kt")
            public void testKt47493() throws Exception {
                runTest("compiler/testData/diagnostics/tests/functionLiterals/kt47493.kt");
            }

            @Test
            @TestMetadata("kt6541_extensionForExtensionFunction.kt")
            public void testKt6541_extensionForExtensionFunction() throws Exception {
                runTest("compiler/testData/diagnostics/tests/functionLiterals/kt6541_extensionForExtensionFunction.kt");
            }

            @Test
            @TestMetadata("kt6869.kt")
            public void testKt6869() throws Exception {
                runTest("compiler/testData/diagnostics/tests/functionLiterals/kt6869.kt");
            }

            @Test
            @TestMetadata("kt7383_starProjectedFunction.kt")
            public void testKt7383_starProjectedFunction() throws Exception {
                runTest("compiler/testData/diagnostics/tests/functionLiterals/kt7383_starProjectedFunction.kt");
            }

            @Test
            @TestMetadata("LabeledFunctionLiterals.kt")
            public void testLabeledFunctionLiterals() throws Exception {
                runTest("compiler/testData/diagnostics/tests/functionLiterals/LabeledFunctionLiterals.kt");
            }

            @Test
            @TestMetadata("lambdaInLambda2.kt")
            public void testLambdaInLambda2() throws Exception {
                runTest("compiler/testData/diagnostics/tests/functionLiterals/lambdaInLambda2.kt");
            }

            @Test
            @TestMetadata("missedTypeMismatch.kt")
            public void testMissedTypeMismatch() throws Exception {
                runTest("compiler/testData/diagnostics/tests/functionLiterals/missedTypeMismatch.kt");
            }

            @Test
            @TestMetadata("prematurelyAnalyzingLambdaWhileFixingTypeVariableForAnotherArgument.kt")
            public void testPrematurelyAnalyzingLambdaWhileFixingTypeVariableForAnotherArgument() throws Exception {
                runTest("compiler/testData/diagnostics/tests/functionLiterals/prematurelyAnalyzingLambdaWhileFixingTypeVariableForAnotherArgument.kt");
            }

            @Test
            @TestMetadata("returnNull.kt")
            public void testReturnNull() throws Exception {
                runTest("compiler/testData/diagnostics/tests/functionLiterals/returnNull.kt");
            }

            @Test
            @TestMetadata("returnNullWithReturn.kt")
            public void testReturnNullWithReturn() throws Exception {
                runTest("compiler/testData/diagnostics/tests/functionLiterals/returnNullWithReturn.kt");
            }

            @Test
            @TestMetadata("underscopeParameters.kt")
            public void testUnderscopeParameters() throws Exception {
                runTest("compiler/testData/diagnostics/tests/functionLiterals/underscopeParameters.kt");
            }

            @Test
            @TestMetadata("unusedLiteral.kt")
            public void testUnusedLiteral() throws Exception {
                runTest("compiler/testData/diagnostics/tests/functionLiterals/unusedLiteral.kt");
            }

            @Test
            @TestMetadata("unusedLiteralInsideUnitLiteral.kt")
            public void testUnusedLiteralInsideUnitLiteral() throws Exception {
                runTest("compiler/testData/diagnostics/tests/functionLiterals/unusedLiteralInsideUnitLiteral.kt");
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/functionLiterals/destructuringInLambdas")
            @TestDataPath("$PROJECT_ROOT")
            public class DestructuringInLambdas {
                @Test
                public void testAllFilesPresentInDestructuringInLambdas() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/functionLiterals/destructuringInLambdas"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("complexInference.kt")
                public void testComplexInference() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/functionLiterals/destructuringInLambdas/complexInference.kt");
                }

                @Test
                @TestMetadata("extensionComponents.kt")
                public void testExtensionComponents() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/functionLiterals/destructuringInLambdas/extensionComponents.kt");
                }

                @Test
                @TestMetadata("inferredFunctionalType.kt")
                public void testInferredFunctionalType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/functionLiterals/destructuringInLambdas/inferredFunctionalType.kt");
                }

                @Test
                @TestMetadata("modifiers.kt")
                public void testModifiers() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/functionLiterals/destructuringInLambdas/modifiers.kt");
                }

                @Test
                @TestMetadata("noExpectedType.kt")
                public void testNoExpectedType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/functionLiterals/destructuringInLambdas/noExpectedType.kt");
                }

                @Test
                @TestMetadata("redeclaration.kt")
                public void testRedeclaration() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/functionLiterals/destructuringInLambdas/redeclaration.kt");
                }

                @Test
                @TestMetadata("shadowing.kt")
                public void testShadowing() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/functionLiterals/destructuringInLambdas/shadowing.kt");
                }

                @Test
                @TestMetadata("simple.kt")
                public void testSimple() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/functionLiterals/destructuringInLambdas/simple.kt");
                }

                @Test
                @TestMetadata("underscore.kt")
                public void testUnderscore() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/functionLiterals/destructuringInLambdas/underscore.kt");
                }

                @Test
                @TestMetadata("unusedParameters.kt")
                public void testUnusedParameters() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/functionLiterals/destructuringInLambdas/unusedParameters.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/functionLiterals/return")
            @TestDataPath("$PROJECT_ROOT")
            public class Return {
                @Test
                public void testAllFilesPresentInReturn() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/functionLiterals/return"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("AutoLabels.kt")
                public void testAutoLabels() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/functionLiterals/return/AutoLabels.kt");
                }

                @Test
                @TestMetadata("AutoLabelsNonLocal.kt")
                public void testAutoLabelsNonLocal() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/functionLiterals/return/AutoLabelsNonLocal.kt");
                }

                @Test
                @TestMetadata("ForbiddenNonLocalReturnNoType.kt")
                public void testForbiddenNonLocalReturnNoType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/functionLiterals/return/ForbiddenNonLocalReturnNoType.kt");
                }

                @Test
                @TestMetadata("IfInReturnedExpression.kt")
                public void testIfInReturnedExpression() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/functionLiterals/return/IfInReturnedExpression.kt");
                }

                @Test
                @TestMetadata("IfWithoutElse.kt")
                public void testIfWithoutElse() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/functionLiterals/return/IfWithoutElse.kt");
                }

                @Test
                @TestMetadata("IfWithoutElseWithExplicitType.kt")
                public void testIfWithoutElseWithExplicitType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/functionLiterals/return/IfWithoutElseWithExplicitType.kt");
                }

                @Test
                @TestMetadata("LambdaWithParameter.kt")
                public void testLambdaWithParameter() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/functionLiterals/return/LambdaWithParameter.kt");
                }

                @Test
                @TestMetadata("LocalAndNonLocalReturnInLambda.kt")
                public void testLocalAndNonLocalReturnInLambda() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/functionLiterals/return/LocalAndNonLocalReturnInLambda.kt");
                }

                @Test
                @TestMetadata("LocalReturnExplicitLabelNoParens.kt")
                public void testLocalReturnExplicitLabelNoParens() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/functionLiterals/return/LocalReturnExplicitLabelNoParens.kt");
                }

                @Test
                @TestMetadata("LocalReturnExplicitLabelParens.kt")
                public void testLocalReturnExplicitLabelParens() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/functionLiterals/return/LocalReturnExplicitLabelParens.kt");
                }

                @Test
                @TestMetadata("LocalReturnHasTypeNothing.kt")
                public void testLocalReturnHasTypeNothing() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/functionLiterals/return/LocalReturnHasTypeNothing.kt");
                }

                @Test
                @TestMetadata("LocalReturnInNestedFunction.kt")
                public void testLocalReturnInNestedFunction() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/functionLiterals/return/LocalReturnInNestedFunction.kt");
                }

                @Test
                @TestMetadata("LocalReturnInNestedLambda.kt")
                public void testLocalReturnInNestedLambda() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/functionLiterals/return/LocalReturnInNestedLambda.kt");
                }

                @Test
                @TestMetadata("LocalReturnNoCoercionToUnit.kt")
                public void testLocalReturnNoCoercionToUnit() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/functionLiterals/return/LocalReturnNoCoercionToUnit.kt");
                }

                @Test
                @TestMetadata("LocalReturnNull.kt")
                public void testLocalReturnNull() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/functionLiterals/return/LocalReturnNull.kt");
                }

                @Test
                @TestMetadata("LocalReturnSecondUnit.kt")
                public void testLocalReturnSecondUnit() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/functionLiterals/return/LocalReturnSecondUnit.kt");
                }

                @Test
                @TestMetadata("LocalReturnUnit.kt")
                public void testLocalReturnUnit() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/functionLiterals/return/LocalReturnUnit.kt");
                }

                @Test
                @TestMetadata("LocalReturnUnitAndDontCareType.kt")
                public void testLocalReturnUnitAndDontCareType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/functionLiterals/return/LocalReturnUnitAndDontCareType.kt");
                }

                @Test
                @TestMetadata("LocalReturnUnitWithBodyExpression.kt")
                public void testLocalReturnUnitWithBodyExpression() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/functionLiterals/return/LocalReturnUnitWithBodyExpression.kt");
                }

                @Test
                @TestMetadata("LocalReturnWithExpectedType.kt")
                public void testLocalReturnWithExpectedType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/functionLiterals/return/LocalReturnWithExpectedType.kt");
                }

                @Test
                @TestMetadata("LocalReturnWithExplicitUnit.kt")
                public void testLocalReturnWithExplicitUnit() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/functionLiterals/return/LocalReturnWithExplicitUnit.kt");
                }

                @Test
                @TestMetadata("LocalReturnsWithExplicitReturnType.kt")
                public void testLocalReturnsWithExplicitReturnType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/functionLiterals/return/LocalReturnsWithExplicitReturnType.kt");
                }

                @Test
                @TestMetadata("MixedReturnsFromLambda.kt")
                public void testMixedReturnsFromLambda() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/functionLiterals/return/MixedReturnsFromLambda.kt");
                }

                @Test
                @TestMetadata("NoCommonSystem.kt")
                public void testNoCommonSystem() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/functionLiterals/return/NoCommonSystem.kt");
                }

                @Test
                @TestMetadata("SmartCast.kt")
                public void testSmartCast() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/functionLiterals/return/SmartCast.kt");
                }

                @Test
                @TestMetadata("SmartCastWithExplicitType.kt")
                public void testSmartCastWithExplicitType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/functionLiterals/return/SmartCastWithExplicitType.kt");
                }

                @Test
                @TestMetadata("unresolvedReferenceInReturnBlock.kt")
                public void testUnresolvedReferenceInReturnBlock() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/functionLiterals/return/unresolvedReferenceInReturnBlock.kt");
                }
            }
        }

        @Nested
        @TestMetadata("compiler/testData/diagnostics/tests/generics")
        @TestDataPath("$PROJECT_ROOT")
        public class Generics {
            @Test
            public void testAllFilesPresentInGenerics() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/generics"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
            }

            @Test
            @TestMetadata("anonymousObjectSupertypeWithTypeParameterFromFunction.kt")
            public void testAnonymousObjectSupertypeWithTypeParameterFromFunction() throws Exception {
                runTest("compiler/testData/diagnostics/tests/generics/anonymousObjectSupertypeWithTypeParameterFromFunction.kt");
            }

            @Test
            @TestMetadata("argumentsForT.kt")
            public void testArgumentsForT() throws Exception {
                runTest("compiler/testData/diagnostics/tests/generics/argumentsForT.kt");
            }

            @Test
            @TestMetadata("bareTypesWithStarProjections.kt")
            public void testBareTypesWithStarProjections() throws Exception {
                runTest("compiler/testData/diagnostics/tests/generics/bareTypesWithStarProjections.kt");
            }

            @Test
            @TestMetadata("commonSupertypeContravariant.kt")
            public void testCommonSupertypeContravariant() throws Exception {
                runTest("compiler/testData/diagnostics/tests/generics/commonSupertypeContravariant.kt");
            }

            @Test
            @TestMetadata("commonSupertypeContravariant2.kt")
            public void testCommonSupertypeContravariant2() throws Exception {
                runTest("compiler/testData/diagnostics/tests/generics/commonSupertypeContravariant2.kt");
            }

            @Test
            @TestMetadata("doNotCaptureSupertype.kt")
            public void testDoNotCaptureSupertype() throws Exception {
                runTest("compiler/testData/diagnostics/tests/generics/doNotCaptureSupertype.kt");
            }

            @Test
            @TestMetadata("finalUpperBoundWithOverride.kt")
            public void testFinalUpperBoundWithOverride() throws Exception {
                runTest("compiler/testData/diagnostics/tests/generics/finalUpperBoundWithOverride.kt");
            }

            @Test
            @TestMetadata("finalUpperBoundWithoutOverride.kt")
            public void testFinalUpperBoundWithoutOverride() throws Exception {
                runTest("compiler/testData/diagnostics/tests/generics/finalUpperBoundWithoutOverride.kt");
            }

            @Test
            @TestMetadata("genericsInType.kt")
            public void testGenericsInType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/generics/genericsInType.kt");
            }

            @Test
            @TestMetadata("InconsistentTypeParameterBounds.kt")
            public void testInconsistentTypeParameterBounds() throws Exception {
                runTest("compiler/testData/diagnostics/tests/generics/InconsistentTypeParameterBounds.kt");
            }

            @Test
            @TestMetadata("invalidArgumentsNumberInWhere.kt")
            public void testInvalidArgumentsNumberInWhere() throws Exception {
                runTest("compiler/testData/diagnostics/tests/generics/invalidArgumentsNumberInWhere.kt");
            }

            @Test
            @TestMetadata("kt1575-Class.kt")
            public void testKt1575_Class() throws Exception {
                runTest("compiler/testData/diagnostics/tests/generics/kt1575-Class.kt");
            }

            @Test
            @TestMetadata("kt1575-Function.kt")
            public void testKt1575_Function() throws Exception {
                runTest("compiler/testData/diagnostics/tests/generics/kt1575-Function.kt");
            }

            @Test
            @TestMetadata("kt30590.kt")
            public void testKt30590() throws Exception {
                runTest("compiler/testData/diagnostics/tests/generics/kt30590.kt");
            }

            @Test
            @TestMetadata("kt34729.kt")
            public void testKt34729() throws Exception {
                runTest("compiler/testData/diagnostics/tests/generics/kt34729.kt");
            }

            @Test
            @TestMetadata("kt5508.kt")
            public void testKt5508() throws Exception {
                runTest("compiler/testData/diagnostics/tests/generics/kt5508.kt");
            }

            @Test
            @TestMetadata("kt9203.kt")
            public void testKt9203() throws Exception {
                runTest("compiler/testData/diagnostics/tests/generics/kt9203.kt");
            }

            @Test
            @TestMetadata("kt9203_1.kt")
            public void testKt9203_1() throws Exception {
                runTest("compiler/testData/diagnostics/tests/generics/kt9203_1.kt");
            }

            @Test
            @TestMetadata("kt9985.kt")
            public void testKt9985() throws Exception {
                runTest("compiler/testData/diagnostics/tests/generics/kt9985.kt");
            }

            @Test
            @TestMetadata("localClassTypeRefWithTypeParameterFromFunction.kt")
            public void testLocalClassTypeRefWithTypeParameterFromFunction() throws Exception {
                runTest("compiler/testData/diagnostics/tests/generics/localClassTypeRefWithTypeParameterFromFunction.kt");
            }

            @Test
            @TestMetadata("Projections.kt")
            public void testProjections() throws Exception {
                runTest("compiler/testData/diagnostics/tests/generics/Projections.kt");
            }

            @Test
            @TestMetadata("protectedSuperCall.kt")
            public void testProtectedSuperCall() throws Exception {
                runTest("compiler/testData/diagnostics/tests/generics/protectedSuperCall.kt");
            }

            @Test
            @TestMetadata("PseudoRawTypes.kt")
            public void testPseudoRawTypes() throws Exception {
                runTest("compiler/testData/diagnostics/tests/generics/PseudoRawTypes.kt");
            }

            @Test
            @TestMetadata("RawTypeInIsExpression.kt")
            public void testRawTypeInIsExpression() throws Exception {
                runTest("compiler/testData/diagnostics/tests/generics/RawTypeInIsExpression.kt");
            }

            @Test
            @TestMetadata("RawTypeInIsPattern.kt")
            public void testRawTypeInIsPattern() throws Exception {
                runTest("compiler/testData/diagnostics/tests/generics/RawTypeInIsPattern.kt");
            }

            @Test
            @TestMetadata("recursive.kt")
            public void testRecursive() throws Exception {
                runTest("compiler/testData/diagnostics/tests/generics/recursive.kt");
            }

            @Test
            @TestMetadata("RecursiveUpperBoundCheck.kt")
            public void testRecursiveUpperBoundCheck() throws Exception {
                runTest("compiler/testData/diagnostics/tests/generics/RecursiveUpperBoundCheck.kt");
            }

            @Test
            @TestMetadata("RecursiveUpperBoundWithTwoArguments.kt")
            public void testRecursiveUpperBoundWithTwoArguments() throws Exception {
                runTest("compiler/testData/diagnostics/tests/generics/RecursiveUpperBoundWithTwoArguments.kt");
            }

            @Test
            @TestMetadata("resolveGenericBoundsBeforeSupertypes.kt")
            public void testResolveGenericBoundsBeforeSupertypes() throws Exception {
                runTest("compiler/testData/diagnostics/tests/generics/resolveGenericBoundsBeforeSupertypes.kt");
            }

            @Test
            @TestMetadata("sameTypeParameterUse.kt")
            public void testSameTypeParameterUse() throws Exception {
                runTest("compiler/testData/diagnostics/tests/generics/sameTypeParameterUse.kt");
            }

            @Test
            @TestMetadata("suppressVarianceConflict.kt")
            public void testSuppressVarianceConflict() throws Exception {
                runTest("compiler/testData/diagnostics/tests/generics/suppressVarianceConflict.kt");
            }

            @Test
            @TestMetadata("TypeParameterBounds.kt")
            public void testTypeParameterBounds() throws Exception {
                runTest("compiler/testData/diagnostics/tests/generics/TypeParameterBounds.kt");
            }

            @Test
            @TestMetadata("TypeParametersInTypeParameterBounds.kt")
            public void testTypeParametersInTypeParameterBounds() throws Exception {
                runTest("compiler/testData/diagnostics/tests/generics/TypeParametersInTypeParameterBounds.kt");
            }

            @Test
            @TestMetadata("unresolvedClassifierInWhere.kt")
            public void testUnresolvedClassifierInWhere() throws Exception {
                runTest("compiler/testData/diagnostics/tests/generics/unresolvedClassifierInWhere.kt");
            }

            @Test
            @TestMetadata("wildcardInValueParameter.kt")
            public void testWildcardInValueParameter() throws Exception {
                runTest("compiler/testData/diagnostics/tests/generics/wildcardInValueParameter.kt");
            }

            @Test
            @TestMetadata("wrongNumberOfTypeArgumentsDiagnostic.kt")
            public void testWrongNumberOfTypeArgumentsDiagnostic() throws Exception {
                runTest("compiler/testData/diagnostics/tests/generics/wrongNumberOfTypeArgumentsDiagnostic.kt");
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/generics/capturedParameters")
            @TestDataPath("$PROJECT_ROOT")
            public class CapturedParameters {
                @Test
                public void testAllFilesPresentInCapturedParameters() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/generics/capturedParameters"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("captured.kt")
                public void testCaptured() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/capturedParameters/captured.kt");
                }

                @Test
                @TestMetadata("innerLocalClass.kt")
                public void testInnerLocalClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/capturedParameters/innerLocalClass.kt");
                }

                @Test
                @TestMetadata("localClass.kt")
                public void testLocalClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/capturedParameters/localClass.kt");
                }

                @Test
                @TestMetadata("localWithTypeParameter.kt")
                public void testLocalWithTypeParameter() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/capturedParameters/localWithTypeParameter.kt");
                }

                @Test
                @TestMetadata("objectLiteral.kt")
                public void testObjectLiteral() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/capturedParameters/objectLiteral.kt");
                }

                @Test
                @TestMetadata("uncheckedCast.kt")
                public void testUncheckedCast() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/capturedParameters/uncheckedCast.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/generics/cyclicBounds")
            @TestDataPath("$PROJECT_ROOT")
            public class CyclicBounds {
                @Test
                public void testAllFilesPresentInCyclicBounds() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/generics/cyclicBounds"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("functions.kt")
                public void testFunctions() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/cyclicBounds/functions.kt");
                }

                @Test
                @TestMetadata("inClass.kt")
                public void testInClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/cyclicBounds/inClass.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/generics/innerClasses")
            @TestDataPath("$PROJECT_ROOT")
            public class InnerClasses {
                @Test
                public void testAllFilesPresentInInnerClasses() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/generics/innerClasses"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("bareTypes.kt")
                public void testBareTypes() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/innerClasses/bareTypes.kt");
                }

                @Test
                @TestMetadata("bareTypesComplex.kt")
                public void testBareTypesComplex() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/innerClasses/bareTypesComplex.kt");
                }

                @Test
                @TestMetadata("checkBoundsOuter.kt")
                public void testCheckBoundsOuter() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/innerClasses/checkBoundsOuter.kt");
                }

                @Test
                @TestMetadata("importedInner.kt")
                public void testImportedInner() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/innerClasses/importedInner.kt");
                }

                @Test
                @TestMetadata("innerSuperCall.kt")
                public void testInnerSuperCall() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/innerClasses/innerSuperCall.kt");
                }

                @Test
                @TestMetadata("innerSuperCallSecondary.kt")
                public void testInnerSuperCallSecondary() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/innerClasses/innerSuperCallSecondary.kt");
                }

                @Test
                @TestMetadata("innerTP.kt")
                public void testInnerTP() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/innerClasses/innerTP.kt");
                }

                @Test
                @TestMetadata("innerUncheckedCast.kt")
                public void testInnerUncheckedCast() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/innerClasses/innerUncheckedCast.kt");
                }

                @Test
                @TestMetadata("innerVariance.kt")
                public void testInnerVariance() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/innerClasses/innerVariance.kt");
                }

                @Test
                @TestMetadata("iterator.kt")
                public void testIterator() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/innerClasses/iterator.kt");
                }

                @Test
                @TestMetadata("j+k.kt")
                public void testJ_k() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/innerClasses/j+k.kt");
                }

                @Test
                @TestMetadata("j+k_complex.kt")
                public void testJ_k_complex() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/innerClasses/j+k_complex.kt");
                }

                @Test
                @TestMetadata("kt3357.kt")
                public void testKt3357() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/innerClasses/kt3357.kt");
                }

                @Test
                @TestMetadata("kt408.kt")
                public void testKt408() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/innerClasses/kt408.kt");
                }

                @Test
                @TestMetadata("kt6325.kt")
                public void testKt6325() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/innerClasses/kt6325.kt");
                }

                @Test
                @TestMetadata("noTypeVarianceConflictInNestedClass.kt")
                public void testNoTypeVarianceConflictInNestedClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/innerClasses/noTypeVarianceConflictInNestedClass.kt");
                }

                @Test
                @TestMetadata("outerArgumentsRequired.kt")
                public void testOuterArgumentsRequired() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/innerClasses/outerArgumentsRequired.kt");
                }

                @Test
                @TestMetadata("parameterShadowing.kt")
                public void testParameterShadowing() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/innerClasses/parameterShadowing.kt");
                }

                @Test
                @TestMetadata("qualifiedOuter.kt")
                public void testQualifiedOuter() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/innerClasses/qualifiedOuter.kt");
                }

                @Test
                @TestMetadata("qualifiedTypesResolution.kt")
                public void testQualifiedTypesResolution() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/innerClasses/qualifiedTypesResolution.kt");
                }

                @Test
                @TestMetadata("simple.kt")
                public void testSimple() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/innerClasses/simple.kt");
                }

                @Test
                @TestMetadata("simpleIn.kt")
                public void testSimpleIn() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/innerClasses/simpleIn.kt");
                }

                @Test
                @TestMetadata("simpleOut.kt")
                public void testSimpleOut() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/innerClasses/simpleOut.kt");
                }

                @Test
                @TestMetadata("simpleOutUseSite.kt")
                public void testSimpleOutUseSite() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/innerClasses/simpleOutUseSite.kt");
                }

                @Test
                @TestMetadata("substitutedMemberScope.kt")
                public void testSubstitutedMemberScope() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/innerClasses/substitutedMemberScope.kt");
                }

                @Nested
                @TestMetadata("compiler/testData/diagnostics/tests/generics/innerClasses/implicitArguments")
                @TestDataPath("$PROJECT_ROOT")
                public class ImplicitArguments {
                    @Test
                    public void testAllFilesPresentInImplicitArguments() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/generics/innerClasses/implicitArguments"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                    }

                    @Test
                    @TestMetadata("fromCompanionObject_after.kt")
                    public void testFromCompanionObject_after() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/generics/innerClasses/implicitArguments/fromCompanionObject_after.kt");
                    }

                    @Test
                    @TestMetadata("fromCompanionObject_before.kt")
                    public void testFromCompanionObject_before() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/generics/innerClasses/implicitArguments/fromCompanionObject_before.kt");
                    }

                    @Test
                    @TestMetadata("fromOuterClassInObjectLiteral.kt")
                    public void testFromOuterClassInObjectLiteral() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/generics/innerClasses/implicitArguments/fromOuterClassInObjectLiteral.kt");
                    }

                    @Test
                    @TestMetadata("fromSuperClasses.kt")
                    public void testFromSuperClasses() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/generics/innerClasses/implicitArguments/fromSuperClasses.kt");
                    }

                    @Test
                    @TestMetadata("fromSuperClassesLocal.kt")
                    public void testFromSuperClassesLocal() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/generics/innerClasses/implicitArguments/fromSuperClassesLocal.kt");
                    }

                    @Test
                    @TestMetadata("fromSuperClassesLocalInsideInner.kt")
                    public void testFromSuperClassesLocalInsideInner() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/generics/innerClasses/implicitArguments/fromSuperClassesLocalInsideInner.kt");
                    }

                    @Test
                    @TestMetadata("fromSuperClassesTransitive.kt")
                    public void testFromSuperClassesTransitive() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/generics/innerClasses/implicitArguments/fromSuperClassesTransitive.kt");
                    }

                    @Test
                    @TestMetadata("inStaticScope.kt")
                    public void testInStaticScope() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/generics/innerClasses/implicitArguments/inStaticScope.kt");
                    }

                    @Test
                    @TestMetadata("secondLevelDepth.kt")
                    public void testSecondLevelDepth() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/generics/innerClasses/implicitArguments/secondLevelDepth.kt");
                    }
                }
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/generics/multipleBoundsMemberScope")
            @TestDataPath("$PROJECT_ROOT")
            public class MultipleBoundsMemberScope {
                @Test
                public void testAllFilesPresentInMultipleBoundsMemberScope() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/generics/multipleBoundsMemberScope"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("conflictingReturnType.kt")
                public void testConflictingReturnType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/multipleBoundsMemberScope/conflictingReturnType.kt");
                }

                @Test
                @TestMetadata("flexibleTypes.kt")
                public void testFlexibleTypes() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/multipleBoundsMemberScope/flexibleTypes.kt");
                }

                @Test
                @TestMetadata("mostSpecific.kt")
                public void testMostSpecific() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/multipleBoundsMemberScope/mostSpecific.kt");
                }

                @Test
                @TestMetadata("properties.kt")
                public void testProperties() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/multipleBoundsMemberScope/properties.kt");
                }

                @Test
                @TestMetadata("propertiesConflict.kt")
                public void testPropertiesConflict() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/multipleBoundsMemberScope/propertiesConflict.kt");
                }

                @Test
                @TestMetadata("simple.kt")
                public void testSimple() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/multipleBoundsMemberScope/simple.kt");
                }

                @Test
                @TestMetadata("validTypeParameters.kt")
                public void testValidTypeParameters() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/multipleBoundsMemberScope/validTypeParameters.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/generics/nullability")
            @TestDataPath("$PROJECT_ROOT")
            public class Nullability {
                @Test
                public void testAllFilesPresentInNullability() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/generics/nullability"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("capturedTypeWithPlatformSupertype.kt")
                public void testCapturedTypeWithPlatformSupertype() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/nullability/capturedTypeWithPlatformSupertype.kt");
                }

                @Test
                @TestMetadata("considerTypeNotNullOnlyIfItHasNotNullBound.kt")
                public void testConsiderTypeNotNullOnlyIfItHasNotNullBound() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/nullability/considerTypeNotNullOnlyIfItHasNotNullBound.kt");
                }

                @Test
                @TestMetadata("correctSubstitutionForIncorporationConstraint.kt")
                public void testCorrectSubstitutionForIncorporationConstraint() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/nullability/correctSubstitutionForIncorporationConstraint.kt");
                }

                @Test
                @TestMetadata("declarationsBoundsViolation.kt")
                public void testDeclarationsBoundsViolation() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/nullability/declarationsBoundsViolation.kt");
                }

                @Test
                @TestMetadata("expressionsBoundsViolation.kt")
                public void testExpressionsBoundsViolation() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/nullability/expressionsBoundsViolation.kt");
                }

                @Test
                @TestMetadata("functionalBound.kt")
                public void testFunctionalBound() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/nullability/functionalBound.kt");
                }

                @Test
                @TestMetadata("inferNotNullTypeFromIntersectionOfNullableTypes.kt")
                public void testInferNotNullTypeFromIntersectionOfNullableTypes() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/nullability/inferNotNullTypeFromIntersectionOfNullableTypes.kt");
                }

                @Test
                @TestMetadata("kt25182.kt")
                public void testKt25182() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/nullability/kt25182.kt");
                }

                @Test
                @TestMetadata("notNullSmartcastOnIntersectionOfNullables.kt")
                public void testNotNullSmartcastOnIntersectionOfNullables() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/nullability/notNullSmartcastOnIntersectionOfNullables.kt");
                }

                @Test
                @TestMetadata("nullToGeneric.kt")
                public void testNullToGeneric() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/nullability/nullToGeneric.kt");
                }

                @Test
                @TestMetadata("smartCastRefinedClass.kt")
                public void testSmartCastRefinedClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/nullability/smartCastRefinedClass.kt");
                }

                @Test
                @TestMetadata("smartCasts.kt")
                public void testSmartCasts() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/nullability/smartCasts.kt");
                }

                @Test
                @TestMetadata("smartCastsOnThis.kt")
                public void testSmartCastsOnThis() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/nullability/smartCastsOnThis.kt");
                }

                @Test
                @TestMetadata("smartCastsValueArgument.kt")
                public void testSmartCastsValueArgument() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/nullability/smartCastsValueArgument.kt");
                }

                @Test
                @TestMetadata("tpBoundsViolation.kt")
                public void testTpBoundsViolation() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/nullability/tpBoundsViolation.kt");
                }

                @Test
                @TestMetadata("tpBoundsViolationVariance.kt")
                public void testTpBoundsViolationVariance() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/nullability/tpBoundsViolationVariance.kt");
                }

                @Test
                @TestMetadata("tpInBounds.kt")
                public void testTpInBounds() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/nullability/tpInBounds.kt");
                }

                @Test
                @TestMetadata("useAsReceiver.kt")
                public void testUseAsReceiver() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/nullability/useAsReceiver.kt");
                }

                @Test
                @TestMetadata("useAsValueArgument.kt")
                public void testUseAsValueArgument() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/nullability/useAsValueArgument.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/generics/projectionsScope")
            @TestDataPath("$PROJECT_ROOT")
            public class ProjectionsScope {
                @Test
                @TestMetadata("addAll.kt")
                public void testAddAll() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/projectionsScope/addAll.kt");
                }

                @Test
                public void testAllFilesPresentInProjectionsScope() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/generics/projectionsScope"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("approximateDispatchReceiver.kt")
                public void testApproximateDispatchReceiver() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/projectionsScope/approximateDispatchReceiver.kt");
                }

                @Test
                @TestMetadata("extensionReceiverTypeMismatch.kt")
                public void testExtensionReceiverTypeMismatch() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/projectionsScope/extensionReceiverTypeMismatch.kt");
                }

                @Test
                @TestMetadata("extensionResultSubstitution.kt")
                public void testExtensionResultSubstitution() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/projectionsScope/extensionResultSubstitution.kt");
                }

                @Test
                @TestMetadata("flexibleProjectedScope.kt")
                public void testFlexibleProjectedScope() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/projectionsScope/flexibleProjectedScope.kt");
                }

                @Test
                @TestMetadata("inValueParameter.kt")
                public void testInValueParameter() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/projectionsScope/inValueParameter.kt");
                }

                @Test
                @TestMetadata("iterateOnExtension.kt")
                public void testIterateOnExtension() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/projectionsScope/iterateOnExtension.kt");
                }

                @Test
                @TestMetadata("kt7296.kt")
                public void testKt7296() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/projectionsScope/kt7296.kt");
                }

                @Test
                @TestMetadata("kt8647.kt")
                public void testKt8647() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/projectionsScope/kt8647.kt");
                }

                @Test
                @TestMetadata("lambdaArgument.kt")
                public void testLambdaArgument() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/projectionsScope/lambdaArgument.kt");
                }

                @Test
                @TestMetadata("leakedApproximatedType.kt")
                public void testLeakedApproximatedType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/projectionsScope/leakedApproximatedType.kt");
                }

                @Test
                @TestMetadata("MLOut.kt")
                public void testMLOut() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/projectionsScope/MLOut.kt");
                }

                @Test
                @TestMetadata("multipleArgumentProjectedOut.kt")
                public void testMultipleArgumentProjectedOut() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/projectionsScope/multipleArgumentProjectedOut.kt");
                }

                @Test
                @TestMetadata("platformSuperClass.kt")
                public void testPlatformSuperClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/projectionsScope/platformSuperClass.kt");
                }

                @Test
                @TestMetadata("projectedOutConventions.kt")
                public void testProjectedOutConventions() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/projectionsScope/projectedOutConventions.kt");
                }

                @Test
                @TestMetadata("projectedOutSmartCast.kt")
                public void testProjectedOutSmartCast() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/projectionsScope/projectedOutSmartCast.kt");
                }

                @Test
                @TestMetadata("recursiveUpperBoundStar.kt")
                public void testRecursiveUpperBoundStar() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/projectionsScope/recursiveUpperBoundStar.kt");
                }

                @Test
                @TestMetadata("recursiveUpperBoundStarOut.kt")
                public void testRecursiveUpperBoundStarOut() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/projectionsScope/recursiveUpperBoundStarOut.kt");
                }

                @Test
                @TestMetadata("starNullability.kt")
                public void testStarNullability() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/projectionsScope/starNullability.kt");
                }

                @Test
                @TestMetadata("starNullabilityRecursive.kt")
                public void testStarNullabilityRecursive() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/projectionsScope/starNullabilityRecursive.kt");
                }

                @Test
                @TestMetadata("superClass.kt")
                public void testSuperClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/projectionsScope/superClass.kt");
                }

                @Test
                @TestMetadata("typeMismatchConventions.kt")
                public void testTypeMismatchConventions() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/projectionsScope/typeMismatchConventions.kt");
                }

                @Test
                @TestMetadata("typeMismatchInLambda.kt")
                public void testTypeMismatchInLambda() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/projectionsScope/typeMismatchInLambda.kt");
                }

                @Test
                @TestMetadata("typeParameterBounds.kt")
                public void testTypeParameterBounds() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/projectionsScope/typeParameterBounds.kt");
                }

                @Test
                @TestMetadata("unsafeVarianceInAliasedFunctionalType.kt")
                public void testUnsafeVarianceInAliasedFunctionalType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/projectionsScope/unsafeVarianceInAliasedFunctionalType.kt");
                }

                @Test
                @TestMetadata("unsafeVarianceOnInputTypeOfFunctionalType.kt")
                public void testUnsafeVarianceOnInputTypeOfFunctionalType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/projectionsScope/unsafeVarianceOnInputTypeOfFunctionalType.kt");
                }

                @Test
                @TestMetadata("unsafeVarianceStar.kt")
                public void testUnsafeVarianceStar() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/projectionsScope/unsafeVarianceStar.kt");
                }

                @Test
                @TestMetadata("unsafeVarianceWithRecursiveGenerics.kt")
                public void testUnsafeVarianceWithRecursiveGenerics() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/projectionsScope/unsafeVarianceWithRecursiveGenerics.kt");
                }

                @Test
                @TestMetadata("varargs.kt")
                public void testVarargs() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/projectionsScope/varargs.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/generics/starProjections")
            @TestDataPath("$PROJECT_ROOT")
            public class StarProjections {
                @Test
                public void testAllFilesPresentInStarProjections() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/generics/starProjections"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("checkBounds.kt")
                public void testCheckBounds() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/starProjections/checkBounds.kt");
                }

                @Test
                @TestMetadata("collectionInheritedFromJava.kt")
                public void testCollectionInheritedFromJava() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/starProjections/collectionInheritedFromJava.kt");
                }

                @Test
                @TestMetadata("foldRecursiveTypesToStarProjection.kt")
                public void testFoldRecursiveTypesToStarProjection() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/starProjections/foldRecursiveTypesToStarProjection.kt");
                }

                @Test
                @TestMetadata("inheritedFromJava.kt")
                public void testInheritedFromJava() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/starProjections/inheritedFromJava.kt");
                }

                @Test
                @TestMetadata("inheritedFromKotlin.kt")
                public void testInheritedFromKotlin() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/starProjections/inheritedFromKotlin.kt");
                }

                @Test
                @TestMetadata("invalid.kt")
                public void testInvalid() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/starProjections/invalid.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/generics/tpAsReified")
            @TestDataPath("$PROJECT_ROOT")
            public class TpAsReified {
                @Test
                public void testAllFilesPresentInTpAsReified() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/generics/tpAsReified"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("CapturedAsReified.kt")
                public void testCapturedAsReified() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/tpAsReified/CapturedAsReified.kt");
                }

                @Test
                @TestMetadata("ClassDereference.kt")
                public void testClassDereference() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/tpAsReified/ClassDereference.kt");
                }

                @Test
                @TestMetadata("Conventions.kt")
                public void testConventions() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/tpAsReified/Conventions.kt");
                }

                @Test
                @TestMetadata("GenericArrayAsReifiedArgument.kt")
                public void testGenericArrayAsReifiedArgument() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/tpAsReified/GenericArrayAsReifiedArgument.kt");
                }

                @Test
                @TestMetadata("GenericArrayAsReifiedArgumentWarning.kt")
                public void testGenericArrayAsReifiedArgumentWarning() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/tpAsReified/GenericArrayAsReifiedArgumentWarning.kt");
                }

                @Test
                @TestMetadata("GenericAsReifiedArgument.kt")
                public void testGenericAsReifiedArgument() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/tpAsReified/GenericAsReifiedArgument.kt");
                }

                @Test
                @TestMetadata("InConstructor.kt")
                public void testInConstructor() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/tpAsReified/InConstructor.kt");
                }

                @Test
                @TestMetadata("InFunction.kt")
                public void testInFunction() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/tpAsReified/InFunction.kt");
                }

                @Test
                @TestMetadata("InProperty.kt")
                public void testInProperty() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/tpAsReified/InProperty.kt");
                }

                @Test
                @TestMetadata("InType.kt")
                public void testInType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/tpAsReified/InType.kt");
                }

                @Test
                @TestMetadata("InlineableReified.kt")
                public void testInlineableReified() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/tpAsReified/InlineableReified.kt");
                }

                @Test
                @TestMetadata("LocalFun.kt")
                public void testLocalFun() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/tpAsReified/LocalFun.kt");
                }

                @Test
                @TestMetadata("NotInlineableReified.kt")
                public void testNotInlineableReified() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/tpAsReified/NotInlineableReified.kt");
                }

                @Test
                @TestMetadata("ReifiedClass.kt")
                public void testReifiedClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/tpAsReified/ReifiedClass.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/generics/varProjection")
            @TestDataPath("$PROJECT_ROOT")
            public class VarProjection {
                @Test
                public void testAllFilesPresentInVarProjection() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/generics/varProjection"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("setterNotProjectedOutAssign.kt")
                public void testSetterNotProjectedOutAssign() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/varProjection/setterNotProjectedOutAssign.kt");
                }

                @Test
                @TestMetadata("setterProjectedOutAssign.kt")
                public void testSetterProjectedOutAssign() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/varProjection/setterProjectedOutAssign.kt");
                }

                @Test
                @TestMetadata("setterProjectedOutNoPlusAssign.kt")
                public void testSetterProjectedOutNoPlusAssign() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/varProjection/setterProjectedOutNoPlusAssign.kt");
                }

                @Test
                @TestMetadata("setterProjectedOutPlusAssignDefined.kt")
                public void testSetterProjectedOutPlusAssignDefined() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/generics/varProjection/setterProjectedOutPlusAssignDefined.kt");
                }
            }
        }

        @Nested
        @TestMetadata("compiler/testData/diagnostics/tests/imports")
        @TestDataPath("$PROJECT_ROOT")
        public class Imports {
            @Test
            public void testAllFilesPresentInImports() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/imports"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
            }

            @Test
            @TestMetadata("AllUnderImportsAmbiguity.kt")
            public void testAllUnderImportsAmbiguity() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/AllUnderImportsAmbiguity.kt");
            }

            @Test
            @TestMetadata("AllUnderImportsLessPriority.kt")
            public void testAllUnderImportsLessPriority() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/AllUnderImportsLessPriority.kt");
            }

            @Test
            @TestMetadata("AllUnderImportsSamePriorityForFunction.kt")
            public void testAllUnderImportsSamePriorityForFunction() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/AllUnderImportsSamePriorityForFunction.kt");
            }

            @Test
            @TestMetadata("AllUnderImportsSamePriorityForProperty.kt")
            public void testAllUnderImportsSamePriorityForProperty() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/AllUnderImportsSamePriorityForProperty.kt");
            }

            @Test
            @TestMetadata("CheckJavaVisibility.kt")
            public void testCheckJavaVisibility() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/CheckJavaVisibility.kt");
            }

            @Test
            @TestMetadata("CheckJavaVisibility2.kt")
            public void testCheckJavaVisibility2() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/CheckJavaVisibility2.kt");
            }

            @Test
            @TestMetadata("CheckVisibility.kt")
            public void testCheckVisibility() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/CheckVisibility.kt");
            }

            @Test
            @TestMetadata("ClassClash.kt")
            public void testClassClash() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/ClassClash.kt");
            }

            @Test
            @TestMetadata("ClassClashStarImport.kt")
            public void testClassClashStarImport() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/ClassClashStarImport.kt");
            }

            @Test
            @TestMetadata("ClassImportsConflicting.kt")
            public void testClassImportsConflicting() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/ClassImportsConflicting.kt");
            }

            @Test
            @TestMetadata("CurrentPackageAndAllUnderImport.kt")
            public void testCurrentPackageAndAllUnderImport() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/CurrentPackageAndAllUnderImport.kt");
            }

            @Test
            @TestMetadata("CurrentPackageAndExplicitImport.kt")
            public void testCurrentPackageAndExplicitImport() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/CurrentPackageAndExplicitImport.kt");
            }

            @Test
            @TestMetadata("DefaultImportsPriority.kt")
            public void testDefaultImportsPriority() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/DefaultImportsPriority.kt");
            }

            @Test
            @TestMetadata("DoubleImports.kt")
            public void testDoubleImports() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/DoubleImports.kt");
            }

            @Test
            @TestMetadata("ExplicitImportsAmbiguity.kt")
            public void testExplicitImportsAmbiguity() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/ExplicitImportsAmbiguity.kt");
            }

            @Test
            @TestMetadata("ExplicitImportsUnambiguityForFunction.kt")
            public void testExplicitImportsUnambiguityForFunction() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/ExplicitImportsUnambiguityForFunction.kt");
            }

            @Test
            @TestMetadata("ExplicitPackageImportsAmbiguity.kt")
            public void testExplicitPackageImportsAmbiguity() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/ExplicitPackageImportsAmbiguity.kt");
            }

            @Test
            @TestMetadata("ImportClassClash.kt")
            public void testImportClassClash() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/ImportClassClash.kt");
            }

            @Test
            @TestMetadata("ImportFromCompanionObject.kt")
            public void testImportFromCompanionObject() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/ImportFromCompanionObject.kt");
            }

            @Test
            @TestMetadata("ImportFromCurrentWithDifferentName.kt")
            public void testImportFromCurrentWithDifferentName() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/ImportFromCurrentWithDifferentName.kt");
            }

            @Test
            @TestMetadata("ImportFromObject.kt")
            public void testImportFromObject() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/ImportFromObject.kt");
            }

            @Test
            @TestMetadata("ImportFromRootPackage.kt")
            public void testImportFromRootPackage() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/ImportFromRootPackage.kt");
            }

            @Test
            @TestMetadata("importFunctionWithAllUnderImport.kt")
            public void testImportFunctionWithAllUnderImport() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/importFunctionWithAllUnderImport.kt");
            }

            @Test
            @TestMetadata("importFunctionWithAllUnderImportAfterNamedImport.kt")
            public void testImportFunctionWithAllUnderImportAfterNamedImport() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/importFunctionWithAllUnderImportAfterNamedImport.kt");
            }

            @Test
            @TestMetadata("ImportFunctionWithPackageName.kt")
            public void testImportFunctionWithPackageName() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/ImportFunctionWithPackageName.kt");
            }

            @Test
            @TestMetadata("ImportHidingDefinitionInTheSameFile.kt")
            public void testImportHidingDefinitionInTheSameFile() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/ImportHidingDefinitionInTheSameFile.kt");
            }

            @Test
            @TestMetadata("ImportNestedWithDifferentName.kt")
            public void testImportNestedWithDifferentName() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/ImportNestedWithDifferentName.kt");
            }

            @Test
            @TestMetadata("ImportObjectAndUseAsSupertype.kt")
            public void testImportObjectAndUseAsSupertype() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/ImportObjectAndUseAsSupertype.kt");
            }

            @Test
            @TestMetadata("ImportObjectHidesCurrentPackage.kt")
            public void testImportObjectHidesCurrentPackage() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/ImportObjectHidesCurrentPackage.kt");
            }

            @Test
            @TestMetadata("ImportOverloadFunctions.kt")
            public void testImportOverloadFunctions() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/ImportOverloadFunctions.kt");
            }

            @Test
            @TestMetadata("ImportPrivateMember.kt")
            public void testImportPrivateMember() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/ImportPrivateMember.kt");
            }

            @Test
            @TestMetadata("ImportPrivateMemberFromOtherFile.kt")
            public void testImportPrivateMemberFromOtherFile() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/ImportPrivateMemberFromOtherFile.kt");
            }

            @Test
            @TestMetadata("ImportPrivateMembersWithStar.kt")
            public void testImportPrivateMembersWithStar() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/ImportPrivateMembersWithStar.kt");
            }

            @Test
            @TestMetadata("ImportProtectedClass.kt")
            public void testImportProtectedClass() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/ImportProtectedClass.kt");
            }

            @Test
            @TestMetadata("ImportResolutionOrder.kt")
            public void testImportResolutionOrder() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/ImportResolutionOrder.kt");
            }

            @Test
            @TestMetadata("ImportStaticFunctionWithNonStaticSibling.kt")
            public void testImportStaticFunctionWithNonStaticSibling() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/ImportStaticFunctionWithNonStaticSibling.kt");
            }

            @Test
            @TestMetadata("ImportTwoTimes.kt")
            public void testImportTwoTimes() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/ImportTwoTimes.kt");
            }

            @Test
            @TestMetadata("ImportTwoTimesStar.kt")
            public void testImportTwoTimesStar() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/ImportTwoTimesStar.kt");
            }

            @Test
            @TestMetadata("Imports.kt")
            public void testImports() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/Imports.kt");
            }

            @Test
            @TestMetadata("ImportsConflicting.kt")
            public void testImportsConflicting() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/ImportsConflicting.kt");
            }

            @Test
            @TestMetadata("InaccessiblePrivateClass.kt")
            public void testInaccessiblePrivateClass() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/InaccessiblePrivateClass.kt");
            }

            @Test
            @TestMetadata("InaccessiblePrivateInFile.kt")
            public void testInaccessiblePrivateInFile() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/InaccessiblePrivateInFile.kt");
            }

            @Test
            @TestMetadata("invisibleFakeReferenceInImport.kt")
            public void testInvisibleFakeReferenceInImport() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/invisibleFakeReferenceInImport.kt");
            }

            @Test
            @TestMetadata("JavaPackageLocalClassNotImported.kt")
            public void testJavaPackageLocalClassNotImported() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/JavaPackageLocalClassNotImported.kt");
            }

            @Test
            @TestMetadata("kt13112.kt")
            public void testKt13112() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/kt13112.kt");
            }

            @Test
            @TestMetadata("MalformedImports.kt")
            public void testMalformedImports() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/MalformedImports.kt");
            }

            @Test
            @TestMetadata("NestedClassClash.kt")
            public void testNestedClassClash() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/NestedClassClash.kt");
            }

            @Test
            @TestMetadata("OperatorRenameOnImport.kt")
            public void testOperatorRenameOnImport() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/OperatorRenameOnImport.kt");
            }

            @Test
            @TestMetadata("OptionalAnnotationClasses.kt")
            public void testOptionalAnnotationClasses() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/OptionalAnnotationClasses.kt");
            }

            @Test
            @TestMetadata("PackageLocalClassNotImported.kt")
            public void testPackageLocalClassNotImported() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/PackageLocalClassNotImported.kt");
            }

            @Test
            @TestMetadata("PackageLocalClassReferencedError.kt")
            public void testPackageLocalClassReferencedError() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/PackageLocalClassReferencedError.kt");
            }

            @Test
            @TestMetadata("PackageVsClass.kt")
            public void testPackageVsClass() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/PackageVsClass.kt");
            }

            @Test
            @TestMetadata("PrivateClassNotImported.kt")
            public void testPrivateClassNotImported() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/PrivateClassNotImported.kt");
            }

            @Test
            @TestMetadata("PrivateClassReferencedError.kt")
            public void testPrivateClassReferencedError() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/PrivateClassReferencedError.kt");
            }

            @Test
            @TestMetadata("propertyClassFileDependencyRecursion.kt")
            public void testPropertyClassFileDependencyRecursion() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/propertyClassFileDependencyRecursion.kt");
            }

            @Test
            @TestMetadata("RenameOnImport.kt")
            public void testRenameOnImport() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/RenameOnImport.kt");
            }

            @Test
            @TestMetadata("StarImportFromObject.kt")
            public void testStarImportFromObject() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/StarImportFromObject.kt");
            }

            @Test
            @TestMetadata("SyntaxError.kt")
            public void testSyntaxError() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/SyntaxError.kt");
            }

            @Test
            @TestMetadata("TopLevelClassVsPackage.kt")
            public void testTopLevelClassVsPackage() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/TopLevelClassVsPackage.kt");
            }

            @Test
            @TestMetadata("twoImportLists.kt")
            public void testTwoImportLists() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/twoImportLists.kt");
            }

            @Test
            @TestMetadata("WrongImport.kt")
            public void testWrongImport() throws Exception {
                runTest("compiler/testData/diagnostics/tests/imports/WrongImport.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/diagnostics/tests/incompleteCode")
        @TestDataPath("$PROJECT_ROOT")
        public class IncompleteCode {
            @Test
            public void testAllFilesPresentInIncompleteCode() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/incompleteCode"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
            }

            @Test
            @TestMetadata("arrayBracketsRange.kt")
            public void testArrayBracketsRange() throws Exception {
                runTest("compiler/testData/diagnostics/tests/incompleteCode/arrayBracketsRange.kt");
            }

            @Test
            @TestMetadata("checkNothingIsSubtype.kt")
            public void testCheckNothingIsSubtype() throws Exception {
                runTest("compiler/testData/diagnostics/tests/incompleteCode/checkNothingIsSubtype.kt");
            }

            @Test
            @TestMetadata("controlStructuresErrors.kt")
            public void testControlStructuresErrors() throws Exception {
                runTest("compiler/testData/diagnostics/tests/incompleteCode/controlStructuresErrors.kt");
            }

            @Test
            @TestMetadata("illegalSelectorCallableReference.kt")
            public void testIllegalSelectorCallableReference() throws Exception {
                runTest("compiler/testData/diagnostics/tests/incompleteCode/illegalSelectorCallableReference.kt");
            }

            @Test
            @TestMetadata("inExpr.kt")
            public void testInExpr() throws Exception {
                runTest("compiler/testData/diagnostics/tests/incompleteCode/inExpr.kt");
            }

            @Test
            @TestMetadata("incompleteAssignment.kt")
            public void testIncompleteAssignment() throws Exception {
                runTest("compiler/testData/diagnostics/tests/incompleteCode/incompleteAssignment.kt");
            }

            @Test
            @TestMetadata("incompleteEquals.kt")
            public void testIncompleteEquals() throws Exception {
                runTest("compiler/testData/diagnostics/tests/incompleteCode/incompleteEquals.kt");
            }

            @Test
            @TestMetadata("incompleteTryCatchBlock.kt")
            public void testIncompleteTryCatchBlock() throws Exception {
                runTest("compiler/testData/diagnostics/tests/incompleteCode/incompleteTryCatchBlock.kt");
            }

            @Test
            @TestMetadata("kt1955.kt")
            public void testKt1955() throws Exception {
                runTest("compiler/testData/diagnostics/tests/incompleteCode/kt1955.kt");
            }

            @Test
            @TestMetadata("kt2014.kt")
            public void testKt2014() throws Exception {
                runTest("compiler/testData/diagnostics/tests/incompleteCode/kt2014.kt");
            }

            @Test
            @TestMetadata("kt4866UnresolvedArrayAccess.kt")
            public void testKt4866UnresolvedArrayAccess() throws Exception {
                runTest("compiler/testData/diagnostics/tests/incompleteCode/kt4866UnresolvedArrayAccess.kt");
            }

            @Test
            @TestMetadata("NoSenselessComparisonForErrorType.kt")
            public void testNoSenselessComparisonForErrorType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/incompleteCode/NoSenselessComparisonForErrorType.kt");
            }

            @Test
            @TestMetadata("plusOnTheRight.kt")
            public void testPlusOnTheRight() throws Exception {
                runTest("compiler/testData/diagnostics/tests/incompleteCode/plusOnTheRight.kt");
            }

            @Test
            @TestMetadata("pseudocodeTraverseNextInstructions.kt")
            public void testPseudocodeTraverseNextInstructions() throws Exception {
                runTest("compiler/testData/diagnostics/tests/incompleteCode/pseudocodeTraverseNextInstructions.kt");
            }

            @Test
            @TestMetadata("senselessComparisonWithNull.kt")
            public void testSenselessComparisonWithNull() throws Exception {
                runTest("compiler/testData/diagnostics/tests/incompleteCode/senselessComparisonWithNull.kt");
            }

            @Test
            @TestMetadata("SupertypeOfErrorType.kt")
            public void testSupertypeOfErrorType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/incompleteCode/SupertypeOfErrorType.kt");
            }

            @Test
            @TestMetadata("typeParameterOnLhsOfDot.kt")
            public void testTypeParameterOnLhsOfDot() throws Exception {
                runTest("compiler/testData/diagnostics/tests/incompleteCode/typeParameterOnLhsOfDot.kt");
            }

            @Test
            @TestMetadata("unresolvedArguments.kt")
            public void testUnresolvedArguments() throws Exception {
                runTest("compiler/testData/diagnostics/tests/incompleteCode/unresolvedArguments.kt");
            }

            @Test
            @TestMetadata("unresolvedOperation.kt")
            public void testUnresolvedOperation() throws Exception {
                runTest("compiler/testData/diagnostics/tests/incompleteCode/unresolvedOperation.kt");
            }

            @Test
            @TestMetadata("variableDeclarationInSelector.kt")
            public void testVariableDeclarationInSelector() throws Exception {
                runTest("compiler/testData/diagnostics/tests/incompleteCode/variableDeclarationInSelector.kt");
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/incompleteCode/diagnosticWithSyntaxError")
            @TestDataPath("$PROJECT_ROOT")
            public class DiagnosticWithSyntaxError {
                @Test
                public void testAllFilesPresentInDiagnosticWithSyntaxError() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/incompleteCode/diagnosticWithSyntaxError"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("arrayExpression.kt")
                public void testArrayExpression() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/incompleteCode/diagnosticWithSyntaxError/arrayExpression.kt");
                }

                @Test
                @TestMetadata("checkBackingFieldException.kt")
                public void testCheckBackingFieldException() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/incompleteCode/diagnosticWithSyntaxError/checkBackingFieldException.kt");
                }

                @Test
                @TestMetadata("completeFunctionArgumentsOfNestedCalls.kt")
                public void testCompleteFunctionArgumentsOfNestedCalls() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/incompleteCode/diagnosticWithSyntaxError/completeFunctionArgumentsOfNestedCalls.kt");
                }

                @Test
                @TestMetadata("declarationAfterDotSelectorExpected.kt")
                public void testDeclarationAfterDotSelectorExpected() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/incompleteCode/diagnosticWithSyntaxError/declarationAfterDotSelectorExpected.kt");
                }

                @Test
                @TestMetadata("declarationAfterIncompleteElvis.kt")
                public void testDeclarationAfterIncompleteElvis() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/incompleteCode/diagnosticWithSyntaxError/declarationAfterIncompleteElvis.kt");
                }

                @Test
                @TestMetadata("funEquals.kt")
                public void testFunEquals() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/incompleteCode/diagnosticWithSyntaxError/funEquals.kt");
                }

                @Test
                @TestMetadata("funKeyword.kt")
                public void testFunKeyword() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/incompleteCode/diagnosticWithSyntaxError/funKeyword.kt");
                }

                @Test
                @TestMetadata("funcitonTypes.kt")
                public void testFuncitonTypes() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/incompleteCode/diagnosticWithSyntaxError/funcitonTypes.kt");
                }

                @Test
                @TestMetadata("incompleteEnumReference.kt")
                public void testIncompleteEnumReference() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/incompleteCode/diagnosticWithSyntaxError/incompleteEnumReference.kt");
                }

                @Test
                @TestMetadata("incompleteVal.kt")
                public void testIncompleteVal() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/incompleteCode/diagnosticWithSyntaxError/incompleteVal.kt");
                }

                @Test
                @TestMetadata("incompleteValWithAccessor.kt")
                public void testIncompleteValWithAccessor() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/incompleteCode/diagnosticWithSyntaxError/incompleteValWithAccessor.kt");
                }

                @Test
                @TestMetadata("incompleteWhen.kt")
                public void testIncompleteWhen() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/incompleteCode/diagnosticWithSyntaxError/incompleteWhen.kt");
                }

                @Test
                @TestMetadata("namedFun.kt")
                public void testNamedFun() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/incompleteCode/diagnosticWithSyntaxError/namedFun.kt");
                }

                @Test
                @TestMetadata("noTypeParamsInReturnType.kt")
                public void testNoTypeParamsInReturnType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/incompleteCode/diagnosticWithSyntaxError/noTypeParamsInReturnType.kt");
                }

                @Test
                @TestMetadata("typeReferenceError.kt")
                public void testTypeReferenceError() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/incompleteCode/diagnosticWithSyntaxError/typeReferenceError.kt");
                }

                @Test
                @TestMetadata("valNoName.kt")
                public void testValNoName() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/incompleteCode/diagnosticWithSyntaxError/valNoName.kt");
                }

                @Test
                @TestMetadata("valWithNoNameBeforeNextDeclarationWithModifiers.kt")
                public void testValWithNoNameBeforeNextDeclarationWithModifiers() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/incompleteCode/diagnosticWithSyntaxError/valWithNoNameBeforeNextDeclarationWithModifiers.kt");
                }

                @Test
                @TestMetadata("valWithNoNameInBlock.kt")
                public void testValWithNoNameInBlock() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/incompleteCode/diagnosticWithSyntaxError/valWithNoNameInBlock.kt");
                }
            }
        }

        @Nested
        @TestMetadata("compiler/testData/diagnostics/tests/inference")
        @TestDataPath("$PROJECT_ROOT")
        public class Inference {
            @Test
            public void testAllFilesPresentInInference() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/inference"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
            }

            @Test
            @TestMetadata("annotatedUnderscoredTypeArgument.kt")
            public void testAnnotatedUnderscoredTypeArgument() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/annotatedUnderscoredTypeArgument.kt");
            }

            @Test
            @TestMetadata("cannotCompleteResolveAmbiguity.kt")
            public void testCannotCompleteResolveAmbiguity() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/cannotCompleteResolveAmbiguity.kt");
            }

            @Test
            @TestMetadata("cannotCompleteResolveFunctionLiteralsNoUse.kt")
            public void testCannotCompleteResolveFunctionLiteralsNoUse() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/cannotCompleteResolveFunctionLiteralsNoUse.kt");
            }

            @Test
            @TestMetadata("cannotCompleteResolveNoInfoForParameter.kt")
            public void testCannotCompleteResolveNoInfoForParameter() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/cannotCompleteResolveNoInfoForParameter.kt");
            }

            @Test
            @TestMetadata("cannotCompleteResolveNoneApplicable.kt")
            public void testCannotCompleteResolveNoneApplicable() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/cannotCompleteResolveNoneApplicable.kt");
            }

            @Test
            @TestMetadata("cannotCompleteResolveWithFunctionLiterals.kt")
            public void testCannotCompleteResolveWithFunctionLiterals() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/cannotCompleteResolveWithFunctionLiterals.kt");
            }

            @Test
            @TestMetadata("capturedInProjectedFlexibleType.kt")
            public void testCapturedInProjectedFlexibleType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/capturedInProjectedFlexibleType.kt");
            }

            @Test
            @TestMetadata("capturedTypesInSelfType.kt")
            public void testCapturedTypesInSelfType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/capturedTypesInSelfType.kt");
            }

            @Test
            @TestMetadata("coerceFunctionLiteralToSuspend.kt")
            public void testCoerceFunctionLiteralToSuspend() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/coerceFunctionLiteralToSuspend.kt");
            }

            @Test
            @TestMetadata("commonSuperTypeOfErrorTypes.kt")
            public void testCommonSuperTypeOfErrorTypes() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/commonSuperTypeOfErrorTypes.kt");
            }

            @Test
            @TestMetadata("commonSuperTypeOfTypesWithErrorSupertypes.kt")
            public void testCommonSuperTypeOfTypesWithErrorSupertypes() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/commonSuperTypeOfTypesWithErrorSupertypes.kt");
            }

            @Test
            @TestMetadata("completeInferenceIfManyFailed.kt")
            public void testCompleteInferenceIfManyFailed() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/completeInferenceIfManyFailed.kt");
            }

            @Test
            @TestMetadata("completionOfMultipleLambdas.kt")
            public void testCompletionOfMultipleLambdas() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/completionOfMultipleLambdas.kt");
            }

            @Test
            @TestMetadata("conflictingSubstitutions.kt")
            public void testConflictingSubstitutions() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/conflictingSubstitutions.kt");
            }

            @Test
            @TestMetadata("cstFromErrorAndNonErrorTypes.kt")
            public void testCstFromErrorAndNonErrorTypes() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/cstFromErrorAndNonErrorTypes.kt");
            }

            @Test
            @TestMetadata("dependOnExpectedType.kt")
            public void testDependOnExpectedType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/dependOnExpectedType.kt");
            }

            @Test
            @TestMetadata("dependantOnVariance.kt")
            public void testDependantOnVariance() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/dependantOnVariance.kt");
            }

            @Test
            @TestMetadata("dependantOnVarianceNullable.kt")
            public void testDependantOnVarianceNullable() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/dependantOnVarianceNullable.kt");
            }

            @Test
            @TestMetadata("discardInapplicableCandidateWithNotSatisfyingSelfType.kt")
            public void testDiscardInapplicableCandidateWithNotSatisfyingSelfType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/discardInapplicableCandidateWithNotSatisfyingSelfType.kt");
            }

            @Test
            @TestMetadata("equalitySubstitutionInsideNonInvariantType.kt")
            public void testEqualitySubstitutionInsideNonInvariantType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/equalitySubstitutionInsideNonInvariantType.kt");
            }

            @Test
            @TestMetadata("errorsOnImplicitInvokeInSimpleCall.kt")
            public void testErrorsOnImplicitInvokeInSimpleCall() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/errorsOnImplicitInvokeInSimpleCall.kt");
            }

            @Test
            @TestMetadata("expectedTypeAdditionalTest.kt")
            public void testExpectedTypeAdditionalTest() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/expectedTypeAdditionalTest.kt");
            }

            @Test
            @TestMetadata("expectedTypeDoubleReceiver.kt")
            public void testExpectedTypeDoubleReceiver() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/expectedTypeDoubleReceiver.kt");
            }

            @Test
            @TestMetadata("expectedTypeFromCast.kt")
            public void testExpectedTypeFromCast() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/expectedTypeFromCast.kt");
            }

            @Test
            @TestMetadata("expectedTypeFromCastComplexExpression.kt")
            public void testExpectedTypeFromCastComplexExpression() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/expectedTypeFromCastComplexExpression.kt");
            }

            @Test
            @TestMetadata("expectedTypeFromCastParenthesized.kt")
            public void testExpectedTypeFromCastParenthesized() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/expectedTypeFromCastParenthesized.kt");
            }

            @Test
            @TestMetadata("expectedTypeWithGenerics.kt")
            public void testExpectedTypeWithGenerics() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/expectedTypeWithGenerics.kt");
            }

            @Test
            @TestMetadata("expectedTypeWithGenericsSafeCalls.kt")
            public void testExpectedTypeWithGenericsSafeCalls() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/expectedTypeWithGenericsSafeCalls.kt");
            }

            @Test
            @TestMetadata("extensionLambdasAndArrow.kt")
            public void testExtensionLambdasAndArrow() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/extensionLambdasAndArrow.kt");
            }

            @Test
            @TestMetadata("findViewById.kt")
            public void testFindViewById() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/findViewById.kt");
            }

            @Test
            @TestMetadata("fixVariableToNothing.kt")
            public void testFixVariableToNothing() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/fixVariableToNothing.kt");
            }

            @Test
            @TestMetadata("fixationOrderForProperConstraints.kt")
            public void testFixationOrderForProperConstraints() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/fixationOrderForProperConstraints.kt");
            }

            @Test
            @TestMetadata("flexibleTypesAsUpperBound.kt")
            public void testFlexibleTypesAsUpperBound() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/flexibleTypesAsUpperBound.kt");
            }

            @Test
            @TestMetadata("functionPlaceholderError.kt")
            public void testFunctionPlaceholderError() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/functionPlaceholderError.kt");
            }

            @Test
            @TestMetadata("genericAssignmentOperator.kt")
            public void testGenericAssignmentOperator() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/genericAssignmentOperator.kt");
            }

            @Test
            @TestMetadata("hasErrorInConstrainingTypes.kt")
            public void testHasErrorInConstrainingTypes() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/hasErrorInConstrainingTypes.kt");
            }

            @Test
            @TestMetadata("illegalUnderscoredTypeArgument.kt")
            public void testIllegalUnderscoredTypeArgument() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/illegalUnderscoredTypeArgument.kt");
            }

            @Test
            @TestMetadata("immutableArrayList.kt")
            public void testImmutableArrayList() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/immutableArrayList.kt");
            }

            @Test
            @TestMetadata("implicitInvokeExtensionWithFunctionalArgument.kt")
            public void testImplicitInvokeExtensionWithFunctionalArgument() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/implicitInvokeExtensionWithFunctionalArgument.kt");
            }

            @Test
            @TestMetadata("implicitInvokeInCompanionObjectWithFunctionalArgument.kt")
            public void testImplicitInvokeInCompanionObjectWithFunctionalArgument() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/implicitInvokeInCompanionObjectWithFunctionalArgument.kt");
            }

            @Test
            @TestMetadata("implicitInvokeInObjectWithFunctionalArgument.kt")
            public void testImplicitInvokeInObjectWithFunctionalArgument() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/implicitInvokeInObjectWithFunctionalArgument.kt");
            }

            @Test
            @TestMetadata("implicitInvokeWithFunctionLiteralArgument.kt")
            public void testImplicitInvokeWithFunctionLiteralArgument() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/implicitInvokeWithFunctionLiteralArgument.kt");
            }

            @Test
            @TestMetadata("inferInFunctionLiterals.kt")
            public void testInferInFunctionLiterals() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/inferInFunctionLiterals.kt");
            }

            @Test
            @TestMetadata("inferInFunctionLiteralsWithReturn.kt")
            public void testInferInFunctionLiteralsWithReturn() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/inferInFunctionLiteralsWithReturn.kt");
            }

            @Test
            @TestMetadata("intersectionTypeMultipleBoundsAsReceiver.kt")
            public void testIntersectionTypeMultipleBoundsAsReceiver() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/intersectionTypeMultipleBoundsAsReceiver.kt");
            }

            @Test
            @TestMetadata("intersectionTypesWithContravariantTypes.kt")
            public void testIntersectionTypesWithContravariantTypes() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/intersectionTypesWithContravariantTypes.kt");
            }

            @Test
            @TestMetadata("intersectionWithEnum.kt")
            public void testIntersectionWithEnum() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/intersectionWithEnum.kt");
            }

            @Test
            @TestMetadata("invokeLambdaAsFunction.kt")
            public void testInvokeLambdaAsFunction() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/invokeLambdaAsFunction.kt");
            }

            @Test
            @TestMetadata("knownTypeParameters.kt")
            public void testKnownTypeParameters() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/knownTypeParameters.kt");
            }

            @Test
            @TestMetadata("kt11963.kt")
            public void testKt11963() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/kt11963.kt");
            }

            @Test
            @TestMetadata("kt12399.kt")
            public void testKt12399() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/kt12399.kt");
            }

            @Test
            @TestMetadata("kt1293.kt")
            public void testKt1293() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/kt1293.kt");
            }

            @Test
            @TestMetadata("kt28598.kt")
            public void testKt28598() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/kt28598.kt");
            }

            @Test
            @TestMetadata("kt28654.kt")
            public void testKt28654() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/kt28654.kt");
            }

            @Test
            @TestMetadata("kt30405.kt")
            public void testKt30405() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/kt30405.kt");
            }

            @Test
            @TestMetadata("kt3184.kt")
            public void testKt3184() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/kt3184.kt");
            }

            @Test
            @TestMetadata("kt32196.kt")
            public void testKt32196() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/kt32196.kt");
            }

            @Test
            @TestMetadata("kt32415.kt")
            public void testKt32415() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/kt32415.kt");
            }

            @Test
            @TestMetadata("kt32434.kt")
            public void testKt32434() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/kt32434.kt");
            }

            @Test
            @TestMetadata("kt32462.kt")
            public void testKt32462() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/kt32462.kt");
            }

            @Test
            @TestMetadata("kt33263.kt")
            public void testKt33263() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/kt33263.kt");
            }

            @Test
            @TestMetadata("kt35702.kt")
            public void testKt35702() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/kt35702.kt");
            }

            @Test
            @TestMetadata("kt36044.kt")
            public void testKt36044() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/kt36044.kt");
            }

            @Test
            @TestMetadata("kt36819.kt")
            public void testKt36819() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/kt36819.kt");
            }

            @Test
            @TestMetadata("kt37853.kt")
            public void testKt37853() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/kt37853.kt");
            }

            @Test
            @TestMetadata("kt39220.kt")
            public void testKt39220() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/kt39220.kt");
            }

            @Test
            @TestMetadata("kt40396.kt")
            public void testKt40396() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/kt40396.kt");
            }

            @Test
            @TestMetadata("kt46515.kt")
            public void testKt46515() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/kt46515.kt");
            }

            @Test
            @TestMetadata("kt47316.kt")
            public void testKt47316() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/kt47316.kt");
            }

            @Test
            @TestMetadata("kt49658.kt")
            public void testKt49658() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/kt49658.kt");
            }

            @Test
            @TestMetadata("kt49658Strict.kt")
            public void testKt49658Strict() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/kt49658Strict.kt");
            }

            @Test
            @TestMetadata("kt51844.kt")
            public void testKt51844() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/kt51844.kt");
            }

            @Test
            @TestMetadata("kt6175.kt")
            public void testKt6175() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/kt6175.kt");
            }

            @Test
            @TestMetadata("kt619.kt")
            public void testKt619() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/kt619.kt");
            }

            @Test
            @TestMetadata("lambdaArgumentWithLabel.kt")
            public void testLambdaArgumentWithLabel() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/lambdaArgumentWithLabel.kt");
            }

            @Test
            @TestMetadata("lambdaInValInitializerWithAnonymousFunctions.kt")
            public void testLambdaInValInitializerWithAnonymousFunctions() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/lambdaInValInitializerWithAnonymousFunctions.kt");
            }

            @Test
            @TestMetadata("lambdaParameterTypeInElvis.kt")
            public void testLambdaParameterTypeInElvis() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/lambdaParameterTypeInElvis.kt");
            }

            @Test
            @TestMetadata("listConstructor.kt")
            public void testListConstructor() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/listConstructor.kt");
            }

            @Test
            @TestMetadata("localFunctionInsideIfBlock.kt")
            public void testLocalFunctionInsideIfBlock() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/localFunctionInsideIfBlock.kt");
            }

            @Test
            @TestMetadata("mapFunction.kt")
            public void testMapFunction() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/mapFunction.kt");
            }

            @Test
            @TestMetadata("mostSpecificAfterInference.kt")
            public void testMostSpecificAfterInference() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/mostSpecificAfterInference.kt");
            }

            @Test
            @TestMetadata("NoInferenceFromDeclaredBounds.kt")
            public void testNoInferenceFromDeclaredBounds() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/NoInferenceFromDeclaredBounds.kt");
            }

            @Test
            @TestMetadata("noInformationForParameter.kt")
            public void testNoInformationForParameter() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/noInformationForParameter.kt");
            }

            @Test
            @TestMetadata("nonFunctionalExpectedTypeForLambdaArgument.kt")
            public void testNonFunctionalExpectedTypeForLambdaArgument() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/nonFunctionalExpectedTypeForLambdaArgument.kt");
            }

            @Test
            @TestMetadata("nullableTypeArgumentWithNotNullUpperBound.kt")
            public void testNullableTypeArgumentWithNotNullUpperBound() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/nullableTypeArgumentWithNotNullUpperBound.kt");
            }

            @Test
            @TestMetadata("nullableUpperBound.kt")
            public void testNullableUpperBound() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/nullableUpperBound.kt");
            }

            @Test
            @TestMetadata("onlyInputTypesWithMultilevelIncorporation.kt")
            public void testOnlyInputTypesWithMultilevelIncorporation() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/onlyInputTypesWithMultilevelIncorporation.kt");
            }

            @Test
            @TestMetadata("opposite.kt")
            public void testOpposite() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/opposite.kt");
            }

            @Test
            @TestMetadata("possibleCycleOnConstraints.kt")
            public void testPossibleCycleOnConstraints() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/possibleCycleOnConstraints.kt");
            }

            @Test
            @TestMetadata("reportAboutUnresolvedReferenceAsUnresolved.kt")
            public void testReportAboutUnresolvedReferenceAsUnresolved() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/reportAboutUnresolvedReferenceAsUnresolved.kt");
            }

            @Test
            @TestMetadata("reportNotEnoughTypeInformationErrorsOnBlockExpressions.kt")
            public void testReportNotEnoughTypeInformationErrorsOnBlockExpressions() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/reportNotEnoughTypeInformationErrorsOnBlockExpressions.kt");
            }

            @Test
            @TestMetadata("resolveWithUnknownLambdaParameterType.kt")
            public void testResolveWithUnknownLambdaParameterType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/resolveWithUnknownLambdaParameterType.kt");
            }

            @Test
            @TestMetadata("returningLambdaInSuspendContext.kt")
            public void testReturningLambdaInSuspendContext() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/returningLambdaInSuspendContext.kt");
            }

            @Test
            @TestMetadata("selectOfLambdaWithExtension.kt")
            public void testSelectOfLambdaWithExtension() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/selectOfLambdaWithExtension.kt");
            }

            @Test
            @TestMetadata("selectOfLambdaWithExtensionDisabled.kt")
            public void testSelectOfLambdaWithExtensionDisabled() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/selectOfLambdaWithExtensionDisabled.kt");
            }

            @Test
            @TestMetadata("selectOfLambdaWithExtensionEnabled.kt")
            public void testSelectOfLambdaWithExtensionEnabled() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/selectOfLambdaWithExtensionEnabled.kt");
            }

            @Test
            @TestMetadata("smartCastFork.kt")
            public void testSmartCastFork() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/smartCastFork.kt");
            }

            @Test
            @TestMetadata("specialCallsWithCallableReferences.kt")
            public void testSpecialCallsWithCallableReferences() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/specialCallsWithCallableReferences.kt");
            }

            @Test
            @TestMetadata("specialCallsWithLambdas.kt")
            public void testSpecialCallsWithLambdas() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/specialCallsWithLambdas.kt");
            }

            @Test
            @TestMetadata("starApproximation.kt")
            public void testStarApproximation() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/starApproximation.kt");
            }

            @Test
            @TestMetadata("starApproximationBangBang.kt")
            public void testStarApproximationBangBang() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/starApproximationBangBang.kt");
            }

            @Test
            @TestMetadata("starApproximationFlexible.kt")
            public void testStarApproximationFlexible() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/starApproximationFlexible.kt");
            }

            @Test
            @TestMetadata("starApproximationFromDifferentTypeParameter.kt")
            public void testStarApproximationFromDifferentTypeParameter() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/starApproximationFromDifferentTypeParameter.kt");
            }

            @Test
            @TestMetadata("stubTypeForSubtyping.kt")
            public void testStubTypeForSubtyping() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/stubTypeForSubtyping.kt");
            }

            @Test
            @TestMetadata("tooEagerSmartcast.kt")
            public void testTooEagerSmartcast() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/tooEagerSmartcast.kt");
            }

            @Test
            @TestMetadata("topLevelIntersection.kt")
            public void testTopLevelIntersection() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/topLevelIntersection.kt");
            }

            @Test
            @TestMetadata("tryNumberLowerBoundsBeforeUpperBounds.kt")
            public void testTryNumberLowerBoundsBeforeUpperBounds() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/tryNumberLowerBoundsBeforeUpperBounds.kt");
            }

            @Test
            @TestMetadata("typeConstructorMismatch.kt")
            public void testTypeConstructorMismatch() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/typeConstructorMismatch.kt");
            }

            @Test
            @TestMetadata("typeInferenceExpectedTypeMismatch.kt")
            public void testTypeInferenceExpectedTypeMismatch() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/typeInferenceExpectedTypeMismatch.kt");
            }

            @Test
            @TestMetadata("typeParameterInConstructor.kt")
            public void testTypeParameterInConstructor() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/typeParameterInConstructor.kt");
            }

            @Test
            @TestMetadata("underscoredTypeArgument.kt")
            public void testUnderscoredTypeArgument() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/underscoredTypeArgument.kt");
            }

            @Test
            @TestMetadata("underscoredTypeInForbiddenPositions.kt")
            public void testUnderscoredTypeInForbiddenPositions() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/underscoredTypeInForbiddenPositions.kt");
            }

            @Test
            @TestMetadata("unsoundness1.kt")
            public void testUnsoundness1() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/unsoundness1.kt");
            }

            @Test
            @TestMetadata("unsoundness2.kt")
            public void testUnsoundness2() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/unsoundness2.kt");
            }

            @Test
            @TestMetadata("useFunctionLiteralsToInferType.kt")
            public void testUseFunctionLiteralsToInferType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/useFunctionLiteralsToInferType.kt");
            }

            @Test
            @TestMetadata("violatingUpperBoundForSelfType.kt")
            public void testViolatingUpperBoundForSelfType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/violatingUpperBoundForSelfType.kt");
            }

            @Test
            @TestMetadata("violatingUpperBoundForSelfTypeError.kt")
            public void testViolatingUpperBoundForSelfTypeError() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inference/violatingUpperBoundForSelfTypeError.kt");
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/inference/builderInference")
            @TestDataPath("$PROJECT_ROOT")
            public class BuilderInference {
                @Test
                public void testAllFilesPresentInBuilderInference() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/inference/builderInference"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("changingResolveIfDontUseBuilderInference.kt")
                public void testChangingResolveIfDontUseBuilderInference() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/builderInference/changingResolveIfDontUseBuilderInference.kt");
                }

                @Test
                @TestMetadata("equalityChecksOnIntegerTypes.kt")
                public void testEqualityChecksOnIntegerTypes() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/builderInference/equalityChecksOnIntegerTypes.kt");
                }

                @Test
                @TestMetadata("equalityChecksOnIntegerTypesProgressive.kt")
                public void testEqualityChecksOnIntegerTypesProgressive() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/builderInference/equalityChecksOnIntegerTypesProgressive.kt");
                }

                @Test
                @TestMetadata("kt47744.kt")
                public void testKt47744() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/builderInference/kt47744.kt");
                }

                @Test
                @TestMetadata("kt49285.kt")
                public void testKt49285() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/builderInference/kt49285.kt");
                }

                @Test
                @TestMetadata("kt49828.kt")
                public void testKt49828() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/builderInference/kt49828.kt");
                }

                @Test
                @TestMetadata("kt49829.kt")
                public void testKt49829() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/builderInference/kt49829.kt");
                }

                @Test
                @TestMetadata("kt50989.kt")
                public void testKt50989() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/builderInference/kt50989.kt");
                }

                @Test
                @TestMetadata("labaledCall.kt")
                public void testLabaledCall() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/builderInference/labaledCall.kt");
                }

                @Test
                @TestMetadata("simpleLambdaInCallWithAnotherLambdaWithBuilderInference.kt")
                public void testSimpleLambdaInCallWithAnotherLambdaWithBuilderInference() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/builderInference/simpleLambdaInCallWithAnotherLambdaWithBuilderInference.kt");
                }

                @Test
                @TestMetadata("skipedUnresolvedInBuilderInferenceWithStubReceiverType.kt")
                public void testSkipedUnresolvedInBuilderInferenceWithStubReceiverType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/builderInference/skipedUnresolvedInBuilderInferenceWithStubReceiverType.kt");
                }

                @Test
                @TestMetadata("specialCallsWithCallableReferences.kt")
                public void testSpecialCallsWithCallableReferences() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/builderInference/specialCallsWithCallableReferences.kt");
                }

                @Test
                @TestMetadata("specialCallsWithCallableReferencesDontCareTypeInBlockExression.kt")
                public void testSpecialCallsWithCallableReferencesDontCareTypeInBlockExression() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/builderInference/specialCallsWithCallableReferencesDontCareTypeInBlockExression.kt");
                }

                @Test
                @TestMetadata("specialCallsWithCallableReferencesDontRewriteAtSlice.kt")
                public void testSpecialCallsWithCallableReferencesDontRewriteAtSlice() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/builderInference/specialCallsWithCallableReferencesDontRewriteAtSlice.kt");
                }

                @Test
                @TestMetadata("specialCallsWithCallableReferencesErrorType.kt")
                public void testSpecialCallsWithCallableReferencesErrorType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/builderInference/specialCallsWithCallableReferencesErrorType.kt");
                }

                @Test
                @TestMetadata("specialCallsWithCallableReferencesErrorTypeUnrestricted.kt")
                public void testSpecialCallsWithCallableReferencesErrorTypeUnrestricted() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/builderInference/specialCallsWithCallableReferencesErrorTypeUnrestricted.kt");
                }

                @Test
                @TestMetadata("specialCallsWithCallableReferencesNonStrictOnlyInputTypes.kt")
                public void testSpecialCallsWithCallableReferencesNonStrictOnlyInputTypes() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/builderInference/specialCallsWithCallableReferencesNonStrictOnlyInputTypes.kt");
                }

                @Test
                @TestMetadata("specialCallsWithCallableReferencesUnrestricted.kt")
                public void testSpecialCallsWithCallableReferencesUnrestricted() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/builderInference/specialCallsWithCallableReferencesUnrestricted.kt");
                }

                @Test
                @TestMetadata("specialCallsWithLambdas.kt")
                public void testSpecialCallsWithLambdas() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/builderInference/specialCallsWithLambdas.kt");
                }

                @Test
                @TestMetadata("withoutAnnotationDisabledFeature.kt")
                public void testWithoutAnnotationDisabledFeature() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/builderInference/withoutAnnotationDisabledFeature.kt");
                }

                @Nested
                @TestMetadata("compiler/testData/diagnostics/tests/inference/builderInference/constraints")
                @TestDataPath("$PROJECT_ROOT")
                public class Constraints {
                    @Test
                    public void testAllFilesPresentInConstraints() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/inference/builderInference/constraints"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                    }

                    @Test
                    @TestMetadata("violating.kt")
                    public void testViolating() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/inference/builderInference/constraints/violating.kt");
                    }
                }

                @Nested
                @TestMetadata("compiler/testData/diagnostics/tests/inference/builderInference/stubTypes")
                @TestDataPath("$PROJECT_ROOT")
                public class StubTypes {
                    @Test
                    public void testAllFilesPresentInStubTypes() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/inference/builderInference/stubTypes"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                    }

                    @Test
                    @TestMetadata("capturedTypes.kt")
                    public void testCapturedTypes() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/inference/builderInference/stubTypes/capturedTypes.kt");
                    }

                    @Test
                    @TestMetadata("commonSuperType.kt")
                    public void testCommonSuperType() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/inference/builderInference/stubTypes/commonSuperType.kt");
                    }

                    @Test
                    @TestMetadata("commonSuperTypeContravariant.kt")
                    public void testCommonSuperTypeContravariant() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/inference/builderInference/stubTypes/commonSuperTypeContravariant.kt");
                    }

                    @Test
                    @TestMetadata("commonSuperTypeCovariant.kt")
                    public void testCommonSuperTypeCovariant() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/inference/builderInference/stubTypes/commonSuperTypeCovariant.kt");
                    }

                    @Test
                    @TestMetadata("commonSuperTypeInvariant.kt")
                    public void testCommonSuperTypeInvariant() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/inference/builderInference/stubTypes/commonSuperTypeInvariant.kt");
                    }

                    @Test
                    @TestMetadata("commonSuperTypeNullable.kt")
                    public void testCommonSuperTypeNullable() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/inference/builderInference/stubTypes/commonSuperTypeNullable.kt");
                    }

                    @Test
                    @TestMetadata("intersect.kt")
                    public void testIntersect() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/inference/builderInference/stubTypes/intersect.kt");
                    }

                    @Test
                    @TestMetadata("memberScope.kt")
                    public void testMemberScope() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/inference/builderInference/stubTypes/memberScope.kt");
                    }

                    @Test
                    @TestMetadata("nullability.kt")
                    public void testNullability() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/inference/builderInference/stubTypes/nullability.kt");
                    }

                    @Test
                    @TestMetadata("renderingStubTypes.kt")
                    public void testRenderingStubTypes() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/inference/builderInference/stubTypes/renderingStubTypes.kt");
                    }
                }
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/inference/capturedTypes")
            @TestDataPath("$PROJECT_ROOT")
            public class CapturedTypes {
                @Test
                public void testAllFilesPresentInCapturedTypes() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/inference/capturedTypes"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("approximateBeforeFixation.kt")
                public void testApproximateBeforeFixation() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/approximateBeforeFixation.kt");
                }

                @Test
                @TestMetadata("approximateContravariantCapturedTypes.kt")
                public void testApproximateContravariantCapturedTypes() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/approximateContravariantCapturedTypes.kt");
                }

                @Test
                @TestMetadata("avoidCreatingUselessCapturedTypes.kt")
                public void testAvoidCreatingUselessCapturedTypes() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/avoidCreatingUselessCapturedTypes.kt");
                }

                @Test
                @TestMetadata("cannotCaptureInProjection.kt")
                public void testCannotCaptureInProjection() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/cannotCaptureInProjection.kt");
                }

                @Test
                @TestMetadata("captureForNullableTypes.kt")
                public void testCaptureForNullableTypes() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/captureForNullableTypes.kt");
                }

                @Test
                @TestMetadata("captureForPlatformTypes.kt")
                public void testCaptureForPlatformTypes() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/captureForPlatformTypes.kt");
                }

                @Test
                @TestMetadata("captureFromNullableTypeVariable.kt")
                public void testCaptureFromNullableTypeVariable() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/captureFromNullableTypeVariable.kt");
                }

                @Test
                @TestMetadata("captureFromSubtyping.kt")
                public void testCaptureFromSubtyping() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/captureFromSubtyping.kt");
                }

                @Test
                @TestMetadata("captureFromTypeParameterUpperBound.kt")
                public void testCaptureFromTypeParameterUpperBound() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/captureFromTypeParameterUpperBound.kt");
                }

                @Test
                @TestMetadata("captureTypeOnlyOnTopLevel.kt")
                public void testCaptureTypeOnlyOnTopLevel() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/captureTypeOnlyOnTopLevel.kt");
                }

                @Test
                @TestMetadata("capturedFlexibleIntersectionTypesWithDifferentBounds.kt")
                public void testCapturedFlexibleIntersectionTypesWithDifferentBounds() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/capturedFlexibleIntersectionTypesWithDifferentBounds.kt");
                }

                @Test
                @TestMetadata("capturedFlexibleIntersectionTypesWithDifferentConstructors.kt")
                public void testCapturedFlexibleIntersectionTypesWithDifferentConstructors() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/capturedFlexibleIntersectionTypesWithDifferentConstructors.kt");
                }

                @Test
                @TestMetadata("capturedType.kt")
                public void testCapturedType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/capturedType.kt");
                }

                @Test
                @TestMetadata("capturedTypeAndApproximation.kt")
                public void testCapturedTypeAndApproximation() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/capturedTypeAndApproximation.kt");
                }

                @Test
                @TestMetadata("capturedTypeSubstitutedIntoOppositeProjection.kt")
                public void testCapturedTypeSubstitutedIntoOppositeProjection() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/capturedTypeSubstitutedIntoOppositeProjection.kt");
                }

                @Test
                @TestMetadata("capturedTypeWithInnerTypealias.kt")
                public void testCapturedTypeWithInnerTypealias() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/capturedTypeWithInnerTypealias.kt");
                }

                @Test
                @TestMetadata("capturedTypeWithTypeVariableSubtyping.kt")
                public void testCapturedTypeWithTypeVariableSubtyping() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/capturedTypeWithTypeVariableSubtyping.kt");
                }

                @Test
                @TestMetadata("capturedTypesSubstitutionIntoAbbreviation.kt")
                public void testCapturedTypesSubstitutionIntoAbbreviation() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/capturedTypesSubstitutionIntoAbbreviation.kt");
                }

                @Test
                @TestMetadata("capturingFromArgumentOfFlexibleType.kt")
                public void testCapturingFromArgumentOfFlexibleType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/capturingFromArgumentOfFlexibleType.kt");
                }

                @Test
                @TestMetadata("dontCheckNewCapturedTypeSpecificChecksForOldOnes.kt")
                public void testDontCheckNewCapturedTypeSpecificChecksForOldOnes() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/dontCheckNewCapturedTypeSpecificChecksForOldOnes.kt");
                }

                @Test
                @TestMetadata("expectedTypeMismatchWithInVariance.kt")
                public void testExpectedTypeMismatchWithInVariance() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/expectedTypeMismatchWithInVariance.kt");
                }

                @Test
                @TestMetadata("invokeCallWithCapturedReceiver.kt")
                public void testInvokeCallWithCapturedReceiver() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/invokeCallWithCapturedReceiver.kt");
                }

                @Test
                @TestMetadata("kt25302.kt")
                public void testKt25302() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/kt25302.kt");
                }

                @Test
                @TestMetadata("kt2570.kt")
                public void testKt2570() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/kt2570.kt");
                }

                @Test
                @TestMetadata("kt2872.kt")
                public void testKt2872() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/kt2872.kt");
                }

                @Test
                @TestMetadata("kt46727.kt")
                public void testKt46727() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/kt46727.kt");
                }

                @Test
                @TestMetadata("kt46727Warnings.kt")
                public void testKt46727Warnings() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/kt46727Warnings.kt");
                }

                @Test
                @TestMetadata("kt49101.kt")
                public void testKt49101() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/kt49101.kt");
                }

                @Test
                @TestMetadata("memberScopeOfCaptured.kt")
                public void testMemberScopeOfCaptured() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/memberScopeOfCaptured.kt");
                }

                @Test
                @TestMetadata("noCaptureTypeErrorForNonTopLevel.kt")
                public void testNoCaptureTypeErrorForNonTopLevel() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/noCaptureTypeErrorForNonTopLevel.kt");
                }

                @Test
                @TestMetadata("notApproximateWhenCopyDescriptors.kt")
                public void testNotApproximateWhenCopyDescriptors() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/notApproximateWhenCopyDescriptors.kt");
                }

                @Test
                @TestMetadata("nullableCaptruredTypeAgainstNullableVariable.kt")
                public void testNullableCaptruredTypeAgainstNullableVariable() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/nullableCaptruredTypeAgainstNullableVariable.kt");
                }

                @Test
                @TestMetadata("nullableCaptruredTypeAgainstNullableVariableWithDisabledComplatibilityFlag.kt")
                public void testNullableCaptruredTypeAgainstNullableVariableWithDisabledComplatibilityFlag() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/nullableCaptruredTypeAgainstNullableVariableWithDisabledComplatibilityFlag.kt");
                }

                @Test
                @TestMetadata("overApproximationForInCaptured.kt")
                public void testOverApproximationForInCaptured() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/overApproximationForInCaptured.kt");
                }

                @Test
                @TestMetadata("overApproximationForOutCaptured.kt")
                public void testOverApproximationForOutCaptured() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/overApproximationForOutCaptured.kt");
                }

                @Test
                @TestMetadata("propagateNullailityOnSupertypesWhenCaptureTypes.kt")
                public void testPropagateNullailityOnSupertypesWhenCaptureTypes() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/propagateNullailityOnSupertypesWhenCaptureTypes.kt");
                }

                @Test
                @TestMetadata("starProjectionRegression.kt")
                public void testStarProjectionRegression() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/starProjectionRegression.kt");
                }

                @Test
                @TestMetadata("substituteCapturedTypesWithTypeVariables.kt")
                public void testSubstituteCapturedTypesWithTypeVariables() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/substituteCapturedTypesWithTypeVariables.kt");
                }

                @Test
                @TestMetadata("topLevelCapturingInsideReturnType.kt")
                public void testTopLevelCapturingInsideReturnType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/capturedTypes/topLevelCapturingInsideReturnType.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/inference/coercionToUnit")
            @TestDataPath("$PROJECT_ROOT")
            public class CoercionToUnit {
                @Test
                public void testAllFilesPresentInCoercionToUnit() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/inference/coercionToUnit"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("coercionToUnitForIfAsLastExpressionInLambda.kt")
                public void testCoercionToUnitForIfAsLastExpressionInLambda() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/coercionToUnit/coercionToUnitForIfAsLastExpressionInLambda.kt");
                }

                @Test
                @TestMetadata("coercionToUnitForLastLambdaInLambda.kt")
                public void testCoercionToUnitForLastLambdaInLambda() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/coercionToUnit/coercionToUnitForLastLambdaInLambda.kt");
                }

                @Test
                @TestMetadata("coercionToUnitReference.kt")
                public void testCoercionToUnitReference() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/coercionToUnit/coercionToUnitReference.kt");
                }

                @Test
                @TestMetadata("coercionToUnitWithNothingType.kt")
                public void testCoercionToUnitWithNothingType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/coercionToUnit/coercionToUnitWithNothingType.kt");
                }

                @Test
                @TestMetadata("coercionWithExpectedType.kt")
                public void testCoercionWithExpectedType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/coercionToUnit/coercionWithExpectedType.kt");
                }

                @Test
                @TestMetadata("coercionWithExpectedTypeAndBound.kt")
                public void testCoercionWithExpectedTypeAndBound() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/coercionToUnit/coercionWithExpectedTypeAndBound.kt");
                }

                @Test
                @TestMetadata("coercionWithExplicitTypeArgument.kt")
                public void testCoercionWithExplicitTypeArgument() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/coercionToUnit/coercionWithExplicitTypeArgument.kt");
                }

                @Test
                @TestMetadata("coercionWithoutExpectedType.kt")
                public void testCoercionWithoutExpectedType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/coercionToUnit/coercionWithoutExpectedType.kt");
                }

                @Test
                @TestMetadata("coerctionToUnitForATypeWithUpperBound.kt")
                public void testCoerctionToUnitForATypeWithUpperBound() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/coercionToUnit/coerctionToUnitForATypeWithUpperBound.kt");
                }

                @Test
                @TestMetadata("coersionWithAnonymousFunctionsAndUnresolved.kt")
                public void testCoersionWithAnonymousFunctionsAndUnresolved() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/coercionToUnit/coersionWithAnonymousFunctionsAndUnresolved.kt");
                }

                @Test
                @TestMetadata("indirectCoercionWithExpectedType.kt")
                public void testIndirectCoercionWithExpectedType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/coercionToUnit/indirectCoercionWithExpectedType.kt");
                }

                @Test
                @TestMetadata("kt30242.kt")
                public void testKt30242() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/coercionToUnit/kt30242.kt");
                }

                @Test
                @TestMetadata("lambdaWithNullableUnitInElvis.kt")
                public void testLambdaWithNullableUnitInElvis() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/coercionToUnit/lambdaWithNullableUnitInElvis.kt");
                }

                @Test
                @TestMetadata("noCoercion.kt")
                public void testNoCoercion() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/coercionToUnit/noCoercion.kt");
                }

                @Test
                @TestMetadata("nonPropagationOfCoercionToUnitInsideNestedLambda.kt")
                public void testNonPropagationOfCoercionToUnitInsideNestedLambda() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/coercionToUnit/nonPropagationOfCoercionToUnitInsideNestedLambda.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/inference/commonSystem")
            @TestDataPath("$PROJECT_ROOT")
            public class CommonSystem {
                @Test
                public void testAllFilesPresentInCommonSystem() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/inference/commonSystem"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("boundOnNullableVariable.kt")
                public void testBoundOnNullableVariable() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/commonSystem/boundOnNullableVariable.kt");
                }

                @Test
                @TestMetadata("castToSubtype.kt")
                public void testCastToSubtype() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/commonSystem/castToSubtype.kt");
                }

                @Test
                @TestMetadata("cstFromNullableChildAndNonParameterizedType.kt")
                public void testCstFromNullableChildAndNonParameterizedType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/commonSystem/cstFromNullableChildAndNonParameterizedType.kt");
                }

                @Test
                @TestMetadata("cstWithTypeContainingNonFixedVariable.kt")
                public void testCstWithTypeContainingNonFixedVariable() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/commonSystem/cstWithTypeContainingNonFixedVariable.kt");
                }

                @Test
                @TestMetadata("dontCaptureTypeVariable.kt")
                public void testDontCaptureTypeVariable() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/commonSystem/dontCaptureTypeVariable.kt");
                }

                @Test
                @TestMetadata("exactOnElvis.kt")
                public void testExactOnElvis() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/commonSystem/exactOnElvis.kt");
                }

                @Test
                @TestMetadata("fixVariablesInRightOrder.kt")
                public void testFixVariablesInRightOrder() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/commonSystem/fixVariablesInRightOrder.kt");
                }

                @Test
                @TestMetadata("genericCandidateInGenericClass.kt")
                public void testGenericCandidateInGenericClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/commonSystem/genericCandidateInGenericClass.kt");
                }

                @Test
                @TestMetadata("iltInsideSeveralCalls.kt")
                public void testIltInsideSeveralCalls() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/commonSystem/iltInsideSeveralCalls.kt");
                }

                @Test
                @TestMetadata("inferenceWithUpperBoundsInLambda.kt")
                public void testInferenceWithUpperBoundsInLambda() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/commonSystem/inferenceWithUpperBoundsInLambda.kt");
                }

                @Test
                @TestMetadata("kt30300.kt")
                public void testKt30300() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/commonSystem/kt30300.kt");
                }

                @Test
                @TestMetadata("kt31969.kt")
                public void testKt31969() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/commonSystem/kt31969.kt");
                }

                @Test
                @TestMetadata("kt32818.kt")
                public void testKt32818() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/commonSystem/kt32818.kt");
                }

                @Test
                @TestMetadata("kt33197.kt")
                public void testKt33197() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/commonSystem/kt33197.kt");
                }

                @Test
                @TestMetadata("kt3372toCollection.kt")
                public void testKt3372toCollection() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/commonSystem/kt3372toCollection.kt");
                }

                @Test
                @TestMetadata("lessSpecificTypeForArgumentCallWithExactAnnotation.kt")
                public void testLessSpecificTypeForArgumentCallWithExactAnnotation() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/commonSystem/lessSpecificTypeForArgumentCallWithExactAnnotation.kt");
                }

                @Test
                @TestMetadata("lessSpecificTypeForArgumentCallWithExactAnnotation_ni.kt")
                public void testLessSpecificTypeForArgumentCallWithExactAnnotation_ni() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/commonSystem/lessSpecificTypeForArgumentCallWithExactAnnotation_ni.kt");
                }

                @Test
                @TestMetadata("manyArgumentsForVararg.kt")
                public void testManyArgumentsForVararg() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/commonSystem/manyArgumentsForVararg.kt");
                }

                @Test
                @TestMetadata("nestedLambdas.kt")
                public void testNestedLambdas() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/commonSystem/nestedLambdas.kt");
                }

                @Test
                @TestMetadata("nonFixedVariableFromBothBranches.kt")
                public void testNonFixedVariableFromBothBranches() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/commonSystem/nonFixedVariableFromBothBranches.kt");
                }

                @Test
                @TestMetadata("nonFixedVariableInsideFlexibleType.kt")
                public void testNonFixedVariableInsideFlexibleType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/commonSystem/nonFixedVariableInsideFlexibleType.kt");
                }

                @Test
                @TestMetadata("outProjectedTypeToOutProjected.kt")
                public void testOutProjectedTypeToOutProjected() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/commonSystem/outProjectedTypeToOutProjected.kt");
                }

                @Test
                @TestMetadata("postponedCompletionWithExactAnnotation.kt")
                public void testPostponedCompletionWithExactAnnotation() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/commonSystem/postponedCompletionWithExactAnnotation.kt");
                }

                @Test
                @TestMetadata("postponedCompletionWithExactAnnotation_ni.kt")
                public void testPostponedCompletionWithExactAnnotation_ni() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/commonSystem/postponedCompletionWithExactAnnotation_ni.kt");
                }

                @Test
                @TestMetadata("selectFromTwoIncompatibleTypes.kt")
                public void testSelectFromTwoIncompatibleTypes() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/commonSystem/selectFromTwoIncompatibleTypes.kt");
                }

                @Test
                @TestMetadata("selectIntegerValueTypeFromIf.kt")
                public void testSelectIntegerValueTypeFromIf() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/commonSystem/selectIntegerValueTypeFromIf.kt");
                }

                @Test
                @TestMetadata("theSameFunctionInArgs.kt")
                public void testTheSameFunctionInArgs() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/commonSystem/theSameFunctionInArgs.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/inference/completion")
            @TestDataPath("$PROJECT_ROOT")
            public class Completion {
                @Test
                public void testAllFilesPresentInCompletion() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/inference/completion"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("anonymousFunction.kt")
                public void testAnonymousFunction() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/completion/anonymousFunction.kt");
                }

                @Test
                @TestMetadata("basic.kt")
                public void testBasic() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/completion/basic.kt");
                }

                @Test
                @TestMetadata("definitelyNotNullType.kt")
                public void testDefinitelyNotNullType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/completion/definitelyNotNullType.kt");
                }

                @Test
                @TestMetadata("equalityConstraintUpstairs.kt")
                public void testEqualityConstraintUpstairs() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/completion/equalityConstraintUpstairs.kt");
                }

                @Test
                @TestMetadata("errorAfterCompletion.kt")
                public void testErrorAfterCompletion() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/completion/errorAfterCompletion.kt");
                }

                @Test
                @TestMetadata("flexibleType.kt")
                public void testFlexibleType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/completion/flexibleType.kt");
                }

                @Test
                @TestMetadata("inferLabeledElementTypeForLambdaInReturnInCatch.kt")
                public void testInferLabeledElementTypeForLambdaInReturnInCatch() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/completion/inferLabeledElementTypeForLambdaInReturnInCatch.kt");
                }

                @Test
                @TestMetadata("intersectionType.kt")
                public void testIntersectionType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/completion/intersectionType.kt");
                }

                @Test
                @TestMetadata("kt33166.kt")
                public void testKt33166() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/completion/kt33166.kt");
                }

                @Test
                @TestMetadata("kt36233.kt")
                public void testKt36233() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/completion/kt36233.kt");
                }

                @Test
                @TestMetadata("lambdaWithVariableAndNothing.kt")
                public void testLambdaWithVariableAndNothing() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/completion/lambdaWithVariableAndNothing.kt");
                }

                @Test
                @TestMetadata("nestedVariance.kt")
                public void testNestedVariance() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/completion/nestedVariance.kt");
                }

                @Test
                @TestMetadata("nothingFromNestedCall.kt")
                public void testNothingFromNestedCall() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/completion/nothingFromNestedCall.kt");
                }

                @Test
                @TestMetadata("partialForIlt.kt")
                public void testPartialForIlt() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/completion/partialForIlt.kt");
                }

                @Test
                @TestMetadata("partialForIltWithNothing.kt")
                public void testPartialForIltWithNothing() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/completion/partialForIltWithNothing.kt");
                }

                @Test
                @TestMetadata("transitiveConstraint.kt")
                public void testTransitiveConstraint() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/completion/transitiveConstraint.kt");
                }

                @Test
                @TestMetadata("withExact.kt")
                public void testWithExact() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/completion/withExact.kt");
                }

                @Nested
                @TestMetadata("compiler/testData/diagnostics/tests/inference/completion/postponedArgumentsAnalysis")
                @TestDataPath("$PROJECT_ROOT")
                public class PostponedArgumentsAnalysis {
                    @Test
                    public void testAllFilesPresentInPostponedArgumentsAnalysis() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/inference/completion/postponedArgumentsAnalysis"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                    }

                    @Test
                    @TestMetadata("basic.kt")
                    public void testBasic() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/inference/completion/postponedArgumentsAnalysis/basic.kt");
                    }

                    @Test
                    @TestMetadata("callableReferenceLambdaCombinationInsideCall.kt")
                    public void testCallableReferenceLambdaCombinationInsideCall() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/inference/completion/postponedArgumentsAnalysis/callableReferenceLambdaCombinationInsideCall.kt");
                    }

                    @Test
                    @TestMetadata("callableReferences.kt")
                    public void testCallableReferences() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/inference/completion/postponedArgumentsAnalysis/callableReferences.kt");
                    }

                    @Test
                    @TestMetadata("fixingVariableDuringAddingConstraintForFirstPosponedArgument.kt")
                    public void testFixingVariableDuringAddingConstraintForFirstPosponedArgument() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/inference/completion/postponedArgumentsAnalysis/fixingVariableDuringAddingConstraintForFirstPosponedArgument.kt");
                    }

                    @Test
                    @TestMetadata("lackOfDeepIncorporation.kt")
                    public void testLackOfDeepIncorporation() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/inference/completion/postponedArgumentsAnalysis/lackOfDeepIncorporation.kt");
                    }

                    @Test
                    @TestMetadata("lambdasInTryCatch.kt")
                    public void testLambdasInTryCatch() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/inference/completion/postponedArgumentsAnalysis/lambdasInTryCatch.kt");
                    }

                    @Test
                    @TestMetadata("notInferableParameterOfAnonymousFunction.kt")
                    public void testNotInferableParameterOfAnonymousFunction() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/inference/completion/postponedArgumentsAnalysis/notInferableParameterOfAnonymousFunction.kt");
                    }

                    @Test
                    @TestMetadata("takingExtensibilityFromDeclarationOfAnonymousFunction.kt")
                    public void testTakingExtensibilityFromDeclarationOfAnonymousFunction() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/inference/completion/postponedArgumentsAnalysis/takingExtensibilityFromDeclarationOfAnonymousFunction.kt");
                    }

                    @Test
                    @TestMetadata("wrongVariableFixationOrder.kt")
                    public void testWrongVariableFixationOrder() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/inference/completion/postponedArgumentsAnalysis/wrongVariableFixationOrder.kt");
                    }

                    @Test
                    @TestMetadata("wrongVariableFixationOrder2.kt")
                    public void testWrongVariableFixationOrder2() throws Exception {
                        runTest("compiler/testData/diagnostics/tests/inference/completion/postponedArgumentsAnalysis/wrongVariableFixationOrder2.kt");
                    }
                }
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/inference/constraints")
            @TestDataPath("$PROJECT_ROOT")
            public class Constraints {
                @Test
                public void testAllFilesPresentInConstraints() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/inference/constraints"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("approximationWithDefNotNullInInvPositionDuringInference.kt")
                public void testApproximationWithDefNotNullInInvPositionDuringInference() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/constraints/approximationWithDefNotNullInInvPositionDuringInference.kt");
                }

                @Test
                @TestMetadata("complexDependencyWihtoutProperConstraints.kt")
                public void testComplexDependencyWihtoutProperConstraints() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/constraints/complexDependencyWihtoutProperConstraints.kt");
                }

                @Test
                @TestMetadata("constraintFromVariantTypeWithNestedProjection.kt")
                public void testConstraintFromVariantTypeWithNestedProjection() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/constraints/constraintFromVariantTypeWithNestedProjection.kt");
                }

                @Test
                @TestMetadata("constraintOnFunctionLiteral.kt")
                public void testConstraintOnFunctionLiteral() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/constraints/constraintOnFunctionLiteral.kt");
                }

                @Test
                @TestMetadata("definitelyNotNullTypeInArguments.kt")
                public void testDefinitelyNotNullTypeInArguments() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/constraints/definitelyNotNullTypeInArguments.kt");
                }

                @Test
                @TestMetadata("definitelyNotNullTypeInReturnPosition.kt")
                public void testDefinitelyNotNullTypeInReturnPosition() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/constraints/definitelyNotNullTypeInReturnPosition.kt");
                }

                @Test
                @TestMetadata("definitelyNotNullTypeInvariantPosition.kt")
                public void testDefinitelyNotNullTypeInvariantPosition() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/constraints/definitelyNotNullTypeInvariantPosition.kt");
                }

                @Test
                @TestMetadata("earlyCompletionForCalls.kt")
                public void testEarlyCompletionForCalls() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/constraints/earlyCompletionForCalls.kt");
                }

                @Test
                @TestMetadata("equalityConstraintOnNullableType.kt")
                public void testEqualityConstraintOnNullableType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/constraints/equalityConstraintOnNullableType.kt");
                }

                @Test
                @TestMetadata("errorUpperBoundConstraint.kt")
                public void testErrorUpperBoundConstraint() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/constraints/errorUpperBoundConstraint.kt");
                }

                @Test
                @TestMetadata("fixTypeVariableWithNothingConstraintEarlierThanComplexVariable.kt")
                public void testFixTypeVariableWithNothingConstraintEarlierThanComplexVariable() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/constraints/fixTypeVariableWithNothingConstraintEarlierThanComplexVariable.kt");
                }

                @Test
                @TestMetadata("ignoreConstraintFromImplicitInNothing.kt")
                public void testIgnoreConstraintFromImplicitInNothing() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/constraints/ignoreConstraintFromImplicitInNothing.kt");
                }

                @Test
                @TestMetadata("inferTypeFromCapturedStarProjection.kt")
                public void testInferTypeFromCapturedStarProjection() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/constraints/inferTypeFromCapturedStarProjection.kt");
                }

                @Test
                @TestMetadata("kt6320.kt")
                public void testKt6320() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/constraints/kt6320.kt");
                }

                @Test
                @TestMetadata("kt7351ConstraintFromUnitExpectedType.kt")
                public void testKt7351ConstraintFromUnitExpectedType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/constraints/kt7351ConstraintFromUnitExpectedType.kt");
                }

                @Test
                @TestMetadata("kt7433.kt")
                public void testKt7433() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/constraints/kt7433.kt");
                }

                @Test
                @TestMetadata("kt8879.kt")
                public void testKt8879() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/constraints/kt8879.kt");
                }

                @Test
                @TestMetadata("manyConstraintsDueToFlexibleRawTypes.kt")
                public void testManyConstraintsDueToFlexibleRawTypes() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/constraints/manyConstraintsDueToFlexibleRawTypes.kt");
                }

                @Test
                @TestMetadata("manyConstraintsDueToRecursiveFlexibleTypesWithWildcards.kt")
                public void testManyConstraintsDueToRecursiveFlexibleTypesWithWildcards() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/constraints/manyConstraintsDueToRecursiveFlexibleTypesWithWildcards.kt");
                }

                @Test
                @TestMetadata("notNullConstraintOnNullableType.kt")
                public void testNotNullConstraintOnNullableType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/constraints/notNullConstraintOnNullableType.kt");
                }

                @Test
                @TestMetadata("operationsOnIntegerValueTypes.kt")
                public void testOperationsOnIntegerValueTypes() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/constraints/operationsOnIntegerValueTypes.kt");
                }

                @Test
                @TestMetadata("recursiveJavaTypeWithStarProjection.kt")
                public void testRecursiveJavaTypeWithStarProjection() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/constraints/recursiveJavaTypeWithStarProjection.kt");
                }

                @Test
                @TestMetadata("remainConstraintContainingTypeWithoutProjection.kt")
                public void testRemainConstraintContainingTypeWithoutProjection() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/constraints/remainConstraintContainingTypeWithoutProjection.kt");
                }

                @Test
                @TestMetadata("returnLambdaFromLambda.kt")
                public void testReturnLambdaFromLambda() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/constraints/returnLambdaFromLambda.kt");
                }

                @Test
                @TestMetadata("subtypeConstraintOnNullableType.kt")
                public void testSubtypeConstraintOnNullableType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/constraints/subtypeConstraintOnNullableType.kt");
                }

                @Test
                @TestMetadata("supertypeConstraintOnNullableType.kt")
                public void testSupertypeConstraintOnNullableType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/constraints/supertypeConstraintOnNullableType.kt");
                }

                @Test
                @TestMetadata("wrongApproximationWithDefNotNullTypesAndDelegates.kt")
                public void testWrongApproximationWithDefNotNullTypesAndDelegates() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/constraints/wrongApproximationWithDefNotNullTypesAndDelegates.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes")
            @TestDataPath("$PROJECT_ROOT")
            public class EmptyIntersectionTypes {
                @Test
                public void testAllFilesPresentInEmptyIntersectionTypes() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("compatibilityResolveWhenVariableHasComplexIntersectionType.kt")
                public void testCompatibilityResolveWhenVariableHasComplexIntersectionType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/compatibilityResolveWhenVariableHasComplexIntersectionType.kt");
                }

                @Test
                @TestMetadata("contravariance.kt")
                public void testContravariance() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/contravariance.kt");
                }

                @Test
                @TestMetadata("covariance.kt")
                public void testCovariance() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/covariance.kt");
                }

                @Test
                @TestMetadata("kt45461.kt")
                public void testKt45461() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/kt45461.kt");
                }

                @Test
                @TestMetadata("kt45461_10.kt")
                public void testKt45461_10() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/kt45461_10.kt");
                }

                @Test
                @TestMetadata("kt45461_11.kt")
                public void testKt45461_11() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/kt45461_11.kt");
                }

                @Test
                @TestMetadata("kt45461_12.kt")
                public void testKt45461_12() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/kt45461_12.kt");
                }

                @Test
                @TestMetadata("kt45461_13.kt")
                public void testKt45461_13() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/kt45461_13.kt");
                }

                @Test
                @TestMetadata("kt45461_14.kt")
                public void testKt45461_14() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/kt45461_14.kt");
                }

                @Test
                @TestMetadata("kt45461_15.kt")
                public void testKt45461_15() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/kt45461_15.kt");
                }

                @Test
                @TestMetadata("kt45461_16.kt")
                public void testKt45461_16() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/kt45461_16.kt");
                }

                @Test
                @TestMetadata("kt45461_17.kt")
                public void testKt45461_17() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/kt45461_17.kt");
                }

                @Test
                @TestMetadata("kt45461_18.kt")
                public void testKt45461_18() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/kt45461_18.kt");
                }

                @Test
                @TestMetadata("kt45461_19.kt")
                public void testKt45461_19() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/kt45461_19.kt");
                }

                @Test
                @TestMetadata("kt45461_2.kt")
                public void testKt45461_2() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/kt45461_2.kt");
                }

                @Test
                @TestMetadata("kt45461_20.kt")
                public void testKt45461_20() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/kt45461_20.kt");
                }

                @Test
                @TestMetadata("kt45461_21.kt")
                public void testKt45461_21() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/kt45461_21.kt");
                }

                @Test
                @TestMetadata("kt45461_22.kt")
                public void testKt45461_22() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/kt45461_22.kt");
                }

                @Test
                @TestMetadata("kt45461_23.kt")
                public void testKt45461_23() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/kt45461_23.kt");
                }

                @Test
                @TestMetadata("kt45461_24.kt")
                public void testKt45461_24() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/kt45461_24.kt");
                }

                @Test
                @TestMetadata("kt45461_25.kt")
                public void testKt45461_25() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/kt45461_25.kt");
                }

                @Test
                @TestMetadata("kt45461_26.kt")
                public void testKt45461_26() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/kt45461_26.kt");
                }

                @Test
                @TestMetadata("kt45461_27.kt")
                public void testKt45461_27() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/kt45461_27.kt");
                }

                @Test
                @TestMetadata("kt45461_28.kt")
                public void testKt45461_28() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/kt45461_28.kt");
                }

                @Test
                @TestMetadata("kt45461_29.kt")
                public void testKt45461_29() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/kt45461_29.kt");
                }

                @Test
                @TestMetadata("kt45461_3.kt")
                public void testKt45461_3() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/kt45461_3.kt");
                }

                @Test
                @TestMetadata("kt45461_30.kt")
                public void testKt45461_30() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/kt45461_30.kt");
                }

                @Test
                @TestMetadata("kt45461_31.kt")
                public void testKt45461_31() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/kt45461_31.kt");
                }

                @Test
                @TestMetadata("kt45461_32.kt")
                public void testKt45461_32() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/kt45461_32.kt");
                }

                @Test
                @TestMetadata("kt45461_33.kt")
                public void testKt45461_33() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/kt45461_33.kt");
                }

                @Test
                @TestMetadata("kt45461_34.kt")
                public void testKt45461_34() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/kt45461_34.kt");
                }

                @Test
                @TestMetadata("kt45461_35.kt")
                public void testKt45461_35() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/kt45461_35.kt");
                }

                @Test
                @TestMetadata("kt45461_35_Enabled.kt")
                public void testKt45461_35_Enabled() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/kt45461_35_Enabled.kt");
                }

                @Test
                @TestMetadata("kt45461_4.kt")
                public void testKt45461_4() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/kt45461_4.kt");
                }

                @Test
                @TestMetadata("kt45461_5.kt")
                public void testKt45461_5() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/kt45461_5.kt");
                }

                @Test
                @TestMetadata("kt45461_6.kt")
                public void testKt45461_6() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/kt45461_6.kt");
                }

                @Test
                @TestMetadata("kt45461_7.kt")
                public void testKt45461_7() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/kt45461_7.kt");
                }

                @Test
                @TestMetadata("kt45461_8.kt")
                public void testKt45461_8() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/kt45461_8.kt");
                }

                @Test
                @TestMetadata("kt45461_9.kt")
                public void testKt45461_9() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/kt45461_9.kt");
                }

                @Test
                @TestMetadata("kt48765.kt")
                public void testKt48765() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/kt48765.kt");
                }

                @Test
                @TestMetadata("kt48935.kt")
                public void testKt48935() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/kt48935.kt");
                }

                @Test
                @TestMetadata("kt48935_2.kt")
                public void testKt48935_2() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/kt48935_2.kt");
                }

                @Test
                @TestMetadata("kt48935_3.kt")
                public void testKt48935_3() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/kt48935_3.kt");
                }

                @Test
                @TestMetadata("kt48935_4.kt")
                public void testKt48935_4() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/kt48935_4.kt");
                }

                @Test
                @TestMetadata("kt48935_5.kt")
                public void testKt48935_5() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/kt48935_5.kt");
                }

                @Test
                @TestMetadata("kt48935_6.kt")
                public void testKt48935_6() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/kt48935_6.kt");
                }

                @Test
                @TestMetadata("kt48987.kt")
                public void testKt48987() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/kt48987.kt");
                }

                @Test
                @TestMetadata("kt49661.kt")
                public void testKt49661() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/kt49661.kt");
                }

                @Test
                @TestMetadata("kt51016.kt")
                public void testKt51016() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/kt51016.kt");
                }

                @Test
                @TestMetadata("kt52364.kt")
                public void testKt52364() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/kt52364.kt");
                }

                @Test
                @TestMetadata("nullableEmptyIntersection.kt")
                public void testNullableEmptyIntersection() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/nullableEmptyIntersection.kt");
                }

                @Test
                @TestMetadata("recursiveTypeParameters.kt")
                public void testRecursiveTypeParameters() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/recursiveTypeParameters.kt");
                }

                @Test
                @TestMetadata("selectFromCovariantAndContravariantTypes.kt")
                public void testSelectFromCovariantAndContravariantTypes() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/selectFromCovariantAndContravariantTypes.kt");
                }

                @Test
                @TestMetadata("substitutingSuperTypes.kt")
                public void testSubstitutingSuperTypes() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/substitutingSuperTypes.kt");
                }

                @Test
                @TestMetadata("substitutingSuperTypes2.kt")
                public void testSubstitutingSuperTypes2() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/emptyIntersectionTypes/substitutingSuperTypes2.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/inference/nestedCalls")
            @TestDataPath("$PROJECT_ROOT")
            public class NestedCalls {
                @Test
                public void testAllFilesPresentInNestedCalls() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/inference/nestedCalls"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("arrayAccess.kt")
                public void testArrayAccess() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/nestedCalls/arrayAccess.kt");
                }

                @Test
                @TestMetadata("binaryExpressions.kt")
                public void testBinaryExpressions() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/nestedCalls/binaryExpressions.kt");
                }

                @Test
                @TestMetadata("checkTypesForQualifiedProperties.kt")
                public void testCheckTypesForQualifiedProperties() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/nestedCalls/checkTypesForQualifiedProperties.kt");
                }

                @Test
                @TestMetadata("completeNestedCallsForArraySetExpression.kt")
                public void testCompleteNestedCallsForArraySetExpression() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/nestedCalls/completeNestedCallsForArraySetExpression.kt");
                }

                @Test
                @TestMetadata("completeNestedCallsInference.kt")
                public void testCompleteNestedCallsInference() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/nestedCalls/completeNestedCallsInference.kt");
                }

                @Test
                @TestMetadata("completeNestedForVariableAsFunctionCall.kt")
                public void testCompleteNestedForVariableAsFunctionCall() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/nestedCalls/completeNestedForVariableAsFunctionCall.kt");
                }

                @Test
                @TestMetadata("externalTypeParameter.kt")
                public void testExternalTypeParameter() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/nestedCalls/externalTypeParameter.kt");
                }

                @Test
                @TestMetadata("inferenceForNestedBinaryCall.kt")
                public void testInferenceForNestedBinaryCall() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/nestedCalls/inferenceForNestedBinaryCall.kt");
                }

                @Test
                @TestMetadata("kt3395.kt")
                public void testKt3395() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/nestedCalls/kt3395.kt");
                }

                @Test
                @TestMetadata("kt3461checkTypes.kt")
                public void testKt3461checkTypes() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/nestedCalls/kt3461checkTypes.kt");
                }

                @Test
                @TestMetadata("makeNullableIfSafeCall.kt")
                public void testMakeNullableIfSafeCall() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/nestedCalls/makeNullableIfSafeCall.kt");
                }

                @Test
                @TestMetadata("nontrivialCallExpression.kt")
                public void testNontrivialCallExpression() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/nestedCalls/nontrivialCallExpression.kt");
                }

                @Test
                @TestMetadata("preferArgumentToNullability.kt")
                public void testPreferArgumentToNullability() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/nestedCalls/preferArgumentToNullability.kt");
                }

                @Test
                @TestMetadata("preferNothingToBound.kt")
                public void testPreferNothingToBound() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/nestedCalls/preferNothingToBound.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/inference/nothingType")
            @TestDataPath("$PROJECT_ROOT")
            public class NothingType {
                @Test
                public void testAllFilesPresentInNothingType() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/inference/nothingType"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("complexDependancyOnVariableWithTrivialConstraint.kt")
                public void testComplexDependancyOnVariableWithTrivialConstraint() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/nothingType/complexDependancyOnVariableWithTrivialConstraint.kt");
                }

                @Test
                @TestMetadata("discriminateNothingForReifiedParameter.kt")
                public void testDiscriminateNothingForReifiedParameter() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/nothingType/discriminateNothingForReifiedParameter.kt");
                }

                @Test
                @TestMetadata("discriminatedNothingAndSmartCast.kt")
                public void testDiscriminatedNothingAndSmartCast() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/nothingType/discriminatedNothingAndSmartCast.kt");
                }

                @Test
                @TestMetadata("discriminatedNothingInsideComplexNestedCall.kt")
                public void testDiscriminatedNothingInsideComplexNestedCall() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/nothingType/discriminatedNothingInsideComplexNestedCall.kt");
                }

                @Test
                @TestMetadata("generateConstraintWithInnerNothingType.kt")
                public void testGenerateConstraintWithInnerNothingType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/nothingType/generateConstraintWithInnerNothingType.kt");
                }

                @Test
                @TestMetadata("genericOverride.kt")
                public void testGenericOverride() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/nothingType/genericOverride.kt");
                }

                @Test
                @TestMetadata("implicitInferenceTToFlexibleNothing.kt")
                public void testImplicitInferenceTToFlexibleNothing() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/nothingType/implicitInferenceTToFlexibleNothing.kt");
                }

                @Test
                @TestMetadata("implicitNothingConstraintFromReturn.kt")
                public void testImplicitNothingConstraintFromReturn() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/nothingType/implicitNothingConstraintFromReturn.kt");
                }

                @Test
                @TestMetadata("inferArgumentToNothingFromNullConstant.kt")
                public void testInferArgumentToNothingFromNullConstant() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/nothingType/inferArgumentToNothingFromNullConstant.kt");
                }

                @Test
                @TestMetadata("inferenceWithRecursiveGenericsAndNothing.kt")
                public void testInferenceWithRecursiveGenericsAndNothing() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/nothingType/inferenceWithRecursiveGenericsAndNothing.kt");
                }

                @Test
                @TestMetadata("kt24490.kt")
                public void testKt24490() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/nothingType/kt24490.kt");
                }

                @Test
                @TestMetadata("kt32051.kt")
                public void testKt32051() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/nothingType/kt32051.kt");
                }

                @Test
                @TestMetadata("kt32081.kt")
                public void testKt32081() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/nothingType/kt32081.kt");
                }

                @Test
                @TestMetadata("kt32207.kt")
                public void testKt32207() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/nothingType/kt32207.kt");
                }

                @Test
                @TestMetadata("kt32388.kt")
                public void testKt32388() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/nothingType/kt32388.kt");
                }

                @Test
                @TestMetadata("kt34335.kt")
                public void testKt34335() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/nothingType/kt34335.kt");
                }

                @Test
                @TestMetadata("lambdaNothingAndExpectedType.kt")
                public void testLambdaNothingAndExpectedType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/nothingType/lambdaNothingAndExpectedType.kt");
                }

                @Test
                @TestMetadata("nestedLambdaInferenceWithIncorporationOfVariables.kt")
                public void testNestedLambdaInferenceWithIncorporationOfVariables() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/nothingType/nestedLambdaInferenceWithIncorporationOfVariables.kt");
                }

                @Test
                @TestMetadata("notEnoughInformationAndNothing.kt")
                public void testNotEnoughInformationAndNothing() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/nothingType/notEnoughInformationAndNothing.kt");
                }

                @Test
                @TestMetadata("notEnoughInformationFromNullabilityConstraint.kt")
                public void testNotEnoughInformationFromNullabilityConstraint() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/nothingType/notEnoughInformationFromNullabilityConstraint.kt");
                }

                @Test
                @TestMetadata("nothingWithCallableReference.kt")
                public void testNothingWithCallableReference() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/nothingType/nothingWithCallableReference.kt");
                }

                @Test
                @TestMetadata("nullableExpectedTypeFromVariable.kt")
                public void testNullableExpectedTypeFromVariable() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/nothingType/nullableExpectedTypeFromVariable.kt");
                }

                @Test
                @TestMetadata("platformNothingAsUsefulConstraint.kt")
                public void testPlatformNothingAsUsefulConstraint() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/nothingType/platformNothingAsUsefulConstraint.kt");
                }

                @Test
                @TestMetadata("reifiedParameterWithRecursiveBound.kt")
                public void testReifiedParameterWithRecursiveBound() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/nothingType/reifiedParameterWithRecursiveBound.kt");
                }

                @Test
                @TestMetadata("reportImplicitNothingOnlyForOwnTypeParameters.kt")
                public void testReportImplicitNothingOnlyForOwnTypeParameters() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/nothingType/reportImplicitNothingOnlyForOwnTypeParameters.kt");
                }

                @Test
                @TestMetadata("specialCallWithMaterializeAndExpectedType.kt")
                public void testSpecialCallWithMaterializeAndExpectedType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/nothingType/specialCallWithMaterializeAndExpectedType.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/inference/publicApproximation")
            @TestDataPath("$PROJECT_ROOT")
            public class PublicApproximation {
                @Test
                public void testAllFilesPresentInPublicApproximation() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/inference/publicApproximation"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("approximatedIntersectionMorePreciseThanBound.kt")
                public void testApproximatedIntersectionMorePreciseThanBound() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/publicApproximation/approximatedIntersectionMorePreciseThanBound.kt");
                }

                @Test
                @TestMetadata("chainedLambdas.kt")
                public void testChainedLambdas() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/publicApproximation/chainedLambdas.kt");
                }

                @Test
                @TestMetadata("declarationTypes.kt")
                public void testDeclarationTypes() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/publicApproximation/declarationTypes.kt");
                }

                @Test
                @TestMetadata("intersectionAfterSmartCastInLambdaReturn.kt")
                public void testIntersectionAfterSmartCastInLambdaReturn() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/publicApproximation/intersectionAfterSmartCastInLambdaReturn.kt");
                }

                @Test
                @TestMetadata("intersectionAlternative.kt")
                public void testIntersectionAlternative() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/publicApproximation/intersectionAlternative.kt");
                }

                @Test
                @TestMetadata("intersectionLocations.kt")
                public void testIntersectionLocations() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/publicApproximation/intersectionLocations.kt");
                }

                @Test
                @TestMetadata("lambdaReturnArgumentCall.kt")
                public void testLambdaReturnArgumentCall() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/publicApproximation/lambdaReturnArgumentCall.kt");
                }

                @Test
                @TestMetadata("lambdaReturnTypeApproximation.kt")
                public void testLambdaReturnTypeApproximation() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/publicApproximation/lambdaReturnTypeApproximation.kt");
                }

                @Test
                @TestMetadata("nonTrivialVariance.kt")
                public void testNonTrivialVariance() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/publicApproximation/nonTrivialVariance.kt");
                }

                @Test
                @TestMetadata("parameterInBound.kt")
                public void testParameterInBound() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/publicApproximation/parameterInBound.kt");
                }

                @Test
                @TestMetadata("projections.kt")
                public void testProjections() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/publicApproximation/projections.kt");
                }

                @Test
                @TestMetadata("smartCastInLambdaReturnAfterIntersection.kt")
                public void testSmartCastInLambdaReturnAfterIntersection() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/publicApproximation/smartCastInLambdaReturnAfterIntersection.kt");
                }

                @Test
                @TestMetadata("twoIntersections.kt")
                public void testTwoIntersections() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/publicApproximation/twoIntersections.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/inference/recursiveCalls")
            @TestDataPath("$PROJECT_ROOT")
            public class RecursiveCalls {
                @Test
                public void testAllFilesPresentInRecursiveCalls() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/inference/recursiveCalls"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("kt23531.kt")
                public void testKt23531() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/recursiveCalls/kt23531.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/inference/recursiveLocalFuns")
            @TestDataPath("$PROJECT_ROOT")
            public class RecursiveLocalFuns {
                @Test
                public void testAllFilesPresentInRecursiveLocalFuns() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/inference/recursiveLocalFuns"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("localFactorial.kt")
                public void testLocalFactorial() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/recursiveLocalFuns/localFactorial.kt");
                }

                @Test
                @TestMetadata("recursiveFun.kt")
                public void testRecursiveFun() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/recursiveLocalFuns/recursiveFun.kt");
                }

                @Test
                @TestMetadata("recursiveLambda.kt")
                public void testRecursiveLambda() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/recursiveLocalFuns/recursiveLambda.kt");
                }

                @Test
                @TestMetadata("selfCall.kt")
                public void testSelfCall() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/recursiveLocalFuns/selfCall.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/inference/recursiveTypes")
            @TestDataPath("$PROJECT_ROOT")
            public class RecursiveTypes {
                @Test
                public void testAllFilesPresentInRecursiveTypes() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/inference/recursiveTypes"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("multirecursion.kt")
                public void testMultirecursion() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/recursiveTypes/multirecursion.kt");
                }

                @Test
                @TestMetadata("recursiveInIn.kt")
                public void testRecursiveInIn() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/recursiveTypes/recursiveInIn.kt");
                }

                @Test
                @TestMetadata("recursiveInInv.kt")
                public void testRecursiveInInv() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/recursiveTypes/recursiveInInv.kt");
                }

                @Test
                @TestMetadata("recursiveInOut.kt")
                public void testRecursiveInOut() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/recursiveTypes/recursiveInOut.kt");
                }

                @Test
                @TestMetadata("recursiveInvIn.kt")
                public void testRecursiveInvIn() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/recursiveTypes/recursiveInvIn.kt");
                }

                @Test
                @TestMetadata("recursiveInvOut.kt")
                public void testRecursiveInvOut() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/recursiveTypes/recursiveInvOut.kt");
                }

                @Test
                @TestMetadata("recursiveOutIn.kt")
                public void testRecursiveOutIn() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/recursiveTypes/recursiveOutIn.kt");
                }

                @Test
                @TestMetadata("recursiveOutInv.kt")
                public void testRecursiveOutInv() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/recursiveTypes/recursiveOutInv.kt");
                }

                @Test
                @TestMetadata("recursiveOutOut.kt")
                public void testRecursiveOutOut() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/recursiveTypes/recursiveOutOut.kt");
                }

                @Test
                @TestMetadata("recursiveTypeWithNonStarResult.kt")
                public void testRecursiveTypeWithNonStarResult() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/recursiveTypes/recursiveTypeWithNonStarResult.kt");
                }

                @Test
                @TestMetadata("recursiveTypes.kt")
                public void testRecursiveTypes() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/recursiveTypes/recursiveTypes.kt");
                }

                @Test
                @TestMetadata("twoTypeConstructors.kt")
                public void testTwoTypeConstructors() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/recursiveTypes/twoTypeConstructors.kt");
                }

                @Nested
                @TestMetadata("compiler/testData/diagnostics/tests/inference/recursiveTypes/selfTypes")
                @TestDataPath("$PROJECT_ROOT")
                public class SelfTypes {
                    @Test
                    public void testAllFilesPresentInSelfTypes() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/inference/recursiveTypes/selfTypes"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                    }

                    @Nested
                    @TestMetadata("compiler/testData/diagnostics/tests/inference/recursiveTypes/selfTypes/disabledInferenceOnSelfTypes")
                    @TestDataPath("$PROJECT_ROOT")
                    public class DisabledInferenceOnSelfTypes {
                        @Test
                        public void testAllFilesPresentInDisabledInferenceOnSelfTypes() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/inference/recursiveTypes/selfTypes/disabledInferenceOnSelfTypes"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }

                        @Test
                        @TestMetadata("basicInferenceForImplicitSelfType.kt")
                        public void testBasicInferenceForImplicitSelfType() throws Exception {
                            runTest("compiler/testData/diagnostics/tests/inference/recursiveTypes/selfTypes/disabledInferenceOnSelfTypes/basicInferenceForImplicitSelfType.kt");
                        }

                        @Test
                        @TestMetadata("recursiveTypeWithTwoTypeParams.kt")
                        public void testRecursiveTypeWithTwoTypeParams() throws Exception {
                            runTest("compiler/testData/diagnostics/tests/inference/recursiveTypes/selfTypes/disabledInferenceOnSelfTypes/recursiveTypeWithTwoTypeParams.kt");
                        }

                        @Test
                        @TestMetadata("writerAppenderExampleRecursive.kt")
                        public void testWriterAppenderExampleRecursive() throws Exception {
                            runTest("compiler/testData/diagnostics/tests/inference/recursiveTypes/selfTypes/disabledInferenceOnSelfTypes/writerAppenderExampleRecursive.kt");
                        }
                    }

                    @Nested
                    @TestMetadata("compiler/testData/diagnostics/tests/inference/recursiveTypes/selfTypes/enabledInferenceOnSelfTypes")
                    @TestDataPath("$PROJECT_ROOT")
                    public class EnabledInferenceOnSelfTypes {
                        @Test
                        public void testAllFilesPresentInEnabledInferenceOnSelfTypes() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/inference/recursiveTypes/selfTypes/enabledInferenceOnSelfTypes"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                        }

                        @Test
                        @TestMetadata("basicInferenceForImplicitSelfType.kt")
                        public void testBasicInferenceForImplicitSelfType() throws Exception {
                            runTest("compiler/testData/diagnostics/tests/inference/recursiveTypes/selfTypes/enabledInferenceOnSelfTypes/basicInferenceForImplicitSelfType.kt");
                        }

                        @Test
                        @TestMetadata("recursiveTypeWithTwoTypeParams.kt")
                        public void testRecursiveTypeWithTwoTypeParams() throws Exception {
                            runTest("compiler/testData/diagnostics/tests/inference/recursiveTypes/selfTypes/enabledInferenceOnSelfTypes/recursiveTypeWithTwoTypeParams.kt");
                        }

                        @Test
                        @TestMetadata("writerAppenderExampleRecursive.kt")
                        public void testWriterAppenderExampleRecursive() throws Exception {
                            runTest("compiler/testData/diagnostics/tests/inference/recursiveTypes/selfTypes/enabledInferenceOnSelfTypes/writerAppenderExampleRecursive.kt");
                        }
                    }
                }
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/inference/regressions")
            @TestDataPath("$PROJECT_ROOT")
            public class Regressions {
                @Test
                public void testAllFilesPresentInRegressions() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/inference/regressions"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("compareBy.kt")
                public void testCompareBy() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/compareBy.kt");
                }

                @Test
                @TestMetadata("kt1029.kt")
                public void testKt1029() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt1029.kt");
                }

                @Test
                @TestMetadata("kt1031.kt")
                public void testKt1031() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt1031.kt");
                }

                @Test
                @TestMetadata("kt1127.kt")
                public void testKt1127() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt1127.kt");
                }

                @Test
                @TestMetadata("kt1145.kt")
                public void testKt1145() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt1145.kt");
                }

                @Test
                @TestMetadata("kt1358.kt")
                public void testKt1358() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt1358.kt");
                }

                @Test
                @TestMetadata("kt1410.kt")
                public void testKt1410() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt1410.kt");
                }

                @Test
                @TestMetadata("kt1718.kt")
                public void testKt1718() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt1718.kt");
                }

                @Test
                @TestMetadata("kt1944.kt")
                public void testKt1944() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt1944.kt");
                }

                @Test
                @TestMetadata("kt2057.kt")
                public void testKt2057() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt2057.kt");
                }

                @Test
                @TestMetadata("kt2179.kt")
                public void testKt2179() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt2179.kt");
                }

                @Test
                @TestMetadata("kt2200.kt")
                public void testKt2200() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt2200.kt");
                }

                @Test
                @TestMetadata("kt2283.kt")
                public void testKt2283() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt2283.kt");
                }

                @Test
                @TestMetadata("kt2286.kt")
                public void testKt2286() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt2286.kt");
                }

                @Test
                @TestMetadata("kt2294.kt")
                public void testKt2294() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt2294.kt");
                }

                @Test
                @TestMetadata("kt2320.kt")
                public void testKt2320() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt2320.kt");
                }

                @Test
                @TestMetadata("kt2324.kt")
                public void testKt2324() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt2324.kt");
                }

                @Test
                @TestMetadata("kt2407.kt")
                public void testKt2407() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt2407.kt");
                }

                @Test
                @TestMetadata("kt2445.kt")
                public void testKt2445() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt2445.kt");
                }

                @Test
                @TestMetadata("kt2459.kt")
                public void testKt2459() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt2459.kt");
                }

                @Test
                @TestMetadata("kt2484.kt")
                public void testKt2484() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt2484.kt");
                }

                @Test
                @TestMetadata("kt2505.kt")
                public void testKt2505() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt2505.kt");
                }

                @Test
                @TestMetadata("kt2514.kt")
                public void testKt2514() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt2514.kt");
                }

                @Test
                @TestMetadata("kt2588.kt")
                public void testKt2588() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt2588.kt");
                }

                @Test
                @TestMetadata("kt2741.kt")
                public void testKt2741() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt2741.kt");
                }

                @Test
                @TestMetadata("kt2754.kt")
                public void testKt2754() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt2754.kt");
                }

                @Test
                @TestMetadata("kt2838.kt")
                public void testKt2838() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt2838.kt");
                }

                @Test
                @TestMetadata("kt2841.kt")
                public void testKt2841() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt2841.kt");
                }

                @Test
                @TestMetadata("kt2841_it.kt")
                public void testKt2841_it() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt2841_it.kt");
                }

                @Test
                @TestMetadata("kt2841_it_this.kt")
                public void testKt2841_it_this() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt2841_it_this.kt");
                }

                @Test
                @TestMetadata("kt2841_this.kt")
                public void testKt2841_this() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt2841_this.kt");
                }

                @Test
                @TestMetadata("kt2842.kt")
                public void testKt2842() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt2842.kt");
                }

                @Test
                @TestMetadata("kt2883.kt")
                public void testKt2883() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt2883.kt");
                }

                @Test
                @TestMetadata("kt3007.kt")
                public void testKt3007() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt3007.kt");
                }

                @Test
                @TestMetadata("kt3038.kt")
                public void testKt3038() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt3038.kt");
                }

                @Test
                @TestMetadata("kt3150.kt")
                public void testKt3150() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt3150.kt");
                }

                @Test
                @TestMetadata("kt3174.kt")
                public void testKt3174() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt3174.kt");
                }

                @Test
                @TestMetadata("kt32106.kt")
                public void testKt32106() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt32106.kt");
                }

                @Test
                @TestMetadata("kt32250.kt")
                public void testKt32250() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt32250.kt");
                }

                @Test
                @TestMetadata("kt32862_both.kt")
                public void testKt32862_both() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt32862_both.kt");
                }

                @Test
                @TestMetadata("kt32862_none.kt")
                public void testKt32862_none() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt32862_none.kt");
                }

                @Test
                @TestMetadata("kt3301.kt")
                public void testKt3301() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt3301.kt");
                }

                @Test
                @TestMetadata("kt3344.kt")
                public void testKt3344() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt3344.kt");
                }

                @Test
                @TestMetadata("kt33629.kt")
                public void testKt33629() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt33629.kt");
                }

                @Test
                @TestMetadata("kt34029.kt")
                public void testKt34029() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt34029.kt");
                }

                @Test
                @TestMetadata("kt34282.kt")
                public void testKt34282() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt34282.kt");
                }

                @Test
                @TestMetadata("kt3496.kt")
                public void testKt3496() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt3496.kt");
                }

                @Test
                @TestMetadata("kt3496_2.kt")
                public void testKt3496_2() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt3496_2.kt");
                }

                @Test
                @TestMetadata("kt3559.kt")
                public void testKt3559() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt3559.kt");
                }

                @Test
                @TestMetadata("kt35844.kt")
                public void testKt35844() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt35844.kt");
                }

                @Test
                @TestMetadata("kt35943.kt")
                public void testKt35943() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt35943.kt");
                }

                @Test
                @TestMetadata("kt36342.kt")
                public void testKt36342() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt36342.kt");
                }

                @Test
                @TestMetadata("kt36342_2.kt")
                public void testKt36342_2() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt36342_2.kt");
                }

                @Test
                @TestMetadata("kt37043.kt")
                public void testKt37043() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt37043.kt");
                }

                @Test
                @TestMetadata("kt37043_2.kt")
                public void testKt37043_2() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt37043_2.kt");
                }

                @Test
                @TestMetadata("kt37419.kt")
                public void testKt37419() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt37419.kt");
                }

                @Test
                @TestMetadata("kt37650.kt")
                public void testKt37650() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt37650.kt");
                }

                @Test
                @TestMetadata("kt38549.kt")
                public void testKt38549() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt38549.kt");
                }

                @Test
                @TestMetadata("kt38691.kt")
                public void testKt38691() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt38691.kt");
                }

                @Test
                @TestMetadata("kt41386.kt")
                public void testKt41386() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt41386.kt");
                }

                @Test
                @TestMetadata("kt41394.kt")
                public void testKt41394() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt41394.kt");
                }

                @Test
                @TestMetadata("kt4420.kt")
                public void testKt4420() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt4420.kt");
                }

                @Test
                @TestMetadata("kt44440.kt")
                public void testKt44440() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt44440.kt");
                }

                @Test
                @TestMetadata("kt47941.kt")
                public void testKt47941() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt47941.kt");
                }

                @Test
                @TestMetadata("kt702.kt")
                public void testKt702() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt702.kt");
                }

                @Test
                @TestMetadata("kt731.kt")
                public void testKt731() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt731.kt");
                }

                @Test
                @TestMetadata("kt742.kt")
                public void testKt742() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt742.kt");
                }

                @Test
                @TestMetadata("kt8132.kt")
                public void testKt8132() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt8132.kt");
                }

                @Test
                @TestMetadata("kt832.kt")
                public void testKt832() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt832.kt");
                }

                @Test
                @TestMetadata("kt943.kt")
                public void testKt943() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt943.kt");
                }

                @Test
                @TestMetadata("kt9461.kt")
                public void testKt9461() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt9461.kt");
                }

                @Test
                @TestMetadata("kt948.kt")
                public void testKt948() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/kt948.kt");
                }

                @Test
                @TestMetadata("noRecursionOnCallingPureKotlinFunctionAsSyntheticJavaAccessor.kt")
                public void testNoRecursionOnCallingPureKotlinFunctionAsSyntheticJavaAccessor() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/regressions/noRecursionOnCallingPureKotlinFunctionAsSyntheticJavaAccessor.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/inference/reportingImprovements")
            @TestDataPath("$PROJECT_ROOT")
            public class ReportingImprovements {
                @Test
                public void testAllFilesPresentInReportingImprovements() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/inference/reportingImprovements"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("cannotInferParameterTypeWithInference.kt")
                public void testCannotInferParameterTypeWithInference() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/reportingImprovements/cannotInferParameterTypeWithInference.kt");
                }

                @Test
                @TestMetadata("ErrorTypeAsGenericParameter.kt")
                public void testErrorTypeAsGenericParameter() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/reportingImprovements/ErrorTypeAsGenericParameter.kt");
                }

                @Test
                @TestMetadata("FunctionPlaceholder.kt")
                public void testFunctionPlaceholder() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/reportingImprovements/FunctionPlaceholder.kt");
                }

                @Test
                @TestMetadata("inferTypeFromUnresolvedArgument.kt")
                public void testInferTypeFromUnresolvedArgument() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/reportingImprovements/inferTypeFromUnresolvedArgument.kt");
                }

                @Test
                @TestMetadata("kt42620.kt")
                public void testKt42620() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/reportingImprovements/kt42620.kt");
                }

                @Test
                @TestMetadata("NoAmbiguityForDifferentFunctionTypes.kt")
                public void testNoAmbiguityForDifferentFunctionTypes() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/reportingImprovements/NoAmbiguityForDifferentFunctionTypes.kt");
                }

                @Test
                @TestMetadata("reportUnresolvedReferenceWrongReceiverForManyCandidates.kt")
                public void testReportUnresolvedReferenceWrongReceiverForManyCandidates() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/reportingImprovements/reportUnresolvedReferenceWrongReceiverForManyCandidates.kt");
                }

                @Test
                @TestMetadata("subtypeForInvariantWithErrorGenerics.kt")
                public void testSubtypeForInvariantWithErrorGenerics() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/reportingImprovements/subtypeForInvariantWithErrorGenerics.kt");
                }

                @Test
                @TestMetadata("typeInferenceFailedOnComponentN.kt")
                public void testTypeInferenceFailedOnComponentN() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/reportingImprovements/typeInferenceFailedOnComponentN.kt");
                }

                @Test
                @TestMetadata("typeInferenceFailedOnIteratorCall.kt")
                public void testTypeInferenceFailedOnIteratorCall() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/reportingImprovements/typeInferenceFailedOnIteratorCall.kt");
                }

                @Test
                @TestMetadata("wrongArgumentExtensionFunction.kt")
                public void testWrongArgumentExtensionFunction() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/reportingImprovements/wrongArgumentExtensionFunction.kt");
                }

                @Test
                @TestMetadata("wrongArgumentPassedToLocalExtensionFunction.kt")
                public void testWrongArgumentPassedToLocalExtensionFunction() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/reportingImprovements/wrongArgumentPassedToLocalExtensionFunction.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/inference/substitutions")
            @TestDataPath("$PROJECT_ROOT")
            public class Substitutions {
                @Test
                public void testAllFilesPresentInSubstitutions() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/inference/substitutions"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("delegationAndInference.kt")
                public void testDelegationAndInference() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/substitutions/delegationAndInference.kt");
                }

                @Test
                @TestMetadata("hideLocalTypeForReturnTypeOfSingleExpressionFunction.kt")
                public void testHideLocalTypeForReturnTypeOfSingleExpressionFunction() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/substitutions/hideLocalTypeForReturnTypeOfSingleExpressionFunction.kt");
                }

                @Test
                @TestMetadata("kt32189returnTypeWithTypealiasSubtitution.kt")
                public void testKt32189returnTypeWithTypealiasSubtitution() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/substitutions/kt32189returnTypeWithTypealiasSubtitution.kt");
                }

                @Test
                @TestMetadata("kt32189returnTypeWithTypealiasSubtitutionOldInference.kt")
                public void testKt32189returnTypeWithTypealiasSubtitutionOldInference() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/substitutions/kt32189returnTypeWithTypealiasSubtitutionOldInference.kt");
                }

                @Test
                @TestMetadata("kt6081SubstituteIntoClassCorrectly.kt")
                public void testKt6081SubstituteIntoClassCorrectly() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/substitutions/kt6081SubstituteIntoClassCorrectly.kt");
                }

                @Test
                @TestMetadata("simpleSubstitutionCheckTypeArgumentsNotTypeParameters.kt")
                public void testSimpleSubstitutionCheckTypeArgumentsNotTypeParameters() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/substitutions/simpleSubstitutionCheckTypeArgumentsNotTypeParameters.kt");
                }

                @Test
                @TestMetadata("substitutionIntoAnonymousClass.kt")
                public void testSubstitutionIntoAnonymousClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/substitutions/substitutionIntoAnonymousClass.kt");
                }

                @Test
                @TestMetadata("substitutionIntoInnerClass.kt")
                public void testSubstitutionIntoInnerClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/substitutions/substitutionIntoInnerClass.kt");
                }

                @Test
                @TestMetadata("substitutionOfTypeEnhancement.kt")
                public void testSubstitutionOfTypeEnhancement() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/substitutions/substitutionOfTypeEnhancement.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/inference/upperBounds")
            @TestDataPath("$PROJECT_ROOT")
            public class UpperBounds {
                @Test
                public void testAllFilesPresentInUpperBounds() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/inference/upperBounds"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("conflictingSubstitutionsFromUpperBound.kt")
                public void testConflictingSubstitutionsFromUpperBound() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/upperBounds/conflictingSubstitutionsFromUpperBound.kt");
                }

                @Test
                @TestMetadata("doNotInferFromBoundsOnly.kt")
                public void testDoNotInferFromBoundsOnly() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/upperBounds/doNotInferFromBoundsOnly.kt");
                }

                @Test
                @TestMetadata("flexibilityInCommonSuperTypeCalculation.kt")
                public void testFlexibilityInCommonSuperTypeCalculation() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/upperBounds/flexibilityInCommonSuperTypeCalculation.kt");
                }

                @Test
                @TestMetadata("flexibilityInCommonSuperTypeCalculation.ni.kt")
                public void testFlexibilityInCommonSuperTypeCalculation_ni() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/upperBounds/flexibilityInCommonSuperTypeCalculation.ni.kt");
                }

                @Test
                @TestMetadata("inferringVariableByMaterializeAndUpperBound.kt")
                public void testInferringVariableByMaterializeAndUpperBound() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/upperBounds/inferringVariableByMaterializeAndUpperBound.kt");
                }

                @Test
                @TestMetadata("intersectUpperBounds.kt")
                public void testIntersectUpperBounds() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/upperBounds/intersectUpperBounds.kt");
                }

                @Test
                @TestMetadata("kt2856.kt")
                public void testKt2856() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/upperBounds/kt2856.kt");
                }

                @Test
                @TestMetadata("nonNullUpperBound.kt")
                public void testNonNullUpperBound() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/upperBounds/nonNullUpperBound.kt");
                }

                @Test
                @TestMetadata("typeParameterAsUpperBound.kt")
                public void testTypeParameterAsUpperBound() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/upperBounds/typeParameterAsUpperBound.kt");
                }

                @Test
                @TestMetadata("useBoundsIfUnknownParameters.kt")
                public void testUseBoundsIfUnknownParameters() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/upperBounds/useBoundsIfUnknownParameters.kt");
                }

                @Test
                @TestMetadata("useBoundsToInferTypeParamsSimple.kt")
                public void testUseBoundsToInferTypeParamsSimple() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inference/upperBounds/useBoundsToInferTypeParamsSimple.kt");
                }
            }
        }

        @Nested
        @TestMetadata("compiler/testData/diagnostics/tests/infos")
        @TestDataPath("$PROJECT_ROOT")
        public class Infos {
            @Test
            public void testAllFilesPresentInInfos() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/infos"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
            }

            @Test
            @TestMetadata("PropertiesWithBackingFields.kt")
            public void testPropertiesWithBackingFields() throws Exception {
                runTest("compiler/testData/diagnostics/tests/infos/PropertiesWithBackingFields.kt");
            }

            @Test
            @TestMetadata("SmartCasts.kt")
            public void testSmartCasts() throws Exception {
                runTest("compiler/testData/diagnostics/tests/infos/SmartCasts.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/diagnostics/tests/inline")
        @TestDataPath("$PROJECT_ROOT")
        public class Inline {
            @Test
            public void testAllFilesPresentInInline() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/inline"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
            }

            @Test
            @TestMetadata("anonymousObjects.kt")
            public void testAnonymousObjects() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inline/anonymousObjects.kt");
            }

            @Test
            @TestMetadata("approximateReturnedAnonymousObjects.kt")
            public void testApproximateReturnedAnonymousObjects() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inline/approximateReturnedAnonymousObjects.kt");
            }

            @Test
            @TestMetadata("assignment.kt")
            public void testAssignment() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inline/assignment.kt");
            }

            @Test
            @TestMetadata("capture.kt")
            public void testCapture() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inline/capture.kt");
            }

            @Test
            @TestMetadata("constructor.kt")
            public void testConstructor() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inline/constructor.kt");
            }

            @Test
            @TestMetadata("default.kt")
            public void testDefault() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inline/default.kt");
            }

            @Test
            @TestMetadata("defaultLambdaInlineSuspend.kt")
            public void testDefaultLambdaInlineSuspend() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inline/defaultLambdaInlineSuspend.kt");
            }

            @Test
            @TestMetadata("defaultLambdaInlining.kt")
            public void testDefaultLambdaInlining() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inline/defaultLambdaInlining.kt");
            }

            @Test
            @TestMetadata("extensionOnFunction.kt")
            public void testExtensionOnFunction() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inline/extensionOnFunction.kt");
            }

            @Test
            @TestMetadata("fromInlineToNoInline.kt")
            public void testFromInlineToNoInline() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inline/fromInlineToNoInline.kt");
            }

            @Test
            @TestMetadata("functions.kt")
            public void testFunctions() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inline/functions.kt");
            }

            @Test
            @TestMetadata("inlineLambdaInDefaultInlineParameter.kt")
            public void testInlineLambdaInDefaultInlineParameter() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inline/inlineLambdaInDefaultInlineParameter.kt");
            }

            @Test
            @TestMetadata("inlineReified.kt")
            public void testInlineReified() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inline/inlineReified.kt");
            }

            @Test
            @TestMetadata("inlinedReturnInBranch.kt")
            public void testInlinedReturnInBranch() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inline/inlinedReturnInBranch.kt");
            }

            @Test
            @TestMetadata("invoke.kt")
            public void testInvoke() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inline/invoke.kt");
            }

            @Test
            @TestMetadata("isCheck.kt")
            public void testIsCheck() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inline/isCheck.kt");
            }

            @Test
            @TestMetadata("kt15410.kt")
            public void testKt15410() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inline/kt15410.kt");
            }

            @Test
            @TestMetadata("kt19679.kt")
            public void testKt19679() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inline/kt19679.kt");
            }

            @Test
            @TestMetadata("kt21177.kt")
            public void testKt21177() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inline/kt21177.kt");
            }

            @Test
            @TestMetadata("kt21177Warning.kt")
            public void testKt21177Warning() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inline/kt21177Warning.kt");
            }

            @Test
            @TestMetadata("kt4869.kt")
            public void testKt4869() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inline/kt4869.kt");
            }

            @Test
            @TestMetadata("labeled.kt")
            public void testLabeled() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inline/labeled.kt");
            }

            @Test
            @TestMetadata("lambdaCast.kt")
            public void testLambdaCast() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inline/lambdaCast.kt");
            }

            @Test
            @TestMetadata("localFun.kt")
            public void testLocalFun() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inline/localFun.kt");
            }

            @Test
            @TestMetadata("messagesForUnsupportedInInline.kt")
            public void testMessagesForUnsupportedInInline() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inline/messagesForUnsupportedInInline.kt");
            }

            @Test
            @TestMetadata("nonVirtualMembersWithInline.kt")
            public void testNonVirtualMembersWithInline() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inline/nonVirtualMembersWithInline.kt");
            }

            @Test
            @TestMetadata("nothingToInline.kt")
            public void testNothingToInline() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inline/nothingToInline.kt");
            }

            @Test
            @TestMetadata("nullabilityOperations.kt")
            public void testNullabilityOperations() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inline/nullabilityOperations.kt");
            }

            @Test
            @TestMetadata("nullableFunction.kt")
            public void testNullableFunction() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inline/nullableFunction.kt");
            }

            @Test
            @TestMetadata("overrideWithInline.kt")
            public void testOverrideWithInline() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inline/overrideWithInline.kt");
            }

            @Test
            @TestMetadata("parenthesized.kt")
            public void testParenthesized() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inline/parenthesized.kt");
            }

            @Test
            @TestMetadata("privateClass.kt")
            public void testPrivateClass() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inline/privateClass.kt");
            }

            @Test
            @TestMetadata("propagation.kt")
            public void testPropagation() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inline/propagation.kt");
            }

            @Test
            @TestMetadata("protectedCallDepecation.kt")
            public void testProtectedCallDepecation() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inline/protectedCallDepecation.kt");
            }

            @Test
            @TestMetadata("protectedCallError.kt")
            public void testProtectedCallError() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inline/protectedCallError.kt");
            }

            @Test
            @TestMetadata("publishedApi.kt")
            public void testPublishedApi() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inline/publishedApi.kt");
            }

            @Test
            @TestMetadata("recursion.kt")
            public void testRecursion() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inline/recursion.kt");
            }

            @Test
            @TestMetadata("returnedAnonymousObjects.kt")
            public void testReturnedAnonymousObjects() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inline/returnedAnonymousObjects.kt");
            }

            @Test
            @TestMetadata("returns.kt")
            public void testReturns() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inline/returns.kt");
            }

            @Test
            @TestMetadata("sam.kt")
            public void testSam() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inline/sam.kt");
            }

            @Test
            @TestMetadata("stringTemplate.kt")
            public void testStringTemplate() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inline/stringTemplate.kt");
            }

            @Test
            @TestMetadata("superCall.kt")
            public void testSuperCall() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inline/superCall.kt");
            }

            @Test
            @TestMetadata("superCallDepecation.kt")
            public void testSuperCallDepecation() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inline/superCallDepecation.kt");
            }

            @Test
            @TestMetadata("superCallDepecationWarning.kt")
            public void testSuperCallDepecationWarning() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inline/superCallDepecationWarning.kt");
            }

            @Test
            @TestMetadata("superCallFromMultipleSubclasses.kt")
            public void testSuperCallFromMultipleSubclasses() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inline/superCallFromMultipleSubclasses.kt");
            }

            @Test
            @TestMetadata("superProperty.kt")
            public void testSuperProperty() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inline/superProperty.kt");
            }

            @Test
            @TestMetadata("vararg.kt")
            public void testVararg() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inline/vararg.kt");
            }

            @Test
            @TestMetadata("when.kt")
            public void testWhen() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inline/when.kt");
            }

            @Test
            @TestMetadata("wrongUsage.kt")
            public void testWrongUsage() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inline/wrongUsage.kt");
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/inline/binaryExpressions")
            @TestDataPath("$PROJECT_ROOT")
            public class BinaryExpressions {
                @Test
                public void testAllFilesPresentInBinaryExpressions() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/inline/binaryExpressions"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("andOr.kt")
                public void testAndOr() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inline/binaryExpressions/andOr.kt");
                }

                @Test
                @TestMetadata("arrayAccess.kt")
                public void testArrayAccess() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inline/binaryExpressions/arrayAccess.kt");
                }

                @Test
                @TestMetadata("assignment.kt")
                public void testAssignment() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inline/binaryExpressions/assignment.kt");
                }

                @Test
                @TestMetadata("comparison.kt")
                public void testComparison() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inline/binaryExpressions/comparison.kt");
                }

                @Test
                @TestMetadata("componentAccess.kt")
                public void testComponentAccess() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inline/binaryExpressions/componentAccess.kt");
                }

                @Test
                @TestMetadata("contains.kt")
                public void testContains() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inline/binaryExpressions/contains.kt");
                }

                @Test
                @TestMetadata("mathOperations.kt")
                public void testMathOperations() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inline/binaryExpressions/mathOperations.kt");
                }

                @Test
                @TestMetadata("rangeTo.kt")
                public void testRangeTo() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inline/binaryExpressions/rangeTo.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/inline/nonLocalReturns")
            @TestDataPath("$PROJECT_ROOT")
            public class NonLocalReturns {
                @Test
                public void testAllFilesPresentInNonLocalReturns() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/inline/nonLocalReturns"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("anonymousObjects.kt")
                public void testAnonymousObjects() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inline/nonLocalReturns/anonymousObjects.kt");
                }

                @Test
                @TestMetadata("anonymousObjectsNested.kt")
                public void testAnonymousObjectsNested() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inline/nonLocalReturns/anonymousObjectsNested.kt");
                }

                @Test
                @TestMetadata("explicitReturnType.kt")
                public void testExplicitReturnType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inline/nonLocalReturns/explicitReturnType.kt");
                }

                @Test
                @TestMetadata("fromOnlyLocal.kt")
                public void testFromOnlyLocal() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inline/nonLocalReturns/fromOnlyLocal.kt");
                }

                @Test
                @TestMetadata("inlineLambda.kt")
                public void testInlineLambda() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inline/nonLocalReturns/inlineLambda.kt");
                }

                @Test
                @TestMetadata("labeledReturn.kt")
                public void testLabeledReturn() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inline/nonLocalReturns/labeledReturn.kt");
                }

                @Test
                @TestMetadata("lambdaAsGeneric.kt")
                public void testLambdaAsGeneric() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inline/nonLocalReturns/lambdaAsGeneric.kt");
                }

                @Test
                @TestMetadata("lambdaAsNonFunction.kt")
                public void testLambdaAsNonFunction() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inline/nonLocalReturns/lambdaAsNonFunction.kt");
                }

                @Test
                @TestMetadata("lambdaWithGlobalReturnsInsideOnlyLocalOne.kt")
                public void testLambdaWithGlobalReturnsInsideOnlyLocalOne() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inline/nonLocalReturns/lambdaWithGlobalReturnsInsideOnlyLocalOne.kt");
                }

                @Test
                @TestMetadata("localFun.kt")
                public void testLocalFun() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inline/nonLocalReturns/localFun.kt");
                }

                @Test
                @TestMetadata("nestedNonLocals.kt")
                public void testNestedNonLocals() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inline/nonLocalReturns/nestedNonLocals.kt");
                }

                @Test
                @TestMetadata("noInlineAnnotation.kt")
                public void testNoInlineAnnotation() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inline/nonLocalReturns/noInlineAnnotation.kt");
                }

                @Test
                @TestMetadata("noInlineLambda.kt")
                public void testNoInlineLambda() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inline/nonLocalReturns/noInlineLambda.kt");
                }

                @Test
                @TestMetadata("nonInlinedClass.kt")
                public void testNonInlinedClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inline/nonLocalReturns/nonInlinedClass.kt");
                }

                @Test
                @TestMetadata("onlyLocalReturnLambda.kt")
                public void testOnlyLocalReturnLambda() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inline/nonLocalReturns/onlyLocalReturnLambda.kt");
                }

                @Test
                @TestMetadata("onlyLocalReturnLambdaBinaryExpr.kt")
                public void testOnlyLocalReturnLambdaBinaryExpr() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inline/nonLocalReturns/onlyLocalReturnLambdaBinaryExpr.kt");
                }

                @Test
                @TestMetadata("propertyAccessorsAndConstructor.kt")
                public void testPropertyAccessorsAndConstructor() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inline/nonLocalReturns/propertyAccessorsAndConstructor.kt");
                }

                @Test
                @TestMetadata("toOnlyLocal.kt")
                public void testToOnlyLocal() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inline/nonLocalReturns/toOnlyLocal.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/inline/nonPublicMember")
            @TestDataPath("$PROJECT_ROOT")
            public class NonPublicMember {
                @Test
                public void testAllFilesPresentInNonPublicMember() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/inline/nonPublicMember"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("inNonPublicClass.kt")
                public void testInNonPublicClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inline/nonPublicMember/inNonPublicClass.kt");
                }

                @Test
                @TestMetadata("inNonPublicInnerClass.kt")
                public void testInNonPublicInnerClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inline/nonPublicMember/inNonPublicInnerClass.kt");
                }

                @Test
                @TestMetadata("inPackage.kt")
                public void testInPackage() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inline/nonPublicMember/inPackage.kt");
                }

                @Test
                @TestMetadata("inPublicClass.kt")
                public void testInPublicClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inline/nonPublicMember/inPublicClass.kt");
                }

                @Test
                @TestMetadata("kt14887.kt")
                public void testKt14887() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inline/nonPublicMember/kt14887.kt");
                }

                @Test
                @TestMetadata("localClass.kt")
                public void testLocalClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inline/nonPublicMember/localClass.kt");
                }

                @Test
                @TestMetadata("localClass2.kt")
                public void testLocalClass2() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inline/nonPublicMember/localClass2.kt");
                }

                @Test
                @TestMetadata("localFun.kt")
                public void testLocalFun() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inline/nonPublicMember/localFun.kt");
                }

                @Test
                @TestMetadata("publishedApi.kt")
                public void testPublishedApi() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inline/nonPublicMember/publishedApi.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/inline/property")
            @TestDataPath("$PROJECT_ROOT")
            public class Property {
                @Test
                public void testAllFilesPresentInProperty() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/inline/property"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("invoke.kt")
                public void testInvoke() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inline/property/invoke.kt");
                }

                @Test
                @TestMetadata("propertyWithBackingField.kt")
                public void testPropertyWithBackingField() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inline/property/propertyWithBackingField.kt");
                }

                @Test
                @TestMetadata("unsupportedConstruction.kt")
                public void testUnsupportedConstruction() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inline/property/unsupportedConstruction.kt");
                }

                @Test
                @TestMetadata("virtualProperty.kt")
                public void testVirtualProperty() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inline/property/virtualProperty.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/inline/regressions")
            @TestDataPath("$PROJECT_ROOT")
            public class Regressions {
                @Test
                public void testAllFilesPresentInRegressions() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/inline/regressions"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("kt4341.kt")
                public void testKt4341() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inline/regressions/kt4341.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/inline/unaryExpressions")
            @TestDataPath("$PROJECT_ROOT")
            public class UnaryExpressions {
                @Test
                public void testAllFilesPresentInUnaryExpressions() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/inline/unaryExpressions"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("mathOperation.kt")
                public void testMathOperation() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inline/unaryExpressions/mathOperation.kt");
                }

                @Test
                @TestMetadata("notOnCall.kt")
                public void testNotOnCall() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inline/unaryExpressions/notOnCall.kt");
                }

                @Test
                @TestMetadata("notOperation.kt")
                public void testNotOperation() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inline/unaryExpressions/notOperation.kt");
                }
            }
        }

        @Nested
        @TestMetadata("compiler/testData/diagnostics/tests/inlineClasses")
        @TestDataPath("$PROJECT_ROOT")
        public class InlineClasses {
            @Test
            public void testAllFilesPresentInInlineClasses() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/inlineClasses"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
            }

            @Test
            @TestMetadata("basicInlineClassDeclaration.kt")
            public void testBasicInlineClassDeclaration() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inlineClasses/basicInlineClassDeclaration.kt");
            }

            @Test
            @TestMetadata("basicInlineClassDeclarationDisabled.kt")
            public void testBasicInlineClassDeclarationDisabled() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inlineClasses/basicInlineClassDeclarationDisabled.kt");
            }

            @Test
            @TestMetadata("changingNullabilityOfOrdinaryClassIsBinaryCompatibleChange.kt")
            public void testChangingNullabilityOfOrdinaryClassIsBinaryCompatibleChange() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inlineClasses/changingNullabilityOfOrdinaryClassIsBinaryCompatibleChange.kt");
            }

            @Test
            @TestMetadata("constructorsJvmSignaturesClash.kt")
            public void testConstructorsJvmSignaturesClash() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inlineClasses/constructorsJvmSignaturesClash.kt");
            }

            @Test
            @TestMetadata("delegatedPropertyInInlineClass.kt")
            public void testDelegatedPropertyInInlineClass() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inlineClasses/delegatedPropertyInInlineClass.kt");
            }

            @Test
            @TestMetadata("functionsJvmSignaturesClash.kt")
            public void testFunctionsJvmSignaturesClash() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inlineClasses/functionsJvmSignaturesClash.kt");
            }

            @Test
            @TestMetadata("functionsJvmSignaturesConflictOnInheritance.kt")
            public void testFunctionsJvmSignaturesConflictOnInheritance() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inlineClasses/functionsJvmSignaturesConflictOnInheritance.kt");
            }

            @Test
            @TestMetadata("genericInlineClass.kt")
            public void testGenericInlineClass() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inlineClasses/genericInlineClass.kt");
            }

            @Test
            @TestMetadata("identityComparisonWithInlineClasses.kt")
            public void testIdentityComparisonWithInlineClasses() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inlineClasses/identityComparisonWithInlineClasses.kt");
            }

            @Test
            @TestMetadata("inlineClassCanImplementInterfaceByDelegation.kt")
            public void testInlineClassCanImplementInterfaceByDelegation() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inlineClasses/inlineClassCanImplementInterfaceByDelegation.kt");
            }

            @Test
            @TestMetadata("inlineClassCanOnlyImplementInterfaces.kt")
            public void testInlineClassCanOnlyImplementInterfaces() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inlineClasses/inlineClassCanOnlyImplementInterfaces.kt");
            }

            @Test
            @TestMetadata("inlineClassCannotImplementInterfaceByDelegation.kt")
            public void testInlineClassCannotImplementInterfaceByDelegation() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inlineClasses/inlineClassCannotImplementInterfaceByDelegation.kt");
            }

            @Test
            @TestMetadata("inlineClassConstructorParameterWithDefaultValue.kt")
            public void testInlineClassConstructorParameterWithDefaultValue() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inlineClasses/inlineClassConstructorParameterWithDefaultValue.kt");
            }

            @Test
            @TestMetadata("inlineClassDeclarationCheck.kt")
            public void testInlineClassDeclarationCheck() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inlineClasses/inlineClassDeclarationCheck.kt");
            }

            @Test
            @TestMetadata("inlineClassDeprecated.kt")
            public void testInlineClassDeprecated() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inlineClasses/inlineClassDeprecated.kt");
            }

            @Test
            @TestMetadata("inlineClassImplementsCollection.kt")
            public void testInlineClassImplementsCollection() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inlineClasses/inlineClassImplementsCollection.kt");
            }

            @Test
            @TestMetadata("inlineClassWithForbiddenUnderlyingType.kt")
            public void testInlineClassWithForbiddenUnderlyingType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inlineClasses/inlineClassWithForbiddenUnderlyingType.kt");
            }

            @Test
            @TestMetadata("inlineClassesInsideAnnotations.kt")
            public void testInlineClassesInsideAnnotations() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inlineClasses/inlineClassesInsideAnnotations.kt");
            }

            @Test
            @TestMetadata("innerClassInsideInlineClass.kt")
            public void testInnerClassInsideInlineClass() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inlineClasses/innerClassInsideInlineClass.kt");
            }

            @Test
            @TestMetadata("lateinitInlineClasses.kt")
            public void testLateinitInlineClasses() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inlineClasses/lateinitInlineClasses.kt");
            }

            @Test
            @TestMetadata("presenceOfInitializerBlockInsideInlineClass.kt")
            public void testPresenceOfInitializerBlockInsideInlineClass() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inlineClasses/presenceOfInitializerBlockInsideInlineClass.kt");
            }

            @Test
            @TestMetadata("presenceOfPublicPrimaryConstructorForInlineClass.kt")
            public void testPresenceOfPublicPrimaryConstructorForInlineClass() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inlineClasses/presenceOfPublicPrimaryConstructorForInlineClass.kt");
            }

            @Test
            @TestMetadata("propertiesWithBackingFieldsInsideInlineClass.kt")
            public void testPropertiesWithBackingFieldsInsideInlineClass() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inlineClasses/propertiesWithBackingFieldsInsideInlineClass.kt");
            }

            @Test
            @TestMetadata("recursiveInlineClasses.kt")
            public void testRecursiveInlineClasses() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inlineClasses/recursiveInlineClasses.kt");
            }

            @Test
            @TestMetadata("reifiedGenericUnderlyingType.kt")
            public void testReifiedGenericUnderlyingType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inlineClasses/reifiedGenericUnderlyingType.kt");
            }

            @Test
            @TestMetadata("reservedMembersAndConstructsInsideInlineClass.kt")
            public void testReservedMembersAndConstructsInsideInlineClass() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inlineClasses/reservedMembersAndConstructsInsideInlineClass.kt");
            }

            @Test
            @TestMetadata("synchronizedForbidden.kt")
            public void testSynchronizedForbidden() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inlineClasses/synchronizedForbidden.kt");
            }

            @Test
            @TestMetadata("unsignedLiteralsWithoutArtifactOnClasspath.kt")
            public void testUnsignedLiteralsWithoutArtifactOnClasspath() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inlineClasses/unsignedLiteralsWithoutArtifactOnClasspath.kt");
            }

            @Test
            @TestMetadata("varargsOnParametersOfInlineClassType.kt")
            public void testVarargsOnParametersOfInlineClassType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inlineClasses/varargsOnParametersOfInlineClassType.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/diagnostics/tests/inner")
        @TestDataPath("$PROJECT_ROOT")
        public class Inner {
            @Test
            @TestMetadata("accessingToJavaNestedClass.kt")
            public void testAccessingToJavaNestedClass() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inner/accessingToJavaNestedClass.kt");
            }

            @Test
            @TestMetadata("accessingToKotlinNestedClass.kt")
            public void testAccessingToKotlinNestedClass() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inner/accessingToKotlinNestedClass.kt");
            }

            @Test
            public void testAllFilesPresentInInner() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/inner"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
            }

            @Test
            @TestMetadata("annotationInInnerClass.kt")
            public void testAnnotationInInnerClass() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inner/annotationInInnerClass.kt");
            }

            @Test
            @TestMetadata("classesInClassObjectHeader.kt")
            public void testClassesInClassObjectHeader() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inner/classesInClassObjectHeader.kt");
            }

            @Test
            @TestMetadata("constructorAccess.kt")
            public void testConstructorAccess() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inner/constructorAccess.kt");
            }

            @Test
            @TestMetadata("deepInnerClass.kt")
            public void testDeepInnerClass() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inner/deepInnerClass.kt");
            }

            @Test
            @TestMetadata("enumEntries.kt")
            public void testEnumEntries() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inner/enumEntries.kt");
            }

            @Test
            @TestMetadata("enumInInnerClass.kt")
            public void testEnumInInnerClass() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inner/enumInInnerClass.kt");
            }

            @Test
            @TestMetadata("extensionFun.kt")
            public void testExtensionFun() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inner/extensionFun.kt");
            }

            @Test
            @TestMetadata("extensionLambdaInsideNestedClass.kt")
            public void testExtensionLambdaInsideNestedClass() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inner/extensionLambdaInsideNestedClass.kt");
            }

            @Test
            @TestMetadata("illegalModifier_lv12.kt")
            public void testIllegalModifier_lv12() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inner/illegalModifier_lv12.kt");
            }

            @Test
            @TestMetadata("innerClassInEnumEntryClassMemberResolve.kt")
            public void testInnerClassInEnumEntryClassMemberResolve() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inner/innerClassInEnumEntryClassMemberResolve.kt");
            }

            @Test
            @TestMetadata("innerClassInEnumEntryClass_lv12.kt")
            public void testInnerClassInEnumEntryClass_lv12() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inner/innerClassInEnumEntryClass_lv12.kt");
            }

            @Test
            @TestMetadata("innerClassInEnumEntryClass_lv13.kt")
            public void testInnerClassInEnumEntryClass_lv13() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inner/innerClassInEnumEntryClass_lv13.kt");
            }

            @Test
            @TestMetadata("InnerClassNameClash.kt")
            public void testInnerClassNameClash() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inner/InnerClassNameClash.kt");
            }

            @Test
            @TestMetadata("innerClassesInStaticParameters.kt")
            public void testInnerClassesInStaticParameters() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inner/innerClassesInStaticParameters.kt");
            }

            @Test
            @TestMetadata("innerConstructorsFromQualifiers.kt")
            public void testInnerConstructorsFromQualifiers() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inner/innerConstructorsFromQualifiers.kt");
            }

            @Test
            @TestMetadata("innerConstructorsFromQualifiersWithIrrelevantCandidate.kt")
            public void testInnerConstructorsFromQualifiersWithIrrelevantCandidate() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inner/innerConstructorsFromQualifiersWithIrrelevantCandidate.kt");
            }

            @Test
            @TestMetadata("innerErrorForClassObjects.kt")
            public void testInnerErrorForClassObjects() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inner/innerErrorForClassObjects.kt");
            }

            @Test
            @TestMetadata("innerErrorForObjects.kt")
            public void testInnerErrorForObjects() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inner/innerErrorForObjects.kt");
            }

            @Test
            @TestMetadata("innerThisSuper.kt")
            public void testInnerThisSuper() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inner/innerThisSuper.kt");
            }

            @Test
            @TestMetadata("interfaceInInnerClass.kt")
            public void testInterfaceInInnerClass() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inner/interfaceInInnerClass.kt");
            }

            @Test
            @TestMetadata("kt5854.kt")
            public void testKt5854() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inner/kt5854.kt");
            }

            @Test
            @TestMetadata("kt6026.kt")
            public void testKt6026() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inner/kt6026.kt");
            }

            @Test
            @TestMetadata("localClass.kt")
            public void testLocalClass() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inner/localClass.kt");
            }

            @Test
            @TestMetadata("localClassInsideNested.kt")
            public void testLocalClassInsideNested() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inner/localClassInsideNested.kt");
            }

            @Test
            @TestMetadata("localThisSuper.kt")
            public void testLocalThisSuper() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inner/localThisSuper.kt");
            }

            @Test
            @TestMetadata("modality.kt")
            public void testModality() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inner/modality.kt");
            }

            @Test
            @TestMetadata("nestedClassAccessedViaInstanceReference.kt")
            public void testNestedClassAccessedViaInstanceReference() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inner/nestedClassAccessedViaInstanceReference.kt");
            }

            @Test
            @TestMetadata("nestedClassExtendsOuter.kt")
            public void testNestedClassExtendsOuter() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inner/nestedClassExtendsOuter.kt");
            }

            @Test
            @TestMetadata("nestedClassExtendsOuterGeneric.kt")
            public void testNestedClassExtendsOuterGeneric() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inner/nestedClassExtendsOuterGeneric.kt");
            }

            @Test
            @TestMetadata("nestedClassInObject.kt")
            public void testNestedClassInObject() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inner/nestedClassInObject.kt");
            }

            @Test
            @TestMetadata("nestedClassNotAllowed_after.kt")
            public void testNestedClassNotAllowed_after() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inner/nestedClassNotAllowed_after.kt");
            }

            @Test
            @TestMetadata("nestedClassNotAllowed_before.kt")
            public void testNestedClassNotAllowed_before() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inner/nestedClassNotAllowed_before.kt");
            }

            @Test
            @TestMetadata("nestedObject.kt")
            public void testNestedObject() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inner/nestedObject.kt");
            }

            @Test
            @TestMetadata("nestedVsInnerAccessOuterMember.kt")
            public void testNestedVsInnerAccessOuterMember() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inner/nestedVsInnerAccessOuterMember.kt");
            }

            @Test
            @TestMetadata("outerGenericParam.kt")
            public void testOuterGenericParam() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inner/outerGenericParam.kt");
            }

            @Test
            @TestMetadata("outerProtectedMember.kt")
            public void testOuterProtectedMember() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inner/outerProtectedMember.kt");
            }

            @Test
            @TestMetadata("outerSuperClassMember.kt")
            public void testOuterSuperClassMember() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inner/outerSuperClassMember.kt");
            }

            @Test
            @TestMetadata("referenceToSelfInLocal.kt")
            public void testReferenceToSelfInLocal() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inner/referenceToSelfInLocal.kt");
            }

            @Test
            @TestMetadata("resolvePackageClassInObjects.kt")
            public void testResolvePackageClassInObjects() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inner/resolvePackageClassInObjects.kt");
            }

            @Test
            @TestMetadata("selfAnnotationForClassObject.kt")
            public void testSelfAnnotationForClassObject() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inner/selfAnnotationForClassObject.kt");
            }

            @Test
            @TestMetadata("traits.kt")
            public void testTraits() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inner/traits.kt");
            }

            @Test
            @TestMetadata("typeVarianceConflict.kt")
            public void testTypeVarianceConflict() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inner/typeVarianceConflict.kt");
            }

            @Test
            @TestMetadata("typeVarianceConflictFeatureOn.kt")
            public void testTypeVarianceConflictFeatureOn() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inner/typeVarianceConflictFeatureOn.kt");
            }

            @Test
            @TestMetadata("visibility.kt")
            public void testVisibility() throws Exception {
                runTest("compiler/testData/diagnostics/tests/inner/visibility.kt");
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/inner/qualifiedExpression")
            @TestDataPath("$PROJECT_ROOT")
            public class QualifiedExpression {
                @Test
                public void testAllFilesPresentInQualifiedExpression() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/inner/qualifiedExpression"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("classObjectOfNestedClass.kt")
                public void testClassObjectOfNestedClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inner/qualifiedExpression/classObjectOfNestedClass.kt");
                }

                @Test
                @TestMetadata("constructNestedClass.kt")
                public void testConstructNestedClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inner/qualifiedExpression/constructNestedClass.kt");
                }

                @Test
                @TestMetadata("dataLocalVariable.kt")
                public void testDataLocalVariable() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inner/qualifiedExpression/dataLocalVariable.kt");
                }

                @Test
                @TestMetadata("enumConstant.kt")
                public void testEnumConstant() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inner/qualifiedExpression/enumConstant.kt");
                }

                @Test
                @TestMetadata("genericNestedClass.kt")
                public void testGenericNestedClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inner/qualifiedExpression/genericNestedClass.kt");
                }

                @Test
                @TestMetadata("importNestedClass.kt")
                public void testImportNestedClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inner/qualifiedExpression/importNestedClass.kt");
                }

                @Test
                @TestMetadata("nestedClassInPackage.kt")
                public void testNestedClassInPackage() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inner/qualifiedExpression/nestedClassInPackage.kt");
                }

                @Test
                @TestMetadata("nestedEnumConstant.kt")
                public void testNestedEnumConstant() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inner/qualifiedExpression/nestedEnumConstant.kt");
                }

                @Test
                @TestMetadata("nestedObjects.kt")
                public void testNestedObjects() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inner/qualifiedExpression/nestedObjects.kt");
                }

                @Test
                @TestMetadata("typePosition.kt")
                public void testTypePosition() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/inner/qualifiedExpression/typePosition.kt");
                }
            }
        }

        @Nested
        @TestMetadata("compiler/testData/diagnostics/tests/integerLiterals")
        @TestDataPath("$PROJECT_ROOT")
        public class IntegerLiterals {
            @Test
            public void testAllFilesPresentInIntegerLiterals() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/integerLiterals"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
            }

            @Test
            @TestMetadata("constantUnaryOperators.kt")
            public void testConstantUnaryOperators() throws Exception {
                runTest("compiler/testData/diagnostics/tests/integerLiterals/constantUnaryOperators.kt");
            }

            @Test
            @TestMetadata("intToLongConversion.kt")
            public void testIntToLongConversion() throws Exception {
                runTest("compiler/testData/diagnostics/tests/integerLiterals/intToLongConversion.kt");
            }

            @Test
            @TestMetadata("literalsInInference.kt")
            public void testLiteralsInInference() throws Exception {
                runTest("compiler/testData/diagnostics/tests/integerLiterals/literalsInInference.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/diagnostics/tests/j+k")
        @TestDataPath("$PROJECT_ROOT")
        public class J_k {
            @Test
            @TestMetadata("accessClassObjectFromJava.kt")
            public void testAccessClassObjectFromJava() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/accessClassObjectFromJava.kt");
            }

            @Test
            public void testAllFilesPresentInJ_k() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/j+k"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
            }

            @Test
            @TestMetadata("ambiguousSamAdapters.kt")
            public void testAmbiguousSamAdapters() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/ambiguousSamAdapters.kt");
            }

            @Test
            @TestMetadata("annotationWithArgumentsMissingDependencies.kt")
            public void testAnnotationWithArgumentsMissingDependencies() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/annotationWithArgumentsMissingDependencies.kt");
            }

            @Test
            @TestMetadata("annotationsInheritance.kt")
            public void testAnnotationsInheritance() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/annotationsInheritance.kt");
            }

            @Test
            @TestMetadata("arrayOfStarParametrized.kt")
            public void testArrayOfStarParametrized() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/arrayOfStarParametrized.kt");
            }

            @Test
            @TestMetadata("callableReferencesStaticMemberClash.kt")
            public void testCallableReferencesStaticMemberClash() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/callableReferencesStaticMemberClash.kt");
            }

            @Test
            @TestMetadata("canDeclareIfSamAdapterIsInherited.kt")
            public void testCanDeclareIfSamAdapterIsInherited() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/canDeclareIfSamAdapterIsInherited.kt");
            }

            @Test
            @TestMetadata("collectorInference.kt")
            public void testCollectorInference() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/collectorInference.kt");
            }

            @Test
            @TestMetadata("computeIfAbsentConcurrent.kt")
            public void testComputeIfAbsentConcurrent() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/computeIfAbsentConcurrent.kt");
            }

            @Test
            @TestMetadata("contravariantIterable.kt")
            public void testContravariantIterable() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/contravariantIterable.kt");
            }

            @Test
            @TestMetadata("defaultMethods.kt")
            public void testDefaultMethods() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/defaultMethods.kt");
            }

            @Test
            @TestMetadata("defaultMethodsIndirectInheritance.kt")
            public void testDefaultMethodsIndirectInheritance() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/defaultMethodsIndirectInheritance.kt");
            }

            @Test
            @TestMetadata("differentFilename.kt")
            public void testDifferentFilename() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/differentFilename.kt");
            }

            @Test
            @TestMetadata("enumGetOrdinal.kt")
            public void testEnumGetOrdinal() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/enumGetOrdinal.kt");
            }

            @Test
            @TestMetadata("exceptionMessage.kt")
            public void testExceptionMessage() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/exceptionMessage.kt");
            }

            @Test
            @TestMetadata("fieldOverridesField.kt")
            public void testFieldOverridesField() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/fieldOverridesField.kt");
            }

            @Test
            @TestMetadata("fieldOverridesFieldOfDifferentType.kt")
            public void testFieldOverridesFieldOfDifferentType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/fieldOverridesFieldOfDifferentType.kt");
            }

            @Test
            @TestMetadata("fieldOverridesNothing.kt")
            public void testFieldOverridesNothing() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/fieldOverridesNothing.kt");
            }

            @Test
            @TestMetadata("finalCollectionSize.kt")
            public void testFinalCollectionSize() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/finalCollectionSize.kt");
            }

            @Test
            @TestMetadata("flexibleNothing.kt")
            public void testFlexibleNothing() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/flexibleNothing.kt");
            }

            @Test
            @TestMetadata("genericConstructorWithMultipleBounds.kt")
            public void testGenericConstructorWithMultipleBounds() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/genericConstructorWithMultipleBounds.kt");
            }

            @Test
            @TestMetadata("GenericsInSupertypes.kt")
            public void testGenericsInSupertypes() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/GenericsInSupertypes.kt");
            }

            @Test
            @TestMetadata("inheritAbstractSamAdapter.kt")
            public void testInheritAbstractSamAdapter() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/inheritAbstractSamAdapter.kt");
            }

            @Test
            @TestMetadata("inheritanceStaticMethodFromInterface.kt")
            public void testInheritanceStaticMethodFromInterface() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/inheritanceStaticMethodFromInterface.kt");
            }

            @Test
            @TestMetadata("InheritedGenericFunction.kt")
            public void testInheritedGenericFunction() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/InheritedGenericFunction.kt");
            }

            @Test
            @TestMetadata("InnerClassFromJava.kt")
            public void testInnerClassFromJava() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/InnerClassFromJava.kt");
            }

            @Test
            @TestMetadata("innerLightClass.kt")
            public void testInnerLightClass() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/innerLightClass.kt");
            }

            @Test
            @TestMetadata("innerNestedClassFromJava.kt")
            public void testInnerNestedClassFromJava() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/innerNestedClassFromJava.kt");
            }

            @Test
            @TestMetadata("integerNotNullable.kt")
            public void testIntegerNotNullable() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/integerNotNullable.kt");
            }

            @Test
            @TestMetadata("invisiblePackagePrivateInheritedMember.kt")
            public void testInvisiblePackagePrivateInheritedMember() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/invisiblePackagePrivateInheritedMember.kt");
            }

            @Test
            @TestMetadata("javaStaticImport.kt")
            public void testJavaStaticImport() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/javaStaticImport.kt");
            }

            @Test
            @TestMetadata("KJKInheritance.kt")
            public void testKJKInheritance() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/KJKInheritance.kt");
            }

            @Test
            @TestMetadata("KJKInheritanceGeneric.kt")
            public void testKJKInheritanceGeneric() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/KJKInheritanceGeneric.kt");
            }

            @Test
            @TestMetadata("kt1402.kt")
            public void testKt1402() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/kt1402.kt");
            }

            @Test
            @TestMetadata("kt1431.kt")
            public void testKt1431() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/kt1431.kt");
            }

            @Test
            @TestMetadata("kt1730_implementCharSequence.kt")
            public void testKt1730_implementCharSequence() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/kt1730_implementCharSequence.kt");
            }

            @Test
            @TestMetadata("kt2152.kt")
            public void testKt2152() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/kt2152.kt");
            }

            @Test
            @TestMetadata("kt2394.kt")
            public void testKt2394() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/kt2394.kt");
            }

            @Test
            @TestMetadata("kt2606.kt")
            public void testKt2606() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/kt2606.kt");
            }

            @Test
            @TestMetadata("kt2619.kt")
            public void testKt2619() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/kt2619.kt");
            }

            @Test
            @TestMetadata("kt2641.kt")
            public void testKt2641() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/kt2641.kt");
            }

            @Test
            @TestMetadata("kt2890.kt")
            public void testKt2890() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/kt2890.kt");
            }

            @Test
            @TestMetadata("kt3307.kt")
            public void testKt3307() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/kt3307.kt");
            }

            @Test
            @TestMetadata("kt3311.kt")
            public void testKt3311() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/kt3311.kt");
            }

            @Test
            @TestMetadata("kt36856.kt")
            public void testKt36856() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/kt36856.kt");
            }

            @Test
            @TestMetadata("kt6720_abstractProperty.kt")
            public void testKt6720_abstractProperty() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/kt6720_abstractProperty.kt");
            }

            @Test
            @TestMetadata("kt7523.kt")
            public void testKt7523() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/kt7523.kt");
            }

            @Test
            @TestMetadata("matchers.kt")
            public void testMatchers() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/matchers.kt");
            }

            @Test
            @TestMetadata("mutableIterator.kt")
            public void testMutableIterator() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/mutableIterator.kt");
            }

            @Test
            @TestMetadata("nullForOptionalOrElse.kt")
            public void testNullForOptionalOrElse() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/nullForOptionalOrElse.kt");
            }

            @Test
            @TestMetadata("orderOfSupertypesAndFakeOverrides_1.kt")
            public void testOrderOfSupertypesAndFakeOverrides_1() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/orderOfSupertypesAndFakeOverrides_1.kt");
            }

            @Test
            @TestMetadata("orderOfSupertypesAndFakeOverrides_2.kt")
            public void testOrderOfSupertypesAndFakeOverrides_2() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/orderOfSupertypesAndFakeOverrides_2.kt");
            }

            @Test
            @TestMetadata("overrideRawType.kt")
            public void testOverrideRawType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/overrideRawType.kt");
            }

            @Test
            @TestMetadata("OverrideVararg.kt")
            public void testOverrideVararg() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/OverrideVararg.kt");
            }

            @Test
            @TestMetadata("overrideWithSamAndTypeParameter.kt")
            public void testOverrideWithSamAndTypeParameter() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/overrideWithSamAndTypeParameter.kt");
            }

            @Test
            @TestMetadata("packagePrivateClassStaticMember.kt")
            public void testPackagePrivateClassStaticMember() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/packagePrivateClassStaticMember.kt");
            }

            @Test
            @TestMetadata("packageVisibility.kt")
            public void testPackageVisibility() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/packageVisibility.kt");
            }

            @Test
            @TestMetadata("privateFieldOverridesNothing.kt")
            public void testPrivateFieldOverridesNothing() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/privateFieldOverridesNothing.kt");
            }

            @Test
            @TestMetadata("privateNestedClassStaticMember.kt")
            public void testPrivateNestedClassStaticMember() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/privateNestedClassStaticMember.kt");
            }

            @Test
            @TestMetadata("protectedStaticSamePackage.kt")
            public void testProtectedStaticSamePackage() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/protectedStaticSamePackage.kt");
            }

            @Test
            @TestMetadata("purelyImplementedSupertype.kt")
            public void testPurelyImplementedSupertype() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/purelyImplementedSupertype.kt");
            }

            @Test
            @TestMetadata("rawOverride.kt")
            public void testRawOverride() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/rawOverride.kt");
            }

            @Test
            @TestMetadata("rawTypeScope.kt")
            public void testRawTypeScope() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/rawTypeScope.kt");
            }

            @Test
            @TestMetadata("rawUpperBounds.kt")
            public void testRawUpperBounds() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/rawUpperBounds.kt");
            }

            @Test
            @TestMetadata("recursionWithJavaSyntheticProperty.kt")
            public void testRecursionWithJavaSyntheticProperty() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/recursionWithJavaSyntheticProperty.kt");
            }

            @Test
            @TestMetadata("recursiveRawUpperBound.kt")
            public void testRecursiveRawUpperBound() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/recursiveRawUpperBound.kt");
            }

            @Test
            @TestMetadata("recursiveRawUpperBound2.kt")
            public void testRecursiveRawUpperBound2() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/recursiveRawUpperBound2.kt");
            }

            @Test
            @TestMetadata("recursiveRawUpperBound3.kt")
            public void testRecursiveRawUpperBound3() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/recursiveRawUpperBound3.kt");
            }

            @Test
            @TestMetadata("safeCallDefinitelyNotNull.kt")
            public void testSafeCallDefinitelyNotNull() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/safeCallDefinitelyNotNull.kt");
            }

            @Test
            @TestMetadata("samInConstructorWithGenerics.kt")
            public void testSamInConstructorWithGenerics() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/samInConstructorWithGenerics.kt");
            }

            @Test
            @TestMetadata("samWithConsumer.kt")
            public void testSamWithConsumer() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/samWithConsumer.kt");
            }

            @Test
            @TestMetadata("selectMoreSpecific.kt")
            public void testSelectMoreSpecific() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/selectMoreSpecific.kt");
            }

            @Test
            @TestMetadata("serializable.kt")
            public void testSerializable() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/serializable.kt");
            }

            @Test
            @TestMetadata("shadowingPrimitiveStaticField.kt")
            public void testShadowingPrimitiveStaticField() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/shadowingPrimitiveStaticField.kt");
            }

            @Test
            @TestMetadata("Simple.kt")
            public void testSimple() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/Simple.kt");
            }

            @Test
            @TestMetadata("specialBridges.kt")
            public void testSpecialBridges() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/specialBridges.kt");
            }

            @Test
            @TestMetadata("StaticMembersFromSuperclasses.kt")
            public void testStaticMembersFromSuperclasses() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/StaticMembersFromSuperclasses.kt");
            }

            @Test
            @TestMetadata("staticMethodInClass.kt")
            public void testStaticMethodInClass() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/staticMethodInClass.kt");
            }

            @Test
            @TestMetadata("SupertypeArgumentsNullability-NotNull-SpecialTypes.kt")
            public void testSupertypeArgumentsNullability_NotNull_SpecialTypes() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/SupertypeArgumentsNullability-NotNull-SpecialTypes.kt");
            }

            @Test
            @TestMetadata("SupertypeArgumentsNullability-NotNull-UserTypes.kt")
            public void testSupertypeArgumentsNullability_NotNull_UserTypes() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/SupertypeArgumentsNullability-NotNull-UserTypes.kt");
            }

            @Test
            @TestMetadata("SupertypeArgumentsNullability-SpecialTypes.kt")
            public void testSupertypeArgumentsNullability_SpecialTypes() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/SupertypeArgumentsNullability-SpecialTypes.kt");
            }

            @Test
            @TestMetadata("SupertypeArgumentsNullability-UserTypes.kt")
            public void testSupertypeArgumentsNullability_UserTypes() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/SupertypeArgumentsNullability-UserTypes.kt");
            }

            @Test
            @TestMetadata("supertypeUsesNested.kt")
            public void testSupertypeUsesNested() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/supertypeUsesNested.kt");
            }

            @Test
            @TestMetadata("traitDefaultCall.kt")
            public void testTraitDefaultCall() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/traitDefaultCall.kt");
            }

            @Test
            @TestMetadata("typeAliasWithSamConstructor.kt")
            public void testTypeAliasWithSamConstructor() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/typeAliasWithSamConstructor.kt");
            }

            @Test
            @TestMetadata("UnboxingNulls.kt")
            public void testUnboxingNulls() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/UnboxingNulls.kt");
            }

            @Test
            @TestMetadata("wrongVarianceInJava.kt")
            public void testWrongVarianceInJava() throws Exception {
                runTest("compiler/testData/diagnostics/tests/j+k/wrongVarianceInJava.kt");
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/j+k/brokenCode")
            @TestDataPath("$PROJECT_ROOT")
            public class BrokenCode {
                @Test
                public void testAllFilesPresentInBrokenCode() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/j+k/brokenCode"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("classDuplicates.kt")
                public void testClassDuplicates() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/brokenCode/classDuplicates.kt");
                }

                @Test
                @TestMetadata("fieldDuplicates.kt")
                public void testFieldDuplicates() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/brokenCode/fieldDuplicates.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/j+k/collectionOverrides")
            @TestDataPath("$PROJECT_ROOT")
            public class CollectionOverrides {
                @Test
                public void testAllFilesPresentInCollectionOverrides() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/j+k/collectionOverrides"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("charBuffer.kt")
                public void testCharBuffer() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/collectionOverrides/charBuffer.kt");
                }

                @Test
                @TestMetadata("collectionStringImpl.kt")
                public void testCollectionStringImpl() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/collectionOverrides/collectionStringImpl.kt");
                }

                @Test
                @TestMetadata("commonCollections.kt")
                public void testCommonCollections() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/collectionOverrides/commonCollections.kt");
                }

                @Test
                @TestMetadata("contains.kt")
                public void testContains() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/collectionOverrides/contains.kt");
                }

                @Test
                @TestMetadata("containsAll.kt")
                public void testContainsAll() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/collectionOverrides/containsAll.kt");
                }

                @Test
                @TestMetadata("containsAndOverload.kt")
                public void testContainsAndOverload() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/collectionOverrides/containsAndOverload.kt");
                }

                @Test
                @TestMetadata("getCharSequence.kt")
                public void testGetCharSequence() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/collectionOverrides/getCharSequence.kt");
                }

                @Test
                @TestMetadata("irrelevantCharAtAbstract.kt")
                public void testIrrelevantCharAtAbstract() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/collectionOverrides/irrelevantCharAtAbstract.kt");
                }

                @Test
                @TestMetadata("irrelevantImplCharSequence.kt")
                public void testIrrelevantImplCharSequence() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/collectionOverrides/irrelevantImplCharSequence.kt");
                }

                @Test
                @TestMetadata("irrelevantImplCharSequenceKotlin.kt")
                public void testIrrelevantImplCharSequenceKotlin() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/collectionOverrides/irrelevantImplCharSequenceKotlin.kt");
                }

                @Test
                @TestMetadata("irrelevantImplMutableList.kt")
                public void testIrrelevantImplMutableList() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/collectionOverrides/irrelevantImplMutableList.kt");
                }

                @Test
                @TestMetadata("irrelevantImplMutableListKotlin.kt")
                public void testIrrelevantImplMutableListKotlin() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/collectionOverrides/irrelevantImplMutableListKotlin.kt");
                }

                @Test
                @TestMetadata("irrelevantMapGetAbstract.kt")
                public void testIrrelevantMapGetAbstract() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/collectionOverrides/irrelevantMapGetAbstract.kt");
                }

                @Test
                @TestMetadata("mapGetOverride.kt")
                public void testMapGetOverride() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/collectionOverrides/mapGetOverride.kt");
                }

                @Test
                @TestMetadata("overridesBuiltinNoMagic.kt")
                public void testOverridesBuiltinNoMagic() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/collectionOverrides/overridesBuiltinNoMagic.kt");
                }

                @Test
                @TestMetadata("removeAt.kt")
                public void testRemoveAt() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/collectionOverrides/removeAt.kt");
                }

                @Test
                @TestMetadata("removeAtInt.kt")
                public void testRemoveAtInt() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/collectionOverrides/removeAtInt.kt");
                }

                @Test
                @TestMetadata("sizeFromKotlinOverriddenInJava.kt")
                public void testSizeFromKotlinOverriddenInJava() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/collectionOverrides/sizeFromKotlinOverriddenInJava.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/j+k/deprecations")
            @TestDataPath("$PROJECT_ROOT")
            public class Deprecations {
                @Test
                public void testAllFilesPresentInDeprecations() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/j+k/deprecations"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("forFakeOverrides.kt")
                public void testForFakeOverrides() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/deprecations/forFakeOverrides.kt");
                }

                @Test
                @TestMetadata("forMixedOverride.kt")
                public void testForMixedOverride() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/deprecations/forMixedOverride.kt");
                }

                @Test
                @TestMetadata("forOverrides.kt")
                public void testForOverrides() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/deprecations/forOverrides.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/j+k/genericConstructor")
            @TestDataPath("$PROJECT_ROOT")
            public class GenericConstructor {
                @Test
                public void testAllFilesPresentInGenericConstructor() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/j+k/genericConstructor"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("classTypeParameterInferredFromArgument.kt")
                public void testClassTypeParameterInferredFromArgument() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/genericConstructor/classTypeParameterInferredFromArgument.kt");
                }

                @Test
                @TestMetadata("innerClass.kt")
                public void testInnerClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/genericConstructor/innerClass.kt");
                }

                @Test
                @TestMetadata("noClassTypeParameters.kt")
                public void testNoClassTypeParameters() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/genericConstructor/noClassTypeParameters.kt");
                }

                @Test
                @TestMetadata("noClassTypeParametersInvParameter.kt")
                public void testNoClassTypeParametersInvParameter() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/genericConstructor/noClassTypeParametersInvParameter.kt");
                }

                @Test
                @TestMetadata("recursive.kt")
                public void testRecursive() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/genericConstructor/recursive.kt");
                }

                @Test
                @TestMetadata("selfTypes.kt")
                public void testSelfTypes() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/genericConstructor/selfTypes.kt");
                }

                @Test
                @TestMetadata("superCall.kt")
                public void testSuperCall() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/genericConstructor/superCall.kt");
                }

                @Test
                @TestMetadata("superCallImpossibleToInfer.kt")
                public void testSuperCallImpossibleToInfer() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/genericConstructor/superCallImpossibleToInfer.kt");
                }

                @Test
                @TestMetadata("withClassTypeParameters.kt")
                public void testWithClassTypeParameters() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/genericConstructor/withClassTypeParameters.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/j+k/polymorphicSignature")
            @TestDataPath("$PROJECT_ROOT")
            public class PolymorphicSignature {
                @Test
                public void testAllFilesPresentInPolymorphicSignature() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/j+k/polymorphicSignature"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("spreadOperator_after.kt")
                public void testSpreadOperator_after() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/polymorphicSignature/spreadOperator_after.kt");
                }

                @Test
                @TestMetadata("spreadOperator_before.kt")
                public void testSpreadOperator_before() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/polymorphicSignature/spreadOperator_before.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/j+k/primitiveOverrides")
            @TestDataPath("$PROJECT_ROOT")
            public class PrimitiveOverrides {
                @Test
                public void testAllFilesPresentInPrimitiveOverrides() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/j+k/primitiveOverrides"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("kt11140.kt")
                public void testKt11140() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/primitiveOverrides/kt11140.kt");
                }

                @Test
                @TestMetadata("notNullAnnotated.kt")
                public void testNotNullAnnotated() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/primitiveOverrides/notNullAnnotated.kt");
                }

                @Test
                @TestMetadata("specializedMap.kt")
                public void testSpecializedMap() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/primitiveOverrides/specializedMap.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/j+k/primitiveOverridesWithInlineClass")
            @TestDataPath("$PROJECT_ROOT")
            public class PrimitiveOverridesWithInlineClass {
                @Test
                public void testAllFilesPresentInPrimitiveOverridesWithInlineClass() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/j+k/primitiveOverridesWithInlineClass"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("inlineClassErasedToPrimitiveInt.kt")
                public void testInlineClassErasedToPrimitiveInt() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/primitiveOverridesWithInlineClass/inlineClassErasedToPrimitiveInt.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/j+k/properties")
            @TestDataPath("$PROJECT_ROOT")
            public class Properties {
                @Test
                public void testAllFilesPresentInProperties() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/j+k/properties"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("fieldPropertyOverloads.kt")
                public void testFieldPropertyOverloads() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/properties/fieldPropertyOverloads.kt");
                }

                @Test
                @TestMetadata("fieldPropertyOverloadsDisabled.kt")
                public void testFieldPropertyOverloadsDisabled() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/properties/fieldPropertyOverloadsDisabled.kt");
                }

                @Test
                @TestMetadata("fieldPropertyOverloadsNI.kt")
                public void testFieldPropertyOverloadsNI() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/properties/fieldPropertyOverloadsNI.kt");
                }

                @Test
                @TestMetadata("interface.kt")
                public void testInterface() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/properties/interface.kt");
                }

                @Test
                @TestMetadata("isName.kt")
                public void testIsName() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/properties/isName.kt");
                }

                @Test
                @TestMetadata("staticFieldPropertyOverloads.kt")
                public void testStaticFieldPropertyOverloads() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/properties/staticFieldPropertyOverloads.kt");
                }

                @Test
                @TestMetadata("val.kt")
                public void testVal() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/properties/val.kt");
                }

                @Test
                @TestMetadata("var.kt")
                public void testVar() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/properties/var.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/j+k/sam")
            @TestDataPath("$PROJECT_ROOT")
            public class Sam {
                @Test
                public void testAllFilesPresentInSam() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/j+k/sam"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("compatibilityResolveToOuterScopeForKotlinFunctions.kt")
                public void testCompatibilityResolveToOuterScopeForKotlinFunctions() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/sam/compatibilityResolveToOuterScopeForKotlinFunctions.kt");
                }

                @Test
                @TestMetadata("conversionForDerivedGenericClass.kt")
                public void testConversionForDerivedGenericClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/sam/conversionForDerivedGenericClass.kt");
                }

                @Test
                @TestMetadata("conversionsWithNestedGenerics.kt")
                public void testConversionsWithNestedGenerics() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/sam/conversionsWithNestedGenerics.kt");
                }

                @Test
                @TestMetadata("enhancedSamConstructor.kt")
                public void testEnhancedSamConstructor() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/sam/enhancedSamConstructor.kt");
                }

                @Test
                @TestMetadata("fakeOverrideFunctionForStaticSam.kt")
                public void testFakeOverrideFunctionForStaticSam() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/sam/fakeOverrideFunctionForStaticSam.kt");
                }

                @Test
                @TestMetadata("inheritedStaticSam.kt")
                public void testInheritedStaticSam() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/sam/inheritedStaticSam.kt");
                }

                @Test
                @TestMetadata("kt37920.kt")
                public void testKt37920() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/sam/kt37920.kt");
                }

                @Test
                @TestMetadata("kt39630.kt")
                public void testKt39630() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/sam/kt39630.kt");
                }

                @Test
                @TestMetadata("privateCandidatesWithWrongArguments.kt")
                public void testPrivateCandidatesWithWrongArguments() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/sam/privateCandidatesWithWrongArguments.kt");
                }

                @Test
                @TestMetadata("recursiveSamsAndInvoke.kt")
                public void testRecursiveSamsAndInvoke() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/sam/recursiveSamsAndInvoke.kt");
                }

                @Test
                @TestMetadata("referenceToSamFunctionAgainstExpectedType.kt")
                public void testReferenceToSamFunctionAgainstExpectedType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/sam/referenceToSamFunctionAgainstExpectedType.kt");
                }

                @Test
                @TestMetadata("samOnTypeParameter.kt")
                public void testSamOnTypeParameter() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/sam/samOnTypeParameter.kt");
                }

                @Test
                @TestMetadata("staticSamFromImportWithStar.kt")
                public void testStaticSamFromImportWithStar() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/sam/staticSamFromImportWithStar.kt");
                }

                @Test
                @TestMetadata("staticSamWithExplicitImport.kt")
                public void testStaticSamWithExplicitImport() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/sam/staticSamWithExplicitImport.kt");
                }

                @Test
                @TestMetadata("typeInferenceOnSamAdapters.kt")
                public void testTypeInferenceOnSamAdapters() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/sam/typeInferenceOnSamAdapters.kt");
                }

                @Test
                @TestMetadata("withDefaultMethods.kt")
                public void testWithDefaultMethods() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/sam/withDefaultMethods.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/j+k/samByProjectedType")
            @TestDataPath("$PROJECT_ROOT")
            public class SamByProjectedType {
                @Test
                public void testAllFilesPresentInSamByProjectedType() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/j+k/samByProjectedType"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("genericInReturnType.kt")
                public void testGenericInReturnType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/samByProjectedType/genericInReturnType.kt");
                }

                @Test
                @TestMetadata("genericInValueParameter.kt")
                public void testGenericInValueParameter() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/samByProjectedType/genericInValueParameter.kt");
                }

                @Test
                @TestMetadata("genericSuperWildcard.kt")
                public void testGenericSuperWildcard() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/samByProjectedType/genericSuperWildcard.kt");
                }

                @Test
                @TestMetadata("noAdapterBecuaseOfRecursiveUpperBound.kt")
                public void testNoAdapterBecuaseOfRecursiveUpperBound() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/samByProjectedType/noAdapterBecuaseOfRecursiveUpperBound.kt");
                }

                @Test
                @TestMetadata("starProjectionComplexUpperBound.kt")
                public void testStarProjectionComplexUpperBound() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/samByProjectedType/starProjectionComplexUpperBound.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/j+k/signatureAnnotations")
            @TestDataPath("$PROJECT_ROOT")
            public class SignatureAnnotations {
                @Test
                public void testAllFilesPresentInSignatureAnnotations() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/j+k/signatureAnnotations"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("notNullVarargOverride.kt")
                public void testNotNullVarargOverride() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/signatureAnnotations/notNullVarargOverride.kt");
                }

                @Test
                @TestMetadata("nullableVarargOverride.kt")
                public void testNullableVarargOverride() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/signatureAnnotations/nullableVarargOverride.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/j+k/specialBuiltIns")
            @TestDataPath("$PROJECT_ROOT")
            public class SpecialBuiltIns {
                @Test
                public void testAllFilesPresentInSpecialBuiltIns() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/j+k/specialBuiltIns"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("hashtableInheritance.kt")
                public void testHashtableInheritance() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/specialBuiltIns/hashtableInheritance.kt");
                }

                @Test
                @TestMetadata("securityProvider.kt")
                public void testSecurityProvider() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/specialBuiltIns/securityProvider.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/j+k/types")
            @TestDataPath("$PROJECT_ROOT")
            public class Types {
                @Test
                public void testAllFilesPresentInTypes() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/j+k/types"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("arrayList.kt")
                public void testArrayList() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/types/arrayList.kt");
                }

                @Test
                @TestMetadata("constantStaticStringField.kt")
                public void testConstantStaticStringField() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/types/constantStaticStringField.kt");
                }

                @Test
                @TestMetadata("noOverrideKeyword.kt")
                public void testNoOverrideKeyword() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/types/noOverrideKeyword.kt");
                }

                @Test
                @TestMetadata("notNullTypeParameterWithKotlinNullable.kt")
                public void testNotNullTypeParameterWithKotlinNullable() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/types/notNullTypeParameterWithKotlinNullable.kt");
                }

                @Test
                @TestMetadata("notNullTypeParameterWithKotlinNullableWarnings.kt")
                public void testNotNullTypeParameterWithKotlinNullableWarnings() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/types/notNullTypeParameterWithKotlinNullableWarnings.kt");
                }

                @Test
                @TestMetadata("notNullTypeParameterWithKotlinOverridesDefinitelyNonNullable.kt")
                public void testNotNullTypeParameterWithKotlinOverridesDefinitelyNonNullable() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/types/notNullTypeParameterWithKotlinOverridesDefinitelyNonNullable.kt");
                }

                @Test
                @TestMetadata("notNullTypeParameterWithKotlinOverridesWarning.kt")
                public void testNotNullTypeParameterWithKotlinOverridesWarning() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/types/notNullTypeParameterWithKotlinOverridesWarning.kt");
                }

                @Test
                @TestMetadata("returnCollection.kt")
                public void testReturnCollection() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/types/returnCollection.kt");
                }

                @Test
                @TestMetadata("shapeMismatchInCovariantPosition.kt")
                public void testShapeMismatchInCovariantPosition() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/types/shapeMismatchInCovariantPosition.kt");
                }

                @Test
                @TestMetadata("shapeMismatchInCovariantPositionGeneric.kt")
                public void testShapeMismatchInCovariantPositionGeneric() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/types/shapeMismatchInCovariantPositionGeneric.kt");
                }

                @Test
                @TestMetadata("typeParameter.kt")
                public void testTypeParameter() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/types/typeParameter.kt");
                }

                @Test
                @TestMetadata("varargOverride.kt")
                public void testVarargOverride() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/j+k/types/varargOverride.kt");
                }
            }
        }

        @Nested
        @TestMetadata("compiler/testData/diagnostics/tests/java8Overrides")
        @TestDataPath("$PROJECT_ROOT")
        public class Java8Overrides {
            @Test
            @TestMetadata("abstractBaseClassMemberNotImplemented.kt")
            public void testAbstractBaseClassMemberNotImplemented() throws Exception {
                runTest("compiler/testData/diagnostics/tests/java8Overrides/abstractBaseClassMemberNotImplemented.kt");
            }

            @Test
            @TestMetadata("abstractBaseClassMemberNotImplemented_15.kt")
            public void testAbstractBaseClassMemberNotImplemented_15() throws Exception {
                runTest("compiler/testData/diagnostics/tests/java8Overrides/abstractBaseClassMemberNotImplemented_15.kt");
            }

            @Test
            @TestMetadata("abstractFakeOverrideSuperCall.kt")
            public void testAbstractFakeOverrideSuperCall() throws Exception {
                runTest("compiler/testData/diagnostics/tests/java8Overrides/abstractFakeOverrideSuperCall.kt");
            }

            @Test
            @TestMetadata("abstractFakeOverrideSuperCallForbidden.kt")
            public void testAbstractFakeOverrideSuperCallForbidden() throws Exception {
                runTest("compiler/testData/diagnostics/tests/java8Overrides/abstractFakeOverrideSuperCallForbidden.kt");
            }

            @Test
            @TestMetadata("abstractVsAbstract.kt")
            public void testAbstractVsAbstract() throws Exception {
                runTest("compiler/testData/diagnostics/tests/java8Overrides/abstractVsAbstract.kt");
            }

            @Test
            public void testAllFilesPresentInJava8Overrides() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/java8Overrides"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
            }

            @Test
            @TestMetadata("defaultVsAbstract.kt")
            public void testDefaultVsAbstract() throws Exception {
                runTest("compiler/testData/diagnostics/tests/java8Overrides/defaultVsAbstract.kt");
            }

            @Test
            @TestMetadata("hidingMethodOfAny.kt")
            public void testHidingMethodOfAny() throws Exception {
                runTest("compiler/testData/diagnostics/tests/java8Overrides/hidingMethodOfAny.kt");
            }

            @Test
            @TestMetadata("implementingMethodOfAny.kt")
            public void testImplementingMethodOfAny() throws Exception {
                runTest("compiler/testData/diagnostics/tests/java8Overrides/implementingMethodOfAny.kt");
            }

            @Test
            @TestMetadata("kt45508.kt")
            public void testKt45508() throws Exception {
                runTest("compiler/testData/diagnostics/tests/java8Overrides/kt45508.kt");
            }

            @Test
            @TestMetadata("notAMethodOfAny.kt")
            public void testNotAMethodOfAny() throws Exception {
                runTest("compiler/testData/diagnostics/tests/java8Overrides/notAMethodOfAny.kt");
            }

            @Test
            @TestMetadata("overridingMethodOfAnyChain.kt")
            public void testOverridingMethodOfAnyChain() throws Exception {
                runTest("compiler/testData/diagnostics/tests/java8Overrides/overridingMethodOfAnyChain.kt");
            }

            @Test
            @TestMetadata("overridingMethodOfAnyDiamond.kt")
            public void testOverridingMethodOfAnyDiamond() throws Exception {
                runTest("compiler/testData/diagnostics/tests/java8Overrides/overridingMethodOfAnyDiamond.kt");
            }

            @Test
            @TestMetadata("singleRelevantDefault.kt")
            public void testSingleRelevantDefault() throws Exception {
                runTest("compiler/testData/diagnostics/tests/java8Overrides/singleRelevantDefault.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/diagnostics/tests/javac")
        @TestDataPath("$PROJECT_ROOT")
        public class Javac {
            @Test
            public void testAllFilesPresentInJavac() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/javac"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
            }

            @Test
            @TestMetadata("Annotations.kt")
            public void testAnnotations() throws Exception {
                runTest("compiler/testData/diagnostics/tests/javac/Annotations.kt");
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/javac/fieldsResolution")
            @TestDataPath("$PROJECT_ROOT")
            public class FieldsResolution {
                @Test
                public void testAllFilesPresentInFieldsResolution() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/javac/fieldsResolution"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("AsteriskStaticImportsAmbiguity.kt")
                public void testAsteriskStaticImportsAmbiguity() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/javac/fieldsResolution/AsteriskStaticImportsAmbiguity.kt");
                }

                @Test
                @TestMetadata("BinaryInitializers.kt")
                public void testBinaryInitializers() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/javac/fieldsResolution/BinaryInitializers.kt");
                }

                @Test
                @TestMetadata("ConstantByFqName.kt")
                public void testConstantByFqName() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/javac/fieldsResolution/ConstantByFqName.kt");
                }

                @Test
                @TestMetadata("ConstantValues.kt")
                public void testConstantValues() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/javac/fieldsResolution/ConstantValues.kt");
                }

                @Test
                @TestMetadata("ConstantValuesFromKtFile.kt")
                public void testConstantValuesFromKtFile() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/javac/fieldsResolution/ConstantValuesFromKtFile.kt");
                }

                @Test
                @TestMetadata("FieldFromOuterClass.kt")
                public void testFieldFromOuterClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/javac/fieldsResolution/FieldFromOuterClass.kt");
                }

                @Test
                @TestMetadata("InheritedField.kt")
                public void testInheritedField() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/javac/fieldsResolution/InheritedField.kt");
                }

                @Test
                @TestMetadata("MultipleOuters.kt")
                public void testMultipleOuters() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/javac/fieldsResolution/MultipleOuters.kt");
                }

                @Test
                @TestMetadata("ResolutionPriority.kt")
                public void testResolutionPriority() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/javac/fieldsResolution/ResolutionPriority.kt");
                }

                @Test
                @TestMetadata("SameFieldInSupertypes.kt")
                public void testSameFieldInSupertypes() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/javac/fieldsResolution/SameFieldInSupertypes.kt");
                }

                @Test
                @TestMetadata("StaticImport.kt")
                public void testStaticImport() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/javac/fieldsResolution/StaticImport.kt");
                }

                @Test
                @TestMetadata("StaticImportsAmbiguity.kt")
                public void testStaticImportsAmbiguity() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/javac/fieldsResolution/StaticImportsAmbiguity.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/javac/imports")
            @TestDataPath("$PROJECT_ROOT")
            public class Imports {
                @Test
                public void testAllFilesPresentInImports() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/javac/imports"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("AllUnderImportsAmbiguity.kt")
                public void testAllUnderImportsAmbiguity() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/javac/imports/AllUnderImportsAmbiguity.kt");
                }

                @Test
                @TestMetadata("AllUnderImportsLessPriority.kt")
                public void testAllUnderImportsLessPriority() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/javac/imports/AllUnderImportsLessPriority.kt");
                }

                @Test
                @TestMetadata("ClassImportsConflicting.kt")
                public void testClassImportsConflicting() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/javac/imports/ClassImportsConflicting.kt");
                }

                @Test
                @TestMetadata("CurrentPackageAndAllUnderImport.kt")
                public void testCurrentPackageAndAllUnderImport() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/javac/imports/CurrentPackageAndAllUnderImport.kt");
                }

                @Test
                @TestMetadata("CurrentPackageAndExplicitImport.kt")
                public void testCurrentPackageAndExplicitImport() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/javac/imports/CurrentPackageAndExplicitImport.kt");
                }

                @Test
                @TestMetadata("CurrentPackageAndExplicitNestedImport.kt")
                public void testCurrentPackageAndExplicitNestedImport() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/javac/imports/CurrentPackageAndExplicitNestedImport.kt");
                }

                @Test
                @TestMetadata("CurrentPackageAndNestedAsteriskImport.kt")
                public void testCurrentPackageAndNestedAsteriskImport() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/javac/imports/CurrentPackageAndNestedAsteriskImport.kt");
                }

                @Test
                @TestMetadata("ImportGenericVsPackage.kt")
                public void testImportGenericVsPackage() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/javac/imports/ImportGenericVsPackage.kt");
                }

                @Test
                @TestMetadata("ImportProtectedClass.kt")
                public void testImportProtectedClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/javac/imports/ImportProtectedClass.kt");
                }

                @Test
                @TestMetadata("ImportTwoTimes.kt")
                public void testImportTwoTimes() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/javac/imports/ImportTwoTimes.kt");
                }

                @Test
                @TestMetadata("ImportTwoTimesStar.kt")
                public void testImportTwoTimesStar() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/javac/imports/ImportTwoTimesStar.kt");
                }

                @Test
                @TestMetadata("NestedAndTopLevelClassClash.kt")
                public void testNestedAndTopLevelClassClash() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/javac/imports/NestedAndTopLevelClassClash.kt");
                }

                @Test
                @TestMetadata("NestedClassClash.kt")
                public void testNestedClassClash() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/javac/imports/NestedClassClash.kt");
                }

                @Test
                @TestMetadata("PackageExplicitAndStartImport.kt")
                public void testPackageExplicitAndStartImport() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/javac/imports/PackageExplicitAndStartImport.kt");
                }

                @Test
                @TestMetadata("PackagePrivateAndPublicNested.kt")
                public void testPackagePrivateAndPublicNested() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/javac/imports/PackagePrivateAndPublicNested.kt");
                }

                @Test
                @TestMetadata("TopLevelClassVsPackage.kt")
                public void testTopLevelClassVsPackage() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/javac/imports/TopLevelClassVsPackage.kt");
                }

                @Test
                @TestMetadata("TopLevelClassVsPackage2.kt")
                public void testTopLevelClassVsPackage2() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/javac/imports/TopLevelClassVsPackage2.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/javac/inheritance")
            @TestDataPath("$PROJECT_ROOT")
            public class Inheritance {
                @Test
                public void testAllFilesPresentInInheritance() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/javac/inheritance"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("IheritanceOfInner.kt")
                public void testIheritanceOfInner() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/javac/inheritance/IheritanceOfInner.kt");
                }

                @Test
                @TestMetadata("InheritanceAmbiguity.kt")
                public void testInheritanceAmbiguity() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/javac/inheritance/InheritanceAmbiguity.kt");
                }

                @Test
                @TestMetadata("InheritanceAmbiguity2.kt")
                public void testInheritanceAmbiguity2() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/javac/inheritance/InheritanceAmbiguity2.kt");
                }

                @Test
                @TestMetadata("InheritanceAmbiguity3.kt")
                public void testInheritanceAmbiguity3() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/javac/inheritance/InheritanceAmbiguity3.kt");
                }

                @Test
                @TestMetadata("InheritanceAmbiguity4.kt")
                public void testInheritanceAmbiguity4() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/javac/inheritance/InheritanceAmbiguity4.kt");
                }

                @Test
                @TestMetadata("InheritanceWithKotlin.kt")
                public void testInheritanceWithKotlin() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/javac/inheritance/InheritanceWithKotlin.kt");
                }

                @Test
                @TestMetadata("InheritanceWithKotlinClasses.kt")
                public void testInheritanceWithKotlinClasses() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/javac/inheritance/InheritanceWithKotlinClasses.kt");
                }

                @Test
                @TestMetadata("InheritedInner.kt")
                public void testInheritedInner() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/javac/inheritance/InheritedInner.kt");
                }

                @Test
                @TestMetadata("InheritedInner2.kt")
                public void testInheritedInner2() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/javac/inheritance/InheritedInner2.kt");
                }

                @Test
                @TestMetadata("InheritedInnerAndSupertypeWithSameName.kt")
                public void testInheritedInnerAndSupertypeWithSameName() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/javac/inheritance/InheritedInnerAndSupertypeWithSameName.kt");
                }

                @Test
                @TestMetadata("InheritedInnerUsageInInner.kt")
                public void testInheritedInnerUsageInInner() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/javac/inheritance/InheritedInnerUsageInInner.kt");
                }

                @Test
                @TestMetadata("InheritedKotlinInner.kt")
                public void testInheritedKotlinInner() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/javac/inheritance/InheritedKotlinInner.kt");
                }

                @Test
                @TestMetadata("InnerAndInheritedInner.kt")
                public void testInnerAndInheritedInner() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/javac/inheritance/InnerAndInheritedInner.kt");
                }

                @Test
                @TestMetadata("ManyInheritedClasses.kt")
                public void testManyInheritedClasses() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/javac/inheritance/ManyInheritedClasses.kt");
                }

                @Test
                @TestMetadata("SameInnersInSupertypeAndSupertypesSupertype.kt")
                public void testSameInnersInSupertypeAndSupertypesSupertype() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/javac/inheritance/SameInnersInSupertypeAndSupertypesSupertype.kt");
                }

                @Test
                @TestMetadata("SuperTypeWithSameInner.kt")
                public void testSuperTypeWithSameInner() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/javac/inheritance/SuperTypeWithSameInner.kt");
                }

                @Test
                @TestMetadata("SupertypeInnerAndTypeParameterWithSameNames.kt")
                public void testSupertypeInnerAndTypeParameterWithSameNames() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/javac/inheritance/SupertypeInnerAndTypeParameterWithSameNames.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/javac/inners")
            @TestDataPath("$PROJECT_ROOT")
            public class Inners {
                @Test
                public void testAllFilesPresentInInners() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/javac/inners"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("ComplexCase.kt")
                public void testComplexCase() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/javac/inners/ComplexCase.kt");
                }

                @Test
                @TestMetadata("ComplexCase2.kt")
                public void testComplexCase2() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/javac/inners/ComplexCase2.kt");
                }

                @Test
                @TestMetadata("CurrentPackageAndInner.kt")
                public void testCurrentPackageAndInner() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/javac/inners/CurrentPackageAndInner.kt");
                }

                @Test
                @TestMetadata("ImportThriceNestedClass.kt")
                public void testImportThriceNestedClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/javac/inners/ImportThriceNestedClass.kt");
                }

                @Test
                @TestMetadata("InnerInInner.kt")
                public void testInnerInInner() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/javac/inners/InnerInInner.kt");
                }

                @Test
                @TestMetadata("Nested.kt")
                public void testNested() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/javac/inners/Nested.kt");
                }

                @Test
                @TestMetadata("ThriceNestedClass.kt")
                public void testThriceNestedClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/javac/inners/ThriceNestedClass.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/javac/qualifiedExpression")
            @TestDataPath("$PROJECT_ROOT")
            public class QualifiedExpression {
                @Test
                public void testAllFilesPresentInQualifiedExpression() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/javac/qualifiedExpression"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("GenericClassVsPackage.kt")
                public void testGenericClassVsPackage() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/javac/qualifiedExpression/GenericClassVsPackage.kt");
                }

                @Test
                @TestMetadata("PackageVsClass.kt")
                public void testPackageVsClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/javac/qualifiedExpression/PackageVsClass.kt");
                }

                @Test
                @TestMetadata("PackageVsClass2.kt")
                public void testPackageVsClass2() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/javac/qualifiedExpression/PackageVsClass2.kt");
                }

                @Test
                @TestMetadata("PackageVsRootClass.kt")
                public void testPackageVsRootClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/javac/qualifiedExpression/PackageVsRootClass.kt");
                }

                @Test
                @TestMetadata("visibleClassVsQualifiedClass.kt")
                public void testVisibleClassVsQualifiedClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/javac/qualifiedExpression/visibleClassVsQualifiedClass.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/javac/typeParameters")
            @TestDataPath("$PROJECT_ROOT")
            public class TypeParameters {
                @Test
                public void testAllFilesPresentInTypeParameters() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/javac/typeParameters"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("Clash.kt")
                public void testClash() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/javac/typeParameters/Clash.kt");
                }

                @Test
                @TestMetadata("ComplexCase.kt")
                public void testComplexCase() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/javac/typeParameters/ComplexCase.kt");
                }

                @Test
                @TestMetadata("InheritedInnerAndTypeParameterWithSameNames.kt")
                public void testInheritedInnerAndTypeParameterWithSameNames() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/javac/typeParameters/InheritedInnerAndTypeParameterWithSameNames.kt");
                }

                @Test
                @TestMetadata("InnerWithTypeParameter.kt")
                public void testInnerWithTypeParameter() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/javac/typeParameters/InnerWithTypeParameter.kt");
                }

                @Test
                @TestMetadata("NestedWithInner.kt")
                public void testNestedWithInner() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/javac/typeParameters/NestedWithInner.kt");
                }

                @Test
                @TestMetadata("SeveralInnersWithTypeParameters.kt")
                public void testSeveralInnersWithTypeParameters() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/javac/typeParameters/SeveralInnersWithTypeParameters.kt");
                }

                @Test
                @TestMetadata("TypeParametersInInnerAndOuterWithSameNames.kt")
                public void testTypeParametersInInnerAndOuterWithSameNames() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/javac/typeParameters/TypeParametersInInnerAndOuterWithSameNames.kt");
                }
            }
        }

        @Nested
        @TestMetadata("compiler/testData/diagnostics/tests/labels")
        @TestDataPath("$PROJECT_ROOT")
        public class Labels {
            @Test
            public void testAllFilesPresentInLabels() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/labels"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
            }

            @Test
            @TestMetadata("automaticLabelFromInfixOperator.kt")
            public void testAutomaticLabelFromInfixOperator() throws Exception {
                runTest("compiler/testData/diagnostics/tests/labels/automaticLabelFromInfixOperator.kt");
            }

            @Test
            @TestMetadata("kt1703.kt")
            public void testKt1703() throws Exception {
                runTest("compiler/testData/diagnostics/tests/labels/kt1703.kt");
            }

            @Test
            @TestMetadata("kt361.kt")
            public void testKt361() throws Exception {
                runTest("compiler/testData/diagnostics/tests/labels/kt361.kt");
            }

            @Test
            @TestMetadata("kt3920.kt")
            public void testKt3920() throws Exception {
                runTest("compiler/testData/diagnostics/tests/labels/kt3920.kt");
            }

            @Test
            @TestMetadata("kt3988.kt")
            public void testKt3988() throws Exception {
                runTest("compiler/testData/diagnostics/tests/labels/kt3988.kt");
            }

            @Test
            @TestMetadata("kt4247.kt")
            public void testKt4247() throws Exception {
                runTest("compiler/testData/diagnostics/tests/labels/kt4247.kt");
            }

            @Test
            @TestMetadata("kt4586.kt")
            public void testKt4586() throws Exception {
                runTest("compiler/testData/diagnostics/tests/labels/kt4586.kt");
            }

            @Test
            @TestMetadata("kt4603.kt")
            public void testKt4603() throws Exception {
                runTest("compiler/testData/diagnostics/tests/labels/kt4603.kt");
            }

            @Test
            @TestMetadata("kt591.kt")
            public void testKt591() throws Exception {
                runTest("compiler/testData/diagnostics/tests/labels/kt591.kt");
            }

            @Test
            @TestMetadata("labelReferencesInsideObjectExpressions.kt")
            public void testLabelReferencesInsideObjectExpressions() throws Exception {
                runTest("compiler/testData/diagnostics/tests/labels/labelReferencesInsideObjectExpressions.kt");
            }

            @Test
            @TestMetadata("labeledFunctionLiteral.kt")
            public void testLabeledFunctionLiteral() throws Exception {
                runTest("compiler/testData/diagnostics/tests/labels/labeledFunctionLiteral.kt");
            }

            @Test
            @TestMetadata("labelsMustBeNamed.kt")
            public void testLabelsMustBeNamed() throws Exception {
                runTest("compiler/testData/diagnostics/tests/labels/labelsMustBeNamed.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/diagnostics/tests/lateinit")
        @TestDataPath("$PROJECT_ROOT")
        public class Lateinit {
            @Test
            public void testAllFilesPresentInLateinit() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/lateinit"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
            }

            @Test
            @TestMetadata("modifierApplicability_lv12.kt")
            public void testModifierApplicability_lv12() throws Exception {
                runTest("compiler/testData/diagnostics/tests/lateinit/modifierApplicability_lv12.kt");
            }

            @Test
            @TestMetadata("NoInapplicableLateinitModifierForPropertyWithUnnresolvedType.kt")
            public void testNoInapplicableLateinitModifierForPropertyWithUnnresolvedType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/lateinit/NoInapplicableLateinitModifierForPropertyWithUnnresolvedType.kt");
            }

            @Test
            @TestMetadata("setter.kt")
            public void testSetter() throws Exception {
                runTest("compiler/testData/diagnostics/tests/lateinit/setter.kt");
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/lateinit/local")
            @TestDataPath("$PROJECT_ROOT")
            public class Local {
                @Test
                public void testAllFilesPresentInLocal() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/lateinit/local"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("inapplicableLateinitModifier.kt")
                public void testInapplicableLateinitModifier() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/lateinit/local/inapplicableLateinitModifier.kt");
                }

                @Test
                @TestMetadata("localLateinit.kt")
                public void testLocalLateinit() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/lateinit/local/localLateinit.kt");
                }

                @Test
                @TestMetadata("uninitialized.kt")
                public void testUninitialized() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/lateinit/local/uninitialized.kt");
                }
            }
        }

        @Nested
        @TestMetadata("compiler/testData/diagnostics/tests/library")
        @TestDataPath("$PROJECT_ROOT")
        public class Library {
            @Test
            public void testAllFilesPresentInLibrary() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/library"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
            }

            @Test
            @TestMetadata("Collections.kt")
            public void testCollections() throws Exception {
                runTest("compiler/testData/diagnostics/tests/library/Collections.kt");
            }

            @Test
            @TestMetadata("kt828.kt")
            public void testKt828() throws Exception {
                runTest("compiler/testData/diagnostics/tests/library/kt828.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/diagnostics/tests/localClasses")
        @TestDataPath("$PROJECT_ROOT")
        public class LocalClasses {
            @Test
            public void testAllFilesPresentInLocalClasses() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/localClasses"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
            }

            @Test
            @TestMetadata("localAnnotationClass.kt")
            public void testLocalAnnotationClass() throws Exception {
                runTest("compiler/testData/diagnostics/tests/localClasses/localAnnotationClass.kt");
            }

            @Test
            @TestMetadata("localAnnotationClassError.kt")
            public void testLocalAnnotationClassError() throws Exception {
                runTest("compiler/testData/diagnostics/tests/localClasses/localAnnotationClassError.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/diagnostics/tests/modifiers")
        @TestDataPath("$PROJECT_ROOT")
        public class Modifiers {
            @Test
            public void testAllFilesPresentInModifiers() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/modifiers"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
            }

            @Test
            @TestMetadata("annotations.kt")
            public void testAnnotations() throws Exception {
                runTest("compiler/testData/diagnostics/tests/modifiers/annotations.kt");
            }

            @Test
            @TestMetadata("defaultModifier.kt")
            public void testDefaultModifier() throws Exception {
                runTest("compiler/testData/diagnostics/tests/modifiers/defaultModifier.kt");
            }

            @Test
            @TestMetadata("IllegalModifiers.kt")
            public void testIllegalModifiers() throws Exception {
                runTest("compiler/testData/diagnostics/tests/modifiers/IllegalModifiers.kt");
            }

            @Test
            @TestMetadata("incompatibleVarianceModifiers.kt")
            public void testIncompatibleVarianceModifiers() throws Exception {
                runTest("compiler/testData/diagnostics/tests/modifiers/incompatibleVarianceModifiers.kt");
            }

            @Test
            @TestMetadata("inlineParameters.kt")
            public void testInlineParameters() throws Exception {
                runTest("compiler/testData/diagnostics/tests/modifiers/inlineParameters.kt");
            }

            @Test
            @TestMetadata("internalInInterface.kt")
            public void testInternalInInterface() throws Exception {
                runTest("compiler/testData/diagnostics/tests/modifiers/internalInInterface.kt");
            }

            @Test
            @TestMetadata("modifierOnParameterInFunctionType.kt")
            public void testModifierOnParameterInFunctionType() throws Exception {
                runTest("compiler/testData/diagnostics/tests/modifiers/modifierOnParameterInFunctionType.kt");
            }

            @Test
            @TestMetadata("NoLocalVisibility.kt")
            public void testNoLocalVisibility() throws Exception {
                runTest("compiler/testData/diagnostics/tests/modifiers/NoLocalVisibility.kt");
            }

            @Test
            @TestMetadata("openInExpectInterface.kt")
            public void testOpenInExpectInterface() throws Exception {
                runTest("compiler/testData/diagnostics/tests/modifiers/openInExpectInterface.kt");
            }

            @Test
            @TestMetadata("openInInterface.kt")
            public void testOpenInInterface() throws Exception {
                runTest("compiler/testData/diagnostics/tests/modifiers/openInInterface.kt");
            }

            @Test
            @TestMetadata("primaryConstructorMissingBrackets.kt")
            public void testPrimaryConstructorMissingBrackets() throws Exception {
                runTest("compiler/testData/diagnostics/tests/modifiers/primaryConstructorMissingBrackets.kt");
            }

            @Test
            @TestMetadata("primaryConstructorMissingKeyword.kt")
            public void testPrimaryConstructorMissingKeyword() throws Exception {
                runTest("compiler/testData/diagnostics/tests/modifiers/primaryConstructorMissingKeyword.kt");
            }

            @Test
            @TestMetadata("privateInInterface.kt")
            public void testPrivateInInterface() throws Exception {
                runTest("compiler/testData/diagnostics/tests/modifiers/privateInInterface.kt");
            }

            @Test
            @TestMetadata("protected.kt")
            public void testProtected() throws Exception {
                runTest("compiler/testData/diagnostics/tests/modifiers/protected.kt");
            }

            @Test
            @TestMetadata("redundantTargets.kt")
            public void testRedundantTargets() throws Exception {
                runTest("compiler/testData/diagnostics/tests/modifiers/redundantTargets.kt");
            }

            @Test
            @TestMetadata("repeatedModifiers.kt")
            public void testRepeatedModifiers() throws Exception {
                runTest("compiler/testData/diagnostics/tests/modifiers/repeatedModifiers.kt");
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/modifiers/const")
            @TestDataPath("$PROJECT_ROOT")
            public class Const {
                @Test
                public void testAllFilesPresentInConst() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/modifiers/const"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("applicability.kt")
                public void testApplicability() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/modifiers/const/applicability.kt");
                }

                @Test
                @TestMetadata("arrayInAnnotationArgumentType.kt")
                public void testArrayInAnnotationArgumentType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/modifiers/const/arrayInAnnotationArgumentType.kt");
                }

                @Test
                @TestMetadata("constInteraction.kt")
                public void testConstInteraction() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/modifiers/const/constInteraction.kt");
                }

                @Test
                @TestMetadata("fromJava.kt")
                public void testFromJava() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/modifiers/const/fromJava.kt");
                }

                @Test
                @TestMetadata("fromJavaSubclass.kt")
                public void testFromJavaSubclass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/modifiers/const/fromJavaSubclass.kt");
                }

                @Test
                @TestMetadata("kt12248.kt")
                public void testKt12248() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/modifiers/const/kt12248.kt");
                }

                @Test
                @TestMetadata("kt15913.kt")
                public void testKt15913() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/modifiers/const/kt15913.kt");
                }

                @Test
                @TestMetadata("types.kt")
                public void testTypes() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/modifiers/const/types.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/modifiers/operatorInfix")
            @TestDataPath("$PROJECT_ROOT")
            public class OperatorInfix {
                @Test
                public void testAllFilesPresentInOperatorInfix() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/modifiers/operatorInfix"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("LocalFunctions.kt")
                public void testLocalFunctions() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/modifiers/operatorInfix/LocalFunctions.kt");
                }

                @Test
                @TestMetadata("MemberFunctions.kt")
                public void testMemberFunctions() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/modifiers/operatorInfix/MemberFunctions.kt");
                }

                @Test
                @TestMetadata("Simple.kt")
                public void testSimple() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/modifiers/operatorInfix/Simple.kt");
                }
            }
        }

        @Nested
        @TestMetadata("compiler/testData/diagnostics/tests/multimodule")
        @TestDataPath("$PROJECT_ROOT")
        public class Multimodule {
            @Test
            public void testAllFilesPresentInMultimodule() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/multimodule"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
            }

            @Test
            @TestMetadata("internal.kt")
            public void testInternal() throws Exception {
                runTest("compiler/testData/diagnostics/tests/multimodule/internal.kt");
            }

            @Test
            @TestMetadata("kt14249.kt")
            public void testKt14249() throws Exception {
                runTest("compiler/testData/diagnostics/tests/multimodule/kt14249.kt");
            }

            @Test
            @TestMetadata("packagePrivate.kt")
            public void testPackagePrivate() throws Exception {
                runTest("compiler/testData/diagnostics/tests/multimodule/packagePrivate.kt");
            }

            @Test
            @TestMetadata("publishedApiInternal.kt")
            public void testPublishedApiInternal() throws Exception {
                runTest("compiler/testData/diagnostics/tests/multimodule/publishedApiInternal.kt");
            }

            @Test
            @TestMetadata("redundantElseInWhen.kt")
            public void testRedundantElseInWhen() throws Exception {
                runTest("compiler/testData/diagnostics/tests/multimodule/redundantElseInWhen.kt");
            }

            @Test
            @TestMetadata("samWithSuspendFunctionFromAnotherModule.kt")
            public void testSamWithSuspendFunctionFromAnotherModule() throws Exception {
                runTest("compiler/testData/diagnostics/tests/multimodule/samWithSuspendFunctionFromAnotherModule.kt");
            }

            @Test
            @TestMetadata("varargConflict.kt")
            public void testVarargConflict() throws Exception {
                runTest("compiler/testData/diagnostics/tests/multimodule/varargConflict.kt");
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/multimodule/duplicateClass")
            @TestDataPath("$PROJECT_ROOT")
            public class DuplicateClass {
                @Test
                public void testAllFilesPresentInDuplicateClass() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/multimodule/duplicateClass"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("collectionMethodStub.kt")
                public void testCollectionMethodStub() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multimodule/duplicateClass/collectionMethodStub.kt");
                }

                @Test
                @TestMetadata("differentGenericArguments.kt")
                public void testDifferentGenericArguments() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multimodule/duplicateClass/differentGenericArguments.kt");
                }

                @Test
                @TestMetadata("differentGenericArgumentsReversed.kt")
                public void testDifferentGenericArgumentsReversed() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multimodule/duplicateClass/differentGenericArgumentsReversed.kt");
                }

                @Test
                @TestMetadata("duplicateClass.kt")
                public void testDuplicateClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multimodule/duplicateClass/duplicateClass.kt");
                }

                @Test
                @TestMetadata("duplicateNestedClasses.kt")
                public void testDuplicateNestedClasses() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multimodule/duplicateClass/duplicateNestedClasses.kt");
                }

                @Test
                @TestMetadata("duplicateSuperClass.kt")
                public void testDuplicateSuperClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multimodule/duplicateClass/duplicateSuperClass.kt");
                }

                @Test
                @TestMetadata("genericArgumentNumberMismatch.kt")
                public void testGenericArgumentNumberMismatch() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multimodule/duplicateClass/genericArgumentNumberMismatch.kt");
                }

                @Test
                @TestMetadata("genericSuperClass.kt")
                public void testGenericSuperClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multimodule/duplicateClass/genericSuperClass.kt");
                }

                @Test
                @TestMetadata("inTheSameModuleWithUsage.kt")
                public void testInTheSameModuleWithUsage() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multimodule/duplicateClass/inTheSameModuleWithUsage.kt");
                }

                @Test
                @TestMetadata("inTheSameModuleWithUsageNoTypeAnnotation.kt")
                public void testInTheSameModuleWithUsageNoTypeAnnotation() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multimodule/duplicateClass/inTheSameModuleWithUsageNoTypeAnnotation.kt");
                }

                @Test
                @TestMetadata("members.kt")
                public void testMembers() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multimodule/duplicateClass/members.kt");
                }

                @Test
                @TestMetadata("sameClassNameDifferentPackages.kt")
                public void testSameClassNameDifferentPackages() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multimodule/duplicateClass/sameClassNameDifferentPackages.kt");
                }

                @Test
                @TestMetadata("sameGenericArguments.kt")
                public void testSameGenericArguments() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multimodule/duplicateClass/sameGenericArguments.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/multimodule/duplicateMethod")
            @TestDataPath("$PROJECT_ROOT")
            public class DuplicateMethod {
                @Test
                public void testAllFilesPresentInDuplicateMethod() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/multimodule/duplicateMethod"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("classGenericsInParams.kt")
                public void testClassGenericsInParams() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multimodule/duplicateMethod/classGenericsInParams.kt");
                }

                @Test
                @TestMetadata("classGenericsInParamsBoundMismatch.kt")
                public void testClassGenericsInParamsBoundMismatch() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multimodule/duplicateMethod/classGenericsInParamsBoundMismatch.kt");
                }

                @Test
                @TestMetadata("classGenericsInParamsIndexMismatch.kt")
                public void testClassGenericsInParamsIndexMismatch() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multimodule/duplicateMethod/classGenericsInParamsIndexMismatch.kt");
                }

                @Test
                @TestMetadata("classGenericsInParamsNameMismatch.kt")
                public void testClassGenericsInParamsNameMismatch() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multimodule/duplicateMethod/classGenericsInParamsNameMismatch.kt");
                }

                @Test
                @TestMetadata("classGenericsInReturnType.kt")
                public void testClassGenericsInReturnType() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multimodule/duplicateMethod/classGenericsInReturnType.kt");
                }

                @Test
                @TestMetadata("classVsFunctionGenericsInParamsMismatch.kt")
                public void testClassVsFunctionGenericsInParamsMismatch() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multimodule/duplicateMethod/classVsFunctionGenericsInParamsMismatch.kt");
                }

                @Test
                @TestMetadata("covariantReturnTypes.kt")
                public void testCovariantReturnTypes() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multimodule/duplicateMethod/covariantReturnTypes.kt");
                }

                @Test
                @TestMetadata("differenceInParamNames.kt")
                public void testDifferenceInParamNames() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multimodule/duplicateMethod/differenceInParamNames.kt");
                }

                @Test
                @TestMetadata("differentGenericsInParams.kt")
                public void testDifferentGenericsInParams() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multimodule/duplicateMethod/differentGenericsInParams.kt");
                }

                @Test
                @TestMetadata("differentNumberOfParams.kt")
                public void testDifferentNumberOfParams() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multimodule/duplicateMethod/differentNumberOfParams.kt");
                }

                @Test
                @TestMetadata("differentReturnTypes.kt")
                public void testDifferentReturnTypes() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multimodule/duplicateMethod/differentReturnTypes.kt");
                }

                @Test
                @TestMetadata("extensionMatch.kt")
                public void testExtensionMatch() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multimodule/duplicateMethod/extensionMatch.kt");
                }

                @Test
                @TestMetadata("functionGenericsInParams.kt")
                public void testFunctionGenericsInParams() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multimodule/duplicateMethod/functionGenericsInParams.kt");
                }

                @Test
                @TestMetadata("functionGenericsInParamsBoundsMismatch.kt")
                public void testFunctionGenericsInParamsBoundsMismatch() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multimodule/duplicateMethod/functionGenericsInParamsBoundsMismatch.kt");
                }

                @Test
                @TestMetadata("functionGenericsInParamsEqNull.kt")
                public void testFunctionGenericsInParamsEqNull() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multimodule/duplicateMethod/functionGenericsInParamsEqNull.kt");
                }

                @Test
                @TestMetadata("functionGenericsInParamsNotIs.kt")
                public void testFunctionGenericsInParamsNotIs() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multimodule/duplicateMethod/functionGenericsInParamsNotIs.kt");
                }

                @Test
                @TestMetadata("functionGenericsInParamsReturnFooT.kt")
                public void testFunctionGenericsInParamsReturnFooT() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multimodule/duplicateMethod/functionGenericsInParamsReturnFooT.kt");
                }

                @Test
                @TestMetadata("functionGenericsInParamsReturnT.kt")
                public void testFunctionGenericsInParamsReturnT() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multimodule/duplicateMethod/functionGenericsInParamsReturnT.kt");
                }

                @Test
                @TestMetadata("incompleteCodeNoNoneApplicable.kt")
                public void testIncompleteCodeNoNoneApplicable() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multimodule/duplicateMethod/incompleteCodeNoNoneApplicable.kt");
                }

                @Test
                @TestMetadata("noGenericsInParams.kt")
                public void testNoGenericsInParams() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multimodule/duplicateMethod/noGenericsInParams.kt");
                }

                @Test
                @TestMetadata("noParams.kt")
                public void testNoParams() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multimodule/duplicateMethod/noParams.kt");
                }

                @Test
                @TestMetadata("sameGenericsInParams.kt")
                public void testSameGenericsInParams() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multimodule/duplicateMethod/sameGenericsInParams.kt");
                }

                @Test
                @TestMetadata("simpleWithInheritance.kt")
                public void testSimpleWithInheritance() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multimodule/duplicateMethod/simpleWithInheritance.kt");
                }

                @Test
                @TestMetadata("sinceKotlin.kt")
                public void testSinceKotlin() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multimodule/duplicateMethod/sinceKotlin.kt");
                }

                @Test
                @TestMetadata("substitutedGenericInParams.kt")
                public void testSubstitutedGenericInParams() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multimodule/duplicateMethod/substitutedGenericInParams.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/multimodule/duplicateSuper")
            @TestDataPath("$PROJECT_ROOT")
            public class DuplicateSuper {
                @Test
                public void testAllFilesPresentInDuplicateSuper() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/multimodule/duplicateSuper"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("differentSuperTraits.kt")
                public void testDifferentSuperTraits() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multimodule/duplicateSuper/differentSuperTraits.kt");
                }

                @Test
                @TestMetadata("sameSuperTrait.kt")
                public void testSameSuperTrait() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multimodule/duplicateSuper/sameSuperTrait.kt");
                }

                @Test
                @TestMetadata("sameSuperTraitDifferentBounds.kt")
                public void testSameSuperTraitDifferentBounds() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multimodule/duplicateSuper/sameSuperTraitDifferentBounds.kt");
                }

                @Test
                @TestMetadata("sameSuperTraitGenerics.kt")
                public void testSameSuperTraitGenerics() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multimodule/duplicateSuper/sameSuperTraitGenerics.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/multimodule/hiddenClass")
            @TestDataPath("$PROJECT_ROOT")
            public class HiddenClass {
                @Test
                public void testAllFilesPresentInHiddenClass() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/multimodule/hiddenClass"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("deprecatedHiddenImportPriority.kt")
                public void testDeprecatedHiddenImportPriority() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multimodule/hiddenClass/deprecatedHiddenImportPriority.kt");
                }

                @Test
                @TestMetadata("deprecatedHiddenMultipleClasses.kt")
                public void testDeprecatedHiddenMultipleClasses() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multimodule/hiddenClass/deprecatedHiddenMultipleClasses.kt");
                }

                @Test
                @TestMetadata("sinceKotlinImportPriority.kt")
                public void testSinceKotlinImportPriority() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multimodule/hiddenClass/sinceKotlinImportPriority.kt");
                }

                @Test
                @TestMetadata("sinceKotlinMultipleClasses.kt")
                public void testSinceKotlinMultipleClasses() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multimodule/hiddenClass/sinceKotlinMultipleClasses.kt");
                }
            }
        }

        @Nested
        @TestMetadata("compiler/testData/diagnostics/tests/multiplatform")
        @TestDataPath("$PROJECT_ROOT")
        public class Multiplatform {
            @Test
            public void testAllFilesPresentInMultiplatform() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/multiplatform"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
            }

            @Test
            @TestMetadata("expectInterfaceApplicability.kt")
            public void testExpectInterfaceApplicability() throws Exception {
                runTest("compiler/testData/diagnostics/tests/multiplatform/expectInterfaceApplicability.kt");
            }

            @Test
            @TestMetadata("expectObjectWithAbstractMember.kt")
            public void testExpectObjectWithAbstractMember() throws Exception {
                runTest("compiler/testData/diagnostics/tests/multiplatform/expectObjectWithAbstractMember.kt");
            }

            @Test
            @TestMetadata("headerFunInNonHeaderClass.kt")
            public void testHeaderFunInNonHeaderClass() throws Exception {
                runTest("compiler/testData/diagnostics/tests/multiplatform/headerFunInNonHeaderClass.kt");
            }

            @Test
            @TestMetadata("implDelegatedMember.kt")
            public void testImplDelegatedMember() throws Exception {
                runTest("compiler/testData/diagnostics/tests/multiplatform/implDelegatedMember.kt");
            }

            @Test
            @TestMetadata("implDynamic.kt")
            public void testImplDynamic() throws Exception {
                runTest("compiler/testData/diagnostics/tests/multiplatform/implDynamic.kt");
            }

            @Test
            @TestMetadata("implFakeOverride.kt")
            public void testImplFakeOverride() throws Exception {
                runTest("compiler/testData/diagnostics/tests/multiplatform/implFakeOverride.kt");
            }

            @Test
            @TestMetadata("incompatibles.kt")
            public void testIncompatibles() throws Exception {
                runTest("compiler/testData/diagnostics/tests/multiplatform/incompatibles.kt");
            }

            @Test
            @TestMetadata("modifierApplicability.kt")
            public void testModifierApplicability() throws Exception {
                runTest("compiler/testData/diagnostics/tests/multiplatform/modifierApplicability.kt");
            }

            @Test
            @TestMetadata("namedArguments.kt")
            public void testNamedArguments() throws Exception {
                runTest("compiler/testData/diagnostics/tests/multiplatform/namedArguments.kt");
            }

            @Test
            @TestMetadata("privateTopLevelDeclarations.kt")
            public void testPrivateTopLevelDeclarations() throws Exception {
                runTest("compiler/testData/diagnostics/tests/multiplatform/privateTopLevelDeclarations.kt");
            }

            @Test
            @TestMetadata("sealedTypeAlias.kt")
            public void testSealedTypeAlias() throws Exception {
                runTest("compiler/testData/diagnostics/tests/multiplatform/sealedTypeAlias.kt");
            }

            @Test
            @TestMetadata("sealedTypeAliasTopLevel.kt")
            public void testSealedTypeAliasTopLevel() throws Exception {
                runTest("compiler/testData/diagnostics/tests/multiplatform/sealedTypeAliasTopLevel.kt");
            }

            @Test
            @TestMetadata("smartcastOnMemberPropertyFromCommonClass.kt")
            public void testSmartcastOnMemberPropertyFromCommonClass() throws Exception {
                runTest("compiler/testData/diagnostics/tests/multiplatform/smartcastOnMemberPropertyFromCommonClass.kt");
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/multiplatform/defaultArguments")
            @TestDataPath("$PROJECT_ROOT")
            public class DefaultArguments {
                @Test
                public void testAllFilesPresentInDefaultArguments() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/multiplatform/defaultArguments"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("annotationArgumentEquality.kt")
                public void testAnnotationArgumentEquality() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/defaultArguments/annotationArgumentEquality.kt");
                }

                @Test
                @TestMetadata("annotations.kt")
                public void testAnnotations() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/defaultArguments/annotations.kt");
                }

                @Test
                @TestMetadata("annotationsViaActualTypeAlias.kt")
                public void testAnnotationsViaActualTypeAlias() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/defaultArguments/annotationsViaActualTypeAlias.kt");
                }

                @Test
                @TestMetadata("annotationsViaActualTypeAlias2.kt")
                public void testAnnotationsViaActualTypeAlias2() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/defaultArguments/annotationsViaActualTypeAlias2.kt");
                }

                @Test
                @TestMetadata("constructor.kt")
                public void testConstructor() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/defaultArguments/constructor.kt");
                }

                @Test
                @TestMetadata("expectedDeclaresDefaultArguments.kt")
                public void testExpectedDeclaresDefaultArguments() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/defaultArguments/expectedDeclaresDefaultArguments.kt");
                }

                @Test
                @TestMetadata("expectedInheritsDefaultArguments.kt")
                public void testExpectedInheritsDefaultArguments() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/defaultArguments/expectedInheritsDefaultArguments.kt");
                }

                @Test
                @TestMetadata("expectedVsNonExpectedWithDefaults.kt")
                public void testExpectedVsNonExpectedWithDefaults() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/defaultArguments/expectedVsNonExpectedWithDefaults.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/multiplatform/deprecated")
            @TestDataPath("$PROJECT_ROOT")
            public class Deprecated {
                @Test
                public void testAllFilesPresentInDeprecated() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/multiplatform/deprecated"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("header.kt")
                public void testHeader() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/deprecated/header.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/multiplatform/enum")
            @TestDataPath("$PROJECT_ROOT")
            public class Enum {
                @Test
                @TestMetadata("additionalEntriesInImpl.kt")
                public void testAdditionalEntriesInImpl() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/enum/additionalEntriesInImpl.kt");
                }

                @Test
                public void testAllFilesPresentInEnum() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/multiplatform/enum"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("constructorInHeaderEnum.kt")
                public void testConstructorInHeaderEnum() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/enum/constructorInHeaderEnum.kt");
                }

                @Test
                @TestMetadata("differentEntryOrder.kt")
                public void testDifferentEntryOrder() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/enum/differentEntryOrder.kt");
                }

                @Test
                @TestMetadata("enumEntryWithBody.kt")
                public void testEnumEntryWithBody() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/enum/enumEntryWithBody.kt");
                }

                @Test
                @TestMetadata("javaEnum.kt")
                public void testJavaEnum() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/enum/javaEnum.kt");
                }

                @Test
                @TestMetadata("simpleEnum.kt")
                public void testSimpleEnum() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/enum/simpleEnum.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/multiplatform/exhaustiveness")
            @TestDataPath("$PROJECT_ROOT")
            public class Exhaustiveness {
                @Test
                public void testAllFilesPresentInExhaustiveness() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/multiplatform/exhaustiveness"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("commonSealedWithPlatformInheritor.kt")
                public void testCommonSealedWithPlatformInheritor() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/exhaustiveness/commonSealedWithPlatformInheritor.kt");
                }

                @Test
                @TestMetadata("expectEnum.kt")
                public void testExpectEnum() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/exhaustiveness/expectEnum.kt");
                }

                @Test
                @TestMetadata("expectSealedClass.kt")
                public void testExpectSealedClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/exhaustiveness/expectSealedClass.kt");
                }

                @Test
                @TestMetadata("expectSealedClassWithActualTypealias.kt")
                public void testExpectSealedClassWithActualTypealias() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/exhaustiveness/expectSealedClassWithActualTypealias.kt");
                }

                @Test
                @TestMetadata("expectSealedInterface.kt")
                public void testExpectSealedInterface() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/exhaustiveness/expectSealedInterface.kt");
                }

                @Test
                @TestMetadata("kt45796.kt")
                public void testKt45796() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/exhaustiveness/kt45796.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/multiplatform/generic")
            @TestDataPath("$PROJECT_ROOT")
            public class Generic {
                @Test
                public void testAllFilesPresentInGeneric() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/multiplatform/generic"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("functionTypeParameterBounds.kt")
                public void testFunctionTypeParameterBounds() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/generic/functionTypeParameterBounds.kt");
                }

                @Test
                @TestMetadata("genericMemberBounds.kt")
                public void testGenericMemberBounds() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/generic/genericMemberBounds.kt");
                }

                @Test
                @TestMetadata("membersInGenericClass.kt")
                public void testMembersInGenericClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/generic/membersInGenericClass.kt");
                }

                @Test
                @TestMetadata("typeParameterBoundsDifferentOrderActualMissing.kt")
                public void testTypeParameterBoundsDifferentOrderActualMissing() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/generic/typeParameterBoundsDifferentOrderActualMissing.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/multiplatform/headerClass")
            @TestDataPath("$PROJECT_ROOT")
            public class HeaderClass {
                @Test
                @TestMetadata("actualClassWithDefaultValuesInAnnotationViaTypealias.kt")
                public void testActualClassWithDefaultValuesInAnnotationViaTypealias() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/headerClass/actualClassWithDefaultValuesInAnnotationViaTypealias.kt");
                }

                @Test
                @TestMetadata("actualClassWithDifferentConstructors.kt")
                public void testActualClassWithDifferentConstructors() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/headerClass/actualClassWithDifferentConstructors.kt");
                }

                @Test
                @TestMetadata("actualMissing.kt")
                public void testActualMissing() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/headerClass/actualMissing.kt");
                }

                @Test
                public void testAllFilesPresentInHeaderClass() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/multiplatform/headerClass"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("baseExpectClassWithoutConstructor.kt")
                public void testBaseExpectClassWithoutConstructor() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/headerClass/baseExpectClassWithoutConstructor.kt");
                }

                @Test
                @TestMetadata("classKinds.kt")
                public void testClassKinds() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/headerClass/classKinds.kt");
                }

                @Test
                @TestMetadata("dontOverrideMethodsFromInterfaceInCommonCode.kt")
                public void testDontOverrideMethodsFromInterfaceInCommonCode() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/headerClass/dontOverrideMethodsFromInterfaceInCommonCode.kt");
                }

                @Test
                @TestMetadata("equalsOverrideInActualInterface.kt")
                public void testEqualsOverrideInActualInterface() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/headerClass/equalsOverrideInActualInterface.kt");
                }

                @Test
                @TestMetadata("expectClassWithExplicitAbstractMember.kt")
                public void testExpectClassWithExplicitAbstractMember() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/headerClass/expectClassWithExplicitAbstractMember.kt");
                }

                @Test
                @TestMetadata("expectClassWithoutConstructor.kt")
                public void testExpectClassWithoutConstructor() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/headerClass/expectClassWithoutConstructor.kt");
                }

                @Test
                @TestMetadata("expectDeclarationWithStrongIncompatibilities.kt")
                public void testExpectDeclarationWithStrongIncompatibilities() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/headerClass/expectDeclarationWithStrongIncompatibilities.kt");
                }

                @Test
                @TestMetadata("expectDeclarationWithWeakIncompatibilities.kt")
                public void testExpectDeclarationWithWeakIncompatibilities() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/headerClass/expectDeclarationWithWeakIncompatibilities.kt");
                }

                @Test
                @TestMetadata("expectFinalActualOpen.kt")
                public void testExpectFinalActualOpen() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/headerClass/expectFinalActualOpen.kt");
                }

                @Test
                @TestMetadata("explicitConstructorDelegation.kt")
                public void testExplicitConstructorDelegation() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/headerClass/explicitConstructorDelegation.kt");
                }

                @Test
                @TestMetadata("extendExpectedClassWithAbstractMember.kt")
                public void testExtendExpectedClassWithAbstractMember() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/headerClass/extendExpectedClassWithAbstractMember.kt");
                }

                @Test
                @TestMetadata("extendExpectedClassWithoutExplicitOverrideOfMethod.kt")
                public void testExtendExpectedClassWithoutExplicitOverrideOfMethod() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/headerClass/extendExpectedClassWithoutExplicitOverrideOfMethod.kt");
                }

                @Test
                @TestMetadata("extraHeaderOnMembers.kt")
                public void testExtraHeaderOnMembers() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/headerClass/extraHeaderOnMembers.kt");
                }

                @Test
                @TestMetadata("functionAndPropertyWithSameName.kt")
                public void testFunctionAndPropertyWithSameName() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/headerClass/functionAndPropertyWithSameName.kt");
                }

                @Test
                @TestMetadata("genericClassImplTypeAlias.kt")
                public void testGenericClassImplTypeAlias() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/headerClass/genericClassImplTypeAlias.kt");
                }

                @Test
                @TestMetadata("headerClassMember.kt")
                public void testHeaderClassMember() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/headerClass/headerClassMember.kt");
                }

                @Test
                @TestMetadata("headerClassWithFunctionBody.kt")
                public void testHeaderClassWithFunctionBody() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/headerClass/headerClassWithFunctionBody.kt");
                }

                @Test
                @TestMetadata("implDataClass.kt")
                public void testImplDataClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/headerClass/implDataClass.kt");
                }

                @Test
                @TestMetadata("implOpenClass.kt")
                public void testImplOpenClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/headerClass/implOpenClass.kt");
                }

                @Test
                @TestMetadata("inheritanceByDelegationInExpectClass.kt")
                public void testInheritanceByDelegationInExpectClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/headerClass/inheritanceByDelegationInExpectClass.kt");
                }

                @Test
                @TestMetadata("memberPropertyKinds.kt")
                public void testMemberPropertyKinds() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/headerClass/memberPropertyKinds.kt");
                }

                @Test
                @TestMetadata("modalityCheckForExplicitAndImplicitOverride.kt")
                public void testModalityCheckForExplicitAndImplicitOverride() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/headerClass/modalityCheckForExplicitAndImplicitOverride.kt");
                }

                @Test
                @TestMetadata("morePermissiveVisibilityOnActual.kt")
                public void testMorePermissiveVisibilityOnActual() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/headerClass/morePermissiveVisibilityOnActual.kt");
                }

                @Test
                @TestMetadata("morePermissiveVisibilityOnActualViaTypeAlias.kt")
                public void testMorePermissiveVisibilityOnActualViaTypeAlias() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/headerClass/morePermissiveVisibilityOnActualViaTypeAlias.kt");
                }

                @Test
                @TestMetadata("nestedClasses.kt")
                public void testNestedClasses() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/headerClass/nestedClasses.kt");
                }

                @Test
                @TestMetadata("nestedClassesWithErrors.kt")
                public void testNestedClassesWithErrors() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/headerClass/nestedClassesWithErrors.kt");
                }

                @Test
                @TestMetadata("noImplKeywordOnMember.kt")
                public void testNoImplKeywordOnMember() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/headerClass/noImplKeywordOnMember.kt");
                }

                @Test
                @TestMetadata("privateMembers.kt")
                public void testPrivateMembers() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/headerClass/privateMembers.kt");
                }

                @Test
                @TestMetadata("simpleHeaderClass.kt")
                public void testSimpleHeaderClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/headerClass/simpleHeaderClass.kt");
                }

                @Test
                @TestMetadata("smartCastOnExpectClass.kt")
                public void testSmartCastOnExpectClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/headerClass/smartCastOnExpectClass.kt");
                }

                @Test
                @TestMetadata("superClass.kt")
                public void testSuperClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/headerClass/superClass.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/multiplatform/hmpp")
            @TestDataPath("$PROJECT_ROOT")
            public class Hmpp {
                @Test
                public void testAllFilesPresentInHmpp() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/multiplatform/hmpp"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("sealedInheritorsInComplexModuleStructure.kt")
                public void testSealedInheritorsInComplexModuleStructure() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/hmpp/sealedInheritorsInComplexModuleStructure.kt");
                }

                @Test
                @TestMetadata("simple.kt")
                public void testSimple() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/hmpp/simple.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/multiplatform/inlineClasses")
            @TestDataPath("$PROJECT_ROOT")
            public class InlineClasses {
                @Test
                public void testAllFilesPresentInInlineClasses() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/multiplatform/inlineClasses"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("expectActualInlineClass.kt")
                public void testExpectActualInlineClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/inlineClasses/expectActualInlineClass.kt");
                }

                @Test
                @TestMetadata("jvmInlineExpectValueClass.kt")
                public void testJvmInlineExpectValueClass() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/inlineClasses/jvmInlineExpectValueClass.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/multiplatform/java")
            @TestDataPath("$PROJECT_ROOT")
            public class Java {
                @Test
                public void testAllFilesPresentInJava() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/multiplatform/java"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("flexibleTypes.kt")
                public void testFlexibleTypes() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/java/flexibleTypes.kt");
                }

                @Test
                @TestMetadata("parameterNames.kt")
                public void testParameterNames() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/java/parameterNames.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/multiplatform/topLevelFun")
            @TestDataPath("$PROJECT_ROOT")
            public class TopLevelFun {
                @Test
                public void testAllFilesPresentInTopLevelFun() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/multiplatform/topLevelFun"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("callHeaderFun.kt")
                public void testCallHeaderFun() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/topLevelFun/callHeaderFun.kt");
                }

                @Test
                @TestMetadata("callableReferenceOnExpectFun.kt")
                public void testCallableReferenceOnExpectFun() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/topLevelFun/callableReferenceOnExpectFun.kt");
                }

                @Test
                @TestMetadata("conflictingHeaderDeclarations.kt")
                public void testConflictingHeaderDeclarations() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/topLevelFun/conflictingHeaderDeclarations.kt");
                }

                @Test
                @TestMetadata("conflictingImplDeclarations.kt")
                public void testConflictingImplDeclarations() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/topLevelFun/conflictingImplDeclarations.kt");
                }

                @Test
                @TestMetadata("functionModifiers.kt")
                public void testFunctionModifiers() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/topLevelFun/functionModifiers.kt");
                }

                @Test
                @TestMetadata("headerAndImplInDIfferentPackages.kt")
                public void testHeaderAndImplInDIfferentPackages() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/topLevelFun/headerAndImplInDIfferentPackages.kt");
                }

                @Test
                @TestMetadata("headerDeclarationWithBody.kt")
                public void testHeaderDeclarationWithBody() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/topLevelFun/headerDeclarationWithBody.kt");
                }

                @Test
                @TestMetadata("headerWithoutImpl.kt")
                public void testHeaderWithoutImpl() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/topLevelFun/headerWithoutImpl.kt");
                }

                @Test
                @TestMetadata("implDeclarationWithoutBody.kt")
                public void testImplDeclarationWithoutBody() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/topLevelFun/implDeclarationWithoutBody.kt");
                }

                @Test
                @TestMetadata("implWithoutHeader.kt")
                public void testImplWithoutHeader() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/topLevelFun/implWithoutHeader.kt");
                }

                @Test
                @TestMetadata("inlineFun.kt")
                public void testInlineFun() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/topLevelFun/inlineFun.kt");
                }

                @Test
                @TestMetadata("simpleHeaderFun.kt")
                public void testSimpleHeaderFun() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/topLevelFun/simpleHeaderFun.kt");
                }

                @Test
                @TestMetadata("valueParameterModifiers.kt")
                public void testValueParameterModifiers() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/topLevelFun/valueParameterModifiers.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/multiplatform/topLevelProperty")
            @TestDataPath("$PROJECT_ROOT")
            public class TopLevelProperty {
                @Test
                public void testAllFilesPresentInTopLevelProperty() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/multiplatform/topLevelProperty"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("differentKindsOfProperties.kt")
                public void testDifferentKindsOfProperties() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/topLevelProperty/differentKindsOfProperties.kt");
                }

                @Test
                @TestMetadata("simpleHeaderVar.kt")
                public void testSimpleHeaderVar() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/multiplatform/topLevelProperty/simpleHeaderVar.kt");
                }
            }
        }

        @Nested
        @TestMetadata("compiler/testData/diagnostics/tests/namedArguments")
        @TestDataPath("$PROJECT_ROOT")
        public class NamedArguments {
            @Test
            public void testAllFilesPresentInNamedArguments() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/namedArguments"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
            }

            @Test
            @TestMetadata("allowForJavaAnnotation.kt")
            public void testAllowForJavaAnnotation() throws Exception {
                runTest("compiler/testData/diagnostics/tests/namedArguments/allowForJavaAnnotation.kt");
            }

            @Test
            @TestMetadata("ambiguousNamedArguments1.kt")
            public void testAmbiguousNamedArguments1() throws Exception {
                runTest("compiler/testData/diagnostics/tests/namedArguments/ambiguousNamedArguments1.kt");
            }

            @Test
            @TestMetadata("ambiguousNamedArguments2.kt")
            public void testAmbiguousNamedArguments2() throws Exception {
                runTest("compiler/testData/diagnostics/tests/namedArguments/ambiguousNamedArguments2.kt");
            }

            @Test
            @TestMetadata("ambiguousNamedArgumentsWithGenerics1.kt")
            public void testAmbiguousNamedArgumentsWithGenerics1() throws Exception {
                runTest("compiler/testData/diagnostics/tests/namedArguments/ambiguousNamedArgumentsWithGenerics1.kt");
            }

            @Test
            @TestMetadata("ambiguousNamedArgumentsWithGenerics2.kt")
            public void testAmbiguousNamedArgumentsWithGenerics2() throws Exception {
                runTest("compiler/testData/diagnostics/tests/namedArguments/ambiguousNamedArgumentsWithGenerics2.kt");
            }

            @Test
            @TestMetadata("ambiguousNamedArgumentsWithGenerics3.kt")
            public void testAmbiguousNamedArgumentsWithGenerics3() throws Exception {
                runTest("compiler/testData/diagnostics/tests/namedArguments/ambiguousNamedArgumentsWithGenerics3.kt");
            }

            @Test
            @TestMetadata("disallowForJavaConstructor.kt")
            public void testDisallowForJavaConstructor() throws Exception {
                runTest("compiler/testData/diagnostics/tests/namedArguments/disallowForJavaConstructor.kt");
            }

            @Test
            @TestMetadata("disallowForJavaMethods.kt")
            public void testDisallowForJavaMethods() throws Exception {
                runTest("compiler/testData/diagnostics/tests/namedArguments/disallowForJavaMethods.kt");
            }

            @Test
            @TestMetadata("disallowForSamAdapterConstructor.kt")
            public void testDisallowForSamAdapterConstructor() throws Exception {
                runTest("compiler/testData/diagnostics/tests/namedArguments/disallowForSamAdapterConstructor.kt");
            }

            @Test
            @TestMetadata("disallowForSamAdapterFunction.kt")
            public void testDisallowForSamAdapterFunction() throws Exception {
                runTest("compiler/testData/diagnostics/tests/namedArguments/disallowForSamAdapterFunction.kt");
            }

            @Test
            @TestMetadata("namedArgumentsAndDefaultValues.kt")
            public void testNamedArgumentsAndDefaultValues() throws Exception {
                runTest("compiler/testData/diagnostics/tests/namedArguments/namedArgumentsAndDefaultValues.kt");
            }

            @Test
            @TestMetadata("namedArgumentsInOverloads.kt")
            public void testNamedArgumentsInOverloads() throws Exception {
                runTest("compiler/testData/diagnostics/tests/namedArguments/namedArgumentsInOverloads.kt");
            }

            @Test
            @TestMetadata("namedArgumentsInOverrides.kt")
            public void testNamedArgumentsInOverrides() throws Exception {
                runTest("compiler/testData/diagnostics/tests/namedArguments/namedArgumentsInOverrides.kt");
            }

            @Nested
            @TestMetadata("compiler/testData/diagnostics/tests/namedArguments/mixedNamedPosition")
            @TestDataPath("$PROJECT_ROOT")
            public class MixedNamedPosition {
                @Test
                public void testAllFilesPresentInMixedNamedPosition() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/namedArguments/mixedNamedPosition"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
                }

                @Test
                @TestMetadata("defaults.kt")
                public void testDefaults() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/namedArguments/mixedNamedPosition/defaults.kt");
                }

                @Test
                @TestMetadata("disabledFeature.kt")
                public void testDisabledFeature() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/namedArguments/mixedNamedPosition/disabledFeature.kt");
                }

                @Test
                @TestMetadata("oldInference.kt")
                public void testOldInference() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/namedArguments/mixedNamedPosition/oldInference.kt");
                }

                @Test
                @TestMetadata("secondNamed.kt")
                public void testSecondNamed() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/namedArguments/mixedNamedPosition/secondNamed.kt");
                }

                @Test
                @TestMetadata("simple.kt")
                public void testSimple() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/namedArguments/mixedNamedPosition/simple.kt");
                }

                @Test
                @TestMetadata("varargs.kt")
                public void testVarargs() throws Exception {
                    runTest("compiler/testData/diagnostics/tests/namedArguments/mixedNamedPosition/varargs.kt");
                }
            }
        }

        @Nested
        @TestMetadata("compiler/testData/diagnostics/tests/nullabilityAndSmartCasts")
        @TestDataPath("$PROJECT_ROOT")
        public class NullabilityAndSmartCasts {
            @Test
            public void testAllFilesPresentInNullabilityAndSmartCasts() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/tests/nullabilityAndSmartCasts"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.fir\\.kts?$"), true);
            }

            @Test
            @TestMetadata("AssertNotNull.kt")
            public void testAssertNotNull() throws Exception {
                runTest("compiler/testData/diagnostics/tests/nullabilityAndSmartCasts/AssertNotNull.kt");
            }

            @Test
            @TestMetadata("augmentedAssignment.kt")
            publi