// !API_VERSION: 1.5
// !LANGUAGE: +JvmRecordSupport
// ENABLE_JVM_PREVIEW
// IGNORE_BACKEND_FIR: JVM_IR
// !JVM_DEFAULT_MODE: enable

// FILE: JavaClass.java
public class JavaClass {
    public static String box() {
        MyRec m = new MyRec<String>("O", "K");
        KI<String> ki = m;
        return m.x() + m.y() + ki.getX() + ki.getY();
    }
}
// FILE: main.kt

interface KI<T> {
    val x: String get() = ""
    val y: T
}

@JvmRecord
data class MyRec<R>(override val x: String, override val y: R) : KI<R>

fun box(): String {
    val res = JavaClass.box()
    if (res != "OKOK") return "fail 1: $res"
    return "OK"
}
