// FILE: 1.kt
package test

@Suppress("INVISIBLE_MEMBER", "INVISIBLE_REFERENCE")
@kotlin.internal.InlineOnly
inline fun <T, R> T.myLet(block: (T) -> R) = block(this)

// FILE: 2.kt
import test.*

fun box(): String {
    // should not have any line numbers
    val k = "".myLet {
        it + "K"
    }
    return "O".myLet(fun (it: String): String {
        return it + k
    })
}

// See KT-23064 for the problem, InlineOnlySmapSkipper for an explanation, and
// `stdlibInlineOnlyOneLine.kt` for the case where something should actually happen.
