// IGNORE_BACKEND: JVM
// WITH_STDLIB

fun Char.hex() = toInt().toString(16)

fun box(): String {
    if (t.length != 39971) return "Failed: ${t.length} != 39971"

    var ssi = 0
    var si = 0
    var i = 0
    for (cht in t) {
        val chs = SS[ssi][si]
        if (chs != cht) return "Mismatch at $i: ${chs.hex()} != ${cht.hex()}"
        ++i
        ++si
        if (si >= SS[ssi].length) {
            si = 0
            ++ssi
        }
    }

    return "OK"
}

// This is some randomly generated sequence of reqular characters and proper suppogate pairs.
// It contains one surrogate pair that would be split at index 32766 
// if long string constant parts are limited to M = 65535/4 = 16383,
// and quite likely some others for other possible Ms.
// The test itself makes sure that we store strings in constant pool properly.

const val S0 = "\ud83c\udf09\uD83C\uDF10\uD83C\uDF10----\ud83c\udf09\ud83c\udf09----\uD83C\uDF10--\uD83C\uDF10\ud83c\udf09--\uD83C\uDF10\ud83c\udf09---\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09-------\ud83c\udf09-\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10--\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10---\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09--\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09"
const val S1 = "--\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10--\uD83C\uDF10\ud83c\udf09\uD83C\uDF10---\uD83C\uDF10\uD83C\uDF10\ud83c\udf09---\uD83C\uDF10\uD83C\uDF10---\ud83c\udf09\uD83C\uDF10--\ud83c\udf09-\ud83c\udf09\ud83c\udf09----\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10-\uD83C\uDF10--\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10--\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09-\ud83c\udf09\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10--\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09-\ud83c\udf09\uD83C\uDF10---\ud83c\udf09\ud83c\udf09\uD83C\uDF10---\uD83C\uDF10\ud83c\udf09----\uD83C\uDF10"
const val S2 = "\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10---\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09---\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\ud83c\udf09-\ud83c\udf09-\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10--\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10--\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09--\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10"
const val S3 = "\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10--\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10--\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09--\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09---\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10--\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10--\ud83c\udf09\uD83C\uDF10\ud83c\udf09--\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09"
const val S4 = "\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10--\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10--\ud83c\udf09----\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09--\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\ud83c\udf09-\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\ud83c\udf09---\ud83c\udf09\uD83C\uDF10--\ud83c\udf09\uD83C\uDF10"
const val S5 = "-\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09--\ud83c\udf09-\ud83c\udf09-\ud83c\udf09--\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09--\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10--\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10--\ud83c\udf09\ud83c\udf09-\ud83c\udf09-\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09--\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10--\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\ud83c\udf09"
const val S6 = "-\ud83c\udf09-\ud83c\udf09---\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09--\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09--\ud83c\udf09\ud83c\udf09\uD83C\uDF10--\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09-\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09---\uD83C\uDF10--\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10---\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\ud83c\udf09-\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09---\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09--\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10"
const val S7 = "\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09--\ud83c\udf09\ud83c\udf09----\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09-\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10---\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\ud83c\udf09-\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10--\ud83c\udf09\ud83c\udf09---\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10-\ud83c\udf09-\uD83C\uDF10--\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10--\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09---\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\ud83c\udf09"
const val S8 = "\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09--\ud83c\udf09--\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09---\uD83C\uDF10--\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09---\uD83C\uDF10\uD83C\uDF10--\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10--\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10--\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\uD83C\uDF10--\ud83c\udf09\ud83c\udf09-\ud83c\udf09-\uD83C\uDF10-\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10"
const val S9 = "-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10--\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\ud83c\udf09--\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10--\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09--\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10--\uD83C\uDF10\uD83C\uDF10--\uD83C\uDF10-\ud83c\udf09-----\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09----\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09"
const val S10 = "\uD83C\uDF10\ud83c\udf09--\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10--\ud83c\udf09-\ud83c\udf09-\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09-\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\ud83c\udf09-\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10---\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\uD83C\uDF10----\ud83c\udf09\ud83c\udf09---\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10--\ud83c\udf09\ud83c\udf09---\uD83C\uDF10\uD83C\uDF10"
const val S11 = "\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09\ud83c\udf09---\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10---\ud83c\udf09-\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09---\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09--\ud83c\udf09\ud83c\udf09"
const val S12 = "-\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09--\ud83c\udf09---\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10----\uD83C\uDF10\ud83c\udf09\uD83C\uDF10---\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\ud83c\udf09-\ud83c\udf09----\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10---\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\ud83c\udf09--\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10--\ud83c\udf09-\ud83c\udf09\ud83c\udf09-\ud83c\udf09-\ud83c\udf09--\uD83C\uDF10"
const val S13 = "\ud83c\udf09\ud83c\udf09-\ud83c\udf09----\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10-----\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09---\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10-\ud83c\udf09\ud83c\udf09--\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10-\uD83C\uDF10--\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\ud83c\udf09--\ud83c\udf09-\ud83c\udf09\ud83c\udf09-\uD83C\uDF10--\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09--\ud83c\udf09\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09"
const val S14 = "--\ud83c\udf09-\ud83c\udf09----\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09--\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09---\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10--\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09---\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10--\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10"
const val S15 = "--\ud83c\udf09-\ud83c\udf09-\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09--\uD83C\uDF10-\uD83C\uDF10---\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10--\uD83C\uDF10\uD83C\uDF10--\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10---\ud83c\udf09-\ud83c\udf09\uD83C\uDF10---\ud83c\udf09\uD83C\uDF10--\uD83C\uDF10\ud83c\udf09\uD83C\uDF10--\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\ud83c\udf09--\ud83c\udf09-\ud83c\udf09--\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\ud83c\udf09-\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10--\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10--\ud83c\udf09--\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09------\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09"
const val S16 = "-\uD83C\uDF10\ud83c\udf09\ud83c\udf09---\ud83c\udf09\ud83c\udf09\ud83c\udf09--\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09--\uD83C\uDF10--\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10--\ud83c\udf09\ud83c\udf09\ud83c\udf09--\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10--\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10---\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\ud83c\udf09--\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10"
const val S17 = "--\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\ud83c\udf09--\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09--\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\uD83C\uDF10--\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\ud83c\udf09------\uD83C\uDF10\ud83c\udf09--\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09-\uD83C\uDF10--\ud83c\udf09\ud83c\udf09\ud83c\udf09--\ud83c\udf09-\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10--\uD83C\uDF10\ud83c\udf09--\uD83C\uDF10\uD83C\uDF10\ud83c\udf09----\uD83C\uDF10\ud83c\udf09--\uD83C\uDF10"
const val S18 = "\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10--\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10--\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-----\ud83c\udf09\ud83c\udf09-\uD83C\uDF10-\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10--\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\ud83c\udf09---\uD83C\uDF10\uD83C\uDF10"
const val S19 = "\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\ud83c\udf09-\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09-\ud83c\udf09--\ud83c\udf09\uD83C\uDF10-\ud83c\udf09-\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09---\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\ud83c\udf09---\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09-\ud83c\udf09\ud83c\udf09\ud83c\udf09--\uD83C\uDF10----\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09-\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10--\uD83C\uDF10\uD83C\uDF10--\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10"
const val S20 = "-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09---\ud83c\udf09\uD83C\uDF10--\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10----\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09--\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10--\ud83c\udf09-\ud83c\udf09-\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10--\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10--\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09------\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\ud83c\udf09---\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\ud83c\udf09"
const val S21 = "--\ud83c\udf09\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09--\uD83C\uDF10\ud83c\udf09---\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\ud83c\udf09-\ud83c\udf09--\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09---\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\ud83c\udf09--\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10--\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09--\ud83c\udf09\uD83C\uDF10\uD83C\uDF10--\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10---\uD83C\uDF10--\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09--\uD83C\uDF10\uD83C\uDF10\ud83c\udf09"
const val S22 = "\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\ud83c\udf09-\ud83c\udf09-----\ud83c\udf09-\ud83c\udf09\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\ud83c\udf09---\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10--\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09--\uD83C\uDF10-\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\ud83c\udf09-\uD83C\uDF10-\ud83c\udf09--\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10--\uD83C\uDF10-\ud83c\udf09-\uD83C\uDF10----\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10"
const val S23 = "---\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10---\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09--\ud83c\udf09--\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\ud83c\udf09--\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\ud83c\udf09---\uD83C\uDF10\uD83C\uDF10--\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10--\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\ud83c\udf09-\ud83c\udf09-\uD83C\uDF10--\uD83C\uDF10\ud83c\udf09--\uD83C\uDF10\ud83c\udf09--\uD83C\uDF10--\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09--\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10"
const val S24 = "\ud83c\udf09\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09--\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\ud83c\udf09--\ud83c\udf09--\uD83C\uDF10\ud83c\udf09--\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10--\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09-\ud83c\udf09-\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10--\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09----\ud83c\udf09--\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10--\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10--\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09"
const val S25 = "-\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09--\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09----\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\ud83c\udf09---\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10--\uD83C\uDF10-\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09--\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09---\ud83c\udf09-\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09-----\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10"
const val S26 = "\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09----\uD83C\uDF10-----\uD83C\uDF10-\uD83C\uDF10---\uD83C\uDF10\ud83c\udf09\ud83c\udf09--\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10--\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09---\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\ud83c\udf09-\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\ud83c\udf09-\uD83C\uDF10"
const val S27 = "-\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09\ud83c\udf09---\uD83C\uDF10\ud83c\udf09---\ud83c\udf09---\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09--\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09--\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09----\ud83c\udf09-\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10-\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10----\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10---\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09--"
const val S28 = "---\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10--\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09-\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10--\uD83C\uDF10\uD83C\uDF10--\ud83c\udf09--\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10---\ud83c\udf09---\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10--\ud83c\udf09\uD83C\uDF10--\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\ud83c\udf09\uD83C\uDF10"
const val S29 = "\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\ud83c\udf09--\uD83C\uDF10-\uD83C\uDF10-----\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10--\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09--\uD83C\uDF10\ud83c\udf09---\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10--\ud83c\udf09\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\ud83c\udf09---\ud83c\udf09----\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10"
const val S30 = "\ud83c\udf09---\uD83C\uDF10\uD83C\uDF10--\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\uD83C\uDF10--\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09-\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09--\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10---\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10--\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10"
const val S31 = "\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10--\uD83C\uDF10\uD83C\uDF10\ud83c\udf09--\ud83c\udf09-\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10--\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10---\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09--\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10--\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\ud83c\udf09--\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09---\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10"
const val S32 = "\ud83c\udf09-\uD83C\uDF10-\ud83c\udf09--\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\ud83c\udf09-\uD83C\uDF10\ud83c\udf09---\ud83c\udf09-\ud83c\udf09---\uD83C\uDF10--\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\ud83c\udf09--\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10--\ud83c\udf09-\uD83C\uDF10-\ud83c\udf09-\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\ud83c\udf09--\ud83c\udf09\uD83C\uDF10--\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10--\ud83c\udf09-----\uD83C\uDF10-\uD83C\uDF10--\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\ud83c\udf09"
const val S33 = "-\ud83c\udf09\ud83c\udf09\uD83C\uDF10--\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09--\ud83c\udf09-\ud83c\udf09\uD83C\uDF10---\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10--\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09--\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09---\ud83c\udf09\ud83c\udf09-\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\ud83c\udf09---\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10-\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09--\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09--\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10--\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10---\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10--\uD83C\uDF10\ud83c\udf09\uD83C\uDF10--\uD83C\uDF10\ud83c\udf09"
const val S34 = "\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10----\ud83c\udf09\ud83c\udf09--\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09---\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10--\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10--\ud83c\udf09\ud83c\udf09-\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\ud83c\udf09\uD83C\uDF10-\ud83c\udf09--\uD83C\uDF10---\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10--\ud83c\udf09\ud83c\udf09\uD83C\uDF10--\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10-\ud83c\udf09--\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10--\ud83c\udf09-\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09---\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09"
const val S35 = "\ud83c\udf09---\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09----\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09---\uD83C\uDF10-----------\uD83C\uDF10--\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09---\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09--\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09"
const val S36 = "\ud83c\udf09-\ud83c\udf09\ud83c\udf09-\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10---\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\ud83c\udf09--\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09--\ud83c\udf09--\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10--\ud83c\udf09-\ud83c\udf09--\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10"
const val S37 = "\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10--\ud83c\udf09---\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10--\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\ud83c\udf09-----\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09---\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\ud83c\udf09--\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10--\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\ud83c\udf09-\ud83c\udf09-\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10--\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10"
const val S38 = "\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09\ud83c\udf09---\uD83C\uDF10-\ud83c\udf09-\uD83C\uDF10-\ud83c\udf09\ud83c\udf09--\uD83C\uDF10-\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09--\uD83C\uDF10-\ud83c\udf09-\ud83c\udf09--\ud83c\udf09\uD83C\uDF10\ud83c\udf09--\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10----\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10--\ud83c\udf09\uD83C\uDF10-\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10--\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09---\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10---\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10--\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10--\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09"
const val S39 = "---\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09--\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10--\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\uD83C\uDF10---\uD83C\uDF10\uD83C\uDF10\ud83c\udf09--\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10--\ud83c\udf09\uD83C\uDF10--\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\ud83c\udf09--\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\ud83c\udf09-\ud83c\udf09-\uD83C\uDF10--"
const val S40 = "-\ud83c\udf09-\uD83C\uDF10-\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\ud83c\udf09--\uD83C\uDF10--\ud83c\udf09--\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09-----\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09--\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09--\ud83c\udf09\ud83c\udf09\ud83c\udf09--\uD83C\uDF10-\ud83c\udf09---\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\ud83c\udf09-\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10---\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10---\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10--\ud83c\udf09\uD83C\uDF10-\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10"
const val S41 = "\ud83c\udf09-\ud83c\udf09-----\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10---\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09--\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10--\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09-\ud83c\udf09--\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10---\ud83c\udf09---\uD83C\uDF10-\ud83c\udf09--\uD83C\uDF10\ud83c\udf09-\ud83c\udf09-\ud83c\udf09--\ud83c\udf09\uD83C\uDF10\ud83c\udf09----\ud83c\udf09-\ud83c\udf09--\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10--\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10"
const val S42 = "\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10-\uD83C\uDF10--\uD83C\uDF10-\ud83c\udf09---\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09-\uD83C\uDF10-\ud83c\udf09--\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10--\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09"
const val S43 = "-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10---\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\ud83c\udf09--\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10---\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10--\uD83C\uDF10\ud83c\udf09\uD83C\uDF10---\ud83c\udf09\ud83c\udf09-\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-----\ud83c\udf09\ud83c\udf09\ud83c\udf09--\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09---\uD83C\uDF10-\ud83c\udf09-\ud83c\udf09\ud83c\udf09--\uD83C\uDF10\uD83C\uDF10----\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09--\ud83c\udf09\ud83c\udf09"
const val S44 = "\ud83c\udf09\ud83c\udf09----\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09-\uD83C\uDF10---\ud83c\udf09\uD83C\uDF10-\ud83c\udf09----\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09--\ud83c\udf09-\ud83c\udf09-\uD83C\uDF10----\ud83c\udf09-\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\ud83c\udf09---\uD83C\uDF10----\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10--\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09-\ud83c\udf09-\ud83c\udf09\uD83C\uDF10"
const val S45 = "\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10--\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\ud83c\udf09-\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10--\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\uD83C\uDF10--\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09--\uD83C\uDF10\uD83C\uDF10--\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09--\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10--\uD83C\uDF10--\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10-\ud83c\udf09"
const val S46 = "-\uD83C\uDF10-\uD83C\uDF10--\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10-\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10----\ud83c\udf09-\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09--\ud83c\udf09-\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10--\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10--\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-----\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09--\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\ud83c\udf09-\ud83c\udf09-\ud83c\udf09--\uD83C\uDF10\ud83c\udf09"
const val S47 = "\uD83C\uDF10\ud83c\udf09--\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\ud83c\udf09--\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\ud83c\udf09-\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10---\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10---\ud83c\udf09--\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09--\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10--\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09--\ud83c\udf09\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10---\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09--\uD83C\uDF10--\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\ud83c\udf09"
const val S48 = "\ud83c\udf09--\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10-\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10---\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09--\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09-\ud83c\udf09-----\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09-\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10---\ud83c\udf09--\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\ud83c\udf09-\ud83c\udf09"
const val S49 = "-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10---\uD83C\uDF10--\uD83C\uDF10-\ud83c\udf09\ud83c\udf09-\ud83c\udf09-\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\ud83c\udf09--\uD83C\uDF10\ud83c\udf09\ud83c\udf09---\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10---\uD83C\uDF10-\uD83C\uDF10----\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09-\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10--\uD83C\uDF10----\uD83C\uDF10\ud83c\udf09--\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10---\uD83C\uDF10-\ud83c\udf09-\ud83c\udf09\ud83c\udf09"
const val S50 = "\uD83C\uDF10--\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10--\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10----\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09\ud83c\udf09---\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\ud83c\udf09-\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10--\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10"
const val S51 = "-\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09--\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10--\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10--\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\uD83C\uDF10--\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09---\uD83C\uDF10\ud83c\udf09-\ud83c\udf09-\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10"
const val S52 = "-\ud83c\udf09--\uD83C\uDF10\ud83c\udf09--\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\ud83c\udf09--\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09--\ud83c\udf09\uD83C\uDF10---\ud83c\udf09---\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09---\uD83C\uDF10---\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10--\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10--\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09"
const val S53 = "---\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\ud83c\udf09--\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10------\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\ud83c\udf09-\ud83c\udf09-\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10--\uD83C\uDF10\uD83C\uDF10\ud83c\udf09--\uD83C\uDF10\uD83C\uDF10\ud83c\udf09--\uD83C\uDF10-\ud83c\udf09-\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10---\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\ud83c\udf09---\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10"
const val S54 = "-\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10--\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10--\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-----\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09---\ud83c\udf09-\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10--\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10---\uD83C\uDF10---\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\ud83c\udf09--\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\ud83c\udf09-\uD83C\uDF10--\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09"
const val S55 = "\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\ud83c\udf09---\ud83c\udf09\uD83C\uDF10-\ud83c\udf09-\uD83C\uDF10--\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10--\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\ud83c\udf09--\uD83C\uDF10--\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10---\ud83c\udf09\ud83c\udf09\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09----\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\ud83c\udf09--\uD83C\uDF10\ud83c\udf09---\ud83c\udf09-\uD83C\uDF10"
const val S56 = "\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09--\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09--\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09--\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09-\uD83C\uDF10-\ud83c\udf09--\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10---\ud83c\udf09\ud83c\udf09\ud83c\udf09---\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09-\uD83C\uDF10-----\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10--\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10-----\ud83c\udf09--\ud83c\udf09\ud83c\udf09---\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09--\uD83C\uDF10-\ud83c\udf09"
const val S57 = "\ud83c\udf09-\ud83c\udf09--\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10--\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\ud83c\udf09--\ud83c\udf09--\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09--\uD83C\uDF10-\ud83c\udf09--"
const val S58 = "-\ud83c\udf09\ud83c\udf09\uD83C\uDF10--\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09--\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\ud83c\udf09--\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10--\ud83c\udf09-\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10--\ud83c\udf09-\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10--\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09---\ud83c\udf09-\ud83c\udf09-\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09--\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09--\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10--\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\ud83c\udf09"
const val S59 = "--\ud83c\udf09\ud83c\udf09-\uD83C\uDF10--\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09--\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\ud83c\udf09---\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\uD83C\uDF10--\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09-\uD83C\uDF10-\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10--\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\ud83c\udf09-\ud83c\udf09\ud83c\udf09--\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10---\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09"
const val S60 = "\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09--\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10--\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09---\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09--\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09-\uD83C\uDF10"
const val S61 = "\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09--\ud83c\udf09--\ud83c\udf09\uD83C\uDF10--\uD83C\uDF10-\ud83c\udf09-\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09------\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10--\ud83c\udf09\ud83c\udf09\uD83C\uDF10---\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10----\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09--\uD83C\uDF10--\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09----\ud83c\udf09\uD83C\uDF10\uD83C\uDF10---\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-"
const val S62 = "\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09----\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10---\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10-----\uD83C\uDF10--\ud83c\udf09\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10--\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10--\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09--\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09--\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09"
const val S63 = "-\ud83c\udf09--\ud83c\udf09-\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10--\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10-\ud83c\udf09----\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\ud83c\udf09--\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09-\ud83c\udf09--\ud83c\udf09\ud83c\udf09--\ud83c\udf09\uD83C\uDF10-\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\ud83c\udf09\uD83C\uDF10----\ud83c\udf09--\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09----\uD83C\uDF10-\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09\ud83c\udf09--\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09"
const val S64 = "\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09-\uD83C\uDF10--\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09--\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10--\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10----\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10--\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09--\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10"
const val S65 = "\ud83c\udf09--\uD83C\uDF10---\uD83C\uDF10\ud83c\udf09\ud83c\udf09--\ud83c\udf09\ud83c\udf09\ud83c\udf09--\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10--\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09--\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09--\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09--\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10--\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\uD83C\uDF10-\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\ud83c\udf09--\ud83c\udf09"
const val S66 = "-\ud83c\udf09--\ud83c\udf09-\uD83C\uDF10\ud83c\udf09---\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09----\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10--\uD83C\uDF10\ud83c\udf09\ud83c\udf09---\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10--\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09---\uD83C\uDF10---\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10"
const val S67 = "-\ud83c\udf09\uD83C\uDF10\ud83c\udf09--\ud83c\udf09-\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10--\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10---\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10--\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09"
const val S68 = "--\uD83C\uDF10--\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10--\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10--\uD83C\uDF10---\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09---\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\ud83c\udf09--\ud83c\udf09\uD83C\uDF10\ud83c\udf09--\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09-\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\ud83c\udf09---\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10---\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10--\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09"
const val S69 = "\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09\ud83c\udf09--\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09--\ud83c\udf09-\ud83c\udf09-\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10--\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10--\uD83C\uDF10--\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09--\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09--\uD83C\uDF10\uD83C\uDF10--\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10"
const val S70 = "---\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\ud83c\udf09-\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09--\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09------\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09----\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10---\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09---\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09"
const val S71 = "\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09-\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10-\uD83C\uDF10-\uD83C\uDF10--\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09-\ud83c\udf09--\ud83c\udf09\ud83c\udf09-\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09-\uD83C\uDF10----\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09--\uD83C\uDF10\ud83c\udf09\ud83c\udf09--\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\ud83c\udf09"
const val S72 = "\uD83C\uDF10\ud83c\udf09\uD83C\uDF10--\ud83c\udf09-\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10--\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10--\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09--\ud83c\udf09--\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\ud83c\udf09-\ud83c\udf09\ud83c\udf09-\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10--\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09-\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\ud83c\udf09-\ud83c\udf09\ud83c\udf09"
const val S73 = "-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09--\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10--\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09--\uD83C\uDF10\ud83c\udf09\uD83C\uDF10--\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10---\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10--\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09"
const val S74 = "\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09--\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10---\ud83c\udf09--\ud83c\udf09\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09-\uD83C\uDF10----\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\ud83c\udf09----\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10--\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10---\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10--\ud83c\udf09\uD83C\uDF10\uD83C\uDF10---\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10--\ud83c\udf09-\uD83C\uDF10--\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09-\uD83C\uDF10\ud83c\udf09---\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\uD83C\uDF10"
const val S75 = "\uD83C\uDF10--\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\ud83c\udf09--\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10---\uD83C\uDF10\ud83c\udf09-----\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10--\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\ud83c\udf09--\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\ud83c\udf09--\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09--\ud83c\udf09\ud83c\udf09--\ud83c\udf09\ud83c\udf09---\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09"
const val S76 = "\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10-\uD83C\uDF10--\ud83c\udf09\ud83c\udf09--\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\ud83c\udf09--\uD83C\uDF10-\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10--\uD83C\uDF10\uD83C\uDF10--\uD83C\uDF10-\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10---\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09-\ud83c\udf09\ud83c\udf09--\uD83C\uDF10\ud83c\udf09\ud83c\udf09--\ud83c\udf09\uD83C\uDF10----\uD83C\uDF10\uD83C\uDF10---\ud83c\udf09\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10"
const val S77 = "-\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10--\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09--\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10--\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10-----\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10--\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09----\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\uD83C\uDF10---\uD83C\uDF10\uD83C\uDF10\ud83c\udf09"
const val S78 = "\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09--\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10----\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10--\uD83C\uDF10-\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\ud83c\udf09--\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09--\ud83c\udf09--\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\ud83c\udf09-\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10---\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09"
const val S79 = "--\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\ud83c\udf09-\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10---\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09--\ud83c\udf09\ud83c\udf09-\uD83C\uDF10--\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10-\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09--\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10--\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\uD83C\uDF10"
const val S80 = "\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09--\ud83c\udf09--\ud83c\udf09\ud83c\udf09---\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10--\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\ud83c\udf09--\ud83c\udf09----\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\ud83c\udf09-\uD83C\uDF10--\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09--\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10--\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10"
const val S81 = "\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10--\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10--\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09---\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\ud83c\udf09--\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10--\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10---\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10---\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10--\ud83c\udf09---\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10---\ud83c\udf09\ud83c\udf09-\ud83c\udf09\uD83C\uDF10"
const val S82 = "--\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10--\uD83C\uDF10\uD83C\uDF10--\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\ud83c\udf09-\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09--\uD83C\uDF10\ud83c\udf09---\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10--\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\ud83c\udf09--\uD83C\uDF10\ud83c\udf09---\uD83C\uDF10"
const val S83 = "\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10--\ud83c\udf09\ud83c\udf09-\ud83c\udf09\uD83C\uDF10--\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10--\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09--\ud83c\udf09-\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10---\ud83c\udf09\uD83C\uDF10--\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09---\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10"
const val S84 = "\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09---\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10--\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10--\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09---\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09----\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\ud83c\udf09-\uD83C\uDF10--\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-----\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09---\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10--\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10---\ud83c\udf09-\uD83C\uDF10-\ud83c\udf09"
const val S85 = "\ud83c\udf09-\uD83C\uDF10-\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10--\ud83c\udf09--\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09---\uD83C\uDF10-\ud83c\udf09\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10--\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\ud83c\udf09-\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09--\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10--\uD83C\uDF10--\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10-\ud83c\udf09-"
const val S86 = "\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09----\uD83C\uDF10---\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09-\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\ud83c\udf09---\ud83c\udf09--\ud83c\udf09\uD83C\uDF10--\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10--\ud83c\udf09\uD83C\uDF10\ud83c\udf09--\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10--\ud83c\udf09\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\ud83c\udf09--\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09--\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09"
const val S87 = "\ud83c\udf09--\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10--\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10--\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09--\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10---\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10-\ud83c\udf09--\ud83c\udf09\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10--\uD83C\uDF10\uD83C\uDF10--\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10--\ud83c\udf09\ud83c\udf09----\ud83c\udf09"
const val S88 = "\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10---\ud83c\udf09--\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\ud83c\udf09--\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09--\uD83C\uDF10--\uD83C\uDF10\uD83C\uDF10--\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10-------\ud83c\udf09--\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09-\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10"
const val S89 = "\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\ud83c\udf09-\uD83C\uDF10-\ud83c\udf09---\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\ud83c\udf09--\ud83c\udf09--\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10--\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09-\ud83c\udf09--\ud83c\udf09-\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10--\ud83c\udf09\uD83C\uDF10\uD83C\uDF10--\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10--\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09--\ud83c\udf09-\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09--\ud83c\udf09-\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10"
const val S90 = "\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\ud83c\udf09-\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09-\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\uD83C\uDF10----\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\ud83c\udf09---\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10---\ud83c\udf09\uD83C\uDF10\ud83c\udf09--\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09---\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10"
const val S91 = "\ud83c\udf09\uD83C\uDF10--\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09-\uD83C\uDF10-\ud83c\udf09-\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10----\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10--\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\ud83c\udf09---\uD83C\uDF10---\ud83c\udf09\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09-------\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09"
const val S92 = "-\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10--\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09-\ud83c\udf09\ud83c\udf09---\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09--\ud83c\udf09-\ud83c\udf09-\ud83c\udf09\uD83C\uDF10-\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\ud83c\udf09-\ud83c\udf09-\ud83c\udf09--\ud83c\udf09-\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10--\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10---\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09-\uD83C\uDF10--\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\ud83c\udf09--\uD83C\uDF10--\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10---\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10--\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10"
const val S93 = "-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09-\ud83c\udf09\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\ud83c\udf09--\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10--\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10---\ud83c\udf09--\uD83C\uDF10--\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09---\uD83C\uDF10\uD83C\uDF10--\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09--\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09"
const val S94 = "\uD83C\uDF10-\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-----\ud83c\udf09\uD83C\uDF10--\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09--\uD83C\uDF10-\uD83C\uDF10--\ud83c\udf09\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10---\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10---\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09--\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10--\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10--\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\ud83c\udf09"
const val S95 = "-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\ud83c\udf09-\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10---\ud83c\udf09--\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09--\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10----\ud83c\udf09\uD83C\uDF10\ud83c\udf09-----\uD83C\uDF10--\uD83C\uDF10-\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09--\ud83c\udf09---\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10"
const val S96 = "\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10---\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10--\ud83c\udf09-\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\ud83c\udf09--\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10----\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10--\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09--\ud83c\udf09--\uD83C\uDF10--\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09"
const val S97 = "-\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\ud83c\udf09---\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10--\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10---\ud83c\udf09\uD83C\uDF10--\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09--\ud83c\udf09\ud83c\udf09--\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\uD83C\uDF10--\uD83C\uDF10--\ud83c\udf09\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09---\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09--\uD83C\uDF10\ud83c\udf09-\ud83c\udf09--\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09-\ud83c\udf09\uD83C\uDF10"
const val S98 = "\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09--\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09-\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09-\uD83C\uDF10-\ud83c\udf09-\ud83c\udf09\ud83c\udf09--\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10--\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09--\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09--\ud83c\udf09\ud83c\udf09-\uD83C\uDF10-\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\ud83c\udf09-----\uD83C\uDF10"
const val S99 = "-\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10---\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10--\ud83c\udf09--\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09---\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10--\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09--\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09--\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10--\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10--\ud83c\udf09--\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09"
const val S100 = "-\uD83C\uDF10--\ud83c\udf09--\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09--\ud83c\udf09\ud83c\udf09-\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10---\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09--\ud83c\udf09--\ud83c\udf09-\ud83c\udf09----\uD83C\uDF10--\uD83C\uDF10\ud83c\udf09---\uD83C\uDF10\ud83c\udf09---\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\ud83c\udf09-\ud83c\udf09--\ud83c\udf09--\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09\ud83c\udf09--\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10"
const val S101 = "-\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10---\ud83c\udf09\ud83c\udf09--\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09---\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09--\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09--\ud83c\udf09\uD83C\uDF10\ud83c\udf09--\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09--\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\ud83c\udf09--\ud83c\udf09---\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09-\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10"
const val S102 = "\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10--\uD83C\uDF10---\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10--\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10--\ud83c\udf09---\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09--\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09--\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10----\ud83c\udf09\ud83c\udf09--\ud83c\udf09-\ud83c\udf09-\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09"
const val S103 = "\uD83C\uDF10\ud83c\udf09----\ud83c\udf09\ud83c\udf09--\ud83c\udf09\uD83C\uDF10-----\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10--\uD83C\uDF10--\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\ud83c\udf09-\ud83c\udf09----\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10--\ud83c\udf09--\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10--\ud83c\udf09\ud83c\udf09--\uD83C\uDF10--\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10--\uD83C\uDF10\uD83C\uDF10-----\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10----\uD83C\uDF10-\ud83c\udf09---\ud83c\udf09-\uD83C\uDF10--\ud83c\udf09\uD83C\uDF10\uD83C\uDF10"
const val S104 = "\ud83c\udf09\uD83C\uDF10-\ud83c\udf09--\uD83C\uDF10\uD83C\uDF10--\ud83c\udf09--\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\ud83c\udf09---\uD83C\uDF10-\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10--\uD83C\uDF10--\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10---\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10--\ud83c\udf09\uD83C\uDF10\ud83c\udf09--\ud83c\udf09\uD83C\uDF10--\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10"
const val S105 = "-\uD83C\uDF10-\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09--\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10--\uD83C\uDF10---\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09--\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10---\ud83c\udf09--\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09--\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09----\ud83c\udf09-\ud83c\udf09---\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09-\uD83C\uDF10--\uD83C\uDF10\uD83C\uDF10--\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\ud83c\udf09\uD83C\uDF10--\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\ud83c\udf09"
const val S106 = "-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10--\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10--\uD83C\uDF10\ud83c\udf09--\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09--\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10--\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10--\ud83c\udf09--\ud83c\udf09\uD83C\uDF10---\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09--\ud83c\udf09-\ud83c\udf09-\ud83c\udf09\ud83c\udf09-\ud83c\udf09"
const val S107 = "\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09--\ud83c\udf09\uD83C\uDF10-\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\uD83C\uDF10-\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09-\uD83C\uDF10--\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09-\uD83C\uDF10----\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10--\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10---\uD83C\uDF10\ud83c\udf09-\ud83c\udf09-\ud83c\udf09-\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09--\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10--\ud83c\udf09-\uD83C\uDF10\ud83c\udf09--\ud83c\udf09-\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10--\uD83C\uDF10\ud83c\udf09\ud83c\udf09"
const val S108 = "\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09-\ud83c\udf09----\uD83C\uDF10-\ud83c\udf09\ud83c\udf09----\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09---\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10--\uD83C\uDF10-\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09-\uD83C\uDF10-\ud83c\udf09-\uD83C\uDF10\ud83c\udf09--\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10---\ud83c\udf09\ud83c\udf09\ud83c\udf09--\ud83c\udf09\uD83C\uDF10\uD83C\uDF10--\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10"
const val S109 = "\ud83c\udf09\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10--\ud83c\udf09\uD83C\uDF10\ud83c\udf09--\ud83c\udf09---\ud83c\udf09\ud83c\udf09-\ud83c\udf09-\uD83C\uDF10\ud83c\udf09-\ud83c\udf09-\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09---\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10--\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10--\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10"
const val S110 = "-\uD83C\uDF10-----\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09----\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\ud83c\udf09--\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09-\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09-\ud83c\udf09-\ud83c\udf09-\uD83C\uDF10\ud83c\udf09-----\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10--\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10"
const val S111 = "-----\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10--\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10--\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09--\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10-\ud83c\udf09--\ud83c\udf09-\uD83C\uDF10---\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10-\ud83c\udf09--\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10--\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\ud83c\udf09--\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10--\ud83c\udf09\uD83C\uDF10----\ud83c\udf09\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09-\uD83C\uDF10---\uD83C\uDF10-"
const val S112 = "-\ud83c\udf09-\uD83C\uDF10\ud83c\udf09--\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\ud83c\udf09--\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\ud83c\udf09--\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10--\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10--\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09\ud83c\udf09---\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09"
const val S113 = "\ud83c\udf09\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09---\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10-\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09-\ud83c\udf09-\ud83c\udf09---\ud83c\udf09\ud83c\udf09-\uD83C\uDF10-\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09---\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10---\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10--\ud83c\udf09"
const val S114 = "\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\ud83c\udf09-\ud83c\udf09\uD83C\uDF10---\ud83c\udf09--\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09--\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10--\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10----\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09-------\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10--\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10--\ud83c\udf09\uD83C\uDF10\uD83C\uDF10--\uD83C\uDF10-\uD83C\uDF10----\ud83c\udf09\ud83c\udf09"
const val S115 = "\ud83c\udf09--\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10--\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09----\uD83C\uDF10--\uD83C\uDF10----\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09--\ud83c\udf09---\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10---\ud83c\udf09\uD83C\uDF10\ud83c\udf09----\uD83C\uDF10"
const val S116 = "\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09--\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10--\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\ud83c\udf09---\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\ud83c\udf09-\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09--\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09--\uD83C\uDF10\uD83C\uDF10--\ud83c\udf09\uD83C\uDF10--\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09--\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09--\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09"
const val S117 = "\ud83c\udf09\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09--\ud83c\udf09\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09---\ud83c\udf09\ud83c\udf09-\ud83c\udf09---\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09--\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09--\uD83C\uDF10\uD83C\uDF10---\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10--\ud83c\udf09-\ud83c\udf09\uD83C\uDF10"
const val S118 = "\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09----\ud83c\udf09---\ud83c\udf09\ud83c\udf09\uD83C\uDF10--\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10-\uD83C\uDF10--\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10--\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10--\uD83C\uDF10--\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09----\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\ud83c\udf09--\ud83c\udf09---\ud83c\udf09-\uD83C\uDF10--\uD83C\uDF10--\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\ud83c\udf09-\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\ud83c\udf09--\ud83c\udf09"
const val S119 = "-\uD83C\uDF10-\ud83c\udf09----\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\ud83c\udf09----\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\ud83c\udf09\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10--\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\uD83C\uDF10--\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09--\ud83c\udf09--\ud83c\udf09-\uD83C\uDF10--\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09----\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10---\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09----\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09--\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10--\uD83C\uDF10\uD83C\uDF10--\uD83C\uDF10--\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09"
const val S120 = "\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10----\uD83C\uDF10\ud83c\udf09--\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09--\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10---\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10--\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10----\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09--\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09--\uD83C\uDF10\ud83c\udf09-\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09-\ud83c\udf09---\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10--\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09"
const val S121 = "\ud83c\udf09----\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\ud83c\udf09---\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10---\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09-\ud83c\udf09-\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10---\uD83C\uDF10\uD83C\uDF10-----\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10--\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10--\ud83c\udf09---\ud83c\udf09-\ud83c\udf09---\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10--\uD83C\uDF10--\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10--\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09"
const val S122 = "\ud83c\udf09--\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10---\uD83C\uDF10\ud83c\udf09\uD83C\uDF10--\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\ud83c\udf09-\ud83c\udf09-\ud83c\udf09\uD83C\uDF10--\uD83C\uDF10--\ud83c\udf09--\uD83C\uDF10\ud83c\udf09-\ud83c\udf09-\ud83c\udf09-\uD83C\uDF10--\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\ud83c\udf09--\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10--\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\ud83c\udf09-\ud83c\udf09\uD83C\uDF10--\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10"
const val S123 = "\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10---\ud83c\udf09-\ud83c\udf09\uD83C\uDF10--\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10--\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09--\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\ud83c\udf09-\ud83c\udf09--\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10--\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\ud83c\udf09-\ud83c\udf09\ud83c\udf09---\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10--\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09----\ud83c\udf09\ud83c\udf09\ud83c\udf09"
const val S124 = "\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09---\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10--\ud83c\udf09\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09--\ud83c\udf09--\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09--\uD83C\uDF10-\ud83c\udf09--\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-----\ud83c\udf09\ud83c\udf09\uD83C\uDF10--\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10"
const val S125 = "\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10--\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09--\uD83C\uDF10-\ud83c\udf09\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09--\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10--\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09--\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10--\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09------\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10-\ud83c\udf09"
const val S126 = "\uD83C\uDF10---\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\uD83C\uDF10--\uD83C\uDF10--\uD83C\uDF10--\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09-\ud83c\udf09-\uD83C\uDF10---\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09--\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-----\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10-\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\ud83c\udf09---\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09----\ud83c\udf09\uD83C\uDF10--\ud83c\udf09-\ud83c\udf09--\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09--\uD83C\uDF10\uD83C\uDF10\ud83c\udf09--\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10-\uD83C\uDF10"
const val S127 = "-\uD83C\uDF10--\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09--\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10-\uD83C\uDF10---\uD83C\uDF10-\uD83C\uDF10--\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09---\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09-\ud83c\udf09-\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09"
const val S128 = "\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09--\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09--\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\ud83c\udf09----\ud83c\udf09-\ud83c\udf09\uD83C\uDF10--\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09--\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10"
const val S129 = "\ud83c\udf09--\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09---\ud83c\udf09\ud83c\udf09-\ud83c\udf09-\uD83C\uDF10--\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10--\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10--\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09--\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\uD83C\uDF10-----\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09--\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09--\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10--\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09---\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09\ud83c\udf09"
const val S130 = "\uD83C\uDF10\uD83C\uDF10--\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09--\ud83c\udf09---\ud83c\udf09\ud83c\udf09---\ud83c\udf09-\uD83C\uDF10--\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-----\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10--\uD83C\uDF10-\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09--\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09-\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09--\uD83C\uDF10-\uD83C\uDF10-\uD83C\uDF10--\ud83c\udf09--\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09-\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10--\ud83c\udf09--\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09"
const val S131 = "\uD83C\uDF10--\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09---\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\ud83c\udf09--\uD83C\uDF10\ud83c\udf09-\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10---\uD83C\uDF10--\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10----\uD83C\uDF10-\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\uD83C\uDF10--\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09--\ud83c\udf09-\ud83c\udf09--\uD83C\uDF10-\uD83C\uDF10--\ud83c\udf09\ud83c\udf09---\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09--\uD83C\uDF10\uD83C\uDF10---\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10--\uD83C\uDF10------\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10"
const val S132 = "-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09--\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09--\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09--\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09--\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09--\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\ud83c\udf09--\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09-\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09--\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\ud83c\udf09"
const val S133 = "-\ud83c\udf09\ud83c\udf09--\ud83c\udf09-\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09----\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09---\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\ud83c\udf09--\ud83c\udf09--\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\ud83c\udf09----\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10--\ud83c\udf09--\ud83c\udf09\ud83c\udf09--\ud83c\udf09\ud83c\udf09-\ud83c\udf09--\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10--\ud83c\udf09\ud83c\udf09\uD83C\uDF10---\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09"
const val S134 = "\uD83C\uDF10-\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10--\ud83c\udf09\ud83c\udf09--\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10--\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\ud83c\udf09--\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09---\uD83C\uDF10\uD83C\uDF10\ud83c\udf09--\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10--\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09-\ud83c\udf09-\uD83C\uDF10-\ud83c\udf09"
const val S135 = "\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09-\uD83C\uDF10--\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10-\uD83C\uDF10--\uD83C\uDF10\uD83C\uDF10\ud83c\udf09---\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10--\uD83C\uDF10--\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10---\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\ud83c\udf09--\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10--\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10--\ud83c\udf09\uD83C\uDF10\ud83c\udf09--\ud83c\udf09---\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10"
const val S136 = "\uD83C\uDF10\ud83c\udf09--\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10--\ud83c\udf09\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10---\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09--\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\ud83c\udf09--\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\uD83C\uDF10--\ud83c\udf09-\ud83c\udf09--\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09\ud83c\udf09-\uD83C\uDF10--\uD83C\uDF10--\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09-\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10"
const val S137 = "\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10--\ud83c\udf09-\ud83c\udf09\ud83c\udf09---\uD83C\uDF10\ud83c\udf09--\ud83c\udf09\ud83c\udf09-\ud83c\udf09--\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10----\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09---\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10--\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\ud83c\udf09-\ud83c\udf09--\uD83C\uDF10\ud83c\udf09\uD83C\uDF10--\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\ud83c\udf09---\ud83c\udf09\uD83C\uDF10--"
const val S138 = "\ud83c\udf09\uD83C\uDF10-\ud83c\udf09--\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10--\uD83C\uDF10\uD83C\uDF10\ud83c\udf09------\ud83c\udf09\ud83c\udf09---\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10----\ud83c\udf09--\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10--\ud83c\udf09\uD83C\uDF10\uD83C\uDF10---\ud83c\udf09\uD83C\uDF10\uD83C\uDF10--\ud83c\udf09\uD83C\uDF10"
const val S139 = "--\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09--\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\uD83C\uDF10--\ud83c\udf09\uD83C\uDF10--\uD83C\uDF10\ud83c\udf09\ud83c\udf09--\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09--\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\ud83c\udf09--\ud83c\udf09---\uD83C\uDF10---\uD83C\uDF10-\ud83c\udf09---\uD83C\uDF10"
const val S140 = "\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10----\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09-\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09--\ud83c\udf09--\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10----\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10--\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10--\uD83C\uDF10\uD83C\uDF10"
const val S141 = "-\ud83c\udf09--\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10-\ud83c\udf09--\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09--\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09-\ud83c\udf09--\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10--\ud83c\udf09---\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\ud83c\udf09---\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\ud83c\udf09-\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09-\ud83c\udf09----\uD83C\uDF10\ud83c\udf09--\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\ud83c\udf09-\uD83C\uDF10--\uD83C\uDF10\ud83c\udf09---\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10"
const val S142 = "\ud83c\udf09\ud83c\udf09--\ud83c\udf09\uD83C\uDF10--\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10---\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10--\ud83c\udf09---\ud83c\udf09\uD83C\uDF10\uD83C\uDF10----\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09---\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\ud83c\udf09--\uD83C\uDF10-\ud83c\udf09--\ud83c\udf09\ud83c\udf09\ud83c\udf09--\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10---\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09--\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10--\ud83c\udf09"
const val S143 = "-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10--\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09--\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09--\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09----\uD83C\uDF10\ud83c\udf09--\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09--\ud83c\udf09---\ud83c\udf09\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09-\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10"
const val S144 = "\ud83c\udf09\ud83c\udf09--\ud83c\udf09-\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09---\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10--\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-----\uD83C\uDF10-\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09---\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09"
const val S145 = "---\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10-\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09---\ud83c\udf09\uD83C\uDF10\uD83C\uDF10--\ud83c\udf09--\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\ud83c\udf09-\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\ud83c\udf09---\ud83c\udf09\uD83C\uDF10---\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\ud83c\udf09---\uD83C\uDF10-\uD83C\uDF10"
const val S146 = "\uD83C\uDF10--\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10-\uD83C\uDF10--\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\ud83c\udf09--\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10--\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09---\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\ud83c\udf09---\uD83C\uDF10--\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10"
const val S147 = "--\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09---\uD83C\uDF10\ud83c\udf09\ud83c\udf09--\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\ud83c\udf09--\ud83c\udf09\uD83C\uDF10\ud83c\udf09--\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09--\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10--\ud83c\udf09-\ud83c\udf09\ud83c\udf09-\ud83c\udf09---\ud83c\udf09-\uD83C\uDF10-\ud83c\udf09\ud83c\udf09--\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10-\ud83c\udf09-\ud83c\udf09---\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09-\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09--\ud83c\udf09\uD83C\uDF10--\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10"
const val S148 = "--\uD83C\uDF10-\uD83C\uDF10--\uD83C\uDF10\ud83c\udf09-\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09--\ud83c\udf09\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10--\uD83C\uDF10-\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09--\uD83C\uDF10-\ud83c\udf09\ud83c\udf09-\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09--\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09--\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09--\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10"
const val S149 = "--\uD83C\uDF10\ud83c\udf09-\ud83c\udf09--\uD83C\uDF10--\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09--\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10---\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09---\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\ud83c\udf09-\ud83c\udf09-\ud83c\udf09\ud83c\udf09\ud83c\udf09--\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10--\ud83c\udf09-\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\ud83c\udf09--\ud83c\udf09"
const val S150 = "\ud83c\udf09\uD83C\uDF10\uD83C\uDF10---\ud83c\udf09-\uD83C\uDF10-\ud83c\udf09---\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\ud83c\udf09--\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09--\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10---\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09--\uD83C\uDF10\uD83C\uDF10\ud83c\udf09---\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\ud83c\udf09-\ud83c\udf09---\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\ud83c\udf09\ud83c\udf09---\ud83c\udf09-\uD83C\uDF10\ud83c\udf09-\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10--\ud83c\udf09-\ud83c\udf09-\uD83C\uDF10--\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\ud83c\udf09-\uD83C\uDF10-----\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\ud83c\udf09"
const val S151 = "\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10--\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\ud83c\udf09--\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10--\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10--\uD83C\uDF10---\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10--\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09--\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09----\ud83c\udf09-\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\ud83c\udf09-\ud83c\udf09"
const val S152 = "\uD83C\uDF10-\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09--\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\uD83C\uDF10---\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\ud83c\udf09--\uD83C\uDF10\uD83C\uDF10---\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\ud83c\udf09---\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10---\uD83C\uDF10\uD83C\uDF10--\uD83C\uDF10-\ud83c\udf09--\uD83C\uDF10--\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09---\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\ud83c\udf09--\ud83c\udf09\ud83c\udf09\ud83c\udf09--\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09--\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09"
const val S153 = "-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09--\ud83c\udf09---\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09--\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09---\ud83c\udf09\uD83C\uDF10-\ud83c\udf09--\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09---\uD83C\uDF10\ud83c\udf09---\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10-\ud83c\udf09-\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09-\ud83c\udf09-\ud83c\udf09-\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09--\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10"
const val S154 = "\ud83c\udf09\uD83C\uDF10----\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10---\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10----\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\ud83c\udf09--\ud83c\udf09-\ud83c\udf09-\ud83c\udf09\uD83C\uDF10--\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09---\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10---\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09--\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09--\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\ud83c\udf09"
const val S155 = "\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10-\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09-\ud83c\udf09-\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\ud83c\udf09----\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09"
const val S156 = "\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\ud83c\udf09----\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10-\uD83C\uDF10---\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\ud83c\udf09--\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09---\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\ud83c\udf09---\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09--\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09-\ud83c\udf09-\ud83c\udf09-\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10---\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\ud83c\udf09------\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09"
const val S157 = "\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09-----\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09-\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09-\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\ud83c\udf09--\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10---\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\ud83c\udf09-\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10-\uD83C\uDF10--\uD83C\uDF10\uD83C\uDF10--\uD83C\uDF10\uD83C\uDF10----\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10"
const val S158 = "\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10--\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\ud83c\udf09--\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\ud83c\udf09--\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10--\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\ud83c\udf09--\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10"
const val S159 = "---\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09------\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10--\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\ud83c\udf09-\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09----\ud83c\udf09-\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10--\ud83c\udf09\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\ud83c\udf09-\ud83c\udf09"
const val S160 = "\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10--\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\ud83c\udf09--\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09--\uD83C\uDF10---\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\ud83c\udf09-------\ud83c\udf09\ud83c\udf09--\uD83C\uDF10\uD83C\uDF10\ud83c\udf09--\uD83C\uDF10--\ud83c\udf09---\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\ud83c\udf09-\ud83c\udf09--\ud83c\udf09\uD83C\uDF10--\ud83c\udf09--\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10--\uD83C\uDF10---\ud83c\udf09\ud83c\udf09\ud83c\udf09--\ud83c\udf09--\ud83c\udf09"
const val S161 = "-\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09--\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10--\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09--\uD83C\uDF10-----\ud83c\udf09----\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10--\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10--\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09\ud83c\udf09-----\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09---\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10--\ud83c\udf09\uD83C\uDF10---\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09"
const val S162 = "\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\ud83c\udf09---\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10--\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10--\ud83c\udf09-\ud83c\udf09--\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09--\ud83c\udf09--\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10--\ud83c\udf09\uD83C\uDF10-\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10"
const val S163 = "-\ud83c\udf09\ud83c\udf09\uD83C\uDF10-----\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\uD83C\uDF10----\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10--\uD83C\uDF10-\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\uD83C\uDF10--\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09---\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10--\uD83C\uDF10\uD83C\uDF10\ud83c\udf09"
const val S164 = "\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09-\uD83C\uDF10-\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\uD83C\uDF10-\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09--\ud83c\udf09---\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09--\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09--------\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10--\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\ud83c\udf09-\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09--\ud83c\udf09\uD83C\uDF10\ud83c\udf09"
const val S165 = "-\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\ud83c\udf09----\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09---\ud83c\udf09\ud83c\udf09--\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10------\ud83c\udf09\ud83c\udf09--\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10--\ud83c\udf09---\uD83C\uDF10-\uD83C\uDF10--\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09"
const val S166 = "\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09--\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10-\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\ud83c\udf09--\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09---\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10"
const val S167 = "\ud83c\udf09--\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\ud83c\udf09--\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09-\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\ud83c\udf09-\ud83c\udf09\ud83c\udf09-\uD83C\uDF10--\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10---\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10--\ud83c\udf09-\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10--\ud83c\udf09--\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09--\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09"
const val S168 = "\ud83c\udf09--\uD83C\uDF10\ud83c\udf09\ud83c\udf09----\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09--\ud83c\udf09--\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10--\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09---\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10--\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10"
const val S169 = "\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10--\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09--\ud83c\udf09---\ud83c\udf09\uD83C\uDF10\ud83c\udf09---\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10---\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09----\ud83c\udf09-\ud83c\udf09\ud83c\udf09\ud83c\udf09-\uD83C\uDF10--\uD83C\uDF10\ud83c\udf09\uD83C\uDF10--\uD83C\uDF10\ud83c\udf09---\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09--\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10-----\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10"
const val S170 = "\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09--\ud83c\udf09\uD83C\uDF10--\ud83c\udf09--\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\ud83c\udf09--\ud83c\udf09-\ud83c\udf09--\uD83C\uDF10-\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10---\uD83C\uDF10--\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10--\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10---\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10---\ud83c\udf09\uD83C\uDF10--\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\ud83c\udf09---\uD83C\uDF10----\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\ud83c\udf09"
const val S171 = "---\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09---\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10---\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09--\ud83c\udf09--\ud83c\udf09\uD83C\uDF10-\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09----\ud83c\udf09\ud83c\udf09\ud83c\udf09--\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-----\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10"
const val S172 = "\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10--\ud83c\udf09-\ud83c\udf09-\ud83c\udf09-\uD83C\uDF10\ud83c\udf09--\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\ud83c\udf09--\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09--\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10--\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10--\ud83c\udf09-\ud83c\udf09-\uD83C\uDF10--\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10--\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10---\uD83C\uDF10-\ud83c\udf09--\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10"
const val S173 = "\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10--\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10--\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10--\ud83c\udf09--\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09-\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10--\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\ud83c\udf09-\uD83C\uDF10---\ud83c\udf09--\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10--\uD83C\uDF10\ud83c\udf09--\ud83c\udf09\uD83C\uDF10--\ud83c\udf09"
const val S174 = "\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\ud83c\udf09-\ud83c\udf09\uD83C\uDF10-\ud83c\udf09-\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10---\ud83c\udf09-\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10----\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10----\ud83c\udf09\uD83C\uDF10---\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10--\uD83C\uDF10\uD83C\uDF10\ud83c\udf09--\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10---\ud83c\udf09--\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\ud83c\udf09--\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09---\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\uD83C\uDF10--\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09-\ud83c\udf09--\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10---\uD83C\uDF10-"
const val S175 = "\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09--\ud83c\udf09---\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09---\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09----\uD83C\uDF10--\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\uD83C\uDF10-\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\ud83c\udf09----\uD83C\uDF10----\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10--\uD83C\uDF10--\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10--\ud83c\udf09-\uD83C\uDF10"
const val S176 = "----\uD83C\uDF10\uD83C\uDF10---\uD83C\uDF10-\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09-----\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10----\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10--\ud83c\udf09\uD83C\uDF10--\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09--\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10--\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09--\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10--\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10--\ud83c\udf09\ud83c\udf09-\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10--\uD83C\uDF10"
const val S177 = "\ud83c\udf09-\uD83C\uDF10\ud83c\udf09-\ud83c\udf09---\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10---\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10---\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10---\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09--\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10--\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10--\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10-\uD83C\uDF10"
const val S178 = "\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09--\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09--\ud83c\udf09-\ud83c\udf09--\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09-\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09--\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\uD83C\uDF10---\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\ud83c\udf09--\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\ud83c\udf09-\ud83c\udf09\uD83C\uDF10--\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10"
const val S179 = "--\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09--\ud83c\udf09-\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10--\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\ud83c\udf09-\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\uD83C\uDF10--\ud83c\udf09\ud83c\udf09-\ud83c\udf09--\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09--\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10"
const val S180 = "\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09-\ud83c\udf09--\ud83c\udf09\uD83C\uDF10--\ud83c\udf09--\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10--\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09---\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09--\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10---\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09--\ud83c\udf09--\ud83c\udf09\ud83c\udf09-\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10---\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10--\uD83C\uDF10--\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10"
const val S181 = "-\uD83C\uDF10---\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\ud83c\udf09---\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10--\ud83c\udf09\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09--\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10--\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09--\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\uD83C\uDF10--\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09"
const val S182 = "\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09--\ud83c\udf09--\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\ud83c\udf09--\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09--\uD83C\uDF10\uD83C\uDF10--\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09-\uD83C\uDF10\ud83c\udf09-\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10--\ud83c\udf09--\ud83c\udf09\ud83c\udf09\ud83c\udf09--\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09-\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10---\uD83C\uDF10---\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\ud83c\udf09"
const val S183 = "\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09--\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\ud83c\udf09-\ud83c\udf09\ud83c\udf09-----\ud83c\udf09--\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10--\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10--\ud83c\udf09-\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10-\uD83C\uDF10---\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\ud83c\udf09-\ud83c\udf09\ud83c\udf09---\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09---\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09----\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09"
const val S184 = "\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10-\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\ud83c\udf09---\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10--\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10--\ud83c\udf09---\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10---\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10---\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10--\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\ud83c\udf09"
const val S185 = "-\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\ud83c\udf09----\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09-\ud83c\udf09--\uD83C\uDF10-\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09--\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09----\uD83C\uDF10---\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10--\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\ud83c\udf09--\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10--\uD83C\uDF10--\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10"
const val S186 = "\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10-\ud83c\udf09-\ud83c\udf09--\ud83c\udf09-\uD83C\uDF10--\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\ud83c\udf09--\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10--\ud83c\udf09-\ud83c\udf09---\ud83c\udf09\uD83C\uDF10\uD83C\uDF10--\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09--\uD83C\uDF10--\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-----\uD83C\uDF10--\uD83C\uDF10\uD83C\uDF10--\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\uD83C\uDF10----\uD83C\uDF10---\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09--\ud83c\udf09\uD83C\uDF10-"
const val S187 = "---\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\ud83c\udf09--\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10--\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09---\uD83C\uDF10--\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09-\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09--\uD83C\uDF10--\ud83c\udf09-\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09--\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10--\ud83c\udf09-\ud83c\udf09-\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09--\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09--\ud83c\udf09---\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10"
const val S188 = "--\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09--\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10--\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10--\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\uD83C\uDF10-\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09--\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10"
const val S189 = "\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09---\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09\uD83C\uDF10---\uD83C\uDF10--\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10--\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09--\uD83C\uDF10-\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09---\ud83c\udf09\ud83c\udf09\uD83C\uDF10--\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\uD83C\uDF10--\ud83c\udf09--\uD83C\uDF10---\ud83c\udf09-\ud83c\udf09\uD83C\uDF10---\ud83c\udf09-\ud83c\udf09-\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09"
const val S190 = "\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10--\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09--\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09---\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09---\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09-\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10--\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10----\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09---\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10--\uD83C\uDF10--\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10----\ud83c\udf09\uD83C\uDF10"
const val S191 = "-\uD83C\uDF10\ud83c\udf09--\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\ud83c\udf09---\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10---\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09--\ud83c\udf09--\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09--\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09--\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09---\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\ud83c\udf09---\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\uD83C\uDF10"
const val S192 = "\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\ud83c\udf09-\ud83c\udf09--\uD83C\uDF10--\uD83C\uDF10--\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\ud83c\udf09\uD83C\uDF10--\ud83c\udf09--\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09---\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\ud83c\udf09--\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09---\ud83c\udf09-\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10---\ud83c\udf09-\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09-\ud83c\udf09--\ud83c\udf09--\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09-----\uD83C\uDF10\uD83C\uDF10---\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10"
const val S193 = "\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10---\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\uD83C\uDF10-----\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09-\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\ud83c\udf09-\uD83C\uDF10---\uD83C\uDF10\uD83C\uDF10\ud83c\udf09--\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09--\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10--\ud83c\udf09-\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10----\ud83c\udf09-\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09--\ud83c\udf09\uD83C\uDF10--\ud83c\udf09\uD83C\uDF10\ud83c\udf09"
const val S194 = "\uD83C\uDF10\ud83c\udf09\uD83C\uDF10--\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\ud83c\udf09--\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09--\uD83C\uDF10-\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09-\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10--\ud83c\udf09-\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09--\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09--\ud83c\udf09\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10---\uD83C\uDF10"
const val S195 = "-\uD83C\uDF10----\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\ud83c\udf09---\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09--\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10---\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10--"
const val S196 = "-\uD83C\uDF10\ud83c\udf09--\uD83C\uDF10\uD83C\uDF10--\ud83c\udf09-\uD83C\uDF10-\ud83c\udf09-\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10--\uD83C\uDF10\ud83c\udf09-\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10----\ud83c\udf09\uD83C\uDF10\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10--\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\uD83C\uDF10--\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10--\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10--\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\uD83C\uDF10-\ud83c\udf09----\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09-\ud83c\udf09"
const val S197 = "\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10--\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10-----\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09\ud83c\udf09--\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\ud83c\udf09\uD83C\uDF10---\ud83c\udf09--\ud83c\udf09-\ud83c\udf09-\ud83c\udf09-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09\uD83C\uDF10--\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\ud83c\udf09--\uD83C\uDF10\ud83c\udf09-\ud83c\udf09--\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10--\uD83C\uDF10-\ud83c\udf09-\ud83c\udf09\ud83c\udf09-\ud83c\udf09-\uD83C\uDF10-\ud83c\udf09-\ud83c\udf09\uD83C\uDF10--\ud83c\udf09-\uD83C\uDF10--\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\ud83c\udf09-\uD83C\uDF10-\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09-\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10"
const val S198 = "\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10\uD83C\uDF10-\uD83C\uDF10-\ud83c\udf09\ud83c\udf09--\ud83c\udf09-\uD83C\uDF10-----\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09---\ud83c\udf09\ud83c\udf09\ud83c\udf09-\uD83C\uDF10-\ud83c\udf09-\uD83C\uDF10\ud83c\udf09--\ud83c\udf09\ud83c\udf09\ud83c\udf09-\ud83c\udf09-\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09--\ud83c\udf09-\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\ud83c\udf09\uD83C\uDF10\ud83c\udf09--\uD83C\uDF10\ud83c\udf09\uD83C\uDF10-\ud83c\udf09\uD83C\uDF10\ud83c\udf09\ud83c\udf09\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\uD83C\uDF10---\uD83C\uDF10\uD83C\uDF10\ud83c\udf09\ud83c\udf09"

val t0 = S0 + S1 + S2 + S3 + S4 + S5 + S6 + S7 + S8 + S9 + S10 + S11 + S12 + S13 + S14 + S15 + S16 + S17 + S18 + S19 + S20 + S21 + S22 +
        S23 + S24 + S25 + S26 + S27 + S28 + S29 + S30 + S31 + S32 + S33 + S34 + S35 + S36 + S37 + S38 + S39 + S40 + S41 + S42 + S43 + S44 +
        S45 + S46 + S47 + S48 + S49 + S50 + S51 + S52 + S53 + S54 + S55 + S56 + S57 + S58 + S59 + S60 + S61 + S62 + S63 + S64 + S65 + S66 +
        S67 + S68 + S69 + S70 + S71 + S72 + S73 + S74 + S75 + S76 + S77 + S78 + S79 + S80 + S81 + S82 + S83 + S84 + S85 + S86 + S87 + S88 +
        S89 + S90 + S91 + S92 + S93 + S94 + S95 + S96 + S97 + S98 + S99 + S100 + S101 + S102 + S103 + S104 + S105 + S106 + S107 + S108 +
        S109 + S110 + S111 + S112 + S113 + S114 + S115 + S116 + S117 + S118 + S119 + S120 + S121 + S122 + S123 + S124 + S125 + S126 + S127 +
        S128 + S129 + S130 + S131 + S132 + S133 + S134 + S135 + S136 + S137 + S138 + S139 + S140 + S141 + S142 + S143 + S144 + S145 + S146 +
        S147 + S148 + S149 + S150 + S151 + S152 + S153 + S154 + S155 + S156 + S157 + S158 + S159 + S160 + S161 + S162 + S163 + S164 + S165 +
        S166 + S167 + S168 + S169 + S170 + S171 + S172 + S173 + S174 + S175 + S176 + S177 + S178 + S179 + S180 + S181 + S182 + S183 + S184 +
        S185 + S186 + S187 + S188 + S189 + S190 + S191 + S192 + S193 + S194 + S195 + S196 + S197 + S198

val t = t0 + "OK"

val SS = arrayOf(
    S0, S1, S2, S3, S4, S5, S6, S7, S8, S9, S10, S11, S12, S13, S14, S15, S16, S17, S18, S19, S20, S21, S22, S23, S24, S25, S26, S27, S28,
    S29, S30, S31, S32, S33, S34, S35, S36, S37, S38, S39, S40, S41, S42, S43, S44, S45, S46, S47, S48, S49, S50, S51, S52, S53, S54, S55,
    S56, S57, S58, S59, S60, S61, S62, S63, S64, S65, S66, S67, S68, S69, S70, S71, S72, S73, S74, S75, S76, S77, S78, S79, S80, S81, S82,
    S83, S84, S85, S86, S87, S88, S89, S90, S91, S92, S93, S94, S95, S96, S97, S98, S99, S100, S101, S102, S103, S104, S105, S106, S107,
    S108, S109, S110, S111, S112, S113, S114, S115, S116, S117, S118, S119, S120, S121, S122, S123, S124, S125, S126, S127, S128, S129,
    S130, S131, S132, S133, S134, S135, S136, S137, S138, S139, S140, S141, S142, S143, S144, S145, S146, S147, S148, S149, S150, S151,
    S152, S153, S154, S155, S156, S157, S158, S159, S160, S161, S162, S163, S164, S165, S166, S167, S168, S169, S170, S171, S172, S173,
    S174, S175, S176, S177, S178, S179, S180, S181, S182, S183, S184, S185, S186, S187, S188, S189, S190, S191, S192, S193, S194, S195,
    S196, S197, S198,
    "OK"
)

