// TARGET_BACKEND: JS
// Contains JS-specific checks, e.g. null == undefined

/* Generated by:

fun values(type: String) = when (type) {
        "Boolean" -> listOf(false to "false", true to "true")
        "Char" -> listOf(0.toChar() to "0.toChar()", 1.toChar() to "1.toChar()")
        else -> listOf(0 to "0.to$type()", 1 to "1.to$type()")
}

val nullableValues = listOf(null to "null", null to "undefined")

fun values(type: String, nullable: Boolean) = values(type) + (if (nullable) nullableValues else listOf())

fun main(args: Array<String>) {
	val types = listOf("Byte", "Boolean", "Short", "Char", "Int", "Float", "Double", "Long")

    val invocations = mutableListOf<String>()

    for (firstType in types) {
        for (secondType in types) {
            for ((firstTypeSuffix, firstNameSuffix) in listOf("" to "", "?" to "Q")) {
                for ((secondTypeSuffix, secondNameSuffix) in listOf("" to "", "?" to "Q")) {
                    val fnName = "eq$firstType$firstNameSuffix$secondType$secondNameSuffix"
                    println("fun <A: $firstType$firstTypeSuffix, B: $secondType$secondTypeSuffix> $fnName(a: A, b: B) = a == b")

                    val firstValues = values(firstType, firstTypeSuffix == "?")
                    val secondValues = values(secondType, secondTypeSuffix == "?")

                    for ((v1, s1) in firstValues) {
                        for ((v2, s2) in secondValues) {
                            val expectedResult = if (v1 == v2) "True" else "False"

                            invocations += "assert$expectedResult($fnName($s1, $s2))"
                        }
                    }
                }
            }
        }
    }

    println()
    println("fun box(): String {")
    invocations.forEach { println("    $it") }
    println("    return \"OK\"")
    println("}")
}

*/


fun <A: Byte, B: Byte> eqByteByte(a: A, b: B) = a == b
fun <A: Byte, B: Byte?> eqByteByteQ(a: A, b: B) = a == b
fun <A: Byte?, B: Byte> eqByteQByte(a: A, b: B) = a == b
fun <A: Byte?, B: Byte?> eqByteQByteQ(a: A, b: B) = a == b
fun <A: Byte, B: Boolean> eqByteBoolean(a: A, b: B) = a == b
fun <A: Byte, B: Boolean?> eqByteBooleanQ(a: A, b: B) = a == b
fun <A: Byte?, B: Boolean> eqByteQBoolean(a: A, b: B) = a == b
fun <A: Byte?, B: Boolean?> eqByteQBooleanQ(a: A, b: B) = a == b
fun <A: Byte, B: Short> eqByteShort(a: A, b: B) = a == b
fun <A: Byte, B: Short?> eqByteShortQ(a: A, b: B) = a == b
fun <A: Byte?, B: Short> eqByteQShort(a: A, b: B) = a == b
fun <A: Byte?, B: Short?> eqByteQShortQ(a: A, b: B) = a == b
fun <A: Byte, B: Char> eqByteChar(a: A, b: B) = a == b
fun <A: Byte, B: Char?> eqByteCharQ(a: A, b: B) = a == b
fun <A: Byte?, B: Char> eqByteQChar(a: A, b: B) = a == b
fun <A: Byte?, B: Char?> eqByteQCharQ(a: A, b: B) = a == b
fun <A: Byte, B: Int> eqByteInt(a: A, b: B) = a == b
fun <A: Byte, B: Int?> eqByteIntQ(a: A, b: B) = a == b
fun <A: Byte?, B: Int> eqByteQInt(a: A, b: B) = a == b
fun <A: Byte?, B: Int?> eqByteQIntQ(a: A, b: B) = a == b
fun <A: Byte, B: Float> eqByteFloat(a: A, b: B) = a == b
fun <A: Byte, B: Float?> eqByteFloatQ(a: A, b: B) = a == b
fun <A: Byte?, B: Float> eqByteQFloat(a: A, b: B) = a == b
fun <A: Byte?, B: Float?> eqByteQFloatQ(a: A, b: B) = a == b
fun <A: Byte, B: Double> eqByteDouble(a: A, b: B) = a == b
fun <A: Byte, B: Double?> eqByteDoubleQ(a: A, b: B) = a == b
fun <A: Byte?, B: Double> eqByteQDouble(a: A, b: B) = a == b
fun <A: Byte?, B: Double?> eqByteQDoubleQ(a: A, b: B) = a == b
fun <A: Byte, B: Long> eqByteLong(a: A, b: B) = a == b
fun <A: Byte, B: Long?> eqByteLongQ(a: A, b: B) = a == b
fun <A: Byte?, B: Long> eqByteQLong(a: A, b: B) = a == b
fun <A: Byte?, B: Long?> eqByteQLongQ(a: A, b: B) = a == b
fun <A: Boolean, B: Byte> eqBooleanByte(a: A, b: B) = a == b
fun <A: Boolean, B: Byte?> eqBooleanByteQ(a: A, b: B) = a == b
fun <A: Boolean?, B: Byte> eqBooleanQByte(a: A, b: B) = a == b
fun <A: Boolean?, B: Byte?> eqBooleanQByteQ(a: A, b: B) = a == b
fun <A: Boolean, B: Boolean> eqBooleanBoolean(a: A, b: B) = a == b
fun <A: Boolean, B: Boolean?> eqBooleanBooleanQ(a: A, b: B) = a == b
fun <A: Boolean?, B: Boolean> eqBooleanQBoolean(a: A, b: B) = a == b
fun <A: Boolean?, B: Boolean?> eqBooleanQBooleanQ(a: A, b: B) = a == b
fun <A: Boolean, B: Short> eqBooleanShort(a: A, b: B) = a == b
fun <A: Boolean, B: Short?> eqBooleanShortQ(a: A, b: B) = a == b
fun <A: Boolean?, B: Short> eqBooleanQShort(a: A, b: B) = a == b
fun <A: Boolean?, B: Short?> eqBooleanQShortQ(a: A, b: B) = a == b
fun <A: Boolean, B: Char> eqBooleanChar(a: A, b: B) = a == b
fun <A: Boolean, B: Char?> eqBooleanCharQ(a: A, b: B) = a == b
fun <A: Boolean?, B: Char> eqBooleanQChar(a: A, b: B) = a == b
fun <A: Boolean?, B: Char?> eqBooleanQCharQ(a: A, b: B) = a == b
fun <A: Boolean, B: Int> eqBooleanInt(a: A, b: B) = a == b
fun <A: Boolean, B: Int?> eqBooleanIntQ(a: A, b: B) = a == b
fun <A: Boolean?, B: Int> eqBooleanQInt(a: A, b: B) = a == b
fun <A: Boolean?, B: Int?> eqBooleanQIntQ(a: A, b: B) = a == b
fun <A: Boolean, B: Float> eqBooleanFloat(a: A, b: B) = a == b
fun <A: Boolean, B: Float?> eqBooleanFloatQ(a: A, b: B) = a == b
fun <A: Boolean?, B: Float> eqBooleanQFloat(a: A, b: B) = a == b
fun <A: Boolean?, B: Float?> eqBooleanQFloatQ(a: A, b: B) = a == b
fun <A: Boolean, B: Double> eqBooleanDouble(a: A, b: B) = a == b
fun <A: Boolean, B: Double?> eqBooleanDoubleQ(a: A, b: B) = a == b
fun <A: Boolean?, B: Double> eqBooleanQDouble(a: A, b: B) = a == b
fun <A: Boolean?, B: Double?> eqBooleanQDoubleQ(a: A, b: B) = a == b
fun <A: Boolean, B: Long> eqBooleanLong(a: A, b: B) = a == b
fun <A: Boolean, B: Long?> eqBooleanLongQ(a: A, b: B) = a == b
fun <A: Boolean?, B: Long> eqBooleanQLong(a: A, b: B) = a == b
fun <A: Boolean?, B: Long?> eqBooleanQLongQ(a: A, b: B) = a == b
fun <A: Short, B: Byte> eqShortByte(a: A, b: B) = a == b
fun <A: Short, B: Byte?> eqShortByteQ(a: A, b: B) = a == b
fun <A: Short?, B: Byte> eqShortQByte(a: A, b: B) = a == b
fun <A: Short?, B: Byte?> eqShortQByteQ(a: A, b: B) = a == b
fun <A: Short, B: Boolean> eqShortBoolean(a: A, b: B) = a == b
fun <A: Short, B: Boolean?> eqShortBooleanQ(a: A, b: B) = a == b
fun <A: Short?, B: Boolean> eqShortQBoolean(a: A, b: B) = a == b
fun <A: Short?, B: Boolean?> eqShortQBooleanQ(a: A, b: B) = a == b
fun <A: Short, B: Short> eqShortShort(a: A, b: B) = a == b
fun <A: Short, B: Short?> eqShortShortQ(a: A, b: B) = a == b
fun <A: Short?, B: Short> eqShortQShort(a: A, b: B) = a == b
fun <A: Short?, B: Short?> eqShortQShortQ(a: A, b: B) = a == b
fun <A: Short, B: Char> eqShortChar(a: A, b: B) = a == b
fun <A: Short, B: Char?> eqShortCharQ(a: A, b: B) = a == b
fun <A: Short?, B: Char> eqShortQChar(a: A, b: B) = a == b
fun <A: Short?, B: Char?> eqShortQCharQ(a: A, b: B) = a == b
fun <A: Short, B: Int> eqShortInt(a: A, b: B) = a == b
fun <A: Short, B: Int?> eqShortIntQ(a: A, b: B) = a == b
fun <A: Short?, B: Int> eqShortQInt(a: A, b: B) = a == b
fun <A: Short?, B: Int?> eqShortQIntQ(a: A, b: B) = a == b
fun <A: Short, B: Float> eqShortFloat(a: A, b: B) = a == b
fun <A: Short, B: Float?> eqShortFloatQ(a: A, b: B) = a == b
fun <A: Short?, B: Float> eqShortQFloat(a: A, b: B) = a == b
fun <A: Short?, B: Float?> eqShortQFloatQ(a: A, b: B) = a == b
fun <A: Short, B: Double> eqShortDouble(a: A, b: B) = a == b
fun <A: Short, B: Double?> eqShortDoubleQ(a: A, b: B) = a == b
fun <A: Short?, B: Double> eqShortQDouble(a: A, b: B) = a == b
fun <A: Short?, B: Double?> eqShortQDoubleQ(a: A, b: B) = a == b
fun <A: Short, B: Long> eqShortLong(a: A, b: B) = a == b
fun <A: Short, B: Long?> eqShortLongQ(a: A, b: B) = a == b
fun <A: Short?, B: Long> eqShortQLong(a: A, b: B) = a == b
fun <A: Short?, B: Long?> eqShortQLongQ(a: A, b: B) = a == b
fun <A: Char, B: Byte> eqCharByte(a: A, b: B) = a == b
fun <A: Char, B: Byte?> eqCharByteQ(a: A, b: B) = a == b
fun <A: Char?, B: Byte> eqCharQByte(a: A, b: B) = a == b
fun <A: Char?, B: Byte?> eqCharQByteQ(a: A, b: B) = a == b
fun <A: Char, B: Boolean> eqCharBoolean(a: A, b: B) = a == b
fun <A: Char, B: Boolean?> eqCharBooleanQ(a: A, b: B) = a == b
fun <A: Char?, B: Boolean> eqCharQBoolean(a: A, b: B) = a == b
fun <A: Char?, B: Boolean?> eqCharQBooleanQ(a: A, b: B) = a == b
fun <A: Char, B: Short> eqCharShort(a: A, b: B) = a == b
fun <A: Char, B: Short?> eqCharShortQ(a: A, b: B) = a == b
fun <A: Char?, B: Short> eqCharQShort(a: A, b: B) = a == b
fun <A: Char?, B: Short?> eqCharQShortQ(a: A, b: B) = a == b
fun <A: Char, B: Char> eqCharChar(a: A, b: B) = a == b
fun <A: Char, B: Char?> eqCharCharQ(a: A, b: B) = a == b
fun <A: Char?, B: Char> eqCharQChar(a: A, b: B) = a == b
fun <A: Char?, B: Char?> eqCharQCharQ(a: A, b: B) = a == b
fun <A: Char, B: Int> eqCharInt(a: A, b: B) = a == b
fun <A: Char, B: Int?> eqCharIntQ(a: A, b: B) = a == b
fun <A: Char?, B: Int> eqCharQInt(a: A, b: B) = a == b
fun <A: Char?, B: Int?> eqCharQIntQ(a: A, b: B) = a == b
fun <A: Char, B: Float> eqCharFloat(a: A, b: B) = a == b
fun <A: Char, B: Float?> eqCharFloatQ(a: A, b: B) = a == b
fun <A: Char?, B: Float> eqCharQFloat(a: A, b: B) = a == b
fun <A: Char?, B: Float?> eqCharQFloatQ(a: A, b: B) = a == b
fun <A: Char, B: Double> eqCharDouble(a: A, b: B) = a == b
fun <A: Char, B: Double?> eqCharDoubleQ(a: A, b: B) = a == b
fun <A: Char?, B: Double> eqCharQDouble(a: A, b: B) = a == b
fun <A: Char?, B: Double?> eqCharQDoubleQ(a: A, b: B) = a == b
fun <A: Char, B: Long> eqCharLong(a: A, b: B) = a == b
fun <A: Char, B: Long?> eqCharLongQ(a: A, b: B) = a == b
fun <A: Char?, B: Long> eqCharQLong(a: A, b: B) = a == b
fun <A: Char?, B: Long?> eqCharQLongQ(a: A, b: B) = a == b
fun <A: Int, B: Byte> eqIntByte(a: A, b: B) = a == b
fun <A: Int, B: Byte?> eqIntByteQ(a: A, b: B) = a == b
fun <A: Int?, B: Byte> eqIntQByte(a: A, b: B) = a == b
fun <A: Int?, B: Byte?> eqIntQByteQ(a: A, b: B) = a == b
fun <A: Int, B: Boolean> eqIntBoolean(a: A, b: B) = a == b
fun <A: Int, B: Boolean?> eqIntBooleanQ(a: A, b: B) = a == b
fun <A: Int?, B: Boolean> eqIntQBoolean(a: A, b: B) = a == b
fun <A: Int?, B: Boolean?> eqIntQBooleanQ(a: A, b: B) = a == b
fun <A: Int, B: Short> eqIntShort(a: A, b: B) = a == b
fun <A: Int, B: Short?> eqIntShortQ(a: A, b: B) = a == b
fun <A: Int?, B: Short> eqIntQShort(a: A, b: B) = a == b
fun <A: Int?, B: Short?> eqIntQShortQ(a: A, b: B) = a == b
fun <A: Int, B: Char> eqIntChar(a: A, b: B) = a == b
fun <A: Int, B: Char?> eqIntCharQ(a: A, b: B) = a == b
fun <A: Int?, B: Char> eqIntQChar(a: A, b: B) = a == b
fun <A: Int?, B: Char?> eqIntQCharQ(a: A, b: B) = a == b
fun <A: Int, B: Int> eqIntInt(a: A, b: B) = a == b
fun <A: Int, B: Int?> eqIntIntQ(a: A, b: B) = a == b
fun <A: Int?, B: Int> eqIntQInt(a: A, b: B) = a == b
fun <A: Int?, B: Int?> eqIntQIntQ(a: A, b: B) = a == b
fun <A: Int, B: Float> eqIntFloat(a: A, b: B) = a == b
fun <A: Int, B: Float?> eqIntFloatQ(a: A, b: B) = a == b
fun <A: Int?, B: Float> eqIntQFloat(a: A, b: B) = a == b
fun <A: Int?, B: Float?> eqIntQFloatQ(a: A, b: B) = a == b
fun <A: Int, B: Double> eqIntDouble(a: A, b: B) = a == b
fun <A: Int, B: Double?> eqIntDoubleQ(a: A, b: B) = a == b
fun <A: Int?, B: Double> eqIntQDouble(a: A, b: B) = a == b
fun <A: Int?, B: Double?> eqIntQDoubleQ(a: A, b: B) = a == b
fun <A: Int, B: Long> eqIntLong(a: A, b: B) = a == b
fun <A: Int, B: Long?> eqIntLongQ(a: A, b: B) = a == b
fun <A: Int?, B: Long> eqIntQLong(a: A, b: B) = a == b
fun <A: Int?, B: Long?> eqIntQLongQ(a: A, b: B) = a == b
fun <A: Float, B: Byte> eqFloatByte(a: A, b: B) = a == b
fun <A: Float, B: Byte?> eqFloatByteQ(a: A, b: B) = a == b
fun <A: Float?, B: Byte> eqFloatQByte(a: A, b: B) = a == b
fun <A: Float?, B: Byte?> eqFloatQByteQ(a: A, b: B) = a == b
fun <A: Float, B: Boolean> eqFloatBoolean(a: A, b: B) = a == b
fun <A: Float, B: Boolean?> eqFloatBooleanQ(a: A, b: B) = a == b
fun <A: Float?, B: Boolean> eqFloatQBoolean(a: A, b: B) = a == b
fun <A: Float?, B: Boolean?> eqFloatQBooleanQ(a: A, b: B) = a == b
fun <A: Float, B: Short> eqFloatShort(a: A, b: B) = a == b
fun <A: Float, B: Short?> eqFloatShortQ(a: A, b: B) = a == b
fun <A: Float?, B: Short> eqFloatQShort(a: A, b: B) = a == b
fun <A: Float?, B: Short?> eqFloatQShortQ(a: A, b: B) = a == b
fun <A: Float, B: Char> eqFloatChar(a: A, b: B) = a == b
fun <A: Float, B: Char?> eqFloatCharQ(a: A, b: B) = a == b
fun <A: Float?, B: Char> eqFloatQChar(a: A, b: B) = a == b
fun <A: Float?, B: Char?> eqFloatQCharQ(a: A, b: B) = a == b
fun <A: Float, B: Int> eqFloatInt(a: A, b: B) = a == b
fun <A: Float, B: Int?> eqFloatIntQ(a: A, b: B) = a == b
fun <A: Float?, B: Int> eqFloatQInt(a: A, b: B) = a == b
fun <A: Float?, B: Int?> eqFloatQIntQ(a: A, b: B) = a == b
fun <A: Float, B: Float> eqFloatFloat(a: A, b: B) = a == b
fun <A: Float, B: Float?> eqFloatFloatQ(a: A, b: B) = a == b
fun <A: Float?, B: Float> eqFloatQFloat(a: A, b: B) = a == b
fun <A: Float?, B: Float?> eqFloatQFloatQ(a: A, b: B) = a == b
fun <A: Float, B: Double> eqFloatDouble(a: A, b: B) = a == b
fun <A: Float, B: Double?> eqFloatDoubleQ(a: A, b: B) = a == b
fun <A: Float?, B: Double> eqFloatQDouble(a: A, b: B) = a == b
fun <A: Float?, B: Double?> eqFloatQDoubleQ(a: A, b: B) = a == b
fun <A: Float, B: Long> eqFloatLong(a: A, b: B) = a == b
fun <A: Float, B: Long?> eqFloatLongQ(a: A, b: B) = a == b
fun <A: Float?, B: Long> eqFloatQLong(a: A, b: B) = a == b
fun <A: Float?, B: Long?> eqFloatQLongQ(a: A, b: B) = a == b
fun <A: Double, B: Byte> eqDoubleByte(a: A, b: B) = a == b
fun <A: Double, B: Byte?> eqDoubleByteQ(a: A, b: B) = a == b
fun <A: Double?, B: Byte> eqDoubleQByte(a: A, b: B) = a == b
fun <A: Double?, B: Byte?> eqDoubleQByteQ(a: A, b: B) = a == b
fun <A: Double, B: Boolean> eqDoubleBoolean(a: A, b: B) = a == b
fun <A: Double, B: Boolean?> eqDoubleBooleanQ(a: A, b: B) = a == b
fun <A: Double?, B: Boolean> eqDoubleQBoolean(a: A, b: B) = a == b
fun <A: Double?, B: Boolean?> eqDoubleQBooleanQ(a: A, b: B) = a == b
fun <A: Double, B: Short> eqDoubleShort(a: A, b: B) = a == b
fun <A: Double, B: Short?> eqDoubleShortQ(a: A, b: B) = a == b
fun <A: Double?, B: Short> eqDoubleQShort(a: A, b: B) = a == b
fun <A: Double?, B: Short?> eqDoubleQShortQ(a: A, b: B) = a == b
fun <A: Double, B: Char> eqDoubleChar(a: A, b: B) = a == b
fun <A: Double, B: Char?> eqDoubleCharQ(a: A, b: B) = a == b
fun <A: Double?, B: Char> eqDoubleQChar(a: A, b: B) = a == b
fun <A: Double?, B: Char?> eqDoubleQCharQ(a: A, b: B) = a == b
fun <A: Double, B: Int> eqDoubleInt(a: A, b: B) = a == b
fun <A: Double, B: Int?> eqDoubleIntQ(a: A, b: B) = a == b
fun <A: Double?, B: Int> eqDoubleQInt(a: A, b: B) = a == b
fun <A: Double?, B: Int?> eqDoubleQIntQ(a: A, b: B) = a == b
fun <A: Double, B: Float> eqDoubleFloat(a: A, b: B) = a == b
fun <A: Double, B: Float?> eqDoubleFloatQ(a: A, b: B) = a == b
fun <A: Double?, B: Float> eqDoubleQFloat(a: A, b: B) = a == b
fun <A: Double?, B: Float?> eqDoubleQFloatQ(a: A, b: B) = a == b
fun <A: Double, B: Double> eqDoubleDouble(a: A, b: B) = a == b
fun <A: Double, B: Double?> eqDoubleDoubleQ(a: A, b: B) = a == b
fun <A: Double?, B: Double> eqDoubleQDouble(a: A, b: B) = a == b
fun <A: Double?, B: Double?> eqDoubleQDoubleQ(a: A, b: B) = a == b
fun <A: Double, B: Long> eqDoubleLong(a: A, b: B) = a == b
fun <A: Double, B: Long?> eqDoubleLongQ(a: A, b: B) = a == b
fun <A: Double?, B: Long> eqDoubleQLong(a: A, b: B) = a == b
fun <A: Double?, B: Long?> eqDoubleQLongQ(a: A, b: B) = a == b
fun <A: Long, B: Byte> eqLongByte(a: A, b: B) = a == b
fun <A: Long, B: Byte?> eqLongByteQ(a: A, b: B) = a == b
fun <A: Long?, B: Byte> eqLongQByte(a: A, b: B) = a == b
fun <A: Long?, B: Byte?> eqLongQByteQ(a: A, b: B) = a == b
fun <A: Long, B: Boolean> eqLongBoolean(a: A, b: B) = a == b
fun <A: Long, B: Boolean?> eqLongBooleanQ(a: A, b: B) = a == b
fun <A: Long?, B: Boolean> eqLongQBoolean(a: A, b: B) = a == b
fun <A: Long?, B: Boolean?> eqLongQBooleanQ(a: A, b: B) = a == b
fun <A: Long, B: Short> eqLongShort(a: A, b: B) = a == b
fun <A: Long, B: Short?> eqLongShortQ(a: A, b: B) = a == b
fun <A: Long?, B: Short> eqLongQShort(a: A, b: B) = a == b
fun <A: Long?, B: Short?> eqLongQShortQ(a: A, b: B) = a == b
fun <A: Long, B: Char> eqLongChar(a: A, b: B) = a == b
fun <A: Long, B: Char?> eqLongCharQ(a: A, b: B) = a == b
fun <A: Long?, B: Char> eqLongQChar(a: A, b: B) = a == b
fun <A: Long?, B: Char?> eqLongQCharQ(a: A, b: B) = a == b
fun <A: Long, B: Int> eqLongInt(a: A, b: B) = a == b
fun <A: Long, B: Int?> eqLongIntQ(a: A, b: B) = a == b
fun <A: Long?, B: Int> eqLongQInt(a: A, b: B) = a == b
fun <A: Long?, B: Int?> eqLongQIntQ(a: A, b: B) = a == b
fun <A: Long, B: Float> eqLongFloat(a: A, b: B) = a == b
fun <A: Long, B: Float?> eqLongFloatQ(a: A, b: B) = a == b
fun <A: Long?, B: Float> eqLongQFloat(a: A, b: B) = a == b
fun <A: Long?, B: Float?> eqLongQFloatQ(a: A, b: B) = a == b
fun <A: Long, B: Double> eqLongDouble(a: A, b: B) = a == b
fun <A: Long, B: Double?> eqLongDoubleQ(a: A, b: B) = a == b
fun <A: Long?, B: Double> eqLongQDouble(a: A, b: B) = a == b
fun <A: Long?, B: Double?> eqLongQDoubleQ(a: A, b: B) = a == b
fun <A: Long, B: Long> eqLongLong(a: A, b: B) = a == b
fun <A: Long, B: Long?> eqLongLongQ(a: A, b: B) = a == b
fun <A: Long?, B: Long> eqLongQLong(a: A, b: B) = a == b
fun <A: Long?, B: Long?> eqLongQLongQ(a: A, b: B) = a == b

fun box(): String {
    assertTrue(eqByteByte(0.toByte(), 0.toByte()))
    assertFalse(eqByteByte(0.toByte(), 1.toByte()))
    assertFalse(eqByteByte(1.toByte(), 0.toByte()))
    assertTrue(eqByteByte(1.toByte(), 1.toByte()))
    assertTrue(eqByteByteQ(0.toByte(), 0.toByte()))
    assertFalse(eqByteByteQ(0.toByte(), 1.toByte()))
    assertFalse(eqByteByteQ(0.toByte(), null))
    assertFalse(eqByteByteQ(0.toByte(), undefined))
    assertFalse(eqByteByteQ(1.toByte(), 0.toByte()))
    assertTrue(eqByteByteQ(1.toByte(), 1.toByte()))
    assertFalse(eqByteByteQ(1.toByte(), null))
    assertFalse(eqByteByteQ(1.toByte(), undefined))
    assertTrue(eqByteQByte(0.toByte(), 0.toByte()))
    assertFalse(eqByteQByte(0.toByte(), 1.toByte()))
    assertFalse(eqByteQByte(1.toByte(), 0.toByte()))
    assertTrue(eqByteQByte(1.toByte(), 1.toByte()))
    assertFalse(eqByteQByte(null, 0.toByte()))
    assertFalse(eqByteQByte(null, 1.toByte()))
    assertFalse(eqByteQByte(undefined, 0.toByte()))
    assertFalse(eqByteQByte(undefined, 1.toByte()))
    assertTrue(eqByteQByteQ(0.toByte(), 0.toByte()))
    assertFalse(eqByteQByteQ(0.toByte(), 1.toByte()))
    assertFalse(eqByteQByteQ(0.toByte(), null))
    assertFalse(eqByteQByteQ(0.toByte(), undefined))
    assertFalse(eqByteQByteQ(1.toByte(), 0.toByte()))
    assertTrue(eqByteQByteQ(1.toByte(), 1.toByte()))
    assertFalse(eqByteQByteQ(1.toByte(), null))
    assertFalse(eqByteQByteQ(1.toByte(), undefined))
    assertFalse(eqByteQByteQ(null, 0.toByte()))
    assertFalse(eqByteQByteQ(null, 1.toByte()))
    assertTrue(eqByteQByteQ(null, null))
    assertTrue(eqByteQByteQ(null, undefined))
    assertFalse(eqByteQByteQ(undefined, 0.toByte()))
    assertFalse(eqByteQByteQ(undefined, 1.toByte()))
    assertTrue(eqByteQByteQ(undefined, null))
    assertTrue(eqByteQByteQ(undefined, undefined))
    assertFalse(eqByteBoolean(0.toByte(), false))
    assertFalse(eqByteBoolean(0.toByte(), true))
    assertFalse(eqByteBoolean(1.toByte(), false))
    assertFalse(eqByteBoolean(1.toByte(), true))
    assertFalse(eqByteBooleanQ(0.toByte(), false))
    assertFalse(eqByteBooleanQ(0.toByte(), true))
    assertFalse(eqByteBooleanQ(0.toByte(), null))
    assertFalse(eqByteBooleanQ(0.toByte(), undefined))
    assertFalse(eqByteBooleanQ(1.toByte(), false))
    assertFalse(eqByteBooleanQ(1.toByte(), true))
    assertFalse(eqByteBooleanQ(1.toByte(), null))
    assertFalse(eqByteBooleanQ(1.toByte(), undefined))
    assertFalse(eqByteQBoolean(0.toByte(), false))
    assertFalse(eqByteQBoolean(0.toByte(), true))
    assertFalse(eqByteQBoolean(1.toByte(), false))
    assertFalse(eqByteQBoolean(1.toByte(), true))
    assertFalse(eqByteQBoolean(null, false))
    assertFalse(eqByteQBoolean(null, true))
    assertFalse(eqByteQBoolean(undefined, false))
    assertFalse(eqByteQBoolean(undefined, true))
    assertFalse(eqByteQBooleanQ(0.toByte(), false))
    assertFalse(eqByteQBooleanQ(0.toByte(), true))
    assertFalse(eqByteQBooleanQ(0.toByte(), null))
    assertFalse(eqByteQBooleanQ(0.toByte(), undefined))
    assertFalse(eqByteQBooleanQ(1.toByte(), false))
    assertFalse(eqByteQBooleanQ(1.toByte(), true))
    assertFalse(eqByteQBooleanQ(1.toByte(), null))
    assertFalse(eqByteQBooleanQ(1.toByte(), undefined))
    assertFalse(eqByteQBooleanQ(null, false))
    assertFalse(eqByteQBooleanQ(null, true))
    assertTrue(eqByteQBooleanQ(null, null))
    assertTrue(eqByteQBooleanQ(null, undefined))
    assertFalse(eqByteQBooleanQ(undefined, false))
    assertFalse(eqByteQBooleanQ(undefined, true))
    assertTrue(eqByteQBooleanQ(undefined, null))
    assertTrue(eqByteQBooleanQ(undefined, undefined))
    assertTrue(eqByteShort(0.toByte(), 0.toShort()))
    assertFalse(eqByteShort(0.toByte(), 1.toShort()))
    assertFalse(eqByteShort(1.toByte(), 0.toShort()))
    assertTrue(eqByteShort(1.toByte(), 1.toShort()))
    assertTrue(eqByteShortQ(0.toByte(), 0.toShort()))
    assertFalse(eqByteShortQ(0.toByte(), 1.toShort()))
    assertFalse(eqByteShortQ(0.toByte(), null))
    assertFalse(eqByteShortQ(0.toByte(), undefined))
    assertFalse(eqByteShortQ(1.toByte(), 0.toShort()))
    assertTrue(eqByteShortQ(1.toByte(), 1.toShort()))
    assertFalse(eqByteShortQ(1.toByte(), null))
    assertFalse(eqByteShortQ(1.toByte(), undefined))
    assertTrue(eqByteQShort(0.toByte(), 0.toShort()))
    assertFalse(eqByteQShort(0.toByte(), 1.toShort()))
    assertFalse(eqByteQShort(1.toByte(), 0.toShort()))
    assertTrue(eqByteQShort(1.toByte(), 1.toShort()))
    assertFalse(eqByteQShort(null, 0.toShort()))
    assertFalse(eqByteQShort(null, 1.toShort()))
    assertFalse(eqByteQShort(undefined, 0.toShort()))
    assertFalse(eqByteQShort(undefined, 1.toShort()))
    assertTrue(eqByteQShortQ(0.toByte(), 0.toShort()))
    assertFalse(eqByteQShortQ(0.toByte(), 1.toShort()))
    assertFalse(eqByteQShortQ(0.toByte(), null))
    assertFalse(eqByteQShortQ(0.toByte(), undefined))
    assertFalse(eqByteQShortQ(1.toByte(), 0.toShort()))
    assertTrue(eqByteQShortQ(1.toByte(), 1.toShort()))
    assertFalse(eqByteQShortQ(1.toByte(), null))
    assertFalse(eqByteQShortQ(1.toByte(), undefined))
    assertFalse(eqByteQShortQ(null, 0.toShort()))
    assertFalse(eqByteQShortQ(null, 1.toShort()))
    assertTrue(eqByteQShortQ(null, null))
    assertTrue(eqByteQShortQ(null, undefined))
    assertFalse(eqByteQShortQ(undefined, 0.toShort()))
    assertFalse(eqByteQShortQ(undefined, 1.toShort()))
    assertTrue(eqByteQShortQ(undefined, null))
    assertTrue(eqByteQShortQ(undefined, undefined))
    assertFalse(eqByteChar(0.toByte(), 0.toChar()))
    assertFalse(eqByteChar(0.toByte(), 1.toChar()))
    assertFalse(eqByteChar(1.toByte(), 0.toChar()))
    assertFalse(eqByteChar(1.toByte(), 1.toChar()))
    assertFalse(eqByteCharQ(0.toByte(), 0.toChar()))
    assertFalse(eqByteCharQ(0.toByte(), 1.toChar()))
    assertFalse(eqByteCharQ(0.toByte(), null))
    assertFalse(eqByteCharQ(0.toByte(), undefined))
    assertFalse(eqByteCharQ(1.toByte(), 0.toChar()))
    assertFalse(eqByteCharQ(1.toByte(), 1.toChar()))
    assertFalse(eqByteCharQ(1.toByte(), null))
    assertFalse(eqByteCharQ(1.toByte(), undefined))
    assertFalse(eqByteQChar(0.toByte(), 0.toChar()))
    assertFalse(eqByteQChar(0.toByte(), 1.toChar()))
    assertFalse(eqByteQChar(1.toByte(), 0.toChar()))
    assertFalse(eqByteQChar(1.toByte(), 1.toChar()))
    assertFalse(eqByteQChar(null, 0.toChar()))
    assertFalse(eqByteQChar(null, 1.toChar()))
    assertFalse(eqByteQChar(undefined, 0.toChar()))
    assertFalse(eqByteQChar(undefined, 1.toChar()))
    assertFalse(eqByteQCharQ(0.toByte(), 0.toChar()))
    assertFalse(eqByteQCharQ(0.toByte(), 1.toChar()))
    assertFalse(eqByteQCharQ(0.toByte(), null))
    assertFalse(eqByteQCharQ(0.toByte(), undefined))
    assertFalse(eqByteQCharQ(1.toByte(), 0.toChar()))
    assertFalse(eqByteQCharQ(1.toByte(), 1.toChar()))
    assertFalse(eqByteQCharQ(1.toByte(), null))
    assertFalse(eqByteQCharQ(1.toByte(), undefined))
    assertFalse(eqByteQCharQ(null, 0.toChar()))
    assertFalse(eqByteQCharQ(null, 1.toChar()))
    assertTrue(eqByteQCharQ(null, null))
    assertTrue(eqByteQCharQ(null, undefined))
    assertFalse(eqByteQCharQ(undefined, 0.toChar()))
    assertFalse(eqByteQCharQ(undefined, 1.toChar()))
    assertTrue(eqByteQCharQ(undefined, null))
    assertTrue(eqByteQCharQ(undefined, undefined))
    assertTrue(eqByteInt(0.toByte(), 0.toInt()))
    assertFalse(eqByteInt(0.toByte(), 1.toInt()))
    assertFalse(eqByteInt(1.toByte(), 0.toInt()))
    assertTrue(eqByteInt(1.toByte(), 1.toInt()))
    assertTrue(eqByteIntQ(0.toByte(), 0.toInt()))
    assertFalse(eqByteIntQ(0.toByte(), 1.toInt()))
    assertFalse(eqByteIntQ(0.toByte(), null))
    assertFalse(eqByteIntQ(0.toByte(), undefined))
    assertFalse(eqByteIntQ(1.toByte(), 0.toInt()))
    assertTrue(eqByteIntQ(1.toByte(), 1.toInt()))
    assertFalse(eqByteIntQ(1.toByte(), null))
    assertFalse(eqByteIntQ(1.toByte(), undefined))
    assertTrue(eqByteQInt(0.toByte(), 0.toInt()))
    assertFalse(eqByteQInt(0.toByte(), 1.toInt()))
    assertFalse(eqByteQInt(1.toByte(), 0.toInt()))
    assertTrue(eqByteQInt(1.toByte(), 1.toInt()))
    assertFalse(eqByteQInt(null, 0.toInt()))
    assertFalse(eqByteQInt(null, 1.toInt()))
    assertFalse(eqByteQInt(undefined, 0.toInt()))
    assertFalse(eqByteQInt(undefined, 1.toInt()))
    assertTrue(eqByteQIntQ(0.toByte(), 0.toInt()))
    assertFalse(eqByteQIntQ(0.toByte(), 1.toInt()))
    assertFalse(eqByteQIntQ(0.toByte(), null))
    assertFalse(eqByteQIntQ(0.toByte(), undefined))
    assertFalse(eqByteQIntQ(1.toByte(), 0.toInt()))
    assertTrue(eqByteQIntQ(1.toByte(), 1.toInt()))
    assertFalse(eqByteQIntQ(1.toByte(), null))
    assertFalse(eqByteQIntQ(1.toByte(), undefined))
    assertFalse(eqByteQIntQ(null, 0.toInt()))
    assertFalse(eqByteQIntQ(null, 1.toInt()))
    assertTrue(eqByteQIntQ(null, null))
    assertTrue(eqByteQIntQ(null, undefined))
    assertFalse(eqByteQIntQ(undefined, 0.toInt()))
    assertFalse(eqByteQIntQ(undefined, 1.toInt()))
    assertTrue(eqByteQIntQ(undefined, null))
    assertTrue(eqByteQIntQ(undefined, undefined))
    assertTrue(eqByteFloat(0.toByte(), 0.toFloat()))
    assertFalse(eqByteFloat(0.toByte(), 1.toFloat()))
    assertFalse(eqByteFloat(1.toByte(), 0.toFloat()))
    assertTrue(eqByteFloat(1.toByte(), 1.toFloat()))
    assertTrue(eqByteFloatQ(0.toByte(), 0.toFloat()))
    assertFalse(eqByteFloatQ(0.toByte(), 1.toFloat()))
    assertFalse(eqByteFloatQ(0.toByte(), null))
    assertFalse(eqByteFloatQ(0.toByte(), undefined))
    assertFalse(eqByteFloatQ(1.toByte(), 0.toFloat()))
    assertTrue(eqByteFloatQ(1.toByte(), 1.toFloat()))
    assertFalse(eqByteFloatQ(1.toByte(), null))
    assertFalse(eqByteFloatQ(1.toByte(), undefined))
    assertTrue(eqByteQFloat(0.toByte(), 0.toFloat()))
    assertFalse(eqByteQFloat(0.toByte(), 1.toFloat()))
    assertFalse(eqByteQFloat(1.toByte(), 0.toFloat()))
    assertTrue(eqByteQFloat(1.toByte(), 1.toFloat()))
    assertFalse(eqByteQFloat(null, 0.toFloat()))
    assertFalse(eqByteQFloat(null, 1.toFloat()))
    assertFalse(eqByteQFloat(undefined, 0.toFloat()))
    assertFalse(eqByteQFloat(undefined, 1.toFloat()))
    assertTrue(eqByteQFloatQ(0.toByte(), 0.toFloat()))
    assertFalse(eqByteQFloatQ(0.toByte(), 1.toFloat()))
    assertFalse(eqByteQFloatQ(0.toByte(), null))
    assertFalse(eqByteQFloatQ(0.toByte(), undefined))
    assertFalse(eqByteQFloatQ(1.toByte(), 0.toFloat()))
    assertTrue(eqByteQFloatQ(1.toByte(), 1.toFloat()))
    assertFalse(eqByteQFloatQ(1.toByte(), null))
    assertFalse(eqByteQFloatQ(1.toByte(), undefined))
    assertFalse(eqByteQFloatQ(null, 0.toFloat()))
    assertFalse(eqByteQFloatQ(null, 1.toFloat()))
    assertTrue(eqByteQFloatQ(null, null))
    assertTrue(eqByteQFloatQ(null, undefined))
    assertFalse(eqByteQFloatQ(undefined, 0.toFloat()))
    assertFalse(eqByteQFloatQ(undefined, 1.toFloat()))
    assertTrue(eqByteQFloatQ(undefined, null))
    assertTrue(eqByteQFloatQ(undefined, undefined))
    assertTrue(eqByteDouble(0.toByte(), 0.toDouble()))
    assertFalse(eqByteDouble(0.toByte(), 1.toDouble()))
    assertFalse(eqByteDouble(1.toByte(), 0.toDouble()))
    assertTrue(eqByteDouble(1.toByte(), 1.toDouble()))
    assertTrue(eqByteDoubleQ(0.toByte(), 0.toDouble()))
    assertFalse(eqByteDoubleQ(0.toByte(), 1.toDouble()))
    assertFalse(eqByteDoubleQ(0.toByte(), null))
    assertFalse(eqByteDoubleQ(0.toByte(), undefined))
    assertFalse(eqByteDoubleQ(1.toByte(), 0.toDouble()))
    assertTrue(eqByteDoubleQ(1.toByte(), 1.toDouble()))
    assertFalse(eqByteDoubleQ(1.toByte(), null))
    assertFalse(eqByteDoubleQ(1.toByte(), undefined))
    assertTrue(eqByteQDouble(0.toByte(), 0.toDouble()))
    assertFalse(eqByteQDouble(0.toByte(), 1.toDouble()))
    assertFalse(eqByteQDouble(1.toByte(), 0.toDouble()))
    assertTrue(eqByteQDouble(1.toByte(), 1.toDouble()))
    assertFalse(eqByteQDouble(null, 0.toDouble()))
    assertFalse(eqByteQDouble(null, 1.toDouble()))
    assertFalse(eqByteQDouble(undefined, 0.toDouble()))
    assertFalse(eqByteQDouble(undefined, 1.toDouble()))
    assertTrue(eqByteQDoubleQ(0.toByte(), 0.toDouble()))
    assertFalse(eqByteQDoubleQ(0.toByte(), 1.toDouble()))
    assertFalse(eqByteQDoubleQ(0.toByte(), null))
    assertFalse(eqByteQDoubleQ(0.toByte(), undefined))
    assertFalse(eqByteQDoubleQ(1.toByte(), 0.toDouble()))
    assertTrue(eqByteQDoubleQ(1.toByte(), 1.toDouble()))
    assertFalse(eqByteQDoubleQ(1.toByte(), null))
    assertFalse(eqByteQDoubleQ(1.toByte(), undefined))
    assertFalse(eqByteQDoubleQ(null, 0.toDouble()))
    assertFalse(eqByteQDoubleQ(null, 1.toDouble()))
    assertTrue(eqByteQDoubleQ(null, null))
    assertTrue(eqByteQDoubleQ(null, undefined))
    assertFalse(eqByteQDoubleQ(undefined, 0.toDouble()))
    assertFalse(eqByteQDoubleQ(undefined, 1.toDouble()))
    assertTrue(eqByteQDoubleQ(undefined, null))
    assertTrue(eqByteQDoubleQ(undefined, undefined))
    assertTrue(eqByteLong(0.toByte(), 0.toLong()))
    assertFalse(eqByteLong(0.toByte(), 1.toLong()))
    assertFalse(eqByteLong(1.toByte(), 0.toLong()))
    assertTrue(eqByteLong(1.toByte(), 1.toLong()))
    assertTrue(eqByteLongQ(0.toByte(), 0.toLong()))
    assertFalse(eqByteLongQ(0.toByte(), 1.toLong()))
    assertFalse(eqByteLongQ(0.toByte(), null))
    assertFalse(eqByteLongQ(0.toByte(), undefined))
    assertFalse(eqByteLongQ(1.toByte(), 0.toLong()))
    assertTrue(eqByteLongQ(1.toByte(), 1.toLong()))
    assertFalse(eqByteLongQ(1.toByte(), null))
    assertFalse(eqByteLongQ(1.toByte(), undefined))
    assertTrue(eqByteQLong(0.toByte(), 0.toLong()))
    assertFalse(eqByteQLong(0.toByte(), 1.toLong()))
    assertFalse(eqByteQLong(1.toByte(), 0.toLong()))
    assertTrue(eqByteQLong(1.toByte(), 1.toLong()))
    assertFalse(eqByteQLong(null, 0.toLong()))
    assertFalse(eqByteQLong(null, 1.toLong()))
    assertFalse(eqByteQLong(undefined, 0.toLong()))
    assertFalse(eqByteQLong(undefined, 1.toLong()))
    assertTrue(eqByteQLongQ(0.toByte(), 0.toLong()))
    assertFalse(eqByteQLongQ(0.toByte(), 1.toLong()))
    assertFalse(eqByteQLongQ(0.toByte(), null))
    assertFalse(eqByteQLongQ(0.toByte(), undefined))
    assertFalse(eqByteQLongQ(1.toByte(), 0.toLong()))
    assertTrue(eqByteQLongQ(1.toByte(), 1.toLong()))
    assertFalse(eqByteQLongQ(1.toByte(), null))
    assertFalse(eqByteQLongQ(1.toByte(), undefined))
    assertFalse(eqByteQLongQ(null, 0.toLong()))
    assertFalse(eqByteQLongQ(null, 1.toLong()))
    assertTrue(eqByteQLongQ(null, null))
    assertTrue(eqByteQLongQ(null, undefined))
    assertFalse(eqByteQLongQ(undefined, 0.toLong()))
    assertFalse(eqByteQLongQ(undefined, 1.toLong()))
    assertTrue(eqByteQLongQ(undefined, null))
    assertTrue(eqByteQLongQ(undefined, undefined))
    assertFalse(eqBooleanByte(false, 0.toByte()))
    assertFalse(eqBooleanByte(false, 1.toByte()))
    assertFalse(eqBooleanByte(true, 0.toByte()))
    assertFalse(eqBooleanByte(true, 1.toByte()))
    assertFalse(eqBooleanByteQ(false, 0.toByte()))
    assertFalse(eqBooleanByteQ(false, 1.toByte()))
    assertFalse(eqBooleanByteQ(false, null))
    assertFalse(eqBooleanByteQ(false, undefined))
    assertFalse(eqBooleanByteQ(true, 0.toByte()))
    assertFalse(eqBooleanByteQ(true, 1.toByte()))
    assertFalse(eqBooleanByteQ(true, null))
    assertFalse(eqBooleanByteQ(true, undefined))
    assertFalse(eqBooleanQByte(false, 0.toByte()))
    assertFalse(eqBooleanQByte(false, 1.toByte()))
    assertFalse(eqBooleanQByte(true, 0.toByte()))
    assertFalse(eqBooleanQByte(true, 1.toByte()))
    assertFalse(eqBooleanQByte(null, 0.toByte()))
    assertFalse(eqBooleanQByte(null, 1.toByte()))
    assertFalse(eqBooleanQByte(undefined, 0.toByte()))
    assertFalse(eqBooleanQByte(undefined, 1.toByte()))
    assertFalse(eqBooleanQByteQ(false, 0.toByte()))
    assertFalse(eqBooleanQByteQ(false, 1.toByte()))
    assertFalse(eqBooleanQByteQ(false, null))
    assertFalse(eqBooleanQByteQ(false, undefined))
    assertFalse(eqBooleanQByteQ(true, 0.toByte()))
    assertFalse(eqBooleanQByteQ(true, 1.toByte()))
    assertFalse(eqBooleanQByteQ(true, null))
    assertFalse(eqBooleanQByteQ(true, undefined))
    assertFalse(eqBooleanQByteQ(null, 0.toByte()))
    assertFalse(eqBooleanQByteQ(null, 1.toByte()))
    assertTrue(eqBooleanQByteQ(null, null))
    assertTrue(eqBooleanQByteQ(null, undefined))
    assertFalse(eqBooleanQByteQ(undefined, 0.toByte()))
    assertFalse(eqBooleanQByteQ(undefined, 1.toByte()))
    assertTrue(eqBooleanQByteQ(undefined, null))
    assertTrue(eqBooleanQByteQ(undefined, undefined))
    assertTrue(eqBooleanBoolean(false, false))
    assertFalse(eqBooleanBoolean(false, true))
    assertFalse(eqBooleanBoolean(true, false))
    assertTrue(eqBooleanBoolean(true, true))
    assertTrue(eqBooleanBooleanQ(false, false))
    assertFalse(eqBooleanBooleanQ(false, true))
    assertFalse(eqBooleanBooleanQ(false, null))
    assertFalse(eqBooleanBooleanQ(false, undefined))
    assertFalse(eqBooleanBooleanQ(true, false))
    assertTrue(eqBooleanBooleanQ(true, true))
    assertFalse(eqBooleanBooleanQ(true, null))
    assertFalse(eqBooleanBooleanQ(true, undefined))
    assertTrue(eqBooleanQBoolean(false, false))
    assertFalse(eqBooleanQBoolean(false, true))
    assertFalse(eqBooleanQBoolean(true, false))
    assertTrue(eqBooleanQBoolean(true, true))
    assertFalse(eqBooleanQBoolean(null, false))
    assertFalse(eqBooleanQBoolean(null, true))
    assertFalse(eqBooleanQBoolean(undefined, false))
    assertFalse(eqBooleanQBoolean(undefined, true))
    assertTrue(eqBooleanQBooleanQ(false, false))
    assertFalse(eqBooleanQBooleanQ(false, true))
    assertFalse(eqBooleanQBooleanQ(false, null))
    assertFalse(eqBooleanQBooleanQ(false, undefined))
    assertFalse(eqBooleanQBooleanQ(true, false))
    assertTrue(eqBooleanQBooleanQ(true, true))
    assertFalse(eqBooleanQBooleanQ(true, null))
    assertFalse(eqBooleanQBooleanQ(true, undefined))
    assertFalse(eqBooleanQBooleanQ(null, false))
    assertFalse(eqBooleanQBooleanQ(null, true))
    assertTrue(eqBooleanQBooleanQ(null, null))
    assertTrue(eqBooleanQBooleanQ(null, undefined))
    assertFalse(eqBooleanQBooleanQ(undefined, false))
    assertFalse(eqBooleanQBooleanQ(undefined, true))
    assertTrue(eqBooleanQBooleanQ(undefined, null))
    assertTrue(eqBooleanQBooleanQ(undefined, undefined))
    assertFalse(eqBooleanShort(false, 0.toShort()))
    assertFalse(eqBooleanShort(false, 1.toShort()))
    assertFalse(eqBooleanShort(true, 0.toShort()))
    assertFalse(eqBooleanShort(true, 1.toShort()))
    assertFalse(eqBooleanShortQ(false, 0.toShort()))
    assertFalse(eqBooleanShortQ(false, 1.toShort()))
    assertFalse(eqBooleanShortQ(false, null))
    assertFalse(eqBooleanShortQ(false, undefined))
    assertFalse(eqBooleanShortQ(true, 0.toShort()))
    assertFalse(eqBooleanShortQ(true, 1.toShort()))
    assertFalse(eqBooleanShortQ(true, null))
    assertFalse(eqBooleanShortQ(true, undefined))
    assertFalse(eqBooleanQShort(false, 0.toShort()))
    assertFalse(eqBooleanQShort(false, 1.toShort()))
    assertFalse(eqBooleanQShort(true, 0.toShort()))
    assertFalse(eqBooleanQShort(true, 1.toShort()))
    assertFalse(eqBooleanQShort(null, 0.toShort()))
    assertFalse(eqBooleanQShort(null, 1.toShort()))
    assertFalse(eqBooleanQShort(undefined, 0.toShort()))
    assertFalse(eqBooleanQShort(undefined, 1.toShort()))
    assertFalse(eqBooleanQShortQ(false, 0.toShort()))
    assertFalse(eqBooleanQShortQ(false, 1.toShort()))
    assertFalse(eqBooleanQShortQ(false, null))
    assertFalse(eqBooleanQShortQ(false, undefined))
    assertFalse(eqBooleanQShortQ(true, 0.toShort()))
    assertFalse(eqBooleanQShortQ(true, 1.toShort()))
    assertFalse(eqBooleanQShortQ(true, null))
    assertFalse(eqBooleanQShortQ(true, undefined))
    assertFalse(eqBooleanQShortQ(null, 0.toShort()))
    assertFalse(eqBooleanQShortQ(null, 1.toShort()))
    assertTrue(eqBooleanQShortQ(null, null))
    assertTrue(eqBooleanQShortQ(null, undefined))
    assertFalse(eqBooleanQShortQ(undefined, 0.toShort()))
    assertFalse(eqBooleanQShortQ(undefined, 1.toShort()))
    assertTrue(eqBooleanQShortQ(undefined, null))
    assertTrue(eqBooleanQShortQ(undefined, undefined))
    assertFalse(eqBooleanChar(false, 0.toChar()))
    assertFalse(eqBooleanChar(false, 1.toChar()))
    assertFalse(eqBooleanChar(true, 0.toChar()))
    assertFalse(eqBooleanChar(true, 1.toChar()))
    assertFalse(eqBooleanCharQ(false, 0.toChar()))
    assertFalse(eqBooleanCharQ(false, 1.toChar()))
    assertFalse(eqBooleanCharQ(false, null))
    assertFalse(eqBooleanCharQ(false, undefined))
    assertFalse(eqBooleanCharQ(true, 0.toChar()))
    assertFalse(eqBooleanCharQ(true, 1.toChar()))
    assertFalse(eqBooleanCharQ(true, null))
    assertFalse(eqBooleanCharQ(true, undefined))
    assertFalse(eqBooleanQChar(false, 0.toChar()))
    assertFalse(eqBooleanQChar(false, 1.toChar()))
    assertFalse(eqBooleanQChar(true, 0.toChar()))
    assertFalse(eqBooleanQChar(true, 1.toChar()))
    assertFalse(eqBooleanQChar(null, 0.toChar()))
    assertFalse(eqBooleanQChar(null, 1.toChar()))
    assertFalse(eqBooleanQChar(undefined, 0.toChar()))
    assertFalse(eqBooleanQChar(undefined, 1.toChar()))
    assertFalse(eqBooleanQCharQ(false, 0.toChar()))
    assertFalse(eqBooleanQCharQ(false, 1.toChar()))
    assertFalse(eqBooleanQCharQ(false, null))
    assertFalse(eqBooleanQCharQ(false, undefined))
    assertFalse(eqBooleanQCharQ(true, 0.toChar()))
    assertFalse(eqBooleanQCharQ(true, 1.toChar()))
    assertFalse(eqBooleanQCharQ(true, null))
    assertFalse(eqBooleanQCharQ(true, undefined))
    assertFalse(eqBooleanQCharQ(null, 0.toChar()))
    assertFalse(eqBooleanQCharQ(null, 1.toChar()))
    assertTrue(eqBooleanQCharQ(null, null))
    assertTrue(eqBooleanQCharQ(null, undefined))
    assertFalse(eqBooleanQCharQ(undefined, 0.toChar()))
    assertFalse(eqBooleanQCharQ(undefined, 1.toChar()))
    assertTrue(eqBooleanQCharQ(undefined, null))
    assertTrue(eqBooleanQCharQ(undefined, undefined))
    assertFalse(eqBooleanInt(false, 0.toInt()))
    assertFalse(eqBooleanInt(false, 1.toInt()))
    assertFalse(eqBooleanInt(true, 0.toInt()))
    assertFalse(eqBooleanInt(true, 1.toInt()))
    assertFalse(eqBooleanIntQ(false, 0.toInt()))
    assertFalse(eqBooleanIntQ(false, 1.toInt()))
    assertFalse(eqBooleanIntQ(false, null))
    assertFalse(eqBooleanIntQ(false, undefined))
    assertFalse(eqBooleanIntQ(true, 0.toInt()))
    assertFalse(eqBooleanIntQ(true, 1.toInt()))
    assertFalse(eqBooleanIntQ(true, null))
    assertFalse(eqBooleanIntQ(true, undefined))
    assertFalse(eqBooleanQInt(false, 0.toInt()))
    assertFalse(eqBooleanQInt(false, 1.toInt()))
    assertFalse(eqBooleanQInt(true, 0.toInt()))
    assertFalse(eqBooleanQInt(true, 1.toInt()))
    assertFalse(eqBooleanQInt(null, 0.toInt()))
    assertFalse(eqBooleanQInt(null, 1.toInt()))
    assertFalse(eqBooleanQInt(undefined, 0.toInt()))
    assertFalse(eqBooleanQInt(undefined, 1.toInt()))
    assertFalse(eqBooleanQIntQ(false, 0.toInt()))
    assertFalse(eqBooleanQIntQ(false, 1.toInt()))
    assertFalse(eqBooleanQIntQ(false, null))
    assertFalse(eqBooleanQIntQ(false, undefined))
    assertFalse(eqBooleanQIntQ(true, 0.toInt()))
    assertFalse(eqBooleanQIntQ(true, 1.toInt()))
    assertFalse(eqBooleanQIntQ(true, null))
    assertFalse(eqBooleanQIntQ(true, undefined))
    assertFalse(eqBooleanQIntQ(null, 0.toInt()))
    assertFalse(eqBooleanQIntQ(null, 1.toInt()))
    assertTrue(eqBooleanQIntQ(null, null))
    assertTrue(eqBooleanQIntQ(null, undefined))
    assertFalse(eqBooleanQIntQ(undefined, 0.toInt()))
    assertFalse(eqBooleanQIntQ(undefined, 1.toInt()))
    assertTrue(eqBooleanQIntQ(undefined, null))
    assertTrue(eqBooleanQIntQ(undefined, undefined))
    assertFalse(eqBooleanFloat(false, 0.toFloat()))
    assertFalse(eqBooleanFloat(false, 1.toFloat()))
    assertFalse(eqBooleanFloat(true, 0.toFloat()))
    assertFalse(eqBooleanFloat(true, 1.toFloat()))
    assertFalse(eqBooleanFloatQ(false, 0.toFloat()))
    assertFalse(eqBooleanFloatQ(false, 1.toFloat()))
    assertFalse(eqBooleanFloatQ(false, null))
    assertFalse(eqBooleanFloatQ(false, undefined))
    assertFalse(eqBooleanFloatQ(true, 0.toFloat()))
    assertFalse(eqBooleanFloatQ(true, 1.toFloat()))
    assertFalse(eqBooleanFloatQ(true, null))
    assertFalse(eqBooleanFloatQ(true, undefined))
    assertFalse(eqBooleanQFloat(false, 0.toFloat()))
    assertFalse(eqBooleanQFloat(false, 1.toFloat()))
    assertFalse(eqBooleanQFloat(true, 0.toFloat()))
    assertFalse(eqBooleanQFloat(true, 1.toFloat()))
    assertFalse(eqBooleanQFloat(null, 0.toFloat()))
    assertFalse(eqBooleanQFloat(null, 1.toFloat()))
    assertFalse(eqBooleanQFloat(undefined, 0.toFloat()))
    assertFalse(eqBooleanQFloat(undefined, 1.toFloat()))
    assertFalse(eqBooleanQFloatQ(false, 0.toFloat()))
    assertFalse(eqBooleanQFloatQ(false, 1.toFloat()))
    assertFalse(eqBooleanQFloatQ(false, null))
    assertFalse(eqBooleanQFloatQ(false, undefined))
    assertFalse(eqBooleanQFloatQ(true, 0.toFloat()))
    assertFalse(eqBooleanQFloatQ(true, 1.toFloat()))
    assertFalse(eqBooleanQFloatQ(true, null))
    assertFalse(eqBooleanQFloatQ(true, undefined))
    assertFalse(eqBooleanQFloatQ(null, 0.toFloat()))
    assertFalse(eqBooleanQFloatQ(null, 1.toFloat()))
    assertTrue(eqBooleanQFloatQ(null, null))
    assertTrue(eqBooleanQFloatQ(null, undefined))
    assertFalse(eqBooleanQFloatQ(undefined, 0.toFloat()))
    assertFalse(eqBooleanQFloatQ(undefined, 1.toFloat()))
    assertTrue(eqBooleanQFloatQ(undefined, null))
    assertTrue(eqBooleanQFloatQ(undefined, undefined))
    assertFalse(eqBooleanDouble(false, 0.toDouble()))
    assertFalse(eqBooleanDouble(false, 1.toDouble()))
    assertFalse(eqBooleanDouble(true, 0.toDouble()))
    assertFalse(eqBooleanDouble(true, 1.toDouble()))
    assertFalse(eqBooleanDoubleQ(false, 0.toDouble()))
    assertFalse(eqBooleanDoubleQ(false, 1.toDouble()))
    assertFalse(eqBooleanDoubleQ(false, null))
    assertFalse(eqBooleanDoubleQ(false, undefined))
    assertFalse(eqBooleanDoubleQ(true, 0.toDouble()))
    assertFalse(eqBooleanDoubleQ(true, 1.toDouble()))
    assertFalse(eqBooleanDoubleQ(true, null))
    assertFalse(eqBooleanDoubleQ(true, undefined))
    assertFalse(eqBooleanQDouble(false, 0.toDouble()))
    assertFalse(eqBooleanQDouble(false, 1.toDouble()))
    assertFalse(eqBooleanQDouble(true, 0.toDouble()))
    assertFalse(eqBooleanQDouble(true, 1.toDouble()))
    assertFalse(eqBooleanQDouble(null, 0.toDouble()))
    assertFalse(eqBooleanQDouble(null, 1.toDouble()))
    assertFalse(eqBooleanQDouble(undefined, 0.toDouble()))
    assertFalse(eqBooleanQDouble(undefined, 1.toDouble()))
    assertFalse(eqBooleanQDoubleQ(false, 0.toDouble()))
    assertFalse(eqBooleanQDoubleQ(false, 1.toDouble()))
    assertFalse(eqBooleanQDoubleQ(false, null))
    assertFalse(eqBooleanQDoubleQ(false, undefined))
    assertFalse(eqBooleanQDoubleQ(true, 0.toDouble()))
    assertFalse(eqBooleanQDoubleQ(true, 1.toDouble()))
    assertFalse(eqBooleanQDoubleQ(true, null))
    assertFalse(eqBooleanQDoubleQ(true, undefined))
    assertFalse(eqBooleanQDoubleQ(null, 0.toDouble()))
    assertFalse(eqBooleanQDoubleQ(null, 1.toDouble()))
    assertTrue(eqBooleanQDoubleQ(null, null))
    assertTrue(eqBooleanQDoubleQ(null, undefined))
    assertFalse(eqBooleanQDoubleQ(undefined, 0.toDouble()))
    assertFalse(eqBooleanQDoubleQ(undefined, 1.toDouble()))
    assertTrue(eqBooleanQDoubleQ(undefined, null))
    assertTrue(eqBooleanQDoubleQ(undefined, undefined))
    assertFalse(eqBooleanLong(false, 0.toLong()))
    assertFalse(eqBooleanLong(false, 1.toLong()))
    assertFalse(eqBooleanLong(true, 0.toLong()))
    assertFalse(eqBooleanLong(true, 1.toLong()))
    assertFalse(eqBooleanLongQ(false, 0.toLong()))
    assertFalse(eqBooleanLongQ(false, 1.toLong()))
    assertFalse(eqBooleanLongQ(false, null))
    assertFalse(eqBooleanLongQ(false, undefined))
    assertFalse(eqBooleanLongQ(true, 0.toLong()))
    assertFalse(eqBooleanLongQ(true, 1.toLong()))
    assertFalse(eqBooleanLongQ(true, null))
    assertFalse(eqBooleanLongQ(true, undefined))
    assertFalse(eqBooleanQLong(false, 0.toLong()))
    assertFalse(eqBooleanQLong(false, 1.toLong()))
    assertFalse(eqBooleanQLong(true, 0.toLong()))
    assertFalse(eqBooleanQLong(true, 1.toLong()))
    assertFalse(eqBooleanQLong(null, 0.toLong()))
    assertFalse(eqBooleanQLong(null, 1.toLong()))
    assertFalse(eqBooleanQLong(undefined, 0.toLong()))
    assertFalse(eqBooleanQLong(undefined, 1.toLong()))
    assertFalse(eqBooleanQLongQ(false, 0.toLong()))
    assertFalse(eqBooleanQLongQ(false, 1.toLong()))
    assertFalse(eqBooleanQLongQ(false, null))
    assertFalse(eqBooleanQLongQ(false, undefined))
    assertFalse(eqBooleanQLongQ(true, 0.toLong()))
    assertFalse(eqBooleanQLongQ(true, 1.toLong()))
    assertFalse(eqBooleanQLongQ(true, null))
    assertFalse(eqBooleanQLongQ(true, undefined))
    assertFalse(eqBooleanQLongQ(null, 0.toLong()))
    assertFalse(eqBooleanQLongQ(null, 1.toLong()))
    assertTrue(eqBooleanQLongQ(null, null))
    assertTrue(eqBooleanQLongQ(null, undefined))
    assertFalse(eqBooleanQLongQ(undefined, 0.toLong()))
    assertFalse(eqBooleanQLongQ(undefined, 1.toLong()))
    assertTrue(eqBooleanQLongQ(undefined, null))
    assertTrue(eqBooleanQLongQ(undefined, undefined))
    assertTrue(eqShortByte(0.toShort(), 0.toByte()))
    assertFalse(eqShortByte(0.toShort(), 1.toByte()))
    assertFalse(eqShortByte(1.toShort(), 0.toByte()))
    assertTrue(eqShortByte(1.toShort(), 1.toByte()))
    assertTrue(eqShortByteQ(0.toShort(), 0.toByte()))
    assertFalse(eqShortByteQ(0.toShort(), 1.toByte()))
    assertFalse(eqShortByteQ(0.toShort(), null))
    assertFalse(eqShortByteQ(0.toShort(), undefined))
    assertFalse(eqShortByteQ(1.toShort(), 0.toByte()))
    assertTrue(eqShortByteQ(1.toShort(), 1.toByte()))
    assertFalse(eqShortByteQ(1.toShort(), null))
    assertFalse(eqShortByteQ(1.toShort(), undefined))
    assertTrue(eqShortQByte(0.toShort(), 0.toByte()))
    assertFalse(eqShortQByte(0.toShort(), 1.toByte()))
    assertFalse(eqShortQByte(1.toShort(), 0.toByte()))
    assertTrue(eqShortQByte(1.toShort(), 1.toByte()))
    assertFalse(eqShortQByte(null, 0.toByte()))
    assertFalse(eqShortQByte(null, 1.toByte()))
    assertFalse(eqShortQByte(undefined, 0.toByte()))
    assertFalse(eqShortQByte(undefined, 1.toByte()))
    assertTrue(eqShortQByteQ(0.toShort(), 0.toByte()))
    assertFalse(eqShortQByteQ(0.toShort(), 1.toByte()))
    assertFalse(eqShortQByteQ(0.toShort(), null))
    assertFalse(eqShortQByteQ(0.toShort(), undefined))
    assertFalse(eqShortQByteQ(1.toShort(), 0.toByte()))
    assertTrue(eqShortQByteQ(1.toShort(), 1.toByte()))
    assertFalse(eqShortQByteQ(1.toShort(), null))
    assertFalse(eqShortQByteQ(1.toShort(), undefined))
    assertFalse(eqShortQByteQ(null, 0.toByte()))
    assertFalse(eqShortQByteQ(null, 1.toByte()))
    assertTrue(eqShortQByteQ(null, null))
    assertTrue(eqShortQByteQ(null, undefined))
    assertFalse(eqShortQByteQ(undefined, 0.toByte()))
    assertFalse(eqShortQByteQ(undefined, 1.toByte()))
    assertTrue(eqShortQByteQ(undefined, null))
    assertTrue(eqShortQByteQ(undefined, undefined))
    assertFalse(eqShortBoolean(0.toShort(), false))
    assertFalse(eqShortBoolean(0.toShort(), true))
    assertFalse(eqShortBoolean(1.toShort(), false))
    assertFalse(eqShortBoolean(1.toShort(), true))
    assertFalse(eqShortBooleanQ(0.toShort(), false))
    assertFalse(eqShortBooleanQ(0.toShort(), true))
    assertFalse(eqShortBooleanQ(0.toShort(), null))
    assertFalse(eqShortBooleanQ(0.toShort(), undefined))
    assertFalse(eqShortBooleanQ(1.toShort(), false))
    assertFalse(eqShortBooleanQ(1.toShort(), true))
    assertFalse(eqShortBooleanQ(1.toShort(), null))
    assertFalse(eqShortBooleanQ(1.toShort(), undefined))
    assertFalse(eqShortQBoolean(0.toShort(), false))
    assertFalse(eqShortQBoolean(0.toShort(), true))
    assertFalse(eqShortQBoolean(1.toShort(), false))
    assertFalse(eqShortQBoolean(1.toShort(), true))
    assertFalse(eqShortQBoolean(null, false))
    assertFalse(eqShortQBoolean(null, true))
    assertFalse(eqShortQBoolean(undefined, false))
    assertFalse(eqShortQBoolean(undefined, true))
    assertFalse(eqShortQBooleanQ(0.toShort(), false))
    assertFalse(eqShortQBooleanQ(0.toShort(), true))
    assertFalse(eqShortQBooleanQ(0.toShort(), null))
    assertFalse(eqShortQBooleanQ(0.toShort(), undefined))
    assertFalse(eqShortQBooleanQ(1.toShort(), false))
    assertFalse(eqShortQBooleanQ(1.toShort(), true))
    assertFalse(eqShortQBooleanQ(1.toShort(), null))
    assertFalse(eqShortQBooleanQ(1.toShort(), undefined))
    assertFalse(eqShortQBooleanQ(null, false))
    assertFalse(eqShortQBooleanQ(null, true))
    assertTrue(eqShortQBooleanQ(null, null))
    assertTrue(eqShortQBooleanQ(null, undefined))
    assertFalse(eqShortQBooleanQ(undefined, false))
    assertFalse(eqShortQBooleanQ(undefined, true))
    assertTrue(eqShortQBooleanQ(undefined, null))
    assertTrue(eqShortQBooleanQ(undefined, undefined))
    assertTrue(eqShortShort(0.toShort(), 0.toShort()))
    assertFalse(eqShortShort(0.toShort(), 1.toShort()))
    assertFalse(eqShortShort(1.toShort(), 0.toShort()))
    assertTrue(eqShortShort(1.toShort(), 1.toShort()))
    assertTrue(eqShortShortQ(0.toShort(), 0.toShort()))
    assertFalse(eqShortShortQ(0.toShort(), 1.toShort()))
    assertFalse(eqShortShortQ(0.toShort(), null))
    assertFalse(eqShortShortQ(0.toShort(), undefined))
    assertFalse(eqShortShortQ(1.toShort(), 0.toShort()))
    assertTrue(eqShortShortQ(1.toShort(), 1.toShort()))
    assertFalse(eqShortShortQ(1.toShort(), null))
    assertFalse(eqShortShortQ(1.toShort(), undefined))
    assertTrue(eqShortQShort(0.toShort(), 0.toShort()))
    assertFalse(eqShortQShort(0.toShort(), 1.toShort()))
    assertFalse(eqShortQShort(1.toShort(), 0.toShort()))
    assertTrue(eqShortQShort(1.toShort(), 1.toShort()))
    assertFalse(eqShortQShort(null, 0.toShort()))
    assertFalse(eqShortQShort(null, 1.toShort()))
    assertFalse(eqShortQShort(undefined, 0.toShort()))
    assertFalse(eqShortQShort(undefined, 1.toShort()))
    assertTrue(eqShortQShortQ(0.toShort(), 0.toShort()))
    assertFalse(eqShortQShortQ(0.toShort(), 1.toShort()))
    assertFalse(eqShortQShortQ(0.toShort(), null))
    assertFalse(eqShortQShortQ(0.toShort(), undefined))
    assertFalse(eqShortQShortQ(1.toShort(), 0.toShort()))
    assertTrue(eqShortQShortQ(1.toShort(), 1.toShort()))
    assertFalse(eqShortQShortQ(1.toShort(), null))
    assertFalse(eqShortQShortQ(1.toShort(), undefined))
    assertFalse(eqShortQShortQ(null, 0.toShort()))
    assertFalse(eqShortQShortQ(null, 1.toShort()))
    assertTrue(eqShortQShortQ(null, null))
    assertTrue(eqShortQShortQ(null, undefined))
    assertFalse(eqShortQShortQ(undefined, 0.toShort()))
    assertFalse(eqShortQShortQ(undefined, 1.toShort()))
    assertTrue(eqShortQShortQ(undefined, null))
    assertTrue(eqShortQShortQ(undefined, undefined))
    assertFalse(eqShortChar(0.toShort(), 0.toChar()))
    assertFalse(eqShortChar(0.toShort(), 1.toChar()))
    assertFalse(eqShortChar(1.toShort(), 0.toChar()))
    assertFalse(eqShortChar(1.toShort(), 1.toChar()))
    assertFalse(eqShortCharQ(0.toShort(), 0.toChar()))
    assertFalse(eqShortCharQ(0.toShort(), 1.toChar()))
    assertFalse(eqShortCharQ(0.toShort(), null))
    assertFalse(eqShortCharQ(0.toShort(), undefined))
    assertFalse(eqShortCharQ(1.toShort(), 0.toChar()))
    assertFalse(eqShortCharQ(1.toShort(), 1.toChar()))
    assertFalse(eqShortCharQ(1.toShort(), null))
    assertFalse(eqShortCharQ(1.toShort(), undefined))
    assertFalse(eqShortQChar(0.toShort(), 0.toChar()))
    assertFalse(eqShortQChar(0.toShort(), 1.toChar()))
    assertFalse(eqShortQChar(1.toShort(), 0.toChar()))
    assertFalse(eqShortQChar(1.toShort(), 1.toChar()))
    assertFalse(eqShortQChar(null, 0.toChar()))
    assertFalse(eqShortQChar(null, 1.toChar()))
    assertFalse(eqShortQChar(undefined, 0.toChar()))
    assertFalse(eqShortQChar(undefined, 1.toChar()))
    assertFalse(eqShortQCharQ(0.toShort(), 0.toChar()))
    assertFalse(eqShortQCharQ(0.toShort(), 1.toChar()))
    assertFalse(eqShortQCharQ(0.toShort(), null))
    assertFalse(eqShortQCharQ(0.toShort(), undefined))
    assertFalse(eqShortQCharQ(1.toShort(), 0.toChar()))
    assertFalse(eqShortQCharQ(1.toShort(), 1.toChar()))
    assertFalse(eqShortQCharQ(1.toShort(), null))
    assertFalse(eqShortQCharQ(1.toShort(), undefined))
    assertFalse(eqShortQCharQ(null, 0.toChar()))
    assertFalse(eqShortQCharQ(null, 1.toChar()))
    assertTrue(eqShortQCharQ(null, null))
    assertTrue(eqShortQCharQ(null, undefined))
    assertFalse(eqShortQCharQ(undefined, 0.toChar()))
    assertFalse(eqShortQCharQ(undefined, 1.toChar()))
    assertTrue(eqShortQCharQ(undefined, null))
    assertTrue(eqShortQCharQ(undefined, undefined))
    assertTrue(eqShortInt(0.toShort(), 0.toInt()))
    assertFalse(eqShortInt(0.toShort(), 1.toInt()))
    assertFalse(eqShortInt(1.toShort(), 0.toInt()))
    assertTrue(eqShortInt(1.toShort(), 1.toInt()))
    assertTrue(eqShortIntQ(0.toShort(), 0.toInt()))
    assertFalse(eqShortIntQ(0.toShort(), 1.toInt()))
    assertFalse(eqShortIntQ(0.toShort(), null))
    assertFalse(eqShortIntQ(0.toShort(), undefined))
    assertFalse(eqShortIntQ(1.toShort(), 0.toInt()))
    assertTrue(eqShortIntQ(1.toShort(), 1.toInt()))
    assertFalse(eqShortIntQ(1.toShort(), null))
    assertFalse(eqShortIntQ(1.toShort(), undefined))
    assertTrue(eqShortQInt(0.toShort(), 0.toInt()))
    assertFalse(eqShortQInt(0.toShort(), 1.toInt()))
    assertFalse(eqShortQInt(1.toShort(), 0.toInt()))
    assertTrue(eqShortQInt(1.toShort(), 1.toInt()))
    assertFalse(eqShortQInt(null, 0.toInt()))
    assertFalse(eqShortQInt(null, 1.toInt()))
    assertFalse(eqShortQInt(undefined, 0.toInt()))
    assertFalse(eqShortQInt(undefined, 1.toInt()))
    assertTrue(eqShortQIntQ(0.toShort(), 0.toInt()))
    assertFalse(eqShortQIntQ(0.toShort(), 1.toInt()))
    assertFalse(eqShortQIntQ(0.toShort(), null))
    assertFalse(eqShortQIntQ(0.toShort(), undefined))
    assertFalse(eqShortQIntQ(1.toShort(), 0.toInt()))
    assertTrue(eqShortQIntQ(1.toShort(), 1.toInt()))
    assertFalse(eqShortQIntQ(1.toShort(), null))
    assertFalse(eqShortQIntQ(1.toShort(), undefined))
    assertFalse(eqShortQIntQ(null, 0.toInt()))
    assertFalse(eqShortQIntQ(null, 1.toInt()))
    assertTrue(eqShortQIntQ(null, null))
    assertTrue(eqShortQIntQ(null, undefined))
    assertFalse(eqShortQIntQ(undefined, 0.toInt()))
    assertFalse(eqShortQIntQ(undefined, 1.toInt()))
    assertTrue(eqShortQIntQ(undefined, null))
    assertTrue(eqShortQIntQ(undefined, undefined))
    assertTrue(eqShortFloat(0.toShort(), 0.toFloat()))
    assertFalse(eqShortFloat(0.toShort(), 1.toFloat()))
    assertFalse(eqShortFloat(1.toShort(), 0.toFloat()))
    assertTrue(eqShortFloat(1.toShort(), 1.toFloat()))
    assertTrue(eqShortFloatQ(0.toShort(), 0.toFloat()))
    assertFalse(eqShortFloatQ(0.toShort(), 1.toFloat()))
    assertFalse(eqShortFloatQ(0.toShort(), null))
    assertFalse(eqShortFloatQ(0.toShort(), undefined))
    assertFalse(eqShortFloatQ(1.toShort(), 0.toFloat()))
    assertTrue(eqShortFloatQ(1.toShort(), 1.toFloat()))
    assertFalse(eqShortFloatQ(1.toShort(), null))
    assertFalse(eqShortFloatQ(1.toShort(), undefined))
    assertTrue(eqShortQFloat(0.toShort(), 0.toFloat()))
    assertFalse(eqShortQFloat(0.toShort(), 1.toFloat()))
    assertFalse(eqShortQFloat(1.toShort(), 0.toFloat()))
    assertTrue(eqShortQFloat(1.toShort(), 1.toFloat()))
    assertFalse(eqShortQFloat(null, 0.toFloat()))
    assertFalse(eqShortQFloat(null, 1.toFloat()))
    assertFalse(eqShortQFloat(undefined, 0.toFloat()))
    assertFalse(eqShortQFloat(undefined, 1.toFloat()))
    assertTrue(eqShortQFloatQ(0.toShort(), 0.toFloat()))
    assertFalse(eqShortQFloatQ(0.toShort(), 1.toFloat()))
    assertFalse(eqShortQFloatQ(0.toShort(), null))
    assertFalse(eqShortQFloatQ(0.toShort(), undefined))
    assertFalse(eqShortQFloatQ(1.toShort(), 0.toFloat()))
    assertTrue(eqShortQFloatQ(1.toShort(), 1.toFloat()))
    assertFalse(eqShortQFloatQ(1.toShort(), null))
    assertFalse(eqShortQFloatQ(1.toShort(), undefined))
    assertFalse(eqShortQFloatQ(null, 0.toFloat()))
    assertFalse(eqShortQFloatQ(null, 1.toFloat()))
    assertTrue(eqShortQFloatQ(null, null))
    assertTrue(eqShortQFloatQ(null, undefined))
    assertFalse(eqShortQFloatQ(undefined, 0.toFloat()))
    assertFalse(eqShortQFloatQ(undefined, 1.toFloat()))
    assertTrue(eqShortQFloatQ(undefined, null))
    assertTrue(eqShortQFloatQ(undefined, undefined))
    assertTrue(eqShortDouble(0.toShort(), 0.toDouble()))
    assertFalse(eqShortDouble(0.toShort(), 1.toDouble()))
    assertFalse(eqShortDouble(1.toShort(), 0.toDouble()))
    assertTrue(eqShortDouble(1.toShort(), 1.toDouble()))
    assertTrue(eqShortDoubleQ(0.toShort(), 0.toDouble()))
    assertFalse(eqShortDoubleQ(0.toShort(), 1.toDouble()))
    assertFalse(eqShortDoubleQ(0.toShort(), null))
    assertFalse(eqShortDoubleQ(0.toShort(), undefined))
    assertFalse(eqShortDoubleQ(1.toShort(), 0.toDouble()))
    assertTrue(eqShortDoubleQ(1.toShort(), 1.toDouble()))
    assertFalse(eqShortDoubleQ(1.toShort(), null))
    assertFalse(eqShortDoubleQ(1.toShort(), undefined))
    assertTrue(eqShortQDouble(0.toShort(), 0.toDouble()))
    assertFalse(eqShortQDouble(0.toShort(), 1.toDouble()))
    assertFalse(eqShortQDouble(1.toShort(), 0.toDouble()))
    assertTrue(eqShortQDouble(1.toShort(), 1.toDouble()))
    assertFalse(eqShortQDouble(null, 0.toDouble()))
    assertFalse(eqShortQDouble(null, 1.toDouble()))
    assertFalse(eqShortQDouble(undefined, 0.toDouble()))
    assertFalse(eqShortQDouble(undefined, 1.toDouble()))
    assertTrue(eqShortQDoubleQ(0.toShort(), 0.toDouble()))
    assertFalse(eqShortQDoubleQ(0.toShort(), 1.toDouble()))
    assertFalse(eqShortQDoubleQ(0.toShort(), null))
    assertFalse(eqShortQDoubleQ(0.toShort(), undefined))
    assertFalse(eqShortQDoubleQ(1.toShort(), 0.toDouble()))
    assertTrue(eqShortQDoubleQ(1.toShort(), 1.toDouble()))
    assertFalse(eqShortQDoubleQ(1.toShort(), null))
    assertFalse(eqShortQDoubleQ(1.toShort(), undefined))
    assertFalse(eqShortQDoubleQ(null, 0.toDouble()))
    assertFalse(eqShortQDoubleQ(null, 1.toDouble()))
    assertTrue(eqShortQDoubleQ(null, null))
    assertTrue(eqShortQDoubleQ(null, undefined))
    assertFalse(eqShortQDoubleQ(undefined, 0.toDouble()))
    assertFalse(eqShortQDoubleQ(undefined, 1.toDouble()))
    assertTrue(eqShortQDoubleQ(undefined, null))
    assertTrue(eqShortQDoubleQ(undefined, undefined))
    assertTrue(eqShortLong(0.toShort(), 0.toLong()))
    assertFalse(eqShortLong(0.toShort(), 1.toLong()))
    assertFalse(eqShortLong(1.toShort(), 0.toLong()))
    assertTrue(eqShortLong(1.toShort(), 1.toLong()))
    assertTrue(eqShortLongQ(0.toShort(), 0.toLong()))
    assertFalse(eqShortLongQ(0.toShort(), 1.toLong()))
    assertFalse(eqShortLongQ(0.toShort(), null))
    assertFalse(eqShortLongQ(0.toShort(), undefined))
    assertFalse(eqShortLongQ(1.toShort(), 0.toLong()))
    assertTrue(eqShortLongQ(1.toShort(), 1.toLong()))
    assertFalse(eqShortLongQ(1.toShort(), null))
    assertFalse(eqShortLongQ(1.toShort(), undefined))
    assertTrue(eqShortQLong(0.toShort(), 0.toLong()))
    assertFalse(eqShortQLong(0.toShort(), 1.toLong()))
    assertFalse(eqShortQLong(1.toShort(), 0.toLong()))
    assertTrue(eqShortQLong(1.toShort(), 1.toLong()))
    assertFalse(eqShortQLong(null, 0.toLong()))
    assertFalse(eqShortQLong(null, 1.toLong()))
    assertFalse(eqShortQLong(undefined, 0.toLong()))
    assertFalse(eqShortQLong(undefined, 1.toLong()))
    assertTrue(eqShortQLongQ(0.toShort(), 0.toLong()))
    assertFalse(eqShortQLongQ(0.toShort(), 1.toLong()))
    assertFalse(eqShortQLongQ(0.toShort(), null))
    assertFalse(eqShortQLongQ(0.toShort(), undefined))
    assertFalse(eqShortQLongQ(1.toShort(), 0.toLong()))
    assertTrue(eqShortQLongQ(1.toShort(), 1.toLong()))
    assertFalse(eqShortQLongQ(1.toShort(), null))
    assertFalse(eqShortQLongQ(1.toShort(), undefined))
    assertFalse(eqShortQLongQ(null, 0.toLong()))
    assertFalse(eqShortQLongQ(null, 1.toLong()))
    assertTrue(eqShortQLongQ(null, null))
    assertTrue(eqShortQLongQ(null, undefined))
    assertFalse(eqShortQLongQ(undefined, 0.toLong()))
    assertFalse(eqShortQLongQ(undefined, 1.toLong()))
    assertTrue(eqShortQLongQ(undefined, null))
    assertTrue(eqShortQLongQ(undefined, undefined))
    assertFalse(eqCharByte(0.toChar(), 0.toByte()))
    assertFalse(eqCharByte(0.toChar(), 1.toByte()))
    assertFalse(eqCharByte(1.toChar(), 0.toByte()))
    assertFalse(eqCharByte(1.toChar(), 1.toByte()))
    assertFalse(eqCharByteQ(0.toChar(), 0.toByte()))
    assertFalse(eqCharByteQ(0.toChar(), 1.toByte()))
    assertFalse(eqCharByteQ(0.toChar(), null))
    assertFalse(eqCharByteQ(0.toChar(), undefined))
    assertFalse(eqCharByteQ(1.toChar(), 0.toByte()))
    assertFalse(eqCharByteQ(1.toChar(), 1.toByte()))
    assertFalse(eqCharByteQ(1.toChar(), null))
    assertFalse(eqCharByteQ(1.toChar(), undefined))
    assertFalse(eqCharQByte(0.toChar(), 0.toByte()))
    assertFalse(eqCharQByte(0.toChar(), 1.toByte()))
    assertFalse(eqCharQByte(1.toChar(), 0.toByte()))
    assertFalse(eqCharQByte(1.toChar(), 1.toByte()))
    assertFalse(eqCharQByte(null, 0.toByte()))
    assertFalse(eqCharQByte(null, 1.toByte()))
    assertFalse(eqCharQByte(undefined, 0.toByte()))
    assertFalse(eqCharQByte(undefined, 1.toByte()))
    assertFalse(eqCharQByteQ(0.toChar(), 0.toByte()))
    assertFalse(eqCharQByteQ(0.toChar(), 1.toByte()))
    assertFalse(eqCharQByteQ(0.toChar(), null))
    assertFalse(eqCharQByteQ(0.toChar(), undefined))
    assertFalse(eqCharQByteQ(1.toChar(), 0.toByte()))
    assertFalse(eqCharQByteQ(1.toChar(), 1.toByte()))
    assertFalse(eqCharQByteQ(1.toChar(), null))
    assertFalse(eqCharQByteQ(1.toChar(), undefined))
    assertFalse(eqCharQByteQ(null, 0.toByte()))
    assertFalse(eqCharQByteQ(null, 1.toByte()))
    assertTrue(eqCharQByteQ(null, null))
    assertTrue(eqCharQByteQ(null, undefined))
    assertFalse(eqCharQByteQ(undefined, 0.toByte()))
    assertFalse(eqCharQByteQ(undefined, 1.toByte()))
    assertTrue(eqCharQByteQ(undefined, null))
    assertTrue(eqCharQByteQ(undefined, undefined))
    assertFalse(eqCharBoolean(0.toChar(), false))
    assertFalse(eqCharBoolean(0.toChar(), true))
    assertFalse(eqCharBoolean(1.toChar(), false))
    assertFalse(eqCharBoolean(1.toChar(), true))
    assertFalse(eqCharBooleanQ(0.toChar(), false))
    assertFalse(eqCharBooleanQ(0.toChar(), true))
    assertFalse(eqCharBooleanQ(0.toChar(), null))
    assertFalse(eqCharBooleanQ(0.toChar(), undefined))
    assertFalse(eqCharBooleanQ(1.toChar(), false))
    assertFalse(eqCharBooleanQ(1.toChar(), true))
    assertFalse(eqCharBooleanQ(1.toChar(), null))
    assertFalse(eqCharBooleanQ(1.toChar(), undefined))
    assertFalse(eqCharQBoolean(0.toChar(), false))
    assertFalse(eqCharQBoolean(0.toChar(), true))
    assertFalse(eqCharQBoolean(1.toChar(), false))
    assertFalse(eqCharQBoolean(1.toChar(), true))
    assertFalse(eqCharQBoolean(null, false))
    assertFalse(eqCharQBoolean(null, true))
    assertFalse(eqCharQBoolean(undefined, false))
    assertFalse(eqCharQBoolean(undefined, true))
    assertFalse(eqCharQBooleanQ(0.toChar(), false))
    assertFalse(eqCharQBooleanQ(0.toChar(), true))
    assertFalse(eqCharQBooleanQ(0.toChar(), null))
    assertFalse(eqCharQBooleanQ(0.toChar(), undefined))
    assertFalse(eqCharQBooleanQ(1.toChar(), false))
    assertFalse(eqCharQBooleanQ(1.toChar(), true))
    assertFalse(eqCharQBooleanQ(1.toChar(), null))
    assertFalse(eqCharQBooleanQ(1.toChar(), undefined))
    assertFalse(eqCharQBooleanQ(null, false))
    assertFalse(eqCharQBooleanQ(null, true))
    assertTrue(eqCharQBooleanQ(null, null))
    assertTrue(eqCharQBooleanQ(null, undefined))
    assertFalse(eqCharQBooleanQ(undefined, false))
    assertFalse(eqCharQBooleanQ(undefined, true))
    assertTrue(eqCharQBooleanQ(undefined, null))
    assertTrue(eqCharQBooleanQ(undefined, undefined))
    assertFalse(eqCharShort(0.toChar(), 0.toShort()))
    assertFalse(eqCharShort(0.toChar(), 1.toShort()))
    assertFalse(eqCharShort(1.toChar(), 0.toShort()))
    assertFalse(eqCharShort(1.toChar(), 1.toShort()))
    assertFalse(eqCharShortQ(0.toChar(), 0.toShort()))
    assertFalse(eqCharShortQ(0.toChar(), 1.toShort()))
    assertFalse(eqCharShortQ(0.toChar(), null))
    assertFalse(eqCharShortQ(0.toChar(), undefined))
    assertFalse(eqCharShortQ(1.toChar(), 0.toShort()))
    assertFalse(eqCharShortQ(1.toChar(), 1.toShort()))
    assertFalse(eqCharShortQ(1.toChar(), null))
    assertFalse(eqCharShortQ(1.toChar(), undefined))
    assertFalse(eqCharQShort(0.toChar(), 0.toShort()))
    assertFalse(eqCharQShort(0.toChar(), 1.toShort()))
    assertFalse(eqCharQShort(1.toChar(), 0.toShort()))
    assertFalse(eqCharQShort(1.toChar(), 1.toShort()))
    assertFalse(eqCharQShort(null, 0.toShort()))
    assertFalse(eqCharQShort(null, 1.toShort()))
    assertFalse(eqCharQShort(undefined, 0.toShort()))
    assertFalse(eqCharQShort(undefined, 1.toShort()))
    assertFalse(eqCharQShortQ(0.toChar(), 0.toShort()))
    assertFalse(eqCharQShortQ(0.toChar(), 1.toShort()))
    assertFalse(eqCharQShortQ(0.toChar(), null))
    assertFalse(eqCharQShortQ(0.toChar(), undefined))
    assertFalse(eqCharQShortQ(1.toChar(), 0.toShort()))
    assertFalse(eqCharQShortQ(1.toChar(), 1.toShort()))
    assertFalse(eqCharQShortQ(1.toChar(), null))
    assertFalse(eqCharQShortQ(1.toChar(), undefined))
    assertFalse(eqCharQShortQ(null, 0.toShort()))
    assertFalse(eqCharQShortQ(null, 1.toShort()))
    assertTrue(eqCharQShortQ(null, null))
    assertTrue(eqCharQShortQ(null, undefined))
    assertFalse(eqCharQShortQ(undefined, 0.toShort()))
    assertFalse(eqCharQShortQ(undefined, 1.toShort()))
    assertTrue(eqCharQShortQ(undefined, null))
    assertTrue(eqCharQShortQ(undefined, undefined))
    assertTrue(eqCharChar(0.toChar(), 0.toChar()))
    assertFalse(eqCharChar(0.toChar(), 1.toChar()))
    assertFalse(eqCharChar(1.toChar(), 0.toChar()))
    assertTrue(eqCharChar(1.toChar(), 1.toChar()))
    assertTrue(eqCharCharQ(0.toChar(), 0.toChar()))
    assertFalse(eqCharCharQ(0.toChar(), 1.toChar()))
    assertFalse(eqCharCharQ(0.toChar(), null))
    assertFalse(eqCharCharQ(0.toChar(), undefined))
    assertFalse(eqCharCharQ(1.toChar(), 0.toChar()))
    assertTrue(eqCharCharQ(1.toChar(), 1.toChar()))
    assertFalse(eqCharCharQ(1.toChar(), null))
    assertFalse(eqCharCharQ(1.toChar(), undefined))
    assertTrue(eqCharQChar(0.toChar(), 0.toChar()))
    assertFalse(eqCharQChar(0.toChar(), 1.toChar()))
    assertFalse(eqCharQChar(1.toChar(), 0.toChar()))
    assertTrue(eqCharQChar(1.toChar(), 1.toChar()))
    assertFalse(eqCharQChar(null, 0.toChar()))
    assertFalse(eqCharQChar(null, 1.toChar()))
    assertFalse(eqCharQChar(undefined, 0.toChar()))
    assertFalse(eqCharQChar(undefined, 1.toChar()))
    assertTrue(eqCharQCharQ(0.toChar(), 0.toChar()))
    assertFalse(eqCharQCharQ(0.toChar(), 1.toChar()))
    assertFalse(eqCharQCharQ(0.toChar(), null))
    assertFalse(eqCharQCharQ(0.toChar(), undefined))
    assertFalse(eqCharQCharQ(1.toChar(), 0.toChar()))
    assertTrue(eqCharQCharQ(1.toChar(), 1.toChar()))
    assertFalse(eqCharQCharQ(1.toChar(), null))
    assertFalse(eqCharQCharQ(1.toChar(), undefined))
    assertFalse(eqCharQCharQ(null, 0.toChar()))
    assertFalse(eqCharQCharQ(null, 1.toChar()))
    assertTrue(eqCharQCharQ(null, null))
    assertTrue(eqCharQCharQ(null, undefined))
    assertFalse(eqCharQCharQ(undefined, 0.toChar()))
    assertFalse(eqCharQCharQ(undefined, 1.toChar()))
    assertTrue(eqCharQCharQ(undefined, null))
    assertTrue(eqCharQCharQ(undefined, undefined))
    assertFalse(eqCharInt(0.toChar(), 0.toInt()))
    assertFalse(eqCharInt(0.toChar(), 1.toInt()))
    assertFalse(eqCharInt(1.toChar(), 0.toInt()))
    assertFalse(eqCharInt(1.toChar(), 1.toInt()))
    assertFalse(eqCharIntQ(0.toChar(), 0.toInt()))
    assertFalse(eqCharIntQ(0.toChar(), 1.toInt()))
    assertFalse(eqCharIntQ(0.toChar(), null))
    assertFalse(eqCharIntQ(0.toChar(), undefined))
    assertFalse(eqCharIntQ(1.toChar(), 0.toInt()))
    assertFalse(eqCharIntQ(1.toChar(), 1.toInt()))
    assertFalse(eqCharIntQ(1.toChar(), null))
    assertFalse(eqCharIntQ(1.toChar(), undefined))
    assertFalse(eqCharQInt(0.toChar(), 0.toInt()))
    assertFalse(eqCharQInt(0.toChar(), 1.toInt()))
    assertFalse(eqCharQInt(1.toChar(), 0.toInt()))
    assertFalse(eqCharQInt(1.toChar(), 1.toInt()))
    assertFalse(eqCharQInt(null, 0.toInt()))
    assertFalse(eqCharQInt(null, 1.toInt()))
    assertFalse(eqCharQInt(undefined, 0.toInt()))
    assertFalse(eqCharQInt(undefined, 1.toInt()))
    assertFalse(eqCharQIntQ(0.toChar(), 0.toInt()))
    assertFalse(eqCharQIntQ(0.toChar(), 1.toInt()))
    assertFalse(eqCharQIntQ(0.toChar(), null))
    assertFalse(eqCharQIntQ(0.toChar(), undefined))
    assertFalse(eqCharQIntQ(1.toChar(), 0.toInt()))
    assertFalse(eqCharQIntQ(1.toChar(), 1.toInt()))
    assertFalse(eqCharQIntQ(1.toChar(), null))
    assertFalse(eqCharQIntQ(1.toChar(), undefined))
    assertFalse(eqCharQIntQ(null, 0.toInt()))
    assertFalse(eqCharQIntQ(null, 1.toInt()))
    assertTrue(eqCharQIntQ(null, null))
    assertTrue(eqCharQIntQ(null, undefined))
    assertFalse(eqCharQIntQ(undefined, 0.toInt()))
    assertFalse(eqCharQIntQ(undefined, 1.toInt()))
    assertTrue(eqCharQIntQ(undefined, null))
    assertTrue(eqCharQIntQ(undefined, undefined))
    assertFalse(eqCharFloat(0.toChar(), 0.toFloat()))
    assertFalse(eqCharFloat(0.toChar(), 1.toFloat()))
    assertFalse(eqCharFloat(1.toChar(), 0.toFloat()))
    assertFalse(eqCharFloat(1.toChar(), 1.toFloat()))
    assertFalse(eqCharFloatQ(0.toChar(), 0.toFloat()))
    assertFalse(eqCharFloatQ(0.toChar(), 1.toFloat()))
    assertFalse(eqCharFloatQ(0.toChar(), null))
    assertFalse(eqCharFloatQ(0.toChar(), undefined))
    assertFalse(eqCharFloatQ(1.toChar(), 0.toFloat()))
    assertFalse(eqCharFloatQ(1.toChar(), 1.toFloat()))
    assertFalse(eqCharFloatQ(1.toChar(), null))
    assertFalse(eqCharFloatQ(1.toChar(), undefined))
    assertFalse(eqCharQFloat(0.toChar(), 0.toFloat()))
    assertFalse(eqCharQFloat(0.toChar(), 1.toFloat()))
    assertFalse(eqCharQFloat(1.toChar(), 0.toFloat()))
    assertFalse(eqCharQFloat(1.toChar(), 1.toFloat()))
    assertFalse(eqCharQFloat(null, 0.toFloat()))
    assertFalse(eqCharQFloat(null, 1.toFloat()))
    assertFalse(eqCharQFloat(undefined, 0.toFloat()))
    assertFalse(eqCharQFloat(undefined, 1.toFloat()))
    assertFalse(eqCharQFloatQ(0.toChar(), 0.toFloat()))
    assertFalse(eqCharQFloatQ(0.toChar(), 1.toFloat()))
    assertFalse(eqCharQFloatQ(0.toChar(), null))
    assertFalse(eqCharQFloatQ(0.toChar(), undefined))
    assertFalse(eqCharQFloatQ(1.toChar(), 0.toFloat()))
    assertFalse(eqCharQFloatQ(1.toChar(), 1.toFloat()))
    assertFalse(eqCharQFloatQ(1.toChar(), null))
    assertFalse(eqCharQFloatQ(1.toChar(), undefined))
    assertFalse(eqCharQFloatQ(null, 0.toFloat()))
    assertFalse(eqCharQFloatQ(null, 1.toFloat()))
    assertTrue(eqCharQFloatQ(null, null))
    assertTrue(eqCharQFloatQ(null, undefined))
    assertFalse(eqCharQFloatQ(undefined, 0.toFloat()))
    assertFalse(eqCharQFloatQ(undefined, 1.toFloat()))
    assertTrue(eqCharQFloatQ(undefined, null))
    assertTrue(eqCharQFloatQ(undefined, undefined))
    assertFalse(eqCharDouble(0.toChar(), 0.toDouble()))
    assertFalse(eqCharDouble(0.toChar(), 1.toDouble()))
    assertFalse(eqCharDouble(1.toChar(), 0.toDouble()))
    assertFalse(eqCharDouble(1.toChar(), 1.toDouble()))
    assertFalse(eqCharDoubleQ(0.toChar(), 0.toDouble()))
    assertFalse(eqCharDoubleQ(0.toChar(), 1.toDouble()))
    assertFalse(eqCharDoubleQ(0.toChar(), null))
    assertFalse(eqCharDoubleQ(0.toChar(), undefined))
    assertFalse(eqCharDoubleQ(1.toChar(), 0.toDouble()))
    assertFalse(eqCharDoubleQ(1.toChar(), 1.toDouble()))
    assertFalse(eqCharDoubleQ(1.toChar(), null))
    assertFalse(eqCharDoubleQ(1.toChar(), undefined))
    assertFalse(eqCharQDouble(0.toChar(), 0.toDouble()))
    assertFalse(eqCharQDouble(0.toChar(), 1.toDouble()))
    assertFalse(eqCharQDouble(1.toChar(), 0.toDouble()))
    assertFalse(eqCharQDouble(1.toChar(), 1.toDouble()))
    assertFalse(eqCharQDouble(null, 0.toDouble()))
    assertFalse(eqCharQDouble(null, 1.toDouble()))
    assertFalse(eqCharQDouble(undefined, 0.toDouble()))
    assertFalse(eqCharQDouble(undefined, 1.toDouble()))
    assertFalse(eqCharQDoubleQ(0.toChar(), 0.toDouble()))
    assertFalse(eqCharQDoubleQ(0.toChar(), 1.toDouble()))
    assertFalse(eqCharQDoubleQ(0.toChar(), null))
    assertFalse(eqCharQDoubleQ(0.toChar(), undefined))
    assertFalse(eqCharQDoubleQ(1.toChar(), 0.toDouble()))
    assertFalse(eqCharQDoubleQ(1.toChar(), 1.toDouble()))
    assertFalse(eqCharQDoubleQ(1.toChar(), null))
    assertFalse(eqCharQDoubleQ(1.toChar(), undefined))
    assertFalse(eqCharQDoubleQ(null, 0.toDouble()))
    assertFalse(eqCharQDoubleQ(null, 1.toDouble()))
    assertTrue(eqCharQDoubleQ(null, null))
    assertTrue(eqCharQDoubleQ(null, undefined))
    assertFalse(eqCharQDoubleQ(undefined, 0.toDouble()))
    assertFalse(eqCharQDoubleQ(undefined, 1.toDouble()))
    assertTrue(eqCharQDoubleQ(undefined, null))
    assertTrue(eqCharQDoubleQ(undefined, undefined))
    assertFalse(eqCharLong(0.toChar(), 0.toLong()))
    assertFalse(eqCharLong(0.toChar(), 1.toLong()))
    assertFalse(eqCharLong(1.toChar(), 0.toLong()))
    assertFalse(eqCharLong(1.toChar(), 1.toLong()))
    assertFalse(eqCharLongQ(0.toChar(), 0.toLong()))
    assertFalse(eqCharLongQ(0.toChar(), 1.toLong()))
    assertFalse(eqCharLongQ(0.toChar(), null))
    assertFalse(eqCharLongQ(0.toChar(), undefined))
    assertFalse(eqCharLongQ(1.toChar(), 0.toLong()))
    assertFalse(eqCharLongQ(1.toChar(), 1.toLong()))
    assertFalse(eqCharLongQ(1.toChar(), null))
    assertFalse(eqCharLongQ(1.toChar(), undefined))
    assertFalse(eqCharQLong(0.toChar(), 0.toLong()))
    assertFalse(eqCharQLong(0.toChar(), 1.toLong()))
    assertFalse(eqCharQLong(1.toChar(), 0.toLong()))
    assertFalse(eqCharQLong(1.toChar(), 1.toLong()))
    assertFalse(eqCharQLong(null, 0.toLong()))
    assertFalse(eqCharQLong(null, 1.toLong()))
    assertFalse(eqCharQLong(undefined, 0.toLong()))
    assertFalse(eqCharQLong(undefined, 1.toLong()))
    assertFalse(eqCharQLongQ(0.toChar(), 0.toLong()))
    assertFalse(eqCharQLongQ(0.toChar(), 1.toLong()))
    assertFalse(eqCharQLongQ(0.toChar(), null))
    assertFalse(eqCharQLongQ(0.toChar(), undefined))
    assertFalse(eqCharQLongQ(1.toChar(), 0.toLong()))
    assertFalse(eqCharQLongQ(1.toChar(), 1.toLong()))
    assertFalse(eqCharQLongQ(1.toChar(), null))
    assertFalse(eqCharQLongQ(1.toChar(), undefined))
    assertFalse(eqCharQLongQ(null, 0.toLong()))
    assertFalse(eqCharQLongQ(null, 1.toLong()))
    assertTrue(eqCharQLongQ(null, null))
    assertTrue(eqCharQLongQ(null, undefined))
    assertFalse(eqCharQLongQ(undefined, 0.toLong()))
    assertFalse(eqCharQLongQ(undefined, 1.toLong()))
    assertTrue(eqCharQLongQ(undefined, null))
    assertTrue(eqCharQLongQ(undefined, undefined))
    assertTrue(eqIntByte(0.toInt(), 0.toByte()))
    assertFalse(eqIntByte(0.toInt(), 1.toByte()))
    assertFalse(eqIntByte(1.toInt(), 0.toByte()))
    assertTrue(eqIntByte(1.toInt(), 1.toByte()))
    assertTrue(eqIntByteQ(0.toInt(), 0.toByte()))
    assertFalse(eqIntByteQ(0.toInt(), 1.toByte()))
    assertFalse(eqIntByteQ(0.toInt(), null))
    assertFalse(eqIntByteQ(0.toInt(), undefined))
    assertFalse(eqIntByteQ(1.toInt(), 0.toByte()))
    assertTrue(eqIntByteQ(1.toInt(), 1.toByte()))
    assertFalse(eqIntByteQ(1.toInt(), null))
    assertFalse(eqIntByteQ(1.toInt(), undefined))
    assertTrue(eqIntQByte(0.toInt(), 0.toByte()))
    assertFalse(eqIntQByte(0.toInt(), 1.toByte()))
    assertFalse(eqIntQByte(1.toInt(), 0.toByte()))
    assertTrue(eqIntQByte(1.toInt(), 1.toByte()))
    assertFalse(eqIntQByte(null, 0.toByte()))
    assertFalse(eqIntQByte(null, 1.toByte()))
    assertFalse(eqIntQByte(undefined, 0.toByte()))
    assertFalse(eqIntQByte(undefined, 1.toByte()))
    assertTrue(eqIntQByteQ(0.toInt(), 0.toByte()))
    assertFalse(eqIntQByteQ(0.toInt(), 1.toByte()))
    assertFalse(eqIntQByteQ(0.toInt(), null))
    assertFalse(eqIntQByteQ(0.toInt(), undefined))
    assertFalse(eqIntQByteQ(1.toInt(), 0.toByte()))
    assertTrue(eqIntQByteQ(1.toInt(), 1.toByte()))
    assertFalse(eqIntQByteQ(1.toInt(), null))
    assertFalse(eqIntQByteQ(1.toInt(), undefined))
    assertFalse(eqIntQByteQ(null, 0.toByte()))
    assertFalse(eqIntQByteQ(null, 1.toByte()))
    assertTrue(eqIntQByteQ(null, null))
    assertTrue(eqIntQByteQ(null, undefined))
    assertFalse(eqIntQByteQ(undefined, 0.toByte()))
    assertFalse(eqIntQByteQ(undefined, 1.toByte()))
    assertTrue(eqIntQByteQ(undefined, null))
    assertTrue(eqIntQByteQ(undefined, undefined))
    assertFalse(eqIntBoolean(0.toInt(), false))
    assertFalse(eqIntBoolean(0.toInt(), true))
    assertFalse(eqIntBoolean(1.toInt(), false))
    assertFalse(eqIntBoolean(1.toInt(), true))
    assertFalse(eqIntBooleanQ(0.toInt(), false))
    assertFalse(eqIntBooleanQ(0.toInt(), true))
    assertFalse(eqIntBooleanQ(0.toInt(), null))
    assertFalse(eqIntBooleanQ(0.toInt(), undefined))
    assertFalse(eqIntBooleanQ(1.toInt(), false))
    assertFalse(eqIntBooleanQ(1.toInt(), true))
    assertFalse(eqIntBooleanQ(1.toInt(), null))
    assertFalse(eqIntBooleanQ(1.toInt(), undefined))
    assertFalse(eqIntQBoolean(0.toInt(), false))
    assertFalse(eqIntQBoolean(0.toInt(), true))
    assertFalse(eqIntQBoolean(1.toInt(), false))
    assertFalse(eqIntQBoolean(1.toInt(), true))
    assertFalse(eqIntQBoolean(null, false))
    assertFalse(eqIntQBoolean(null, true))
    assertFalse(eqIntQBoolean(undefined, false))
    assertFalse(eqIntQBoolean(undefined, true))
    assertFalse(eqIntQBooleanQ(0.toInt(), false))
    assertFalse(eqIntQBooleanQ(0.toInt(), true))
    assertFalse(eqIntQBooleanQ(0.toInt(), null))
    assertFalse(eqIntQBooleanQ(0.toInt(), undefined))
    assertFalse(eqIntQBooleanQ(1.toInt(), false))
    assertFalse(eqIntQBooleanQ(1.toInt(), true))
    assertFalse(eqIntQBooleanQ(1.toInt(), null))
    assertFalse(eqIntQBooleanQ(1.toInt(), undefined))
    assertFalse(eqIntQBooleanQ(null, false))
    assertFalse(eqIntQBooleanQ(null, true))
    assertTrue(eqIntQBooleanQ(null, null))
    assertTrue(eqIntQBooleanQ(null, undefined))
    assertFalse(eqIntQBooleanQ(undefined, false))
    assertFalse(eqIntQBooleanQ(undefined, true))
    assertTrue(eqIntQBooleanQ(undefined, null))
    assertTrue(eqIntQBooleanQ(undefined, undefined))
    assertTrue(eqIntShort(0.toInt(), 0.toShort()))
    assertFalse(eqIntShort(0.toInt(), 1.toShort()))
    assertFalse(eqIntShort(1.toInt(), 0.toShort()))
    assertTrue(eqIntShort(1.toInt(), 1.toShort()))
    assertTrue(eqIntShortQ(0.toInt(), 0.toShort()))
    assertFalse(eqIntShortQ(0.toInt(), 1.toShort()))
    assertFalse(eqIntShortQ(0.toInt(), null))
    assertFalse(eqIntShortQ(0.toInt(), undefined))
    assertFalse(eqIntShortQ(1.toInt(), 0.toShort()))
    assertTrue(eqIntShortQ(1.toInt(), 1.toShort()))
    assertFalse(eqIntShortQ(1.toInt(), null))
    assertFalse(eqIntShortQ(1.toInt(), undefined))
    assertTrue(eqIntQShort(0.toInt(), 0.toShort()))
    assertFalse(eqIntQShort(0.toInt(), 1.toShort()))
    assertFalse(eqIntQShort(1.toInt(), 0.toShort()))
    assertTrue(eqIntQShort(1.toInt(), 1.toShort()))
    assertFalse(eqIntQShort(null, 0.toShort()))
    assertFalse(eqIntQShort(null, 1.toShort()))
    assertFalse(eqIntQShort(undefined, 0.toShort()))
    assertFalse(eqIntQShort(undefined, 1.toShort()))
    assertTrue(eqIntQShortQ(0.toInt(), 0.toShort()))
    assertFalse(eqIntQShortQ(0.toInt(), 1.toShort()))
    assertFalse(eqIntQShortQ(0.toInt(), null))
    assertFalse(eqIntQShortQ(0.toInt(), undefined))
    assertFalse(eqIntQShortQ(1.toInt(), 0.toShort()))
    assertTrue(eqIntQShortQ(1.toInt(), 1.toShort()))
    assertFalse(eqIntQShortQ(1.toInt(), null))
    assertFalse(eqIntQShortQ(1.toInt(), undefined))
    assertFalse(eqIntQShortQ(null, 0.toShort()))
    assertFalse(eqIntQShortQ(null, 1.toShort()))
    assertTrue(eqIntQShortQ(null, null))
    assertTrue(eqIntQShortQ(null, undefined))
    assertFalse(eqIntQShortQ(undefined, 0.toShort()))
    assertFalse(eqIntQShortQ(undefined, 1.toShort()))
    assertTrue(eqIntQShortQ(undefined, null))
    assertTrue(eqIntQShortQ(undefined, undefined))
    assertFalse(eqIntChar(0.toInt(), 0.toChar()))
    assertFalse(eqIntChar(0.toInt(), 1.toChar()))
    assertFalse(eqIntChar(1.toInt(), 0.toChar()))
    assertFalse(eqIntChar(1.toInt(), 1.toChar()))
    assertFalse(eqIntCharQ(0.toInt(), 0.toChar()))
    assertFalse(eqIntCharQ(0.toInt(), 1.toChar()))
    assertFalse(eqIntCharQ(0.toInt(), null))
    assertFalse(eqIntCharQ(0.toInt(), undefined))
    assertFalse(eqIntCharQ(1.toInt(), 0.toChar()))
    assertFalse(eqIntCharQ(1.toInt(), 1.toChar()))
    assertFalse(eqIntCharQ(1.toInt(), null))
    assertFalse(eqIntCharQ(1.toInt(), undefined))
    assertFalse(eqIntQChar(0.toInt(), 0.toChar()))
    assertFalse(eqIntQChar(0.toInt(), 1.toChar()))
    assertFalse(eqIntQChar(1.toInt(), 0.toChar()))
    assertFalse(eqIntQChar(1.toInt(), 1.toChar()))
    assertFalse(eqIntQChar(null, 0.toChar()))
    assertFalse(eqIntQChar(null, 1.toChar()))
    assertFalse(eqIntQChar(undefined, 0.toChar()))
    assertFalse(eqIntQChar(undefined, 1.toChar()))
    assertFalse(eqIntQCharQ(0.toInt(), 0.toChar()))
    assertFalse(eqIntQCharQ(0.toInt(), 1.toChar()))
    assertFalse(eqIntQCharQ(0.toInt(), null))
    assertFalse(eqIntQCharQ(0.toInt(), undefined))
    assertFalse(eqIntQCharQ(1.toInt(), 0.toChar()))
    assertFalse(eqIntQCharQ(1.toInt(), 1.toChar()))
    assertFalse(eqIntQCharQ(1.toInt(), null))
    assertFalse(eqIntQCharQ(1.toInt(), undefined))
    assertFalse(eqIntQCharQ(null, 0.toChar()))
    assertFalse(eqIntQCharQ(null, 1.toChar()))
    assertTrue(eqIntQCharQ(null, null))
    assertTrue(eqIntQCharQ(null, undefined))
    assertFalse(eqIntQCharQ(undefined, 0.toChar()))
    assertFalse(eqIntQCharQ(undefined, 1.toChar()))
    assertTrue(eqIntQCharQ(undefined, null))
    assertTrue(eqIntQCharQ(undefined, undefined))
    assertTrue(eqIntInt(0.toInt(), 0.toInt()))
    assertFalse(eqIntInt(0.toInt(), 1.toInt()))
    assertFalse(eqIntInt(1.toInt(), 0.toInt()))
    assertTrue(eqIntInt(1.toInt(), 1.toInt()))
    assertTrue(eqIntIntQ(0.toInt(), 0.toInt()))
    assertFalse(eqIntIntQ(0.toInt(), 1.toInt()))
    assertFalse(eqIntIntQ(0.toInt(), null))
    assertFalse(eqIntIntQ(0.toInt(), undefined))
    assertFalse(eqIntIntQ(1.toInt(), 0.toInt()))
    assertTrue(eqIntIntQ(1.toInt(), 1.toInt()))
    assertFalse(eqIntIntQ(1.toInt(), null))
    assertFalse(eqIntIntQ(1.toInt(), undefined))
    assertTrue(eqIntQInt(0.toInt(), 0.toInt()))
    assertFalse(eqIntQInt(0.toInt(), 1.toInt()))
    assertFalse(eqIntQInt(1.toInt(), 0.toInt()))
    assertTrue(eqIntQInt(1.toInt(), 1.toInt()))
    assertFalse(eqIntQInt(null, 0.toInt()))
    assertFalse(eqIntQInt(null, 1.toInt()))
    assertFalse(eqIntQInt(undefined, 0.toInt()))
    assertFalse(eqIntQInt(undefined, 1.toInt()))
    assertTrue(eqIntQIntQ(0.toInt(), 0.toInt()))
    assertFalse(eqIntQIntQ(0.toInt(), 1.toInt()))
    assertFalse(eqIntQIntQ(0.toInt(), null))
    assertFalse(eqIntQIntQ(0.toInt(), undefined))
    assertFalse(eqIntQIntQ(1.toInt(), 0.toInt()))
    assertTrue(eqIntQIntQ(1.toInt(), 1.toInt()))
    assertFalse(eqIntQIntQ(1.toInt(), null))
    assertFalse(eqIntQIntQ(1.toInt(), undefined))
    assertFalse(eqIntQIntQ(null, 0.toInt()))
    assertFalse(eqIntQIntQ(null, 1.toInt()))
    assertTrue(eqIntQIntQ(null, null))
    assertTrue(eqIntQIntQ(null, undefined))
    assertFalse(eqIntQIntQ(undefined, 0.toInt()))
    assertFalse(eqIntQIntQ(undefined, 1.toInt()))
    assertTrue(eqIntQIntQ(undefined, null))
    assertTrue(eqIntQIntQ(undefined, undefined))
    assertTrue(eqIntFloat(0.toInt(), 0.toFloat()))
    assertFalse(eqIntFloat(0.toInt(), 1.toFloat()))
    assertFalse(eqIntFloat(1.toInt(), 0.toFloat()))
    assertTrue(eqIntFloat(1.toInt(), 1.toFloat()))
    assertTrue(eqIntFloatQ(0.toInt(), 0.toFloat()))
    assertFalse(eqIntFloatQ(0.toInt(), 1.toFloat()))
    assertFalse(eqIntFloatQ(0.toInt(), null))
    assertFalse(eqIntFloatQ(0.toInt(), undefined))
    assertFalse(eqIntFloatQ(1.toInt(), 0.toFloat()))
    assertTrue(eqIntFloatQ(1.toInt(), 1.toFloat()))
    assertFalse(eqIntFloatQ(1.toInt(), null))
    assertFalse(eqIntFloatQ(1.toInt(), undefined))
    assertTrue(eqIntQFloat(0.toInt(), 0.toFloat()))
    assertFalse(eqIntQFloat(0.toInt(), 1.toFloat()))
    assertFalse(eqIntQFloat(1.toInt(), 0.toFloat()))
    assertTrue(eqIntQFloat(1.toInt(), 1.toFloat()))
    assertFalse(eqIntQFloat(null, 0.toFloat()))
    assertFalse(eqIntQFloat(null, 1.toFloat()))
    assertFalse(eqIntQFloat(undefined, 0.toFloat()))
    assertFalse(eqIntQFloat(undefined, 1.toFloat()))
    assertTrue(eqIntQFloatQ(0.toInt(), 0.toFloat()))
    assertFalse(eqIntQFloatQ(0.toInt(), 1.toFloat()))
    assertFalse(eqIntQFloatQ(0.toInt(), null))
    assertFalse(eqIntQFloatQ(0.toInt(), undefined))
    assertFalse(eqIntQFloatQ(1.toInt(), 0.toFloat()))
    assertTrue(eqIntQFloatQ(1.toInt(), 1.toFloat()))
    assertFalse(eqIntQFloatQ(1.toInt(), null))
    assertFalse(eqIntQFloatQ(1.toInt(), undefined))
    assertFalse(eqIntQFloatQ(null, 0.toFloat()))
    assertFalse(eqIntQFloatQ(null, 1.toFloat()))
    assertTrue(eqIntQFloatQ(null, null))
    assertTrue(eqIntQFloatQ(null, undefined))
    assertFalse(eqIntQFloatQ(undefined, 0.toFloat()))
    assertFalse(eqIntQFloatQ(undefined, 1.toFloat()))
    assertTrue(eqIntQFloatQ(undefined, null))
    assertTrue(eqIntQFloatQ(undefined, undefined))
    assertTrue(eqIntDouble(0.toInt(), 0.toDouble()))
    assertFalse(eqIntDouble(0.toInt(), 1.toDouble()))
    assertFalse(eqIntDouble(1.toInt(), 0.toDouble()))
    assertTrue(eqIntDouble(1.toInt(), 1.toDouble()))
    assertTrue(eqIntDoubleQ(0.toInt(), 0.toDouble()))
    assertFalse(eqIntDoubleQ(0.toInt(), 1.toDouble()))
    assertFalse(eqIntDoubleQ(0.toInt(), null))
    assertFalse(eqIntDoubleQ(0.toInt(), undefined))
    assertFalse(eqIntDoubleQ(1.toInt(), 0.toDouble()))
    assertTrue(eqIntDoubleQ(1.toInt(), 1.toDouble()))
    assertFalse(eqIntDoubleQ(1.toInt(), null))
    assertFalse(eqIntDoubleQ(1.toInt(), undefined))
    assertTrue(eqIntQDouble(0.toInt(), 0.toDouble()))
    assertFalse(eqIntQDouble(0.toInt(), 1.toDouble()))
    assertFalse(eqIntQDouble(1.toInt(), 0.toDouble()))
    assertTrue(eqIntQDouble(1.toInt(), 1.toDouble()))
    assertFalse(eqIntQDouble(null, 0.toDouble()))
    assertFalse(eqIntQDouble(null, 1.toDouble()))
    assertFalse(eqIntQDouble(undefined, 0.toDouble()))
    assertFalse(eqIntQDouble(undefined, 1.toDouble()))
    assertTrue(eqIntQDoubleQ(0.toInt(), 0.toDouble()))
    assertFalse(eqIntQDoubleQ(0.toInt(), 1.toDouble()))
    assertFalse(eqIntQDoubleQ(0.toInt(), null))
    assertFalse(eqIntQDoubleQ(0.toInt(), undefined))
    assertFalse(eqIntQDoubleQ(1.toInt(), 0.toDouble()))
    assertTrue(eqIntQDoubleQ(1.toInt(), 1.toDouble()))
    assertFalse(eqIntQDoubleQ(1.toInt(), null))
    assertFalse(eqIntQDoubleQ(1.toInt(), undefined))
    assertFalse(eqIntQDoubleQ(null, 0.toDouble()))
    assertFalse(eqIntQDoubleQ(null, 1.toDouble()))
    assertTrue(eqIntQDoubleQ(null, null))
    assertTrue(eqIntQDoubleQ(null, undefined))
    assertFalse(eqIntQDoubleQ(undefined, 0.toDouble()))
    assertFalse(eqIntQDoubleQ(undefined, 1.toDouble()))
    assertTrue(eqIntQDoubleQ(undefined, null))
    assertTrue(eqIntQDoubleQ(undefined, undefined))
    assertTrue(eqIntLong(0.toInt(), 0.toLong()))
    assertFalse(eqIntLong(0.toInt(), 1.toLong()))
    assertFalse(eqIntLong(1.toInt(), 0.toLong()))
    assertTrue(eqIntLong(1.toInt(), 1.toLong()))
    assertTrue(eqIntLongQ(0.toInt(), 0.toLong()))
    assertFalse(eqIntLongQ(0.toInt(), 1.toLong()))
    assertFalse(eqIntLongQ(0.toInt(), null))
    assertFalse(eqIntLongQ(0.toInt(), undefined))
    assertFalse(eqIntLongQ(1.toInt(), 0.toLong()))
    assertTrue(eqIntLongQ(1.toInt(), 1.toLong()))
    assertFalse(eqIntLongQ(1.toInt(), null))
    assertFalse(eqIntLongQ(1.toInt(), undefined))
    assertTrue(eqIntQLong(0.toInt(), 0.toLong()))
    assertFalse(eqIntQLong(0.toInt(), 1.toLong()))
    assertFalse(eqIntQLong(1.toInt(), 0.toLong()))
    assertTrue(eqIntQLong(1.toInt(), 1.toLong()))
    assertFalse(eqIntQLong(null, 0.toLong()))
    assertFalse(eqIntQLong(null, 1.toLong()))
    assertFalse(eqIntQLong(undefined, 0.toLong()))
    assertFalse(eqIntQLong(undefined, 1.toLong()))
    assertTrue(eqIntQLongQ(0.toInt(), 0.toLong()))
    assertFalse(eqIntQLongQ(0.toInt(), 1.toLong()))
    assertFalse(eqIntQLongQ(0.toInt(), null))
    assertFalse(eqIntQLongQ(0.toInt(), undefined))
    assertFalse(eqIntQLongQ(1.toInt(), 0.toLong()))
    assertTrue(eqIntQLongQ(1.toInt(), 1.toLong()))
    assertFalse(eqIntQLongQ(1.toInt(), null))
    assertFalse(eqIntQLongQ(1.toInt(), undefined))
    assertFalse(eqIntQLongQ(null, 0.toLong()))
    assertFalse(eqIntQLongQ(null, 1.toLong()))
    assertTrue(eqIntQLongQ(null, null))
    assertTrue(eqIntQLongQ(null, undefined))
    assertFalse(eqIntQLongQ(undefined, 0.toLong()))
    assertFalse(eqIntQLongQ(undefined, 1.toLong()))
    assertTrue(eqIntQLongQ(undefined, null))
    assertTrue(eqIntQLongQ(undefined, undefined))
    assertTrue(eqFloatByte(0.toFloat(), 0.toByte()))
    assertFalse(eqFloatByte(0.toFloat(), 1.toByte()))
    assertFalse(eqFloatByte(1.toFloat(), 0.toByte()))
    assertTrue(eqFloatByte(1.toFloat(), 1.toByte()))
    assertTrue(eqFloatByteQ(0.toFloat(), 0.toByte()))
    assertFalse(eqFloatByteQ(0.toFloat(), 1.toByte()))
    assertFalse(eqFloatByteQ(0.toFloat(), null))
    assertFalse(eqFloatByteQ(0.toFloat(), undefined))
    assertFalse(eqFloatByteQ(1.toFloat(), 0.toByte()))
    assertTrue(eqFloatByteQ(1.toFloat(), 1.toByte()))
    assertFalse(eqFloatByteQ(1.toFloat(), null))
    assertFalse(eqFloatByteQ(1.toFloat(), undefined))
    assertTrue(eqFloatQByte(0.toFloat(), 0.toByte()))
    assertFalse(eqFloatQByte(0.toFloat(), 1.toByte()))
    assertFalse(eqFloatQByte(1.toFloat(), 0.toByte()))
    assertTrue(eqFloatQByte(1.toFloat(), 1.toByte()))
    assertFalse(eqFloatQByte(null, 0.toByte()))
    assertFalse(eqFloatQByte(null, 1.toByte()))
    assertFalse(eqFloatQByte(undefined, 0.toByte()))
    assertFalse(eqFloatQByte(undefined, 1.toByte()))
    assertTrue(eqFloatQByteQ(0.toFloat(), 0.toByte()))
    assertFalse(eqFloatQByteQ(0.toFloat(), 1.toByte()))
    assertFalse(eqFloatQByteQ(0.toFloat(), null))
    assertFalse(eqFloatQByteQ(0.toFloat(), undefined))
    assertFalse(eqFloatQByteQ(1.toFloat(), 0.toByte()))
    assertTrue(eqFloatQByteQ(1.toFloat(), 1.toByte()))
    assertFalse(eqFloatQByteQ(1.toFloat(), null))
    assertFalse(eqFloatQByteQ(1.toFloat(), undefined))
    assertFalse(eqFloatQByteQ(null, 0.toByte()))
    assertFalse(eqFloatQByteQ(null, 1.toByte()))
    assertTrue(eqFloatQByteQ(null, null))
    assertTrue(eqFloatQByteQ(null, undefined))
    assertFalse(eqFloatQByteQ(undefined, 0.toByte()))
    assertFalse(eqFloatQByteQ(undefined, 1.toByte()))
    assertTrue(eqFloatQByteQ(undefined, null))
    assertTrue(eqFloatQByteQ(undefined, undefined))
    assertFalse(eqFloatBoolean(0.toFloat(), false))
    assertFalse(eqFloatBoolean(0.toFloat(), true))
    assertFalse(eqFloatBoolean(1.toFloat(), false))
    assertFalse(eqFloatBoolean(1.toFloat(), true))
    assertFalse(eqFloatBooleanQ(0.toFloat(), false))
    assertFalse(eqFloatBooleanQ(0.toFloat(), true))
    assertFalse(eqFloatBooleanQ(0.toFloat(), null))
    assertFalse(eqFloatBooleanQ(0.toFloat(), undefined))
    assertFalse(eqFloatBooleanQ(1.toFloat(), false))
    assertFalse(eqFloatBooleanQ(1.toFloat(), true))
    assertFalse(eqFloatBooleanQ(1.toFloat(), null))
    assertFalse(eqFloatBooleanQ(1.toFloat(), undefined))
    assertFalse(eqFloatQBoolean(0.toFloat(), false))
    assertFalse(eqFloatQBoolean(0.toFloat(), true))
    assertFalse(eqFloatQBoolean(1.toFloat(), false))
    assertFalse(eqFloatQBoolean(1.toFloat(), true))
    assertFalse(eqFloatQBoolean(null, false))
    assertFalse(eqFloatQBoolean(null, true))
    assertFalse(eqFloatQBoolean(undefined, false))
    assertFalse(eqFloatQBoolean(undefined, true))
    assertFalse(eqFloatQBooleanQ(0.toFloat(), false))
    assertFalse(eqFloatQBooleanQ(0.toFloat(), true))
    assertFalse(eqFloatQBooleanQ(0.toFloat(), null))
    assertFalse(eqFloatQBooleanQ(0.toFloat(), undefined))
    assertFalse(eqFloatQBooleanQ(1.toFloat(), false))
    assertFalse(eqFloatQBooleanQ(1.toFloat(), true))
    assertFalse(eqFloatQBooleanQ(1.toFloat(), null))
    assertFalse(eqFloatQBooleanQ(1.toFloat(), undefined))
    assertFalse(eqFloatQBooleanQ(null, false))
    assertFalse(eqFloatQBooleanQ(null, true))
    assertTrue(eqFloatQBooleanQ(null, null))
    assertTrue(eqFloatQBooleanQ(null, undefined))
    assertFalse(eqFloatQBooleanQ(undefined, false))
    assertFalse(eqFloatQBooleanQ(undefined, true))
    assertTrue(eqFloatQBooleanQ(undefined, null))
    assertTrue(eqFloatQBooleanQ(undefined, undefined))
    assertTrue(eqFloatShort(0.toFloat(), 0.toShort()))
    assertFalse(eqFloatShort(0.toFloat(), 1.toShort()))
    assertFalse(eqFloatShort(1.toFloat(), 0.toShort()))
    assertTrue(eqFloatShort(1.toFloat(), 1.toShort()))
    assertTrue(eqFloatShortQ(0.toFloat(), 0.toShort()))
    assertFalse(eqFloatShortQ(0.toFloat(), 1.toShort()))
    assertFalse(eqFloatShortQ(0.toFloat(), null))
    assertFalse(eqFloatShortQ(0.toFloat(), undefined))
    assertFalse(eqFloatShortQ(1.toFloat(), 0.toShort()))
    assertTrue(eqFloatShortQ(1.toFloat(), 1.toShort()))
    assertFalse(eqFloatShortQ(1.toFloat(), null))
    assertFalse(eqFloatShortQ(1.toFloat(), undefined))
    assertTrue(eqFloatQShort(0.toFloat(), 0.toShort()))
    assertFalse(eqFloatQShort(0.toFloat(), 1.toShort()))
    assertFalse(eqFloatQShort(1.toFloat(), 0.toShort()))
    assertTrue(eqFloatQShort(1.toFloat(), 1.toShort()))
    assertFalse(eqFloatQShort(null, 0.toShort()))
    assertFalse(eqFloatQShort(null, 1.toShort()))
    assertFalse(eqFloatQShort(undefined, 0.toShort()))
    assertFalse(eqFloatQShort(undefined, 1.toShort()))
    assertTrue(eqFloatQShortQ(0.toFloat(), 0.toShort()))
    assertFalse(eqFloatQShortQ(0.toFloat(), 1.toShort()))
    assertFalse(eqFloatQShortQ(0.toFloat(), null))
    assertFalse(eqFloatQShortQ(0.toFloat(), undefined))
    assertFalse(eqFloatQShortQ(1.toFloat(), 0.toShort()))
    assertTrue(eqFloatQShortQ(1.toFloat(), 1.toShort()))
    assertFalse(eqFloatQShortQ(1.toFloat(), null))
    assertFalse(eqFloatQShortQ(1.toFloat(), undefined))
    assertFalse(eqFloatQShortQ(null, 0.toShort()))
    assertFalse(eqFloatQShortQ(null, 1.toShort()))
    assertTrue(eqFloatQShortQ(null, null))
    assertTrue(eqFloatQShortQ(null, undefined))
    assertFalse(eqFloatQShortQ(undefined, 0.toShort()))
    assertFalse(eqFloatQShortQ(undefined, 1.toShort()))
    assertTrue(eqFloatQShortQ(undefined, null))
    assertTrue(eqFloatQShortQ(undefined, undefined))
    assertFalse(eqFloatChar(0.toFloat(), 0.toChar()))
    assertFalse(eqFloatChar(0.toFloat(), 1.toChar()))
    assertFalse(eqFloatChar(1.toFloat(), 0.toChar()))
    assertFalse(eqFloatChar(1.toFloat(), 1.toChar()))
    assertFalse(eqFloatCharQ(0.toFloat(), 0.toChar()))
    assertFalse(eqFloatCharQ(0.toFloat(), 1.toChar()))
    assertFalse(eqFloatCharQ(0.toFloat(), null))
    assertFalse(eqFloatCharQ(0.toFloat(), undefined))
    assertFalse(eqFloatCharQ(1.toFloat(), 0.toChar()))
    assertFalse(eqFloatCharQ(1.toFloat(), 1.toChar()))
    assertFalse(eqFloatCharQ(1.toFloat(), null))
    assertFalse(eqFloatCharQ(1.toFloat(), undefined))
    assertFalse(eqFloatQChar(0.toFloat(), 0.toChar()))
    assertFalse(eqFloatQChar(0.toFloat(), 1.toChar()))
    assertFalse(eqFloatQChar(1.toFloat(), 0.toChar()))
    assertFalse(eqFloatQChar(1.toFloat(), 1.toChar()))
    assertFalse(eqFloatQChar(null, 0.toChar()))
    assertFalse(eqFloatQChar(null, 1.toChar()))
    assertFalse(eqFloatQChar(undefined, 0.toChar()))
    assertFalse(eqFloatQChar(undefined, 1.toChar()))
    assertFalse(eqFloatQCharQ(0.toFloat(), 0.toChar()))
    assertFalse(eqFloatQCharQ(0.toFloat(), 1.toChar()))
    assertFalse(eqFloatQCharQ(0.toFloat(), null))
    assertFalse(eqFloatQCharQ(0.toFloat(), undefined))
    assertFalse(eqFloatQCharQ(1.toFloat(), 0.toChar()))
    assertFalse(eqFloatQCharQ(1.toFloat(), 1.toChar()))
    assertFalse(eqFloatQCharQ(1.toFloat(), null))
    assertFalse(eqFloatQCharQ(1.toFloat(), undefined))
    assertFalse(eqFloatQCharQ(null, 0.toChar()))
    assertFalse(eqFloatQCharQ(null, 1.toChar()))
    assertTrue(eqFloatQCharQ(null, null))
    assertTrue(eqFloatQCharQ(null, undefined))
    assertFalse(eqFloatQCharQ(undefined, 0.toChar()))
    assertFalse(eqFloatQCharQ(undefined, 1.toChar()))
    assertTrue(eqFloatQCharQ(undefined, null))
    assertTrue(eqFloatQCharQ(undefined, undefined))
    assertTrue(eqFloatInt(0.toFloat(), 0.toInt()))
    assertFalse(eqFloatInt(0.toFloat(), 1.toInt()))
    assertFalse(eqFloatInt(1.toFloat(), 0.toInt()))
    assertTrue(eqFloatInt(1.toFloat(), 1.toInt()))
    assertTrue(eqFloatIntQ(0.toFloat(), 0.toInt()))
    assertFalse(eqFloatIntQ(0.toFloat(), 1.toInt()))
    assertFalse(eqFloatIntQ(0.toFloat(), null))
    assertFalse(eqFloatIntQ(0.toFloat(), undefined))
    assertFalse(eqFloatIntQ(1.toFloat(), 0.toInt()))
    assertTrue(eqFloatIntQ(1.toFloat(), 1.toInt()))
    assertFalse(eqFloatIntQ(1.toFloat(), null))
    assertFalse(eqFloatIntQ(1.toFloat(), undefined))
    assertTrue(eqFloatQInt(0.toFloat(), 0.toInt()))
    assertFalse(eqFloatQInt(0.toFloat(), 1.toInt()))
    assertFalse(eqFloatQInt(1.toFloat(), 0.toInt()))
    assertTrue(eqFloatQInt(1.toFloat(), 1.toInt()))
    assertFalse(eqFloatQInt(null, 0.toInt()))
    assertFalse(eqFloatQInt(null, 1.toInt()))
    assertFalse(eqFloatQInt(undefined, 0.toInt()))
    assertFalse(eqFloatQInt(undefined, 1.toInt()))
    assertTrue(eqFloatQIntQ(0.toFloat(), 0.toInt()))
    assertFalse(eqFloatQIntQ(0.toFloat(), 1.toInt()))
    assertFalse(eqFloatQIntQ(0.toFloat(), null))
    assertFalse(eqFloatQIntQ(0.toFloat(), undefined))
    assertFalse(eqFloatQIntQ(1.toFloat(), 0.toInt()))
    assertTrue(eqFloatQIntQ(1.toFloat(), 1.toInt()))
    assertFalse(eqFloatQIntQ(1.toFloat(), null))
    assertFalse(eqFloatQIntQ(1.toFloat(), undefined))
    assertFalse(eqFloatQIntQ(null, 0.toInt()))
    assertFalse(eqFloatQIntQ(null, 1.toInt()))
    assertTrue(eqFloatQIntQ(null, null))
    assertTrue(eqFloatQIntQ(null, undefined))
    assertFalse(eqFloatQIntQ(undefined, 0.toInt()))
    assertFalse(eqFloatQIntQ(undefined, 1.toInt()))
    assertTrue(eqFloatQIntQ(undefined, null))
    assertTrue(eqFloatQIntQ(undefined, undefined))
    assertTrue(eqFloatFloat(0.toFloat(), 0.toFloat()))
    assertFalse(eqFloatFloat(0.toFloat(), 1.toFloat()))
    assertFalse(eqFloatFloat(1.toFloat(), 0.toFloat()))
    assertTrue(eqFloatFloat(1.toFloat(), 1.toFloat()))
    assertTrue(eqFloatFloatQ(0.toFloat(), 0.toFloat()))
    assertFalse(eqFloatFloatQ(0.toFloat(), 1.toFloat()))
    assertFalse(eqFloatFloatQ(0.toFloat(), null))
    assertFalse(eqFloatFloatQ(0.toFloat(), undefined))
    assertFalse(eqFloatFloatQ(1.toFloat(), 0.toFloat()))
    assertTrue(eqFloatFloatQ(1.toFloat(), 1.toFloat()))
    assertFalse(eqFloatFloatQ(1.toFloat(), null))
    assertFalse(eqFloatFloatQ(1.toFloat(), undefined))
    assertTrue(eqFloatQFloat(0.toFloat(), 0.toFloat()))
    assertFalse(eqFloatQFloat(0.toFloat(), 1.toFloat()))
    assertFalse(eqFloatQFloat(1.toFloat(), 0.toFloat()))
    assertTrue(eqFloatQFloat(1.toFloat(), 1.toFloat()))
    assertFalse(eqFloatQFloat(null, 0.toFloat()))
    assertFalse(eqFloatQFloat(null, 1.toFloat()))
    assertFalse(eqFloatQFloat(undefined, 0.toFloat()))
    assertFalse(eqFloatQFloat(undefined, 1.toFloat()))
    assertTrue(eqFloatQFloatQ(0.toFloat(), 0.toFloat()))
    assertFalse(eqFloatQFloatQ(0.toFloat(), 1.toFloat()))
    assertFalse(eqFloatQFloatQ(0.toFloat(), null))
    assertFalse(eqFloatQFloatQ(0.toFloat(), undefined))
    assertFalse(eqFloatQFloatQ(1.toFloat(), 0.toFloat()))
    assertTrue(eqFloatQFloatQ(1.toFloat(), 1.toFloat()))
    assertFalse(eqFloatQFloatQ(1.toFloat(), null))
    assertFalse(eqFloatQFloatQ(1.toFloat(), undefined))
    assertFalse(eqFloatQFloatQ(null, 0.toFloat()))
    assertFalse(eqFloatQFloatQ(null, 1.toFloat()))
    assertTrue(eqFloatQFloatQ(null, null))
    assertTrue(eqFloatQFloatQ(null, undefined))
    assertFalse(eqFloatQFloatQ(undefined, 0.toFloat()))
    assertFalse(eqFloatQFloatQ(undefined, 1.toFloat()))
    assertTrue(eqFloatQFloatQ(undefined, null))
    assertTrue(eqFloatQFloatQ(undefined, undefined))
    assertTrue(eqFloatDouble(0.toFloat(), 0.toDouble()))
    assertFalse(eqFloatDouble(0.toFloat(), 1.toDouble()))
    assertFalse(eqFloatDouble(1.toFloat(), 0.toDouble()))
    assertTrue(eqFloatDouble(1.toFloat(), 1.toDouble()))
    assertTrue(eqFloatDoubleQ(0.toFloat(), 0.toDouble()))
    assertFalse(eqFloatDoubleQ(0.toFloat(), 1.toDouble()))
    assertFalse(eqFloatDoubleQ(0.toFloat(), null))
    assertFalse(eqFloatDoubleQ(0.toFloat(), undefined))
    assertFalse(eqFloatDoubleQ(1.toFloat(), 0.toDouble()))
    assertTrue(eqFloatDoubleQ(1.toFloat(), 1.toDouble()))
    assertFalse(eqFloatDoubleQ(1.toFloat(), null))
    assertFalse(eqFloatDoubleQ(1.toFloat(), undefined))
    assertTrue(eqFloatQDouble(0.toFloat(), 0.toDouble()))
    assertFalse(eqFloatQDouble(0.toFloat(), 1.toDouble()))
    assertFalse(eqFloatQDouble(1.toFloat(), 0.toDouble()))
    assertTrue(eqFloatQDouble(1.toFloat(), 1.toDouble()))
    assertFalse(eqFloatQDouble(null, 0.toDouble()))
    assertFalse(eqFloatQDouble(null, 1.toDouble()))
    assertFalse(eqFloatQDouble(undefined, 0.toDouble()))
    assertFalse(eqFloatQDouble(undefined, 1.toDouble()))
    assertTrue(eqFloatQDoubleQ(0.toFloat(), 0.toDouble()))
    assertFalse(eqFloatQDoubleQ(0.toFloat(), 1.toDouble()))
    assertFalse(eqFloatQDoubleQ(0.toFloat(), null))
    assertFalse(eqFloatQDoubleQ(0.toFloat(), undefined))
    assertFalse(eqFloatQDoubleQ(1.toFloat(), 0.toDouble()))
    assertTrue(eqFloatQDoubleQ(1.toFloat(), 1.toDouble()))
    assertFalse(eqFloatQDoubleQ(1.toFloat(), null))
    assertFalse(eqFloatQDoubleQ(1.toFloat(), undefined))
    assertFalse(eqFloatQDoubleQ(null, 0.toDouble()))
    assertFalse(eqFloatQDoubleQ(null, 1.toDouble()))
    assertTrue(eqFloatQDoubleQ(null, null))
    assertTrue(eqFloatQDoubleQ(null, undefined))
    assertFalse(eqFloatQDoubleQ(undefined, 0.toDouble()))
    assertFalse(eqFloatQDoubleQ(undefined, 1.toDouble()))
    assertTrue(eqFloatQDoubleQ(undefined, null))
    assertTrue(eqFloatQDoubleQ(undefined, undefined))
    assertTrue(eqFloatLong(0.toFloat(), 0.toLong()))
    assertFalse(eqFloatLong(0.toFloat(), 1.toLong()))
    assertFalse(eqFloatLong(1.toFloat(), 0.toLong()))
    assertTrue(eqFloatLong(1.toFloat(), 1.toLong()))
    assertTrue(eqFloatLongQ(0.toFloat(), 0.toLong()))
    assertFalse(eqFloatLongQ(0.toFloat(), 1.toLong()))
    assertFalse(eqFloatLongQ(0.toFloat(), null))
    assertFalse(eqFloatLongQ(0.toFloat(), undefined))
    assertFalse(eqFloatLongQ(1.toFloat(), 0.toLong()))
    assertTrue(eqFloatLongQ(1.toFloat(), 1.toLong()))
    assertFalse(eqFloatLongQ(1.toFloat(), null))
    assertFalse(eqFloatLongQ(1.toFloat(), undefined))
    assertTrue(eqFloatQLong(0.toFloat(), 0.toLong()))
    assertFalse(eqFloatQLong(0.toFloat(), 1.toLong()))
    assertFalse(eqFloatQLong(1.toFloat(), 0.toLong()))
    assertTrue(eqFloatQLong(1.toFloat(), 1.toLong()))
    assertFalse(eqFloatQLong(null, 0.toLong()))
    assertFalse(eqFloatQLong(null, 1.toLong()))
    assertFalse(eqFloatQLong(undefined, 0.toLong()))
    assertFalse(eqFloatQLong(undefined, 1.toLong()))
    assertTrue(eqFloatQLongQ(0.toFloat(), 0.toLong()))
    assertFalse(eqFloatQLongQ(0.toFloat(), 1.toLong()))
    assertFalse(eqFloatQLongQ(0.toFloat(), null))
    assertFalse(eqFloatQLongQ(0.toFloat(), undefined))
    assertFalse(eqFloatQLongQ(1.toFloat(), 0.toLong()))
    assertTrue(eqFloatQLongQ(1.toFloat(), 1.toLong()))
    assertFalse(eqFloatQLongQ(1.toFloat(), null))
    assertFalse(eqFloatQLongQ(1.toFloat(), undefined))
    assertFalse(eqFloatQLongQ(null, 0.toLong()))
    assertFalse(eqFloatQLongQ(null, 1.toLong()))
    assertTrue(eqFloatQLongQ(null, null))
    assertTrue(eqFloatQLongQ(null, undefined))
    assertFalse(eqFloatQLongQ(undefined, 0.toLong()))
    assertFalse(eqFloatQLongQ(undefined, 1.toLong()))
    assertTrue(eqFloatQLongQ(undefined, null))
    assertTrue(eqFloatQLongQ(undefined, undefined))
    assertTrue(eqDoubleByte(0.toDouble(), 0.toByte()))
    assertFalse(eqDoubleByte(0.toDouble(), 1.toByte()))
    assertFalse(eqDoubleByte(1.toDouble(), 0.toByte()))
    assertTrue(eqDoubleByte(1.toDouble(), 1.toByte()))
    assertTrue(eqDoubleByteQ(0.toDouble(), 0.toByte()))
    assertFalse(eqDoubleByteQ(0.toDouble(), 1.toByte()))
    assertFalse(eqDoubleByteQ(0.toDouble(), null))
    assertFalse(eqDoubleByteQ(0.toDouble(), undefined))
    assertFalse(eqDoubleByteQ(1.toDouble(), 0.toByte()))
    assertTrue(eqDoubleByteQ(1.toDouble(), 1.toByte()))
    assertFalse(eqDoubleByteQ(1.toDouble(), null))
    assertFalse(eqDoubleByteQ(1.toDouble(), undefined))
    assertTrue(eqDoubleQByte(0.toDouble(), 0.toByte()))
    assertFalse(eqDoubleQByte(0.toDouble(), 1.toByte()))
    assertFalse(eqDoubleQByte(1.toDouble(), 0.toByte()))
    assertTrue(eqDoubleQByte(1.toDouble(), 1.toByte()))
    assertFalse(eqDoubleQByte(null, 0.toByte()))
    assertFalse(eqDoubleQByte(null, 1.toByte()))
    assertFalse(eqDoubleQByte(undefined, 0.toByte()))
    assertFalse(eqDoubleQByte(undefined, 1.toByte()))
    assertTrue(eqDoubleQByteQ(0.toDouble(), 0.toByte()))
    assertFalse(eqDoubleQByteQ(0.toDouble(), 1.toByte()))
    assertFalse(eqDoubleQByteQ(0.toDouble(), null))
    assertFalse(eqDoubleQByteQ(0.toDouble(), undefined))
    assertFalse(eqDoubleQByteQ(1.toDouble(), 0.toByte()))
    assertTrue(eqDoubleQByteQ(1.toDouble(), 1.toByte()))
    assertFalse(eqDoubleQByteQ(1.toDouble(), null))
    assertFalse(eqDoubleQByteQ(1.toDouble(), undefined))
    assertFalse(eqDoubleQByteQ(null, 0.toByte()))
    assertFalse(eqDoubleQByteQ(null, 1.toByte()))
    assertTrue(eqDoubleQByteQ(null, null))
    assertTrue(eqDoubleQByteQ(null, undefined))
    assertFalse(eqDoubleQByteQ(undefined, 0.toByte()))
    assertFalse(eqDoubleQByteQ(undefined, 1.toByte()))
    assertTrue(eqDoubleQByteQ(undefined, null))
    assertTrue(eqDoubleQByteQ(undefined, undefined))
    assertFalse(eqDoubleBoolean(0.toDouble(), false))
    assertFalse(eqDoubleBoolean(0.toDouble(), true))
    assertFalse(eqDoubleBoolean(1.toDouble(), false))
    assertFalse(eqDoubleBoolean(1.toDouble(), true))
    assertFalse(eqDoubleBooleanQ(0.toDouble(), false))
    assertFalse(eqDoubleBooleanQ(0.toDouble(), true))
    assertFalse(eqDoubleBooleanQ(0.toDouble(), null))
    assertFalse(eqDoubleBooleanQ(0.toDouble(), undefined))
    assertFalse(eqDoubleBooleanQ(1.toDouble(), false))
    assertFalse(eqDoubleBooleanQ(1.toDouble(), true))
    assertFalse(eqDoubleBooleanQ(1.toDouble(), null))
    assertFalse(eqDoubleBooleanQ(1.toDouble(), undefined))
    assertFalse(eqDoubleQBoolean(0.toDouble(), false))
    assertFalse(eqDoubleQBoolean(0.toDouble(), true))
    assertFalse(eqDoubleQBoolean(1.toDouble(), false))
    assertFalse(eqDoubleQBoolean(1.toDouble(), true))
    assertFalse(eqDoubleQBoolean(null, false))
    assertFalse(eqDoubleQBoolean(null, true))
    assertFalse(eqDoubleQBoolean(undefined, false))
    assertFalse(eqDoubleQBoolean(undefined, true))
    assertFalse(eqDoubleQBooleanQ(0.toDouble(), false))
    assertFalse(eqDoubleQBooleanQ(0.toDouble(), true))
    assertFalse(eqDoubleQBooleanQ(0.toDouble(), null))
    assertFalse(eqDoubleQBooleanQ(0.toDouble(), undefined))
    assertFalse(eqDoubleQBooleanQ(1.toDouble(), false))
    assertFalse(eqDoubleQBooleanQ(1.toDouble(), true))
    assertFalse(eqDoubleQBooleanQ(1.toDouble(), null))
    assertFalse(eqDoubleQBooleanQ(1.toDouble(), undefined))
    assertFalse(eqDoubleQBooleanQ(null, false))
    assertFalse(eqDoubleQBooleanQ(null, true))
    assertTrue(eqDoubleQBooleanQ(null, null))
    assertTrue(eqDoubleQBooleanQ(null, undefined))
    assertFalse(eqDoubleQBooleanQ(undefined, false))
    assertFalse(eqDoubleQBooleanQ(undefined, true))
    assertTrue(eqDoubleQBooleanQ(undefined, null))
    assertTrue(eqDoubleQBooleanQ(undefined, undefined))
    assertTrue(eqDoubleShort(0.toDouble(), 0.toShort()))
    assertFalse(eqDoubleShort(0.toDouble(), 1.toShort()))
    assertFalse(eqDoubleShort(1.toDouble(), 0.toShort()))
    assertTrue(eqDoubleShort(1.toDouble(), 1.toShort()))
    assertTrue(eqDoubleShortQ(0.toDouble(), 0.toShort()))
    assertFalse(eqDoubleShortQ(0.toDouble(), 1.toShort()))
    assertFalse(eqDoubleShortQ(0.toDouble(), null))
    assertFalse(eqDoubleShortQ(0.toDouble(), undefined))
    assertFalse(eqDoubleShortQ(1.toDouble(), 0.toShort()))
    assertTrue(eqDoubleShortQ(1.toDouble(), 1.toShort()))
    assertFalse(eqDoubleShortQ(1.toDouble(), null))
    assertFalse(eqDoubleShortQ(1.toDouble(), undefined))
    assertTrue(eqDoubleQShort(0.toDouble(), 0.toShort()))
    assertFalse(eqDoubleQShort(0.toDouble(), 1.toShort()))
    assertFalse(eqDoubleQShort(1.toDouble(), 0.toShort()))
    assertTrue(eqDoubleQShort(1.toDouble(), 1.toShort()))
    assertFalse(eqDoubleQShort(null, 0.toShort()))
    assertFalse(eqDoubleQShort(null, 1.toShort()))
    assertFalse(eqDoubleQShort(undefined, 0.toShort()))
    assertFalse(eqDoubleQShort(undefined, 1.toShort()))
    assertTrue(eqDoubleQShortQ(0.toDouble(), 0.toShort()))
    assertFalse(eqDoubleQShortQ(0.toDouble(), 1.toShort()))
    assertFalse(eqDoubleQShortQ(0.toDouble(), null))
    assertFalse(eqDoubleQShortQ(0.toDouble(), undefined))
    assertFalse(eqDoubleQShortQ(1.toDouble(), 0.toShort()))
    assertTrue(eqDoubleQShortQ(1.toDouble(), 1.toShort()))
    assertFalse(eqDoubleQShortQ(1.toDouble(), null))
    assertFalse(eqDoubleQShortQ(1.toDouble(), undefined))
    assertFalse(eqDoubleQShortQ(null, 0.toShort()))
    assertFalse(eqDoubleQShortQ(null, 1.toShort()))
    assertTrue(eqDoubleQShortQ(null, null))
    assertTrue(eqDoubleQShortQ(null, undefined))
    assertFalse(eqDoubleQShortQ(undefined, 0.toShort()))
    assertFalse(eqDoubleQShortQ(undefined, 1.toShort()))
    assertTrue(eqDoubleQShortQ(undefined, null))
    assertTrue(eqDoubleQShortQ(undefined, undefined))
    assertFalse(eqDoubleChar(0.toDouble(), 0.toChar()))
    assertFalse(eqDoubleChar(0.toDouble(), 1.toChar()))
    assertFalse(eqDoubleChar(1.toDouble(), 0.toChar()))
    assertFalse(eqDoubleChar(1.toDouble(), 1.toChar()))
    assertFalse(eqDoubleCharQ(0.toDouble(), 0.toChar()))
    assertFalse(eqDoubleCharQ(0.toDouble(), 1.toChar()))
    assertFalse(eqDoubleCharQ(0.toDouble(), null))
    assertFalse(eqDoubleCharQ(0.toDouble(), undefined))
    assertFalse(eqDoubleCharQ(1.toDouble(), 0.toChar()))
    assertFalse(eqDoubleCharQ(1.toDouble(), 1.toChar()))
    assertFalse(eqDoubleCharQ(1.toDouble(), null))
    assertFalse(eqDoubleCharQ(1.toDouble(), undefined))
    assertFalse(eqDoubleQChar(0.toDouble(), 0.toChar()))
    assertFalse(eqDoubleQChar(0.toDouble(), 1.toChar()))
    assertFalse(eqDoubleQChar(1.toDouble(), 0.toChar()))
    assertFalse(eqDoubleQChar(1.toDouble(), 1.toChar()))
    assertFalse(eqDoubleQChar(null, 0.toChar()))
    assertFalse(eqDoubleQChar(null, 1.toChar()))
    assertFalse(eqDoubleQChar(undefined, 0.toChar()))
    assertFalse(eqDoubleQChar(undefined, 1.toChar()))
    assertFalse(eqDoubleQCharQ(0.toDouble(), 0.toChar()))
    assertFalse(eqDoubleQCharQ(0.toDouble(), 1.toChar()))
    assertFalse(eqDoubleQCharQ(0.toDouble(), null))
    assertFalse(eqDoubleQCharQ(0.toDouble(), undefined))
    assertFalse(eqDoubleQCharQ(1.toDouble(), 0.toChar()))
    assertFalse(eqDoubleQCharQ(1.toDouble(), 1.toChar()))
    assertFalse(eqDoubleQCharQ(1.toDouble(), null))
    assertFalse(eqDoubleQCharQ(1.toDouble(), undefined))
    assertFalse(eqDoubleQCharQ(null, 0.toChar()))
    assertFalse(eqDoubleQCharQ(null, 1.toChar()))
    assertTrue(eqDoubleQCharQ(null, null))
    assertTrue(eqDoubleQCharQ(null, undefined))
    assertFalse(eqDoubleQCharQ(undefined, 0.toChar()))
    assertFalse(eqDoubleQCharQ(undefined, 1.toChar()))
    assertTrue(eqDoubleQCharQ(undefined, null))
    assertTrue(eqDoubleQCharQ(undefined, undefined))
    assertTrue(eqDoubleInt(0.toDouble(), 0.toInt()))
    assertFalse(eqDoubleInt(0.toDouble(), 1.toInt()))
    assertFalse(eqDoubleInt(1.toDouble(), 0.toInt()))
    assertTrue(eqDoubleInt(1.toDouble(), 1.toInt()))
    assertTrue(eqDoubleIntQ(0.toDouble(), 0.toInt()))
    assertFalse(eqDoubleIntQ(0.toDouble(), 1.toInt()))
    assertFalse(eqDoubleIntQ(0.toDouble(), null))
    assertFalse(eqDoubleIntQ(0.toDouble(), undefined))
    assertFalse(eqDoubleIntQ(1.toDouble(), 0.toInt()))
    assertTrue(eqDoubleIntQ(1.toDouble(), 1.toInt()))
    assertFalse(eqDoubleIntQ(1.toDouble(), null))
    assertFalse(eqDoubleIntQ(1.toDouble(), undefined))
    assertTrue(eqDoubleQInt(0.toDouble(), 0.toInt()))
    assertFalse(eqDoubleQInt(0.toDouble(), 1.toInt()))
    assertFalse(eqDoubleQInt(1.toDouble(), 0.toInt()))
    assertTrue(eqDoubleQInt(1.toDouble(), 1.toInt()))
    assertFalse(eqDoubleQInt(null, 0.toInt()))
    assertFalse(eqDoubleQInt(null, 1.toInt()))
    assertFalse(eqDoubleQInt(undefined, 0.toInt()))
    assertFalse(eqDoubleQInt(undefined, 1.toInt()))
    assertTrue(eqDoubleQIntQ(0.toDouble(), 0.toInt()))
    assertFalse(eqDoubleQIntQ(0.toDouble(), 1.toInt()))
    assertFalse(eqDoubleQIntQ(0.toDouble(), null))
    assertFalse(eqDoubleQIntQ(0.toDouble(), undefined))
    assertFalse(eqDoubleQIntQ(1.toDouble(), 0.toInt()))
    assertTrue(eqDoubleQIntQ(1.toDouble(), 1.toInt()))
    assertFalse(eqDoubleQIntQ(1.toDouble(), null))
    assertFalse(eqDoubleQIntQ(1.toDouble(), undefined))
    assertFalse(eqDoubleQIntQ(null, 0.toInt()))
    assertFalse(eqDoubleQIntQ(null, 1.toInt()))
    assertTrue(eqDoubleQIntQ(null, null))
    assertTrue(eqDoubleQIntQ(null, undefined))
    assertFalse(eqDoubleQIntQ(undefined, 0.toInt()))
    assertFalse(eqDoubleQIntQ(undefined, 1.toInt()))
    assertTrue(eqDoubleQIntQ(undefined, null))
    assertTrue(eqDoubleQIntQ(undefined, undefined))
    assertTrue(eqDoubleFloat(0.toDouble(), 0.toFloat()))
    assertFalse(eqDoubleFloat(0.toDouble(), 1.toFloat()))
    assertFalse(eqDoubleFloat(1.toDouble(), 0.toFloat()))
    assertTrue(eqDoubleFloat(1.toDouble(), 1.toFloat()))
    assertTrue(eqDoubleFloatQ(0.toDouble(), 0.toFloat()))
    assertFalse(eqDoubleFloatQ(0.toDouble(), 1.toFloat()))
    assertFalse(eqDoubleFloatQ(0.toDouble(), null))
    assertFalse(eqDoubleFloatQ(0.toDouble(), undefined))
    assertFalse(eqDoubleFloatQ(1.toDouble(), 0.toFloat()))
    assertTrue(eqDoubleFloatQ(1.toDouble(), 1.toFloat()))
    assertFalse(eqDoubleFloatQ(1.toDouble(), null))
    assertFalse(eqDoubleFloatQ(1.toDouble(), undefined))
    assertTrue(eqDoubleQFloat(0.toDouble(), 0.toFloat()))
    assertFalse(eqDoubleQFloat(0.toDouble(), 1.toFloat()))
    assertFalse(eqDoubleQFloat(1.toDouble(), 0.toFloat()))
    assertTrue(eqDoubleQFloat(1.toDouble(), 1.toFloat()))
    assertFalse(eqDoubleQFloat(null, 0.toFloat()))
    assertFalse(eqDoubleQFloat(null, 1.toFloat()))
    assertFalse(eqDoubleQFloat(undefined, 0.toFloat()))
    assertFalse(eqDoubleQFloat(undefined, 1.toFloat()))
    assertTrue(eqDoubleQFloatQ(0.toDouble(), 0.toFloat()))
    assertFalse(eqDoubleQFloatQ(0.toDouble(), 1.toFloat()))
    assertFalse(eqDoubleQFloatQ(0.toDouble(), null))
    assertFalse(eqDoubleQFloatQ(0.toDouble(), undefined))
    assertFalse(eqDoubleQFloatQ(1.toDouble(), 0.toFloat()))
    assertTrue(eqDoubleQFloatQ(1.toDouble(), 1.toFloat()))
    assertFalse(eqDoubleQFloatQ(1.toDouble(), null))
    assertFalse(eqDoubleQFloatQ(1.toDouble(), undefined))
    assertFalse(eqDoubleQFloatQ(null, 0.toFloat()))
    assertFalse(eqDoubleQFloatQ(null, 1.toFloat()))
    assertTrue(eqDoubleQFloatQ(null, null))
    assertTrue(eqDoubleQFloatQ(null, undefined))
    assertFalse(eqDoubleQFloatQ(undefined, 0.toFloat()))
    assertFalse(eqDoubleQFloatQ(undefined, 1.toFloat()))
    assertTrue(eqDoubleQFloatQ(undefined, null))
    assertTrue(eqDoubleQFloatQ(undefined, undefined))
    assertTrue(eqDoubleDouble(0.toDouble(), 0.toDouble()))
    assertFalse(eqDoubleDouble(0.toDouble(), 1.toDouble()))
    assertFalse(eqDoubleDouble(1.toDouble(), 0.toDouble()))
    assertTrue(eqDoubleDouble(1.toDouble(), 1.toDouble()))
    assertTrue(eqDoubleDoubleQ(0.toDouble(), 0.toDouble()))
    assertFalse(eqDoubleDoubleQ(0.toDouble(), 1.toDouble()))
    assertFalse(eqDoubleDoubleQ(0.toDouble(), null))
    assertFalse(eqDoubleDoubleQ(0.toDouble(), undefined))
    assertFalse(eqDoubleDoubleQ(1.toDouble(), 0.toDouble()))
    assertTrue(eqDoubleDoubleQ(1.toDouble(), 1.toDouble()))
    assertFalse(eqDoubleDoubleQ(1.toDouble(), null))
    assertFalse(eqDoubleDoubleQ(1.toDouble(), undefined))
    assertTrue(eqDoubleQDouble(0.toDouble(), 0.toDouble()))
    assertFalse(eqDoubleQDouble(0.toDouble(), 1.toDouble()))
    assertFalse(eqDoubleQDouble(1.toDouble(), 0.toDouble()))
    assertTrue(eqDoubleQDouble(1.toDouble(), 1.toDouble()))
    assertFalse(eqDoubleQDouble(null, 0.toDouble()))
    assertFalse(eqDoubleQDouble(null, 1.toDouble()))
    assertFalse(eqDoubleQDouble(undefined, 0.toDouble()))
    assertFalse(eqDoubleQDouble(undefined, 1.toDouble()))
    assertTrue(eqDoubleQDoubleQ(0.toDouble(), 0.toDouble()))
    assertFalse(eqDoubleQDoubleQ(0.toDouble(), 1.toDouble()))
    assertFalse(eqDoubleQDoubleQ(0.toDouble(), null))
    assertFalse(eqDoubleQDoubleQ(0.toDouble(), undefined))
    assertFalse(eqDoubleQDoubleQ(1.toDouble(), 0.toDouble()))
    assertTrue(eqDoubleQDoubleQ(1.toDouble(), 1.toDouble()))
    assertFalse(eqDoubleQDoubleQ(1.toDouble(), null))
    assertFalse(eqDoubleQDoubleQ(1.toDouble(), undefined))
    assertFalse(eqDoubleQDoubleQ(null, 0.toDouble()))
    assertFalse(eqDoubleQDoubleQ(null, 1.toDouble()))
    assertTrue(eqDoubleQDoubleQ(null, null))
    assertTrue(eqDoubleQDoubleQ(null, undefined))
    assertFalse(eqDoubleQDoubleQ(undefined, 0.toDouble()))
    assertFalse(eqDoubleQDoubleQ(undefined, 1.toDouble()))
    assertTrue(eqDoubleQDoubleQ(undefined, null))
    assertTrue(eqDoubleQDoubleQ(undefined, undefined))
    assertTrue(eqDoubleLong(0.toDouble(), 0.toLong()))
    assertFalse(eqDoubleLong(0.toDouble(), 1.toLong()))
    assertFalse(eqDoubleLong(1.toDouble(), 0.toLong()))
    assertTrue(eqDoubleLong(1.toDouble(), 1.toLong()))
    assertTrue(eqDoubleLongQ(0.toDouble(), 0.toLong()))
    assertFalse(eqDoubleLongQ(0.toDouble(), 1.toLong()))
    assertFalse(eqDoubleLongQ(0.toDouble(), null))
    assertFalse(eqDoubleLongQ(0.toDouble(), undefined))
    assertFalse(eqDoubleLongQ(1.toDouble(), 0.toLong()))
    assertTrue(eqDoubleLongQ(1.toDouble(), 1.toLong()))
    assertFalse(eqDoubleLongQ(1.toDouble(), null))
    assertFalse(eqDoubleLongQ(1.toDouble(), undefined))
    assertTrue(eqDoubleQLong(0.toDouble(), 0.toLong()))
    assertFalse(eqDoubleQLong(0.toDouble(), 1.toLong()))
    assertFalse(eqDoubleQLong(1.toDouble(), 0.toLong()))
    assertTrue(eqDoubleQLong(1.toDouble(), 1.toLong()))
    assertFalse(eqDoubleQLong(null, 0.toLong()))
    assertFalse(eqDoubleQLong(null, 1.toLong()))
    assertFalse(eqDoubleQLong(undefined, 0.toLong()))
    assertFalse(eqDoubleQLong(undefined, 1.toLong()))
    assertTrue(eqDoubleQLongQ(0.toDouble(), 0.toLong()))
    assertFalse(eqDoubleQLongQ(0.toDouble(), 1.toLong()))
    assertFalse(eqDoubleQLongQ(0.toDouble(), null))
    assertFalse(eqDoubleQLongQ(0.toDouble(), undefined))
    assertFalse(eqDoubleQLongQ(1.toDouble(), 0.toLong()))
    assertTrue(eqDoubleQLongQ(1.toDouble(), 1.toLong()))
    assertFalse(eqDoubleQLongQ(1.toDouble(), null))
    assertFalse(eqDoubleQLongQ(1.toDouble(), undefined))
    assertFalse(eqDoubleQLongQ(null, 0.toLong()))
    assertFalse(eqDoubleQLongQ(null, 1.toLong()))
    assertTrue(eqDoubleQLongQ(null, null))
    assertTrue(eqDoubleQLongQ(null, undefined))
    assertFalse(eqDoubleQLongQ(undefined, 0.toLong()))
    assertFalse(eqDoubleQLongQ(undefined, 1.toLong()))
    assertTrue(eqDoubleQLongQ(undefined, null))
    assertTrue(eqDoubleQLongQ(undefined, undefined))
    assertTrue(eqLongByte(0.toLong(), 0.toByte()))
    assertFalse(eqLongByte(0.toLong(), 1.toByte()))
    assertFalse(eqLongByte(1.toLong(), 0.toByte()))
    assertTrue(eqLongByte(1.toLong(), 1.toByte()))
    assertTrue(eqLongByteQ(0.toLong(), 0.toByte()))
    assertFalse(eqLongByteQ(0.toLong(), 1.toByte()))
    assertFalse(eqLongByteQ(0.toLong(), null))
    assertFalse(eqLongByteQ(0.toLong(), undefined))
    assertFalse(eqLongByteQ(1.toLong(), 0.toByte()))
    assertTrue(eqLongByteQ(1.toLong(), 1.toByte()))
    assertFalse(eqLongByteQ(1.toLong(), null))
    assertFalse(eqLongByteQ(1.toLong(), undefined))
    assertTrue(eqLongQByte(0.toLong(), 0.toByte()))
    assertFalse(eqLongQByte(0.toLong(), 1.toByte()))
    assertFalse(eqLongQByte(1.toLong(), 0.toByte()))
    assertTrue(eqLongQByte(1.toLong(), 1.toByte()))
    assertFalse(eqLongQByte(null, 0.toByte()))
    assertFalse(eqLongQByte(null, 1.toByte()))
    assertFalse(eqLongQByte(undefined, 0.toByte()))
    assertFalse(eqLongQByte(undefined, 1.toByte()))
    assertTrue(eqLongQByteQ(0.toLong(), 0.toByte()))
    assertFalse(eqLongQByteQ(0.toLong(), 1.toByte()))
    assertFalse(eqLongQByteQ(0.toLong(), null))
    assertFalse(eqLongQByteQ(0.toLong(), undefined))
    assertFalse(eqLongQByteQ(1.toLong(), 0.toByte()))
    assertTrue(eqLongQByteQ(1.toLong(), 1.toByte()))
    assertFalse(eqLongQByteQ(1.toLong(), null))
    assertFalse(eqLongQByteQ(1.toLong(), undefined))
    assertFalse(eqLongQByteQ(null, 0.toByte()))
    assertFalse(eqLongQByteQ(null, 1.toByte()))
    assertTrue(eqLongQByteQ(null, null))
    assertTrue(eqLongQByteQ(null, undefined))
    assertFalse(eqLongQByteQ(undefined, 0.toByte()))
    assertFalse(eqLongQByteQ(undefined, 1.toByte()))
    assertTrue(eqLongQByteQ(undefined, null))
    assertTrue(eqLongQByteQ(undefined, undefined))
    assertFalse(eqLongBoolean(0.toLong(), false))
    assertFalse(eqLongBoolean(0.toLong(), true))
    assertFalse(eqLongBoolean(1.toLong(), false))
    assertFalse(eqLongBoolean(1.toLong(), true))
    assertFalse(eqLongBooleanQ(0.toLong(), false))
    assertFalse(eqLongBooleanQ(0.toLong(), true))
    assertFalse(eqLongBooleanQ(0.toLong(), null))
    assertFalse(eqLongBooleanQ(0.toLong(), undefined))
    assertFalse(eqLongBooleanQ(1.toLong(), false))
    assertFalse(eqLongBooleanQ(1.toLong(), true))
    assertFalse(eqLongBooleanQ(1.toLong(), null))
    assertFalse(eqLongBooleanQ(1.toLong(), undefined))
    assertFalse(eqLongQBoolean(0.toLong(), false))
    assertFalse(eqLongQBoolean(0.toLong(), true))
    assertFalse(eqLongQBoolean(1.toLong(), false))
    assertFalse(eqLongQBoolean(1.toLong(), true))
    assertFalse(eqLongQBoolean(null, false))
    assertFalse(eqLongQBoolean(null, true))
    assertFalse(eqLongQBoolean(undefined, false))
    assertFalse(eqLongQBoolean(undefined, true))
    assertFalse(eqLongQBooleanQ(0.toLong(), false))
    assertFalse(eqLongQBooleanQ(0.toLong(), true))
    assertFalse(eqLongQBooleanQ(0.toLong(), null))
    assertFalse(eqLongQBooleanQ(0.toLong(), undefined))
    assertFalse(eqLongQBooleanQ(1.toLong(), false))
    assertFalse(eqLongQBooleanQ(1.toLong(), true))
    assertFalse(eqLongQBooleanQ(1.toLong(), null))
    assertFalse(eqLongQBooleanQ(1.toLong(), undefined))
    assertFalse(eqLongQBooleanQ(null, false))
    assertFalse(eqLongQBooleanQ(null, true))
    assertTrue(eqLongQBooleanQ(null, null))
    assertTrue(eqLongQBooleanQ(null, undefined))
    assertFalse(eqLongQBooleanQ(undefined, false))
    assertFalse(eqLongQBooleanQ(undefined, true))
    assertTrue(eqLongQBooleanQ(undefined, null))
    assertTrue(eqLongQBooleanQ(undefined, undefined))
    assertTrue(eqLongShort(0.toLong(), 0.toShort()))
    assertFalse(eqLongShort(0.toLong(), 1.toShort()))
    assertFalse(eqLongShort(1.toLong(), 0.toShort()))
    assertTrue(eqLongShort(1.toLong(), 1.toShort()))
    assertTrue(eqLongShortQ(0.toLong(), 0.toShort()))
    assertFalse(eqLongShortQ(0.toLong(), 1.toShort()))
    assertFalse(eqLongShortQ(0.toLong(), null))
    assertFalse(eqLongShortQ(0.toLong(), undefined))
    assertFalse(eqLongShortQ(1.toLong(), 0.toShort()))
    assertTrue(eqLongShortQ(1.toLong(), 1.toShort()))
    assertFalse(eqLongShortQ(1.toLong(), null))
    assertFalse(eqLongShortQ(1.toLong(), undefined))
    assertTrue(eqLongQShort(0.toLong(), 0.toShort()))
    assertFalse(eqLongQShort(0.toLong(), 1.toShort()))
    assertFalse(eqLongQShort(1.toLong(), 0.toShort()))
    assertTrue(eqLongQShort(1.toLong(), 1.toShort()))
    assertFalse(eqLongQShort(null, 0.toShort()))
    assertFalse(eqLongQShort(null, 1.toShort()))
    assertFalse(eqLongQShort(undefined, 0.toShort()))
    assertFalse(eqLongQShort(undefined, 1.toShort()))
    assertTrue(eqLongQShortQ(0.toLong(), 0.toShort()))
    assertFalse(eqLongQShortQ(0.toLong(), 1.toShort()))
    assertFalse(eqLongQShortQ(0.toLong(), null))
    assertFalse(eqLongQShortQ(0.toLong(), undefined))
    assertFalse(eqLongQShortQ(1.toLong(), 0.toShort()))
    assertTrue(eqLongQShortQ(1.toLong(), 1.toShort()))
    assertFalse(eqLongQShortQ(1.toLong(), null))
    assertFalse(eqLongQShortQ(1.toLong(), undefined))
    assertFalse(eqLongQShortQ(null, 0.toShort()))
    assertFalse(eqLongQShortQ(null, 1.toShort()))
    assertTrue(eqLongQShortQ(null, null))
    assertTrue(eqLongQShortQ(null, undefined))
    assertFalse(eqLongQShortQ(undefined, 0.toShort()))
    assertFalse(eqLongQShortQ(undefined, 1.toShort()))
    assertTrue(eqLongQShortQ(undefined, null))
    assertTrue(eqLongQShortQ(undefined, undefined))
    assertFalse(eqLongChar(0.toLong(), 0.toChar()))
    assertFalse(eqLongChar(0.toLong(), 1.toChar()))
    assertFalse(eqLongChar(1.toLong(), 0.toChar()))
    assertFalse(eqLongChar(1.toLong(), 1.toChar()))
    assertFalse(eqLongCharQ(0.toLong(), 0.toChar()))
    assertFalse(eqLongCharQ(0.toLong(), 1.toChar()))
    assertFalse(eqLongCharQ(0.toLong(), null))
    assertFalse(eqLongCharQ(0.toLong(), undefined))
    assertFalse(eqLongCharQ(1.toLong(), 0.toChar()))
    assertFalse(eqLongCharQ(1.toLong(), 1.toChar()))
    assertFalse(eqLongCharQ(1.toLong(), null))
    assertFalse(eqLongCharQ(1.toLong(), undefined))
    assertFalse(eqLongQChar(0.toLong(), 0.toChar()))
    assertFalse(eqLongQChar(0.toLong(), 1.toChar()))
    assertFalse(eqLongQChar(1.toLong(), 0.toChar()))
    assertFalse(eqLongQChar(1.toLong(), 1.toChar()))
    assertFalse(eqLongQChar(null, 0.toChar()))
    assertFalse(eqLongQChar(null, 1.toChar()))
    assertFalse(eqLongQChar(undefined, 0.toChar()))
    assertFalse(eqLongQChar(undefined, 1.toChar()))
    assertFalse(eqLongQCharQ(0.toLong(), 0.toChar()))
    assertFalse(eqLongQCharQ(0.toLong(), 1.toChar()))
    assertFalse(eqLongQCharQ(0.toLong(), null))
    assertFalse(eqLongQCharQ(0.toLong(), undefined))
    assertFalse(eqLongQCharQ(1.toLong(), 0.toChar()))
    assertFalse(eqLongQCharQ(1.toLong(), 1.toChar()))
    assertFalse(eqLongQCharQ(1.toLong(), null))
    assertFalse(eqLongQCharQ(1.toLong(), undefined))
    assertFalse(eqLongQCharQ(null, 0.toChar()))
    assertFalse(eqLongQCharQ(null, 1.toChar()))
    assertTrue(eqLongQCharQ(null, null))
    assertTrue(eqLongQCharQ(null, undefined))
    assertFalse(eqLongQCharQ(undefined, 0.toChar()))
    assertFalse(eqLongQCharQ(undefined, 1.toChar()))
    assertTrue(eqLongQCharQ(undefined, null))
    assertTrue(eqLongQCharQ(undefined, undefined))
    assertTrue(eqLongInt(0.toLong(), 0.toInt()))
    assertFalse(eqLongInt(0.toLong(), 1.toInt()))
    assertFalse(eqLongInt(1.toLong(), 0.toInt()))
    assertTrue(eqLongInt(1.toLong(), 1.toInt()))
    assertTrue(eqLongIntQ(0.toLong(), 0.toInt()))
    assertFalse(eqLongIntQ(0.toLong(), 1.toInt()))
    assertFalse(eqLongIntQ(0.toLong(), null))
    assertFalse(eqLongIntQ(0.toLong(), undefined))
    assertFalse(eqLongIntQ(1.toLong(), 0.toInt()))
    assertTrue(eqLongIntQ(1.toLong(), 1.toInt()))
    assertFalse(eqLongIntQ(1.toLong(), null))
    assertFalse(eqLongIntQ(1.toLong(), undefined))
    assertTrue(eqLongQInt(0.toLong(), 0.toInt()))
    assertFalse(eqLongQInt(0.toLong(), 1.toInt()))
    assertFalse(eqLongQInt(1.toLong(), 0.toInt()))
    assertTrue(eqLongQInt(1.toLong(), 1.toInt()))
    assertFalse(eqLongQInt(null, 0.toInt()))
    assertFalse(eqLongQInt(null, 1.toInt()))
    assertFalse(eqLongQInt(undefined, 0.toInt()))
    assertFalse(eqLongQInt(undefined, 1.toInt()))
    assertTrue(eqLongQIntQ(0.toLong(), 0.toInt()))
    assertFalse(eqLongQIntQ(0.toLong(), 1.toInt()))
    assertFalse(eqLongQIntQ(0.toLong(), null))
    assertFalse(eqLongQIntQ(0.toLong(), undefined))
    assertFalse(eqLongQIntQ(1.toLong(), 0.toInt()))
    assertTrue(eqLongQIntQ(1.toLong(), 1.toInt()))
    assertFalse(eqLongQIntQ(1.toLong(), null))
    assertFalse(eqLongQIntQ(1.toLong(), undefined))
    assertFalse(eqLongQIntQ(null, 0.toInt()))
    assertFalse(eqLongQIntQ(null, 1.toInt()))
    assertTrue(eqLongQIntQ(null, null))
    assertTrue(eqLongQIntQ(null, undefined))
    assertFalse(eqLongQIntQ(undefined, 0.toInt()))
    assertFalse(eqLongQIntQ(undefined, 1.toInt()))
    assertTrue(eqLongQIntQ(undefined, null))
    assertTrue(eqLongQIntQ(undefined, undefined))
    assertTrue(eqLongFloat(0.toLong(), 0.toFloat()))
    assertFalse(eqLongFloat(0.toLong(), 1.toFloat()))
    assertFalse(eqLongFloat(1.toLong(), 0.toFloat()))
    assertTrue(eqLongFloat(1.toLong(), 1.toFloat()))
    assertTrue(eqLongFloatQ(0.toLong(), 0.toFloat()))
    assertFalse(eqLongFloatQ(0.toLong(), 1.toFloat()))
    assertFalse(eqLongFloatQ(0.toLong(), null))
    assertFalse(eqLongFloatQ(0.toLong(), undefined))
    assertFalse(eqLongFloatQ(1.toLong(), 0.toFloat()))
    assertTrue(eqLongFloatQ(1.toLong(), 1.toFloat()))
    assertFalse(eqLongFloatQ(1.toLong(), null))
    assertFalse(eqLongFloatQ(1.toLong(), undefined))
    assertTrue(eqLongQFloat(0.toLong(), 0.toFloat()))
    assertFalse(eqLongQFloat(0.toLong(), 1.toFloat()))
    assertFalse(eqLongQFloat(1.toLong(), 0.toFloat()))
    assertTrue(eqLongQFloat(1.toLong(), 1.toFloat()))
    assertFalse(eqLongQFloat(null, 0.toFloat()))
    assertFalse(eqLongQFloat(null, 1.toFloat()))
    assertFalse(eqLongQFloat(undefined, 0.toFloat()))
    assertFalse(eqLongQFloat(undefined, 1.toFloat()))
    assertTrue(eqLongQFloatQ(0.toLong(), 0.toFloat()))
    assertFalse(eqLongQFloatQ(0.toLong(), 1.toFloat()))
    assertFalse(eqLongQFloatQ(0.toLong(), null))
    assertFalse(eqLongQFloatQ(0.toLong(), undefined))
    assertFalse(eqLongQFloatQ(1.toLong(), 0.toFloat()))
    assertTrue(eqLongQFloatQ(1.toLong(), 1.toFloat()))
    assertFalse(eqLongQFloatQ(1.toLong(), null))
    assertFalse(eqLongQFloatQ(1.toLong(), undefined))
    assertFalse(eqLongQFloatQ(null, 0.toFloat()))
    assertFalse(eqLongQFloatQ(null, 1.toFloat()))
    assertTrue(eqLongQFloatQ(null, null))
    assertTrue(eqLongQFloatQ(null, undefined))
    assertFalse(eqLongQFloatQ(undefined, 0.toFloat()))
    assertFalse(eqLongQFloatQ(undefined, 1.toFloat()))
    assertTrue(eqLongQFloatQ(undefined, null))
    assertTrue(eqLongQFloatQ(undefined, undefined))
    assertTrue(eqLongDouble(0.toLong(), 0.toDouble()))
    assertFalse(eqLongDouble(0.toLong(), 1.toDouble()))
    assertFalse(eqLongDouble(1.toLong(), 0.toDouble()))
    assertTrue(eqLongDouble(1.toLong(), 1.toDouble()))
    assertTrue(eqLongDoubleQ(0.toLong(), 0.toDouble()))
    assertFalse(eqLongDoubleQ(0.toLong(), 1.toDouble()))
    assertFalse(eqLongDoubleQ(0.toLong(), null))
    assertFalse(eqLongDoubleQ(0.toLong(), undefined))
    assertFalse(eqLongDoubleQ(1.toLong(), 0.toDouble()))
    assertTrue(eqLongDoubleQ(1.toLong(), 1.toDouble()))
    assertFalse(eqLongDoubleQ(1.toLong(), null))
    assertFalse(eqLongDoubleQ(1.toLong(), undefined))
    assertTrue(eqLongQDouble(0.toLong(), 0.toDouble()))
    assertFalse(eqLongQDouble(0.toLong(), 1.toDouble()))
    assertFalse(eqLongQDouble(1.toLong(), 0.toDouble()))
    assertTrue(eqLongQDouble(1.toLong(), 1.toDouble()))
    assertFalse(eqLongQDouble(null, 0.toDouble()))
    assertFalse(eqLongQDouble(null, 1.toDouble()))
    assertFalse(eqLongQDouble(undefined, 0.toDouble()))
    assertFalse(eqLongQDouble(undefined, 1.toDouble()))
    assertTrue(eqLongQDoubleQ(0.toLong(), 0.toDouble()))
    assertFalse(eqLongQDoubleQ(0.toLong(), 1.toDouble()))
    assertFalse(eqLongQDoubleQ(0.toLong(), null))
    assertFalse(eqLongQDoubleQ(0.toLong(), undefined))
    assertFalse(eqLongQDoubleQ(1.toLong(), 0.toDouble()))
    assertTrue(eqLongQDoubleQ(1.toLong(), 1.toDouble()))
    assertFalse(eqLongQDoubleQ(1.toLong(), null))
    assertFalse(eqLongQDoubleQ(1.toLong(), undefined))
    assertFalse(eqLongQDoubleQ(null, 0.toDouble()))
    assertFalse(eqLongQDoubleQ(null, 1.toDouble()))
    assertTrue(eqLongQDoubleQ(null, null))
    assertTrue(eqLongQDoubleQ(null, undefined))
    assertFalse(eqLongQDoubleQ(undefined, 0.toDouble()))
    assertFalse(eqLongQDoubleQ(undefined, 1.toDouble()))
    assertTrue(eqLongQDoubleQ(undefined, null))
    assertTrue(eqLongQDoubleQ(undefined, undefined))
    assertTrue(eqLongLong(0.toLong(), 0.toLong()))
    assertFalse(eqLongLong(0.toLong(), 1.toLong()))
    assertFalse(eqLongLong(1.toLong(), 0.toLong()))
    assertTrue(eqLongLong(1.toLong(), 1.toLong()))
    assertTrue(eqLongLongQ(0.toLong(), 0.toLong()))
    assertFalse(eqLongLongQ(0.toLong(), 1.toLong()))
    assertFalse(eqLongLongQ(0.toLong(), null))
    assertFalse(eqLongLongQ(0.toLong(), undefined))
    assertFalse(eqLongLongQ(1.toLong(), 0.toLong()))
    assertTrue(eqLongLongQ(1.toLong(), 1.toLong()))
    assertFalse(eqLongLongQ(1.toLong(), null))
    assertFalse(eqLongLongQ(1.toLong(), undefined))
    assertTrue(eqLongQLong(0.toLong(), 0.toLong()))
    assertFalse(eqLongQLong(0.toLong(), 1.toLong()))
    assertFalse(eqLongQLong(1.toLong(), 0.toLong()))
    assertTrue(eqLongQLong(1.toLong(), 1.toLong()))
    assertFalse(eqLongQLong(null, 0.toLong()))
    assertFalse(eqLongQLong(null, 1.toLong()))
    assertFalse(eqLongQLong(undefined, 0.toLong()))
    assertFalse(eqLongQLong(undefined, 1.toLong()))
    assertTrue(eqLongQLongQ(0.toLong(), 0.toLong()))
    assertFalse(eqLongQLongQ(0.toLong(), 1.toLong()))
    assertFalse(eqLongQLongQ(0.toLong(), null))
    assertFalse(eqLongQLongQ(0.toLong(), undefined))
    assertFalse(eqLongQLongQ(1.toLong(), 0.toLong()))
    assertTrue(eqLongQLongQ(1.toLong(), 1.toLong()))
    assertFalse(eqLongQLongQ(1.toLong(), null))
    assertFalse(eqLongQLongQ(1.toLong(), undefined))
    assertFalse(eqLongQLongQ(null, 0.toLong()))
    assertFalse(eqLongQLongQ(null, 1.toLong()))
    assertTrue(eqLongQLongQ(null, null))
    assertTrue(eqLongQLongQ(null, undefined))
    assertFalse(eqLongQLongQ(undefined, 0.toLong()))
    assertFalse(eqLongQLongQ(undefined, 1.toLong()))
    assertTrue(eqLongQLongQ(undefined, null))
    assertTrue(eqLongQLongQ(undefined, undefined))
    return "OK"
}