// WITH_STDLIB

fun <T> foo(a: Result<T>): T = bar(a, object : IFace<Result<T>, T> {
    override fun call(ic: Result<T>): T = ic.getOrThrow()
})

interface IFace<T, R> {
    fun call(ic: T): R
}

fun <T, R> bar(value: T, f: IFace<T, R>): R {
    return f.call(value)
}

fun box(): String {
    val res = foo<Int>(Result.success(40)) + 2
    return if (res != 42) "FAIL $res" else "OK"
}