// TARGET_BACKEND: JVM
// WITH_STDLIB
// WITH_COROUTINES

// FILE: I.kt

interface I {
    suspend fun foo(x: Int): String
}

// FILE: JavaClass.java

public class JavaClass implements I {
    @Override
    public Object foo(int x, kotlin.coroutines.Continuation<? super String> continuation) {
        continuation.resumeWith("OK");
        return kotlin.coroutines.intrinsics.IntrinsicsKt.getCOROUTINE_SUSPENDED();
    }
}

// FILE: main.kt
import helpers.*
import kotlin.coroutines.*
import kotlin.coroutines.intrinsics.*

fun builder(c: suspend () -> Unit) {
    c.startCoroutine(EmptyContinuation)
}

fun box(): String {
    var result = "fail"

    builder {
        result = JavaClass().foo(1)
    }

    return result
}
