// !LANGUAGE: +InlineClasses
// WITH_STDLIB

fun box(): String {
    testForInUIntArrayWithUpcactToAny()
    testForInUIntArrayWithUpcactToComparable()

    return "OK"
}

fun testForInUIntArrayWithUpcactToAny() {
    var test = ""
    for (x: Any in uintArrayOf(1u, 2u, 3u)) {
        test = "$test$x;"
        useUIntAsAny(x)
    }
    if (test != "1;2;3;") throw AssertionError(test)
}

fun testForInUIntArrayWithUpcactToComparable() {
    var test = ""
    for (x: Comparable<*> in uintArrayOf(1u, 2u, 3u)) {
        test = "$test$x;"
        useUIntAsComparable(x)
    }
    if (test != "1;2;3;") throw AssertionError(test)
}

fun useUIntAsAny(a: Any) {
    a as UInt
}

fun useUIntAsComparable(a: Comparable<*>) {
    a as Comparable<*>
}