/*
 * Copyright 2010-2021 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.test.runners.ir;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link GenerateNewCompilerTests.kt}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("compiler/testData/ir/irText")
@TestDataPath("$PROJECT_ROOT")
public class Fir2IrTextTestGenerated extends AbstractFir2IrTextTest {
    @Test
    public void testAllFilesPresentInIrText() throws Exception {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Nested
    @TestMetadata("compiler/testData/ir/irText/classes")
    @TestDataPath("$PROJECT_ROOT")
    public class Classes {
        @Test
        @TestMetadata("47424.kt")
        public void test47424() throws Exception {
            runTest("compiler/testData/ir/irText/classes/47424.kt");
        }

        @Test
        @TestMetadata("abstractMembers.kt")
        public void testAbstractMembers() throws Exception {
            runTest("compiler/testData/ir/irText/classes/abstractMembers.kt");
        }

        @Test
        public void testAllFilesPresentInClasses() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/classes"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("annotationClasses.kt")
        public void testAnnotationClasses() throws Exception {
            runTest("compiler/testData/ir/irText/classes/annotationClasses.kt");
        }

        @Test
        @TestMetadata("argumentReorderingInDelegatingConstructorCall.kt")
        public void testArgumentReorderingInDelegatingConstructorCall() throws Exception {
            runTest("compiler/testData/ir/irText/classes/argumentReorderingInDelegatingConstructorCall.kt");
        }

        @Test
        @TestMetadata("clashingFakeOverrideSignatures.kt")
        public void testClashingFakeOverrideSignatures() throws Exception {
            runTest("compiler/testData/ir/irText/classes/clashingFakeOverrideSignatures.kt");
        }

        @Test
        @TestMetadata("classMembers.kt")
        public void testClassMembers() throws Exception {
            runTest("compiler/testData/ir/irText/classes/classMembers.kt");
        }

        @Test
        @TestMetadata("classes.kt")
        public void testClasses() throws Exception {
            runTest("compiler/testData/ir/irText/classes/classes.kt");
        }

        @Test
        @TestMetadata("cloneable.kt")
        public void testCloneable() throws Exception {
            runTest("compiler/testData/ir/irText/classes/cloneable.kt");
        }

        @Test
        @TestMetadata("companionObject.kt")
        public void testCompanionObject() throws Exception {
            runTest("compiler/testData/ir/irText/classes/companionObject.kt");
        }

        @Test
        @TestMetadata("delegatedGenericImplementation.kt")
        public void testDelegatedGenericImplementation() throws Exception {
            runTest("compiler/testData/ir/irText/classes/delegatedGenericImplementation.kt");
        }

        @Test
        @TestMetadata("delegatedImplementation.kt")
        public void testDelegatedImplementation() throws Exception {
            runTest("compiler/testData/ir/irText/classes/delegatedImplementation.kt");
        }

        @Test
        @TestMetadata("delegatedImplementationOfJavaInterface.kt")
        public void testDelegatedImplementationOfJavaInterface() throws Exception {
            runTest("compiler/testData/ir/irText/classes/delegatedImplementationOfJavaInterface.kt");
        }

        @Test
        @TestMetadata("delegatedImplementationWithExplicitOverride.kt")
        public void testDelegatedImplementationWithExplicitOverride() throws Exception {
            runTest("compiler/testData/ir/irText/classes/delegatedImplementationWithExplicitOverride.kt");
        }

        @Test
        @TestMetadata("delegatingConstructorCallToTypeAliasConstructor.kt")
        public void testDelegatingConstructorCallToTypeAliasConstructor() throws Exception {
            runTest("compiler/testData/ir/irText/classes/delegatingConstructorCallToTypeAliasConstructor.kt");
        }

        @Test
        @TestMetadata("delegatingConstructorCallsInSecondaryConstructors.kt")
        public void testDelegatingConstructorCallsInSecondaryConstructors() throws Exception {
            runTest("compiler/testData/ir/irText/classes/delegatingConstructorCallsInSecondaryConstructors.kt");
        }

        @Test
        @TestMetadata("enum.kt")
        public void testEnum() throws Exception {
            runTest("compiler/testData/ir/irText/classes/enum.kt");
        }

        @Test
        @TestMetadata("enumClassModality.kt")
        public void testEnumClassModality() throws Exception {
            runTest("compiler/testData/ir/irText/classes/enumClassModality.kt");
        }

        @Test
        @TestMetadata("enumWithMultipleCtors.kt")
        public void testEnumWithMultipleCtors() throws Exception {
            runTest("compiler/testData/ir/irText/classes/enumWithMultipleCtors.kt");
        }

        @Test
        @TestMetadata("enumWithSecondaryCtor.kt")
        public void testEnumWithSecondaryCtor() throws Exception {
            runTest("compiler/testData/ir/irText/classes/enumWithSecondaryCtor.kt");
        }

        @Test
        @TestMetadata("fakeOverridesForJavaStaticMembers.kt")
        public void testFakeOverridesForJavaStaticMembers() throws Exception {
            runTest("compiler/testData/ir/irText/classes/fakeOverridesForJavaStaticMembers.kt");
        }

        @Test
        @TestMetadata("implicitNotNullOnDelegatedImplementation.kt")
        public void testImplicitNotNullOnDelegatedImplementation() throws Exception {
            runTest("compiler/testData/ir/irText/classes/implicitNotNullOnDelegatedImplementation.kt");
        }

        @Test
        @TestMetadata("initBlock.kt")
        public void testInitBlock() throws Exception {
            runTest("compiler/testData/ir/irText/classes/initBlock.kt");
        }

        @Test
        @TestMetadata("initVal.kt")
        public void testInitVal() throws Exception {
            runTest("compiler/testData/ir/irText/classes/initVal.kt");
        }

        @Test
        @TestMetadata("initValInLambda.kt")
        public void testInitValInLambda() throws Exception {
            runTest("compiler/testData/ir/irText/classes/initValInLambda.kt");
        }

        @Test
        @TestMetadata("initVar.kt")
        public void testInitVar() throws Exception {
            runTest("compiler/testData/ir/irText/classes/initVar.kt");
        }

        @Test
        @TestMetadata("inlineClass.kt")
        public void testInlineClass() throws Exception {
            runTest("compiler/testData/ir/irText/classes/inlineClass.kt");
        }

        @Test
        @TestMetadata("inlineClassSyntheticMethods.kt")
        public void testInlineClassSyntheticMethods() throws Exception {
            runTest("compiler/testData/ir/irText/classes/inlineClassSyntheticMethods.kt");
        }

        @Test
        @TestMetadata("innerClass.kt")
        public void testInnerClass() throws Exception {
            runTest("compiler/testData/ir/irText/classes/innerClass.kt");
        }

        @Test
        @TestMetadata("innerClassWithDelegatingConstructor.kt")
        public void testInnerClassWithDelegatingConstructor() throws Exception {
            runTest("compiler/testData/ir/irText/classes/innerClassWithDelegatingConstructor.kt");
        }

        @Test
        @TestMetadata("kt19306.kt")
        public void testKt19306() throws Exception {
            runTest("compiler/testData/ir/irText/classes/kt19306.kt");
        }

        @Test
        @TestMetadata("kt43217.kt")
        public void testKt43217() throws Exception {
            runTest("compiler/testData/ir/irText/classes/kt43217.kt");
        }

        @Test
        @TestMetadata("kt44013.kt")
        public void testKt44013() throws Exception {
            runTest("compiler/testData/ir/irText/classes/kt44013.kt");
        }

        @Test
        @TestMetadata("kt45853.kt")
        public void testKt45853() throws Exception {
            runTest("compiler/testData/ir/irText/classes/kt45853.kt");
        }

        @Test
        @TestMetadata("kt45934.kt")
        public void testKt45934() throws Exception {
            runTest("compiler/testData/ir/irText/classes/kt45934.kt");
        }

        @Test
        @TestMetadata("localClasses.kt")
        public void testLocalClasses() throws Exception {
            runTest("compiler/testData/ir/irText/classes/localClasses.kt");
        }

        @Test
        @TestMetadata("objectLiteralExpressions.kt")
        public void testObjectLiteralExpressions() throws Exception {
            runTest("compiler/testData/ir/irText/classes/objectLiteralExpressions.kt");
        }

        @Test
        @TestMetadata("objectWithInitializers.kt")
        public void testObjectWithInitializers() throws Exception {
            runTest("compiler/testData/ir/irText/classes/objectWithInitializers.kt");
        }

        @Test
        @TestMetadata("outerClassAccess.kt")
        public void testOuterClassAccess() throws Exception {
            runTest("compiler/testData/ir/irText/classes/outerClassAccess.kt");
        }

        @Test
        @TestMetadata("primaryConstructor.kt")
        public void testPrimaryConstructor() throws Exception {
            runTest("compiler/testData/ir/irText/classes/primaryConstructor.kt");
        }

        @Test
        @TestMetadata("primaryConstructorWithSuperConstructorCall.kt")
        public void testPrimaryConstructorWithSuperConstructorCall() throws Exception {
            runTest("compiler/testData/ir/irText/classes/primaryConstructorWithSuperConstructorCall.kt");
        }

        @Test
        @TestMetadata("qualifiedSuperCalls.kt")
        public void testQualifiedSuperCalls() throws Exception {
            runTest("compiler/testData/ir/irText/classes/qualifiedSuperCalls.kt");
        }

        @Test
        @TestMetadata("sealedClasses.kt")
        public void testSealedClasses() throws Exception {
            runTest("compiler/testData/ir/irText/classes/sealedClasses.kt");
        }

        @Test
        @TestMetadata("secondaryConstructorWithInitializersFromClassBody.kt")
        public void testSecondaryConstructorWithInitializersFromClassBody() throws Exception {
            runTest("compiler/testData/ir/irText/classes/secondaryConstructorWithInitializersFromClassBody.kt");
        }

        @Test
        @TestMetadata("secondaryConstructors.kt")
        public void testSecondaryConstructors() throws Exception {
            runTest("compiler/testData/ir/irText/classes/secondaryConstructors.kt");
        }

        @Test
        @TestMetadata("superCalls.kt")
        public void testSuperCalls() throws Exception {
            runTest("compiler/testData/ir/irText/classes/superCalls.kt");
        }

        @Test
        @TestMetadata("superCallsComposed.kt")
        public void testSuperCallsComposed() throws Exception {
            runTest("compiler/testData/ir/irText/classes/superCallsComposed.kt");
        }

        @Nested
        @TestMetadata("compiler/testData/ir/irText/classes/dataClasses")
        @TestDataPath("$PROJECT_ROOT")
        public class DataClasses {
            @Test
            public void testAllFilesPresentInDataClasses() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/classes/dataClasses"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("dataClassWithArrayMembers.kt")
            public void testDataClassWithArrayMembers() throws Exception {
                runTest("compiler/testData/ir/irText/classes/dataClasses/dataClassWithArrayMembers.kt");
            }

            @Test
            @TestMetadata("dataClasses.kt")
            public void testDataClasses() throws Exception {
                runTest("compiler/testData/ir/irText/classes/dataClasses/dataClasses.kt");
            }

            @Test
            @TestMetadata("dataClassesGeneric.kt")
            public void testDataClassesGeneric() throws Exception {
                runTest("compiler/testData/ir/irText/classes/dataClasses/dataClassesGeneric.kt");
            }

            @Test
            @TestMetadata("kt31649.kt")
            public void testKt31649() throws Exception {
                runTest("compiler/testData/ir/irText/classes/dataClasses/kt31649.kt");
            }

            @Test
            @TestMetadata("kt49936.kt")
            public void testKt49936() throws Exception {
                runTest("compiler/testData/ir/irText/classes/dataClasses/kt49936.kt");
            }

            @Test
            @TestMetadata("lambdaInDataClassDefaultParameter.kt")
            public void testLambdaInDataClassDefaultParameter() throws Exception {
                runTest("compiler/testData/ir/irText/classes/dataClasses/lambdaInDataClassDefaultParameter.kt");
            }

            @Test
            @TestMetadata("openDataClass.kt")
            public void testOpenDataClass() throws Exception {
                runTest("compiler/testData/ir/irText/classes/dataClasses/openDataClass.kt");
            }
        }
    }

    @Nested
    @TestMetadata("compiler/testData/ir/irText/declarations")
    @TestDataPath("$PROJECT_ROOT")
    public class Declarations {
        @Test
        public void testAllFilesPresentInDeclarations() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/declarations"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("catchParameterInTopLevelProperty.kt")
        public void testCatchParameterInTopLevelProperty() throws Exception {
            runTest("compiler/testData/ir/irText/declarations/catchParameterInTopLevelProperty.kt");
        }

        @Test
        @TestMetadata("classLevelProperties.kt")
        public void testClassLevelProperties() throws Exception {
            runTest("compiler/testData/ir/irText/declarations/classLevelProperties.kt");
        }

        @Test
        @TestMetadata("constValInitializers.kt")
        public void testConstValInitializers() throws Exception {
            runTest("compiler/testData/ir/irText/declarations/constValInitializers.kt");
        }

        @Test
        @TestMetadata("defaultArguments.kt")
        public void testDefaultArguments() throws Exception {
            runTest("compiler/testData/ir/irText/declarations/defaultArguments.kt");
        }

        @Test
        @TestMetadata("delegatedProperties.kt")
        public void testDelegatedProperties() throws Exception {
            runTest("compiler/testData/ir/irText/declarations/delegatedProperties.kt");
        }

        @Test
        @TestMetadata("deprecatedProperty.kt")
        public void testDeprecatedProperty() throws Exception {
            runTest("compiler/testData/ir/irText/declarations/deprecatedProperty.kt");
        }

        @Test
        @TestMetadata("extensionProperties.kt")
        public void testExtensionProperties() throws Exception {
            runTest("compiler/testData/ir/irText/declarations/extensionProperties.kt");
        }

        @Test
        @TestMetadata("fakeOverrides.kt")
        public void testFakeOverrides() throws Exception {
            runTest("compiler/testData/ir/irText/declarations/fakeOverrides.kt");
        }

        @Test
        @TestMetadata("fileWithAnnotations.kt")
        public void testFileWithAnnotations() throws Exception {
            runTest("compiler/testData/ir/irText/declarations/fileWithAnnotations.kt");
        }

        @Test
        @TestMetadata("fileWithTypeAliasesOnly.kt")
        public void testFileWithTypeAliasesOnly() throws Exception {
            runTest("compiler/testData/ir/irText/declarations/fileWithTypeAliasesOnly.kt");
        }

        @Test
        @TestMetadata("genericDelegatedProperty.kt")
        public void testGenericDelegatedProperty() throws Exception {
            runTest("compiler/testData/ir/irText/declarations/genericDelegatedProperty.kt");
        }

        @Test
        @TestMetadata("inlineCollectionOfInlineClass.kt")
        public void testInlineCollectionOfInlineClass() throws Exception {
            runTest("compiler/testData/ir/irText/declarations/inlineCollectionOfInlineClass.kt");
        }

        @Test
        @TestMetadata("interfaceProperties.kt")
        public void testInterfaceProperties() throws Exception {
            runTest("compiler/testData/ir/irText/declarations/interfaceProperties.kt");
        }

        @Test
        @TestMetadata("kt27005.kt")
        public void testKt27005() throws Exception {
            runTest("compiler/testData/ir/irText/declarations/kt27005.kt");
        }

        @Test
        @TestMetadata("kt29833.kt")
        public void testKt29833() throws Exception {
            runTest("compiler/testData/ir/irText/declarations/kt29833.kt");
        }

        @Test
        @TestMetadata("kt35550.kt")
        public void testKt35550() throws Exception {
            runTest("compiler/testData/ir/irText/declarations/kt35550.kt");
        }

        @Test
        @TestMetadata("kt45308.kt")
        public void testKt45308() throws Exception {
            runTest("compiler/testData/ir/irText/declarations/kt45308.kt");
        }

        @Test
        @TestMetadata("kt47527.kt")
        public void testKt47527() throws Exception {
            runTest("compiler/testData/ir/irText/declarations/kt47527.kt");
        }

        @Test
        @TestMetadata("localClassWithOverrides.kt")
        public void testLocalClassWithOverrides() throws Exception {
            runTest("compiler/testData/ir/irText/declarations/localClassWithOverrides.kt");
        }

        @Test
        @TestMetadata("localDelegatedProperties.kt")
        public void testLocalDelegatedProperties() throws Exception {
            runTest("compiler/testData/ir/irText/declarations/localDelegatedProperties.kt");
        }

        @Test
        @TestMetadata("localVarInDoWhile.kt")
        public void testLocalVarInDoWhile() throws Exception {
            runTest("compiler/testData/ir/irText/declarations/localVarInDoWhile.kt");
        }

        @Test
        @TestMetadata("packageLevelProperties.kt")
        public void testPackageLevelProperties() throws Exception {
            runTest("compiler/testData/ir/irText/declarations/packageLevelProperties.kt");
        }

        @Test
        @TestMetadata("primaryCtorDefaultArguments.kt")
        public void testPrimaryCtorDefaultArguments() throws Exception {
            runTest("compiler/testData/ir/irText/declarations/primaryCtorDefaultArguments.kt");
        }

        @Test
        @TestMetadata("primaryCtorProperties.kt")
        public void testPrimaryCtorProperties() throws Exception {
            runTest("compiler/testData/ir/irText/declarations/primaryCtorProperties.kt");
        }

        @Test
        @TestMetadata("typeAlias.kt")
        public void testTypeAlias() throws Exception {
            runTest("compiler/testData/ir/irText/declarations/typeAlias.kt");
        }

        @Nested
        @TestMetadata("compiler/testData/ir/irText/declarations/annotations")
        @TestDataPath("$PROJECT_ROOT")
        public class Annotations {
            @Test
            public void testAllFilesPresentInAnnotations() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/declarations/annotations"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("annotationOnClassWithInitializer.kt")
            public void testAnnotationOnClassWithInitializer() throws Exception {
                runTest("compiler/testData/ir/irText/declarations/annotations/annotationOnClassWithInitializer.kt");
            }

            @Test
            @TestMetadata("annotationsInAnnotationArguments.kt")
            public void testAnnotationsInAnnotationArguments() throws Exception {
                runTest("compiler/testData/ir/irText/declarations/annotations/annotationsInAnnotationArguments.kt");
            }

            @Test
            @TestMetadata("annotationsOnDelegatedMembers.kt")
            public void testAnnotationsOnDelegatedMembers() throws Exception {
                runTest("compiler/testData/ir/irText/declarations/annotations/annotationsOnDelegatedMembers.kt");
            }

            @Test
            @TestMetadata("annotationsWithDefaultParameterValues.kt")
            public void testAnnotationsWithDefaultParameterValues() throws Exception {
                runTest("compiler/testData/ir/irText/declarations/annotations/annotationsWithDefaultParameterValues.kt");
            }

            @Test
            @TestMetadata("annotationsWithVarargParameters.kt")
            public void testAnnotationsWithVarargParameters() throws Exception {
                runTest("compiler/testData/ir/irText/declarations/annotations/annotationsWithVarargParameters.kt");
            }

            @Test
            @TestMetadata("arrayInAnnotationArguments.kt")
            public void testArrayInAnnotationArguments() throws Exception {
                runTest("compiler/testData/ir/irText/declarations/annotations/arrayInAnnotationArguments.kt");
            }

            @Test
            @TestMetadata("classLiteralInAnnotation.kt")
            public void testClassLiteralInAnnotation() throws Exception {
                runTest("compiler/testData/ir/irText/declarations/annotations/classLiteralInAnnotation.kt");
            }

            @Test
            @TestMetadata("classesWithAnnotations.kt")
            public void testClassesWithAnnotations() throws Exception {
                runTest("compiler/testData/ir/irText/declarations/annotations/classesWithAnnotations.kt");
            }

            @Test
            @TestMetadata("constExpressionsInAnnotationArguments.kt")
            public void testConstExpressionsInAnnotationArguments() throws Exception {
                runTest("compiler/testData/ir/irText/declarations/annotations/constExpressionsInAnnotationArguments.kt");
            }

            @Test
            @TestMetadata("constructorsWithAnnotations.kt")
            public void testConstructorsWithAnnotations() throws Exception {
                runTest("compiler/testData/ir/irText/declarations/annotations/constructorsWithAnnotations.kt");
            }

            @Test
            @TestMetadata("delegateFieldWithAnnotations.kt")
            public void testDelegateFieldWithAnnotations() throws Exception {
                runTest("compiler/testData/ir/irText/declarations/annotations/delegateFieldWithAnnotations.kt");
            }

            @Test
            @TestMetadata("delegatedPropertyAccessorsWithAnnotations.kt")
            public void testDelegatedPropertyAccessorsWithAnnotations() throws Exception {
                runTest("compiler/testData/ir/irText/declarations/annotations/delegatedPropertyAccessorsWithAnnotations.kt");
            }

            @Test
            @TestMetadata("enumEntriesWithAnnotations.kt")
            public void testEnumEntriesWithAnnotations() throws Exception {
                runTest("compiler/testData/ir/irText/declarations/annotations/enumEntriesWithAnnotations.kt");
            }

            @Test
            @TestMetadata("enumsInAnnotationArguments.kt")
            public void testEnumsInAnnotationArguments() throws Exception {
                runTest("compiler/testData/ir/irText/declarations/annotations/enumsInAnnotationArguments.kt");
            }

            @Test
            @TestMetadata("fieldsWithAnnotations.kt")
            public void testFieldsWithAnnotations() throws Exception {
                runTest("compiler/testData/ir/irText/declarations/annotations/fieldsWithAnnotations.kt");
            }

            @Test
            @TestMetadata("fileAnnotations.kt")
            public void testFileAnnotations() throws Exception {
                runTest("compiler/testData/ir/irText/declarations/annotations/fileAnnotations.kt");
            }

            @Test
            @TestMetadata("functionsWithAnnotations.kt")
            public void testFunctionsWithAnnotations() throws Exception {
                runTest("compiler/testData/ir/irText/declarations/annotations/functionsWithAnnotations.kt");
            }

            @Test
            @TestMetadata("genericAnnotationClasses.kt")
            public void testGenericAnnotationClasses() throws Exception {
                runTest("compiler/testData/ir/irText/declarations/annotations/genericAnnotationClasses.kt");
            }

            @Test
            @TestMetadata("inheritingDeprecation.kt")
            public void testInheritingDeprecation() throws Exception {
                runTest("compiler/testData/ir/irText/declarations/annotations/inheritingDeprecation.kt");
            }

            @Test
            @TestMetadata("javaAnnotation.kt")
            public void testJavaAnnotation() throws Exception {
                runTest("compiler/testData/ir/irText/declarations/annotations/javaAnnotation.kt");
            }

            @Test
            @TestMetadata("javaAnnotationWithSingleArrayArgument.kt")
            public void testJavaAnnotationWithSingleArrayArgument() throws Exception {
                runTest("compiler/testData/ir/irText/declarations/annotations/javaAnnotationWithSingleArrayArgument.kt");
            }

            @Test
            @TestMetadata("localDelegatedPropertiesWithAnnotations.kt")
            public void testLocalDelegatedPropertiesWithAnnotations() throws Exception {
                runTest("compiler/testData/ir/irText/declarations/annotations/localDelegatedPropertiesWithAnnotations.kt");
            }

            @Test
            @TestMetadata("multipleAnnotationsInSquareBrackets.kt")
            public void testMultipleAnnotationsInSquareBrackets() throws Exception {
                runTest("compiler/testData/ir/irText/declarations/annotations/multipleAnnotationsInSquareBrackets.kt");
            }

            @Test
            @TestMetadata("primaryConstructorParameterWithAnnotations.kt")
            public void testPrimaryConstructorParameterWithAnnotations() throws Exception {
                runTest("compiler/testData/ir/irText/declarations/annotations/primaryConstructorParameterWithAnnotations.kt");
            }

            @Test
            @TestMetadata("propertiesWithAnnotations.kt")
            public void testPropertiesWithAnnotations() throws Exception {
                runTest("compiler/testData/ir/irText/declarations/annotations/propertiesWithAnnotations.kt");
            }

            @Test
            @TestMetadata("propertyAccessorsFromClassHeaderWithAnnotations.kt")
            public void testPropertyAccessorsFromClassHeaderWithAnnotations() throws Exception {
                runTest("compiler/testData/ir/irText/declarations/annotations/propertyAccessorsFromClassHeaderWithAnnotations.kt");
            }

            @Test
            @TestMetadata("propertyAccessorsWithAnnotations.kt")
            public void testPropertyAccessorsWithAnnotations() throws Exception {
                runTest("compiler/testData/ir/irText/declarations/annotations/propertyAccessorsWithAnnotations.kt");
            }

            @Test
            @TestMetadata("propertySetterParameterWithAnnotations.kt")
            public void testPropertySetterParameterWithAnnotations() throws Exception {
                runTest("compiler/testData/ir/irText/declarations/annotations/propertySetterParameterWithAnnotations.kt");
            }

            @Test
            @TestMetadata("receiverParameterWithAnnotations.kt")
            public void testReceiverParameterWithAnnotations() throws Exception {
                runTest("compiler/testData/ir/irText/declarations/annotations/receiverParameterWithAnnotations.kt");
            }

            @Test
            @TestMetadata("spreadOperatorInAnnotationArguments.kt")
            public void testSpreadOperatorInAnnotationArguments() throws Exception {
                runTest("compiler/testData/ir/irText/declarations/annotations/spreadOperatorInAnnotationArguments.kt");
            }

            @Test
            @TestMetadata("typeAliasesWithAnnotations.kt")
            public void testTypeAliasesWithAnnotations() throws Exception {
                runTest("compiler/testData/ir/irText/declarations/annotations/typeAliasesWithAnnotations.kt");
            }

            @Test
            @TestMetadata("typeParametersWithAnnotations.kt")
            public void testTypeParametersWithAnnotations() throws Exception {
                runTest("compiler/testData/ir/irText/declarations/annotations/typeParametersWithAnnotations.kt");
            }

            @Test
            @TestMetadata("valueParametersWithAnnotations.kt")
            public void testValueParametersWithAnnotations() throws Exception {
                runTest("compiler/testData/ir/irText/declarations/annotations/valueParametersWithAnnotations.kt");
            }

            @Test
            @TestMetadata("varargsInAnnotationArguments.kt")
            public void testVarargsInAnnotationArguments() throws Exception {
                runTest("compiler/testData/ir/irText/declarations/annotations/varargsInAnnotationArguments.kt");
            }

            @Test
            @TestMetadata("variablesWithAnnotations.kt")
            public void testVariablesWithAnnotations() throws Exception {
                runTest("compiler/testData/ir/irText/declarations/annotations/variablesWithAnnotations.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/ir/irText/declarations/contextReceivers")
        @TestDataPath("$PROJECT_ROOT")
        public class ContextReceivers {
            @Test
            public void testAllFilesPresentInContextReceivers() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/declarations/contextReceivers"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("arrayAccessCompositeOperators.kt")
            public void testArrayAccessCompositeOperators() throws Exception {
                runTest("compiler/testData/ir/irText/declarations/contextReceivers/arrayAccessCompositeOperators.kt");
            }

            @Test
            @TestMetadata("arrayAccessOperators.kt")
            public void testArrayAccessOperators() throws Exception {
                runTest("compiler/testData/ir/irText/declarations/contextReceivers/arrayAccessOperators.kt");
            }

            @Test
            @TestMetadata("class.kt")
            public void testClass() throws Exception {
                runTest("compiler/testData/ir/irText/declarations/contextReceivers/class.kt");
            }

            @Test
            @TestMetadata("compoundAssignmentOperators.kt")
            public void testCompoundAssignmentOperators() throws Exception {
                runTest("compiler/testData/ir/irText/declarations/contextReceivers/compoundAssignmentOperators.kt");
            }

            @Test
            @TestMetadata("contextualFunctionConversion.kt")
            public void testContextualFunctionConversion() throws Exception {
                runTest("compiler/testData/ir/irText/declarations/contextReceivers/contextualFunctionConversion.kt");
            }

            @Test
            @TestMetadata("contextualInlineCall.kt")
            public void testContextualInlineCall() throws Exception {
                runTest("compiler/testData/ir/irText/declarations/contextReceivers/contextualInlineCall.kt");
            }

            @Test
            @TestMetadata("contextualPrimaryConstructorWithParams.kt")
            public void testContextualPrimaryConstructorWithParams() throws Exception {
                runTest("compiler/testData/ir/irText/declarations/contextReceivers/contextualPrimaryConstructorWithParams.kt");
            }

            @Test
            @TestMetadata("delegatedPropertiesOperators.kt")
            public void testDelegatedPropertiesOperators() throws Exception {
                runTest("compiler/testData/ir/irText/declarations/contextReceivers/delegatedPropertiesOperators.kt");
            }

            @Test
            @TestMetadata("function.kt")
            public void testFunction() throws Exception {
                runTest("compiler/testData/ir/irText/declarations/contextReceivers/function.kt");
            }

            @Test
            @TestMetadata("functionalType.kt")
            public void testFunctionalType() throws Exception {
                runTest("compiler/testData/ir/irText/declarations/contextReceivers/functionalType.kt");
            }

            @Test
            @TestMetadata("genericOuterClass.kt")
            public void testGenericOuterClass() throws Exception {
                runTest("compiler/testData/ir/irText/declarations/contextReceivers/genericOuterClass.kt");
            }

            @Test
            @TestMetadata("iteratorOperator.kt")
            public void testIteratorOperator() throws Exception {
                runTest("compiler/testData/ir/irText/declarations/contextReceivers/iteratorOperator.kt");
            }

            @Test
            @TestMetadata("lazy.kt")
            public void testLazy() throws Exception {
                runTest("compiler/testData/ir/irText/declarations/contextReceivers/lazy.kt");
            }

            @Test
            @TestMetadata("overloadPriority.kt")
            public void testOverloadPriority() throws Exception {
                runTest("compiler/testData/ir/irText/declarations/contextReceivers/overloadPriority.kt");
            }

            @Test
            @TestMetadata("overloading.kt")
            public void testOverloading() throws Exception {
                runTest("compiler/testData/ir/irText/declarations/contextReceivers/overloading.kt");
            }

            @Test
            @TestMetadata("passingLambdaToContextualParam.kt")
            public void testPassingLambdaToContextualParam() throws Exception {
                runTest("compiler/testData/ir/irText/declarations/contextReceivers/passingLambdaToContextualParam.kt");
            }

            @Test
            @TestMetadata("plusMatrix.kt")
            public void testPlusMatrix() throws Exception {
                runTest("compiler/testData/ir/irText/declarations/contextReceivers/plusMatrix.kt");
            }

            @Test
            @TestMetadata("property.kt")
            public void testProperty() throws Exception {
                runTest("compiler/testData/ir/irText/declarations/contextReceivers/property.kt");
            }

            @Test
            @TestMetadata("thisWithCustomLabel.kt")
            public void testThisWithCustomLabel() throws Exception {
                runTest("compiler/testData/ir/irText/declarations/contextReceivers/thisWithCustomLabel.kt");
            }

            @Test
            @TestMetadata("typeParameterAsContextReceiver.kt")
            public void testTypeParameterAsContextReceiver() throws Exception {
                runTest("compiler/testData/ir/irText/declarations/contextReceivers/typeParameterAsContextReceiver.kt");
            }

            @Test
            @TestMetadata("unaryOperators.kt")
            public void testUnaryOperators() throws Exception {
                runTest("compiler/testData/ir/irText/declarations/contextReceivers/unaryOperators.kt");
            }

            @Nested
            @TestMetadata("compiler/testData/ir/irText/declarations/contextReceivers/fromKEEP")
            @TestDataPath("$PROJECT_ROOT")
            public class FromKEEP {
                @Test
                public void testAllFilesPresentInFromKEEP() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/declarations/contextReceivers/fromKEEP"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
                }

                @Test
                @TestMetadata("canvas.kt")
                public void testCanvas() throws Exception {
                    runTest("compiler/testData/ir/irText/declarations/contextReceivers/fromKEEP/canvas.kt");
                }

                @Test
                @TestMetadata("compareTo.kt")
                public void testCompareTo() throws Exception {
                    runTest("compiler/testData/ir/irText/declarations/contextReceivers/fromKEEP/compareTo.kt");
                }

                @Test
                @TestMetadata("dp.kt")
                public void testDp() throws Exception {
                    runTest("compiler/testData/ir/irText/declarations/contextReceivers/fromKEEP/dp.kt");
                }

                @Test
                @TestMetadata("functionalType.kt")
                public void testFunctionalType() throws Exception {
                    runTest("compiler/testData/ir/irText/declarations/contextReceivers/fromKEEP/functionalType.kt");
                }

                @Test
                @TestMetadata("monoidSum.kt")
                public void testMonoidSum() throws Exception {
                    runTest("compiler/testData/ir/irText/declarations/contextReceivers/fromKEEP/monoidSum.kt");
                }
            }
        }

        @Nested
        @TestMetadata("compiler/testData/ir/irText/declarations/multiplatform")
        @TestDataPath("$PROJECT_ROOT")
        public class Multiplatform {
            @Test
            public void testAllFilesPresentInMultiplatform() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/declarations/multiplatform"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("expectClassInherited.kt")
            public void testExpectClassInherited() throws Exception {
                runTest("compiler/testData/ir/irText/declarations/multiplatform/expectClassInherited.kt");
            }

            @Test
            @TestMetadata("expectedEnumClass.kt")
            public void testExpectedEnumClass() throws Exception {
                runTest("compiler/testData/ir/irText/declarations/multiplatform/expectedEnumClass.kt");
            }

            @Test
            @TestMetadata("expectedSealedClass.kt")
            public void testExpectedSealedClass() throws Exception {
                runTest("compiler/testData/ir/irText/declarations/multiplatform/expectedSealedClass.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/ir/irText/declarations/parameters")
        @TestDataPath("$PROJECT_ROOT")
        public class Parameters {
            @Test
            public void testAllFilesPresentInParameters() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/declarations/parameters"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("class.kt")
            public void testClass() throws Exception {
                runTest("compiler/testData/ir/irText/declarations/parameters/class.kt");
            }

            @Test
            @TestMetadata("constructor.kt")
            public void testConstructor() throws Exception {
                runTest("compiler/testData/ir/irText/declarations/parameters/constructor.kt");
            }

            @Test
            @TestMetadata("dataClassMembers.kt")
            public void testDataClassMembers() throws Exception {
                runTest("compiler/testData/ir/irText/declarations/parameters/dataClassMembers.kt");
            }

            @Test
            @TestMetadata("defaultPropertyAccessors.kt")
            public void testDefaultPropertyAccessors() throws Exception {
                runTest("compiler/testData/ir/irText/declarations/parameters/defaultPropertyAccessors.kt");
            }

            @Test
            @TestMetadata("delegatedMembers.kt")
            public void testDelegatedMembers() throws Exception {
                runTest("compiler/testData/ir/irText/declarations/parameters/delegatedMembers.kt");
            }

            @Test
            @TestMetadata("fun.kt")
            public void testFun() throws Exception {
                runTest("compiler/testData/ir/irText/declarations/parameters/fun.kt");
            }

            @Test
            @TestMetadata("genericInnerClass.kt")
            public void testGenericInnerClass() throws Exception {
                runTest("compiler/testData/ir/irText/declarations/parameters/genericInnerClass.kt");
            }

            @Test
            @TestMetadata("lambdas.kt")
            public void testLambdas() throws Exception {
                runTest("compiler/testData/ir/irText/declarations/parameters/lambdas.kt");
            }

            @Test
            @TestMetadata("localFun.kt")
            public void testLocalFun() throws Exception {
                runTest("compiler/testData/ir/irText/declarations/parameters/localFun.kt");
            }

            @Test
            @TestMetadata("propertyAccessors.kt")
            public void testPropertyAccessors() throws Exception {
                runTest("compiler/testData/ir/irText/declarations/parameters/propertyAccessors.kt");
            }

            @Test
            @TestMetadata("typeParameterBeforeBound.kt")
            public void testTypeParameterBeforeBound() throws Exception {
                runTest("compiler/testData/ir/irText/declarations/parameters/typeParameterBeforeBound.kt");
            }

            @Test
            @TestMetadata("typeParameterBoundedBySubclass.kt")
            public void testTypeParameterBoundedBySubclass() throws Exception {
                runTest("compiler/testData/ir/irText/declarations/parameters/typeParameterBoundedBySubclass.kt");
            }

            @Test
            @TestMetadata("useNextParamInLambda.kt")
            public void testUseNextParamInLambda() throws Exception {
                runTest("compiler/testData/ir/irText/declarations/parameters/useNextParamInLambda.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/ir/irText/declarations/provideDelegate")
        @TestDataPath("$PROJECT_ROOT")
        public class ProvideDelegate {
            @Test
            public void testAllFilesPresentInProvideDelegate() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/declarations/provideDelegate"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("differentReceivers.kt")
            public void testDifferentReceivers() throws Exception {
                runTest("compiler/testData/ir/irText/declarations/provideDelegate/differentReceivers.kt");
            }

            @Test
            @TestMetadata("javaDelegate.kt")
            public void testJavaDelegate() throws Exception {
                runTest("compiler/testData/ir/irText/declarations/provideDelegate/javaDelegate.kt");
            }

            @Test
            @TestMetadata("local.kt")
            public void testLocal() throws Exception {
                runTest("compiler/testData/ir/irText/declarations/provideDelegate/local.kt");
            }

            @Test
            @TestMetadata("localDifferentReceivers.kt")
            public void testLocalDifferentReceivers() throws Exception {
                runTest("compiler/testData/ir/irText/declarations/provideDelegate/localDifferentReceivers.kt");
            }

            @Test
            @TestMetadata("member.kt")
            public void testMember() throws Exception {
                runTest("compiler/testData/ir/irText/declarations/provideDelegate/member.kt");
            }

            @Test
            @TestMetadata("memberExtension.kt")
            public void testMemberExtension() throws Exception {
                runTest("compiler/testData/ir/irText/declarations/provideDelegate/memberExtension.kt");
            }

            @Test
            @TestMetadata("topLevel.kt")
            public void testTopLevel() throws Exception {
                runTest("compiler/testData/ir/irText/declarations/provideDelegate/topLevel.kt");
            }
        }
    }

    @Nested
    @TestMetadata("compiler/testData/ir/irText/errors")
    @TestDataPath("$PROJECT_ROOT")
    public class Errors {
        @Test
        public void testAllFilesPresentInErrors() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/errors"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("suppressedNonPublicCall.kt")
        public void testSuppressedNonPublicCall() throws Exception {
            runTest("compiler/testData/ir/irText/errors/suppressedNonPublicCall.kt");
        }

        @Test
        @TestMetadata("unresolvedReference.kt")
        public void testUnresolvedReference() throws Exception {
            runTest("compiler/testData/ir/irText/errors/unresolvedReference.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/ir/irText/expressions")
    @TestDataPath("$PROJECT_ROOT")
    public class Expressions {
        @Test
        public void testAllFilesPresentInExpressions() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/expressions"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("argumentMappedWithError.kt")
        public void testArgumentMappedWithError() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/argumentMappedWithError.kt");
        }

        @Test
        @TestMetadata("arrayAccess.kt")
        public void testArrayAccess() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/arrayAccess.kt");
        }

        @Test
        @TestMetadata("arrayAssignment.kt")
        public void testArrayAssignment() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/arrayAssignment.kt");
        }

        @Test
        @TestMetadata("arrayAugmentedAssignment1.kt")
        public void testArrayAugmentedAssignment1() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/arrayAugmentedAssignment1.kt");
        }

        @Test
        @TestMetadata("arrayAugmentedAssignment2.kt")
        public void testArrayAugmentedAssignment2() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/arrayAugmentedAssignment2.kt");
        }

        @Test
        @TestMetadata("assignments.kt")
        public void testAssignments() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/assignments.kt");
        }

        @Test
        @TestMetadata("augmentedAssignment1.kt")
        public void testAugmentedAssignment1() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/augmentedAssignment1.kt");
        }

        @Test
        @TestMetadata("augmentedAssignment2.kt")
        public void testAugmentedAssignment2() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/augmentedAssignment2.kt");
        }

        @Test
        @TestMetadata("augmentedAssignmentWithExpression.kt")
        public void testAugmentedAssignmentWithExpression() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/augmentedAssignmentWithExpression.kt");
        }

        @Test
        @TestMetadata("badBreakContinue.kt")
        public void testBadBreakContinue() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/badBreakContinue.kt");
        }

        @Test
        @TestMetadata("bangbang.kt")
        public void testBangbang() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/bangbang.kt");
        }

        @Test
        @TestMetadata("booleanConstsInAndAndOrOr.kt")
        public void testBooleanConstsInAndAndOrOr() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/booleanConstsInAndAndOrOr.kt");
        }

        @Test
        @TestMetadata("booleanOperators.kt")
        public void testBooleanOperators() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/booleanOperators.kt");
        }

        @Test
        @TestMetadata("boundCallableReferences.kt")
        public void testBoundCallableReferences() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/boundCallableReferences.kt");
        }

        @Test
        @TestMetadata("boxOk.kt")
        public void testBoxOk() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/boxOk.kt");
        }

        @Test
        @TestMetadata("breakContinue.kt")
        public void testBreakContinue() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/breakContinue.kt");
        }

        @Test
        @TestMetadata("breakContinueInLoopHeader.kt")
        public void testBreakContinueInLoopHeader() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/breakContinueInLoopHeader.kt");
        }

        @Test
        @TestMetadata("breakContinueInWhen.kt")
        public void testBreakContinueInWhen() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/breakContinueInWhen.kt");
        }

        @Test
        @TestMetadata("callWithReorderedArguments.kt")
        public void testCallWithReorderedArguments() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/callWithReorderedArguments.kt");
        }

        @Test
        @TestMetadata("calls.kt")
        public void testCalls() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/calls.kt");
        }

        @Test
        @TestMetadata("castToTypeParameter.kt")
        public void testCastToTypeParameter() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/castToTypeParameter.kt");
        }

        @Test
        @TestMetadata("catchParameterAccess.kt")
        public void testCatchParameterAccess() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/catchParameterAccess.kt");
        }

        @Test
        @TestMetadata("chainOfSafeCalls.kt")
        public void testChainOfSafeCalls() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/chainOfSafeCalls.kt");
        }

        @Test
        @TestMetadata("chainedFunSuspendConversionForSimpleExpression.kt")
        public void testChainedFunSuspendConversionForSimpleExpression() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/chainedFunSuspendConversionForSimpleExpression.kt");
        }

        @Test
        @TestMetadata("classReference.kt")
        public void testClassReference() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/classReference.kt");
        }

        @Test
        @TestMetadata("coercionToUnit.kt")
        public void testCoercionToUnit() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/coercionToUnit.kt");
        }

        @Test
        @TestMetadata("complexAugmentedAssignment.kt")
        public void testComplexAugmentedAssignment() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/complexAugmentedAssignment.kt");
        }

        @Test
        @TestMetadata("constructorWithOwnTypeParametersCall.kt")
        public void testConstructorWithOwnTypeParametersCall() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/constructorWithOwnTypeParametersCall.kt");
        }

        @Test
        @TestMetadata("contructorCall.kt")
        public void testContructorCall() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/contructorCall.kt");
        }

        @Test
        @TestMetadata("conventionComparisons.kt")
        public void testConventionComparisons() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/conventionComparisons.kt");
        }

        @Test
        @TestMetadata("destructuring1.kt")
        public void testDestructuring1() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/destructuring1.kt");
        }

        @Test
        @TestMetadata("destructuringWithUnderscore.kt")
        public void testDestructuringWithUnderscore() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/destructuringWithUnderscore.kt");
        }

        @Test
        @TestMetadata("dotQualified.kt")
        public void testDotQualified() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/dotQualified.kt");
        }

        @Test
        @TestMetadata("elvis.kt")
        public void testElvis() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/elvis.kt");
        }

        @Test
        @TestMetadata("enumEntryAsReceiver.kt")
        public void testEnumEntryAsReceiver() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/enumEntryAsReceiver.kt");
        }

        @Test
        @TestMetadata("enumEntryReferenceFromEnumEntryClass.kt")
        public void testEnumEntryReferenceFromEnumEntryClass() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/enumEntryReferenceFromEnumEntryClass.kt");
        }

        @Test
        @TestMetadata("equality.kt")
        public void testEquality() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/equality.kt");
        }

        @Test
        @TestMetadata("equals.kt")
        public void testEquals() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/equals.kt");
        }

        @Test
        @TestMetadata("exclExclOnPlatformType.kt")
        public void testExclExclOnPlatformType() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/exclExclOnPlatformType.kt");
        }

        @Test
        @TestMetadata("exhaustiveWhenElseBranch.kt")
        public void testExhaustiveWhenElseBranch() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/exhaustiveWhenElseBranch.kt");
        }

        @Test
        @TestMetadata("extFunInvokeAsFun.kt")
        public void testExtFunInvokeAsFun() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/extFunInvokeAsFun.kt");
        }

        @Test
        @TestMetadata("extFunSafeInvoke.kt")
        public void testExtFunSafeInvoke() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/extFunSafeInvoke.kt");
        }

        @Test
        @TestMetadata("extensionPropertyGetterCall.kt")
        public void testExtensionPropertyGetterCall() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/extensionPropertyGetterCall.kt");
        }

        @Test
        @TestMetadata("field.kt")
        public void testField() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/field.kt");
        }

        @Test
        @TestMetadata("for.kt")
        public void testFor() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/for.kt");
        }

        @Test
        @TestMetadata("forWithBreakContinue.kt")
        public void testForWithBreakContinue() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/forWithBreakContinue.kt");
        }

        @Test
        @TestMetadata("forWithImplicitReceivers.kt")
        public void testForWithImplicitReceivers() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/forWithImplicitReceivers.kt");
        }

        @Test
        @TestMetadata("funImportedFromObject.kt")
        public void testFunImportedFromObject() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/funImportedFromObject.kt");
        }

        @Test
        @TestMetadata("funInterfaceConstructorReference.kt")
        public void testFunInterfaceConstructorReference() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/funInterfaceConstructorReference.kt");
        }

        @Test
        @TestMetadata("genericConstructorCallWithTypeArguments.kt")
        public void testGenericConstructorCallWithTypeArguments() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/genericConstructorCallWithTypeArguments.kt");
        }

        @Test
        @TestMetadata("genericPropertyCall.kt")
        public void testGenericPropertyCall() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/genericPropertyCall.kt");
        }

        @Test
        @TestMetadata("genericPropertyRef.kt")
        public void testGenericPropertyRef() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/genericPropertyRef.kt");
        }

        @Test
        @TestMetadata("identity.kt")
        public void testIdentity() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/identity.kt");
        }

        @Test
        @TestMetadata("ifElseIf.kt")
        public void testIfElseIf() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/ifElseIf.kt");
        }

        @Test
        @TestMetadata("implicitCastInReturnFromConstructor.kt")
        public void testImplicitCastInReturnFromConstructor() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/implicitCastInReturnFromConstructor.kt");
        }

        @Test
        @TestMetadata("implicitCastOnPlatformType.kt")
        public void testImplicitCastOnPlatformType() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/implicitCastOnPlatformType.kt");
        }

        @Test
        @TestMetadata("implicitCastToNonNull.kt")
        public void testImplicitCastToNonNull() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/implicitCastToNonNull.kt");
        }

        @Test
        @TestMetadata("implicitCastToTypeParameter.kt")
        public void testImplicitCastToTypeParameter() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/implicitCastToTypeParameter.kt");
        }

        @Test
        @TestMetadata("implicitNotNullInDestructuringAssignment.kt")
        public void testImplicitNotNullInDestructuringAssignment() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/implicitNotNullInDestructuringAssignment.kt");
        }

        @Test
        @TestMetadata("in.kt")
        public void testIn() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/in.kt");
        }

        @Test
        @TestMetadata("incrementDecrement.kt")
        public void testIncrementDecrement() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/incrementDecrement.kt");
        }

        @Test
        @TestMetadata("interfaceThisRef.kt")
        public void testInterfaceThisRef() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/interfaceThisRef.kt");
        }

        @Test
        @TestMetadata("javaSyntheticGenericPropretyAccess.kt")
        public void testJavaSyntheticGenericPropretyAccess() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/javaSyntheticGenericPropretyAccess.kt");
        }

        @Test
        @TestMetadata("javaSyntheticPropertyAccess.kt")
        public void testJavaSyntheticPropertyAccess() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/javaSyntheticPropertyAccess.kt");
        }

        @Test
        @TestMetadata("jvmFieldReferenceWithIntersectionTypes.kt")
        public void testJvmFieldReferenceWithIntersectionTypes() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/jvmFieldReferenceWithIntersectionTypes.kt");
        }

        @Test
        @TestMetadata("jvmInstanceFieldReference.kt")
        public void testJvmInstanceFieldReference() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/jvmInstanceFieldReference.kt");
        }

        @Test
        @TestMetadata("jvmStaticFieldReference.kt")
        public void testJvmStaticFieldReference() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/jvmStaticFieldReference.kt");
        }

        @Test
        @TestMetadata("kt16904.kt")
        public void testKt16904() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/kt16904.kt");
        }

        @Test
        @TestMetadata("kt16905.kt")
        public void testKt16905() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/kt16905.kt");
        }

        @Test
        @TestMetadata("kt23030.kt")
        public void testKt23030() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/kt23030.kt");
        }

        @Test
        @TestMetadata("kt24804.kt")
        public void testKt24804() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/kt24804.kt");
        }

        @Test
        @TestMetadata("kt27933.kt")
        public void testKt27933() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/kt27933.kt");
        }

        @Test
        @TestMetadata("kt28006.kt")
        public void testKt28006() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/kt28006.kt");
        }

        @Test
        @TestMetadata("kt28456.kt")
        public void testKt28456() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/kt28456.kt");
        }

        @Test
        @TestMetadata("kt28456a.kt")
        public void testKt28456a() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/kt28456a.kt");
        }

        @Test
        @TestMetadata("kt28456b.kt")
        public void testKt28456b() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/kt28456b.kt");
        }

        @Test
        @TestMetadata("kt30020.kt")
        public void testKt30020() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/kt30020.kt");
        }

        @Test
        @TestMetadata("kt30796.kt")
        public void testKt30796() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/kt30796.kt");
        }

        @Test
        @TestMetadata("kt35730.kt")
        public void testKt35730() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/kt35730.kt");
        }

        @Test
        @TestMetadata("kt36956.kt")
        public void testKt36956() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/kt36956.kt");
        }

        @Test
        @TestMetadata("kt36963.kt")
        public void testKt36963() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/kt36963.kt");
        }

        @Test
        @TestMetadata("kt37570.kt")
        public void testKt37570() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/kt37570.kt");
        }

        @Test
        @TestMetadata("kt37779.kt")
        public void testKt37779() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/kt37779.kt");
        }

        @Test
        @TestMetadata("kt42321.kt")
        public void testKt42321() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/kt42321.kt");
        }

        @Test
        @TestMetadata("kt44993.kt")
        public void testKt44993() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/kt44993.kt");
        }

        @Test
        @TestMetadata("kt45022.kt")
        public void testKt45022() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/kt45022.kt");
        }

        @Test
        @TestMetadata("kt47082.kt")
        public void testKt47082() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/kt47082.kt");
        }

        @Test
        @TestMetadata("kt47245.kt")
        public void testKt47245() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/kt47245.kt");
        }

        @Test
        @TestMetadata("kt47328.kt")
        public void testKt47328() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/kt47328.kt");
        }

        @Test
        @TestMetadata("kt47450.kt")
        public void testKt47450() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/kt47450.kt");
        }

        @Test
        @TestMetadata("kt48708.kt")
        public void testKt48708() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/kt48708.kt");
        }

        @Test
        @TestMetadata("kt48806.kt")
        public void testKt48806() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/kt48806.kt");
        }

        @Test
        @TestMetadata("kt49203.kt")
        public void testKt49203() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/kt49203.kt");
        }

        @Test
        @TestMetadata("kt50028.kt")
        public void testKt50028() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/kt50028.kt");
        }

        @Test
        @TestMetadata("kt51036.kt")
        public void testKt51036() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/kt51036.kt");
        }

        @Test
        @TestMetadata("lambdaInCAO.kt")
        public void testLambdaInCAO() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/lambdaInCAO.kt");
        }

        @Test
        @TestMetadata("literals.kt")
        public void testLiterals() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/literals.kt");
        }

        @Test
        @TestMetadata("memberTypeArguments.kt")
        public void testMemberTypeArguments() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/memberTypeArguments.kt");
        }

        @Test
        @TestMetadata("membersImportedFromObject.kt")
        public void testMembersImportedFromObject() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/membersImportedFromObject.kt");
        }

        @Test
        @TestMetadata("multipleSmartCasts.kt")
        public void testMultipleSmartCasts() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/multipleSmartCasts.kt");
        }

        @Test
        @TestMetadata("multipleThisReferences.kt")
        public void testMultipleThisReferences() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/multipleThisReferences.kt");
        }

        @Test
        @TestMetadata("nullCheckOnGenericLambdaReturn.kt")
        public void testNullCheckOnGenericLambdaReturn() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/nullCheckOnGenericLambdaReturn.kt");
        }

        @Test
        @TestMetadata("nullCheckOnLambdaReturn.kt")
        public void testNullCheckOnLambdaReturn() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/nullCheckOnLambdaReturn.kt");
        }

        @Test
        @TestMetadata("objectAsCallable.kt")
        public void testObjectAsCallable() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/objectAsCallable.kt");
        }

        @Test
        @TestMetadata("objectByNameInsideObject.kt")
        public void testObjectByNameInsideObject() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/objectByNameInsideObject.kt");
        }

        @Test
        @TestMetadata("objectClassReference.kt")
        public void testObjectClassReference() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/objectClassReference.kt");
        }

        @Test
        @TestMetadata("objectReference.kt")
        public void testObjectReference() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/objectReference.kt");
        }

        @Test
        @TestMetadata("objectReferenceInClosureInSuperConstructorCall.kt")
        public void testObjectReferenceInClosureInSuperConstructorCall() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/objectReferenceInClosureInSuperConstructorCall.kt");
        }

        @Test
        @TestMetadata("objectReferenceInFieldInitializer.kt")
        public void testObjectReferenceInFieldInitializer() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/objectReferenceInFieldInitializer.kt");
        }

        @Test
        @TestMetadata("outerClassInstanceReference.kt")
        public void testOuterClassInstanceReference() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/outerClassInstanceReference.kt");
        }

        @Test
        @TestMetadata("primitiveComparisons.kt")
        public void testPrimitiveComparisons() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/primitiveComparisons.kt");
        }

        @Test
        @TestMetadata("primitivesImplicitConversions.kt")
        public void testPrimitivesImplicitConversions() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/primitivesImplicitConversions.kt");
        }

        @Test
        @TestMetadata("propertyReferences.kt")
        public void testPropertyReferences() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/propertyReferences.kt");
        }

        @Test
        @TestMetadata("protectedJavaFieldRef.kt")
        public void testProtectedJavaFieldRef() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/protectedJavaFieldRef.kt");
        }

        @Test
        @TestMetadata("references.kt")
        public void testReferences() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/references.kt");
        }

        @Test
        @TestMetadata("reflectionLiterals.kt")
        public void testReflectionLiterals() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/reflectionLiterals.kt");
        }

        @Test
        @TestMetadata("safeAssignment.kt")
        public void testSafeAssignment() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/safeAssignment.kt");
        }

        @Test
        @TestMetadata("safeCallWithIncrementDecrement.kt")
        public void testSafeCallWithIncrementDecrement() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/safeCallWithIncrementDecrement.kt");
        }

        @Test
        @TestMetadata("safeCalls.kt")
        public void testSafeCalls() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/safeCalls.kt");
        }

        @Test
        @TestMetadata("setFieldWithImplicitCast.kt")
        public void testSetFieldWithImplicitCast() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/setFieldWithImplicitCast.kt");
        }

        @Test
        @TestMetadata("signedToUnsignedConversions.kt")
        public void testSignedToUnsignedConversions() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/signedToUnsignedConversions.kt");
        }

        @Test
        @TestMetadata("simpleOperators.kt")
        public void testSimpleOperators() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/simpleOperators.kt");
        }

        @Test
        @TestMetadata("simpleUnaryOperators.kt")
        public void testSimpleUnaryOperators() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/simpleUnaryOperators.kt");
        }

        @Test
        @TestMetadata("smartCasts.kt")
        public void testSmartCasts() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/smartCasts.kt");
        }

        @Test
        @TestMetadata("smartCastsWithDestructuring.kt")
        public void testSmartCastsWithDestructuring() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/smartCastsWithDestructuring.kt");
        }

        @Test
        @TestMetadata("specializedTypeAliasConstructorCall.kt")
        public void testSpecializedTypeAliasConstructorCall() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/specializedTypeAliasConstructorCall.kt");
        }

        @Test
        @TestMetadata("stringComparisons.kt")
        public void testStringComparisons() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/stringComparisons.kt");
        }

        @Test
        @TestMetadata("stringPlus.kt")
        public void testStringPlus() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/stringPlus.kt");
        }

        @Test
        @TestMetadata("stringTemplates.kt")
        public void testStringTemplates() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/stringTemplates.kt");
        }

        @Test
        @TestMetadata("suspendConversionForExtensionFunction.kt")
        public void testSuspendConversionForExtensionFunction() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/suspendConversionForExtensionFunction.kt");
        }

        @Test
        @TestMetadata("suspendConversionInVararg.kt")
        public void testSuspendConversionInVararg() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/suspendConversionInVararg.kt");
        }

        @Test
        @TestMetadata("suspendConversionOnArbitraryExpression.kt")
        public void testSuspendConversionOnArbitraryExpression() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/suspendConversionOnArbitraryExpression.kt");
        }

        @Test
        @TestMetadata("suspendConversionWithFunInterfaces.kt")
        public void testSuspendConversionWithFunInterfaces() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/suspendConversionWithFunInterfaces.kt");
        }

        @Test
        @TestMetadata("temporaryInEnumEntryInitializer.kt")
        public void testTemporaryInEnumEntryInitializer() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/temporaryInEnumEntryInitializer.kt");
        }

        @Test
        @TestMetadata("temporaryInInitBlock.kt")
        public void testTemporaryInInitBlock() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/temporaryInInitBlock.kt");
        }

        @Test
        @TestMetadata("thisOfGenericOuterClass.kt")
        public void testThisOfGenericOuterClass() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/thisOfGenericOuterClass.kt");
        }

        @Test
        @TestMetadata("thisRefToObjectInNestedClassConstructorCall.kt")
        public void testThisRefToObjectInNestedClassConstructorCall() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/thisRefToObjectInNestedClassConstructorCall.kt");
        }

        @Test
        @TestMetadata("thisReferenceBeforeClassDeclared.kt")
        public void testThisReferenceBeforeClassDeclared() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/thisReferenceBeforeClassDeclared.kt");
        }

        @Test
        @TestMetadata("throw.kt")
        public void testThrow() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/throw.kt");
        }

        @Test
        @TestMetadata("tryCatch.kt")
        public void testTryCatch() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/tryCatch.kt");
        }

        @Test
        @TestMetadata("tryCatchWithImplicitCast.kt")
        public void testTryCatchWithImplicitCast() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/tryCatchWithImplicitCast.kt");
        }

        @Test
        @TestMetadata("typeAliasConstructorReference.kt")
        public void testTypeAliasConstructorReference() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/typeAliasConstructorReference.kt");
        }

        @Test
        @TestMetadata("typeArguments.kt")
        public void testTypeArguments() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/typeArguments.kt");
        }

        @Test
        @TestMetadata("typeOperators.kt")
        public void testTypeOperators() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/typeOperators.kt");
        }

        @Test
        @TestMetadata("typeParameterClassLiteral.kt")
        public void testTypeParameterClassLiteral() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/typeParameterClassLiteral.kt");
        }

        @Test
        @TestMetadata("unsignedIntegerLiterals.kt")
        public void testUnsignedIntegerLiterals() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/unsignedIntegerLiterals.kt");
        }

        @Test
        @TestMetadata("useImportedMember.kt")
        public void testUseImportedMember() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/useImportedMember.kt");
        }

        @Test
        @TestMetadata("values.kt")
        public void testValues() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/values.kt");
        }

        @Test
        @TestMetadata("vararg.kt")
        public void testVararg() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/vararg.kt");
        }

        @Test
        @TestMetadata("varargWithImplicitCast.kt")
        public void testVarargWithImplicitCast() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/varargWithImplicitCast.kt");
        }

        @Test
        @TestMetadata("variableAsFunctionCall.kt")
        public void testVariableAsFunctionCall() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/variableAsFunctionCall.kt");
        }

        @Test
        @TestMetadata("variableAsFunctionCallWithGenerics.kt")
        public void testVariableAsFunctionCallWithGenerics() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/variableAsFunctionCallWithGenerics.kt");
        }

        @Test
        @TestMetadata("when.kt")
        public void testWhen() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/when.kt");
        }

        @Test
        @TestMetadata("whenCoercedToUnit.kt")
        public void testWhenCoercedToUnit() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/whenCoercedToUnit.kt");
        }

        @Test
        @TestMetadata("whenElse.kt")
        public void testWhenElse() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/whenElse.kt");
        }

        @Test
        @TestMetadata("whenReturn.kt")
        public void testWhenReturn() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/whenReturn.kt");
        }

        @Test
        @TestMetadata("whenReturnUnit.kt")
        public void testWhenReturnUnit() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/whenReturnUnit.kt");
        }

        @Test
        @TestMetadata("whenSmartCastToEnum.kt")
        public void testWhenSmartCastToEnum() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/whenSmartCastToEnum.kt");
        }

        @Test
        @TestMetadata("whenUnusedExpression.kt")
        public void testWhenUnusedExpression() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/whenUnusedExpression.kt");
        }

        @Test
        @TestMetadata("whenWithSubjectVariable.kt")
        public void testWhenWithSubjectVariable() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/whenWithSubjectVariable.kt");
        }

        @Test
        @TestMetadata("whileDoWhile.kt")
        public void testWhileDoWhile() throws Exception {
            runTest("compiler/testData/ir/irText/expressions/whileDoWhile.kt");
        }

        @Nested
        @TestMetadata("compiler/testData/ir/irText/expressions/callableReferences")
        @TestDataPath("$PROJECT_ROOT")
        public class CallableReferences {
            @Test
            @TestMetadata("adaptedExtensionFunctions.kt")
            public void testAdaptedExtensionFunctions() throws Exception {
                runTest("compiler/testData/ir/irText/expressions/callableReferences/adaptedExtensionFunctions.kt");
            }

            @Test
            @TestMetadata("adaptedWithCoercionToUnit.kt")
            public void testAdaptedWithCoercionToUnit() throws Exception {
                runTest("compiler/testData/ir/irText/expressions/callableReferences/adaptedWithCoercionToUnit.kt");
            }

            @Test
            public void testAllFilesPresentInCallableReferences() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/expressions/callableReferences"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("boundInlineAdaptedReference.kt")
            public void testBoundInlineAdaptedReference() throws Exception {
                runTest("compiler/testData/ir/irText/expressions/callableReferences/boundInlineAdaptedReference.kt");
            }

            @Test
            @TestMetadata("boundInnerGenericConstructor.kt")
            public void testBoundInnerGenericConstructor() throws Exception {
                runTest("compiler/testData/ir/irText/expressions/callableReferences/boundInnerGenericConstructor.kt");
            }

            @Test
            @TestMetadata("caoWithAdaptationForSam.kt")
            public void testCaoWithAdaptationForSam() throws Exception {
                runTest("compiler/testData/ir/irText/expressions/callableReferences/caoWithAdaptationForSam.kt");
            }

            @Test
            @TestMetadata("constructorWithAdaptedArguments.kt")
            public void testConstructorWithAdaptedArguments() throws Exception {
                runTest("compiler/testData/ir/irText/expressions/callableReferences/constructorWithAdaptedArguments.kt");
            }

            @Test
            @TestMetadata("funWithDefaultParametersAsKCallableStar.kt")
            public void testFunWithDefaultParametersAsKCallableStar() throws Exception {
                runTest("compiler/testData/ir/irText/expressions/callableReferences/funWithDefaultParametersAsKCallableStar.kt");
            }

            @Test
            @TestMetadata("genericLocalClassConstructorReference.kt")
            public void testGenericLocalClassConstructorReference() throws Exception {
                runTest("compiler/testData/ir/irText/expressions/callableReferences/genericLocalClassConstructorReference.kt");
            }

            @Test
            @TestMetadata("genericMember.kt")
            public void testGenericMember() throws Exception {
                runTest("compiler/testData/ir/irText/expressions/callableReferences/genericMember.kt");
            }

            @Test
            @TestMetadata("importedFromObject.kt")
            public void testImportedFromObject() throws Exception {
                runTest("compiler/testData/ir/irText/expressions/callableReferences/importedFromObject.kt");
            }

            @Test
            @TestMetadata("kt37131.kt")
            public void testKt37131() throws Exception {
                runTest("compiler/testData/ir/irText/expressions/callableReferences/kt37131.kt");
            }

            @Test
            @TestMetadata("kt46069.kt")
            public void testKt46069() throws Exception {
                runTest("compiler/testData/ir/irText/expressions/callableReferences/kt46069.kt");
            }

            @Test
            @TestMetadata("suspendConversion.kt")
            public void testSuspendConversion() throws Exception {
                runTest("compiler/testData/ir/irText/expressions/callableReferences/suspendConversion.kt");
            }

            @Test
            @TestMetadata("typeArguments.kt")
            public void testTypeArguments() throws Exception {
                runTest("compiler/testData/ir/irText/expressions/callableReferences/typeArguments.kt");
            }

            @Test
            @TestMetadata("unboundMemberReferenceWithAdaptedArguments.kt")
            public void testUnboundMemberReferenceWithAdaptedArguments() throws Exception {
                runTest("compiler/testData/ir/irText/expressions/callableReferences/unboundMemberReferenceWithAdaptedArguments.kt");
            }

            @Test
            @TestMetadata("varargFunImportedFromObject.kt")
            public void testVarargFunImportedFromObject() throws Exception {
                runTest("compiler/testData/ir/irText/expressions/callableReferences/varargFunImportedFromObject.kt");
            }

            @Test
            @TestMetadata("withAdaptationForSam.kt")
            public void testWithAdaptationForSam() throws Exception {
                runTest("compiler/testData/ir/irText/expressions/callableReferences/withAdaptationForSam.kt");
            }

            @Test
            @TestMetadata("withAdaptedArguments.kt")
            public void testWithAdaptedArguments() throws Exception {
                runTest("compiler/testData/ir/irText/expressions/callableReferences/withAdaptedArguments.kt");
            }

            @Test
            @TestMetadata("withArgumentAdaptationAndReceiver.kt")
            public void testWithArgumentAdaptationAndReceiver() throws Exception {
                runTest("compiler/testData/ir/irText/expressions/callableReferences/withArgumentAdaptationAndReceiver.kt");
            }

            @Test
            @TestMetadata("withVarargViewedAsArray.kt")
            public void testWithVarargViewedAsArray() throws Exception {
                runTest("compiler/testData/ir/irText/expressions/callableReferences/withVarargViewedAsArray.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/ir/irText/expressions/floatingPointComparisons")
        @TestDataPath("$PROJECT_ROOT")
        public class FloatingPointComparisons {
            @Test
            public void testAllFilesPresentInFloatingPointComparisons() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/expressions/floatingPointComparisons"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("comparableWithDoubleOrFloat.kt")
            public void testComparableWithDoubleOrFloat() throws Exception {
                runTest("compiler/testData/ir/irText/expressions/floatingPointComparisons/comparableWithDoubleOrFloat.kt");
            }

            @Test
            @TestMetadata("eqeqRhsConditionPossiblyAffectingLhs.kt")
            public void testEqeqRhsConditionPossiblyAffectingLhs() throws Exception {
                runTest("compiler/testData/ir/irText/expressions/floatingPointComparisons/eqeqRhsConditionPossiblyAffectingLhs.kt");
            }

            @Test
            @TestMetadata("floatingPointCompareTo.kt")
            public void testFloatingPointCompareTo() throws Exception {
                runTest("compiler/testData/ir/irText/expressions/floatingPointComparisons/floatingPointCompareTo.kt");
            }

            @Test
            @TestMetadata("floatingPointEqeq.kt")
            public void testFloatingPointEqeq() throws Exception {
                runTest("compiler/testData/ir/irText/expressions/floatingPointComparisons/floatingPointEqeq.kt");
            }

            @Test
            @TestMetadata("floatingPointEquals.kt")
            public void testFloatingPointEquals() throws Exception {
                runTest("compiler/testData/ir/irText/expressions/floatingPointComparisons/floatingPointEquals.kt");
            }

            @Test
            @TestMetadata("floatingPointExcleq.kt")
            public void testFloatingPointExcleq() throws Exception {
                runTest("compiler/testData/ir/irText/expressions/floatingPointComparisons/floatingPointExcleq.kt");
            }

            @Test
            @TestMetadata("floatingPointLess.kt")
            public void testFloatingPointLess() throws Exception {
                runTest("compiler/testData/ir/irText/expressions/floatingPointComparisons/floatingPointLess.kt");
            }

            @Test
            @TestMetadata("nullableAnyAsIntToDouble.kt")
            public void testNullableAnyAsIntToDouble() throws Exception {
                runTest("compiler/testData/ir/irText/expressions/floatingPointComparisons/nullableAnyAsIntToDouble.kt");
            }

            @Test
            @TestMetadata("nullableFloatingPointEqeq.kt")
            public void testNullableFloatingPointEqeq() throws Exception {
                runTest("compiler/testData/ir/irText/expressions/floatingPointComparisons/nullableFloatingPointEqeq.kt");
            }

            @Test
            @TestMetadata("typeParameterWithPrimitiveNumericSupertype.kt")
            public void testTypeParameterWithPrimitiveNumericSupertype() throws Exception {
                runTest("compiler/testData/ir/irText/expressions/floatingPointComparisons/typeParameterWithPrimitiveNumericSupertype.kt");
            }

            @Test
            @TestMetadata("whenByFloatingPoint.kt")
            public void testWhenByFloatingPoint() throws Exception {
                runTest("compiler/testData/ir/irText/expressions/floatingPointComparisons/whenByFloatingPoint.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/ir/irText/expressions/funInterface")
        @TestDataPath("$PROJECT_ROOT")
        public class FunInterface {
            @Test
            public void testAllFilesPresentInFunInterface() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/expressions/funInterface"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("arrayAsVarargAfterSamArgument_fi.kt")
            public void testArrayAsVarargAfterSamArgument_fi() throws Exception {
                runTest("compiler/testData/ir/irText/expressions/funInterface/arrayAsVarargAfterSamArgument_fi.kt");
            }

            @Test
            @TestMetadata("basicFunInterfaceConversion.kt")
            public void testBasicFunInterfaceConversion() throws Exception {
                runTest("compiler/testData/ir/irText/expressions/funInterface/basicFunInterfaceConversion.kt");
            }

            @Test
            @TestMetadata("castFromAny.kt")
            public void testCastFromAny() throws Exception {
                runTest("compiler/testData/ir/irText/expressions/funInterface/castFromAny.kt");
            }

            @Test
            @TestMetadata("functionSupertype.kt")
            public void testFunctionSupertype() throws Exception {
                runTest("compiler/testData/ir/irText/expressions/funInterface/functionSupertype.kt");
            }

            @Test
            @TestMetadata("partialSam.kt")
            public void testPartialSam() throws Exception {
                runTest("compiler/testData/ir/irText/expressions/funInterface/partialSam.kt");
            }

            @Test
            @TestMetadata("samConversionInVarargs.kt")
            public void testSamConversionInVarargs() throws Exception {
                runTest("compiler/testData/ir/irText/expressions/funInterface/samConversionInVarargs.kt");
            }

            @Test
            @TestMetadata("samConversionInVarargsMixed.kt")
            public void testSamConversionInVarargsMixed() throws Exception {
                runTest("compiler/testData/ir/irText/expressions/funInterface/samConversionInVarargsMixed.kt");
            }

            @Test
            @TestMetadata("samConversionOnCallableReference.kt")
            public void testSamConversionOnCallableReference() throws Exception {
                runTest("compiler/testData/ir/irText/expressions/funInterface/samConversionOnCallableReference.kt");
            }

            @Test
            @TestMetadata("samConversionsWithSmartCasts.kt")
            public void testSamConversionsWithSmartCasts() throws Exception {
                runTest("compiler/testData/ir/irText/expressions/funInterface/samConversionsWithSmartCasts.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/ir/irText/expressions/sam")
        @TestDataPath("$PROJECT_ROOT")
        public class Sam {
            @Test
            public void testAllFilesPresentInSam() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/expressions/sam"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("arrayAsVarargAfterSamArgument.kt")
            public void testArrayAsVarargAfterSamArgument() throws Exception {
                runTest("compiler/testData/ir/irText/expressions/sam/arrayAsVarargAfterSamArgument.kt");
            }

            @Test
            @TestMetadata("genericSamProjectedOut.kt")
            public void testGenericSamProjectedOut() throws Exception {
                runTest("compiler/testData/ir/irText/expressions/sam/genericSamProjectedOut.kt");
            }

            @Test
            @TestMetadata("genericSamSmartcast.kt")
            public void testGenericSamSmartcast() throws Exception {
                runTest("compiler/testData/ir/irText/expressions/sam/genericSamSmartcast.kt");
            }

            @Test
            @TestMetadata("samByProjectedType.kt")
            public void testSamByProjectedType() throws Exception {
                runTest("compiler/testData/ir/irText/expressions/sam/samByProjectedType.kt");
            }

            @Test
            @TestMetadata("samConstructors.kt")
            public void testSamConstructors() throws Exception {
                runTest("compiler/testData/ir/irText/expressions/sam/samConstructors.kt");
            }

            @Test
            @TestMetadata("samConversionInGenericConstructorCall.kt")
            public void testSamConversionInGenericConstructorCall() throws Exception {
                runTest("compiler/testData/ir/irText/expressions/sam/samConversionInGenericConstructorCall.kt");
            }

            @Test
            @TestMetadata("samConversionToGeneric.kt")
            public void testSamConversionToGeneric() throws Exception {
                runTest("compiler/testData/ir/irText/expressions/sam/samConversionToGeneric.kt");
            }

            @Test
            @TestMetadata("samConversions.kt")
            public void testSamConversions() throws Exception {
                runTest("compiler/testData/ir/irText/expressions/sam/samConversions.kt");
            }

            @Test
            @TestMetadata("samConversionsWithSmartCasts.kt")
            public void testSamConversionsWithSmartCasts() throws Exception {
                runTest("compiler/testData/ir/irText/expressions/sam/samConversionsWithSmartCasts.kt");
            }

            @Test
            @TestMetadata("samOperators.kt")
            public void testSamOperators() throws Exception {
                runTest("compiler/testData/ir/irText/expressions/sam/samOperators.kt");
            }
        }
    }

    @Nested
    @TestMetadata("compiler/testData/ir/irText/firProblems")
    @TestDataPath("$PROJECT_ROOT")
    public class FirProblems {
        @Test
        @TestMetadata("AbstractMutableMap.kt")
        public void testAbstractMutableMap() throws Exception {
            runTest("compiler/testData/ir/irText/firProblems/AbstractMutableMap.kt");
        }

        @Test
        @TestMetadata("AllCandidates.kt")
        public void testAllCandidates() throws Exception {
            runTest("compiler/testData/ir/irText/firProblems/AllCandidates.kt");
        }

        @Test
        public void testAllFilesPresentInFirProblems() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/firProblems"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("AnnotationInAnnotation.kt")
        public void testAnnotationInAnnotation() throws Exception {
            runTest("compiler/testData/ir/irText/firProblems/AnnotationInAnnotation.kt");
        }

        @Test
        @TestMetadata("AnnotationLoader.kt")
        public void testAnnotationLoader() throws Exception {
            runTest("compiler/testData/ir/irText/firProblems/AnnotationLoader.kt");
        }

        @Test
        @TestMetadata("ArrayListOverrides.kt")
        public void testArrayListOverrides() throws Exception {
            runTest("compiler/testData/ir/irText/firProblems/ArrayListOverrides.kt");
        }

        @Test
        @TestMetadata("ArrayMap.kt")
        public void testArrayMap() throws Exception {
            runTest("compiler/testData/ir/irText/firProblems/ArrayMap.kt");
        }

        @Test
        @TestMetadata("candidateSymbol.kt")
        public void testCandidateSymbol() throws Exception {
            runTest("compiler/testData/ir/irText/firProblems/candidateSymbol.kt");
        }

        @Test
        @TestMetadata("ClashResolutionDescriptor.kt")
        public void testClashResolutionDescriptor() throws Exception {
            runTest("compiler/testData/ir/irText/firProblems/ClashResolutionDescriptor.kt");
        }

        @Test
        @TestMetadata("coercionToUnitForNestedWhen.kt")
        public void testCoercionToUnitForNestedWhen() throws Exception {
            runTest("compiler/testData/ir/irText/firProblems/coercionToUnitForNestedWhen.kt");
        }

        @Test
        @TestMetadata("DeepCopyIrTree.kt")
        public void testDeepCopyIrTree() throws Exception {
            runTest("compiler/testData/ir/irText/firProblems/DeepCopyIrTree.kt");
        }

        @Test
        @TestMetadata("DelegationAndInheritanceFromJava.kt")
        public void testDelegationAndInheritanceFromJava() throws Exception {
            runTest("compiler/testData/ir/irText/firProblems/DelegationAndInheritanceFromJava.kt");
        }

        @Test
        @TestMetadata("deprecated.kt")
        public void testDeprecated() throws Exception {
            runTest("compiler/testData/ir/irText/firProblems/deprecated.kt");
        }

        @Test
        @TestMetadata("Fir2IrClassifierStorage.kt")
        public void testFir2IrClassifierStorage() throws Exception {
            runTest("compiler/testData/ir/irText/firProblems/Fir2IrClassifierStorage.kt");
        }

        @Test
        @TestMetadata("FirBuilder.kt")
        public void testFirBuilder() throws Exception {
            runTest("compiler/testData/ir/irText/firProblems/FirBuilder.kt");
        }

        @Test
        @TestMetadata("FlushFromAnonymous.kt")
        public void testFlushFromAnonymous() throws Exception {
            runTest("compiler/testData/ir/irText/firProblems/FlushFromAnonymous.kt");
        }

        @Test
        @TestMetadata("functionLiteralGenericSignature.kt")
        public void testFunctionLiteralGenericSignature() throws Exception {
            runTest("compiler/testData/ir/irText/firProblems/functionLiteralGenericSignature.kt");
        }

        @Test
        @TestMetadata("ImplicitReceiverStack.kt")
        public void testImplicitReceiverStack() throws Exception {
            runTest("compiler/testData/ir/irText/firProblems/ImplicitReceiverStack.kt");
        }

        @Test
        @TestMetadata("inapplicableCollectionSet.kt")
        public void testInapplicableCollectionSet() throws Exception {
            runTest("compiler/testData/ir/irText/firProblems/inapplicableCollectionSet.kt");
        }

        @Test
        @TestMetadata("InnerClassInAnonymous.kt")
        public void testInnerClassInAnonymous() throws Exception {
            runTest("compiler/testData/ir/irText/firProblems/InnerClassInAnonymous.kt");
        }

        @Test
        @TestMetadata("JCTree.kt")
        public void testJCTree() throws Exception {
            runTest("compiler/testData/ir/irText/firProblems/JCTree.kt");
        }

        @Test
        @TestMetadata("kt19251.kt")
        public void testKt19251() throws Exception {
            runTest("compiler/testData/ir/irText/firProblems/kt19251.kt");
        }

        @Test
        @TestMetadata("kt43342.kt")
        public void testKt43342() throws Exception {
            runTest("compiler/testData/ir/irText/firProblems/kt43342.kt");
        }

        @Test
        @TestMetadata("lambdaInEnumEntryConstructorCall.kt")
        public void testLambdaInEnumEntryConstructorCall() throws Exception {
            runTest("compiler/testData/ir/irText/firProblems/lambdaInEnumEntryConstructorCall.kt");
        }

        @Test
        @TestMetadata("localClassUsedBeforeDeclaration.kt")
        public void testLocalClassUsedBeforeDeclaration() throws Exception {
            runTest("compiler/testData/ir/irText/firProblems/localClassUsedBeforeDeclaration.kt");
        }

        @Test
        @TestMetadata("Modality.kt")
        public void testModality() throws Exception {
            runTest("compiler/testData/ir/irText/firProblems/Modality.kt");
        }

        @Test
        @TestMetadata("MultiList.kt")
        public void testMultiList() throws Exception {
            runTest("compiler/testData/ir/irText/firProblems/MultiList.kt");
        }

        @Test
        @TestMetadata("putIfAbsent.kt")
        public void testPutIfAbsent() throws Exception {
            runTest("compiler/testData/ir/irText/firProblems/putIfAbsent.kt");
        }

        @Test
        @TestMetadata("readWriteProperty.kt")
        public void testReadWriteProperty() throws Exception {
            runTest("compiler/testData/ir/irText/firProblems/readWriteProperty.kt");
        }

        @Test
        @TestMetadata("recursiveCapturedTypeInPropertyReference.kt")
        public void testRecursiveCapturedTypeInPropertyReference() throws Exception {
            runTest("compiler/testData/ir/irText/firProblems/recursiveCapturedTypeInPropertyReference.kt");
        }

        @Test
        @TestMetadata("SafeLetWithReturn.kt")
        public void testSafeLetWithReturn() throws Exception {
            runTest("compiler/testData/ir/irText/firProblems/SafeLetWithReturn.kt");
        }

        @Test
        @TestMetadata("SameJavaFieldReferences.kt")
        public void testSameJavaFieldReferences() throws Exception {
            runTest("compiler/testData/ir/irText/firProblems/SameJavaFieldReferences.kt");
        }

        @Test
        @TestMetadata("SignatureClash.kt")
        public void testSignatureClash() throws Exception {
            runTest("compiler/testData/ir/irText/firProblems/SignatureClash.kt");
        }

        @Test
        @TestMetadata("SimpleTypeMarker.kt")
        public void testSimpleTypeMarker() throws Exception {
            runTest("compiler/testData/ir/irText/firProblems/SimpleTypeMarker.kt");
        }

        @Test
        @TestMetadata("SyntheticSetterType.kt")
        public void testSyntheticSetterType() throws Exception {
            runTest("compiler/testData/ir/irText/firProblems/SyntheticSetterType.kt");
        }

        @Test
        @TestMetadata("throwableStackTrace.kt")
        public void testThrowableStackTrace() throws Exception {
            runTest("compiler/testData/ir/irText/firProblems/throwableStackTrace.kt");
        }

        @Test
        @TestMetadata("TypeParameterBounds.kt")
        public void testTypeParameterBounds() throws Exception {
            runTest("compiler/testData/ir/irText/firProblems/TypeParameterBounds.kt");
        }

        @Test
        @TestMetadata("typeParameterFromJavaClass.kt")
        public void testTypeParameterFromJavaClass() throws Exception {
            runTest("compiler/testData/ir/irText/firProblems/typeParameterFromJavaClass.kt");
        }

        @Test
        @TestMetadata("typeVariableAfterBuildMap.kt")
        public void testTypeVariableAfterBuildMap() throws Exception {
            runTest("compiler/testData/ir/irText/firProblems/typeVariableAfterBuildMap.kt");
        }

        @Test
        @TestMetadata("V8ArrayToList.kt")
        public void testV8ArrayToList() throws Exception {
            runTest("compiler/testData/ir/irText/firProblems/V8ArrayToList.kt");
        }

        @Test
        @TestMetadata("VarInInit.kt")
        public void testVarInInit() throws Exception {
            runTest("compiler/testData/ir/irText/firProblems/VarInInit.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/ir/irText/lambdas")
    @TestDataPath("$PROJECT_ROOT")
    public class Lambdas {
        @Test
        public void testAllFilesPresentInLambdas() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/lambdas"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("anonymousFunction.kt")
        public void testAnonymousFunction() throws Exception {
            runTest("compiler/testData/ir/irText/lambdas/anonymousFunction.kt");
        }

        @Test
        @TestMetadata("destructuringInLambda.kt")
        public void testDestructuringInLambda() throws Exception {
            runTest("compiler/testData/ir/irText/lambdas/destructuringInLambda.kt");
        }

        @Test
        @TestMetadata("extensionLambda.kt")
        public void testExtensionLambda() throws Exception {
            runTest("compiler/testData/ir/irText/lambdas/extensionLambda.kt");
        }

        @Test
        @TestMetadata("justLambda.kt")
        public void testJustLambda() throws Exception {
            runTest("compiler/testData/ir/irText/lambdas/justLambda.kt");
        }

        @Test
        @TestMetadata("lambdaReturningUnit.kt")
        public void testLambdaReturningUnit() throws Exception {
            runTest("compiler/testData/ir/irText/lambdas/lambdaReturningUnit.kt");
        }

        @Test
        @TestMetadata("localFunction.kt")
        public void testLocalFunction() throws Exception {
            runTest("compiler/testData/ir/irText/lambdas/localFunction.kt");
        }

        @Test
        @TestMetadata("multipleImplicitReceivers.kt")
        public void testMultipleImplicitReceivers() throws Exception {
            runTest("compiler/testData/ir/irText/lambdas/multipleImplicitReceivers.kt");
        }

        @Test
        @TestMetadata("nonLocalReturn.kt")
        public void testNonLocalReturn() throws Exception {
            runTest("compiler/testData/ir/irText/lambdas/nonLocalReturn.kt");
        }

        @Test
        @TestMetadata("samAdapter.kt")
        public void testSamAdapter() throws Exception {
            runTest("compiler/testData/ir/irText/lambdas/samAdapter.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/ir/irText/regressions")
    @TestDataPath("$PROJECT_ROOT")
    public class Regressions {
        @Test
        public void testAllFilesPresentInRegressions() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/regressions"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("coercionInLoop.kt")
        public void testCoercionInLoop() throws Exception {
            runTest("compiler/testData/ir/irText/regressions/coercionInLoop.kt");
        }

        @Test
        @TestMetadata("integerCoercionToT.kt")
        public void testIntegerCoercionToT() throws Exception {
            runTest("compiler/testData/ir/irText/regressions/integerCoercionToT.kt");
        }

        @Test
        @TestMetadata("kt24114.kt")
        public void testKt24114() throws Exception {
            runTest("compiler/testData/ir/irText/regressions/kt24114.kt");
        }

        @Test
        @TestMetadata("kt44855.kt")
        public void testKt44855() throws Exception {
            runTest("compiler/testData/ir/irText/regressions/kt44855.kt");
        }

        @Test
        @TestMetadata("kt45236.kt")
        public void testKt45236() throws Exception {
            runTest("compiler/testData/ir/irText/regressions/kt45236.kt");
        }

        @Test
        @TestMetadata("newInferenceFixationOrder1.kt")
        public void testNewInferenceFixationOrder1() throws Exception {
            runTest("compiler/testData/ir/irText/regressions/newInferenceFixationOrder1.kt");
        }

        @Test
        @TestMetadata("typeAliasCtorForGenericClass.kt")
        public void testTypeAliasCtorForGenericClass() throws Exception {
            runTest("compiler/testData/ir/irText/regressions/typeAliasCtorForGenericClass.kt");
        }

        @Test
        @TestMetadata("typeParametersInImplicitCast.kt")
        public void testTypeParametersInImplicitCast() throws Exception {
            runTest("compiler/testData/ir/irText/regressions/typeParametersInImplicitCast.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/ir/irText/singletons")
    @TestDataPath("$PROJECT_ROOT")
    public class Singletons {
        @Test
        public void testAllFilesPresentInSingletons() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/singletons"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("companion.kt")
        public void testCompanion() throws Exception {
            runTest("compiler/testData/ir/irText/singletons/companion.kt");
        }

        @Test
        @TestMetadata("enumEntry.kt")
        public void testEnumEntry() throws Exception {
            runTest("compiler/testData/ir/irText/singletons/enumEntry.kt");
        }

        @Test
        @TestMetadata("object.kt")
        public void testObject() throws Exception {
            runTest("compiler/testData/ir/irText/singletons/object.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/ir/irText/stubs")
    @TestDataPath("$PROJECT_ROOT")
    public class Stubs {
        @Test
        public void testAllFilesPresentInStubs() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/stubs"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("builtinMap.kt")
        public void testBuiltinMap() throws Exception {
            runTest("compiler/testData/ir/irText/stubs/builtinMap.kt");
        }

        @Test
        @TestMetadata("constFromBuiltins.kt")
        public void testConstFromBuiltins() throws Exception {
            runTest("compiler/testData/ir/irText/stubs/constFromBuiltins.kt");
        }

        @Test
        @TestMetadata("genericClassInDifferentModule.kt")
        public void testGenericClassInDifferentModule() throws Exception {
            runTest("compiler/testData/ir/irText/stubs/genericClassInDifferentModule.kt");
        }

        @Test
        @TestMetadata("javaConstructorWithTypeParameters.kt")
        public void testJavaConstructorWithTypeParameters() throws Exception {
            runTest("compiler/testData/ir/irText/stubs/javaConstructorWithTypeParameters.kt");
        }

        @Test
        @TestMetadata("javaEnum.kt")
        public void testJavaEnum() throws Exception {
            runTest("compiler/testData/ir/irText/stubs/javaEnum.kt");
        }

        @Test
        @TestMetadata("javaInnerClass.kt")
        public void testJavaInnerClass() throws Exception {
            runTest("compiler/testData/ir/irText/stubs/javaInnerClass.kt");
        }

        @Test
        @TestMetadata("javaMethod.kt")
        public void testJavaMethod() throws Exception {
            runTest("compiler/testData/ir/irText/stubs/javaMethod.kt");
        }

        @Test
        @TestMetadata("javaNestedClass.kt")
        public void testJavaNestedClass() throws Exception {
            runTest("compiler/testData/ir/irText/stubs/javaNestedClass.kt");
        }

        @Test
        @TestMetadata("javaStaticMethod.kt")
        public void testJavaStaticMethod() throws Exception {
            runTest("compiler/testData/ir/irText/stubs/javaStaticMethod.kt");
        }

        @Test
        @TestMetadata("javaSyntheticProperty.kt")
        public void testJavaSyntheticProperty() throws Exception {
            runTest("compiler/testData/ir/irText/stubs/javaSyntheticProperty.kt");
        }

        @Test
        @TestMetadata("jdkClassSyntheticProperty.kt")
        public void testJdkClassSyntheticProperty() throws Exception {
            runTest("compiler/testData/ir/irText/stubs/jdkClassSyntheticProperty.kt");
        }

        @Test
        @TestMetadata("kotlinInnerClass.kt")
        public void testKotlinInnerClass() throws Exception {
            runTest("compiler/testData/ir/irText/stubs/kotlinInnerClass.kt");
        }

        @Test
        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("compiler/testData/ir/irText/stubs/simple.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/ir/irText/types")
    @TestDataPath("$PROJECT_ROOT")
    public class Types {
        @Test
        @TestMetadata("abbreviatedTypes.kt")
        public void testAbbreviatedTypes() throws Exception {
            runTest("compiler/testData/ir/irText/types/abbreviatedTypes.kt");
        }

        @Test
        public void testAllFilesPresentInTypes() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/types"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("asOnPlatformType.kt")
        public void testAsOnPlatformType() throws Exception {
            runTest("compiler/testData/ir/irText/types/asOnPlatformType.kt");
        }

        @Test
        @TestMetadata("castsInsideCoroutineInference.kt")
        public void testCastsInsideCoroutineInference() throws Exception {
            runTest("compiler/testData/ir/irText/types/castsInsideCoroutineInference.kt");
        }

        @Test
        @TestMetadata("coercionToUnitInLambdaReturnValue.kt")
        public void testCoercionToUnitInLambdaReturnValue() throws Exception {
            runTest("compiler/testData/ir/irText/types/coercionToUnitInLambdaReturnValue.kt");
        }

        @Test
        @TestMetadata("definitelyNonNull.kt")
        public void testDefinitelyNonNull() throws Exception {
            runTest("compiler/testData/ir/irText/types/definitelyNonNull.kt");
        }

        @Test
        @TestMetadata("definitelyNonNullOverride.kt")
        public void testDefinitelyNonNullOverride() throws Exception {
            runTest("compiler/testData/ir/irText/types/definitelyNonNullOverride.kt");
        }

        @Test
        @TestMetadata("definitelyNonNullSAM.kt")
        public void testDefinitelyNonNullSAM() throws Exception {
            runTest("compiler/testData/ir/irText/types/definitelyNonNullSAM.kt");
        }

        @Test
        @TestMetadata("definitelyNonNullWithJava.kt")
        public void testDefinitelyNonNullWithJava() throws Exception {
            runTest("compiler/testData/ir/irText/types/definitelyNonNullWithJava.kt");
        }

        @Test
        @TestMetadata("definitelyNotNullAsArgument.kt")
        public void testDefinitelyNotNullAsArgument() throws Exception {
            runTest("compiler/testData/ir/irText/types/definitelyNotNullAsArgument.kt");
        }

        @Test
        @TestMetadata("definitelyNotNullAsReceiver.kt")
        public void testDefinitelyNotNullAsReceiver() throws Exception {
            runTest("compiler/testData/ir/irText/types/definitelyNotNullAsReceiver.kt");
        }

        @Test
        @TestMetadata("definitelyNotNullWithIntersection1.kt")
        public void testDefinitelyNotNullWithIntersection1() throws Exception {
            runTest("compiler/testData/ir/irText/types/definitelyNotNullWithIntersection1.kt");
        }

        @Test
        @TestMetadata("genericDelegatedDeepProperty.kt")
        public void testGenericDelegatedDeepProperty() throws Exception {
            runTest("compiler/testData/ir/irText/types/genericDelegatedDeepProperty.kt");
        }

        @Test
        @TestMetadata("genericFunWithStar.kt")
        public void testGenericFunWithStar() throws Exception {
            runTest("compiler/testData/ir/irText/types/genericFunWithStar.kt");
        }

        @Test
        @TestMetadata("genericPropertyReferenceType.kt")
        public void testGenericPropertyReferenceType() throws Exception {
            runTest("compiler/testData/ir/irText/types/genericPropertyReferenceType.kt");
        }

        @Test
        @TestMetadata("inStarProjectionInReceiverType.kt")
        public void testInStarProjectionInReceiverType() throws Exception {
            runTest("compiler/testData/ir/irText/types/inStarProjectionInReceiverType.kt");
        }

        @Test
        @TestMetadata("intersectionType1.kt")
        public void testIntersectionType1() throws Exception {
            runTest("compiler/testData/ir/irText/types/intersectionType1.kt");
        }

        @Test
        @TestMetadata("intersectionType2.kt")
        public void testIntersectionType2() throws Exception {
            runTest("compiler/testData/ir/irText/types/intersectionType2.kt");
        }

        @Test
        @TestMetadata("intersectionType3.kt")
        public void testIntersectionType3() throws Exception {
            runTest("compiler/testData/ir/irText/types/intersectionType3.kt");
        }

        @Test
        @TestMetadata("intersectionTypeInSamType.kt")
        public void testIntersectionTypeInSamType() throws Exception {
            runTest("compiler/testData/ir/irText/types/intersectionTypeInSamType.kt");
        }

        @Test
        @TestMetadata("javaWildcardType.kt")
        public void testJavaWildcardType() throws Exception {
            runTest("compiler/testData/ir/irText/types/javaWildcardType.kt");
        }

        @Test
        @TestMetadata("kt36143.kt")
        public void testKt36143() throws Exception {
            runTest("compiler/testData/ir/irText/types/kt36143.kt");
        }

        @Test
        @TestMetadata("kt49526.kt")
        public void testKt49526() throws Exception {
            runTest("compiler/testData/ir/irText/types/kt49526.kt");
        }

        @Test
        @TestMetadata("localVariableOfIntersectionType.kt")
        public void testLocalVariableOfIntersectionType() throws Exception {
            runTest("compiler/testData/ir/irText/types/localVariableOfIntersectionType.kt");
        }

        @Test
        @TestMetadata("rawTypeInSignature.kt")
        public void testRawTypeInSignature() throws Exception {
            runTest("compiler/testData/ir/irText/types/rawTypeInSignature.kt");
        }

        @Test
        @TestMetadata("receiverOfIntersectionType.kt")
        public void testReceiverOfIntersectionType() throws Exception {
            runTest("compiler/testData/ir/irText/types/receiverOfIntersectionType.kt");
        }

        @Test
        @TestMetadata("smartCastOnFakeOverrideReceiver.kt")
        public void testSmartCastOnFakeOverrideReceiver() throws Exception {
            runTest("compiler/testData/ir/irText/types/smartCastOnFakeOverrideReceiver.kt");
        }

        @Test
        @TestMetadata("smartCastOnFieldReceiverOfGenericType.kt")
        public void testSmartCastOnFieldReceiverOfGenericType() throws Exception {
            runTest("compiler/testData/ir/irText/types/smartCastOnFieldReceiverOfGenericType.kt");
        }

        @Test
        @TestMetadata("smartCastOnReceiverOfGenericType.kt")
        public void testSmartCastOnReceiverOfGenericType() throws Exception {
            runTest("compiler/testData/ir/irText/types/smartCastOnReceiverOfGenericType.kt");
        }

        @Test
        @TestMetadata("starProjection.kt")
        public void testStarProjection() throws Exception {
            runTest("compiler/testData/ir/irText/types/starProjection.kt");
        }

        @Test
        @TestMetadata("typeAliasWithUnsafeVariance.kt")
        public void testTypeAliasWithUnsafeVariance() throws Exception {
            runTest("compiler/testData/ir/irText/types/typeAliasWithUnsafeVariance.kt");
        }

        @Test
        @TestMetadata("typeCheckOnDefinitelyNotNull.kt")
        public void testTypeCheckOnDefinitelyNotNull() throws Exception {
            runTest("compiler/testData/ir/irText/types/typeCheckOnDefinitelyNotNull.kt");
        }

        @Nested
        @TestMetadata("compiler/testData/ir/irText/types/nullChecks")
        @TestDataPath("$PROJECT_ROOT")
        public class NullChecks {
            @Test
            public void testAllFilesPresentInNullChecks() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/types/nullChecks"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("enhancedNullability.kt")
            public void testEnhancedNullability() throws Exception {
                runTest("compiler/testData/ir/irText/types/nullChecks/enhancedNullability.kt");
            }

            @Test
            @TestMetadata("enhancedNullabilityInDestructuringAssignment.kt")
            public void testEnhancedNullabilityInDestructuringAssignment() throws Exception {
                runTest("compiler/testData/ir/irText/types/nullChecks/enhancedNullabilityInDestructuringAssignment.kt");
            }

            @Test
            @TestMetadata("enhancedNullabilityInForLoop.kt")
            public void testEnhancedNullabilityInForLoop() throws Exception {
                runTest("compiler/testData/ir/irText/types/nullChecks/enhancedNullabilityInForLoop.kt");
            }

            @Test
            @TestMetadata("explicitEqualsAndCompareToCallsOnPlatformTypeReceiver.kt")
            public void testExplicitEqualsAndCompareToCallsOnPlatformTypeReceiver() throws Exception {
                runTest("compiler/testData/ir/irText/types/nullChecks/explicitEqualsAndCompareToCallsOnPlatformTypeReceiver.kt");
            }

            @Test
            @TestMetadata("implicitNotNullOnPlatformType.kt")
            public void testImplicitNotNullOnPlatformType() throws Exception {
                runTest("compiler/testData/ir/irText/types/nullChecks/implicitNotNullOnPlatformType.kt");
            }

            @Test
            @TestMetadata("nullCheckInElvisRhs.kt")
            public void testNullCheckInElvisRhs() throws Exception {
                runTest("compiler/testData/ir/irText/types/nullChecks/nullCheckInElvisRhs.kt");
            }

            @Test
            @TestMetadata("nullCheckOnInterfaceDelegation.kt")
            public void testNullCheckOnInterfaceDelegation() throws Exception {
                runTest("compiler/testData/ir/irText/types/nullChecks/nullCheckOnInterfaceDelegation.kt");
            }

            @Test
            @TestMetadata("nullabilityAssertionOnExtensionReceiver.kt")
            public void testNullabilityAssertionOnExtensionReceiver() throws Exception {
                runTest("compiler/testData/ir/irText/types/nullChecks/nullabilityAssertionOnExtensionReceiver.kt");
            }

            @Test
            @TestMetadata("platformTypeReceiver.kt")
            public void testPlatformTypeReceiver() throws Exception {
                runTest("compiler/testData/ir/irText/types/nullChecks/platformTypeReceiver.kt");
            }

            @Test
            @TestMetadata("typeParameterWithMixedNullableAndNotNullableBounds.kt")
            public void testTypeParameterWithMixedNullableAndNotNullableBounds() throws Exception {
                runTest("compiler/testData/ir/irText/types/nullChecks/typeParameterWithMixedNullableAndNotNullableBounds.kt");
            }

            @Test
            @TestMetadata("typeParameterWithMultipleNotNullableBounds.kt")
            public void testTypeParameterWithMultipleNotNullableBounds() throws Exception {
                runTest("compiler/testData/ir/irText/types/nullChecks/typeParameterWithMultipleNotNullableBounds.kt");
            }

            @Test
            @TestMetadata("typeParameterWithMultipleNullableBounds.kt")
            public void testTypeParameterWithMultipleNullableBounds() throws Exception {
                runTest("compiler/testData/ir/irText/types/nullChecks/typeParameterWithMultipleNullableBounds.kt");
            }

            @Nested
            @TestMetadata("compiler/testData/ir/irText/types/nullChecks/nullCheckOnLambdaResult")
            @TestDataPath("$PROJECT_ROOT")
            public class NullCheckOnLambdaResult {
                @Test
                public void testAllFilesPresentInNullCheckOnLambdaResult() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/types/nullChecks/nullCheckOnLambdaResult"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
                }

                @Test
                @TestMetadata("nnStringVsT.kt")
                public void testNnStringVsT() throws Exception {
                    runTest("compiler/testData/ir/irText/types/nullChecks/nullCheckOnLambdaResult/nnStringVsT.kt");
                }

                @Test
                @TestMetadata("nnStringVsTAny.kt")
                public void testNnStringVsTAny() throws Exception {
                    runTest("compiler/testData/ir/irText/types/nullChecks/nullCheckOnLambdaResult/nnStringVsTAny.kt");
                }

                @Test
                @TestMetadata("nnStringVsTConstrained.kt")
                public void testNnStringVsTConstrained() throws Exception {
                    runTest("compiler/testData/ir/irText/types/nullChecks/nullCheckOnLambdaResult/nnStringVsTConstrained.kt");
                }

                @Test
                @TestMetadata("nnStringVsTXArray.kt")
                public void testNnStringVsTXArray() throws Exception {
                    runTest("compiler/testData/ir/irText/types/nullChecks/nullCheckOnLambdaResult/nnStringVsTXArray.kt");
                }

                @Test
                @TestMetadata("nnStringVsTXString.kt")
                public void testNnStringVsTXString() throws Exception {
                    runTest("compiler/testData/ir/irText/types/nullChecks/nullCheckOnLambdaResult/nnStringVsTXString.kt");
                }

                @Test
                @TestMetadata("stringVsAny.kt")
                public void testStringVsAny() throws Exception {
                    runTest("compiler/testData/ir/irText/types/nullChecks/nullCheckOnLambdaResult/stringVsAny.kt");
                }

                @Test
                @TestMetadata("stringVsT.kt")
                public void testStringVsT() throws Exception {
                    runTest("compiler/testData/ir/irText/types/nullChecks/nullCheckOnLambdaResult/stringVsT.kt");
                }

                @Test
                @TestMetadata("stringVsTAny.kt")
                public void testStringVsTAny() throws Exception {
                    runTest("compiler/testData/ir/irText/types/nullChecks/nullCheckOnLambdaResult/stringVsTAny.kt");
                }

                @Test
                @TestMetadata("stringVsTConstrained.kt")
                public void testStringVsTConstrained() throws Exception {
                    runTest("compiler/testData/ir/irText/types/nullChecks/nullCheckOnLambdaResult/stringVsTConstrained.kt");
                }

                @Test
                @TestMetadata("stringVsTXArray.kt")
                public void testStringVsTXArray() throws Exception {
                    runTest("compiler/testData/ir/irText/types/nullChecks/nullCheckOnLambdaResult/stringVsTXArray.kt");
                }

                @Test
                @TestMetadata("stringVsTXString.kt")
                public void testStringVsTXString() throws Exception {
                    runTest("compiler/testData/ir/irText/types/nullChecks/nullCheckOnLambdaResult/stringVsTXString.kt");
                }
            }
        }
    }
}
