/*
 * Copyright 2010-2021 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.test.runners.codegen;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link GenerateNewCompilerTests.kt}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("compiler/testData/codegen/bytecodeText")
@TestDataPath("$PROJECT_ROOT")
public class FirBytecodeTextTestGenerated extends AbstractFirBytecodeTextTest {
    @Test
    @TestMetadata("accessorForOverridenVal.kt")
    public void testAccessorForOverridenVal() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/accessorForOverridenVal.kt");
    }

    @Test
    @TestMetadata("accessorForProtected.kt")
    public void testAccessorForProtected() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/accessorForProtected.kt");
    }

    @Test
    @TestMetadata("accessorNaming.kt")
    public void testAccessorNaming() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/accessorNaming.kt");
    }

    @Test
    public void testAllFilesPresentInBytecodeText() throws Exception {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("annotationDefaultValue.kt")
    public void testAnnotationDefaultValue() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/annotationDefaultValue.kt");
    }

    @Test
    @TestMetadata("annotationDefaultValueOfUnsigned.kt")
    public void testAnnotationDefaultValueOfUnsigned() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/annotationDefaultValueOfUnsigned.kt");
    }

    @Test
    @TestMetadata("annotationJavaRetentionPolicyRuntime.kt")
    public void testAnnotationJavaRetentionPolicyRuntime() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/annotationJavaRetentionPolicyRuntime.kt");
    }

    @Test
    @TestMetadata("annotationRetentionPolicyClass.kt")
    public void testAnnotationRetentionPolicyClass() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/annotationRetentionPolicyClass.kt");
    }

    @Test
    @TestMetadata("annotationRetentionPolicyRuntime.kt")
    public void testAnnotationRetentionPolicyRuntime() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/annotationRetentionPolicyRuntime.kt");
    }

    @Test
    @TestMetadata("annotationRetentionPolicySource.kt")
    public void testAnnotationRetentionPolicySource() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/annotationRetentionPolicySource.kt");
    }

    @Test
    @TestMetadata("boxedNotNumberTypeOnUnboxing.kt")
    public void testBoxedNotNumberTypeOnUnboxing() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/boxedNotNumberTypeOnUnboxing.kt");
    }

    @Test
    @TestMetadata("bridgeForFakeOverride.kt")
    public void testBridgeForFakeOverride() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/bridgeForFakeOverride.kt");
    }

    @Test
    @TestMetadata("charConstant.kt")
    public void testCharConstant() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/charConstant.kt");
    }

    @Test
    @TestMetadata("checkcastOnThrow.kt")
    public void testCheckcastOnThrow() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/checkcastOnThrow.kt");
    }

    @Test
    @TestMetadata("collectionStubs.kt")
    public void testCollectionStubs() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/collectionStubs.kt");
    }

    @Test
    @TestMetadata("componentEvaluatesOnlyOnce.kt")
    public void testComponentEvaluatesOnlyOnce() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/componentEvaluatesOnlyOnce.kt");
    }

    @Test
    @TestMetadata("constClosureOptimization.kt")
    public void testConstClosureOptimization() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/constClosureOptimization.kt");
    }

    @Test
    @TestMetadata("defaultMethodBody.kt")
    public void testDefaultMethodBody() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/defaultMethodBody.kt");
    }

    @Test
    @TestMetadata("doNotStoreNullForTmpInDestructuring.kt")
    public void testDoNotStoreNullForTmpInDestructuring() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/doNotStoreNullForTmpInDestructuring.kt");
    }

    @Test
    @TestMetadata("doNotStoreNullsForCapturedVars.kt")
    public void testDoNotStoreNullsForCapturedVars() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/doNotStoreNullsForCapturedVars.kt");
    }

    @Test
    @TestMetadata("falseSmartCast.kt")
    public void testFalseSmartCast() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/falseSmartCast.kt");
    }

    @Test
    @TestMetadata("flagsInMultiFileInherit.kt")
    public void testFlagsInMultiFileInherit() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/flagsInMultiFileInherit.kt");
    }

    @Test
    @TestMetadata("iincGeneration.kt")
    public void testIincGeneration() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/iincGeneration.kt");
    }

    @Test
    @TestMetadata("inheritedPropertyAnnotations.kt")
    public void testInheritedPropertyAnnotations() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/inheritedPropertyAnnotations.kt");
    }

    @Test
    @TestMetadata("inlineFromOtherModule.kt")
    public void testInlineFromOtherModule() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/inlineFromOtherModule.kt");
    }

    @Test
    @TestMetadata("inlineJavaConstantFromSubclass.kt")
    public void testInlineJavaConstantFromSubclass() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/inlineJavaConstantFromSubclass.kt");
    }

    @Test
    @TestMetadata("inlineJavaStaticFields.kt")
    public void testInlineJavaStaticFields() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/inlineJavaStaticFields.kt");
    }

    @Test
    @TestMetadata("inlineProtectedJavaConstantFromOtherPackage.kt")
    public void testInlineProtectedJavaConstantFromOtherPackage() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/inlineProtectedJavaConstantFromOtherPackage.kt");
    }

    @Test
    @TestMetadata("intConstantNotNull.kt")
    public void testIntConstantNotNull() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/intConstantNotNull.kt");
    }

    @Test
    @TestMetadata("intConstantNullable.kt")
    public void testIntConstantNullable() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/intConstantNullable.kt");
    }

    @Test
    @TestMetadata("intConstantNullableSafeCall.kt")
    public void testIntConstantNullableSafeCall() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/intConstantNullableSafeCall.kt");
    }

    @Test
    @TestMetadata("intConstantSafeCall.kt")
    public void testIntConstantSafeCall() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/intConstantSafeCall.kt");
    }

    @Test
    @TestMetadata("intProgressionNoBoxing.kt")
    public void testIntProgressionNoBoxing() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/intProgressionNoBoxing.kt");
    }

    @Test
    @TestMetadata("intRangeNoBoxing.kt")
    public void testIntRangeNoBoxing() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/intRangeNoBoxing.kt");
    }

    @Test
    @TestMetadata("interfaceDefaultImpl.kt")
    public void testInterfaceDefaultImpl() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/interfaceDefaultImpl.kt");
    }

    @Test
    @TestMetadata("isArrayOf.kt")
    public void testIsArrayOf() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/isArrayOf.kt");
    }

    @Test
    @TestMetadata("javaExtensionPropertyIntrinsic.kt")
    public void testJavaExtensionPropertyIntrinsic() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/javaExtensionPropertyIntrinsic.kt");
    }

    @Test
    @TestMetadata("javaFields.kt")
    public void testJavaFields() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/javaFields.kt");
    }

    @Test
    @TestMetadata("javaFieldsWithIntersectionTypes.kt")
    public void testJavaFieldsWithIntersectionTypes() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/javaFieldsWithIntersectionTypes.kt");
    }

    @Test
    @TestMetadata("javaStatics.kt")
    public void testJavaStatics() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/javaStatics.kt");
    }

    @Test
    @TestMetadata("jvmField.kt")
    public void testJvmField() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/jvmField.kt");
    }

    @Test
    @TestMetadata("jvmStaticInternalMangling.kt")
    public void testJvmStaticInternalMangling() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/jvmStaticInternalMangling.kt");
    }

    @Test
    @TestMetadata("kt10259.kt")
    public void testKt10259() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/kt10259.kt");
    }

    @Test
    @TestMetadata("kt10259_2.kt")
    public void testKt10259_2() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/kt10259_2.kt");
    }

    @Test
    @TestMetadata("kt10259_3.kt")
    public void testKt10259_3() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/kt10259_3.kt");
    }

    @Test
    @TestMetadata("kt2202.kt")
    public void testKt2202() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/kt2202.kt");
    }

    @Test
    @TestMetadata("kt2887.kt")
    public void testKt2887() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/kt2887.kt");
    }

    @Test
    @TestMetadata("kt3845.kt")
    public void testKt3845() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/kt3845.kt");
    }

    @Test
    @TestMetadata("kt46615.kt")
    public void testKt46615() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/kt46615.kt");
    }

    @Test
    @TestMetadata("kt48367.kt")
    public void testKt48367() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/kt48367.kt");
    }

    @Test
    @TestMetadata("kt5016.kt")
    public void testKt5016() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/kt5016.kt");
    }

    @Test
    @TestMetadata("kt5016int.kt")
    public void testKt5016int() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/kt5016int.kt");
    }

    @Test
    @TestMetadata("kt5016intOrNull.kt")
    public void testKt5016intOrNull() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/kt5016intOrNull.kt");
    }

    @Test
    @TestMetadata("kt7188.kt")
    public void testKt7188() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/kt7188.kt");
    }

    @Test
    @TestMetadata("kt7769.kt")
    public void testKt7769() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/kt7769.kt");
    }

    @Test
    @TestMetadata("kt9603.kt")
    public void testKt9603() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/kt9603.kt");
    }

    @Test
    @TestMetadata("mapGetOrDefault.kt")
    public void testMapGetOrDefault() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/mapGetOrDefault.kt");
    }

    @Test
    @TestMetadata("maxStackAfterOptimizations.kt")
    public void testMaxStackAfterOptimizations() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/maxStackAfterOptimizations.kt");
    }

    @Test
    @TestMetadata("mergedProgression.kt")
    public void testMergedProgression() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/mergedProgression.kt");
    }

    @Test
    @TestMetadata("noAccessorForProtectedInSamePackageCrossinline.kt")
    public void testNoAccessorForProtectedInSamePackageCrossinline() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/noAccessorForProtectedInSamePackageCrossinline.kt");
    }

    @Test
    @TestMetadata("noAccessorForProtectedInSamePackagePrivateInline.kt")
    public void testNoAccessorForProtectedInSamePackagePrivateInline() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/noAccessorForProtectedInSamePackagePrivateInline.kt");
    }

    @Test
    @TestMetadata("noFlagAnnotations.kt")
    public void testNoFlagAnnotations() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/noFlagAnnotations.kt");
    }

    @Test
    @TestMetadata("noNumberCheckCast.kt")
    public void testNoNumberCheckCast() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/noNumberCheckCast.kt");
    }

    @Test
    @TestMetadata("noSuperCheckInDefaultConstuctor.kt")
    public void testNoSuperCheckInDefaultConstuctor() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/noSuperCheckInDefaultConstuctor.kt");
    }

    @Test
    @TestMetadata("noSyntheticAccessorForPrivateCompanionObjectWhenNotRequired.kt")
    public void testNoSyntheticAccessorForPrivateCompanionObjectWhenNotRequired() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/noSyntheticAccessorForPrivateCompanionObjectWhenNotRequired.kt");
    }

    @Test
    @TestMetadata("noWrapperForMethodReturningPrimitive.kt")
    public void testNoWrapperForMethodReturningPrimitive() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/noWrapperForMethodReturningPrimitive.kt");
    }

    @Test
    @TestMetadata("nopsInDoWhile.kt")
    public void testNopsInDoWhile() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/nopsInDoWhile.kt");
    }

    @Test
    @TestMetadata("partMembersCall.kt")
    public void testPartMembersCall() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/partMembersCall.kt");
    }

    @Test
    @TestMetadata("partMembersInline.kt")
    public void testPartMembersInline() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/partMembersInline.kt");
    }

    @Test
    @TestMetadata("preEvaluateInlineJavaStaticFields.kt")
    public void testPreEvaluateInlineJavaStaticFields() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/preEvaluateInlineJavaStaticFields.kt");
    }

    @Test
    @TestMetadata("prefixIntVarIncrement.kt")
    public void testPrefixIntVarIncrement() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/prefixIntVarIncrement.kt");
    }

    @Test
    @TestMetadata("privateDefaultArgs.kt")
    public void testPrivateDefaultArgs() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/privateDefaultArgs.kt");
    }

    @Test
    @TestMetadata("redundantGotoRemoving.kt")
    public void testRedundantGotoRemoving() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/redundantGotoRemoving.kt");
    }

    @Test
    @TestMetadata("redundantInitializer.kt")
    public void testRedundantInitializer() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/redundantInitializer.kt");
    }

    @Test
    @TestMetadata("redundantInitializerNumber.kt")
    public void testRedundantInitializerNumber() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/redundantInitializerNumber.kt");
    }

    @Test
    @TestMetadata("redundantValInitializer.kt")
    public void testRedundantValInitializer() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/redundantValInitializer.kt");
    }

    @Test
    @TestMetadata("redundantValInitializerInObject.kt")
    public void testRedundantValInitializerInObject() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/redundantValInitializerInObject.kt");
    }

    @Test
    @TestMetadata("redundantVarInitializer.kt")
    public void testRedundantVarInitializer() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/redundantVarInitializer.kt");
    }

    @Test
    @TestMetadata("redundantVarInitializerInObject.kt")
    public void testRedundantVarInitializerInObject() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/redundantVarInitializerInObject.kt");
    }

    @Test
    @TestMetadata("reifiedAsCheck.kt")
    public void testReifiedAsCheck() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/reifiedAsCheck.kt");
    }

    @Test
    @TestMetadata("reifiedAsCheckWithNullable.kt")
    public void testReifiedAsCheckWithNullable() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/reifiedAsCheckWithNullable.kt");
    }

    @Test
    @TestMetadata("reifiedIsCheck.kt")
    public void testReifiedIsCheck() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/reifiedIsCheck.kt");
    }

    @Test
    @TestMetadata("reifiedIsCheckWithNullable.kt")
    public void testReifiedIsCheckWithNullable() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/reifiedIsCheckWithNullable.kt");
    }

    @Test
    @TestMetadata("reifiedSafeAsCheck.kt")
    public void testReifiedSafeAsCheck() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/reifiedSafeAsCheck.kt");
    }

    @Test
    @TestMetadata("safeAsWithMutable.kt")
    public void testSafeAsWithMutable() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/safeAsWithMutable.kt");
    }

    @Test
    @TestMetadata("superFlagInMultiFileFacade.kt")
    public void testSuperFlagInMultiFileFacade() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/superFlagInMultiFileFacade.kt");
    }

    @Test
    @TestMetadata("superToString.kt")
    public void testSuperToString() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/superToString.kt");
    }

    @Test
    @TestMetadata("suspendCoroutineUninterceptedOrReturn.kt")
    public void testSuspendCoroutineUninterceptedOrReturn() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/suspendCoroutineUninterceptedOrReturn.kt");
    }

    @Test
    @TestMetadata("topLevelFunWithDefaultArgs.kt")
    public void testTopLevelFunWithDefaultArgs() throws Exception {
        runTest("compiler/testData/codegen/bytecodeText/topLevelFunWithDefaultArgs.kt");
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/argumentOrder")
    @TestDataPath("$PROJECT_ROOT")
    public class ArgumentOrder {
        @Test
        public void testAllFilesPresentInArgumentOrder() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/argumentOrder"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("sameOrder.kt")
        public void testSameOrder() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/argumentOrder/sameOrder.kt");
        }

        @Test
        @TestMetadata("sameOrderWithDefault.kt")
        public void testSameOrderWithDefault() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/argumentOrder/sameOrderWithDefault.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/assert")
    @TestDataPath("$PROJECT_ROOT")
    public class Assert {
        @Test
        public void testAllFilesPresentInAssert() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/assert"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("jvmCrossinline.kt")
        public void testJvmCrossinline() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/assert/jvmCrossinline.kt");
        }

        @Test
        @TestMetadata("jvmCrossinlineAssertInLambda.kt")
        public void testJvmCrossinlineAssertInLambda() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/assert/jvmCrossinlineAssertInLambda.kt");
        }

        @Test
        @TestMetadata("jvmInline.kt")
        public void testJvmInline() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/assert/jvmInline.kt");
        }

        @Test
        @TestMetadata("jvmInlineLambda.kt")
        public void testJvmInlineLambda() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/assert/jvmInlineLambda.kt");
        }

        @Test
        @TestMetadata("jvmNestedClass.kt")
        public void testJvmNestedClass() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/assert/jvmNestedClass.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/boxing")
    @TestDataPath("$PROJECT_ROOT")
    public class Boxing {
        @Test
        public void testAllFilesPresentInBoxing() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/boxing"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("crossinlineSuspend.kt")
        public void testCrossinlineSuspend() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/boxing/crossinlineSuspend.kt");
        }

        @Test
        @TestMetadata("inlineSuspend.kt")
        public void testInlineSuspend() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/boxing/inlineSuspend.kt");
        }

        @Test
        @TestMetadata("suspend.kt")
        public void testSuspend() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/boxing/suspend.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/boxingOptimization")
    @TestDataPath("$PROJECT_ROOT")
    public class BoxingOptimization {
        @Test
        public void testAllFilesPresentInBoxingOptimization() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/boxingOptimization"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("boxingAndEquals.kt")
        public void testBoxingAndEquals() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/boxingAndEquals.kt");
        }

        @Test
        @TestMetadata("casts.kt")
        public void testCasts() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/casts.kt");
        }

        @Test
        @TestMetadata("checkcastAndInstanceOf.kt")
        public void testCheckcastAndInstanceOf() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/checkcastAndInstanceOf.kt");
        }

        @Test
        @TestMetadata("fold.kt")
        public void testFold() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/fold.kt");
        }

        @Test
        @TestMetadata("hashCodeOnNonNull.kt")
        public void testHashCodeOnNonNull() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/hashCodeOnNonNull.kt");
        }

        @Test
        @TestMetadata("inlineClassesAndInlinedLambda.kt")
        public void testInlineClassesAndInlinedLambda() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/inlineClassesAndInlinedLambda.kt");
        }

        @Test
        @TestMetadata("intCompareTo.kt")
        public void testIntCompareTo() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/intCompareTo.kt");
        }

        @Test
        @TestMetadata("kClassInAnnotation.kt")
        public void testKClassInAnnotation() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/kClassInAnnotation.kt");
        }

        @Test
        @TestMetadata("kClassInAnnotationEscaping.kt")
        public void testKClassInAnnotationEscaping() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/kClassInAnnotationEscaping.kt");
        }

        @Test
        @TestMetadata("kt15862.kt")
        public void testKt15862() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/kt15862.kt");
        }

        @Test
        @TestMetadata("kt15862_2.kt")
        public void testKt15862_2() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/kt15862_2.kt");
        }

        @Test
        @TestMetadata("kt6842.kt")
        public void testKt6842() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/kt6842.kt");
        }

        @Test
        @TestMetadata("kt7224.kt")
        public void testKt7224() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/kt7224.kt");
        }

        @Test
        @TestMetadata("maxMinByOrNull.kt")
        public void testMaxMinByOrNull() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/maxMinByOrNull.kt");
        }

        @Test
        @TestMetadata("nullCheck.kt")
        public void testNullCheck() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/nullCheck.kt");
        }

        @Test
        @TestMetadata("progressions.kt")
        public void testProgressions() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/progressions.kt");
        }

        @Test
        @TestMetadata("safeCallToPrimitiveEquality1.kt")
        public void testSafeCallToPrimitiveEquality1() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/safeCallToPrimitiveEquality1.kt");
        }

        @Test
        @TestMetadata("safeCallToPrimitiveEquality2.kt")
        public void testSafeCallToPrimitiveEquality2() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/safeCallToPrimitiveEquality2.kt");
        }

        @Test
        @TestMetadata("safeCallToPrimitiveEquality3.kt")
        public void testSafeCallToPrimitiveEquality3() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/safeCallToPrimitiveEquality3.kt");
        }

        @Test
        @TestMetadata("safeCallWithElvis.kt")
        public void testSafeCallWithElvis() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/safeCallWithElvis.kt");
        }

        @Test
        @TestMetadata("safeCallWithElvisMultipleFiles.kt")
        public void testSafeCallWithElvisMultipleFiles() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/safeCallWithElvisMultipleFiles.kt");
        }

        @Test
        @TestMetadata("severalInlines.kt")
        public void testSeveralInlines() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/severalInlines.kt");
        }

        @Test
        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/simple.kt");
        }

        @Test
        @TestMetadata("simpleUninitializedMerge.kt")
        public void testSimpleUninitializedMerge() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/simpleUninitializedMerge.kt");
        }

        @Test
        @TestMetadata("suspendBoxing.kt")
        public void testSuspendBoxing() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/suspendBoxing.kt");
        }

        @Test
        @TestMetadata("unsafeRemoving.kt")
        public void testUnsafeRemoving() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/unsafeRemoving.kt");
        }

        @Test
        @TestMetadata("unsignedRangeIteratorSpecialization.kt")
        public void testUnsignedRangeIteratorSpecialization() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/unsignedRangeIteratorSpecialization.kt");
        }

        @Test
        @TestMetadata("variableClash.kt")
        public void testVariableClash() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/variableClash.kt");
        }

        @Test
        @TestMetadata("variables.kt")
        public void testVariables() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/variables.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/builtinFunctions")
    @TestDataPath("$PROJECT_ROOT")
    public class BuiltinFunctions {
        @Test
        public void testAllFilesPresentInBuiltinFunctions() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/builtinFunctions"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("charSequence.kt")
        public void testCharSequence() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/builtinFunctions/charSequence.kt");
        }

        @Test
        @TestMetadata("contains.kt")
        public void testContains() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/builtinFunctions/contains.kt");
        }

        @Test
        @TestMetadata("removeAt.kt")
        public void testRemoveAt() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/builtinFunctions/removeAt.kt");
        }

        @Test
        @TestMetadata("size.kt")
        public void testSize() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/builtinFunctions/size.kt");
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/bytecodeText/builtinFunctions/genericParameterBridge")
        @TestDataPath("$PROJECT_ROOT")
        public class GenericParameterBridge {
            @Test
            @TestMetadata("abstractList.kt")
            public void testAbstractList() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/builtinFunctions/genericParameterBridge/abstractList.kt");
            }

            @Test
            public void testAllFilesPresentInGenericParameterBridge() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/builtinFunctions/genericParameterBridge"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("IntMC.kt")
            public void testIntMC() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/builtinFunctions/genericParameterBridge/IntMC.kt");
            }

            @Test
            @TestMetadata("mutableCollection.kt")
            public void testMutableCollection() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/builtinFunctions/genericParameterBridge/mutableCollection.kt");
            }

            @Test
            @TestMetadata("mutableSetInterfaces.kt")
            public void testMutableSetInterfaces() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/builtinFunctions/genericParameterBridge/mutableSetInterfaces.kt");
            }

            @Test
            @TestMetadata("notNullAnyMC.kt")
            public void testNotNullAnyMC() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/builtinFunctions/genericParameterBridge/notNullAnyMC.kt");
            }

            @Test
            @TestMetadata("notNullParamMC.kt")
            public void testNotNullParamMC() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/builtinFunctions/genericParameterBridge/notNullParamMC.kt");
            }

            @Test
            @TestMetadata("nullableAnyMC.kt")
            public void testNullableAnyMC() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/builtinFunctions/genericParameterBridge/nullableAnyMC.kt");
            }
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/callableReference")
    @TestDataPath("$PROJECT_ROOT")
    public class CallableReference {
        @Test
        public void testAllFilesPresentInCallableReference() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/callableReference"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("boundFieldReferenceInInline.kt")
        public void testBoundFieldReferenceInInline() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/callableReference/boundFieldReferenceInInline.kt");
        }

        @Test
        @TestMetadata("boundFunReferenceInInline.kt")
        public void testBoundFunReferenceInInline() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/callableReference/boundFunReferenceInInline.kt");
        }

        @Test
        @TestMetadata("boundPropertyReferenceInInline.kt")
        public void testBoundPropertyReferenceInInline() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/callableReference/boundPropertyReferenceInInline.kt");
        }

        @Test
        @TestMetadata("kt36975.kt")
        public void testKt36975() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/callableReference/kt36975.kt");
        }

        @Test
        @TestMetadata("kt39612.kt")
        public void testKt39612() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/callableReference/kt39612.kt");
        }

        @Test
        @TestMetadata("nameIntrinsicWithImplicitThis.kt")
        public void testNameIntrinsicWithImplicitThis() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/callableReference/nameIntrinsicWithImplicitThis.kt");
        }

        @Test
        @TestMetadata("unboundFieldReferenceInInline.kt")
        public void testUnboundFieldReferenceInInline() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/callableReference/unboundFieldReferenceInInline.kt");
        }

        @Test
        @TestMetadata("unboundFunReferenceInInline.kt")
        public void testUnboundFunReferenceInInline() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/callableReference/unboundFunReferenceInInline.kt");
        }

        @Test
        @TestMetadata("unboundPropertyReferenceInInline.kt")
        public void testUnboundPropertyReferenceInInline() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/callableReference/unboundPropertyReferenceInInline.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/capturedVarsOptimization")
    @TestDataPath("$PROJECT_ROOT")
    public class CapturedVarsOptimization {
        @Test
        public void testAllFilesPresentInCapturedVarsOptimization() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/capturedVarsOptimization"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("capturedInChainOfInlineFuns.kt")
        public void testCapturedInChainOfInlineFuns() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/capturedVarsOptimization/capturedInChainOfInlineFuns.kt");
        }

        @Test
        @TestMetadata("capturedInInlineOnly.kt")
        public void testCapturedInInlineOnly() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/capturedVarsOptimization/capturedInInlineOnly.kt");
        }

        @Test
        @TestMetadata("capturedInLocalObject.kt")
        public void testCapturedInLocalObject() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/capturedVarsOptimization/capturedInLocalObject.kt");
        }

        @Test
        @TestMetadata("capturedInNoInlineOnly.kt")
        public void testCapturedInNoInlineOnly() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/capturedVarsOptimization/capturedInNoInlineOnly.kt");
        }

        @Test
        @TestMetadata("capturedInNoInlneInsideChainOfInlineFuns.kt")
        public void testCapturedInNoInlneInsideChainOfInlineFuns() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/capturedVarsOptimization/capturedInNoInlneInsideChainOfInlineFuns.kt");
        }

        @Test
        @TestMetadata("capturedValInLambdaInitializedInside.kt")
        public void testCapturedValInLambdaInitializedInside() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/capturedVarsOptimization/capturedValInLambdaInitializedInside.kt");
        }

        @Test
        @TestMetadata("capturedValInLambdaInitializedOutside.kt")
        public void testCapturedValInLambdaInitializedOutside() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/capturedVarsOptimization/capturedValInLambdaInitializedOutside.kt");
        }

        @Test
        @TestMetadata("capturedVarsOfSize2.kt")
        public void testCapturedVarsOfSize2() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/capturedVarsOptimization/capturedVarsOfSize2.kt");
        }

        @Test
        @TestMetadata("returnValueOfArrayConstructor.kt")
        public void testReturnValueOfArrayConstructor() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/capturedVarsOptimization/returnValueOfArrayConstructor.kt");
        }

        @Test
        @TestMetadata("sharedSlotsWithCapturedVars.kt")
        public void testSharedSlotsWithCapturedVars() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/capturedVarsOptimization/sharedSlotsWithCapturedVars.kt");
        }

        @Test
        @TestMetadata("withStackNormalization.kt")
        public void testWithStackNormalization() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/capturedVarsOptimization/withStackNormalization.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/checkcast")
    @TestDataPath("$PROJECT_ROOT")
    public class Checkcast {
        @Test
        public void testAllFilesPresentInCheckcast() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/checkcast"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("kt14811.kt")
        public void testKt14811() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/checkcast/kt14811.kt");
        }

        @Test
        @TestMetadata("kt14963.kt")
        public void testKt14963() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/checkcast/kt14963.kt");
        }

        @Test
        @TestMetadata("kt15411.kt")
        public void testKt15411() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/checkcast/kt15411.kt");
        }

        @Test
        @TestMetadata("kt22714.kt")
        public void testKt22714() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/checkcast/kt22714.kt");
        }

        @Test
        @TestMetadata("noCheckcastOnDelegatingDefaultImplsCall.kt")
        public void testNoCheckcastOnDelegatingDefaultImplsCall() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/checkcast/noCheckcastOnDelegatingDefaultImplsCall.kt");
        }

        @Test
        @TestMetadata("noCheckcastOnSuper.kt")
        public void testNoCheckcastOnSuper() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/checkcast/noCheckcastOnSuper.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/coercionToUnitOptimization")
    @TestDataPath("$PROJECT_ROOT")
    public class CoercionToUnitOptimization {
        @Test
        public void testAllFilesPresentInCoercionToUnitOptimization() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/coercionToUnitOptimization"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("inRangeCheckWithConst.kt")
        public void testInRangeCheckWithConst() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/coercionToUnitOptimization/inRangeCheckWithConst.kt");
        }

        @Test
        @TestMetadata("kt14360.kt")
        public void testKt14360() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/coercionToUnitOptimization/kt14360.kt");
        }

        @Test
        @TestMetadata("largeMethodWithCoercionToUnit.kt")
        public void testLargeMethodWithCoercionToUnit() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/coercionToUnitOptimization/largeMethodWithCoercionToUnit.kt");
        }

        @Test
        @TestMetadata("nopInlineFuns.kt")
        public void testNopInlineFuns() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/coercionToUnitOptimization/nopInlineFuns.kt");
        }

        @Test
        @TestMetadata("returnsUnit.kt")
        public void testReturnsUnit() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/coercionToUnitOptimization/returnsUnit.kt");
        }

        @Test
        @TestMetadata("safeCall.kt")
        public void testSafeCall() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/coercionToUnitOptimization/safeCall.kt");
        }

        @Test
        @TestMetadata("safeCallWithReturnValue.kt")
        public void testSafeCallWithReturnValue() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/coercionToUnitOptimization/safeCallWithReturnValue.kt");
        }

        @Test
        @TestMetadata("safeLet.kt")
        public void testSafeLet() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/coercionToUnitOptimization/safeLet.kt");
        }

        @Test
        @TestMetadata("tryInlined.kt")
        public void testTryInlined() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/coercionToUnitOptimization/tryInlined.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/companion")
    @TestDataPath("$PROJECT_ROOT")
    public class Companion {
        @Test
        public void testAllFilesPresentInCompanion() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/companion"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("directAccessToBackingField.kt")
        public void testDirectAccessToBackingField() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/companion/directAccessToBackingField.kt");
        }

        @Test
        @TestMetadata("floatingPointCompanionAccess.kt")
        public void testFloatingPointCompanionAccess() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/companion/floatingPointCompanionAccess.kt");
        }

        @Test
        @TestMetadata("inlineFunctionCompanionPropertyAccess.kt")
        public void testInlineFunctionCompanionPropertyAccess() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/companion/inlineFunctionCompanionPropertyAccess.kt");
        }

        @Test
        @TestMetadata("inlineFunctionObjectCompanionPropertyAccess.kt")
        public void testInlineFunctionObjectCompanionPropertyAccess() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/companion/inlineFunctionObjectCompanionPropertyAccess.kt");
        }

        @Test
        @TestMetadata("kt14258_1.kt")
        public void testKt14258_1() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/companion/kt14258_1.kt");
        }

        @Test
        @TestMetadata("kt14258_2.kt")
        public void testKt14258_2() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/companion/kt14258_2.kt");
        }

        @Test
        @TestMetadata("kt14258_3.kt")
        public void testKt14258_3() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/companion/kt14258_3.kt");
        }

        @Test
        @TestMetadata("kt14258_4.kt")
        public void testKt14258_4() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/companion/kt14258_4.kt");
        }

        @Test
        @TestMetadata("kt14258_5.kt")
        public void testKt14258_5() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/companion/kt14258_5.kt");
        }

        @Test
        @TestMetadata("nonDefaultAccessors.kt")
        public void testNonDefaultAccessors() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/companion/nonDefaultAccessors.kt");
        }

        @Test
        @TestMetadata("privateCompanionObjectAccessors_after.kt")
        public void testPrivateCompanionObjectAccessors_after() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/companion/privateCompanionObjectAccessors_after.kt");
        }

        @Test
        @TestMetadata("privateCompanionObjectAccessors_before.kt")
        public void testPrivateCompanionObjectAccessors_before() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/companion/privateCompanionObjectAccessors_before.kt");
        }

        @Test
        @TestMetadata("protectedCompanionObjectAccessors_after.kt")
        public void testProtectedCompanionObjectAccessors_after() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/companion/protectedCompanionObjectAccessors_after.kt");
        }

        @Test
        @TestMetadata("protectedCompanionObjectAccessors_before.kt")
        public void testProtectedCompanionObjectAccessors_before() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/companion/protectedCompanionObjectAccessors_before.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/conditions")
    @TestDataPath("$PROJECT_ROOT")
    public class Conditions {
        @Test
        public void testAllFilesPresentInConditions() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/conditions"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("conjunction.kt")
        public void testConjunction() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/conditions/conjunction.kt");
        }

        @Test
        @TestMetadata("conjunctionInDoWhile.kt")
        public void testConjunctionInDoWhile() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/conditions/conjunctionInDoWhile.kt");
        }

        @Test
        @TestMetadata("conjunctionInWhile.kt")
        public void testConjunctionInWhile() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/conditions/conjunctionInWhile.kt");
        }

        @Test
        @TestMetadata("disjunction.kt")
        public void testDisjunction() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/conditions/disjunction.kt");
        }

        @Test
        @TestMetadata("negatedConjuction.kt")
        public void testNegatedConjuction() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/conditions/negatedConjuction.kt");
        }

        @Test
        @TestMetadata("negatedDisjunction.kt")
        public void testNegatedDisjunction() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/conditions/negatedDisjunction.kt");
        }

        @Test
        @TestMetadata("negatedNonZeroCompareInDoWhile.kt")
        public void testNegatedNonZeroCompareInDoWhile() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/conditions/negatedNonZeroCompareInDoWhile.kt");
        }

        @Test
        @TestMetadata("negatedNonZeroCompareInIf.kt")
        public void testNegatedNonZeroCompareInIf() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/conditions/negatedNonZeroCompareInIf.kt");
        }

        @Test
        @TestMetadata("negatedNonZeroCompareInWhile.kt")
        public void testNegatedNonZeroCompareInWhile() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/conditions/negatedNonZeroCompareInWhile.kt");
        }

        @Test
        @TestMetadata("negatedNullCompareInDoWhile.kt")
        public void testNegatedNullCompareInDoWhile() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/conditions/negatedNullCompareInDoWhile.kt");
        }

        @Test
        @TestMetadata("negatedNullCompareInIf.kt")
        public void testNegatedNullCompareInIf() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/conditions/negatedNullCompareInIf.kt");
        }

        @Test
        @TestMetadata("negatedNullCompareInWhile.kt")
        public void testNegatedNullCompareInWhile() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/conditions/negatedNullCompareInWhile.kt");
        }

        @Test
        @TestMetadata("negatedZeroCompareInDoWhile.kt")
        public void testNegatedZeroCompareInDoWhile() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/conditions/negatedZeroCompareInDoWhile.kt");
        }

        @Test
        @TestMetadata("negatedZeroCompareInIf.kt")
        public void testNegatedZeroCompareInIf() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/conditions/negatedZeroCompareInIf.kt");
        }

        @Test
        @TestMetadata("negatedZeroCompareInWhile.kt")
        public void testNegatedZeroCompareInWhile() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/conditions/negatedZeroCompareInWhile.kt");
        }

        @Test
        @TestMetadata("noBoxingForBoxedEqPrimitive.kt")
        public void testNoBoxingForBoxedEqPrimitive() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/conditions/noBoxingForBoxedEqPrimitive.kt");
        }

        @Test
        @TestMetadata("noBoxingForPrimitiveEqBoxed.kt")
        public void testNoBoxingForPrimitiveEqBoxed() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/conditions/noBoxingForPrimitiveEqBoxed.kt");
        }

        @Test
        @TestMetadata("noBoxingForPrimitiveEqObject.kt")
        public void testNoBoxingForPrimitiveEqObject() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/conditions/noBoxingForPrimitiveEqObject.kt");
        }

        @Test
        @TestMetadata("nonZeroCompareInDoWhile.kt")
        public void testNonZeroCompareInDoWhile() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/conditions/nonZeroCompareInDoWhile.kt");
        }

        @Test
        @TestMetadata("nonZeroCompareInIf.kt")
        public void testNonZeroCompareInIf() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/conditions/nonZeroCompareInIf.kt");
        }

        @Test
        @TestMetadata("nonZeroCompareInWhile.kt")
        public void testNonZeroCompareInWhile() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/conditions/nonZeroCompareInWhile.kt");
        }

        @Test
        @TestMetadata("nullCompareConst.kt")
        public void testNullCompareConst() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/conditions/nullCompareConst.kt");
        }

        @Test
        @TestMetadata("nullCompareInDoWhile.kt")
        public void testNullCompareInDoWhile() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/conditions/nullCompareInDoWhile.kt");
        }

        @Test
        @TestMetadata("nullCompareInIf.kt")
        public void testNullCompareInIf() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/conditions/nullCompareInIf.kt");
        }

        @Test
        @TestMetadata("nullCompareInWhile.kt")
        public void testNullCompareInWhile() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/conditions/nullCompareInWhile.kt");
        }

        @Test
        @TestMetadata("zeroCompareInDoWhile.kt")
        public void testZeroCompareInDoWhile() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/conditions/zeroCompareInDoWhile.kt");
        }

        @Test
        @TestMetadata("zeroCompareInIf.kt")
        public void testZeroCompareInIf() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/conditions/zeroCompareInIf.kt");
        }

        @Test
        @TestMetadata("zeroCompareInWhile.kt")
        public void testZeroCompareInWhile() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/conditions/zeroCompareInWhile.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/constProperty")
    @TestDataPath("$PROJECT_ROOT")
    public class ConstProperty {
        @Test
        public void testAllFilesPresentInConstProperty() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/constProperty"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("noAccessorsForPrivateConstants.kt")
        public void testNoAccessorsForPrivateConstants() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/constProperty/noAccessorsForPrivateConstants.kt");
        }

        @Test
        @TestMetadata("nonConstValHasNoDefaultValue_after.kt")
        public void testNonConstValHasNoDefaultValue_after() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/constProperty/nonConstValHasNoDefaultValue_after.kt");
        }

        @Test
        @TestMetadata("nonConstValHasNoDefaultValue_before.kt")
        public void testNonConstValHasNoDefaultValue_before() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/constProperty/nonConstValHasNoDefaultValue_before.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/constantConditions")
    @TestDataPath("$PROJECT_ROOT")
    public class ConstantConditions {
        @Test
        public void testAllFilesPresentInConstantConditions() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/constantConditions"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("cmpIntWith0.kt")
        public void testCmpIntWith0() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/constantConditions/cmpIntWith0.kt");
        }

        @Test
        @TestMetadata("constantFlag.kt")
        public void testConstantFlag() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/constantConditions/constantFlag.kt");
        }

        @Test
        @TestMetadata("constantInt.kt")
        public void testConstantInt() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/constantConditions/constantInt.kt");
        }

        @Test
        @TestMetadata("inlineIfFalse.kt")
        public void testInlineIfFalse() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/constantConditions/inlineIfFalse.kt");
        }

        @Test
        @TestMetadata("kt3098.kt")
        public void testKt3098() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/constantConditions/kt3098.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/constants")
    @TestDataPath("$PROJECT_ROOT")
    public class Constants {
        @Test
        public void testAllFilesPresentInConstants() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/constants"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("byte.kt")
        public void testByte() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/constants/byte.kt");
        }

        @Test
        @TestMetadata("comparisonFalse.kt")
        public void testComparisonFalse() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/constants/comparisonFalse.kt");
        }

        @Test
        @TestMetadata("comparisonTrue.kt")
        public void testComparisonTrue() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/constants/comparisonTrue.kt");
        }

        @Test
        @TestMetadata("floatingPoints.kt")
        public void testFloatingPoints() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/constants/floatingPoints.kt");
        }

        @Test
        @TestMetadata("inlineUnsignedIntConstant.kt")
        public void testInlineUnsignedIntConstant() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/constants/inlineUnsignedIntConstant.kt");
        }

        @Test
        @TestMetadata("kt9532.kt")
        public void testKt9532() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/constants/kt9532.kt");
        }

        @Test
        @TestMetadata("noInlineNonConst.kt")
        public void testNoInlineNonConst() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/constants/noInlineNonConst.kt");
        }

        @Test
        @TestMetadata("noInlineNonStaticJavaField.kt")
        public void testNoInlineNonStaticJavaField() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/constants/noInlineNonStaticJavaField.kt");
        }

        @Test
        @TestMetadata("nullableByteAndShort.kt")
        public void testNullableByteAndShort() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/constants/nullableByteAndShort.kt");
        }

        @Test
        @TestMetadata("partialString.kt")
        public void testPartialString() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/constants/partialString.kt");
        }

        @Test
        @TestMetadata("short.kt")
        public void testShort() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/constants/short.kt");
        }

        @Test
        @TestMetadata("string.kt")
        public void testString() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/constants/string.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/constructors")
    @TestDataPath("$PROJECT_ROOT")
    public class Constructors {
        @Test
        public void testAllFilesPresentInConstructors() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/constructors"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("enumPrimaryDefaults.kt")
        public void testEnumPrimaryDefaults() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/constructors/enumPrimaryDefaults.kt");
        }

        @Test
        @TestMetadata("inlineArgumentPrimaryDefaults.kt")
        public void testInlineArgumentPrimaryDefaults() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/constructors/inlineArgumentPrimaryDefaults.kt");
        }

        @Test
        @TestMetadata("inlinePrimaryDefaults.kt")
        public void testInlinePrimaryDefaults() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/constructors/inlinePrimaryDefaults.kt");
        }

        @Test
        @TestMetadata("innerClassConstructor.kt")
        public void testInnerClassConstructor() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/constructors/innerClassConstructor.kt");
        }

        @Test
        @TestMetadata("innerPrimaryDefaults.kt")
        public void testInnerPrimaryDefaults() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/constructors/innerPrimaryDefaults.kt");
        }

        @Test
        @TestMetadata("internalPrimaryDefaults.kt")
        public void testInternalPrimaryDefaults() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/constructors/internalPrimaryDefaults.kt");
        }

        @Test
        @TestMetadata("localPrimaryDefaults.kt")
        public void testLocalPrimaryDefaults() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/constructors/localPrimaryDefaults.kt");
        }

        @Test
        @TestMetadata("parameterlessPrimary.kt")
        public void testParameterlessPrimary() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/constructors/parameterlessPrimary.kt");
        }

        @Test
        @TestMetadata("privatePrimaryDefaults.kt")
        public void testPrivatePrimaryDefaults() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/constructors/privatePrimaryDefaults.kt");
        }

        @Test
        @TestMetadata("protectedPrimaryDefaults.kt")
        public void testProtectedPrimaryDefaults() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/constructors/protectedPrimaryDefaults.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/controlStructures")
    @TestDataPath("$PROJECT_ROOT")
    public class ControlStructures {
        @Test
        public void testAllFilesPresentInControlStructures() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/controlStructures"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("ifConsts.kt")
        public void testIfConsts() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/controlStructures/ifConsts.kt");
        }

        @Test
        @TestMetadata("kt17110.kt")
        public void testKt17110() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/controlStructures/kt17110.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/coroutines")
    @TestDataPath("$PROJECT_ROOT")
    public class Coroutines {
        @Test
        public void testAllFilesPresentInCoroutines() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/coroutines"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("crossinlineSuspendContinuation_1_3.kt")
        public void testCrossinlineSuspendContinuation_1_3() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/coroutines/crossinlineSuspendContinuation_1_3.kt");
        }

        @Test
        @TestMetadata("doNotReassignContinuation.kt")
        public void testDoNotReassignContinuation() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/coroutines/doNotReassignContinuation.kt");
        }

        @Test
        @TestMetadata("effectivelyInlineOnly.kt")
        public void testEffectivelyInlineOnly() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/coroutines/effectivelyInlineOnly.kt");
        }

        @Test
        @TestMetadata("internalInlineSuspend.kt")
        public void testInternalInlineSuspend() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/coroutines/internalInlineSuspend.kt");
        }

        @Test
        @TestMetadata("mergeLvt.kt")
        public void testMergeLvt() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/coroutines/mergeLvt.kt");
        }

        @Test
        @TestMetadata("nonLocalReturn.kt")
        public void testNonLocalReturn() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/coroutines/nonLocalReturn.kt");
        }

        @Test
        @TestMetadata("returnUnitInLambda.kt")
        public void testReturnUnitInLambda() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/coroutines/returnUnitInLambda.kt");
        }

        @Test
        @TestMetadata("suspendMain.kt")
        public void testSuspendMain() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/coroutines/suspendMain.kt");
        }

        @Test
        @TestMetadata("throwOnFailure.kt")
        public void testThrowOnFailure() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/coroutines/throwOnFailure.kt");
        }

        @Test
        @TestMetadata("varValueConflictsWithTable.kt")
        public void testVarValueConflictsWithTable() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/coroutines/varValueConflictsWithTable.kt");
        }

        @Test
        @TestMetadata("varValueConflictsWithTableSameSort.kt")
        public void testVarValueConflictsWithTableSameSort() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/coroutines/varValueConflictsWithTableSameSort.kt");
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/bytecodeText/coroutines/cleanup")
        @TestDataPath("$PROJECT_ROOT")
        public class Cleanup {
            @Test
            public void testAllFilesPresentInCleanup() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/coroutines/cleanup"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("backEdge.kt")
            public void testBackEdge() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/coroutines/cleanup/backEdge.kt");
            }

            @Test
            @TestMetadata("if.kt")
            public void testIf() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/coroutines/cleanup/if.kt");
            }

            @Test
            @TestMetadata("nullCleanup.kt")
            public void testNullCleanup() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/coroutines/cleanup/nullCleanup.kt");
            }

            @Test
            @TestMetadata("nullNotSpill.kt")
            public void testNullNotSpill() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/coroutines/cleanup/nullNotSpill.kt");
            }

            @Test
            @TestMetadata("simple.kt")
            public void testSimple() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/coroutines/cleanup/simple.kt");
            }

            @Test
            @TestMetadata("twoRefs.kt")
            public void testTwoRefs() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/coroutines/cleanup/twoRefs.kt");
            }

            @Test
            @TestMetadata("unusedParamNotSpill.kt")
            public void testUnusedParamNotSpill() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/coroutines/cleanup/unusedParamNotSpill.kt");
            }

            @Test
            @TestMetadata("when.kt")
            public void testWhen() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/coroutines/cleanup/when.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/bytecodeText/coroutines/debug")
        @TestDataPath("$PROJECT_ROOT")
        public class Debug {
            @Test
            public void testAllFilesPresentInDebug() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/coroutines/debug"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("continuationInLvt.kt")
            public void testContinuationInLvt() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/coroutines/debug/continuationInLvt.kt");
            }

            @Test
            @TestMetadata("localVariableCorrectLabel.kt")
            public void testLocalVariableCorrectLabel() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/coroutines/debug/localVariableCorrectLabel.kt");
            }

            @Test
            @TestMetadata("probeCoroutineSuspended.kt")
            public void testProbeCoroutineSuspended() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/coroutines/debug/probeCoroutineSuspended.kt");
            }

            @Test
            @TestMetadata("shrinkLvtTopLevel.kt")
            public void testShrinkLvtTopLevel() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/coroutines/debug/shrinkLvtTopLevel.kt");
            }

            @Test
            @TestMetadata("thisAndResultInLvt.kt")
            public void testThisAndResultInLvt() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/coroutines/debug/thisAndResultInLvt.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/bytecodeText/coroutines/destructuringInLambda")
        @TestDataPath("$PROJECT_ROOT")
        public class DestructuringInLambda {
            @Test
            public void testAllFilesPresentInDestructuringInLambda() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/coroutines/destructuringInLambda"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("inlineSeparateFiles.kt")
            public void testInlineSeparateFiles() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/coroutines/destructuringInLambda/inlineSeparateFiles.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/bytecodeText/coroutines/inlineClasses")
        @TestDataPath("$PROJECT_ROOT")
        public class InlineClasses {
            @Test
            public void testAllFilesPresentInInlineClasses() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/coroutines/inlineClasses"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("inlineClassBoxingInSuspendFunReturn_Primitive.kt")
            public void testInlineClassBoxingInSuspendFunReturn_Primitive() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/coroutines/inlineClasses/inlineClassBoxingInSuspendFunReturn_Primitive.kt");
            }

            @Test
            @TestMetadata("noInlineClassBoxingInSuspendFunReturn_Any.kt")
            public void testNoInlineClassBoxingInSuspendFunReturn_Any() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/coroutines/inlineClasses/noInlineClassBoxingInSuspendFunReturn_Any.kt");
            }

            @Test
            @TestMetadata("noInlineClassBoxingInSuspendFunReturn_InlineAny.kt")
            public void testNoInlineClassBoxingInSuspendFunReturn_InlineAny() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/coroutines/inlineClasses/noInlineClassBoxingInSuspendFunReturn_InlineAny.kt");
            }

            @Test
            @TestMetadata("noInlineClassBoxingInSuspendFunReturn_SameJvmType.kt")
            public void testNoInlineClassBoxingInSuspendFunReturn_SameJvmType() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/coroutines/inlineClasses/noInlineClassBoxingInSuspendFunReturn_SameJvmType.kt");
            }

            @Test
            @TestMetadata("noInlineClassBoxingInSuspendFunReturn_String.kt")
            public void testNoInlineClassBoxingInSuspendFunReturn_String() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/coroutines/inlineClasses/noInlineClassBoxingInSuspendFunReturn_String.kt");
            }

            @Test
            @TestMetadata("returnResult.kt")
            public void testReturnResult() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/coroutines/inlineClasses/returnResult.kt");
            }

            @Test
            @TestMetadata("returnStringOverride.kt")
            public void testReturnStringOverride() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/coroutines/inlineClasses/returnStringOverride.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling")
        @TestDataPath("$PROJECT_ROOT")
        public class IntLikeVarSpilling {
            @Test
            public void testAllFilesPresentInIntLikeVarSpilling() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("complicatedMerge.kt")
            public void testComplicatedMerge() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling/complicatedMerge.kt");
            }

            @Test
            @TestMetadata("i2bResult.kt")
            public void testI2bResult() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling/i2bResult.kt");
            }

            @Test
            @TestMetadata("loadFromBooleanArray.kt")
            public void testLoadFromBooleanArray() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling/loadFromBooleanArray.kt");
            }

            @Test
            @TestMetadata("loadFromByteArray.kt")
            public void testLoadFromByteArray() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling/loadFromByteArray.kt");
            }

            @Test
            @TestMetadata("noVariableInTable.kt")
            public void testNoVariableInTable() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling/noVariableInTable.kt");
            }

            @Test
            @TestMetadata("sameIconst1ManyVars.kt")
            public void testSameIconst1ManyVars() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling/sameIconst1ManyVars.kt");
            }

            @Test
            @TestMetadata("usedInArrayStore.kt")
            public void testUsedInArrayStore() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling/usedInArrayStore.kt");
            }

            @Test
            @TestMetadata("usedInMethodCall.kt")
            public void testUsedInMethodCall() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling/usedInMethodCall.kt");
            }

            @Test
            @TestMetadata("usedInPutfield.kt")
            public void testUsedInPutfield() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling/usedInPutfield.kt");
            }

            @Test
            @TestMetadata("usedInVarStore.kt")
            public void testUsedInVarStore() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling/usedInVarStore.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/bytecodeText/coroutines/stateMachine")
        @TestDataPath("$PROJECT_ROOT")
        public class StateMachine {
            @Test
            public void testAllFilesPresentInStateMachine() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/coroutines/stateMachine"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("kt25893.kt")
            public void testKt25893() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/coroutines/stateMachine/kt25893.kt");
            }

            @Test
            @TestMetadata("withTypeParameter.kt")
            public void testWithTypeParameter() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/coroutines/stateMachine/withTypeParameter.kt");
            }
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/deadCodeElimination")
    @TestDataPath("$PROJECT_ROOT")
    public class DeadCodeElimination {
        @Test
        public void testAllFilesPresentInDeadCodeElimination() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/deadCodeElimination"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("arrayConstructor.kt")
        public void testArrayConstructor() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/deadCodeElimination/arrayConstructor.kt");
        }

        @Test
        @TestMetadata("boxing.kt")
        public void testBoxing() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/deadCodeElimination/boxing.kt");
        }

        @Test
        @TestMetadata("boxingNotOptimizable.kt")
        public void testBoxingNotOptimizable() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/deadCodeElimination/boxingNotOptimizable.kt");
        }

        @Test
        @TestMetadata("emptyVariableRange.kt")
        public void testEmptyVariableRange() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/deadCodeElimination/emptyVariableRange.kt");
        }

        @Test
        @TestMetadata("kt14357.kt")
        public void testKt14357() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/deadCodeElimination/kt14357.kt");
        }

        @Test
        @TestMetadata("lastReturn.kt")
        public void testLastReturn() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/deadCodeElimination/lastReturn.kt");
        }

        @Test
        @TestMetadata("literal.kt")
        public void testLiteral() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/deadCodeElimination/literal.kt");
        }

        @Test
        @TestMetadata("simpleConstructor.kt")
        public void testSimpleConstructor() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/deadCodeElimination/simpleConstructor.kt");
        }

        @Test
        @TestMetadata("simpleConstructorNotRedundant.kt")
        public void testSimpleConstructorNotRedundant() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/deadCodeElimination/simpleConstructorNotRedundant.kt");
        }

        @Test
        @TestMetadata("simpleConstructorNotRedundantNotOptimizable.kt")
        public void testSimpleConstructorNotRedundantNotOptimizable() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/deadCodeElimination/simpleConstructorNotRedundantNotOptimizable.kt");
        }

        @Test
        @TestMetadata("unusedPrimitiveAndObjectEquals.kt")
        public void testUnusedPrimitiveAndObjectEquals() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/deadCodeElimination/unusedPrimitiveAndObjectEquals.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/defaultArguments")
    @TestDataPath("$PROJECT_ROOT")
    public class DefaultArguments {
        @Test
        public void testAllFilesPresentInDefaultArguments() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/defaultArguments"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("inheritedInterfaceFunction.kt")
        public void testInheritedInterfaceFunction() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/defaultArguments/inheritedInterfaceFunction.kt");
        }

        @Test
        @TestMetadata("kt11962.kt")
        public void testKt11962() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/defaultArguments/kt11962.kt");
        }

        @Test
        @TestMetadata("localVariablesInInlinedDefaultStubs.kt")
        public void testLocalVariablesInInlinedDefaultStubs() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/defaultArguments/localVariablesInInlinedDefaultStubs.kt");
        }

        @Test
        @TestMetadata("maskAndArgumentElimination.kt")
        public void testMaskAndArgumentElimination() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/defaultArguments/maskAndArgumentElimination.kt");
        }

        @Test
        @TestMetadata("maskCheckSequence.kt")
        public void testMaskCheckSequence() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/defaultArguments/maskCheckSequence.kt");
        }

        @Test
        @TestMetadata("methodHandlerElimination.kt")
        public void testMethodHandlerElimination() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/defaultArguments/methodHandlerElimination.kt");
        }

        @Test
        @TestMetadata("noAccessorForDefault.kt")
        public void testNoAccessorForDefault() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/defaultArguments/noAccessorForDefault.kt");
        }

        @Test
        @TestMetadata("noAnonymousObjectRegenerationInDefaultStub.kt")
        public void testNoAnonymousObjectRegenerationInDefaultStub() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/defaultArguments/noAnonymousObjectRegenerationInDefaultStub.kt");
        }

        @Test
        @TestMetadata("noEmptyArray.kt")
        public void testNoEmptyArray() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/defaultArguments/noEmptyArray.kt");
        }

        @Test
        @TestMetadata("noSyntheticParameters.kt")
        public void testNoSyntheticParameters() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/defaultArguments/noSyntheticParameters.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/directInvoke")
    @TestDataPath("$PROJECT_ROOT")
    public class DirectInvoke {
        @Test
        public void testAllFilesPresentInDirectInvoke() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/directInvoke"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("callableReference.kt")
        public void testCallableReference() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/directInvoke/callableReference.kt");
        }

        @Test
        @TestMetadata("inplaceClosure.kt")
        public void testInplaceClosure() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/directInvoke/inplaceClosure.kt");
        }

        @Test
        @TestMetadata("localFun.kt")
        public void testLocalFun() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/directInvoke/localFun.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/disabledOptimizations")
    @TestDataPath("$PROJECT_ROOT")
    public class DisabledOptimizations {
        @Test
        public void testAllFilesPresentInDisabledOptimizations() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/disabledOptimizations"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("noJumpInLastBranch.kt")
        public void testNoJumpInLastBranch() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/disabledOptimizations/noJumpInLastBranch.kt");
        }

        @Test
        @TestMetadata("noJumpInSingleBranch.kt")
        public void testNoJumpInSingleBranch() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/disabledOptimizations/noJumpInSingleBranch.kt");
        }

        @Test
        @TestMetadata("noObjectCastAfterReification.kt")
        public void testNoObjectCastAfterReification() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/disabledOptimizations/noObjectCastAfterReification.kt");
        }

        @Test
        @TestMetadata("noUnitInstanceInDefaultParameterInitialization.kt")
        public void testNoUnitInstanceInDefaultParameterInitialization() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/disabledOptimizations/noUnitInstanceInDefaultParameterInitialization.kt");
        }

        @Test
        @TestMetadata("noUnitInstanceOnVoidFunctionCall.kt")
        public void testNoUnitInstanceOnVoidFunctionCall() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/disabledOptimizations/noUnitInstanceOnVoidFunctionCall.kt");
        }

        @Test
        @TestMetadata("noUnusedLabel.kt")
        public void testNoUnusedLabel() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/disabledOptimizations/noUnusedLabel.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/enum")
    @TestDataPath("$PROJECT_ROOT")
    public class Enum {
        @Test
        public void testAllFilesPresentInEnum() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/enum"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("constructorAccessors.kt")
        public void testConstructorAccessors() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/enum/constructorAccessors.kt");
        }

        @Test
        @TestMetadata("enumCheckcasts.kt")
        public void testEnumCheckcasts() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/enum/enumCheckcasts.kt");
        }

        @Test
        @TestMetadata("kt18731.kt")
        public void testKt18731() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/enum/kt18731.kt");
        }

        @Test
        @TestMetadata("kt18731_2.kt")
        public void testKt18731_2() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/enum/kt18731_2.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/exclExcl")
    @TestDataPath("$PROJECT_ROOT")
    public class ExclExcl {
        @Test
        public void testAllFilesPresentInExclExcl() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/exclExcl"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("exclExclOnPlatformType.kt")
        public void testExclExclOnPlatformType() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/exclExcl/exclExclOnPlatformType.kt");
        }

        @Test
        @TestMetadata("primitive.kt")
        public void testPrimitive() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/exclExcl/primitive.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/fieldsForCapturedValues")
    @TestDataPath("$PROJECT_ROOT")
    public class FieldsForCapturedValues {
        @Test
        public void testAllFilesPresentInFieldsForCapturedValues() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/fieldsForCapturedValues"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("constructorOnly.kt")
        public void testConstructorOnly() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/fieldsForCapturedValues/constructorOnly.kt");
        }

        @Test
        @TestMetadata("extensionLambdaExtensionReceiver.kt")
        public void testExtensionLambdaExtensionReceiver() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/fieldsForCapturedValues/extensionLambdaExtensionReceiver.kt");
        }

        @Test
        @TestMetadata("extensionReceiver.kt")
        public void testExtensionReceiver() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/fieldsForCapturedValues/extensionReceiver.kt");
        }

        @Test
        @TestMetadata("innerAndOuterThis.kt")
        public void testInnerAndOuterThis() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/fieldsForCapturedValues/innerAndOuterThis.kt");
        }

        @Test
        @TestMetadata("labeledExtensionLambdaExtensionReceiver.kt")
        public void testLabeledExtensionLambdaExtensionReceiver() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/fieldsForCapturedValues/labeledExtensionLambdaExtensionReceiver.kt");
        }

        @Test
        @TestMetadata("multipleExtensionReceivers.kt")
        public void testMultipleExtensionReceivers() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/fieldsForCapturedValues/multipleExtensionReceivers.kt");
        }

        @Test
        @TestMetadata("outerThis.kt")
        public void testOuterThis() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/fieldsForCapturedValues/outerThis.kt");
        }

        @Test
        @TestMetadata("outerThisInInnerConstructor.kt")
        public void testOuterThisInInnerConstructor() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/fieldsForCapturedValues/outerThisInInnerConstructor.kt");
        }

        @Test
        @TestMetadata("outerThisInInnerInitBlock.kt")
        public void testOuterThisInInnerInitBlock() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/fieldsForCapturedValues/outerThisInInnerInitBlock.kt");
        }

        @Test
        @TestMetadata("this.kt")
        public void testThis() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/fieldsForCapturedValues/this.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/forLoop")
    @TestDataPath("$PROJECT_ROOT")
    public class ForLoop {
        @Test
        public void testAllFilesPresentInForLoop() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/forLoop"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("forInCharSequence.kt")
        public void testForInCharSequence() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/forLoop/forInCharSequence.kt");
        }

        @Test
        @TestMetadata("forInCharSequenceTypeParameter.kt")
        public void testForInCharSequenceTypeParameter() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/forLoop/forInCharSequenceTypeParameter.kt");
        }

        @Test
        @TestMetadata("forInDownToCharMinValue.kt")
        public void testForInDownToCharMinValue() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/forLoop/forInDownToCharMinValue.kt");
        }

        @Test
        @TestMetadata("forInDownToIntMinValue.kt")
        public void testForInDownToIntMinValue() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/forLoop/forInDownToIntMinValue.kt");
        }

        @Test
        @TestMetadata("forInDownToLongConstNoUnderflow.kt")
        public void testForInDownToLongConstNoUnderflow() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/forLoop/forInDownToLongConstNoUnderflow.kt");
        }

        @Test
        @TestMetadata("forInDownToLongMinValue.kt")
        public void testForInDownToLongMinValue() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/forLoop/forInDownToLongMinValue.kt");
        }

        @Test
        @TestMetadata("forInObjectArray.kt")
        public void testForInObjectArray() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/forLoop/forInObjectArray.kt");
        }

        @Test
        @TestMetadata("forInPrimitiveArray.kt")
        public void testForInPrimitiveArray() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/forLoop/forInPrimitiveArray.kt");
        }

        @Test
        @TestMetadata("forInRangeSpecializedToUntil.kt")
        public void testForInRangeSpecializedToUntil() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeSpecializedToUntil.kt");
        }

        @Test
        @TestMetadata("forInRangeToCharConst.kt")
        public void testForInRangeToCharConst() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeToCharConst.kt");
        }

        @Test
        @TestMetadata("forInRangeToCharMaxValue.kt")
        public void testForInRangeToCharMaxValue() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeToCharMaxValue.kt");
        }

        @Test
        @TestMetadata("forInRangeToConst.kt")
        public void testForInRangeToConst() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeToConst.kt");
        }

        @Test
        @TestMetadata("forInRangeToIntMaxValue.kt")
        public void testForInRangeToIntMaxValue() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeToIntMaxValue.kt");
        }

        @Test
        @TestMetadata("forInRangeToLongConst.kt")
        public void testForInRangeToLongConst() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeToLongConst.kt");
        }

        @Test
        @TestMetadata("forInRangeToLongMaxValue.kt")
        public void testForInRangeToLongMaxValue() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeToLongMaxValue.kt");
        }

        @Test
        @TestMetadata("forInRangeToQualifiedConst.kt")
        public void testForInRangeToQualifiedConst() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeToQualifiedConst.kt");
        }

        @Test
        @TestMetadata("forInRangeWithImplicitReceiver.kt")
        public void testForInRangeWithImplicitReceiver() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithImplicitReceiver.kt");
        }

        @Test
        @TestMetadata("forInStringSpecialized.kt")
        public void testForInStringSpecialized() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/forLoop/forInStringSpecialized.kt");
        }

        @Test
        @TestMetadata("forIntInDownTo.kt")
        public void testForIntInDownTo() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/forLoop/forIntInDownTo.kt");
        }

        @Test
        @TestMetadata("iincGeneration.kt")
        public void testIincGeneration() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/forLoop/iincGeneration.kt");
        }

        @Test
        @TestMetadata("intrinsicArrayConstructorsUseCounterLoop.kt")
        public void testIntrinsicArrayConstructorsUseCounterLoop() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/forLoop/intrinsicArrayConstructorsUseCounterLoop.kt");
        }

        @Test
        @TestMetadata("loopVarInterval.kt")
        public void testLoopVarInterval() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/forLoop/loopVarInterval.kt");
        }

        @Test
        @TestMetadata("primitiveLiteralRange1.kt")
        public void testPrimitiveLiteralRange1() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/forLoop/primitiveLiteralRange1.kt");
        }

        @Test
        @TestMetadata("primitiveLiteralRange2.kt")
        public void testPrimitiveLiteralRange2() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/forLoop/primitiveLiteralRange2.kt");
        }

        @Test
        @TestMetadata("primitiveProgression.kt")
        public void testPrimitiveProgression() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/forLoop/primitiveProgression.kt");
        }

        @Test
        @TestMetadata("primitiveRange.kt")
        public void testPrimitiveRange() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/forLoop/primitiveRange.kt");
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/bytecodeText/forLoop/forInArrayWithIndex")
        @TestDataPath("$PROJECT_ROOT")
        public class ForInArrayWithIndex {
            @Test
            public void testAllFilesPresentInForInArrayWithIndex() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/forLoop/forInArrayWithIndex"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("forInArrayWithIndexNoElementVar.kt")
            public void testForInArrayWithIndexNoElementVar() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInArrayWithIndex/forInArrayWithIndexNoElementVar.kt");
            }

            @Test
            @TestMetadata("forInArrayWithIndexNoIndexVar.kt")
            public void testForInArrayWithIndexNoIndexVar() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInArrayWithIndex/forInArrayWithIndexNoIndexVar.kt");
            }

            @Test
            @TestMetadata("forInEmptyArrayWithIndex.kt")
            public void testForInEmptyArrayWithIndex() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInArrayWithIndex/forInEmptyArrayWithIndex.kt");
            }

            @Test
            @TestMetadata("forInIntArrayWithIndex.kt")
            public void testForInIntArrayWithIndex() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInArrayWithIndex/forInIntArrayWithIndex.kt");
            }

            @Test
            @TestMetadata("forInObjectArrayWithIndex.kt")
            public void testForInObjectArrayWithIndex() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInArrayWithIndex/forInObjectArrayWithIndex.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/bytecodeText/forLoop/forInCharSequenceWithIndex")
        @TestDataPath("$PROJECT_ROOT")
        public class ForInCharSequenceWithIndex {
            @Test
            public void testAllFilesPresentInForInCharSequenceWithIndex() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/forLoop/forInCharSequenceWithIndex"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("forInCharSequenceWithIndex.kt")
            public void testForInCharSequenceWithIndex() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInCharSequenceWithIndex/forInCharSequenceWithIndex.kt");
            }

            @Test
            @TestMetadata("forInEmptyStringWithIndex.kt")
            public void testForInEmptyStringWithIndex() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInCharSequenceWithIndex/forInEmptyStringWithIndex.kt");
            }

            @Test
            @TestMetadata("forInStringWithIndex.kt")
            public void testForInStringWithIndex() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInCharSequenceWithIndex/forInStringWithIndex.kt");
            }

            @Test
            @TestMetadata("forInStringWithIndexNoElementVar.kt")
            public void testForInStringWithIndexNoElementVar() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInCharSequenceWithIndex/forInStringWithIndexNoElementVar.kt");
            }

            @Test
            @TestMetadata("forInStringWithIndexNoIndexVar.kt")
            public void testForInStringWithIndexNoIndexVar() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInCharSequenceWithIndex/forInStringWithIndexNoIndexVar.kt");
            }

            @Test
            @TestMetadata("forInStringWithIndexWithExplicitlyTypedIndexVariable.kt")
            public void testForInStringWithIndexWithExplicitlyTypedIndexVariable() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInCharSequenceWithIndex/forInStringWithIndexWithExplicitlyTypedIndexVariable.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/bytecodeText/forLoop/forInIndices")
        @TestDataPath("$PROJECT_ROOT")
        public class ForInIndices {
            @Test
            public void testAllFilesPresentInForInIndices() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/forLoop/forInIndices"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("forInArrayListIndices.kt")
            public void testForInArrayListIndices() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInIndices/forInArrayListIndices.kt");
            }

            @Test
            @TestMetadata("forInCharSequenceIndices.kt")
            public void testForInCharSequenceIndices() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInIndices/forInCharSequenceIndices.kt");
            }

            @Test
            @TestMetadata("forInCharSequenceTypeParameterIndices.kt")
            public void testForInCharSequenceTypeParameterIndices() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInIndices/forInCharSequenceTypeParameterIndices.kt");
            }

            @Test
            @TestMetadata("forInCollectionImplicitReceiverIndices.kt")
            public void testForInCollectionImplicitReceiverIndices() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInIndices/forInCollectionImplicitReceiverIndices.kt");
            }

            @Test
            @TestMetadata("forInCollectionIndices.kt")
            public void testForInCollectionIndices() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInIndices/forInCollectionIndices.kt");
            }

            @Test
            @TestMetadata("forInCollectionTypeParameterIndices.kt")
            public void testForInCollectionTypeParameterIndices() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInIndices/forInCollectionTypeParameterIndices.kt");
            }

            @Test
            @TestMetadata("forInNonOptimizedIndices.kt")
            public void testForInNonOptimizedIndices() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInIndices/forInNonOptimizedIndices.kt");
            }

            @Test
            @TestMetadata("forInObjectArrayIndices.kt")
            public void testForInObjectArrayIndices() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInIndices/forInObjectArrayIndices.kt");
            }

            @Test
            @TestMetadata("forInPrimitiveArrayIndices.kt")
            public void testForInPrimitiveArrayIndices() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInIndices/forInPrimitiveArrayIndices.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/bytecodeText/forLoop/forInIterableWithIndex")
        @TestDataPath("$PROJECT_ROOT")
        public class ForInIterableWithIndex {
            @Test
            public void testAllFilesPresentInForInIterableWithIndex() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/forLoop/forInIterableWithIndex"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("forInEmptyListWithIndex.kt")
            public void testForInEmptyListWithIndex() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInIterableWithIndex/forInEmptyListWithIndex.kt");
            }

            @Test
            @TestMetadata("forInIterableTypeParameterWithIndex.kt")
            public void testForInIterableTypeParameterWithIndex() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInIterableWithIndex/forInIterableTypeParameterWithIndex.kt");
            }

            @Test
            @TestMetadata("forInListWithIndex.kt")
            public void testForInListWithIndex() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInIterableWithIndex/forInListWithIndex.kt");
            }

            @Test
            @TestMetadata("forInListWithIndexNoElementVar.kt")
            public void testForInListWithIndexNoElementVar() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInIterableWithIndex/forInListWithIndexNoElementVar.kt");
            }

            @Test
            @TestMetadata("forInListWithIndexNoIndexVar.kt")
            public void testForInListWithIndexNoIndexVar() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInIterableWithIndex/forInListWithIndexNoIndexVar.kt");
            }

            @Test
            @TestMetadata("forInListWithIndexWithExplicitlyTypedIndexVariable.kt")
            public void testForInListWithIndexWithExplicitlyTypedIndexVariable() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInIterableWithIndex/forInListWithIndexWithExplicitlyTypedIndexVariable.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/bytecodeText/forLoop/forInProgressionWithIndex")
        @TestDataPath("$PROJECT_ROOT")
        public class ForInProgressionWithIndex {
            @Test
            public void testAllFilesPresentInForInProgressionWithIndex() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/forLoop/forInProgressionWithIndex"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("forInDownToWithIndex.kt")
            public void testForInDownToWithIndex() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInProgressionWithIndex/forInDownToWithIndex.kt");
            }

            @Test
            @TestMetadata("forInIndicesWithIndex.kt")
            public void testForInIndicesWithIndex() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInProgressionWithIndex/forInIndicesWithIndex.kt");
            }

            @Test
            @TestMetadata("forInRangeToWithIndex.kt")
            public void testForInRangeToWithIndex() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInProgressionWithIndex/forInRangeToWithIndex.kt");
            }

            @Test
            @TestMetadata("forInReversedStepWithIndex.kt")
            public void testForInReversedStepWithIndex() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInProgressionWithIndex/forInReversedStepWithIndex.kt");
            }

            @Test
            @TestMetadata("forInReversedWithIndex.kt")
            public void testForInReversedWithIndex() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInProgressionWithIndex/forInReversedWithIndex.kt");
            }

            @Test
            @TestMetadata("forInStepReversedWithIndex.kt")
            public void testForInStepReversedWithIndex() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInProgressionWithIndex/forInStepReversedWithIndex.kt");
            }

            @Test
            @TestMetadata("forInStepWithIndex.kt")
            public void testForInStepWithIndex() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInProgressionWithIndex/forInStepWithIndex.kt");
            }

            @Test
            @TestMetadata("forInUntilWithIndex.kt")
            public void testForInUntilWithIndex() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInProgressionWithIndex/forInUntilWithIndex.kt");
            }

            @Test
            @TestMetadata("forInWithIndexNoIndexOrElementVar.kt")
            public void testForInWithIndexNoIndexOrElementVar() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInProgressionWithIndex/forInWithIndexNoIndexOrElementVar.kt");
            }

            @Test
            @TestMetadata("forInWithIndexNotDestructured.kt")
            public void testForInWithIndexNotDestructured() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInProgressionWithIndex/forInWithIndexNotDestructured.kt");
            }

            @Test
            @TestMetadata("forInWithIndexReversed.kt")
            public void testForInWithIndexReversed() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInProgressionWithIndex/forInWithIndexReversed.kt");
            }

            @Test
            @TestMetadata("forInWithIndexWithIndex.kt")
            public void testForInWithIndexWithIndex() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInProgressionWithIndex/forInWithIndexWithIndex.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1")
        @TestDataPath("$PROJECT_ROOT")
        public class ForInRangeWithUpperBoundMinus1 {
            @Test
            public void testAllFilesPresentInForInRangeWithUpperBoundMinus1() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("booleanArray.kt")
            public void testBooleanArray() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1/booleanArray.kt");
            }

            @Test
            @TestMetadata("byteArray.kt")
            public void testByteArray() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1/byteArray.kt");
            }

            @Test
            @TestMetadata("charArray.kt")
            public void testCharArray() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1/charArray.kt");
            }

            @Test
            @TestMetadata("charSequence.kt")
            public void testCharSequence() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1/charSequence.kt");
            }

            @Test
            @TestMetadata("doubleArray.kt")
            public void testDoubleArray() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1/doubleArray.kt");
            }

            @Test
            @TestMetadata("emptyList.kt")
            public void testEmptyList() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1/emptyList.kt");
            }

            @Test
            @TestMetadata("emptyMap.kt")
            public void testEmptyMap() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1/emptyMap.kt");
            }

            @Test
            @TestMetadata("emptySet.kt")
            public void testEmptySet() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1/emptySet.kt");
            }

            @Test
            @TestMetadata("floatArray.kt")
            public void testFloatArray() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1/floatArray.kt");
            }

            @Test
            @TestMetadata("intArray.kt")
            public void testIntArray() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1/intArray.kt");
            }

            @Test
            @TestMetadata("list.kt")
            public void testList() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1/list.kt");
            }

            @Test
            @TestMetadata("longArray.kt")
            public void testLongArray() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1/longArray.kt");
            }

            @Test
            @TestMetadata("map.kt")
            public void testMap() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1/map.kt");
            }

            @Test
            @TestMetadata("mutableList.kt")
            public void testMutableList() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1/mutableList.kt");
            }

            @Test
            @TestMetadata("mutableMap.kt")
            public void testMutableMap() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1/mutableMap.kt");
            }

            @Test
            @TestMetadata("mutableSet.kt")
            public void testMutableSet() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1/mutableSet.kt");
            }

            @Test
            @TestMetadata("set.kt")
            public void testSet() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1/set.kt");
            }

            @Test
            @TestMetadata("shortArray.kt")
            public void testShortArray() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1/shortArray.kt");
            }

            @Test
            @TestMetadata("string.kt")
            public void testString() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1/string.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/bytecodeText/forLoop/forInReversed")
        @TestDataPath("$PROJECT_ROOT")
        public class ForInReversed {
            @Test
            public void testAllFilesPresentInForInReversed() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/forLoop/forInReversed"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("forInReversedArrayIndices.kt")
            public void testForInReversedArrayIndices() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInReversed/forInReversedArrayIndices.kt");
            }

            @Test
            @TestMetadata("forInReversedCharSequenceIndices.kt")
            public void testForInReversedCharSequenceIndices() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInReversed/forInReversedCharSequenceIndices.kt");
            }

            @Test
            @TestMetadata("forInReversedCollectionIndices.kt")
            public void testForInReversedCollectionIndices() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInReversed/forInReversedCollectionIndices.kt");
            }

            @Test
            @TestMetadata("forInReversedDownTo.kt")
            public void testForInReversedDownTo() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInReversed/forInReversedDownTo.kt");
            }

            @Test
            @TestMetadata("forInReversedEmptyRangeLiteral.kt")
            public void testForInReversedEmptyRangeLiteral() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInReversed/forInReversedEmptyRangeLiteral.kt");
            }

            @Test
            @TestMetadata("forInReversedRange.kt")
            public void testForInReversedRange() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInReversed/forInReversedRange.kt");
            }

            @Test
            @TestMetadata("forInReversedRangeLiteral.kt")
            public void testForInReversedRangeLiteral() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInReversed/forInReversedRangeLiteral.kt");
            }

            @Test
            @TestMetadata("forInReversedReversedArrayIndices.kt")
            public void testForInReversedReversedArrayIndices() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInReversed/forInReversedReversedArrayIndices.kt");
            }

            @Test
            @TestMetadata("forInReversedReversedDownTo.kt")
            public void testForInReversedReversedDownTo() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInReversed/forInReversedReversedDownTo.kt");
            }

            @Test
            @TestMetadata("forInReversedReversedRange.kt")
            public void testForInReversedReversedRange() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInReversed/forInReversedReversedRange.kt");
            }

            @Test
            @TestMetadata("forInReversedReversedReversedRange.kt")
            public void testForInReversedReversedReversedRange() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInReversed/forInReversedReversedReversedRange.kt");
            }

            @Test
            @TestMetadata("forInReversedReversedUntil.kt")
            public void testForInReversedReversedUntil() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInReversed/forInReversedReversedUntil.kt");
            }

            @Test
            @TestMetadata("forInReversedUntil.kt")
            public void testForInReversedUntil() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInReversed/forInReversedUntil.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/bytecodeText/forLoop/forInSequenceWithIndex")
        @TestDataPath("$PROJECT_ROOT")
        public class ForInSequenceWithIndex {
            @Test
            public void testAllFilesPresentInForInSequenceWithIndex() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/forLoop/forInSequenceWithIndex"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("forInEmptySequenceWithIndex.kt")
            public void testForInEmptySequenceWithIndex() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInSequenceWithIndex/forInEmptySequenceWithIndex.kt");
            }

            @Test
            @TestMetadata("forInSequenceTypeParameterWithIndex.kt")
            public void testForInSequenceTypeParameterWithIndex() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInSequenceWithIndex/forInSequenceTypeParameterWithIndex.kt");
            }

            @Test
            @TestMetadata("forInSequenceWithIndex.kt")
            public void testForInSequenceWithIndex() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInSequenceWithIndex/forInSequenceWithIndex.kt");
            }

            @Test
            @TestMetadata("forInSequenceWithIndexNoElementVar.kt")
            public void testForInSequenceWithIndexNoElementVar() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInSequenceWithIndex/forInSequenceWithIndexNoElementVar.kt");
            }

            @Test
            @TestMetadata("forInSequenceWithIndexNoIndexVar.kt")
            public void testForInSequenceWithIndexNoIndexVar() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInSequenceWithIndex/forInSequenceWithIndexNoIndexVar.kt");
            }

            @Test
            @TestMetadata("forInSequenceWithIndexThrowsCME.kt")
            public void testForInSequenceWithIndexThrowsCME() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInSequenceWithIndex/forInSequenceWithIndexThrowsCME.kt");
            }

            @Test
            @TestMetadata("forInSequenceWithIndexWithExplicitlyTypedIndexVariable.kt")
            public void testForInSequenceWithIndexWithExplicitlyTypedIndexVariable() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInSequenceWithIndex/forInSequenceWithIndexWithExplicitlyTypedIndexVariable.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/bytecodeText/forLoop/forInUntil")
        @TestDataPath("$PROJECT_ROOT")
        public class ForInUntil {
            @Test
            public void testAllFilesPresentInForInUntil() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/forLoop/forInUntil"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("forInUntilChar.kt")
            public void testForInUntilChar() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInUntil/forInUntilChar.kt");
            }

            @Test
            @TestMetadata("forInUntilCharMaxValue.kt")
            public void testForInUntilCharMaxValue() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInUntil/forInUntilCharMaxValue.kt");
            }

            @Test
            @TestMetadata("forInUntilCharMinValue.kt")
            public void testForInUntilCharMinValue() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInUntil/forInUntilCharMinValue.kt");
            }

            @Test
            @TestMetadata("forInUntilInt.kt")
            public void testForInUntilInt() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInUntil/forInUntilInt.kt");
            }

            @Test
            @TestMetadata("forInUntilIntMaxValue.kt")
            public void testForInUntilIntMaxValue() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInUntil/forInUntilIntMaxValue.kt");
            }

            @Test
            @TestMetadata("forInUntilIntMinValue.kt")
            public void testForInUntilIntMinValue() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInUntil/forInUntilIntMinValue.kt");
            }

            @Test
            @TestMetadata("forInUntilLong.kt")
            public void testForInUntilLong() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInUntil/forInUntilLong.kt");
            }

            @Test
            @TestMetadata("forInUntilLongMaxValue.kt")
            public void testForInUntilLongMaxValue() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInUntil/forInUntilLongMaxValue.kt");
            }

            @Test
            @TestMetadata("forInUntilLongMinValue.kt")
            public void testForInUntilLongMinValue() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/forInUntil/forInUntilLongMinValue.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/bytecodeText/forLoop/stepped")
        @TestDataPath("$PROJECT_ROOT")
        public class Stepped {
            @Test
            public void testAllFilesPresentInStepped() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/forLoop/stepped"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("illegalStepConst.kt")
            public void testIllegalStepConst() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/stepped/illegalStepConst.kt");
            }

            @Test
            @TestMetadata("reversedThenStep.kt")
            public void testReversedThenStep() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/stepped/reversedThenStep.kt");
            }

            @Test
            @TestMetadata("stepConst.kt")
            public void testStepConst() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/stepped/stepConst.kt");
            }

            @Test
            @TestMetadata("stepConstOnNonLiteralProgression.kt")
            public void testStepConstOnNonLiteralProgression() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/stepped/stepConstOnNonLiteralProgression.kt");
            }

            @Test
            @TestMetadata("stepNonConst.kt")
            public void testStepNonConst() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/stepped/stepNonConst.kt");
            }

            @Test
            @TestMetadata("stepNonConstOnNonLiteralProgression.kt")
            public void testStepNonConstOnNonLiteralProgression() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/stepped/stepNonConstOnNonLiteralProgression.kt");
            }

            @Test
            @TestMetadata("stepOnNonLiteralRange.kt")
            public void testStepOnNonLiteralRange() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/stepped/stepOnNonLiteralRange.kt");
            }

            @Test
            @TestMetadata("stepOne.kt")
            public void testStepOne() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/stepped/stepOne.kt");
            }

            @Test
            @TestMetadata("stepOneThenStepOne.kt")
            public void testStepOneThenStepOne() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/stepped/stepOneThenStepOne.kt");
            }

            @Test
            @TestMetadata("stepThenDifferentStep.kt")
            public void testStepThenDifferentStep() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/stepped/stepThenDifferentStep.kt");
            }

            @Test
            @TestMetadata("stepThenReversed.kt")
            public void testStepThenReversed() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/stepped/stepThenReversed.kt");
            }

            @Test
            @TestMetadata("stepThenSameStep.kt")
            public void testStepThenSameStep() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/stepped/stepThenSameStep.kt");
            }

            @Test
            @TestMetadata("stepThenStepNonConst.kt")
            public void testStepThenStepNonConst() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/stepped/stepThenStepNonConst.kt");
            }

            @Test
            @TestMetadata("stepThenStepOne.kt")
            public void testStepThenStepOne() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/stepped/stepThenStepOne.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/bytecodeText/forLoop/unsigned")
        @TestDataPath("$PROJECT_ROOT")
        public class Unsigned {
            @Test
            public void testAllFilesPresentInUnsigned() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/forLoop/unsigned"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("forInConstBoundUnsignedRange.kt")
            public void testForInConstBoundUnsignedRange() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/forInConstBoundUnsignedRange.kt");
            }

            @Test
            @TestMetadata("forInDownToUIntMinValue.kt")
            public void testForInDownToUIntMinValue() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/forInDownToUIntMinValue.kt");
            }

            @Test
            @TestMetadata("forInDownToULongMinValue.kt")
            public void testForInDownToULongMinValue() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/forInDownToULongMinValue.kt");
            }

            @Test
            @TestMetadata("forInOptimizableUnsignedRange.kt")
            public void testForInOptimizableUnsignedRange() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/forInOptimizableUnsignedRange.kt");
            }

            @Test
            @TestMetadata("forInRangeToUIntMaxValue.kt")
            public void testForInRangeToUIntMaxValue() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/forInRangeToUIntMaxValue.kt");
            }

            @Test
            @TestMetadata("forInRangeToULongMaxValue.kt")
            public void testForInRangeToULongMaxValue() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/forInRangeToULongMaxValue.kt");
            }

            @Test
            @TestMetadata("forInUnsignedArray.kt")
            public void testForInUnsignedArray() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/forInUnsignedArray.kt");
            }

            @Test
            @TestMetadata("forInUnsignedArrayIndices.kt")
            public void testForInUnsignedArrayIndices() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/forInUnsignedArrayIndices.kt");
            }

            @Test
            @TestMetadata("forInUnsignedArrayWithIndex.kt")
            public void testForInUnsignedArrayWithIndex() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/forInUnsignedArrayWithIndex.kt");
            }

            @Test
            @TestMetadata("forInUntilUIntMaxValue.kt")
            public void testForInUntilUIntMaxValue() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/forInUntilUIntMaxValue.kt");
            }

            @Test
            @TestMetadata("forInUntilUIntMinValue.kt")
            public void testForInUntilUIntMinValue() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/forInUntilUIntMinValue.kt");
            }

            @Test
            @TestMetadata("forInUntilULongMaxValue.kt")
            public void testForInUntilULongMaxValue() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/forInUntilULongMaxValue.kt");
            }

            @Test
            @TestMetadata("forInUntilULongMinValue.kt")
            public void testForInUntilULongMinValue() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/forInUntilULongMinValue.kt");
            }

            @Test
            @TestMetadata("illegalStepConst.kt")
            public void testIllegalStepConst() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/illegalStepConst.kt");
            }

            @Test
            @TestMetadata("reversedThenStep.kt")
            public void testReversedThenStep() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/reversedThenStep.kt");
            }

            @Test
            @TestMetadata("stepConstOnNonLiteralProgression.kt")
            public void testStepConstOnNonLiteralProgression() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/stepConstOnNonLiteralProgression.kt");
            }

            @Test
            @TestMetadata("stepNonConstOnNonLiteralProgression.kt")
            public void testStepNonConstOnNonLiteralProgression() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/stepNonConstOnNonLiteralProgression.kt");
            }

            @Test
            @TestMetadata("stepOnNonLiteralRange.kt")
            public void testStepOnNonLiteralRange() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/stepOnNonLiteralRange.kt");
            }

            @Test
            @TestMetadata("stepThenDifferentStep.kt")
            public void testStepThenDifferentStep() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/stepThenDifferentStep.kt");
            }
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/hashCode")
    @TestDataPath("$PROJECT_ROOT")
    public class HashCode {
        @Test
        public void testAllFilesPresentInHashCode() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/hashCode"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("hashCode_1_6.kt")
        public void testHashCode_1_6() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/hashCode/hashCode_1_6.kt");
        }

        @Test
        @TestMetadata("interfaceHashCode.kt")
        public void testInterfaceHashCode() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/hashCode/interfaceHashCode.kt");
        }

        @Test
        @TestMetadata("interfaceHashCodeWithSmartCast.kt")
        public void testInterfaceHashCodeWithSmartCast() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/hashCode/interfaceHashCodeWithSmartCast.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/ieee754")
    @TestDataPath("$PROJECT_ROOT")
    public class Ieee754 {
        @Test
        public void testAllFilesPresentInIeee754() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/ieee754"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("nullableDoubleEquals.kt")
        public void testNullableDoubleEquals() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/ieee754/nullableDoubleEquals.kt");
        }

        @Test
        @TestMetadata("nullableDoubleNotEquals.kt")
        public void testNullableDoubleNotEquals() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/ieee754/nullableDoubleNotEquals.kt");
        }

        @Test
        @TestMetadata("nullableFloatEquals.kt")
        public void testNullableFloatEquals() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/ieee754/nullableFloatEquals.kt");
        }

        @Test
        @TestMetadata("nullableFloatNotEquals.kt")
        public void testNullableFloatNotEquals() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/ieee754/nullableFloatNotEquals.kt");
        }

        @Test
        @TestMetadata("smartCastsForDouble.kt")
        public void testSmartCastsForDouble() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/ieee754/smartCastsForDouble.kt");
        }

        @Test
        @TestMetadata("smartCastsForFloat.kt")
        public void testSmartCastsForFloat() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/ieee754/smartCastsForFloat.kt");
        }

        @Test
        @TestMetadata("when.kt")
        public void testWhen() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/ieee754/when.kt");
        }

        @Test
        @TestMetadata("whenNullableSmartCast.kt")
        public void testWhenNullableSmartCast() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/ieee754/whenNullableSmartCast.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/inline")
    @TestDataPath("$PROJECT_ROOT")
    public class Inline {
        @Test
        public void testAllFilesPresentInInline() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/inline"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("defaultLambda.kt")
        public void testDefaultLambda() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inline/defaultLambda.kt");
        }

        @Test
        @TestMetadata("deleteClassOnTransformation.kt")
        public void testDeleteClassOnTransformation() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inline/deleteClassOnTransformation.kt");
        }

        @Test
        @TestMetadata("finallyMarkers.kt")
        public void testFinallyMarkers() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inline/finallyMarkers.kt");
        }

        @Test
        @TestMetadata("inlineArgumentSlots.kt")
        public void testInlineArgumentSlots() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inline/inlineArgumentSlots.kt");
        }

        @Test
        @TestMetadata("inlineReturnsNothing1.kt")
        public void testInlineReturnsNothing1() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inline/inlineReturnsNothing1.kt");
        }

        @Test
        @TestMetadata("inlineReturnsNothing2.kt")
        public void testInlineReturnsNothing2() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inline/inlineReturnsNothing2.kt");
        }

        @Test
        @TestMetadata("inlineReturnsNothing3.kt")
        public void testInlineReturnsNothing3() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inline/inlineReturnsNothing3.kt");
        }

        @Test
        @TestMetadata("inlineSuspendReifiedNoSpilling.kt")
        public void testInlineSuspendReifiedNoSpilling() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inline/inlineSuspendReifiedNoSpilling.kt");
        }

        @Test
        @TestMetadata("interfaceDefaultMethod.kt")
        public void testInterfaceDefaultMethod() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inline/interfaceDefaultMethod.kt");
        }

        @Test
        @TestMetadata("linenumberForOneParametersArgumentCall.kt")
        public void testLinenumberForOneParametersArgumentCall() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inline/linenumberForOneParametersArgumentCall.kt");
        }

        @Test
        @TestMetadata("noFakeVariableForInlineOnlyFun.kt")
        public void testNoFakeVariableForInlineOnlyFun() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inline/noFakeVariableForInlineOnlyFun.kt");
        }

        @Test
        @TestMetadata("noFakeVariableForInlineOnlyFunFromStdlib.kt")
        public void testNoFakeVariableForInlineOnlyFunFromStdlib() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inline/noFakeVariableForInlineOnlyFunFromStdlib.kt");
        }

        @Test
        @TestMetadata("noFakeVariableForInlineOnlyFunMap.kt")
        public void testNoFakeVariableForInlineOnlyFunMap() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inline/noFakeVariableForInlineOnlyFunMap.kt");
        }

        @Test
        @TestMetadata("noFakeVariableForInlineOnlyFunWithLambda.kt")
        public void testNoFakeVariableForInlineOnlyFunWithLambda() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inline/noFakeVariableForInlineOnlyFunWithLambda.kt");
        }

        @Test
        @TestMetadata("noSynAccessor.kt")
        public void testNoSynAccessor() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inline/noSynAccessor.kt");
        }

        @Test
        @TestMetadata("noSynAccessorToDirectFieldAccess.kt")
        public void testNoSynAccessorToDirectFieldAccess() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inline/noSynAccessorToDirectFieldAccess.kt");
        }

        @Test
        @TestMetadata("noSynAccessorToSuper.kt")
        public void testNoSynAccessorToSuper() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inline/noSynAccessorToSuper.kt");
        }

        @Test
        @TestMetadata("notSplitedExceptionTable.kt")
        public void testNotSplitedExceptionTable() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inline/notSplitedExceptionTable.kt");
        }

        @Test
        @TestMetadata("reifiedSafeAsWithMutable.kt")
        public void testReifiedSafeAsWithMutable() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inline/reifiedSafeAsWithMutable.kt");
        }

        @Test
        @TestMetadata("remappedLocalVar.kt")
        public void testRemappedLocalVar() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inline/remappedLocalVar.kt");
        }

        @Test
        @TestMetadata("removedFinallyMarkers.kt")
        public void testRemovedFinallyMarkers() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inline/removedFinallyMarkers.kt");
        }

        @Test
        @TestMetadata("specialEnumFunction.kt")
        public void testSpecialEnumFunction() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inline/specialEnumFunction.kt");
        }

        @Test
        @TestMetadata("splitedExceptionTable.kt")
        public void testSplitedExceptionTable() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inline/splitedExceptionTable.kt");
        }

        @Test
        @TestMetadata("whenMappingOnCallSite.kt")
        public void testWhenMappingOnCallSite() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inline/whenMappingOnCallSite.kt");
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/bytecodeText/inline/property")
        @TestDataPath("$PROJECT_ROOT")
        public class Property {
            @Test
            public void testAllFilesPresentInProperty() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/inline/property"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("simple.kt")
            public void testSimple() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/inline/property/simple.kt");
            }
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/inlineArgsInPlace")
    @TestDataPath("$PROJECT_ROOT")
    public class InlineArgsInPlace {
        @Test
        public void testAllFilesPresentInInlineArgsInPlace() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/inlineArgsInPlace"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("kotlinMathMax.kt")
        public void testKotlinMathMax() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineArgsInPlace/kotlinMathMax.kt");
        }

        @Test
        @TestMetadata("println.kt")
        public void testPrintln() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineArgsInPlace/println.kt");
        }

        @Test
        @TestMetadata("sin.kt")
        public void testSin() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineArgsInPlace/sin.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/inlineClasses")
    @TestDataPath("$PROJECT_ROOT")
    public class InlineClasses {
        @Test
        public void testAllFilesPresentInInlineClasses() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/inlineClasses"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("asCastForInlineClass.kt")
        public void testAsCastForInlineClass() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/asCastForInlineClass.kt");
        }

        @Test
        @TestMetadata("assertionsForParametersOfInlineClassTypes.kt")
        public void testAssertionsForParametersOfInlineClassTypes() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/assertionsForParametersOfInlineClassTypes.kt");
        }

        @Test
        @TestMetadata("boxInlineClassInsideElvisWithNullConstant.kt")
        public void testBoxInlineClassInsideElvisWithNullConstant() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/boxInlineClassInsideElvisWithNullConstant.kt");
        }

        @Test
        @TestMetadata("boxInlineClassesOnPassingToVarargs.kt")
        public void testBoxInlineClassesOnPassingToVarargs() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/boxInlineClassesOnPassingToVarargs.kt");
        }

        @Test
        @TestMetadata("boxMethodCalledByInlineClass.kt")
        public void testBoxMethodCalledByInlineClass() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/boxMethodCalledByInlineClass.kt");
        }

        @Test
        @TestMetadata("boxResultAfterConstructorCall.kt")
        public void testBoxResultAfterConstructorCall() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/boxResultAfterConstructorCall.kt");
        }

        @Test
        @TestMetadata("boxResultInlineClassOfConstructorCall.kt")
        public void testBoxResultInlineClassOfConstructorCall() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/boxResultInlineClassOfConstructorCall.kt");
        }

        @Test
        @TestMetadata("boxThisOfInlineClass.kt")
        public void testBoxThisOfInlineClass() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/boxThisOfInlineClass.kt");
        }

        @Test
        @TestMetadata("boxUnboxInlineClassFromMethodReturnType.kt")
        public void testBoxUnboxInlineClassFromMethodReturnType() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/boxUnboxInlineClassFromMethodReturnType.kt");
        }

        @Test
        @TestMetadata("boxUnboxInsideLambdaAsLastExpression.kt")
        public void testBoxUnboxInsideLambdaAsLastExpression() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/boxUnboxInsideLambdaAsLastExpression.kt");
        }

        @Test
        @TestMetadata("boxUnboxOfInlineClassesWithFunctionalTypes.kt")
        public void testBoxUnboxOfInlineClassesWithFunctionalTypes() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/boxUnboxOfInlineClassesWithFunctionalTypes.kt");
        }

        @Test
        @TestMetadata("boxUnboxOnInlinedParameters.kt")
        public void testBoxUnboxOnInlinedParameters() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/boxUnboxOnInlinedParameters.kt");
        }

        @Test
        @TestMetadata("boxingForNonLocalAndLabeledReturnsOfInlineClasses.kt")
        public void testBoxingForNonLocalAndLabeledReturnsOfInlineClasses() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/boxingForNonLocalAndLabeledReturnsOfInlineClasses.kt");
        }

        @Test
        @TestMetadata("callMemberMethodsInsideInlineClass.kt")
        public void testCallMemberMethodsInsideInlineClass() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/callMemberMethodsInsideInlineClass.kt");
        }

        @Test
        @TestMetadata("checkBoxingInInlineClass.kt")
        public void testCheckBoxingInInlineClass() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/checkBoxingInInlineClass.kt");
        }

        @Test
        @TestMetadata("checkOuterInlineFunctionCall.kt")
        public void testCheckOuterInlineFunctionCall() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/checkOuterInlineFunctionCall.kt");
        }

        @Test
        @TestMetadata("constructorBridge.kt")
        public void testConstructorBridge() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/constructorBridge.kt");
        }

        @Test
        @TestMetadata("constructorWithDefaultArguments.kt")
        public void testConstructorWithDefaultArguments() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/constructorWithDefaultArguments.kt");
        }

        @Test
        @TestMetadata("defaultParametersDontBox.kt")
        public void testDefaultParametersDontBox() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/defaultParametersDontBox.kt");
        }

        @Test
        @TestMetadata("delegatedPropertyMangling.kt")
        public void testDelegatedPropertyMangling() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/delegatedPropertyMangling.kt");
        }

        @Test
        @TestMetadata("equalsDoesNotBox.kt")
        public void testEqualsDoesNotBox() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/equalsDoesNotBox.kt");
        }

        @Test
        @TestMetadata("equalsIsCalledByInlineClass.kt")
        public void testEqualsIsCalledByInlineClass() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/equalsIsCalledByInlineClass.kt");
        }

        @Test
        @TestMetadata("factoryMethodForSecondaryConstructorsCalledByInlineClass.kt")
        public void testFactoryMethodForSecondaryConstructorsCalledByInlineClass() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/factoryMethodForSecondaryConstructorsCalledByInlineClass.kt");
        }

        @Test
        @TestMetadata("functionsWithInlineClassParametersHaveStableMangledNames.kt")
        public void testFunctionsWithInlineClassParametersHaveStableMangledNames() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/functionsWithInlineClassParametersHaveStableMangledNames.kt");
        }

        @Test
        @TestMetadata("generationOfAccessorToUnderlyingValue.kt")
        public void testGenerationOfAccessorToUnderlyingValue() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/generationOfAccessorToUnderlyingValue.kt");
        }

        @Test
        @TestMetadata("genericNoUnbox.kt")
        public void testGenericNoUnbox() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/genericNoUnbox.kt");
        }

        @Test
        @TestMetadata("hashCodeIsCalledByInlineClass.kt")
        public void testHashCodeIsCalledByInlineClass() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/hashCodeIsCalledByInlineClass.kt");
        }

        @Test
        @TestMetadata("inlineClassBoxingOnAssignment.kt")
        public void testInlineClassBoxingOnAssignment() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/inlineClassBoxingOnAssignment.kt");
        }

        @Test
        @TestMetadata("inlineClassBoxingOnFunctionCall.kt")
        public void testInlineClassBoxingOnFunctionCall() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/inlineClassBoxingOnFunctionCall.kt");
        }

        @Test
        @TestMetadata("inlineClassBoxingUnboxingInsideInlinedLambda.kt")
        public void testInlineClassBoxingUnboxingInsideInlinedLambda() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/inlineClassBoxingUnboxingInsideInlinedLambda.kt");
        }

        @Test
        @TestMetadata("inlineClassInGeneratedToString.kt")
        public void testInlineClassInGeneratedToString() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/inlineClassInGeneratedToString.kt");
        }

        @Test
        @TestMetadata("inlineClassInStringTemplate.kt")
        public void testInlineClassInStringTemplate() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/inlineClassInStringTemplate.kt");
        }

        @Test
        @TestMetadata("inlineClassesUnboxingAfterAssertionOperator.kt")
        public void testInlineClassesUnboxingAfterAssertionOperator() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/inlineClassesUnboxingAfterAssertionOperator.kt");
        }

        @Test
        @TestMetadata("interfaceDefaultImplStubs.kt")
        public void testInterfaceDefaultImplStubs() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/interfaceDefaultImplStubs.kt");
        }

        @Test
        @TestMetadata("interfaceJvmDefaultImplStubs.kt")
        public void testInterfaceJvmDefaultImplStubs() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/interfaceJvmDefaultImplStubs.kt");
        }

        @Test
        @TestMetadata("isCheckForInlineClass.kt")
        public void testIsCheckForInlineClass() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/isCheckForInlineClass.kt");
        }

        @Test
        @TestMetadata("mangledInlineClassInterfaceImplementation.kt")
        public void testMangledInlineClassInterfaceImplementation() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/mangledInlineClassInterfaceImplementation.kt");
        }

        @Test
        @TestMetadata("mangledSamWrappers.kt")
        public void testMangledSamWrappers() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/mangledSamWrappers.kt");
        }

        @Test
        @TestMetadata("mangledSamWrappersIndy.kt")
        public void testMangledSamWrappersIndy() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/mangledSamWrappersIndy.kt");
        }

        @Test
        @TestMetadata("mangledSamWrappersOld.kt")
        public void testMangledSamWrappersOld() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/mangledSamWrappersOld.kt");
        }

        @Test
        @TestMetadata("noActualCallsOfInlineFunctionsOfInlineClass.kt")
        public void testNoActualCallsOfInlineFunctionsOfInlineClass() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/noActualCallsOfInlineFunctionsOfInlineClass.kt");
        }

        @Test
        @TestMetadata("noAssertionsForInlineClassesBasedOnNullableTypes.kt")
        public void testNoAssertionsForInlineClassesBasedOnNullableTypes() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/noAssertionsForInlineClassesBasedOnNullableTypes.kt");
        }

        @Test
        @TestMetadata("noBoxingInMethod.kt")
        public void testNoBoxingInMethod() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/noBoxingInMethod.kt");
        }

        @Test
        @TestMetadata("noBoxingOnCastOperations.kt")
        public void testNoBoxingOnCastOperations() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/noBoxingOnCastOperations.kt");
        }

        @Test
        @TestMetadata("noBoxingOperationsOnNonTrivialSpread.kt")
        public void testNoBoxingOperationsOnNonTrivialSpread() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/noBoxingOperationsOnNonTrivialSpread.kt");
        }

        @Test
        @TestMetadata("noBoxingUnboxingInAccessorsForDelegatedPropertyWithInlineClassDelegate.kt")
        public void testNoBoxingUnboxingInAccessorsForDelegatedPropertyWithInlineClassDelegate() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/noBoxingUnboxingInAccessorsForDelegatedPropertyWithInlineClassDelegate.kt");
        }

        @Test
        @TestMetadata("noManglingForFunctionsWithJvmName.kt")
        public void testNoManglingForFunctionsWithJvmName() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/noManglingForFunctionsWithJvmName.kt");
        }

        @Test
        @TestMetadata("noReturnTypeMangling.kt")
        public void testNoReturnTypeMangling() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/noReturnTypeMangling.kt");
        }

        @Test
        @TestMetadata("nonOverridingMethodsAreCalledByInlineClass.kt")
        public void testNonOverridingMethodsAreCalledByInlineClass() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/nonOverridingMethodsAreCalledByInlineClass.kt");
        }

        @Test
        @TestMetadata("overridingMethodsAreCalledByInlineClass.kt")
        public void testOverridingMethodsAreCalledByInlineClass() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/overridingMethodsAreCalledByInlineClass.kt");
        }

        @Test
        @TestMetadata("passInlineClassesWithSpreadOperatorToVarargs.kt")
        public void testPassInlineClassesWithSpreadOperatorToVarargs() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/passInlineClassesWithSpreadOperatorToVarargs.kt");
        }

        @Test
        @TestMetadata("primaryConstructorCalledByInlineClass.kt")
        public void testPrimaryConstructorCalledByInlineClass() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/primaryConstructorCalledByInlineClass.kt");
        }

        @Test
        @TestMetadata("propertyAccessorsAreCalledByInlineClass.kt")
        public void testPropertyAccessorsAreCalledByInlineClass() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/propertyAccessorsAreCalledByInlineClass.kt");
        }

        @Test
        @TestMetadata("propertySetterWithInlineClassTypeArgument.kt")
        public void testPropertySetterWithInlineClassTypeArgument() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/propertySetterWithInlineClassTypeArgument.kt");
        }

        @Test
        @TestMetadata("resultApiDoesntCallSpecializedEquals.kt")
        public void testResultApiDoesntCallSpecializedEquals() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/resultApiDoesntCallSpecializedEquals.kt");
        }

        @Test
        @TestMetadata("resultApiDoesntUseBox.kt")
        public void testResultApiDoesntUseBox() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/resultApiDoesntUseBox.kt");
        }

        @Test
        @TestMetadata("resultApiEqualsDoesntBox.kt")
        public void testResultApiEqualsDoesntBox() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/resultApiEqualsDoesntBox.kt");
        }

        @Test
        @TestMetadata("resultApiRunCatchingDoesntBox.kt")
        public void testResultApiRunCatchingDoesntBox() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/resultApiRunCatchingDoesntBox.kt");
        }

        @Test
        @TestMetadata("resultApiStringInterpolationDoesntBox.kt")
        public void testResultApiStringInterpolationDoesntBox() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/resultApiStringInterpolationDoesntBox.kt");
        }

        @Test
        @TestMetadata("resultMangling.kt")
        public void testResultMangling() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/resultMangling.kt");
        }

        @Test
        @TestMetadata("skipCallToUnderlyingValueOfInlineClass.kt")
        public void testSkipCallToUnderlyingValueOfInlineClass() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/skipCallToUnderlyingValueOfInlineClass.kt");
        }

        @Test
        @TestMetadata("suspendFunctionMangling.kt")
        public void testSuspendFunctionMangling() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/suspendFunctionMangling.kt");
        }

        @Test
        @TestMetadata("toStringOfInlineClassValue.kt")
        public void testToStringOfInlineClassValue() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/toStringOfInlineClassValue.kt");
        }

        @Test
        @TestMetadata("toStringOfReferenceInlineClassValue.kt")
        public void testToStringOfReferenceInlineClassValue() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/toStringOfReferenceInlineClassValue.kt");
        }

        @Test
        @TestMetadata("uIntArrayIteratorWithoutBoxing.kt")
        public void testUIntArrayIteratorWithoutBoxing() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/uIntArrayIteratorWithoutBoxing.kt");
        }

        @Test
        @TestMetadata("uIntArraySwapBoxing.kt")
        public void testUIntArraySwapBoxing() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/uIntArraySwapBoxing.kt");
        }

        @Test
        @TestMetadata("unboxInlineClassAfterElvis.kt")
        public void testUnboxInlineClassAfterElvis() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/unboxInlineClassAfterElvis.kt");
        }

        @Test
        @TestMetadata("unboxInlineClassAfterSafeCall.kt")
        public void testUnboxInlineClassAfterSafeCall() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/unboxInlineClassAfterSafeCall.kt");
        }

        @Test
        @TestMetadata("unboxInlineClassFromParameterizedType.kt")
        public void testUnboxInlineClassFromParameterizedType() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/unboxInlineClassFromParameterizedType.kt");
        }

        @Test
        @TestMetadata("unboxInlineClassesAfterSmartCasts.kt")
        public void testUnboxInlineClassesAfterSmartCasts() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/unboxInlineClassesAfterSmartCasts.kt");
        }

        @Test
        @TestMetadata("unboxMethodCalledByInlineClass.kt")
        public void testUnboxMethodCalledByInlineClass() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/inlineClasses/unboxMethodCalledByInlineClass.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/innerClasses")
    @TestDataPath("$PROJECT_ROOT")
    public class InnerClasses {
        @Test
        public void testAllFilesPresentInInnerClasses() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/innerClasses"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("nestedClassInAnnotationArgument.kt")
        public void testNestedClassInAnnotationArgument() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/innerClasses/nestedClassInAnnotationArgument.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/interfaces")
    @TestDataPath("$PROJECT_ROOT")
    public class Interfaces {
        @Test
        @TestMetadata("addedInterfaceBridge.kt")
        public void testAddedInterfaceBridge() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/interfaces/addedInterfaceBridge.kt");
        }

        @Test
        public void testAllFilesPresentInInterfaces() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/interfaces"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("firstInheritedMethodIsAbstract.kt")
        public void testFirstInheritedMethodIsAbstract() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/interfaces/firstInheritedMethodIsAbstract.kt");
        }

        @Test
        @TestMetadata("noAnyMethodsOnInterfaceInheritance.kt")
        public void testNoAnyMethodsOnInterfaceInheritance() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/interfaces/noAnyMethodsOnInterfaceInheritance.kt");
        }

        @Test
        @TestMetadata("noNullCheckOnThisInDefaultMethod.kt")
        public void testNoNullCheckOnThisInDefaultMethod() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/interfaces/noNullCheckOnThisInDefaultMethod.kt");
        }

        @Test
        @TestMetadata("noPrivateMemberInJavaInterface.kt")
        public void testNoPrivateMemberInJavaInterface() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/interfaces/noPrivateMemberInJavaInterface.kt");
        }

        @Test
        @TestMetadata("traitImplGeneratedOnce.kt")
        public void testTraitImplGeneratedOnce() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/interfaces/traitImplGeneratedOnce.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/intrinsics")
    @TestDataPath("$PROJECT_ROOT")
    public class Intrinsics {
        @Test
        public void testAllFilesPresentInIntrinsics() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/intrinsics"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("javaObjectType.kt")
        public void testJavaObjectType() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/intrinsics/javaObjectType.kt");
        }

        @Test
        @TestMetadata("javaPrimitiveType.kt")
        public void testJavaPrimitiveType() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/intrinsics/javaPrimitiveType.kt");
        }

        @Test
        @TestMetadata("postfixIncrDecr.kt")
        public void testPostfixIncrDecr() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/intrinsics/postfixIncrDecr.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/intrinsicsCompare")
    @TestDataPath("$PROJECT_ROOT")
    public class IntrinsicsCompare {
        @Test
        public void testAllFilesPresentInIntrinsicsCompare() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/intrinsicsCompare"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("byteSmartCast_after.kt")
        public void testByteSmartCast_after() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/intrinsicsCompare/byteSmartCast_after.kt");
        }

        @Test
        @TestMetadata("byteSmartCast_before.kt")
        public void testByteSmartCast_before() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/intrinsicsCompare/byteSmartCast_before.kt");
        }

        @Test
        @TestMetadata("charSmartCast.kt")
        public void testCharSmartCast() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/intrinsicsCompare/charSmartCast.kt");
        }

        @Test
        @TestMetadata("differentTypes_after.kt")
        public void testDifferentTypes_after() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/intrinsicsCompare/differentTypes_after.kt");
        }

        @Test
        @TestMetadata("differentTypes_before.kt")
        public void testDifferentTypes_before() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/intrinsicsCompare/differentTypes_before.kt");
        }

        @Test
        @TestMetadata("intSmartCast_after.kt")
        public void testIntSmartCast_after() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/intrinsicsCompare/intSmartCast_after.kt");
        }

        @Test
        @TestMetadata("intSmartCast_before.kt")
        public void testIntSmartCast_before() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/intrinsicsCompare/intSmartCast_before.kt");
        }

        @Test
        @TestMetadata("longSmartCast.kt")
        public void testLongSmartCast() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/intrinsicsCompare/longSmartCast.kt");
        }

        @Test
        @TestMetadata("shortSmartCast_after.kt")
        public void testShortSmartCast_after() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/intrinsicsCompare/shortSmartCast_after.kt");
        }

        @Test
        @TestMetadata("shortSmartCast_before.kt")
        public void testShortSmartCast_before() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/intrinsicsCompare/shortSmartCast_before.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/intrinsicsTrim")
    @TestDataPath("$PROJECT_ROOT")
    public class IntrinsicsTrim {
        @Test
        public void testAllFilesPresentInIntrinsicsTrim() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/intrinsicsTrim"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("trimIndentNegative.kt")
        public void testTrimIndentNegative() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/intrinsicsTrim/trimIndentNegative.kt");
        }

        @Test
        @TestMetadata("trimIndentPositive.kt")
        public void testTrimIndentPositive() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/intrinsicsTrim/trimIndentPositive.kt");
        }

        @Test
        @TestMetadata("trimMarginNegative.kt")
        public void testTrimMarginNegative() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/intrinsicsTrim/trimMarginNegative.kt");
        }

        @Test
        @TestMetadata("trimMarginPositive.kt")
        public void testTrimMarginPositive() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/intrinsicsTrim/trimMarginPositive.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/invokedynamic")
    @TestDataPath("$PROJECT_ROOT")
    public class Invokedynamic {
        @Test
        public void testAllFilesPresentInInvokedynamic() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/invokedynamic"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("functionRefToJavaInterface.kt")
        public void testFunctionRefToJavaInterface() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/invokedynamic/functionRefToJavaInterface.kt");
        }

        @Test
        @TestMetadata("lambdas.kt")
        public void testLambdas() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/invokedynamic/lambdas.kt");
        }

        @Test
        @TestMetadata("streamApi.kt")
        public void testStreamApi() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/invokedynamic/streamApi.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/jvm8")
    @TestDataPath("$PROJECT_ROOT")
    public class Jvm8 {
        @Test
        public void testAllFilesPresentInJvm8() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/jvm8"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/bytecodeText/jvm8/hashCode")
        @TestDataPath("$PROJECT_ROOT")
        public class HashCode {
            @Test
            public void testAllFilesPresentInHashCode() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/jvm8/hashCode"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("dataClass.kt")
            public void testDataClass() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/jvm8/hashCode/dataClass.kt");
            }

            @Test
            @TestMetadata("hashCode.kt")
            public void testHashCode() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/jvm8/hashCode/hashCode.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/bytecodeText/jvm8/jvmDefault")
        @TestDataPath("$PROJECT_ROOT")
        public class JvmDefault {
            @Test
            public void testAllFilesPresentInJvmDefault() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/jvm8/jvmDefault"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Nested
            @TestMetadata("compiler/testData/codegen/bytecodeText/jvm8/jvmDefault/allCompatibility")
            @TestDataPath("$PROJECT_ROOT")
            public class AllCompatibility {
                @Test
                public void testAllFilesPresentInAllCompatibility() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/jvm8/jvmDefault/allCompatibility"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
                }

                @Test
                @TestMetadata("defaultArgs.kt")
                public void testDefaultArgs() throws Exception {
                    runTest("compiler/testData/codegen/bytecodeText/jvm8/jvmDefault/allCompatibility/defaultArgs.kt");
                }

                @Test
                @TestMetadata("simpleDiamond.kt")
                public void testSimpleDiamond() throws Exception {
                    runTest("compiler/testData/codegen/bytecodeText/jvm8/jvmDefault/allCompatibility/simpleDiamond.kt");
                }

                @Test
                @TestMetadata("simpleFunction.kt")
                public void testSimpleFunction() throws Exception {
                    runTest("compiler/testData/codegen/bytecodeText/jvm8/jvmDefault/allCompatibility/simpleFunction.kt");
                }

                @Test
                @TestMetadata("simpleFunctionWithAbstractOverride.kt")
                public void testSimpleFunctionWithAbstractOverride() throws Exception {
                    runTest("compiler/testData/codegen/bytecodeText/jvm8/jvmDefault/allCompatibility/simpleFunctionWithAbstractOverride.kt");
                }

                @Test
                @TestMetadata("simpleProperty.kt")
                public void testSimpleProperty() throws Exception {
                    runTest("compiler/testData/codegen/bytecodeText/jvm8/jvmDefault/allCompatibility/simpleProperty.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/testData/codegen/bytecodeText/jvm8/jvmDefault/compatibility")
            @TestDataPath("$PROJECT_ROOT")
            public class Compatibility {
                @Test
                public void testAllFilesPresentInCompatibility() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/jvm8/jvmDefault/compatibility"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
                }

                @Test
                @TestMetadata("defaultArgs.kt")
                public void testDefaultArgs() throws Exception {
                    runTest("compiler/testData/codegen/bytecodeText/jvm8/jvmDefault/compatibility/defaultArgs.kt");
                }

                @Test
                @TestMetadata("simpleDiamond.kt")
                public void testSimpleDiamond() throws Exception {
                    runTest("compiler/testData/codegen/bytecodeText/jvm8/jvmDefault/compatibility/simpleDiamond.kt");
                }

                @Test
                @TestMetadata("simpleFunction.kt")
                public void testSimpleFunction() throws Exception {
                    runTest("compiler/testData/codegen/bytecodeText/jvm8/jvmDefault/compatibility/simpleFunction.kt");
                }

                @Test
                @TestMetadata("simpleFunctionWithAbstractOverride.kt")
                public void testSimpleFunctionWithAbstractOverride() throws Exception {
                    runTest("compiler/testData/codegen/bytecodeText/jvm8/jvmDefault/compatibility/simpleFunctionWithAbstractOverride.kt");
                }

                @Test
                @TestMetadata("simpleProperty.kt")
                public void testSimpleProperty() throws Exception {
                    runTest("compiler/testData/codegen/bytecodeText/jvm8/jvmDefault/compatibility/simpleProperty.kt");
                }
            }
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/lazyCodegen")
    @TestDataPath("$PROJECT_ROOT")
    public class LazyCodegen {
        @Test
        public void testAllFilesPresentInLazyCodegen() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/lazyCodegen"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("inlineConstInsideComparison.kt")
        public void testInlineConstInsideComparison() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/lazyCodegen/inlineConstInsideComparison.kt");
        }

        @Test
        @TestMetadata("negateConst.kt")
        public void testNegateConst() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/lazyCodegen/negateConst.kt");
        }

        @Test
        @TestMetadata("negateObjectComp.kt")
        public void testNegateObjectComp() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/lazyCodegen/negateObjectComp.kt");
        }

        @Test
        @TestMetadata("negateObjectCompChaing.kt")
        public void testNegateObjectCompChaing() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/lazyCodegen/negateObjectCompChaing.kt");
        }

        @Test
        @TestMetadata("negateVar.kt")
        public void testNegateVar() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/lazyCodegen/negateVar.kt");
        }

        @Test
        @TestMetadata("negateVarChain.kt")
        public void testNegateVarChain() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/lazyCodegen/negateVarChain.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/lineNumbers")
    @TestDataPath("$PROJECT_ROOT")
    public class LineNumbers {
        @Test
        public void testAllFilesPresentInLineNumbers() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/lineNumbers"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("ifConsts.kt")
        public void testIfConsts() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/lineNumbers/ifConsts.kt");
        }

        @Test
        @TestMetadata("ifElse.kt")
        public void testIfElse() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/lineNumbers/ifElse.kt");
        }

        @Test
        @TestMetadata("ifFalse.kt")
        public void testIfFalse() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/lineNumbers/ifFalse.kt");
        }

        @Test
        @TestMetadata("ifFalseElse.kt")
        public void testIfFalseElse() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/lineNumbers/ifFalseElse.kt");
        }

        @Test
        @TestMetadata("ifTrue.kt")
        public void testIfTrue() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/lineNumbers/ifTrue.kt");
        }

        @Test
        @TestMetadata("ifTrueElse.kt")
        public void testIfTrueElse() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/lineNumbers/ifTrueElse.kt");
        }

        @Test
        @TestMetadata("inlineCondition.kt")
        public void testInlineCondition() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/lineNumbers/inlineCondition.kt");
        }

        @Test
        @TestMetadata("inlineCondition2.kt")
        public void testInlineCondition2() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/lineNumbers/inlineCondition2.kt");
        }

        @Test
        @TestMetadata("inlineLambdaObjectInit.kt")
        public void testInlineLambdaObjectInit() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/lineNumbers/inlineLambdaObjectInit.kt");
        }

        @Test
        @TestMetadata("singleThen.kt")
        public void testSingleThen() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/lineNumbers/singleThen.kt");
        }

        @Test
        @TestMetadata("tryCatch.kt")
        public void testTryCatch() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/lineNumbers/tryCatch.kt");
        }

        @Test
        @TestMetadata("tryFinally.kt")
        public void testTryFinally() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/lineNumbers/tryFinally.kt");
        }

        @Test
        @TestMetadata("when.kt")
        public void testWhen() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/lineNumbers/when.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/localInitializationLVT")
    @TestDataPath("$PROJECT_ROOT")
    public class LocalInitializationLVT {
        @Test
        public void testAllFilesPresentInLocalInitializationLVT() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/localInitializationLVT"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("boxing.kt")
        public void testBoxing() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/boxing.kt");
        }

        @Test
        @TestMetadata("boxingVar.kt")
        public void testBoxingVar() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/boxingVar.kt");
        }

        @Test
        @TestMetadata("contract.kt")
        public void testContract() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/contract.kt");
        }

        @Test
        @TestMetadata("contractVar.kt")
        public void testContractVar() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/contractVar.kt");
        }

        @Test
        @TestMetadata("generics.kt")
        public void testGenerics() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/generics.kt");
        }

        @Test
        @TestMetadata("genericsVar.kt")
        public void testGenericsVar() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/genericsVar.kt");
        }

        @Test
        @TestMetadata("ifStatement.kt")
        public void testIfStatement() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/ifStatement.kt");
        }

        @Test
        @TestMetadata("ifStatementVar.kt")
        public void testIfStatementVar() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/ifStatementVar.kt");
        }

        @Test
        @TestMetadata("ifStatementWithoutBlock.kt")
        public void testIfStatementWithoutBlock() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/ifStatementWithoutBlock.kt");
        }

        @Test
        @TestMetadata("ifStatementWithoutBlockVar.kt")
        public void testIfStatementWithoutBlockVar() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/ifStatementWithoutBlockVar.kt");
        }

        @Test
        @TestMetadata("inlineClass.kt")
        public void testInlineClass() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/inlineClass.kt");
        }

        @Test
        @TestMetadata("inlineClassVar.kt")
        public void testInlineClassVar() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/inlineClassVar.kt");
        }

        @Test
        @TestMetadata("lateinit.kt")
        public void testLateinit() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/lateinit.kt");
        }

        @Test
        @TestMetadata("run.kt")
        public void testRun() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/run.kt");
        }

        @Test
        @TestMetadata("runVar.kt")
        public void testRunVar() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/runVar.kt");
        }

        @Test
        @TestMetadata("singleBlock.kt")
        public void testSingleBlock() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/singleBlock.kt");
        }

        @Test
        @TestMetadata("singleBlockVar.kt")
        public void testSingleBlockVar() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/singleBlockVar.kt");
        }

        @Test
        @TestMetadata("whenStatement.kt")
        public void testWhenStatement() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/whenStatement.kt");
        }

        @Test
        @TestMetadata("whenStatementVar.kt")
        public void testWhenStatementVar() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/whenStatementVar.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/mangling")
    @TestDataPath("$PROJECT_ROOT")
    public class Mangling {
        @Test
        public void testAllFilesPresentInMangling() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/mangling"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("parentheses.kt")
        public void testParentheses() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/mangling/parentheses.kt");
        }

        @Test
        @TestMetadata("parenthesesNoSanitize.kt")
        public void testParenthesesNoSanitize() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/mangling/parenthesesNoSanitize.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/multifileClasses")
    @TestDataPath("$PROJECT_ROOT")
    public class MultifileClasses {
        @Test
        public void testAllFilesPresentInMultifileClasses() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/multifileClasses"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("defaultFunctionInMultifileClass.kt")
        public void testDefaultFunctionInMultifileClass() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/multifileClasses/defaultFunctionInMultifileClass.kt");
        }

        @Test
        @TestMetadata("optimizedMultifileClassFacadeMethods.kt")
        public void testOptimizedMultifileClassFacadeMethods() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/multifileClasses/optimizedMultifileClassFacadeMethods.kt");
        }

        @Test
        @TestMetadata("privateFunctionName.kt")
        public void testPrivateFunctionName() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/multifileClasses/privateFunctionName.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/notNullAssertions")
    @TestDataPath("$PROJECT_ROOT")
    public class NotNullAssertions {
        @Test
        public void testAllFilesPresentInNotNullAssertions() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/notNullAssertions"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("arrayListGet.kt")
        public void testArrayListGet() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/notNullAssertions/arrayListGet.kt");
        }

        @Test
        @TestMetadata("assertionForNotNullCaptured.kt")
        public void testAssertionForNotNullCaptured() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/notNullAssertions/assertionForNotNullCaptured.kt");
        }

        @Test
        @TestMetadata("assertionForNotNullTypeParam.kt")
        public void testAssertionForNotNullTypeParam() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/notNullAssertions/assertionForNotNullTypeParam.kt");
        }

        @Test
        @TestMetadata("assertionForNotNullTypeParam_1_4.kt")
        public void testAssertionForNotNullTypeParam_1_4() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/notNullAssertions/assertionForNotNullTypeParam_1_4.kt");
        }

        @Test
        @TestMetadata("doNotGenerateParamAssertions.kt")
        public void testDoNotGenerateParamAssertions() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/notNullAssertions/doNotGenerateParamAssertions.kt");
        }

        @Test
        @TestMetadata("javaMultipleSubstitutions.kt")
        public void testJavaMultipleSubstitutions() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/notNullAssertions/javaMultipleSubstitutions.kt");
        }

        @Test
        @TestMetadata("noAssertionForNullableCaptured.kt")
        public void testNoAssertionForNullableCaptured() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/notNullAssertions/noAssertionForNullableCaptured.kt");
        }

        @Test
        @TestMetadata("noAssertionForNullableGenericMethod.kt")
        public void testNoAssertionForNullableGenericMethod() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/notNullAssertions/noAssertionForNullableGenericMethod.kt");
        }

        @Test
        @TestMetadata("noAssertionForNullableGenericMethodCall.kt")
        public void testNoAssertionForNullableGenericMethodCall() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/notNullAssertions/noAssertionForNullableGenericMethodCall.kt");
        }

        @Test
        @TestMetadata("noAssertionForPrivateMethod.kt")
        public void testNoAssertionForPrivateMethod() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/notNullAssertions/noAssertionForPrivateMethod.kt");
        }

        @Test
        @TestMetadata("noAssertionsForKotlin.kt")
        public void testNoAssertionsForKotlin() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/notNullAssertions/noAssertionsForKotlin.kt");
        }

        @Test
        @TestMetadata("noTemporaryVariableInNullCheckOnExpression.kt")
        public void testNoTemporaryVariableInNullCheckOnExpression() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/notNullAssertions/noTemporaryVariableInNullCheckOnExpression.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/nullCheckOptimization")
    @TestDataPath("$PROJECT_ROOT")
    public class NullCheckOptimization {
        @Test
        public void testAllFilesPresentInNullCheckOptimization() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/nullCheckOptimization"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("alreadyCheckedForIs.kt")
        public void testAlreadyCheckedForIs() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/alreadyCheckedForIs.kt");
        }

        @Test
        @TestMetadata("alreadyCheckedForNull.kt")
        public void testAlreadyCheckedForNull() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/alreadyCheckedForNull.kt");
        }

        @Test
        @TestMetadata("deterministicNotNullChecks.kt")
        public void testDeterministicNotNullChecks() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/deterministicNotNullChecks.kt");
        }

        @Test
        @TestMetadata("exclExclAsNotNullType.kt")
        public void testExclExclAsNotNullType() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/exclExclAsNotNullType.kt");
        }

        @Test
        @TestMetadata("expressionValueIsNotNull.kt")
        public void testExpressionValueIsNotNull() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/expressionValueIsNotNull.kt");
        }

        @Test
        @TestMetadata("expressionValueIsNotNullAfterExclExcl.kt")
        public void testExpressionValueIsNotNullAfterExclExcl() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/expressionValueIsNotNullAfterExclExcl.kt");
        }

        @Test
        @TestMetadata("expressionValueIsNotNullTwice.kt")
        public void testExpressionValueIsNotNullTwice() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/expressionValueIsNotNullTwice.kt");
        }

        @Test
        @TestMetadata("ifNullEqualsNull.kt")
        public void testIfNullEqualsNull() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/ifNullEqualsNull.kt");
        }

        @Test
        @TestMetadata("ifNullEqualsNullInline.kt")
        public void testIfNullEqualsNullInline() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/ifNullEqualsNullInline.kt");
        }

        @Test
        @TestMetadata("ifUnitEqualsNull.kt")
        public void testIfUnitEqualsNull() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/ifUnitEqualsNull.kt");
        }

        @Test
        @TestMetadata("ifUnitEqualsNullInline.kt")
        public void testIfUnitEqualsNullInline() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/ifUnitEqualsNullInline.kt");
        }

        @Test
        @TestMetadata("kt12839.kt")
        public void testKt12839() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/kt12839.kt");
        }

        @Test
        @TestMetadata("multipleExclExcl_1_4.kt")
        public void testMultipleExclExcl_1_4() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/multipleExclExcl_1_4.kt");
        }

        @Test
        @TestMetadata("noNullCheckAfterCast.kt")
        public void testNoNullCheckAfterCast() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/noNullCheckAfterCast.kt");
        }

        @Test
        @TestMetadata("notNullAsNotNullable.kt")
        public void testNotNullAsNotNullable() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/notNullAsNotNullable.kt");
        }

        @Test
        @TestMetadata("notNullExpressionValueTwice_1_4.kt")
        public void testNotNullExpressionValueTwice_1_4() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/notNullExpressionValueTwice_1_4.kt");
        }

        @Test
        @TestMetadata("nullCheckAfterExclExcl_1_4.kt")
        public void testNullCheckAfterExclExcl_1_4() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/nullCheckAfterExclExcl_1_4.kt");
        }

        @Test
        @TestMetadata("nullabilityAssertionOnDispatchReceiver.kt")
        public void testNullabilityAssertionOnDispatchReceiver() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/nullabilityAssertionOnDispatchReceiver.kt");
        }

        @Test
        @TestMetadata("primitiveCheck.kt")
        public void testPrimitiveCheck() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/primitiveCheck.kt");
        }

        @Test
        @TestMetadata("redundantSafeCall.kt")
        public void testRedundantSafeCall() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/redundantSafeCall.kt");
        }

        @Test
        @TestMetadata("redundantSafeCall_1_4.kt")
        public void testRedundantSafeCall_1_4() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/redundantSafeCall_1_4.kt");
        }

        @Test
        @TestMetadata("reifiedIs.kt")
        public void testReifiedIs() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/reifiedIs.kt");
        }

        @Test
        @TestMetadata("reifiedNullIs.kt")
        public void testReifiedNullIs() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/reifiedNullIs.kt");
        }

        @Test
        @TestMetadata("safeCallAndElvisChains.kt")
        public void testSafeCallAndElvisChains() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/safeCallAndElvisChains.kt");
        }

        @Test
        @TestMetadata("trivialInstanceOf.kt")
        public void testTrivialInstanceOf() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/trivialInstanceOf.kt");
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/bytecodeText/nullCheckOptimization/localLateinit")
        @TestDataPath("$PROJECT_ROOT")
        public class LocalLateinit {
            @Test
            public void testAllFilesPresentInLocalLateinit() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/nullCheckOptimization/localLateinit"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("checkedAlways.kt")
            public void testCheckedAlways() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/localLateinit/checkedAlways.kt");
            }

            @Test
            @TestMetadata("checkedOnce.kt")
            public void testCheckedOnce() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/localLateinit/checkedOnce.kt");
            }

            @Test
            @TestMetadata("initialized.kt")
            public void testInitialized() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/localLateinit/initialized.kt");
            }
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/optimizedDelegatedProperties")
    @TestDataPath("$PROJECT_ROOT")
    public class OptimizedDelegatedProperties {
        @Test
        public void testAllFilesPresentInOptimizedDelegatedProperties() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/optimizedDelegatedProperties"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("definedInSources.kt")
        public void testDefinedInSources() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/optimizedDelegatedProperties/definedInSources.kt");
        }

        @Test
        @TestMetadata("delegateToAnother.kt")
        public void testDelegateToAnother() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/optimizedDelegatedProperties/delegateToAnother.kt");
        }

        @Test
        @TestMetadata("inSeparateModule.kt")
        public void testInSeparateModule() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/optimizedDelegatedProperties/inSeparateModule.kt");
        }

        @Test
        @TestMetadata("lazy.kt")
        public void testLazy() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/optimizedDelegatedProperties/lazy.kt");
        }

        @Test
        @TestMetadata("withNonNullMetadataParameter.kt")
        public void testWithNonNullMetadataParameter() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/optimizedDelegatedProperties/withNonNullMetadataParameter.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/outerClass")
    @TestDataPath("$PROJECT_ROOT")
    public class OuterClass {
        @Test
        public void testAllFilesPresentInOuterClass() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/outerClass"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("classInClinit.kt")
        public void testClassInClinit() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/outerClass/classInClinit.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/parameterlessMain")
    @TestDataPath("$PROJECT_ROOT")
    public class ParameterlessMain {
        @Test
        public void testAllFilesPresentInParameterlessMain() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/parameterlessMain"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("dontGenerateOnExtensionReceiver.kt")
        public void testDontGenerateOnExtensionReceiver() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/parameterlessMain/dontGenerateOnExtensionReceiver.kt");
        }

        @Test
        @TestMetadata("dontGenerateOnJvmNameMain.kt")
        public void testDontGenerateOnJvmNameMain() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/parameterlessMain/dontGenerateOnJvmNameMain.kt");
        }

        @Test
        @TestMetadata("dontGenerateOnJvmOverloads.kt")
        public void testDontGenerateOnJvmOverloads() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/parameterlessMain/dontGenerateOnJvmOverloads.kt");
        }

        @Test
        @TestMetadata("dontGenerateOnMain.kt")
        public void testDontGenerateOnMain() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/parameterlessMain/dontGenerateOnMain.kt");
        }

        @Test
        @TestMetadata("dontGenerateOnMainExtension.kt")
        public void testDontGenerateOnMainExtension() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/parameterlessMain/dontGenerateOnMainExtension.kt");
        }

        @Test
        @TestMetadata("dontGenerateOnNullableArray.kt")
        public void testDontGenerateOnNullableArray() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/parameterlessMain/dontGenerateOnNullableArray.kt");
        }

        @Test
        @TestMetadata("dontGenerateOnNullableString.kt")
        public void testDontGenerateOnNullableString() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/parameterlessMain/dontGenerateOnNullableString.kt");
        }

        @Test
        @TestMetadata("dontGenerateOnVarargsString.kt")
        public void testDontGenerateOnVarargsString() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/parameterlessMain/dontGenerateOnVarargsString.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/properties")
    @TestDataPath("$PROJECT_ROOT")
    public class Properties {
        @Test
        public void testAllFilesPresentInProperties() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/properties"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("dataClass.kt")
        public void testDataClass() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/properties/dataClass.kt");
        }

        @Test
        @TestMetadata("openDataClass.kt")
        public void testOpenDataClass() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/properties/openDataClass.kt");
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/bytecodeText/properties/lateinit")
        @TestDataPath("$PROJECT_ROOT")
        public class Lateinit {
            @Test
            public void testAllFilesPresentInLateinit() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/properties/lateinit"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("companionObject.kt")
            public void testCompanionObject() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/properties/lateinit/companionObject.kt");
            }

            @Test
            @TestMetadata("companionObjectFromLambda.kt")
            public void testCompanionObjectFromLambda() throws Exception {
                runTest("compiler/testData/codegen/bytecodeText/properties/lateinit/companionObjectFromLambda.kt");
            }
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/ranges")
    @TestDataPath("$PROJECT_ROOT")
    public class Ranges {
        @Test
        public void testAllFilesPresentInRanges() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/ranges"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("ifNotInRange.kt")
        public void testIfNotInRange() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/ranges/ifNotInRange.kt");
        }

        @Test
        @TestMetadata("inArrayIndices.kt")
        public void testInArrayIndices() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/ranges/inArrayIndices.kt");
        }

        @Test
        @TestMetadata("inCharSequenceIndices.kt")
        public void testInCharSequenceIndices() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/ranges/inCharSequenceIndices.kt");
        }

        @Test
        @TestMetadata("inCollectionIndices.kt")
        public void testInCollectionIndices() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/ranges/inCollectionIndices.kt");
        }

        @Test
        @TestMetadata("inComparableRangeLiteral.kt")
        public void testInComparableRangeLiteral() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/ranges/inComparableRangeLiteral.kt");
        }

        @Test
        @TestMetadata("inMixedUnsignedRange.kt")
        public void testInMixedUnsignedRange() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/ranges/inMixedUnsignedRange.kt");
        }

        @Test
        @TestMetadata("inMixedUnsignedRange_2.kt")
        public void testInMixedUnsignedRange_2() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/ranges/inMixedUnsignedRange_2.kt");
        }

        @Test
        @TestMetadata("inNonMatchingRangeIntrinsified.kt")
        public void testInNonMatchingRangeIntrinsified() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/ranges/inNonMatchingRangeIntrinsified.kt");
        }

        @Test
        @TestMetadata("inOptimizableRange.kt")
        public void testInOptimizableRange() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/ranges/inOptimizableRange.kt");
        }

        @Test
        @TestMetadata("inOptimizableUnsignedRange.kt")
        public void testInOptimizableUnsignedRange() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/ranges/inOptimizableUnsignedRange.kt");
        }

        @Test
        @TestMetadata("inUntil.kt")
        public void testInUntil() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/ranges/inUntil.kt");
        }

        @Test
        @TestMetadata("noDupXForLiteralRangeContains.kt")
        public void testNoDupXForLiteralRangeContains() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/ranges/noDupXForLiteralRangeContains.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/sam")
    @TestDataPath("$PROJECT_ROOT")
    public class Sam {
        @Test
        public void testAllFilesPresentInSam() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/sam"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("samWrapperForNullInitialization.kt")
        public void testSamWrapperForNullInitialization() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/sam/samWrapperForNullInitialization.kt");
        }

        @Test
        @TestMetadata("samWrapperForNullableInitialization.kt")
        public void testSamWrapperForNullableInitialization() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/sam/samWrapperForNullableInitialization.kt");
        }

        @Test
        @TestMetadata("samWrapperInInlineLambda.kt")
        public void testSamWrapperInInlineLambda() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/sam/samWrapperInInlineLambda.kt");
        }

        @Test
        @TestMetadata("samWrapperInInlineLambda2.kt")
        public void testSamWrapperInInlineLambda2() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/sam/samWrapperInInlineLambda2.kt");
        }

        @Test
        @TestMetadata("samWrapperOfLambda.kt")
        public void testSamWrapperOfLambda() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/sam/samWrapperOfLambda.kt");
        }

        @Test
        @TestMetadata("samWrapperOfReference.kt")
        public void testSamWrapperOfReference() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/sam/samWrapperOfReference.kt");
        }

        @Test
        @TestMetadata("samWrapperRawTypes.kt")
        public void testSamWrapperRawTypes() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/sam/samWrapperRawTypes.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/statements")
    @TestDataPath("$PROJECT_ROOT")
    public class Statements {
        @Test
        public void testAllFilesPresentInStatements() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/statements"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("ifSingleBranch.kt")
        public void testIfSingleBranch() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/statements/ifSingleBranch.kt");
        }

        @Test
        @TestMetadata("ifThenElse.kt")
        public void testIfThenElse() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/statements/ifThenElse.kt");
        }

        @Test
        @TestMetadata("ifThenElseEmpty.kt")
        public void testIfThenElseEmpty() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/statements/ifThenElseEmpty.kt");
        }

        @Test
        @TestMetadata("labeled.kt")
        public void testLabeled() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/statements/labeled.kt");
        }

        @Test
        @TestMetadata("statementsComposition.kt")
        public void testStatementsComposition() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/statements/statementsComposition.kt");
        }

        @Test
        @TestMetadata("tryCatchFinally.kt")
        public void testTryCatchFinally() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/statements/tryCatchFinally.kt");
        }

        @Test
        @TestMetadata("when.kt")
        public void testWhen() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/statements/when.kt");
        }

        @Test
        @TestMetadata("whenSubject.kt")
        public void testWhenSubject() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/statements/whenSubject.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/staticFields")
    @TestDataPath("$PROJECT_ROOT")
    public class StaticFields {
        @Test
        public void testAllFilesPresentInStaticFields() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/staticFields"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("classObject.kt")
        public void testClassObject() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/staticFields/classObject.kt");
        }

        @Test
        @TestMetadata("object.kt")
        public void testObject() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/staticFields/object.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/storeStackBeforeInline")
    @TestDataPath("$PROJECT_ROOT")
    public class StoreStackBeforeInline {
        @Test
        public void testAllFilesPresentInStoreStackBeforeInline() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/storeStackBeforeInline"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("arrayConstructor.kt")
        public void testArrayConstructor() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/storeStackBeforeInline/arrayConstructor.kt");
        }

        @Test
        @TestMetadata("differentTypes.kt")
        public void testDifferentTypes() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/storeStackBeforeInline/differentTypes.kt");
        }

        @Test
        @TestMetadata("primitiveMerge.kt")
        public void testPrimitiveMerge() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/storeStackBeforeInline/primitiveMerge.kt");
        }

        @Test
        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/storeStackBeforeInline/simple.kt");
        }

        @Test
        @TestMetadata("unreachableMarker.kt")
        public void testUnreachableMarker() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/storeStackBeforeInline/unreachableMarker.kt");
        }

        @Test
        @TestMetadata("withLambda.kt")
        public void testWithLambda() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/storeStackBeforeInline/withLambda.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/stringOperations")
    @TestDataPath("$PROJECT_ROOT")
    public class StringOperations {
        @Test
        public void testAllFilesPresentInStringOperations() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/stringOperations"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("concat.kt")
        public void testConcat() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/stringOperations/concat.kt");
        }

        @Test
        @TestMetadata("concatDynamic.kt")
        public void testConcatDynamic() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/stringOperations/concatDynamic.kt");
        }

        @Test
        @TestMetadata("concatDynamic199.kt")
        public void testConcatDynamic199() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/stringOperations/concatDynamic199.kt");
        }

        @Test
        @TestMetadata("concatDynamic200.kt")
        public void testConcatDynamic200() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/stringOperations/concatDynamic200.kt");
        }

        @Test
        @TestMetadata("concatDynamic201.kt")
        public void testConcatDynamic201() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/stringOperations/concatDynamic201.kt");
        }

        @Test
        @TestMetadata("concatDynamicConstants.kt")
        public void testConcatDynamicConstants() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/stringOperations/concatDynamicConstants.kt");
        }

        @Test
        @TestMetadata("concatDynamicDataClass.kt")
        public void testConcatDynamicDataClass() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/stringOperations/concatDynamicDataClass.kt");
        }

        @Test
        @TestMetadata("concatDynamicIndy.kt")
        public void testConcatDynamicIndy() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/stringOperations/concatDynamicIndy.kt");
        }

        @Test
        @TestMetadata("concatDynamicIndy201.kt")
        public void testConcatDynamicIndy201() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/stringOperations/concatDynamicIndy201.kt");
        }

        @Test
        @TestMetadata("concatDynamicIndyDataClass.kt")
        public void testConcatDynamicIndyDataClass() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/stringOperations/concatDynamicIndyDataClass.kt");
        }

        @Test
        @TestMetadata("concatDynamicSpecialSymbols.kt")
        public void testConcatDynamicSpecialSymbols() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/stringOperations/concatDynamicSpecialSymbols.kt");
        }

        @Test
        @TestMetadata("concatDynamicUnit.kt")
        public void testConcatDynamicUnit() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/stringOperations/concatDynamicUnit.kt");
        }

        @Test
        @TestMetadata("concatNotDynamic.kt")
        public void testConcatNotDynamic() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/stringOperations/concatNotDynamic.kt");
        }

        @Test
        @TestMetadata("constConcat.kt")
        public void testConstConcat() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/stringOperations/constConcat.kt");
        }

        @Test
        @TestMetadata("constValConcat.kt")
        public void testConstValConcat() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/stringOperations/constValConcat.kt");
        }

        @Test
        @TestMetadata("doNotAppendEmptyString.kt")
        public void testDoNotAppendEmptyString() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/stringOperations/doNotAppendEmptyString.kt");
        }

        @Test
        @TestMetadata("interpolation.kt")
        public void testInterpolation() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/stringOperations/interpolation.kt");
        }

        @Test
        @TestMetadata("kt15235.kt")
        public void testKt15235() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/stringOperations/kt15235.kt");
        }

        @Test
        @TestMetadata("kt19037.kt")
        public void testKt19037() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/stringOperations/kt19037.kt");
        }

        @Test
        @TestMetadata("kt42457_old.kt")
        public void testKt42457_old() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/stringOperations/kt42457_old.kt");
        }

        @Test
        @TestMetadata("multipleNestedConcat.kt")
        public void testMultipleNestedConcat() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/stringOperations/multipleNestedConcat.kt");
        }

        @Test
        @TestMetadata("nestedConcat.kt")
        public void testNestedConcat() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/stringOperations/nestedConcat.kt");
        }

        @Test
        @TestMetadata("nonNullableStringPlus.kt")
        public void testNonNullableStringPlus() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/stringOperations/nonNullableStringPlus.kt");
        }

        @Test
        @TestMetadata("nullableStringPlus.kt")
        public void testNullableStringPlus() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/stringOperations/nullableStringPlus.kt");
        }

        @Test
        @TestMetadata("partiallyConstConcat.kt")
        public void testPartiallyConstConcat() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/stringOperations/partiallyConstConcat.kt");
        }

        @Test
        @TestMetadata("plusAssign.kt")
        public void testPlusAssign() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/stringOperations/plusAssign.kt");
        }

        @Test
        @TestMetadata("primitiveToString.kt")
        public void testPrimitiveToString() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/stringOperations/primitiveToString.kt");
        }

        @Test
        @TestMetadata("primitiveToStringNotOptimizable.kt")
        public void testPrimitiveToStringNotOptimizable() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/stringOperations/primitiveToStringNotOptimizable.kt");
        }

        @Test
        @TestMetadata("primitivesAsStringTemplates.kt")
        public void testPrimitivesAsStringTemplates() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/stringOperations/primitivesAsStringTemplates.kt");
        }

        @Test
        @TestMetadata("singleConcat.kt")
        public void testSingleConcat() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/stringOperations/singleConcat.kt");
        }

        @Test
        @TestMetadata("stringBuilderToString.kt")
        public void testStringBuilderToString() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/stringOperations/stringBuilderToString.kt");
        }

        @Test
        @TestMetadata("stringPlus.kt")
        public void testStringPlus() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/stringOperations/stringPlus.kt");
        }

        @Test
        @TestMetadata("useAppendCharForOneCharStringInTemplate.kt")
        public void testUseAppendCharForOneCharStringInTemplate() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/stringOperations/useAppendCharForOneCharStringInTemplate.kt");
        }

        @Test
        @TestMetadata("useAppendCharForOneCharStringInTemplate_2.kt")
        public void testUseAppendCharForOneCharStringInTemplate_2() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/stringOperations/useAppendCharForOneCharStringInTemplate_2.kt");
        }

        @Test
        @TestMetadata("useAppendCharForOneCharStringUsingPlus.kt")
        public void testUseAppendCharForOneCharStringUsingPlus() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/stringOperations/useAppendCharForOneCharStringUsingPlus.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/temporaryVals")
    @TestDataPath("$PROJECT_ROOT")
    public class TemporaryVals {
        @Test
        public void testAllFilesPresentInTemporaryVals() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/temporaryVals"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("arrayCompoundAssignment.kt")
        public void testArrayCompoundAssignment() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/temporaryVals/arrayCompoundAssignment.kt");
        }

        @Test
        @TestMetadata("elvisChain.kt")
        public void testElvisChain() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/temporaryVals/elvisChain.kt");
        }

        @Test
        @TestMetadata("noTemporaryInCheckedCast.kt")
        public void testNoTemporaryInCheckedCast() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/temporaryVals/noTemporaryInCheckedCast.kt");
        }

        @Test
        @TestMetadata("notNullReceiversInChain.kt")
        public void testNotNullReceiversInChain() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/temporaryVals/notNullReceiversInChain.kt");
        }

        @Test
        @TestMetadata("safeCallChain1.kt")
        public void testSafeCallChain1() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/temporaryVals/safeCallChain1.kt");
        }

        @Test
        @TestMetadata("safeCallChain2.kt")
        public void testSafeCallChain2() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/temporaryVals/safeCallChain2.kt");
        }

        @Test
        @TestMetadata("safeCallChainMemberExt1.kt")
        public void testSafeCallChainMemberExt1() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/temporaryVals/safeCallChainMemberExt1.kt");
        }

        @Test
        @TestMetadata("safeCallChainMemberExt2.kt")
        public void testSafeCallChainMemberExt2() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/temporaryVals/safeCallChainMemberExt2.kt");
        }

        @Test
        @TestMetadata("safeCallElvisSafeCallElvisSomething.kt")
        public void testSafeCallElvisSafeCallElvisSomething() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/temporaryVals/safeCallElvisSafeCallElvisSomething.kt");
        }

        @Test
        @TestMetadata("safeCallWithElvis.kt")
        public void testSafeCallWithElvis() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/temporaryVals/safeCallWithElvis.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/toArray")
    @TestDataPath("$PROJECT_ROOT")
    public class ToArray {
        @Test
        public void testAllFilesPresentInToArray() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/toArray"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("noAccessorForToArray.kt")
        public void testNoAccessorForToArray() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/toArray/noAccessorForToArray.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/unsignedTypes")
    @TestDataPath("$PROJECT_ROOT")
    public class UnsignedTypes {
        @Test
        public void testAllFilesPresentInUnsignedTypes() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/unsignedTypes"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("unsignedIntCompare_before.kt")
        public void testUnsignedIntCompare_before() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/unsignedTypes/unsignedIntCompare_before.kt");
        }

        @Test
        @TestMetadata("unsignedIntCompare_jvm18.kt")
        public void testUnsignedIntCompare_jvm18() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/unsignedTypes/unsignedIntCompare_jvm18.kt");
        }

        @Test
        @TestMetadata("unsignedIntDivide_jvm18.kt")
        public void testUnsignedIntDivide_jvm18() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/unsignedTypes/unsignedIntDivide_jvm18.kt");
        }

        @Test
        @TestMetadata("unsignedIntRemainder_jvm18.kt")
        public void testUnsignedIntRemainder_jvm18() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/unsignedTypes/unsignedIntRemainder_jvm18.kt");
        }

        @Test
        @TestMetadata("unsignedIntSmartCasts_jvm18.kt")
        public void testUnsignedIntSmartCasts_jvm18() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/unsignedTypes/unsignedIntSmartCasts_jvm18.kt");
        }

        @Test
        @TestMetadata("unsignedIntToString_jvm18.kt")
        public void testUnsignedIntToString_jvm18() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/unsignedTypes/unsignedIntToString_jvm18.kt");
        }

        @Test
        @TestMetadata("unsignedLongCompare_jvm18.kt")
        public void testUnsignedLongCompare_jvm18() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/unsignedTypes/unsignedLongCompare_jvm18.kt");
        }

        @Test
        @TestMetadata("unsignedLongDivide_jvm18.kt")
        public void testUnsignedLongDivide_jvm18() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/unsignedTypes/unsignedLongDivide_jvm18.kt");
        }

        @Test
        @TestMetadata("unsignedLongRemainder_jvm18.kt")
        public void testUnsignedLongRemainder_jvm18() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/unsignedTypes/unsignedLongRemainder_jvm18.kt");
        }

        @Test
        @TestMetadata("unsignedLongToString_jvm18.kt")
        public void testUnsignedLongToString_jvm18() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/unsignedTypes/unsignedLongToString_jvm18.kt");
        }

        @Test
        @TestMetadata("whenByUnsigned.kt")
        public void testWhenByUnsigned() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/unsignedTypes/whenByUnsigned.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/varargs")
    @TestDataPath("$PROJECT_ROOT")
    public class Varargs {
        @Test
        public void testAllFilesPresentInVarargs() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/varargs"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("doNotCopyImmediatelyCreatedArrays.kt")
        public void testDoNotCopyImmediatelyCreatedArrays() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/varargs/doNotCopyImmediatelyCreatedArrays.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/when")
    @TestDataPath("$PROJECT_ROOT")
    public class When {
        @Test
        public void testAllFilesPresentInWhen() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/when"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("edgeCases.kt")
        public void testEdgeCases() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/when/edgeCases.kt");
        }

        @Test
        @TestMetadata("exhaustiveWhenInitialization.kt")
        public void testExhaustiveWhenInitialization() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/when/exhaustiveWhenInitialization.kt");
        }

        @Test
        @TestMetadata("exhaustiveWhenReturn.kt")
        public void testExhaustiveWhenReturn() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/when/exhaustiveWhenReturn.kt");
        }

        @Test
        @TestMetadata("exhaustiveWhenSpecialCases.kt")
        public void testExhaustiveWhenSpecialCases() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/when/exhaustiveWhenSpecialCases.kt");
        }

        @Test
        @TestMetadata("exhaustiveWhenUnit.kt")
        public void testExhaustiveWhenUnit() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/when/exhaustiveWhenUnit.kt");
        }

        @Test
        @TestMetadata("exhaustiveWhenUnitStatement.kt")
        public void testExhaustiveWhenUnitStatement() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/when/exhaustiveWhenUnitStatement.kt");
        }

        @Test
        @TestMetadata("inlineConstValsInsideWhen.kt")
        public void testInlineConstValsInsideWhen() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/when/inlineConstValsInsideWhen.kt");
        }

        @Test
        @TestMetadata("integralWhenWithNoInlinedConstants.kt")
        public void testIntegralWhenWithNoInlinedConstants() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/when/integralWhenWithNoInlinedConstants.kt");
        }

        @Test
        @TestMetadata("kt18818.kt")
        public void testKt18818() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/when/kt18818.kt");
        }

        @Test
        @TestMetadata("lookupSwitch.kt")
        public void testLookupSwitch() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/when/lookupSwitch.kt");
        }

        @Test
        @TestMetadata("lookupSwitchWithSubjectVal.kt")
        public void testLookupSwitchWithSubjectVal() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/when/lookupSwitchWithSubjectVal.kt");
        }

        @Test
        @TestMetadata("noBoxingInDefaultWhenWithSpecialCases.kt")
        public void testNoBoxingInDefaultWhenWithSpecialCases() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/when/noBoxingInDefaultWhenWithSpecialCases.kt");
        }

        @Test
        @TestMetadata("qualifiedConstValsInsideWhen.kt")
        public void testQualifiedConstValsInsideWhen() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/when/qualifiedConstValsInsideWhen.kt");
        }

        @Test
        @TestMetadata("sealedWhenInitialization.kt")
        public void testSealedWhenInitialization() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/when/sealedWhenInitialization.kt");
        }

        @Test
        @TestMetadata("simpleConstValsInsideWhen.kt")
        public void testSimpleConstValsInsideWhen() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/when/simpleConstValsInsideWhen.kt");
        }

        @Test
        @TestMetadata("stringSwitchWithSubjectVal.kt")
        public void testStringSwitchWithSubjectVal() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/when/stringSwitchWithSubjectVal.kt");
        }

        @Test
        @TestMetadata("subjectValHasLocalVariableSlot.kt")
        public void testSubjectValHasLocalVariableSlot() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/when/subjectValHasLocalVariableSlot.kt");
        }

        @Test
        @TestMetadata("subjectValInEnumWhenHasLocalVariableSlot.kt")
        public void testSubjectValInEnumWhenHasLocalVariableSlot() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/when/subjectValInEnumWhenHasLocalVariableSlot.kt");
        }

        @Test
        @TestMetadata("subjectValInIntWhenHasLocalVariableSlot.kt")
        public void testSubjectValInIntWhenHasLocalVariableSlot() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/when/subjectValInIntWhenHasLocalVariableSlot.kt");
        }

        @Test
        @TestMetadata("subjectValInStringWhenHasLocalVariableSlot.kt")
        public void testSubjectValInStringWhenHasLocalVariableSlot() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/when/subjectValInStringWhenHasLocalVariableSlot.kt");
        }

        @Test
        @TestMetadata("switchOptimizationDuplicates.kt")
        public void testSwitchOptimizationDuplicates() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/when/switchOptimizationDuplicates.kt");
        }

        @Test
        @TestMetadata("tableSwitch.kt")
        public void testTableSwitch() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/when/tableSwitch.kt");
        }

        @Test
        @TestMetadata("tableSwitchWithSubjectVal.kt")
        public void testTableSwitchWithSubjectVal() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/when/tableSwitchWithSubjectVal.kt");
        }

        @Test
        @TestMetadata("whenNull.kt")
        public void testWhenNull() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/when/whenNull.kt");
        }

        @Test
        @TestMetadata("whenZero.kt")
        public void testWhenZero() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/when/whenZero.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/whenEnumOptimization")
    @TestDataPath("$PROJECT_ROOT")
    public class WhenEnumOptimization {
        @Test
        public void testAllFilesPresentInWhenEnumOptimization() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/whenEnumOptimization"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("bigEnum.kt")
        public void testBigEnum() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/bigEnum.kt");
        }

        @Test
        @TestMetadata("differentEnumClasses.kt")
        public void testDifferentEnumClasses() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/differentEnumClasses.kt");
        }

        @Test
        @TestMetadata("differentEnumClasses2.kt")
        public void testDifferentEnumClasses2() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/differentEnumClasses2.kt");
        }

        @Test
        @TestMetadata("duplicatingItems.kt")
        public void testDuplicatingItems() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/duplicatingItems.kt");
        }

        @Test
        @TestMetadata("expression.kt")
        public void testExpression() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/expression.kt");
        }

        @Test
        @TestMetadata("functionLiteralInTopLevel.kt")
        public void testFunctionLiteralInTopLevel() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/functionLiteralInTopLevel.kt");
        }

        @Test
        @TestMetadata("importedEnumEntry.kt")
        public void testImportedEnumEntry() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/importedEnumEntry.kt");
        }

        @Test
        @TestMetadata("kt14597_full.kt")
        public void testKt14597_full() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/kt14597_full.kt");
        }

        @Test
        @TestMetadata("kt14802.kt")
        public void testKt14802() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/kt14802.kt");
        }

        @Test
        @TestMetadata("manyWhensWithinClass.kt")
        public void testManyWhensWithinClass() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/manyWhensWithinClass.kt");
        }

        @Test
        @TestMetadata("nestedWhenInCondition.kt")
        public void testNestedWhenInCondition() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/nestedWhenInCondition.kt");
        }

        @Test
        @TestMetadata("nonConstantEnum.kt")
        public void testNonConstantEnum() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/nonConstantEnum.kt");
        }

        @Test
        @TestMetadata("nullability.kt")
        public void testNullability() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/nullability.kt");
        }

        @Test
        @TestMetadata("subjectAny.kt")
        public void testSubjectAny() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/subjectAny.kt");
        }

        @Test
        @TestMetadata("whenOr.kt")
        public void testWhenOr() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/whenOr.kt");
        }

        @Test
        @TestMetadata("withoutElse.kt")
        public void testWithoutElse() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/withoutElse.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/bytecodeText/whenStringOptimization")
    @TestDataPath("$PROJECT_ROOT")
    public class WhenStringOptimization {
        @Test
        public void testAllFilesPresentInWhenStringOptimization() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/whenStringOptimization"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("denseHashCode.kt")
        public void testDenseHashCode() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/whenStringOptimization/denseHashCode.kt");
        }

        @Test
        @TestMetadata("duplicatingItems.kt")
        public void testDuplicatingItems() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/whenStringOptimization/duplicatingItems.kt");
        }

        @Test
        @TestMetadata("duplicatingItemsSameHashCodeFewBranches.kt")
        public void testDuplicatingItemsSameHashCodeFewBranches() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/whenStringOptimization/duplicatingItemsSameHashCodeFewBranches.kt");
        }

        @Test
        @TestMetadata("duplicatingItemsSameHashCodeMoreBranches.kt")
        public void testDuplicatingItemsSameHashCodeMoreBranches() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/whenStringOptimization/duplicatingItemsSameHashCodeMoreBranches.kt");
        }

        @Test
        @TestMetadata("expression.kt")
        public void testExpression() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/whenStringOptimization/expression.kt");
        }

        @Test
        @TestMetadata("inlineStringConstInsideWhen.kt")
        public void testInlineStringConstInsideWhen() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/whenStringOptimization/inlineStringConstInsideWhen.kt");
        }

        @Test
        @TestMetadata("nullability.kt")
        public void testNullability() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/whenStringOptimization/nullability.kt");
        }

        @Test
        @TestMetadata("sameHashCode.kt")
        public void testSameHashCode() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/whenStringOptimization/sameHashCode.kt");
        }

        @Test
        @TestMetadata("statement.kt")
        public void testStatement() throws Exception {
            runTest("compiler/testData/codegen/bytecodeText/whenStringOptimization/statement.kt");
        }
    }
}
