/*
 * Copyright 2010-2021 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.test.runners.codegen;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.utils.TransformersFunctions;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link GenerateNewCompilerTests.kt}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("compiler/testData/codegen/box")
@TestDataPath("$PROJECT_ROOT")
public class FirBlackBoxCodegenTestGenerated extends AbstractFirBlackBoxCodegenTest {
    @Test
    public void testAllFilesPresentInBox() throws Exception {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/annotations")
    @TestDataPath("$PROJECT_ROOT")
    public class Annotations {
        @Test
        public void testAllFilesPresentInAnnotations() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/annotations"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("annotatedAnnotationParameter.kt")
        public void testAnnotatedAnnotationParameter() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/annotatedAnnotationParameter.kt");
        }

        @Test
        @TestMetadata("annotatedEnumEntry.kt")
        public void testAnnotatedEnumEntry() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/annotatedEnumEntry.kt");
        }

        @Test
        @TestMetadata("annotatedObjectLiteral.kt")
        public void testAnnotatedObjectLiteral() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/annotatedObjectLiteral.kt");
        }

        @Test
        @TestMetadata("annotationDefaultValueOfUnsigned.kt")
        public void testAnnotationDefaultValueOfUnsigned() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/annotationDefaultValueOfUnsigned.kt");
        }

        @Test
        @TestMetadata("annotationOnWhen.kt")
        public void testAnnotationOnWhen() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/annotationOnWhen.kt");
        }

        @Test
        @TestMetadata("annotationProperty.kt")
        public void testAnnotationProperty() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/annotationProperty.kt");
        }

        @Test
        @TestMetadata("annotationTargets.kt")
        public void testAnnotationTargets() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/annotationTargets.kt");
        }

        @Test
        @TestMetadata("annotationWithKotlinProperty.kt")
        public void testAnnotationWithKotlinProperty() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/annotationWithKotlinProperty.kt");
        }

        @Test
        @TestMetadata("annotationWithKotlinPropertyFromInterfaceCompanion.kt")
        public void testAnnotationWithKotlinPropertyFromInterfaceCompanion() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/annotationWithKotlinPropertyFromInterfaceCompanion.kt");
        }

        @Test
        @TestMetadata("annotationWithVarargAsDefaultValue.kt")
        public void testAnnotationWithVarargAsDefaultValue() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/annotationWithVarargAsDefaultValue.kt");
        }

        @Test
        @TestMetadata("annotationsOnDefault.kt")
        public void testAnnotationsOnDefault() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/annotationsOnDefault.kt");
        }

        @Test
        @TestMetadata("annotationsOnLateinitAccessors.kt")
        public void testAnnotationsOnLateinitAccessors() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/annotationsOnLateinitAccessors.kt");
        }

        @Test
        @TestMetadata("annotationsOnLateinitFields.kt")
        public void testAnnotationsOnLateinitFields() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/annotationsOnLateinitFields.kt");
        }

        @Test
        @TestMetadata("annotationsOnNonExistentAccessors.kt")
        public void testAnnotationsOnNonExistentAccessors() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/annotationsOnNonExistentAccessors.kt");
        }

        @Test
        @TestMetadata("annotationsOnTypeAliases.kt")
        public void testAnnotationsOnTypeAliases() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/annotationsOnTypeAliases.kt");
        }

        @Test
        @TestMetadata("constValInAnnotation.kt")
        public void testConstValInAnnotation() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/constValInAnnotation.kt");
        }

        @Test
        @TestMetadata("defaultParameterValues.kt")
        public void testDefaultParameterValues() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/defaultParameterValues.kt");
        }

        @Test
        @TestMetadata("delegatedPropertySetter.kt")
        public void testDelegatedPropertySetter() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/delegatedPropertySetter.kt");
        }

        @Test
        @TestMetadata("divisionByZeroInJava.kt")
        public void testDivisionByZeroInJava() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/divisionByZeroInJava.kt");
        }

        @Test
        @TestMetadata("fileClassWithFileAnnotation.kt")
        public void testFileClassWithFileAnnotation() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/fileClassWithFileAnnotation.kt");
        }

        @Test
        @TestMetadata("genericAnnotations.kt")
        public void testGenericAnnotations() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/genericAnnotations.kt");
        }

        @Test
        @TestMetadata("javaAnnotationArrayValueDefault.kt")
        public void testJavaAnnotationArrayValueDefault() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/javaAnnotationArrayValueDefault.kt");
        }

        @Test
        @TestMetadata("javaAnnotationArrayValueNoDefault.kt")
        public void testJavaAnnotationArrayValueNoDefault() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/javaAnnotationArrayValueNoDefault.kt");
        }

        @Test
        @TestMetadata("javaAnnotationCall.kt")
        public void testJavaAnnotationCall() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/javaAnnotationCall.kt");
        }

        @Test
        @TestMetadata("javaAnnotationDefault.kt")
        public void testJavaAnnotationDefault() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/javaAnnotationDefault.kt");
        }

        @Test
        @TestMetadata("javaAnnotationOnProperty.kt")
        public void testJavaAnnotationOnProperty() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/javaAnnotationOnProperty.kt");
        }

        @Test
        @TestMetadata("javaAnnotationOnSecondaryConstructorOfLocalClass.kt")
        public void testJavaAnnotationOnSecondaryConstructorOfLocalClass() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/javaAnnotationOnSecondaryConstructorOfLocalClass.kt");
        }

        @Test
        @TestMetadata("javaAnnotationWithSingleArrayArgument.kt")
        public void testJavaAnnotationWithSingleArrayArgument() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/javaAnnotationWithSingleArrayArgument.kt");
        }

        @Test
        @TestMetadata("javaNegativePropertyAsAnnotationParameter.kt")
        public void testJavaNegativePropertyAsAnnotationParameter() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/javaNegativePropertyAsAnnotationParameter.kt");
        }

        @Test
        @TestMetadata("javaPropertyAsAnnotationParameter.kt")
        public void testJavaPropertyAsAnnotationParameter() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/javaPropertyAsAnnotationParameter.kt");
        }

        @Test
        @TestMetadata("javaPropertyWithIntInitializer.kt")
        public void testJavaPropertyWithIntInitializer() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/javaPropertyWithIntInitializer.kt");
        }

        @Test
        @TestMetadata("jvmAnnotationFlags.kt")
        public void testJvmAnnotationFlags() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/jvmAnnotationFlags.kt");
        }

        @Test
        @TestMetadata("kotlinPropertyFromClassObjectAsParameter.kt")
        public void testKotlinPropertyFromClassObjectAsParameter() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/kotlinPropertyFromClassObjectAsParameter.kt");
        }

        @Test
        @TestMetadata("kotlinTopLevelPropertyAsParameter.kt")
        public void testKotlinTopLevelPropertyAsParameter() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/kotlinTopLevelPropertyAsParameter.kt");
        }

        @Test
        @TestMetadata("kt10136.kt")
        public void testKt10136() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/kt10136.kt");
        }

        @Test
        @TestMetadata("kt25489.kt")
        public void testKt25489() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/kt25489.kt");
        }

        @Test
        @TestMetadata("mustBeDocumented.kt")
        public void testMustBeDocumented() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/mustBeDocumented.kt");
        }

        @Test
        @TestMetadata("nestedAnnotation.kt")
        public void testNestedAnnotation() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/nestedAnnotation.kt");
        }

        @Test
        @TestMetadata("nestedClassPropertyAsParameter.kt")
        public void testNestedClassPropertyAsParameter() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/nestedClassPropertyAsParameter.kt");
        }

        @Test
        @TestMetadata("nestedClassesInAnnotations.kt")
        public void testNestedClassesInAnnotations() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/nestedClassesInAnnotations.kt");
        }

        @Test
        @TestMetadata("objectConstValInAnnotationArgument.kt")
        public void testObjectConstValInAnnotationArgument() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/objectConstValInAnnotationArgument.kt");
        }

        @Test
        @TestMetadata("parameterAnnotationInDefaultImpls.kt")
        public void testParameterAnnotationInDefaultImpls() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/parameterAnnotationInDefaultImpls.kt");
        }

        @Test
        @TestMetadata("parameterWithPrimitiveType.kt")
        public void testParameterWithPrimitiveType() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/parameterWithPrimitiveType.kt");
        }

        @Test
        @TestMetadata("parameters.kt")
        public void testParameters() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/parameters.kt");
        }

        @Test
        @TestMetadata("propertyWithPropertyInInitializerAsParameter.kt")
        public void testPropertyWithPropertyInInitializerAsParameter() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/propertyWithPropertyInInitializerAsParameter.kt");
        }

        @Test
        @TestMetadata("resolveWithLowPriorityAnnotation.kt")
        public void testResolveWithLowPriorityAnnotation() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/resolveWithLowPriorityAnnotation.kt");
        }

        @Test
        @TestMetadata("retentionInJava.kt")
        public void testRetentionInJava() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/retentionInJava.kt");
        }

        @Test
        @TestMetadata("singleAssignmentToVarargInAnnotation.kt")
        public void testSingleAssignmentToVarargInAnnotation() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/singleAssignmentToVarargInAnnotation.kt");
        }

        @Test
        @TestMetadata("syntheticMethodForJvmStaticProperty.kt")
        public void testSyntheticMethodForJvmStaticProperty() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/syntheticMethodForJvmStaticProperty.kt");
        }

        @Test
        @TestMetadata("syntheticMethodForProperty.kt")
        public void testSyntheticMethodForProperty() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/syntheticMethodForProperty.kt");
        }

        @Test
        @TestMetadata("typeAnnotationOnJdk6.kt")
        public void testTypeAnnotationOnJdk6() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/typeAnnotationOnJdk6.kt");
        }

        @Test
        @TestMetadata("useTypeParameterAnnotationFromJava.kt")
        public void testUseTypeParameterAnnotationFromJava() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/useTypeParameterAnnotationFromJava.kt");
        }

        @Test
        @TestMetadata("useTypeUseAnnotationFromJava.kt")
        public void testUseTypeUseAnnotationFromJava() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/useTypeUseAnnotationFromJava.kt");
        }

        @Test
        @TestMetadata("varargInAnnotationParameter.kt")
        public void testVarargInAnnotationParameter() throws Exception {
            runTest("compiler/testData/codegen/box/annotations/varargInAnnotationParameter.kt");
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/box/annotations/annotatedLambda")
        @TestDataPath("$PROJECT_ROOT")
        public class AnnotatedLambda {
            @Test
            public void testAllFilesPresentInAnnotatedLambda() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/annotations/annotatedLambda"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("funExpression.kt")
            public void testFunExpression() throws Exception {
                runTest("compiler/testData/codegen/box/annotations/annotatedLambda/funExpression.kt");
            }

            @Test
            @TestMetadata("lambda.kt")
            public void testLambda() throws Exception {
                runTest("compiler/testData/codegen/box/annotations/annotatedLambda/lambda.kt");
            }

            @Test
            @TestMetadata("samFunExpression.kt")
            public void testSamFunExpression() throws Exception {
                runTest("compiler/testData/codegen/box/annotations/annotatedLambda/samFunExpression.kt");
            }

            @Test
            @TestMetadata("samFunReference.kt")
            public void testSamFunReference() throws Exception {
                runTest("compiler/testData/codegen/box/annotations/annotatedLambda/samFunReference.kt");
            }

            @Test
            @TestMetadata("samLambda.kt")
            public void testSamLambda() throws Exception {
                runTest("compiler/testData/codegen/box/annotations/annotatedLambda/samLambda.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/box/annotations/instances")
        @TestDataPath("$PROJECT_ROOT")
        public class Instances {
            @Test
            public void testAllFilesPresentInInstances() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/annotations/instances"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("annotationEnclosingName.kt")
            public void testAnnotationEnclosingName() throws Exception {
                runTest("compiler/testData/codegen/box/annotations/instances/annotationEnclosingName.kt");
            }

            @Test
            @TestMetadata("annotationEqHc.kt")
            public void testAnnotationEqHc() throws Exception {
                runTest("compiler/testData/codegen/box/annotations/instances/annotationEqHc.kt");
            }

            @Test
            @TestMetadata("annotationFromStdlib.kt")
            public void testAnnotationFromStdlib() throws Exception {
                runTest("compiler/testData/codegen/box/annotations/instances/annotationFromStdlib.kt");
            }

            @Test
            @TestMetadata("annotationInstances.kt")
            public void testAnnotationInstances() throws Exception {
                runTest("compiler/testData/codegen/box/annotations/instances/annotationInstances.kt");
            }

            @Test
            @TestMetadata("annotationInstancesEmptyDefault.kt")
            public void testAnnotationInstancesEmptyDefault() throws Exception {
                runTest("compiler/testData/codegen/box/annotations/instances/annotationInstancesEmptyDefault.kt");
            }

            @Test
            @TestMetadata("annotationJvmHashCode.kt")
            public void testAnnotationJvmHashCode() throws Exception {
                runTest("compiler/testData/codegen/box/annotations/instances/annotationJvmHashCode.kt");
            }

            @Test
            @TestMetadata("annotationToString.kt")
            public void testAnnotationToString() throws Exception {
                runTest("compiler/testData/codegen/box/annotations/instances/annotationToString.kt");
            }

            @Test
            @TestMetadata("annotationType.kt")
            public void testAnnotationType() throws Exception {
                runTest("compiler/testData/codegen/box/annotations/instances/annotationType.kt");
            }

            @Test
            @TestMetadata("inInlineFunction.kt")
            public void testInInlineFunction() throws Exception {
                runTest("compiler/testData/codegen/box/annotations/instances/inInlineFunction.kt");
            }

            @Test
            @TestMetadata("javaAnnotation.kt")
            public void testJavaAnnotation() throws Exception {
                runTest("compiler/testData/codegen/box/annotations/instances/javaAnnotation.kt");
            }

            @Test
            @TestMetadata("kotlinExistingAnnotation.kt")
            public void testKotlinExistingAnnotation() throws Exception {
                runTest("compiler/testData/codegen/box/annotations/instances/kotlinExistingAnnotation.kt");
            }

            @Test
            @TestMetadata("multifileEqHc.kt")
            public void testMultifileEqHc() throws Exception {
                runTest("compiler/testData/codegen/box/annotations/instances/multifileEqHc.kt");
            }

            @Test
            @TestMetadata("multimoduleCreation.kt")
            public void testMultimoduleCreation() throws Exception {
                runTest("compiler/testData/codegen/box/annotations/instances/multimoduleCreation.kt");
            }

            @Test
            @TestMetadata("multimoduleInlining.kt")
            public void testMultimoduleInlining() throws Exception {
                runTest("compiler/testData/codegen/box/annotations/instances/multimoduleInlining.kt");
            }

            @Test
            @TestMetadata("multiplatformInstantiation.kt")
            public void testMultiplatformInstantiation() throws Exception {
                runTest("compiler/testData/codegen/box/annotations/instances/multiplatformInstantiation.kt");
            }

            @Test
            @TestMetadata("nestedAnnotationInstances.kt")
            public void testNestedAnnotationInstances() throws Exception {
                runTest("compiler/testData/codegen/box/annotations/instances/nestedAnnotationInstances.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/box/annotations/kClassMapping")
        @TestDataPath("$PROJECT_ROOT")
        public class KClassMapping {
            @Test
            public void testAllFilesPresentInKClassMapping() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/annotations/kClassMapping"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("arrayClassParameter.kt")
            public void testArrayClassParameter() throws Exception {
                runTest("compiler/testData/codegen/box/annotations/kClassMapping/arrayClassParameter.kt");
            }

            @Test
            @TestMetadata("arrayClassParameterOnJavaClass.kt")
            public void testArrayClassParameterOnJavaClass() throws Exception {
                runTest("compiler/testData/codegen/box/annotations/kClassMapping/arrayClassParameterOnJavaClass.kt");
            }

            @Test
            @TestMetadata("classParameter.kt")
            public void testClassParameter() throws Exception {
                runTest("compiler/testData/codegen/box/annotations/kClassMapping/classParameter.kt");
            }

            @Test
            @TestMetadata("classParameterOnJavaClass.kt")
            public void testClassParameterOnJavaClass() throws Exception {
                runTest("compiler/testData/codegen/box/annotations/kClassMapping/classParameterOnJavaClass.kt");
            }

            @Test
            @TestMetadata("varargClassParameter.kt")
            public void testVarargClassParameter() throws Exception {
                runTest("compiler/testData/codegen/box/annotations/kClassMapping/varargClassParameter.kt");
            }

            @Test
            @TestMetadata("varargClassParameterOnJavaClass.kt")
            public void testVarargClassParameterOnJavaClass() throws Exception {
                runTest("compiler/testData/codegen/box/annotations/kClassMapping/varargClassParameterOnJavaClass.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/box/annotations/repeatable")
        @TestDataPath("$PROJECT_ROOT")
        public class Repeatable {
            @Test
            public void testAllFilesPresentInRepeatable() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/annotations/repeatable"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("javaAnnotation.kt")
            public void testJavaAnnotation() throws Exception {
                runTest("compiler/testData/codegen/box/annotations/repeatable/javaAnnotation.kt");
            }

            @Test
            @TestMetadata("jvmRepeatableKotlinAnnotation.kt")
            public void testJvmRepeatableKotlinAnnotation() throws Exception {
                runTest("compiler/testData/codegen/box/annotations/repeatable/jvmRepeatableKotlinAnnotation.kt");
            }

            @Test
            @TestMetadata("kotlinAnnotation.kt")
            public void testKotlinAnnotation() throws Exception {
                runTest("compiler/testData/codegen/box/annotations/repeatable/kotlinAnnotation.kt");
            }

            @Test
            @TestMetadata("kotlinAnnotationInJava.kt")
            public void testKotlinAnnotationInJava() throws Exception {
                runTest("compiler/testData/codegen/box/annotations/repeatable/kotlinAnnotationInJava.kt");
            }

            @Test
            @TestMetadata("kotlinAnnotationWithBothRepeatables.kt")
            public void testKotlinAnnotationWithBothRepeatables() throws Exception {
                runTest("compiler/testData/codegen/box/annotations/repeatable/kotlinAnnotationWithBothRepeatables.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/box/annotations/typeAnnotations")
        @TestDataPath("$PROJECT_ROOT")
        public class TypeAnnotations {
            @Test
            public void testAllFilesPresentInTypeAnnotations() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/annotations/typeAnnotations"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("checkingNotincorporatedInputTypes.kt")
            public void testCheckingNotincorporatedInputTypes() throws Exception {
                runTest("compiler/testData/codegen/box/annotations/typeAnnotations/checkingNotincorporatedInputTypes.kt");
            }

            @Test
            @TestMetadata("classTypeParameterBound.kt")
            public void testClassTypeParameterBound() throws Exception {
                runTest("compiler/testData/codegen/box/annotations/typeAnnotations/classTypeParameterBound.kt");
            }

            @Test
            @TestMetadata("classTypeParameterBoundsJava.kt")
            public void testClassTypeParameterBoundsJava() throws Exception {
                runTest("compiler/testData/codegen/box/annotations/typeAnnotations/classTypeParameterBoundsJava.kt");
            }

            @Test
            @TestMetadata("functionTypeParameterBound.kt")
            public void testFunctionTypeParameterBound() throws Exception {
                runTest("compiler/testData/codegen/box/annotations/typeAnnotations/functionTypeParameterBound.kt");
            }

            @Test
            @TestMetadata("implicitReturn.kt")
            public void testImplicitReturn() throws Exception {
                runTest("compiler/testData/codegen/box/annotations/typeAnnotations/implicitReturn.kt");
            }

            @Test
            @TestMetadata("implicitReturnAgainstCompiled.kt")
            public void testImplicitReturnAgainstCompiled() throws Exception {
                runTest("compiler/testData/codegen/box/annotations/typeAnnotations/implicitReturnAgainstCompiled.kt");
            }

            @Test
            @TestMetadata("kt41484.kt")
            public void testKt41484() throws Exception {
                runTest("compiler/testData/codegen/box/annotations/typeAnnotations/kt41484.kt");
            }

            @Test
            @TestMetadata("methodParameters.kt")
            public void testMethodParameters() throws Exception {
                runTest("compiler/testData/codegen/box/annotations/typeAnnotations/methodParameters.kt");
            }

            @Test
            @TestMetadata("methodTypeParameters.kt")
            public void testMethodTypeParameters() throws Exception {
                runTest("compiler/testData/codegen/box/annotations/typeAnnotations/methodTypeParameters.kt");
            }

            @Test
            @TestMetadata("typeAnnotationTarget6.kt")
            public void testTypeAnnotationTarget6() throws Exception {
                runTest("compiler/testData/codegen/box/annotations/typeAnnotations/typeAnnotationTarget6.kt");
            }

            @Test
            @TestMetadata("typeUseAnnotation.kt")
            public void testTypeUseAnnotation() throws Exception {
                runTest("compiler/testData/codegen/box/annotations/typeAnnotations/typeUseAnnotation.kt");
            }
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/argumentOrder")
    @TestDataPath("$PROJECT_ROOT")
    public class ArgumentOrder {
        @Test
        public void testAllFilesPresentInArgumentOrder() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/argumentOrder"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("argumentOrderInObjectSuperCall.kt")
        public void testArgumentOrderInObjectSuperCall() throws Exception {
            runTest("compiler/testData/codegen/box/argumentOrder/argumentOrderInObjectSuperCall.kt");
        }

        @Test
        @TestMetadata("argumentOrderInObjectSuperCallWithPlatformType.kt")
        public void testArgumentOrderInObjectSuperCallWithPlatformType() throws Exception {
            runTest("compiler/testData/codegen/box/argumentOrder/argumentOrderInObjectSuperCallWithPlatformType.kt");
        }

        @Test
        @TestMetadata("argumentOrderInSuperCall.kt")
        public void testArgumentOrderInSuperCall() throws Exception {
            runTest("compiler/testData/codegen/box/argumentOrder/argumentOrderInSuperCall.kt");
        }

        @Test
        @TestMetadata("arguments.kt")
        public void testArguments() throws Exception {
            runTest("compiler/testData/codegen/box/argumentOrder/arguments.kt");
        }

        @Test
        @TestMetadata("captured.kt")
        public void testCaptured() throws Exception {
            runTest("compiler/testData/codegen/box/argumentOrder/captured.kt");
        }

        @Test
        @TestMetadata("capturedInExtension.kt")
        public void testCapturedInExtension() throws Exception {
            runTest("compiler/testData/codegen/box/argumentOrder/capturedInExtension.kt");
        }

        @Test
        @TestMetadata("defaults.kt")
        public void testDefaults() throws Exception {
            runTest("compiler/testData/codegen/box/argumentOrder/defaults.kt");
        }

        @Test
        @TestMetadata("extension.kt")
        public void testExtension() throws Exception {
            runTest("compiler/testData/codegen/box/argumentOrder/extension.kt");
        }

        @Test
        @TestMetadata("extensionInClass.kt")
        public void testExtensionInClass() throws Exception {
            runTest("compiler/testData/codegen/box/argumentOrder/extensionInClass.kt");
        }

        @Test
        @TestMetadata("kt17691.kt")
        public void testKt17691() throws Exception {
            runTest("compiler/testData/codegen/box/argumentOrder/kt17691.kt");
        }

        @Test
        @TestMetadata("kt17691WithEnabledFeature.kt")
        public void testKt17691WithEnabledFeature() throws Exception {
            runTest("compiler/testData/codegen/box/argumentOrder/kt17691WithEnabledFeature.kt");
        }

        @Test
        @TestMetadata("kt9277.kt")
        public void testKt9277() throws Exception {
            runTest("compiler/testData/codegen/box/argumentOrder/kt9277.kt");
        }

        @Test
        @TestMetadata("lambdaMigration.kt")
        public void testLambdaMigration() throws Exception {
            runTest("compiler/testData/codegen/box/argumentOrder/lambdaMigration.kt");
        }

        @Test
        @TestMetadata("lambdaMigrationInClass.kt")
        public void testLambdaMigrationInClass() throws Exception {
            runTest("compiler/testData/codegen/box/argumentOrder/lambdaMigrationInClass.kt");
        }

        @Test
        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("compiler/testData/codegen/box/argumentOrder/simple.kt");
        }

        @Test
        @TestMetadata("simpleInClass.kt")
        public void testSimpleInClass() throws Exception {
            runTest("compiler/testData/codegen/box/argumentOrder/simpleInClass.kt");
        }

        @Test
        @TestMetadata("singleSideEffect.kt")
        public void testSingleSideEffect() throws Exception {
            runTest("compiler/testData/codegen/box/argumentOrder/singleSideEffect.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/arrays")
    @TestDataPath("$PROJECT_ROOT")
    public class Arrays {
        @Test
        public void testAllFilesPresentInArrays() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/arrays"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("arrayConstructorWithNonInlineLambda.kt")
        public void testArrayConstructorWithNonInlineLambda() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/arrayConstructorWithNonInlineLambda.kt");
        }

        @Test
        @TestMetadata("arrayConstructorsSimple.kt")
        public void testArrayConstructorsSimple() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/arrayConstructorsSimple.kt");
        }

        @Test
        @TestMetadata("arrayGetAssignMultiIndex.kt")
        public void testArrayGetAssignMultiIndex() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/arrayGetAssignMultiIndex.kt");
        }

        @Test
        @TestMetadata("arrayGetMultiIndex.kt")
        public void testArrayGetMultiIndex() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/arrayGetMultiIndex.kt");
        }

        @Test
        @TestMetadata("arrayInstanceOf.kt")
        public void testArrayInstanceOf() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/arrayInstanceOf.kt");
        }

        @Test
        @TestMetadata("arrayPlusAssign.kt")
        public void testArrayPlusAssign() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/arrayPlusAssign.kt");
        }

        @Test
        @TestMetadata("arraysAreCloneable.kt")
        public void testArraysAreCloneable() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/arraysAreCloneable.kt");
        }

        @Test
        @TestMetadata("cloneArray.kt")
        public void testCloneArray() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/cloneArray.kt");
        }

        @Test
        @TestMetadata("clonePrimitiveArrays.kt")
        public void testClonePrimitiveArrays() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/clonePrimitiveArrays.kt");
        }

        @Test
        @TestMetadata("collectionAssignGetMultiIndex.kt")
        public void testCollectionAssignGetMultiIndex() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/collectionAssignGetMultiIndex.kt");
        }

        @Test
        @TestMetadata("collectionGetMultiIndex.kt")
        public void testCollectionGetMultiIndex() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/collectionGetMultiIndex.kt");
        }

        @Test
        @TestMetadata("constantArrayOfAny.kt")
        public void testConstantArrayOfAny() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/constantArrayOfAny.kt");
        }

        @Test
        @TestMetadata("forEachBooleanArray.kt")
        public void testForEachBooleanArray() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/forEachBooleanArray.kt");
        }

        @Test
        @TestMetadata("forEachByteArray.kt")
        public void testForEachByteArray() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/forEachByteArray.kt");
        }

        @Test
        @TestMetadata("forEachCharArray.kt")
        public void testForEachCharArray() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/forEachCharArray.kt");
        }

        @Test
        @TestMetadata("forEachDoubleArray.kt")
        public void testForEachDoubleArray() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/forEachDoubleArray.kt");
        }

        @Test
        @TestMetadata("forEachFloatArray.kt")
        public void testForEachFloatArray() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/forEachFloatArray.kt");
        }

        @Test
        @TestMetadata("forEachIntArray.kt")
        public void testForEachIntArray() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/forEachIntArray.kt");
        }

        @Test
        @TestMetadata("forEachLongArray.kt")
        public void testForEachLongArray() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/forEachLongArray.kt");
        }

        @Test
        @TestMetadata("forEachShortArray.kt")
        public void testForEachShortArray() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/forEachShortArray.kt");
        }

        @Test
        @TestMetadata("genericArrayInObjectLiteralConstructor.kt")
        public void testGenericArrayInObjectLiteralConstructor() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/genericArrayInObjectLiteralConstructor.kt");
        }

        @Test
        @TestMetadata("hashMap.kt")
        public void testHashMap() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/hashMap.kt");
        }

        @Test
        @TestMetadata("inProjectionAsParameter.kt")
        public void testInProjectionAsParameter() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/inProjectionAsParameter.kt");
        }

        @Test
        @TestMetadata("inProjectionOfArray.kt")
        public void testInProjectionOfArray() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/inProjectionOfArray.kt");
        }

        @Test
        @TestMetadata("inProjectionOfList.kt")
        public void testInProjectionOfList() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/inProjectionOfList.kt");
        }

        @Test
        @TestMetadata("indices.kt")
        public void testIndices() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/indices.kt");
        }

        @Test
        @TestMetadata("indicesChar.kt")
        public void testIndicesChar() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/indicesChar.kt");
        }

        @Test
        @TestMetadata("inlineInitializer.kt")
        public void testInlineInitializer() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/inlineInitializer.kt");
        }

        @Test
        @TestMetadata("iterator.kt")
        public void testIterator() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/iterator.kt");
        }

        @Test
        @TestMetadata("iteratorBooleanArray.kt")
        public void testIteratorBooleanArray() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/iteratorBooleanArray.kt");
        }

        @Test
        @TestMetadata("iteratorByteArray.kt")
        public void testIteratorByteArray() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/iteratorByteArray.kt");
        }

        @Test
        @TestMetadata("iteratorByteArrayNextByte.kt")
        public void testIteratorByteArrayNextByte() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/iteratorByteArrayNextByte.kt");
        }

        @Test
        @TestMetadata("iteratorCharArray.kt")
        public void testIteratorCharArray() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/iteratorCharArray.kt");
        }

        @Test
        @TestMetadata("iteratorDoubleArray.kt")
        public void testIteratorDoubleArray() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/iteratorDoubleArray.kt");
        }

        @Test
        @TestMetadata("iteratorFloatArray.kt")
        public void testIteratorFloatArray() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/iteratorFloatArray.kt");
        }

        @Test
        @TestMetadata("iteratorIntArray.kt")
        public void testIteratorIntArray() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/iteratorIntArray.kt");
        }

        @Test
        @TestMetadata("iteratorLongArray.kt")
        public void testIteratorLongArray() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/iteratorLongArray.kt");
        }

        @Test
        @TestMetadata("iteratorLongArrayNextLong.kt")
        public void testIteratorLongArrayNextLong() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/iteratorLongArrayNextLong.kt");
        }

        @Test
        @TestMetadata("iteratorShortArray.kt")
        public void testIteratorShortArray() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/iteratorShortArray.kt");
        }

        @Test
        @TestMetadata("kt1291.kt")
        public void testKt1291() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/kt1291.kt");
        }

        @Test
        @TestMetadata("kt17134.kt")
        public void testKt17134() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/kt17134.kt");
        }

        @Test
        @TestMetadata("kt238.kt")
        public void testKt238() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/kt238.kt");
        }

        @Test
        @TestMetadata("kt2997.kt")
        public void testKt2997() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/kt2997.kt");
        }

        @Test
        @TestMetadata("kt33.kt")
        public void testKt33() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/kt33.kt");
        }

        @Test
        @TestMetadata("kt34291_16dimensions.kt")
        public void testKt34291_16dimensions() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/kt34291_16dimensions.kt");
        }

        @Test
        @TestMetadata("kt3771.kt")
        public void testKt3771() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/kt3771.kt");
        }

        @Test
        @TestMetadata("kt4118.kt")
        public void testKt4118() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/kt4118.kt");
        }

        @Test
        @TestMetadata("kt42932.kt")
        public void testKt42932() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/kt42932.kt");
        }

        @Test
        @TestMetadata("kt4348.kt")
        public void testKt4348() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/kt4348.kt");
        }

        @Test
        @TestMetadata("kt4357.kt")
        public void testKt4357() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/kt4357.kt");
        }

        @Test
        @TestMetadata("kt45410.kt")
        public void testKt45410() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/kt45410.kt");
        }

        @Test
        @TestMetadata("kt47483.kt")
        public void testKt47483() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/kt47483.kt");
        }

        @Test
        @TestMetadata("kt47499.kt")
        public void testKt47499() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/kt47499.kt");
        }

        @Test
        @TestMetadata("kt503.kt")
        public void testKt503() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/kt503.kt");
        }

        @Test
        @TestMetadata("kt594.kt")
        public void testKt594() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/kt594.kt");
        }

        @Test
        @TestMetadata("kt602.kt")
        public void testKt602() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/kt602.kt");
        }

        @Test
        @TestMetadata("kt7009.kt")
        public void testKt7009() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/kt7009.kt");
        }

        @Test
        @TestMetadata("kt7288.kt")
        public void testKt7288() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/kt7288.kt");
        }

        @Test
        @TestMetadata("kt7338.kt")
        public void testKt7338() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/kt7338.kt");
        }

        @Test
        @TestMetadata("kt779.kt")
        public void testKt779() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/kt779.kt");
        }

        @Test
        @TestMetadata("kt945.kt")
        public void testKt945() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/kt945.kt");
        }

        @Test
        @TestMetadata("kt950.kt")
        public void testKt950() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/kt950.kt");
        }

        @Test
        @TestMetadata("longAsIndex.kt")
        public void testLongAsIndex() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/longAsIndex.kt");
        }

        @Test
        @TestMetadata("multiArrayConstructors.kt")
        public void testMultiArrayConstructors() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/multiArrayConstructors.kt");
        }

        @Test
        @TestMetadata("nonLocalReturnArrayConstructor.kt")
        public void testNonLocalReturnArrayConstructor() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/nonLocalReturnArrayConstructor.kt");
        }

        @Test
        @TestMetadata("nonNullArray.kt")
        public void testNonNullArray() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/nonNullArray.kt");
        }

        @Test
        @TestMetadata("primitiveArrays.kt")
        public void testPrimitiveArrays() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/primitiveArrays.kt");
        }

        @Test
        @TestMetadata("stdlib.kt")
        public void testStdlib() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/stdlib.kt");
        }

        @Test
        @TestMetadata("varargsWithJava.kt")
        public void testVarargsWithJava() throws Exception {
            runTest("compiler/testData/codegen/box/arrays/varargsWithJava.kt");
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/box/arrays/arraysOfInlineClass")
        @TestDataPath("$PROJECT_ROOT")
        public class ArraysOfInlineClass {
            @Test
            @TestMetadata("accessArrayOfInlineClass.kt")
            public void testAccessArrayOfInlineClass() throws Exception {
                runTest("compiler/testData/codegen/box/arrays/arraysOfInlineClass/accessArrayOfInlineClass.kt");
            }

            @Test
            @TestMetadata("accessArrayOfUnsigned.kt")
            public void testAccessArrayOfUnsigned() throws Exception {
                runTest("compiler/testData/codegen/box/arrays/arraysOfInlineClass/accessArrayOfUnsigned.kt");
            }

            @Test
            public void testAllFilesPresentInArraysOfInlineClass() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/arrays/arraysOfInlineClass"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("arrayOfInlineClassOfArrayOfInlineClass.kt")
            public void testArrayOfInlineClassOfArrayOfInlineClass() throws Exception {
                runTest("compiler/testData/codegen/box/arrays/arraysOfInlineClass/arrayOfInlineClassOfArrayOfInlineClass.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/box/arrays/forInReversed")
        @TestDataPath("$PROJECT_ROOT")
        public class ForInReversed {
            @Test
            public void testAllFilesPresentInForInReversed() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/arrays/forInReversed"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("reversedArray.kt")
            public void testReversedArray() throws Exception {
                runTest("compiler/testData/codegen/box/arrays/forInReversed/reversedArray.kt");
            }

            @Test
            @TestMetadata("reversedArrayOriginalUpdatedInLoopBody.kt")
            public void testReversedArrayOriginalUpdatedInLoopBody() throws Exception {
                runTest("compiler/testData/codegen/box/arrays/forInReversed/reversedArrayOriginalUpdatedInLoopBody.kt");
            }

            @Test
            @TestMetadata("reversedArrayReversedArrayOriginalUpdatedInLoopBody.kt")
            public void testReversedArrayReversedArrayOriginalUpdatedInLoopBody() throws Exception {
                runTest("compiler/testData/codegen/box/arrays/forInReversed/reversedArrayReversedArrayOriginalUpdatedInLoopBody.kt");
            }

            @Test
            @TestMetadata("reversedOriginalUpdatedInLoopBody.kt")
            public void testReversedOriginalUpdatedInLoopBody() throws Exception {
                runTest("compiler/testData/codegen/box/arrays/forInReversed/reversedOriginalUpdatedInLoopBody.kt");
            }

            @Test
            @TestMetadata("reversedReversedOriginalUpdatedInLoopBody.kt")
            public void testReversedReversedOriginalUpdatedInLoopBody() throws Exception {
                runTest("compiler/testData/codegen/box/arrays/forInReversed/reversedReversedOriginalUpdatedInLoopBody.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/box/arrays/forInUnsignedArray")
        @TestDataPath("$PROJECT_ROOT")
        public class ForInUnsignedArray {
            @Test
            public void testAllFilesPresentInForInUnsignedArray() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/arrays/forInUnsignedArray"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("forInUnsignedArray.kt")
            public void testForInUnsignedArray() throws Exception {
                runTest("compiler/testData/codegen/box/arrays/forInUnsignedArray/forInUnsignedArray.kt");
            }

            @Test
            @TestMetadata("forInUnsignedArrayIndices.kt")
            public void testForInUnsignedArrayIndices() throws Exception {
                runTest("compiler/testData/codegen/box/arrays/forInUnsignedArray/forInUnsignedArrayIndices.kt");
            }

            @Test
            @TestMetadata("forInUnsignedArrayIndicesReversed.kt")
            public void testForInUnsignedArrayIndicesReversed() throws Exception {
                runTest("compiler/testData/codegen/box/arrays/forInUnsignedArray/forInUnsignedArrayIndicesReversed.kt");
            }

            @Test
            @TestMetadata("forInUnsignedArrayReversed.kt")
            public void testForInUnsignedArrayReversed() throws Exception {
                runTest("compiler/testData/codegen/box/arrays/forInUnsignedArray/forInUnsignedArrayReversed.kt");
            }

            @Test
            @TestMetadata("forInUnsignedArrayWithIndex.kt")
            public void testForInUnsignedArrayWithIndex() throws Exception {
                runTest("compiler/testData/codegen/box/arrays/forInUnsignedArray/forInUnsignedArrayWithIndex.kt");
            }

            @Test
            @TestMetadata("forInUnsignedArrayWithIndexNoElementVar.kt")
            public void testForInUnsignedArrayWithIndexNoElementVar() throws Exception {
                runTest("compiler/testData/codegen/box/arrays/forInUnsignedArray/forInUnsignedArrayWithIndexNoElementVar.kt");
            }

            @Test
            @TestMetadata("forInUnsignedArrayWithIndexNoIndexVar.kt")
            public void testForInUnsignedArrayWithIndexNoIndexVar() throws Exception {
                runTest("compiler/testData/codegen/box/arrays/forInUnsignedArray/forInUnsignedArrayWithIndexNoIndexVar.kt");
            }

            @Test
            @TestMetadata("forInUnsignedArrayWithIndexReversed.kt")
            public void testForInUnsignedArrayWithIndexReversed() throws Exception {
                runTest("compiler/testData/codegen/box/arrays/forInUnsignedArray/forInUnsignedArrayWithIndexReversed.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/box/arrays/multiDecl")
        @TestDataPath("$PROJECT_ROOT")
        public class MultiDecl {
            @Test
            public void testAllFilesPresentInMultiDecl() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/arrays/multiDecl"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("kt15560.kt")
            public void testKt15560() throws Exception {
                runTest("compiler/testData/codegen/box/arrays/multiDecl/kt15560.kt");
            }

            @Test
            @TestMetadata("kt15568.kt")
            public void testKt15568() throws Exception {
                runTest("compiler/testData/codegen/box/arrays/multiDecl/kt15568.kt");
            }

            @Test
            @TestMetadata("kt15575.kt")
            public void testKt15575() throws Exception {
                runTest("compiler/testData/codegen/box/arrays/multiDecl/kt15575.kt");
            }

            @Test
            @TestMetadata("MultiDeclFor.kt")
            public void testMultiDeclFor() throws Exception {
                runTest("compiler/testData/codegen/box/arrays/multiDecl/MultiDeclFor.kt");
            }

            @Test
            @TestMetadata("MultiDeclForComponentExtensions.kt")
            public void testMultiDeclForComponentExtensions() throws Exception {
                runTest("compiler/testData/codegen/box/arrays/multiDecl/MultiDeclForComponentExtensions.kt");
            }

            @Test
            @TestMetadata("MultiDeclForComponentMemberExtensions.kt")
            public void testMultiDeclForComponentMemberExtensions() throws Exception {
                runTest("compiler/testData/codegen/box/arrays/multiDecl/MultiDeclForComponentMemberExtensions.kt");
            }

            @Test
            @TestMetadata("MultiDeclForComponentMemberExtensionsInExtensionFunction.kt")
            public void testMultiDeclForComponentMemberExtensionsInExtensionFunction() throws Exception {
                runTest("compiler/testData/codegen/box/arrays/multiDecl/MultiDeclForComponentMemberExtensionsInExtensionFunction.kt");
            }

            @Test
            @TestMetadata("MultiDeclForValCaptured.kt")
            public void testMultiDeclForValCaptured() throws Exception {
                runTest("compiler/testData/codegen/box/arrays/multiDecl/MultiDeclForValCaptured.kt");
            }

            @Nested
            @TestMetadata("compiler/testData/codegen/box/arrays/multiDecl/int")
            @TestDataPath("$PROJECT_ROOT")
            public class Int {
                @Test
                public void testAllFilesPresentInInt() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/arrays/multiDecl/int"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
                }

                @Test
                @TestMetadata("MultiDeclForComponentExtensions.kt")
                public void testMultiDeclForComponentExtensions() throws Exception {
                    runTest("compiler/testData/codegen/box/arrays/multiDecl/int/MultiDeclForComponentExtensions.kt");
                }

                @Test
                @TestMetadata("MultiDeclForComponentExtensionsValCaptured.kt")
                public void testMultiDeclForComponentExtensionsValCaptured() throws Exception {
                    runTest("compiler/testData/codegen/box/arrays/multiDecl/int/MultiDeclForComponentExtensionsValCaptured.kt");
                }

                @Test
                @TestMetadata("MultiDeclForComponentMemberExtensions.kt")
                public void testMultiDeclForComponentMemberExtensions() throws Exception {
                    runTest("compiler/testData/codegen/box/arrays/multiDecl/int/MultiDeclForComponentMemberExtensions.kt");
                }

                @Test
                @TestMetadata("MultiDeclForComponentMemberExtensionsInExtensionFunction.kt")
                public void testMultiDeclForComponentMemberExtensionsInExtensionFunction() throws Exception {
                    runTest("compiler/testData/codegen/box/arrays/multiDecl/int/MultiDeclForComponentMemberExtensionsInExtensionFunction.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/testData/codegen/box/arrays/multiDecl/long")
            @TestDataPath("$PROJECT_ROOT")
            public class Long {
                @Test
                public void testAllFilesPresentInLong() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/arrays/multiDecl/long"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
                }

                @Test
                @TestMetadata("MultiDeclForComponentExtensions.kt")
                public void testMultiDeclForComponentExtensions() throws Exception {
                    runTest("compiler/testData/codegen/box/arrays/multiDecl/long/MultiDeclForComponentExtensions.kt");
                }

                @Test
                @TestMetadata("MultiDeclForComponentExtensionsValCaptured.kt")
                public void testMultiDeclForComponentExtensionsValCaptured() throws Exception {
                    runTest("compiler/testData/codegen/box/arrays/multiDecl/long/MultiDeclForComponentExtensionsValCaptured.kt");
                }

                @Test
                @TestMetadata("MultiDeclForComponentMemberExtensions.kt")
                public void testMultiDeclForComponentMemberExtensions() throws Exception {
                    runTest("compiler/testData/codegen/box/arrays/multiDecl/long/MultiDeclForComponentMemberExtensions.kt");
                }

                @Test
                @TestMetadata("MultiDeclForComponentMemberExtensionsInExtensionFunction.kt")
                public void testMultiDeclForComponentMemberExtensionsInExtensionFunction() throws Exception {
                    runTest("compiler/testData/codegen/box/arrays/multiDecl/long/MultiDeclForComponentMemberExtensionsInExtensionFunction.kt");
                }
            }
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/assert")
    @TestDataPath("$PROJECT_ROOT")
    public class Assert {
        @Test
        public void testAllFilesPresentInAssert() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/assert"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("alwaysDisable.kt")
        public void testAlwaysDisable() throws Exception {
            runTest("compiler/testData/codegen/box/assert/alwaysDisable.kt");
        }

        @Test
        @TestMetadata("alwaysEnable.kt")
        public void testAlwaysEnable() throws Exception {
            runTest("compiler/testData/codegen/box/assert/alwaysEnable.kt");
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/box/assert/jvm")
        @TestDataPath("$PROJECT_ROOT")
        public class Jvm {
            @Test
            public void testAllFilesPresentInJvm() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/assert/jvm"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("assertionsEnabledBeforeClassInitializers.kt")
            public void testAssertionsEnabledBeforeClassInitializers() throws Exception {
                runTest("compiler/testData/codegen/box/assert/jvm/assertionsEnabledBeforeClassInitializers.kt");
            }

            @Test
            @TestMetadata("classAssertions.kt")
            public void testClassAssertions() throws Exception {
                runTest("compiler/testData/codegen/box/assert/jvm/classAssertions.kt");
            }

            @Test
            @TestMetadata("classAssertionsForCompanion.kt")
            public void testClassAssertionsForCompanion() throws Exception {
                runTest("compiler/testData/codegen/box/assert/jvm/classAssertionsForCompanion.kt");
            }

            @Test
            @TestMetadata("classAssertionsForInnerClasses.kt")
            public void testClassAssertionsForInnerClasses() throws Exception {
                runTest("compiler/testData/codegen/box/assert/jvm/classAssertionsForInnerClasses.kt");
            }

            @Test
            @TestMetadata("classAssertionsForLocalClasses.kt")
            public void testClassAssertionsForLocalClasses() throws Exception {
                runTest("compiler/testData/codegen/box/assert/jvm/classAssertionsForLocalClasses.kt");
            }

            @Test
            @TestMetadata("classAssertionsForNestedClasses.kt")
            public void testClassAssertionsForNestedClasses() throws Exception {
                runTest("compiler/testData/codegen/box/assert/jvm/classAssertionsForNestedClasses.kt");
            }

            @Test
            @TestMetadata("interfaceAssertionsDisabled.kt")
            public void testInterfaceAssertionsDisabled() throws Exception {
                runTest("compiler/testData/codegen/box/assert/jvm/interfaceAssertionsDisabled.kt");
            }

            @Test
            @TestMetadata("interfaceAssertionsEnabled.kt")
            public void testInterfaceAssertionsEnabled() throws Exception {
                runTest("compiler/testData/codegen/box/assert/jvm/interfaceAssertionsEnabled.kt");
            }

            @Test
            @TestMetadata("lambdaNotEvaluated.kt")
            public void testLambdaNotEvaluated() throws Exception {
                runTest("compiler/testData/codegen/box/assert/jvm/lambdaNotEvaluated.kt");
            }

            @Test
            @TestMetadata("localAnonymousFunction.kt")
            public void testLocalAnonymousFunction() throws Exception {
                runTest("compiler/testData/codegen/box/assert/jvm/localAnonymousFunction.kt");
            }

            @Test
            @TestMetadata("localClass.kt")
            public void testLocalClass() throws Exception {
                runTest("compiler/testData/codegen/box/assert/jvm/localClass.kt");
            }

            @Test
            @TestMetadata("localFunction.kt")
            public void testLocalFunction() throws Exception {
                runTest("compiler/testData/codegen/box/assert/jvm/localFunction.kt");
            }

            @Test
            @TestMetadata("localLambda.kt")
            public void testLocalLambda() throws Exception {
                runTest("compiler/testData/codegen/box/assert/jvm/localLambda.kt");
            }

            @Test
            @TestMetadata("localObject.kt")
            public void testLocalObject() throws Exception {
                runTest("compiler/testData/codegen/box/assert/jvm/localObject.kt");
            }

            @Test
            @TestMetadata("noUnnecessaryClassInitialization.kt")
            public void testNoUnnecessaryClassInitialization() throws Exception {
                runTest("compiler/testData/codegen/box/assert/jvm/noUnnecessaryClassInitialization.kt");
            }

            @Test
            @TestMetadata("nonLocalReturn.kt")
            public void testNonLocalReturn() throws Exception {
                runTest("compiler/testData/codegen/box/assert/jvm/nonLocalReturn.kt");
            }

            @Test
            @TestMetadata("ordinary.kt")
            public void testOrdinary() throws Exception {
                runTest("compiler/testData/codegen/box/assert/jvm/ordinary.kt");
            }

            @Test
            @TestMetadata("superClassInitializer.kt")
            public void testSuperClassInitializer() throws Exception {
                runTest("compiler/testData/codegen/box/assert/jvm/superClassInitializer.kt");
            }

            @Test
            @TestMetadata("suspendFunctionAssertionDisabled.kt")
            public void testSuspendFunctionAssertionDisabled() throws Exception {
                runTest("compiler/testData/codegen/box/assert/jvm/suspendFunctionAssertionDisabled.kt");
            }

            @Test
            @TestMetadata("suspendFunctionAssertionsEnabled.kt")
            public void testSuspendFunctionAssertionsEnabled() throws Exception {
                runTest("compiler/testData/codegen/box/assert/jvm/suspendFunctionAssertionsEnabled.kt");
            }

            @Test
            @TestMetadata("suspendLambdaAssertionsDisabled.kt")
            public void testSuspendLambdaAssertionsDisabled() throws Exception {
                runTest("compiler/testData/codegen/box/assert/jvm/suspendLambdaAssertionsDisabled.kt");
            }

            @Test
            @TestMetadata("suspendLambdaAssertionsEnabled.kt")
            public void testSuspendLambdaAssertionsEnabled() throws Exception {
                runTest("compiler/testData/codegen/box/assert/jvm/suspendLambdaAssertionsEnabled.kt");
            }
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/binaryOp")
    @TestDataPath("$PROJECT_ROOT")
    public class BinaryOp {
        @Test
        public void testAllFilesPresentInBinaryOp() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/binaryOp"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("bitwiseOp.kt")
        public void testBitwiseOp() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/bitwiseOp.kt");
        }

        @Test
        @TestMetadata("bitwiseOpAny.kt")
        public void testBitwiseOpAny() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/bitwiseOpAny.kt");
        }

        @Test
        @TestMetadata("bitwiseOpNullable.kt")
        public void testBitwiseOpNullable() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/bitwiseOpNullable.kt");
        }

        @Test
        @TestMetadata("boxingOfLiteralReceiverWithIntegerValueType.kt")
        public void testBoxingOfLiteralReceiverWithIntegerValueType() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/boxingOfLiteralReceiverWithIntegerValueType.kt");
        }

        @Test
        @TestMetadata("call.kt")
        public void testCall() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/call.kt");
        }

        @Test
        @TestMetadata("callAny.kt")
        public void testCallAny() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/callAny.kt");
        }

        @Test
        @TestMetadata("callNullable.kt")
        public void testCallNullable() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/callNullable.kt");
        }

        @Test
        @TestMetadata("compareBoxedChars.kt")
        public void testCompareBoxedChars() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/compareBoxedChars.kt");
        }

        @Test
        @TestMetadata("compareWithBoxedDouble.kt")
        public void testCompareWithBoxedDouble() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/compareWithBoxedDouble.kt");
        }

        @Test
        @TestMetadata("compareWithBoxedLong.kt")
        public void testCompareWithBoxedLong() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/compareWithBoxedLong.kt");
        }

        @Test
        @TestMetadata("compareWithBoxedNotNullDouble.kt")
        public void testCompareWithBoxedNotNullDouble() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/compareWithBoxedNotNullDouble.kt");
        }

        @Test
        @TestMetadata("compareWithBoxedNotNullLong.kt")
        public void testCompareWithBoxedNotNullLong() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/compareWithBoxedNotNullLong.kt");
        }

        @Test
        @TestMetadata("divisionByZero.kt")
        public void testDivisionByZero() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/divisionByZero.kt");
        }

        @Test
        @TestMetadata("eqNullableDoubles.kt")
        public void testEqNullableDoubles() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/eqNullableDoubles.kt");
        }

        @Test
        @TestMetadata("eqNullableDoublesToInt.kt")
        public void testEqNullableDoublesToInt() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/eqNullableDoublesToInt.kt");
        }

        @Test
        @TestMetadata("eqNullableDoublesToIntWithTP.kt")
        public void testEqNullableDoublesToIntWithTP() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/eqNullableDoublesToIntWithTP.kt");
        }

        @Test
        @TestMetadata("eqNullableDoublesWithTP.kt")
        public void testEqNullableDoublesWithTP() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/eqNullableDoublesWithTP.kt");
        }

        @Test
        @TestMetadata("eqNullableShortToShort.kt")
        public void testEqNullableShortToShort() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/eqNullableShortToShort.kt");
        }

        @Test
        @TestMetadata("eqNullableToPrimitiveWithSideEffects.kt")
        public void testEqNullableToPrimitiveWithSideEffects() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/eqNullableToPrimitiveWithSideEffects.kt");
        }

        @Test
        @TestMetadata("intrinsic.kt")
        public void testIntrinsic() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/intrinsic.kt");
        }

        @Test
        @TestMetadata("intrinsicAny.kt")
        public void testIntrinsicAny() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/intrinsicAny.kt");
        }

        @Test
        @TestMetadata("intrinsicNullable.kt")
        public void testIntrinsicNullable() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/intrinsicNullable.kt");
        }

        @Test
        @TestMetadata("kt11163.kt")
        public void testKt11163() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/kt11163.kt");
        }

        @Test
        @TestMetadata("kt11163_properIeee754comparisons.kt")
        public void testKt11163_properIeee754comparisons() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/kt11163_properIeee754comparisons.kt");
        }

        @Test
        @TestMetadata("kt23030_properIeee754comparisons.kt")
        public void testKt23030_properIeee754comparisons() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/kt23030_properIeee754comparisons.kt");
        }

        @Test
        @TestMetadata("kt44402.kt")
        public void testKt44402() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/kt44402.kt");
        }

        @Test
        @TestMetadata("kt6747_identityEquals.kt")
        public void testKt6747_identityEquals() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/kt6747_identityEquals.kt");
        }

        @Test
        @TestMetadata("overflowChar.kt")
        public void testOverflowChar() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/overflowChar.kt");
        }

        @Test
        @TestMetadata("overflowInt.kt")
        public void testOverflowInt() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/overflowInt.kt");
        }

        @Test
        @TestMetadata("overflowLong.kt")
        public void testOverflowLong() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/overflowLong.kt");
        }

        @Test
        @TestMetadata("primitiveEqualsSafeCall.kt")
        public void testPrimitiveEqualsSafeCall() throws Exception {
            runTest("compiler/testData/codegen/box/binaryOp/primitiveEqualsSafeCall.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/boxingOptimization")
    @TestDataPath("$PROJECT_ROOT")
    public class BoxingOptimization {
        @Test
        public void testAllFilesPresentInBoxingOptimization() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/boxingOptimization"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("boxedIntegersCmp.kt")
        public void testBoxedIntegersCmp() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/boxedIntegersCmp.kt");
        }

        @Test
        @TestMetadata("boxedPrimitivesAreEqual.kt")
        public void testBoxedPrimitivesAreEqual() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/boxedPrimitivesAreEqual.kt");
        }

        @Test
        @TestMetadata("boxedRealsCmp.kt")
        public void testBoxedRealsCmp() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/boxedRealsCmp.kt");
        }

        @Test
        @TestMetadata("casts.kt")
        public void testCasts() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/casts.kt");
        }

        @Test
        @TestMetadata("checkcastAndInstanceOf.kt")
        public void testCheckcastAndInstanceOf() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/checkcastAndInstanceOf.kt");
        }

        @Test
        @TestMetadata("explicitEqualsOnDouble.kt")
        public void testExplicitEqualsOnDouble() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/explicitEqualsOnDouble.kt");
        }

        @Test
        @TestMetadata("fold.kt")
        public void testFold() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/fold.kt");
        }

        @Test
        @TestMetadata("foldRange.kt")
        public void testFoldRange() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/foldRange.kt");
        }

        @Test
        @TestMetadata("intCompareTo.kt")
        public void testIntCompareTo() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/intCompareTo.kt");
        }

        @Test
        @TestMetadata("kClassEquals.kt")
        public void testKClassEquals() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/kClassEquals.kt");
        }

        @Test
        @TestMetadata("kt15871.kt")
        public void testKt15871() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/kt15871.kt");
        }

        @Test
        @TestMetadata("kt17748.kt")
        public void testKt17748() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/kt17748.kt");
        }

        @Test
        @TestMetadata("kt19767.kt")
        public void testKt19767() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/kt19767.kt");
        }

        @Test
        @TestMetadata("kt19767_2.kt")
        public void testKt19767_2() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/kt19767_2.kt");
        }

        @Test
        @TestMetadata("kt19767_3.kt")
        public void testKt19767_3() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/kt19767_3.kt");
        }

        @Test
        @TestMetadata("kt19767_chain.kt")
        public void testKt19767_chain() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/kt19767_chain.kt");
        }

        @Test
        @TestMetadata("kt46859.kt")
        public void testKt46859() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/kt46859.kt");
        }

        @Test
        @TestMetadata("kt48394.kt")
        public void testKt48394() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/kt48394.kt");
        }

        @Test
        @TestMetadata("kt49092a.kt")
        public void testKt49092a() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/kt49092a.kt");
        }

        @Test
        @TestMetadata("kt49092b.kt")
        public void testKt49092b() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/kt49092b.kt");
        }

        @Test
        @TestMetadata("kt49092c.kt")
        public void testKt49092c() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/kt49092c.kt");
        }

        @Test
        @TestMetadata("kt49092d.kt")
        public void testKt49092d() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/kt49092d.kt");
        }

        @Test
        @TestMetadata("kt49092e.kt")
        public void testKt49092e() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/kt49092e.kt");
        }

        @Test
        @TestMetadata("kt49092f.kt")
        public void testKt49092f() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/kt49092f.kt");
        }

        @Test
        @TestMetadata("kt49548.kt")
        public void testKt49548() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/kt49548.kt");
        }

        @Test
        @TestMetadata("kt49548a.kt")
        public void testKt49548a() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/kt49548a.kt");
        }

        @Test
        @TestMetadata("kt5493.kt")
        public void testKt5493() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/kt5493.kt");
        }

        @Test
        @TestMetadata("kt5588.kt")
        public void testKt5588() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/kt5588.kt");
        }

        @Test
        @TestMetadata("kt5844.kt")
        public void testKt5844() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/kt5844.kt");
        }

        @Test
        @TestMetadata("kt6047.kt")
        public void testKt6047() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/kt6047.kt");
        }

        @Test
        @TestMetadata("kt6842.kt")
        public void testKt6842() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/kt6842.kt");
        }

        @Test
        @TestMetadata("maxMinByOrNull.kt")
        public void testMaxMinByOrNull() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/maxMinByOrNull.kt");
        }

        @Test
        @TestMetadata("nullCheck.kt")
        public void testNullCheck() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/nullCheck.kt");
        }

        @Test
        @TestMetadata("progressions.kt")
        public void testProgressions() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/progressions.kt");
        }

        @Test
        @TestMetadata("safeCallWithElvis.kt")
        public void testSafeCallWithElvis() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/safeCallWithElvis.kt");
        }

        @Test
        @TestMetadata("safeCallWithElvisAndEnhancedNullability.kt")
        public void testSafeCallWithElvisAndEnhancedNullability() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/safeCallWithElvisAndEnhancedNullability.kt");
        }

        @Test
        @TestMetadata("safeCallWithElvisMultipleFiles.kt")
        public void testSafeCallWithElvisMultipleFiles() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/safeCallWithElvisMultipleFiles.kt");
        }

        @Test
        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/simple.kt");
        }

        @Test
        @TestMetadata("simpleUninitializedMerge.kt")
        public void testSimpleUninitializedMerge() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/simpleUninitializedMerge.kt");
        }

        @Test
        @TestMetadata("taintedValues.kt")
        public void testTaintedValues() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/taintedValues.kt");
        }

        @Test
        @TestMetadata("taintedValuesBox.kt")
        public void testTaintedValuesBox() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/taintedValuesBox.kt");
        }

        @Test
        @TestMetadata("unsafeRemoving.kt")
        public void testUnsafeRemoving() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/unsafeRemoving.kt");
        }

        @Test
        @TestMetadata("unsignedArrayForEach.kt")
        public void testUnsignedArrayForEach() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/unsignedArrayForEach.kt");
        }

        @Test
        @TestMetadata("variables.kt")
        public void testVariables() throws Exception {
            runTest("compiler/testData/codegen/box/boxingOptimization/variables.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/bridges")
    @TestDataPath("$PROJECT_ROOT")
    public class Bridges {
        @Test
        @TestMetadata("abstractOverrideBridge.kt")
        public void testAbstractOverrideBridge() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/abstractOverrideBridge.kt");
        }

        @Test
        public void testAllFilesPresentInBridges() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/bridges"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("bridgeInInterface.kt")
        public void testBridgeInInterface() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/bridgeInInterface.kt");
        }

        @Test
        @TestMetadata("bridgeInInterfaceWithProperties.kt")
        public void testBridgeInInterfaceWithProperties() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/bridgeInInterfaceWithProperties.kt");
        }

        @Test
        @TestMetadata("complexMultiInheritance.kt")
        public void testComplexMultiInheritance() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/complexMultiInheritance.kt");
        }

        @Test
        @TestMetadata("complexTraitImpl.kt")
        public void testComplexTraitImpl() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/complexTraitImpl.kt");
        }

        @Test
        @TestMetadata("covariantGenericDiamond.kt")
        public void testCovariantGenericDiamond() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/covariantGenericDiamond.kt");
        }

        @Test
        @TestMetadata("delegation.kt")
        public void testDelegation() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/delegation.kt");
        }

        @Test
        @TestMetadata("delegationComplex.kt")
        public void testDelegationComplex() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/delegationComplex.kt");
        }

        @Test
        @TestMetadata("delegationComplexWithList.kt")
        public void testDelegationComplexWithList() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/delegationComplexWithList.kt");
        }

        @Test
        @TestMetadata("delegationProperty.kt")
        public void testDelegationProperty() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/delegationProperty.kt");
        }

        @Test
        @TestMetadata("diamond.kt")
        public void testDiamond() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/diamond.kt");
        }

        @Test
        @TestMetadata("fakeCovariantOverride.kt")
        public void testFakeCovariantOverride() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/fakeCovariantOverride.kt");
        }

        @Test
        @TestMetadata("fakeGenericCovariantOverride.kt")
        public void testFakeGenericCovariantOverride() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/fakeGenericCovariantOverride.kt");
        }

        @Test
        @TestMetadata("fakeGenericCovariantOverrideWithDelegation.kt")
        public void testFakeGenericCovariantOverrideWithDelegation() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/fakeGenericCovariantOverrideWithDelegation.kt");
        }

        @Test
        @TestMetadata("fakeOverrideFromInterfaceThroughIntermediateClass.kt")
        public void testFakeOverrideFromInterfaceThroughIntermediateClass() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/fakeOverrideFromInterfaceThroughIntermediateClass.kt");
        }

        @Test
        @TestMetadata("fakeOverrideMultiFile.kt")
        public void testFakeOverrideMultiFile() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/fakeOverrideMultiFile.kt");
        }

        @Test
        @TestMetadata("fakeOverrideOfTraitImpl.kt")
        public void testFakeOverrideOfTraitImpl() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/fakeOverrideOfTraitImpl.kt");
        }

        @Test
        @TestMetadata("fakeOverrideThroughGenericSuperclass.kt")
        public void testFakeOverrideThroughGenericSuperclass() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/fakeOverrideThroughGenericSuperclass.kt");
        }

        @Test
        @TestMetadata("fakeOverrideWithSeveralSuperDeclarations.kt")
        public void testFakeOverrideWithSeveralSuperDeclarations() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/fakeOverrideWithSeveralSuperDeclarations.kt");
        }

        @Test
        @TestMetadata("fakeOverrideWithSynthesizedImplementation.kt")
        public void testFakeOverrideWithSynthesizedImplementation() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/fakeOverrideWithSynthesizedImplementation.kt");
        }

        @Test
        @TestMetadata("genericProperty.kt")
        public void testGenericProperty() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/genericProperty.kt");
        }

        @Test
        @TestMetadata("innerClassTypeParameters.kt")
        public void testInnerClassTypeParameters() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/innerClassTypeParameters.kt");
        }

        @Test
        @TestMetadata("kt12416.kt")
        public void testKt12416() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/kt12416.kt");
        }

        @Test
        @TestMetadata("kt1939.kt")
        public void testKt1939() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/kt1939.kt");
        }

        @Test
        @TestMetadata("kt1959.kt")
        public void testKt1959() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/kt1959.kt");
        }

        @Test
        @TestMetadata("kt24193.kt")
        public void testKt24193() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/kt24193.kt");
        }

        @Test
        @TestMetadata("kt2498.kt")
        public void testKt2498() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/kt2498.kt");
        }

        @Test
        @TestMetadata("kt2702.kt")
        public void testKt2702() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/kt2702.kt");
        }

        @Test
        @TestMetadata("kt2833.kt")
        public void testKt2833() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/kt2833.kt");
        }

        @Test
        @TestMetadata("kt2920.kt")
        public void testKt2920() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/kt2920.kt");
        }

        @Test
        @TestMetadata("kt318.kt")
        public void testKt318() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/kt318.kt");
        }

        @Test
        @TestMetadata("kt42137.kt")
        public void testKt42137() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/kt42137.kt");
        }

        @Test
        @TestMetadata("kt46389.kt")
        public void testKt46389() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/kt46389.kt");
        }

        @Test
        @TestMetadata("kt46389_jvmDefault.kt")
        public void testKt46389_jvmDefault() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/kt46389_jvmDefault.kt");
        }

        @Test
        @TestMetadata("longChainOneBridge.kt")
        public void testLongChainOneBridge() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/longChainOneBridge.kt");
        }

        @Test
        @TestMetadata("manyTypeArgumentsSubstitutedSuccessively.kt")
        public void testManyTypeArgumentsSubstitutedSuccessively() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/manyTypeArgumentsSubstitutedSuccessively.kt");
        }

        @Test
        @TestMetadata("methodFromTrait.kt")
        public void testMethodFromTrait() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/methodFromTrait.kt");
        }

        @Test
        @TestMetadata("noBridgeOnMutableCollectionInheritance.kt")
        public void testNoBridgeOnMutableCollectionInheritance() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/noBridgeOnMutableCollectionInheritance.kt");
        }

        @Test
        @TestMetadata("objectClone.kt")
        public void testObjectClone() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/objectClone.kt");
        }

        @Test
        @TestMetadata("overrideAbstractProperty.kt")
        public void testOverrideAbstractProperty() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/overrideAbstractProperty.kt");
        }

        @Test
        @TestMetadata("overrideReturnType.kt")
        public void testOverrideReturnType() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/overrideReturnType.kt");
        }

        @Test
        @TestMetadata("overrideWithValueClassReturn.kt")
        public void testOverrideWithValueClassReturn() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/overrideWithValueClassReturn.kt");
        }

        @Test
        @TestMetadata("propertyAccessorsWithoutBody.kt")
        public void testPropertyAccessorsWithoutBody() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/propertyAccessorsWithoutBody.kt");
        }

        @Test
        @TestMetadata("propertyDiamond.kt")
        public void testPropertyDiamond() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/propertyDiamond.kt");
        }

        @Test
        @TestMetadata("propertyDiamondFakeOverride.kt")
        public void testPropertyDiamondFakeOverride() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/propertyDiamondFakeOverride.kt");
        }

        @Test
        @TestMetadata("propertyInConstructor.kt")
        public void testPropertyInConstructor() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/propertyInConstructor.kt");
        }

        @Test
        @TestMetadata("propertySetter.kt")
        public void testPropertySetter() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/propertySetter.kt");
        }

        @Test
        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/simple.kt");
        }

        @Test
        @TestMetadata("simpleEnum.kt")
        public void testSimpleEnum() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/simpleEnum.kt");
        }

        @Test
        @TestMetadata("simpleGenericMethod.kt")
        public void testSimpleGenericMethod() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/simpleGenericMethod.kt");
        }

        @Test
        @TestMetadata("simpleObject.kt")
        public void testSimpleObject() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/simpleObject.kt");
        }

        @Test
        @TestMetadata("simpleReturnType.kt")
        public void testSimpleReturnType() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/simpleReturnType.kt");
        }

        @Test
        @TestMetadata("simpleTraitImpl.kt")
        public void testSimpleTraitImpl() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/simpleTraitImpl.kt");
        }

        @Test
        @TestMetadata("simpleUpperBound.kt")
        public void testSimpleUpperBound() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/simpleUpperBound.kt");
        }

        @Test
        @TestMetadata("strListContains.kt")
        public void testStrListContains() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/strListContains.kt");
        }

        @Test
        @TestMetadata("strListRemove.kt")
        public void testStrListRemove() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/strListRemove.kt");
        }

        @Test
        @TestMetadata("traitImplInheritsTraitImpl.kt")
        public void testTraitImplInheritsTraitImpl() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/traitImplInheritsTraitImpl.kt");
        }

        @Test
        @TestMetadata("twoParentsWithDifferentMethodsTwoBridges.kt")
        public void testTwoParentsWithDifferentMethodsTwoBridges() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/twoParentsWithDifferentMethodsTwoBridges.kt");
        }

        @Test
        @TestMetadata("twoParentsWithDifferentMethodsTwoBridges2.kt")
        public void testTwoParentsWithDifferentMethodsTwoBridges2() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/twoParentsWithDifferentMethodsTwoBridges2.kt");
        }

        @Test
        @TestMetadata("twoParentsWithTheSameMethodOneBridge.kt")
        public void testTwoParentsWithTheSameMethodOneBridge() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/twoParentsWithTheSameMethodOneBridge.kt");
        }

        @Test
        @TestMetadata("typeParameterInExtensionReceiver.kt")
        public void testTypeParameterInExtensionReceiver() throws Exception {
            runTest("compiler/testData/codegen/box/bridges/typeParameterInExtensionReceiver.kt");
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/box/bridges/substitutionInSuperClass")
        @TestDataPath("$PROJECT_ROOT")
        public class SubstitutionInSuperClass {
            @Test
            @TestMetadata("abstractFun.kt")
            public void testAbstractFun() throws Exception {
                runTest("compiler/testData/codegen/box/bridges/substitutionInSuperClass/abstractFun.kt");
            }

            @Test
            public void testAllFilesPresentInSubstitutionInSuperClass() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/bridges/substitutionInSuperClass"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("boundedTypeArguments.kt")
            public void testBoundedTypeArguments() throws Exception {
                runTest("compiler/testData/codegen/box/bridges/substitutionInSuperClass/boundedTypeArguments.kt");
            }

            @Test
            @TestMetadata("delegation.kt")
            public void testDelegation() throws Exception {
                runTest("compiler/testData/codegen/box/bridges/substitutionInSuperClass/delegation.kt");
            }

            @Test
            @TestMetadata("differentErasureInSuperClass.kt")
            public void testDifferentErasureInSuperClass() throws Exception {
                runTest("compiler/testData/codegen/box/bridges/substitutionInSuperClass/differentErasureInSuperClass.kt");
            }

            @Test
            @TestMetadata("differentErasureInSuperClassComplex.kt")
            public void testDifferentErasureInSuperClassComplex() throws Exception {
                runTest("compiler/testData/codegen/box/bridges/substitutionInSuperClass/differentErasureInSuperClassComplex.kt");
            }

            @Test
            @TestMetadata("enum.kt")
            public void testEnum() throws Exception {
                runTest("compiler/testData/codegen/box/bridges/substitutionInSuperClass/enum.kt");
            }

            @Test
            @TestMetadata("genericMethod.kt")
            public void testGenericMethod() throws Exception {
                runTest("compiler/testData/codegen/box/bridges/substitutionInSuperClass/genericMethod.kt");
            }

            @Test
            @TestMetadata("object.kt")
            public void testObject() throws Exception {
                runTest("compiler/testData/codegen/box/bridges/substitutionInSuperClass/object.kt");
            }

            @Test
            @TestMetadata("property.kt")
            public void testProperty() throws Exception {
                runTest("compiler/testData/codegen/box/bridges/substitutionInSuperClass/property.kt");
            }

            @Test
            @TestMetadata("simple.kt")
            public void testSimple() throws Exception {
                runTest("compiler/testData/codegen/box/bridges/substitutionInSuperClass/simple.kt");
            }

            @Test
            @TestMetadata("upperBound.kt")
            public void testUpperBound() throws Exception {
                runTest("compiler/testData/codegen/box/bridges/substitutionInSuperClass/upperBound.kt");
            }
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/builtinStubMethods")
    @TestDataPath("$PROJECT_ROOT")
    public class BuiltinStubMethods {
        @Test
        @TestMetadata("abstractMember.kt")
        public void testAbstractMember() throws Exception {
            runTest("compiler/testData/codegen/box/builtinStubMethods/abstractMember.kt");
        }

        @Test
        public void testAllFilesPresentInBuiltinStubMethods() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/builtinStubMethods"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("Collection.kt")
        public void testCollection() throws Exception {
            runTest("compiler/testData/codegen/box/builtinStubMethods/Collection.kt");
        }

        @Test
        @TestMetadata("customReadOnlyIterator.kt")
        public void testCustomReadOnlyIterator() throws Exception {
            runTest("compiler/testData/codegen/box/builtinStubMethods/customReadOnlyIterator.kt");
        }

        @Test
        @TestMetadata("delegationToArrayList.kt")
        public void testDelegationToArrayList() throws Exception {
            runTest("compiler/testData/codegen/box/builtinStubMethods/delegationToArrayList.kt");
        }

        @Test
        @TestMetadata("immutableRemove.kt")
        public void testImmutableRemove() throws Exception {
            runTest("compiler/testData/codegen/box/builtinStubMethods/immutableRemove.kt");
        }

        @Test
        @TestMetadata("implementationInTrait.kt")
        public void testImplementationInTrait() throws Exception {
            runTest("compiler/testData/codegen/box/builtinStubMethods/implementationInTrait.kt");
        }

        @Test
        @TestMetadata("inheritedImplementations.kt")
        public void testInheritedImplementations() throws Exception {
            runTest("compiler/testData/codegen/box/builtinStubMethods/inheritedImplementations.kt");
        }

        @Test
        @TestMetadata("int2IntMap.kt")
        public void testInt2IntMap() throws Exception {
            runTest("compiler/testData/codegen/box/builtinStubMethods/int2IntMap.kt");
        }

        @Test
        @TestMetadata("Iterator.kt")
        public void testIterator() throws Exception {
            runTest("compiler/testData/codegen/box/builtinStubMethods/Iterator.kt");
        }

        @Test
        @TestMetadata("IteratorWithRemove.kt")
        public void testIteratorWithRemove() throws Exception {
            runTest("compiler/testData/codegen/box/builtinStubMethods/IteratorWithRemove.kt");
        }

        @Test
        @TestMetadata("List.kt")
        public void testList() throws Exception {
            runTest("compiler/testData/codegen/box/builtinStubMethods/List.kt");
        }

        @Test
        @TestMetadata("ListIterator.kt")
        public void testListIterator() throws Exception {
            runTest("compiler/testData/codegen/box/builtinStubMethods/ListIterator.kt");
        }

        @Test
        @TestMetadata("ListWithAllImplementations.kt")
        public void testListWithAllImplementations() throws Exception {
            runTest("compiler/testData/codegen/box/builtinStubMethods/ListWithAllImplementations.kt");
        }

        @Test
        @TestMetadata("ListWithAllInheritedImplementations.kt")
        public void testListWithAllInheritedImplementations() throws Exception {
            runTest("compiler/testData/codegen/box/builtinStubMethods/ListWithAllInheritedImplementations.kt");
        }

        @Test
        @TestMetadata("manyTypeParametersWithUpperBounds.kt")
        public void testManyTypeParametersWithUpperBounds() throws Exception {
            runTest("compiler/testData/codegen/box/builtinStubMethods/manyTypeParametersWithUpperBounds.kt");
        }

        @Test
        @TestMetadata("Map.kt")
        public void testMap() throws Exception {
            runTest("compiler/testData/codegen/box/builtinStubMethods/Map.kt");
        }

        @Test
        @TestMetadata("MapEntry.kt")
        public void testMapEntry() throws Exception {
            runTest("compiler/testData/codegen/box/builtinStubMethods/MapEntry.kt");
        }

        @Test
        @TestMetadata("MapEntryWithSetValue.kt")
        public void testMapEntryWithSetValue() throws Exception {
            runTest("compiler/testData/codegen/box/builtinStubMethods/MapEntryWithSetValue.kt");
        }

        @Test
        @TestMetadata("MapWithAllImplementations.kt")
        public void testMapWithAllImplementations() throws Exception {
            runTest("compiler/testData/codegen/box/builtinStubMethods/MapWithAllImplementations.kt");
        }

        @Test
        @TestMetadata("nonTrivialSubstitution.kt")
        public void testNonTrivialSubstitution() throws Exception {
            runTest("compiler/testData/codegen/box/builtinStubMethods/nonTrivialSubstitution.kt");
        }

        @Test
        @TestMetadata("nonTrivialUpperBound.kt")
        public void testNonTrivialUpperBound() throws Exception {
            runTest("compiler/testData/codegen/box/builtinStubMethods/nonTrivialUpperBound.kt");
        }

        @Test
        @TestMetadata("substitutedIterable.kt")
        public void testSubstitutedIterable() throws Exception {
            runTest("compiler/testData/codegen/box/builtinStubMethods/substitutedIterable.kt");
        }

        @Test
        @TestMetadata("SubstitutedList.kt")
        public void testSubstitutedList() throws Exception {
            runTest("compiler/testData/codegen/box/builtinStubMethods/SubstitutedList.kt");
        }

        @Test
        @TestMetadata("substitutedListWithExtraSuperInterface.kt")
        public void testSubstitutedListWithExtraSuperInterface() throws Exception {
            runTest("compiler/testData/codegen/box/builtinStubMethods/substitutedListWithExtraSuperInterface.kt");
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/box/builtinStubMethods/bridgesForStubs")
        @TestDataPath("$PROJECT_ROOT")
        public class BridgesForStubs {
            @Test
            public void testAllFilesPresentInBridgesForStubs() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/builtinStubMethods/bridgesForStubs"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("derivedEmptyListAdd.kt")
            public void testDerivedEmptyListAdd() throws Exception {
                runTest("compiler/testData/codegen/box/builtinStubMethods/bridgesForStubs/derivedEmptyListAdd.kt");
            }

            @Test
            @TestMetadata("derivedEmptyListSeveralModulesAdd.kt")
            public void testDerivedEmptyListSeveralModulesAdd() throws Exception {
                runTest("compiler/testData/codegen/box/builtinStubMethods/bridgesForStubs/derivedEmptyListSeveralModulesAdd.kt");
            }

            @Test
            @TestMetadata("derivedEmptyStringListAdd.kt")
            public void testDerivedEmptyStringListAdd() throws Exception {
                runTest("compiler/testData/codegen/box/builtinStubMethods/bridgesForStubs/derivedEmptyStringListAdd.kt");
            }

            @Test
            @TestMetadata("emptyListAdd.kt")
            public void testEmptyListAdd() throws Exception {
                runTest("compiler/testData/codegen/box/builtinStubMethods/bridgesForStubs/emptyListAdd.kt");
            }

            @Test
            @TestMetadata("emptyListAddWithIndex.kt")
            public void testEmptyListAddWithIndex() throws Exception {
                runTest("compiler/testData/codegen/box/builtinStubMethods/bridgesForStubs/emptyListAddWithIndex.kt");
            }

            @Test
            @TestMetadata("emptyListSet.kt")
            public void testEmptyListSet() throws Exception {
                runTest("compiler/testData/codegen/box/builtinStubMethods/bridgesForStubs/emptyListSet.kt");
            }

            @Test
            @TestMetadata("emptyStringListAdd.kt")
            public void testEmptyStringListAdd() throws Exception {
                runTest("compiler/testData/codegen/box/builtinStubMethods/bridgesForStubs/emptyStringListAdd.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/box/builtinStubMethods/extendJavaClasses")
        @TestDataPath("$PROJECT_ROOT")
        public class ExtendJavaClasses {
            @Test
            @TestMetadata("abstractList.kt")
            public void testAbstractList() throws Exception {
                runTest("compiler/testData/codegen/box/builtinStubMethods/extendJavaClasses/abstractList.kt");
            }

            @Test
            @TestMetadata("abstractMap.kt")
            public void testAbstractMap() throws Exception {
                runTest("compiler/testData/codegen/box/builtinStubMethods/extendJavaClasses/abstractMap.kt");
            }

            @Test
            @TestMetadata("abstractSet.kt")
            public void testAbstractSet() throws Exception {
                runTest("compiler/testData/codegen/box/builtinStubMethods/extendJavaClasses/abstractSet.kt");
            }

            @Test
            public void testAllFilesPresentInExtendJavaClasses() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/builtinStubMethods/extendJavaClasses"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("arrayList.kt")
            public void testArrayList() throws Exception {
                runTest("compiler/testData/codegen/box/builtinStubMethods/extendJavaClasses/arrayList.kt");
            }

            @Test
            @TestMetadata("charSequenceGetOverriddenInJavaSuperClass.kt")
            public void testCharSequenceGetOverriddenInJavaSuperClass() throws Exception {
                runTest("compiler/testData/codegen/box/builtinStubMethods/extendJavaClasses/charSequenceGetOverriddenInJavaSuperClass.kt");
            }

            @Test
            @TestMetadata("extendArrayListThroughKotlin.kt")
            public void testExtendArrayListThroughKotlin() throws Exception {
                runTest("compiler/testData/codegen/box/builtinStubMethods/extendJavaClasses/extendArrayListThroughKotlin.kt");
            }

            @Test
            @TestMetadata("hashMap.kt")
            public void testHashMap() throws Exception {
                runTest("compiler/testData/codegen/box/builtinStubMethods/extendJavaClasses/hashMap.kt");
            }

            @Test
            @TestMetadata("hashSet.kt")
            public void testHashSet() throws Exception {
                runTest("compiler/testData/codegen/box/builtinStubMethods/extendJavaClasses/hashSet.kt");
            }

            @Test
            @TestMetadata("mapEntry.kt")
            public void testMapEntry() throws Exception {
                runTest("compiler/testData/codegen/box/builtinStubMethods/extendJavaClasses/mapEntry.kt");
            }

            @Test
            @TestMetadata("numberMixedHierarchy.kt")
            public void testNumberMixedHierarchy() throws Exception {
                runTest("compiler/testData/codegen/box/builtinStubMethods/extendJavaClasses/numberMixedHierarchy.kt");
            }

            @Test
            @TestMetadata("removeAtBridgeToJavaClass.kt")
            public void testRemoveAtBridgeToJavaClass() throws Exception {
                runTest("compiler/testData/codegen/box/builtinStubMethods/extendJavaClasses/removeAtBridgeToJavaClass.kt");
            }

            @Test
            @TestMetadata("removeAtBridgeToJavaDefault.kt")
            public void testRemoveAtBridgeToJavaDefault() throws Exception {
                runTest("compiler/testData/codegen/box/builtinStubMethods/extendJavaClasses/removeAtBridgeToJavaDefault.kt");
            }

            @Test
            @TestMetadata("removeAtBridgeToJavaSuperClass.kt")
            public void testRemoveAtBridgeToJavaSuperClass() throws Exception {
                runTest("compiler/testData/codegen/box/builtinStubMethods/extendJavaClasses/removeAtBridgeToJavaSuperClass.kt");
            }

            @Test
            @TestMetadata("superCallToFakeRemoveAt.kt")
            public void testSuperCallToFakeRemoveAt() throws Exception {
                runTest("compiler/testData/codegen/box/builtinStubMethods/extendJavaClasses/superCallToFakeRemoveAt.kt");
            }

            @Test
            @TestMetadata("superCallToRemoveAt.kt")
            public void testSuperCallToRemoveAt() throws Exception {
                runTest("compiler/testData/codegen/box/builtinStubMethods/extendJavaClasses/superCallToRemoveAt.kt");
            }

            @Test
            @TestMetadata("superCallToRemoveAtInJavaDefault.kt")
            public void testSuperCallToRemoveAtInJavaDefault() throws Exception {
                runTest("compiler/testData/codegen/box/builtinStubMethods/extendJavaClasses/superCallToRemoveAtInJavaDefault.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/box/builtinStubMethods/mapGetOrDefault")
        @TestDataPath("$PROJECT_ROOT")
        public class MapGetOrDefault {
            @Test
            public void testAllFilesPresentInMapGetOrDefault() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/builtinStubMethods/mapGetOrDefault"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("noTypeSafeBridge.kt")
            public void testNoTypeSafeBridge() throws Exception {
                runTest("compiler/testData/codegen/box/builtinStubMethods/mapGetOrDefault/noTypeSafeBridge.kt");
            }

            @Test
            @TestMetadata("typeSafeBridge.kt")
            public void testTypeSafeBridge() throws Exception {
                runTest("compiler/testData/codegen/box/builtinStubMethods/mapGetOrDefault/typeSafeBridge.kt");
            }

            @Test
            @TestMetadata("typeSafeBridgeNotNullAny.kt")
            public void testTypeSafeBridgeNotNullAny() throws Exception {
                runTest("compiler/testData/codegen/box/builtinStubMethods/mapGetOrDefault/typeSafeBridgeNotNullAny.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/box/builtinStubMethods/mapRemove")
        @TestDataPath("$PROJECT_ROOT")
        public class MapRemove {
            @Test
            public void testAllFilesPresentInMapRemove() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/builtinStubMethods/mapRemove"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("noDefaultImpls.kt")
            public void testNoDefaultImpls() throws Exception {
                runTest("compiler/testData/codegen/box/builtinStubMethods/mapRemove/noDefaultImpls.kt");
            }

            @Test
            @TestMetadata("readOnlyMap.kt")
            public void testReadOnlyMap() throws Exception {
                runTest("compiler/testData/codegen/box/builtinStubMethods/mapRemove/readOnlyMap.kt");
            }

            @Test
            @TestMetadata("typeSafeBridge.kt")
            public void testTypeSafeBridge() throws Exception {
                runTest("compiler/testData/codegen/box/builtinStubMethods/mapRemove/typeSafeBridge.kt");
            }

            @Test
            @TestMetadata("typeSafeBridgeNotNullAny.kt")
            public void testTypeSafeBridgeNotNullAny() throws Exception {
                runTest("compiler/testData/codegen/box/builtinStubMethods/mapRemove/typeSafeBridgeNotNullAny.kt");
            }
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/callableReference")
    @TestDataPath("$PROJECT_ROOT")
    public class CallableReference {
        @Test
        public void testAllFilesPresentInCallableReference() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/callableReference"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("arrayConstructor.kt")
        public void testArrayConstructor() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/arrayConstructor.kt");
        }

        @Test
        @TestMetadata("arrayConstructorArgument.kt")
        public void testArrayConstructorArgument() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/arrayConstructorArgument.kt");
        }

        @Test
        @TestMetadata("arrayOf.kt")
        public void testArrayOf() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/arrayOf.kt");
        }

        @Test
        @TestMetadata("builtinFunctionReferenceOwner.kt")
        public void testBuiltinFunctionReferenceOwner() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/builtinFunctionReferenceOwner.kt");
        }

        @Test
        @TestMetadata("callableReferenceOfCompanionConst.kt")
        public void testCallableReferenceOfCompanionConst() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/callableReferenceOfCompanionConst.kt");
        }

        @Test
        @TestMetadata("callableReferenceOfCompanionMethod.kt")
        public void testCallableReferenceOfCompanionMethod() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/callableReferenceOfCompanionMethod.kt");
        }

        @Test
        @TestMetadata("callableReferenceOfCompanionProperty.kt")
        public void testCallableReferenceOfCompanionProperty() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/callableReferenceOfCompanionProperty.kt");
        }

        @Test
        @TestMetadata("callableReferenceOfJavaNestedClass.kt")
        public void testCallableReferenceOfJavaNestedClass() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/callableReferenceOfJavaNestedClass.kt");
        }

        @Test
        @TestMetadata("callableReferenceOfKotlinNestedClass.kt")
        public void testCallableReferenceOfKotlinNestedClass() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/callableReferenceOfKotlinNestedClass.kt");
        }

        @Test
        @TestMetadata("callableReferenceOfNestedClass.kt")
        public void testCallableReferenceOfNestedClass() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/callableReferenceOfNestedClass.kt");
        }

        @Test
        @TestMetadata("callableReferenceOfObjectMethod.kt")
        public void testCallableReferenceOfObjectMethod() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/callableReferenceOfObjectMethod.kt");
        }

        @Test
        @TestMetadata("callableReferenceOfStaticField.kt")
        public void testCallableReferenceOfStaticField() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/callableReferenceOfStaticField.kt");
        }

        @Test
        @TestMetadata("callableReferenceOfStaticMethod.kt")
        public void testCallableReferenceOfStaticMethod() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/callableReferenceOfStaticMethod.kt");
        }

        @Test
        @TestMetadata("charArrayOf.kt")
        public void testCharArrayOf() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/charArrayOf.kt");
        }

        @Test
        @TestMetadata("classesAreSynthetic.kt")
        public void testClassesAreSynthetic() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/classesAreSynthetic.kt");
        }

        @Test
        @TestMetadata("constructor.kt")
        public void testConstructor() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/constructor.kt");
        }

        @Test
        @TestMetadata("genericConstructorReference.kt")
        public void testGenericConstructorReference() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/genericConstructorReference.kt");
        }

        @Test
        @TestMetadata("genericLocalClassConstructorReference.kt")
        public void testGenericLocalClassConstructorReference() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/genericLocalClassConstructorReference.kt");
        }

        @Test
        @TestMetadata("inlineArrayConstructors.kt")
        public void testInlineArrayConstructors() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/inlineArrayConstructors.kt");
        }

        @Test
        @TestMetadata("javaField.kt")
        public void testJavaField() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/javaField.kt");
        }

        @Test
        @TestMetadata("kt16412.kt")
        public void testKt16412() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/kt16412.kt");
        }

        @Test
        @TestMetadata("kt16752.kt")
        public void testKt16752() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/kt16752.kt");
        }

        @Test
        @TestMetadata("kt21014.kt")
        public void testKt21014() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/kt21014.kt");
        }

        @Test
        @TestMetadata("kt21092a.kt")
        public void testKt21092a() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/kt21092a.kt");
        }

        @Test
        @TestMetadata("kt21092b.kt")
        public void testKt21092b() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/kt21092b.kt");
        }

        @Test
        @TestMetadata("kt37604.kt")
        public void testKt37604() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/kt37604.kt");
        }

        @Test
        @TestMetadata("kt44483.kt")
        public void testKt44483() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/kt44483.kt");
        }

        @Test
        @TestMetadata("kt46902.kt")
        public void testKt46902() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/kt46902.kt");
        }

        @Test
        @TestMetadata("kt47988.kt")
        public void testKt47988() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/kt47988.kt");
        }

        @Test
        @TestMetadata("kt49526.kt")
        public void testKt49526() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/kt49526.kt");
        }

        @Test
        @TestMetadata("kt49526_sam.kt")
        public void testKt49526_sam() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/kt49526_sam.kt");
        }

        @Test
        @TestMetadata("kt49526a.kt")
        public void testKt49526a() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/kt49526a.kt");
        }

        @Test
        @TestMetadata("kt49526b.kt")
        public void testKt49526b() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/kt49526b.kt");
        }

        @Test
        @TestMetadata("kt50172.kt")
        public void testKt50172() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/kt50172.kt");
        }

        @Test
        @TestMetadata("kt51844.kt")
        public void testKt51844() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/kt51844.kt");
        }

        @Test
        @TestMetadata("nested.kt")
        public void testNested() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/nested.kt");
        }

        @Test
        @TestMetadata("optimizedSuperclasses_after.kt")
        public void testOptimizedSuperclasses_after() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/optimizedSuperclasses_after.kt");
        }

        @Test
        @TestMetadata("optimizedSuperclasses_before.kt")
        public void testOptimizedSuperclasses_before() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/optimizedSuperclasses_before.kt");
        }

        @Test
        @TestMetadata("publicFinalField.kt")
        public void testPublicFinalField() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/publicFinalField.kt");
        }

        @Test
        @TestMetadata("publicMutableField.kt")
        public void testPublicMutableField() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/publicMutableField.kt");
        }

        @Test
        @TestMetadata("staticMethod.kt")
        public void testStaticMethod() throws Exception {
            runTest("compiler/testData/codegen/box/callableReference/staticMethod.kt");
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/box/callableReference/adaptedReferences")
        @TestDataPath("$PROJECT_ROOT")
        public class AdaptedReferences {
            @Test
            @TestMetadata("adaptedArrayOf.kt")
            public void testAdaptedArrayOf() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/adaptedArrayOf.kt");
            }

            @Test
            @TestMetadata("adaptedVarargFunImportedFromObject.kt")
            public void testAdaptedVarargFunImportedFromObject() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/adaptedVarargFunImportedFromObject.kt");
            }

            @Test
            public void testAllFilesPresentInAdaptedReferences() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/callableReference/adaptedReferences"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("bothWithCoercionToUnit.kt")
            public void testBothWithCoercionToUnit() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/bothWithCoercionToUnit.kt");
            }

            @Test
            @TestMetadata("boundReferences.kt")
            public void testBoundReferences() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/boundReferences.kt");
            }

            @Test
            @TestMetadata("defaultAfterVararg.kt")
            public void testDefaultAfterVararg() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/defaultAfterVararg.kt");
            }

            @Test
            @TestMetadata("defaultWithGenericExpectedType.kt")
            public void testDefaultWithGenericExpectedType() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/defaultWithGenericExpectedType.kt");
            }

            @Test
            @TestMetadata("emptyVarargAndDefault.kt")
            public void testEmptyVarargAndDefault() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/emptyVarargAndDefault.kt");
            }

            @Test
            @TestMetadata("inlineBound.kt")
            public void testInlineBound() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/inlineBound.kt");
            }

            @Test
            @TestMetadata("inlineDefault.kt")
            public void testInlineDefault() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/inlineDefault.kt");
            }

            @Test
            @TestMetadata("inlineVararg.kt")
            public void testInlineVararg() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/inlineVararg.kt");
            }

            @Test
            @TestMetadata("inlineVarargAndDefault.kt")
            public void testInlineVarargAndDefault() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/inlineVarargAndDefault.kt");
            }

            @Test
            @TestMetadata("inlineVarargInts.kt")
            public void testInlineVarargInts() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/inlineVarargInts.kt");
            }

            @Test
            @TestMetadata("innerConstructorWithVararg.kt")
            public void testInnerConstructorWithVararg() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/innerConstructorWithVararg.kt");
            }

            @Test
            @TestMetadata("jvmStatic.kt")
            public void testJvmStatic() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/jvmStatic.kt");
            }

            @Test
            @TestMetadata("largeVararg.kt")
            public void testLargeVararg() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/largeVararg.kt");
            }

            @Test
            @TestMetadata("localFunctionWithDefault.kt")
            public void testLocalFunctionWithDefault() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/localFunctionWithDefault.kt");
            }

            @Test
            @TestMetadata("manyDefaultsAndVararg.kt")
            public void testManyDefaultsAndVararg() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/manyDefaultsAndVararg.kt");
            }

            @Test
            @TestMetadata("noAdaptedReferencesIfNoOptimizedReferencesEnabled.kt")
            public void testNoAdaptedReferencesIfNoOptimizedReferencesEnabled() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/noAdaptedReferencesIfNoOptimizedReferencesEnabled.kt");
            }

            @Test
            @TestMetadata("noNameClashForReferencesToSameFunction.kt")
            public void testNoNameClashForReferencesToSameFunction() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/noNameClashForReferencesToSameFunction.kt");
            }

            @Test
            @TestMetadata("noReflectionForAdaptedCallableReferences.kt")
            public void testNoReflectionForAdaptedCallableReferences() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/noReflectionForAdaptedCallableReferences.kt");
            }

            @Test
            @TestMetadata("noReflectionForAdaptedCallableReferencesWithSuspendConversion.kt")
            public void testNoReflectionForAdaptedCallableReferencesWithSuspendConversion() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/noReflectionForAdaptedCallableReferencesWithSuspendConversion.kt");
            }

            @Test
            @TestMetadata("referenceToVarargWithDefaults.kt")
            public void testReferenceToVarargWithDefaults() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/referenceToVarargWithDefaults.kt");
            }

            @Test
            @TestMetadata("reflectionForVarargAsArray.kt")
            public void testReflectionForVarargAsArray() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/reflectionForVarargAsArray.kt");
            }

            @Test
            @TestMetadata("simpleDefaultArgument.kt")
            public void testSimpleDefaultArgument() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/simpleDefaultArgument.kt");
            }

            @Test
            @TestMetadata("simpleEmptyVararg.kt")
            public void testSimpleEmptyVararg() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/simpleEmptyVararg.kt");
            }

            @Test
            @TestMetadata("suspendUnitConversion.kt")
            public void testSuspendUnitConversion() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/suspendUnitConversion.kt");
            }

            @Test
            @TestMetadata("toStringNoReflect.kt")
            public void testToStringNoReflect() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/toStringNoReflect.kt");
            }

            @Test
            @TestMetadata("unboundReferences.kt")
            public void testUnboundReferences() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/unboundReferences.kt");
            }

            @Test
            @TestMetadata("varargFromBaseClass.kt")
            public void testVarargFromBaseClass() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/varargFromBaseClass.kt");
            }

            @Test
            @TestMetadata("varargViewedAsArray.kt")
            public void testVarargViewedAsArray() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/varargViewedAsArray.kt");
            }

            @Test
            @TestMetadata("varargViewedAsPrimitiveArray.kt")
            public void testVarargViewedAsPrimitiveArray() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/varargViewedAsPrimitiveArray.kt");
            }

            @Test
            @TestMetadata("varargWithDefaultValue.kt")
            public void testVarargWithDefaultValue() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/varargWithDefaultValue.kt");
            }

            @Test
            @TestMetadata("withReceiver.kt")
            public void testWithReceiver() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/withReceiver.kt");
            }

            @Nested
            @TestMetadata("compiler/testData/codegen/box/callableReference/adaptedReferences/suspendConversion")
            @TestDataPath("$PROJECT_ROOT")
            public class SuspendConversion {
                @Test
                @TestMetadata("adaptedWithCoercionToUnit.kt")
                public void testAdaptedWithCoercionToUnit() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/suspendConversion/adaptedWithCoercionToUnit.kt");
                }

                @Test
                @TestMetadata("adaptedWithDefaultArguments.kt")
                public void testAdaptedWithDefaultArguments() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/suspendConversion/adaptedWithDefaultArguments.kt");
                }

                @Test
                @TestMetadata("adaptedWithVarargs.kt")
                public void testAdaptedWithVarargs() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/suspendConversion/adaptedWithVarargs.kt");
                }

                @Test
                public void testAllFilesPresentInSuspendConversion() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/callableReference/adaptedReferences/suspendConversion"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
                }

                @Test
                @TestMetadata("bound.kt")
                public void testBound() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/suspendConversion/bound.kt");
                }

                @Test
                @TestMetadata("boundExtension.kt")
                public void testBoundExtension() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/suspendConversion/boundExtension.kt");
                }

                @Test
                @TestMetadata("crossInline.kt")
                public void testCrossInline() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/suspendConversion/crossInline.kt");
                }

                @Test
                @TestMetadata("inlineAdaptedWithCoercionToUnit.kt")
                public void testInlineAdaptedWithCoercionToUnit() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/suspendConversion/inlineAdaptedWithCoercionToUnit.kt");
                }

                @Test
                @TestMetadata("inlineAdaptedWithDefaultArguments.kt")
                public void testInlineAdaptedWithDefaultArguments() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/suspendConversion/inlineAdaptedWithDefaultArguments.kt");
                }

                @Test
                @TestMetadata("inlineAdaptedWithVarargs.kt")
                public void testInlineAdaptedWithVarargs() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/suspendConversion/inlineAdaptedWithVarargs.kt");
                }

                @Test
                @TestMetadata("inlineBound.kt")
                public void testInlineBound() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/suspendConversion/inlineBound.kt");
                }

                @Test
                @TestMetadata("inlineSimple.kt")
                public void testInlineSimple() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/suspendConversion/inlineSimple.kt");
                }

                @Test
                @TestMetadata("inlineWithParameters.kt")
                public void testInlineWithParameters() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/suspendConversion/inlineWithParameters.kt");
                }

                @Test
                @TestMetadata("isAs.kt")
                public void testIsAs() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/suspendConversion/isAs.kt");
                }

                @Test
                @TestMetadata("nullableParameter.kt")
                public void testNullableParameter() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/suspendConversion/nullableParameter.kt");
                }

                @Test
                @TestMetadata("simple.kt")
                public void testSimple() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/suspendConversion/simple.kt");
                }

                @Test
                @TestMetadata("withParameters.kt")
                public void testWithParameters() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/adaptedReferences/suspendConversion/withParameters.kt");
                }
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/box/callableReference/bound")
        @TestDataPath("$PROJECT_ROOT")
        public class Bound {
            @Test
            @TestMetadata("adapted.kt")
            public void testAdapted() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/adapted.kt");
            }

            @Test
            public void testAllFilesPresentInBound() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/callableReference/bound"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("array.kt")
            public void testArray() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/array.kt");
            }

            @Test
            @TestMetadata("arrayConstructorArgument.kt")
            public void testArrayConstructorArgument() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/arrayConstructorArgument.kt");
            }

            @Test
            @TestMetadata("arrayGetIntrinsic.kt")
            public void testArrayGetIntrinsic() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/arrayGetIntrinsic.kt");
            }

            @Test
            @TestMetadata("boundJvmFieldInInterfaceCompanion.kt")
            public void testBoundJvmFieldInInterfaceCompanion() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/boundJvmFieldInInterfaceCompanion.kt");
            }

            @Test
            @TestMetadata("boundReferenceToOverloadedFunction.kt")
            public void testBoundReferenceToOverloadedFunction() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/boundReferenceToOverloadedFunction.kt");
            }

            @Test
            @TestMetadata("captureVarInInitBlock.kt")
            public void testCaptureVarInInitBlock() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/captureVarInInitBlock.kt");
            }

            @Test
            @TestMetadata("captureVarInPropertyInit.kt")
            public void testCaptureVarInPropertyInit() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/captureVarInPropertyInit.kt");
            }

            @Test
            @TestMetadata("coercionToUnit.kt")
            public void testCoercionToUnit() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/coercionToUnit.kt");
            }

            @Test
            @TestMetadata("companionObjectReceiver.kt")
            public void testCompanionObjectReceiver() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/companionObjectReceiver.kt");
            }

            @Test
            @TestMetadata("dontShareReceiver.kt")
            public void testDontShareReceiver() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/dontShareReceiver.kt");
            }

            @Test
            @TestMetadata("emptyLHS.kt")
            public void testEmptyLHS() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/emptyLHS.kt");
            }

            @Test
            @TestMetadata("enumEntryMember.kt")
            public void testEnumEntryMember() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/enumEntryMember.kt");
            }

            @Test
            @TestMetadata("genericBoundPropertyAsCrossinline.kt")
            public void testGenericBoundPropertyAsCrossinline() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/genericBoundPropertyAsCrossinline.kt");
            }

            @Test
            @TestMetadata("genericValOnLHS.kt")
            public void testGenericValOnLHS() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/genericValOnLHS.kt");
            }

            @Test
            @TestMetadata("javaField.kt")
            public void testJavaField() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/javaField.kt");
            }

            @Test
            @TestMetadata("kCallableNameIntrinsic.kt")
            public void testKCallableNameIntrinsic() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/kCallableNameIntrinsic.kt");
            }

            @Test
            @TestMetadata("kt12738.kt")
            public void testKt12738() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/kt12738.kt");
            }

            @Test
            @TestMetadata("kt15446.kt")
            public void testKt15446() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/kt15446.kt");
            }

            @Test
            @TestMetadata("kt44636_localExtension.kt")
            public void testKt44636_localExtension() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/kt44636_localExtension.kt");
            }

            @Test
            @TestMetadata("localUnitFunction.kt")
            public void testLocalUnitFunction() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/localUnitFunction.kt");
            }

            @Test
            @TestMetadata("multiCase.kt")
            public void testMultiCase() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/multiCase.kt");
            }

            @Test
            @TestMetadata("nullReceiver.kt")
            public void testNullReceiver() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/nullReceiver.kt");
            }

            @Test
            @TestMetadata("objectReceiver.kt")
            public void testObjectReceiver() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/objectReceiver.kt");
            }

            @Test
            @TestMetadata("primitiveReceiver.kt")
            public void testPrimitiveReceiver() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/primitiveReceiver.kt");
            }

            @Test
            @TestMetadata("receiverEvaluatedOnce.kt")
            public void testReceiverEvaluatedOnce() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/receiverEvaluatedOnce.kt");
            }

            @Test
            @TestMetadata("referenceToGetSetMethodsFromVararg.kt")
            public void testReferenceToGetSetMethodsFromVararg() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/referenceToGetSetMethodsFromVararg.kt");
            }

            @Test
            @TestMetadata("simpleFunction.kt")
            public void testSimpleFunction() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/simpleFunction.kt");
            }

            @Test
            @TestMetadata("simpleProperty.kt")
            public void testSimpleProperty() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/simpleProperty.kt");
            }

            @Test
            @TestMetadata("smartCastForExtensionReceiver.kt")
            public void testSmartCastForExtensionReceiver() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/smartCastForExtensionReceiver.kt");
            }

            @Test
            @TestMetadata("syntheticExtensionOnLHS.kt")
            public void testSyntheticExtensionOnLHS() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/bound/syntheticExtensionOnLHS.kt");
            }

            @Nested
            @TestMetadata("compiler/testData/codegen/box/callableReference/bound/equals")
            @TestDataPath("$PROJECT_ROOT")
            public class Equals {
                @Test
                public void testAllFilesPresentInEquals() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/callableReference/bound/equals"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
                }

                @Test
                @TestMetadata("nullableReceiverInEquals.kt")
                public void testNullableReceiverInEquals() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/bound/equals/nullableReceiverInEquals.kt");
                }

                @Test
                @TestMetadata("receiverInEquals.kt")
                public void testReceiverInEquals() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/bound/equals/receiverInEquals.kt");
                }

                @Test
                @TestMetadata("reflectionReference.kt")
                public void testReflectionReference() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/bound/equals/reflectionReference.kt");
                }
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/box/callableReference/equality")
        @TestDataPath("$PROJECT_ROOT")
        public class Equality {
            @Test
            public void testAllFilesPresentInEquality() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/callableReference/equality"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("capturedDefaults.kt")
            public void testCapturedDefaults() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/equality/capturedDefaults.kt");
            }

            @Test
            @TestMetadata("capturedVararg.kt")
            public void testCapturedVararg() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/equality/capturedVararg.kt");
            }

            @Test
            @TestMetadata("coercionToUnit.kt")
            public void testCoercionToUnit() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/equality/coercionToUnit.kt");
            }

            @Test
            @TestMetadata("coercionToUnitWithDefaults.kt")
            public void testCoercionToUnitWithDefaults() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/equality/coercionToUnitWithDefaults.kt");
            }

            @Test
            @TestMetadata("coercionToUnitWithVararg.kt")
            public void testCoercionToUnitWithVararg() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/equality/coercionToUnitWithVararg.kt");
            }

            @Test
            @TestMetadata("extensionReceiverVsDefault.kt")
            public void testExtensionReceiverVsDefault() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/equality/extensionReceiverVsDefault.kt");
            }

            @Test
            @TestMetadata("noCoercionToUnitIfFunctionAlreadyReturnsUnit.kt")
            public void testNoCoercionToUnitIfFunctionAlreadyReturnsUnit() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/equality/noCoercionToUnitIfFunctionAlreadyReturnsUnit.kt");
            }

            @Test
            @TestMetadata("simpleEquality.kt")
            public void testSimpleEquality() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/equality/simpleEquality.kt");
            }

            @Test
            @TestMetadata("suspendConversion.kt")
            public void testSuspendConversion() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/equality/suspendConversion.kt");
            }

            @Test
            @TestMetadata("varargAsArrayMemberOrExtension.kt")
            public void testVarargAsArrayMemberOrExtension() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/equality/varargAsArrayMemberOrExtension.kt");
            }

            @Test
            @TestMetadata("varargAsArrayWithDefaults.kt")
            public void testVarargAsArrayWithDefaults() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/equality/varargAsArrayWithDefaults.kt");
            }

            @Test
            @TestMetadata("varargWithDefaults.kt")
            public void testVarargWithDefaults() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/equality/varargWithDefaults.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/box/callableReference/funInterfaceConstructor")
        @TestDataPath("$PROJECT_ROOT")
        public class FunInterfaceConstructor {
            @Test
            public void testAllFilesPresentInFunInterfaceConstructor() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/callableReference/funInterfaceConstructor"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("funInterfaceConstructedObjectsEquality.kt")
            public void testFunInterfaceConstructedObjectsEquality() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/funInterfaceConstructor/funInterfaceConstructedObjectsEquality.kt");
            }

            @Test
            @TestMetadata("funInterfaceConstructor.kt")
            public void testFunInterfaceConstructor() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/funInterfaceConstructor/funInterfaceConstructor.kt");
            }

            @Test
            @TestMetadata("funInterfaceConstructorEquality.kt")
            public void testFunInterfaceConstructorEquality() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/funInterfaceConstructor/funInterfaceConstructorEquality.kt");
            }

            @Test
            @TestMetadata("funInterfaceConstructorIsKFunction.kt")
            public void testFunInterfaceConstructorIsKFunction() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/funInterfaceConstructor/funInterfaceConstructorIsKFunction.kt");
            }

            @Test
            @TestMetadata("funInterfaceConstructorOfImplicitKFunctionType.kt")
            public void testFunInterfaceConstructorOfImplicitKFunctionType() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/funInterfaceConstructor/funInterfaceConstructorOfImplicitKFunctionType.kt");
            }

            @Test
            @TestMetadata("funInterfaceConstructorThrowsNpe.kt")
            public void testFunInterfaceConstructorThrowsNpe() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/funInterfaceConstructor/funInterfaceConstructorThrowsNpe.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/box/callableReference/function")
        @TestDataPath("$PROJECT_ROOT")
        public class Function {
            @Test
            @TestMetadata("abstractClassMember.kt")
            public void testAbstractClassMember() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/abstractClassMember.kt");
            }

            @Test
            public void testAllFilesPresentInFunction() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/callableReference/function"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("argumentTypes.kt")
            public void testArgumentTypes() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/argumentTypes.kt");
            }

            @Test
            @TestMetadata("argumentTypesNoinline.kt")
            public void testArgumentTypesNoinline() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/argumentTypesNoinline.kt");
            }

            @Test
            @TestMetadata("booleanNotIntrinsic.kt")
            public void testBooleanNotIntrinsic() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/booleanNotIntrinsic.kt");
            }

            @Test
            @TestMetadata("classMemberFromClass.kt")
            public void testClassMemberFromClass() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/classMemberFromClass.kt");
            }

            @Test
            @TestMetadata("classMemberFromCompanionObject.kt")
            public void testClassMemberFromCompanionObject() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/classMemberFromCompanionObject.kt");
            }

            @Test
            @TestMetadata("classMemberFromExtension.kt")
            public void testClassMemberFromExtension() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/classMemberFromExtension.kt");
            }

            @Test
            @TestMetadata("classMemberFromTopLevelStringNoArgs.kt")
            public void testClassMemberFromTopLevelStringNoArgs() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/classMemberFromTopLevelStringNoArgs.kt");
            }

            @Test
            @TestMetadata("classMemberFromTopLevelStringOneStringArg.kt")
            public void testClassMemberFromTopLevelStringOneStringArg() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/classMemberFromTopLevelStringOneStringArg.kt");
            }

            @Test
            @TestMetadata("classMemberFromTopLevelUnitNoArgs.kt")
            public void testClassMemberFromTopLevelUnitNoArgs() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/classMemberFromTopLevelUnitNoArgs.kt");
            }

            @Test
            @TestMetadata("classMemberFromTopLevelUnitOneStringArg.kt")
            public void testClassMemberFromTopLevelUnitOneStringArg() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/classMemberFromTopLevelUnitOneStringArg.kt");
            }

            @Test
            @TestMetadata("coercionToUnit.kt")
            public void testCoercionToUnit() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/coercionToUnit.kt");
            }

            @Test
            @TestMetadata("constructorFromTopLevelNoArgs.kt")
            public void testConstructorFromTopLevelNoArgs() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/constructorFromTopLevelNoArgs.kt");
            }

            @Test
            @TestMetadata("constructorFromTopLevelOneStringArg.kt")
            public void testConstructorFromTopLevelOneStringArg() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/constructorFromTopLevelOneStringArg.kt");
            }

            @Test
            @TestMetadata("dispatchReceiverType.kt")
            public void testDispatchReceiverType() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/dispatchReceiverType.kt");
            }

            @Test
            @TestMetadata("enumValueOfMethod.kt")
            public void testEnumValueOfMethod() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/enumValueOfMethod.kt");
            }

            @Test
            @TestMetadata("equalsIntrinsic.kt")
            public void testEqualsIntrinsic() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/equalsIntrinsic.kt");
            }

            @Test
            @TestMetadata("extensionFromClass.kt")
            public void testExtensionFromClass() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/extensionFromClass.kt");
            }

            @Test
            @TestMetadata("extensionFromExtension.kt")
            public void testExtensionFromExtension() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/extensionFromExtension.kt");
            }

            @Test
            @TestMetadata("extensionFromTopLevelStringNoArgs.kt")
            public void testExtensionFromTopLevelStringNoArgs() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/extensionFromTopLevelStringNoArgs.kt");
            }

            @Test
            @TestMetadata("extensionFromTopLevelStringOneStringArg.kt")
            public void testExtensionFromTopLevelStringOneStringArg() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/extensionFromTopLevelStringOneStringArg.kt");
            }

            @Test
            @TestMetadata("extensionFromTopLevelUnitNoArgs.kt")
            public void testExtensionFromTopLevelUnitNoArgs() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/extensionFromTopLevelUnitNoArgs.kt");
            }

            @Test
            @TestMetadata("extensionFromTopLevelUnitOneStringArg.kt")
            public void testExtensionFromTopLevelUnitOneStringArg() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/extensionFromTopLevelUnitOneStringArg.kt");
            }

            @Test
            @TestMetadata("extensionProperty.kt")
            public void testExtensionProperty() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/extensionProperty.kt");
            }

            @Test
            @TestMetadata("genericCallableReferenceArguments.kt")
            public void testGenericCallableReferenceArguments() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/genericCallableReferenceArguments.kt");
            }

            @Test
            @TestMetadata("genericCallableReferencesWithNullableTypes.kt")
            public void testGenericCallableReferencesWithNullableTypes() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/genericCallableReferencesWithNullableTypes.kt");
            }

            @Test
            @TestMetadata("genericCallableReferencesWithOverload.kt")
            public void testGenericCallableReferencesWithOverload() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/genericCallableReferencesWithOverload.kt");
            }

            @Test
            @TestMetadata("genericMember.kt")
            public void testGenericMember() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/genericMember.kt");
            }

            @Test
            @TestMetadata("genericWithDependentType.kt")
            public void testGenericWithDependentType() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/genericWithDependentType.kt");
            }

            @Test
            @TestMetadata("getArityViaFunctionImpl.kt")
            public void testGetArityViaFunctionImpl() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/getArityViaFunctionImpl.kt");
            }

            @Test
            @TestMetadata("innerClassConstructorWithTwoReceivers.kt")
            public void testInnerClassConstructorWithTwoReceivers() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/innerClassConstructorWithTwoReceivers.kt");
            }

            @Test
            @TestMetadata("innerConstructorFromClass.kt")
            public void testInnerConstructorFromClass() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/innerConstructorFromClass.kt");
            }

            @Test
            @TestMetadata("innerConstructorFromExtension.kt")
            public void testInnerConstructorFromExtension() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/innerConstructorFromExtension.kt");
            }

            @Test
            @TestMetadata("innerConstructorFromTopLevelNoArgs.kt")
            public void testInnerConstructorFromTopLevelNoArgs() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/innerConstructorFromTopLevelNoArgs.kt");
            }

            @Test
            @TestMetadata("innerConstructorFromTopLevelOneStringArg.kt")
            public void testInnerConstructorFromTopLevelOneStringArg() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/innerConstructorFromTopLevelOneStringArg.kt");
            }

            @Test
            @TestMetadata("javaCollectionsStaticMethod.kt")
            public void testJavaCollectionsStaticMethod() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/javaCollectionsStaticMethod.kt");
            }

            @Test
            @TestMetadata("kt21787.kt")
            public void testKt21787() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/kt21787.kt");
            }

            @Test
            @TestMetadata("kt32462.kt")
            public void testKt32462() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/kt32462.kt");
            }

            @Test
            @TestMetadata("kt47741.kt")
            public void testKt47741() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/kt47741.kt");
            }

            @Test
            @TestMetadata("nestedConstructorFromClass.kt")
            public void testNestedConstructorFromClass() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/nestedConstructorFromClass.kt");
            }

            @Test
            @TestMetadata("nestedConstructorFromTopLevelNoArgs.kt")
            public void testNestedConstructorFromTopLevelNoArgs() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/nestedConstructorFromTopLevelNoArgs.kt");
            }

            @Test
            @TestMetadata("nestedConstructorFromTopLevelOneStringArg.kt")
            public void testNestedConstructorFromTopLevelOneStringArg() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/nestedConstructorFromTopLevelOneStringArg.kt");
            }

            @Test
            @TestMetadata("newArray.kt")
            public void testNewArray() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/newArray.kt");
            }

            @Test
            @TestMetadata("overloadedFun.kt")
            public void testOverloadedFun() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/overloadedFun.kt");
            }

            @Test
            @TestMetadata("overloadedFunVsVal.kt")
            public void testOverloadedFunVsVal() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/overloadedFunVsVal.kt");
            }

            @Test
            @TestMetadata("privateClassMember.kt")
            public void testPrivateClassMember() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/privateClassMember.kt");
            }

            @Test
            @TestMetadata("referenceToCompanionMember.kt")
            public void testReferenceToCompanionMember() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/referenceToCompanionMember.kt");
            }

            @Test
            @TestMetadata("sortListOfStrings.kt")
            public void testSortListOfStrings() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/sortListOfStrings.kt");
            }

            @Test
            @TestMetadata("specialCalls.kt")
            public void testSpecialCalls() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/specialCalls.kt");
            }

            @Test
            @TestMetadata("staticFunctionReference.kt")
            public void testStaticFunctionReference() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/staticFunctionReference.kt");
            }

            @Test
            @TestMetadata("topLevelFromClass.kt")
            public void testTopLevelFromClass() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/topLevelFromClass.kt");
            }

            @Test
            @TestMetadata("topLevelFromExtension.kt")
            public void testTopLevelFromExtension() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/topLevelFromExtension.kt");
            }

            @Test
            @TestMetadata("topLevelFromTopLevelStringNoArgs.kt")
            public void testTopLevelFromTopLevelStringNoArgs() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/topLevelFromTopLevelStringNoArgs.kt");
            }

            @Test
            @TestMetadata("topLevelFromTopLevelStringOneStringArg.kt")
            public void testTopLevelFromTopLevelStringOneStringArg() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/topLevelFromTopLevelStringOneStringArg.kt");
            }

            @Test
            @TestMetadata("topLevelFromTopLevelUnitManyArgs.kt")
            public void testTopLevelFromTopLevelUnitManyArgs() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/topLevelFromTopLevelUnitManyArgs.kt");
            }

            @Test
            @TestMetadata("topLevelFromTopLevelUnitNoArgs.kt")
            public void testTopLevelFromTopLevelUnitNoArgs() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/topLevelFromTopLevelUnitNoArgs.kt");
            }

            @Test
            @TestMetadata("topLevelFromTopLevelUnitOneStringArg.kt")
            public void testTopLevelFromTopLevelUnitOneStringArg() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/topLevelFromTopLevelUnitOneStringArg.kt");
            }

            @Test
            @TestMetadata("traitImplMethodWithClassReceiver.kt")
            public void testTraitImplMethodWithClassReceiver() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/traitImplMethodWithClassReceiver.kt");
            }

            @Test
            @TestMetadata("traitMember.kt")
            public void testTraitMember() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/function/traitMember.kt");
            }

            @Nested
            @TestMetadata("compiler/testData/codegen/box/callableReference/function/local")
            @TestDataPath("$PROJECT_ROOT")
            public class Local {
                @Test
                public void testAllFilesPresentInLocal() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/callableReference/function/local"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
                }

                @Test
                @TestMetadata("captureOuter.kt")
                public void testCaptureOuter() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/function/local/captureOuter.kt");
                }

                @Test
                @TestMetadata("classMember.kt")
                public void testClassMember() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/function/local/classMember.kt");
                }

                @Test
                @TestMetadata("closureWithSideEffect.kt")
                public void testClosureWithSideEffect() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/function/local/closureWithSideEffect.kt");
                }

                @Test
                @TestMetadata("constructor.kt")
                public void testConstructor() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/function/local/constructor.kt");
                }

                @Test
                @TestMetadata("constructorWithInitializer.kt")
                public void testConstructorWithInitializer() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/function/local/constructorWithInitializer.kt");
                }

                @Test
                @TestMetadata("enumExtendsTrait.kt")
                public void testEnumExtendsTrait() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/function/local/enumExtendsTrait.kt");
                }

                @Test
                @TestMetadata("equalsHashCode.kt")
                public void testEqualsHashCode() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/function/local/equalsHashCode.kt");
                }

                @Test
                @TestMetadata("extension.kt")
                public void testExtension() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/function/local/extension.kt");
                }

                @Test
                @TestMetadata("extensionToLocalClass.kt")
                public void testExtensionToLocalClass() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/function/local/extensionToLocalClass.kt");
                }

                @Test
                @TestMetadata("extensionToPrimitive.kt")
                public void testExtensionToPrimitive() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/function/local/extensionToPrimitive.kt");
                }

                @Test
                @TestMetadata("extensionWithClosure.kt")
                public void testExtensionWithClosure() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/function/local/extensionWithClosure.kt");
                }

                @Test
                @TestMetadata("genericMember.kt")
                public void testGenericMember() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/function/local/genericMember.kt");
                }

                @Test
                @TestMetadata("localClassMember.kt")
                public void testLocalClassMember() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/function/local/localClassMember.kt");
                }

                @Test
                @TestMetadata("localFunctionName.kt")
                public void testLocalFunctionName() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/function/local/localFunctionName.kt");
                }

                @Test
                @TestMetadata("localLocal.kt")
                public void testLocalLocal() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/function/local/localLocal.kt");
                }

                @Test
                @TestMetadata("recursiveClosure.kt")
                public void testRecursiveClosure() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/function/local/recursiveClosure.kt");
                }

                @Test
                @TestMetadata("simple.kt")
                public void testSimple() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/function/local/simple.kt");
                }

                @Test
                @TestMetadata("simpleClosure.kt")
                public void testSimpleClosure() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/function/local/simpleClosure.kt");
                }

                @Test
                @TestMetadata("simpleWithArg.kt")
                public void testSimpleWithArg() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/function/local/simpleWithArg.kt");
                }

                @Test
                @TestMetadata("unitWithSideEffect.kt")
                public void testUnitWithSideEffect() throws Exception {
                    runTest("compiler/testData/codegen/box/callableReference/function/local/unitWithSideEffect.kt");
                }
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/box/callableReference/property")
        @TestDataPath("$PROJECT_ROOT")
        public class Property {
            @Test
            @TestMetadata("accessViaSubclass.kt")
            public void testAccessViaSubclass() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/accessViaSubclass.kt");
            }

            @Test
            @TestMetadata("accessorForPropertyWithPrivateSetter.kt")
            public void testAccessorForPropertyWithPrivateSetter() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/accessorForPropertyWithPrivateSetter.kt");
            }

            @Test
            public void testAllFilesPresentInProperty() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/callableReference/property"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("delegated.kt")
            public void testDelegated() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/delegated.kt");
            }

            @Test
            @TestMetadata("delegatedMutable.kt")
            public void testDelegatedMutable() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/delegatedMutable.kt");
            }

            @Test
            @TestMetadata("enumNameOrdinal.kt")
            public void testEnumNameOrdinal() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/enumNameOrdinal.kt");
            }

            @Test
            @TestMetadata("extensionToArray.kt")
            public void testExtensionToArray() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/extensionToArray.kt");
            }

            @Test
            @TestMetadata("genericProperty.kt")
            public void testGenericProperty() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/genericProperty.kt");
            }

            @Test
            @TestMetadata("inEnum.kt")
            public void testInEnum() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/inEnum.kt");
            }

            @Test
            @TestMetadata("inReceiverOfAnother.kt")
            public void testInReceiverOfAnother() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/inReceiverOfAnother.kt");
            }

            @Test
            @TestMetadata("invokePropertyReference.kt")
            public void testInvokePropertyReference() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/invokePropertyReference.kt");
            }

            @Test
            @TestMetadata("javaBeanConvention.kt")
            public void testJavaBeanConvention() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/javaBeanConvention.kt");
            }

            @Test
            @TestMetadata("kClassInstanceIsInitializedFirst.kt")
            public void testKClassInstanceIsInitializedFirst() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/kClassInstanceIsInitializedFirst.kt");
            }

            @Test
            @TestMetadata("kt12044.kt")
            public void testKt12044() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/kt12044.kt");
            }

            @Test
            @TestMetadata("kt12982_protectedPropertyReference.kt")
            public void testKt12982_protectedPropertyReference() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/kt12982_protectedPropertyReference.kt");
            }

            @Test
            @TestMetadata("kt14330.kt")
            public void testKt14330() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/kt14330.kt");
            }

            @Test
            @TestMetadata("kt14330_2.kt")
            public void testKt14330_2() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/kt14330_2.kt");
            }

            @Test
            @TestMetadata("kt15447.kt")
            public void testKt15447() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/kt15447.kt");
            }

            @Test
            @TestMetadata("kt6870_privatePropertyReference.kt")
            public void testKt6870_privatePropertyReference() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/kt6870_privatePropertyReference.kt");
            }

            @Test
            @TestMetadata("listOfStringsMapLength.kt")
            public void testListOfStringsMapLength() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/listOfStringsMapLength.kt");
            }

            @Test
            @TestMetadata("localClassVar.kt")
            public void testLocalClassVar() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/localClassVar.kt");
            }

            @Test
            @TestMetadata("overriddenInSubclass.kt")
            public void testOverriddenInSubclass() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/overriddenInSubclass.kt");
            }

            @Test
            @TestMetadata("privateSetOuterClass.kt")
            public void testPrivateSetOuterClass() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/privateSetOuterClass.kt");
            }

            @Test
            @TestMetadata("privateSetterInsideClass.kt")
            public void testPrivateSetterInsideClass() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/privateSetterInsideClass.kt");
            }

            @Test
            @TestMetadata("privateSetterOutsideClass.kt")
            public void testPrivateSetterOutsideClass() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/privateSetterOutsideClass.kt");
            }

            @Test
            @TestMetadata("receiverEvaluatedOnce.kt")
            public void testReceiverEvaluatedOnce() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/receiverEvaluatedOnce.kt");
            }

            @Test
            @TestMetadata("simpleExtension.kt")
            public void testSimpleExtension() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/simpleExtension.kt");
            }

            @Test
            @TestMetadata("simpleMember.kt")
            public void testSimpleMember() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/simpleMember.kt");
            }

            @Test
            @TestMetadata("simpleMutableExtension.kt")
            public void testSimpleMutableExtension() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/simpleMutableExtension.kt");
            }

            @Test
            @TestMetadata("simpleMutableMember.kt")
            public void testSimpleMutableMember() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/simpleMutableMember.kt");
            }

            @Test
            @TestMetadata("simpleMutableTopLevel.kt")
            public void testSimpleMutableTopLevel() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/simpleMutableTopLevel.kt");
            }

            @Test
            @TestMetadata("simpleTopLevel.kt")
            public void testSimpleTopLevel() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/property/simpleTopLevel.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/box/callableReference/serializability")
        @TestDataPath("$PROJECT_ROOT")
        public class Serializability {
            @Test
            @TestMetadata("adaptedReferences.kt")
            public void testAdaptedReferences() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/serializability/adaptedReferences.kt");
            }

            @Test
            public void testAllFilesPresentInSerializability() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/callableReference/serializability"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("boundWithNotSerializableReceiver.kt")
            public void testBoundWithNotSerializableReceiver() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/serializability/boundWithNotSerializableReceiver.kt");
            }

            @Test
            @TestMetadata("boundWithSerializableReceiver.kt")
            public void testBoundWithSerializableReceiver() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/serializability/boundWithSerializableReceiver.kt");
            }

            @Test
            @TestMetadata("noReflect.kt")
            public void testNoReflect() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/serializability/noReflect.kt");
            }

            @Test
            @TestMetadata("reflectedIsNotSerialized.kt")
            public void testReflectedIsNotSerialized() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/serializability/reflectedIsNotSerialized.kt");
            }

            @Test
            @TestMetadata("withReflect.kt")
            public void testWithReflect() throws Exception {
                runTest("compiler/testData/codegen/box/callableReference/serializability/withReflect.kt");
            }
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/casts")
    @TestDataPath("$PROJECT_ROOT")
    public class Casts {
        @Test
        public void testAllFilesPresentInCasts() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/casts"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("as.kt")
        public void testAs() throws Exception {
            runTest("compiler/testData/codegen/box/casts/as.kt");
        }

        @Test
        @TestMetadata("asForConstants.kt")
        public void testAsForConstants() throws Exception {
            runTest("compiler/testData/codegen/box/casts/asForConstants.kt");
        }

        @Test
        @TestMetadata("asSafe.kt")
        public void testAsSafe() throws Exception {
            runTest("compiler/testData/codegen/box/casts/asSafe.kt");
        }

        @Test
        @TestMetadata("asSafeFail.kt")
        public void testAsSafeFail() throws Exception {
            runTest("compiler/testData/codegen/box/casts/asSafeFail.kt");
        }

        @Test
        @TestMetadata("asSafeForConstants.kt")
        public void testAsSafeForConstants() throws Exception {
            runTest("compiler/testData/codegen/box/casts/asSafeForConstants.kt");
        }

        @Test
        @TestMetadata("asThrowsNpe_1_4.kt")
        public void testAsThrowsNpe_1_4() throws Exception {
            runTest("compiler/testData/codegen/box/casts/asThrowsNpe_1_4.kt");
        }

        @Test
        @TestMetadata("asUnit.kt")
        public void testAsUnit() throws Exception {
            runTest("compiler/testData/codegen/box/casts/asUnit.kt");
        }

        @Test
        @TestMetadata("asWithGeneric.kt")
        public void testAsWithGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/casts/asWithGeneric.kt");
        }

        @Test
        @TestMetadata("castGenericNull.kt")
        public void testCastGenericNull() throws Exception {
            runTest("compiler/testData/codegen/box/casts/castGenericNull.kt");
        }

        @Test
        @TestMetadata("castToDefinitelyNotNullType.kt")
        public void testCastToDefinitelyNotNullType() throws Exception {
            runTest("compiler/testData/codegen/box/casts/castToDefinitelyNotNullType.kt");
        }

        @Test
        @TestMetadata("dontCreateInconsistentTypeDuringStarProjectionSubstitution.kt")
        public void testDontCreateInconsistentTypeDuringStarProjectionSubstitution() throws Exception {
            runTest("compiler/testData/codegen/box/casts/dontCreateInconsistentTypeDuringStarProjectionSubstitution.kt");
        }

        @Test
        @TestMetadata("intersectionTypeMultipleBounds.kt")
        public void testIntersectionTypeMultipleBounds() throws Exception {
            runTest("compiler/testData/codegen/box/casts/intersectionTypeMultipleBounds.kt");
        }

        @Test
        @TestMetadata("intersectionTypeMultipleBoundsImplicitReceiver.kt")
        public void testIntersectionTypeMultipleBoundsImplicitReceiver() throws Exception {
            runTest("compiler/testData/codegen/box/casts/intersectionTypeMultipleBoundsImplicitReceiver.kt");
        }

        @Test
        @TestMetadata("intersectionTypeSmartcast.kt")
        public void testIntersectionTypeSmartcast() throws Exception {
            runTest("compiler/testData/codegen/box/casts/intersectionTypeSmartcast.kt");
        }

        @Test
        @TestMetadata("intersectionTypeWithMultipleBoundsAsReceiver.kt")
        public void testIntersectionTypeWithMultipleBoundsAsReceiver() throws Exception {
            runTest("compiler/testData/codegen/box/casts/intersectionTypeWithMultipleBoundsAsReceiver.kt");
        }

        @Test
        @TestMetadata("intersectionTypeWithoutGenericsAsReceiver.kt")
        public void testIntersectionTypeWithoutGenericsAsReceiver() throws Exception {
            runTest("compiler/testData/codegen/box/casts/intersectionTypeWithoutGenericsAsReceiver.kt");
        }

        @Test
        @TestMetadata("is.kt")
        public void testIs() throws Exception {
            runTest("compiler/testData/codegen/box/casts/is.kt");
        }

        @Test
        @TestMetadata("isNullablePrimitive.kt")
        public void testIsNullablePrimitive() throws Exception {
            runTest("compiler/testData/codegen/box/casts/isNullablePrimitive.kt");
        }

        @Test
        @TestMetadata("kt22714.kt")
        public void testKt22714() throws Exception {
            runTest("compiler/testData/codegen/box/casts/kt22714.kt");
        }

        @Test
        @TestMetadata("kt48927_privateMethodOnDerivedCastToBase.kt")
        public void testKt48927_privateMethodOnDerivedCastToBase() throws Exception {
            runTest("compiler/testData/codegen/box/casts/kt48927_privateMethodOnDerivedCastToBase.kt");
        }

        @Test
        @TestMetadata("kt50577.kt")
        public void testKt50577() throws Exception {
            runTest("compiler/testData/codegen/box/casts/kt50577.kt");
        }

        @Test
        @TestMetadata("lambdaToUnitCast.kt")
        public void testLambdaToUnitCast() throws Exception {
            runTest("compiler/testData/codegen/box/casts/lambdaToUnitCast.kt");
        }

        @Test
        @TestMetadata("notIs.kt")
        public void testNotIs() throws Exception {
            runTest("compiler/testData/codegen/box/casts/notIs.kt");
        }

        @Test
        @TestMetadata("nullableSafeCastToTypeParameterWithInterfaceUpperBound.kt")
        public void testNullableSafeCastToTypeParameterWithInterfaceUpperBound() throws Exception {
            runTest("compiler/testData/codegen/box/casts/nullableSafeCastToTypeParameterWithInterfaceUpperBound.kt");
        }

        @Test
        @TestMetadata("objectToPrimitiveWithAssertion.kt")
        public void testObjectToPrimitiveWithAssertion() throws Exception {
            runTest("compiler/testData/codegen/box/casts/objectToPrimitiveWithAssertion.kt");
        }

        @Test
        @TestMetadata("unitAsAny.kt")
        public void testUnitAsAny() throws Exception {
            runTest("compiler/testData/codegen/box/casts/unitAsAny.kt");
        }

        @Test
        @TestMetadata("unitAsInt.kt")
        public void testUnitAsInt() throws Exception {
            runTest("compiler/testData/codegen/box/casts/unitAsInt.kt");
        }

        @Test
        @TestMetadata("unitAsSafeAny.kt")
        public void testUnitAsSafeAny() throws Exception {
            runTest("compiler/testData/codegen/box/casts/unitAsSafeAny.kt");
        }

        @Test
        @TestMetadata("unitNullableCast.kt")
        public void testUnitNullableCast() throws Exception {
            runTest("compiler/testData/codegen/box/casts/unitNullableCast.kt");
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/box/casts/functions")
        @TestDataPath("$PROJECT_ROOT")
        public class Functions {
            @Test
            public void testAllFilesPresentInFunctions() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/casts/functions"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("asFunKBig.kt")
            public void testAsFunKBig() throws Exception {
                runTest("compiler/testData/codegen/box/casts/functions/asFunKBig.kt");
            }

            @Test
            @TestMetadata("asFunKSmall.kt")
            public void testAsFunKSmall() throws Exception {
                runTest("compiler/testData/codegen/box/casts/functions/asFunKSmall.kt");
            }

            @Test
            @TestMetadata("isFunKBig.kt")
            public void testIsFunKBig() throws Exception {
                runTest("compiler/testData/codegen/box/casts/functions/isFunKBig.kt");
            }

            @Test
            @TestMetadata("isFunKSmall.kt")
            public void testIsFunKSmall() throws Exception {
                runTest("compiler/testData/codegen/box/casts/functions/isFunKSmall.kt");
            }

            @Test
            @TestMetadata("javaTypeIsFunK.kt")
            public void testJavaTypeIsFunK() throws Exception {
                runTest("compiler/testData/codegen/box/casts/functions/javaTypeIsFunK.kt");
            }

            @Test
            @TestMetadata("reifiedAsFunKBig.kt")
            public void testReifiedAsFunKBig() throws Exception {
                runTest("compiler/testData/codegen/box/casts/functions/reifiedAsFunKBig.kt");
            }

            @Test
            @TestMetadata("reifiedAsFunKSmall.kt")
            public void testReifiedAsFunKSmall() throws Exception {
                runTest("compiler/testData/codegen/box/casts/functions/reifiedAsFunKSmall.kt");
            }

            @Test
            @TestMetadata("reifiedIsFunKBig.kt")
            public void testReifiedIsFunKBig() throws Exception {
                runTest("compiler/testData/codegen/box/casts/functions/reifiedIsFunKBig.kt");
            }

            @Test
            @TestMetadata("reifiedIsFunKSmall.kt")
            public void testReifiedIsFunKSmall() throws Exception {
                runTest("compiler/testData/codegen/box/casts/functions/reifiedIsFunKSmall.kt");
            }

            @Test
            @TestMetadata("reifiedSafeAsFunKBig.kt")
            public void testReifiedSafeAsFunKBig() throws Exception {
                runTest("compiler/testData/codegen/box/casts/functions/reifiedSafeAsFunKBig.kt");
            }

            @Test
            @TestMetadata("reifiedSafeAsFunKSmall.kt")
            public void testReifiedSafeAsFunKSmall() throws Exception {
                runTest("compiler/testData/codegen/box/casts/functions/reifiedSafeAsFunKSmall.kt");
            }

            @Test
            @TestMetadata("safeAsFunKBig.kt")
            public void testSafeAsFunKBig() throws Exception {
                runTest("compiler/testData/codegen/box/casts/functions/safeAsFunKBig.kt");
            }

            @Test
            @TestMetadata("safeAsFunKSmall.kt")
            public void testSafeAsFunKSmall() throws Exception {
                runTest("compiler/testData/codegen/box/casts/functions/safeAsFunKSmall.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/box/casts/javaInterop")
        @TestDataPath("$PROJECT_ROOT")
        public class JavaInterop {
            @Test
            public void testAllFilesPresentInJavaInterop() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/casts/javaInterop"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("castWithWrongType.kt")
            public void testCastWithWrongType() throws Exception {
                runTest("compiler/testData/codegen/box/casts/javaInterop/castWithWrongType.kt");
            }

            @Test
            @TestMetadata("implicitNotNullWithWrongType.kt")
            public void testImplicitNotNullWithWrongType() throws Exception {
                runTest("compiler/testData/codegen/box/casts/javaInterop/implicitNotNullWithWrongType.kt");
            }

            @Test
            @TestMetadata("instanceOfWithWrongType.kt")
            public void testInstanceOfWithWrongType() throws Exception {
                runTest("compiler/testData/codegen/box/casts/javaInterop/instanceOfWithWrongType.kt");
            }

            @Test
            @TestMetadata("noNullCheckOnCollectionContains.kt")
            public void testNoNullCheckOnCollectionContains() throws Exception {
                runTest("compiler/testData/codegen/box/casts/javaInterop/noNullCheckOnCollectionContains.kt");
            }

            @Test
            @TestMetadata("noNullCheckOnCollectionRemove.kt")
            public void testNoNullCheckOnCollectionRemove() throws Exception {
                runTest("compiler/testData/codegen/box/casts/javaInterop/noNullCheckOnCollectionRemove.kt");
            }

            @Test
            @TestMetadata("noNullCheckOnListIndexOf.kt")
            public void testNoNullCheckOnListIndexOf() throws Exception {
                runTest("compiler/testData/codegen/box/casts/javaInterop/noNullCheckOnListIndexOf.kt");
            }

            @Test
            @TestMetadata("noNullCheckOnListLastIndexOf.kt")
            public void testNoNullCheckOnListLastIndexOf() throws Exception {
                runTest("compiler/testData/codegen/box/casts/javaInterop/noNullCheckOnListLastIndexOf.kt");
            }

            @Test
            @TestMetadata("noNullCheckOnMapContainsKey.kt")
            public void testNoNullCheckOnMapContainsKey() throws Exception {
                runTest("compiler/testData/codegen/box/casts/javaInterop/noNullCheckOnMapContainsKey.kt");
            }

            @Test
            @TestMetadata("noNullCheckOnMapContainsValue.kt")
            public void testNoNullCheckOnMapContainsValue() throws Exception {
                runTest("compiler/testData/codegen/box/casts/javaInterop/noNullCheckOnMapContainsValue.kt");
            }

            @Test
            @TestMetadata("noNullCheckOnMapGet.kt")
            public void testNoNullCheckOnMapGet() throws Exception {
                runTest("compiler/testData/codegen/box/casts/javaInterop/noNullCheckOnMapGet.kt");
            }

            @Test
            @TestMetadata("noNullCheckOnMapRemove.kt")
            public void testNoNullCheckOnMapRemove() throws Exception {
                runTest("compiler/testData/codegen/box/casts/javaInterop/noNullCheckOnMapRemove.kt");
            }

            @Test
            @TestMetadata("nullCheckOnMapGetOrDefault.kt")
            public void testNullCheckOnMapGetOrDefault() throws Exception {
                runTest("compiler/testData/codegen/box/casts/javaInterop/nullCheckOnMapGetOrDefault.kt");
            }

            @Test
            @TestMetadata("nullCheckOnMapRemove2.kt")
            public void testNullCheckOnMapRemove2() throws Exception {
                runTest("compiler/testData/codegen/box/casts/javaInterop/nullCheckOnMapRemove2.kt");
            }

            @Test
            @TestMetadata("safeCastWithWrongType.kt")
            public void testSafeCastWithWrongType() throws Exception {
                runTest("compiler/testData/codegen/box/casts/javaInterop/safeCastWithWrongType.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/box/casts/literalExpressionAsGenericArgument")
        @TestDataPath("$PROJECT_ROOT")
        public class LiteralExpressionAsGenericArgument {
            @Test
            public void testAllFilesPresentInLiteralExpressionAsGenericArgument() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/casts/literalExpressionAsGenericArgument"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("binaryExpressionCast.kt")
            public void testBinaryExpressionCast() throws Exception {
                runTest("compiler/testData/codegen/box/casts/literalExpressionAsGenericArgument/binaryExpressionCast.kt");
            }

            @Test
            @TestMetadata("javaBox.kt")
            public void testJavaBox() throws Exception {
                runTest("compiler/testData/codegen/box/casts/literalExpressionAsGenericArgument/javaBox.kt");
            }

            @Test
            @TestMetadata("labeledExpressionCast.kt")
            public void testLabeledExpressionCast() throws Exception {
                runTest("compiler/testData/codegen/box/casts/literalExpressionAsGenericArgument/labeledExpressionCast.kt");
            }

            @Test
            @TestMetadata("parenthesizedExpressionCast.kt")
            public void testParenthesizedExpressionCast() throws Exception {
                runTest("compiler/testData/codegen/box/casts/literalExpressionAsGenericArgument/parenthesizedExpressionCast.kt");
            }

            @Test
            @TestMetadata("superConstructor.kt")
            public void testSuperConstructor() throws Exception {
                runTest("compiler/testData/codegen/box/casts/literalExpressionAsGenericArgument/superConstructor.kt");
            }

            @Test
            @TestMetadata("unaryExpressionCast.kt")
            public void testUnaryExpressionCast() throws Exception {
                runTest("compiler/testData/codegen/box/casts/literalExpressionAsGenericArgument/unaryExpressionCast.kt");
            }

            @Test
            @TestMetadata("vararg.kt")
            public void testVararg() throws Exception {
                runTest("compiler/testData/codegen/box/casts/literalExpressionAsGenericArgument/vararg.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/box/casts/mutableCollections")
        @TestDataPath("$PROJECT_ROOT")
        public class MutableCollections {
            @Test
            public void testAllFilesPresentInMutableCollections() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/casts/mutableCollections"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("asWithMutable.kt")
            public void testAsWithMutable() throws Exception {
                runTest("compiler/testData/codegen/box/casts/mutableCollections/asWithMutable.kt");
            }

            @Test
            @TestMetadata("isWithMutable.kt")
            public void testIsWithMutable() throws Exception {
                runTest("compiler/testData/codegen/box/casts/mutableCollections/isWithMutable.kt");
            }

            @Test
            @TestMetadata("mutabilityMarkerInterfaces.kt")
            public void testMutabilityMarkerInterfaces() throws Exception {
                runTest("compiler/testData/codegen/box/casts/mutableCollections/mutabilityMarkerInterfaces.kt");
            }

            @Test
            @TestMetadata("reifiedAsWithMutable.kt")
            public void testReifiedAsWithMutable() throws Exception {
                runTest("compiler/testData/codegen/box/casts/mutableCollections/reifiedAsWithMutable.kt");
            }

            @Test
            @TestMetadata("reifiedIsWithMutable.kt")
            public void testReifiedIsWithMutable() throws Exception {
                runTest("compiler/testData/codegen/box/casts/mutableCollections/reifiedIsWithMutable.kt");
            }

            @Test
            @TestMetadata("reifiedSafeAsWithMutable.kt")
            public void testReifiedSafeAsWithMutable() throws Exception {
                runTest("compiler/testData/codegen/box/casts/mutableCollections/reifiedSafeAsWithMutable.kt");
            }

            @Test
            @TestMetadata("safeAsWithMutable.kt")
            public void testSafeAsWithMutable() throws Exception {
                runTest("compiler/testData/codegen/box/casts/mutableCollections/safeAsWithMutable.kt");
            }

            @Test
            @TestMetadata("weirdMutableCasts.kt")
            public void testWeirdMutableCasts() throws Exception {
                runTest("compiler/testData/codegen/box/casts/mutableCollections/weirdMutableCasts.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/box/casts/nativeCCEMessage")
        @TestDataPath("$PROJECT_ROOT")
        public class NativeCCEMessage {
            @Test
            public void testAllFilesPresentInNativeCCEMessage() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/casts/nativeCCEMessage"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/checkcastOptimization")
    @TestDataPath("$PROJECT_ROOT")
    public class CheckcastOptimization {
        @Test
        public void testAllFilesPresentInCheckcastOptimization() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/checkcastOptimization"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("kt19128.kt")
        public void testKt19128() throws Exception {
            runTest("compiler/testData/codegen/box/checkcastOptimization/kt19128.kt");
        }

        @Test
        @TestMetadata("kt19246.kt")
        public void testKt19246() throws Exception {
            runTest("compiler/testData/codegen/box/checkcastOptimization/kt19246.kt");
        }

        @Test
        @TestMetadata("kt47851.kt")
        public void testKt47851() throws Exception {
            runTest("compiler/testData/codegen/box/checkcastOptimization/kt47851.kt");
        }

        @Test
        @TestMetadata("kt47851a.kt")
        public void testKt47851a() throws Exception {
            runTest("compiler/testData/codegen/box/checkcastOptimization/kt47851a.kt");
        }

        @Test
        @TestMetadata("kt50215.kt")
        public void testKt50215() throws Exception {
            runTest("compiler/testData/codegen/box/checkcastOptimization/kt50215.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/classLiteral")
    @TestDataPath("$PROJECT_ROOT")
    public class ClassLiteral {
        @Test
        public void testAllFilesPresentInClassLiteral() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/classLiteral"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("bareArray.kt")
        public void testBareArray() throws Exception {
            runTest("compiler/testData/codegen/box/classLiteral/bareArray.kt");
        }

        @Test
        @TestMetadata("primitiveKClassEquality.kt")
        public void testPrimitiveKClassEquality() throws Exception {
            runTest("compiler/testData/codegen/box/classLiteral/primitiveKClassEquality.kt");
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/box/classLiteral/bound")
        @TestDataPath("$PROJECT_ROOT")
        public class Bound {
            @Test
            public void testAllFilesPresentInBound() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/classLiteral/bound"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("javaIntrinsicWithSideEffect.kt")
            public void testJavaIntrinsicWithSideEffect() throws Exception {
                runTest("compiler/testData/codegen/box/classLiteral/bound/javaIntrinsicWithSideEffect.kt");
            }

            @Test
            @TestMetadata("primitives.kt")
            public void testPrimitives() throws Exception {
                runTest("compiler/testData/codegen/box/classLiteral/bound/primitives.kt");
            }

            @Test
            @TestMetadata("sideEffect.kt")
            public void testSideEffect() throws Exception {
                runTest("compiler/testData/codegen/box/classLiteral/bound/sideEffect.kt");
            }

            @Test
            @TestMetadata("simple.kt")
            public void testSimple() throws Exception {
                runTest("compiler/testData/codegen/box/classLiteral/bound/simple.kt");
            }

            @Test
            @TestMetadata("smartCast.kt")
            public void testSmartCast() throws Exception {
                runTest("compiler/testData/codegen/box/classLiteral/bound/smartCast.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/box/classLiteral/java")
        @TestDataPath("$PROJECT_ROOT")
        public class Java {
            @Test
            public void testAllFilesPresentInJava() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/classLiteral/java"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("java.kt")
            public void testJava() throws Exception {
                runTest("compiler/testData/codegen/box/classLiteral/java/java.kt");
            }

            @Test
            @TestMetadata("javaObjectType.kt")
            public void testJavaObjectType() throws Exception {
                runTest("compiler/testData/codegen/box/classLiteral/java/javaObjectType.kt");
            }

            @Test
            @TestMetadata("javaObjectTypeReified.kt")
            public void testJavaObjectTypeReified() throws Exception {
                runTest("compiler/testData/codegen/box/classLiteral/java/javaObjectTypeReified.kt");
            }

            @Test
            @TestMetadata("javaPrimitiveType.kt")
            public void testJavaPrimitiveType() throws Exception {
                runTest("compiler/testData/codegen/box/classLiteral/java/javaPrimitiveType.kt");
            }

            @Test
            @TestMetadata("javaPrimitiveTypeReified.kt")
            public void testJavaPrimitiveTypeReified() throws Exception {
                runTest("compiler/testData/codegen/box/classLiteral/java/javaPrimitiveTypeReified.kt");
            }

            @Test
            @TestMetadata("javaReified.kt")
            public void testJavaReified() throws Exception {
                runTest("compiler/testData/codegen/box/classLiteral/java/javaReified.kt");
            }

            @Test
            @TestMetadata("kt11943.kt")
            public void testKt11943() throws Exception {
                runTest("compiler/testData/codegen/box/classLiteral/java/kt11943.kt");
            }

            @Test
            @TestMetadata("objectSuperConstructorCall.kt")
            public void testObjectSuperConstructorCall() throws Exception {
                runTest("compiler/testData/codegen/box/classLiteral/java/objectSuperConstructorCall.kt");
            }
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/classes")
    @TestDataPath("$PROJECT_ROOT")
    public class Classes {
        @Test
        public void testAllFilesPresentInClasses() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/classes"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("boxPrimitiveTypeInClinitOfClassObject.kt")
        public void testBoxPrimitiveTypeInClinitOfClassObject() throws Exception {
            runTest("compiler/testData/codegen/box/classes/boxPrimitiveTypeInClinitOfClassObject.kt");
        }

        @Test
        @TestMetadata("classCompanionInitializationWithJava.kt")
        public void testClassCompanionInitializationWithJava() throws Exception {
            runTest("compiler/testData/codegen/box/classes/classCompanionInitializationWithJava.kt");
        }

        @Test
        @TestMetadata("classNamedAsOldPackageFacade.kt")
        public void testClassNamedAsOldPackageFacade() throws Exception {
            runTest("compiler/testData/codegen/box/classes/classNamedAsOldPackageFacade.kt");
        }

        @Test
        @TestMetadata("classObject.kt")
        public void testClassObject() throws Exception {
            runTest("compiler/testData/codegen/box/classes/classObject.kt");
        }

        @Test
        @TestMetadata("classObjectAsExtensionReceiver.kt")
        public void testClassObjectAsExtensionReceiver() throws Exception {
            runTest("compiler/testData/codegen/box/classes/classObjectAsExtensionReceiver.kt");
        }

        @Test
        @TestMetadata("classObjectAsStaticInitializer.kt")
        public void testClassObjectAsStaticInitializer() throws Exception {
            runTest("compiler/testData/codegen/box/classes/classObjectAsStaticInitializer.kt");
        }

        @Test
        @TestMetadata("classObjectField.kt")
        public void testClassObjectField() throws Exception {
            runTest("compiler/testData/codegen/box/classes/classObjectField.kt");
        }

        @Test
        @TestMetadata("classObjectInTrait.kt")
        public void testClassObjectInTrait() throws Exception {
            runTest("compiler/testData/codegen/box/classes/classObjectInTrait.kt");
        }

        @Test
        @TestMetadata("classObjectNotOfEnum.kt")
        public void testClassObjectNotOfEnum() throws Exception {
            runTest("compiler/testData/codegen/box/classes/classObjectNotOfEnum.kt");
        }

        @Test
        @TestMetadata("classObjectToString.kt")
        public void testClassObjectToString() throws Exception {
            runTest("compiler/testData/codegen/box/classes/classObjectToString.kt");
        }

        @Test
        @TestMetadata("classObjectWithPrivateGenericMember.kt")
        public void testClassObjectWithPrivateGenericMember() throws Exception {
            runTest("compiler/testData/codegen/box/classes/classObjectWithPrivateGenericMember.kt");
        }

        @Test
        @TestMetadata("classObjectsWithParentClasses.kt")
        public void testClassObjectsWithParentClasses() throws Exception {
            runTest("compiler/testData/codegen/box/classes/classObjectsWithParentClasses.kt");
        }

        @Test
        @TestMetadata("comanionObjectFieldVsClassField.kt")
        public void testComanionObjectFieldVsClassField() throws Exception {
            runTest("compiler/testData/codegen/box/classes/comanionObjectFieldVsClassField.kt");
        }

        @Test
        @TestMetadata("defaultObjectSameNamesAsInOuter.kt")
        public void testDefaultObjectSameNamesAsInOuter() throws Exception {
            runTest("compiler/testData/codegen/box/classes/defaultObjectSameNamesAsInOuter.kt");
        }

        @Test
        @TestMetadata("delegateConstructorCallWithKeywords.kt")
        public void testDelegateConstructorCallWithKeywords() throws Exception {
            runTest("compiler/testData/codegen/box/classes/delegateConstructorCallWithKeywords.kt");
        }

        @Test
        @TestMetadata("delegation2.kt")
        public void testDelegation2() throws Exception {
            runTest("compiler/testData/codegen/box/classes/delegation2.kt");
        }

        @Test
        @TestMetadata("delegation3.kt")
        public void testDelegation3() throws Exception {
            runTest("compiler/testData/codegen/box/classes/delegation3.kt");
        }

        @Test
        @TestMetadata("delegation4.kt")
        public void testDelegation4() throws Exception {
            runTest("compiler/testData/codegen/box/classes/delegation4.kt");
        }

        @Test
        @TestMetadata("delegationGenericArg.kt")
        public void testDelegationGenericArg() throws Exception {
            runTest("compiler/testData/codegen/box/classes/delegationGenericArg.kt");
        }

        @Test
        @TestMetadata("delegationGenericArgUpperBound.kt")
        public void testDelegationGenericArgUpperBound() throws Exception {
            runTest("compiler/testData/codegen/box/classes/delegationGenericArgUpperBound.kt");
        }

        @Test
        @TestMetadata("delegationGenericLongArg.kt")
        public void testDelegationGenericLongArg() throws Exception {
            runTest("compiler/testData/codegen/box/classes/delegationGenericLongArg.kt");
        }

        @Test
        @TestMetadata("delegationJava.kt")
        public void testDelegationJava() throws Exception {
            runTest("compiler/testData/codegen/box/classes/delegationJava.kt");
        }

        @Test
        @TestMetadata("delegationMethodsWithArgs.kt")
        public void testDelegationMethodsWithArgs() throws Exception {
            runTest("compiler/testData/codegen/box/classes/delegationMethodsWithArgs.kt");
        }

        @Test
        @TestMetadata("exceptionConstructor.kt")
        public void testExceptionConstructor() throws Exception {
            runTest("compiler/testData/codegen/box/classes/exceptionConstructor.kt");
        }

        @Test
        @TestMetadata("extensionFunWithDefaultParam.kt")
        public void testExtensionFunWithDefaultParam() throws Exception {
            runTest("compiler/testData/codegen/box/classes/extensionFunWithDefaultParam.kt");
        }

        @Test
        @TestMetadata("extensionOnNamedClassObject.kt")
        public void testExtensionOnNamedClassObject() throws Exception {
            runTest("compiler/testData/codegen/box/classes/extensionOnNamedClassObject.kt");
        }

        @Test
        @TestMetadata("funDelegation.kt")
        public void testFunDelegation() throws Exception {
            runTest("compiler/testData/codegen/box/classes/funDelegation.kt");
        }

        @Test
        @TestMetadata("implementComparableInSubclass.kt")
        public void testImplementComparableInSubclass() throws Exception {
            runTest("compiler/testData/codegen/box/classes/implementComparableInSubclass.kt");
        }

        @Test
        @TestMetadata("inheritSetAndHashSet.kt")
        public void testInheritSetAndHashSet() throws Exception {
            runTest("compiler/testData/codegen/box/classes/inheritSetAndHashSet.kt");
        }

        @Test
        @TestMetadata("inheritance.kt")
        public void testInheritance() throws Exception {
            runTest("compiler/testData/codegen/box/classes/inheritance.kt");
        }

        @Test
        @TestMetadata("inheritedInnerClass.kt")
        public void testInheritedInnerClass() throws Exception {
            runTest("compiler/testData/codegen/box/classes/inheritedInnerClass.kt");
        }

        @Test
        @TestMetadata("inheritedMethod.kt")
        public void testInheritedMethod() throws Exception {
            runTest("compiler/testData/codegen/box/classes/inheritedMethod.kt");
        }

        @Test
        @TestMetadata("initializerBlock.kt")
        public void testInitializerBlock() throws Exception {
            runTest("compiler/testData/codegen/box/classes/initializerBlock.kt");
        }

        @Test
        @TestMetadata("initializerBlockDImpl.kt")
        public void testInitializerBlockDImpl() throws Exception {
            runTest("compiler/testData/codegen/box/classes/initializerBlockDImpl.kt");
        }

        @Test
        @TestMetadata("initializerBlockResetToDefault.kt")
        public void testInitializerBlockResetToDefault() throws Exception {
            runTest("compiler/testData/codegen/box/classes/initializerBlockResetToDefault.kt");
        }

        @Test
        @TestMetadata("innerClass.kt")
        public void testInnerClass() throws Exception {
            runTest("compiler/testData/codegen/box/classes/innerClass.kt");
        }

        @Test
        @TestMetadata("interfaceCompanionInitializationWithJava.kt")
        public void testInterfaceCompanionInitializationWithJava() throws Exception {
            runTest("compiler/testData/codegen/box/classes/interfaceCompanionInitializationWithJava.kt");
        }

        @Test
        @TestMetadata("kt1018.kt")
        public void testKt1018() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt1018.kt");
        }

        @Test
        @TestMetadata("kt1120.kt")
        public void testKt1120() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt1120.kt");
        }

        @Test
        @TestMetadata("kt1134.kt")
        public void testKt1134() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt1134.kt");
        }

        @Test
        @TestMetadata("kt1157.kt")
        public void testKt1157() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt1157.kt");
        }

        @Test
        @TestMetadata("kt1247.kt")
        public void testKt1247() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt1247.kt");
        }

        @Test
        @TestMetadata("kt1345.kt")
        public void testKt1345() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt1345.kt");
        }

        @Test
        @TestMetadata("kt1439.kt")
        public void testKt1439() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt1439.kt");
        }

        @Test
        @TestMetadata("kt1535.kt")
        public void testKt1535() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt1535.kt");
        }

        @Test
        @TestMetadata("kt1538.kt")
        public void testKt1538() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt1538.kt");
        }

        @Test
        @TestMetadata("kt1578.kt")
        public void testKt1578() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt1578.kt");
        }

        @Test
        @TestMetadata("kt1611.kt")
        public void testKt1611() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt1611.kt");
        }

        @Test
        @TestMetadata("kt1721.kt")
        public void testKt1721() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt1721.kt");
        }

        @Test
        @TestMetadata("kt1726.kt")
        public void testKt1726() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt1726.kt");
        }

        @Test
        @TestMetadata("kt1759.kt")
        public void testKt1759() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt1759.kt");
        }

        @Test
        @TestMetadata("kt1891.kt")
        public void testKt1891() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt1891.kt");
        }

        @Test
        @TestMetadata("kt1918.kt")
        public void testKt1918() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt1918.kt");
        }

        @Test
        @TestMetadata("kt1976.kt")
        public void testKt1976() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt1976.kt");
        }

        @Test
        @TestMetadata("kt1980.kt")
        public void testKt1980() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt1980.kt");
        }

        @Test
        @TestMetadata("kt2224.kt")
        public void testKt2224() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt2224.kt");
        }

        @Test
        @TestMetadata("kt2288.kt")
        public void testKt2288() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt2288.kt");
        }

        @Test
        @TestMetadata("kt2384.kt")
        public void testKt2384() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt2384.kt");
        }

        @Test
        @TestMetadata("kt2390.kt")
        public void testKt2390() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt2390.kt");
        }

        @Test
        @TestMetadata("kt2391.kt")
        public void testKt2391() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt2391.kt");
        }

        @Test
        @TestMetadata("kt2395.kt")
        public void testKt2395() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt2395.kt");
        }

        @Test
        @TestMetadata("kt2417.kt")
        public void testKt2417() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt2417.kt");
        }

        @Test
        @TestMetadata("kt2477.kt")
        public void testKt2477() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt2477.kt");
        }

        @Test
        @TestMetadata("kt2480.kt")
        public void testKt2480() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt2480.kt");
        }

        @Test
        @TestMetadata("kt2482.kt")
        public void testKt2482() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt2482.kt");
        }

        @Test
        @TestMetadata("kt2485.kt")
        public void testKt2485() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt2485.kt");
        }

        @Test
        @TestMetadata("kt249.kt")
        public void testKt249() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt249.kt");
        }

        @Test
        @TestMetadata("kt2532.kt")
        public void testKt2532() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt2532.kt");
        }

        @Test
        @TestMetadata("kt2566.kt")
        public void testKt2566() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt2566.kt");
        }

        @Test
        @TestMetadata("kt2566_2.kt")
        public void testKt2566_2() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt2566_2.kt");
        }

        @Test
        @TestMetadata("kt2607.kt")
        public void testKt2607() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt2607.kt");
        }

        @Test
        @TestMetadata("kt2626.kt")
        public void testKt2626() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt2626.kt");
        }

        @Test
        @TestMetadata("kt2711.kt")
        public void testKt2711() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt2711.kt");
        }

        @Test
        @TestMetadata("kt2784.kt")
        public void testKt2784() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt2784.kt");
        }

        @Test
        @TestMetadata("kt285.kt")
        public void testKt285() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt285.kt");
        }

        @Test
        @TestMetadata("kt3001.kt")
        public void testKt3001() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt3001.kt");
        }

        @Test
        @TestMetadata("kt3114.kt")
        public void testKt3114() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt3114.kt");
        }

        @Test
        @TestMetadata("kt3414.kt")
        public void testKt3414() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt3414.kt");
        }

        @Test
        @TestMetadata("kt343.kt")
        public void testKt343() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt343.kt");
        }

        @Test
        @TestMetadata("kt3546.kt")
        public void testKt3546() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt3546.kt");
        }

        @Test
        @TestMetadata("kt40332.kt")
        public void testKt40332() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt40332.kt");
        }

        @Test
        @TestMetadata("kt454.kt")
        public void testKt454() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt454.kt");
        }

        @Test
        @TestMetadata("kt471.kt")
        public void testKt471() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt471.kt");
        }

        @Test
        @TestMetadata("kt48.kt")
        public void testKt48() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt48.kt");
        }

        @Test
        @TestMetadata("kt496.kt")
        public void testKt496() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt496.kt");
        }

        @Test
        @TestMetadata("kt500.kt")
        public void testKt500() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt500.kt");
        }

        @Test
        @TestMetadata("kt501.kt")
        public void testKt501() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt501.kt");
        }

        @Test
        @TestMetadata("kt504.kt")
        public void testKt504() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt504.kt");
        }

        @Test
        @TestMetadata("kt508.kt")
        public void testKt508() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt508.kt");
        }

        @Test
        @TestMetadata("kt5347.kt")
        public void testKt5347() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt5347.kt");
        }

        @Test
        @TestMetadata("kt6136.kt")
        public void testKt6136() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt6136.kt");
        }

        @Test
        @TestMetadata("kt633.kt")
        public void testKt633() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt633.kt");
        }

        @Test
        @TestMetadata("kt6816.kt")
        public void testKt6816() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt6816.kt");
        }

        @Test
        @TestMetadata("kt707.kt")
        public void testKt707() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt707.kt");
        }

        @Test
        @TestMetadata("kt723.kt")
        public void testKt723() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt723.kt");
        }

        @Test
        @TestMetadata("kt725.kt")
        public void testKt725() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt725.kt");
        }

        @Test
        @TestMetadata("kt8011.kt")
        public void testKt8011() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt8011.kt");
        }

        @Test
        @TestMetadata("kt8011a.kt")
        public void testKt8011a() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt8011a.kt");
        }

        @Test
        @TestMetadata("kt903.kt")
        public void testKt903() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt903.kt");
        }

        @Test
        @TestMetadata("kt940.kt")
        public void testKt940() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt940.kt");
        }

        @Test
        @TestMetadata("kt9642.kt")
        public void testKt9642() throws Exception {
            runTest("compiler/testData/codegen/box/classes/kt9642.kt");
        }

        @Test
        @TestMetadata("namedClassObject.kt")
        public void testNamedClassObject() throws Exception {
            runTest("compiler/testData/codegen/box/classes/namedClassObject.kt");
        }

        @Test
        @TestMetadata("outerThis.kt")
        public void testOuterThis() throws Exception {
            runTest("compiler/testData/codegen/box/classes/outerThis.kt");
        }

        @Test
        @TestMetadata("overloadBinaryOperator.kt")
        public void testOverloadBinaryOperator() throws Exception {
            runTest("compiler/testData/codegen/box/classes/overloadBinaryOperator.kt");
        }

        @Test
        @TestMetadata("overloadPlusAssign.kt")
        public void testOverloadPlusAssign() throws Exception {
            runTest("compiler/testData/codegen/box/classes/overloadPlusAssign.kt");
        }

        @Test
        @TestMetadata("overloadPlusAssignReturn.kt")
        public void testOverloadPlusAssignReturn() throws Exception {
            runTest("compiler/testData/codegen/box/classes/overloadPlusAssignReturn.kt");
        }

        @Test
        @TestMetadata("overloadPlusToPlusAssign.kt")
        public void testOverloadPlusToPlusAssign() throws Exception {
            runTest("compiler/testData/codegen/box/classes/overloadPlusToPlusAssign.kt");
        }

        @Test
        @TestMetadata("overloadUnaryOperator.kt")
        public void testOverloadUnaryOperator() throws Exception {
            runTest("compiler/testData/codegen/box/classes/overloadUnaryOperator.kt");
        }

        @Test
        @TestMetadata("privateOuterFunctions.kt")
        public void testPrivateOuterFunctions() throws Exception {
            runTest("compiler/testData/codegen/box/classes/privateOuterFunctions.kt");
        }

        @Test
        @TestMetadata("privateOuterProperty.kt")
        public void testPrivateOuterProperty() throws Exception {
            runTest("compiler/testData/codegen/box/classes/privateOuterProperty.kt");
        }

        @Test
        @TestMetadata("privateToThis.kt")
        public void testPrivateToThis() throws Exception {
            runTest("compiler/testData/codegen/box/classes/privateToThis.kt");
        }

        @Test
        @TestMetadata("propertyDelegation.kt")
        public void testPropertyDelegation() throws Exception {
            runTest("compiler/testData/codegen/box/classes/propertyDelegation.kt");
        }

        @Test
        @TestMetadata("propertyInInitializer.kt")
        public void testPropertyInInitializer() throws Exception {
            runTest("compiler/testData/codegen/box/classes/propertyInInitializer.kt");
        }

        @Test
        @TestMetadata("quotedClassName.kt")
        public void testQuotedClassName() throws Exception {
            runTest("compiler/testData/codegen/box/classes/quotedClassName.kt");
        }

        @Test
        @TestMetadata("rightHandOverride.kt")
        public void testRightHandOverride() throws Exception {
            runTest("compiler/testData/codegen/box/classes/rightHandOverride.kt");
        }

        @Test
        @TestMetadata("selfcreate.kt")
        public void testSelfcreate() throws Exception {
            runTest("compiler/testData/codegen/box/classes/selfcreate.kt");
        }

        @Test
        @TestMetadata("simpleBox.kt")
        public void testSimpleBox() throws Exception {
            runTest("compiler/testData/codegen/box/classes/simpleBox.kt");
        }

        @Test
        @TestMetadata("superConstructorCallWithComplexArg.kt")
        public void testSuperConstructorCallWithComplexArg() throws Exception {
            runTest("compiler/testData/codegen/box/classes/superConstructorCallWithComplexArg.kt");
        }

        @Test
        @TestMetadata("typedDelegation.kt")
        public void testTypedDelegation() throws Exception {
            runTest("compiler/testData/codegen/box/classes/typedDelegation.kt");
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/box/classes/inner")
        @TestDataPath("$PROJECT_ROOT")
        public class Inner {
            @Test
            public void testAllFilesPresentInInner() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/classes/inner"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("extensionWithOuter.kt")
            public void testExtensionWithOuter() throws Exception {
                runTest("compiler/testData/codegen/box/classes/inner/extensionWithOuter.kt");
            }

            @Test
            @TestMetadata("instantiateInDerived.kt")
            public void testInstantiateInDerived() throws Exception {
                runTest("compiler/testData/codegen/box/classes/inner/instantiateInDerived.kt");
            }

            @Test
            @TestMetadata("instantiateInDerivedLabeled.kt")
            public void testInstantiateInDerivedLabeled() throws Exception {
                runTest("compiler/testData/codegen/box/classes/inner/instantiateInDerivedLabeled.kt");
            }

            @Test
            @TestMetadata("instantiateInSameClass.kt")
            public void testInstantiateInSameClass() throws Exception {
                runTest("compiler/testData/codegen/box/classes/inner/instantiateInSameClass.kt");
            }

            @Test
            @TestMetadata("kt6708.kt")
            public void testKt6708() throws Exception {
                runTest("compiler/testData/codegen/box/classes/inner/kt6708.kt");
            }

            @Test
            @TestMetadata("properOuter.kt")
            public void testProperOuter() throws Exception {
                runTest("compiler/testData/codegen/box/classes/inner/properOuter.kt");
            }

            @Test
            @TestMetadata("properSuperLinking.kt")
            public void testProperSuperLinking() throws Exception {
                runTest("compiler/testData/codegen/box/classes/inner/properSuperLinking.kt");
            }
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/closures")
    @TestDataPath("$PROJECT_ROOT")
    public class Closures {
        @Test
        public void testAllFilesPresentInClosures() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/closures"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("anonymousObjectAsLastExpressionInLambda.kt")
        public void testAnonymousObjectAsLastExpressionInLambda() throws Exception {
            runTest("compiler/testData/codegen/box/closures/anonymousObjectAsLastExpressionInLambda.kt");
        }

        @Test
        @TestMetadata("captureExtensionReceiver.kt")
        public void testCaptureExtensionReceiver() throws Exception {
            runTest("compiler/testData/codegen/box/closures/captureExtensionReceiver.kt");
        }

        @Test
        @TestMetadata("captureExtensionReceiverX2.kt")
        public void testCaptureExtensionReceiverX2() throws Exception {
            runTest("compiler/testData/codegen/box/closures/captureExtensionReceiverX2.kt");
        }

        @Test
        @TestMetadata("capturedLocalGenericFun.kt")
        public void testCapturedLocalGenericFun() throws Exception {
            runTest("compiler/testData/codegen/box/closures/capturedLocalGenericFun.kt");
        }

        @Test
        @TestMetadata("closureInsideConstrucor.kt")
        public void testClosureInsideConstrucor() throws Exception {
            runTest("compiler/testData/codegen/box/closures/closureInsideConstrucor.kt");
        }

        @Test
        @TestMetadata("closureOnTopLevel1.kt")
        public void testClosureOnTopLevel1() throws Exception {
            runTest("compiler/testData/codegen/box/closures/closureOnTopLevel1.kt");
        }

        @Test
        @TestMetadata("closureOnTopLevel2.kt")
        public void testClosureOnTopLevel2() throws Exception {
            runTest("compiler/testData/codegen/box/closures/closureOnTopLevel2.kt");
        }

        @Test
        @TestMetadata("closureWithParameter.kt")
        public void testClosureWithParameter() throws Exception {
            runTest("compiler/testData/codegen/box/closures/closureWithParameter.kt");
        }

        @Test
        @TestMetadata("closureWithParameterAndBoxing.kt")
        public void testClosureWithParameterAndBoxing() throws Exception {
            runTest("compiler/testData/codegen/box/closures/closureWithParameterAndBoxing.kt");
        }

        @Test
        @TestMetadata("crossinlineLocalDeclaration.kt")
        public void testCrossinlineLocalDeclaration() throws Exception {
            runTest("compiler/testData/codegen/box/closures/crossinlineLocalDeclaration.kt");
        }

        @Test
        @TestMetadata("doubleEnclosedLocalVariable.kt")
        public void testDoubleEnclosedLocalVariable() throws Exception {
            runTest("compiler/testData/codegen/box/closures/doubleEnclosedLocalVariable.kt");
        }

        @Test
        @TestMetadata("enclosingLocalVariable.kt")
        public void testEnclosingLocalVariable() throws Exception {
            runTest("compiler/testData/codegen/box/closures/enclosingLocalVariable.kt");
        }

        @Test
        @TestMetadata("enclosingThis.kt")
        public void testEnclosingThis() throws Exception {
            runTest("compiler/testData/codegen/box/closures/enclosingThis.kt");
        }

        @Test
        @TestMetadata("extensionClosure.kt")
        public void testExtensionClosure() throws Exception {
            runTest("compiler/testData/codegen/box/closures/extensionClosure.kt");
        }

        @Test
        @TestMetadata("kt10044.kt")
        public void testKt10044() throws Exception {
            runTest("compiler/testData/codegen/box/closures/kt10044.kt");
        }

        @Test
        @TestMetadata("kt11634.kt")
        public void testKt11634() throws Exception {
            runTest("compiler/testData/codegen/box/closures/kt11634.kt");
        }

        @Test
        @TestMetadata("kt11634_2.kt")
        public void testKt11634_2() throws Exception {
            runTest("compiler/testData/codegen/box/closures/kt11634_2.kt");
        }

        @Test
        @TestMetadata("kt11634_3.kt")
        public void testKt11634_3() throws Exception {
            runTest("compiler/testData/codegen/box/closures/kt11634_3.kt");
        }

        @Test
        @TestMetadata("kt11634_4.kt")
        public void testKt11634_4() throws Exception {
            runTest("compiler/testData/codegen/box/closures/kt11634_4.kt");
        }

        @Test
        @TestMetadata("kt19389.kt")
        public void testKt19389() throws Exception {
            runTest("compiler/testData/codegen/box/closures/kt19389.kt");
        }

        @Test
        @TestMetadata("kt19389_set.kt")
        public void testKt19389_set() throws Exception {
            runTest("compiler/testData/codegen/box/closures/kt19389_set.kt");
        }

        @Test
        @TestMetadata("kt2151.kt")
        public void testKt2151() throws Exception {
            runTest("compiler/testData/codegen/box/closures/kt2151.kt");
        }

        @Test
        @TestMetadata("kt23881.kt")
        public void testKt23881() throws Exception {
            runTest("compiler/testData/codegen/box/closures/kt23881.kt");
        }

        @Test
        @TestMetadata("kt3152.kt")
        public void testKt3152() throws Exception {
            runTest("compiler/testData/codegen/box/closures/kt3152.kt");
        }

        @Test
        @TestMetadata("kt3523.kt")
        public void testKt3523() throws Exception {
            runTest("compiler/testData/codegen/box/closures/kt3523.kt");
        }

        @Test
        @TestMetadata("kt3738.kt")
        public void testKt3738() throws Exception {
            runTest("compiler/testData/codegen/box/closures/kt3738.kt");
        }

        @Test
        @TestMetadata("kt3905.kt")
        public void testKt3905() throws Exception {
            runTest("compiler/testData/codegen/box/closures/kt3905.kt");
        }

        @Test
        @TestMetadata("kt4106.kt")
        public void testKt4106() throws Exception {
            runTest("compiler/testData/codegen/box/closures/kt4106.kt");
        }

        @Test
        @TestMetadata("kt4137.kt")
        public void testKt4137() throws Exception {
            runTest("compiler/testData/codegen/box/closures/kt4137.kt");
        }

        @Test
        @TestMetadata("kt47120.kt")
        public void testKt47120() throws Exception {
            runTest("compiler/testData/codegen/box/closures/kt47120.kt");
        }

        @Test
        @TestMetadata("kt47120a.kt")
        public void testKt47120a() throws Exception {
            runTest("compiler/testData/codegen/box/closures/kt47120a.kt");
        }

        @Test
        @TestMetadata("kt47840.kt")
        public void testKt47840() throws Exception {
            runTest("compiler/testData/codegen/box/closures/kt47840.kt");
        }

        @Test
        @TestMetadata("kt47894_inlineFunWithObjectWithNothing.kt")
        public void testKt47894_inlineFunWithObjectWithNothing() throws Exception {
            runTest("compiler/testData/codegen/box/closures/kt47894_inlineFunWithObjectWithNothing.kt");
        }

        @Test
        @TestMetadata("kt5589.kt")
        public void testKt5589() throws Exception {
            runTest("compiler/testData/codegen/box/closures/kt5589.kt");
        }

        @Test
        @TestMetadata("localClassFunClosure.kt")
        public void testLocalClassFunClosure() throws Exception {
            runTest("compiler/testData/codegen/box/closures/localClassFunClosure.kt");
        }

        @Test
        @TestMetadata("localClassLambdaClosure.kt")
        public void testLocalClassLambdaClosure() throws Exception {
            runTest("compiler/testData/codegen/box/closures/localClassLambdaClosure.kt");
        }

        @Test
        @TestMetadata("localFunInInit.kt")
        public void testLocalFunInInit() throws Exception {
            runTest("compiler/testData/codegen/box/closures/localFunInInit.kt");
        }

        @Test
        @TestMetadata("localFunctionInFunction.kt")
        public void testLocalFunctionInFunction() throws Exception {
            runTest("compiler/testData/codegen/box/closures/localFunctionInFunction.kt");
        }

        @Test
        @TestMetadata("localFunctionInInitBlock.kt")
        public void testLocalFunctionInInitBlock() throws Exception {
            runTest("compiler/testData/codegen/box/closures/localFunctionInInitBlock.kt");
        }

        @Test
        @TestMetadata("localFunctionInInitializer.kt")
        public void testLocalFunctionInInitializer() throws Exception {
            runTest("compiler/testData/codegen/box/closures/localFunctionInInitializer.kt");
        }

        @Test
        @TestMetadata("localGenericFun.kt")
        public void testLocalGenericFun() throws Exception {
            runTest("compiler/testData/codegen/box/closures/localGenericFun.kt");
        }

        @Test
        @TestMetadata("localReturn.kt")
        public void testLocalReturn() throws Exception {
            runTest("compiler/testData/codegen/box/closures/localReturn.kt");
        }

        @Test
        @TestMetadata("localReturnWithAutolabel.kt")
        public void testLocalReturnWithAutolabel() throws Exception {
            runTest("compiler/testData/codegen/box/closures/localReturnWithAutolabel.kt");
        }

        @Test
        @TestMetadata("noRefToOuter.kt")
        public void testNoRefToOuter() throws Exception {
            runTest("compiler/testData/codegen/box/closures/noRefToOuter.kt");
        }

        @Test
        @TestMetadata("recursiveClosure.kt")
        public void testRecursiveClosure() throws Exception {
            runTest("compiler/testData/codegen/box/closures/recursiveClosure.kt");
        }

        @Test
        @TestMetadata("refsAreSerializable.kt")
        public void testRefsAreSerializable() throws Exception {
            runTest("compiler/testData/codegen/box/closures/refsAreSerializable.kt");
        }

        @Test
        @TestMetadata("simplestClosure.kt")
        public void testSimplestClosure() throws Exception {
            runTest("compiler/testData/codegen/box/closures/simplestClosure.kt");
        }

        @Test
        @TestMetadata("simplestClosureAndBoxing.kt")
        public void testSimplestClosureAndBoxing() throws Exception {
            runTest("compiler/testData/codegen/box/closures/simplestClosureAndBoxing.kt");
        }

        @Test
        @TestMetadata("staticLambda.kt")
        public void testStaticLambda() throws Exception {
            runTest("compiler/testData/codegen/box/closures/staticLambda.kt");
        }

        @Test
        @TestMetadata("subclosuresWithinInitializers.kt")
        public void testSubclosuresWithinInitializers() throws Exception {
            runTest("compiler/testData/codegen/box/closures/subclosuresWithinInitializers.kt");
        }

        @Test
        @TestMetadata("underscoreParameters.kt")
        public void testUnderscoreParameters() throws Exception {
            runTest("compiler/testData/codegen/box/closures/underscoreParameters.kt");
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/box/closures/captureInSuperConstructorCall")
        @TestDataPath("$PROJECT_ROOT")
        public class CaptureInSuperConstructorCall {
            @Test
            public void testAllFilesPresentInCaptureInSuperConstructorCall() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/closures/captureInSuperConstructorCall"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("constructorParameterAndLocalCapturedInLambdaInLocalClass.kt")
            public void testConstructorParameterAndLocalCapturedInLambdaInLocalClass() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/constructorParameterAndLocalCapturedInLambdaInLocalClass.kt");
            }

            @Test
            @TestMetadata("constructorParameterCapturedInLambdaInLocalClass.kt")
            public void testConstructorParameterCapturedInLambdaInLocalClass() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/constructorParameterCapturedInLambdaInLocalClass.kt");
            }

            @Test
            @TestMetadata("constructorParameterCapturedInLambdaInLocalClass2.kt")
            public void testConstructorParameterCapturedInLambdaInLocalClass2() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/constructorParameterCapturedInLambdaInLocalClass2.kt");
            }

            @Test
            @TestMetadata("kt13454.kt")
            public void testKt13454() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/kt13454.kt");
            }

            @Test
            @TestMetadata("kt14148.kt")
            public void testKt14148() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/kt14148.kt");
            }

            @Test
            @TestMetadata("kt4174.kt")
            public void testKt4174() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/kt4174.kt");
            }

            @Test
            @TestMetadata("kt4174a.kt")
            public void testKt4174a() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/kt4174a.kt");
            }

            @Test
            @TestMetadata("localCapturedInAnonymousObjectInLocalClass.kt")
            public void testLocalCapturedInAnonymousObjectInLocalClass() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/localCapturedInAnonymousObjectInLocalClass.kt");
            }

            @Test
            @TestMetadata("localCapturedInAnonymousObjectInLocalClass2.kt")
            public void testLocalCapturedInAnonymousObjectInLocalClass2() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/localCapturedInAnonymousObjectInLocalClass2.kt");
            }

            @Test
            @TestMetadata("localCapturedInLambdaInInnerClassInLocalClass.kt")
            public void testLocalCapturedInLambdaInInnerClassInLocalClass() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/localCapturedInLambdaInInnerClassInLocalClass.kt");
            }

            @Test
            @TestMetadata("localCapturedInLambdaInLocalClass.kt")
            public void testLocalCapturedInLambdaInLocalClass() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/localCapturedInLambdaInLocalClass.kt");
            }

            @Test
            @TestMetadata("localFunctionCapturedInLambda.kt")
            public void testLocalFunctionCapturedInLambda() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/localFunctionCapturedInLambda.kt");
            }

            @Test
            @TestMetadata("outerAndLocalCapturedInLocalClass.kt")
            public void testOuterAndLocalCapturedInLocalClass() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/outerAndLocalCapturedInLocalClass.kt");
            }

            @Test
            @TestMetadata("outerCapturedAsImplicitThisInBoundReference.kt")
            public void testOuterCapturedAsImplicitThisInBoundReference() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/outerCapturedAsImplicitThisInBoundReference.kt");
            }

            @Test
            @TestMetadata("outerCapturedInFunctionLiteral.kt")
            public void testOuterCapturedInFunctionLiteral() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/outerCapturedInFunctionLiteral.kt");
            }

            @Test
            @TestMetadata("outerCapturedInInlineLambda.kt")
            public void testOuterCapturedInInlineLambda() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/outerCapturedInInlineLambda.kt");
            }

            @Test
            @TestMetadata("outerCapturedInInlineLambda2.kt")
            public void testOuterCapturedInInlineLambda2() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/outerCapturedInInlineLambda2.kt");
            }

            @Test
            @TestMetadata("outerCapturedInLambda.kt")
            public void testOuterCapturedInLambda() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/outerCapturedInLambda.kt");
            }

            @Test
            @TestMetadata("outerCapturedInLambda2.kt")
            public void testOuterCapturedInLambda2() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/outerCapturedInLambda2.kt");
            }

            @Test
            @TestMetadata("outerCapturedInLambdaInSecondaryConstructor.kt")
            public void testOuterCapturedInLambdaInSecondaryConstructor() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/outerCapturedInLambdaInSecondaryConstructor.kt");
            }

            @Test
            @TestMetadata("outerCapturedInLambdaInSubExpression.kt")
            public void testOuterCapturedInLambdaInSubExpression() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/outerCapturedInLambdaInSubExpression.kt");
            }

            @Test
            @TestMetadata("outerCapturedInLocalClass.kt")
            public void testOuterCapturedInLocalClass() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/outerCapturedInLocalClass.kt");
            }

            @Test
            @TestMetadata("outerCapturedInNestedLambda.kt")
            public void testOuterCapturedInNestedLambda() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/outerCapturedInNestedLambda.kt");
            }

            @Test
            @TestMetadata("outerCapturedInNestedObject.kt")
            public void testOuterCapturedInNestedObject() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/outerCapturedInNestedObject.kt");
            }

            @Test
            @TestMetadata("outerCapturedInObject.kt")
            public void testOuterCapturedInObject() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/outerCapturedInObject.kt");
            }

            @Test
            @TestMetadata("outerCapturedInObject2.kt")
            public void testOuterCapturedInObject2() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/outerCapturedInObject2.kt");
            }

            @Test
            @TestMetadata("outerCapturedInPrimaryConstructorDefaultParameter.kt")
            public void testOuterCapturedInPrimaryConstructorDefaultParameter() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/outerCapturedInPrimaryConstructorDefaultParameter.kt");
            }

            @Test
            @TestMetadata("outerCapturedInSecondaryConstructorDefaultParameter.kt")
            public void testOuterCapturedInSecondaryConstructorDefaultParameter() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/outerCapturedInSecondaryConstructorDefaultParameter.kt");
            }

            @Test
            @TestMetadata("outerEnumEntryCapturedInLambdaInInnerClass.kt")
            public void testOuterEnumEntryCapturedInLambdaInInnerClass() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/outerEnumEntryCapturedInLambdaInInnerClass.kt");
            }

            @Test
            @TestMetadata("properValueCapturedByClosure1.kt")
            public void testProperValueCapturedByClosure1() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/properValueCapturedByClosure1.kt");
            }

            @Test
            @TestMetadata("properValueCapturedByClosure2.kt")
            public void testProperValueCapturedByClosure2() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/properValueCapturedByClosure2.kt");
            }

            @Test
            @TestMetadata("referenceToCapturedVariablesInMultipleLambdas.kt")
            public void testReferenceToCapturedVariablesInMultipleLambdas() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureInSuperConstructorCall/referenceToCapturedVariablesInMultipleLambdas.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/box/closures/captureOuterProperty")
        @TestDataPath("$PROJECT_ROOT")
        public class CaptureOuterProperty {
            @Test
            public void testAllFilesPresentInCaptureOuterProperty() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/closures/captureOuterProperty"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("captureFunctionInProperty.kt")
            public void testCaptureFunctionInProperty() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureOuterProperty/captureFunctionInProperty.kt");
            }

            @Test
            @TestMetadata("inFunction.kt")
            public void testInFunction() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureOuterProperty/inFunction.kt");
            }

            @Test
            @TestMetadata("inProperty.kt")
            public void testInProperty() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureOuterProperty/inProperty.kt");
            }

            @Test
            @TestMetadata("inPropertyDeepObjectChain.kt")
            public void testInPropertyDeepObjectChain() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureOuterProperty/inPropertyDeepObjectChain.kt");
            }

            @Test
            @TestMetadata("inPropertyFromSuperClass.kt")
            public void testInPropertyFromSuperClass() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureOuterProperty/inPropertyFromSuperClass.kt");
            }

            @Test
            @TestMetadata("inPropertyFromSuperSuperClass.kt")
            public void testInPropertyFromSuperSuperClass() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureOuterProperty/inPropertyFromSuperSuperClass.kt");
            }

            @Test
            @TestMetadata("kt4176.kt")
            public void testKt4176() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureOuterProperty/kt4176.kt");
            }

            @Test
            @TestMetadata("kt4656.kt")
            public void testKt4656() throws Exception {
                runTest("compiler/testData/codegen/box/closures/captureOuterProperty/kt4656.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/box/closures/capturedVarsOptimization")
        @TestDataPath("$PROJECT_ROOT")
        public class CapturedVarsOptimization {
            @Test
            public void testAllFilesPresentInCapturedVarsOptimization() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/closures/capturedVarsOptimization"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("capturedInCrossinline.kt")
            public void testCapturedInCrossinline() throws Exception {
                runTest("compiler/testData/codegen/box/closures/capturedVarsOptimization/capturedInCrossinline.kt");
            }

            @Test
            @TestMetadata("capturedInInlineOnlyAssign.kt")
            public void testCapturedInInlineOnlyAssign() throws Exception {
                runTest("compiler/testData/codegen/box/closures/capturedVarsOptimization/capturedInInlineOnlyAssign.kt");
            }

            @Test
            @TestMetadata("capturedInInlineOnlyCAO.kt")
            public void testCapturedInInlineOnlyCAO() throws Exception {
                runTest("compiler/testData/codegen/box/closures/capturedVarsOptimization/capturedInInlineOnlyCAO.kt");
            }

            @Test
            @TestMetadata("capturedInInlineOnlyIncrDecr.kt")
            public void testCapturedInInlineOnlyIncrDecr() throws Exception {
                runTest("compiler/testData/codegen/box/closures/capturedVarsOptimization/capturedInInlineOnlyIncrDecr.kt");
            }

            @Test
            @TestMetadata("capturedInInlineOnlyIndexedCAO.kt")
            public void testCapturedInInlineOnlyIndexedCAO() throws Exception {
                runTest("compiler/testData/codegen/box/closures/capturedVarsOptimization/capturedInInlineOnlyIndexedCAO.kt");
            }

            @Test
            @TestMetadata("capturedVarsOfSize2.kt")
            public void testCapturedVarsOfSize2() throws Exception {
                runTest("compiler/testData/codegen/box/closures/capturedVarsOptimization/capturedVarsOfSize2.kt");
            }

            @Test
            @TestMetadata("kt17200.kt")
            public void testKt17200() throws Exception {
                runTest("compiler/testData/codegen/box/closures/capturedVarsOptimization/kt17200.kt");
            }

            @Test
            @TestMetadata("kt17588.kt")
            public void testKt17588() throws Exception {
                runTest("compiler/testData/codegen/box/closures/capturedVarsOptimization/kt17588.kt");
            }

            @Test
            @TestMetadata("kt44347.kt")
            public void testKt44347() throws Exception {
                runTest("compiler/testData/codegen/box/closures/capturedVarsOptimization/kt44347.kt");
            }

            @Test
            @TestMetadata("kt45446.kt")
            public void testKt45446() throws Exception {
                runTest("compiler/testData/codegen/box/closures/capturedVarsOptimization/kt45446.kt");
            }

            @Test
            @TestMetadata("sharedSlotsWithCapturedVars.kt")
            public void testSharedSlotsWithCapturedVars() throws Exception {
                runTest("compiler/testData/codegen/box/closures/capturedVarsOptimization/sharedSlotsWithCapturedVars.kt");
            }

            @Test
            @TestMetadata("withCoroutines.kt")
            public void testWithCoroutines() throws Exception {
                runTest("compiler/testData/codegen/box/closures/capturedVarsOptimization/withCoroutines.kt");
            }

            @Test
            @TestMetadata("withCoroutinesNoStdLib.kt")
            public void testWithCoroutinesNoStdLib() throws Exception {
                runTest("compiler/testData/codegen/box/closures/capturedVarsOptimization/withCoroutinesNoStdLib.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/box/closures/closureInsideClosure")
        @TestDataPath("$PROJECT_ROOT")
        public class ClosureInsideClosure {
            @Test
            public void testAllFilesPresentInClosureInsideClosure() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/closures/closureInsideClosure"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("localFunInsideLocalFun.kt")
            public void testLocalFunInsideLocalFun() throws Exception {
                runTest("compiler/testData/codegen/box/closures/closureInsideClosure/localFunInsideLocalFun.kt");
            }

            @Test
            @TestMetadata("localFunInsideLocalFunDifferentSignatures.kt")
            public void testLocalFunInsideLocalFunDifferentSignatures() throws Exception {
                runTest("compiler/testData/codegen/box/closures/closureInsideClosure/localFunInsideLocalFunDifferentSignatures.kt");
            }

            @Test
            @TestMetadata("propertyAndFunctionNameClash.kt")
            public void testPropertyAndFunctionNameClash() throws Exception {
                runTest("compiler/testData/codegen/box/closures/closureInsideClosure/propertyAndFunctionNameClash.kt");
            }

            @Test
            @TestMetadata("threeLevels.kt")
            public void testThreeLevels() throws Exception {
                runTest("compiler/testData/codegen/box/closures/closureInsideClosure/threeLevels.kt");
            }

            @Test
            @TestMetadata("threeLevelsDifferentSignatures.kt")
            public void testThreeLevelsDifferentSignatures() throws Exception {
                runTest("compiler/testData/codegen/box/closures/closureInsideClosure/threeLevelsDifferentSignatures.kt");
            }

            @Test
            @TestMetadata("varAsFunInsideLocalFun.kt")
            public void testVarAsFunInsideLocalFun() throws Exception {
                runTest("compiler/testData/codegen/box/closures/closureInsideClosure/varAsFunInsideLocalFun.kt");
            }
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/collectionLiterals")
    @TestDataPath("$PROJECT_ROOT")
    public class CollectionLiterals {
        @Test
        public void testAllFilesPresentInCollectionLiterals() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/collectionLiterals"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("collectionLiteralsInArgumentPosition.kt")
        public void testCollectionLiteralsInArgumentPosition() throws Exception {
            runTest("compiler/testData/codegen/box/collectionLiterals/collectionLiteralsInArgumentPosition.kt");
        }

        @Test
        @TestMetadata("collectionLiteralsWithConstants.kt")
        public void testCollectionLiteralsWithConstants() throws Exception {
            runTest("compiler/testData/codegen/box/collectionLiterals/collectionLiteralsWithConstants.kt");
        }

        @Test
        @TestMetadata("collectionLiteralsWithVarargs.kt")
        public void testCollectionLiteralsWithVarargs() throws Exception {
            runTest("compiler/testData/codegen/box/collectionLiterals/collectionLiteralsWithVarargs.kt");
        }

        @Test
        @TestMetadata("defaultAnnotationParameterValues.kt")
        public void testDefaultAnnotationParameterValues() throws Exception {
            runTest("compiler/testData/codegen/box/collectionLiterals/defaultAnnotationParameterValues.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/collections")
    @TestDataPath("$PROJECT_ROOT")
    public class Collections {
        @Test
        @TestMetadata("addCollectionStubWithCovariantOverride.kt")
        public void testAddCollectionStubWithCovariantOverride() throws Exception {
            runTest("compiler/testData/codegen/box/collections/addCollectionStubWithCovariantOverride.kt");
        }

        @Test
        public void testAllFilesPresentInCollections() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/collections"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("charSequence.kt")
        public void testCharSequence() throws Exception {
            runTest("compiler/testData/codegen/box/collections/charSequence.kt");
        }

        @Test
        @TestMetadata("implementCollectionThroughKotlin.kt")
        public void testImplementCollectionThroughKotlin() throws Exception {
            runTest("compiler/testData/codegen/box/collections/implementCollectionThroughKotlin.kt");
        }

        @Test
        @TestMetadata("inSetWithSmartCast.kt")
        public void testInSetWithSmartCast() throws Exception {
            runTest("compiler/testData/codegen/box/collections/inSetWithSmartCast.kt");
        }

        @Test
        @TestMetadata("inheritFromAbstractMutableListInt.kt")
        public void testInheritFromAbstractMutableListInt() throws Exception {
            runTest("compiler/testData/codegen/box/collections/inheritFromAbstractMutableListInt.kt");
        }

        @Test
        @TestMetadata("inheritFromHashtable.kt")
        public void testInheritFromHashtable() throws Exception {
            runTest("compiler/testData/codegen/box/collections/inheritFromHashtable.kt");
        }

        @Test
        @TestMetadata("internalRemove.kt")
        public void testInternalRemove() throws Exception {
            runTest("compiler/testData/codegen/box/collections/internalRemove.kt");
        }

        @Test
        @TestMetadata("internalRemoveFromJava.kt")
        public void testInternalRemoveFromJava() throws Exception {
            runTest("compiler/testData/codegen/box/collections/internalRemoveFromJava.kt");
        }

        @Test
        @TestMetadata("irrelevantImplCharSequence.kt")
        public void testIrrelevantImplCharSequence() throws Exception {
            runTest("compiler/testData/codegen/box/collections/irrelevantImplCharSequence.kt");
        }

        @Test
        @TestMetadata("irrelevantImplCharSequenceKotlin.kt")
        public void testIrrelevantImplCharSequenceKotlin() throws Exception {
            runTest("compiler/testData/codegen/box/collections/irrelevantImplCharSequenceKotlin.kt");
        }

        @Test
        @TestMetadata("irrelevantImplMutableList.kt")
        public void testIrrelevantImplMutableList() throws Exception {
            runTest("compiler/testData/codegen/box/collections/irrelevantImplMutableList.kt");
        }

        @Test
        @TestMetadata("irrelevantImplMutableListKotlin.kt")
        public void testIrrelevantImplMutableListKotlin() throws Exception {
            runTest("compiler/testData/codegen/box/collections/irrelevantImplMutableListKotlin.kt");
        }

        @Test
        @TestMetadata("irrelevantImplMutableListSubstitution.kt")
        public void testIrrelevantImplMutableListSubstitution() throws Exception {
            runTest("compiler/testData/codegen/box/collections/irrelevantImplMutableListSubstitution.kt");
        }

        @Test
        @TestMetadata("irrelevantRemoveAtOverrideInJava.kt")
        public void testIrrelevantRemoveAtOverrideInJava() throws Exception {
            runTest("compiler/testData/codegen/box/collections/irrelevantRemoveAtOverrideInJava.kt");
        }

        @Test
        @TestMetadata("irrelevantSizeOverrideInJava.kt")
        public void testIrrelevantSizeOverrideInJava() throws Exception {
            runTest("compiler/testData/codegen/box/collections/irrelevantSizeOverrideInJava.kt");
        }

        @Test
        @TestMetadata("javaCollectionWithRemovePrimitiveInt.kt")
        public void testJavaCollectionWithRemovePrimitiveInt() throws Exception {
            runTest("compiler/testData/codegen/box/collections/javaCollectionWithRemovePrimitiveInt.kt");
        }

        @Test
        @TestMetadata("kt40305.kt")
        public void testKt40305() throws Exception {
            runTest("compiler/testData/codegen/box/collections/kt40305.kt");
        }

        @Test
        @TestMetadata("kt41123.kt")
        public void testKt41123() throws Exception {
            runTest("compiler/testData/codegen/box/collections/kt41123.kt");
        }

        @Test
        @TestMetadata("kt44233.kt")
        public void testKt44233() throws Exception {
            runTest("compiler/testData/codegen/box/collections/kt44233.kt");
        }

        @Test
        @TestMetadata("kt48945.kt")
        public void testKt48945() throws Exception {
            runTest("compiler/testData/codegen/box/collections/kt48945.kt");
        }

        @Test
        @TestMetadata("kt48945a.kt")
        public void testKt48945a() throws Exception {
            runTest("compiler/testData/codegen/box/collections/kt48945a.kt");
        }

        @Test
        @TestMetadata("kt48945b.kt")
        public void testKt48945b() throws Exception {
            runTest("compiler/testData/codegen/box/collections/kt48945b.kt");
        }

        @Test
        @TestMetadata("kt48945c.kt")
        public void testKt48945c() throws Exception {
            runTest("compiler/testData/codegen/box/collections/kt48945c.kt");
        }

        @Test
        @TestMetadata("mutableList.kt")
        public void testMutableList() throws Exception {
            runTest("compiler/testData/codegen/box/collections/mutableList.kt");
        }

        @Test
        @TestMetadata("noStubsInJavaSuperClass.kt")
        public void testNoStubsInJavaSuperClass() throws Exception {
            runTest("compiler/testData/codegen/box/collections/noStubsInJavaSuperClass.kt");
        }

        @Test
        @TestMetadata("platformValueContains.kt")
        public void testPlatformValueContains() throws Exception {
            runTest("compiler/testData/codegen/box/collections/platformValueContains.kt");
        }

        @Test
        @TestMetadata("readOnlyList.kt")
        public void testReadOnlyList() throws Exception {
            runTest("compiler/testData/codegen/box/collections/readOnlyList.kt");
        }

        @Test
        @TestMetadata("readOnlyMap.kt")
        public void testReadOnlyMap() throws Exception {
            runTest("compiler/testData/codegen/box/collections/readOnlyMap.kt");
        }

        @Test
        @TestMetadata("removeAtBridgeClashWithJava.kt")
        public void testRemoveAtBridgeClashWithJava() throws Exception {
            runTest("compiler/testData/codegen/box/collections/removeAtBridgeClashWithJava.kt");
        }

        @Test
        @TestMetadata("removeAtInt.kt")
        public void testRemoveAtInt() throws Exception {
            runTest("compiler/testData/codegen/box/collections/removeAtInt.kt");
        }

        @Test
        @TestMetadata("removeClash.kt")
        public void testRemoveClash() throws Exception {
            runTest("compiler/testData/codegen/box/collections/removeClash.kt");
        }

        @Test
        @TestMetadata("removeClashJava.kt")
        public void testRemoveClashJava() throws Exception {
            runTest("compiler/testData/codegen/box/collections/removeClashJava.kt");
        }

        @Test
        @TestMetadata("removeClashKotlin.kt")
        public void testRemoveClashKotlin() throws Exception {
            runTest("compiler/testData/codegen/box/collections/removeClashKotlin.kt");
        }

        @Test
        @TestMetadata("removeClashWithGenerics.kt")
        public void testRemoveClashWithGenerics() throws Exception {
            runTest("compiler/testData/codegen/box/collections/removeClashWithGenerics.kt");
        }

        @Test
        @TestMetadata("removeNullFromList.kt")
        public void testRemoveNullFromList() throws Exception {
            runTest("compiler/testData/codegen/box/collections/removeNullFromList.kt");
        }

        @Test
        @TestMetadata("removeOverriddenInJava.kt")
        public void testRemoveOverriddenInJava() throws Exception {
            runTest("compiler/testData/codegen/box/collections/removeOverriddenInJava.kt");
        }

        @Test
        @TestMetadata("removeOverriddenInJava_Map.kt")
        public void testRemoveOverriddenInJava_Map() throws Exception {
            runTest("compiler/testData/codegen/box/collections/removeOverriddenInJava_Map.kt");
        }

        @Test
        @TestMetadata("specialBridgeForGet.kt")
        public void testSpecialBridgeForGet() throws Exception {
            runTest("compiler/testData/codegen/box/collections/specialBridgeForGet.kt");
        }

        @Test
        @TestMetadata("strList.kt")
        public void testStrList() throws Exception {
            runTest("compiler/testData/codegen/box/collections/strList.kt");
        }

        @Test
        @TestMetadata("toArrayInJavaClass.kt")
        public void testToArrayInJavaClass() throws Exception {
            runTest("compiler/testData/codegen/box/collections/toArrayInJavaClass.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/companion")
    @TestDataPath("$PROJECT_ROOT")
    public class Companion {
        @Test
        public void testAllFilesPresentInCompanion() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/companion"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("delegatedPropertyOnCompanion.kt")
        public void testDelegatedPropertyOnCompanion() throws Exception {
            runTest("compiler/testData/codegen/box/companion/delegatedPropertyOnCompanion.kt");
        }

        @Test
        @TestMetadata("genericLambdaOnStringCompanion.kt")
        public void testGenericLambdaOnStringCompanion() throws Exception {
            runTest("compiler/testData/codegen/box/companion/genericLambdaOnStringCompanion.kt");
        }

        @Test
        @TestMetadata("inlineFunctionCompanionPropertyAccess.kt")
        public void testInlineFunctionCompanionPropertyAccess() throws Exception {
            runTest("compiler/testData/codegen/box/companion/inlineFunctionCompanionPropertyAccess.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/compatibility")
    @TestDataPath("$PROJECT_ROOT")
    public class Compatibility {
        @Test
        public void testAllFilesPresentInCompatibility() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/compatibility"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("privateCompanionObject.kt")
        public void testPrivateCompanionObject() throws Exception {
            runTest("compiler/testData/codegen/box/compatibility/privateCompanionObject.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/compileKotlinAgainstKotlin")
    @TestDataPath("$PROJECT_ROOT")
    public class CompileKotlinAgainstKotlin {
        @Test
        @TestMetadata("adaptedSuspendFunctionReference.kt")
        public void testAdaptedSuspendFunctionReference() throws Exception {
            runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/adaptedSuspendFunctionReference.kt");
        }

        @Test
        public void testAllFilesPresentInCompileKotlinAgainstKotlin() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/compileKotlinAgainstKotlin"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("annotationInInterface.kt")
        public void testAnnotationInInterface() throws Exception {
            runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/annotationInInterface.kt");
        }

        @Test
        @TestMetadata("annotationOnTypeUseInTypeAlias.kt")
        public void testAnnotationOnTypeUseInTypeAlias() throws Exception {
            runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/annotationOnTypeUseInTypeAlias.kt");
        }

        @Test
        @TestMetadata("annotationsOnTypeAliases.kt")
        public void testAnnotationsOnTypeAliases() throws Exception {
            runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/annotationsOnTypeAliases.kt");
        }

        @Test
        @TestMetadata("callsToMultifileClassFromOtherPackage.kt")
        public void testCallsToMultifileClassFromOtherPackage() throws Exception {
            runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/callsToMultifileClassFromOtherPackage.kt");
        }

        @Test
        @TestMetadata("clashingFakeOverrideSignatures.kt")
        public void testClashingFakeOverrideSignatures() throws Exception {
            runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/clashingFakeOverrideSignatures.kt");
        }

        @Test
        @TestMetadata("classInObject.kt")
        public void testClassInObject() throws Exception {
            runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/classInObject.kt");
        }

        @Test
        @TestMetadata("companionObjectInEnum.kt")
        public void testCompanionObjectInEnum() throws Exception {
            runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/companionObjectInEnum.kt");
        }

        @Test
        @TestMetadata("companionObjectMember.kt")
        public void testCompanionObjectMember() throws Exception {
            runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/companionObjectMember.kt");
        }

        @Test
        @TestMetadata("constPropertyReferenceFromMultifileClass.kt")
        public void testConstPropertyReferenceFromMultifileClass() throws Exception {
            runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/constPropertyReferenceFromMultifileClass.kt");
        }

        @Test
        @TestMetadata("constructorVararg.kt")
        public void testConstructorVararg() throws Exception {
            runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/constructorVararg.kt");
        }

        @Test
        @TestMetadata("copySamOnInline.kt")
        public void testCopySamOnInline() throws Exception {
            runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/copySamOnInline.kt");
        }

        @Test
        @TestMetadata("copySamOnInline2.kt")
        public void testCopySamOnInline2() throws Exception {
            runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/copySamOnInline2.kt");
        }

        @Test
        @TestMetadata("coroutinesBinary.kt")
        public void testCoroutinesBinary() throws Exception {
            runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/coroutinesBinary.kt");
        }

        @Test
        @TestMetadata("defaultConstructor.kt")
        public void testDefaultConstructor() throws Exception {
            runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/defaultConstructor.kt");
        }

        @Test
        @TestMetadata("defaultLambdaRegeneration.kt")
        public void testDefaultLambdaRegeneration() throws Exception {
            runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/defaultLambdaRegeneration.kt");
        }

        @Test
        @TestMetadata("defaultLambdaRegeneration2.kt")
        public void testDefaultLambdaRegeneration2() throws Exception {
            runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/defaultLambdaRegeneration2.kt");
        }

        @Test
        @TestMetadata("delegatedDefault.kt")
        public void testDelegatedDefault() throws Exception {
            runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/delegatedDefault.kt");
        }

        @Test
        @TestMetadata("delegationAndAnnotations.kt")
        public void testDelegationAndAnnotations() throws Exception {
            runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/delegationAndAnnotations.kt");
        }

        @Test
        @TestMetadata("doublyNestedClass.kt")
        public void testDoublyNestedClass() throws Exception {
            runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/doublyNestedClass.kt");
        }

        @Test
        @TestMetadata("enum.kt")
        public void testEnum() throws Exception {
            runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/enum.kt");
        }

        @Test
        @TestMetadata("expectClassActualTypeAlias.kt")
        public void testExpectClassActualTypeAlias() throws Exception {
            runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/expectClassActualTypeAlias.kt");
        }

        @Test
        @TestMetadata("fakeOverridesForIntersectionTypes.kt")
        public void testFakeOverridesForIntersectionTypes() throws Exception {
            runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/fakeOverridesForIntersectionTypes.kt");
        }

        @Test
        @TestMetadata("importCompanion.kt")
        public void testImportCompanion() throws Exception {
            runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/importCompanion.kt");
        }

        @Test
        @TestMetadata("inlinedConstants.kt")
        public void testInlinedConstants() throws Exception {
            runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/inlinedConstants.kt");
        }

        @Test
        @TestMetadata("innerClassConstructor.kt")
        public void testInnerClassConstructor() throws Exception {
            runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/innerClassConstructor.kt");
        }

        @Test
        @TestMetadata("interfaceDelegationAndBridgesProcessing.kt")
        public void testInterfaceDelegationAndBridgesProcessing() throws Exception {
            runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/interfaceDelegationAndBridgesProcessing.kt");
        }

        @Test
        @TestMetadata("internalLeakBug.kt")
        public void testInternalLeakBug() throws Exception {
            runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/internalLeakBug.kt");
        }

        @Test
        @TestMetadata("internalSetterOverridden.kt")
        public void testInternalSetterOverridden() throws Exception {
            runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/internalSetterOverridden.kt");
        }

        @Test
        @TestMetadata("internalWithDefaultArgs.kt")
        public void testInternalWithDefaultArgs() throws Exception {
            runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/internalWithDefaultArgs.kt");
        }

        @Test
        @TestMetadata("internalWithOtherModuleName.kt")
        public void testInternalWithOtherModuleName() throws Exception {
            runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/internalWithOtherModuleName.kt");
        }

        @Test
        @TestMetadata("intersectionOverrideProperies.kt")
        public void testIntersectionOverrideProperies() throws Exception {
            runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/intersectionOverrideProperies.kt");
        }

        @Test
        @TestMetadata("jvmField.kt")
        public void testJvmField() throws Exception {
            runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvmField.kt");
        }

        @Test
        @TestMetadata("jvmFieldInAnnotationCompanion.kt")
        public void testJvmFieldInAnnotationCompanion() throws Exception {
            runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvmFieldInAnnotationCompanion.kt");
        }

        @Test
        @TestMetadata("jvmFieldInConstructor.kt")
        public void testJvmFieldInConstructor() throws Exception {
            runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvmFieldInConstructor.kt");
        }

        @Test
        @TestMetadata("jvmFieldInConstructor2.kt")
        public void testJvmFieldInConstructor2() throws Exception {
            runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvmFieldInConstructor2.kt");
        }

        @Test
        @TestMetadata("jvmFieldInInterfaceCompanion.kt")
        public void testJvmFieldInInterfaceCompanion() throws Exception {
            runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvmFieldInInterfaceCompanion.kt");
        }

        @Test
        @TestMetadata("jvmNames.kt")
        public void testJvmNames() throws Exception {
            runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvmNames.kt");
        }

        @Test
        @TestMetadata("jvmPackageName.kt")
        public void testJvmPackageName() throws Exception {
            runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvmPackageName.kt");
        }

        @Test
        @TestMetadata("jvmPackageNameInRootPackage.kt")
        public void testJvmPackageNameInRootPackage() throws Exception {
            runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvmPackageNameInRootPackage.kt");
        }

        @Test
        @TestMetadata("jvmPackageNameMultifileClass.kt")
        public void testJvmPackageNameMultifileClass() throws Exception {
            runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvmPackageNameMultifileClass.kt");
        }

        @Test
        @TestMetadata("jvmPackageNameWithJvmName.kt")
        public void testJvmPackageNameWithJvmName() throws Exception {
            runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvmPackageNameWithJvmName.kt");
        }

        @Test
        @TestMetadata("jvmStaticInObject.kt")
        public void testJvmStaticInObject() throws Exception {
            runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvmStaticInObject.kt");
        }

        @Test
        @TestMetadata("jvmStaticInObjectPropertyReference.kt")
        public void testJvmStaticInObjectPropertyReference() throws Exception {
            runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvmStaticInObjectPropertyReference.kt");
        }

        @Test
        @TestMetadata("kotlinPropertyAsAnnotationParameter.kt")
        public void testKotlinPropertyAsAnnotationParameter() throws Exception {
            runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/kotlinPropertyAsAnnotationParameter.kt");
        }

        @Test
        @TestMetadata("kt14012.kt")
        public void testKt14012() throws Exception {
            runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/kt14012.kt");
        }

        @Test
        @TestMetadata("kt14012_multi.kt")
        public void testKt14012_multi() throws Exception {
            runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/kt14012_multi.kt");
        }

        @Test
        @TestMetadata("kt21775.kt")
        public void testKt21775() throws Exception {
            runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/kt21775.kt");
        }

        @Test
        @TestMetadata("metadataForMembersInLocalClassInInitializer.kt")
        public void testMetadataForMembersInLocalClassInInitializer() throws Exception {
            runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/metadataForMembersInLocalClassInInitializer.kt");
        }

        @Test
        @TestMetadata("multifileClassInlineFunctionAccessingProperty.kt")
        public void testMultifileClassInlineFunctionAccessingProperty() throws Exception {
            runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/multifileClassInlineFunctionAccessingProperty.kt");
        }

        @Test
        @TestMetadata("multifileClassWithTypealias.kt")
        public void testMultifileClassWithTypealias() throws Exception {
            runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/multifileClassWithTypealias.kt");
        }

        @Test
        @TestMetadata("nestedClass.kt")
        public void testNestedClass() throws Exception {
            runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/nestedClass.kt");
        }

        @Test
        @TestMetadata("nestedClassInAnnotationArgument.kt")
        public void testNestedClassInAnnotationArgument() throws Exception {
            runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/nestedClassInAnnotationArgument.kt");
        }

        @Test
        @TestMetadata("nestedEnum.kt")
        public void testNestedEnum() throws Exception {
            runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/nestedEnum.kt");
        }

        @Test
        @TestMetadata("nestedFunctionTypeAliasExpansion.kt")
        public void testNestedFunctionTypeAliasExpansion() throws Exception {
            runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/nestedFunctionTypeAliasExpansion.kt");
        }

        @Test
        @TestMetadata("nestedObject.kt")
        public void testNestedObject() throws Exception {
            runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/nestedObject.kt");
        }

        @Test
        @TestMetadata("nestedTypeAliasExpansion.kt")
        public void testNestedTypeAliasExpansion() throws Exception {
            runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/nestedTypeAliasExpansion.kt");
        }

        @Test
        @TestMetadata("noExplicitOverrideForDelegatedFromSupertype.kt")
        public void testNoExplicitOverrideForDelegatedFromSupertype() throws Exception {
            runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/noExplicitOverrideForDelegatedFromSupertype.kt");
        }

        @Test
        @TestMetadata("optionalAnnotation.kt")
        public void testOptionalAnnotation() throws Exception {
            runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/optionalAnnotation.kt");
        }

        @Test
        @TestMetadata("platformTypes.kt")
        public void testPlatformTypes() throws Exception {
            runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/platformTypes.kt");
        }

        @Test
        @TestMetadata("propertyReference.kt")
        public void testPropertyReference() throws Exception {
            runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/propertyReference.kt");
        }

        @Test
        @TestMetadata("recursiveGeneric.kt")
        public void testRecursiveGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/recursiveGeneric.kt");
        }

        @Test
        @TestMetadata("reflectTopLevelFunctionOtherFile.kt")
        public void testReflectTopLevelFunctionOtherFile() throws Exception {
            runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/reflectTopLevelFunctionOtherFile.kt");
        }

        @Test
        @TestMetadata("repeatableAnnotation.kt")
        public void testRepeatableAnnotation() throws Exception {
            runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/repeatableAnnotation.kt");
        }

        @Test
        @TestMetadata("sealedClass.kt")
        public void testSealedClass() throws Exception {
            runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/sealedClass.kt");
        }

        @Test
        @TestMetadata("secondaryConstructors.kt")
        public void testSecondaryConstructors() throws Exception {
            runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/secondaryConstructors.kt");
        }

        @Test
        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/simple.kt");
        }

        @Test
        @TestMetadata("simpleValAnonymousObject.kt")
        public void testSimpleValAnonymousObject() throws Exception {
            runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/simpleValAnonymousObject.kt");
        }

        @Test
        @TestMetadata("specialBridgesInDependencies.kt")
        public void testSpecialBridgesInDependencies() throws Exception {
            runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/specialBridgesInDependencies.kt");
        }

        @Test
        @TestMetadata("starImportEnum.kt")
        public void testStarImportEnum() throws Exception {
            runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/starImportEnum.kt");
        }

        @Test
        @TestMetadata("targetedJvmName.kt")
        public void testTargetedJvmName() throws Exception {
            runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/targetedJvmName.kt");
        }

        @Test
        @TestMetadata("typeAliasesKt13181.kt")
        public void testTypeAliasesKt13181() throws Exception {
            runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/typeAliasesKt13181.kt");
        }

        @Test
        @TestMetadata("unsignedTypesInAnnotations.kt")
        public void testUnsignedTypesInAnnotations() throws Exception {
            runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/unsignedTypesInAnnotations.kt");
        }

        @Test
        @TestMetadata("useDeserializedFunInterface.kt")
        public void testUseDeserializedFunInterface() throws Exception {
            runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/useDeserializedFunInterface.kt");
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/box/compileKotlinAgainstKotlin/fir")
        @TestDataPath("$PROJECT_ROOT")
        public class Fir {
            @Test
            public void testAllFilesPresentInFir() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/compileKotlinAgainstKotlin/fir"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("AnonymousObjectInProperty.kt")
            public void testAnonymousObjectInProperty() throws Exception {
                runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/fir/AnonymousObjectInProperty.kt");
            }

            @Test
            @TestMetadata("ExistingSymbolInFakeOverride.kt")
            public void testExistingSymbolInFakeOverride() throws Exception {
                runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/fir/ExistingSymbolInFakeOverride.kt");
            }

            @Test
            @TestMetadata("IncrementalCompilerRunner.kt")
            public void testIncrementalCompilerRunner() throws Exception {
                runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/fir/IncrementalCompilerRunner.kt");
            }

            @Test
            @TestMetadata("IrConstAcceptMultiModule.kt")
            public void testIrConstAcceptMultiModule() throws Exception {
                runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/fir/IrConstAcceptMultiModule.kt");
            }

            @Test
            @TestMetadata("LibraryProperty.kt")
            public void testLibraryProperty() throws Exception {
                runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/fir/LibraryProperty.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/box/compileKotlinAgainstKotlin/inlineClasses")
        @TestDataPath("$PROJECT_ROOT")
        public class InlineClasses {
            @Test
            public void testAllFilesPresentInInlineClasses() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/compileKotlinAgainstKotlin/inlineClasses"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("callDeserializedPropertyOnInlineClassType.kt")
            public void testCallDeserializedPropertyOnInlineClassType() throws Exception {
                runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/inlineClasses/callDeserializedPropertyOnInlineClassType.kt");
            }

            @Test
            @TestMetadata("constructorWithInlineClassParametersInBinaryDependencies.kt")
            public void testConstructorWithInlineClassParametersInBinaryDependencies() throws Exception {
                runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/inlineClasses/constructorWithInlineClassParametersInBinaryDependencies.kt");
            }

            @Test
            @TestMetadata("defaultWithInlineClassAndReceivers.kt")
            public void testDefaultWithInlineClassAndReceivers() throws Exception {
                runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/inlineClasses/defaultWithInlineClassAndReceivers.kt");
            }

            @Test
            @TestMetadata("extensionPropertyWithSameName.kt")
            public void testExtensionPropertyWithSameName() throws Exception {
                runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/inlineClasses/extensionPropertyWithSameName.kt");
            }

            @Test
            @TestMetadata("funInterface.kt")
            public void testFunInterface() throws Exception {
                runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/inlineClasses/funInterface.kt");
            }

            @Test
            @TestMetadata("inlineClassFakeOverrideMangling.kt")
            public void testInlineClassFakeOverrideMangling() throws Exception {
                runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/inlineClasses/inlineClassFakeOverrideMangling.kt");
            }

            @Test
            @TestMetadata("inlineClassFromBinaryDependencies.kt")
            public void testInlineClassFromBinaryDependencies() throws Exception {
                runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/inlineClasses/inlineClassFromBinaryDependencies.kt");
            }

            @Test
            @TestMetadata("inlineClassInlineFunctionCall.kt")
            public void testInlineClassInlineFunctionCall() throws Exception {
                runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/inlineClasses/inlineClassInlineFunctionCall.kt");
            }

            @Test
            @TestMetadata("inlineClassInlineProperty.kt")
            public void testInlineClassInlineProperty() throws Exception {
                runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/inlineClasses/inlineClassInlineProperty.kt");
            }

            @Test
            @TestMetadata("internalWithInlineClass.kt")
            public void testInternalWithInlineClass() throws Exception {
                runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/inlineClasses/internalWithInlineClass.kt");
            }

            @Test
            @TestMetadata("privateCompanionObjectValInDifferentModule.kt")
            public void testPrivateCompanionObjectValInDifferentModule() throws Exception {
                runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/inlineClasses/privateCompanionObjectValInDifferentModule.kt");
            }

            @Test
            @TestMetadata("privateConstructor.kt")
            public void testPrivateConstructor() throws Exception {
                runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/inlineClasses/privateConstructor.kt");
            }

            @Test
            @TestMetadata("privateConstructorWithPrivateField.kt")
            public void testPrivateConstructorWithPrivateField() throws Exception {
                runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/inlineClasses/privateConstructorWithPrivateField.kt");
            }

            @Test
            @TestMetadata("privateConstructorWithPrivateFieldUsingTypeTable.kt")
            public void testPrivateConstructorWithPrivateFieldUsingTypeTable() throws Exception {
                runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/inlineClasses/privateConstructorWithPrivateFieldUsingTypeTable.kt");
            }

            @Test
            @TestMetadata("privateTopLevelValInDifferentModule.kt")
            public void testPrivateTopLevelValInDifferentModule() throws Exception {
                runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/inlineClasses/privateTopLevelValInDifferentModule.kt");
            }

            @Test
            @TestMetadata("suspendFunWithDefaultMangling.kt")
            public void testSuspendFunWithDefaultMangling() throws Exception {
                runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/inlineClasses/suspendFunWithDefaultMangling.kt");
            }

            @Nested
            @TestMetadata("compiler/testData/codegen/box/compileKotlinAgainstKotlin/inlineClasses/oldMangling")
            @TestDataPath("$PROJECT_ROOT")
            public class OldMangling {
                @Test
                public void testAllFilesPresentInOldMangling() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/compileKotlinAgainstKotlin/inlineClasses/oldMangling"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
                }

                @Test
                @TestMetadata("callDeserializedPropertyOnInlineClassType.kt")
                public void testCallDeserializedPropertyOnInlineClassType() throws Exception {
                    runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/inlineClasses/oldMangling/callDeserializedPropertyOnInlineClassType.kt");
                }

                @Test
                @TestMetadata("constructorWithInlineClassParametersInBinaryDependencies.kt")
                public void testConstructorWithInlineClassParametersInBinaryDependencies() throws Exception {
                    runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/inlineClasses/oldMangling/constructorWithInlineClassParametersInBinaryDependencies.kt");
                }

                @Test
                @TestMetadata("defaultWithInlineClassAndReceivers.kt")
                public void testDefaultWithInlineClassAndReceivers() throws Exception {
                    runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/inlineClasses/oldMangling/defaultWithInlineClassAndReceivers.kt");
                }

                @Test
                @TestMetadata("extensionPropertyWithSameName.kt")
                public void testExtensionPropertyWithSameName() throws Exception {
                    runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/inlineClasses/oldMangling/extensionPropertyWithSameName.kt");
                }

                @Test
                @TestMetadata("inlineClassFakeOverrideMangling.kt")
                public void testInlineClassFakeOverrideMangling() throws Exception {
                    runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/inlineClasses/oldMangling/inlineClassFakeOverrideMangling.kt");
                }

                @Test
                @TestMetadata("inlineClassFromBinaryDependencies.kt")
                public void testInlineClassFromBinaryDependencies() throws Exception {
                    runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/inlineClasses/oldMangling/inlineClassFromBinaryDependencies.kt");
                }

                @Test
                @TestMetadata("inlineClassInlineFunctionCall.kt")
                public void testInlineClassInlineFunctionCall() throws Exception {
                    runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/inlineClasses/oldMangling/inlineClassInlineFunctionCall.kt");
                }

                @Test
                @TestMetadata("inlineClassInlineProperty.kt")
                public void testInlineClassInlineProperty() throws Exception {
                    runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/inlineClasses/oldMangling/inlineClassInlineProperty.kt");
                }

                @Test
                @TestMetadata("privateCompanionObjectValInDifferentModule.kt")
                public void testPrivateCompanionObjectValInDifferentModule() throws Exception {
                    runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/inlineClasses/oldMangling/privateCompanionObjectValInDifferentModule.kt");
                }

                @Test
                @TestMetadata("privateConstructor.kt")
                public void testPrivateConstructor() throws Exception {
                    runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/inlineClasses/oldMangling/privateConstructor.kt");
                }

                @Test
                @TestMetadata("privateConstructorWithPrivateField.kt")
                public void testPrivateConstructorWithPrivateField() throws Exception {
                    runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/inlineClasses/oldMangling/privateConstructorWithPrivateField.kt");
                }

                @Test
                @TestMetadata("privateTopLevelValInDifferentModule.kt")
                public void testPrivateTopLevelValInDifferentModule() throws Exception {
                    runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/inlineClasses/oldMangling/privateTopLevelValInDifferentModule.kt");
                }

                @Test
                @TestMetadata("suspendFunWithDefaultOldMangling.kt")
                public void testSuspendFunWithDefaultOldMangling() throws Exception {
                    runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/inlineClasses/oldMangling/suspendFunWithDefaultOldMangling.kt");
                }

                @Test
                @TestMetadata("useOldMangling.kt")
                public void testUseOldMangling() throws Exception {
                    runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/inlineClasses/oldMangling/useOldMangling.kt");
                }
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvm8")
        @TestDataPath("$PROJECT_ROOT")
        public class Jvm8 {
            @Test
            public void testAllFilesPresentInJvm8() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvm8"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Nested
            @TestMetadata("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvm8/defaults")
            @TestDataPath("$PROJECT_ROOT")
            public class Defaults {
                @Test
                public void testAllFilesPresentInDefaults() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvm8/defaults"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
                }

                @Test
                @TestMetadata("superCall.kt")
                public void testSuperCall() throws Exception {
                    runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvm8/defaults/superCall.kt");
                }

                @Test
                @TestMetadata("superCallFromInterface.kt")
                public void testSuperCallFromInterface() throws Exception {
                    runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvm8/defaults/superCallFromInterface.kt");
                }

                @Test
                @TestMetadata("superCallFromInterface2.kt")
                public void testSuperCallFromInterface2() throws Exception {
                    runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvm8/defaults/superCallFromInterface2.kt");
                }

                @Test
                @TestMetadata("superPropAccess.kt")
                public void testSuperPropAccess() throws Exception {
                    runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvm8/defaults/superPropAccess.kt");
                }

                @Test
                @TestMetadata("superPropAccessFromInterface.kt")
                public void testSuperPropAccessFromInterface() throws Exception {
                    runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvm8/defaults/superPropAccessFromInterface.kt");
                }

                @Test
                @TestMetadata("superPropAccessFromInterface2.kt")
                public void testSuperPropAccessFromInterface2() throws Exception {
                    runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvm8/defaults/superPropAccessFromInterface2.kt");
                }

                @Nested
                @TestMetadata("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvm8/defaults/allCompatibility")
                @TestDataPath("$PROJECT_ROOT")
                public class AllCompatibility {
                    @Test
                    public void testAllFilesPresentInAllCompatibility() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvm8/defaults/allCompatibility"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
                    }

                    @Test
                    @TestMetadata("callStackTrace.kt")
                    public void testCallStackTrace() throws Exception {
                        runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvm8/defaults/allCompatibility/callStackTrace.kt");
                    }

                    @Test
                    @TestMetadata("superCall.kt")
                    public void testSuperCall() throws Exception {
                        runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvm8/defaults/allCompatibility/superCall.kt");
                    }

                    @Test
                    @TestMetadata("superCallFromInterface.kt")
                    public void testSuperCallFromInterface() throws Exception {
                        runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvm8/defaults/allCompatibility/superCallFromInterface.kt");
                    }

                    @Test
                    @TestMetadata("superCallFromInterface2.kt")
                    public void testSuperCallFromInterface2() throws Exception {
                        runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvm8/defaults/allCompatibility/superCallFromInterface2.kt");
                    }

                    @Test
                    @TestMetadata("superPropAccess.kt")
                    public void testSuperPropAccess() throws Exception {
                        runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvm8/defaults/allCompatibility/superPropAccess.kt");
                    }

                    @Test
                    @TestMetadata("superPropAccessFromInterface.kt")
                    public void testSuperPropAccessFromInterface() throws Exception {
                        runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvm8/defaults/allCompatibility/superPropAccessFromInterface.kt");
                    }

                    @Test
                    @TestMetadata("superPropAccessFromInterface2.kt")
                    public void testSuperPropAccessFromInterface2() throws Exception {
                        runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvm8/defaults/allCompatibility/superPropAccessFromInterface2.kt");
                    }

                    @Nested
                    @TestMetadata("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvm8/defaults/allCompatibility/delegationBy")
                    @TestDataPath("$PROJECT_ROOT")
                    public class DelegationBy {
                        @Test
                        public void testAllFilesPresentInDelegationBy() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvm8/defaults/allCompatibility/delegationBy"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
                        }

                        @Test
                        @TestMetadata("simple.kt")
                        public void testSimple() throws Exception {
                            runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvm8/defaults/allCompatibility/delegationBy/simple.kt");
                        }

                        @Test
                        @TestMetadata("simpleProperty.kt")
                        public void testSimpleProperty() throws Exception {
                            runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvm8/defaults/allCompatibility/delegationBy/simpleProperty.kt");
                        }
                    }
                }

                @Nested
                @TestMetadata("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvm8/defaults/interop")
                @TestDataPath("$PROJECT_ROOT")
                public class Interop {
                    @Test
                    @TestMetadata("allAgainsAllCompatibility.kt")
                    public void testAllAgainsAllCompatibility() throws Exception {
                        runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvm8/defaults/interop/allAgainsAllCompatibility.kt");
                    }

                    @Test
                    @TestMetadata("allCompatibilityAgainsAll.kt")
                    public void testAllCompatibilityAgainsAll() throws Exception {
                        runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvm8/defaults/interop/allCompatibilityAgainsAll.kt");
                    }

                    @Test
                    public void testAllFilesPresentInInterop() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvm8/defaults/interop"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
                    }

                    @Test
                    @TestMetadata("likeMemberClash.kt")
                    public void testLikeMemberClash() throws Exception {
                        runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvm8/defaults/interop/likeMemberClash.kt");
                    }

                    @Test
                    @TestMetadata("likeSpecialization.kt")
                    public void testLikeSpecialization() throws Exception {
                        runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvm8/defaults/interop/likeSpecialization.kt");
                    }

                    @Test
                    @TestMetadata("newAndOldSchemes.kt")
                    public void testNewAndOldSchemes() throws Exception {
                        runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvm8/defaults/interop/newAndOldSchemes.kt");
                    }

                    @Test
                    @TestMetadata("newAndOldSchemes2.kt")
                    public void testNewAndOldSchemes2() throws Exception {
                        runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvm8/defaults/interop/newAndOldSchemes2.kt");
                    }

                    @Test
                    @TestMetadata("newAndOldSchemes2Compatibility.kt")
                    public void testNewAndOldSchemes2Compatibility() throws Exception {
                        runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvm8/defaults/interop/newAndOldSchemes2Compatibility.kt");
                    }

                    @Test
                    @TestMetadata("newAndOldSchemes3.kt")
                    public void testNewAndOldSchemes3() throws Exception {
                        runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvm8/defaults/interop/newAndOldSchemes3.kt");
                    }

                    @Test
                    @TestMetadata("newSchemeWithJvmDefault.kt")
                    public void testNewSchemeWithJvmDefault() throws Exception {
                        runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvm8/defaults/interop/newSchemeWithJvmDefault.kt");
                    }
                }

                @Nested
                @TestMetadata("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvm8/defaults/noDefaultImpls")
                @TestDataPath("$PROJECT_ROOT")
                public class NoDefaultImpls {
                    @Test
                    public void testAllFilesPresentInNoDefaultImpls() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvm8/defaults/noDefaultImpls"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
                    }

                    @Test
                    @TestMetadata("superPropAccessFromInterface.kt")
                    public void testSuperPropAccessFromInterface() throws Exception {
                        runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvm8/defaults/noDefaultImpls/superPropAccessFromInterface.kt");
                    }
                }
            }

            @Nested
            @TestMetadata("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvm8/jvm8against6")
            @TestDataPath("$PROJECT_ROOT")
            public class Jvm8against6 {
                @Test
                public void testAllFilesPresentInJvm8against6() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvm8/jvm8against6"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
                }

                @Test
                @TestMetadata("jdk8Against6.kt")
                public void testJdk8Against6() throws Exception {
                    runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvm8/jvm8against6/jdk8Against6.kt");
                }

                @Test
                @TestMetadata("simpleCall.kt")
                public void testSimpleCall() throws Exception {
                    runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvm8/jvm8against6/simpleCall.kt");
                }

                @Test
                @TestMetadata("simpleCallWithBigHierarchy.kt")
                public void testSimpleCallWithBigHierarchy() throws Exception {
                    runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvm8/jvm8against6/simpleCallWithBigHierarchy.kt");
                }

                @Test
                @TestMetadata("simpleCallWithHierarchy.kt")
                public void testSimpleCallWithHierarchy() throws Exception {
                    runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvm8/jvm8against6/simpleCallWithHierarchy.kt");
                }

                @Test
                @TestMetadata("simpleProp.kt")
                public void testSimpleProp() throws Exception {
                    runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvm8/jvm8against6/simpleProp.kt");
                }

                @Test
                @TestMetadata("simplePropWithHierarchy.kt")
                public void testSimplePropWithHierarchy() throws Exception {
                    runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvm8/jvm8against6/simplePropWithHierarchy.kt");
                }

                @Nested
                @TestMetadata("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvm8/jvm8against6/delegation")
                @TestDataPath("$PROJECT_ROOT")
                public class Delegation {
                    @Test
                    public void testAllFilesPresentInDelegation() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvm8/jvm8against6/delegation"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
                    }

                    @Test
                    @TestMetadata("diamond.kt")
                    public void testDiamond() throws Exception {
                        runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvm8/jvm8against6/delegation/diamond.kt");
                    }

                    @Test
                    @TestMetadata("diamond2.kt")
                    public void testDiamond2() throws Exception {
                        runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvm8/jvm8against6/delegation/diamond2.kt");
                    }

                    @Test
                    @TestMetadata("diamond3.kt")
                    public void testDiamond3() throws Exception {
                        runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/jvm8/jvm8against6/delegation/diamond3.kt");
                    }
                }
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/box/compileKotlinAgainstKotlin/typeAnnotations")
        @TestDataPath("$PROJECT_ROOT")
        public class TypeAnnotations {
            @Test
            public void testAllFilesPresentInTypeAnnotations() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/compileKotlinAgainstKotlin/typeAnnotations"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("implicitReturn.kt")
            public void testImplicitReturn() throws Exception {
                runTest("compiler/testData/codegen/box/compileKotlinAgainstKotlin/typeAnnotations/implicitReturn.kt");
            }
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/constants")
    @TestDataPath("$PROJECT_ROOT")
    public class Constants {
        @Test
        public void testAllFilesPresentInConstants() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/constants"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("comparisonFalse.kt")
        public void testComparisonFalse() throws Exception {
            runTest("compiler/testData/codegen/box/constants/comparisonFalse.kt");
        }

        @Test
        @TestMetadata("comparisonTrue.kt")
        public void testComparisonTrue() throws Exception {
            runTest("compiler/testData/codegen/box/constants/comparisonTrue.kt");
        }

        @Test
        @TestMetadata("constValFromAnotherModuleInConsVal.kt")
        public void testConstValFromAnotherModuleInConsVal() throws Exception {
            runTest("compiler/testData/codegen/box/constants/constValFromAnotherModuleInConsVal.kt");
        }

        @Test
        @TestMetadata("constantsInWhen.kt")
        public void testConstantsInWhen() throws Exception {
            runTest("compiler/testData/codegen/box/constants/constantsInWhen.kt");
        }

        @Test
        @TestMetadata("divisionByZero.kt")
        public void testDivisionByZero() throws Exception {
            runTest("compiler/testData/codegen/box/constants/divisionByZero.kt");
        }

        @Test
        @TestMetadata("float.kt")
        public void testFloat() throws Exception {
            runTest("compiler/testData/codegen/box/constants/float.kt");
        }

        @Test
        @TestMetadata("foldingBinaryOpsUnsigned.kt")
        public void testFoldingBinaryOpsUnsigned() throws Exception {
            runTest("compiler/testData/codegen/box/constants/foldingBinaryOpsUnsigned.kt");
        }

        @Test
        @TestMetadata("foldingBinaryOpsUnsignedConst.kt")
        public void testFoldingBinaryOpsUnsignedConst() throws Exception {
            runTest("compiler/testData/codegen/box/constants/foldingBinaryOpsUnsignedConst.kt");
        }

        @Test
        @TestMetadata("kt9532.kt")
        public void testKt9532() throws Exception {
            runTest("compiler/testData/codegen/box/constants/kt9532.kt");
        }

        @Test
        @TestMetadata("long.kt")
        public void testLong() throws Exception {
            runTest("compiler/testData/codegen/box/constants/long.kt");
        }

        @Test
        @TestMetadata("numberLiteralCoercionToInferredType.kt")
        public void testNumberLiteralCoercionToInferredType() throws Exception {
            runTest("compiler/testData/codegen/box/constants/numberLiteralCoercionToInferredType.kt");
        }

        @Test
        @TestMetadata("privateConst.kt")
        public void testPrivateConst() throws Exception {
            runTest("compiler/testData/codegen/box/constants/privateConst.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/constructor")
    @TestDataPath("$PROJECT_ROOT")
    public class Constructor {
        @Test
        public void testAllFilesPresentInConstructor() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/constructor"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("genericConstructor.kt")
        public void testGenericConstructor() throws Exception {
            runTest("compiler/testData/codegen/box/constructor/genericConstructor.kt");
        }

        @Test
        @TestMetadata("secondaryConstructor.kt")
        public void testSecondaryConstructor() throws Exception {
            runTest("compiler/testData/codegen/box/constructor/secondaryConstructor.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/constructorCall")
    @TestDataPath("$PROJECT_ROOT")
    public class ConstructorCall {
        @Test
        public void testAllFilesPresentInConstructorCall() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/constructorCall"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("breakInConstructorArguments.kt")
        public void testBreakInConstructorArguments() throws Exception {
            runTest("compiler/testData/codegen/box/constructorCall/breakInConstructorArguments.kt");
        }

        @Test
        @TestMetadata("continueInConstructorArguments.kt")
        public void testContinueInConstructorArguments() throws Exception {
            runTest("compiler/testData/codegen/box/constructorCall/continueInConstructorArguments.kt");
        }

        @Test
        @TestMetadata("earlyReturnInConstructorArguments.kt")
        public void testEarlyReturnInConstructorArguments() throws Exception {
            runTest("compiler/testData/codegen/box/constructorCall/earlyReturnInConstructorArguments.kt");
        }

        @Test
        @TestMetadata("inlineFunInConstructorCall.kt")
        public void testInlineFunInConstructorCall() throws Exception {
            runTest("compiler/testData/codegen/box/constructorCall/inlineFunInConstructorCall.kt");
        }

        @Test
        @TestMetadata("inlineFunInConstructorCallEvaluationOrder.kt")
        public void testInlineFunInConstructorCallEvaluationOrder() throws Exception {
            runTest("compiler/testData/codegen/box/constructorCall/inlineFunInConstructorCallEvaluationOrder.kt");
        }

        @Test
        @TestMetadata("inlineFunInInnerClassConstructorCall.kt")
        public void testInlineFunInInnerClassConstructorCall() throws Exception {
            runTest("compiler/testData/codegen/box/constructorCall/inlineFunInInnerClassConstructorCall.kt");
        }

        @Test
        @TestMetadata("inlineFunInLocalClassConstructorCall.kt")
        public void testInlineFunInLocalClassConstructorCall() throws Exception {
            runTest("compiler/testData/codegen/box/constructorCall/inlineFunInLocalClassConstructorCall.kt");
        }

        @Test
        @TestMetadata("kt49615.kt")
        public void testKt49615() throws Exception {
            runTest("compiler/testData/codegen/box/constructorCall/kt49615.kt");
        }

        @Test
        @TestMetadata("kt49615a.kt")
        public void testKt49615a() throws Exception {
            runTest("compiler/testData/codegen/box/constructorCall/kt49615a.kt");
        }

        @Test
        @TestMetadata("loopInInlineFun.kt")
        public void testLoopInInlineFun() throws Exception {
            runTest("compiler/testData/codegen/box/constructorCall/loopInInlineFun.kt");
        }

        @Test
        @TestMetadata("loopInInlineFunInSuperConstructorCall.kt")
        public void testLoopInInlineFunInSuperConstructorCall() throws Exception {
            runTest("compiler/testData/codegen/box/constructorCall/loopInInlineFunInSuperConstructorCall.kt");
        }

        @Test
        @TestMetadata("nestedConstructorCallWithJumpOutInConstructorArguments.kt")
        public void testNestedConstructorCallWithJumpOutInConstructorArguments() throws Exception {
            runTest("compiler/testData/codegen/box/constructorCall/nestedConstructorCallWithJumpOutInConstructorArguments.kt");
        }

        @Test
        @TestMetadata("nonLocalReturnInConstructorArguments.kt")
        public void testNonLocalReturnInConstructorArguments() throws Exception {
            runTest("compiler/testData/codegen/box/constructorCall/nonLocalReturnInConstructorArguments.kt");
        }

        @Test
        @TestMetadata("possiblyPoppedUnitializedValueInArguments.kt")
        public void testPossiblyPoppedUnitializedValueInArguments() throws Exception {
            runTest("compiler/testData/codegen/box/constructorCall/possiblyPoppedUnitializedValueInArguments.kt");
        }

        @Test
        @TestMetadata("regularConstructorCallEvaluationOrder.kt")
        public void testRegularConstructorCallEvaluationOrder() throws Exception {
            runTest("compiler/testData/codegen/box/constructorCall/regularConstructorCallEvaluationOrder.kt");
        }

        @Test
        @TestMetadata("tryCatchInConstructorCallEvaluationOrder.kt")
        public void testTryCatchInConstructorCallEvaluationOrder() throws Exception {
            runTest("compiler/testData/codegen/box/constructorCall/tryCatchInConstructorCallEvaluationOrder.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/contracts")
    @TestDataPath("$PROJECT_ROOT")
    public class Contracts {
        @Test
        public void testAllFilesPresentInContracts() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/contracts"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("constructorArgument.kt")
        public void testConstructorArgument() throws Exception {
            runTest("compiler/testData/codegen/box/contracts/constructorArgument.kt");
        }

        @Test
        @TestMetadata("destructuredVariable.kt")
        public void testDestructuredVariable() throws Exception {
            runTest("compiler/testData/codegen/box/contracts/destructuredVariable.kt");
        }

        @Test
        @TestMetadata("exactlyOnceNotInline.kt")
        public void testExactlyOnceNotInline() throws Exception {
            runTest("compiler/testData/codegen/box/contracts/exactlyOnceNotInline.kt");
        }

        @Test
        @TestMetadata("exception.kt")
        public void testException() throws Exception {
            runTest("compiler/testData/codegen/box/contracts/exception.kt");
        }

        @Test
        @TestMetadata("fieldInConstructorParens.kt")
        public void testFieldInConstructorParens() throws Exception {
            runTest("compiler/testData/codegen/box/contracts/fieldInConstructorParens.kt");
        }

        @Test
        @TestMetadata("fieldReadInConstructor.kt")
        public void testFieldReadInConstructor() throws Exception {
            runTest("compiler/testData/codegen/box/contracts/fieldReadInConstructor.kt");
        }

        @Test
        @TestMetadata("forLoop.kt")
        public void testForLoop() throws Exception {
            runTest("compiler/testData/codegen/box/contracts/forLoop.kt");
        }

        @Test
        @TestMetadata("functionParameter.kt")
        public void testFunctionParameter() throws Exception {
            runTest("compiler/testData/codegen/box/contracts/functionParameter.kt");
        }

        @Test
        @TestMetadata("kt39374.kt")
        public void testKt39374() throws Exception {
            runTest("compiler/testData/codegen/box/contracts/kt39374.kt");
        }

        @Test
        @TestMetadata("kt45236.kt")
        public void testKt45236() throws Exception {
            runTest("compiler/testData/codegen/box/contracts/kt45236.kt");
        }

        @Test
        @TestMetadata("kt47168.kt")
        public void testKt47168() throws Exception {
            runTest("compiler/testData/codegen/box/contracts/kt47168.kt");
        }

        @Test
        @TestMetadata("kt47300.kt")
        public void testKt47300() throws Exception {
            runTest("compiler/testData/codegen/box/contracts/kt47300.kt");
        }

        @Test
        @TestMetadata("lambdaParameter.kt")
        public void testLambdaParameter() throws Exception {
            runTest("compiler/testData/codegen/box/contracts/lambdaParameter.kt");
        }

        @Test
        @TestMetadata("listAppend.kt")
        public void testListAppend() throws Exception {
            runTest("compiler/testData/codegen/box/contracts/listAppend.kt");
        }

        @Test
        @TestMetadata("nestedLambdaInNonInlineCallExactlyOnce.kt")
        public void testNestedLambdaInNonInlineCallExactlyOnce() throws Exception {
            runTest("compiler/testData/codegen/box/contracts/nestedLambdaInNonInlineCallExactlyOnce.kt");
        }

        @Test
        @TestMetadata("valInWhen.kt")
        public void testValInWhen() throws Exception {
            runTest("compiler/testData/codegen/box/contracts/valInWhen.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/controlStructures")
    @TestDataPath("$PROJECT_ROOT")
    public class ControlStructures {
        @Test
        public void testAllFilesPresentInControlStructures() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/controlStructures"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("bottles.kt")
        public void testBottles() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/bottles.kt");
        }

        @Test
        @TestMetadata("breakInFinally.kt")
        public void testBreakInFinally() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/breakInFinally.kt");
        }

        @Test
        @TestMetadata("breakInWhen.kt")
        public void testBreakInWhen() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/breakInWhen.kt");
        }

        @Test
        @TestMetadata("compareBoxedIntegerToZero.kt")
        public void testCompareBoxedIntegerToZero() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/compareBoxedIntegerToZero.kt");
        }

        @Test
        @TestMetadata("conditionOfEmptyIf.kt")
        public void testConditionOfEmptyIf() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/conditionOfEmptyIf.kt");
        }

        @Test
        @TestMetadata("continueInExpr.kt")
        public void testContinueInExpr() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/continueInExpr.kt");
        }

        @Test
        @TestMetadata("continueInFor.kt")
        public void testContinueInFor() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/continueInFor.kt");
        }

        @Test
        @TestMetadata("continueInForCondition.kt")
        public void testContinueInForCondition() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/continueInForCondition.kt");
        }

        @Test
        @TestMetadata("continueInWhen.kt")
        public void testContinueInWhen() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/continueInWhen.kt");
        }

        @Test
        @TestMetadata("continueInWhile.kt")
        public void testContinueInWhile() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/continueInWhile.kt");
        }

        @Test
        @TestMetadata("continueToLabelInFor.kt")
        public void testContinueToLabelInFor() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/continueToLabelInFor.kt");
        }

        @Test
        @TestMetadata("doWhile.kt")
        public void testDoWhile() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/doWhile.kt");
        }

        @Test
        @TestMetadata("doWhileFib.kt")
        public void testDoWhileFib() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/doWhileFib.kt");
        }

        @Test
        @TestMetadata("doWhileWithContinue.kt")
        public void testDoWhileWithContinue() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/doWhileWithContinue.kt");
        }

        @Test
        @TestMetadata("emptyDoWhile.kt")
        public void testEmptyDoWhile() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/emptyDoWhile.kt");
        }

        @Test
        @TestMetadata("emptyFor.kt")
        public void testEmptyFor() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/emptyFor.kt");
        }

        @Test
        @TestMetadata("emptyWhile.kt")
        public void testEmptyWhile() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/emptyWhile.kt");
        }

        @Test
        @TestMetadata("factorialTest.kt")
        public void testFactorialTest() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/factorialTest.kt");
        }

        @Test
        @TestMetadata("finallyOnEmptyReturn.kt")
        public void testFinallyOnEmptyReturn() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/finallyOnEmptyReturn.kt");
        }

        @Test
        @TestMetadata("forArrayList.kt")
        public void testForArrayList() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/forArrayList.kt");
        }

        @Test
        @TestMetadata("forArrayListMultiDecl.kt")
        public void testForArrayListMultiDecl() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/forArrayListMultiDecl.kt");
        }

        @Test
        @TestMetadata("forInCharSequence.kt")
        public void testForInCharSequence() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/forInCharSequence.kt");
        }

        @Test
        @TestMetadata("forInCharSequenceMut.kt")
        public void testForInCharSequenceMut() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/forInCharSequenceMut.kt");
        }

        @Test
        @TestMetadata("forInSmartCastToArray.kt")
        public void testForInSmartCastToArray() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/forInSmartCastToArray.kt");
        }

        @Test
        @TestMetadata("forLoopMemberExtensionAll.kt")
        public void testForLoopMemberExtensionAll() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/forLoopMemberExtensionAll.kt");
        }

        @Test
        @TestMetadata("forLoopMemberExtensionHasNext.kt")
        public void testForLoopMemberExtensionHasNext() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/forLoopMemberExtensionHasNext.kt");
        }

        @Test
        @TestMetadata("forLoopMemberExtensionNext.kt")
        public void testForLoopMemberExtensionNext() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/forLoopMemberExtensionNext.kt");
        }

        @Test
        @TestMetadata("forNullableCharInString.kt")
        public void testForNullableCharInString() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/forNullableCharInString.kt");
        }

        @Test
        @TestMetadata("forUserType.kt")
        public void testForUserType() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/forUserType.kt");
        }

        @Test
        @TestMetadata("ifConst1.kt")
        public void testIfConst1() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/ifConst1.kt");
        }

        @Test
        @TestMetadata("ifConst2.kt")
        public void testIfConst2() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/ifConst2.kt");
        }

        @Test
        @TestMetadata("ifIncompatibleBranches.kt")
        public void testIfIncompatibleBranches() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/ifIncompatibleBranches.kt");
        }

        @Test
        @TestMetadata("inRangeConditionsInWhen.kt")
        public void testInRangeConditionsInWhen() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/inRangeConditionsInWhen.kt");
        }

        @Test
        @TestMetadata("kt12908.kt")
        public void testKt12908() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt12908.kt");
        }

        @Test
        @TestMetadata("kt12908_2.kt")
        public void testKt12908_2() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt12908_2.kt");
        }

        @Test
        @TestMetadata("kt1441.kt")
        public void testKt1441() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt1441.kt");
        }

        @Test
        @TestMetadata("kt14839.kt")
        public void testKt14839() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt14839.kt");
        }

        @Test
        @TestMetadata("kt15726.kt")
        public void testKt15726() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt15726.kt");
        }

        @Test
        @TestMetadata("kt1688.kt")
        public void testKt1688() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt1688.kt");
        }

        @Test
        @TestMetadata("kt17110.kt")
        public void testKt17110() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt17110.kt");
        }

        @Test
        @TestMetadata("kt1742.kt")
        public void testKt1742() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt1742.kt");
        }

        @Test
        @TestMetadata("kt17590.kt")
        public void testKt17590() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt17590.kt");
        }

        @Test
        @TestMetadata("kt17590_long.kt")
        public void testKt17590_long() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt17590_long.kt");
        }

        @Test
        @TestMetadata("kt1899.kt")
        public void testKt1899() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt1899.kt");
        }

        @Test
        @TestMetadata("kt2147.kt")
        public void testKt2147() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt2147.kt");
        }

        @Test
        @TestMetadata("kt2259.kt")
        public void testKt2259() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt2259.kt");
        }

        @Test
        @TestMetadata("kt2291.kt")
        public void testKt2291() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt2291.kt");
        }

        @Test
        @TestMetadata("kt237.kt")
        public void testKt237() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt237.kt");
        }

        @Test
        @TestMetadata("kt2416.kt")
        public void testKt2416() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt2416.kt");
        }

        @Test
        @TestMetadata("kt2423.kt")
        public void testKt2423() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt2423.kt");
        }

        @Test
        @TestMetadata("kt2577.kt")
        public void testKt2577() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt2577.kt");
        }

        @Test
        @TestMetadata("kt2597.kt")
        public void testKt2597() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt2597.kt");
        }

        @Test
        @TestMetadata("kt299.kt")
        public void testKt299() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt299.kt");
        }

        @Test
        @TestMetadata("kt3087.kt")
        public void testKt3087() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt3087.kt");
        }

        @Test
        @TestMetadata("kt3203_1.kt")
        public void testKt3203_1() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt3203_1.kt");
        }

        @Test
        @TestMetadata("kt3203_2.kt")
        public void testKt3203_2() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt3203_2.kt");
        }

        @Test
        @TestMetadata("kt3273.kt")
        public void testKt3273() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt3273.kt");
        }

        @Test
        @TestMetadata("kt3280.kt")
        public void testKt3280() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt3280.kt");
        }

        @Test
        @TestMetadata("kt3574.kt")
        public void testKt3574() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt3574.kt");
        }

        @Test
        @TestMetadata("kt416.kt")
        public void testKt416() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt416.kt");
        }

        @Test
        @TestMetadata("kt42455.kt")
        public void testKt42455() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt42455.kt");
        }

        @Test
        @TestMetadata("kt47245.kt")
        public void testKt47245() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt47245.kt");
        }

        @Test
        @TestMetadata("kt513.kt")
        public void testKt513() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt513.kt");
        }

        @Test
        @TestMetadata("kt628.kt")
        public void testKt628() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt628.kt");
        }

        @Test
        @TestMetadata("kt769.kt")
        public void testKt769() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt769.kt");
        }

        @Test
        @TestMetadata("kt772.kt")
        public void testKt772() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt772.kt");
        }

        @Test
        @TestMetadata("kt773.kt")
        public void testKt773() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt773.kt");
        }

        @Test
        @TestMetadata("kt8148.kt")
        public void testKt8148() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt8148.kt");
        }

        @Test
        @TestMetadata("kt8148_break.kt")
        public void testKt8148_break() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt8148_break.kt");
        }

        @Test
        @TestMetadata("kt8148_continue.kt")
        public void testKt8148_continue() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt8148_continue.kt");
        }

        @Test
        @TestMetadata("kt870.kt")
        public void testKt870() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt870.kt");
        }

        @Test
        @TestMetadata("kt9022Return.kt")
        public void testKt9022Return() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt9022Return.kt");
        }

        @Test
        @TestMetadata("kt9022Throw.kt")
        public void testKt9022Throw() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt9022Throw.kt");
        }

        @Test
        @TestMetadata("kt910.kt")
        public void testKt910() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt910.kt");
        }

        @Test
        @TestMetadata("kt958.kt")
        public void testKt958() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/kt958.kt");
        }

        @Test
        @TestMetadata("longRange.kt")
        public void testLongRange() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/longRange.kt");
        }

        @Test
        @TestMetadata("parameterWithNameForFunctionType.kt")
        public void testParameterWithNameForFunctionType() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/parameterWithNameForFunctionType.kt");
        }

        @Test
        @TestMetadata("quicksort.kt")
        public void testQuicksort() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/quicksort.kt");
        }

        @Test
        @TestMetadata("tcbInEliminatedCondition.kt")
        public void testTcbInEliminatedCondition() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/tcbInEliminatedCondition.kt");
        }

        @Test
        @TestMetadata("tryCatchExpression.kt")
        public void testTryCatchExpression() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/tryCatchExpression.kt");
        }

        @Test
        @TestMetadata("tryCatchFinally.kt")
        public void testTryCatchFinally() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/tryCatchFinally.kt");
        }

        @Test
        @TestMetadata("tryCatchFinallyChain.kt")
        public void testTryCatchFinallyChain() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/tryCatchFinallyChain.kt");
        }

        @Test
        @TestMetadata("tryFinally.kt")
        public void testTryFinally() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/tryFinally.kt");
        }

        @Test
        @TestMetadata("tryFinallyGeneric.kt")
        public void testTryFinallyGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/controlStructures/tryFinallyGeneric.kt");
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions")
        @TestDataPath("$PROJECT_ROOT")
        public class BreakContinueInExpressions {
            @Test
            public void testAllFilesPresentInBreakContinueInExpressions() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("breakFromOuter.kt")
            public void testBreakFromOuter() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/breakFromOuter.kt");
            }

            @Test
            @TestMetadata("breakInDoWhile.kt")
            public void testBreakInDoWhile() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/breakInDoWhile.kt");
            }

            @Test
            @TestMetadata("breakInExpr.kt")
            public void testBreakInExpr() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/breakInExpr.kt");
            }

            @Test
            @TestMetadata("breakInLoopConditions.kt")
            public void testBreakInLoopConditions() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/breakInLoopConditions.kt");
            }

            @Test
            @TestMetadata("continueInDoWhile.kt")
            public void testContinueInDoWhile() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/continueInDoWhile.kt");
            }

            @Test
            @TestMetadata("continueInExpr.kt")
            public void testContinueInExpr() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/continueInExpr.kt");
            }

            @Test
            @TestMetadata("inlineWithStack.kt")
            public void testInlineWithStack() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/inlineWithStack.kt");
            }

            @Test
            @TestMetadata("innerLoopWithStack.kt")
            public void testInnerLoopWithStack() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/innerLoopWithStack.kt");
            }

            @Test
            @TestMetadata("kt14581.kt")
            public void testKt14581() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/kt14581.kt");
            }

            @Test
            @TestMetadata("kt16713.kt")
            public void testKt16713() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/kt16713.kt");
            }

            @Test
            @TestMetadata("kt16713_2.kt")
            public void testKt16713_2() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/kt16713_2.kt");
            }

            @Test
            @TestMetadata("kt17384.kt")
            public void testKt17384() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/kt17384.kt");
            }

            @Test
            @TestMetadata("kt45704_elvisInInlineFun.kt")
            public void testKt45704_elvisInInlineFun() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/kt45704_elvisInInlineFun.kt");
            }

            @Test
            @TestMetadata("kt9022And.kt")
            public void testKt9022And() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/kt9022And.kt");
            }

            @Test
            @TestMetadata("kt9022Or.kt")
            public void testKt9022Or() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/kt9022Or.kt");
            }

            @Test
            @TestMetadata("pathologicalDoWhile.kt")
            public void testPathologicalDoWhile() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/pathologicalDoWhile.kt");
            }

            @Test
            @TestMetadata("popSizes.kt")
            public void testPopSizes() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/popSizes.kt");
            }

            @Test
            @TestMetadata("tryFinally1.kt")
            public void testTryFinally1() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/tryFinally1.kt");
            }

            @Test
            @TestMetadata("tryFinally2.kt")
            public void testTryFinally2() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/tryFinally2.kt");
            }

            @Test
            @TestMetadata("whileTrueBreak.kt")
            public void testWhileTrueBreak() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/breakContinueInExpressions/whileTrueBreak.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/box/controlStructures/forInArray")
        @TestDataPath("$PROJECT_ROOT")
        public class ForInArray {
            @Test
            public void testAllFilesPresentInForInArray() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/controlStructures/forInArray"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("forInArraySpecializedToUntil.kt")
            public void testForInArraySpecializedToUntil() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArray/forInArraySpecializedToUntil.kt");
            }

            @Test
            @TestMetadata("forInArrayWithArrayPropertyUpdatedInLoopBody.kt")
            public void testForInArrayWithArrayPropertyUpdatedInLoopBody() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArray/forInArrayWithArrayPropertyUpdatedInLoopBody.kt");
            }

            @Test
            @TestMetadata("forInArrayWithArrayVarUpdatedInLoopBody13.kt")
            public void testForInArrayWithArrayVarUpdatedInLoopBody13() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArray/forInArrayWithArrayVarUpdatedInLoopBody13.kt");
            }

            @Test
            @TestMetadata("forInDelegatedPropertyUpdatedInLoopBody.kt")
            public void testForInDelegatedPropertyUpdatedInLoopBody() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArray/forInDelegatedPropertyUpdatedInLoopBody.kt");
            }

            @Test
            @TestMetadata("forInDoubleArrayWithUpcast.kt")
            public void testForInDoubleArrayWithUpcast() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArray/forInDoubleArrayWithUpcast.kt");
            }

            @Test
            @TestMetadata("forInFieldUpdatedInLoopBody.kt")
            public void testForInFieldUpdatedInLoopBody() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArray/forInFieldUpdatedInLoopBody.kt");
            }

            @Test
            @TestMetadata("forInInlineClassArrayWithUpcast.kt")
            public void testForInInlineClassArrayWithUpcast() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArray/forInInlineClassArrayWithUpcast.kt");
            }

            @Test
            @TestMetadata("forIntArray.kt")
            public void testForIntArray() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArray/forIntArray.kt");
            }

            @Test
            @TestMetadata("forNullableIntArray.kt")
            public void testForNullableIntArray() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArray/forNullableIntArray.kt");
            }

            @Test
            @TestMetadata("forPrimitiveIntArray.kt")
            public void testForPrimitiveIntArray() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArray/forPrimitiveIntArray.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex")
        @TestDataPath("$PROJECT_ROOT")
        public class ForInArrayWithIndex {
            @Test
            public void testAllFilesPresentInForInArrayWithIndex() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("forInArrayOfObjectArrayWithIndex.kt")
            public void testForInArrayOfObjectArrayWithIndex() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex/forInArrayOfObjectArrayWithIndex.kt");
            }

            @Test
            @TestMetadata("forInArrayOfPrimArrayWithIndex.kt")
            public void testForInArrayOfPrimArrayWithIndex() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex/forInArrayOfPrimArrayWithIndex.kt");
            }

            @Test
            @TestMetadata("forInArrayWithIndexBreakAndContinue.kt")
            public void testForInArrayWithIndexBreakAndContinue() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex/forInArrayWithIndexBreakAndContinue.kt");
            }

            @Test
            @TestMetadata("forInArrayWithIndexContinuesAsUnmodified.kt")
            public void testForInArrayWithIndexContinuesAsUnmodified() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex/forInArrayWithIndexContinuesAsUnmodified.kt");
            }

            @Test
            @TestMetadata("forInArrayWithIndexNoElementVar.kt")
            public void testForInArrayWithIndexNoElementVar() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex/forInArrayWithIndexNoElementVar.kt");
            }

            @Test
            @TestMetadata("forInArrayWithIndexNoIndexOrElementVar.kt")
            public void testForInArrayWithIndexNoIndexOrElementVar() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex/forInArrayWithIndexNoIndexOrElementVar.kt");
            }

            @Test
            @TestMetadata("forInArrayWithIndexNoIndexVar.kt")
            public void testForInArrayWithIndexNoIndexVar() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex/forInArrayWithIndexNoIndexVar.kt");
            }

            @Test
            @TestMetadata("forInArrayWithIndexNotDestructured.kt")
            public void testForInArrayWithIndexNotDestructured() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex/forInArrayWithIndexNotDestructured.kt");
            }

            @Test
            @TestMetadata("forInArrayWithIndexWithExplicitlyTypedIndexVariable.kt")
            public void testForInArrayWithIndexWithExplicitlyTypedIndexVariable() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex/forInArrayWithIndexWithExplicitlyTypedIndexVariable.kt");
            }

            @Test
            @TestMetadata("forInByteArrayWithIndex.kt")
            public void testForInByteArrayWithIndex() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex/forInByteArrayWithIndex.kt");
            }

            @Test
            @TestMetadata("forInByteArrayWithIndexWithSmartCast.kt")
            public void testForInByteArrayWithIndexWithSmartCast() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex/forInByteArrayWithIndexWithSmartCast.kt");
            }

            @Test
            @TestMetadata("forInEmptyArrayWithIndex.kt")
            public void testForInEmptyArrayWithIndex() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex/forInEmptyArrayWithIndex.kt");
            }

            @Test
            @TestMetadata("forInGenericArrayOfIntsWithIndex.kt")
            public void testForInGenericArrayOfIntsWithIndex() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex/forInGenericArrayOfIntsWithIndex.kt");
            }

            @Test
            @TestMetadata("forInGenericArrayOfIntsWithIndexWithSmartCast.kt")
            public void testForInGenericArrayOfIntsWithIndexWithSmartCast() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex/forInGenericArrayOfIntsWithIndexWithSmartCast.kt");
            }

            @Test
            @TestMetadata("forInGenericArrayWithIndex.kt")
            public void testForInGenericArrayWithIndex() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex/forInGenericArrayWithIndex.kt");
            }

            @Test
            @TestMetadata("forInIntArrayWithIndex.kt")
            public void testForInIntArrayWithIndex() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex/forInIntArrayWithIndex.kt");
            }

            @Test
            @TestMetadata("forInIntArrayWithIndexWithSmartCast.kt")
            public void testForInIntArrayWithIndexWithSmartCast() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex/forInIntArrayWithIndexWithSmartCast.kt");
            }

            @Test
            @TestMetadata("forInObjectArrayWithIndex.kt")
            public void testForInObjectArrayWithIndex() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex/forInObjectArrayWithIndex.kt");
            }

            @Test
            @TestMetadata("forInShortArrayWithIndex.kt")
            public void testForInShortArrayWithIndex() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex/forInShortArrayWithIndex.kt");
            }

            @Test
            @TestMetadata("forInShortArrayWithIndexWithSmartCast.kt")
            public void testForInShortArrayWithIndexWithSmartCast() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInArrayWithIndex/forInShortArrayWithIndexWithSmartCast.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/box/controlStructures/forInCharSequenceWithIndex")
        @TestDataPath("$PROJECT_ROOT")
        public class ForInCharSequenceWithIndex {
            @Test
            public void testAllFilesPresentInForInCharSequenceWithIndex() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/controlStructures/forInCharSequenceWithIndex"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("forInCharSeqWithIndexStops.kt")
            public void testForInCharSeqWithIndexStops() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInCharSequenceWithIndex/forInCharSeqWithIndexStops.kt");
            }

            @Test
            @TestMetadata("forInCharSequenceTypeParameterWithIndex.kt")
            public void testForInCharSequenceTypeParameterWithIndex() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInCharSequenceWithIndex/forInCharSequenceTypeParameterWithIndex.kt");
            }

            @Test
            @TestMetadata("forInCharSequenceWithIndex.kt")
            public void testForInCharSequenceWithIndex() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInCharSequenceWithIndex/forInCharSequenceWithIndex.kt");
            }

            @Test
            @TestMetadata("forInCharSequenceWithIndexBreakAndContinue.kt")
            public void testForInCharSequenceWithIndexBreakAndContinue() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInCharSequenceWithIndex/forInCharSequenceWithIndexBreakAndContinue.kt");
            }

            @Test
            @TestMetadata("forInCharSequenceWithIndexCheckSideEffects.kt")
            public void testForInCharSequenceWithIndexCheckSideEffects() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInCharSequenceWithIndex/forInCharSequenceWithIndexCheckSideEffects.kt");
            }

            @Test
            @TestMetadata("forInCharSequenceWithIndexNoElementVarCheckSideEffects.kt")
            public void testForInCharSequenceWithIndexNoElementVarCheckSideEffects() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInCharSequenceWithIndex/forInCharSequenceWithIndexNoElementVarCheckSideEffects.kt");
            }

            @Test
            @TestMetadata("forInCharSequenceWithIndexNoIndexVarCheckSideEffects.kt")
            public void testForInCharSequenceWithIndexNoIndexVarCheckSideEffects() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInCharSequenceWithIndex/forInCharSequenceWithIndexNoIndexVarCheckSideEffects.kt");
            }

            @Test
            @TestMetadata("forInEmptyStringWithIndex.kt")
            public void testForInEmptyStringWithIndex() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInCharSequenceWithIndex/forInEmptyStringWithIndex.kt");
            }

            @Test
            @TestMetadata("forInStringWithIndex.kt")
            public void testForInStringWithIndex() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInCharSequenceWithIndex/forInStringWithIndex.kt");
            }

            @Test
            @TestMetadata("forInStringWithIndexNoElementVar.kt")
            public void testForInStringWithIndexNoElementVar() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInCharSequenceWithIndex/forInStringWithIndexNoElementVar.kt");
            }

            @Test
            @TestMetadata("forInStringWithIndexNoIndexOrElementVar.kt")
            public void testForInStringWithIndexNoIndexOrElementVar() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInCharSequenceWithIndex/forInStringWithIndexNoIndexOrElementVar.kt");
            }

            @Test
            @TestMetadata("forInStringWithIndexNoIndexVar.kt")
            public void testForInStringWithIndexNoIndexVar() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInCharSequenceWithIndex/forInStringWithIndexNoIndexVar.kt");
            }

            @Test
            @TestMetadata("forInStringWithIndexNotDestructured.kt")
            public void testForInStringWithIndexNotDestructured() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInCharSequenceWithIndex/forInStringWithIndexNotDestructured.kt");
            }

            @Test
            @TestMetadata("forInStringWithIndexWithExplicitlyTypedIndexVariable.kt")
            public void testForInStringWithIndexWithExplicitlyTypedIndexVariable() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInCharSequenceWithIndex/forInStringWithIndexWithExplicitlyTypedIndexVariable.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/box/controlStructures/forInIterableWithIndex")
        @TestDataPath("$PROJECT_ROOT")
        public class ForInIterableWithIndex {
            @Test
            public void testAllFilesPresentInForInIterableWithIndex() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/controlStructures/forInIterableWithIndex"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("forInEmptyListWithIndex.kt")
            public void testForInEmptyListWithIndex() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInIterableWithIndex/forInEmptyListWithIndex.kt");
            }

            @Test
            @TestMetadata("forInIterableTypeParameterWithIndex.kt")
            public void testForInIterableTypeParameterWithIndex() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInIterableWithIndex/forInIterableTypeParameterWithIndex.kt");
            }

            @Test
            @TestMetadata("forInIterableWithIndexCheckSideEffects.kt")
            public void testForInIterableWithIndexCheckSideEffects() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInIterableWithIndex/forInIterableWithIndexCheckSideEffects.kt");
            }

            @Test
            @TestMetadata("forInIterableWithIndexNoElementVarCheckSideEffects.kt")
            public void testForInIterableWithIndexNoElementVarCheckSideEffects() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInIterableWithIndex/forInIterableWithIndexNoElementVarCheckSideEffects.kt");
            }

            @Test
            @TestMetadata("forInIterableWithIndexNoIndexVarCheckSideEffects.kt")
            public void testForInIterableWithIndexNoIndexVarCheckSideEffects() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInIterableWithIndex/forInIterableWithIndexNoIndexVarCheckSideEffects.kt");
            }

            @Test
            @TestMetadata("forInListWithIndex.kt")
            public void testForInListWithIndex() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInIterableWithIndex/forInListWithIndex.kt");
            }

            @Test
            @TestMetadata("forInListWithIndexBreak.kt")
            public void testForInListWithIndexBreak() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInIterableWithIndex/forInListWithIndexBreak.kt");
            }

            @Test
            @TestMetadata("forInListWithIndexBreakAndContinue.kt")
            public void testForInListWithIndexBreakAndContinue() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInIterableWithIndex/forInListWithIndexBreakAndContinue.kt");
            }

            @Test
            @TestMetadata("forInListWithIndexContinue.kt")
            public void testForInListWithIndexContinue() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInIterableWithIndex/forInListWithIndexContinue.kt");
            }

            @Test
            @TestMetadata("forInListWithIndexNoElementVar.kt")
            public void testForInListWithIndexNoElementVar() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInIterableWithIndex/forInListWithIndexNoElementVar.kt");
            }

            @Test
            @TestMetadata("forInListWithIndexNoIndexVar.kt")
            public void testForInListWithIndexNoIndexVar() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInIterableWithIndex/forInListWithIndexNoIndexVar.kt");
            }

            @Test
            @TestMetadata("forInListWithIndexThrowsCME.kt")
            public void testForInListWithIndexThrowsCME() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInIterableWithIndex/forInListWithIndexThrowsCME.kt");
            }

            @Test
            @TestMetadata("forInListWithIndexWithExplicitlyTypedIndexVariable.kt")
            public void testForInListWithIndexWithExplicitlyTypedIndexVariable() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInIterableWithIndex/forInListWithIndexWithExplicitlyTypedIndexVariable.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/box/controlStructures/forInIterator")
        @TestDataPath("$PROJECT_ROOT")
        public class ForInIterator {
            @Test
            @TestMetadata("abstractNext.kt")
            public void testAbstractNext() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInIterator/abstractNext.kt");
            }

            @Test
            public void testAllFilesPresentInForInIterator() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/controlStructures/forInIterator"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("primitiveIterator.kt")
            public void testPrimitiveIterator() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInIterator/primitiveIterator.kt");
            }

            @Test
            @TestMetadata("uintIterator.kt")
            public void testUintIterator() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInIterator/uintIterator.kt");
            }

            @Test
            @TestMetadata("unrelatedExtensionFunctionNext.kt")
            public void testUnrelatedExtensionFunctionNext() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInIterator/unrelatedExtensionFunctionNext.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/box/controlStructures/forInSequenceWithIndex")
        @TestDataPath("$PROJECT_ROOT")
        public class ForInSequenceWithIndex {
            @Test
            public void testAllFilesPresentInForInSequenceWithIndex() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/controlStructures/forInSequenceWithIndex"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("forInEmptySequenceWithIndex.kt")
            public void testForInEmptySequenceWithIndex() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInSequenceWithIndex/forInEmptySequenceWithIndex.kt");
            }

            @Test
            @TestMetadata("forInSequenceTypeParameterWithIndex.kt")
            public void testForInSequenceTypeParameterWithIndex() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInSequenceWithIndex/forInSequenceTypeParameterWithIndex.kt");
            }

            @Test
            @TestMetadata("forInSequenceWithIndex.kt")
            public void testForInSequenceWithIndex() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInSequenceWithIndex/forInSequenceWithIndex.kt");
            }

            @Test
            @TestMetadata("forInSequenceWithIndexBreakAndContinue.kt")
            public void testForInSequenceWithIndexBreakAndContinue() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInSequenceWithIndex/forInSequenceWithIndexBreakAndContinue.kt");
            }

            @Test
            @TestMetadata("forInSequenceWithIndexCheckSideEffects.kt")
            public void testForInSequenceWithIndexCheckSideEffects() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInSequenceWithIndex/forInSequenceWithIndexCheckSideEffects.kt");
            }

            @Test
            @TestMetadata("forInSequenceWithIndexNoElementVar.kt")
            public void testForInSequenceWithIndexNoElementVar() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInSequenceWithIndex/forInSequenceWithIndexNoElementVar.kt");
            }

            @Test
            @TestMetadata("forInSequenceWithIndexNoElementVarCheckSideEffects.kt")
            public void testForInSequenceWithIndexNoElementVarCheckSideEffects() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInSequenceWithIndex/forInSequenceWithIndexNoElementVarCheckSideEffects.kt");
            }

            @Test
            @TestMetadata("forInSequenceWithIndexNoIndexVar.kt")
            public void testForInSequenceWithIndexNoIndexVar() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInSequenceWithIndex/forInSequenceWithIndexNoIndexVar.kt");
            }

            @Test
            @TestMetadata("forInSequenceWithIndexNoIndexVarCheckSideEffects.kt")
            public void testForInSequenceWithIndexNoIndexVarCheckSideEffects() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInSequenceWithIndex/forInSequenceWithIndexNoIndexVarCheckSideEffects.kt");
            }

            @Test
            @TestMetadata("forInSequenceWithIndexThrowsCME.kt")
            public void testForInSequenceWithIndexThrowsCME() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInSequenceWithIndex/forInSequenceWithIndexThrowsCME.kt");
            }

            @Test
            @TestMetadata("forInSequenceWithIndexWithExplicitlyTypedIndexVariable.kt")
            public void testForInSequenceWithIndexWithExplicitlyTypedIndexVariable() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/forInSequenceWithIndex/forInSequenceWithIndexWithExplicitlyTypedIndexVariable.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/box/controlStructures/returnsNothing")
        @TestDataPath("$PROJECT_ROOT")
        public class ReturnsNothing {
            @Test
            public void testAllFilesPresentInReturnsNothing() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/controlStructures/returnsNothing"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("ifElse.kt")
            public void testIfElse() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/returnsNothing/ifElse.kt");
            }

            @Test
            @TestMetadata("inlineMethod.kt")
            public void testInlineMethod() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/returnsNothing/inlineMethod.kt");
            }

            @Test
            @TestMetadata("propertyGetter.kt")
            public void testPropertyGetter() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/returnsNothing/propertyGetter.kt");
            }

            @Test
            @TestMetadata("tryCatch.kt")
            public void testTryCatch() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/returnsNothing/tryCatch.kt");
            }

            @Test
            @TestMetadata("when.kt")
            public void testWhen() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/returnsNothing/when.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/box/controlStructures/slowDsl")
        @TestDataPath("$PROJECT_ROOT")
        public class SlowDsl {
            @Test
            public void testAllFilesPresentInSlowDsl() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/controlStructures/slowDsl"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("slowHtmlLikeDsl.kt")
            public void testSlowHtmlLikeDsl() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/slowDsl/slowHtmlLikeDsl.kt");
            }

            @Test
            @TestMetadata("slowHtmlLikeDslNoInline.kt")
            public void testSlowHtmlLikeDslNoInline() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/slowDsl/slowHtmlLikeDslNoInline.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions")
        @TestDataPath("$PROJECT_ROOT")
        public class TryCatchInExpressions {
            @Test
            public void testAllFilesPresentInTryCatchInExpressions() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("catch.kt")
            public void testCatch() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/catch.kt");
            }

            @Test
            @TestMetadata("complexChain.kt")
            public void testComplexChain() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/complexChain.kt");
            }

            @Test
            @TestMetadata("deadTryCatch.kt")
            public void testDeadTryCatch() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/deadTryCatch.kt");
            }

            @Test
            @TestMetadata("differentTypes.kt")
            public void testDifferentTypes() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/differentTypes.kt");
            }

            @Test
            @TestMetadata("expectException.kt")
            public void testExpectException() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/expectException.kt");
            }

            @Test
            @TestMetadata("finally.kt")
            public void testFinally() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/finally.kt");
            }

            @Test
            @TestMetadata("inlineTryCatch.kt")
            public void testInlineTryCatch() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/inlineTryCatch.kt");
            }

            @Test
            @TestMetadata("inlineTryExpr.kt")
            public void testInlineTryExpr() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/inlineTryExpr.kt");
            }

            @Test
            @TestMetadata("inlineTryFinally.kt")
            public void testInlineTryFinally() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/inlineTryFinally.kt");
            }

            @Test
            @TestMetadata("kt17572.kt")
            public void testKt17572() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/kt17572.kt");
            }

            @Test
            @TestMetadata("kt17572_2.kt")
            public void testKt17572_2() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/kt17572_2.kt");
            }

            @Test
            @TestMetadata("kt17572_2_ext.kt")
            public void testKt17572_2_ext() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/kt17572_2_ext.kt");
            }

            @Test
            @TestMetadata("kt17572_ext.kt")
            public void testKt17572_ext() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/kt17572_ext.kt");
            }

            @Test
            @TestMetadata("kt17572_nested.kt")
            public void testKt17572_nested() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/kt17572_nested.kt");
            }

            @Test
            @TestMetadata("kt17573.kt")
            public void testKt17573() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/kt17573.kt");
            }

            @Test
            @TestMetadata("kt17573_nested.kt")
            public void testKt17573_nested() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/kt17573_nested.kt");
            }

            @Test
            @TestMetadata("kt8608.kt")
            public void testKt8608() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/kt8608.kt");
            }

            @Test
            @TestMetadata("kt9644try.kt")
            public void testKt9644try() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/kt9644try.kt");
            }

            @Test
            @TestMetadata("multipleCatchBlocks.kt")
            public void testMultipleCatchBlocks() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/multipleCatchBlocks.kt");
            }

            @Test
            @TestMetadata("nonLocalReturnInTryFinally.kt")
            public void testNonLocalReturnInTryFinally() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/nonLocalReturnInTryFinally.kt");
            }

            @Test
            @TestMetadata("splitTry.kt")
            public void testSplitTry() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/splitTry.kt");
            }

            @Test
            @TestMetadata("splitTryCorner1.kt")
            public void testSplitTryCorner1() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/splitTryCorner1.kt");
            }

            @Test
            @TestMetadata("splitTryCorner2.kt")
            public void testSplitTryCorner2() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/splitTryCorner2.kt");
            }

            @Test
            @TestMetadata("try.kt")
            public void testTry() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/try.kt");
            }

            @Test
            @TestMetadata("tryAfterTry.kt")
            public void testTryAfterTry() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/tryAfterTry.kt");
            }

            @Test
            @TestMetadata("tryAndBreak.kt")
            public void testTryAndBreak() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/tryAndBreak.kt");
            }

            @Test
            @TestMetadata("tryAndContinue.kt")
            public void testTryAndContinue() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/tryAndContinue.kt");
            }

            @Test
            @TestMetadata("tryCatchAfterWhileTrue.kt")
            public void testTryCatchAfterWhileTrue() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/tryCatchAfterWhileTrue.kt");
            }

            @Test
            @TestMetadata("tryInsideCatch.kt")
            public void testTryInsideCatch() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/tryInsideCatch.kt");
            }

            @Test
            @TestMetadata("tryInsideTry.kt")
            public void testTryInsideTry() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/tryInsideTry.kt");
            }

            @Test
            @TestMetadata("unmatchedInlineMarkers.kt")
            public void testUnmatchedInlineMarkers() throws Exception {
                runTest("compiler/testData/codegen/box/controlStructures/tryCatchInExpressions/unmatchedInlineMarkers.kt");
            }
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/coroutines")
    @TestDataPath("$PROJECT_ROOT")
    public class Coroutines {
        @Test
        @TestMetadata("32defaultParametersInSuspend.kt")
        public void test32defaultParametersInSuspend() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/32defaultParametersInSuspend.kt");
        }

        @Test
        @TestMetadata("accessorForSuspend.kt")
        public void testAccessorForSuspend() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/accessorForSuspend.kt");
        }

        @Test
        public void testAllFilesPresentInCoroutines() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("async.kt")
        public void testAsync() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/async.kt");
        }

        @Test
        @TestMetadata("asyncException.kt")
        public void testAsyncException() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/asyncException.kt");
        }

        @Test
        @TestMetadata("asyncIteratorNullMerge_1_3.kt")
        public void testAsyncIteratorNullMerge_1_3() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/asyncIteratorNullMerge_1_3.kt");
        }

        @Test
        @TestMetadata("asyncIteratorToList_1_3.kt")
        public void testAsyncIteratorToList_1_3() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/asyncIteratorToList_1_3.kt");
        }

        @Test
        @TestMetadata("asyncIterator_1_3.kt")
        public void testAsyncIterator_1_3() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/asyncIterator_1_3.kt");
        }

        @Test
        @TestMetadata("await.kt")
        public void testAwait() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/await.kt");
        }

        @Test
        @TestMetadata("beginWithException.kt")
        public void testBeginWithException() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/beginWithException.kt");
        }

        @Test
        @TestMetadata("beginWithExceptionNoHandleException.kt")
        public void testBeginWithExceptionNoHandleException() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/beginWithExceptionNoHandleException.kt");
        }

        @Test
        @TestMetadata("builderInferenceAndGenericArrayAcessCall.kt")
        public void testBuilderInferenceAndGenericArrayAcessCall() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/builderInferenceAndGenericArrayAcessCall.kt");
        }

        @Test
        @TestMetadata("captureInfixFun.kt")
        public void testCaptureInfixFun() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/captureInfixFun.kt");
        }

        @Test
        @TestMetadata("captureMutableLocalVariableInsideCoroutineBlock.kt")
        public void testCaptureMutableLocalVariableInsideCoroutineBlock() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/captureMutableLocalVariableInsideCoroutineBlock.kt");
        }

        @Test
        @TestMetadata("captureUnaryOperator.kt")
        public void testCaptureUnaryOperator() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/captureUnaryOperator.kt");
        }

        @Test
        @TestMetadata("capturedVarInSuspendLambda.kt")
        public void testCapturedVarInSuspendLambda() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/capturedVarInSuspendLambda.kt");
        }

        @Test
        @TestMetadata("castWithSuspend.kt")
        public void testCastWithSuspend() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/castWithSuspend.kt");
        }

        @Test
        @TestMetadata("catchWithInlineInsideSuspend.kt")
        public void testCatchWithInlineInsideSuspend() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/catchWithInlineInsideSuspend.kt");
        }

        @Test
        @TestMetadata("coercionToUnit.kt")
        public void testCoercionToUnit() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/coercionToUnit.kt");
        }

        @Test
        @TestMetadata("controllerAccessFromInnerLambda.kt")
        public void testControllerAccessFromInnerLambda() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/controllerAccessFromInnerLambda.kt");
        }

        @Test
        @TestMetadata("coroutineContextInInlinedLambda.kt")
        public void testCoroutineContextInInlinedLambda() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/coroutineContextInInlinedLambda.kt");
        }

        @Test
        @TestMetadata("coroutineToString.kt")
        public void testCoroutineToString() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/coroutineToString.kt");
        }

        @Test
        @TestMetadata("createCoroutineSafe.kt")
        public void testCreateCoroutineSafe() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/createCoroutineSafe.kt");
        }

        @Test
        @TestMetadata("createCoroutinesOnManualInstances.kt")
        public void testCreateCoroutinesOnManualInstances() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/createCoroutinesOnManualInstances.kt");
        }

        @Test
        @TestMetadata("crossInlineWithCapturedOuterReceiver.kt")
        public void testCrossInlineWithCapturedOuterReceiver() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/crossInlineWithCapturedOuterReceiver.kt");
        }

        @Test
        @TestMetadata("defaultParametersInSuspend.kt")
        public void testDefaultParametersInSuspend() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/defaultParametersInSuspend.kt");
        }

        @Test
        @TestMetadata("defaultParametersInSuspendWithJvmOverloads.kt")
        public void testDefaultParametersInSuspendWithJvmOverloads() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/defaultParametersInSuspendWithJvmOverloads.kt");
        }

        @Test
        @TestMetadata("delegatedSuspendMember.kt")
        public void testDelegatedSuspendMember() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/delegatedSuspendMember.kt");
        }

        @Test
        @TestMetadata("dispatchResume.kt")
        public void testDispatchResume() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/dispatchResume.kt");
        }

        @Test
        @TestMetadata("doubleColonExpressionsGenerationInBuilderInference.kt")
        public void testDoubleColonExpressionsGenerationInBuilderInference() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/doubleColonExpressionsGenerationInBuilderInference.kt");
        }

        @Test
        @TestMetadata("emptyClosure.kt")
        public void testEmptyClosure() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/emptyClosure.kt");
        }

        @Test
        @TestMetadata("emptyCommonConstraintSystemForCoroutineInferenceCall.kt")
        public void testEmptyCommonConstraintSystemForCoroutineInferenceCall() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/emptyCommonConstraintSystemForCoroutineInferenceCall.kt");
        }

        @Test
        @TestMetadata("epam.kt")
        public void testEpam() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/epam.kt");
        }

        @Test
        @TestMetadata("falseUnitCoercion.kt")
        public void testFalseUnitCoercion() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/falseUnitCoercion.kt");
        }

        @Test
        @TestMetadata("generate.kt")
        public void testGenerate() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/generate.kt");
        }

        @Test
        @TestMetadata("handleException.kt")
        public void testHandleException() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/handleException.kt");
        }

        @Test
        @TestMetadata("handleResultCallEmptyBody.kt")
        public void testHandleResultCallEmptyBody() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/handleResultCallEmptyBody.kt");
        }

        @Test
        @TestMetadata("handleResultNonUnitExpression.kt")
        public void testHandleResultNonUnitExpression() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/handleResultNonUnitExpression.kt");
        }

        @Test
        @TestMetadata("handleResultSuspended.kt")
        public void testHandleResultSuspended() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/handleResultSuspended.kt");
        }

        @Test
        @TestMetadata("illegalState.kt")
        public void testIllegalState() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/illegalState.kt");
        }

        @Test
        @TestMetadata("indirectInlineUsedAsNonInline.kt")
        public void testIndirectInlineUsedAsNonInline() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/indirectInlineUsedAsNonInline.kt");
        }

        @Test
        @TestMetadata("inlineFunInGenericClass.kt")
        public void testInlineFunInGenericClass() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/inlineFunInGenericClass.kt");
        }

        @Test
        @TestMetadata("inlineFunctionInMultifileClass.kt")
        public void testInlineFunctionInMultifileClass() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/inlineFunctionInMultifileClass.kt");
        }

        @Test
        @TestMetadata("inlineFunctionInMultifileClassUnoptimized.kt")
        public void testInlineFunctionInMultifileClassUnoptimized() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/inlineFunctionInMultifileClassUnoptimized.kt");
        }

        @Test
        @TestMetadata("inlineGenericFunCalledFromSubclass.kt")
        public void testInlineGenericFunCalledFromSubclass() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/inlineGenericFunCalledFromSubclass.kt");
        }

        @Test
        @TestMetadata("inlineSuspendFunction.kt")
        public void testInlineSuspendFunction() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/inlineSuspendFunction.kt");
        }

        @Test
        @TestMetadata("inlineSuspendLambdaNonLocalReturn.kt")
        public void testInlineSuspendLambdaNonLocalReturn() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/inlineSuspendLambdaNonLocalReturn.kt");
        }

        @Test
        @TestMetadata("inlinedTryCatchFinally.kt")
        public void testInlinedTryCatchFinally() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/inlinedTryCatchFinally.kt");
        }

        @Test
        @TestMetadata("innerSuspensionCalls.kt")
        public void testInnerSuspensionCalls() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/innerSuspensionCalls.kt");
        }

        @Test
        @TestMetadata("instanceOfContinuation.kt")
        public void testInstanceOfContinuation() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/instanceOfContinuation.kt");
        }

        @Test
        @TestMetadata("iterateOverArray.kt")
        public void testIterateOverArray() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/iterateOverArray.kt");
        }

        @Test
        @TestMetadata("jvmStaticAndJvmInline.kt")
        public void testJvmStaticAndJvmInline() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/jvmStaticAndJvmInline.kt");
        }

        @Test
        @TestMetadata("kt12958.kt")
        public void testKt12958() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/kt12958.kt");
        }

        @Test
        @TestMetadata("kt15016.kt")
        public void testKt15016() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/kt15016.kt");
        }

        @Test
        @TestMetadata("kt15017.kt")
        public void testKt15017() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/kt15017.kt");
        }

        @Test
        @TestMetadata("kt15930.kt")
        public void testKt15930() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/kt15930.kt");
        }

        @Test
        @TestMetadata("kt21080.kt")
        public void testKt21080() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/kt21080.kt");
        }

        @Test
        @TestMetadata("kt21605.kt")
        public void testKt21605() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/kt21605.kt");
        }

        @Test
        @TestMetadata("kt24135.kt")
        public void testKt24135() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/kt24135.kt");
        }

        @Test
        @TestMetadata("kt25912.kt")
        public void testKt25912() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/kt25912.kt");
        }

        @Test
        @TestMetadata("kt28844.kt")
        public void testKt28844() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/kt28844.kt");
        }

        @Test
        @TestMetadata("kt30858.kt")
        public void testKt30858() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/kt30858.kt");
        }

        @Test
        @TestMetadata("kt31784.kt")
        public void testKt31784() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/kt31784.kt");
        }

        @Test
        @TestMetadata("kt35967.kt")
        public void testKt35967() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/kt35967.kt");
        }

        @Test
        @TestMetadata("kt38099.kt")
        public void testKt38099() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/kt38099.kt");
        }

        @Test
        @TestMetadata("kt42028.kt")
        public void testKt42028() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/kt42028.kt");
        }

        @Test
        @TestMetadata("kt42554.kt")
        public void testKt42554() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/kt42554.kt");
        }

        @Test
        @TestMetadata("kt44221.kt")
        public void testKt44221() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/kt44221.kt");
        }

        @Test
        @TestMetadata("kt44710.kt")
        public void testKt44710() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/kt44710.kt");
        }

        @Test
        @TestMetadata("kt44781.kt")
        public void testKt44781() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/kt44781.kt");
        }

        @Test
        @TestMetadata("kt45377.kt")
        public void testKt45377() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/kt45377.kt");
        }

        @Test
        @TestMetadata("kt46813.kt")
        public void testKt46813() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/kt46813.kt");
        }

        @Test
        @TestMetadata("kt49168.kt")
        public void testKt49168() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/kt49168.kt");
        }

        @Test
        @TestMetadata("kt49317.kt")
        public void testKt49317() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/kt49317.kt");
        }

        @Test
        @TestMetadata("kt49645.kt")
        public void testKt49645() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/kt49645.kt");
        }

        @Test
        @TestMetadata("kt50277.kt")
        public void testKt50277() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/kt50277.kt");
        }

        @Test
        @TestMetadata("kt51530.kt")
        public void testKt51530() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/kt51530.kt");
        }

        @Test
        @TestMetadata("kt51718.kt")
        public void testKt51718() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/kt51718.kt");
        }

        @Test
        @TestMetadata("lastExpressionIsLoop.kt")
        public void testLastExpressionIsLoop() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/lastExpressionIsLoop.kt");
        }

        @Test
        @TestMetadata("lastStatementInc.kt")
        public void testLastStatementInc() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/lastStatementInc.kt");
        }

        @Test
        @TestMetadata("lastStementAssignment.kt")
        public void testLastStementAssignment() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/lastStementAssignment.kt");
        }

        @Test
        @TestMetadata("lastUnitExpression.kt")
        public void testLastUnitExpression() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/lastUnitExpression.kt");
        }

        @Test
        @TestMetadata("localCallableRef.kt")
        public void testLocalCallableRef() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/localCallableRef.kt");
        }

        @Test
        @TestMetadata("localDelegate.kt")
        public void testLocalDelegate() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/localDelegate.kt");
        }

        @Test
        @TestMetadata("longRangeInSuspendCall.kt")
        public void testLongRangeInSuspendCall() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/longRangeInSuspendCall.kt");
        }

        @Test
        @TestMetadata("longRangeInSuspendFun.kt")
        public void testLongRangeInSuspendFun() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/longRangeInSuspendFun.kt");
        }

        @Test
        @TestMetadata("mergeNullAndString.kt")
        public void testMergeNullAndString() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/mergeNullAndString.kt");
        }

        @Test
        @TestMetadata("multipleInvokeCalls.kt")
        public void testMultipleInvokeCalls() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/multipleInvokeCalls.kt");
        }

        @Test
        @TestMetadata("multipleInvokeCallsInsideInlineLambda1.kt")
        public void testMultipleInvokeCallsInsideInlineLambda1() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/multipleInvokeCallsInsideInlineLambda1.kt");
        }

        @Test
        @TestMetadata("multipleInvokeCallsInsideInlineLambda2.kt")
        public void testMultipleInvokeCallsInsideInlineLambda2() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/multipleInvokeCallsInsideInlineLambda2.kt");
        }

        @Test
        @TestMetadata("multipleInvokeCallsInsideInlineLambda3.kt")
        public void testMultipleInvokeCallsInsideInlineLambda3() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/multipleInvokeCallsInsideInlineLambda3.kt");
        }

        @Test
        @TestMetadata("nestedTryCatch.kt")
        public void testNestedTryCatch() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/nestedTryCatch.kt");
        }

        @Test
        @TestMetadata("noSuspensionPoints.kt")
        public void testNoSuspensionPoints() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/noSuspensionPoints.kt");
        }

        @Test
        @TestMetadata("nonLocalReturn.kt")
        public void testNonLocalReturn() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/nonLocalReturn.kt");
        }

        @Test
        @TestMetadata("nonLocalReturnFromInlineLambda.kt")
        public void testNonLocalReturnFromInlineLambda() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/nonLocalReturnFromInlineLambda.kt");
        }

        @Test
        @TestMetadata("nonLocalReturnFromInlineLambdaDeep.kt")
        public void testNonLocalReturnFromInlineLambdaDeep() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/nonLocalReturnFromInlineLambdaDeep.kt");
        }

        @Test
        @TestMetadata("nullableSuspendFunctionType.kt")
        public void testNullableSuspendFunctionType() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/nullableSuspendFunctionType.kt");
        }

        @Test
        @TestMetadata("overrideDefaultArgument.kt")
        public void testOverrideDefaultArgument() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/overrideDefaultArgument.kt");
        }

        @Test
        @TestMetadata("recursiveSuspend.kt")
        public void testRecursiveSuspend() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/recursiveSuspend.kt");
        }

        @Test
        @TestMetadata("restrictedSuspendLambda.kt")
        public void testRestrictedSuspendLambda() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/restrictedSuspendLambda.kt");
        }

        @Test
        @TestMetadata("returnByLabel.kt")
        public void testReturnByLabel() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/returnByLabel.kt");
        }

        @Test
        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/simple.kt");
        }

        @Test
        @TestMetadata("simpleException.kt")
        public void testSimpleException() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/simpleException.kt");
        }

        @Test
        @TestMetadata("simpleSuspendCallableReference.kt")
        public void testSimpleSuspendCallableReference() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/simpleSuspendCallableReference.kt");
        }

        @Test
        @TestMetadata("simpleWithDefaultValue.kt")
        public void testSimpleWithDefaultValue() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/simpleWithDefaultValue.kt");
        }

        @Test
        @TestMetadata("simpleWithHandleResult.kt")
        public void testSimpleWithHandleResult() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/simpleWithHandleResult.kt");
        }

        @Test
        @TestMetadata("statementLikeLastExpression.kt")
        public void testStatementLikeLastExpression() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/statementLikeLastExpression.kt");
        }

        @Test
        @TestMetadata("stopAfter.kt")
        public void testStopAfter() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/stopAfter.kt");
        }

        @Test
        @TestMetadata("suspendCallInSuperInterfaceCallArguments.kt")
        public void testSuspendCallInSuperInterfaceCallArguments() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/suspendCallInSuperInterfaceCallArguments.kt");
        }

        @Test
        @TestMetadata("suspendCallsInArguments.kt")
        public void testSuspendCallsInArguments() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/suspendCallsInArguments.kt");
        }

        @Test
        @TestMetadata("suspendCoroutineFromStateMachine.kt")
        public void testSuspendCoroutineFromStateMachine() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/suspendCoroutineFromStateMachine.kt");
        }

        @Test
        @TestMetadata("suspendCovariantJavaOverrides.kt")
        public void testSuspendCovariantJavaOverrides() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/suspendCovariantJavaOverrides.kt");
        }

        @Test
        @TestMetadata("suspendDefaultImpl.kt")
        public void testSuspendDefaultImpl() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/suspendDefaultImpl.kt");
        }

        @Test
        @TestMetadata("suspendDelegation.kt")
        public void testSuspendDelegation() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/suspendDelegation.kt");
        }

        @Test
        @TestMetadata("suspendFromInlineLambda.kt")
        public void testSuspendFromInlineLambda() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/suspendFromInlineLambda.kt");
        }

        @Test
        @TestMetadata("suspendFunImportedFromObject.kt")
        public void testSuspendFunImportedFromObject() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/suspendFunImportedFromObject.kt");
        }

        @Test
        @TestMetadata("suspendFunctionAsSupertype.kt")
        public void testSuspendFunctionAsSupertype() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/suspendFunctionAsSupertype.kt");
        }

        @Test
        @TestMetadata("suspendFunctionAsSupertypeCall.kt")
        public void testSuspendFunctionAsSupertypeCall() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/suspendFunctionAsSupertypeCall.kt");
        }

        @Test
        @TestMetadata("suspendFunctionMethodReference.kt")
        public void testSuspendFunctionMethodReference() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/suspendFunctionMethodReference.kt");
        }

        @Test
        @TestMetadata("suspendImplBridge.kt")
        public void testSuspendImplBridge() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/suspendImplBridge.kt");
        }

        @Test
        @TestMetadata("suspendInCycle.kt")
        public void testSuspendInCycle() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/suspendInCycle.kt");
        }

        @Test
        @TestMetadata("suspendInTheMiddleOfObjectConstruction.kt")
        public void testSuspendInTheMiddleOfObjectConstruction() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/suspendInTheMiddleOfObjectConstruction.kt");
        }

        @Test
        @TestMetadata("suspendInTheMiddleOfObjectConstructionEvaluationOrder.kt")
        public void testSuspendInTheMiddleOfObjectConstructionEvaluationOrder() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/suspendInTheMiddleOfObjectConstructionEvaluationOrder.kt");
        }

        @Test
        @TestMetadata("suspendInTheMiddleOfObjectConstructionWithJumpOut.kt")
        public void testSuspendInTheMiddleOfObjectConstructionWithJumpOut() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/suspendInTheMiddleOfObjectConstructionWithJumpOut.kt");
        }

        @Test
        @TestMetadata("suspendInlineReference.kt")
        public void testSuspendInlineReference() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/suspendInlineReference.kt");
        }

        @Test
        @TestMetadata("suspendJavaOverrides.kt")
        public void testSuspendJavaOverrides() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/suspendJavaOverrides.kt");
        }

        @Test
        @TestMetadata("suspendLambdaInInterface.kt")
        public void testSuspendLambdaInInterface() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/suspendLambdaInInterface.kt");
        }

        @Test
        @TestMetadata("suspendLambdaWithArgumentRearrangement.kt")
        public void testSuspendLambdaWithArgumentRearrangement() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/suspendLambdaWithArgumentRearrangement.kt");
        }

        @Test
        @TestMetadata("suspendReturningPlatformType.kt")
        public void testSuspendReturningPlatformType() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/suspendReturningPlatformType.kt");
        }

        @Test
        @TestMetadata("suspensionInsideSafeCall.kt")
        public void testSuspensionInsideSafeCall() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/suspensionInsideSafeCall.kt");
        }

        @Test
        @TestMetadata("suspensionInsideSafeCallWithElvis.kt")
        public void testSuspensionInsideSafeCallWithElvis() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/suspensionInsideSafeCallWithElvis.kt");
        }

        @Test
        @TestMetadata("tailCallToNothing.kt")
        public void testTailCallToNothing() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/tailCallToNothing.kt");
        }

        @Test
        @TestMetadata("tryCatchFinallyWithHandleResult.kt")
        public void testTryCatchFinallyWithHandleResult() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/tryCatchFinallyWithHandleResult.kt");
        }

        @Test
        @TestMetadata("tryCatchWithHandleResult.kt")
        public void testTryCatchWithHandleResult() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/tryCatchWithHandleResult.kt");
        }

        @Test
        @TestMetadata("tryFinallyInsideInlineLambda.kt")
        public void testTryFinallyInsideInlineLambda() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/tryFinallyInsideInlineLambda.kt");
        }

        @Test
        @TestMetadata("tryFinallyWithHandleResult.kt")
        public void testTryFinallyWithHandleResult() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/tryFinallyWithHandleResult.kt");
        }

        @Test
        @TestMetadata("varCaptuedInCoroutineIntrinsic.kt")
        public void testVarCaptuedInCoroutineIntrinsic() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/varCaptuedInCoroutineIntrinsic.kt");
        }

        @Test
        @TestMetadata("varValueConflictsWithTable.kt")
        public void testVarValueConflictsWithTable() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/varValueConflictsWithTable.kt");
        }

        @Test
        @TestMetadata("varValueConflictsWithTableSameSort.kt")
        public void testVarValueConflictsWithTableSameSort() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/varValueConflictsWithTableSameSort.kt");
        }

        @Test
        @TestMetadata("varargCallFromSuspend.kt")
        public void testVarargCallFromSuspend() throws Exception {
            runTest("compiler/testData/codegen/box/coroutines/varargCallFromSuspend.kt");
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/box/coroutines/bridges")
        @TestDataPath("$PROJECT_ROOT")
        public class Bridges {
            @Test
            public void testAllFilesPresentInBridges() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/bridges"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("interfaceGenericDefault.kt")
            public void testInterfaceGenericDefault() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/bridges/interfaceGenericDefault.kt");
            }

            @Test
            @TestMetadata("interfaceSpecialization.kt")
            public void testInterfaceSpecialization() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/bridges/interfaceSpecialization.kt");
            }

            @Test
            @TestMetadata("lambdaWithLongReceiver.kt")
            public void testLambdaWithLongReceiver() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/bridges/lambdaWithLongReceiver.kt");
            }

            @Test
            @TestMetadata("lambdaWithMultipleParameters.kt")
            public void testLambdaWithMultipleParameters() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/bridges/lambdaWithMultipleParameters.kt");
            }

            @Test
            @TestMetadata("mapSuspendAbstractClear.kt")
            public void testMapSuspendAbstractClear() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/bridges/mapSuspendAbstractClear.kt");
            }

            @Test
            @TestMetadata("mapSuspendClear.kt")
            public void testMapSuspendClear() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/bridges/mapSuspendClear.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/box/coroutines/controlFlow")
        @TestDataPath("$PROJECT_ROOT")
        public class ControlFlow {
            @Test
            public void testAllFilesPresentInControlFlow() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/controlFlow"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("breakFinally.kt")
            public void testBreakFinally() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/controlFlow/breakFinally.kt");
            }

            @Test
            @TestMetadata("breakStatement.kt")
            public void testBreakStatement() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/controlFlow/breakStatement.kt");
            }

            @Test
            @TestMetadata("complexChainSuspend.kt")
            public void testComplexChainSuspend() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/controlFlow/complexChainSuspend.kt");
            }

            @Test
            @TestMetadata("doWhileStatement.kt")
            public void testDoWhileStatement() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/controlFlow/doWhileStatement.kt");
            }

            @Test
            @TestMetadata("doWhileWithInline.kt")
            public void testDoWhileWithInline() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/controlFlow/doWhileWithInline.kt");
            }

            @Test
            @TestMetadata("doubleBreak.kt")
            public void testDoubleBreak() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/controlFlow/doubleBreak.kt");
            }

            @Test
            @TestMetadata("finallyCatch.kt")
            public void testFinallyCatch() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/controlFlow/finallyCatch.kt");
            }

            @Test
            @TestMetadata("forContinue.kt")
            public void testForContinue() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/controlFlow/forContinue.kt");
            }

            @Test
            @TestMetadata("forStatement.kt")
            public void testForStatement() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/controlFlow/forStatement.kt");
            }

            @Test
            @TestMetadata("forWithStep.kt")
            public void testForWithStep() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/controlFlow/forWithStep.kt");
            }

            @Test
            @TestMetadata("ifStatement.kt")
            public void testIfStatement() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/controlFlow/ifStatement.kt");
            }

            @Test
            @TestMetadata("kt22694_1_3.kt")
            public void testKt22694_1_3() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/controlFlow/kt22694_1_3.kt");
            }

            @Test
            @TestMetadata("labeledWhile.kt")
            public void testLabeledWhile() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/controlFlow/labeledWhile.kt");
            }

            @Test
            @TestMetadata("multipleCatchBlocksSuspend.kt")
            public void testMultipleCatchBlocksSuspend() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/controlFlow/multipleCatchBlocksSuspend.kt");
            }

            @Test
            @TestMetadata("returnFromFinally.kt")
            public void testReturnFromFinally() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/controlFlow/returnFromFinally.kt");
            }

            @Test
            @TestMetadata("returnWithFinally.kt")
            public void testReturnWithFinally() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/controlFlow/returnWithFinally.kt");
            }

            @Test
            @TestMetadata("suspendInStringTemplate.kt")
            public void testSuspendInStringTemplate() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/controlFlow/suspendInStringTemplate.kt");
            }

            @Test
            @TestMetadata("switchLikeWhen.kt")
            public void testSwitchLikeWhen() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/controlFlow/switchLikeWhen.kt");
            }

            @Test
            @TestMetadata("throwFromCatch.kt")
            public void testThrowFromCatch() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/controlFlow/throwFromCatch.kt");
            }

            @Test
            @TestMetadata("throwFromFinally.kt")
            public void testThrowFromFinally() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/controlFlow/throwFromFinally.kt");
            }

            @Test
            @TestMetadata("throwInTryWithHandleResult.kt")
            public void testThrowInTryWithHandleResult() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/controlFlow/throwInTryWithHandleResult.kt");
            }

            @Test
            @TestMetadata("whenWithSuspensions.kt")
            public void testWhenWithSuspensions() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/controlFlow/whenWithSuspensions.kt");
            }

            @Test
            @TestMetadata("whileStatement.kt")
            public void testWhileStatement() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/controlFlow/whileStatement.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/box/coroutines/debug")
        @TestDataPath("$PROJECT_ROOT")
        public class Debug {
            @Test
            public void testAllFilesPresentInDebug() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/debug"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("debuggerMetadata.kt")
            public void testDebuggerMetadata() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/debug/debuggerMetadata.kt");
            }

            @Test
            @TestMetadata("elvisLineNumber.kt")
            public void testElvisLineNumber() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/debug/elvisLineNumber.kt");
            }

            @Test
            @TestMetadata("firstSuspensionPoint.kt")
            public void testFirstSuspensionPoint() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/debug/firstSuspensionPoint.kt");
            }

            @Test
            @TestMetadata("fqName.kt")
            public void testFqName() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/debug/fqName.kt");
            }

            @Test
            @TestMetadata("multipleSuspendCallsOnSameLine.kt")
            public void testMultipleSuspendCallsOnSameLine() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/debug/multipleSuspendCallsOnSameLine.kt");
            }

            @Test
            @TestMetadata("runtimeDebugMetadata.kt")
            public void testRuntimeDebugMetadata() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/debug/runtimeDebugMetadata.kt");
            }

            @Test
            @TestMetadata("throwsOnSameLine.kt")
            public void testThrowsOnSameLine() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/debug/throwsOnSameLine.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/box/coroutines/featureIntersection")
        @TestDataPath("$PROJECT_ROOT")
        public class FeatureIntersection {
            @Test
            public void testAllFilesPresentInFeatureIntersection() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/featureIntersection"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("breakWithNonEmptyStack.kt")
            public void testBreakWithNonEmptyStack() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/featureIntersection/breakWithNonEmptyStack.kt");
            }

            @Test
            @TestMetadata("defaultExpect.kt")
            public void testDefaultExpect() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/featureIntersection/defaultExpect.kt");
            }

            @Test
            @TestMetadata("delegate.kt")
            public void testDelegate() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/featureIntersection/delegate.kt");
            }

            @Test
            @TestMetadata("destructuringInLambdas.kt")
            public void testDestructuringInLambdas() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/featureIntersection/destructuringInLambdas.kt");
            }

            @Test
            @TestMetadata("funInterface.kt")
            public void testFunInterface() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/featureIntersection/funInterface.kt");
            }

            @Test
            @TestMetadata("inlineSuspendFinally.kt")
            public void testInlineSuspendFinally() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/featureIntersection/inlineSuspendFinally.kt");
            }

            @Test
            @TestMetadata("interfaceMethodWithBody.kt")
            public void testInterfaceMethodWithBody() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/featureIntersection/interfaceMethodWithBody.kt");
            }

            @Test
            @TestMetadata("interfaceMethodWithBodyGeneric.kt")
            public void testInterfaceMethodWithBodyGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/featureIntersection/interfaceMethodWithBodyGeneric.kt");
            }

            @Test
            @TestMetadata("overrideInInlineClass.kt")
            public void testOverrideInInlineClass() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/featureIntersection/overrideInInlineClass.kt");
            }

            @Test
            @TestMetadata("overrideInInnerClass.kt")
            public void testOverrideInInnerClass() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/featureIntersection/overrideInInnerClass.kt");
            }

            @Test
            @TestMetadata("safeCallOnTwoReceivers.kt")
            public void testSafeCallOnTwoReceivers() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/featureIntersection/safeCallOnTwoReceivers.kt");
            }

            @Test
            @TestMetadata("safeCallOnTwoReceiversLong.kt")
            public void testSafeCallOnTwoReceiversLong() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/featureIntersection/safeCallOnTwoReceiversLong.kt");
            }

            @Test
            @TestMetadata("suspendDestructuringInLambdas.kt")
            public void testSuspendDestructuringInLambdas() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/featureIntersection/suspendDestructuringInLambdas.kt");
            }

            @Test
            @TestMetadata("suspendFunctionAsSupertypeIsCheck.kt")
            public void testSuspendFunctionAsSupertypeIsCheck() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/featureIntersection/suspendFunctionAsSupertypeIsCheck.kt");
            }

            @Test
            @TestMetadata("suspendFunctionAsSupertypeIsCheckWithArity.kt")
            public void testSuspendFunctionAsSupertypeIsCheckWithArity() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/featureIntersection/suspendFunctionAsSupertypeIsCheckWithArity.kt");
            }

            @Test
            @TestMetadata("suspendFunctionIsAs.kt")
            public void testSuspendFunctionIsAs() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/featureIntersection/suspendFunctionIsAs.kt");
            }

            @Test
            @TestMetadata("suspendInlineSuspendFinally.kt")
            public void testSuspendInlineSuspendFinally() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/featureIntersection/suspendInlineSuspendFinally.kt");
            }

            @Test
            @TestMetadata("suspendOperatorPlus.kt")
            public void testSuspendOperatorPlus() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/featureIntersection/suspendOperatorPlus.kt");
            }

            @Test
            @TestMetadata("suspendOperatorPlusAssign.kt")
            public void testSuspendOperatorPlusAssign() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/featureIntersection/suspendOperatorPlusAssign.kt");
            }

            @Test
            @TestMetadata("suspendOperatorPlusCallFromLambda.kt")
            public void testSuspendOperatorPlusCallFromLambda() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/featureIntersection/suspendOperatorPlusCallFromLambda.kt");
            }

            @Nested
            @TestMetadata("compiler/testData/codegen/box/coroutines/featureIntersection/callableReference")
            @TestDataPath("$PROJECT_ROOT")
            public class CallableReference {
                @Test
                public void testAllFilesPresentInCallableReference() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/featureIntersection/callableReference"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
                }

                @Test
                @TestMetadata("bigArity.kt")
                public void testBigArity() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/featureIntersection/callableReference/bigArity.kt");
                }

                @Test
                @TestMetadata("fromJava.kt")
                public void testFromJava() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/featureIntersection/callableReference/fromJava.kt");
                }

                @Test
                @TestMetadata("kt48732_genericSignature.kt")
                public void testKt48732_genericSignature() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/featureIntersection/callableReference/kt48732_genericSignature.kt");
                }

                @Test
                @TestMetadata("lambdaParameterUsed.kt")
                public void testLambdaParameterUsed() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/featureIntersection/callableReference/lambdaParameterUsed.kt");
                }

                @Test
                @TestMetadata("longArgs.kt")
                public void testLongArgs() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/featureIntersection/callableReference/longArgs.kt");
                }

                @Nested
                @TestMetadata("compiler/testData/codegen/box/coroutines/featureIntersection/callableReference/bound")
                @TestDataPath("$PROJECT_ROOT")
                public class Bound {
                    @Test
                    public void testAllFilesPresentInBound() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/featureIntersection/callableReference/bound"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
                    }

                    @Test
                    @TestMetadata("emptyLHS.kt")
                    public void testEmptyLHS() throws Exception {
                        runTest("compiler/testData/codegen/box/coroutines/featureIntersection/callableReference/bound/emptyLHS.kt");
                    }
                }

                @Nested
                @TestMetadata("compiler/testData/codegen/box/coroutines/featureIntersection/callableReference/function")
                @TestDataPath("$PROJECT_ROOT")
                public class Function {
                    @Test
                    @TestMetadata("adapted.kt")
                    public void testAdapted() throws Exception {
                        runTest("compiler/testData/codegen/box/coroutines/featureIntersection/callableReference/function/adapted.kt");
                    }

                    @Test
                    public void testAllFilesPresentInFunction() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/featureIntersection/callableReference/function"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
                    }

                    @Test
                    @TestMetadata("genericCallableReferenceArguments.kt")
                    public void testGenericCallableReferenceArguments() throws Exception {
                        runTest("compiler/testData/codegen/box/coroutines/featureIntersection/callableReference/function/genericCallableReferenceArguments.kt");
                    }

                    @Test
                    @TestMetadata("genericCallableReferencesWithNullableTypes.kt")
                    public void testGenericCallableReferencesWithNullableTypes() throws Exception {
                        runTest("compiler/testData/codegen/box/coroutines/featureIntersection/callableReference/function/genericCallableReferencesWithNullableTypes.kt");
                    }

                    @Test
                    @TestMetadata("getArityViaFunctionImpl.kt")
                    public void testGetArityViaFunctionImpl() throws Exception {
                        runTest("compiler/testData/codegen/box/coroutines/featureIntersection/callableReference/function/getArityViaFunctionImpl.kt");
                    }

                    @Nested
                    @TestMetadata("compiler/testData/codegen/box/coroutines/featureIntersection/callableReference/function/local")
                    @TestDataPath("$PROJECT_ROOT")
                    public class Local {
                        @Test
                        public void testAllFilesPresentInLocal() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/featureIntersection/callableReference/function/local"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
                        }

                        @Test
                        @TestMetadata("equalsHashCode.kt")
                        public void testEqualsHashCode() throws Exception {
                            runTest("compiler/testData/codegen/box/coroutines/featureIntersection/callableReference/function/local/equalsHashCode.kt");
                        }
                    }
                }
            }

            @Nested
            @TestMetadata("compiler/testData/codegen/box/coroutines/featureIntersection/funInterface")
            @TestDataPath("$PROJECT_ROOT")
            public class FunInterface {
                @Test
                public void testAllFilesPresentInFunInterface() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/featureIntersection/funInterface"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
                }

                @Test
                @TestMetadata("kt47549.kt")
                public void testKt47549() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/featureIntersection/funInterface/kt47549.kt");
                }

                @Test
                @TestMetadata("kt47549_1.kt")
                public void testKt47549_1() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/featureIntersection/funInterface/kt47549_1.kt");
                }

                @Test
                @TestMetadata("kt49294.kt")
                public void testKt49294() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/featureIntersection/funInterface/kt49294.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/testData/codegen/box/coroutines/featureIntersection/jvmDefault")
            @TestDataPath("$PROJECT_ROOT")
            public class JvmDefault {
                @Test
                @TestMetadata("all.kt")
                public void testAll() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/featureIntersection/jvmDefault/all.kt");
                }

                @Test
                public void testAllFilesPresentInJvmDefault() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/featureIntersection/jvmDefault"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
                }

                @Nested
                @TestMetadata("compiler/testData/codegen/box/coroutines/featureIntersection/jvmDefault/kt46007")
                @TestDataPath("$PROJECT_ROOT")
                public class Kt46007 {
                    @Test
                    @TestMetadata("all.kt")
                    public void testAll() throws Exception {
                        runTest("compiler/testData/codegen/box/coroutines/featureIntersection/jvmDefault/kt46007/all.kt");
                    }

                    @Test
                    public void testAllFilesPresentInKt46007() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/featureIntersection/jvmDefault/kt46007"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
                    }

                    @Test
                    @TestMetadata("all-compatibility.kt")
                    public void testAll_compatibility() throws Exception {
                        runTest("compiler/testData/codegen/box/coroutines/featureIntersection/jvmDefault/kt46007/all-compatibility.kt");
                    }

                    @Test
                    @TestMetadata("disable.kt")
                    public void testDisable() throws Exception {
                        runTest("compiler/testData/codegen/box/coroutines/featureIntersection/jvmDefault/kt46007/disable.kt");
                    }

                    @Test
                    @TestMetadata("enable.kt")
                    public void testEnable() throws Exception {
                        runTest("compiler/testData/codegen/box/coroutines/featureIntersection/jvmDefault/kt46007/enable.kt");
                    }
                }
            }

            @Nested
            @TestMetadata("compiler/testData/codegen/box/coroutines/featureIntersection/tailrec")
            @TestDataPath("$PROJECT_ROOT")
            public class Tailrec {
                @Test
                public void testAllFilesPresentInTailrec() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/featureIntersection/tailrec"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
                }

                @Test
                @TestMetadata("controlFlowIf.kt")
                public void testControlFlowIf() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/featureIntersection/tailrec/controlFlowIf.kt");
                }

                @Test
                @TestMetadata("controlFlowWhen.kt")
                public void testControlFlowWhen() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/featureIntersection/tailrec/controlFlowWhen.kt");
                }

                @Test
                @TestMetadata("extention.kt")
                public void testExtention() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/featureIntersection/tailrec/extention.kt");
                }

                @Test
                @TestMetadata("infixCall.kt")
                public void testInfixCall() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/featureIntersection/tailrec/infixCall.kt");
                }

                @Test
                @TestMetadata("infixRecursiveCall.kt")
                public void testInfixRecursiveCall() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/featureIntersection/tailrec/infixRecursiveCall.kt");
                }

                @Test
                @TestMetadata("kt38920_localTailrec.kt")
                public void testKt38920_localTailrec() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/featureIntersection/tailrec/kt38920_localTailrec.kt");
                }

                @Test
                @TestMetadata("realIteratorFoldl.kt")
                public void testRealIteratorFoldl() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/featureIntersection/tailrec/realIteratorFoldl.kt");
                }

                @Test
                @TestMetadata("realStringEscape.kt")
                public void testRealStringEscape() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/featureIntersection/tailrec/realStringEscape.kt");
                }

                @Test
                @TestMetadata("realStringRepeat.kt")
                public void testRealStringRepeat() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/featureIntersection/tailrec/realStringRepeat.kt");
                }

                @Test
                @TestMetadata("returnInParentheses.kt")
                public void testReturnInParentheses() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/featureIntersection/tailrec/returnInParentheses.kt");
                }

                @Test
                @TestMetadata("sum.kt")
                public void testSum() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/featureIntersection/tailrec/sum.kt");
                }

                @Test
                @TestMetadata("tailCallInBlockInParentheses.kt")
                public void testTailCallInBlockInParentheses() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/featureIntersection/tailrec/tailCallInBlockInParentheses.kt");
                }

                @Test
                @TestMetadata("tailCallInParentheses.kt")
                public void testTailCallInParentheses() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/featureIntersection/tailrec/tailCallInParentheses.kt");
                }

                @Test
                @TestMetadata("whenWithIs.kt")
                public void testWhenWithIs() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/featureIntersection/tailrec/whenWithIs.kt");
                }
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/box/coroutines/inlineClasses")
        @TestDataPath("$PROJECT_ROOT")
        public class InlineClasses {
            @Test
            public void testAllFilesPresentInInlineClasses() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/inlineClasses"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("genericParameterResult.kt")
            public void testGenericParameterResult() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/inlineClasses/genericParameterResult.kt");
            }

            @Test
            @TestMetadata("kt47129.kt")
            public void testKt47129() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/inlineClasses/kt47129.kt");
            }

            @Test
            @TestMetadata("nonLocalReturn.kt")
            public void testNonLocalReturn() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/inlineClasses/nonLocalReturn.kt");
            }

            @Nested
            @TestMetadata("compiler/testData/codegen/box/coroutines/inlineClasses/direct")
            @TestDataPath("$PROJECT_ROOT")
            public class Direct {
                @Test
                public void testAllFilesPresentInDirect() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/inlineClasses/direct"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
                }

                @Test
                @TestMetadata("boxReturnValueOfSuspendFunctionReference.kt")
                public void testBoxReturnValueOfSuspendFunctionReference() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/boxReturnValueOfSuspendFunctionReference.kt");
                }

                @Test
                @TestMetadata("boxReturnValueOfSuspendLambda.kt")
                public void testBoxReturnValueOfSuspendLambda() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/boxReturnValueOfSuspendLambda.kt");
                }

                @Test
                @TestMetadata("boxTypeParameterOfSuperType.kt")
                public void testBoxTypeParameterOfSuperType() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/boxTypeParameterOfSuperType.kt");
                }

                @Test
                @TestMetadata("boxTypeParameterOfSuperTypeResult.kt")
                public void testBoxTypeParameterOfSuperTypeResult() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/boxTypeParameterOfSuperTypeResult.kt");
                }

                @Test
                @TestMetadata("boxUnboxInsideCoroutine.kt")
                public void testBoxUnboxInsideCoroutine() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/boxUnboxInsideCoroutine.kt");
                }

                @Test
                @TestMetadata("boxUnboxInsideCoroutine_Any.kt")
                public void testBoxUnboxInsideCoroutine_Any() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/boxUnboxInsideCoroutine_Any.kt");
                }

                @Test
                @TestMetadata("boxUnboxInsideCoroutine_InlineAny.kt")
                public void testBoxUnboxInsideCoroutine_InlineAny() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/boxUnboxInsideCoroutine_InlineAny.kt");
                }

                @Test
                @TestMetadata("boxUnboxInsideCoroutine_InlineInt.kt")
                public void testBoxUnboxInsideCoroutine_InlineInt() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/boxUnboxInsideCoroutine_InlineInt.kt");
                }

                @Test
                @TestMetadata("boxUnboxInsideCoroutine_Int.kt")
                public void testBoxUnboxInsideCoroutine_Int() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/boxUnboxInsideCoroutine_Int.kt");
                }

                @Test
                @TestMetadata("boxUnboxInsideCoroutine_Long.kt")
                public void testBoxUnboxInsideCoroutine_Long() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/boxUnboxInsideCoroutine_Long.kt");
                }

                @Test
                @TestMetadata("boxUnboxInsideCoroutine_NAny.kt")
                public void testBoxUnboxInsideCoroutine_NAny() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/boxUnboxInsideCoroutine_NAny.kt");
                }

                @Test
                @TestMetadata("boxUnboxInsideCoroutine_nonLocalReturn.kt")
                public void testBoxUnboxInsideCoroutine_nonLocalReturn() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/boxUnboxInsideCoroutine_nonLocalReturn.kt");
                }

                @Test
                @TestMetadata("boxUnboxInsideCoroutine_suspendFunType.kt")
                public void testBoxUnboxInsideCoroutine_suspendFunType() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/boxUnboxInsideCoroutine_suspendFunType.kt");
                }

                @Test
                @TestMetadata("bridgeGenerationCrossinline.kt")
                public void testBridgeGenerationCrossinline() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/bridgeGenerationCrossinline.kt");
                }

                @Test
                @TestMetadata("bridgeGenerationNonInline.kt")
                public void testBridgeGenerationNonInline() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/bridgeGenerationNonInline.kt");
                }

                @Test
                @TestMetadata("covariantOverrideSuspendFun.kt")
                public void testCovariantOverrideSuspendFun() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/covariantOverrideSuspendFun.kt");
                }

                @Test
                @TestMetadata("covariantOverrideSuspendFunSameJvmType.kt")
                public void testCovariantOverrideSuspendFunSameJvmType() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/covariantOverrideSuspendFunSameJvmType.kt");
                }

                @Test
                @TestMetadata("covariantOverrideSuspendFunWithNullableInlineClass.kt")
                public void testCovariantOverrideSuspendFunWithNullableInlineClass() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/covariantOverrideSuspendFunWithNullableInlineClass.kt");
                }

                @Test
                @TestMetadata("covariantOverrideSuspendFunWithNullableInlineClassSameJvmType.kt")
                public void testCovariantOverrideSuspendFunWithNullableInlineClassSameJvmType() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/covariantOverrideSuspendFunWithNullableInlineClassSameJvmType.kt");
                }

                @Test
                @TestMetadata("covariantOverrideSuspendFunWithNullableInlineClass_Any.kt")
                public void testCovariantOverrideSuspendFunWithNullableInlineClass_Any() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/covariantOverrideSuspendFunWithNullableInlineClass_Any.kt");
                }

                @Test
                @TestMetadata("covariantOverrideSuspendFunWithNullableInlineClass_Int.kt")
                public void testCovariantOverrideSuspendFunWithNullableInlineClass_Int() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/covariantOverrideSuspendFunWithNullableInlineClass_Int.kt");
                }

                @Test
                @TestMetadata("covariantOverrideSuspendFunWithNullableInlineClass_NullableAny.kt")
                public void testCovariantOverrideSuspendFunWithNullableInlineClass_NullableAny() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/covariantOverrideSuspendFunWithNullableInlineClass_NullableAny.kt");
                }

                @Test
                @TestMetadata("covariantOverrideSuspendFunWithNullableInlineClass_NullableAny_null.kt")
                public void testCovariantOverrideSuspendFunWithNullableInlineClass_NullableAny_null() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/covariantOverrideSuspendFunWithNullableInlineClass_NullableAny_null.kt");
                }

                @Test
                @TestMetadata("covariantOverrideSuspendFunWithNullableInlineClass_NullableInt.kt")
                public void testCovariantOverrideSuspendFunWithNullableInlineClass_NullableInt() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/covariantOverrideSuspendFunWithNullableInlineClass_NullableInt.kt");
                }

                @Test
                @TestMetadata("covariantOverrideSuspendFunWithNullableInlineClass_NullableInt_null.kt")
                public void testCovariantOverrideSuspendFunWithNullableInlineClass_NullableInt_null() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/covariantOverrideSuspendFunWithNullableInlineClass_NullableInt_null.kt");
                }

                @Test
                @TestMetadata("covariantOverrideSuspendFun_Any.kt")
                public void testCovariantOverrideSuspendFun_Any() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/covariantOverrideSuspendFun_Any.kt");
                }

                @Test
                @TestMetadata("covariantOverrideSuspendFun_Int.kt")
                public void testCovariantOverrideSuspendFun_Int() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/covariantOverrideSuspendFun_Int.kt");
                }

                @Test
                @TestMetadata("createMangling.kt")
                public void testCreateMangling() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/createMangling.kt");
                }

                @Test
                @TestMetadata("createOverride.kt")
                public void testCreateOverride() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/createOverride.kt");
                }

                @Test
                @TestMetadata("defaultStub.kt")
                public void testDefaultStub() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/defaultStub.kt");
                }

                @Test
                @TestMetadata("genericOverrideSuspendFun.kt")
                public void testGenericOverrideSuspendFun() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/genericOverrideSuspendFun.kt");
                }

                @Test
                @TestMetadata("genericOverrideSuspendFun_Any.kt")
                public void testGenericOverrideSuspendFun_Any() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/genericOverrideSuspendFun_Any.kt");
                }

                @Test
                @TestMetadata("genericOverrideSuspendFun_Any_NullableInlineClassUpperBound.kt")
                public void testGenericOverrideSuspendFun_Any_NullableInlineClassUpperBound() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/genericOverrideSuspendFun_Any_NullableInlineClassUpperBound.kt");
                }

                @Test
                @TestMetadata("genericOverrideSuspendFun_Int.kt")
                public void testGenericOverrideSuspendFun_Int() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/genericOverrideSuspendFun_Int.kt");
                }

                @Test
                @TestMetadata("genericOverrideSuspendFun_NullableAny.kt")
                public void testGenericOverrideSuspendFun_NullableAny() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/genericOverrideSuspendFun_NullableAny.kt");
                }

                @Test
                @TestMetadata("genericOverrideSuspendFun_NullableAny_null.kt")
                public void testGenericOverrideSuspendFun_NullableAny_null() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/genericOverrideSuspendFun_NullableAny_null.kt");
                }

                @Test
                @TestMetadata("genericOverrideSuspendFun_NullableInt.kt")
                public void testGenericOverrideSuspendFun_NullableInt() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/genericOverrideSuspendFun_NullableInt.kt");
                }

                @Test
                @TestMetadata("genericOverrideSuspendFun_NullableInt_null.kt")
                public void testGenericOverrideSuspendFun_NullableInt_null() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/genericOverrideSuspendFun_NullableInt_null.kt");
                }

                @Test
                @TestMetadata("interfaceDelegateWithInlineClass.kt")
                public void testInterfaceDelegateWithInlineClass() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/interfaceDelegateWithInlineClass.kt");
                }

                @Test
                @TestMetadata("invokeOperator.kt")
                public void testInvokeOperator() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/invokeOperator.kt");
                }

                @Test
                @TestMetadata("multifileBridge.kt")
                public void testMultifileBridge() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/multifileBridge.kt");
                }

                @Test
                @TestMetadata("overrideSuspendFun.kt")
                public void testOverrideSuspendFun() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/overrideSuspendFun.kt");
                }

                @Test
                @TestMetadata("overrideSuspendFun_Any.kt")
                public void testOverrideSuspendFun_Any() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/overrideSuspendFun_Any.kt");
                }

                @Test
                @TestMetadata("overrideSuspendFun_Any_itf.kt")
                public void testOverrideSuspendFun_Any_itf() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/overrideSuspendFun_Any_itf.kt");
                }

                @Test
                @TestMetadata("overrideSuspendFun_Any_this.kt")
                public void testOverrideSuspendFun_Any_this() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/overrideSuspendFun_Any_this.kt");
                }

                @Test
                @TestMetadata("overrideSuspendFun_Int.kt")
                public void testOverrideSuspendFun_Int() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/overrideSuspendFun_Int.kt");
                }

                @Test
                @TestMetadata("returnResult.kt")
                public void testReturnResult() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/returnResult.kt");
                }

                @Test
                @TestMetadata("syntheticAccessor.kt")
                public void testSyntheticAccessor() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/direct/syntheticAccessor.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/testData/codegen/box/coroutines/inlineClasses/resume")
            @TestDataPath("$PROJECT_ROOT")
            public class Resume {
                @Test
                public void testAllFilesPresentInResume() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/inlineClasses/resume"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
                }

                @Test
                @TestMetadata("boxReturnValueOfSuspendFunctionReference.kt")
                public void testBoxReturnValueOfSuspendFunctionReference() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/boxReturnValueOfSuspendFunctionReference.kt");
                }

                @Test
                @TestMetadata("boxReturnValueOfSuspendLambda.kt")
                public void testBoxReturnValueOfSuspendLambda() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/boxReturnValueOfSuspendLambda.kt");
                }

                @Test
                @TestMetadata("boxTypeParameterOfSuperType.kt")
                public void testBoxTypeParameterOfSuperType() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/boxTypeParameterOfSuperType.kt");
                }

                @Test
                @TestMetadata("boxTypeParameterOfSuperTypeResult.kt")
                public void testBoxTypeParameterOfSuperTypeResult() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/boxTypeParameterOfSuperTypeResult.kt");
                }

                @Test
                @TestMetadata("boxUnboxInsideCoroutine.kt")
                public void testBoxUnboxInsideCoroutine() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/boxUnboxInsideCoroutine.kt");
                }

                @Test
                @TestMetadata("boxUnboxInsideCoroutine_Any.kt")
                public void testBoxUnboxInsideCoroutine_Any() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/boxUnboxInsideCoroutine_Any.kt");
                }

                @Test
                @TestMetadata("boxUnboxInsideCoroutine_InlineAny.kt")
                public void testBoxUnboxInsideCoroutine_InlineAny() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/boxUnboxInsideCoroutine_InlineAny.kt");
                }

                @Test
                @TestMetadata("boxUnboxInsideCoroutine_InlineInt.kt")
                public void testBoxUnboxInsideCoroutine_InlineInt() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/boxUnboxInsideCoroutine_InlineInt.kt");
                }

                @Test
                @TestMetadata("boxUnboxInsideCoroutine_Int.kt")
                public void testBoxUnboxInsideCoroutine_Int() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/boxUnboxInsideCoroutine_Int.kt");
                }

                @Test
                @TestMetadata("boxUnboxInsideCoroutine_Long.kt")
                public void testBoxUnboxInsideCoroutine_Long() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/boxUnboxInsideCoroutine_Long.kt");
                }

                @Test
                @TestMetadata("boxUnboxInsideCoroutine_NAny.kt")
                public void testBoxUnboxInsideCoroutine_NAny() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/boxUnboxInsideCoroutine_NAny.kt");
                }

                @Test
                @TestMetadata("boxUnboxInsideCoroutine_nonLocalReturn.kt")
                public void testBoxUnboxInsideCoroutine_nonLocalReturn() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/boxUnboxInsideCoroutine_nonLocalReturn.kt");
                }

                @Test
                @TestMetadata("boxUnboxInsideCoroutine_suspendFunType.kt")
                public void testBoxUnboxInsideCoroutine_suspendFunType() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/boxUnboxInsideCoroutine_suspendFunType.kt");
                }

                @Test
                @TestMetadata("bridgeGenerationCrossinline.kt")
                public void testBridgeGenerationCrossinline() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/bridgeGenerationCrossinline.kt");
                }

                @Test
                @TestMetadata("bridgeGenerationNonInline.kt")
                public void testBridgeGenerationNonInline() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/bridgeGenerationNonInline.kt");
                }

                @Test
                @TestMetadata("covariantOverrideSuspendFun.kt")
                public void testCovariantOverrideSuspendFun() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/covariantOverrideSuspendFun.kt");
                }

                @Test
                @TestMetadata("covariantOverrideSuspendFunSameJvmType.kt")
                public void testCovariantOverrideSuspendFunSameJvmType() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/covariantOverrideSuspendFunSameJvmType.kt");
                }

                @Test
                @TestMetadata("covariantOverrideSuspendFunWithNullableInlineClass.kt")
                public void testCovariantOverrideSuspendFunWithNullableInlineClass() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/covariantOverrideSuspendFunWithNullableInlineClass.kt");
                }

                @Test
                @TestMetadata("covariantOverrideSuspendFunWithNullableInlineClassSameJvmType.kt")
                public void testCovariantOverrideSuspendFunWithNullableInlineClassSameJvmType() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/covariantOverrideSuspendFunWithNullableInlineClassSameJvmType.kt");
                }

                @Test
                @TestMetadata("covariantOverrideSuspendFunWithNullableInlineClass_Any.kt")
                public void testCovariantOverrideSuspendFunWithNullableInlineClass_Any() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/covariantOverrideSuspendFunWithNullableInlineClass_Any.kt");
                }

                @Test
                @TestMetadata("covariantOverrideSuspendFunWithNullableInlineClass_Int.kt")
                public void testCovariantOverrideSuspendFunWithNullableInlineClass_Int() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/covariantOverrideSuspendFunWithNullableInlineClass_Int.kt");
                }

                @Test
                @TestMetadata("covariantOverrideSuspendFunWithNullableInlineClass_NullableAny.kt")
                public void testCovariantOverrideSuspendFunWithNullableInlineClass_NullableAny() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/covariantOverrideSuspendFunWithNullableInlineClass_NullableAny.kt");
                }

                @Test
                @TestMetadata("covariantOverrideSuspendFunWithNullableInlineClass_NullableAny_null.kt")
                public void testCovariantOverrideSuspendFunWithNullableInlineClass_NullableAny_null() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/covariantOverrideSuspendFunWithNullableInlineClass_NullableAny_null.kt");
                }

                @Test
                @TestMetadata("covariantOverrideSuspendFunWithNullableInlineClass_NullableInt.kt")
                public void testCovariantOverrideSuspendFunWithNullableInlineClass_NullableInt() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/covariantOverrideSuspendFunWithNullableInlineClass_NullableInt.kt");
                }

                @Test
                @TestMetadata("covariantOverrideSuspendFunWithNullableInlineClass_NullableInt_null.kt")
                public void testCovariantOverrideSuspendFunWithNullableInlineClass_NullableInt_null() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/covariantOverrideSuspendFunWithNullableInlineClass_NullableInt_null.kt");
                }

                @Test
                @TestMetadata("covariantOverrideSuspendFun_Any.kt")
                public void testCovariantOverrideSuspendFun_Any() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/covariantOverrideSuspendFun_Any.kt");
                }

                @Test
                @TestMetadata("covariantOverrideSuspendFun_Int.kt")
                public void testCovariantOverrideSuspendFun_Int() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/covariantOverrideSuspendFun_Int.kt");
                }

                @Test
                @TestMetadata("createMangling.kt")
                public void testCreateMangling() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/createMangling.kt");
                }

                @Test
                @TestMetadata("createOverride.kt")
                public void testCreateOverride() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/createOverride.kt");
                }

                @Test
                @TestMetadata("defaultStub.kt")
                public void testDefaultStub() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/defaultStub.kt");
                }

                @Test
                @TestMetadata("genericOverrideSuspendFun.kt")
                public void testGenericOverrideSuspendFun() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/genericOverrideSuspendFun.kt");
                }

                @Test
                @TestMetadata("genericOverrideSuspendFun_Any.kt")
                public void testGenericOverrideSuspendFun_Any() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/genericOverrideSuspendFun_Any.kt");
                }

                @Test
                @TestMetadata("genericOverrideSuspendFun_Any_NullableInlineClassUpperBound.kt")
                public void testGenericOverrideSuspendFun_Any_NullableInlineClassUpperBound() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/genericOverrideSuspendFun_Any_NullableInlineClassUpperBound.kt");
                }

                @Test
                @TestMetadata("genericOverrideSuspendFun_Int.kt")
                public void testGenericOverrideSuspendFun_Int() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/genericOverrideSuspendFun_Int.kt");
                }

                @Test
                @TestMetadata("genericOverrideSuspendFun_NullableAny.kt")
                public void testGenericOverrideSuspendFun_NullableAny() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/genericOverrideSuspendFun_NullableAny.kt");
                }

                @Test
                @TestMetadata("genericOverrideSuspendFun_NullableAny_null.kt")
                public void testGenericOverrideSuspendFun_NullableAny_null() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/genericOverrideSuspendFun_NullableAny_null.kt");
                }

                @Test
                @TestMetadata("genericOverrideSuspendFun_NullableInt.kt")
                public void testGenericOverrideSuspendFun_NullableInt() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/genericOverrideSuspendFun_NullableInt.kt");
                }

                @Test
                @TestMetadata("genericOverrideSuspendFun_NullableInt_null.kt")
                public void testGenericOverrideSuspendFun_NullableInt_null() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/genericOverrideSuspendFun_NullableInt_null.kt");
                }

                @Test
                @TestMetadata("interfaceDelegateWithInlineClass.kt")
                public void testInterfaceDelegateWithInlineClass() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/interfaceDelegateWithInlineClass.kt");
                }

                @Test
                @TestMetadata("invokeOperator.kt")
                public void testInvokeOperator() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/invokeOperator.kt");
                }

                @Test
                @TestMetadata("multifileBridge.kt")
                public void testMultifileBridge() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/multifileBridge.kt");
                }

                @Test
                @TestMetadata("overrideSuspendFun.kt")
                public void testOverrideSuspendFun() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/overrideSuspendFun.kt");
                }

                @Test
                @TestMetadata("overrideSuspendFun_Any.kt")
                public void testOverrideSuspendFun_Any() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/overrideSuspendFun_Any.kt");
                }

                @Test
                @TestMetadata("overrideSuspendFun_Any_itf.kt")
                public void testOverrideSuspendFun_Any_itf() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/overrideSuspendFun_Any_itf.kt");
                }

                @Test
                @TestMetadata("overrideSuspendFun_Any_this.kt")
                public void testOverrideSuspendFun_Any_this() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/overrideSuspendFun_Any_this.kt");
                }

                @Test
                @TestMetadata("overrideSuspendFun_Int.kt")
                public void testOverrideSuspendFun_Int() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/overrideSuspendFun_Int.kt");
                }

                @Test
                @TestMetadata("returnResult.kt")
                public void testReturnResult() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/returnResult.kt");
                }

                @Test
                @TestMetadata("syntheticAccessor.kt")
                public void testSyntheticAccessor() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resume/syntheticAccessor.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException")
            @TestDataPath("$PROJECT_ROOT")
            public class ResumeWithException {
                @Test
                public void testAllFilesPresentInResumeWithException() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
                }

                @Test
                @TestMetadata("boxReturnValueOfSuspendFunctionReference.kt")
                public void testBoxReturnValueOfSuspendFunctionReference() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/boxReturnValueOfSuspendFunctionReference.kt");
                }

                @Test
                @TestMetadata("boxReturnValueOfSuspendLambda.kt")
                public void testBoxReturnValueOfSuspendLambda() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/boxReturnValueOfSuspendLambda.kt");
                }

                @Test
                @TestMetadata("boxTypeParameterOfSuperType.kt")
                public void testBoxTypeParameterOfSuperType() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/boxTypeParameterOfSuperType.kt");
                }

                @Test
                @TestMetadata("boxTypeParameterOfSuperTypeResult.kt")
                public void testBoxTypeParameterOfSuperTypeResult() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/boxTypeParameterOfSuperTypeResult.kt");
                }

                @Test
                @TestMetadata("boxUnboxInsideCoroutine.kt")
                public void testBoxUnboxInsideCoroutine() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/boxUnboxInsideCoroutine.kt");
                }

                @Test
                @TestMetadata("boxUnboxInsideCoroutine_Any.kt")
                public void testBoxUnboxInsideCoroutine_Any() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/boxUnboxInsideCoroutine_Any.kt");
                }

                @Test
                @TestMetadata("boxUnboxInsideCoroutine_InlineAny.kt")
                public void testBoxUnboxInsideCoroutine_InlineAny() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/boxUnboxInsideCoroutine_InlineAny.kt");
                }

                @Test
                @TestMetadata("boxUnboxInsideCoroutine_InlineInt.kt")
                public void testBoxUnboxInsideCoroutine_InlineInt() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/boxUnboxInsideCoroutine_InlineInt.kt");
                }

                @Test
                @TestMetadata("boxUnboxInsideCoroutine_Int.kt")
                public void testBoxUnboxInsideCoroutine_Int() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/boxUnboxInsideCoroutine_Int.kt");
                }

                @Test
                @TestMetadata("boxUnboxInsideCoroutine_Long.kt")
                public void testBoxUnboxInsideCoroutine_Long() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/boxUnboxInsideCoroutine_Long.kt");
                }

                @Test
                @TestMetadata("boxUnboxInsideCoroutine_NAny.kt")
                public void testBoxUnboxInsideCoroutine_NAny() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/boxUnboxInsideCoroutine_NAny.kt");
                }

                @Test
                @TestMetadata("boxUnboxInsideCoroutine_nonLocalReturn.kt")
                public void testBoxUnboxInsideCoroutine_nonLocalReturn() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/boxUnboxInsideCoroutine_nonLocalReturn.kt");
                }

                @Test
                @TestMetadata("boxUnboxInsideCoroutine_suspendFunType.kt")
                public void testBoxUnboxInsideCoroutine_suspendFunType() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/boxUnboxInsideCoroutine_suspendFunType.kt");
                }

                @Test
                @TestMetadata("bridgeGenerationCrossinline.kt")
                public void testBridgeGenerationCrossinline() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/bridgeGenerationCrossinline.kt");
                }

                @Test
                @TestMetadata("bridgeGenerationNonInline.kt")
                public void testBridgeGenerationNonInline() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/bridgeGenerationNonInline.kt");
                }

                @Test
                @TestMetadata("covariantOverrideSuspendFun.kt")
                public void testCovariantOverrideSuspendFun() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/covariantOverrideSuspendFun.kt");
                }

                @Test
                @TestMetadata("covariantOverrideSuspendFunSameJvmType.kt")
                public void testCovariantOverrideSuspendFunSameJvmType() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/covariantOverrideSuspendFunSameJvmType.kt");
                }

                @Test
                @TestMetadata("covariantOverrideSuspendFunWithNullableInlineClass.kt")
                public void testCovariantOverrideSuspendFunWithNullableInlineClass() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/covariantOverrideSuspendFunWithNullableInlineClass.kt");
                }

                @Test
                @TestMetadata("covariantOverrideSuspendFunWithNullableInlineClassSameJvmType.kt")
                public void testCovariantOverrideSuspendFunWithNullableInlineClassSameJvmType() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/covariantOverrideSuspendFunWithNullableInlineClassSameJvmType.kt");
                }

                @Test
                @TestMetadata("covariantOverrideSuspendFunWithNullableInlineClass_Any.kt")
                public void testCovariantOverrideSuspendFunWithNullableInlineClass_Any() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/covariantOverrideSuspendFunWithNullableInlineClass_Any.kt");
                }

                @Test
                @TestMetadata("covariantOverrideSuspendFunWithNullableInlineClass_Int.kt")
                public void testCovariantOverrideSuspendFunWithNullableInlineClass_Int() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/covariantOverrideSuspendFunWithNullableInlineClass_Int.kt");
                }

                @Test
                @TestMetadata("covariantOverrideSuspendFunWithNullableInlineClass_NullableAny.kt")
                public void testCovariantOverrideSuspendFunWithNullableInlineClass_NullableAny() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/covariantOverrideSuspendFunWithNullableInlineClass_NullableAny.kt");
                }

                @Test
                @TestMetadata("covariantOverrideSuspendFunWithNullableInlineClass_NullableAny_null.kt")
                public void testCovariantOverrideSuspendFunWithNullableInlineClass_NullableAny_null() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/covariantOverrideSuspendFunWithNullableInlineClass_NullableAny_null.kt");
                }

                @Test
                @TestMetadata("covariantOverrideSuspendFunWithNullableInlineClass_NullableInt.kt")
                public void testCovariantOverrideSuspendFunWithNullableInlineClass_NullableInt() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/covariantOverrideSuspendFunWithNullableInlineClass_NullableInt.kt");
                }

                @Test
                @TestMetadata("covariantOverrideSuspendFun_Any.kt")
                public void testCovariantOverrideSuspendFun_Any() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/covariantOverrideSuspendFun_Any.kt");
                }

                @Test
                @TestMetadata("covariantOverrideSuspendFun_Int.kt")
                public void testCovariantOverrideSuspendFun_Int() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/covariantOverrideSuspendFun_Int.kt");
                }

                @Test
                @TestMetadata("createMangling.kt")
                public void testCreateMangling() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/createMangling.kt");
                }

                @Test
                @TestMetadata("createOverride.kt")
                public void testCreateOverride() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/createOverride.kt");
                }

                @Test
                @TestMetadata("genericOverrideSuspendFun.kt")
                public void testGenericOverrideSuspendFun() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/genericOverrideSuspendFun.kt");
                }

                @Test
                @TestMetadata("genericOverrideSuspendFun_Any.kt")
                public void testGenericOverrideSuspendFun_Any() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/genericOverrideSuspendFun_Any.kt");
                }

                @Test
                @TestMetadata("genericOverrideSuspendFun_Any_NullableInlineClassUpperBound.kt")
                public void testGenericOverrideSuspendFun_Any_NullableInlineClassUpperBound() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/genericOverrideSuspendFun_Any_NullableInlineClassUpperBound.kt");
                }

                @Test
                @TestMetadata("genericOverrideSuspendFun_Int.kt")
                public void testGenericOverrideSuspendFun_Int() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/genericOverrideSuspendFun_Int.kt");
                }

                @Test
                @TestMetadata("genericOverrideSuspendFun_NullableAny.kt")
                public void testGenericOverrideSuspendFun_NullableAny() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/genericOverrideSuspendFun_NullableAny.kt");
                }

                @Test
                @TestMetadata("genericOverrideSuspendFun_NullableInt.kt")
                public void testGenericOverrideSuspendFun_NullableInt() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/genericOverrideSuspendFun_NullableInt.kt");
                }

                @Test
                @TestMetadata("interfaceDelegateWithInlineClass.kt")
                public void testInterfaceDelegateWithInlineClass() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/interfaceDelegateWithInlineClass.kt");
                }

                @Test
                @TestMetadata("invokeOperator.kt")
                public void testInvokeOperator() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/invokeOperator.kt");
                }

                @Test
                @TestMetadata("overrideSuspendFun.kt")
                public void testOverrideSuspendFun() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/overrideSuspendFun.kt");
                }

                @Test
                @TestMetadata("overrideSuspendFun_Any.kt")
                public void testOverrideSuspendFun_Any() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/overrideSuspendFun_Any.kt");
                }

                @Test
                @TestMetadata("overrideSuspendFun_Any_itf.kt")
                public void testOverrideSuspendFun_Any_itf() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/overrideSuspendFun_Any_itf.kt");
                }

                @Test
                @TestMetadata("overrideSuspendFun_Any_this.kt")
                public void testOverrideSuspendFun_Any_this() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/overrideSuspendFun_Any_this.kt");
                }

                @Test
                @TestMetadata("overrideSuspendFun_Int.kt")
                public void testOverrideSuspendFun_Int() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/overrideSuspendFun_Int.kt");
                }

                @Test
                @TestMetadata("returnResult.kt")
                public void testReturnResult() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/inlineClasses/resumeWithException/returnResult.kt");
                }
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/box/coroutines/intLikeVarSpilling")
        @TestDataPath("$PROJECT_ROOT")
        public class IntLikeVarSpilling {
            @Test
            public void testAllFilesPresentInIntLikeVarSpilling() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/intLikeVarSpilling"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("complicatedMerge.kt")
            public void testComplicatedMerge() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/intLikeVarSpilling/complicatedMerge.kt");
            }

            @Test
            @TestMetadata("i2bResult.kt")
            public void testI2bResult() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/intLikeVarSpilling/i2bResult.kt");
            }

            @Test
            @TestMetadata("listThrowablePairInOneSlot.kt")
            public void testListThrowablePairInOneSlot() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/intLikeVarSpilling/listThrowablePairInOneSlot.kt");
            }

            @Test
            @TestMetadata("loadFromBooleanArray.kt")
            public void testLoadFromBooleanArray() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/intLikeVarSpilling/loadFromBooleanArray.kt");
            }

            @Test
            @TestMetadata("loadFromByteArray.kt")
            public void testLoadFromByteArray() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/intLikeVarSpilling/loadFromByteArray.kt");
            }

            @Test
            @TestMetadata("noVariableInTable.kt")
            public void testNoVariableInTable() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/intLikeVarSpilling/noVariableInTable.kt");
            }

            @Test
            @TestMetadata("sameIconst1ManyVars.kt")
            public void testSameIconst1ManyVars() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/intLikeVarSpilling/sameIconst1ManyVars.kt");
            }

            @Test
            @TestMetadata("unusedCatchVar.kt")
            public void testUnusedCatchVar() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/intLikeVarSpilling/unusedCatchVar.kt");
            }

            @Test
            @TestMetadata("usedInArrayStore.kt")
            public void testUsedInArrayStore() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/intLikeVarSpilling/usedInArrayStore.kt");
            }

            @Test
            @TestMetadata("usedInMethodCall.kt")
            public void testUsedInMethodCall() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/intLikeVarSpilling/usedInMethodCall.kt");
            }

            @Test
            @TestMetadata("usedInPutfield.kt")
            public void testUsedInPutfield() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/intLikeVarSpilling/usedInPutfield.kt");
            }

            @Test
            @TestMetadata("usedInVarStore.kt")
            public void testUsedInVarStore() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/intLikeVarSpilling/usedInVarStore.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/box/coroutines/intrinsicSemantics")
        @TestDataPath("$PROJECT_ROOT")
        public class IntrinsicSemantics {
            @Test
            public void testAllFilesPresentInIntrinsicSemantics() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/intrinsicSemantics"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("coroutineContext.kt")
            public void testCoroutineContext() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/intrinsicSemantics/coroutineContext.kt");
            }

            @Test
            @TestMetadata("coroutineContextReceiver.kt")
            public void testCoroutineContextReceiver() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/intrinsicSemantics/coroutineContextReceiver.kt");
            }

            @Test
            @TestMetadata("coroutineContextReceiverNotIntrinsic.kt")
            public void testCoroutineContextReceiverNotIntrinsic() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/intrinsicSemantics/coroutineContextReceiverNotIntrinsic.kt");
            }

            @Test
            @TestMetadata("intercepted.kt")
            public void testIntercepted() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/intrinsicSemantics/intercepted.kt");
            }

            @Test
            @TestMetadata("resultExceptionOrNullInLambda.kt")
            public void testResultExceptionOrNullInLambda() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/intrinsicSemantics/resultExceptionOrNullInLambda.kt");
            }

            @Test
            @TestMetadata("startCoroutine.kt")
            public void testStartCoroutine() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/intrinsicSemantics/startCoroutine.kt");
            }

            @Test
            @TestMetadata("startCoroutineUninterceptedOrReturn.kt")
            public void testStartCoroutineUninterceptedOrReturn() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/intrinsicSemantics/startCoroutineUninterceptedOrReturn.kt");
            }

            @Test
            @TestMetadata("startCoroutineUninterceptedOrReturnInterception.kt")
            public void testStartCoroutineUninterceptedOrReturnInterception() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/intrinsicSemantics/startCoroutineUninterceptedOrReturnInterception.kt");
            }

            @Test
            @TestMetadata("suspendCoroutineUninterceptedOrReturn.kt")
            public void testSuspendCoroutineUninterceptedOrReturn() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/intrinsicSemantics/suspendCoroutineUninterceptedOrReturn.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/box/coroutines/javaInterop")
        @TestDataPath("$PROJECT_ROOT")
        public class JavaInterop {
            @Test
            public void testAllFilesPresentInJavaInterop() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/javaInterop"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("objectWithSeveralSuspends.kt")
            public void testObjectWithSeveralSuspends() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/javaInterop/objectWithSeveralSuspends.kt");
            }

            @Test
            @TestMetadata("returnLambda.kt")
            public void testReturnLambda() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/javaInterop/returnLambda.kt");
            }

            @Test
            @TestMetadata("returnObject.kt")
            public void testReturnObject() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/javaInterop/returnObject.kt");
            }

            @Test
            @TestMetadata("severalCaptures.kt")
            public void testSeveralCaptures() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/javaInterop/severalCaptures.kt");
            }

            @Test
            @TestMetadata("suspendInlineWithCrossinline.kt")
            public void testSuspendInlineWithCrossinline() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/javaInterop/suspendInlineWithCrossinline.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/box/coroutines/localFunctions")
        @TestDataPath("$PROJECT_ROOT")
        public class LocalFunctions {
            @Test
            public void testAllFilesPresentInLocalFunctions() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/localFunctions"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Nested
            @TestMetadata("compiler/testData/codegen/box/coroutines/localFunctions/anonymous")
            @TestDataPath("$PROJECT_ROOT")
            public class Anonymous {
                @Test
                public void testAllFilesPresentInAnonymous() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/localFunctions/anonymous"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
                }

                @Test
                @TestMetadata("simple.kt")
                public void testSimple() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/localFunctions/anonymous/simple.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/testData/codegen/box/coroutines/localFunctions/named")
            @TestDataPath("$PROJECT_ROOT")
            public class Named {
                @Test
                public void testAllFilesPresentInNamed() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/localFunctions/named"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
                }

                @Test
                @TestMetadata("callTopLevelFromLocal.kt")
                public void testCallTopLevelFromLocal() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/localFunctions/named/callTopLevelFromLocal.kt");
                }

                @Test
                @TestMetadata("capturedParameters.kt")
                public void testCapturedParameters() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/localFunctions/named/capturedParameters.kt");
                }

                @Test
                @TestMetadata("capturedVariables.kt")
                public void testCapturedVariables() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/localFunctions/named/capturedVariables.kt");
                }

                @Test
                @TestMetadata("defaultArgument.kt")
                public void testDefaultArgument() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/localFunctions/named/defaultArgument.kt");
                }

                @Test
                @TestMetadata("extension.kt")
                public void testExtension() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/localFunctions/named/extension.kt");
                }

                @Test
                @TestMetadata("infix.kt")
                public void testInfix() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/localFunctions/named/infix.kt");
                }

                @Test
                @TestMetadata("insideLambda.kt")
                public void testInsideLambda() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/localFunctions/named/insideLambda.kt");
                }

                @Test
                @TestMetadata("nestedLocals.kt")
                public void testNestedLocals() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/localFunctions/named/nestedLocals.kt");
                }

                @Test
                @TestMetadata("rec.kt")
                public void testRec() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/localFunctions/named/rec.kt");
                }

                @Test
                @TestMetadata("simple.kt")
                public void testSimple() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/localFunctions/named/simple.kt");
                }

                @Test
                @TestMetadata("simpleSuspensionPoint.kt")
                public void testSimpleSuspensionPoint() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/localFunctions/named/simpleSuspensionPoint.kt");
                }

                @Test
                @TestMetadata("stateMachine.kt")
                public void testStateMachine() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/localFunctions/named/stateMachine.kt");
                }

                @Test
                @TestMetadata("withArguments.kt")
                public void testWithArguments() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/localFunctions/named/withArguments.kt");
                }
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/box/coroutines/multiModule")
        @TestDataPath("$PROJECT_ROOT")
        public class MultiModule {
            @Test
            public void testAllFilesPresentInMultiModule() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/multiModule"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("inlineCrossModule.kt")
            public void testInlineCrossModule() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/multiModule/inlineCrossModule.kt");
            }

            @Test
            @TestMetadata("inlineFunctionWithOptionalParam.kt")
            public void testInlineFunctionWithOptionalParam() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/multiModule/inlineFunctionWithOptionalParam.kt");
            }

            @Test
            @TestMetadata("inlineMultiModule.kt")
            public void testInlineMultiModule() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/multiModule/inlineMultiModule.kt");
            }

            @Test
            @TestMetadata("inlineMultiModuleOverride.kt")
            public void testInlineMultiModuleOverride() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/multiModule/inlineMultiModuleOverride.kt");
            }

            @Test
            @TestMetadata("inlineMultiModuleWithController.kt")
            public void testInlineMultiModuleWithController() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/multiModule/inlineMultiModuleWithController.kt");
            }

            @Test
            @TestMetadata("inlineMultiModuleWithInnerInlining.kt")
            public void testInlineMultiModuleWithInnerInlining() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/multiModule/inlineMultiModuleWithInnerInlining.kt");
            }

            @Test
            @TestMetadata("inlineTailCall.kt")
            public void testInlineTailCall() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/multiModule/inlineTailCall.kt");
            }

            @Test
            @TestMetadata("inlineWithJava.kt")
            public void testInlineWithJava() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/multiModule/inlineWithJava.kt");
            }

            @Test
            @TestMetadata("simple.kt")
            public void testSimple() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/multiModule/simple.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/box/coroutines/redundantLocalsElimination")
        @TestDataPath("$PROJECT_ROOT")
        public class RedundantLocalsElimination {
            @Test
            public void testAllFilesPresentInRedundantLocalsElimination() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/redundantLocalsElimination"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("ktor_receivedMessage.kt")
            public void testKtor_receivedMessage() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/redundantLocalsElimination/ktor_receivedMessage.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/box/coroutines/reflect")
        @TestDataPath("$PROJECT_ROOT")
        public class Reflect {
            @Test
            public void testAllFilesPresentInReflect() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/reflect"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("bigArity.kt")
            public void testBigArity() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/reflect/bigArity.kt");
            }

            @Test
            @TestMetadata("callSuspend.kt")
            public void testCallSuspend() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/reflect/callSuspend.kt");
            }

            @Test
            @TestMetadata("callSuspendBy.kt")
            public void testCallSuspendBy() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/reflect/callSuspendBy.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/box/coroutines/stackUnwinding")
        @TestDataPath("$PROJECT_ROOT")
        public class StackUnwinding {
            @Test
            public void testAllFilesPresentInStackUnwinding() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/stackUnwinding"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("exception.kt")
            public void testException() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/stackUnwinding/exception.kt");
            }

            @Test
            @TestMetadata("inlineSuspendFunction.kt")
            public void testInlineSuspendFunction() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/stackUnwinding/inlineSuspendFunction.kt");
            }

            @Test
            @TestMetadata("rethrowInFinally.kt")
            public void testRethrowInFinally() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/stackUnwinding/rethrowInFinally.kt");
            }

            @Test
            @TestMetadata("rethrowInFinallyWithSuspension.kt")
            public void testRethrowInFinallyWithSuspension() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/stackUnwinding/rethrowInFinallyWithSuspension.kt");
            }

            @Test
            @TestMetadata("simple.kt")
            public void testSimple() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/stackUnwinding/simple.kt");
            }

            @Test
            @TestMetadata("suspendInCycle.kt")
            public void testSuspendInCycle() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/stackUnwinding/suspendInCycle.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/box/coroutines/suspendConversion")
        @TestDataPath("$PROJECT_ROOT")
        public class SuspendConversion {
            @Test
            public void testAllFilesPresentInSuspendConversion() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/suspendConversion"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("intersectionTypeToSubtypeConversion.kt")
            public void testIntersectionTypeToSubtypeConversion() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/suspendConversion/intersectionTypeToSubtypeConversion.kt");
            }

            @Test
            @TestMetadata("onArgument.kt")
            public void testOnArgument() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/suspendConversion/onArgument.kt");
            }

            @Test
            @TestMetadata("onInlineArgument.kt")
            public void testOnInlineArgument() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/suspendConversion/onInlineArgument.kt");
            }

            @Test
            @TestMetadata("subtypeOfFunctionalTypeToSuspendConversion.kt")
            public void testSubtypeOfFunctionalTypeToSuspendConversion() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/suspendConversion/subtypeOfFunctionalTypeToSuspendConversion.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine")
        @TestDataPath("$PROJECT_ROOT")
        public class SuspendFunctionAsCoroutine {
            @Test
            public void testAllFilesPresentInSuspendFunctionAsCoroutine() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("dispatchResume.kt")
            public void testDispatchResume() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/dispatchResume.kt");
            }

            @Test
            @TestMetadata("handleException.kt")
            public void testHandleException() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/handleException.kt");
            }

            @Test
            @TestMetadata("ifExpressionInsideCoroutine_1_3.kt")
            public void testIfExpressionInsideCoroutine_1_3() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/ifExpressionInsideCoroutine_1_3.kt");
            }

            @Test
            @TestMetadata("inline.kt")
            public void testInline() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/inline.kt");
            }

            @Test
            @TestMetadata("inlineTwoReceivers.kt")
            public void testInlineTwoReceivers() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/inlineTwoReceivers.kt");
            }

            @Test
            @TestMetadata("member.kt")
            public void testMember() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/member.kt");
            }

            @Test
            @TestMetadata("noinlineTwoReceivers.kt")
            public void testNoinlineTwoReceivers() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/noinlineTwoReceivers.kt");
            }

            @Test
            @TestMetadata("openFunWithJava.kt")
            public void testOpenFunWithJava() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/openFunWithJava.kt");
            }

            @Test
            @TestMetadata("operators.kt")
            public void testOperators() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/operators.kt");
            }

            @Test
            @TestMetadata("privateFunctions.kt")
            public void testPrivateFunctions() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/privateFunctions.kt");
            }

            @Test
            @TestMetadata("privateInFile.kt")
            public void testPrivateInFile() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/privateInFile.kt");
            }

            @Test
            @TestMetadata("returnNoSuspend.kt")
            public void testReturnNoSuspend() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/returnNoSuspend.kt");
            }

            @Test
            @TestMetadata("simple.kt")
            public void testSimple() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/simple.kt");
            }

            @Test
            @TestMetadata("superCall.kt")
            public void testSuperCall() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/superCall.kt");
            }

            @Test
            @TestMetadata("superCallAbstractClass.kt")
            public void testSuperCallAbstractClass() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/superCallAbstractClass.kt");
            }

            @Test
            @TestMetadata("superCallInterface.kt")
            public void testSuperCallInterface() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/superCallInterface.kt");
            }

            @Test
            @TestMetadata("superCallOverload.kt")
            public void testSuperCallOverload() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/superCallOverload.kt");
            }

            @Test
            @TestMetadata("withVariables.kt")
            public void testWithVariables() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/suspendFunctionAsCoroutine/withVariables.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/box/coroutines/suspendFunctionTypeCall")
        @TestDataPath("$PROJECT_ROOT")
        public class SuspendFunctionTypeCall {
            @Test
            public void testAllFilesPresentInSuspendFunctionTypeCall() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/suspendFunctionTypeCall"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("localVal.kt")
            public void testLocalVal() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/suspendFunctionTypeCall/localVal.kt");
            }

            @Test
            @TestMetadata("manyParameters.kt")
            public void testManyParameters() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/suspendFunctionTypeCall/manyParameters.kt");
            }

            @Test
            @TestMetadata("manyParametersNoCapture.kt")
            public void testManyParametersNoCapture() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/suspendFunctionTypeCall/manyParametersNoCapture.kt");
            }

            @Test
            @TestMetadata("simple.kt")
            public void testSimple() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/suspendFunctionTypeCall/simple.kt");
            }

            @Test
            @TestMetadata("suspendModifier.kt")
            public void testSuspendModifier() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/suspendFunctionTypeCall/suspendModifier.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/box/coroutines/tailCallOptimizations")
        @TestDataPath("$PROJECT_ROOT")
        public class TailCallOptimizations {
            @Test
            public void testAllFilesPresentInTailCallOptimizations() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/tailCallOptimizations"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("also.kt")
            public void testAlso() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/tailCallOptimizations/also.kt");
            }

            @Test
            @TestMetadata("checkcast.kt")
            public void testCheckcast() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/tailCallOptimizations/checkcast.kt");
            }

            @Test
            @TestMetadata("checkcast2.kt")
            public void testCheckcast2() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/tailCallOptimizations/checkcast2.kt");
            }

            @Test
            @TestMetadata("crossinline.kt")
            public void testCrossinline() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/tailCallOptimizations/crossinline.kt");
            }

            @Test
            @TestMetadata("deferredAwaitSuspendImpl.kt")
            public void testDeferredAwaitSuspendImpl() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/tailCallOptimizations/deferredAwaitSuspendImpl.kt");
            }

            @Test
            @TestMetadata("inlineWithStateMachine.kt")
            public void testInlineWithStateMachine() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/tailCallOptimizations/inlineWithStateMachine.kt");
            }

            @Test
            @TestMetadata("inlineWithoutStateMachine.kt")
            public void testInlineWithoutStateMachine() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/tailCallOptimizations/inlineWithoutStateMachine.kt");
            }

            @Test
            @TestMetadata("innerObjectRetransformation.kt")
            public void testInnerObjectRetransformation() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/tailCallOptimizations/innerObjectRetransformation.kt");
            }

            @Test
            @TestMetadata("interfaceDelegation.kt")
            public void testInterfaceDelegation() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/tailCallOptimizations/interfaceDelegation.kt");
            }

            @Test
            @TestMetadata("returnInlineClass.kt")
            public void testReturnInlineClass() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/tailCallOptimizations/returnInlineClass.kt");
            }

            @Test
            @TestMetadata("simple.kt")
            public void testSimple() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/tailCallOptimizations/simple.kt");
            }

            @Test
            @TestMetadata("tailCallIfReturnUnit.kt")
            public void testTailCallIfReturnUnit() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/tailCallOptimizations/tailCallIfReturnUnit.kt");
            }

            @Test
            @TestMetadata("tailCallIntrinsics.kt")
            public void testTailCallIntrinsics() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/tailCallOptimizations/tailCallIntrinsics.kt");
            }

            @Test
            @TestMetadata("tailSuspendUnitFun.kt")
            public void testTailSuspendUnitFun() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/tailCallOptimizations/tailSuspendUnitFun.kt");
            }

            @Test
            @TestMetadata("tryCatch.kt")
            public void testTryCatch() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/tailCallOptimizations/tryCatch.kt");
            }

            @Test
            @TestMetadata("tryCatchTailCall.kt")
            public void testTryCatchTailCall() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/tailCallOptimizations/tryCatchTailCall.kt");
            }

            @Test
            @TestMetadata("unreachable.kt")
            public void testUnreachable() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/tailCallOptimizations/unreachable.kt");
            }

            @Test
            @TestMetadata("whenUnit.kt")
            public void testWhenUnit() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/tailCallOptimizations/whenUnit.kt");
            }

            @Nested
            @TestMetadata("compiler/testData/codegen/box/coroutines/tailCallOptimizations/unit")
            @TestDataPath("$PROJECT_ROOT")
            public class Unit {
                @Test
                public void testAllFilesPresentInUnit() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/tailCallOptimizations/unit"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
                }

                @Test
                @TestMetadata("functionReference.kt")
                public void testFunctionReference() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/tailCallOptimizations/unit/functionReference.kt");
                }

                @Test
                @TestMetadata("inline.kt")
                public void testInline() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/tailCallOptimizations/unit/inline.kt");
                }

                @Test
                @TestMetadata("override.kt")
                public void testOverride() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/tailCallOptimizations/unit/override.kt");
                }

                @Test
                @TestMetadata("override2.kt")
                public void testOverride2() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/tailCallOptimizations/unit/override2.kt");
                }

                @Test
                @TestMetadata("override3.kt")
                public void testOverride3() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/tailCallOptimizations/unit/override3.kt");
                }

                @Test
                @TestMetadata("override4.kt")
                public void testOverride4() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/tailCallOptimizations/unit/override4.kt");
                }

                @Test
                @TestMetadata("override5.kt")
                public void testOverride5() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/tailCallOptimizations/unit/override5.kt");
                }

                @Test
                @TestMetadata("override6.kt")
                public void testOverride6() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/tailCallOptimizations/unit/override6.kt");
                }

                @Test
                @TestMetadata("overrideCrossinline.kt")
                public void testOverrideCrossinline() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/tailCallOptimizations/unit/overrideCrossinline.kt");
                }

                @Test
                @TestMetadata("overrideOverriden.kt")
                public void testOverrideOverriden() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/tailCallOptimizations/unit/overrideOverriden.kt");
                }

                @Test
                @TestMetadata("reflection.kt")
                public void testReflection() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/tailCallOptimizations/unit/reflection.kt");
                }

                @Test
                @TestMetadata("simple.kt")
                public void testSimple() throws Exception {
                    runTest("compiler/testData/codegen/box/coroutines/tailCallOptimizations/unit/simple.kt");
                }
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/box/coroutines/tailOperations")
        @TestDataPath("$PROJECT_ROOT")
        public class TailOperations {
            @Test
            public void testAllFilesPresentInTailOperations() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/tailOperations"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("suspendWithIf.kt")
            public void testSuspendWithIf() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/tailOperations/suspendWithIf.kt");
            }

            @Test
            @TestMetadata("suspendWithTryCatch.kt")
            public void testSuspendWithTryCatch() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/tailOperations/suspendWithTryCatch.kt");
            }

            @Test
            @TestMetadata("suspendWithWhen.kt")
            public void testSuspendWithWhen() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/tailOperations/suspendWithWhen.kt");
            }

            @Test
            @TestMetadata("tailInlining.kt")
            public void testTailInlining() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/tailOperations/tailInlining.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/box/coroutines/unitTypeReturn")
        @TestDataPath("$PROJECT_ROOT")
        public class UnitTypeReturn {
            @Test
            public void testAllFilesPresentInUnitTypeReturn() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/unitTypeReturn"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("coroutineNonLocalReturn.kt")
            public void testCoroutineNonLocalReturn() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/unitTypeReturn/coroutineNonLocalReturn.kt");
            }

            @Test
            @TestMetadata("coroutineReturn.kt")
            public void testCoroutineReturn() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/unitTypeReturn/coroutineReturn.kt");
            }

            @Test
            @TestMetadata("inlineUnitFunction.kt")
            public void testInlineUnitFunction() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/unitTypeReturn/inlineUnitFunction.kt");
            }

            @Test
            @TestMetadata("interfaceDelegation.kt")
            public void testInterfaceDelegation() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/unitTypeReturn/interfaceDelegation.kt");
            }

            @Test
            @TestMetadata("suspendNonLocalReturn.kt")
            public void testSuspendNonLocalReturn() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/unitTypeReturn/suspendNonLocalReturn.kt");
            }

            @Test
            @TestMetadata("suspendReturn.kt")
            public void testSuspendReturn() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/unitTypeReturn/suspendReturn.kt");
            }

            @Test
            @TestMetadata("unitSafeCall.kt")
            public void testUnitSafeCall() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/unitTypeReturn/unitSafeCall.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/box/coroutines/varSpilling")
        @TestDataPath("$PROJECT_ROOT")
        public class VarSpilling {
            @Test
            public void testAllFilesPresentInVarSpilling() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/coroutines/varSpilling"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("fakeInlinerVariables.kt")
            public void testFakeInlinerVariables() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/varSpilling/fakeInlinerVariables.kt");
            }

            @Test
            @TestMetadata("kt19475.kt")
            public void testKt19475() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/varSpilling/kt19475.kt");
            }

            @Test
            @TestMetadata("kt38925.kt")
            public void testKt38925() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/varSpilling/kt38925.kt");
            }

            @Test
            @TestMetadata("kt49834.kt")
            public void testKt49834() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/varSpilling/kt49834.kt");
            }

            @Test
            @TestMetadata("lvtWithInlineOnly.kt")
            public void testLvtWithInlineOnly() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/varSpilling/lvtWithInlineOnly.kt");
            }

            @Test
            @TestMetadata("nullSpilling.kt")
            public void testNullSpilling() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/varSpilling/nullSpilling.kt");
            }

            @Test
            @TestMetadata("refinedIntTypesAnalysis.kt")
            public void testRefinedIntTypesAnalysis() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/varSpilling/refinedIntTypesAnalysis.kt");
            }

            @Test
            @TestMetadata("safeCallElvis.kt")
            public void testSafeCallElvis() throws Exception {
                runTest("compiler/testData/codegen/box/coroutines/varSpilling/safeCallElvis.kt");
            }
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/correctFrontendCode")
    @TestDataPath("$PROJECT_ROOT")
    public class CorrectFrontendCode {
        @Test
        public void testAllFilesPresentInCorrectFrontendCode() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/correctFrontendCode"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("privateNestedClassInSuper.kt")
        public void testPrivateNestedClassInSuper() throws Exception {
            runTest("compiler/testData/codegen/box/correctFrontendCode/privateNestedClassInSuper.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/dataClasses")
    @TestDataPath("$PROJECT_ROOT")
    public class DataClasses {
        @Test
        public void testAllFilesPresentInDataClasses() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/dataClasses"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("arrayParams.kt")
        public void testArrayParams() throws Exception {
            runTest("compiler/testData/codegen/box/dataClasses/arrayParams.kt");
        }

        @Test
        @TestMetadata("changingVarParam.kt")
        public void testChangingVarParam() throws Exception {
            runTest("compiler/testData/codegen/box/dataClasses/changingVarParam.kt");
        }

        @Test
        @TestMetadata("dataClassWithManyFields.kt")
        public void testDataClassWithManyFields() throws Exception {
            runTest("compiler/testData/codegen/box/dataClasses/dataClassWithManyFields.kt");
        }

        @Test
        @TestMetadata("doubleParam.kt")
        public void testDoubleParam() throws Exception {
            runTest("compiler/testData/codegen/box/dataClasses/doubleParam.kt");
        }

        @Test
        @TestMetadata("floatParam.kt")
        public void testFloatParam() throws Exception {
            runTest("compiler/testData/codegen/box/dataClasses/floatParam.kt");
        }

        @Test
        @TestMetadata("genericParam.kt")
        public void testGenericParam() throws Exception {
            runTest("compiler/testData/codegen/box/dataClasses/genericParam.kt");
        }

        @Test
        @TestMetadata("kt49715.kt")
        public void testKt49715() throws Exception {
            runTest("compiler/testData/codegen/box/dataClasses/kt49715.kt");
        }

        @Test
        @TestMetadata("kt49715_behaviorChange.kt")
        public void testKt49715_behaviorChange() throws Exception {
            runTest("compiler/testData/codegen/box/dataClasses/kt49715_behaviorChange.kt");
        }

        @Test
        @TestMetadata("kt5002.kt")
        public void testKt5002() throws Exception {
            runTest("compiler/testData/codegen/box/dataClasses/kt5002.kt");
        }

        @Test
        @TestMetadata("mixedParams.kt")
        public void testMixedParams() throws Exception {
            runTest("compiler/testData/codegen/box/dataClasses/mixedParams.kt");
        }

        @Test
        @TestMetadata("multiDeclaration.kt")
        public void testMultiDeclaration() throws Exception {
            runTest("compiler/testData/codegen/box/dataClasses/multiDeclaration.kt");
        }

        @Test
        @TestMetadata("multiDeclarationFor.kt")
        public void testMultiDeclarationFor() throws Exception {
            runTest("compiler/testData/codegen/box/dataClasses/multiDeclarationFor.kt");
        }

        @Test
        @TestMetadata("nonTrivialFinalMemberInSuperClass.kt")
        public void testNonTrivialFinalMemberInSuperClass() throws Exception {
            runTest("compiler/testData/codegen/box/dataClasses/nonTrivialFinalMemberInSuperClass.kt");
        }

        @Test
        @TestMetadata("nonTrivialMemberInSuperClass.kt")
        public void testNonTrivialMemberInSuperClass() throws Exception {
            runTest("compiler/testData/codegen/box/dataClasses/nonTrivialMemberInSuperClass.kt");
        }

        @Test
        @TestMetadata("privateValParams.kt")
        public void testPrivateValParams() throws Exception {
            runTest("compiler/testData/codegen/box/dataClasses/privateValParams.kt");
        }

        @Test
        @TestMetadata("twoValParams.kt")
        public void testTwoValParams() throws Exception {
            runTest("compiler/testData/codegen/box/dataClasses/twoValParams.kt");
        }

        @Test
        @TestMetadata("twoVarParams.kt")
        public void testTwoVarParams() throws Exception {
            runTest("compiler/testData/codegen/box/dataClasses/twoVarParams.kt");
        }

        @Test
        @TestMetadata("typeParameterWithNonTrivialBound.kt")
        public void testTypeParameterWithNonTrivialBound() throws Exception {
            runTest("compiler/testData/codegen/box/dataClasses/typeParameterWithNonTrivialBound.kt");
        }

        @Test
        @TestMetadata("unitComponent.kt")
        public void testUnitComponent() throws Exception {
            runTest("compiler/testData/codegen/box/dataClasses/unitComponent.kt");
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/box/dataClasses/components")
        @TestDataPath("$PROJECT_ROOT")
        public class Components {
            @Test
            public void testAllFilesPresentInComponents() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/dataClasses/components"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("kt49812.kt")
            public void testKt49812() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/components/kt49812.kt");
            }

            @Test
            @TestMetadata("kt49936.kt")
            public void testKt49936() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/components/kt49936.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/box/dataClasses/copy")
        @TestDataPath("$PROJECT_ROOT")
        public class Copy {
            @Test
            public void testAllFilesPresentInCopy() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/dataClasses/copy"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("constructorWithDefaultParam.kt")
            public void testConstructorWithDefaultParam() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/copy/constructorWithDefaultParam.kt");
            }

            @Test
            @TestMetadata("copyInObjectNestedDataClass.kt")
            public void testCopyInObjectNestedDataClass() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/copy/copyInObjectNestedDataClass.kt");
            }

            @Test
            @TestMetadata("kt12708.kt")
            public void testKt12708() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/copy/kt12708.kt");
            }

            @Test
            @TestMetadata("kt3033.kt")
            public void testKt3033() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/copy/kt3033.kt");
            }

            @Test
            @TestMetadata("valInConstructorParams.kt")
            public void testValInConstructorParams() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/copy/valInConstructorParams.kt");
            }

            @Test
            @TestMetadata("varInConstructorParams.kt")
            public void testVarInConstructorParams() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/copy/varInConstructorParams.kt");
            }

            @Test
            @TestMetadata("withGenericParameter.kt")
            public void testWithGenericParameter() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/copy/withGenericParameter.kt");
            }

            @Test
            @TestMetadata("withSecondaryConstructor.kt")
            public void testWithSecondaryConstructor() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/copy/withSecondaryConstructor.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/box/dataClasses/equals")
        @TestDataPath("$PROJECT_ROOT")
        public class Equals {
            @Test
            public void testAllFilesPresentInEquals() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/dataClasses/equals"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("alreadyDeclared.kt")
            public void testAlreadyDeclared() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/equals/alreadyDeclared.kt");
            }

            @Test
            @TestMetadata("alreadyDeclaredWrongSignature.kt")
            public void testAlreadyDeclaredWrongSignature() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/equals/alreadyDeclaredWrongSignature.kt");
            }

            @Test
            @TestMetadata("genericarray.kt")
            public void testGenericarray() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/equals/genericarray.kt");
            }

            @Test
            @TestMetadata("intarray.kt")
            public void testIntarray() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/equals/intarray.kt");
            }

            @Test
            @TestMetadata("null.kt")
            public void testNull() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/equals/null.kt");
            }

            @Test
            @TestMetadata("nullother.kt")
            public void testNullother() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/equals/nullother.kt");
            }

            @Test
            @TestMetadata("sameinstance.kt")
            public void testSameinstance() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/equals/sameinstance.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/box/dataClasses/hashCode")
        @TestDataPath("$PROJECT_ROOT")
        public class HashCode {
            @Test
            public void testAllFilesPresentInHashCode() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/dataClasses/hashCode"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("alreadyDeclared.kt")
            public void testAlreadyDeclared() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/hashCode/alreadyDeclared.kt");
            }

            @Test
            @TestMetadata("alreadyDeclaredWrongSignature.kt")
            public void testAlreadyDeclaredWrongSignature() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/hashCode/alreadyDeclaredWrongSignature.kt");
            }

            @Test
            @TestMetadata("array.kt")
            public void testArray() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/hashCode/array.kt");
            }

            @Test
            @TestMetadata("boolean.kt")
            public void testBoolean() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/hashCode/boolean.kt");
            }

            @Test
            @TestMetadata("byte.kt")
            public void testByte() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/hashCode/byte.kt");
            }

            @Test
            @TestMetadata("char.kt")
            public void testChar() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/hashCode/char.kt");
            }

            @Test
            @TestMetadata("double.kt")
            public void testDouble() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/hashCode/double.kt");
            }

            @Test
            @TestMetadata("float.kt")
            public void testFloat() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/hashCode/float.kt");
            }

            @Test
            @TestMetadata("genericNull.kt")
            public void testGenericNull() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/hashCode/genericNull.kt");
            }

            @Test
            @TestMetadata("int.kt")
            public void testInt() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/hashCode/int.kt");
            }

            @Test
            @TestMetadata("long.kt")
            public void testLong() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/hashCode/long.kt");
            }

            @Test
            @TestMetadata("null.kt")
            public void testNull() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/hashCode/null.kt");
            }

            @Test
            @TestMetadata("short.kt")
            public void testShort() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/hashCode/short.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/box/dataClasses/toString")
        @TestDataPath("$PROJECT_ROOT")
        public class ToString {
            @Test
            public void testAllFilesPresentInToString() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/dataClasses/toString"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("alreadyDeclared.kt")
            public void testAlreadyDeclared() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/toString/alreadyDeclared.kt");
            }

            @Test
            @TestMetadata("alreadyDeclaredWrongSignature.kt")
            public void testAlreadyDeclaredWrongSignature() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/toString/alreadyDeclaredWrongSignature.kt");
            }

            @Test
            @TestMetadata("arrayParams.kt")
            public void testArrayParams() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/toString/arrayParams.kt");
            }

            @Test
            @TestMetadata("changingVarParam.kt")
            public void testChangingVarParam() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/toString/changingVarParam.kt");
            }

            @Test
            @TestMetadata("genericParam.kt")
            public void testGenericParam() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/toString/genericParam.kt");
            }

            @Test
            @TestMetadata("mixedParams.kt")
            public void testMixedParams() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/toString/mixedParams.kt");
            }

            @Test
            @TestMetadata("primitiveArrays.kt")
            public void testPrimitiveArrays() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/toString/primitiveArrays.kt");
            }

            @Test
            @TestMetadata("unitComponent.kt")
            public void testUnitComponent() throws Exception {
                runTest("compiler/testData/codegen/box/dataClasses/toString/unitComponent.kt");
            }
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/deadCodeElimination")
    @TestDataPath("$PROJECT_ROOT")
    public class DeadCodeElimination {
        @Test
        public void testAllFilesPresentInDeadCodeElimination() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/deadCodeElimination"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("emptyVariableRange.kt")
        public void testEmptyVariableRange() throws Exception {
            runTest("compiler/testData/codegen/box/deadCodeElimination/emptyVariableRange.kt");
        }

        @Test
        @TestMetadata("intersectingVariableRange.kt")
        public void testIntersectingVariableRange() throws Exception {
            runTest("compiler/testData/codegen/box/deadCodeElimination/intersectingVariableRange.kt");
        }

        @Test
        @TestMetadata("intersectingVariableRangeInFinally.kt")
        public void testIntersectingVariableRangeInFinally() throws Exception {
            runTest("compiler/testData/codegen/box/deadCodeElimination/intersectingVariableRangeInFinally.kt");
        }

        @Test
        @TestMetadata("kt14357.kt")
        public void testKt14357() throws Exception {
            runTest("compiler/testData/codegen/box/deadCodeElimination/kt14357.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/defaultArguments")
    @TestDataPath("$PROJECT_ROOT")
    public class DefaultArguments {
        @Test
        public void testAllFilesPresentInDefaultArguments() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/defaultArguments"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("callDefaultFromInitializer.kt")
        public void testCallDefaultFromInitializer() throws Exception {
            runTest("compiler/testData/codegen/box/defaultArguments/callDefaultFromInitializer.kt");
        }

        @Test
        @TestMetadata("captureInTailrec.kt")
        public void testCaptureInTailrec() throws Exception {
            runTest("compiler/testData/codegen/box/defaultArguments/captureInTailrec.kt");
        }

        @Test
        @TestMetadata("complexInheritance.kt")
        public void testComplexInheritance() throws Exception {
            runTest("compiler/testData/codegen/box/defaultArguments/complexInheritance.kt");
        }

        @Test
        @TestMetadata("implementedByFake.kt")
        public void testImplementedByFake() throws Exception {
            runTest("compiler/testData/codegen/box/defaultArguments/implementedByFake.kt");
        }

        @Test
        @TestMetadata("implementedByFake2.kt")
        public void testImplementedByFake2() throws Exception {
            runTest("compiler/testData/codegen/box/defaultArguments/implementedByFake2.kt");
        }

        @Test
        @TestMetadata("implementedByFake3.kt")
        public void testImplementedByFake3() throws Exception {
            runTest("compiler/testData/codegen/box/defaultArguments/implementedByFake3.kt");
        }

        @Test
        @TestMetadata("inheritedFromInterfaceViaAbstractSuperclass.kt")
        public void testInheritedFromInterfaceViaAbstractSuperclass() throws Exception {
            runTest("compiler/testData/codegen/box/defaultArguments/inheritedFromInterfaceViaAbstractSuperclass.kt");
        }

        @Test
        @TestMetadata("kt36853.kt")
        public void testKt36853() throws Exception {
            runTest("compiler/testData/codegen/box/defaultArguments/kt36853.kt");
        }

        @Test
        @TestMetadata("kt36853_fibonacci.kt")
        public void testKt36853_fibonacci() throws Exception {
            runTest("compiler/testData/codegen/box/defaultArguments/kt36853_fibonacci.kt");
        }

        @Test
        @TestMetadata("kt36853_nestedObject.kt")
        public void testKt36853_nestedObject() throws Exception {
            runTest("compiler/testData/codegen/box/defaultArguments/kt36853_nestedObject.kt");
        }

        @Test
        @TestMetadata("kt36853a.kt")
        public void testKt36853a() throws Exception {
            runTest("compiler/testData/codegen/box/defaultArguments/kt36853a.kt");
        }

        @Test
        @TestMetadata("kt36972_companion.kt")
        public void testKt36972_companion() throws Exception {
            runTest("compiler/testData/codegen/box/defaultArguments/kt36972_companion.kt");
        }

        @Test
        @TestMetadata("kt36972_object.kt")
        public void testKt36972_object() throws Exception {
            runTest("compiler/testData/codegen/box/defaultArguments/kt36972_object.kt");
        }

        @Test
        @TestMetadata("kt46189.kt")
        public void testKt46189() throws Exception {
            runTest("compiler/testData/codegen/box/defaultArguments/kt46189.kt");
        }

        @Test
        @TestMetadata("kt47073.kt")
        public void testKt47073() throws Exception {
            runTest("compiler/testData/codegen/box/defaultArguments/kt47073.kt");
        }

        @Test
        @TestMetadata("kt47073_nested.kt")
        public void testKt47073_nested() throws Exception {
            runTest("compiler/testData/codegen/box/defaultArguments/kt47073_nested.kt");
        }

        @Test
        @TestMetadata("kt48391.kt")
        public void testKt48391() throws Exception {
            runTest("compiler/testData/codegen/box/defaultArguments/kt48391.kt");
        }

        @Test
        @TestMetadata("kt6382.kt")
        public void testKt6382() throws Exception {
            runTest("compiler/testData/codegen/box/defaultArguments/kt6382.kt");
        }

        @Test
        @TestMetadata("protected.kt")
        public void testProtected() throws Exception {
            runTest("compiler/testData/codegen/box/defaultArguments/protected.kt");
        }

        @Test
        @TestMetadata("recursiveDefaultArguments.kt")
        public void testRecursiveDefaultArguments() throws Exception {
            runTest("compiler/testData/codegen/box/defaultArguments/recursiveDefaultArguments.kt");
        }

        @Test
        @TestMetadata("referenceAsArg.kt")
        public void testReferenceAsArg() throws Exception {
            runTest("compiler/testData/codegen/box/defaultArguments/referenceAsArg.kt");
        }

        @Test
        @TestMetadata("simpleFromOtherFile.kt")
        public void testSimpleFromOtherFile() throws Exception {
            runTest("compiler/testData/codegen/box/defaultArguments/simpleFromOtherFile.kt");
        }

        @Test
        @TestMetadata("superCallCheck.kt")
        public void testSuperCallCheck() throws Exception {
            runTest("compiler/testData/codegen/box/defaultArguments/superCallCheck.kt");
        }

        @Test
        @TestMetadata("superCallHandlerOrder.kt")
        public void testSuperCallHandlerOrder() throws Exception {
            runTest("compiler/testData/codegen/box/defaultArguments/superCallHandlerOrder.kt");
        }

        @Test
        @TestMetadata("useNextParamInLambda.kt")
        public void testUseNextParamInLambda() throws Exception {
            runTest("compiler/testData/codegen/box/defaultArguments/useNextParamInLambda.kt");
        }

        @Test
        @TestMetadata("useNextParamInLambdaTailrec.kt")
        public void testUseNextParamInLambdaTailrec() throws Exception {
            runTest("compiler/testData/codegen/box/defaultArguments/useNextParamInLambdaTailrec.kt");
        }

        @Test
        @TestMetadata("useThisInLambda.kt")
        public void testUseThisInLambda() throws Exception {
            runTest("compiler/testData/codegen/box/defaultArguments/useThisInLambda.kt");
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/box/defaultArguments/constructor")
        @TestDataPath("$PROJECT_ROOT")
        public class Constructor {
            @Test
            public void testAllFilesPresentInConstructor() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/defaultArguments/constructor"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("annotation.kt")
            public void testAnnotation() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/constructor/annotation.kt");
            }

            @Test
            @TestMetadata("annotationWithEmptyArray.kt")
            public void testAnnotationWithEmptyArray() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/constructor/annotationWithEmptyArray.kt");
            }

            @Test
            @TestMetadata("checkIfConstructorIsSynthetic.kt")
            public void testCheckIfConstructorIsSynthetic() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/constructor/checkIfConstructorIsSynthetic.kt");
            }

            @Test
            @TestMetadata("defArgs1.kt")
            public void testDefArgs1() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/constructor/defArgs1.kt");
            }

            @Test
            @TestMetadata("defArgs1InnerClass.kt")
            public void testDefArgs1InnerClass() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/constructor/defArgs1InnerClass.kt");
            }

            @Test
            @TestMetadata("defArgs2.kt")
            public void testDefArgs2() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/constructor/defArgs2.kt");
            }

            @Test
            @TestMetadata("doubleDefArgs1InnerClass.kt")
            public void testDoubleDefArgs1InnerClass() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/constructor/doubleDefArgs1InnerClass.kt");
            }

            @Test
            @TestMetadata("enum.kt")
            public void testEnum() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/constructor/enum.kt");
            }

            @Test
            @TestMetadata("enumWithOneDefArg.kt")
            public void testEnumWithOneDefArg() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/constructor/enumWithOneDefArg.kt");
            }

            @Test
            @TestMetadata("enumWithTwoDefArgs.kt")
            public void testEnumWithTwoDefArgs() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/constructor/enumWithTwoDefArgs.kt");
            }

            @Test
            @TestMetadata("enumWithTwoDoubleDefArgs.kt")
            public void testEnumWithTwoDoubleDefArgs() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/constructor/enumWithTwoDoubleDefArgs.kt");
            }

            @Test
            @TestMetadata("innerClass32Args.kt")
            public void testInnerClass32Args() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/constructor/innerClass32Args.kt");
            }

            @Test
            @TestMetadata("kt2852.kt")
            public void testKt2852() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/constructor/kt2852.kt");
            }

            @Test
            @TestMetadata("kt30517.kt")
            public void testKt30517() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/constructor/kt30517.kt");
            }

            @Test
            @TestMetadata("kt3060.kt")
            public void testKt3060() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/constructor/kt3060.kt");
            }

            @Test
            @TestMetadata("manyArgs.kt")
            public void testManyArgs() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/constructor/manyArgs.kt");
            }

            @Test
            @TestMetadata("objectExpressionDelegatingToSecondaryConstructor.kt")
            public void testObjectExpressionDelegatingToSecondaryConstructor() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/constructor/objectExpressionDelegatingToSecondaryConstructor.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/box/defaultArguments/convention")
        @TestDataPath("$PROJECT_ROOT")
        public class Convention {
            @Test
            public void testAllFilesPresentInConvention() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/defaultArguments/convention"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("incWithDefaultInGetter.kt")
            public void testIncWithDefaultInGetter() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/convention/incWithDefaultInGetter.kt");
            }

            @Test
            @TestMetadata("incWithDefaults.kt")
            public void testIncWithDefaults() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/convention/incWithDefaults.kt");
            }

            @Test
            @TestMetadata("kt16520.kt")
            public void testKt16520() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/convention/kt16520.kt");
            }

            @Test
            @TestMetadata("kt16520_old.kt")
            public void testKt16520_old() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/convention/kt16520_old.kt");
            }

            @Test
            @TestMetadata("kt9140.kt")
            public void testKt9140() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/convention/kt9140.kt");
            }

            @Test
            @TestMetadata("plusAssignWithDefaultInGetter.kt")
            public void testPlusAssignWithDefaultInGetter() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/convention/plusAssignWithDefaultInGetter.kt");
            }

            @Test
            @TestMetadata("plusAssignWithDefaults.kt")
            public void testPlusAssignWithDefaults() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/convention/plusAssignWithDefaults.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/box/defaultArguments/function")
        @TestDataPath("$PROJECT_ROOT")
        public class Function {
            @Test
            @TestMetadata("abstractClass.kt")
            public void testAbstractClass() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/abstractClass.kt");
            }

            @Test
            public void testAllFilesPresentInFunction() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/defaultArguments/function"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("complexInheritance.kt")
            public void testComplexInheritance() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/complexInheritance.kt");
            }

            @Test
            @TestMetadata("covariantOverride.kt")
            public void testCovariantOverride() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/covariantOverride.kt");
            }

            @Test
            @TestMetadata("covariantOverrideGeneric.kt")
            public void testCovariantOverrideGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/covariantOverrideGeneric.kt");
            }

            @Test
            @TestMetadata("defaultLambdaInline.kt")
            public void testDefaultLambdaInline() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/defaultLambdaInline.kt");
            }

            @Test
            @TestMetadata("extensionFunctionManyArgs.kt")
            public void testExtensionFunctionManyArgs() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/extensionFunctionManyArgs.kt");
            }

            @Test
            @TestMetadata("extentionFunction.kt")
            public void testExtentionFunction() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/extentionFunction.kt");
            }

            @Test
            @TestMetadata("extentionFunctionDouble.kt")
            public void testExtentionFunctionDouble() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/extentionFunctionDouble.kt");
            }

            @Test
            @TestMetadata("extentionFunctionDoubleTwoArgs.kt")
            public void testExtentionFunctionDoubleTwoArgs() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/extentionFunctionDoubleTwoArgs.kt");
            }

            @Test
            @TestMetadata("extentionFunctionInClassObject.kt")
            public void testExtentionFunctionInClassObject() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/extentionFunctionInClassObject.kt");
            }

            @Test
            @TestMetadata("extentionFunctionInObject.kt")
            public void testExtentionFunctionInObject() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/extentionFunctionInObject.kt");
            }

            @Test
            @TestMetadata("extentionFunctionWithOneDefArg.kt")
            public void testExtentionFunctionWithOneDefArg() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/extentionFunctionWithOneDefArg.kt");
            }

            @Test
            @TestMetadata("funInTrait.kt")
            public void testFunInTrait() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/funInTrait.kt");
            }

            @Test
            @TestMetadata("funInTraitChain.kt")
            public void testFunInTraitChain() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/funInTraitChain.kt");
            }

            @Test
            @TestMetadata("innerExtentionFunction.kt")
            public void testInnerExtentionFunction() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/innerExtentionFunction.kt");
            }

            @Test
            @TestMetadata("innerExtentionFunctionDouble.kt")
            public void testInnerExtentionFunctionDouble() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/innerExtentionFunctionDouble.kt");
            }

            @Test
            @TestMetadata("innerExtentionFunctionDoubleTwoArgs.kt")
            public void testInnerExtentionFunctionDoubleTwoArgs() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/innerExtentionFunctionDoubleTwoArgs.kt");
            }

            @Test
            @TestMetadata("innerExtentionFunctionManyArgs.kt")
            public void testInnerExtentionFunctionManyArgs() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/innerExtentionFunctionManyArgs.kt");
            }

            @Test
            @TestMetadata("kt15971.kt")
            public void testKt15971() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/kt15971.kt");
            }

            @Test
            @TestMetadata("kt15971_2.kt")
            public void testKt15971_2() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/kt15971_2.kt");
            }

            @Test
            @TestMetadata("kt15971_3.kt")
            public void testKt15971_3() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/kt15971_3.kt");
            }

            @Test
            @TestMetadata("kt36188.kt")
            public void testKt36188() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/kt36188.kt");
            }

            @Test
            @TestMetadata("kt36188_2.kt")
            public void testKt36188_2() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/kt36188_2.kt");
            }

            @Test
            @TestMetadata("kt5232.kt")
            public void testKt5232() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/kt5232.kt");
            }

            @Test
            @TestMetadata("memberFunctionManyArgs.kt")
            public void testMemberFunctionManyArgs() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/memberFunctionManyArgs.kt");
            }

            @Test
            @TestMetadata("mixingNamedAndPositioned.kt")
            public void testMixingNamedAndPositioned() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/mixingNamedAndPositioned.kt");
            }

            @Test
            @TestMetadata("topLevelManyArgs.kt")
            public void testTopLevelManyArgs() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/topLevelManyArgs.kt");
            }

            @Test
            @TestMetadata("trait.kt")
            public void testTrait() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/function/trait.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/box/defaultArguments/private")
        @TestDataPath("$PROJECT_ROOT")
        public class Private {
            @Test
            public void testAllFilesPresentInPrivate() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/defaultArguments/private"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("memberExtensionFunction.kt")
            public void testMemberExtensionFunction() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/private/memberExtensionFunction.kt");
            }

            @Test
            @TestMetadata("memberFunction.kt")
            public void testMemberFunction() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/private/memberFunction.kt");
            }

            @Test
            @TestMetadata("primaryConstructor.kt")
            public void testPrimaryConstructor() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/private/primaryConstructor.kt");
            }

            @Test
            @TestMetadata("secondaryConstructor.kt")
            public void testSecondaryConstructor() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/private/secondaryConstructor.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/box/defaultArguments/signature")
        @TestDataPath("$PROJECT_ROOT")
        public class Signature {
            @Test
            public void testAllFilesPresentInSignature() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/defaultArguments/signature"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("kt2789.kt")
            public void testKt2789() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/signature/kt2789.kt");
            }

            @Test
            @TestMetadata("kt9428.kt")
            public void testKt9428() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/signature/kt9428.kt");
            }

            @Test
            @TestMetadata("kt9924.kt")
            public void testKt9924() throws Exception {
                runTest("compiler/testData/codegen/box/defaultArguments/signature/kt9924.kt");
            }
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/delegatedProperty")
    @TestDataPath("$PROJECT_ROOT")
    public class DelegatedProperty {
        @Test
        @TestMetadata("accessTopLevelDelegatedPropertyInClinit.kt")
        public void testAccessTopLevelDelegatedPropertyInClinit() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/accessTopLevelDelegatedPropertyInClinit.kt");
        }

        @Test
        public void testAllFilesPresentInDelegatedProperty() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/delegatedProperty"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("beforeDeclarationContainerOptimization.kt")
        public void testBeforeDeclarationContainerOptimization() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/beforeDeclarationContainerOptimization.kt");
        }

        @Test
        @TestMetadata("capturePropertyInClosure.kt")
        public void testCapturePropertyInClosure() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/capturePropertyInClosure.kt");
        }

        @Test
        @TestMetadata("castGetReturnType.kt")
        public void testCastGetReturnType() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/castGetReturnType.kt");
        }

        @Test
        @TestMetadata("castSetParameter.kt")
        public void testCastSetParameter() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/castSetParameter.kt");
        }

        @Test
        @TestMetadata("delegateAsInnerClass.kt")
        public void testDelegateAsInnerClass() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/delegateAsInnerClass.kt");
        }

        @Test
        @TestMetadata("delegateByOtherProperty.kt")
        public void testDelegateByOtherProperty() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/delegateByOtherProperty.kt");
        }

        @Test
        @TestMetadata("delegateByTopLevelFun.kt")
        public void testDelegateByTopLevelFun() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/delegateByTopLevelFun.kt");
        }

        @Test
        @TestMetadata("delegateByTopLevelProperty.kt")
        public void testDelegateByTopLevelProperty() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/delegateByTopLevelProperty.kt");
        }

        @Test
        @TestMetadata("delegateForExtProperty.kt")
        public void testDelegateForExtProperty() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/delegateForExtProperty.kt");
        }

        @Test
        @TestMetadata("delegateForExtPropertyInClass.kt")
        public void testDelegateForExtPropertyInClass() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/delegateForExtPropertyInClass.kt");
        }

        @Test
        @TestMetadata("delegateToConstructorParameter.kt")
        public void testDelegateToConstructorParameter() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/delegateToConstructorParameter.kt");
        }

        @Test
        @TestMetadata("delegateWithPrivateSet.kt")
        public void testDelegateWithPrivateSet() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/delegateWithPrivateSet.kt");
        }

        @Test
        @TestMetadata("delegatedPropertyInEnum.kt")
        public void testDelegatedPropertyInEnum() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/delegatedPropertyInEnum.kt");
        }

        @Test
        @TestMetadata("extensionDelegatesWithSameNames.kt")
        public void testExtensionDelegatesWithSameNames() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/extensionDelegatesWithSameNames.kt");
        }

        @Test
        @TestMetadata("extensionPropertyAndExtensionGetValue.kt")
        public void testExtensionPropertyAndExtensionGetValue() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/extensionPropertyAndExtensionGetValue.kt");
        }

        @Test
        @TestMetadata("functionRefDelefate.kt")
        public void testFunctionRefDelefate() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/functionRefDelefate.kt");
        }

        @Test
        @TestMetadata("genericDelegate.kt")
        public void testGenericDelegate() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/genericDelegate.kt");
        }

        @Test
        @TestMetadata("genericDelegateUncheckedCast1.kt")
        public void testGenericDelegateUncheckedCast1() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/genericDelegateUncheckedCast1.kt");
        }

        @Test
        @TestMetadata("genericDelegateUncheckedCast2.kt")
        public void testGenericDelegateUncheckedCast2() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/genericDelegateUncheckedCast2.kt");
        }

        @Test
        @TestMetadata("genericSetValueViaSyntheticAccessor.kt")
        public void testGenericSetValueViaSyntheticAccessor() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/genericSetValueViaSyntheticAccessor.kt");
        }

        @Test
        @TestMetadata("getAsExtensionFun.kt")
        public void testGetAsExtensionFun() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/getAsExtensionFun.kt");
        }

        @Test
        @TestMetadata("getAsExtensionFunInClass.kt")
        public void testGetAsExtensionFunInClass() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/getAsExtensionFunInClass.kt");
        }

        @Test
        @TestMetadata("getDelegateWithoutReflection.kt")
        public void testGetDelegateWithoutReflection() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/getDelegateWithoutReflection.kt");
        }

        @Test
        @TestMetadata("inClassVal.kt")
        public void testInClassVal() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/inClassVal.kt");
        }

        @Test
        @TestMetadata("inClassVar.kt")
        public void testInClassVar() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/inClassVar.kt");
        }

        @Test
        @TestMetadata("inTrait.kt")
        public void testInTrait() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/inTrait.kt");
        }

        @Test
        @TestMetadata("inferredPropertyType.kt")
        public void testInferredPropertyType() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/inferredPropertyType.kt");
        }

        @Test
        @TestMetadata("insideInlinedObjectMultiModule.kt")
        public void testInsideInlinedObjectMultiModule() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/insideInlinedObjectMultiModule.kt");
        }

        @Test
        @TestMetadata("javaDelegateTopLevel.kt")
        public void testJavaDelegateTopLevel() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/javaDelegateTopLevel.kt");
        }

        @Test
        @TestMetadata("kt35707.kt")
        public void testKt35707() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/kt35707.kt");
        }

        @Test
        @TestMetadata("kt37204.kt")
        public void testKt37204() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/kt37204.kt");
        }

        @Test
        @TestMetadata("kt4138.kt")
        public void testKt4138() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/kt4138.kt");
        }

        @Test
        @TestMetadata("kt45431.kt")
        public void testKt45431() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/kt45431.kt");
        }

        @Test
        @TestMetadata("kt6722.kt")
        public void testKt6722() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/kt6722.kt");
        }

        @Test
        @TestMetadata("kt9712.kt")
        public void testKt9712() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/kt9712.kt");
        }

        @Test
        @TestMetadata("privateInSubClass.kt")
        public void testPrivateInSubClass() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/privateInSubClass.kt");
        }

        @Test
        @TestMetadata("privateSetterKPropertyIsNotMutable.kt")
        public void testPrivateSetterKPropertyIsNotMutable() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/privateSetterKPropertyIsNotMutable.kt");
        }

        @Test
        @TestMetadata("privateVar.kt")
        public void testPrivateVar() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/privateVar.kt");
        }

        @Test
        @TestMetadata("propertyMetadataShouldBeCached.kt")
        public void testPropertyMetadataShouldBeCached() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/propertyMetadataShouldBeCached.kt");
        }

        @Test
        @TestMetadata("protectedVarWithPrivateSet.kt")
        public void testProtectedVarWithPrivateSet() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/protectedVarWithPrivateSet.kt");
        }

        @Test
        @TestMetadata("referenceEnclosingClassFieldInReceiver.kt")
        public void testReferenceEnclosingClassFieldInReceiver() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/referenceEnclosingClassFieldInReceiver.kt");
        }

        @Test
        @TestMetadata("referenceEnclosingClassFieldInReceiver2.kt")
        public void testReferenceEnclosingClassFieldInReceiver2() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/referenceEnclosingClassFieldInReceiver2.kt");
        }

        @Test
        @TestMetadata("setAsExtensionFun.kt")
        public void testSetAsExtensionFun() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/setAsExtensionFun.kt");
        }

        @Test
        @TestMetadata("setAsExtensionFunInClass.kt")
        public void testSetAsExtensionFunInClass() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/setAsExtensionFunInClass.kt");
        }

        @Test
        @TestMetadata("stackOverflowOnCallFromGetValue.kt")
        public void testStackOverflowOnCallFromGetValue() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/stackOverflowOnCallFromGetValue.kt");
        }

        @Test
        @TestMetadata("topLevelVal.kt")
        public void testTopLevelVal() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/topLevelVal.kt");
        }

        @Test
        @TestMetadata("topLevelVar.kt")
        public void testTopLevelVar() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/topLevelVar.kt");
        }

        @Test
        @TestMetadata("twoPropByOneDelegete.kt")
        public void testTwoPropByOneDelegete() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/twoPropByOneDelegete.kt");
        }

        @Test
        @TestMetadata("useKPropertyLater.kt")
        public void testUseKPropertyLater() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/useKPropertyLater.kt");
        }

        @Test
        @TestMetadata("useReflectionOnKProperty.kt")
        public void testUseReflectionOnKProperty() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/useReflectionOnKProperty.kt");
        }

        @Test
        @TestMetadata("valByMapDelegatedProperty.kt")
        public void testValByMapDelegatedProperty() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/valByMapDelegatedProperty.kt");
        }

        @Test
        @TestMetadata("valInInnerClass.kt")
        public void testValInInnerClass() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/valInInnerClass.kt");
        }

        @Test
        @TestMetadata("varInInnerClass.kt")
        public void testVarInInnerClass() throws Exception {
            runTest("compiler/testData/codegen/box/delegatedProperty/varInInnerClass.kt");
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/box/delegatedProperty/delegateToAnother")
        @TestDataPath("$PROJECT_ROOT")
        public class DelegateToAnother {
            @Test
            public void testAllFilesPresentInDelegateToAnother() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/delegatedProperty/delegateToAnother"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("custom.kt")
            public void testCustom() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/delegateToAnother/custom.kt");
            }

            @Test
            @TestMetadata("genericJavaProperty.kt")
            public void testGenericJavaProperty() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/delegateToAnother/genericJavaProperty.kt");
            }

            @Test
            @TestMetadata("kt49793_companionObject.kt")
            public void testKt49793_companionObject() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/delegateToAnother/kt49793_companionObject.kt");
            }

            @Test
            @TestMetadata("kt49793_interfaceCompanionObject.kt")
            public void testKt49793_interfaceCompanionObject() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/delegateToAnother/kt49793_interfaceCompanionObject.kt");
            }

            @Test
            @TestMetadata("kt49793_object.kt")
            public void testKt49793_object() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/delegateToAnother/kt49793_object.kt");
            }

            @Test
            @TestMetadata("kt50019_noOptimizedCallableReferences.kt")
            public void testKt50019_noOptimizedCallableReferences() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/delegateToAnother/kt50019_noOptimizedCallableReferences.kt");
            }

            @Test
            @TestMetadata("mutable.kt")
            public void testMutable() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/delegateToAnother/mutable.kt");
            }

            @Test
            @TestMetadata("openProperty.kt")
            public void testOpenProperty() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/delegateToAnother/openProperty.kt");
            }

            @Test
            @TestMetadata("simple.kt")
            public void testSimple() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/delegateToAnother/simple.kt");
            }

            @Test
            @TestMetadata("withSideEffects.kt")
            public void testWithSideEffects() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/delegateToAnother/withSideEffects.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/box/delegatedProperty/local")
        @TestDataPath("$PROJECT_ROOT")
        public class Local {
            @Test
            public void testAllFilesPresentInLocal() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/delegatedProperty/local"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("capturedLocalVal.kt")
            public void testCapturedLocalVal() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/local/capturedLocalVal.kt");
            }

            @Test
            @TestMetadata("capturedLocalValNoInline.kt")
            public void testCapturedLocalValNoInline() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/local/capturedLocalValNoInline.kt");
            }

            @Test
            @TestMetadata("capturedLocalVar.kt")
            public void testCapturedLocalVar() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/local/capturedLocalVar.kt");
            }

            @Test
            @TestMetadata("capturedLocalVarNoInline.kt")
            public void testCapturedLocalVarNoInline() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/local/capturedLocalVarNoInline.kt");
            }

            @Test
            @TestMetadata("inlineGetValue.kt")
            public void testInlineGetValue() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/local/inlineGetValue.kt");
            }

            @Test
            @TestMetadata("inlineOperators.kt")
            public void testInlineOperators() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/local/inlineOperators.kt");
            }

            @Test
            @TestMetadata("kt12891.kt")
            public void testKt12891() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/local/kt12891.kt");
            }

            @Test
            @TestMetadata("kt13557.kt")
            public void testKt13557() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/local/kt13557.kt");
            }

            @Test
            @TestMetadata("kt16864.kt")
            public void testKt16864() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/local/kt16864.kt");
            }

            @Test
            @TestMetadata("kt19690.kt")
            public void testKt19690() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/local/kt19690.kt");
            }

            @Test
            @TestMetadata("kt21085.kt")
            public void testKt21085() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/local/kt21085.kt");
            }

            @Test
            @TestMetadata("kt23117.kt")
            public void testKt23117() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/local/kt23117.kt");
            }

            @Test
            @TestMetadata("localVal.kt")
            public void testLocalVal() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/local/localVal.kt");
            }

            @Test
            @TestMetadata("localValNoExplicitType.kt")
            public void testLocalValNoExplicitType() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/local/localValNoExplicitType.kt");
            }

            @Test
            @TestMetadata("localVar.kt")
            public void testLocalVar() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/local/localVar.kt");
            }

            @Test
            @TestMetadata("localVarNoExplicitType.kt")
            public void testLocalVarNoExplicitType() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/local/localVarNoExplicitType.kt");
            }

            @Test
            @TestMetadata("useReflectionForLocalVarInLambda.kt")
            public void testUseReflectionForLocalVarInLambda() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/local/useReflectionForLocalVarInLambda.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/box/delegatedProperty/optimizedDelegatedProperties")
        @TestDataPath("$PROJECT_ROOT")
        public class OptimizedDelegatedProperties {
            @Test
            public void testAllFilesPresentInOptimizedDelegatedProperties() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/delegatedProperty/optimizedDelegatedProperties"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("definedInSources.kt")
            public void testDefinedInSources() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/optimizedDelegatedProperties/definedInSources.kt");
            }

            @Test
            @TestMetadata("definedInSourcesWithNonNullParameter.kt")
            public void testDefinedInSourcesWithNonNullParameter() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/optimizedDelegatedProperties/definedInSourcesWithNonNullParameter.kt");
            }

            @Test
            @TestMetadata("inSeparateModule.kt")
            public void testInSeparateModule() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/optimizedDelegatedProperties/inSeparateModule.kt");
            }

            @Test
            @TestMetadata("inSeparateModuleWithNonNullParameter.kt")
            public void testInSeparateModuleWithNonNullParameter() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/optimizedDelegatedProperties/inSeparateModuleWithNonNullParameter.kt");
            }

            @Test
            @TestMetadata("kt40815.kt")
            public void testKt40815() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/optimizedDelegatedProperties/kt40815.kt");
            }

            @Test
            @TestMetadata("kt40815_2.kt")
            public void testKt40815_2() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/optimizedDelegatedProperties/kt40815_2.kt");
            }

            @Test
            @TestMetadata("kt40815_3.kt")
            public void testKt40815_3() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/optimizedDelegatedProperties/kt40815_3.kt");
            }

            @Test
            @TestMetadata("kt42253.kt")
            public void testKt42253() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/optimizedDelegatedProperties/kt42253.kt");
            }

            @Test
            @TestMetadata("kt48825.kt")
            public void testKt48825() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/optimizedDelegatedProperties/kt48825.kt");
            }

            @Test
            @TestMetadata("lazy.kt")
            public void testLazy() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/optimizedDelegatedProperties/lazy.kt");
            }

            @Test
            @TestMetadata("mixedArgumentSizes.kt")
            public void testMixedArgumentSizes() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/optimizedDelegatedProperties/mixedArgumentSizes.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/box/delegatedProperty/provideDelegate")
        @TestDataPath("$PROJECT_ROOT")
        public class ProvideDelegate {
            @Test
            public void testAllFilesPresentInProvideDelegate() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/delegatedProperty/provideDelegate"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("delegatedPropertyWithIdProvideDelegate.kt")
            public void testDelegatedPropertyWithIdProvideDelegate() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/delegatedPropertyWithIdProvideDelegate.kt");
            }

            @Test
            @TestMetadata("differentReceivers.kt")
            public void testDifferentReceivers() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/differentReceivers.kt");
            }

            @Test
            @TestMetadata("evaluationOrder.kt")
            public void testEvaluationOrder() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/evaluationOrder.kt");
            }

            @Test
            @TestMetadata("evaluationOrderVar.kt")
            public void testEvaluationOrderVar() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/evaluationOrderVar.kt");
            }

            @Test
            @TestMetadata("extensionDelegated.kt")
            public void testExtensionDelegated() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/extensionDelegated.kt");
            }

            @Test
            @TestMetadata("generic.kt")
            public void testGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/generic.kt");
            }

            @Test
            @TestMetadata("genericDelegateWithNoAdditionalInfo.kt")
            public void testGenericDelegateWithNoAdditionalInfo() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/genericDelegateWithNoAdditionalInfo.kt");
            }

            @Test
            @TestMetadata("genericProvideDelegateOnNumberLiteral.kt")
            public void testGenericProvideDelegateOnNumberLiteral() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/genericProvideDelegateOnNumberLiteral.kt");
            }

            @Test
            @TestMetadata("hostCheck.kt")
            public void testHostCheck() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/hostCheck.kt");
            }

            @Test
            @TestMetadata("inClass.kt")
            public void testInClass() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/inClass.kt");
            }

            @Test
            @TestMetadata("inlineProvideDelegate.kt")
            public void testInlineProvideDelegate() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/inlineProvideDelegate.kt");
            }

            @Test
            @TestMetadata("jvmStaticInObject.kt")
            public void testJvmStaticInObject() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/jvmStaticInObject.kt");
            }

            @Test
            @TestMetadata("kt15437.kt")
            public void testKt15437() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/kt15437.kt");
            }

            @Test
            @TestMetadata("kt16441.kt")
            public void testKt16441() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/kt16441.kt");
            }

            @Test
            @TestMetadata("kt18902.kt")
            public void testKt18902() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/kt18902.kt");
            }

            @Test
            @TestMetadata("kt39588.kt")
            public void testKt39588() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/kt39588.kt");
            }

            @Test
            @TestMetadata("local.kt")
            public void testLocal() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/local.kt");
            }

            @Test
            @TestMetadata("localCaptured.kt")
            public void testLocalCaptured() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/localCaptured.kt");
            }

            @Test
            @TestMetadata("localDifferentReceivers.kt")
            public void testLocalDifferentReceivers() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/localDifferentReceivers.kt");
            }

            @Test
            @TestMetadata("memberExtension.kt")
            public void testMemberExtension() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/memberExtension.kt");
            }

            @Test
            @TestMetadata("propertyMetadata.kt")
            public void testPropertyMetadata() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/propertyMetadata.kt");
            }

            @Test
            @TestMetadata("provideDelegateByExtensionFunction.kt")
            public void testProvideDelegateByExtensionFunction() throws Exception {
                runTest("compiler/testData/codegen/box/delegatedProperty/provideDelegate/provideDelegateByExtensionFunction.kt");
            }
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/delegation")
    @TestDataPath("$PROJECT_ROOT")
    public class Delegation {
        @Test
        public void testAllFilesPresentInDelegation() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/delegation"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("byMiddleInterface.kt")
        public void testByMiddleInterface() throws Exception {
            runTest("compiler/testData/codegen/box/delegation/byMiddleInterface.kt");
        }

        @Test
        @TestMetadata("defaultOverride.kt")
        public void testDefaultOverride() throws Exception {
            runTest("compiler/testData/codegen/box/delegation/defaultOverride.kt");
        }

        @Test
        @TestMetadata("delegationAndInheritanceFromJava.kt")
        public void testDelegationAndInheritanceFromJava() throws Exception {
            runTest("compiler/testData/codegen/box/delegation/delegationAndInheritanceFromJava.kt");
        }

        @Test
        @TestMetadata("delegationDifferentModule.kt")
        public void testDelegationDifferentModule() throws Exception {
            runTest("compiler/testData/codegen/box/delegation/delegationDifferentModule.kt");
        }

        @Test
        @TestMetadata("delegationToMap.kt")
        public void testDelegationToMap() throws Exception {
            runTest("compiler/testData/codegen/box/delegation/delegationToMap.kt");
        }

        @Test
        @TestMetadata("delegationToVal.kt")
        public void testDelegationToVal() throws Exception {
            runTest("compiler/testData/codegen/box/delegation/delegationToVal.kt");
        }

        @Test
        @TestMetadata("delegationWithPrivateConstructor.kt")
        public void testDelegationWithPrivateConstructor() throws Exception {
            runTest("compiler/testData/codegen/box/delegation/delegationWithPrivateConstructor.kt");
        }

        @Test
        @TestMetadata("diamond.kt")
        public void testDiamond() throws Exception {
            runTest("compiler/testData/codegen/box/delegation/diamond.kt");
        }

        @Test
        @TestMetadata("diamond2.kt")
        public void testDiamond2() throws Exception {
            runTest("compiler/testData/codegen/box/delegation/diamond2.kt");
        }

        @Test
        @TestMetadata("differentModules.kt")
        public void testDifferentModules() throws Exception {
            runTest("compiler/testData/codegen/box/delegation/differentModules.kt");
        }

        @Test
        @TestMetadata("genericProperty.kt")
        public void testGenericProperty() throws Exception {
            runTest("compiler/testData/codegen/box/delegation/genericProperty.kt");
        }

        @Test
        @TestMetadata("hiddenSuperOverrideIn1.0.kt")
        public void testHiddenSuperOverrideIn1_0() throws Exception {
            runTest("compiler/testData/codegen/box/delegation/hiddenSuperOverrideIn1.0.kt");
        }

        @Test
        @TestMetadata("inClassDeclaration.kt")
        public void testInClassDeclaration() throws Exception {
            runTest("compiler/testData/codegen/box/delegation/inClassDeclaration.kt");
        }

        @Test
        @TestMetadata("inDataClass.kt")
        public void testInDataClass() throws Exception {
            runTest("compiler/testData/codegen/box/delegation/inDataClass.kt");
        }

        @Test
        @TestMetadata("kt30102_comparable.kt")
        public void testKt30102_comparable() throws Exception {
            runTest("compiler/testData/codegen/box/delegation/kt30102_comparable.kt");
        }

        @Test
        @TestMetadata("kt8154.kt")
        public void testKt8154() throws Exception {
            runTest("compiler/testData/codegen/box/delegation/kt8154.kt");
        }

        @Test
        @TestMetadata("mixed.kt")
        public void testMixed() throws Exception {
            runTest("compiler/testData/codegen/box/delegation/mixed.kt");
        }

        @Test
        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("compiler/testData/codegen/box/delegation/simple.kt");
        }

        @Test
        @TestMetadata("viaTypeAlias.kt")
        public void testViaTypeAlias() throws Exception {
            runTest("compiler/testData/codegen/box/delegation/viaTypeAlias.kt");
        }

        @Test
        @TestMetadata("withDefaultParameters.kt")
        public void testWithDefaultParameters() throws Exception {
            runTest("compiler/testData/codegen/box/delegation/withDefaultParameters.kt");
        }

        @Test
        @TestMetadata("withDefaultsMultipleFilesOrder.kt")
        public void testWithDefaultsMultipleFilesOrder() throws Exception {
            runTest("compiler/testData/codegen/box/delegation/withDefaultsMultipleFilesOrder.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/deprecated")
    @TestDataPath("$PROJECT_ROOT")
    public class Deprecated {
        @Test
        public void testAllFilesPresentInDeprecated() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/deprecated"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("deprecatedSinceKotlin.kt")
        public void testDeprecatedSinceKotlin() throws Exception {
            runTest("compiler/testData/codegen/box/deprecated/deprecatedSinceKotlin.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/destructuringDeclInLambdaParam")
    @TestDataPath("$PROJECT_ROOT")
    public class DestructuringDeclInLambdaParam {
        @Test
        public void testAllFilesPresentInDestructuringDeclInLambdaParam() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/destructuringDeclInLambdaParam"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("extensionComponents.kt")
        public void testExtensionComponents() throws Exception {
            runTest("compiler/testData/codegen/box/destructuringDeclInLambdaParam/extensionComponents.kt");
        }

        @Test
        @TestMetadata("generic.kt")
        public void testGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/destructuringDeclInLambdaParam/generic.kt");
        }

        @Test
        @TestMetadata("inline.kt")
        public void testInline() throws Exception {
            runTest("compiler/testData/codegen/box/destructuringDeclInLambdaParam/inline.kt");
        }

        @Test
        @TestMetadata("otherParameters.kt")
        public void testOtherParameters() throws Exception {
            runTest("compiler/testData/codegen/box/destructuringDeclInLambdaParam/otherParameters.kt");
        }

        @Test
        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("compiler/testData/codegen/box/destructuringDeclInLambdaParam/simple.kt");
        }

        @Test
        @TestMetadata("stdlibUsages.kt")
        public void testStdlibUsages() throws Exception {
            runTest("compiler/testData/codegen/box/destructuringDeclInLambdaParam/stdlibUsages.kt");
        }

        @Test
        @TestMetadata("underscoreNames.kt")
        public void testUnderscoreNames() throws Exception {
            runTest("compiler/testData/codegen/box/destructuringDeclInLambdaParam/underscoreNames.kt");
        }

        @Test
        @TestMetadata("withIndexed.kt")
        public void testWithIndexed() throws Exception {
            runTest("compiler/testData/codegen/box/destructuringDeclInLambdaParam/withIndexed.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/diagnostics")
    @TestDataPath("$PROJECT_ROOT")
    public class Diagnostics {
        @Test
        public void testAllFilesPresentInDiagnostics() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/diagnostics"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/box/diagnostics/functions")
        @TestDataPath("$PROJECT_ROOT")
        public class Functions {
            @Test
            public void testAllFilesPresentInFunctions() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/diagnostics/functions"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Nested
            @TestMetadata("compiler/testData/codegen/box/diagnostics/functions/inference")
            @TestDataPath("$PROJECT_ROOT")
            public class Inference {
                @Test
                public void testAllFilesPresentInInference() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/diagnostics/functions/inference"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
                }

                @Test
                @TestMetadata("kt6176.kt")
                public void testKt6176() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/inference/kt6176.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/testData/codegen/box/diagnostics/functions/invoke")
            @TestDataPath("$PROJECT_ROOT")
            public class Invoke {
                @Test
                public void testAllFilesPresentInInvoke() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/diagnostics/functions/invoke"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
                }

                @Nested
                @TestMetadata("compiler/testData/codegen/box/diagnostics/functions/invoke/onObjects")
                @TestDataPath("$PROJECT_ROOT")
                public class OnObjects {
                    @Test
                    public void testAllFilesPresentInOnObjects() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/diagnostics/functions/invoke/onObjects"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
                    }

                    @Test
                    @TestMetadata("invokeOnClassObject1.kt")
                    public void testInvokeOnClassObject1() throws Exception {
                        runTest("compiler/testData/codegen/box/diagnostics/functions/invoke/onObjects/invokeOnClassObject1.kt");
                    }

                    @Test
                    @TestMetadata("invokeOnClassObject2.kt")
                    public void testInvokeOnClassObject2() throws Exception {
                        runTest("compiler/testData/codegen/box/diagnostics/functions/invoke/onObjects/invokeOnClassObject2.kt");
                    }

                    @Test
                    @TestMetadata("invokeOnClassObjectOfNestedClass1.kt")
                    public void testInvokeOnClassObjectOfNestedClass1() throws Exception {
                        runTest("compiler/testData/codegen/box/diagnostics/functions/invoke/onObjects/invokeOnClassObjectOfNestedClass1.kt");
                    }

                    @Test
                    @TestMetadata("invokeOnClassObjectOfNestedClass2.kt")
                    public void testInvokeOnClassObjectOfNestedClass2() throws Exception {
                        runTest("compiler/testData/codegen/box/diagnostics/functions/invoke/onObjects/invokeOnClassObjectOfNestedClass2.kt");
                    }

                    @Test
                    @TestMetadata("invokeOnEnum1.kt")
                    public void testInvokeOnEnum1() throws Exception {
                        runTest("compiler/testData/codegen/box/diagnostics/functions/invoke/onObjects/invokeOnEnum1.kt");
                    }

                    @Test
                    @TestMetadata("invokeOnEnum2.kt")
                    public void testInvokeOnEnum2() throws Exception {
                        runTest("compiler/testData/codegen/box/diagnostics/functions/invoke/onObjects/invokeOnEnum2.kt");
                    }

                    @Test
                    @TestMetadata("invokeOnImportedEnum1.kt")
                    public void testInvokeOnImportedEnum1() throws Exception {
                        runTest("compiler/testData/codegen/box/diagnostics/functions/invoke/onObjects/invokeOnImportedEnum1.kt");
                    }

                    @Test
                    @TestMetadata("invokeOnImportedEnum2.kt")
                    public void testInvokeOnImportedEnum2() throws Exception {
                        runTest("compiler/testData/codegen/box/diagnostics/functions/invoke/onObjects/invokeOnImportedEnum2.kt");
                    }

                    @Test
                    @TestMetadata("invokeOnObject1.kt")
                    public void testInvokeOnObject1() throws Exception {
                        runTest("compiler/testData/codegen/box/diagnostics/functions/invoke/onObjects/invokeOnObject1.kt");
                    }

                    @Test
                    @TestMetadata("invokeOnObject2.kt")
                    public void testInvokeOnObject2() throws Exception {
                        runTest("compiler/testData/codegen/box/diagnostics/functions/invoke/onObjects/invokeOnObject2.kt");
                    }
                }
            }

            @Nested
            @TestMetadata("compiler/testData/codegen/box/diagnostics/functions/tailRecursion")
            @TestDataPath("$PROJECT_ROOT")
            public class TailRecursion {
                @Test
                public void testAllFilesPresentInTailRecursion() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/diagnostics/functions/tailRecursion"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
                }

                @Test
                @TestMetadata("defaultArgs.kt")
                public void testDefaultArgs() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/defaultArgs.kt");
                }

                @Test
                @TestMetadata("defaultArgs2.kt")
                public void testDefaultArgs2() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/defaultArgs2.kt");
                }

                @Test
                @TestMetadata("defaultArgsOverridden.kt")
                public void testDefaultArgsOverridden() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/defaultArgsOverridden.kt");
                }

                @Test
                @TestMetadata("defaultArgsWithSideEffects.kt")
                public void testDefaultArgsWithSideEffects() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/defaultArgsWithSideEffects.kt");
                }

                @Test
                @TestMetadata("defaultArgsWithSideEffects2.kt")
                public void testDefaultArgsWithSideEffects2() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/defaultArgsWithSideEffects2.kt");
                }

                @Test
                @TestMetadata("defaultArgsWithSideEffectsOld.kt")
                public void testDefaultArgsWithSideEffectsOld() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/defaultArgsWithSideEffectsOld.kt");
                }

                @Test
                @TestMetadata("extensionTailCall.kt")
                public void testExtensionTailCall() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/extensionTailCall.kt");
                }

                @Test
                @TestMetadata("functionWithNoTails.kt")
                public void testFunctionWithNoTails() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/functionWithNoTails.kt");
                }

                @Test
                @TestMetadata("functionWithNonTailRecursions.kt")
                public void testFunctionWithNonTailRecursions() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/functionWithNonTailRecursions.kt");
                }

                @Test
                @TestMetadata("functionWithoutAnnotation.kt")
                public void testFunctionWithoutAnnotation() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/functionWithoutAnnotation.kt");
                }

                @Test
                @TestMetadata("infixCall.kt")
                public void testInfixCall() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/infixCall.kt");
                }

                @Test
                @TestMetadata("infixRecursiveCall.kt")
                public void testInfixRecursiveCall() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/infixRecursiveCall.kt");
                }

                @Test
                @TestMetadata("insideElvis.kt")
                public void testInsideElvis() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/insideElvis.kt");
                }

                @Test
                @TestMetadata("kt47084_lambdaInDefaultArgument.kt")
                public void testKt47084_lambdaInDefaultArgument() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/kt47084_lambdaInDefaultArgument.kt");
                }

                @Test
                @TestMetadata("labeledThisReferences.kt")
                public void testLabeledThisReferences() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/labeledThisReferences.kt");
                }

                @Test
                @TestMetadata("loops.kt")
                public void testLoops() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/loops.kt");
                }

                @Test
                @TestMetadata("multilevelBlocks.kt")
                public void testMultilevelBlocks() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/multilevelBlocks.kt");
                }

                @Test
                @TestMetadata("realIteratorFoldl.kt")
                public void testRealIteratorFoldl() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/realIteratorFoldl.kt");
                }

                @Test
                @TestMetadata("realStringEscape.kt")
                public void testRealStringEscape() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/realStringEscape.kt");
                }

                @Test
                @TestMetadata("realStringRepeat.kt")
                public void testRealStringRepeat() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/realStringRepeat.kt");
                }

                @Test
                @TestMetadata("recursiveCallInInlineLambda.kt")
                public void testRecursiveCallInInlineLambda() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/recursiveCallInInlineLambda.kt");
                }

                @Test
                @TestMetadata("recursiveCallInInlineLambdaWithCapture.kt")
                public void testRecursiveCallInInlineLambdaWithCapture() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/recursiveCallInInlineLambdaWithCapture.kt");
                }

                @Test
                @TestMetadata("recursiveCallInLambda.kt")
                public void testRecursiveCallInLambda() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/recursiveCallInLambda.kt");
                }

                @Test
                @TestMetadata("recursiveCallInLocalFunction.kt")
                public void testRecursiveCallInLocalFunction() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/recursiveCallInLocalFunction.kt");
                }

                @Test
                @TestMetadata("recursiveInnerFunction.kt")
                public void testRecursiveInnerFunction() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/recursiveInnerFunction.kt");
                }

                @Test
                @TestMetadata("returnIf.kt")
                public void testReturnIf() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/returnIf.kt");
                }

                @Test
                @TestMetadata("returnInCatch.kt")
                public void testReturnInCatch() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/returnInCatch.kt");
                }

                @Test
                @TestMetadata("returnInFinally.kt")
                public void testReturnInFinally() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/returnInFinally.kt");
                }

                @Test
                @TestMetadata("returnInIfInFinally.kt")
                public void testReturnInIfInFinally() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/returnInIfInFinally.kt");
                }

                @Test
                @TestMetadata("returnInParentheses.kt")
                public void testReturnInParentheses() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/returnInParentheses.kt");
                }

                @Test
                @TestMetadata("returnInTry.kt")
                public void testReturnInTry() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/returnInTry.kt");
                }

                @Test
                @TestMetadata("simpleBlock.kt")
                public void testSimpleBlock() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/simpleBlock.kt");
                }

                @Test
                @TestMetadata("simpleReturn.kt")
                public void testSimpleReturn() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/simpleReturn.kt");
                }

                @Test
                @TestMetadata("simpleReturnWithElse.kt")
                public void testSimpleReturnWithElse() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/simpleReturnWithElse.kt");
                }

                @Test
                @TestMetadata("sum.kt")
                public void testSum() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/sum.kt");
                }

                @Test
                @TestMetadata("tailCallInBlockInParentheses.kt")
                public void testTailCallInBlockInParentheses() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/tailCallInBlockInParentheses.kt");
                }

                @Test
                @TestMetadata("tailCallInParentheses.kt")
                public void testTailCallInParentheses() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/tailCallInParentheses.kt");
                }

                @Test
                @TestMetadata("tailRecursionInFinally.kt")
                public void testTailRecursionInFinally() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/tailRecursionInFinally.kt");
                }

                @Test
                @TestMetadata("tailrecWithExplicitCompanionObjectDispatcher.kt")
                public void testTailrecWithExplicitCompanionObjectDispatcher() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/tailrecWithExplicitCompanionObjectDispatcher.kt");
                }

                @Test
                @TestMetadata("tailrecWithExplicitObjectDispatcher.kt")
                public void testTailrecWithExplicitObjectDispatcher() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/tailrecWithExplicitObjectDispatcher.kt");
                }

                @Test
                @TestMetadata("thisReferences.kt")
                public void testThisReferences() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/thisReferences.kt");
                }

                @Test
                @TestMetadata("unitBlocks.kt")
                public void testUnitBlocks() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/unitBlocks.kt");
                }

                @Test
                @TestMetadata("whenWithCondition.kt")
                public void testWhenWithCondition() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/whenWithCondition.kt");
                }

                @Test
                @TestMetadata("whenWithInRange.kt")
                public void testWhenWithInRange() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/whenWithInRange.kt");
                }

                @Test
                @TestMetadata("whenWithIs.kt")
                public void testWhenWithIs() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/whenWithIs.kt");
                }

                @Test
                @TestMetadata("whenWithoutCondition.kt")
                public void testWhenWithoutCondition() throws Exception {
                    runTest("compiler/testData/codegen/box/diagnostics/functions/tailRecursion/whenWithoutCondition.kt");
                }
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/box/diagnostics/vararg")
        @TestDataPath("$PROJECT_ROOT")
        public class Vararg {
            @Test
            public void testAllFilesPresentInVararg() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/diagnostics/vararg"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("kt4172.kt")
            public void testKt4172() throws Exception {
                runTest("compiler/testData/codegen/box/diagnostics/vararg/kt4172.kt");
            }
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/differentDependencyVersion")
    @TestDataPath("$PROJECT_ROOT")
    public class DifferentDependencyVersion {
        @Test
        public void testAllFilesPresentInDifferentDependencyVersion() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/differentDependencyVersion"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("kt51194_java.kt")
        public void testKt51194_java() throws Exception {
            runTest("compiler/testData/codegen/box/differentDependencyVersion/kt51194_java.kt");
        }

        @Test
        @TestMetadata("kt51194_javaAndKotlin.kt")
        public void testKt51194_javaAndKotlin() throws Exception {
            runTest("compiler/testData/codegen/box/differentDependencyVersion/kt51194_javaAndKotlin.kt");
        }

        @Test
        @TestMetadata("kt51194_kotlin.kt")
        public void testKt51194_kotlin() throws Exception {
            runTest("compiler/testData/codegen/box/differentDependencyVersion/kt51194_kotlin.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/directInvokeOptimization")
    @TestDataPath("$PROJECT_ROOT")
    public class DirectInvokeOptimization {
        @Test
        public void testAllFilesPresentInDirectInvokeOptimization() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/directInvokeOptimization"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("boundInnerContructorRef.kt")
        public void testBoundInnerContructorRef() throws Exception {
            runTest("compiler/testData/codegen/box/directInvokeOptimization/boundInnerContructorRef.kt");
        }

        @Test
        @TestMetadata("boundMemberRef.kt")
        public void testBoundMemberRef() throws Exception {
            runTest("compiler/testData/codegen/box/directInvokeOptimization/boundMemberRef.kt");
        }

        @Test
        @TestMetadata("capturingLambda.kt")
        public void testCapturingLambda() throws Exception {
            runTest("compiler/testData/codegen/box/directInvokeOptimization/capturingLambda.kt");
        }

        @Test
        @TestMetadata("contructorRef.kt")
        public void testContructorRef() throws Exception {
            runTest("compiler/testData/codegen/box/directInvokeOptimization/contructorRef.kt");
        }

        @Test
        @TestMetadata("nestedLambdas.kt")
        public void testNestedLambdas() throws Exception {
            runTest("compiler/testData/codegen/box/directInvokeOptimization/nestedLambdas.kt");
        }

        @Test
        @TestMetadata("simpleAnonymousFun.kt")
        public void testSimpleAnonymousFun() throws Exception {
            runTest("compiler/testData/codegen/box/directInvokeOptimization/simpleAnonymousFun.kt");
        }

        @Test
        @TestMetadata("simpleFunRef.kt")
        public void testSimpleFunRef() throws Exception {
            runTest("compiler/testData/codegen/box/directInvokeOptimization/simpleFunRef.kt");
        }

        @Test
        @TestMetadata("simpleLambda.kt")
        public void testSimpleLambda() throws Exception {
            runTest("compiler/testData/codegen/box/directInvokeOptimization/simpleLambda.kt");
        }

        @Test
        @TestMetadata("unboundInnerContructorRef.kt")
        public void testUnboundInnerContructorRef() throws Exception {
            runTest("compiler/testData/codegen/box/directInvokeOptimization/unboundInnerContructorRef.kt");
        }

        @Test
        @TestMetadata("unboundMemberRef.kt")
        public void testUnboundMemberRef() throws Exception {
            runTest("compiler/testData/codegen/box/directInvokeOptimization/unboundMemberRef.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/elvis")
    @TestDataPath("$PROJECT_ROOT")
    public class Elvis {
        @Test
        public void testAllFilesPresentInElvis() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/elvis"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("genericElvisWithMoreSpecificLHS.kt")
        public void testGenericElvisWithMoreSpecificLHS() throws Exception {
            runTest("compiler/testData/codegen/box/elvis/genericElvisWithMoreSpecificLHS.kt");
        }

        @Test
        @TestMetadata("genericElvisWithNullLHS.kt")
        public void testGenericElvisWithNullLHS() throws Exception {
            runTest("compiler/testData/codegen/box/elvis/genericElvisWithNullLHS.kt");
        }

        @Test
        @TestMetadata("genericNull.kt")
        public void testGenericNull() throws Exception {
            runTest("compiler/testData/codegen/box/elvis/genericNull.kt");
        }

        @Test
        @TestMetadata("kt24209.kt")
        public void testKt24209() throws Exception {
            runTest("compiler/testData/codegen/box/elvis/kt24209.kt");
        }

        @Test
        @TestMetadata("kt6694ExactAnnotationForElvis.kt")
        public void testKt6694ExactAnnotationForElvis() throws Exception {
            runTest("compiler/testData/codegen/box/elvis/kt6694ExactAnnotationForElvis.kt");
        }

        @Test
        @TestMetadata("nullNullOk.kt")
        public void testNullNullOk() throws Exception {
            runTest("compiler/testData/codegen/box/elvis/nullNullOk.kt");
        }

        @Test
        @TestMetadata("ofNonNullableResultType.kt")
        public void testOfNonNullableResultType() throws Exception {
            runTest("compiler/testData/codegen/box/elvis/ofNonNullableResultType.kt");
        }

        @Test
        @TestMetadata("primitive.kt")
        public void testPrimitive() throws Exception {
            runTest("compiler/testData/codegen/box/elvis/primitive.kt");
        }

        @Test
        @TestMetadata("withReturn.kt")
        public void testWithReturn() throws Exception {
            runTest("compiler/testData/codegen/box/elvis/withReturn.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/enum")
    @TestDataPath("$PROJECT_ROOT")
    public class Enum {
        @Test
        @TestMetadata("abstractMethodInEnum.kt")
        public void testAbstractMethodInEnum() throws Exception {
            runTest("compiler/testData/codegen/box/enum/abstractMethodInEnum.kt");
        }

        @Test
        @TestMetadata("abstractNestedClass.kt")
        public void testAbstractNestedClass() throws Exception {
            runTest("compiler/testData/codegen/box/enum/abstractNestedClass.kt");
        }

        @Test
        public void testAllFilesPresentInEnum() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/enum"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("annotatedParameter.kt")
        public void testAnnotatedParameter() throws Exception {
            runTest("compiler/testData/codegen/box/enum/annotatedParameter.kt");
        }

        @Test
        @TestMetadata("annotatedParameter2.kt")
        public void testAnnotatedParameter2() throws Exception {
            runTest("compiler/testData/codegen/box/enum/annotatedParameter2.kt");
        }

        @Test
        @TestMetadata("asReturnExpression.kt")
        public void testAsReturnExpression() throws Exception {
            runTest("compiler/testData/codegen/box/enum/asReturnExpression.kt");
        }

        @Test
        @TestMetadata("bigEnum.kt")
        public void testBigEnum() throws Exception {
            runTest("compiler/testData/codegen/box/enum/bigEnum.kt");
        }

        @Test
        @TestMetadata("classForEnumEntry.kt")
        public void testClassForEnumEntry() throws Exception {
            runTest("compiler/testData/codegen/box/enum/classForEnumEntry.kt");
        }

        @Test
        @TestMetadata("companionAccessingEnumValue.kt")
        public void testCompanionAccessingEnumValue() throws Exception {
            runTest("compiler/testData/codegen/box/enum/companionAccessingEnumValue.kt");
        }

        @Test
        @TestMetadata("companionObjectInEnum.kt")
        public void testCompanionObjectInEnum() throws Exception {
            runTest("compiler/testData/codegen/box/enum/companionObjectInEnum.kt");
        }

        @Test
        @TestMetadata("constructorWithReordering.kt")
        public void testConstructorWithReordering() throws Exception {
            runTest("compiler/testData/codegen/box/enum/constructorWithReordering.kt");
        }

        @Test
        @TestMetadata("declaringClassOnEnumObject.kt")
        public void testDeclaringClassOnEnumObject() throws Exception {
            runTest("compiler/testData/codegen/box/enum/declaringClassOnEnumObject.kt");
        }

        @Test
        @TestMetadata("deepInnerClassInEnumEntryClass.kt")
        public void testDeepInnerClassInEnumEntryClass() throws Exception {
            runTest("compiler/testData/codegen/box/enum/deepInnerClassInEnumEntryClass.kt");
        }

        @Test
        @TestMetadata("deepInnerClassInEnumEntryClass2.kt")
        public void testDeepInnerClassInEnumEntryClass2() throws Exception {
            runTest("compiler/testData/codegen/box/enum/deepInnerClassInEnumEntryClass2.kt");
        }

        @Test
        @TestMetadata("emptyConstructor.kt")
        public void testEmptyConstructor() throws Exception {
            runTest("compiler/testData/codegen/box/enum/emptyConstructor.kt");
        }

        @Test
        @TestMetadata("emptyEnumValuesValueOf.kt")
        public void testEmptyEnumValuesValueOf() throws Exception {
            runTest("compiler/testData/codegen/box/enum/emptyEnumValuesValueOf.kt");
        }

        @Test
        @TestMetadata("enumCompanionInit.kt")
        public void testEnumCompanionInit() throws Exception {
            runTest("compiler/testData/codegen/box/enum/enumCompanionInit.kt");
        }

        @Test
        @TestMetadata("enumConstructorParameterClashWithDefaults.kt")
        public void testEnumConstructorParameterClashWithDefaults() throws Exception {
            runTest("compiler/testData/codegen/box/enum/enumConstructorParameterClashWithDefaults.kt");
        }

        @Test
        @TestMetadata("enumEntryMembers.kt")
        public void testEnumEntryMembers() throws Exception {
            runTest("compiler/testData/codegen/box/enum/enumEntryMembers.kt");
        }

        @Test
        @TestMetadata("enumEntryReferenceFromInnerClassConstructor1.kt")
        public void testEnumEntryReferenceFromInnerClassConstructor1() throws Exception {
            runTest("compiler/testData/codegen/box/enum/enumEntryReferenceFromInnerClassConstructor1.kt");
        }

        @Test
        @TestMetadata("enumEntryReferenceFromInnerClassConstructor2.kt")
        public void testEnumEntryReferenceFromInnerClassConstructor2() throws Exception {
            runTest("compiler/testData/codegen/box/enum/enumEntryReferenceFromInnerClassConstructor2.kt");
        }

        @Test
        @TestMetadata("enumEntryReferenceFromInnerClassConstructor3.kt")
        public void testEnumEntryReferenceFromInnerClassConstructor3() throws Exception {
            runTest("compiler/testData/codegen/box/enum/enumEntryReferenceFromInnerClassConstructor3.kt");
        }

        @Test
        @TestMetadata("enumInheritedFromTrait.kt")
        public void testEnumInheritedFromTrait() throws Exception {
            runTest("compiler/testData/codegen/box/enum/enumInheritedFromTrait.kt");
        }

        @Test
        @TestMetadata("enumMultiModule.kt")
        public void testEnumMultiModule() throws Exception {
            runTest("compiler/testData/codegen/box/enum/enumMultiModule.kt");
        }

        @Test
        @TestMetadata("enumShort.kt")
        public void testEnumShort() throws Exception {
            runTest("compiler/testData/codegen/box/enum/enumShort.kt");
        }

        @Test
        @TestMetadata("enumValueOf.kt")
        public void testEnumValueOf() throws Exception {
            runTest("compiler/testData/codegen/box/enum/enumValueOf.kt");
        }

        @Test
        @TestMetadata("enumWithLambdaParameter.kt")
        public void testEnumWithLambdaParameter() throws Exception {
            runTest("compiler/testData/codegen/box/enum/enumWithLambdaParameter.kt");
        }

        @Test
        @TestMetadata("getEnumEntityByOrdinal.kt")
        public void testGetEnumEntityByOrdinal() throws Exception {
            runTest("compiler/testData/codegen/box/enum/getEnumEntityByOrdinal.kt");
        }

        @Test
        @TestMetadata("inPackage.kt")
        public void testInPackage() throws Exception {
            runTest("compiler/testData/codegen/box/enum/inPackage.kt");
        }

        @Test
        @TestMetadata("inclassobj.kt")
        public void testInclassobj() throws Exception {
            runTest("compiler/testData/codegen/box/enum/inclassobj.kt");
        }

        @Test
        @TestMetadata("initEntriesInCompanionObject.kt")
        public void testInitEntriesInCompanionObject() throws Exception {
            runTest("compiler/testData/codegen/box/enum/initEntriesInCompanionObject.kt");
        }

        @Test
        @TestMetadata("initEntriesInCompanionObject2.kt")
        public void testInitEntriesInCompanionObject2() throws Exception {
            runTest("compiler/testData/codegen/box/enum/initEntriesInCompanionObject2.kt");
        }

        @Test
        @TestMetadata("initEntriesInValueOf.kt")
        public void testInitEntriesInValueOf() throws Exception {
            runTest("compiler/testData/codegen/box/enum/initEntriesInValueOf.kt");
        }

        @Test
        @TestMetadata("initEnumAfterObjectAccess.kt")
        public void testInitEnumAfterObjectAccess() throws Exception {
            runTest("compiler/testData/codegen/box/enum/initEnumAfterObjectAccess.kt");
        }

        @Test
        @TestMetadata("inner.kt")
        public void testInner() throws Exception {
            runTest("compiler/testData/codegen/box/enum/inner.kt");
        }

        @Test
        @TestMetadata("innerClassInEnumEntryClass.kt")
        public void testInnerClassInEnumEntryClass() throws Exception {
            runTest("compiler/testData/codegen/box/enum/innerClassInEnumEntryClass.kt");
        }

        @Test
        @TestMetadata("innerClassMethodInEnumEntryClass.kt")
        public void testInnerClassMethodInEnumEntryClass() throws Exception {
            runTest("compiler/testData/codegen/box/enum/innerClassMethodInEnumEntryClass.kt");
        }

        @Test
        @TestMetadata("innerClassMethodInEnumEntryClass2.kt")
        public void testInnerClassMethodInEnumEntryClass2() throws Exception {
            runTest("compiler/testData/codegen/box/enum/innerClassMethodInEnumEntryClass2.kt");
        }

        @Test
        @TestMetadata("innerWithExistingClassObject.kt")
        public void testInnerWithExistingClassObject() throws Exception {
            runTest("compiler/testData/codegen/box/enum/innerWithExistingClassObject.kt");
        }

        @Test
        @TestMetadata("javaClassWithNestedEnum.kt")
        public void testJavaClassWithNestedEnum() throws Exception {
            runTest("compiler/testData/codegen/box/enum/javaClassWithNestedEnum.kt");
        }

        @Test
        @TestMetadata("javaEnumValueOf.kt")
        public void testJavaEnumValueOf() throws Exception {
            runTest("compiler/testData/codegen/box/enum/javaEnumValueOf.kt");
        }

        @Test
        @TestMetadata("javaEnumValueOf2.kt")
        public void testJavaEnumValueOf2() throws Exception {
            runTest("compiler/testData/codegen/box/enum/javaEnumValueOf2.kt");
        }

        @Test
        @TestMetadata("javaEnumValues.kt")
        public void testJavaEnumValues() throws Exception {
            runTest("compiler/testData/codegen/box/enum/javaEnumValues.kt");
        }

        @Test
        @TestMetadata("javaEnumValues2.kt")
        public void testJavaEnumValues2() throws Exception {
            runTest("compiler/testData/codegen/box/enum/javaEnumValues2.kt");
        }

        @Test
        @TestMetadata("javaEnumValues3.kt")
        public void testJavaEnumValues3() throws Exception {
            runTest("compiler/testData/codegen/box/enum/javaEnumValues3.kt");
        }

        @Test
        @TestMetadata("kt1119.kt")
        public void testKt1119() throws Exception {
            runTest("compiler/testData/codegen/box/enum/kt1119.kt");
        }

        @Test
        @TestMetadata("kt18731.kt")
        public void testKt18731() throws Exception {
            runTest("compiler/testData/codegen/box/enum/kt18731.kt");
        }

        @Test
        @TestMetadata("kt18731_2.kt")
        public void testKt18731_2() throws Exception {
            runTest("compiler/testData/codegen/box/enum/kt18731_2.kt");
        }

        @Test
        @TestMetadata("kt20651.kt")
        public void testKt20651() throws Exception {
            runTest("compiler/testData/codegen/box/enum/kt20651.kt");
        }

        @Test
        @TestMetadata("kt20651_inlineLambda.kt")
        public void testKt20651_inlineLambda() throws Exception {
            runTest("compiler/testData/codegen/box/enum/kt20651_inlineLambda.kt");
        }

        @Test
        @TestMetadata("kt20651a.kt")
        public void testKt20651a() throws Exception {
            runTest("compiler/testData/codegen/box/enum/kt20651a.kt");
        }

        @Test
        @TestMetadata("kt20651b.kt")
        public void testKt20651b() throws Exception {
            runTest("compiler/testData/codegen/box/enum/kt20651b.kt");
        }

        @Test
        @TestMetadata("kt2350.kt")
        public void testKt2350() throws Exception {
            runTest("compiler/testData/codegen/box/enum/kt2350.kt");
        }

        @Test
        @TestMetadata("kt38996.kt")
        public void testKt38996() throws Exception {
            runTest("compiler/testData/codegen/box/enum/kt38996.kt");
        }

        @Test
        @TestMetadata("kt44744.kt")
        public void testKt44744() throws Exception {
            runTest("compiler/testData/codegen/box/enum/kt44744.kt");
        }

        @Test
        @TestMetadata("kt44744_innerClass.kt")
        public void testKt44744_innerClass() throws Exception {
            runTest("compiler/testData/codegen/box/enum/kt44744_innerClass.kt");
        }

        @Test
        @TestMetadata("kt46605.kt")
        public void testKt46605() throws Exception {
            runTest("compiler/testData/codegen/box/enum/kt46605.kt");
        }

        @Test
        @TestMetadata("kt7257.kt")
        public void testKt7257() throws Exception {
            runTest("compiler/testData/codegen/box/enum/kt7257.kt");
        }

        @Test
        @TestMetadata("kt7257_anonObjectInit.kt")
        public void testKt7257_anonObjectInit() throws Exception {
            runTest("compiler/testData/codegen/box/enum/kt7257_anonObjectInit.kt");
        }

        @Test
        @TestMetadata("kt7257_anonObjectMethod.kt")
        public void testKt7257_anonObjectMethod() throws Exception {
            runTest("compiler/testData/codegen/box/enum/kt7257_anonObjectMethod.kt");
        }

        @Test
        @TestMetadata("kt7257_boundReference1.kt")
        public void testKt7257_boundReference1() throws Exception {
            runTest("compiler/testData/codegen/box/enum/kt7257_boundReference1.kt");
        }

        @Test
        @TestMetadata("kt7257_boundReference2.kt")
        public void testKt7257_boundReference2() throws Exception {
            runTest("compiler/testData/codegen/box/enum/kt7257_boundReference2.kt");
        }

        @Test
        @TestMetadata("kt7257_boundReferenceWithImplicitReceiver.kt")
        public void testKt7257_boundReferenceWithImplicitReceiver() throws Exception {
            runTest("compiler/testData/codegen/box/enum/kt7257_boundReferenceWithImplicitReceiver.kt");
        }

        @Test
        @TestMetadata("kt7257_explicitReceiver.kt")
        public void testKt7257_explicitReceiver() throws Exception {
            runTest("compiler/testData/codegen/box/enum/kt7257_explicitReceiver.kt");
        }

        @Test
        @TestMetadata("kt7257_fullyQualifiedReceiver.kt")
        public void testKt7257_fullyQualifiedReceiver() throws Exception {
            runTest("compiler/testData/codegen/box/enum/kt7257_fullyQualifiedReceiver.kt");
        }

        @Test
        @TestMetadata("kt7257_namedLocalFun.kt")
        public void testKt7257_namedLocalFun() throws Exception {
            runTest("compiler/testData/codegen/box/enum/kt7257_namedLocalFun.kt");
        }

        @Test
        @TestMetadata("kt7257_notInline.kt")
        public void testKt7257_notInline() throws Exception {
            runTest("compiler/testData/codegen/box/enum/kt7257_notInline.kt");
        }

        @Test
        @TestMetadata("kt9711.kt")
        public void testKt9711() throws Exception {
            runTest("compiler/testData/codegen/box/enum/kt9711.kt");
        }

        @Test
        @TestMetadata("kt9711_2.kt")
        public void testKt9711_2() throws Exception {
            runTest("compiler/testData/codegen/box/enum/kt9711_2.kt");
        }

        @Test
        @TestMetadata("manyDefaultParameters.kt")
        public void testManyDefaultParameters() throws Exception {
            runTest("compiler/testData/codegen/box/enum/manyDefaultParameters.kt");
        }

        @Test
        @TestMetadata("modifierFlags.kt")
        public void testModifierFlags() throws Exception {
            runTest("compiler/testData/codegen/box/enum/modifierFlags.kt");
        }

        @Test
        @TestMetadata("nameClashWithCompanion.kt")
        public void testNameClashWithCompanion() throws Exception {
            runTest("compiler/testData/codegen/box/enum/nameClashWithCompanion.kt");
        }

        @Test
        @TestMetadata("nameConflict.kt")
        public void testNameConflict() throws Exception {
            runTest("compiler/testData/codegen/box/enum/nameConflict.kt");
        }

        @Test
        @TestMetadata("noClassForSimpleEnum.kt")
        public void testNoClassForSimpleEnum() throws Exception {
            runTest("compiler/testData/codegen/box/enum/noClassForSimpleEnum.kt");
        }

        @Test
        @TestMetadata("objectInEnum.kt")
        public void testObjectInEnum() throws Exception {
            runTest("compiler/testData/codegen/box/enum/objectInEnum.kt");
        }

        @Test
        @TestMetadata("ordinal.kt")
        public void testOrdinal() throws Exception {
            runTest("compiler/testData/codegen/box/enum/ordinal.kt");
        }

        @Test
        @TestMetadata("ordinalsWithEnumEntitiesOverrides.kt")
        public void testOrdinalsWithEnumEntitiesOverrides() throws Exception {
            runTest("compiler/testData/codegen/box/enum/ordinalsWithEnumEntitiesOverrides.kt");
        }

        @Test
        @TestMetadata("overloadedEnumValues.kt")
        public void testOverloadedEnumValues() throws Exception {
            runTest("compiler/testData/codegen/box/enum/overloadedEnumValues.kt");
        }

        @Test
        @TestMetadata("overloadedEnumValuesStatic.kt")
        public void testOverloadedEnumValuesStatic() throws Exception {
            runTest("compiler/testData/codegen/box/enum/overloadedEnumValuesStatic.kt");
        }

        @Test
        @TestMetadata("refToThis.kt")
        public void testRefToThis() throws Exception {
            runTest("compiler/testData/codegen/box/enum/refToThis.kt");
        }

        @Test
        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("compiler/testData/codegen/box/enum/simple.kt");
        }

        @Test
        @TestMetadata("simpleJavaEnum.kt")
        public void testSimpleJavaEnum() throws Exception {
            runTest("compiler/testData/codegen/box/enum/simpleJavaEnum.kt");
        }

        @Test
        @TestMetadata("simpleJavaEnumWithFunction.kt")
        public void testSimpleJavaEnumWithFunction() throws Exception {
            runTest("compiler/testData/codegen/box/enum/simpleJavaEnumWithFunction.kt");
        }

        @Test
        @TestMetadata("simpleJavaEnumWithStaticImport.kt")
        public void testSimpleJavaEnumWithStaticImport() throws Exception {
            runTest("compiler/testData/codegen/box/enum/simpleJavaEnumWithStaticImport.kt");
        }

        @Test
        @TestMetadata("simpleJavaInnerEnum.kt")
        public void testSimpleJavaInnerEnum() throws Exception {
            runTest("compiler/testData/codegen/box/enum/simpleJavaInnerEnum.kt");
        }

        @Test
        @TestMetadata("sortEnumEntries.kt")
        public void testSortEnumEntries() throws Exception {
            runTest("compiler/testData/codegen/box/enum/sortEnumEntries.kt");
        }

        @Test
        @TestMetadata("staticField.kt")
        public void testStaticField() throws Exception {
            runTest("compiler/testData/codegen/box/enum/staticField.kt");
        }

        @Test
        @TestMetadata("staticMethod.kt")
        public void testStaticMethod() throws Exception {
            runTest("compiler/testData/codegen/box/enum/staticMethod.kt");
        }

        @Test
        @TestMetadata("superCallInEnumLiteral.kt")
        public void testSuperCallInEnumLiteral() throws Exception {
            runTest("compiler/testData/codegen/box/enum/superCallInEnumLiteral.kt");
        }

        @Test
        @TestMetadata("toString.kt")
        public void testToString() throws Exception {
            runTest("compiler/testData/codegen/box/enum/toString.kt");
        }

        @Test
        @TestMetadata("valueof.kt")
        public void testValueof() throws Exception {
            runTest("compiler/testData/codegen/box/enum/valueof.kt");
        }

        @Test
        @TestMetadata("whenInObject.kt")
        public void testWhenInObject() throws Exception {
            runTest("compiler/testData/codegen/box/enum/whenInObject.kt");
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/box/enum/defaultCtor")
        @TestDataPath("$PROJECT_ROOT")
        public class DefaultCtor {
            @Test
            public void testAllFilesPresentInDefaultCtor() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/enum/defaultCtor"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("constructorWithDefaultArguments.kt")
            public void testConstructorWithDefaultArguments() throws Exception {
                runTest("compiler/testData/codegen/box/enum/defaultCtor/constructorWithDefaultArguments.kt");
            }

            @Test
            @TestMetadata("constructorWithVararg.kt")
            public void testConstructorWithVararg() throws Exception {
                runTest("compiler/testData/codegen/box/enum/defaultCtor/constructorWithVararg.kt");
            }

            @Test
            @TestMetadata("entryClassConstructorWithDefaultArguments.kt")
            public void testEntryClassConstructorWithDefaultArguments() throws Exception {
                runTest("compiler/testData/codegen/box/enum/defaultCtor/entryClassConstructorWithDefaultArguments.kt");
            }

            @Test
            @TestMetadata("entryClassConstructorWithVarargs.kt")
            public void testEntryClassConstructorWithVarargs() throws Exception {
                runTest("compiler/testData/codegen/box/enum/defaultCtor/entryClassConstructorWithVarargs.kt");
            }

            @Test
            @TestMetadata("secondaryConstructorWithDefaultArguments.kt")
            public void testSecondaryConstructorWithDefaultArguments() throws Exception {
                runTest("compiler/testData/codegen/box/enum/defaultCtor/secondaryConstructorWithDefaultArguments.kt");
            }

            @Test
            @TestMetadata("secondaryConstructorWithVararg.kt")
            public void testSecondaryConstructorWithVararg() throws Exception {
                runTest("compiler/testData/codegen/box/enum/defaultCtor/secondaryConstructorWithVararg.kt");
            }
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/evaluate")
    @TestDataPath("$PROJECT_ROOT")
    public class Evaluate {
        @Test
        public void testAllFilesPresentInEvaluate() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/evaluate"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("char.kt")
        public void testChar() throws Exception {
            runTest("compiler/testData/codegen/box/evaluate/char.kt");
        }

        @Test
        @TestMetadata("divide.kt")
        public void testDivide() throws Exception {
            runTest("compiler/testData/codegen/box/evaluate/divide.kt");
        }

        @Test
        @TestMetadata("floorDiv.kt")
        public void testFloorDiv() throws Exception {
            runTest("compiler/testData/codegen/box/evaluate/floorDiv.kt");
        }

        @Test
        @TestMetadata("intrinsics.kt")
        public void testIntrinsics() throws Exception {
            runTest("compiler/testData/codegen/box/evaluate/intrinsics.kt");
        }

        @Test
        @TestMetadata("kt9443.kt")
        public void testKt9443() throws Exception {
            runTest("compiler/testData/codegen/box/evaluate/kt9443.kt");
        }

        @Test
        @TestMetadata("maxValue.kt")
        public void testMaxValue() throws Exception {
            runTest("compiler/testData/codegen/box/evaluate/maxValue.kt");
        }

        @Test
        @TestMetadata("maxValueByte.kt")
        public void testMaxValueByte() throws Exception {
            runTest("compiler/testData/codegen/box/evaluate/maxValueByte.kt");
        }

        @Test
        @TestMetadata("maxValueInt.kt")
        public void testMaxValueInt() throws Exception {
            runTest("compiler/testData/codegen/box/evaluate/maxValueInt.kt");
        }

        @Test
        @TestMetadata("minus.kt")
        public void testMinus() throws Exception {
            runTest("compiler/testData/codegen/box/evaluate/minus.kt");
        }

        @Test
        @TestMetadata("mod.kt")
        public void testMod() throws Exception {
            runTest("compiler/testData/codegen/box/evaluate/mod.kt");
        }

        @Test
        @TestMetadata("multiply.kt")
        public void testMultiply() throws Exception {
            runTest("compiler/testData/codegen/box/evaluate/multiply.kt");
        }

        @Test
        @TestMetadata("parenthesized.kt")
        public void testParenthesized() throws Exception {
            runTest("compiler/testData/codegen/box/evaluate/parenthesized.kt");
        }

        @Test
        @TestMetadata("plus.kt")
        public void testPlus() throws Exception {
            runTest("compiler/testData/codegen/box/evaluate/plus.kt");
        }

        @Test
        @TestMetadata("rem.kt")
        public void testRem() throws Exception {
            runTest("compiler/testData/codegen/box/evaluate/rem.kt");
        }

        @Test
        @TestMetadata("simpleCallBinary.kt")
        public void testSimpleCallBinary() throws Exception {
            runTest("compiler/testData/codegen/box/evaluate/simpleCallBinary.kt");
        }

        @Test
        @TestMetadata("unaryMinus.kt")
        public void testUnaryMinus() throws Exception {
            runTest("compiler/testData/codegen/box/evaluate/unaryMinus.kt");
        }

        @Test
        @TestMetadata("unaryPlus.kt")
        public void testUnaryPlus() throws Exception {
            runTest("compiler/testData/codegen/box/evaluate/unaryPlus.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/exclExcl")
    @TestDataPath("$PROJECT_ROOT")
    public class ExclExcl {
        @Test
        public void testAllFilesPresentInExclExcl() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/exclExcl"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("genericNull.kt")
        public void testGenericNull() throws Exception {
            runTest("compiler/testData/codegen/box/exclExcl/genericNull.kt");
        }

        @Test
        @TestMetadata("kt48440.kt")
        public void testKt48440() throws Exception {
            runTest("compiler/testData/codegen/box/exclExcl/kt48440.kt");
        }

        @Test
        @TestMetadata("kt48440_2.kt")
        public void testKt48440_2() throws Exception {
            runTest("compiler/testData/codegen/box/exclExcl/kt48440_2.kt");
        }

        @Test
        @TestMetadata("primitive.kt")
        public void testPrimitive() throws Exception {
            runTest("compiler/testData/codegen/box/exclExcl/primitive.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/extensionClasses")
    @TestDataPath("$PROJECT_ROOT")
    public class ExtensionClasses {
        @Test
        public void testAllFilesPresentInExtensionClasses() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/extensionClasses"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("constructors.kt")
        public void testConstructors() throws Exception {
            runTest("compiler/testData/codegen/box/extensionClasses/constructors.kt");
        }

        @Test
        @TestMetadata("contextualPrimaryConstructorWithParams.kt")
        public void testContextualPrimaryConstructorWithParams() throws Exception {
            runTest("compiler/testData/codegen/box/extensionClasses/contextualPrimaryConstructorWithParams.kt");
        }

        @Test
        @TestMetadata("edouble.kt")
        public void testEdouble() throws Exception {
            runTest("compiler/testData/codegen/box/extensionClasses/edouble.kt");
        }

        @Test
        @TestMetadata("genericCollection.kt")
        public void testGenericCollection() throws Exception {
            runTest("compiler/testData/codegen/box/extensionClasses/genericCollection.kt");
        }

        @Test
        @TestMetadata("generics.kt")
        public void testGenerics() throws Exception {
            runTest("compiler/testData/codegen/box/extensionClasses/generics.kt");
        }

        @Test
        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("compiler/testData/codegen/box/extensionClasses/simple.kt");
        }

        @Test
        @TestMetadata("typealiasForContextualClass.kt")
        public void testTypealiasForContextualClass() throws Exception {
            runTest("compiler/testData/codegen/box/extensionClasses/typealiasForContextualClass.kt");
        }

        @Test
        @TestMetadata("useFromAnotherModule.kt")
        public void testUseFromAnotherModule() throws Exception {
            runTest("compiler/testData/codegen/box/extensionClasses/useFromAnotherModule.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/extensionFunctions")
    @TestDataPath("$PROJECT_ROOT")
    public class ExtensionFunctions {
        @Test
        public void testAllFilesPresentInExtensionFunctions() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/extensionFunctions"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("classMethodCallExtensionSuper.kt")
        public void testClassMethodCallExtensionSuper() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/classMethodCallExtensionSuper.kt");
        }

        @Test
        @TestMetadata("defaultMethodInterfaceCallExtensionSuper.kt")
        public void testDefaultMethodInterfaceCallExtensionSuper() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/defaultMethodInterfaceCallExtensionSuper.kt");
        }

        @Test
        @TestMetadata("executionOrder.kt")
        public void testExecutionOrder() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/executionOrder.kt");
        }

        @Test
        @TestMetadata("extensionFunctionAsSupertype.kt")
        public void testExtensionFunctionAsSupertype() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/extensionFunctionAsSupertype.kt");
        }

        @Test
        @TestMetadata("kt1061.kt")
        public void testKt1061() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/kt1061.kt");
        }

        @Test
        @TestMetadata("kt1249.kt")
        public void testKt1249() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/kt1249.kt");
        }

        @Test
        @TestMetadata("kt1290.kt")
        public void testKt1290() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/kt1290.kt");
        }

        @Test
        @TestMetadata("kt13312.kt")
        public void testKt13312() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/kt13312.kt");
        }

        @Test
        @TestMetadata("kt1776.kt")
        public void testKt1776() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/kt1776.kt");
        }

        @Test
        @TestMetadata("kt1953.kt")
        public void testKt1953() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/kt1953.kt");
        }

        @Test
        @TestMetadata("kt1953_class.kt")
        public void testKt1953_class() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/kt1953_class.kt");
        }

        @Test
        @TestMetadata("kt23675.kt")
        public void testKt23675() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/kt23675.kt");
        }

        @Test
        @TestMetadata("kt3285.kt")
        public void testKt3285() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/kt3285.kt");
        }

        @Test
        @TestMetadata("kt3298.kt")
        public void testKt3298() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/kt3298.kt");
        }

        @Test
        @TestMetadata("kt3646.kt")
        public void testKt3646() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/kt3646.kt");
        }

        @Test
        @TestMetadata("kt3969.kt")
        public void testKt3969() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/kt3969.kt");
        }

        @Test
        @TestMetadata("kt4228.kt")
        public void testKt4228() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/kt4228.kt");
        }

        @Test
        @TestMetadata("kt475.kt")
        public void testKt475() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/kt475.kt");
        }

        @Test
        @TestMetadata("kt5467.kt")
        public void testKt5467() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/kt5467.kt");
        }

        @Test
        @TestMetadata("kt606.kt")
        public void testKt606() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/kt606.kt");
        }

        @Test
        @TestMetadata("kt865.kt")
        public void testKt865() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/kt865.kt");
        }

        @Test
        @TestMetadata("memberExtensionEqualsHashCodeToStringInInterface.kt")
        public void testMemberExtensionEqualsHashCodeToStringInInterface() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/memberExtensionEqualsHashCodeToStringInInterface.kt");
        }

        @Test
        @TestMetadata("nested2.kt")
        public void testNested2() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/nested2.kt");
        }

        @Test
        @TestMetadata("shared.kt")
        public void testShared() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/shared.kt");
        }

        @Test
        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/simple.kt");
        }

        @Test
        @TestMetadata("thisMethodInObjectLiteral.kt")
        public void testThisMethodInObjectLiteral() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/thisMethodInObjectLiteral.kt");
        }

        @Test
        @TestMetadata("virtual.kt")
        public void testVirtual() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/virtual.kt");
        }

        @Test
        @TestMetadata("whenFail.kt")
        public void testWhenFail() throws Exception {
            runTest("compiler/testData/codegen/box/extensionFunctions/whenFail.kt");
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/box/extensionFunctions/contextReceivers")
        @TestDataPath("$PROJECT_ROOT")
        public class ContextReceivers {
            @Test
            public void testAllFilesPresentInContextReceivers() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/extensionFunctions/contextReceivers"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("arrayAccessCompositeOperators.kt")
            public void testArrayAccessCompositeOperators() throws Exception {
                runTest("compiler/testData/codegen/box/extensionFunctions/contextReceivers/arrayAccessCompositeOperators.kt");
            }

            @Test
            @TestMetadata("arrayAccessOperators.kt")
            public void testArrayAccessOperators() throws Exception {
                runTest("compiler/testData/codegen/box/extensionFunctions/contextReceivers/arrayAccessOperators.kt");
            }

            @Test
            @TestMetadata("compoundAssignmentOperators.kt")
            public void testCompoundAssignmentOperators() throws Exception {
                runTest("compiler/testData/codegen/box/extensionFunctions/contextReceivers/compoundAssignmentOperators.kt");
            }

            @Test
            @TestMetadata("contextAndExtensionSameName.kt")
            public void testContextAndExtensionSameName() throws Exception {
                runTest("compiler/testData/codegen/box/extensionFunctions/contextReceivers/contextAndExtensionSameName.kt");
            }

            @Test
            @TestMetadata("contextualFunctionConversion.kt")
            public void testContextualFunctionConversion() throws Exception {
                runTest("compiler/testData/codegen/box/extensionFunctions/contextReceivers/contextualFunctionConversion.kt");
            }

            @Test
            @TestMetadata("contextualInlineCall.kt")
            public void testContextualInlineCall() throws Exception {
                runTest("compiler/testData/codegen/box/extensionFunctions/contextReceivers/contextualInlineCall.kt");
            }

            @Test
            @TestMetadata("delegatedPropertiesOperators.kt")
            public void testDelegatedPropertiesOperators() throws Exception {
                runTest("compiler/testData/codegen/box/extensionFunctions/contextReceivers/delegatedPropertiesOperators.kt");
            }

            @Test
            @TestMetadata("inferGenericPropertyType.kt")
            public void testInferGenericPropertyType() throws Exception {
                runTest("compiler/testData/codegen/box/extensionFunctions/contextReceivers/inferGenericPropertyType.kt");
            }

            @Test
            @TestMetadata("iteratorOperator.kt")
            public void testIteratorOperator() throws Exception {
                runTest("compiler/testData/codegen/box/extensionFunctions/contextReceivers/iteratorOperator.kt");
            }

            @Test
            @TestMetadata("overload.kt")
            public void testOverload() throws Exception {
                runTest("compiler/testData/codegen/box/extensionFunctions/contextReceivers/overload.kt");
            }

            @Test
            @TestMetadata("overloading.kt")
            public void testOverloading() throws Exception {
                runTest("compiler/testData/codegen/box/extensionFunctions/contextReceivers/overloading.kt");
            }

            @Test
            @TestMetadata("passingLambdaToContextualParam.kt")
            public void testPassingLambdaToContextualParam() throws Exception {
                runTest("compiler/testData/codegen/box/extensionFunctions/contextReceivers/passingLambdaToContextualParam.kt");
            }

            @Test
            @TestMetadata("plusAssign.kt")
            public void testPlusAssign() throws Exception {
                runTest("compiler/testData/codegen/box/extensionFunctions/contextReceivers/plusAssign.kt");
            }

            @Test
            @TestMetadata("plusMatrix.kt")
            public void testPlusMatrix() throws Exception {
                runTest("compiler/testData/codegen/box/extensionFunctions/contextReceivers/plusMatrix.kt");
            }

            @Test
            @TestMetadata("propertyCompoundAssignment.kt")
            public void testPropertyCompoundAssignment() throws Exception {
                runTest("compiler/testData/codegen/box/extensionFunctions/contextReceivers/propertyCompoundAssignment.kt");
            }

            @Test
            @TestMetadata("simpleCall.kt")
            public void testSimpleCall() throws Exception {
                runTest("compiler/testData/codegen/box/extensionFunctions/contextReceivers/simpleCall.kt");
            }

            @Test
            @TestMetadata("substitutedContextReceivers.kt")
            public void testSubstitutedContextReceivers() throws Exception {
                runTest("compiler/testData/codegen/box/extensionFunctions/contextReceivers/substitutedContextReceivers.kt");
            }

            @Test
            @TestMetadata("superClassAndSubClassWithContextReceiver.kt")
            public void testSuperClassAndSubClassWithContextReceiver() throws Exception {
                runTest("compiler/testData/codegen/box/extensionFunctions/contextReceivers/superClassAndSubClassWithContextReceiver.kt");
            }

            @Test
            @TestMetadata("superClassAndSubClassWithContextReceiverSubstituted.kt")
            public void testSuperClassAndSubClassWithContextReceiverSubstituted() throws Exception {
                runTest("compiler/testData/codegen/box/extensionFunctions/contextReceivers/superClassAndSubClassWithContextReceiverSubstituted.kt");
            }

            @Test
            @TestMetadata("suspendContextualWithExtension.kt")
            public void testSuspendContextualWithExtension() throws Exception {
                runTest("compiler/testData/codegen/box/extensionFunctions/contextReceivers/suspendContextualWithExtension.kt");
            }

            @Test
            @TestMetadata("this.kt")
            public void testThis() throws Exception {
                runTest("compiler/testData/codegen/box/extensionFunctions/contextReceivers/this.kt");
            }

            @Test
            @TestMetadata("unaryOperators.kt")
            public void testUnaryOperators() throws Exception {
                runTest("compiler/testData/codegen/box/extensionFunctions/contextReceivers/unaryOperators.kt");
            }

            @Test
            @TestMetadata("useContextReceiverInPropertyInitializer.kt")
            public void testUseContextReceiverInPropertyInitializer() throws Exception {
                runTest("compiler/testData/codegen/box/extensionFunctions/contextReceivers/useContextReceiverInPropertyInitializer.kt");
            }

            @Test
            @TestMetadata("useFromAnotherModule.kt")
            public void testUseFromAnotherModule() throws Exception {
                runTest("compiler/testData/codegen/box/extensionFunctions/contextReceivers/useFromAnotherModule.kt");
            }

            @Test
            @TestMetadata("useFromAnotherModuleSuspending.kt")
            public void testUseFromAnotherModuleSuspending() throws Exception {
                runTest("compiler/testData/codegen/box/extensionFunctions/contextReceivers/useFromAnotherModuleSuspending.kt");
            }

            @Test
            @TestMetadata("useFromAnotherModuleWithDefaultParameterValues.kt")
            public void testUseFromAnotherModuleWithDefaultParameterValues() throws Exception {
                runTest("compiler/testData/codegen/box/extensionFunctions/contextReceivers/useFromAnotherModuleWithDefaultParameterValues.kt");
            }

            @Nested
            @TestMetadata("compiler/testData/codegen/box/extensionFunctions/contextReceivers/fromKEEP")
            @TestDataPath("$PROJECT_ROOT")
            public class FromKEEP {
                @Test
                public void testAllFilesPresentInFromKEEP() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/extensionFunctions/contextReceivers/fromKEEP"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
                }

                @Test
                @TestMetadata("canvas.kt")
                public void testCanvas() throws Exception {
                    runTest("compiler/testData/codegen/box/extensionFunctions/contextReceivers/fromKEEP/canvas.kt");
                }

                @Test
                @TestMetadata("compareTo.kt")
                public void testCompareTo() throws Exception {
                    runTest("compiler/testData/codegen/box/extensionFunctions/contextReceivers/fromKEEP/compareTo.kt");
                }

                @Test
                @TestMetadata("decimateEveryEvenThird.kt")
                public void testDecimateEveryEvenThird() throws Exception {
                    runTest("compiler/testData/codegen/box/extensionFunctions/contextReceivers/fromKEEP/decimateEveryEvenThird.kt");
                }

                @Test
                @TestMetadata("dp.kt")
                public void testDp() throws Exception {
                    runTest("compiler/testData/codegen/box/extensionFunctions/contextReceivers/fromKEEP/dp.kt");
                }

                @Test
                @TestMetadata("functionalType.kt")
                public void testFunctionalType() throws Exception {
                    runTest("compiler/testData/codegen/box/extensionFunctions/contextReceivers/fromKEEP/functionalType.kt");
                }

                @Test
                @TestMetadata("monoidSum.kt")
                public void testMonoidSum() throws Exception {
                    runTest("compiler/testData/codegen/box/extensionFunctions/contextReceivers/fromKEEP/monoidSum.kt");
                }

                @Test
                @TestMetadata("structuredConcurrency.kt")
                public void testStructuredConcurrency() throws Exception {
                    runTest("compiler/testData/codegen/box/extensionFunctions/contextReceivers/fromKEEP/structuredConcurrency.kt");
                }
            }
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/extensionProperties")
    @TestDataPath("$PROJECT_ROOT")
    public class ExtensionProperties {
        @Test
        @TestMetadata("accessorForPrivateSetter.kt")
        public void testAccessorForPrivateSetter() throws Exception {
            runTest("compiler/testData/codegen/box/extensionProperties/accessorForPrivateSetter.kt");
        }

        @Test
        public void testAllFilesPresentInExtensionProperties() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/extensionProperties"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("genericValForPrimitiveType.kt")
        public void testGenericValForPrimitiveType() throws Exception {
            runTest("compiler/testData/codegen/box/extensionProperties/genericValForPrimitiveType.kt");
        }

        @Test
        @TestMetadata("genericValMultipleUpperBounds.kt")
        public void testGenericValMultipleUpperBounds() throws Exception {
            runTest("compiler/testData/codegen/box/extensionProperties/genericValMultipleUpperBounds.kt");
        }

        @Test
        @TestMetadata("genericVarForPrimitiveType.kt")
        public void testGenericVarForPrimitiveType() throws Exception {
            runTest("compiler/testData/codegen/box/extensionProperties/genericVarForPrimitiveType.kt");
        }

        @Test
        @TestMetadata("inClass.kt")
        public void testInClass() throws Exception {
            runTest("compiler/testData/codegen/box/extensionProperties/inClass.kt");
        }

        @Test
        @TestMetadata("inClassLongTypeInReceiver.kt")
        public void testInClassLongTypeInReceiver() throws Exception {
            runTest("compiler/testData/codegen/box/extensionProperties/inClassLongTypeInReceiver.kt");
        }

        @Test
        @TestMetadata("inClassWithGetter.kt")
        public void testInClassWithGetter() throws Exception {
            runTest("compiler/testData/codegen/box/extensionProperties/inClassWithGetter.kt");
        }

        @Test
        @TestMetadata("inClassWithPrivateGetter.kt")
        public void testInClassWithPrivateGetter() throws Exception {
            runTest("compiler/testData/codegen/box/extensionProperties/inClassWithPrivateGetter.kt");
        }

        @Test
        @TestMetadata("inClassWithPrivateSetter.kt")
        public void testInClassWithPrivateSetter() throws Exception {
            runTest("compiler/testData/codegen/box/extensionProperties/inClassWithPrivateSetter.kt");
        }

        @Test
        @TestMetadata("inClassWithSetter.kt")
        public void testInClassWithSetter() throws Exception {
            runTest("compiler/testData/codegen/box/extensionProperties/inClassWithSetter.kt");
        }

        @Test
        @TestMetadata("kt46952.kt")
        public void testKt46952() throws Exception {
            runTest("compiler/testData/codegen/box/extensionProperties/kt46952.kt");
        }

        @Test
        @TestMetadata("kt9897.kt")
        public void testKt9897() throws Exception {
            runTest("compiler/testData/codegen/box/extensionProperties/kt9897.kt");
        }

        @Test
        @TestMetadata("kt9897_topLevel.kt")
        public void testKt9897_topLevel() throws Exception {
            runTest("compiler/testData/codegen/box/extensionProperties/kt9897_topLevel.kt");
        }

        @Test
        @TestMetadata("nonAbstractInInterface.kt")
        public void testNonAbstractInInterface() throws Exception {
            runTest("compiler/testData/codegen/box/extensionProperties/nonAbstractInInterface.kt");
        }

        @Test
        @TestMetadata("topLevel.kt")
        public void testTopLevel() throws Exception {
            runTest("compiler/testData/codegen/box/extensionProperties/topLevel.kt");
        }

        @Test
        @TestMetadata("topLevelLongTypeInReceiver.kt")
        public void testTopLevelLongTypeInReceiver() throws Exception {
            runTest("compiler/testData/codegen/box/extensionProperties/topLevelLongTypeInReceiver.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/external")
    @TestDataPath("$PROJECT_ROOT")
    public class External {
        @Test
        public void testAllFilesPresentInExternal() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/external"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("jvmStaticExternal.kt")
        public void testJvmStaticExternal() throws Exception {
            runTest("compiler/testData/codegen/box/external/jvmStaticExternal.kt");
        }

        @Test
        @TestMetadata("jvmStaticExternalPrivate.kt")
        public void testJvmStaticExternalPrivate() throws Exception {
            runTest("compiler/testData/codegen/box/external/jvmStaticExternalPrivate.kt");
        }

        @Test
        @TestMetadata("withDefaultArg.kt")
        public void testWithDefaultArg() throws Exception {
            runTest("compiler/testData/codegen/box/external/withDefaultArg.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/fakeOverride")
    @TestDataPath("$PROJECT_ROOT")
    public class FakeOverride {
        @Test
        public void testAllFilesPresentInFakeOverride() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/fakeOverride"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("diamondFunction.kt")
        public void testDiamondFunction() throws Exception {
            runTest("compiler/testData/codegen/box/fakeOverride/diamondFunction.kt");
        }

        @Test
        @TestMetadata("fakeOverrideInAnonymousObject.kt")
        public void testFakeOverrideInAnonymousObject() throws Exception {
            runTest("compiler/testData/codegen/box/fakeOverride/fakeOverrideInAnonymousObject.kt");
        }

        @Test
        @TestMetadata("function.kt")
        public void testFunction() throws Exception {
            runTest("compiler/testData/codegen/box/fakeOverride/function.kt");
        }

        @Test
        @TestMetadata("internalFromFriendModule.kt")
        public void testInternalFromFriendModule() throws Exception {
            runTest("compiler/testData/codegen/box/fakeOverride/internalFromFriendModule.kt");
        }

        @Test
        @TestMetadata("kt49371.kt")
        public void testKt49371() throws Exception {
            runTest("compiler/testData/codegen/box/fakeOverride/kt49371.kt");
        }

        @Test
        @TestMetadata("privateFakeOverrides0.kt")
        public void testPrivateFakeOverrides0() throws Exception {
            runTest("compiler/testData/codegen/box/fakeOverride/privateFakeOverrides0.kt");
        }

        @Test
        @TestMetadata("privateFakeOverrides1.kt")
        public void testPrivateFakeOverrides1() throws Exception {
            runTest("compiler/testData/codegen/box/fakeOverride/privateFakeOverrides1.kt");
        }

        @Test
        @TestMetadata("propertyGetter.kt")
        public void testPropertyGetter() throws Exception {
            runTest("compiler/testData/codegen/box/fakeOverride/propertyGetter.kt");
        }

        @Test
        @TestMetadata("propertySetter.kt")
        public void testPropertySetter() throws Exception {
            runTest("compiler/testData/codegen/box/fakeOverride/propertySetter.kt");
        }

        @Test
        @TestMetadata("varianceOverload.kt")
        public void testVarianceOverload() throws Exception {
            runTest("compiler/testData/codegen/box/fakeOverride/varianceOverload.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/fieldRename")
    @TestDataPath("$PROJECT_ROOT")
    public class FieldRename {
        @Test
        public void testAllFilesPresentInFieldRename() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/fieldRename"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("constructorAndClassObject.kt")
        public void testConstructorAndClassObject() throws Exception {
            runTest("compiler/testData/codegen/box/fieldRename/constructorAndClassObject.kt");
        }

        @Test
        @TestMetadata("delegates.kt")
        public void testDelegates() throws Exception {
            runTest("compiler/testData/codegen/box/fieldRename/delegates.kt");
        }

        @Test
        @TestMetadata("genericPropertyWithItself.kt")
        public void testGenericPropertyWithItself() throws Exception {
            runTest("compiler/testData/codegen/box/fieldRename/genericPropertyWithItself.kt");
        }

        @Test
        @TestMetadata("jvmFieldNoClash1.kt")
        public void testJvmFieldNoClash1() throws Exception {
            runTest("compiler/testData/codegen/box/fieldRename/jvmFieldNoClash1.kt");
        }

        @Test
        @TestMetadata("jvmFieldNoClash2.kt")
        public void testJvmFieldNoClash2() throws Exception {
            runTest("compiler/testData/codegen/box/fieldRename/jvmFieldNoClash2.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/finally")
    @TestDataPath("$PROJECT_ROOT")
    public class Finally {
        @Test
        public void testAllFilesPresentInFinally() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/finally"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("breakAndOuterFinally.kt")
        public void testBreakAndOuterFinally() throws Exception {
            runTest("compiler/testData/codegen/box/finally/breakAndOuterFinally.kt");
        }

        @Test
        @TestMetadata("continueAndOuterFinally.kt")
        public void testContinueAndOuterFinally() throws Exception {
            runTest("compiler/testData/codegen/box/finally/continueAndOuterFinally.kt");
        }

        @Test
        @TestMetadata("finallyAndFinally.kt")
        public void testFinallyAndFinally() throws Exception {
            runTest("compiler/testData/codegen/box/finally/finallyAndFinally.kt");
        }

        @Test
        @TestMetadata("kt31923_break.kt")
        public void testKt31923_break() throws Exception {
            runTest("compiler/testData/codegen/box/finally/kt31923_break.kt");
        }

        @Test
        @TestMetadata("kt31923_continue.kt")
        public void testKt31923_continue() throws Exception {
            runTest("compiler/testData/codegen/box/finally/kt31923_continue.kt");
        }

        @Test
        @TestMetadata("kt31923_return.kt")
        public void testKt31923_return() throws Exception {
            runTest("compiler/testData/codegen/box/finally/kt31923_return.kt");
        }

        @Test
        @TestMetadata("kt31923_wrong.kt")
        public void testKt31923_wrong() throws Exception {
            runTest("compiler/testData/codegen/box/finally/kt31923_wrong.kt");
        }

        @Test
        @TestMetadata("kt3549.kt")
        public void testKt3549() throws Exception {
            runTest("compiler/testData/codegen/box/finally/kt3549.kt");
        }

        @Test
        @TestMetadata("kt3706.kt")
        public void testKt3706() throws Exception {
            runTest("compiler/testData/codegen/box/finally/kt3706.kt");
        }

        @Test
        @TestMetadata("kt3867.kt")
        public void testKt3867() throws Exception {
            runTest("compiler/testData/codegen/box/finally/kt3867.kt");
        }

        @Test
        @TestMetadata("kt3874.kt")
        public void testKt3874() throws Exception {
            runTest("compiler/testData/codegen/box/finally/kt3874.kt");
        }

        @Test
        @TestMetadata("kt3894.kt")
        public void testKt3894() throws Exception {
            runTest("compiler/testData/codegen/box/finally/kt3894.kt");
        }

        @Test
        @TestMetadata("kt4134.kt")
        public void testKt4134() throws Exception {
            runTest("compiler/testData/codegen/box/finally/kt4134.kt");
        }

        @Test
        @TestMetadata("loopAndFinally.kt")
        public void testLoopAndFinally() throws Exception {
            runTest("compiler/testData/codegen/box/finally/loopAndFinally.kt");
        }

        @Test
        @TestMetadata("nestedFinallyAndNonFinallyTry.kt")
        public void testNestedFinallyAndNonFinallyTry() throws Exception {
            runTest("compiler/testData/codegen/box/finally/nestedFinallyAndNonFinallyTry.kt");
        }

        @Test
        @TestMetadata("nestedFinallyAndNonFinallyTry2.kt")
        public void testNestedFinallyAndNonFinallyTry2() throws Exception {
            runTest("compiler/testData/codegen/box/finally/nestedFinallyAndNonFinallyTry2.kt");
        }

        @Test
        @TestMetadata("nestedFinallyAndNonFinallyTry3.kt")
        public void testNestedFinallyAndNonFinallyTry3() throws Exception {
            runTest("compiler/testData/codegen/box/finally/nestedFinallyAndNonFinallyTry3.kt");
        }

        @Test
        @TestMetadata("nestedFinallyAndNonFinallyTry4.kt")
        public void testNestedFinallyAndNonFinallyTry4() throws Exception {
            runTest("compiler/testData/codegen/box/finally/nestedFinallyAndNonFinallyTry4.kt");
        }

        @Test
        @TestMetadata("notChainCatch.kt")
        public void testNotChainCatch() throws Exception {
            runTest("compiler/testData/codegen/box/finally/notChainCatch.kt");
        }

        @Test
        @TestMetadata("objectInFinally.kt")
        public void testObjectInFinally() throws Exception {
            runTest("compiler/testData/codegen/box/finally/objectInFinally.kt");
        }

        @Test
        @TestMetadata("someStuff.kt")
        public void testSomeStuff() throws Exception {
            runTest("compiler/testData/codegen/box/finally/someStuff.kt");
        }

        @Test
        @TestMetadata("tryFinally.kt")
        public void testTryFinally() throws Exception {
            runTest("compiler/testData/codegen/box/finally/tryFinally.kt");
        }

        @Test
        @TestMetadata("tryLoopTry.kt")
        public void testTryLoopTry() throws Exception {
            runTest("compiler/testData/codegen/box/finally/tryLoopTry.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/fir")
    @TestDataPath("$PROJECT_ROOT")
    public class Fir {
        @Test
        public void testAllFilesPresentInFir() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/fir"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("callableReferenceToJavaField.kt")
        public void testCallableReferenceToJavaField() throws Exception {
            runTest("compiler/testData/codegen/box/fir/callableReferenceToJavaField.kt");
        }

        @Test
        @TestMetadata("callableReferenceToStaticFunction.kt")
        public void testCallableReferenceToStaticFunction() throws Exception {
            runTest("compiler/testData/codegen/box/fir/callableReferenceToStaticFunction.kt");
        }

        @Test
        @TestMetadata("ClassBuilder.kt")
        public void testClassBuilder() throws Exception {
            runTest("compiler/testData/codegen/box/fir/ClassBuilder.kt");
        }

        @Test
        @TestMetadata("classCanNotBeCastedToVoid.kt")
        public void testClassCanNotBeCastedToVoid() throws Exception {
            runTest("compiler/testData/codegen/box/fir/classCanNotBeCastedToVoid.kt");
        }

        @Test
        @TestMetadata("ColorValuePanel.kt")
        public void testColorValuePanel() throws Exception {
            runTest("compiler/testData/codegen/box/fir/ColorValuePanel.kt");
        }

        @Test
        @TestMetadata("complexAnnotations.kt")
        public void testComplexAnnotations() throws Exception {
            runTest("compiler/testData/codegen/box/fir/complexAnnotations.kt");
        }

        @Test
        @TestMetadata("ConstValAccess.kt")
        public void testConstValAccess() throws Exception {
            runTest("compiler/testData/codegen/box/fir/ConstValAccess.kt");
        }

        @Test
        @TestMetadata("CustomHashSetSize.kt")
        public void testCustomHashSetSize() throws Exception {
            runTest("compiler/testData/codegen/box/fir/CustomHashSetSize.kt");
        }

        @Test
        @TestMetadata("CustomThrowableMessage.kt")
        public void testCustomThrowableMessage() throws Exception {
            runTest("compiler/testData/codegen/box/fir/CustomThrowableMessage.kt");
        }

        @Test
        @TestMetadata("differentSinceKotlin.kt")
        public void testDifferentSinceKotlin() throws Exception {
            runTest("compiler/testData/codegen/box/fir/differentSinceKotlin.kt");
        }

        @Test
        @TestMetadata("ExtensionAlias.kt")
        public void testExtensionAlias() throws Exception {
            runTest("compiler/testData/codegen/box/fir/ExtensionAlias.kt");
        }

        @Test
        @TestMetadata("FakeOverrideBuilder.kt")
        public void testFakeOverrideBuilder() throws Exception {
            runTest("compiler/testData/codegen/box/fir/FakeOverrideBuilder.kt");
        }

        @Test
        @TestMetadata("falsePositiveBoundSmartcast.kt")
        public void testFalsePositiveBoundSmartcast() throws Exception {
            runTest("compiler/testData/codegen/box/fir/falsePositiveBoundSmartcast.kt");
        }

        @Test
        @TestMetadata("Fir2IrClassifierStorage.kt")
        public void testFir2IrClassifierStorage() throws Exception {
            runTest("compiler/testData/codegen/box/fir/Fir2IrClassifierStorage.kt");
        }

        @Test
        @TestMetadata("flexibleIntegerLiterals.kt")
        public void testFlexibleIntegerLiterals() throws Exception {
            runTest("compiler/testData/codegen/box/fir/flexibleIntegerLiterals.kt");
        }

        @Test
        @TestMetadata("implicitNothingInDelegate.kt")
        public void testImplicitNothingInDelegate() throws Exception {
            runTest("compiler/testData/codegen/box/fir/implicitNothingInDelegate.kt");
        }

        @Test
        @TestMetadata("incorrectBytecodeWithEnhancedNullability.kt")
        public void testIncorrectBytecodeWithEnhancedNullability() throws Exception {
            runTest("compiler/testData/codegen/box/fir/incorrectBytecodeWithEnhancedNullability.kt");
        }

        @Test
        @TestMetadata("IrBuiltIns.kt")
        public void testIrBuiltIns() throws Exception {
            runTest("compiler/testData/codegen/box/fir/IrBuiltIns.kt");
        }

        @Test
        @TestMetadata("JKEnumConstant.kt")
        public void testJKEnumConstant() throws Exception {
            runTest("compiler/testData/codegen/box/fir/JKEnumConstant.kt");
        }

        @Test
        @TestMetadata("jvmFieldInLocalClass.kt")
        public void testJvmFieldInLocalClass() throws Exception {
            runTest("compiler/testData/codegen/box/fir/jvmFieldInLocalClass.kt");
        }

        @Test
        @TestMetadata("KotlinDocumentationProvider.kt")
        public void testKotlinDocumentationProvider() throws Exception {
            runTest("compiler/testData/codegen/box/fir/KotlinDocumentationProvider.kt");
        }

        @Test
        @TestMetadata("LookupTags.kt")
        public void testLookupTags() throws Exception {
            runTest("compiler/testData/codegen/box/fir/LookupTags.kt");
        }

        @Test
        @TestMetadata("NameHighlighter.kt")
        public void testNameHighlighter() throws Exception {
            runTest("compiler/testData/codegen/box/fir/NameHighlighter.kt");
        }

        @Test
        @TestMetadata("namedArgumentOnTypeAnnotation.kt")
        public void testNamedArgumentOnTypeAnnotation() throws Exception {
            runTest("compiler/testData/codegen/box/fir/namedArgumentOnTypeAnnotation.kt");
        }

        @Test
        @TestMetadata("noSymbolForIntRangeIterator.kt")
        public void testNoSymbolForIntRangeIterator() throws Exception {
            runTest("compiler/testData/codegen/box/fir/noSymbolForIntRangeIterator.kt");
        }

        @Test
        @TestMetadata("notFoundClasses.kt")
        public void testNotFoundClasses() throws Exception {
            runTest("compiler/testData/codegen/box/fir/notFoundClasses.kt");
        }

        @Test
        @TestMetadata("SamWithReceiverMavenProjectImportHandler.kt")
        public void testSamWithReceiverMavenProjectImportHandler() throws Exception {
            runTest("compiler/testData/codegen/box/fir/SamWithReceiverMavenProjectImportHandler.kt");
        }

        @Test
        @TestMetadata("SuspendExtension.kt")
        public void testSuspendExtension() throws Exception {
            runTest("compiler/testData/codegen/box/fir/SuspendExtension.kt");
        }

        @Test
        @TestMetadata("unqualifiedEnum.kt")
        public void testUnqualifiedEnum() throws Exception {
            runTest("compiler/testData/codegen/box/fir/unqualifiedEnum.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/fullJdk")
    @TestDataPath("$PROJECT_ROOT")
    public class FullJdk {
        @Test
        public void testAllFilesPresentInFullJdk() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/fullJdk"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("charBuffer.kt")
        public void testCharBuffer() throws Exception {
            runTest("compiler/testData/codegen/box/fullJdk/charBuffer.kt");
        }

        @Test
        @TestMetadata("ifInWhile.kt")
        public void testIfInWhile() throws Exception {
            runTest("compiler/testData/codegen/box/fullJdk/ifInWhile.kt");
        }

        @Test
        @TestMetadata("intCountDownLatchExtension.kt")
        public void testIntCountDownLatchExtension() throws Exception {
            runTest("compiler/testData/codegen/box/fullJdk/intCountDownLatchExtension.kt");
        }

        @Test
        @TestMetadata("kt31757.kt")
        public void testKt31757() throws Exception {
            runTest("compiler/testData/codegen/box/fullJdk/kt31757.kt");
        }

        @Test
        @TestMetadata("kt434.kt")
        public void testKt434() throws Exception {
            runTest("compiler/testData/codegen/box/fullJdk/kt434.kt");
        }

        @Test
        @TestMetadata("kt46540.kt")
        public void testKt46540() throws Exception {
            runTest("compiler/testData/codegen/box/fullJdk/kt46540.kt");
        }

        @Test
        @TestMetadata("platformTypeAssertionStackTrace.kt")
        public void testPlatformTypeAssertionStackTrace() throws Exception {
            runTest("compiler/testData/codegen/box/fullJdk/platformTypeAssertionStackTrace.kt");
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/box/fullJdk/native")
        @TestDataPath("$PROJECT_ROOT")
        public class Native {
            @Test
            public void testAllFilesPresentInNative() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/fullJdk/native"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("nativePropertyAccessors.kt")
            public void testNativePropertyAccessors() throws Exception {
                runTest("compiler/testData/codegen/box/fullJdk/native/nativePropertyAccessors.kt");
            }

            @Test
            @TestMetadata("simpleNative.kt")
            public void testSimpleNative() throws Exception {
                runTest("compiler/testData/codegen/box/fullJdk/native/simpleNative.kt");
            }

            @Test
            @TestMetadata("topLevel.kt")
            public void testTopLevel() throws Exception {
                runTest("compiler/testData/codegen/box/fullJdk/native/topLevel.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/box/fullJdk/regressions")
        @TestDataPath("$PROJECT_ROOT")
        public class Regressions {
            @Test
            public void testAllFilesPresentInRegressions() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/fullJdk/regressions"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("kt15112.kt")
            public void testKt15112() throws Exception {
                runTest("compiler/testData/codegen/box/fullJdk/regressions/kt15112.kt");
            }

            @Test
            @TestMetadata("kt1770.kt")
            public void testKt1770() throws Exception {
                runTest("compiler/testData/codegen/box/fullJdk/regressions/kt1770.kt");
            }
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/funInterface")
    @TestDataPath("$PROJECT_ROOT")
    public class FunInterface {
        @Test
        public void testAllFilesPresentInFunInterface() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/funInterface"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("basicFunInterface.kt")
        public void testBasicFunInterface() throws Exception {
            runTest("compiler/testData/codegen/box/funInterface/basicFunInterface.kt");
        }

        @Test
        @TestMetadata("basicFunInterfaceConversion.kt")
        public void testBasicFunInterfaceConversion() throws Exception {
            runTest("compiler/testData/codegen/box/funInterface/basicFunInterfaceConversion.kt");
        }

        @Test
        @TestMetadata("basicFunInterfaceConversionClash.kt")
        public void testBasicFunInterfaceConversionClash() throws Exception {
            runTest("compiler/testData/codegen/box/funInterface/basicFunInterfaceConversionClash.kt");
        }

        @Test
        @TestMetadata("castFromAny.kt")
        public void testCastFromAny() throws Exception {
            runTest("compiler/testData/codegen/box/funInterface/castFromAny.kt");
        }

        @Test
        @TestMetadata("contravariantIntersectionType.kt")
        public void testContravariantIntersectionType() throws Exception {
            runTest("compiler/testData/codegen/box/funInterface/contravariantIntersectionType.kt");
        }

        @Test
        @TestMetadata("contravariantIntersectionTypeWithNonTrivialCommonSupertype.kt")
        public void testContravariantIntersectionTypeWithNonTrivialCommonSupertype() throws Exception {
            runTest("compiler/testData/codegen/box/funInterface/contravariantIntersectionTypeWithNonTrivialCommonSupertype.kt");
        }

        @Test
        @TestMetadata("contravariantIntersectionTypeWithNonTrivialCommonSupertype2.kt")
        public void testContravariantIntersectionTypeWithNonTrivialCommonSupertype2() throws Exception {
            runTest("compiler/testData/codegen/box/funInterface/contravariantIntersectionTypeWithNonTrivialCommonSupertype2.kt");
        }

        @Test
        @TestMetadata("funConversionInVararg.kt")
        public void testFunConversionInVararg() throws Exception {
            runTest("compiler/testData/codegen/box/funInterface/funConversionInVararg.kt");
        }

        @Test
        @TestMetadata("funInterfaceCallInLambda.kt")
        public void testFunInterfaceCallInLambda() throws Exception {
            runTest("compiler/testData/codegen/box/funInterface/funInterfaceCallInLambda.kt");
        }

        @Test
        @TestMetadata("funInterfaceInheritance.kt")
        public void testFunInterfaceInheritance() throws Exception {
            runTest("compiler/testData/codegen/box/funInterface/funInterfaceInheritance.kt");
        }

        @Test
        @TestMetadata("funInterfaceWithReceiver.kt")
        public void testFunInterfaceWithReceiver() throws Exception {
            runTest("compiler/testData/codegen/box/funInterface/funInterfaceWithReceiver.kt");
        }

        @Test
        @TestMetadata("inlinedSamWrapper.kt")
        public void testInlinedSamWrapper() throws Exception {
            runTest("compiler/testData/codegen/box/funInterface/inlinedSamWrapper.kt");
        }

        @Test
        @TestMetadata("intersectionTypeToFunInterfaceConversion.kt")
        public void testIntersectionTypeToFunInterfaceConversion() throws Exception {
            runTest("compiler/testData/codegen/box/funInterface/intersectionTypeToFunInterfaceConversion.kt");
        }

        @Test
        @TestMetadata("irrelevantPrivateDeclarations.kt")
        public void testIrrelevantPrivateDeclarations() throws Exception {
            runTest("compiler/testData/codegen/box/funInterface/irrelevantPrivateDeclarations.kt");
        }

        @Test
        @TestMetadata("kt44827_funInterface.kt")
        public void testKt44827_funInterface() throws Exception {
            runTest("compiler/testData/codegen/box/funInterface/kt44827_funInterface.kt");
        }

        @Test
        @TestMetadata("kt45444_privateFunInterface.kt")
        public void testKt45444_privateFunInterface() throws Exception {
            runTest("compiler/testData/codegen/box/funInterface/kt45444_privateFunInterface.kt");
        }

        @Test
        @TestMetadata("kt46512_indyFunInterfaceOverCallableReference.kt")
        public void testKt46512_indyFunInterfaceOverCallableReference() throws Exception {
            runTest("compiler/testData/codegen/box/funInterface/kt46512_indyFunInterfaceOverCallableReference.kt");
        }

        @Test
        @TestMetadata("kt46908_functionSupertype.kt")
        public void testKt46908_functionSupertype() throws Exception {
            runTest("compiler/testData/codegen/box/funInterface/kt46908_functionSupertype.kt");
        }

        @Test
        @TestMetadata("multimodule.kt")
        public void testMultimodule() throws Exception {
            runTest("compiler/testData/codegen/box/funInterface/multimodule.kt");
        }

        @Test
        @TestMetadata("noOptimizedCallableReferences.kt")
        public void testNoOptimizedCallableReferences() throws Exception {
            runTest("compiler/testData/codegen/box/funInterface/noOptimizedCallableReferences.kt");
        }

        @Test
        @TestMetadata("nonAbstractMethod.kt")
        public void testNonAbstractMethod() throws Exception {
            runTest("compiler/testData/codegen/box/funInterface/nonAbstractMethod.kt");
        }

        @Test
        @TestMetadata("nullableSam.kt")
        public void testNullableSam() throws Exception {
            runTest("compiler/testData/codegen/box/funInterface/nullableSam.kt");
        }

        @Test
        @TestMetadata("partialSam.kt")
        public void testPartialSam() throws Exception {
            runTest("compiler/testData/codegen/box/funInterface/partialSam.kt");
        }

        @Test
        @TestMetadata("primitiveConversions.kt")
        public void testPrimitiveConversions() throws Exception {
            runTest("compiler/testData/codegen/box/funInterface/primitiveConversions.kt");
        }

        @Test
        @TestMetadata("receiverEvaluatedOnce.kt")
        public void testReceiverEvaluatedOnce() throws Exception {
            runTest("compiler/testData/codegen/box/funInterface/receiverEvaluatedOnce.kt");
        }

        @Test
        @TestMetadata("samConstructorExplicitInvocation.kt")
        public void testSamConstructorExplicitInvocation() throws Exception {
            runTest("compiler/testData/codegen/box/funInterface/samConstructorExplicitInvocation.kt");
        }

        @Test
        @TestMetadata("samConversionToGenericInterfaceInGenericFun.kt")
        public void testSamConversionToGenericInterfaceInGenericFun() throws Exception {
            runTest("compiler/testData/codegen/box/funInterface/samConversionToGenericInterfaceInGenericFun.kt");
        }

        @Test
        @TestMetadata("subtypeOfFunctionalTypeToFunInterfaceConversion.kt")
        public void testSubtypeOfFunctionalTypeToFunInterfaceConversion() throws Exception {
            runTest("compiler/testData/codegen/box/funInterface/subtypeOfFunctionalTypeToFunInterfaceConversion.kt");
        }

        @Test
        @TestMetadata("suspendFunInterfaceConversionCodegen.kt")
        public void testSuspendFunInterfaceConversionCodegen() throws Exception {
            runTest("compiler/testData/codegen/box/funInterface/suspendFunInterfaceConversionCodegen.kt");
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/box/funInterface/equality")
        @TestDataPath("$PROJECT_ROOT")
        public class Equality {
            @Test
            public void testAllFilesPresentInEquality() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/funInterface/equality"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("functionReferencesBound.kt")
            public void testFunctionReferencesBound() throws Exception {
                runTest("compiler/testData/codegen/box/funInterface/equality/functionReferencesBound.kt");
            }

            @Test
            @TestMetadata("functionReferencesUnbound.kt")
            public void testFunctionReferencesUnbound() throws Exception {
                runTest("compiler/testData/codegen/box/funInterface/equality/functionReferencesUnbound.kt");
            }

            @Test
            @TestMetadata("lambdaRuntimeConversion.kt")
            public void testLambdaRuntimeConversion() throws Exception {
                runTest("compiler/testData/codegen/box/funInterface/equality/lambdaRuntimeConversion.kt");
            }

            @Test
            @TestMetadata("localFunctionReferences.kt")
            public void testLocalFunctionReferences() throws Exception {
                runTest("compiler/testData/codegen/box/funInterface/equality/localFunctionReferences.kt");
            }

            @Test
            @TestMetadata("simpleLambdas.kt")
            public void testSimpleLambdas() throws Exception {
                runTest("compiler/testData/codegen/box/funInterface/equality/simpleLambdas.kt");
            }
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/functions")
    @TestDataPath("$PROJECT_ROOT")
    public class Functions {
        @Test
        public void testAllFilesPresentInFunctions() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/functions"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("coerceVoidToArray.kt")
        public void testCoerceVoidToArray() throws Exception {
            runTest("compiler/testData/codegen/box/functions/coerceVoidToArray.kt");
        }

        @Test
        @TestMetadata("coerceVoidToObject.kt")
        public void testCoerceVoidToObject() throws Exception {
            runTest("compiler/testData/codegen/box/functions/coerceVoidToObject.kt");
        }

        @Test
        @TestMetadata("constructor.kt")
        public void testConstructor() throws Exception {
            runTest("compiler/testData/codegen/box/functions/constructor.kt");
        }

        @Test
        @TestMetadata("dataLocalVariable.kt")
        public void testDataLocalVariable() throws Exception {
            runTest("compiler/testData/codegen/box/functions/dataLocalVariable.kt");
        }

        @Test
        @TestMetadata("defaultargs.kt")
        public void testDefaultargs() throws Exception {
            runTest("compiler/testData/codegen/box/functions/defaultargs.kt");
        }

        @Test
        @TestMetadata("defaultargs1.kt")
        public void testDefaultargs1() throws Exception {
            runTest("compiler/testData/codegen/box/functions/defaultargs1.kt");
        }

        @Test
        @TestMetadata("defaultargs2.kt")
        public void testDefaultargs2() throws Exception {
            runTest("compiler/testData/codegen/box/functions/defaultargs2.kt");
        }

        @Test
        @TestMetadata("defaultargs3.kt")
        public void testDefaultargs3() throws Exception {
            runTest("compiler/testData/codegen/box/functions/defaultargs3.kt");
        }

        @Test
        @TestMetadata("defaultargs4.kt")
        public void testDefaultargs4() throws Exception {
            runTest("compiler/testData/codegen/box/functions/defaultargs4.kt");
        }

        @Test
        @TestMetadata("defaultargs5.kt")
        public void testDefaultargs5() throws Exception {
            runTest("compiler/testData/codegen/box/functions/defaultargs5.kt");
        }

        @Test
        @TestMetadata("defaultargs6.kt")
        public void testDefaultargs6() throws Exception {
            runTest("compiler/testData/codegen/box/functions/defaultargs6.kt");
        }

        @Test
        @TestMetadata("defaultargs7.kt")
        public void testDefaultargs7() throws Exception {
            runTest("compiler/testData/codegen/box/functions/defaultargs7.kt");
        }

        @Test
        @TestMetadata("ea33909.kt")
        public void testEa33909() throws Exception {
            runTest("compiler/testData/codegen/box/functions/ea33909.kt");
        }

        @Test
        @TestMetadata("fakeDescriptorWithSeveralOverridenOne.kt")
        public void testFakeDescriptorWithSeveralOverridenOne() throws Exception {
            runTest("compiler/testData/codegen/box/functions/fakeDescriptorWithSeveralOverridenOne.kt");
        }

        @Test
        @TestMetadata("functionNtoString.kt")
        public void testFunctionNtoString() throws Exception {
            runTest("compiler/testData/codegen/box/functions/functionNtoString.kt");
        }

        @Test
        @TestMetadata("functionNtoStringGeneric.kt")
        public void testFunctionNtoStringGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/functions/functionNtoStringGeneric.kt");
        }

        @Test
        @TestMetadata("functionNtoStringNoReflect.kt")
        public void testFunctionNtoStringNoReflect() throws Exception {
            runTest("compiler/testData/codegen/box/functions/functionNtoStringNoReflect.kt");
        }

        @Test
        @TestMetadata("infixRecursiveCall.kt")
        public void testInfixRecursiveCall() throws Exception {
            runTest("compiler/testData/codegen/box/functions/infixRecursiveCall.kt");
        }

        @Test
        @TestMetadata("kt1038.kt")
        public void testKt1038() throws Exception {
            runTest("compiler/testData/codegen/box/functions/kt1038.kt");
        }

        @Test
        @TestMetadata("kt1199.kt")
        public void testKt1199() throws Exception {
            runTest("compiler/testData/codegen/box/functions/kt1199.kt");
        }

        @Test
        @TestMetadata("kt1413.kt")
        public void testKt1413() throws Exception {
            runTest("compiler/testData/codegen/box/functions/kt1413.kt");
        }

        @Test
        @TestMetadata("kt1649_1.kt")
        public void testKt1649_1() throws Exception {
            runTest("compiler/testData/codegen/box/functions/kt1649_1.kt");
        }

        @Test
        @TestMetadata("kt1649_2.kt")
        public void testKt1649_2() throws Exception {
            runTest("compiler/testData/codegen/box/functions/kt1649_2.kt");
        }

        @Test
        @TestMetadata("kt1739.kt")
        public void testKt1739() throws Exception {
            runTest("compiler/testData/codegen/box/functions/kt1739.kt");
        }

        @Test
        @TestMetadata("kt2270.kt")
        public void testKt2270() throws Exception {
            runTest("compiler/testData/codegen/box/functions/kt2270.kt");
        }

        @Test
        @TestMetadata("kt2271.kt")
        public void testKt2271() throws Exception {
            runTest("compiler/testData/codegen/box/functions/kt2271.kt");
        }

        @Test
        @TestMetadata("kt2280.kt")
        public void testKt2280() throws Exception {
            runTest("compiler/testData/codegen/box/functions/kt2280.kt");
        }

        @Test
        @TestMetadata("kt2481.kt")
        public void testKt2481() throws Exception {
            runTest("compiler/testData/codegen/box/functions/kt2481.kt");
        }

        @Test
        @TestMetadata("kt2716.kt")
        public void testKt2716() throws Exception {
            runTest("compiler/testData/codegen/box/functions/kt2716.kt");
        }

        @Test
        @TestMetadata("kt2739.kt")
        public void testKt2739() throws Exception {
            runTest("compiler/testData/codegen/box/functions/kt2739.kt");
        }

        @Test
        @TestMetadata("kt2929.kt")
        public void testKt2929() throws Exception {
            runTest("compiler/testData/codegen/box/functions/kt2929.kt");
        }

        @Test
        @TestMetadata("kt3214.kt")
        public void testKt3214() throws Exception {
            runTest("compiler/testData/codegen/box/functions/kt3214.kt");
        }

        @Test
        @TestMetadata("kt3313.kt")
        public void testKt3313() throws Exception {
            runTest("compiler/testData/codegen/box/functions/kt3313.kt");
        }

        @Test
        @TestMetadata("kt3573.kt")
        public void testKt3573() throws Exception {
            runTest("compiler/testData/codegen/box/functions/kt3573.kt");
        }

        @Test
        @TestMetadata("kt3724.kt")
        public void testKt3724() throws Exception {
            runTest("compiler/testData/codegen/box/functions/kt3724.kt");
        }

        @Test
        @TestMetadata("kt395.kt")
        public void testKt395() throws Exception {
            runTest("compiler/testData/codegen/box/functions/kt395.kt");
        }

        @Test
        @TestMetadata("kt47449.kt")
        public void testKt47449() throws Exception {
            runTest("compiler/testData/codegen/box/functions/kt47449.kt");
        }

        @Test
        @TestMetadata("kt47527.kt")
        public void testKt47527() throws Exception {
            runTest("compiler/testData/codegen/box/functions/kt47527.kt");
        }

        @Test
        @TestMetadata("kt48058.kt")
        public void testKt48058() throws Exception {
            runTest("compiler/testData/codegen/box/functions/kt48058.kt");
        }

        @Test
        @TestMetadata("kt785.kt")
        public void testKt785() throws Exception {
            runTest("compiler/testData/codegen/box/functions/kt785.kt");
        }

        @Test
        @TestMetadata("kt873.kt")
        public void testKt873() throws Exception {
            runTest("compiler/testData/codegen/box/functions/kt873.kt");
        }

        @Test
        @TestMetadata("localFunction.kt")
        public void testLocalFunction() throws Exception {
            runTest("compiler/testData/codegen/box/functions/localFunction.kt");
        }

        @Test
        @TestMetadata("localReturnInsideFunctionExpression.kt")
        public void testLocalReturnInsideFunctionExpression() throws Exception {
            runTest("compiler/testData/codegen/box/functions/localReturnInsideFunctionExpression.kt");
        }

        @Test
        @TestMetadata("max.kt")
        public void testMax() throws Exception {
            runTest("compiler/testData/codegen/box/functions/max.kt");
        }

        @Test
        @TestMetadata("mutualInline.kt")
        public void testMutualInline() throws Exception {
            runTest("compiler/testData/codegen/box/functions/mutualInline.kt");
        }

        @Test
        @TestMetadata("nothisnoclosure.kt")
        public void testNothisnoclosure() throws Exception {
            runTest("compiler/testData/codegen/box/functions/nothisnoclosure.kt");
        }

        @Test
        @TestMetadata("overloadByInterfaceType.kt")
        public void testOverloadByInterfaceType() throws Exception {
            runTest("compiler/testData/codegen/box/functions/overloadByInterfaceType.kt");
        }

        @Test
        @TestMetadata("prefixRecursiveCall.kt")
        public void testPrefixRecursiveCall() throws Exception {
            runTest("compiler/testData/codegen/box/functions/prefixRecursiveCall.kt");
        }

        @Test
        @TestMetadata("recursiveCompareTo.kt")
        public void testRecursiveCompareTo() throws Exception {
            runTest("compiler/testData/codegen/box/functions/recursiveCompareTo.kt");
        }

        @Test
        @TestMetadata("recursiveIncrementCall.kt")
        public void testRecursiveIncrementCall() throws Exception {
            runTest("compiler/testData/codegen/box/functions/recursiveIncrementCall.kt");
        }

        @Test
        @TestMetadata("referencesStaticInnerClassMethod.kt")
        public void testReferencesStaticInnerClassMethod() throws Exception {
            runTest("compiler/testData/codegen/box/functions/referencesStaticInnerClassMethod.kt");
        }

        @Test
        @TestMetadata("referencesStaticInnerClassMethodL2.kt")
        public void testReferencesStaticInnerClassMethodL2() throws Exception {
            runTest("compiler/testData/codegen/box/functions/referencesStaticInnerClassMethodL2.kt");
        }

        @Test
        @TestMetadata("typeParameterAsUpperBound.kt")
        public void testTypeParameterAsUpperBound() throws Exception {
            runTest("compiler/testData/codegen/box/functions/typeParameterAsUpperBound.kt");
        }

        @Test
        @TestMetadata("typeParametersInLocalFunction.kt")
        public void testTypeParametersInLocalFunction() throws Exception {
            runTest("compiler/testData/codegen/box/functions/typeParametersInLocalFunction.kt");
        }

        @Test
        @TestMetadata("unrelatedUpperBounds.kt")
        public void testUnrelatedUpperBounds() throws Exception {
            runTest("compiler/testData/codegen/box/functions/unrelatedUpperBounds.kt");
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/box/functions/bigArity")
        @TestDataPath("$PROJECT_ROOT")
        public class BigArity {
            @Test
            public void testAllFilesPresentInBigArity() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/functions/bigArity"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("callFromJava.kt")
            public void testCallFromJava() throws Exception {
                runTest("compiler/testData/codegen/box/functions/bigArity/callFromJava.kt");
            }

            @Test
            @TestMetadata("callFunViaVararg.kt")
            public void testCallFunViaVararg() throws Exception {
                runTest("compiler/testData/codegen/box/functions/bigArity/callFunViaVararg.kt");
            }

            @Test
            @TestMetadata("callWithIncorrectNumberOfArguments.kt")
            public void testCallWithIncorrectNumberOfArguments() throws Exception {
                runTest("compiler/testData/codegen/box/functions/bigArity/callWithIncorrectNumberOfArguments.kt");
            }

            @Test
            @TestMetadata("function255.kt")
            public void testFunction255() throws Exception {
                runTest("compiler/testData/codegen/box/functions/bigArity/function255.kt");
            }

            @Test
            @TestMetadata("instanceOfCallableReference.kt")
            public void testInstanceOfCallableReference() throws Exception {
                runTest("compiler/testData/codegen/box/functions/bigArity/instanceOfCallableReference.kt");
            }

            @Test
            @TestMetadata("invokeCallableReference.kt")
            public void testInvokeCallableReference() throws Exception {
                runTest("compiler/testData/codegen/box/functions/bigArity/invokeCallableReference.kt");
            }

            @Test
            @TestMetadata("invokeLambda.kt")
            public void testInvokeLambda() throws Exception {
                runTest("compiler/testData/codegen/box/functions/bigArity/invokeLambda.kt");
            }

            @Test
            @TestMetadata("invokeMemberCallableReference.kt")
            public void testInvokeMemberCallableReference() throws Exception {
                runTest("compiler/testData/codegen/box/functions/bigArity/invokeMemberCallableReference.kt");
            }

            @Test
            @TestMetadata("javaLambda.kt")
            public void testJavaLambda() throws Exception {
                runTest("compiler/testData/codegen/box/functions/bigArity/javaLambda.kt");
            }

            @Test
            @TestMetadata("nestedBigArityFunCalls.kt")
            public void testNestedBigArityFunCalls() throws Exception {
                runTest("compiler/testData/codegen/box/functions/bigArity/nestedBigArityFunCalls.kt");
            }

            @Test
            @TestMetadata("subclass.kt")
            public void testSubclass() throws Exception {
                runTest("compiler/testData/codegen/box/functions/bigArity/subclass.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/box/functions/functionExpression")
        @TestDataPath("$PROJECT_ROOT")
        public class FunctionExpression {
            @Test
            public void testAllFilesPresentInFunctionExpression() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/functions/functionExpression"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("functionExpression.kt")
            public void testFunctionExpression() throws Exception {
                runTest("compiler/testData/codegen/box/functions/functionExpression/functionExpression.kt");
            }

            @Test
            @TestMetadata("functionExpressionWithThisReference.kt")
            public void testFunctionExpressionWithThisReference() throws Exception {
                runTest("compiler/testData/codegen/box/functions/functionExpression/functionExpressionWithThisReference.kt");
            }

            @Test
            @TestMetadata("functionLiteralExpression.kt")
            public void testFunctionLiteralExpression() throws Exception {
                runTest("compiler/testData/codegen/box/functions/functionExpression/functionLiteralExpression.kt");
            }

            @Test
            @TestMetadata("insideGenericLambda.kt")
            public void testInsideGenericLambda() throws Exception {
                runTest("compiler/testData/codegen/box/functions/functionExpression/insideGenericLambda.kt");
            }

            @Test
            @TestMetadata("underscoreParameters.kt")
            public void testUnderscoreParameters() throws Exception {
                runTest("compiler/testData/codegen/box/functions/functionExpression/underscoreParameters.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/box/functions/invoke")
        @TestDataPath("$PROJECT_ROOT")
        public class Invoke {
            @Test
            public void testAllFilesPresentInInvoke() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/functions/invoke"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("castFunctionToExtension.kt")
            public void testCastFunctionToExtension() throws Exception {
                runTest("compiler/testData/codegen/box/functions/invoke/castFunctionToExtension.kt");
            }

            @Test
            @TestMetadata("extensionInvokeOnExpr.kt")
            public void testExtensionInvokeOnExpr() throws Exception {
                runTest("compiler/testData/codegen/box/functions/invoke/extensionInvokeOnExpr.kt");
            }

            @Test
            @TestMetadata("implicitInvokeInCompanionObjectWithFunctionalArgument.kt")
            public void testImplicitInvokeInCompanionObjectWithFunctionalArgument() throws Exception {
                runTest("compiler/testData/codegen/box/functions/invoke/implicitInvokeInCompanionObjectWithFunctionalArgument.kt");
            }

            @Test
            @TestMetadata("implicitInvokeWithFunctionLiteralArgument.kt")
            public void testImplicitInvokeWithFunctionLiteralArgument() throws Exception {
                runTest("compiler/testData/codegen/box/functions/invoke/implicitInvokeWithFunctionLiteralArgument.kt");
            }

            @Test
            @TestMetadata("invoke.kt")
            public void testInvoke() throws Exception {
                runTest("compiler/testData/codegen/box/functions/invoke/invoke.kt");
            }

            @Test
            @TestMetadata("invokeOnExprByConvention.kt")
            public void testInvokeOnExprByConvention() throws Exception {
                runTest("compiler/testData/codegen/box/functions/invoke/invokeOnExprByConvention.kt");
            }

            @Test
            @TestMetadata("invokeOnSyntheticProperty.kt")
            public void testInvokeOnSyntheticProperty() throws Exception {
                runTest("compiler/testData/codegen/box/functions/invoke/invokeOnSyntheticProperty.kt");
            }

            @Test
            @TestMetadata("kt3189.kt")
            public void testKt3189() throws Exception {
                runTest("compiler/testData/codegen/box/functions/invoke/kt3189.kt");
            }

            @Test
            @TestMetadata("kt3190.kt")
            public void testKt3190() throws Exception {
                runTest("compiler/testData/codegen/box/functions/invoke/kt3190.kt");
            }

            @Test
            @TestMetadata("kt3297.kt")
            public void testKt3297() throws Exception {
                runTest("compiler/testData/codegen/box/functions/invoke/kt3297.kt");
            }

            @Test
            @TestMetadata("kt3450getAndInvoke.kt")
            public void testKt3450getAndInvoke() throws Exception {
                runTest("compiler/testData/codegen/box/functions/invoke/kt3450getAndInvoke.kt");
            }

            @Test
            @TestMetadata("kt3631invokeOnString.kt")
            public void testKt3631invokeOnString() throws Exception {
                runTest("compiler/testData/codegen/box/functions/invoke/kt3631invokeOnString.kt");
            }

            @Test
            @TestMetadata("kt3772.kt")
            public void testKt3772() throws Exception {
                runTest("compiler/testData/codegen/box/functions/invoke/kt3772.kt");
            }

            @Test
            @TestMetadata("kt3821invokeOnThis.kt")
            public void testKt3821invokeOnThis() throws Exception {
                runTest("compiler/testData/codegen/box/functions/invoke/kt3821invokeOnThis.kt");
            }

            @Test
            @TestMetadata("kt3822invokeOnThis.kt")
            public void testKt3822invokeOnThis() throws Exception {
                runTest("compiler/testData/codegen/box/functions/invoke/kt3822invokeOnThis.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/box/functions/localFunctions")
        @TestDataPath("$PROJECT_ROOT")
        public class LocalFunctions {
            @Test
            public void testAllFilesPresentInLocalFunctions() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/functions/localFunctions"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("boundTypeParameterInSupertype.kt")
            public void testBoundTypeParameterInSupertype() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/boundTypeParameterInSupertype.kt");
            }

            @Test
            @TestMetadata("boundTypeParameterInVararg.kt")
            public void testBoundTypeParameterInVararg() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/boundTypeParameterInVararg.kt");
            }

            @Test
            @TestMetadata("callBetweenLocalFunctions.kt")
            public void testCallBetweenLocalFunctions() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/callBetweenLocalFunctions.kt");
            }

            @Test
            @TestMetadata("callInlineLocalInLambda.kt")
            public void testCallInlineLocalInLambda() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/callInlineLocalInLambda.kt");
            }

            @Test
            @TestMetadata("captureUpperBoundedTypeParameter.kt")
            public void testCaptureUpperBoundedTypeParameter() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/captureUpperBoundedTypeParameter.kt");
            }

            @Test
            @TestMetadata("definedWithinLambda.kt")
            public void testDefinedWithinLambda() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/definedWithinLambda.kt");
            }

            @Test
            @TestMetadata("definedWithinLambdaInnerUsage1.kt")
            public void testDefinedWithinLambdaInnerUsage1() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/definedWithinLambdaInnerUsage1.kt");
            }

            @Test
            @TestMetadata("definedWithinLambdaInnerUsage2.kt")
            public void testDefinedWithinLambdaInnerUsage2() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/definedWithinLambdaInnerUsage2.kt");
            }

            @Test
            @TestMetadata("kt2895.kt")
            public void testKt2895() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/kt2895.kt");
            }

            @Test
            @TestMetadata("kt3308.kt")
            public void testKt3308() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/kt3308.kt");
            }

            @Test
            @TestMetadata("kt3978.kt")
            public void testKt3978() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/kt3978.kt");
            }

            @Test
            @TestMetadata("kt3978_2.kt")
            public void testKt3978_2() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/kt3978_2.kt");
            }

            @Test
            @TestMetadata("kt4119.kt")
            public void testKt4119() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/kt4119.kt");
            }

            @Test
            @TestMetadata("kt4119_2.kt")
            public void testKt4119_2() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/kt4119_2.kt");
            }

            @Test
            @TestMetadata("kt4514.kt")
            public void testKt4514() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/kt4514.kt");
            }

            @Test
            @TestMetadata("kt4777.kt")
            public void testKt4777() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/kt4777.kt");
            }

            @Test
            @TestMetadata("kt4783.kt")
            public void testKt4783() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/kt4783.kt");
            }

            @Test
            @TestMetadata("kt4784.kt")
            public void testKt4784() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/kt4784.kt");
            }

            @Test
            @TestMetadata("kt4989.kt")
            public void testKt4989() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/kt4989.kt");
            }

            @Test
            @TestMetadata("localExtensionOnNullableParameter.kt")
            public void testLocalExtensionOnNullableParameter() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/localExtensionOnNullableParameter.kt");
            }

            @Test
            @TestMetadata("localFunctionInConstructor.kt")
            public void testLocalFunctionInConstructor() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/localFunctionInConstructor.kt");
            }

            @Test
            @TestMetadata("localFunctionVsLocalVariable.kt")
            public void testLocalFunctionVsLocalVariable() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/localFunctionVsLocalVariable.kt");
            }

            @Test
            @TestMetadata("nameClash.kt")
            public void testNameClash() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/nameClash.kt");
            }

            @Test
            @TestMetadata("nameClashAcrossDifferentContainers.kt")
            public void testNameClashAcrossDifferentContainers() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/nameClashAcrossDifferentContainers.kt");
            }

            @Test
            @TestMetadata("overloadedLocalFunWithoutClosure.kt")
            public void testOverloadedLocalFunWithoutClosure() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/overloadedLocalFunWithoutClosure.kt");
            }

            @Test
            @TestMetadata("overloadedLocalFunction.kt")
            public void testOverloadedLocalFunction() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/overloadedLocalFunction.kt");
            }

            @Test
            @TestMetadata("overloadedLocalFunction1.kt")
            public void testOverloadedLocalFunction1() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/overloadedLocalFunction1.kt");
            }

            @Test
            @TestMetadata("overloadedLocalFunction2.kt")
            public void testOverloadedLocalFunction2() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/overloadedLocalFunction2.kt");
            }

            @Test
            @TestMetadata("overloadedLocalFunction3.kt")
            public void testOverloadedLocalFunction3() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/overloadedLocalFunction3.kt");
            }

            @Test
            @TestMetadata("parameterAsDefaultValue.kt")
            public void testParameterAsDefaultValue() throws Exception {
                runTest("compiler/testData/codegen/box/functions/localFunctions/parameterAsDefaultValue.kt");
            }
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/hashPMap")
    @TestDataPath("$PROJECT_ROOT")
    public class HashPMap {
        @Test
        public void testAllFilesPresentInHashPMap() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/hashPMap"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("empty.kt")
        public void testEmpty() throws Exception {
            runTest("compiler/testData/codegen/box/hashPMap/empty.kt");
        }

        @Test
        @TestMetadata("manyNumbers.kt")
        public void testManyNumbers() throws Exception {
            runTest("compiler/testData/codegen/box/hashPMap/manyNumbers.kt");
        }

        @Test
        @TestMetadata("rewriteWithDifferent.kt")
        public void testRewriteWithDifferent() throws Exception {
            runTest("compiler/testData/codegen/box/hashPMap/rewriteWithDifferent.kt");
        }

        @Test
        @TestMetadata("rewriteWithEqual.kt")
        public void testRewriteWithEqual() throws Exception {
            runTest("compiler/testData/codegen/box/hashPMap/rewriteWithEqual.kt");
        }

        @Test
        @TestMetadata("simplePlusGet.kt")
        public void testSimplePlusGet() throws Exception {
            runTest("compiler/testData/codegen/box/hashPMap/simplePlusGet.kt");
        }

        @Test
        @TestMetadata("simplePlusMinus.kt")
        public void testSimplePlusMinus() throws Exception {
            runTest("compiler/testData/codegen/box/hashPMap/simplePlusMinus.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/ieee754")
    @TestDataPath("$PROJECT_ROOT")
    public class Ieee754 {
        @Test
        public void testAllFilesPresentInIeee754() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/ieee754"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("anyCastToPrimitiveCompareTo1.kt")
        public void testAnyCastToPrimitiveCompareTo1() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/anyCastToPrimitiveCompareTo1.kt");
        }

        @Test
        @TestMetadata("anyCastToPrimitiveCompareTo2.kt")
        public void testAnyCastToPrimitiveCompareTo2() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/anyCastToPrimitiveCompareTo2.kt");
        }

        @Test
        @TestMetadata("anyToReal.kt")
        public void testAnyToReal() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/anyToReal.kt");
        }

        @Test
        @TestMetadata("anyToReal_AgainstCompiled.kt")
        public void testAnyToReal_AgainstCompiled() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/anyToReal_AgainstCompiled.kt");
        }

        @Test
        @TestMetadata("asComparableToDouble.kt")
        public void testAsComparableToDouble() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/asComparableToDouble.kt");
        }

        @Test
        @TestMetadata("asComparableToDouble_properIeeeComparisons.kt")
        public void testAsComparableToDouble_properIeeeComparisons() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/asComparableToDouble_properIeeeComparisons.kt");
        }

        @Test
        @TestMetadata("comparableToTWithT_properIeeeComparisons.kt")
        public void testComparableToTWithT_properIeeeComparisons() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/comparableToTWithT_properIeeeComparisons.kt");
        }

        @Test
        @TestMetadata("comparableTypeCast.kt")
        public void testComparableTypeCast() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/comparableTypeCast.kt");
        }

        @Test
        @TestMetadata("comparableTypeCast_AgainstCompiled.kt")
        public void testComparableTypeCast_AgainstCompiled() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/comparableTypeCast_AgainstCompiled.kt");
        }

        @Test
        @TestMetadata("dataClass.kt")
        public void testDataClass() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/dataClass.kt");
        }

        @Test
        @TestMetadata("differentTypesComparison.kt")
        public void testDifferentTypesComparison() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/differentTypesComparison.kt");
        }

        @Test
        @TestMetadata("double.kt")
        public void testDouble() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/double.kt");
        }

        @Test
        @TestMetadata("equalsDouble.kt")
        public void testEqualsDouble() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/equalsDouble.kt");
        }

        @Test
        @TestMetadata("equalsDouble_properIeeeComparisons.kt")
        public void testEqualsDouble_properIeeeComparisons() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/equalsDouble_properIeeeComparisons.kt");
        }

        @Test
        @TestMetadata("equalsFloat.kt")
        public void testEqualsFloat() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/equalsFloat.kt");
        }

        @Test
        @TestMetadata("equalsFloat_properIeeeComparisons.kt")
        public void testEqualsFloat_properIeeeComparisons() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/equalsFloat_properIeeeComparisons.kt");
        }

        @Test
        @TestMetadata("equalsNaN.kt")
        public void testEqualsNaN() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/equalsNaN.kt");
        }

        @Test
        @TestMetadata("equalsNaN_properIeeeComparisons.kt")
        public void testEqualsNaN_properIeeeComparisons() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/equalsNaN_properIeeeComparisons.kt");
        }

        @Test
        @TestMetadata("equalsNullableDouble.kt")
        public void testEqualsNullableDouble() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/equalsNullableDouble.kt");
        }

        @Test
        @TestMetadata("equalsNullableDouble_properIeeeComparisons.kt")
        public void testEqualsNullableDouble_properIeeeComparisons() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/equalsNullableDouble_properIeeeComparisons.kt");
        }

        @Test
        @TestMetadata("equalsNullableFloat.kt")
        public void testEqualsNullableFloat() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/equalsNullableFloat.kt");
        }

        @Test
        @TestMetadata("equalsNullableFloat_properIeeeComparisons.kt")
        public void testEqualsNullableFloat_properIeeeComparisons() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/equalsNullableFloat_properIeeeComparisons.kt");
        }

        @Test
        @TestMetadata("explicitCompareCall.kt")
        public void testExplicitCompareCall() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/explicitCompareCall.kt");
        }

        @Test
        @TestMetadata("explicitCompareCall_AgainstCompiled.kt")
        public void testExplicitCompareCall_AgainstCompiled() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/explicitCompareCall_AgainstCompiled.kt");
        }

        @Test
        @TestMetadata("explicitEqualsCall.kt")
        public void testExplicitEqualsCall() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/explicitEqualsCall.kt");
        }

        @Test
        @TestMetadata("explicitEqualsCall_AgainstCompiled.kt")
        public void testExplicitEqualsCall_AgainstCompiled() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/explicitEqualsCall_AgainstCompiled.kt");
        }

        @Test
        @TestMetadata("float.kt")
        public void testFloat() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/float.kt");
        }

        @Test
        @TestMetadata("generic.kt")
        public void testGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/generic.kt");
        }

        @Test
        @TestMetadata("generic_AgainstCompiled.kt")
        public void testGeneric_AgainstCompiled() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/generic_AgainstCompiled.kt");
        }

        @Test
        @TestMetadata("greaterDouble.kt")
        public void testGreaterDouble() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/greaterDouble.kt");
        }

        @Test
        @TestMetadata("greaterDouble_properIeeeComparisons.kt")
        public void testGreaterDouble_properIeeeComparisons() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/greaterDouble_properIeeeComparisons.kt");
        }

        @Test
        @TestMetadata("greaterFloat.kt")
        public void testGreaterFloat() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/greaterFloat.kt");
        }

        @Test
        @TestMetadata("greaterFloat_properIeeeComparisons.kt")
        public void testGreaterFloat_properIeeeComparisons() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/greaterFloat_properIeeeComparisons.kt");
        }

        @Test
        @TestMetadata("inline.kt")
        public void testInline() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/inline.kt");
        }

        @Test
        @TestMetadata("kt48648_genericField.kt")
        public void testKt48648_genericField() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/kt48648_genericField.kt");
        }

        @Test
        @TestMetadata("lessDouble.kt")
        public void testLessDouble() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/lessDouble.kt");
        }

        @Test
        @TestMetadata("lessDouble_properIeeeAndNewInference.kt")
        public void testLessDouble_properIeeeAndNewInference() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/lessDouble_properIeeeAndNewInference.kt");
        }

        @Test
        @TestMetadata("lessDouble_properIeeeComparisons.kt")
        public void testLessDouble_properIeeeComparisons() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/lessDouble_properIeeeComparisons.kt");
        }

        @Test
        @TestMetadata("lessFloat.kt")
        public void testLessFloat() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/lessFloat.kt");
        }

        @Test
        @TestMetadata("lessFloat_properIeeeComparisons.kt")
        public void testLessFloat_properIeeeComparisons() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/lessFloat_properIeeeComparisons.kt");
        }

        @Test
        @TestMetadata("nullableAnyToReal.kt")
        public void testNullableAnyToReal() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/nullableAnyToReal.kt");
        }

        @Test
        @TestMetadata("nullableAnyToReal_AgainstCompiled.kt")
        public void testNullableAnyToReal_AgainstCompiled() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/nullableAnyToReal_AgainstCompiled.kt");
        }

        @Test
        @TestMetadata("nullableDoubleEquals.kt")
        public void testNullableDoubleEquals() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/nullableDoubleEquals.kt");
        }

        @Test
        @TestMetadata("nullableDoubleEqualsLV13.kt")
        public void testNullableDoubleEqualsLV13() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/nullableDoubleEqualsLV13.kt");
        }

        @Test
        @TestMetadata("nullableDoubleNotEquals.kt")
        public void testNullableDoubleNotEquals() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/nullableDoubleNotEquals.kt");
        }

        @Test
        @TestMetadata("nullableFloatEquals.kt")
        public void testNullableFloatEquals() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/nullableFloatEquals.kt");
        }

        @Test
        @TestMetadata("nullableFloatNotEquals.kt")
        public void testNullableFloatNotEquals() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/nullableFloatNotEquals.kt");
        }

        @Test
        @TestMetadata("nullableIntEquals.kt")
        public void testNullableIntEquals() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/nullableIntEquals.kt");
        }

        @Test
        @TestMetadata("safeCall.kt")
        public void testSafeCall() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/safeCall.kt");
        }

        @Test
        @TestMetadata("smartCastOnWhenSubjectAfterCheckInBranch_properIeeeComparisons.kt")
        public void testSmartCastOnWhenSubjectAfterCheckInBranch_properIeeeComparisons() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/smartCastOnWhenSubjectAfterCheckInBranch_properIeeeComparisons.kt");
        }

        @Test
        @TestMetadata("smartCastToDifferentTypes.kt")
        public void testSmartCastToDifferentTypes() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/smartCastToDifferentTypes.kt");
        }

        @Test
        @TestMetadata("smartCastToDifferentTypesWithNumericPromotion.kt")
        public void testSmartCastToDifferentTypesWithNumericPromotion() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/smartCastToDifferentTypesWithNumericPromotion.kt");
        }

        @Test
        @TestMetadata("smartCastToDifferentTypesWithNumericPromotion_properIeeeComparisons.kt")
        public void testSmartCastToDifferentTypesWithNumericPromotion_properIeeeComparisons() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/smartCastToDifferentTypesWithNumericPromotion_properIeeeComparisons.kt");
        }

        @Test
        @TestMetadata("smartCastToDifferentTypes_properIeeeComparisons.kt")
        public void testSmartCastToDifferentTypes_properIeeeComparisons() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/smartCastToDifferentTypes_properIeeeComparisons.kt");
        }

        @Test
        @TestMetadata("smartCastToDoubleAndComparableToDouble.kt")
        public void testSmartCastToDoubleAndComparableToDouble() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/smartCastToDoubleAndComparableToDouble.kt");
        }

        @Test
        @TestMetadata("smartCastToInt.kt")
        public void testSmartCastToInt() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/smartCastToInt.kt");
        }

        @Test
        @TestMetadata("when.kt")
        public void testWhen() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/when.kt");
        }

        @Test
        @TestMetadata("whenNoSubject.kt")
        public void testWhenNoSubject() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/whenNoSubject.kt");
        }

        @Test
        @TestMetadata("whenNoSubject_properIeeeComparisons.kt")
        public void testWhenNoSubject_properIeeeComparisons() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/whenNoSubject_properIeeeComparisons.kt");
        }

        @Test
        @TestMetadata("whenNullableSmartCast.kt")
        public void testWhenNullableSmartCast() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/whenNullableSmartCast.kt");
        }

        @Test
        @TestMetadata("when_properIeeeComparisons.kt")
        public void testWhen_properIeeeComparisons() throws Exception {
            runTest("compiler/testData/codegen/box/ieee754/when_properIeeeComparisons.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/increment")
    @TestDataPath("$PROJECT_ROOT")
    public class Increment {
        @Test
        public void testAllFilesPresentInIncrement() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/increment"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("argumentWithSideEffects.kt")
        public void testArgumentWithSideEffects() throws Exception {
            runTest("compiler/testData/codegen/box/increment/argumentWithSideEffects.kt");
        }

        @Test
        @TestMetadata("arrayElement.kt")
        public void testArrayElement() throws Exception {
            runTest("compiler/testData/codegen/box/increment/arrayElement.kt");
        }

        @Test
        @TestMetadata("assignPlusOnSmartCast.kt")
        public void testAssignPlusOnSmartCast() throws Exception {
            runTest("compiler/testData/codegen/box/increment/assignPlusOnSmartCast.kt");
        }

        @Test
        @TestMetadata("augmentedAssignmentWithComplexRhs.kt")
        public void testAugmentedAssignmentWithComplexRhs() throws Exception {
            runTest("compiler/testData/codegen/box/increment/augmentedAssignmentWithComplexRhs.kt");
        }

        @Test
        @TestMetadata("classNaryGetSet.kt")
        public void testClassNaryGetSet() throws Exception {
            runTest("compiler/testData/codegen/box/increment/classNaryGetSet.kt");
        }

        @Test
        @TestMetadata("classVarargGetSet.kt")
        public void testClassVarargGetSet() throws Exception {
            runTest("compiler/testData/codegen/box/increment/classVarargGetSet.kt");
        }

        @Test
        @TestMetadata("classVarargGetSetEvaluationOrder.kt")
        public void testClassVarargGetSetEvaluationOrder() throws Exception {
            runTest("compiler/testData/codegen/box/increment/classVarargGetSetEvaluationOrder.kt");
        }

        @Test
        @TestMetadata("classWithGetSet.kt")
        public void testClassWithGetSet() throws Exception {
            runTest("compiler/testData/codegen/box/increment/classWithGetSet.kt");
        }

        @Test
        @TestMetadata("extOnLong.kt")
        public void testExtOnLong() throws Exception {
            runTest("compiler/testData/codegen/box/increment/extOnLong.kt");
        }

        @Test
        @TestMetadata("genericClassWithGetSet.kt")
        public void testGenericClassWithGetSet() throws Exception {
            runTest("compiler/testData/codegen/box/increment/genericClassWithGetSet.kt");
        }

        @Test
        @TestMetadata("kt36956.kt")
        public void testKt36956() throws Exception {
            runTest("compiler/testData/codegen/box/increment/kt36956.kt");
        }

        @Test
        @TestMetadata("memberExtOnLong.kt")
        public void testMemberExtOnLong() throws Exception {
            runTest("compiler/testData/codegen/box/increment/memberExtOnLong.kt");
        }

        @Test
        @TestMetadata("mutableListElement.kt")
        public void testMutableListElement() throws Exception {
            runTest("compiler/testData/codegen/box/increment/mutableListElement.kt");
        }

        @Test
        @TestMetadata("nullable.kt")
        public void testNullable() throws Exception {
            runTest("compiler/testData/codegen/box/increment/nullable.kt");
        }

        @Test
        @TestMetadata("postfixIncrementDoubleSmartCast.kt")
        public void testPostfixIncrementDoubleSmartCast() throws Exception {
            runTest("compiler/testData/codegen/box/increment/postfixIncrementDoubleSmartCast.kt");
        }

        @Test
        @TestMetadata("postfixIncrementOnClass.kt")
        public void testPostfixIncrementOnClass() throws Exception {
            runTest("compiler/testData/codegen/box/increment/postfixIncrementOnClass.kt");
        }

        @Test
        @TestMetadata("postfixIncrementOnClassSmartCast.kt")
        public void testPostfixIncrementOnClassSmartCast() throws Exception {
            runTest("compiler/testData/codegen/box/increment/postfixIncrementOnClassSmartCast.kt");
        }

        @Test
        @TestMetadata("postfixIncrementOnShortSmartCast.kt")
        public void testPostfixIncrementOnShortSmartCast() throws Exception {
            runTest("compiler/testData/codegen/box/increment/postfixIncrementOnShortSmartCast.kt");
        }

        @Test
        @TestMetadata("postfixIncrementOnSmartCast.kt")
        public void testPostfixIncrementOnSmartCast() throws Exception {
            runTest("compiler/testData/codegen/box/increment/postfixIncrementOnSmartCast.kt");
        }

        @Test
        @TestMetadata("postfixNullableClassIncrement.kt")
        public void testPostfixNullableClassIncrement() throws Exception {
            runTest("compiler/testData/codegen/box/increment/postfixNullableClassIncrement.kt");
        }

        @Test
        @TestMetadata("postfixNullableIncrement.kt")
        public void testPostfixNullableIncrement() throws Exception {
            runTest("compiler/testData/codegen/box/increment/postfixNullableIncrement.kt");
        }

        @Test
        @TestMetadata("prefixIncrementOnClass.kt")
        public void testPrefixIncrementOnClass() throws Exception {
            runTest("compiler/testData/codegen/box/increment/prefixIncrementOnClass.kt");
        }

        @Test
        @TestMetadata("prefixIncrementOnClassSmartCast.kt")
        public void testPrefixIncrementOnClassSmartCast() throws Exception {
            runTest("compiler/testData/codegen/box/increment/prefixIncrementOnClassSmartCast.kt");
        }

        @Test
        @TestMetadata("prefixIncrementOnSmartCast.kt")
        public void testPrefixIncrementOnSmartCast() throws Exception {
            runTest("compiler/testData/codegen/box/increment/prefixIncrementOnSmartCast.kt");
        }

        @Test
        @TestMetadata("prefixNullableClassIncrement.kt")
        public void testPrefixNullableClassIncrement() throws Exception {
            runTest("compiler/testData/codegen/box/increment/prefixNullableClassIncrement.kt");
        }

        @Test
        @TestMetadata("prefixNullableIncrement.kt")
        public void testPrefixNullableIncrement() throws Exception {
            runTest("compiler/testData/codegen/box/increment/prefixNullableIncrement.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/inference")
    @TestDataPath("$PROJECT_ROOT")
    public class Inference {
        @Test
        public void testAllFilesPresentInInference() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/inference"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("approximateNonTopLevelCapturedTypes.kt")
        public void testApproximateNonTopLevelCapturedTypes() throws Exception {
            runTest("compiler/testData/codegen/box/inference/approximateNonTopLevelCapturedTypes.kt");
        }

        @Test
        @TestMetadata("builderInference.kt")
        public void testBuilderInference() throws Exception {
            runTest("compiler/testData/codegen/box/inference/builderInference.kt");
        }

        @Test
        @TestMetadata("builderInferenceLeakingVariable.kt")
        public void testBuilderInferenceLeakingVariable() throws Exception {
            runTest("compiler/testData/codegen/box/inference/builderInferenceLeakingVariable.kt");
        }

        @Test
        @TestMetadata("capturedStarProjection.kt")
        public void testCapturedStarProjection() throws Exception {
            runTest("compiler/testData/codegen/box/inference/capturedStarProjection.kt");
        }

        @Test
        @TestMetadata("capturedTypesSubstitutionIntoAbbreviation.kt")
        public void testCapturedTypesSubstitutionIntoAbbreviation() throws Exception {
            runTest("compiler/testData/codegen/box/inference/capturedTypesSubstitutionIntoAbbreviation.kt");
        }

        @Test
        @TestMetadata("coercionToUnitForLambdaReturnTypeWithFlexibleConstraint.kt")
        public void testCoercionToUnitForLambdaReturnTypeWithFlexibleConstraint() throws Exception {
            runTest("compiler/testData/codegen/box/inference/coercionToUnitForLambdaReturnTypeWithFlexibleConstraint.kt");
        }

        @Test
        @TestMetadata("coercionToUnitWithLastLambdaExpression.kt")
        public void testCoercionToUnitWithLastLambdaExpression() throws Exception {
            runTest("compiler/testData/codegen/box/inference/coercionToUnitWithLastLambdaExpression.kt");
        }

        @Test
        @TestMetadata("coerctionToUnitForLastExpressionWithStarProjection.kt")
        public void testCoerctionToUnitForLastExpressionWithStarProjection() throws Exception {
            runTest("compiler/testData/codegen/box/inference/coerctionToUnitForLastExpressionWithStarProjection.kt");
        }

        @Test
        @TestMetadata("earlyReturnInsideCrossinlineLambda.kt")
        public void testEarlyReturnInsideCrossinlineLambda() throws Exception {
            runTest("compiler/testData/codegen/box/inference/earlyReturnInsideCrossinlineLambda.kt");
        }

        @Test
        @TestMetadata("inferenceWithTypeVariableInsideCapturedType.kt")
        public void testInferenceWithTypeVariableInsideCapturedType() throws Exception {
            runTest("compiler/testData/codegen/box/inference/inferenceWithTypeVariableInsideCapturedType.kt");
        }

        @Test
        @TestMetadata("integerLiteralTypeInLamdaReturnType.kt")
        public void testIntegerLiteralTypeInLamdaReturnType() throws Exception {
            runTest("compiler/testData/codegen/box/inference/integerLiteralTypeInLamdaReturnType.kt");
        }

        @Test
        @TestMetadata("intersectionTypeInArguments.kt")
        public void testIntersectionTypeInArguments() throws Exception {
            runTest("compiler/testData/codegen/box/inference/intersectionTypeInArguments.kt");
        }

        @Test
        @TestMetadata("kt10822.kt")
        public void testKt10822() throws Exception {
            runTest("compiler/testData/codegen/box/inference/kt10822.kt");
        }

        @Test
        @TestMetadata("kt26345.kt")
        public void testKt26345() throws Exception {
            runTest("compiler/testData/codegen/box/inference/kt26345.kt");
        }

        @Test
        @TestMetadata("kt32429.kt")
        public void testKt32429() throws Exception {
            runTest("compiler/testData/codegen/box/inference/kt32429.kt");
        }

        @Test
        @TestMetadata("kt35684.kt")
        public void testKt35684() throws Exception {
            runTest("compiler/testData/codegen/box/inference/kt35684.kt");
        }

        @Test
        @TestMetadata("kt36446.kt")
        public void testKt36446() throws Exception {
            runTest("compiler/testData/codegen/box/inference/kt36446.kt");
        }

        @Test
        @TestMetadata("kt38664.kt")
        public void testKt38664() throws Exception {
            runTest("compiler/testData/codegen/box/inference/kt38664.kt");
        }

        @Test
        @TestMetadata("kt39824.kt")
        public void testKt39824() throws Exception {
            runTest("compiler/testData/codegen/box/inference/kt39824.kt");
        }

        @Test
        @TestMetadata("kt42042.kt")
        public void testKt42042() throws Exception {
            runTest("compiler/testData/codegen/box/inference/kt42042.kt");
        }

        @Test
        @TestMetadata("kt42130.kt")
        public void testKt42130() throws Exception {
            runTest("compiler/testData/codegen/box/inference/kt42130.kt");
        }

        @Test
        @TestMetadata("kt45118.kt")
        public void testKt45118() throws Exception {
            runTest("compiler/testData/codegen/box/inference/kt45118.kt");
        }

        @Test
        @TestMetadata("kt47316.kt")
        public void testKt47316() throws Exception {
            runTest("compiler/testData/codegen/box/inference/kt47316.kt");
        }

        @Test
        @TestMetadata("kt49838.kt")
        public void testKt49838() throws Exception {
            runTest("compiler/testData/codegen/box/inference/kt49838.kt");
        }

        @Test
        @TestMetadata("kt51040.kt")
        public void testKt51040() throws Exception {
            runTest("compiler/testData/codegen/box/inference/kt51040.kt");
        }

        @Test
        @TestMetadata("lambdaWithStarReturn.kt")
        public void testLambdaWithStarReturn() throws Exception {
            runTest("compiler/testData/codegen/box/inference/lambdaWithStarReturn.kt");
        }

        @Test
        @TestMetadata("lambdasWithExtensionFunctionType.kt")
        public void testLambdasWithExtensionFunctionType() throws Exception {
            runTest("compiler/testData/codegen/box/inference/lambdasWithExtensionFunctionType.kt");
        }

        @Test
        @TestMetadata("lastExpressionOfLambdaWithNothingConstraint.kt")
        public void testLastExpressionOfLambdaWithNothingConstraint() throws Exception {
            runTest("compiler/testData/codegen/box/inference/lastExpressionOfLambdaWithNothingConstraint.kt");
        }

        @Test
        @TestMetadata("manyConstraintsDueToFlexibleRawTypes.kt")
        public void testManyConstraintsDueToFlexibleRawTypes() throws Exception {
            runTest("compiler/testData/codegen/box/inference/manyConstraintsDueToFlexibleRawTypes.kt");
        }

        @Test
        @TestMetadata("manyFlexibleTypeParametersFromJavaAndConversions.kt")
        public void testManyFlexibleTypeParametersFromJavaAndConversions() throws Exception {
            runTest("compiler/testData/codegen/box/inference/manyFlexibleTypeParametersFromJavaAndConversions.kt");
        }

        @Test
        @TestMetadata("mapCollectChainWithNullResult.kt")
        public void testMapCollectChainWithNullResult() throws Exception {
            runTest("compiler/testData/codegen/box/inference/mapCollectChainWithNullResult.kt");
        }

        @Test
        @TestMetadata("noCoercionToUniForNullableLambdaReturnType.kt")
        public void testNoCoercionToUniForNullableLambdaReturnType() throws Exception {
            runTest("compiler/testData/codegen/box/inference/noCoercionToUniForNullableLambdaReturnType.kt");
        }

        @Test
        @TestMetadata("noCoercionToUnitWithEqualityConstraintForNullableReturnType.kt")
        public void testNoCoercionToUnitWithEqualityConstraintForNullableReturnType() throws Exception {
            runTest("compiler/testData/codegen/box/inference/noCoercionToUnitWithEqualityConstraintForNullableReturnType.kt");
        }

        @Test
        @TestMetadata("noNothingValueInsideSpecialCall.kt")
        public void testNoNothingValueInsideSpecialCall() throws Exception {
            runTest("compiler/testData/codegen/box/inference/noNothingValueInsideSpecialCall.kt");
        }

        @Test
        @TestMetadata("plusAssignInsideLambda.kt")
        public void testPlusAssignInsideLambda() throws Exception {
            runTest("compiler/testData/codegen/box/inference/plusAssignInsideLambda.kt");
        }

        @Test
        @TestMetadata("recursiveConstraintInsideTypeArgumentWithStarProjection.kt")
        public void testRecursiveConstraintInsideTypeArgumentWithStarProjection() throws Exception {
            runTest("compiler/testData/codegen/box/inference/recursiveConstraintInsideTypeArgumentWithStarProjection.kt");
        }

        @Test
        @TestMetadata("referenceToCatchParameterFromLambdaExpression.kt")
        public void testReferenceToCatchParameterFromLambdaExpression() throws Exception {
            runTest("compiler/testData/codegen/box/inference/referenceToCatchParameterFromLambdaExpression.kt");
        }

        @Test
        @TestMetadata("specialCallsWithCallableReferences.kt")
        public void testSpecialCallsWithCallableReferences() throws Exception {
            runTest("compiler/testData/codegen/box/inference/specialCallsWithCallableReferences.kt");
        }

        @Test
        @TestMetadata("substituteIntersectionTypeInsideCapType.kt")
        public void testSubstituteIntersectionTypeInsideCapType() throws Exception {
            runTest("compiler/testData/codegen/box/inference/substituteIntersectionTypeInsideCapType.kt");
        }

        @Test
        @TestMetadata("subtypingOfIntersectionIltInsideFlexible.kt")
        public void testSubtypingOfIntersectionIltInsideFlexible() throws Exception {
            runTest("compiler/testData/codegen/box/inference/subtypingOfIntersectionIltInsideFlexible.kt");
        }

        @Test
        @TestMetadata("sumOfOverloads.kt")
        public void testSumOfOverloads() throws Exception {
            runTest("compiler/testData/codegen/box/inference/sumOfOverloads.kt");
        }

        @Test
        @TestMetadata("suspendExtensionRecevierFromConstraint.kt")
        public void testSuspendExtensionRecevierFromConstraint() throws Exception {
            runTest("compiler/testData/codegen/box/inference/suspendExtensionRecevierFromConstraint.kt");
        }

        @Test
        @TestMetadata("unsafeVarianceCodegen.kt")
        public void testUnsafeVarianceCodegen() throws Exception {
            runTest("compiler/testData/codegen/box/inference/unsafeVarianceCodegen.kt");
        }

        @Test
        @TestMetadata("violatingUpperBoundForSelfType.kt")
        public void testViolatingUpperBoundForSelfType() throws Exception {
            runTest("compiler/testData/codegen/box/inference/violatingUpperBoundForSelfType.kt");
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/box/inference/builderInference")
        @TestDataPath("$PROJECT_ROOT")
        public class BuilderInference {
            @Test
            public void testAllFilesPresentInBuilderInference() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/inference/builderInference"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("builderCallAsReturnTypeInLocalClass.kt")
            public void testBuilderCallAsReturnTypeInLocalClass() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/builderCallAsReturnTypeInLocalClass.kt");
            }

            @Test
            @TestMetadata("callableReferenceAndCoercionToUnit.kt")
            public void testCallableReferenceAndCoercionToUnit() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/callableReferenceAndCoercionToUnit.kt");
            }

            @Test
            @TestMetadata("callableReferencesProperCompletion.kt")
            public void testCallableReferencesProperCompletion() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/callableReferencesProperCompletion.kt");
            }

            @Test
            @TestMetadata("capturedTypes.kt")
            public void testCapturedTypes() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/capturedTypes.kt");
            }

            @Test
            @TestMetadata("changingResolveIfDontUseBuilderInferenceDisabledFeature.kt")
            public void testChangingResolveIfDontUseBuilderInferenceDisabledFeature() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/changingResolveIfDontUseBuilderInferenceDisabledFeature.kt");
            }

            @Test
            @TestMetadata("commonSuperType.kt")
            public void testCommonSuperType() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/commonSuperType.kt");
            }

            @Test
            @TestMetadata("commonSuperTypeContravariant.kt")
            public void testCommonSuperTypeContravariant() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/commonSuperTypeContravariant.kt");
            }

            @Test
            @TestMetadata("commonSuperTypeCovariant.kt")
            public void testCommonSuperTypeCovariant() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/commonSuperTypeCovariant.kt");
            }

            @Test
            @TestMetadata("commonSuperTypeInvariant.kt")
            public void testCommonSuperTypeInvariant() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/commonSuperTypeInvariant.kt");
            }

            @Test
            @TestMetadata("commonSuperTypeNullable.kt")
            public void testCommonSuperTypeNullable() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/commonSuperTypeNullable.kt");
            }

            @Test
            @TestMetadata("constraintsBetweenTwoStubVariables.kt")
            public void testConstraintsBetweenTwoStubVariables() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/constraintsBetweenTwoStubVariables.kt");
            }

            @Test
            @TestMetadata("cstBasedOnTwoBuilderInferenceLambda.kt")
            public void testCstBasedOnTwoBuilderInferenceLambda() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/cstBasedOnTwoBuilderInferenceLambda.kt");
            }

            @Test
            @TestMetadata("inferFromExpectedType.kt")
            public void testInferFromExpectedType() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/inferFromExpectedType.kt");
            }

            @Test
            @TestMetadata("intersect.kt")
            public void testIntersect() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/intersect.kt");
            }

            @Test
            @TestMetadata("kt41164.kt")
            public void testKt41164() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/kt41164.kt");
            }

            @Test
            @TestMetadata("kt42139.kt")
            public void testKt42139() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/kt42139.kt");
            }

            @Test
            @TestMetadata("kt44241.kt")
            public void testKt44241() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/kt44241.kt");
            }

            @Test
            @TestMetadata("kt45083.kt")
            public void testKt45083() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/kt45083.kt");
            }

            @Test
            @TestMetadata("kt47052.kt")
            public void testKt47052() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/kt47052.kt");
            }

            @Test
            @TestMetadata("kt47744.kt")
            public void testKt47744() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/kt47744.kt");
            }

            @Test
            @TestMetadata("kt48445.kt")
            public void testKt48445() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/kt48445.kt");
            }

            @Test
            @TestMetadata("kt48633.kt")
            public void testKt48633() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/kt48633.kt");
            }

            @Test
            @TestMetadata("kt49887.kt")
            public void testKt49887() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/kt49887.kt");
            }

            @Test
            @TestMetadata("kt51988.kt")
            public void testKt51988() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/kt51988.kt");
            }

            @Test
            @TestMetadata("labaledCall.kt")
            public void testLabaledCall() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/labaledCall.kt");
            }

            @Test
            @TestMetadata("lackOfNullCheckOnNullableInsideBuild.kt")
            public void testLackOfNullCheckOnNullableInsideBuild() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/lackOfNullCheckOnNullableInsideBuild.kt");
            }

            @Test
            @TestMetadata("memberScope.kt")
            public void testMemberScope() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/memberScope.kt");
            }

            @Test
            @TestMetadata("nullability.kt")
            public void testNullability() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/nullability.kt");
            }

            @Test
            @TestMetadata("propagateInferenceSessionIntoDeclarationAnalyzers.kt")
            public void testPropagateInferenceSessionIntoDeclarationAnalyzers() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/propagateInferenceSessionIntoDeclarationAnalyzers.kt");
            }

            @Test
            @TestMetadata("specialCallsWithCallableReferences.kt")
            public void testSpecialCallsWithCallableReferences() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/specialCallsWithCallableReferences.kt");
            }

            @Test
            @TestMetadata("specialCallsWithCallableReferencesDontRewriteAtSlice.kt")
            public void testSpecialCallsWithCallableReferencesDontRewriteAtSlice() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/specialCallsWithCallableReferencesDontRewriteAtSlice.kt");
            }

            @Test
            @TestMetadata("specialCallsWithCallableReferencesErrorType.kt")
            public void testSpecialCallsWithCallableReferencesErrorType() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/specialCallsWithCallableReferencesErrorType.kt");
            }

            @Test
            @TestMetadata("specialCallsWithCallableReferencesNonStrictOnlyInputTypes.kt")
            public void testSpecialCallsWithCallableReferencesNonStrictOnlyInputTypes() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/specialCallsWithCallableReferencesNonStrictOnlyInputTypes.kt");
            }

            @Test
            @TestMetadata("specialCallsWithLambdas.kt")
            public void testSpecialCallsWithLambdas() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/specialCallsWithLambdas.kt");
            }

            @Test
            @TestMetadata("substituteStubTypeIntoCR.kt")
            public void testSubstituteStubTypeIntoCR() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/substituteStubTypeIntoCR.kt");
            }

            @Test
            @TestMetadata("substituteStubTypeIntolambdaParameterDescriptor.kt")
            public void testSubstituteStubTypeIntolambdaParameterDescriptor() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/substituteStubTypeIntolambdaParameterDescriptor.kt");
            }

            @Test
            @TestMetadata("substituteTypeVariableIntolambdaParameterDescriptor.kt")
            public void testSubstituteTypeVariableIntolambdaParameterDescriptor() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/substituteTypeVariableIntolambdaParameterDescriptor.kt");
            }

            @Test
            @TestMetadata("substitutelambdaExtensionReceiverType.kt")
            public void testSubstitutelambdaExtensionReceiverType() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/substitutelambdaExtensionReceiverType.kt");
            }

            @Test
            @TestMetadata("topDownCompletionBreakedByNonBuilderInferenceSession.kt")
            public void testTopDownCompletionBreakedByNonBuilderInferenceSession() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/topDownCompletionBreakedByNonBuilderInferenceSession.kt");
            }

            @Test
            @TestMetadata("topDownCompletionWithThreeBuilderInferenceCalls.kt")
            public void testTopDownCompletionWithThreeBuilderInferenceCalls() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/topDownCompletionWithThreeBuilderInferenceCalls.kt");
            }

            @Test
            @TestMetadata("topDownCompletionWithThreeBuilderInferenceCallsSameLevel.kt")
            public void testTopDownCompletionWithThreeBuilderInferenceCallsSameLevel() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/topDownCompletionWithThreeBuilderInferenceCallsSameLevel.kt");
            }

            @Test
            @TestMetadata("topDownCompletionWithTwoBuilderInferenceCalls.kt")
            public void testTopDownCompletionWithTwoBuilderInferenceCalls() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/topDownCompletionWithTwoBuilderInferenceCalls.kt");
            }

            @Test
            @TestMetadata("withExpectedType.kt")
            public void testWithExpectedType() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/withExpectedType.kt");
            }

            @Test
            @TestMetadata("withoutAnnotation.kt")
            public void testWithoutAnnotation() throws Exception {
                runTest("compiler/testData/codegen/box/inference/builderInference/withoutAnnotation.kt");
            }
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/inlineArgsInPlace")
    @TestDataPath("$PROJECT_ROOT")
    public class InlineArgsInPlace {
        @Test
        public void testAllFilesPresentInInlineArgsInPlace() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/inlineArgsInPlace"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("arrayDequeRemoveAll.kt")
        public void testArrayDequeRemoveAll() throws Exception {
            runTest("compiler/testData/codegen/box/inlineArgsInPlace/arrayDequeRemoveAll.kt");
        }

        @Test
        @TestMetadata("breakInArgumentExpression.kt")
        public void testBreakInArgumentExpression() throws Exception {
            runTest("compiler/testData/codegen/box/inlineArgsInPlace/breakInArgumentExpression.kt");
        }

        @Test
        @TestMetadata("continueInArgumentExpression.kt")
        public void testContinueInArgumentExpression() throws Exception {
            runTest("compiler/testData/codegen/box/inlineArgsInPlace/continueInArgumentExpression.kt");
        }

        @Test
        @TestMetadata("inlineCircularDedepency.kt")
        public void testInlineCircularDedepency() throws Exception {
            runTest("compiler/testData/codegen/box/inlineArgsInPlace/inlineCircularDedepency.kt");
        }

        @Test
        @TestMetadata("kotlinReflect.kt")
        public void testKotlinReflect() throws Exception {
            runTest("compiler/testData/codegen/box/inlineArgsInPlace/kotlinReflect.kt");
        }

        @Test
        @TestMetadata("kt49370.kt")
        public void testKt49370() throws Exception {
            runTest("compiler/testData/codegen/box/inlineArgsInPlace/kt49370.kt");
        }

        @Test
        @TestMetadata("kt49407.kt")
        public void testKt49407() throws Exception {
            runTest("compiler/testData/codegen/box/inlineArgsInPlace/kt49407.kt");
        }

        @Test
        @TestMetadata("mapSet.kt")
        public void testMapSet() throws Exception {
            runTest("compiler/testData/codegen/box/inlineArgsInPlace/mapSet.kt");
        }

        @Test
        @TestMetadata("mutableCollectionPlusAssign.kt")
        public void testMutableCollectionPlusAssign() throws Exception {
            runTest("compiler/testData/codegen/box/inlineArgsInPlace/mutableCollectionPlusAssign.kt");
        }

        @Test
        @TestMetadata("noinlineParameter.kt")
        public void testNoinlineParameter() throws Exception {
            runTest("compiler/testData/codegen/box/inlineArgsInPlace/noinlineParameter.kt");
        }

        @Test
        @TestMetadata("suspensionPointInsideArgument.kt")
        public void testSuspensionPointInsideArgument() throws Exception {
            runTest("compiler/testData/codegen/box/inlineArgsInPlace/suspensionPointInsideArgument.kt");
        }

        @Test
        @TestMetadata("withLogFile.kt")
        public void testWithLogFile() throws Exception {
            runTest("compiler/testData/codegen/box/inlineArgsInPlace/withLogFile.kt");
        }
    }

    @Nested
    @TestMetadata("compiler/testData/codegen/box/inlineClasses")
    @TestDataPath("$PROJECT_ROOT")
    public class InlineClasses {
        @Test
        public void testAllFilesPresentInInlineClasses() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/inlineClasses"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("annotatedMemberExtensionProperty.kt")
        public void testAnnotatedMemberExtensionProperty() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/annotatedMemberExtensionProperty.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("annotatedMemberExtensionPropertyGeneric.kt")
        public void testAnnotatedMemberExtensionPropertyGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/annotatedMemberExtensionPropertyGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("anySuperCall.kt")
        public void testAnySuperCall() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/anySuperCall.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("anySuperCallGeneric.kt")
        public void testAnySuperCallGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/anySuperCallGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("boundCallableReferencePassedToInlineFunction.kt")
        public void testBoundCallableReferencePassedToInlineFunction() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/boundCallableReferencePassedToInlineFunction.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("boundCallableReferencePassedToInlineFunctionGeneric.kt")
        public void testBoundCallableReferencePassedToInlineFunctionGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/boundCallableReferencePassedToInlineFunctionGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("boundCallableReferencePassedToInlineFunctionGeneric2.kt")
        public void testBoundCallableReferencePassedToInlineFunctionGeneric2() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/boundCallableReferencePassedToInlineFunctionGeneric2.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("boxImplDoesNotExecuteInSecondaryConstructor.kt")
        public void testBoxImplDoesNotExecuteInSecondaryConstructor() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/boxImplDoesNotExecuteInSecondaryConstructor.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("boxImplDoesNotExecuteInSecondaryConstructorGeneric.kt")
        public void testBoxImplDoesNotExecuteInSecondaryConstructorGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/boxImplDoesNotExecuteInSecondaryConstructorGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("boxImplDoesNotExecuteInitBlock.kt")
        public void testBoxImplDoesNotExecuteInitBlock() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/boxImplDoesNotExecuteInitBlock.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("boxImplDoesNotExecuteInitBlockGeneric.kt")
        public void testBoxImplDoesNotExecuteInitBlockGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/boxImplDoesNotExecuteInitBlockGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("boxNullableForFakeOverride.kt")
        public void testBoxNullableForFakeOverride() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/boxNullableForFakeOverride.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("boxNullableForFakeOverrideGeneric.kt")
        public void testBoxNullableForFakeOverrideGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/boxNullableForFakeOverrideGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("boxNullableForFakeOverrideGeneric2.kt")
        public void testBoxNullableForFakeOverrideGeneric2() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/boxNullableForFakeOverrideGeneric2.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("boxNullableValueOfInlineClassWithNonNullUnderlyingType.kt")
        public void testBoxNullableValueOfInlineClassWithNonNullUnderlyingType() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/boxNullableValueOfInlineClassWithNonNullUnderlyingType.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("boxNullableValueOfInlineClassWithNonNullUnderlyingTypeGeneric.kt")
        public void testBoxNullableValueOfInlineClassWithNonNullUnderlyingTypeGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/boxNullableValueOfInlineClassWithNonNullUnderlyingTypeGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("boxNullableValueOfInlineClassWithNonNullUnderlyingTypeGeneric2.kt")
        public void testBoxNullableValueOfInlineClassWithNonNullUnderlyingTypeGeneric2() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/boxNullableValueOfInlineClassWithNonNullUnderlyingTypeGeneric2.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("boxNullableValueOfInlineClassWithPrimitiveUnderlyingType.kt")
        public void testBoxNullableValueOfInlineClassWithPrimitiveUnderlyingType() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/boxNullableValueOfInlineClassWithPrimitiveUnderlyingType.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("boxNullableValueOfInlineClassWithPrimitiveUnderlyingTypeGeneric.kt")
        public void testBoxNullableValueOfInlineClassWithPrimitiveUnderlyingTypeGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/boxNullableValueOfInlineClassWithPrimitiveUnderlyingTypeGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("boxNullableValueOfInlineClassWithPrimitiveUnderlyingTypeGeneric2.kt")
        public void testBoxNullableValueOfInlineClassWithPrimitiveUnderlyingTypeGeneric2() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/boxNullableValueOfInlineClassWithPrimitiveUnderlyingTypeGeneric2.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("boxResultInlineClassOfConstructorCall.kt")
        public void testBoxResultInlineClassOfConstructorCall() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/boxResultInlineClassOfConstructorCall.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("boxResultInlineClassOfConstructorCallGeneric.kt")
        public void testBoxResultInlineClassOfConstructorCallGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/boxResultInlineClassOfConstructorCallGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("boxResultInlineClassOfConstructorCallGeneric2.kt")
        public void testBoxResultInlineClassOfConstructorCallGeneric2() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/boxResultInlineClassOfConstructorCallGeneric2.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("boxUnboxInlineClassesWithOperatorsGetSet.kt")
        public void testBoxUnboxInlineClassesWithOperatorsGetSet() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/boxUnboxInlineClassesWithOperatorsGetSet.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("boxUnboxInlineClassesWithOperatorsGetSetGeneric.kt")
        public void testBoxUnboxInlineClassesWithOperatorsGetSetGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/boxUnboxInlineClassesWithOperatorsGetSetGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("boxUnboxOfInlineClassForCapturedVars.kt")
        public void testBoxUnboxOfInlineClassForCapturedVars() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/boxUnboxOfInlineClassForCapturedVars.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("boxUnboxOfInlineClassForCapturedVarsGeneric.kt")
        public void testBoxUnboxOfInlineClassForCapturedVarsGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/boxUnboxOfInlineClassForCapturedVarsGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("bridgeForFunctionReturningInlineClass.kt")
        public void testBridgeForFunctionReturningInlineClass() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/bridgeForFunctionReturningInlineClass.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("bridgeForFunctionReturningInlineClassGeneric.kt")
        public void testBridgeForFunctionReturningInlineClassGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/bridgeForFunctionReturningInlineClassGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("bridgeGenerationWithInlineClassOverAny.kt")
        public void testBridgeGenerationWithInlineClassOverAny() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/bridgeGenerationWithInlineClassOverAny.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("bridgeGenerationWithInlineClassOverAnyGeneric.kt")
        public void testBridgeGenerationWithInlineClassOverAnyGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/bridgeGenerationWithInlineClassOverAnyGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("bridgeGenerationWithInlineClassOverAnyGeneric2.kt")
        public void testBridgeGenerationWithInlineClassOverAnyGeneric2() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/bridgeGenerationWithInlineClassOverAnyGeneric2.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("bridgesWhenInlineClassImplementsGenericInterface.kt")
        public void testBridgesWhenInlineClassImplementsGenericInterface() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/bridgesWhenInlineClassImplementsGenericInterface.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("bridgesWhenInlineClassImplementsGenericInterfaceGeneric.kt")
        public void testBridgesWhenInlineClassImplementsGenericInterfaceGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/bridgesWhenInlineClassImplementsGenericInterfaceGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("callComputablePropertyInsideInlineClass.kt")
        public void testCallComputablePropertyInsideInlineClass() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/callComputablePropertyInsideInlineClass.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("callSpecializedEqualsViaReflection.kt")
        public void testCallSpecializedEqualsViaReflection() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/callSpecializedEqualsViaReflection.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("callSpecializedEqualsViaReflectionGeneric.kt")
        public void testCallSpecializedEqualsViaReflectionGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/callSpecializedEqualsViaReflectionGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("callSpeciallyOverriddenPropertyOfInlineClass.kt")
        public void testCallSpeciallyOverriddenPropertyOfInlineClass() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/callSpeciallyOverriddenPropertyOfInlineClass.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("callSpeciallyOverriddenPropertyOfInlineClassGeneric.kt")
        public void testCallSpeciallyOverriddenPropertyOfInlineClassGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/callSpeciallyOverriddenPropertyOfInlineClassGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("callableReferencesWithInlineClasses.kt")
        public void testCallableReferencesWithInlineClasses() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/callableReferencesWithInlineClasses.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("callableReferencesWithInlineClassesGeneric.kt")
        public void testCallableReferencesWithInlineClassesGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/callableReferencesWithInlineClassesGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("castInsideWhenExpression.kt")
        public void testCastInsideWhenExpression() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/castInsideWhenExpression.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("castInsideWhenExpressionGeneric.kt")
        public void testCastInsideWhenExpressionGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/castInsideWhenExpressionGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("checkBoxUnboxOfArgumentsOnInlinedFunctions.kt")
        public void testCheckBoxUnboxOfArgumentsOnInlinedFunctions() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/checkBoxUnboxOfArgumentsOnInlinedFunctions.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("checkBoxUnboxOfArgumentsOnInlinedFunctionsGeneric.kt")
        public void testCheckBoxUnboxOfArgumentsOnInlinedFunctionsGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/checkBoxUnboxOfArgumentsOnInlinedFunctionsGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("checkBoxingAfterAssertionOperator.kt")
        public void testCheckBoxingAfterAssertionOperator() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/checkBoxingAfterAssertionOperator.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("checkBoxingAfterAssertionOperatorGeneric.kt")
        public void testCheckBoxingAfterAssertionOperatorGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/checkBoxingAfterAssertionOperatorGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("checkBoxingForComplexClassHierarchy.kt")
        public void testCheckBoxingForComplexClassHierarchy() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/checkBoxingForComplexClassHierarchy.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("checkBoxingForComplexClassHierarchyGeneric.kt")
        public void testCheckBoxingForComplexClassHierarchyGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/checkBoxingForComplexClassHierarchyGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("checkBoxingForNonLocalAndLabeledReturns.kt")
        public void testCheckBoxingForNonLocalAndLabeledReturns() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/checkBoxingForNonLocalAndLabeledReturns.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("checkBoxingForNonLocalAndLabeledReturnsGeneric.kt")
        public void testCheckBoxingForNonLocalAndLabeledReturnsGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/checkBoxingForNonLocalAndLabeledReturnsGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("checkBoxingFromReturnTypeForInlineClasses.kt")
        public void testCheckBoxingFromReturnTypeForInlineClasses() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/checkBoxingFromReturnTypeForInlineClasses.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("checkBoxingFromReturnTypeForInlineClassesGeneric.kt")
        public void testCheckBoxingFromReturnTypeForInlineClassesGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/checkBoxingFromReturnTypeForInlineClassesGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("checkBoxingOnFunctionCalls.kt")
        public void testCheckBoxingOnFunctionCalls() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/checkBoxingOnFunctionCalls.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("checkBoxingOnFunctionCallsGeneric.kt")
        public void testCheckBoxingOnFunctionCallsGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/checkBoxingOnFunctionCallsGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("checkBoxingOnLocalVariableAssignments.kt")
        public void testCheckBoxingOnLocalVariableAssignments() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/checkBoxingOnLocalVariableAssignments.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("checkBoxingOnLocalVariableAssignmentsGeneric.kt")
        public void testCheckBoxingOnLocalVariableAssignmentsGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/checkBoxingOnLocalVariableAssignmentsGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("checkBoxingUnboxingForInheritedTypeSpecializedFunctions.kt")
        public void testCheckBoxingUnboxingForInheritedTypeSpecializedFunctions() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/checkBoxingUnboxingForInheritedTypeSpecializedFunctions.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("checkBoxingUnboxingForInheritedTypeSpecializedFunctionsGeneric.kt")
        public void testCheckBoxingUnboxingForInheritedTypeSpecializedFunctionsGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/checkBoxingUnboxingForInheritedTypeSpecializedFunctionsGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("checkCallingMembersInsideInlineClass.kt")
        public void testCheckCallingMembersInsideInlineClass() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/checkCallingMembersInsideInlineClass.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("checkCallingMembersInsideInlineClassGeneric.kt")
        public void testCheckCallingMembersInsideInlineClassGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/checkCallingMembersInsideInlineClassGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("checkCastToInlineClass.kt")
        public void testCheckCastToInlineClass() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/checkCastToInlineClass.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("checkCastToInlineClassGeneric.kt")
        public void testCheckCastToInlineClassGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/checkCastToInlineClassGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("checkForInstanceOfInlineClass.kt")
        public void testCheckForInstanceOfInlineClass() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/checkForInstanceOfInlineClass.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("checkForInstanceOfInlineClassGeneric.kt")
        public void testCheckForInstanceOfInlineClassGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/checkForInstanceOfInlineClassGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("checkLambdaWithInlineClassesInFunctionalType.kt")
        public void testCheckLambdaWithInlineClassesInFunctionalType() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/checkLambdaWithInlineClassesInFunctionalType.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("checkLambdaWithInlineClassesInFunctionalTypeGeneric.kt")
        public void testCheckLambdaWithInlineClassesInFunctionalTypeGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/checkLambdaWithInlineClassesInFunctionalTypeGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("checkUnboxingResultFromTypeVariable.kt")
        public void testCheckUnboxingResultFromTypeVariable() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/checkUnboxingResultFromTypeVariable.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("checkUnboxingResultFromTypeVariableGeneric.kt")
        public void testCheckUnboxingResultFromTypeVariableGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/checkUnboxingResultFromTypeVariableGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("checkUnboxingResultFromTypeVariableGeneric2.kt")
        public void testCheckUnboxingResultFromTypeVariableGeneric2() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/checkUnboxingResultFromTypeVariableGeneric2.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("classInInlineClassInit.kt")
        public void testClassInInlineClassInit() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/classInInlineClassInit.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("classInInlineClassInitGeneric.kt")
        public void testClassInInlineClassInitGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/classInInlineClassInitGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("classLiteralOnInlineClass.kt")
        public void testClassLiteralOnInlineClass() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/classLiteralOnInlineClass.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("classLiteralOnInlineClassGeneric.kt")
        public void testClassLiteralOnInlineClassGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/classLiteralOnInlineClassGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("computablePropertyInsideInlineClass.kt")
        public void testComputablePropertyInsideInlineClass() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/computablePropertyInsideInlineClass.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("conformToComparableAndCallInterfaceMethod.kt")
        public void testConformToComparableAndCallInterfaceMethod() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/conformToComparableAndCallInterfaceMethod.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("conformToComparableAndCallInterfaceMethodGeneric.kt")
        public void testConformToComparableAndCallInterfaceMethodGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/conformToComparableAndCallInterfaceMethodGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("constructorCallableReference.kt")
        public void testConstructorCallableReference() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/constructorCallableReference.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("constructorCallableReferenceGeneric.kt")
        public void testConstructorCallableReferenceGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/constructorCallableReferenceGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("constructorImplVisibility.kt")
        public void testConstructorImplVisibility() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/constructorImplVisibility.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("constructorImplVisibilityGeneric.kt")
        public void testConstructorImplVisibilityGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/constructorImplVisibilityGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("correctBoxingForBranchExpressions.kt")
        public void testCorrectBoxingForBranchExpressions() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/correctBoxingForBranchExpressions.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("correctBoxingForBranchExpressionsGeneric.kt")
        public void testCorrectBoxingForBranchExpressionsGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/correctBoxingForBranchExpressionsGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("createInlineClassInArgumentPosition.kt")
        public void testCreateInlineClassInArgumentPosition() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/createInlineClassInArgumentPosition.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("createInlineClassInArgumentPositionGeneric.kt")
        public void testCreateInlineClassInArgumentPositionGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/createInlineClassInArgumentPositionGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("crossinlineWithInlineClassInParameter.kt")
        public void testCrossinlineWithInlineClassInParameter() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/crossinlineWithInlineClassInParameter.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("crossinlineWithInlineClassInParameterGeneric.kt")
        public void testCrossinlineWithInlineClassInParameterGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/crossinlineWithInlineClassInParameterGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("crossinlineWithInlineClassInParameterGeneric2.kt")
        public void testCrossinlineWithInlineClassInParameterGeneric2() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/crossinlineWithInlineClassInParameterGeneric2.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("customIterator.kt")
        public void testCustomIterator() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/customIterator.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("defaultFunctionsFromAnyForInlineClass.kt")
        public void testDefaultFunctionsFromAnyForInlineClass() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/defaultFunctionsFromAnyForInlineClass.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("defaultFunctionsFromAnyForInlineClassGeneric.kt")
        public void testDefaultFunctionsFromAnyForInlineClassGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/defaultFunctionsFromAnyForInlineClassGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("defaultInterfaceMethodsInInlineClass.kt")
        public void testDefaultInterfaceMethodsInInlineClass() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/defaultInterfaceMethodsInInlineClass.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("defaultInterfaceMethodsInInlineClassGeneric.kt")
        public void testDefaultInterfaceMethodsInInlineClassGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/defaultInterfaceMethodsInInlineClassGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("defaultWithInlineClassArgument.kt")
        public void testDefaultWithInlineClassArgument() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/defaultWithInlineClassArgument.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("defaultWithInlineClassArgumentGeneric.kt")
        public void testDefaultWithInlineClassArgumentGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/defaultWithInlineClassArgumentGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("elvisWithInlineClassAndNullConstant.kt")
        public void testElvisWithInlineClassAndNullConstant() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/elvisWithInlineClassAndNullConstant.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("elvisWithInlineClassAndNullConstantGeneric.kt")
        public void testElvisWithInlineClassAndNullConstantGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/elvisWithInlineClassAndNullConstantGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("emptyConstructorForInlineClass.kt")
        public void testEmptyConstructorForInlineClass() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/emptyConstructorForInlineClass.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("emptyConstructorForInlineClassGeneric.kt")
        public void testEmptyConstructorForInlineClassGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/emptyConstructorForInlineClassGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("equalityChecksInlineClassNonNull.kt")
        public void testEqualityChecksInlineClassNonNull() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalityChecksInlineClassNonNull.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("equalityChecksInlineClassNonNullGeneric.kt")
        public void testEqualityChecksInlineClassNonNullGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalityChecksInlineClassNonNullGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("equalityChecksMixedNullability.kt")
        public void testEqualityChecksMixedNullability() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalityChecksMixedNullability.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("equalityChecksMixedNullabilityGeneric.kt")
        public void testEqualityChecksMixedNullabilityGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalityChecksMixedNullabilityGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("equalityChecksNegatedInlineClassNonNull.kt")
        public void testEqualityChecksNegatedInlineClassNonNull() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalityChecksNegatedInlineClassNonNull.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("equalityChecksNegatedInlineClassNonNullGeneric.kt")
        public void testEqualityChecksNegatedInlineClassNonNullGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalityChecksNegatedInlineClassNonNullGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("equalityChecksNegatedNonNull.kt")
        public void testEqualityChecksNegatedNonNull() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalityChecksNegatedNonNull.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("equalityChecksNegatedNonNullGeneric.kt")
        public void testEqualityChecksNegatedNonNullGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalityChecksNegatedNonNullGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("equalityChecksNegatedNullable.kt")
        public void testEqualityChecksNegatedNullable() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalityChecksNegatedNullable.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("equalityChecksNegatedNullableGeneric.kt")
        public void testEqualityChecksNegatedNullableGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalityChecksNegatedNullableGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("equalityChecksNegatedNullableGeneric2.kt")
        public void testEqualityChecksNegatedNullableGeneric2() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalityChecksNegatedNullableGeneric2.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("equalityChecksNegatedPrimitive.kt")
        public void testEqualityChecksNegatedPrimitive() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalityChecksNegatedPrimitive.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("equalityChecksNegatedPrimitiveGeneric.kt")
        public void testEqualityChecksNegatedPrimitiveGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalityChecksNegatedPrimitiveGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("equalityChecksNonNull.kt")
        public void testEqualityChecksNonNull() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalityChecksNonNull.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("equalityChecksNonNullGeneric.kt")
        public void testEqualityChecksNonNullGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalityChecksNonNullGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("equalityChecksNullable.kt")
        public void testEqualityChecksNullable() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalityChecksNullable.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("equalityChecksNullableGeneric.kt")
        public void testEqualityChecksNullableGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalityChecksNullableGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("equalityChecksNullableGeneric2.kt")
        public void testEqualityChecksNullableGeneric2() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalityChecksNullableGeneric2.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("equalityChecksPrimitive.kt")
        public void testEqualityChecksPrimitive() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalityChecksPrimitive.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("equalityChecksPrimitiveGeneric.kt")
        public void testEqualityChecksPrimitiveGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalityChecksPrimitiveGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("equalityForBoxesOfNullableValuesOfInlineClass.kt")
        public void testEqualityForBoxesOfNullableValuesOfInlineClass() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalityForBoxesOfNullableValuesOfInlineClass.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("equalityForBoxesOfNullableValuesOfInlineClassGeneric.kt")
        public void testEqualityForBoxesOfNullableValuesOfInlineClassGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalityForBoxesOfNullableValuesOfInlineClassGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("equalsCallsLeftArgument.kt")
        public void testEqualsCallsLeftArgument() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalsCallsLeftArgument.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("equalsCallsLeftArgumentGeneric.kt")
        public void testEqualsCallsLeftArgumentGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalsCallsLeftArgumentGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("equalsEvaluationOrderInlineClass.kt")
        public void testEqualsEvaluationOrderInlineClass() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalsEvaluationOrderInlineClass.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("equalsEvaluationOrderInlineClassGeneric.kt")
        public void testEqualsEvaluationOrderInlineClassGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalsEvaluationOrderInlineClassGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("equalsEvaluationOrderNonNull.kt")
        public void testEqualsEvaluationOrderNonNull() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalsEvaluationOrderNonNull.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("equalsEvaluationOrderNonNullGeneric.kt")
        public void testEqualsEvaluationOrderNonNullGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalsEvaluationOrderNonNullGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("equalsEvaluationOrderNullable.kt")
        public void testEqualsEvaluationOrderNullable() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalsEvaluationOrderNullable.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("equalsEvaluationOrderNullableGeneric.kt")
        public void testEqualsEvaluationOrderNullableGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalsEvaluationOrderNullableGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("equalsEvaluationOrderNullableGeneric2.kt")
        public void testEqualsEvaluationOrderNullableGeneric2() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalsEvaluationOrderNullableGeneric2.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("equalsEvaluationOrderPrimitive.kt")
        public void testEqualsEvaluationOrderPrimitive() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalsEvaluationOrderPrimitive.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("equalsEvaluationOrderPrimitiveGeneric.kt")
        public void testEqualsEvaluationOrderPrimitiveGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalsEvaluationOrderPrimitiveGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("equalsOperatorWithGenericCall.kt")
        public void testEqualsOperatorWithGenericCall() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalsOperatorWithGenericCall.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("equalsOperatorWithGenericCallGeneric.kt")
        public void testEqualsOperatorWithGenericCallGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/equalsOperatorWithGenericCallGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("extLambdaInInlineClassFun.kt")
        public void testExtLambdaInInlineClassFun() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/extLambdaInInlineClassFun.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("extLambdaInInlineClassFun2.kt")
        public void testExtLambdaInInlineClassFun2() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/extLambdaInInlineClassFun2.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("extLambdaInInlineClassFun2Generic.kt")
        public void testExtLambdaInInlineClassFun2Generic() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/extLambdaInInlineClassFun2Generic.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("extLambdaInInlineClassFunGeneric.kt")
        public void testExtLambdaInInlineClassFunGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/extLambdaInInlineClassFunGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("fieldNameClash.kt")
        public void testFieldNameClash() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/fieldNameClash.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("fieldNameClashGeneric.kt")
        public void testFieldNameClashGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/fieldNameClashGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("funInterfaceDoubleSuffux.kt")
        public void testFunInterfaceDoubleSuffux() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/funInterfaceDoubleSuffux.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("funInterfaceDoubleSuffux2.kt")
        public void testFunInterfaceDoubleSuffux2() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/funInterfaceDoubleSuffux2.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("functionExpression.kt")
        public void testFunctionExpression() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/functionExpression.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("functionExpressionGeneric.kt")
        public void testFunctionExpressionGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/functionExpressionGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("genericInlineClassSynthMembers.kt")
        public void testGenericInlineClassSynthMembers() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/genericInlineClassSynthMembers.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("genericVararg2ndConstructor.kt")
        public void testGenericVararg2ndConstructor() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/genericVararg2ndConstructor.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("initBlock.kt")
        public void testInitBlock() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/initBlock.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("initBlockGeneric.kt")
        public void testInitBlockGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/initBlockGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("inlineClassAsLastExpressionInInLambda.kt")
        public void testInlineClassAsLastExpressionInInLambda() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassAsLastExpressionInInLambda.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("inlineClassAsLastExpressionInInLambdaGeneric.kt")
        public void testInlineClassAsLastExpressionInInLambdaGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassAsLastExpressionInInLambdaGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("inlineClassEqualityShouldUseTotalOrderForFloatingPointData.kt")
        public void testInlineClassEqualityShouldUseTotalOrderForFloatingPointData() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassEqualityShouldUseTotalOrderForFloatingPointData.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("inlineClassEqualityShouldUseTotalOrderForFloatingPointDataGeneric.kt")
        public void testInlineClassEqualityShouldUseTotalOrderForFloatingPointDataGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassEqualityShouldUseTotalOrderForFloatingPointDataGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("inlineClassFieldHandling.kt")
        public void testInlineClassFieldHandling() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassFieldHandling.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("inlineClassFieldHandlingGeneric.kt")
        public void testInlineClassFieldHandlingGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassFieldHandlingGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("inlineClassFunctionInvoke.kt")
        public void testInlineClassFunctionInvoke() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassFunctionInvoke.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("inlineClassFunctionInvokeGeneric.kt")
        public void testInlineClassFunctionInvokeGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassFunctionInvokeGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("inlineClassImplementsCollection.kt")
        public void testInlineClassImplementsCollection() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassImplementsCollection.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("inlineClassImplementsCollectionGeneric.kt")
        public void testInlineClassImplementsCollectionGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassImplementsCollectionGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("inlineClassInInitBlock.kt")
        public void testInlineClassInInitBlock() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassInInitBlock.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("inlineClassInInitBlockGeneric.kt")
        public void testInlineClassInInitBlockGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassInInitBlockGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("inlineClassInStringTemplate.kt")
        public void testInlineClassInStringTemplate() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassInStringTemplate.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("inlineClassInStringTemplateGeneric.kt")
        public void testInlineClassInStringTemplateGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassInStringTemplateGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("inlineClassPropertyReferenceGetAndSet.kt")
        public void testInlineClassPropertyReferenceGetAndSet() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassPropertyReferenceGetAndSet.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("inlineClassPropertyReferenceGetAndSetGeneric.kt")
        public void testInlineClassPropertyReferenceGetAndSetGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassPropertyReferenceGetAndSetGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("inlineClassValueCapturedInInlineLambda.kt")
        public void testInlineClassValueCapturedInInlineLambda() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassValueCapturedInInlineLambda.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("inlineClassValueCapturedInInlineLambdaGeneric.kt")
        public void testInlineClassValueCapturedInInlineLambdaGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassValueCapturedInInlineLambdaGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("inlineClassValueCapturedInNonInlineLambda.kt")
        public void testInlineClassValueCapturedInNonInlineLambda() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassValueCapturedInNonInlineLambda.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("inlineClassValueCapturedInNonInlineLambdaGeneric.kt")
        public void testInlineClassValueCapturedInNonInlineLambdaGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassValueCapturedInNonInlineLambdaGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("inlineClassValuesInsideStrings.kt")
        public void testInlineClassValuesInsideStrings() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassValuesInsideStrings.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("inlineClassValuesInsideStringsGeneric.kt")
        public void testInlineClassValuesInsideStringsGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassValuesInsideStringsGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("inlineClassWithCustomEquals.kt")
        public void testInlineClassWithCustomEquals() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassWithCustomEquals.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("inlineClassWithCustomEqualsGeneric.kt")
        public void testInlineClassWithCustomEqualsGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassWithCustomEqualsGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("inlineClassWithDefaultFunctionsFromAny.kt")
        public void testInlineClassWithDefaultFunctionsFromAny() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassWithDefaultFunctionsFromAny.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("inlineClassWithDefaultFunctionsFromAnyGeneric.kt")
        public void testInlineClassWithDefaultFunctionsFromAnyGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassWithDefaultFunctionsFromAnyGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("inlineClassesAsInlineFunParameters.kt")
        public void testInlineClassesAsInlineFunParameters() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassesAsInlineFunParameters.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("inlineClassesAsInlineFunParametersGeneric.kt")
        public void testInlineClassesAsInlineFunParametersGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassesAsInlineFunParametersGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("inlineClassesCheckCast.kt")
        public void testInlineClassesCheckCast() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassesCheckCast.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("inlineClassesCheckCastGeneric.kt")
        public void testInlineClassesCheckCastGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassesCheckCastGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("inlineClassesInInlineLambdaParameters.kt")
        public void testInlineClassesInInlineLambdaParameters() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassesInInlineLambdaParameters.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("inlineClassesInInlineLambdaParametersGeneric.kt")
        public void testInlineClassesInInlineLambdaParametersGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassesInInlineLambdaParametersGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("inlineClassesRefTypesInInlineLambdaParameters.kt")
        public void testInlineClassesRefTypesInInlineLambdaParameters() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassesRefTypesInInlineLambdaParameters.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("inlineClassesRefTypesInInlineLambdaParametersGeneric.kt")
        public void testInlineClassesRefTypesInInlineLambdaParametersGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineClassesRefTypesInInlineLambdaParametersGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("inlineExtLambdaInInlineClassFun.kt")
        public void testInlineExtLambdaInInlineClassFun() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineExtLambdaInInlineClassFun.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("inlineExtLambdaInInlineClassFun2.kt")
        public void testInlineExtLambdaInInlineClassFun2() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineExtLambdaInInlineClassFun2.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("inlineExtLambdaInInlineClassFun2Generic.kt")
        public void testInlineExtLambdaInInlineClassFun2Generic() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineExtLambdaInInlineClassFun2Generic.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("inlineExtLambdaInInlineClassFunGeneric.kt")
        public void testInlineExtLambdaInInlineClassFunGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineExtLambdaInInlineClassFunGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("inlineFunctionInsideInlineClass.kt")
        public void testInlineFunctionInsideInlineClass() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineFunctionInsideInlineClass.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("inlineFunctionInsideInlineClassGeneric.kt")
        public void testInlineFunctionInsideInlineClassGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineFunctionInsideInlineClassGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("inlineInCompanion.kt")
        public void testInlineInCompanion() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineInCompanion.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("inlineInCompanionGeneric.kt")
        public void testInlineInCompanionGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineInCompanionGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("inlineToString.kt")
        public void testInlineToString() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/inlineToString.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("iterateOverArrayOfInlineClassValues.kt")
        public void testIterateOverArrayOfInlineClassValues() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/iterateOverArrayOfInlineClassValues.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("iterateOverArrayOfInlineClassValuesGeneric.kt")
        public void testIterateOverArrayOfInlineClassValuesGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/iterateOverArrayOfInlineClassValuesGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("iterateOverListOfInlineClassValues.kt")
        public void testIterateOverListOfInlineClassValues() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/iterateOverListOfInlineClassValues.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("iterateOverListOfInlineClassValuesGeneric.kt")
        public void testIterateOverListOfInlineClassValuesGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/iterateOverListOfInlineClassValuesGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("javaClassIntrinsicOnInlineClasses.kt")
        public void testJavaClassIntrinsicOnInlineClasses() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/javaClassIntrinsicOnInlineClasses.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("javaClassIntrinsicOnInlineClassesGeneric.kt")
        public void testJavaClassIntrinsicOnInlineClassesGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/javaClassIntrinsicOnInlineClassesGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("javaPrimitiveTypeIC.kt")
        public void testJavaPrimitiveTypeIC() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/javaPrimitiveTypeIC.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("javaPrimitiveTypeICGeneric.kt")
        public void testJavaPrimitiveTypeICGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/javaPrimitiveTypeICGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("jvmFieldInInlineClassCompanion.kt")
        public void testJvmFieldInInlineClassCompanion() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/jvmFieldInInlineClassCompanion.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("jvmFieldInInlineClassCompanionGeneric.kt")
        public void testJvmFieldInInlineClassCompanionGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/jvmFieldInInlineClassCompanionGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("jvmInline.kt")
        public void testJvmInline() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/jvmInline.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("jvmOverloadsOnTopLevelFunctionReturningInlineClassValue.kt")
        public void testJvmOverloadsOnTopLevelFunctionReturningInlineClassValue() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/jvmOverloadsOnTopLevelFunctionReturningInlineClassValue.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("jvmOverloadsOnTopLevelFunctionReturningInlineClassValueGeneric.kt")
        public void testJvmOverloadsOnTopLevelFunctionReturningInlineClassValueGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/jvmOverloadsOnTopLevelFunctionReturningInlineClassValueGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("jvmStaticFunInInlineClassCompanion.kt")
        public void testJvmStaticFunInInlineClassCompanion() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/jvmStaticFunInInlineClassCompanion.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("jvmStaticFunInInlineClassCompanionGeneric.kt")
        public void testJvmStaticFunInInlineClassCompanionGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/jvmStaticFunInInlineClassCompanionGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("jvmStaticPropertyAccessorInInlineClassCompanion.kt")
        public void testJvmStaticPropertyAccessorInInlineClassCompanion() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/jvmStaticPropertyAccessorInInlineClassCompanion.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("jvmStaticPropertyAccessorInInlineClassCompanionGeneric.kt")
        public void testJvmStaticPropertyAccessorInInlineClassCompanionGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/jvmStaticPropertyAccessorInInlineClassCompanionGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("jvmStaticVarInInlineClassCompanion.kt")
        public void testJvmStaticVarInInlineClassCompanion() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/jvmStaticVarInInlineClassCompanion.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("jvmStaticVarInInlineClassCompanionGeneric.kt")
        public void testJvmStaticVarInInlineClassCompanionGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/jvmStaticVarInInlineClassCompanionGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("kclassInAnnotation.kt")
        public void testKclassInAnnotation() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kclassInAnnotation.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("kclassInAnnotationGeneric.kt")
        public void testKclassInAnnotationGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kclassInAnnotationGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("kt25246.kt")
        public void testKt25246() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt25246.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("kt25750.kt")
        public void testKt25750() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt25750.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("kt25750Generic.kt")
        public void testKt25750Generic() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt25750Generic.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("kt25771.kt")
        public void testKt25771() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt25771.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("kt26103.kt")
        public void testKt26103() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt26103.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("kt26103_contravariantUnderlyingType.kt")
        public void testKt26103_contravariantUnderlyingType() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt26103_contravariantUnderlyingType.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("kt26103_covariantUnderlyingType.kt")
        public void testKt26103_covariantUnderlyingType() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt26103_covariantUnderlyingType.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("kt26103_original.kt")
        public void testKt26103_original() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt26103_original.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("kt27096.kt")
        public void testKt27096() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt27096.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("kt27096Generic.kt")
        public void testKt27096Generic() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt27096Generic.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("kt27096_enum.kt")
        public void testKt27096_enum() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt27096_enum.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("kt27096_enumGeneric.kt")
        public void testKt27096_enumGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt27096_enumGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("kt27096_functional.kt")
        public void testKt27096_functional() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt27096_functional.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("kt27096_functionalGeneric.kt")
        public void testKt27096_functionalGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt27096_functionalGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("kt27096_innerClass.kt")
        public void testKt27096_innerClass() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt27096_innerClass.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("kt27096_nullablePrimitive.kt")
        public void testKt27096_nullablePrimitive() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt27096_nullablePrimitive.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("kt27096_nullablePrimitiveGeneric.kt")
        public void testKt27096_nullablePrimitiveGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt27096_nullablePrimitiveGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("kt27096_nullablePrimitiveGeneric2.kt")
        public void testKt27096_nullablePrimitiveGeneric2() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt27096_nullablePrimitiveGeneric2.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("kt27096_nullableReference.kt")
        public void testKt27096_nullableReference() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt27096_nullableReference.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("kt27096_nullableReferenceGeneric.kt")
        public void testKt27096_nullableReferenceGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt27096_nullableReferenceGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("kt27096_nullableReferenceGeneric2.kt")
        public void testKt27096_nullableReferenceGeneric2() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt27096_nullableReferenceGeneric2.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("kt27096_primitive.kt")
        public void testKt27096_primitive() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt27096_primitive.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("kt27096_primitiveGeneric.kt")
        public void testKt27096_primitiveGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt27096_primitiveGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("kt27096_reference.kt")
        public void testKt27096_reference() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt27096_reference.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("kt27096_referenceGeneric.kt")
        public void testKt27096_referenceGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt27096_referenceGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("kt27113.kt")
        public void testKt27113() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt27113.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("kt27113a.kt")
        public void testKt27113a() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt27113a.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("kt27113aGeneric.kt")
        public void testKt27113aGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt27113aGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("kt27132.kt")
        public void testKt27132() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt27132.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("kt27132Generic.kt")
        public void testKt27132Generic() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt27132Generic.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("kt27140.kt")
        public void testKt27140() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt27140.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("kt27140Generic.kt")
        public void testKt27140Generic() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt27140Generic.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("kt27705.kt")
        public void testKt27705() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt27705.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("kt27705Generic.kt")
        public void testKt27705Generic() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt27705Generic.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("kt27706.kt")
        public void testKt27706() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt27706.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("kt27706Generic.kt")
        public void testKt27706Generic() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt27706Generic.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("kt28405.kt")
        public void testKt28405() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt28405.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("kt28585.kt")
        public void testKt28585() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt28585.kt");
        }

        @Test
        @TestMetadata("kt28879.kt")
        public void testKt28879() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt28879.kt");
        }

        @Test
        @TestMetadata("kt28920_javaObjectType.kt")
        public void testKt28920_javaObjectType() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt28920_javaObjectType.kt");
        }

        @Test
        @TestMetadata("kt28920_javaPrimitiveType.kt")
        public void testKt28920_javaPrimitiveType() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt28920_javaPrimitiveType.kt");
        }

        @Test
        @TestMetadata("kt31994.kt")
        public void testKt31994() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt31994.kt");
        }

        @Test
        @TestMetadata("kt32793.kt")
        public void testKt32793() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt32793.kt");
        }

        @Test
        @TestMetadata("kt33119.kt")
        public void testKt33119() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt33119.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("kt33119Generic.kt")
        public void testKt33119Generic() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt33119Generic.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("kt34268.kt")
        public void testKt34268() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt34268.kt");
        }

        @Test
        @TestMetadata("kt34902.kt")
        public void testKt34902() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt34902.kt");
        }

        @Test
        @TestMetadata("kt37998.kt")
        public void testKt37998() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt37998.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("kt37998Generic.kt")
        public void testKt37998Generic() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt37998Generic.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("kt38680.kt")
        public void testKt38680() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt38680.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("kt38680Generic.kt")
        public void testKt38680Generic() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt38680Generic.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("kt38680a.kt")
        public void testKt38680a() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt38680a.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("kt38680aGeneric.kt")
        public void testKt38680aGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt38680aGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("kt38680b.kt")
        public void testKt38680b() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt38680b.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("kt38680bGeneric.kt")
        public void testKt38680bGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt38680bGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("kt44141.kt")
        public void testKt44141() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt44141.kt");
        }

        @Test
        @TestMetadata("kt44701_jvmOverloads.kt")
        public void testKt44701_jvmOverloads() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt44701_jvmOverloads.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("kt44701_jvmOverloadsGeneric.kt")
        public void testKt44701_jvmOverloadsGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt44701_jvmOverloadsGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("kt44701_jvmOverloadsGeneric2.kt")
        public void testKt44701_jvmOverloadsGeneric2() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt44701_jvmOverloadsGeneric2.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("kt44867.kt")
        public void testKt44867() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt44867.kt");
        }

        @Test
        @TestMetadata("kt44978.kt")
        public void testKt44978() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt44978.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("kt45084.kt")
        public void testKt45084() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt45084.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("kt45084Generic.kt")
        public void testKt45084Generic() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt45084Generic.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("kt45991.kt")
        public void testKt45991() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt45991.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("kt46554.kt")
        public void testKt46554() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt46554.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("kt46554Generic.kt")
        public void testKt46554Generic() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt46554Generic.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("kt47609.kt")
        public void testKt47609() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt47609.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("kt47762.kt")
        public void testKt47762() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt47762.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("kt47762Generic.kt")
        public void testKt47762Generic() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt47762Generic.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("kt48993.kt")
        public void testKt48993() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt48993.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("kt48993Generic.kt")
        public void testKt48993Generic() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt48993Generic.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("kt51157.kt")
        public void testKt51157() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt51157.kt");
        }

        @Test
        @TestMetadata("kt51254.kt")
        public void testKt51254() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt51254.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("kt51353.kt")
        public void testKt51353() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt51353.kt");
        }

        @Test
        @TestMetadata("kt51672.kt")
        public void testKt51672() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/kt51672.kt");
        }

        @Test
        @TestMetadata("mangledDefaultParameterFunction.kt")
        public void testMangledDefaultParameterFunction() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/mangledDefaultParameterFunction.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("mangledDefaultParameterFunctionGeneric.kt")
        public void testMangledDefaultParameterFunctionGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/mangledDefaultParameterFunctionGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("mangledSuperCalls.kt")
        public void testMangledSuperCalls() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/mangledSuperCalls.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("mangledSuperCallsGeneric.kt")
        public void testMangledSuperCallsGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/mangledSuperCallsGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("mapInlineClassesWithSuppressWildcardsMode.kt")
        public void testMapInlineClassesWithSuppressWildcardsMode() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/mapInlineClassesWithSuppressWildcardsMode.kt");
        }

        @Test
        @TestMetadata("mappingOfBoxedFlexibleInlineClassType.kt")
        public void testMappingOfBoxedFlexibleInlineClassType() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/mappingOfBoxedFlexibleInlineClassType.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("mappingOfBoxedFlexibleInlineClassTypeGeneric.kt")
        public void testMappingOfBoxedFlexibleInlineClassTypeGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/mappingOfBoxedFlexibleInlineClassTypeGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("multifileClass.kt")
        public void testMultifileClass() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/multifileClass.kt");
        }

        @Test
        @TestMetadata("nestedInlineClass.kt")
        public void testNestedInlineClass() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/nestedInlineClass.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("nestedInlineClassGeneric.kt")
        public void testNestedInlineClassGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/nestedInlineClassGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("noAssertionsOnInlineClassBasedOnNullableType.kt")
        public void testNoAssertionsOnInlineClassBasedOnNullableType() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/noAssertionsOnInlineClassBasedOnNullableType.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("noAssertionsOnInlineClassBasedOnNullableTypeGeneric.kt")
        public void testNoAssertionsOnInlineClassBasedOnNullableTypeGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/noAssertionsOnInlineClassBasedOnNullableTypeGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("noReturnTypeMangling.kt")
        public void testNoReturnTypeMangling() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/noReturnTypeMangling.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("noReturnTypeManglingGeneric.kt")
        public void testNoReturnTypeManglingGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/noReturnTypeManglingGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("noReturnTypeManglingJvmName.kt")
        public void testNoReturnTypeManglingJvmName() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/noReturnTypeManglingJvmName.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("noReturnTypeManglingJvmNameGeneric.kt")
        public void testNoReturnTypeManglingJvmNameGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/noReturnTypeManglingJvmNameGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("nullableEqeqNonNull.kt")
        public void testNullableEqeqNonNull() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/nullableEqeqNonNull.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("nullableEqeqNonNullGeneric.kt")
        public void testNullableEqeqNonNullGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/nullableEqeqNonNullGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("nullableWrapperEquality.kt")
        public void testNullableWrapperEquality() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/nullableWrapperEquality.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("nullableWrapperEqualityGeneric.kt")
        public void testNullableWrapperEqualityGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/nullableWrapperEqualityGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("nullableWrapperEqualityGeneric2.kt")
        public void testNullableWrapperEqualityGeneric2() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/nullableWrapperEqualityGeneric2.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("overrideReturnNothing.kt")
        public void testOverrideReturnNothing() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/overrideReturnNothing.kt");
        }

        @Test
        @TestMetadata("overridingFunCallingPrivateFun.kt")
        public void testOverridingFunCallingPrivateFun() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/overridingFunCallingPrivateFun.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("overridingFunCallingPrivateFunGeneric.kt")
        public void testOverridingFunCallingPrivateFunGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/overridingFunCallingPrivateFunGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("passInlineClassAsVararg.kt")
        public void testPassInlineClassAsVararg() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/passInlineClassAsVararg.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("passInlineClassAsVarargGeneric.kt")
        public void testPassInlineClassAsVarargGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/passInlineClassAsVarargGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("passInlineClassWithSpreadOperatorToVarargs.kt")
        public void testPassInlineClassWithSpreadOperatorToVarargs() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/passInlineClassWithSpreadOperatorToVarargs.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("passInlineClassWithSpreadOperatorToVarargsGeneric.kt")
        public void testPassInlineClassWithSpreadOperatorToVarargsGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/passInlineClassWithSpreadOperatorToVarargsGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("privateConstructorFunInterfaceMultiModule.kt")
        public void testPrivateConstructorFunInterfaceMultiModule() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/privateConstructorFunInterfaceMultiModule.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("privateConstructorFunInterfaceMultiModuleGeneric.kt")
        public void testPrivateConstructorFunInterfaceMultiModuleGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/privateConstructorFunInterfaceMultiModuleGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("propertyLoweringOrder.kt")
        public void testPropertyLoweringOrder() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/propertyLoweringOrder.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("propertyLoweringOrderGeneric.kt")
        public void testPropertyLoweringOrderGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/propertyLoweringOrderGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("referToPropertyInCompanionObjectOfInlineClass.kt")
        public void testReferToPropertyInCompanionObjectOfInlineClass() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/referToPropertyInCompanionObjectOfInlineClass.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("referToPropertyInCompanionObjectOfInlineClassGeneric.kt")
        public void testReferToPropertyInCompanionObjectOfInlineClassGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/referToPropertyInCompanionObjectOfInlineClassGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("referToUnderlyingPropertyInsideInlineClass.kt")
        public void testReferToUnderlyingPropertyInsideInlineClass() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/referToUnderlyingPropertyInsideInlineClass.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("referToUnderlyingPropertyInsideInlineClassGeneric.kt")
        public void testReferToUnderlyingPropertyInsideInlineClassGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/referToUnderlyingPropertyInsideInlineClassGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("referToUnderlyingPropertyOfInlineClass.kt")
        public void testReferToUnderlyingPropertyOfInlineClass() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/referToUnderlyingPropertyOfInlineClass.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("referToUnderlyingPropertyOfInlineClassGeneric.kt")
        public void testReferToUnderlyingPropertyOfInlineClassGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/referToUnderlyingPropertyOfInlineClassGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("removeInInlineCollectionOfInlineClassAsInt.kt")
        public void testRemoveInInlineCollectionOfInlineClassAsInt() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/removeInInlineCollectionOfInlineClassAsInt.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("result.kt")
        public void testResult() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/result.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("resultGeneric.kt")
        public void testResultGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/resultGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("resultGeneric2.kt")
        public void testResultGeneric2() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/resultGeneric2.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("resultInlining.kt")
        public void testResultInlining() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/resultInlining.kt");
        }

        @Test
        @TestMetadata("resultRunCatchingOrElse.kt")
        public void testResultRunCatchingOrElse() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/resultRunCatchingOrElse.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("safeAsOfTypeParameterWithInlineClassBound.kt")
        public void testSafeAsOfTypeParameterWithInlineClassBound() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/safeAsOfTypeParameterWithInlineClassBound.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("safeAsOfTypeParameterWithInlineClassBoundGeneric.kt")
        public void testSafeAsOfTypeParameterWithInlineClassBoundGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/safeAsOfTypeParameterWithInlineClassBoundGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("samWrapperDifferentModule.kt")
        public void testSamWrapperDifferentModule() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/samWrapperDifferentModule.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("samWrapperDifferentModuleGeneric.kt")
        public void testSamWrapperDifferentModuleGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/samWrapperDifferentModuleGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("secondaryConstructorWithVararg.kt")
        public void testSecondaryConstructorWithVararg() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/secondaryConstructorWithVararg.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("secondaryConstructorWithVarargGeneric.kt")
        public void testSecondaryConstructorWithVarargGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/secondaryConstructorWithVarargGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("secondaryConstructorsInsideInlineClass.kt")
        public void testSecondaryConstructorsInsideInlineClass() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/secondaryConstructorsInsideInlineClass.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("secondaryConstructorsInsideInlineClassGeneric.kt")
        public void testSecondaryConstructorsInsideInlineClassGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/secondaryConstructorsInsideInlineClassGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("secondaryConstructorsInsideInlineClassWithPrimitiveCarrierType.kt")
        public void testSecondaryConstructorsInsideInlineClassWithPrimitiveCarrierType() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/secondaryConstructorsInsideInlineClassWithPrimitiveCarrierType.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("secondaryConstructorsInsideInlineClassWithPrimitiveCarrierTypeGeneric.kt")
        public void testSecondaryConstructorsInsideInlineClassWithPrimitiveCarrierTypeGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/secondaryConstructorsInsideInlineClassWithPrimitiveCarrierTypeGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("simpleSecondaryConstructor.kt")
        public void testSimpleSecondaryConstructor() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/simpleSecondaryConstructor.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("simpleSecondaryConstructorGeneric.kt")
        public void testSimpleSecondaryConstructorGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/simpleSecondaryConstructorGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("smartCastOnThisOfInlineClassType.kt")
        public void testSmartCastOnThisOfInlineClassType() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/smartCastOnThisOfInlineClassType.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("smartCastOnThisOfInlineClassTypeGeneric.kt")
        public void testSmartCastOnThisOfInlineClassTypeGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/smartCastOnThisOfInlineClassTypeGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("stringPlus.kt")
        public void testStringPlus() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/stringPlus.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("stringPlusGeneric.kt")
        public void testStringPlusGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/stringPlusGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("toStringCallingPrivateFun.kt")
        public void testToStringCallingPrivateFun() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/toStringCallingPrivateFun.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("toStringCallingPrivateFunGeneric.kt")
        public void testToStringCallingPrivateFunGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/toStringCallingPrivateFunGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("toStringOfUnboxedNullable.kt")
        public void testToStringOfUnboxedNullable() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/toStringOfUnboxedNullable.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("toStringOfUnboxedNullableGeneric.kt")
        public void testToStringOfUnboxedNullableGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/toStringOfUnboxedNullableGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("typeChecksForInlineClasses.kt")
        public void testTypeChecksForInlineClasses() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/typeChecksForInlineClasses.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("typeChecksForInlineClassesGeneric.kt")
        public void testTypeChecksForInlineClassesGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/typeChecksForInlineClassesGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("UIntArraySortExample.kt")
        public void testUIntArraySortExample() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/UIntArraySortExample.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("UIntArraySortExampleGeneric.kt")
        public void testUIntArraySortExampleGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/UIntArraySortExampleGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("UIntSafeAsInt.kt")
        public void testUIntSafeAsInt() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/UIntSafeAsInt.kt");
        }

        @Test
        @TestMetadata("unboxNullableValueOfInlineClassWithNonNullUnderlyingType.kt")
        public void testUnboxNullableValueOfInlineClassWithNonNullUnderlyingType() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/unboxNullableValueOfInlineClassWithNonNullUnderlyingType.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("unboxNullableValueOfInlineClassWithNonNullUnderlyingTypeGeneric.kt")
        public void testUnboxNullableValueOfInlineClassWithNonNullUnderlyingTypeGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/unboxNullableValueOfInlineClassWithNonNullUnderlyingTypeGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("unboxNullableValueOfInlineClassWithNullableInlineClassUnderlyingTypeGWI.kt")
        public void testUnboxNullableValueOfInlineClassWithNullableInlineClassUnderlyingTypeGWI() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/unboxNullableValueOfInlineClassWithNullableInlineClassUnderlyingTypeGWI.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("unboxNullableValueOfInlineClassWithNullableInlineClassUnderlyingTypeGWI2.kt")
        public void testUnboxNullableValueOfInlineClassWithNullableInlineClassUnderlyingTypeGWI2() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/unboxNullableValueOfInlineClassWithNullableInlineClassUnderlyingTypeGWI2.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("unboxNullableValueOfInlineClassWithNullablePrimitiveUnderlyingType.kt")
        public void testUnboxNullableValueOfInlineClassWithNullablePrimitiveUnderlyingType() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/unboxNullableValueOfInlineClassWithNullablePrimitiveUnderlyingType.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("unboxNullableValueOfInlineClassWithNullablePrimitiveUnderlyingTypeGWI.kt")
        public void testUnboxNullableValueOfInlineClassWithNullablePrimitiveUnderlyingTypeGWI() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/unboxNullableValueOfInlineClassWithNullablePrimitiveUnderlyingTypeGWI.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("unboxNullableValueOfInlineClassWithNullablePrimitiveUnderlyingTypeGWI2.kt")
        public void testUnboxNullableValueOfInlineClassWithNullablePrimitiveUnderlyingTypeGWI2() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/unboxNullableValueOfInlineClassWithNullablePrimitiveUnderlyingTypeGWI2.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("unboxNullableValueOfInlineClassWithNullablePrimitiveUnderlyingTypeGeneric.kt")
        public void testUnboxNullableValueOfInlineClassWithNullablePrimitiveUnderlyingTypeGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/unboxNullableValueOfInlineClassWithNullablePrimitiveUnderlyingTypeGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("unboxNullableValueOfInlineClassWithPrimitiveUnderlyingType.kt")
        public void testUnboxNullableValueOfInlineClassWithPrimitiveUnderlyingType() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/unboxNullableValueOfInlineClassWithPrimitiveUnderlyingType.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("unboxNullableValueOfInlineClassWithPrimitiveUnderlyingTypeGeneric.kt")
        public void testUnboxNullableValueOfInlineClassWithPrimitiveUnderlyingTypeGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/unboxNullableValueOfInlineClassWithPrimitiveUnderlyingTypeGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("unboxParameterOfSuspendLambdaBeforeInvoke.kt")
        public void testUnboxParameterOfSuspendLambdaBeforeInvoke() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/unboxParameterOfSuspendLambdaBeforeInvoke.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("unboxParameterOfSuspendLambdaBeforeInvokeGeneric.kt")
        public void testUnboxParameterOfSuspendLambdaBeforeInvokeGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/unboxParameterOfSuspendLambdaBeforeInvokeGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("unboxReceiverOnCallingMethodFromInlineClass.kt")
        public void testUnboxReceiverOnCallingMethodFromInlineClass() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/unboxReceiverOnCallingMethodFromInlineClass.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("unboxReceiverOnCallingMethodFromInlineClassGeneric.kt")
        public void testUnboxReceiverOnCallingMethodFromInlineClassGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/unboxReceiverOnCallingMethodFromInlineClassGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("unboxResultParameterWhenCapturingToCrossinlineLambda.kt")
        public void testUnboxResultParameterWhenCapturingToCrossinlineLambda() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/unboxResultParameterWhenCapturingToCrossinlineLambda.kt");
        }

        @Test
        @TestMetadata("unboxValueFromPlatformType.kt")
        public void testUnboxValueFromPlatformType() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/unboxValueFromPlatformType.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("unboxValueFromPlatformTypeGeneric.kt")
        public void testUnboxValueFromPlatformTypeGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/unboxValueFromPlatformTypeGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("unboxValueOfAnyBeforeMethodInvocation.kt")
        public void testUnboxValueOfAnyBeforeMethodInvocation() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/unboxValueOfAnyBeforeMethodInvocation.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("unboxValueOfAnyBeforeMethodInvocationGeneric.kt")
        public void testUnboxValueOfAnyBeforeMethodInvocationGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/unboxValueOfAnyBeforeMethodInvocationGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("unboxValueOfAnyBeforeMethodInvocationGeneric2.kt")
        public void testUnboxValueOfAnyBeforeMethodInvocationGeneric2() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/unboxValueOfAnyBeforeMethodInvocationGeneric2.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("useInlineClassesInsideElvisOperator.kt")
        public void testUseInlineClassesInsideElvisOperator() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/useInlineClassesInsideElvisOperator.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("useInlineClassesInsideElvisOperatorGeneric.kt")
        public void testUseInlineClassesInsideElvisOperatorGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/useInlineClassesInsideElvisOperatorGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("useInlineFunctionInsideInlineClass.kt")
        public void testUseInlineFunctionInsideInlineClass() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/useInlineFunctionInsideInlineClass.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("useInlineFunctionInsideInlineClassGeneric.kt")
        public void testUseInlineFunctionInsideInlineClassGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/useInlineFunctionInsideInlineClassGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("useOfInlineClassWithGenericMethodFromJava.kt")
        public void testUseOfInlineClassWithGenericMethodFromJava() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/useOfInlineClassWithGenericMethodFromJava.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("useOfInlineClassWithGenericMethodFromJavaGeneric.kt")
        public void testUseOfInlineClassWithGenericMethodFromJavaGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/useOfInlineClassWithGenericMethodFromJavaGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("useThisInsideInlineClass.kt")
        public void testUseThisInsideInlineClass() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/useThisInsideInlineClass.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("useThisInsideInlineClassGeneric.kt")
        public void testUseThisInsideInlineClassGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/useThisInsideInlineClassGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("whenWithSubject.kt")
        public void testWhenWithSubject() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/whenWithSubject.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Test
        @TestMetadata("whenWithSubjectGeneric.kt")
        public void testWhenWithSubjectGeneric() throws Exception {
            runTest("compiler/testData/codegen/box/inlineClasses/whenWithSubjectGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/box/inlineClasses/boxReturnValueInLambda")
        @TestDataPath("$PROJECT_ROOT")
        public class BoxReturnValueInLambda {
            @Test
            public void testAllFilesPresentInBoxReturnValueInLambda() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/inlineClasses/boxReturnValueInLambda"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("boxAny.kt")
            public void testBoxAny() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueInLambda/boxAny.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @Test
            @TestMetadata("boxAnyGeneric.kt")
            public void testBoxAnyGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueInLambda/boxAnyGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @Test
            @TestMetadata("boxFunLiteralAny.kt")
            public void testBoxFunLiteralAny() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueInLambda/boxFunLiteralAny.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @Test
            @TestMetadata("boxFunLiteralAnyGeneric.kt")
            public void testBoxFunLiteralAnyGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueInLambda/boxFunLiteralAnyGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @Test
            @TestMetadata("boxInt.kt")
            public void testBoxInt() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueInLambda/boxInt.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @Test
            @TestMetadata("boxIntGeneric.kt")
            public void testBoxIntGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueInLambda/boxIntGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @Test
            @TestMetadata("boxNullableAny.kt")
            public void testBoxNullableAny() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueInLambda/boxNullableAny.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @Test
            @TestMetadata("boxNullableAnyGeneric.kt")
            public void testBoxNullableAnyGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueInLambda/boxNullableAnyGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @Test
            @TestMetadata("boxNullableAnyGeneric2.kt")
            public void testBoxNullableAnyGeneric2() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueInLambda/boxNullableAnyGeneric2.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @Test
            @TestMetadata("boxNullableAnyNull.kt")
            public void testBoxNullableAnyNull() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueInLambda/boxNullableAnyNull.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @Test
            @TestMetadata("boxNullableAnyNullGeneric.kt")
            public void testBoxNullableAnyNullGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueInLambda/boxNullableAnyNullGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @Test
            @TestMetadata("boxNullableAnyNullGeneric2.kt")
            public void testBoxNullableAnyNullGeneric2() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueInLambda/boxNullableAnyNullGeneric2.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @Test
            @TestMetadata("boxNullableInt.kt")
            public void testBoxNullableInt() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueInLambda/boxNullableInt.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @Test
            @TestMetadata("boxNullableIntGeneric.kt")
            public void testBoxNullableIntGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueInLambda/boxNullableIntGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @Test
            @TestMetadata("boxNullableIntGeneric2.kt")
            public void testBoxNullableIntGeneric2() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueInLambda/boxNullableIntGeneric2.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @Test
            @TestMetadata("boxNullableIntNull.kt")
            public void testBoxNullableIntNull() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueInLambda/boxNullableIntNull.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @Test
            @TestMetadata("boxNullableIntNullGeneric.kt")
            public void testBoxNullableIntNullGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueInLambda/boxNullableIntNullGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @Test
            @TestMetadata("boxNullableIntNullGeneric2.kt")
            public void testBoxNullableIntNullGeneric2() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueInLambda/boxNullableIntNullGeneric2.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @Test
            @TestMetadata("boxNullableString.kt")
            public void testBoxNullableString() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueInLambda/boxNullableString.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @Test
            @TestMetadata("boxNullableStringGeneric.kt")
            public void testBoxNullableStringGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueInLambda/boxNullableStringGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @Test
            @TestMetadata("boxNullableStringGeneric2.kt")
            public void testBoxNullableStringGeneric2() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueInLambda/boxNullableStringGeneric2.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @Test
            @TestMetadata("boxNullableStringNull.kt")
            public void testBoxNullableStringNull() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueInLambda/boxNullableStringNull.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @Test
            @TestMetadata("boxNullableStringNullGeneric.kt")
            public void testBoxNullableStringNullGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueInLambda/boxNullableStringNullGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @Test
            @TestMetadata("boxNullableStringNullGeneric2.kt")
            public void testBoxNullableStringNullGeneric2() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueInLambda/boxNullableStringNullGeneric2.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @Test
            @TestMetadata("boxString.kt")
            public void testBoxString() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueInLambda/boxString.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @Test
            @TestMetadata("boxStringGeneric.kt")
            public void testBoxStringGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueInLambda/boxStringGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @Test
            @TestMetadata("kt27586_1.kt")
            public void testKt27586_1() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueInLambda/kt27586_1.kt");
            }

            @Test
            @TestMetadata("kt27586_2.kt")
            public void testKt27586_2() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueInLambda/kt27586_2.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride")
        @TestDataPath("$PROJECT_ROOT")
        public class BoxReturnValueOnOverride {
            @Test
            public void testAllFilesPresentInBoxReturnValueOnOverride() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
            }

            @Test
            @TestMetadata("boxReturnValueInDefaultMethod.kt")
            public void testBoxReturnValueInDefaultMethod() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/boxReturnValueInDefaultMethod.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @Test
            @TestMetadata("boxReturnValueInDefaultMethodGenericInt.kt")
            public void testBoxReturnValueInDefaultMethodGenericInt() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/boxReturnValueInDefaultMethodGenericInt.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @Test
            @TestMetadata("covariantOverrideChainErasedToAny.kt")
            public void testCovariantOverrideChainErasedToAny() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/covariantOverrideChainErasedToAny.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @Test
            @TestMetadata("covariantOverrideChainErasedToAnyGeneric.kt")
            public void testCovariantOverrideChainErasedToAnyGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/covariantOverrideChainErasedToAnyGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @Test
            @TestMetadata("covariantOverrideChainErasedToNullableAny.kt")
            public void testCovariantOverrideChainErasedToNullableAny() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/covariantOverrideChainErasedToNullableAny.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @Test
            @TestMetadata("covariantOverrideChainErasedToNullableAnyGeneric.kt")
            public void testCovariantOverrideChainErasedToNullableAnyGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/covariantOverrideChainErasedToNullableAnyGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @Test
            @TestMetadata("covariantOverrideChainErasedToNullableAnyGeneric2.kt")
            public void testCovariantOverrideChainErasedToNullableAnyGeneric2() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/covariantOverrideChainErasedToNullableAnyGeneric2.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @Test
            @TestMetadata("covariantOverrideErasedToAny.kt")
            public void testCovariantOverrideErasedToAny() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/covariantOverrideErasedToAny.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @Test
            @TestMetadata("covariantOverrideErasedToAnyGeneric.kt")
            public void testCovariantOverrideErasedToAnyGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/covariantOverrideErasedToAnyGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @Test
            @TestMetadata("covariantOverrideErasedToInterface.kt")
            public void testCovariantOverrideErasedToInterface() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/covariantOverrideErasedToInterface.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @Test
            @TestMetadata("covariantOverrideErasedToInterfaceGeneric.kt")
            public void testCovariantOverrideErasedToInterfaceGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/covariantOverrideErasedToInterfaceGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @Test
            @TestMetadata("covariantOverrideErasedToPrimitive.kt")
            public void testCovariantOverrideErasedToPrimitive() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/covariantOverrideErasedToPrimitive.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @Test
            @TestMetadata("covariantOverrideErasedToPrimitiveGeneric.kt")
            public void testCovariantOverrideErasedToPrimitiveGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/covariantOverrideErasedToPrimitiveGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @Test
            @TestMetadata("covariantOverrideListVsMutableList.kt")
            public void testCovariantOverrideListVsMutableList() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/covariantOverrideListVsMutableList.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @Test
            @TestMetadata("covariantOverrideListVsMutableListGeneric.kt")
            public void testCovariantOverrideListVsMutableListGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/covariantOverrideListVsMutableListGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @Test
            @TestMetadata("covariantOverrideUnrelatedInterfaces.kt")
            public void testCovariantOverrideUnrelatedInterfaces() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/covariantOverrideUnrelatedInterfaces.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @Test
            @TestMetadata("covariantOverrideUnrelatedInterfacesGeneric.kt")
            public void testCovariantOverrideUnrelatedInterfacesGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/covariantOverrideUnrelatedInterfacesGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @Test
            @TestMetadata("genericOverride.kt")
            public void testGenericOverride() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/genericOverride.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @Test
            @TestMetadata("genericOverrideGeneric.kt")
            public void testGenericOverrideGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/genericOverrideGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @Test
            @TestMetadata("genericOverrideSpecialized.kt")
            public void testGenericOverrideSpecialized() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/genericOverrideSpecialized.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @Test
            @TestMetadata("genericOverrideSpecializedGeneric.kt")
            public void testGenericOverrideSpecializedGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/genericOverrideSpecializedGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @Test
            @TestMetadata("inlineClassInOverriddenReturnTypes.kt")
            public void testInlineClassInOverriddenReturnTypes() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/inlineClassInOverriddenReturnTypes.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @Test
            @TestMetadata("inlineClassInOverriddenReturnTypesGeneric.kt")
            public void testInlineClassInOverriddenReturnTypesGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/inlineClassInOverriddenReturnTypesGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @Test
            @TestMetadata("kt28483.kt")
            public void testKt28483() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/kt28483.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @Test
            @TestMetadata("kt28483Generic.kt")
            public void testKt28483Generic() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/kt28483Generic.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @Test
            @TestMetadata("kt28483Generic2.kt")
            public void testKt28483Generic2() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/kt28483Generic2.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @Test
            @TestMetadata("kt31585.kt")
            public void testKt31585() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/kt31585.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @Test
            @TestMetadata("kt31585Generic.kt")
            public void testKt31585Generic() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/kt31585Generic.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @Test
            @TestMetadata("kt35234.kt")
            public void testKt35234() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/kt35234.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @Test
            @TestMetadata("kt35234Generic.kt")
            public void testKt35234Generic() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/kt35234Generic.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @Test
            @TestMetadata("kt35234a.kt")
            public void testKt35234a() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/kt35234a.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @Test
            @TestMetadata("overrideGenericWithInlineClass.kt")
            public void testOverrideGenericWithInlineClass() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/overrideGenericWithInlineClass.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @Test
            @TestMetadata("overrideGenericWithInlineClassGeneric.kt")
            public void testOverrideGenericWithInlineClassGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/overrideGenericWithInlineClassGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @Test
            @TestMetadata("overrideGenericWithNullableInlineClassUpperBoundWithNonNullAny.kt")
            public void testOverrideGenericWithNullableInlineClassUpperBoundWithNonNullAny() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/overrideGenericWithNullableInlineClassUpperBoundWithNonNullAny.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @Test
            @TestMetadata("overrideGenericWithNullableInlineClassUpperBoundWithNonNullAnyGeneric.kt")
            public void testOverrideGenericWithNullableInlineClassUpperBoundWithNonNullAnyGeneric() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/overrideGenericWithNullableInlineClassUpperBoundWithNonNullAnyGeneric.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @Test
            @TestMetadata("overrideGenericWithNullableInlineClassUpperBoundWithNonNullNullableAny.kt")
            public void testOverrideGenericWithNullableInlineClassUpperBoundWithNonNullNullableAny() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/overrideGenericWithNullableInlineClassUpperBoundWithNonNullNullableAny.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @Test
            @TestMetadata("overrideGenericWithNullableInlineClassUpperBoundWithNonNullNullableAnyG.kt")
            public void testOverrideGenericWithNullableInlineClassUpperBoundWithNonNullNullableAnyG() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/overrideGenericWithNullableInlineClassUpperBoundWithNonNullNullableAnyG.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @Test
            @TestMetadata("overrideGenericWithNullableInlineClassUpperBoundWithNonNullNullableAnyG2.kt")
            public void testOverrideGenericWithNullableInlineClassUpperBoundWithNonNullNullableAnyG2() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/overrideGenericWithNullableInlineClassUpperBoundWithNonNullNullableAnyG2.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotationWithReal());
            }

            @Test
            @TestMetadata("overrideGenericWithNullableInlineClassUpperBoundWithNonNullNullableAnyNG.kt")
            public void testOverrideGenericWithNullableInlineClassUpperBoundWithNonNullNullableAnyNG() throws Exception {
                runTest("compiler/testData/codegen/box/inlineClasses/boxReturnValueOnOverride/overrideGenericWithNullableInlineClassUpperBoundWithNonNullNullableAnyNG.kt", TransformersFunctions.getReplaceOptionalJvmInlineAnnotation