/*
 * Copyright 2010-2021 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.fir;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.runner.RunWith;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.TestsPackage}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("compiler/fir/analysis-tests/testData/resolve")
@TestDataPath("$PROJECT_ROOT")
@RunWith(JUnit3RunnerWithInners.class)
public class LazyBodyIsNotTouchedTilContractsPhaseTestGenerated extends AbstractLazyBodyIsNotTouchedTilContractsPhaseTest {
    private void runTest(String testDataFilePath) throws Exception {
        KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
    }

    public void testAllFilesPresentInResolve() throws Exception {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
    }

    @TestMetadata("annotationOnDeclarationWithDifferentArguments.kt")
    public void testAnnotationOnDeclarationWithDifferentArguments() throws Exception {
        runTest("compiler/fir/analysis-tests/testData/resolve/annotationOnDeclarationWithDifferentArguments.kt");
    }

    @TestMetadata("annotationUsedAsAnnotationArgument.kt")
    public void testAnnotationUsedAsAnnotationArgument() throws Exception {
        runTest("compiler/fir/analysis-tests/testData/resolve/annotationUsedAsAnnotationArgument.kt");
    }

    @TestMetadata("asImports.kt")
    public void testAsImports() throws Exception {
        runTest("compiler/fir/analysis-tests/testData/resolve/asImports.kt");
    }

    @TestMetadata("bareTypes.kt")
    public void testBareTypes() throws Exception {
        runTest("compiler/fir/analysis-tests/testData/resolve/bareTypes.kt");
    }

    @TestMetadata("bareTypes2.kt")
    public void testBareTypes2() throws Exception {
        runTest("compiler/fir/analysis-tests/testData/resolve/bareTypes2.kt");
    }

    @TestMetadata("bareTypesWithFlexibleArguments.kt")
    public void testBareTypesWithFlexibleArguments() throws Exception {
        runTest("compiler/fir/analysis-tests/testData/resolve/bareTypesWithFlexibleArguments.kt");
    }

    @TestMetadata("cast.kt")
    public void testCast() throws Exception {
        runTest("compiler/fir/analysis-tests/testData/resolve/cast.kt");
    }

    @TestMetadata("catchParameter.kt")
    public void testCatchParameter() throws Exception {
        runTest("compiler/fir/analysis-tests/testData/resolve/catchParameter.kt");
    }

    @TestMetadata("classCallInLambda.kt")
    public void testClassCallInLambda() throws Exception {
        runTest("compiler/fir/analysis-tests/testData/resolve/classCallInLambda.kt");
    }

    @TestMetadata("companion.kt")
    public void testCompanion() throws Exception {
        runTest("compiler/fir/analysis-tests/testData/resolve/companion.kt");
    }

    @TestMetadata("companionAccessInEnum.kt")
    public void testCompanionAccessInEnum() throws Exception {
        runTest("compiler/fir/analysis-tests/testData/resolve/companionAccessInEnum.kt");
    }

    @TestMetadata("companionObjectCall.kt")
    public void testCompanionObjectCall() throws Exception {
        runTest("compiler/fir/analysis-tests/testData/resolve/companionObjectCall.kt");
    }

    @TestMetadata("companionUsesNested.kt")
    public void testCompanionUsesNested() throws Exception {
        runTest("compiler/fir/analysis-tests/testData/resolve/companionUsesNested.kt");
    }

    @TestMetadata("constantValues.kt")
    public void testConstantValues() throws Exception {
        runTest("compiler/fir/analysis-tests/testData/resolve/constantValues.kt");
    }

    @TestMetadata("copy.kt")
    public void testCopy() throws Exception {
        runTest("compiler/fir/analysis-tests/testData/resolve/copy.kt");
    }

    @TestMetadata("covariantArrayAsReceiver.kt")
    public void testCovariantArrayAsReceiver() throws Exception {
        runTest("compiler/fir/analysis-tests/testData/resolve/covariantArrayAsReceiver.kt");
    }

    @TestMetadata("defaultJavaImportHiding.kt")
    public void testDefaultJavaImportHiding() throws Exception {
        runTest("compiler/fir/analysis-tests/testData/resolve/defaultJavaImportHiding.kt");
    }

    @TestMetadata("defaultParametersInheritedToJava.kt")
    public void testDefaultParametersInheritedToJava() throws Exception {
        runTest("compiler/fir/analysis-tests/testData/resolve/defaultParametersInheritedToJava.kt");
    }

    @TestMetadata("definitelyNotNullAmbiguity.kt")
    public void testDefinitelyNotNullAmbiguity() throws Exception {
        runTest("compiler/fir/analysis-tests/testData/resolve/definitelyNotNullAmbiguity.kt");
    }

    @TestMetadata("delegatedSuperType.kt")
    public void testDelegatedSuperType() throws Exception {
        runTest("compiler/fir/analysis-tests/testData/resolve/delegatedSuperType.kt");
    }

    @TestMetadata("delegatingConstructorCall.kt")
    public void testDelegatingConstructorCall() throws Exception {
        runTest("compiler/fir/analysis-tests/testData/resolve/delegatingConstructorCall.kt");
    }

    @TestMetadata("delegatingConstructorsAndTypeAliases.kt")
    public void testDelegatingConstructorsAndTypeAliases() throws Exception {
        runTest("compiler/fir/analysis-tests/testData/resolve/delegatingConstructorsAndTypeAliases.kt");
    }

    @TestMetadata("derivedClass.kt")
    public void testDerivedClass() throws Exception {
        runTest("compiler/fir/analysis-tests/testData/resolve/derivedClass.kt");
    }

    @TestMetadata("enum.kt")
    public void testEnum() throws Exception {
        runTest("compiler/fir/analysis-tests/testData/resolve/enum.kt");
    }

    @TestMetadata("enumWithCompanion.kt")
    public void testEnumWithCompanion() throws Exception {
        runTest("compiler/fir/analysis-tests/testData/resolve/enumWithCompanion.kt");
    }

    @TestMetadata("extension.kt")
    public void testExtension() throws Exception {
        runTest("compiler/fir/analysis-tests/testData/resolve/extension.kt");
    }

    @TestMetadata("F.kt")
    public void testF() throws Exception {
        runTest("compiler/fir/analysis-tests/testData/resolve/F.kt");
    }

    @TestMetadata("fakeRecursiveSupertype.kt")
    public void testFakeRecursiveSupertype() throws Exception {
        runTest("compiler/fir/analysis-tests/testData/resolve/fakeRecursiveSupertype.kt");
    }

    @TestMetadata("fakeRecursiveTypealias.kt")
    public void testFakeRecursiveTypealias() throws Exception {
        runTest("compiler/fir/analysis-tests/testData/resolve/fakeRecursiveTypealias.kt");
    }

    @TestMetadata("fib.kt")
    public void testFib() throws Exception {
        runTest("compiler/fir/analysis-tests/testData/resolve/fib.kt");
    }

    @TestMetadata("flexibleCapturedType.kt")
    public void testFlexibleCapturedType() throws Exception {
        runTest("compiler/fir/analysis-tests/testData/resolve/flexibleCapturedType.kt");
    }

    @TestMetadata("ft.kt")
    public void testFt() throws Exception {
        runTest("compiler/fir/analysis-tests/testData/resolve/ft.kt");
    }

    @TestMetadata("funInterfaceDeclaration.kt")
    public void testFunInterfaceDeclaration() throws Exception {
        runTest("compiler/fir/analysis-tests/testData/resolve/funInterfaceDeclaration.kt");
    }

    @TestMetadata("functionTypeAlias.kt")
    public void testFunctionTypeAlias() throws Exception {
        runTest("compiler/fir/analysis-tests/testData/resolve/functionTypeAlias.kt");
    }

    @TestMetadata("functionTypes.kt")
    public void testFunctionTypes() throws Exception {
        runTest("compiler/fir/analysis-tests/testData/resolve/functionTypes.kt");
    }

    @TestMetadata("genericConstructors.kt")
    public void testGenericConstructors() throws Exception {
        runTest("compiler/fir/analysis-tests/testData/resolve/genericConstructors.kt");
    }

    @TestMetadata("genericFunctions.kt")
    public void testGenericFunctions() throws Exception {
        runTest("compiler/fir/analysis-tests/testData/resolve/genericFunctions.kt");
    }

    @TestMetadata("genericReceiverPropertyOverride.kt")
    public void testGenericReceiverPropertyOverride() throws Exception {
        runTest("compiler/fir/analysis-tests/testData/resolve/genericReceiverPropertyOverride.kt");
    }

    @TestMetadata("implicitTypeFromOtherModule.kt")
    public void testImplicitTypeFromOtherModule() throws Exception {
        runTest("compiler/fir/analysis-tests/testData/resolve/implicitTypeFromOtherModule.kt");
    }

    @TestMetadata("implicitTypeInFakeOverride.kt")
    public void testImplicitTypeInFakeOverride() throws Exception {
        runTest("compiler/fir/analysis-tests/testData/resolve/implicitTypeInFakeOverride.kt");
    }

    @TestMetadata("implicitTypeWithTypeBound.kt")
    public void testImplicitTypeWithTypeBound() throws Exception {
        runTest("compiler/fir/analysis-tests/testData/resolve/implicitTypeWithTypeBound.kt");
    }

    @TestMetadata("incorrectDataClass.kt")
    public void testIncorrectDataClass() throws Exception {
        runTest("compiler/fir/analysis-tests/testData/resolve/incorrectDataClass.kt");
    }

    @TestMetadata("incorrectSuperCall.kt")
    public void testIncorrectSuperCall() throws Exception {
        runTest("compiler/fir/analysis-tests/testData/resolve/incorrectSuperCall.kt");
    }

    @TestMetadata("inherentlyImportedTypeFromOtherModule.kt")
    public void testInherentlyImportedTypeFromOtherModule() throws Exception {
        runTest("compiler/fir/analysis-tests/testData/resolve/inherentlyImportedTypeFromOtherModule.kt");
    }

    @TestMetadata("inherentlyImportedTypeFromOtherModule2.kt")
    public void testInherentlyImportedTypeFromOtherModule2() throws Exception {
        runTest("compiler/fir/analysis-tests/testData/resolve/inherentlyImportedTypeFromOtherModule2.kt");
    }

    @TestMetadata("inherentlyImportedTypeFromOtherModule3.kt")
    public void testInherentlyImportedTypeFromOtherModule3() throws Exception {
        runTest("compiler/fir/analysis-tests/testData/resolve/inherentlyImportedTypeFromOtherModule3.kt");
    }

    @TestMetadata("intersectionScope.kt")
    public void testIntersectionScope() throws Exception {
        runTest("compiler/fir/analysis-tests/testData/resolve/intersectionScope.kt");
    }

    @TestMetadata("intersectionTypes.kt")
    public void testIntersectionTypes() throws Exception {
        runTest("compiler/fir/analysis-tests/testData/resolve/intersectionTypes.kt");
    }

    @TestMetadata("invokeInWhenSubjectVariableInitializer.kt")
    public void testInvokeInWhenSubjectVariableInitializer() throws Exception {
        runTest("compiler/fir/analysis-tests/testData/resolve/invokeInWhenSubjectVariableInitializer.kt");
    }

    @TestMetadata("invokeOfLambdaWithReceiver.kt")
    public void testInvokeOfLambdaWithReceiver() throws Exception {
        runTest("compiler/fir/analysis-tests/testData/resolve/invokeOfLambdaWithReceiver.kt");
    }

    @TestMetadata("javaFieldVsAccessor.kt")
    public void testJavaFieldVsAccessor() throws Exception {
        runTest("compiler/fir/analysis-tests/testData/resolve/javaFieldVsAccessor.kt");
    }

    @TestMetadata("javaStaticScopeInheritance.kt")
    public void testJavaStaticScopeInheritance() throws Exception {
        runTest("compiler/fir/analysis-tests/testData/resolve/javaStaticScopeInheritance.kt");
    }

    @TestMetadata("kt41984.kt")
    public void testKt41984() throws Exception {
        runTest("compiler/fir/analysis-tests/testData/resolve/kt41984.kt");
    }

    @TestMetadata("kt41990.kt")
    public void testKt41990() throws Exception {
        runTest("compiler/fir/analysis-tests/testData/resolve/kt41990.kt");
    }

    @TestMetadata("labelAndReceiverForInfix.kt")
    public void testLabelAndReceiverForInfix() throws Exception {
        runTest("compiler/fir/analysis-tests/testData/resolve/labelAndReceiverForInfix.kt");
    }

    @TestMetadata("labeledReturnFromNotLabeledUnnamedFunction.kt")
    public void testLabeledReturnFromNotLabeledUnnamedFunction() throws Exception {
        runTest("compiler/fir/analysis-tests/testData/resolve/labeledReturnFromNotLabeledUnnamedFunction.kt");
    }

    @TestMetadata("lambdaArgInScopeFunction.kt")
    public void testLambdaArgInScopeFunction() throws Exception {
        runTest("compiler/fir/analysis-tests/testData/resolve/lambdaArgInScopeFunction.kt");
    }

    @TestMetadata("lambdaInLhsOfTypeOperatorCall.kt")
    public void testLambdaInLhsOfTypeOperatorCall() throws Exception {
        runTest("compiler/fir/analysis-tests/testData/resolve/lambdaInLhsOfTypeOperatorCall.kt");
    }

    @TestMetadata("lambdaPropertyTypeInference.kt")
    public void testLambdaPropertyTypeInference() throws Exception {
        runTest("compiler/fir/analysis-tests/testData/resolve/lambdaPropertyTypeInference.kt");
    }

    @TestMetadata("localFunctionsHiding.kt")
    public void testLocalFunctionsHiding() throws Exception {
        runTest("compiler/fir/analysis-tests/testData/resolve/localFunctionsHiding.kt");
    }

    @TestMetadata("localObject.kt")
    public void testLocalObject() throws Exception {
        runTest("compiler/fir/analysis-tests/testData/resolve/localObject.kt");
    }

    @TestMetadata("nestedClass.kt")
    public void testNestedClass() throws Exception {
        runTest("compiler/fir/analysis-tests/testData/resolve/nestedClass.kt");
    }

    @TestMetadata("nestedClassContructor.kt")
    public void testNestedClassContructor() throws Exception {
        runTest("compiler/fir/analysis-tests/testData/resolve/nestedClassContructor.kt");
    }

    @TestMetadata("nestedClassNameClash.kt")
    public void testNestedClassNameClash() throws Exception {
        runTest("compiler/fir/analysis-tests/testData/resolve/nestedClassNameClash.kt");
    }

    @TestMetadata("NestedOfAliasedType.kt")
    public void testNestedOfAliasedType() throws Exception {
        runTest("compiler/fir/analysis-tests/testData/resolve/NestedOfAliasedType.kt");
    }

    @TestMetadata("nestedReturnType.kt")
    public void testNestedReturnType() throws Exception {
        runTest("compiler/fir/analysis-tests/testData/resolve/nestedReturnType.kt");
    }

    @TestMetadata("NestedSuperType.kt")
    public void testNestedSuperType() throws Exception {
        runTest("compiler/fir/analysis-tests/testData/resolve/NestedSuperType.kt");
    }

    @TestMetadata("objectInnerClass.kt")
    public void testObjectInnerClass() throws Exception {
        runTest("compiler/fir/analysis-tests/testData/resolve/objectInnerClass.kt");
    }

    @TestMetadata("offOrderMultiBoundGenericOverride.kt")
    public void testOffOrderMultiBoundGenericOverride() throws Exception {
        runTest("compiler/fir/analysis-tests/testData/resolve/offOrderMultiBoundGenericOverride.kt");
    }

    @TestMetadata("openInInterface.kt")
    public void testOpenInInterface() throws Exception {
        runTest("compiler/fir/analysis-tests/testData/resolve/openInInterface.kt");
    }

    @TestMetadata("problems2.kt")
    public void testProblems2() throws Exception {
        runTest("compiler/fir/analysis-tests/testData/resolve/problems2.kt");
    }

    @TestMetadata("propertyFromJavaPlusAssign.kt")
    public void testPropertyFromJavaPlusAssign() throws Exception {
        runTest("compiler/fir/analysis-tests/testData/resolve/propertyFromJavaPlusAssign.kt");
    }

    @TestMetadata("qualifierWithCompanion.kt")
    public void testQualifierWithCompanion() throws Exception {
        runTest("compiler/fir/analysis-tests/testData/resolve/qualifierWithCompanion.kt");
    }

    @TestMetadata("rawTypeSam.kt")
    public void testRawTypeSam() throws Exception {
        runTest("compiler/fir/analysis-tests/testData/resolve/rawTypeSam.kt");
    }

    @TestMetadata("recursiveCallOnWhenWithSealedClass.kt")
    public void testRecursiveCallOnWhenWithSealedClass() throws Exception {
        runTest("compiler/fir/analysis-tests/testData/resolve/recursiveCallOnWhenWithSealedClass.kt");
    }

    @TestMetadata("recursiveTypeAlias.kt")
    public void testRecursiveTypeAlias() throws Exception {
        runTest("compiler/fir/analysis-tests/testData/resolve/recursiveTypeAlias.kt");
    }

    @TestMetadata("sealedClass.kt")
    public void testSealedClass() throws Exception {
        runTest("compiler/fir/analysis-tests/testData/resolve/sealedClass.kt");
    }

    @TestMetadata("settersGetters.kt")
    public void testSettersGetters() throws Exception {
        runTest("compiler/fir/analysis-tests/testData/resolve/settersGetters.kt");
    }

    @TestMetadata("simpleClass.kt")
    public void testSimpleClass() throws Exception {
        runTest("compiler/fir/analysis-tests/testData/resolve/simpleClass.kt");
    }

    @TestMetadata("simpleTypeAlias.kt")
    public void testSimpleTypeAlias() throws Exception {
        runTest("compiler/fir/analysis-tests/testData/resolve/simpleTypeAlias.kt");
    }

    @TestMetadata("spreadOperator.kt")
    public void testSpreadOperator() throws Exception {
        runTest("compiler/fir/analysis-tests/testData/resolve/spreadOperator.kt");
    }

    @TestMetadata("statusResolveForTypealiasAsSuperClass.kt")
    public void testStatusResolveForTypealiasAsSuperClass() throws Exception {
        runTest("compiler/fir/analysis-tests/testData/resolve/statusResolveForTypealiasAsSuperClass.kt");
    }

    @TestMetadata("supertypesForAnnotationClass.kt")
    public void testSupertypesForAnnotationClass() throws Exception {
        runTest("compiler/fir/analysis-tests/testData/resolve/supertypesForAnnotationClass.kt");
    }

    @TestMetadata("syntheticsVsNormalProperties.kt")
    public void testSyntheticsVsNormalProperties() throws Exception {
        runTest("compiler/fir/analysis-tests/testData/resolve/syntheticsVsNormalProperties.kt");
    }

    @TestMetadata("throwableSubclass.kt")
    public void testThrowableSubclass() throws Exception {
        runTest("compiler/fir/analysis-tests/testData/resolve/throwableSubclass.kt");
    }

    @TestMetadata("topLevelDestruction.kt")
    public void testTopLevelDestruction() throws Exception {
        runTest("compiler/fir/analysis-tests/testData/resolve/topLevelDestruction.kt");
    }

    @TestMetadata("treeSet.kt")
    public void testTreeSet() throws Exception {
        runTest("compiler/fir/analysis-tests/testData/resolve/treeSet.kt");
    }

    @TestMetadata("tryInference.kt")
    public void testTryInference() throws Exception {
        runTest("compiler/fir/analysis-tests/testData/resolve/tryInference.kt");
    }

    @TestMetadata("TwoDeclarationsInSameFile.kt")
    public void testTwoDeclarationsInSameFile() throws Exception {
        runTest("compiler/fir/analysis-tests/testData/resolve/TwoDeclarationsInSameFile.kt");
    }

    @TestMetadata("typeAliasWithGeneric.kt")
    public void testTypeAliasWithGeneric() throws Exception {
        runTest("compiler/fir/analysis-tests/testData/resolve/typeAliasWithGeneric.kt");
    }

    @TestMetadata("typeAliasWithTypeArguments.kt")
    public void testTypeAliasWithTypeArguments() throws Exception {
        runTest("compiler/fir/analysis-tests/testData/resolve/typeAliasWithTypeArguments.kt");
    }

    @TestMetadata("typeFromGetter.kt")
    public void testTypeFromGetter() throws Exception {
        runTest("compiler/fir/analysis-tests/testData/resolve/typeFromGetter.kt");
    }

    @TestMetadata("typeParameterInPropertyReceiver.kt")
    public void testTypeParameterInPropertyReceiver() throws Exception {
        runTest("compiler/fir/analysis-tests/testData/resolve/typeParameterInPropertyReceiver.kt");
    }

    @TestMetadata("typeParameterVsNested.kt")
    public void testTypeParameterVsNested() throws Exception {
        runTest("compiler/fir/analysis-tests/testData/resolve/typeParameterVsNested.kt");
    }

    @TestMetadata("typesInLocalFunctions.kt")
    public void testTypesInLocalFunctions() throws Exception {
        runTest("compiler/fir/analysis-tests/testData/resolve/typesInLocalFunctions.kt");
    }

    @TestMetadata("varargInPrimaryConstructor.kt")
    public void testVarargInPrimaryConstructor() throws Exception {
        runTest("compiler/fir/analysis-tests/testData/resolve/varargInPrimaryConstructor.kt");
    }

    @TestMetadata("visibleVsInvisibleQualifier.kt")
    public void testVisibleVsInvisibleQualifier() throws Exception {
        runTest("compiler/fir/analysis-tests/testData/resolve/visibleVsInvisibleQualifier.kt");
    }

    @TestMetadata("whenAsReceiver.kt")
    public void testWhenAsReceiver() throws Exception {
        runTest("compiler/fir/analysis-tests/testData/resolve/whenAsReceiver.kt");
    }

    @TestMetadata("whenElse.kt")
    public void testWhenElse() throws Exception {
        runTest("compiler/fir/analysis-tests/testData/resolve/whenElse.kt");
    }

    @TestMetadata("whenExpressionType.kt")
    public void testWhenExpressionType() throws Exception {
        runTest("compiler/fir/analysis-tests/testData/resolve/whenExpressionType.kt");
    }

    @TestMetadata("whenInference.kt")
    public void testWhenInference() throws Exception {
        runTest("compiler/fir/analysis-tests/testData/resolve/whenInference.kt");
    }

    @TestMetadata("whenWithWhenAsStatement.kt")
    public void testWhenWithWhenAsStatement() throws Exception {
        runTest("compiler/fir/analysis-tests/testData/resolve/whenWithWhenAsStatement.kt");
    }

    @TestMetadata("compiler/fir/analysis-tests/testData/resolve/arguments")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Arguments extends AbstractLazyBodyIsNotTouchedTilContractsPhaseTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
        }

        public void testAllFilesPresentInArguments() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/arguments"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
        }

        @TestMetadata("ambiguityOnJavaOverride.kt")
        public void testAmbiguityOnJavaOverride() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/arguments/ambiguityOnJavaOverride.kt");
        }

        @TestMetadata("argParamTypeMismatch.kt")
        public void testArgParamTypeMismatch() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/arguments/argParamTypeMismatch.kt");
        }

        @TestMetadata("argumentsOfAnnotations.kt")
        public void testArgumentsOfAnnotations() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/arguments/argumentsOfAnnotations.kt");
        }

        @TestMetadata("argumentsOfJavaAnnotation.kt")
        public void testArgumentsOfJavaAnnotation() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/arguments/argumentsOfJavaAnnotation.kt");
        }

        @TestMetadata("default.kt")
        public void testDefault() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/arguments/default.kt");
        }

        @TestMetadata("defaultFromOverrides.kt")
        public void testDefaultFromOverrides() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/arguments/defaultFromOverrides.kt");
        }

        @TestMetadata("definetelyNotNullForTypeParameter.kt")
        public void testDefinetelyNotNullForTypeParameter() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/arguments/definetelyNotNullForTypeParameter.kt");
        }

        @TestMetadata("destructuring.kt")
        public void testDestructuring() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/arguments/destructuring.kt");
        }

        @TestMetadata("extensionLambdaInDefaultArgument.kt")
        public void testExtensionLambdaInDefaultArgument() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/arguments/extensionLambdaInDefaultArgument.kt");
        }

        @TestMetadata("fieldPlusAssign.kt")
        public void testFieldPlusAssign() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/arguments/fieldPlusAssign.kt");
        }

        @TestMetadata("incorrectFunctionalType.kt")
        public void testIncorrectFunctionalType() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/arguments/incorrectFunctionalType.kt");
        }

        @TestMetadata("integerLiteralTypes.kt")
        public void testIntegerLiteralTypes() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/arguments/integerLiteralTypes.kt");
        }

        @TestMetadata("integerOverloads.kt")
        public void testIntegerOverloads() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/arguments/integerOverloads.kt");
        }

        @TestMetadata("invoke.kt")
        public void testInvoke() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/arguments/invoke.kt");
        }

        @TestMetadata("javaAnnotationsWithArrayValue.kt")
        public void testJavaAnnotationsWithArrayValue() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/arguments/javaAnnotationsWithArrayValue.kt");
        }

        @TestMetadata("javaArrayVariance.kt")
        public void testJavaArrayVariance() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/arguments/javaArrayVariance.kt");
        }

        @TestMetadata("kt41940.kt")
        public void testKt41940() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/arguments/kt41940.kt");
        }

        @TestMetadata("lambda.kt")
        public void testLambda() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/arguments/lambda.kt");
        }

        @TestMetadata("lambdaInLambda.kt")
        public void testLambdaInLambda() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/arguments/lambdaInLambda.kt");
        }

        @TestMetadata("lambdaInLambda2.kt")
        public void testLambdaInLambda2() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/arguments/lambdaInLambda2.kt");
        }

        @TestMetadata("lambdaInUnresolvedCall.kt")
        public void testLambdaInUnresolvedCall() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/arguments/lambdaInUnresolvedCall.kt");
        }

        @TestMetadata("namedArrayInAnnotation.kt")
        public void testNamedArrayInAnnotation() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/arguments/namedArrayInAnnotation.kt");
        }

        @TestMetadata("nestedClassInAnnotationArgument.kt")
        public void testNestedClassInAnnotationArgument() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/arguments/nestedClassInAnnotationArgument.kt");
        }

        @TestMetadata("noParameterForName.kt")
        public void testNoParameterForName() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/arguments/noParameterForName.kt");
        }

        @TestMetadata("operatorsOverLiterals.kt")
        public void testOperatorsOverLiterals() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/arguments/operatorsOverLiterals.kt");
        }

        @TestMetadata("overloadByReceiver.kt")
        public void testOverloadByReceiver() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/arguments/overloadByReceiver.kt");
        }

        @TestMetadata("overloadWithDefault.kt")
        public void testOverloadWithDefault() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/arguments/overloadWithDefault.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/arguments/simple.kt");
        }

        @TestMetadata("stringTemplates.kt")
        public void testStringTemplates() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/arguments/stringTemplates.kt");
        }

        @TestMetadata("tryInLambda.kt")
        public void testTryInLambda() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/arguments/tryInLambda.kt");
        }

        @TestMetadata("typeMismatchOnExpectedJavaMap.kt")
        public void testTypeMismatchOnExpectedJavaMap() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/arguments/typeMismatchOnExpectedJavaMap.kt");
        }

        @TestMetadata("untouchedReturnInIf.kt")
        public void testUntouchedReturnInIf() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/arguments/untouchedReturnInIf.kt");
        }

        @TestMetadata("vararg.kt")
        public void testVararg() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/arguments/vararg.kt");
        }

        @TestMetadata("varargOfLambdasWithReceiver.kt")
        public void testVarargOfLambdasWithReceiver() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/arguments/varargOfLambdasWithReceiver.kt");
        }

        @TestMetadata("varargProjection.kt")
        public void testVarargProjection() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/arguments/varargProjection.kt");
        }
    }

    @TestMetadata("compiler/fir/analysis-tests/testData/resolve/arrays")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Arrays extends AbstractLazyBodyIsNotTouchedTilContractsPhaseTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
        }

        public void testAllFilesPresentInArrays() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/arrays"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
        }

        @TestMetadata("arraySet.kt")
        public void testArraySet() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/arrays/arraySet.kt");
        }

        @TestMetadata("arraySetWithOperation.kt")
        public void testArraySetWithOperation() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/arrays/arraySetWithOperation.kt");
        }
    }

    @TestMetadata("compiler/fir/analysis-tests/testData/resolve/builtins")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Builtins extends AbstractLazyBodyIsNotTouchedTilContractsPhaseTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
        }

        public void testAllFilesPresentInBuiltins() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/builtins"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
        }

        @TestMetadata("lists.kt")
        public void testLists() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/builtins/lists.kt");
        }
    }

    @TestMetadata("compiler/fir/analysis-tests/testData/resolve/callResolution")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class CallResolution extends AbstractLazyBodyIsNotTouchedTilContractsPhaseTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
        }

        public void testAllFilesPresentInCallResolution() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/callResolution"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
        }

        @TestMetadata("arraySetWithPlusAssign.kt")
        public void testArraySetWithPlusAssign() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/callResolution/arraySetWithPlusAssign.kt");
        }

        @TestMetadata("companionInvoke.kt")
        public void testCompanionInvoke() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/callResolution/companionInvoke.kt");
        }

        @TestMetadata("companionVsSuperStatic.kt")
        public void testCompanionVsSuperStatic() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/callResolution/companionVsSuperStatic.kt");
        }

        @TestMetadata("debugExpressionType.kt")
        public void testDebugExpressionType() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/callResolution/debugExpressionType.kt");
        }

        @TestMetadata("debugInfoCall.kt")
        public void testDebugInfoCall() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/callResolution/debugInfoCall.kt");
        }

        @TestMetadata("errorCandidates.kt")
        public void testErrorCandidates() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/callResolution/errorCandidates.kt");
        }

        @TestMetadata("exponentialArraySetWithPlusAssign.kt")
        public void testExponentialArraySetWithPlusAssign() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/callResolution/exponentialArraySetWithPlusAssign.kt");
        }

        @TestMetadata("extensionInvokeAfterSafeCall.kt")
        public void testExtensionInvokeAfterSafeCall() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/callResolution/extensionInvokeAfterSafeCall.kt");
        }

        @TestMetadata("invokeAmbiguity.kt")
        public void testInvokeAmbiguity() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/callResolution/invokeAmbiguity.kt");
        }

        @TestMetadata("invokeWithReceiverAndArgument.kt")
        public void testInvokeWithReceiverAndArgument() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/callResolution/invokeWithReceiverAndArgument.kt");
        }

        @TestMetadata("kt37056.kt")
        public void testKt37056() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/callResolution/kt37056.kt");
        }

        @TestMetadata("lambdaAsReceiver.kt")
        public void testLambdaAsReceiver() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/callResolution/lambdaAsReceiver.kt");
        }

        @TestMetadata("objectInvoke.kt")
        public void testObjectInvoke() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/callResolution/objectInvoke.kt");
        }

        @TestMetadata("safeCallOnTypeAlias.kt")
        public void testSafeCallOnTypeAlias() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/callResolution/safeCallOnTypeAlias.kt");
        }

        @TestMetadata("superAny.kt")
        public void testSuperAny() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/callResolution/superAny.kt");
        }

        @TestMetadata("syntheticPropertiesWrongImplicitReceiver.kt")
        public void testSyntheticPropertiesWrongImplicitReceiver() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/callResolution/syntheticPropertiesWrongImplicitReceiver.kt");
        }

        @TestMetadata("twoLocalLambdasWithSameName.kt")
        public void testTwoLocalLambdasWithSameName() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/callResolution/twoLocalLambdasWithSameName.kt");
        }

        @TestMetadata("typeAliasWithNotNullBound.kt")
        public void testTypeAliasWithNotNullBound() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/callResolution/typeAliasWithNotNullBound.kt");
        }

        @TestMetadata("uselessMultipleBounds.kt")
        public void testUselessMultipleBounds() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/callResolution/uselessMultipleBounds.kt");
        }
    }

    @TestMetadata("compiler/fir/analysis-tests/testData/resolve/cfg")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Cfg extends AbstractLazyBodyIsNotTouchedTilContractsPhaseTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
        }

        public void testAllFilesPresentInCfg() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/cfg"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
        }

        @TestMetadata("annotatedLocalClass.kt")
        public void testAnnotatedLocalClass() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/cfg/annotatedLocalClass.kt");
        }

        @TestMetadata("binaryOperations.kt")
        public void testBinaryOperations() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/cfg/binaryOperations.kt");
        }

        @TestMetadata("booleanOperatorsWithConsts.kt")
        public void testBooleanOperatorsWithConsts() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/cfg/booleanOperatorsWithConsts.kt");
        }

        @TestMetadata("complex.kt")
        public void testComplex() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/cfg/complex.kt");
        }

        @TestMetadata("defaultArguments.kt")
        public void testDefaultArguments() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/cfg/defaultArguments.kt");
        }

        @TestMetadata("emptyWhen.kt")
        public void testEmptyWhen() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/cfg/emptyWhen.kt");
        }

        @TestMetadata("flowFromInplaceLambda.kt")
        public void testFlowFromInplaceLambda() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/cfg/flowFromInplaceLambda.kt");
        }

        @TestMetadata("initBlock.kt")
        public void testInitBlock() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/cfg/initBlock.kt");
        }

        @TestMetadata("initBlockAndInPlaceLambda.kt")
        public void testInitBlockAndInPlaceLambda() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/cfg/initBlockAndInPlaceLambda.kt");
        }

        @TestMetadata("innerClassInAnonymousObject.kt")
        public void testInnerClassInAnonymousObject() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/cfg/innerClassInAnonymousObject.kt");
        }

        @TestMetadata("inplaceLambdaInControlFlowExpressions.kt")
        public void testInplaceLambdaInControlFlowExpressions() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/cfg/inplaceLambdaInControlFlowExpressions.kt");
        }

        @TestMetadata("jumps.kt")
        public void testJumps() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/cfg/jumps.kt");
        }

        @TestMetadata("lambdaAsReturnOfLambda.kt")
        public void testLambdaAsReturnOfLambda() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/cfg/lambdaAsReturnOfLambda.kt");
        }

        @TestMetadata("lambdaReturningObject.kt")
        public void testLambdaReturningObject() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/cfg/lambdaReturningObject.kt");
        }

        @TestMetadata("lambdas.kt")
        public void testLambdas() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/cfg/lambdas.kt");
        }

        @TestMetadata("localClassesWithImplicit.kt")
        public void testLocalClassesWithImplicit() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/cfg/localClassesWithImplicit.kt");
        }

        @TestMetadata("loops.kt")
        public void testLoops() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/cfg/loops.kt");
        }

        @TestMetadata("postponedLambdaInConstructor.kt")
        public void testPostponedLambdaInConstructor() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/cfg/postponedLambdaInConstructor.kt");
        }

        @TestMetadata("postponedLambdas.kt")
        public void testPostponedLambdas() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/cfg/postponedLambdas.kt");
        }

        @TestMetadata("propertiesAndInitBlocks.kt")
        public void testPropertiesAndInitBlocks() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/cfg/propertiesAndInitBlocks.kt");
        }

        @TestMetadata("returnValuesFromLambda.kt")
        public void testReturnValuesFromLambda() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/cfg/returnValuesFromLambda.kt");
        }

        @TestMetadata("safeCalls.kt")
        public void testSafeCalls() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/cfg/safeCalls.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/cfg/simple.kt");
        }

        @TestMetadata("tryCatch.kt")
        public void testTryCatch() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/cfg/tryCatch.kt");
        }

        @TestMetadata("variableInitializedInTryBlock.kt")
        public void testVariableInitializedInTryBlock() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/cfg/variableInitializedInTryBlock.kt");
        }

        @TestMetadata("when.kt")
        public void testWhen() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/cfg/when.kt");
        }
    }

    @TestMetadata("compiler/fir/analysis-tests/testData/resolve/constVal")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ConstVal extends AbstractLazyBodyIsNotTouchedTilContractsPhaseTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
        }

        public void testAllFilesPresentInConstVal() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/constVal"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
        }

        @TestMetadata("const.kt")
        public void testConst() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/constVal/const.kt");
        }

        @TestMetadata("constValNotTopLevelOrObject.kt")
        public void testConstValNotTopLevelOrObject() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/constVal/constValNotTopLevelOrObject.kt");
        }

        @TestMetadata("constValWithGetterOrDelegate.kt")
        public void testConstValWithGetterOrDelegate() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/constVal/constValWithGetterOrDelegate.kt");
        }

        @TestMetadata("constValWithTypealiasType.kt")
        public void testConstValWithTypealiasType() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/constVal/constValWithTypealiasType.kt");
        }
    }

    @TestMetadata("compiler/fir/analysis-tests/testData/resolve/constructors")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Constructors extends AbstractLazyBodyIsNotTouchedTilContractsPhaseTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
        }

        public void testAllFilesPresentInConstructors() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/constructors"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
        }

        @TestMetadata("erroneousDelegatedConstructorCall.kt")
        public void testErroneousDelegatedConstructorCall() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/constructors/erroneousDelegatedConstructorCall.kt");
        }

        @TestMetadata("noSuperCallInSupertypes.kt")
        public void testNoSuperCallInSupertypes() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/constructors/noSuperCallInSupertypes.kt");
        }
    }

    @TestMetadata("compiler/fir/analysis-tests/testData/resolve/contracts")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Contracts extends AbstractLazyBodyIsNotTouchedTilContractsPhaseTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
        }

        public void testAllFilesPresentInContracts() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/contracts"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
        }

        @TestMetadata("genericContract.kt")
        public void testGenericContract() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/contracts/genericContract.kt");
        }
    }

    @TestMetadata("compiler/fir/analysis-tests/testData/resolve/delegates")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Delegates extends AbstractLazyBodyIsNotTouchedTilContractsPhaseTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
        }

        public void testAllFilesPresentInDelegates() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/delegates"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
        }

        @TestMetadata("delegateInference.kt")
        public void testDelegateInference() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/delegates/delegateInference.kt");
        }

        @TestMetadata("delegateWithArgInference.kt")
        public void testDelegateWithArgInference() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/delegates/delegateWithArgInference.kt");
        }

        @TestMetadata("delegateWithLambda.kt")
        public void testDelegateWithLambda() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/delegates/delegateWithLambda.kt");
        }

        @TestMetadata("extensionGenericGetValue.kt")
        public void testExtensionGenericGetValue() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/delegates/extensionGenericGetValue.kt");
        }

        @TestMetadata("extensionGetValueWithTypeVariableAsReceiver.kt")
        public void testExtensionGetValueWithTypeVariableAsReceiver() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/delegates/extensionGetValueWithTypeVariableAsReceiver.kt");
        }

        @TestMetadata("kt41982.kt")
        public void testKt41982() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/delegates/kt41982.kt");
        }

        @TestMetadata("provideDelegate.kt")
        public void testProvideDelegate() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/delegates/provideDelegate.kt");
        }

        @TestMetadata("receiverInference.kt")
        public void testReceiverInference() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/delegates/receiverInference.kt");
        }
    }

    @TestMetadata("compiler/fir/analysis-tests/testData/resolve/diagnostics")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Diagnostics extends AbstractLazyBodyIsNotTouchedTilContractsPhaseTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
        }

        @TestMetadata("abstractSuperCall.kt")
        public void testAbstractSuperCall() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/abstractSuperCall.kt");
        }

        @TestMetadata("abstractSuperCallInPresenseOfNonAbstractMethodInParent.kt")
        public void testAbstractSuperCallInPresenseOfNonAbstractMethodInParent() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/abstractSuperCallInPresenseOfNonAbstractMethodInParent.kt");
        }

        public void testAllFilesPresentInDiagnostics() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/diagnostics"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
        }

        @TestMetadata("annotationArgumentKClassLiteralTypeError.kt")
        public void testAnnotationArgumentKClassLiteralTypeError() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/annotationArgumentKClassLiteralTypeError.kt");
        }

        @TestMetadata("annotationArgumentMustBeConst.kt")
        public void testAnnotationArgumentMustBeConst() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/annotationArgumentMustBeConst.kt");
        }

        @TestMetadata("annotationArgumentMustBeEnumConst.kt")
        public void testAnnotationArgumentMustBeEnumConst() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/annotationArgumentMustBeEnumConst.kt");
        }

        @TestMetadata("annotationArgumentMustBeKClassLiteral.kt")
        public void testAnnotationArgumentMustBeKClassLiteral() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/annotationArgumentMustBeKClassLiteral.kt");
        }

        @TestMetadata("annotationClassMember.kt")
        public void testAnnotationClassMember() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/annotationClassMember.kt");
        }

        @TestMetadata("anonymousObjectByDelegate.kt")
        public void testAnonymousObjectByDelegate() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/anonymousObjectByDelegate.kt");
        }

        @TestMetadata("classInSupertypeForEnum.kt")
        public void testClassInSupertypeForEnum() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/classInSupertypeForEnum.kt");
        }

        @TestMetadata("conflictingOverloads.kt")
        public void testConflictingOverloads() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/conflictingOverloads.kt");
        }

        @TestMetadata("conflictingProjection.kt")
        public void testConflictingProjection() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/conflictingProjection.kt");
        }

        @TestMetadata("constructorInInterface.kt")
        public void testConstructorInInterface() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/constructorInInterface.kt");
        }

        @TestMetadata("cyclicConstructorDelegationCall.kt")
        public void testCyclicConstructorDelegationCall() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/cyclicConstructorDelegationCall.kt");
        }

        @TestMetadata("delegationInInterface.kt")
        public void testDelegationInInterface() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/delegationInInterface.kt");
        }

        @TestMetadata("delegationSuperCallInEnumConstructor.kt")
        public void testDelegationSuperCallInEnumConstructor() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/delegationSuperCallInEnumConstructor.kt");
        }

        @TestMetadata("explicitDelegationCallRequired.kt")
        public void testExplicitDelegationCallRequired() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/explicitDelegationCallRequired.kt");
        }

        @TestMetadata("inapplicableLateinitModifier.kt")
        public void testInapplicableLateinitModifier() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/inapplicableLateinitModifier.kt");
        }

        @TestMetadata("incompatibleModifiers.kt")
        public void testIncompatibleModifiers() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/incompatibleModifiers.kt");
        }

        @TestMetadata("infixFunctions.kt")
        public void testInfixFunctions() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/infixFunctions.kt");
        }

        @TestMetadata("instanceAccessBeforeSuperCall.kt")
        public void testInstanceAccessBeforeSuperCall() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/instanceAccessBeforeSuperCall.kt");
        }

        @TestMetadata("interfaceWithSuperclass.kt")
        public void testInterfaceWithSuperclass() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/interfaceWithSuperclass.kt");
        }

        @TestMetadata("localAnnotationClass.kt")
        public void testLocalAnnotationClass() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/localAnnotationClass.kt");
        }

        @TestMetadata("localEntitytNotAllowed.kt")
        public void testLocalEntitytNotAllowed() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/localEntitytNotAllowed.kt");
        }

        @TestMetadata("manyCompanionObjects.kt")
        public void testManyCompanionObjects() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/manyCompanionObjects.kt");
        }

        @TestMetadata("methodOfAnyImplementedInInterface.kt")
        public void testMethodOfAnyImplementedInInterface() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/methodOfAnyImplementedInInterface.kt");
        }

        @TestMetadata("multipleBounds.kt")
        public void testMultipleBounds() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/multipleBounds.kt");
        }

        @TestMetadata("nonConstValInAnnotationArgument.kt")
        public void testNonConstValInAnnotationArgument() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/nonConstValInAnnotationArgument.kt");
        }

        @TestMetadata("notASupertype.kt")
        public void testNotASupertype() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/notASupertype.kt");
        }

        @TestMetadata("primaryConstructorRequiredForDataClass.kt")
        public void testPrimaryConstructorRequiredForDataClass() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/primaryConstructorRequiredForDataClass.kt");
        }

        @TestMetadata("projectionsOnNonClassTypeArguments.kt")
        public void testProjectionsOnNonClassTypeArguments() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/projectionsOnNonClassTypeArguments.kt");
        }

        @TestMetadata("propertyTypeMismatchOnOverride.kt")
        public void testPropertyTypeMismatchOnOverride() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/propertyTypeMismatchOnOverride.kt");
        }

        @TestMetadata("qualifiedSupertypeExtendedByOtherSupertype.kt")
        public void testQualifiedSupertypeExtendedByOtherSupertype() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/qualifiedSupertypeExtendedByOtherSupertype.kt");
        }

        @TestMetadata("redundantModifier.kt")
        public void testRedundantModifier() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/redundantModifier.kt");
        }

        @TestMetadata("repeatedModifier.kt")
        public void testRepeatedModifier() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/repeatedModifier.kt");
        }

        @TestMetadata("returnTypeMismatchOnOverride.kt")
        public void testReturnTypeMismatchOnOverride() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/returnTypeMismatchOnOverride.kt");
        }

        @TestMetadata("sealedClassConstructorCall.kt")
        public void testSealedClassConstructorCall() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/sealedClassConstructorCall.kt");
        }

        @TestMetadata("sealedSupertype.kt")
        public void testSealedSupertype() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/sealedSupertype.kt");
        }

        @TestMetadata("someOverridesTest.kt")
        public void testSomeOverridesTest() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/someOverridesTest.kt");
        }

        @TestMetadata("superCallWithDelegation.kt")
        public void testSuperCallWithDelegation() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/superCallWithDelegation.kt");
        }

        @TestMetadata("superIsNotAnExpression.kt")
        public void testSuperIsNotAnExpression() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/superIsNotAnExpression.kt");
        }

        @TestMetadata("superNotAvailable.kt")
        public void testSuperNotAvailable() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/superNotAvailable.kt");
        }

        @TestMetadata("superclassNotAccessibleFromInterface.kt")
        public void testSuperclassNotAccessibleFromInterface() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/superclassNotAccessibleFromInterface.kt");
        }

        @TestMetadata("supertypeInitializedInInterface.kt")
        public void testSupertypeInitializedInInterface() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/supertypeInitializedInInterface.kt");
        }

        @TestMetadata("supertypeInitializedWithoutPrimaryConstructor.kt")
        public void testSupertypeInitializedWithoutPrimaryConstructor() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/supertypeInitializedWithoutPrimaryConstructor.kt");
        }

        @TestMetadata("testIllegalAnnotationClass.kt")
        public void testTestIllegalAnnotationClass() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/testIllegalAnnotationClass.kt");
        }

        @TestMetadata("typeArgumentsNotAllowed.kt")
        public void testTypeArgumentsNotAllowed() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/typeArgumentsNotAllowed.kt");
        }

        @TestMetadata("typeOfAnnotationMember.kt")
        public void testTypeOfAnnotationMember() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/typeOfAnnotationMember.kt");
        }

        @TestMetadata("typeParametersInEnum.kt")
        public void testTypeParametersInEnum() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/typeParametersInEnum.kt");
        }

        @TestMetadata("typeParametersInObject.kt")
        public void testTypeParametersInObject() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/typeParametersInObject.kt");
        }

        @TestMetadata("upperBoundViolated.kt")
        public void testUpperBoundViolated() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/upperBoundViolated.kt");
        }

        @TestMetadata("valOnAnnotationParameter.kt")
        public void testValOnAnnotationParameter() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/valOnAnnotationParameter.kt");
        }

        @TestMetadata("compiler/fir/analysis-tests/testData/resolve/diagnostics/functionAsExpression")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class FunctionAsExpression extends AbstractLazyBodyIsNotTouchedTilContractsPhaseTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
            }

            public void testAllFilesPresentInFunctionAsExpression() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/diagnostics/functionAsExpression"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
            }

            @TestMetadata("Parameters.kt")
            public void testParameters() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/functionAsExpression/Parameters.kt");
            }
        }
    }

    @TestMetadata("compiler/fir/analysis-tests/testData/resolve/exhaustiveness")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Exhaustiveness extends AbstractLazyBodyIsNotTouchedTilContractsPhaseTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
        }

        public void testAllFilesPresentInExhaustiveness() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/exhaustiveness"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
        }

        @TestMetadata("compiler/fir/analysis-tests/testData/resolve/exhaustiveness/negative")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Negative extends AbstractLazyBodyIsNotTouchedTilContractsPhaseTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
            }

            public void testAllFilesPresentInNegative() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/exhaustiveness/negative"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
            }

            @TestMetadata("missingBooleanBranch.kt")
            public void testMissingBooleanBranch() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/exhaustiveness/negative/missingBooleanBranch.kt");
            }

            @TestMetadata("missingElse.kt")
            public void testMissingElse() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/exhaustiveness/negative/missingElse.kt");
            }

            @TestMetadata("missingEnumEntry.kt")
            public void testMissingEnumEntry() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/exhaustiveness/negative/missingEnumEntry.kt");
            }

            @TestMetadata("missingSealedInheritor.kt")
            public void testMissingSealedInheritor() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/exhaustiveness/negative/missingSealedInheritor.kt");
            }

            @TestMetadata("nonExhaustiveWhenWithoutCoercionToUnit.kt")
            public void testNonExhaustiveWhenWithoutCoercionToUnit() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/exhaustiveness/negative/nonExhaustiveWhenWithoutCoercionToUnit.kt");
            }
        }

        @TestMetadata("compiler/fir/analysis-tests/testData/resolve/exhaustiveness/positive")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Positive extends AbstractLazyBodyIsNotTouchedTilContractsPhaseTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
            }

            public void testAllFilesPresentInPositive() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/exhaustiveness/positive"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
            }

            @TestMetadata("exhaustiveWhenAndDNNType.kt")
            public void testExhaustiveWhenAndDNNType() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/exhaustiveness/positive/exhaustiveWhenAndDNNType.kt");
            }

            @TestMetadata("exhaustiveWhenAndFlexibleType.kt")
            public void testExhaustiveWhenAndFlexibleType() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/exhaustiveness/positive/exhaustiveWhenAndFlexibleType.kt");
            }

            @TestMetadata("exhaustiveness_boolean.kt")
            public void testExhaustiveness_boolean() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/exhaustiveness/positive/exhaustiveness_boolean.kt");
            }

            @TestMetadata("exhaustiveness_enum.kt")
            public void testExhaustiveness_enum() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/exhaustiveness/positive/exhaustiveness_enum.kt");
            }

            @TestMetadata("exhaustiveness_enumJava.kt")
            public void testExhaustiveness_enumJava() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/exhaustiveness/positive/exhaustiveness_enumJava.kt");
            }

            @TestMetadata("exhaustiveness_sealedClass.kt")
            public void testExhaustiveness_sealedClass() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/exhaustiveness/positive/exhaustiveness_sealedClass.kt");
            }

            @TestMetadata("exhaustiveness_sealedObject.kt")
            public void testExhaustiveness_sealedObject() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/exhaustiveness/positive/exhaustiveness_sealedObject.kt");
            }

            @TestMetadata("exhaustiveness_sealedSubClass.kt")
            public void testExhaustiveness_sealedSubClass() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/exhaustiveness/positive/exhaustiveness_sealedSubClass.kt");
            }

            @TestMetadata("nestedIfInLambda.kt")
            public void testNestedIfInLambda() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/exhaustiveness/positive/nestedIfInLambda.kt");
            }

            @TestMetadata("nonExhaustiveWhenWithCoercionToUnit.kt")
            public void testNonExhaustiveWhenWithCoercionToUnit() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/exhaustiveness/positive/nonExhaustiveWhenWithCoercionToUnit.kt");
            }
        }
    }

    @TestMetadata("compiler/fir/analysis-tests/testData/resolve/expresssions")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Expresssions extends AbstractLazyBodyIsNotTouchedTilContractsPhaseTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
        }

        @TestMetadata("access.kt")
        public void testAccess() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/access.kt");
        }

        public void testAllFilesPresentInExpresssions() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/expresssions"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
        }

        @TestMetadata("annotationWithReturn.kt")
        public void testAnnotationWithReturn() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/annotationWithReturn.kt");
        }

        @TestMetadata("annotations.kt")
        public void testAnnotations() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/annotations.kt");
        }

        @TestMetadata("baseQualifier.kt")
        public void testBaseQualifier() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/baseQualifier.kt");
        }

        @TestMetadata("blockLocalScopes.kt")
        public void testBlockLocalScopes() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/blockLocalScopes.kt");
        }

        @TestMetadata("CallBasedInExpressionGenerator.kt")
        public void testCallBasedInExpressionGenerator() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/CallBasedInExpressionGenerator.kt");
        }

        @TestMetadata("checkArguments.kt")
        public void testCheckArguments() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/checkArguments.kt");
        }

        @TestMetadata("classifierAccessFromCompanion.kt")
        public void testClassifierAccessFromCompanion() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/classifierAccessFromCompanion.kt");
        }

        @TestMetadata("companion.kt")
        public void testCompanion() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/companion.kt");
        }

        @TestMetadata("companionExtension.kt")
        public void testCompanionExtension() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/companionExtension.kt");
        }

        @TestMetadata("constructor.kt")
        public void testConstructor() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/constructor.kt");
        }

        @TestMetadata("dispatchReceiver.kt")
        public void testDispatchReceiver() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/dispatchReceiver.kt");
        }

        @TestMetadata("enumEntryUse.kt")
        public void testEnumEntryUse() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/enumEntryUse.kt");
        }

        @TestMetadata("enumValues.kt")
        public void testEnumValues() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/enumValues.kt");
        }

        @TestMetadata("errCallable.kt")
        public void testErrCallable() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/errCallable.kt");
        }

        @TestMetadata("extensionPropertyInLambda.kt")
        public void testExtensionPropertyInLambda() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/extensionPropertyInLambda.kt");
        }

        @TestMetadata("genericDecorator.kt")
        public void testGenericDecorator() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/genericDecorator.kt");
        }

        @TestMetadata("genericDescriptor.kt")
        public void testGenericDescriptor() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/genericDescriptor.kt");
        }

        @TestMetadata("genericDiagnostic.kt")
        public void testGenericDiagnostic() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/genericDiagnostic.kt");
        }

        @TestMetadata("genericPropertyAccess.kt")
        public void testGenericPropertyAccess() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/genericPropertyAccess.kt");
        }

        @TestMetadata("genericUsedInFunction.kt")
        public void testGenericUsedInFunction() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/genericUsedInFunction.kt");
        }

        @TestMetadata("importedReceiver.kt")
        public void testImportedReceiver() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/importedReceiver.kt");
        }

        @TestMetadata("innerQualifier.kt")
        public void testInnerQualifier() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/innerQualifier.kt");
        }

        @TestMetadata("innerWithSuperCompanion.kt")
        public void testInnerWithSuperCompanion() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/innerWithSuperCompanion.kt");
        }

        @TestMetadata("javaFieldCallable.kt")
        public void testJavaFieldCallable() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/javaFieldCallable.kt");
        }

        @TestMetadata("lambda.kt")
        public void testLambda() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/lambda.kt");
        }

        @TestMetadata("lambdaWithReceiver.kt")
        public void testLambdaWithReceiver() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/lambdaWithReceiver.kt");
        }

        @TestMetadata("localClassAccessesContainingClass.kt")
        public void testLocalClassAccessesContainingClass() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/localClassAccessesContainingClass.kt");
        }

        @TestMetadata("localConstructor.kt")
        public void testLocalConstructor() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/localConstructor.kt");
        }

        @TestMetadata("localExtension.kt")
        public void testLocalExtension() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/localExtension.kt");
        }

        @TestMetadata("localImplicitBodies.kt")
        public void testLocalImplicitBodies() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/localImplicitBodies.kt");
        }

        @TestMetadata("localInnerClass.kt")
        public void testLocalInnerClass() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/localInnerClass.kt");
        }

        @TestMetadata("localObjects.kt")
        public void testLocalObjects() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/localObjects.kt");
        }

        @TestMetadata("localScopes.kt")
        public void testLocalScopes() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/localScopes.kt");
        }

        @TestMetadata("localTypes.kt")
        public void testLocalTypes() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/localTypes.kt");
        }

        @TestMetadata("localWithBooleanNot.kt")
        public void testLocalWithBooleanNot() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/localWithBooleanNot.kt");
        }

        @TestMetadata("memberExtension.kt")
        public void testMemberExtension() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/memberExtension.kt");
        }

        @TestMetadata("nestedConstructorCallable.kt")
        public void testNestedConstructorCallable() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/nestedConstructorCallable.kt");
        }

        @TestMetadata("nestedObjects.kt")
        public void testNestedObjects() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/nestedObjects.kt");
        }

        @TestMetadata("nestedVisibility.kt")
        public void testNestedVisibility() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/nestedVisibility.kt");
        }

        @TestMetadata("objectOverrideCallViaImport.kt")
        public void testObjectOverrideCallViaImport() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/objectOverrideCallViaImport.kt");
        }

        @TestMetadata("objectVsProperty.kt")
        public void testObjectVsProperty() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/objectVsProperty.kt");
        }

        @TestMetadata("objects.kt")
        public void testObjects() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/objects.kt");
        }

        @TestMetadata("outerMemberAccesses.kt")
        public void testOuterMemberAccesses() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/outerMemberAccesses.kt");
        }

        @TestMetadata("outerObject.kt")
        public void testOuterObject() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/outerObject.kt");
        }

        @TestMetadata("overriddenJavaGetter.kt")
        public void testOverriddenJavaGetter() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/overriddenJavaGetter.kt");
        }

        @TestMetadata("privateObjectLiteral.kt")
        public void testPrivateObjectLiteral() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/privateObjectLiteral.kt");
        }

        @TestMetadata("privateVisibility.kt")
        public void testPrivateVisibility() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/privateVisibility.kt");
        }

        @TestMetadata("protectedVisibility.kt")
        public void testProtectedVisibility() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/protectedVisibility.kt");
        }

        @TestMetadata("qualifiedExpressions.kt")
        public void testQualifiedExpressions() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/qualifiedExpressions.kt");
        }

        @TestMetadata("qualifierPriority.kt")
        public void testQualifierPriority() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/qualifierPriority.kt");
        }

        @TestMetadata("receiverConsistency.kt")
        public void testReceiverConsistency() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/receiverConsistency.kt");
        }

        @TestMetadata("sameReceiver.kt")
        public void testSameReceiver() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/sameReceiver.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/simple.kt");
        }

        @TestMetadata("syntheticInImplicitBody.kt")
        public void testSyntheticInImplicitBody() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/syntheticInImplicitBody.kt");
        }

        @TestMetadata("syntheticSmartCast.kt")
        public void testSyntheticSmartCast() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/syntheticSmartCast.kt");
        }

        @TestMetadata("this.kt")
        public void testThis() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/this.kt");
        }

        @TestMetadata("topExtensionVsOuterMember.kt")
        public void testTopExtensionVsOuterMember() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/topExtensionVsOuterMember.kt");
        }

        @TestMetadata("typeAliasConstructor.kt")
        public void testTypeAliasConstructor() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/typeAliasConstructor.kt");
        }

        @TestMetadata("vararg.kt")
        public void testVararg() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/vararg.kt");
        }

        @TestMetadata("when.kt")
        public void testWhen() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/when.kt");
        }

        @TestMetadata("compiler/fir/analysis-tests/testData/resolve/expresssions/inference")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Inference extends AbstractLazyBodyIsNotTouchedTilContractsPhaseTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
            }

            public void testAllFilesPresentInInference() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/expresssions/inference"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
            }

            @TestMetadata("id.kt")
            public void testId() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/inference/id.kt");
            }

            @TestMetadata("typeParameters.kt")
            public void testTypeParameters() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/inference/typeParameters.kt");
            }

            @TestMetadata("typeParameters2.kt")
            public void testTypeParameters2() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/inference/typeParameters2.kt");
            }
        }

        @TestMetadata("compiler/fir/analysis-tests/testData/resolve/expresssions/invoke")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Invoke extends AbstractLazyBodyIsNotTouchedTilContractsPhaseTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
            }

            public void testAllFilesPresentInInvoke() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/expresssions/invoke"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
            }

            @TestMetadata("doubleBrackets.kt")
            public void testDoubleBrackets() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/invoke/doubleBrackets.kt");
            }

            @TestMetadata("explicitReceiver.kt")
            public void testExplicitReceiver() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/invoke/explicitReceiver.kt");
            }

            @TestMetadata("explicitReceiver2.kt")
            public void testExplicitReceiver2() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/invoke/explicitReceiver2.kt");
            }

            @TestMetadata("extension.kt")
            public void testExtension() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/invoke/extension.kt");
            }

            @TestMetadata("extensionOnObject.kt")
            public void testExtensionOnObject() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/invoke/extensionOnObject.kt");
            }

            @TestMetadata("extensionSafeCall.kt")
            public void testExtensionSafeCall() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/invoke/extensionSafeCall.kt");
            }

            @TestMetadata("farInvokeExtension.kt")
            public void testFarInvokeExtension() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/invoke/farInvokeExtension.kt");
            }

            @TestMetadata("implicitTypeOrder.kt")
            public void testImplicitTypeOrder() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/invoke/implicitTypeOrder.kt");
            }

            @TestMetadata("inBrackets.kt")
            public void testInBrackets() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/invoke/inBrackets.kt");
            }

            @TestMetadata("incorrectInvokeReceiver.kt")
            public void testIncorrectInvokeReceiver() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/invoke/incorrectInvokeReceiver.kt");
            }

            @TestMetadata("propertyFromParameter.kt")
            public void testPropertyFromParameter() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/invoke/propertyFromParameter.kt");
            }

            @TestMetadata("propertyWithExtensionType.kt")
            public void testPropertyWithExtensionType() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/invoke/propertyWithExtensionType.kt");
            }

            @TestMetadata("simple.kt")
            public void testSimple() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/invoke/simple.kt");
            }

            @TestMetadata("threeReceivers.kt")
            public void testThreeReceivers() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/invoke/threeReceivers.kt");
            }

            @TestMetadata("threeReceiversCorrect.kt")
            public void testThreeReceiversCorrect() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/invoke/threeReceiversCorrect.kt");
            }
        }

        @TestMetadata("compiler/fir/analysis-tests/testData/resolve/expresssions/operators")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Operators extends AbstractLazyBodyIsNotTouchedTilContractsPhaseTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
            }

            public void testAllFilesPresentInOperators() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/expresssions/operators"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
            }

            @TestMetadata("plus.kt")
            public void testPlus() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/operators/plus.kt");
            }

            @TestMetadata("plusAndPlusAssign.kt")
            public void testPlusAndPlusAssign() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/operators/plusAndPlusAssign.kt");
            }

            @TestMetadata("plusAssign.kt")
            public void testPlusAssign() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/operators/plusAssign.kt");
            }
        }
    }

    @TestMetadata("compiler/fir/analysis-tests/testData/resolve/extendedCheckers")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ExtendedCheckers extends AbstractLazyBodyIsNotTouchedTilContractsPhaseTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
        }

        public void testAllFilesPresentInExtendedCheckers() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/extendedCheckers"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
        }

        @TestMetadata("ArrayEqualityCanBeReplacedWithEquals.kt")
        public void testArrayEqualityCanBeReplacedWithEquals() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/ArrayEqualityCanBeReplacedWithEquals.kt");
        }

        @TestMetadata("CanBeValChecker.kt")
        public void testCanBeValChecker() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/CanBeValChecker.kt");
        }

        @TestMetadata("RedundantExplicitTypeChecker.kt")
        public void testRedundantExplicitTypeChecker() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/RedundantExplicitTypeChecker.kt");
        }

        @TestMetadata("RedundantModalityModifierChecker.kt")
        public void testRedundantModalityModifierChecker() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/RedundantModalityModifierChecker.kt");
        }

        @TestMetadata("RedundantReturnUnitTypeChecker.kt")
        public void testRedundantReturnUnitTypeChecker() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/RedundantReturnUnitTypeChecker.kt");
        }

        @TestMetadata("RedundantSetterParameterTypeChecker.kt")
        public void testRedundantSetterParameterTypeChecker() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/RedundantSetterParameterTypeChecker.kt");
        }

        @TestMetadata("RedundantSingleExpressionStringTemplateChecker.kt")
        public void testRedundantSingleExpressionStringTemplateChecker() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/RedundantSingleExpressionStringTemplateChecker.kt");
        }

        @TestMetadata("RedundantVisibilityDueToOverride.kt")
        public void testRedundantVisibilityDueToOverride() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/RedundantVisibilityDueToOverride.kt");
        }

        @TestMetadata("RedundantVisibilityModifierChecker.kt")
        public void testRedundantVisibilityModifierChecker() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/RedundantVisibilityModifierChecker.kt");
        }

        @TestMetadata("RedundantVisibilityModifierCheckerForInnerComponents.kt")
        public void testRedundantVisibilityModifierCheckerForInnerComponents() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/RedundantVisibilityModifierCheckerForInnerComponents.kt");
        }

        @TestMetadata("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/canBeReplacedWithOperatorAssignment")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class CanBeReplacedWithOperatorAssignment extends AbstractLazyBodyIsNotTouchedTilContractsPhaseTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
            }

            public void testAllFilesPresentInCanBeReplacedWithOperatorAssignment() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/canBeReplacedWithOperatorAssignment"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
            }

            @TestMetadata("BasicTest.kt")
            public void testBasicTest() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/canBeReplacedWithOperatorAssignment/BasicTest.kt");
            }

            @TestMetadata("ComplexExpression.kt")
            public void testComplexExpression() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/canBeReplacedWithOperatorAssignment/ComplexExpression.kt");
            }

            @TestMetadata("flexibleTypeBug.kt")
            public void testFlexibleTypeBug() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/canBeReplacedWithOperatorAssignment/flexibleTypeBug.kt");
            }

            @TestMetadata("illegalMultipleOperators.kt")
            public void testIllegalMultipleOperators() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/canBeReplacedWithOperatorAssignment/illegalMultipleOperators.kt");
            }

            @TestMetadata("illegalMultipleOperatorsMiddle.kt")
            public void testIllegalMultipleOperatorsMiddle() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/canBeReplacedWithOperatorAssignment/illegalMultipleOperatorsMiddle.kt");
            }

            @TestMetadata("invalidSubtraction.kt")
            public void testInvalidSubtraction() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/canBeReplacedWithOperatorAssignment/invalidSubtraction.kt");
            }

            @TestMetadata("list.kt")
            public void testList() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/canBeReplacedWithOperatorAssignment/list.kt");
            }

            @TestMetadata("logicOperators.kt")
            public void testLogicOperators() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/canBeReplacedWithOperatorAssignment/logicOperators.kt");
            }

            @TestMetadata("multipleOperators.kt")
            public void testMultipleOperators() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/canBeReplacedWithOperatorAssignment/multipleOperators.kt");
            }

            @TestMetadata("multipleOperatorsRightSideRepeat.kt")
            public void testMultipleOperatorsRightSideRepeat() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/canBeReplacedWithOperatorAssignment/multipleOperatorsRightSideRepeat.kt");
            }

            @TestMetadata("mutableList.kt")
            public void testMutableList() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/canBeReplacedWithOperatorAssignment/mutableList.kt");
            }

            @TestMetadata("nonCommutativeRepeat.kt")
            public void testNonCommutativeRepeat() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/canBeReplacedWithOperatorAssignment/nonCommutativeRepeat.kt");
            }

            @TestMetadata("nonRepeatingAssignment.kt")
            public void testNonRepeatingAssignment() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/canBeReplacedWithOperatorAssignment/nonRepeatingAssignment.kt");
            }

            @TestMetadata("OperatorAssignment.kt")
            public void testOperatorAssignment() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/canBeReplacedWithOperatorAssignment/OperatorAssignment.kt");
            }

            @TestMetadata("plusAssignConflict.kt")
            public void testPlusAssignConflict() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/canBeReplacedWithOperatorAssignment/plusAssignConflict.kt");
            }

            @TestMetadata("rightSideRepeat.kt")
            public void testRightSideRepeat() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/canBeReplacedWithOperatorAssignment/rightSideRepeat.kt");
            }

            @TestMetadata("simpleAssign.kt")
            public void testSimpleAssign() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/canBeReplacedWithOperatorAssignment/simpleAssign.kt");
            }

            @TestMetadata("validAddition.kt")
            public void testValidAddition() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/canBeReplacedWithOperatorAssignment/validAddition.kt");
            }

            @TestMetadata("validSubtraction.kt")
            public void testValidSubtraction() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/canBeReplacedWithOperatorAssignment/validSubtraction.kt");
            }
        }

        @TestMetadata("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/emptyRangeChecker")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class EmptyRangeChecker extends AbstractLazyBodyIsNotTouchedTilContractsPhaseTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
            }

            public void testAllFilesPresentInEmptyRangeChecker() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/emptyRangeChecker"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
            }

            @TestMetadata("NoWarning.kt")
            public void testNoWarning() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/emptyRangeChecker/NoWarning.kt");
            }

            @TestMetadata("Warning.kt")
            public void testWarning() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/emptyRangeChecker/Warning.kt");
            }
        }

        @TestMetadata("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/RedundantCallOfConversionMethod")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class RedundantCallOfConversionMethod extends AbstractLazyBodyIsNotTouchedTilContractsPhaseTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
            }

            public void testAllFilesPresentInRedundantCallOfConversionMethod() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/RedundantCallOfConversionMethod"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
            }

            @TestMetadata("booleanToInt.kt")
            public void testBooleanToInt() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/RedundantCallOfConversionMethod/booleanToInt.kt");
            }

            @TestMetadata("byte.kt")
            public void testByte() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/RedundantCallOfConversionMethod/byte.kt");
            }

            @TestMetadata("char.kt")
            public void testChar() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/RedundantCallOfConversionMethod/char.kt");
            }

            @TestMetadata("double.kt")
            public void testDouble() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/RedundantCallOfConversionMethod/double.kt");
            }

            @TestMetadata("float.kt")
            public void testFloat() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/RedundantCallOfConversionMethod/float.kt");
            }

            @TestMetadata("int.kt")
            public void testInt() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/RedundantCallOfConversionMethod/int.kt");
            }

            @TestMetadata("long.kt")
            public void testLong() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/RedundantCallOfConversionMethod/long.kt");
            }

            @TestMetadata("nullable.kt")
            public void testNullable() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/RedundantCallOfConversionMethod/nullable.kt");
            }

            @TestMetadata("nullable2.kt")
            public void testNullable2() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/RedundantCallOfConversionMethod/nullable2.kt");
            }

            @TestMetadata("safeString.kt")
            public void testSafeString() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/RedundantCallOfConversionMethod/safeString.kt");
            }

            @TestMetadata("safeString2.kt")
            public void testSafeString2() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/RedundantCallOfConversionMethod/safeString2.kt");
            }

            @TestMetadata("short.kt")
            public void testShort() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/RedundantCallOfConversionMethod/short.kt");
            }

            @TestMetadata("string.kt")
            public void testString() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/RedundantCallOfConversionMethod/string.kt");
            }

            @TestMetadata("StringTemplate.kt")
            public void testStringTemplate() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/RedundantCallOfConversionMethod/StringTemplate.kt");
            }

            @TestMetadata("toOtherType.kt")
            public void testToOtherType() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/RedundantCallOfConversionMethod/toOtherType.kt");
            }

            @TestMetadata("uByte.kt")
            public void testUByte() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/RedundantCallOfConversionMethod/uByte.kt");
            }

            @TestMetadata("uInt.kt")
            public void testUInt() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/RedundantCallOfConversionMethod/uInt.kt");
            }

            @TestMetadata("uLong.kt")
            public void testULong() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/RedundantCallOfConversionMethod/uLong.kt");
            }

            @TestMetadata("uShort.kt")
            public void testUShort() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/RedundantCallOfConversionMethod/uShort.kt");
            }

            @TestMetadata("variable.kt")
            public void testVariable() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/RedundantCallOfConversionMethod/variable.kt");
            }
        }

        @TestMetadata("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/unused")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Unused extends AbstractLazyBodyIsNotTouchedTilContractsPhaseTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
            }

            public void testAllFilesPresentInUnused() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/unused"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
            }

            @TestMetadata("classProperty.kt")
            public void testClassProperty() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/unused/classProperty.kt");
            }

            @TestMetadata("invoke.kt")
            public void testInvoke() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/unused/invoke.kt");
            }

            @TestMetadata("lambda.kt")
            public void testLambda() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/unused/lambda.kt");
            }

            @TestMetadata("localVariable.kt")
            public void testLocalVariable() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/unused/localVariable.kt");
            }

            @TestMetadata("manyLocalVariables.kt")
            public void testManyLocalVariables() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/unused/manyLocalVariables.kt");
            }

            @TestMetadata("usedInAnnotationArguments.kt")
            public void testUsedInAnnotationArguments() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/unused/usedInAnnotationArguments.kt");
            }

            @TestMetadata("valueIsNeverRead.kt")
            public void testValueIsNeverRead() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/unused/valueIsNeverRead.kt");
            }
        }

        @TestMetadata("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/UselessCallOnNotNullChecker")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class UselessCallOnNotNullChecker extends AbstractLazyBodyIsNotTouchedTilContractsPhaseTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
            }

            public void testAllFilesPresentInUselessCallOnNotNullChecker() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/UselessCallOnNotNullChecker"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
            }

            @TestMetadata("Basic.kt")
            public void testBasic() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/UselessCallOnNotNullChecker/Basic.kt");
            }

            @TestMetadata("NotNullType.kt")
            public void testNotNullType() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/UselessCallOnNotNullChecker/NotNullType.kt");
            }

            @TestMetadata("NotNullTypeChain.kt")
            public void testNotNullTypeChain() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/UselessCallOnNotNullChecker/NotNullTypeChain.kt");
            }

            @TestMetadata("NullOrBlankSafe.kt")
            public void testNullOrBlankSafe() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/UselessCallOnNotNullChecker/NullOrBlankSafe.kt");
            }

            @TestMetadata("NullOrEmpty.kt")
            public void testNullOrEmpty() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/UselessCallOnNotNullChecker/NullOrEmpty.kt");
            }

            @TestMetadata("NullOrEmptyFake.kt")
            public void testNullOrEmptyFake() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/UselessCallOnNotNullChecker/NullOrEmptyFake.kt");
            }

            @TestMetadata("NullOrEmptySafe.kt")
            public void testNullOrEmptySafe() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/UselessCallOnNotNullChecker/NullOrEmptySafe.kt");
            }

            @TestMetadata("OrEmptyFake.kt")
            public void testOrEmptyFake() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/UselessCallOnNotNullChecker/OrEmptyFake.kt");
            }

            @TestMetadata("SafeCall.kt")
            public void testSafeCall() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/UselessCallOnNotNullChecker/SafeCall.kt");
            }

            @TestMetadata("Sequence.kt")
            public void testSequence() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/UselessCallOnNotNullChecker/Sequence.kt");
            }

            @TestMetadata("String.kt")
            public void testString() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/UselessCallOnNotNullChecker/String.kt");
            }
        }
    }

    @TestMetadata("compiler/fir/analysis-tests/testData/resolve/fromBuilder")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class FromBuilder extends AbstractLazyBodyIsNotTouchedTilContractsPhaseTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
        }

        public void testAllFilesPresentInFromBuilder() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/fromBuilder"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
        }

        @TestMetadata("complexTypes.kt")
        public void testComplexTypes() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/fromBuilder/complexTypes.kt");
        }

        @TestMetadata("enums.kt")
        public void testEnums() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/fromBuilder/enums.kt");
        }

        @TestMetadata("noPrimaryConstructor.kt")
        public void testNoPrimaryConstructor() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/fromBuilder/noPrimaryConstructor.kt");
        }

        @TestMetadata("simpleClass.kt")
        public void testSimpleClass() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/fromBuilder/simpleClass.kt");
        }

        @TestMetadata("typeParameters.kt")
        public void testTypeParameters() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/fromBuilder/typeParameters.kt");
        }
    }

    @TestMetadata("compiler/fir/analysis-tests/testData/resolve/inference")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Inference extends AbstractLazyBodyIsNotTouchedTilContractsPhaseTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
        }

        public void testAllFilesPresentInInference() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/inference"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
        }

        @TestMetadata("callableReferenceOnInstance.kt")
        public void testCallableReferenceOnInstance() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/inference/callableReferenceOnInstance.kt");
        }

        @TestMetadata("callableReferenceToLocalClass.kt")
        public void testCallableReferenceToLocalClass() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/inference/callableReferenceToLocalClass.kt");
        }

        @TestMetadata("callableReferencesAndDefaultParameters.kt")
        public void testCallableReferencesAndDefaultParameters() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/inference/callableReferencesAndDefaultParameters.kt");
        }

        @TestMetadata("capturedTypeForJavaTypeParameter.kt")
        public void testCapturedTypeForJavaTypeParameter() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/inference/capturedTypeForJavaTypeParameter.kt");
        }

        @TestMetadata("coercionToUnitWithEarlyReturn.kt")
        public void testCoercionToUnitWithEarlyReturn() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/inference/coercionToUnitWithEarlyReturn.kt");
        }

        @TestMetadata("definitelyNotNullIntersectionType.kt")
        public void testDefinitelyNotNullIntersectionType() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/inference/definitelyNotNullIntersectionType.kt");
        }

        @TestMetadata("dnnThrowJavaCall.kt")
        public void testDnnThrowJavaCall() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/inference/dnnThrowJavaCall.kt");
        }

        @TestMetadata("elvisAndUnit.kt")
        public void testElvisAndUnit() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/inference/elvisAndUnit.kt");
        }

        @TestMetadata("equals.kt")
        public void testEquals() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/inference/equals.kt");
        }

        @TestMetadata("extensionCallableReferences.kt")
        public void testExtensionCallableReferences() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/inference/extensionCallableReferences.kt");
        }

        @TestMetadata("integerLiteralAsComparable.kt")
        public void testIntegerLiteralAsComparable() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/inference/integerLiteralAsComparable.kt");
        }

        @TestMetadata("intersectionTypesInConstraints.kt")
        public void testIntersectionTypesInConstraints() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/inference/intersectionTypesInConstraints.kt");
        }

        @TestMetadata("kt40131.kt")
        public void testKt40131() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/inference/kt40131.kt");
        }

        @TestMetadata("kt41989.kt")
        public void testKt41989() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/inference/kt41989.kt");
        }

        @TestMetadata("lambdaAsReturnStatementOfLambda.kt")
        public void testLambdaAsReturnStatementOfLambda() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/inference/lambdaAsReturnStatementOfLambda.kt");
        }

        @TestMetadata("lambdaInElvis.kt")
        public void testLambdaInElvis() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/inference/lambdaInElvis.kt");
        }

        @TestMetadata("lambdaWithoutExpectedType.kt")
        public void testLambdaWithoutExpectedType() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/inference/lambdaWithoutExpectedType.kt");
        }

        @TestMetadata("lambdasReturns.kt")
        public void testLambdasReturns() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/inference/lambdasReturns.kt");
        }

        @TestMetadata("nestedExtensionFunctionType.kt")
        public void testNestedExtensionFunctionType() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/inference/nestedExtensionFunctionType.kt");
        }

        @TestMetadata("nestedLambdas.kt")
        public void testNestedLambdas() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/inference/nestedLambdas.kt");
        }

        @TestMetadata("nullableIntegerLiteralType.kt")
        public void testNullableIntegerLiteralType() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/inference/nullableIntegerLiteralType.kt");
        }

        @TestMetadata("receiverWithCapturedType.kt")
        public void testReceiverWithCapturedType() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/inference/receiverWithCapturedType.kt");
        }

        @TestMetadata("simpleCapturedTypes.kt")
        public void testSimpleCapturedTypes() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/inference/simpleCapturedTypes.kt");
        }

        @TestMetadata("typeDepthForTypeAlias.kt")
        public void testTypeDepthForTypeAlias() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/inference/typeDepthForTypeAlias.kt");
        }

        @TestMetadata("unitUpperBound.kt")
        public void testUnitUpperBound() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/inference/unitUpperBound.kt");
        }
    }

    @TestMetadata("compiler/fir/analysis-tests/testData/resolve/inlineClasses")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class InlineClasses extends AbstractLazyBodyIsNotTouchedTilContractsPhaseTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
        }

        public void testAllFilesPresentInInlineClasses() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/inlineClasses"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
        }

        @TestMetadata("inlineClassConstructor.kt")
        public void testInlineClassConstructor() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/inlineClasses/inlineClassConstructor.kt");
        }

        @TestMetadata("inlineClassDeclaration.kt")
        public void testInlineClassDeclaration() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/inlineClasses/inlineClassDeclaration.kt");
        }

        @TestMetadata("inlineClassMembers.kt")
        public void testInlineClassMembers() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/inlineClasses/inlineClassMembers.kt");
        }
    }

    @TestMetadata("compiler/fir/analysis-tests/testData/resolve/innerClasses")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class InnerClasses extends AbstractLazyBodyIsNotTouchedTilContractsPhaseTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
        }

        public void testAllFilesPresentInInnerClasses() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/innerClasses"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
        }

        @TestMetadata("inner.kt")
        public void testInner() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/innerClasses/inner.kt");
        }

        @TestMetadata("innerTypeFromSuperClassInBody.kt")
        public void testInnerTypeFromSuperClassInBody() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/innerClasses/innerTypeFromSuperClassInBody.kt");
        }

        @TestMetadata("innerTypes.kt")
        public void testInnerTypes() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/innerClasses/innerTypes.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/innerClasses/simple.kt");
        }
    }

    @TestMetadata("compiler/fir/analysis-tests/testData/resolve/localClasses")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class LocalClasses extends AbstractLazyBodyIsNotTouchedTilContractsPhaseTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
        }

        public void testAllFilesPresentInLocalClasses() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/localClasses"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
        }

        @TestMetadata("anonymousInAnonymous.kt")
        public void testAnonymousInAnonymous() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/localClasses/anonymousInAnonymous.kt");
        }

        @TestMetadata("implicitInAnonymous.kt")
        public void testImplicitInAnonymous() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/localClasses/implicitInAnonymous.kt");
        }

        @TestMetadata("implicitInLocalClasses.kt")
        public void testImplicitInLocalClasses() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/localClasses/implicitInLocalClasses.kt");
        }

        @TestMetadata("typesFromSuperClasses.kt")
        public void testTypesFromSuperClasses() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/localClasses/typesFromSuperClasses.kt");
        }
    }

    @TestMetadata("compiler/fir/analysis-tests/testData/resolve/multifile")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Multifile extends AbstractLazyBodyIsNotTouchedTilContractsPhaseTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
        }

        public void testAllFilesPresentInMultifile() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/multifile"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
        }

        @TestMetadata("Annotations.kt")
        public void testAnnotations() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/multifile/Annotations.kt");
        }

        @TestMetadata("ByteArray.kt")
        public void testByteArray() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/multifile/ByteArray.kt");
        }

        @TestMetadata("importFromObject.kt")
        public void testImportFromObject() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/multifile/importFromObject.kt");
        }

        @TestMetadata("NestedSuperType.kt")
        public void testNestedSuperType() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/multifile/NestedSuperType.kt");
        }

        @TestMetadata("sealedStarImport.kt")
        public void testSealedStarImport() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/multifile/sealedStarImport.kt");
        }

        @TestMetadata("simpleAliasedImport.kt")
        public void testSimpleAliasedImport() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/multifile/simpleAliasedImport.kt");
        }

        @TestMetadata("simpleImport.kt")
        public void testSimpleImport() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/multifile/simpleImport.kt");
        }

        @TestMetadata("simpleImportNested.kt")
        public void testSimpleImportNested() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/multifile/simpleImportNested.kt");
        }

        @TestMetadata("simpleImportOuter.kt")
        public void testSimpleImportOuter() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/multifile/simpleImportOuter.kt");
        }

        @TestMetadata("simpleStarImport.kt")
        public void testSimpleStarImport() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/multifile/simpleStarImport.kt");
        }

        @TestMetadata("TypeAliasExpansion.kt")
        public void testTypeAliasExpansion() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/multifile/TypeAliasExpansion.kt");
        }
    }

    @TestMetadata("compiler/fir/analysis-tests/testData/resolve/overrides")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Overrides extends AbstractLazyBodyIsNotTouchedTilContractsPhaseTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
        }

        public void testAllFilesPresentInOverrides() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/overrides"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
        }

        @TestMetadata("generics.kt")
        public void testGenerics() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/overrides/generics.kt");
        }

        @TestMetadata("protobufExt.kt")
        public void testProtobufExt() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/overrides/protobufExt.kt");
        }

        @TestMetadata("sameValueParametersDifferentReceiver.kt")
        public void testSameValueParametersDifferentReceiver() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/overrides/sameValueParametersDifferentReceiver.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/overrides/simple.kt");
        }

        @TestMetadata("simpleFakeOverride.kt")
        public void testSimpleFakeOverride() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/overrides/simpleFakeOverride.kt");
        }

        @TestMetadata("simpleMostSpecific.kt")
        public void testSimpleMostSpecific() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/overrides/simpleMostSpecific.kt");
        }

        @TestMetadata("supertypeGenerics.kt")
        public void testSupertypeGenerics() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/overrides/supertypeGenerics.kt");
        }

        @TestMetadata("supertypeGenericsComplex.kt")
        public void testSupertypeGenericsComplex() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/overrides/supertypeGenericsComplex.kt");
        }

        @TestMetadata("three.kt")
        public void testThree() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/overrides/three.kt");
        }
    }

    @TestMetadata("compiler/fir/analysis-tests/testData/resolve/problems")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Problems extends AbstractLazyBodyIsNotTouchedTilContractsPhaseTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
        }

        public void testAllFilesPresentInProblems() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/problems"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
        }

        @TestMetadata("compilerPhase.kt")
        public void testCompilerPhase() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/problems/compilerPhase.kt");
        }

        @TestMetadata("complexLambdaWithTypeVariableAsExpectedType.kt")
        public void testComplexLambdaWithTypeVariableAsExpectedType() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/problems/complexLambdaWithTypeVariableAsExpectedType.kt");
        }

        @TestMetadata("defaultParametersFromDifferentScopes.kt")
        public void testDefaultParametersFromDifferentScopes() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/problems/defaultParametersFromDifferentScopes.kt");
        }

        @TestMetadata("definitelyNotNullAndOriginalType.kt")
        public void testDefinitelyNotNullAndOriginalType() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/problems/definitelyNotNullAndOriginalType.kt");
        }

        @TestMetadata("doubleGenericDiamond.kt")
        public void testDoubleGenericDiamond() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/problems/doubleGenericDiamond.kt");
        }

        @TestMetadata("emptySelectorInQualifiedExpression.kt")
        public void testEmptySelectorInQualifiedExpression() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/problems/emptySelectorInQualifiedExpression.kt");
        }

        @TestMetadata("expectConstructor.kt")
        public void testExpectConstructor() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/problems/expectConstructor.kt");
        }

        @TestMetadata("fakeTypeMismatchOnExtensionReference.kt")
        public void testFakeTypeMismatchOnExtensionReference() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/problems/fakeTypeMismatchOnExtensionReference.kt");
        }

        @TestMetadata("falseIntersection.kt")
        public void testFalseIntersection() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/problems/falseIntersection.kt");
        }

        @TestMetadata("flexibleTypeVarAgainstNull.kt")
        public void testFlexibleTypeVarAgainstNull() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/problems/flexibleTypeVarAgainstNull.kt");
        }

        @TestMetadata("inaccessibleJavaGetter.kt")
        public void testInaccessibleJavaGetter() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/problems/inaccessibleJavaGetter.kt");
        }

        @TestMetadata("innerClassHierarchy.kt")
        public void testInnerClassHierarchy() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/problems/innerClassHierarchy.kt");
        }

        @TestMetadata("javaQualifier.kt")
        public void testJavaQualifier() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/problems/javaQualifier.kt");
        }

        @TestMetadata("kt42346.kt")
        public void testKt42346() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/problems/kt42346.kt");
        }

        @TestMetadata("multipleJavaClassesInOneFile.kt")
        public void testMultipleJavaClassesInOneFile() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/problems/multipleJavaClassesInOneFile.kt");
        }

        @TestMetadata("objectDerivedFromInnerClass.kt")
        public void testObjectDerivedFromInnerClass() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/problems/objectDerivedFromInnerClass.kt");
        }

        @TestMetadata("questionableSmartCast.kt")
        public void testQuestionableSmartCast() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/problems/questionableSmartCast.kt");
        }

        @TestMetadata("recursiveNamedAnnotation.kt")
        public void testRecursiveNamedAnnotation() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/problems/recursiveNamedAnnotation.kt");
        }

        @TestMetadata("safeCallInvoke.kt")
        public void testSafeCallInvoke() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/problems/safeCallInvoke.kt");
        }

        @TestMetadata("secondaryConstructorCfg.kt")
        public void testSecondaryConstructorCfg() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/problems/secondaryConstructorCfg.kt");
        }

        @TestMetadata("symbolsAndDescriptors.kt")
        public void testSymbolsAndDescriptors() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/problems/symbolsAndDescriptors.kt");
        }

        @TestMetadata("transform.kt")
        public void testTransform() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/problems/transform.kt");
        }
    }

    @TestMetadata("compiler/fir/analysis-tests/testData/resolve/properties")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Properties extends AbstractLazyBodyIsNotTouchedTilContractsPhaseTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
        }

        public void testAllFilesPresentInProperties() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/properties"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
        }

        @TestMetadata("javaAccessorConversion.kt")
        public void testJavaAccessorConversion() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/properties/javaAccessorConversion.kt");
        }

        @TestMetadata("javaAccessorsComplex.kt")
        public void testJavaAccessorsComplex() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/properties/javaAccessorsComplex.kt");
        }

        @TestMetadata("kotlinOverridesJavaComplex.kt")
        public void testKotlinOverridesJavaComplex() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/properties/kotlinOverridesJavaComplex.kt");
        }

        @TestMetadata("noBackingFieldForExtension.kt")
        public void testNoBackingFieldForExtension() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/properties/noBackingFieldForExtension.kt");
        }

        @TestMetadata("noBackingFieldInProperty.kt")
        public void testNoBackingFieldInProperty() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/properties/noBackingFieldInProperty.kt");
        }

        @TestMetadata("syntheticPropertiesForJavaAnnotations.kt")
        public void testSyntheticPropertiesForJavaAnnotations() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/properties/syntheticPropertiesForJavaAnnotations.kt");
        }
    }

    @TestMetadata("compiler/fir/analysis-tests/testData/resolve/references")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class References extends AbstractLazyBodyIsNotTouchedTilContractsPhaseTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
        }

        public void testAllFilesPresentInReferences() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/references"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
        }

        @TestMetadata("integerLiteralInLhs.kt")
        public void testIntegerLiteralInLhs() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/references/integerLiteralInLhs.kt");
        }

        @TestMetadata("leakedImplicitType.kt")
        public void testLeakedImplicitType() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/references/leakedImplicitType.kt");
        }

        @TestMetadata("referenceToExtension.kt")
        public void testReferenceToExtension() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/references/referenceToExtension.kt");
        }

        @TestMetadata("referenceToField.kt")
        public void testReferenceToField() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/references/referenceToField.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/references/simple.kt");
        }

        @TestMetadata("superMember.kt")
        public void testSuperMember() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/references/superMember.kt");
        }
    }

    @TestMetadata("compiler/fir/analysis-tests/testData/resolve/samConstructors")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class SamConstructors extends AbstractLazyBodyIsNotTouchedTilContractsPhaseTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
        }

        public void testAllFilesPresentInSamConstructors() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/samConstructors"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
        }

        @TestMetadata("funInterfaceConstructorReference.kt")
        public void testFunInterfaceConstructorReference() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/samConstructors/funInterfaceConstructorReference.kt");
        }

        @TestMetadata("genericSam.kt")
        public void testGenericSam() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/samConstructors/genericSam.kt");
        }

        @TestMetadata("genericSamInferenceFromExpectType.kt")
        public void testGenericSamInferenceFromExpectType() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/samConstructors/genericSamInferenceFromExpectType.kt");
        }

        @TestMetadata("kotlinSam.kt")
        public void testKotlinSam() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/samConstructors/kotlinSam.kt");
        }

        @TestMetadata("realConstructorFunction.kt")
        public void testRealConstructorFunction() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/samConstructors/realConstructorFunction.kt");
        }

        @TestMetadata("runnable.kt")
        public void testRunnable() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/samConstructors/runnable.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/samConstructors/simple.kt");
        }
    }

    @TestMetadata("compiler/fir/analysis-tests/testData/resolve/samConversions")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class SamConversions extends AbstractLazyBodyIsNotTouchedTilContractsPhaseTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
        }

        public void testAllFilesPresentInSamConversions() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/samConversions"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
        }

        @TestMetadata("genericSam.kt")
        public void testGenericSam() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/samConversions/genericSam.kt");
        }

        @TestMetadata("kotlinSam.kt")
        public void testKotlinSam() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/samConversions/kotlinSam.kt");
        }

        @TestMetadata("notSamBecauseOfSupertype.kt")
        public void testNotSamBecauseOfSupertype() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/samConversions/notSamBecauseOfSupertype.kt");
        }

        @TestMetadata("runnable.kt")
        public void testRunnable() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/samConversions/runnable.kt");
        }

        @TestMetadata("samConversionInConstructorCall.kt")
        public void testSamConversionInConstructorCall() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/samConversions/samConversionInConstructorCall.kt");
        }

        @TestMetadata("samSupertype.kt")
        public void testSamSupertype() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/samConversions/samSupertype.kt");
        }

        @TestMetadata("samSupertypeWithOverride.kt")
        public void testSamSupertypeWithOverride() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/samConversions/samSupertypeWithOverride.kt");
        }

        @TestMetadata("samWithEquals.kt")
        public void testSamWithEquals() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/samConversions/samWithEquals.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/samConversions/simple.kt");
        }
    }

    @TestMetadata("compiler/fir/analysis-tests/testData/resolve/scopes")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Scopes extends AbstractLazyBodyIsNotTouchedTilContractsPhaseTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
        }

        public void testAllFilesPresentInScopes() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/scopes"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
        }

        @TestMetadata("explicitOverrideOfTwoMembers.kt")
        public void testExplicitOverrideOfTwoMembers() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/scopes/explicitOverrideOfTwoMembers.kt");
        }

        @TestMetadata("explicitOverrideOfTwoMembers_java.kt")
        public void testExplicitOverrideOfTwoMembers_java() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/scopes/explicitOverrideOfTwoMembers_java.kt");
        }

        @TestMetadata("getterOverrideAndKotlinProperty.kt")
        public void testGetterOverrideAndKotlinProperty() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/scopes/getterOverrideAndKotlinProperty.kt");
        }

        @TestMetadata("intersectionOverrideOfTwoMembers.kt")
        public void testIntersectionOverrideOfTwoMembers() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/scopes/intersectionOverrideOfTwoMembers.kt");
        }

        @TestMetadata("intersectionOverrideOfTwoMembers_java.kt")
        public void testIntersectionOverrideOfTwoMembers_java() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/scopes/intersectionOverrideOfTwoMembers_java.kt");
        }

        @TestMetadata("javaFunctionAndKotlinPropertyFromDifferentSupertypes.kt")
        public void testJavaFunctionAndKotlinPropertyFromDifferentSupertypes() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/scopes/javaFunctionAndKotlinPropertyFromDifferentSupertypes.kt");
        }

        @TestMetadata("kotlinAccessorsLikeFunctionsThrowJavaClass.kt")
        public void testKotlinAccessorsLikeFunctionsThrowJavaClass() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/scopes/kotlinAccessorsLikeFunctionsThrowJavaClass.kt");
        }

        @TestMetadata("noIntersectionOverrideOfTwoMembers.kt")
        public void testNoIntersectionOverrideOfTwoMembers() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/scopes/noIntersectionOverrideOfTwoMembers.kt");
        }

        @TestMetadata("noIntersectionOverrideOfTwoMembers_java.kt")
        public void testNoIntersectionOverrideOfTwoMembers_java() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/scopes/noIntersectionOverrideOfTwoMembers_java.kt");
        }

        @TestMetadata("publicJavaAndPrivateKotlinVar.kt")
        public void testPublicJavaAndPrivateKotlinVar() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/scopes/publicJavaAndPrivateKotlinVar.kt");
        }

        @TestMetadata("specialFunctionInJava_1.kt")
        public void testSpecialFunctionInJava_1() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/scopes/specialFunctionInJava_1.kt");
        }

        @TestMetadata("specialFunctionInJava_2.kt")
        public void testSpecialFunctionInJava_2() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/scopes/specialFunctionInJava_2.kt");
        }

        @TestMetadata("specialFunctionInJava_3.kt")
        public void testSpecialFunctionInJava_3() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/scopes/specialFunctionInJava_3.kt");
        }

        @TestMetadata("specialFunctionInJava_4.kt")
        public void testSpecialFunctionInJava_4() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/scopes/specialFunctionInJava_4.kt");
        }
    }

    @TestMetadata("compiler/fir/analysis-tests/testData/resolve/smartcasts")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Smartcasts extends AbstractLazyBodyIsNotTouchedTilContractsPhaseTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
        }

        @TestMetadata("accessToMemberAfterReceiverReassignment.kt")
        public void testAccessToMemberAfterReceiverReassignment() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/accessToMemberAfterReceiverReassignment.kt");
        }

        public void testAllFilesPresentInSmartcasts() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/smartcasts"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
        }

        @TestMetadata("bangbang.kt")
        public void testBangbang() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/bangbang.kt");
        }

        @TestMetadata("casts.kt")
        public void testCasts() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/casts.kt");
        }

        @TestMetadata("equalsAndIdentity.kt")
        public void testEqualsAndIdentity() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/equalsAndIdentity.kt");
        }

        @TestMetadata("incorrectSmartcastToNothing.kt")
        public void testIncorrectSmartcastToNothing() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/incorrectSmartcastToNothing.kt");
        }

        @TestMetadata("kt10240.kt")
        public void testKt10240() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/kt10240.kt");
        }

        @TestMetadata("kt37327.kt")
        public void testKt37327() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/kt37327.kt");
        }

        @TestMetadata("kt39000.kt")
        public void testKt39000() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/kt39000.kt");
        }

        @TestMetadata("kt50788.kt")
        public void testKt50788() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/kt50788.kt");
        }

        @TestMetadata("kt50875.kt")
        public void testKt50875() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/kt50875.kt");
        }

        @TestMetadata("literalInWhenSubject.kt")
        public void testLiteralInWhenSubject() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/literalInWhenSubject.kt");
        }

        @TestMetadata("multipleCasts.kt")
        public void testMultipleCasts() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/multipleCasts.kt");
        }

        @TestMetadata("nullability.kt")
        public void testNullability() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/nullability.kt");
        }

        @TestMetadata("orInWhenBranch.kt")
        public void testOrInWhenBranch() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/orInWhenBranch.kt");
        }

        @TestMetadata("smartCastInInit.kt")
        public void testSmartCastInInit() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/smartCastInInit.kt");
        }

        @TestMetadata("smartcastInByClause.kt")
        public void testSmartcastInByClause() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/smartcastInByClause.kt");
        }

        @TestMetadata("smartcastOnImplicitReceiverOfCallableReference.kt")
        public void testSmartcastOnImplicitReceiverOfCallableReference() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/smartcastOnImplicitReceiverOfCallableReference.kt");
        }

        @TestMetadata("smartcastToNothing.kt")
        public void testSmartcastToNothing() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/smartcastToNothing.kt");
        }

        @TestMetadata("smartcastToTypeParameter.kt")
        public void testSmartcastToTypeParameter() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/smartcastToTypeParameter.kt");
        }

        @TestMetadata("smartcastsFromEquals_differentModule.kt")
        public void testSmartcastsFromEquals_differentModule() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/smartcastsFromEquals_differentModule.kt");
        }

        @TestMetadata("smartcastsFromEquals_sameModule.kt")
        public void testSmartcastsFromEquals_sameModule() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/smartcastsFromEquals_sameModule.kt");
        }

        @TestMetadata("unstableSmartcastAndAmbiguity.kt")
        public void testUnstableSmartcastAndAmbiguity() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/unstableSmartcastAndAmbiguity.kt");
        }

        @TestMetadata("compiler/fir/analysis-tests/testData/resolve/smartcasts/booleans")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Booleans extends AbstractLazyBodyIsNotTouchedTilContractsPhaseTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
            }

            public void testAllFilesPresentInBooleans() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/smartcasts/booleans"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
            }

            @TestMetadata("booleanElvisBoundSmartcast.kt")
            public void testBooleanElvisBoundSmartcast() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/booleans/booleanElvisBoundSmartcast.kt");
            }

            @TestMetadata("booleanOperators.kt")
            public void testBooleanOperators() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/booleans/booleanOperators.kt");
            }

            @TestMetadata("equalsToBoolean.kt")
            public void testEqualsToBoolean() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/booleans/equalsToBoolean.kt");
            }

            @TestMetadata("jumpFromRhsOfOperator.kt")
            public void testJumpFromRhsOfOperator() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/booleans/jumpFromRhsOfOperator.kt");
            }
        }

        @TestMetadata("compiler/fir/analysis-tests/testData/resolve/smartcasts/boundSmartcasts")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class BoundSmartcasts extends AbstractLazyBodyIsNotTouchedTilContractsPhaseTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
            }

            public void testAllFilesPresentInBoundSmartcasts() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/smartcasts/boundSmartcasts"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
            }

            @TestMetadata("boundSmartcasts.kt")
            public void testBoundSmartcasts() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/boundSmartcasts/boundSmartcasts.kt");
            }

            @TestMetadata("boundSmartcastsInBranches.kt")
            public void testBoundSmartcastsInBranches() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/boundSmartcasts/boundSmartcastsInBranches.kt");
            }

            @TestMetadata("functionCallBound.kt")
            public void testFunctionCallBound() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/boundSmartcasts/functionCallBound.kt");
            }

            @TestMetadata("thisAssignment.kt")
            public void testThisAssignment() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/boundSmartcasts/thisAssignment.kt");
            }
        }

        @TestMetadata("compiler/fir/analysis-tests/testData/resolve/smartcasts/controlStructures")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ControlStructures extends AbstractLazyBodyIsNotTouchedTilContractsPhaseTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
            }

            public void testAllFilesPresentInControlStructures() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/smartcasts/controlStructures"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
            }

            @TestMetadata("elvis.kt")
            public void testElvis() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/controlStructures/elvis.kt");
            }

            @TestMetadata("returns.kt")
            public void testReturns() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/controlStructures/returns.kt");
            }

            @TestMetadata("simpleIf.kt")
            public void testSimpleIf() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/controlStructures/simpleIf.kt");
            }

            @TestMetadata("smartcastFromArgument.kt")
            public void testSmartcastFromArgument() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/controlStructures/smartcastFromArgument.kt");
            }

            @TestMetadata("when.kt")
            public void testWhen() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/controlStructures/when.kt");
            }

            @TestMetadata("whenSubjectExpression.kt")
            public void testWhenSubjectExpression() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/controlStructures/whenSubjectExpression.kt");
            }
        }

        @TestMetadata("compiler/fir/analysis-tests/testData/resolve/smartcasts/lambdas")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Lambdas extends AbstractLazyBodyIsNotTouchedTilContractsPhaseTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
            }

            public void testAllFilesPresentInLambdas() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/smartcasts/lambdas"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
            }

            @TestMetadata("inPlaceLambdas.kt")
            public void testInPlaceLambdas() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/lambdas/inPlaceLambdas.kt");
            }

            @TestMetadata("lambdaInWhenBranch.kt")
            public void testLambdaInWhenBranch() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/lambdas/lambdaInWhenBranch.kt");
            }

            @TestMetadata("smartcastOnLambda.kt")
            public void testSmartcastOnLambda() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/lambdas/smartcastOnLambda.kt");
            }
        }

        @TestMetadata("compiler/fir/analysis-tests/testData/resolve/smartcasts/loops")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Loops extends AbstractLazyBodyIsNotTouchedTilContractsPhaseTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
            }

            public void testAllFilesPresentInLoops() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/smartcasts/loops"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
            }

            @TestMetadata("dataFlowInfoFromWhileCondition.kt")
            public void testDataFlowInfoFromWhileCondition() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/loops/dataFlowInfoFromWhileCondition.kt");
            }

            @TestMetadata("endlessLoops.kt")
            public void testEndlessLoops() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/loops/endlessLoops.kt");
            }
        }

        @TestMetadata("compiler/fir/analysis-tests/testData/resolve/smartcasts/problems")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Problems extends AbstractLazyBodyIsNotTouchedTilContractsPhaseTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
            }

            public void testAllFilesPresentInProblems() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/smartcasts/problems"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
            }

            @TestMetadata("invoke.kt")
            public void testInvoke() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/problems/invoke.kt");
            }
        }

        @TestMetadata("compiler/fir/analysis-tests/testData/resolve/smartcasts/receivers")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Receivers extends AbstractLazyBodyIsNotTouchedTilContractsPhaseTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
            }

            public void testAllFilesPresentInReceivers() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/smartcasts/receivers"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
            }

            @TestMetadata("implicitReceiverAsWhenSubject.kt")
            public void testImplicitReceiverAsWhenSubject() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/receivers/implicitReceiverAsWhenSubject.kt");
            }

            @TestMetadata("implicitReceivers.kt")
            public void testImplicitReceivers() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/receivers/implicitReceivers.kt");
            }

            @TestMetadata("mixingImplicitAndExplicitReceivers.kt")
            public void testMixingImplicitAndExplicitReceivers() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/receivers/mixingImplicitAndExplicitReceivers.kt");
            }

            @TestMetadata("thisOfExtensionProperty.kt")
            public void testThisOfExtensionProperty() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/receivers/thisOfExtensionProperty.kt");
            }
        }

        @TestMetadata("compiler/fir/analysis-tests/testData/resolve/smartcasts/safeCalls")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class SafeCalls extends AbstractLazyBodyIsNotTouchedTilContractsPhaseTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
            }

            public void testAllFilesPresentInSafeCalls() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/smartcasts/safeCalls"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
            }

            @TestMetadata("assignSafeCall.kt")
            public void testAssignSafeCall() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/safeCalls/assignSafeCall.kt");
            }

            @TestMetadata("boundSafeCallAndIsCheck.kt")
            public void testBoundSafeCallAndIsCheck() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/safeCalls/boundSafeCallAndIsCheck.kt");
            }

            @TestMetadata("complexIfWithOr.kt")
            public void testComplexIfWithOr() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/safeCalls/complexIfWithOr.kt");
            }

            @TestMetadata("safeCallAndEqualityToBool.kt")
            public void testSafeCallAndEqualityToBool() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/safeCalls/safeCallAndEqualityToBool.kt");
            }

            @TestMetadata("safeCalls.kt")
            public void testSafeCalls() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/safeCalls/safeCalls.kt");
            }
        }

        @TestMetadata("compiler/fir/analysis-tests/testData/resolve/smartcasts/stability")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Stability extends AbstractLazyBodyIsNotTouchedTilContractsPhaseTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
            }

            public void testAllFilesPresentInStability() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/smartcasts/stability"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
            }

            @TestMetadata("overridenOpenVal.kt")
            public void testOverridenOpenVal() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/stability/overridenOpenVal.kt");
            }
        }

        @TestMetadata("compiler/fir/analysis-tests/testData/resolve/smartcasts/variables")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Variables extends AbstractLazyBodyIsNotTouchedTilContractsPhaseTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
            }

            public void testAllFilesPresentInVariables() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/smartcasts/variables"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
            }

            @TestMetadata("delayedAssignment.kt")
            public void testDelayedAssignment() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/variables/delayedAssignment.kt");
            }

            @TestMetadata("smartcastAfterReassignment.kt")
            public void testSmartcastAfterReassignment() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/variables/smartcastAfterReassignment.kt");
            }
        }
    }

    @TestMetadata("compiler/fir/analysis-tests/testData/resolve/stdlib")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Stdlib extends AbstractLazyBodyIsNotTouchedTilContractsPhaseTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
        }

        public void testAllFilesPresentInStdlib() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/stdlib"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
        }

        @TestMetadata("compiler/fir/analysis-tests/testData/resolve/stdlib/j+k")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class J_k extends AbstractLazyBodyIsNotTouchedTilContractsPhaseTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
            }

            public void testAllFilesPresentInJ_k() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/stdlib/j+k"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
            }

            @TestMetadata("ArrayInGenericArguments.kt")
            public void testArrayInGenericArguments() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/stdlib/j+k/ArrayInGenericArguments.kt");
            }

            @TestMetadata("flexibleWildcard.kt")
            public void testFlexibleWildcard() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/stdlib/j+k/flexibleWildcard.kt");
            }
        }
    }

    @TestMetadata("compiler/fir/analysis-tests/testData/resolve/suppress")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Suppress extends AbstractLazyBodyIsNotTouchedTilContractsPhaseTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
        }

        public void testAllFilesPresentInSuppress() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/suppress"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
        }

        @TestMetadata("allWarnings.kt")
        public void testAllWarnings() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/suppress/allWarnings.kt");
        }

        @TestMetadata("multipleWarnings.kt")
        public void testMultipleWarnings() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/suppress/multipleWarnings.kt");
        }

        @TestMetadata("singleError.kt")
        public void testSingleError() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/suppress/singleError.kt");
        }

        @TestMetadata("singleWarning.kt")
        public void testSingleWarning() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/suppress/singleWarning.kt");
        }
    }

    @TestMetadata("compiler/fir/analysis-tests/testData/resolve/types")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Types extends AbstractLazyBodyIsNotTouchedTilContractsPhaseTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
        }

        public void testAllFilesPresentInTypes() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/types"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
        }

        @TestMetadata("bareWithFlexibleArg.kt")
        public void testBareWithFlexibleArg() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/types/bareWithFlexibleArg.kt");
        }

        @TestMetadata("bareWithSubjectTypeAlias.kt")
        public void testBareWithSubjectTypeAlias() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/types/bareWithSubjectTypeAlias.kt");
        }

        @TestMetadata("capturedParametersOfInnerClasses.kt")
        public void testCapturedParametersOfInnerClasses() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/types/capturedParametersOfInnerClasses.kt");
        }

        @TestMetadata("castToBareType.kt")
        public void testCastToBareType() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/types/castToBareType.kt");
        }

        @TestMetadata("typeAliasInArguments.kt")
        public void testTypeAliasInArguments() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/types/typeAliasInArguments.kt");
        }
    }

    @TestMetadata("compiler/fir/analysis-tests/testData/resolve/unqualifiedEnum")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class UnqualifiedEnum extends AbstractLazyBodyIsNotTouchedTilContractsPhaseTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
        }

        public void testAllFilesPresentInUnqualifiedEnum() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/unqualifiedEnum"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
        }

        @TestMetadata("correctJava.kt")
        public void testCorrectJava() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/unqualifiedEnum/correctJava.kt");
        }

        @TestMetadata("incorrectJava.kt")
        public void testIncorrectJava() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/unqualifiedEnum/incorrectJava.kt");
        }

        @TestMetadata("nested.kt")
        public void testNested() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/unqualifiedEnum/nested.kt");
        }

        @TestMetadata("notInsideBranches.kt")
        public void testNotInsideBranches() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/unqualifiedEnum/notInsideBranches.kt");
        }

        @TestMetadata("priority.kt")
        public void testPriority() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/unqualifiedEnum/priority.kt");
        }

        @TestMetadata("typeAlias.kt")
        public void testTypeAlias() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/unqualifiedEnum/typeAlias.kt");
        }

        @TestMetadata("unqualifiedEnum.kt")
        public void testUnqualifiedEnum() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/unqualifiedEnum/unqualifiedEnum.kt");
        }
    }

    @TestMetadata("compiler/fir/analysis-tests/testData/resolve/visibility")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Visibility extends AbstractLazyBodyIsNotTouchedTilContractsPhaseTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
        }

        public void testAllFilesPresentInVisibility() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/visibility"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
        }

        @TestMetadata("exposedFunctionParameterType.kt")
        public void testExposedFunctionParameterType() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/visibility/exposedFunctionParameterType.kt");
        }

        @TestMetadata("exposedFunctionReturnType.kt")
        public void testExposedFunctionReturnType() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/visibility/exposedFunctionReturnType.kt");
        }

        @TestMetadata("exposedPropertyType.kt")
        public void testExposedPropertyType() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/visibility/exposedPropertyType.kt");
        }

        @TestMetadata("exposedSupertype.kt")
        public void testExposedSupertype() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/visibility/exposedSupertype.kt");
        }

        @TestMetadata("exposedTypeAlias.kt")
        public void testExposedTypeAlias() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/visibility/exposedTypeAlias.kt");
        }

        @TestMetadata("exposedTypeParameters.kt")
        public void testExposedTypeParameters() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/visibility/exposedTypeParameters.kt");
        }

        @TestMetadata("intersectionOverrideWithImplicitTypes.kt")
        public void testIntersectionOverrideWithImplicitTypes() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/visibility/intersectionOverrideWithImplicitTypes.kt");
        }

        @TestMetadata("kotlinJavaKotlinHierarchy.kt")
        public void testKotlinJavaKotlinHierarchy() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/visibility/kotlinJavaKotlinHierarchy.kt");
        }

        @TestMetadata("privateAliasInSamePackage.kt")
        public void testPrivateAliasInSamePackage() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/visibility/privateAliasInSamePackage.kt");
        }

        @TestMetadata("protectedInCompanion.kt")
        public void testProtectedInCompanion() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/visibility/protectedInCompanion.kt");
        }

        @TestMetadata("singletonConstructors.kt")
        public void testSingletonConstructors() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/visibility/singletonConstructors.kt");
        }

        @TestMetadata("superAccessToJavaField.kt")
        public void testSuperAccessToJavaField() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/visibility/superAccessToJavaField.kt");
        }

        @TestMetadata("visibilityWithOverrides.kt")
        public void testVisibilityWithOverrides() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/visibility/visibilityWithOverrides.kt");
        }
    }

    @TestMetadata("compiler/fir/analysis-tests/testData/resolve/withAllowedKotlinPackage")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class WithAllowedKotlinPackage extends AbstractLazyBodyIsNotTouchedTilContractsPhaseTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, this, testDataFilePath);
        }

        public void testAllFilesPresentInWithAllowedKotlinPackage() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/withAllowedKotlinPackage"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
        }

        @TestMetadata("extensionFunctionAddedToStdlib.kt")
        public void testExtensionFunctionAddedToStdlib() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/withAllowedKotlinPackage/extensionFunctionAddedToStdlib.kt");
        }
    }
}
