/*
 * Copyright 2010-2021 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.analysis.low.level.api.fir.resolve;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link GenerateNewCompilerTests.kt}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("analysis/low-level-api-fir/testdata/innerDeclarationsResolve")
@TestDataPath("$PROJECT_ROOT")
public class InnerDeclarationsResolvePhaseTestGenerated extends AbstractInnerDeclarationsResolvePhaseTest {
    @Test
    public void testAllFilesPresentInInnerDeclarationsResolve() throws Exception {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/low-level-api-fir/testdata/innerDeclarationsResolve"), Pattern.compile("^(.+)\\.kt$"), null, true);
    }

    @Test
    @TestMetadata("annonymousClass.kt")
    public void testAnnonymousClass() throws Exception {
        runTest("analysis/low-level-api-fir/testdata/innerDeclarationsResolve/annonymousClass.kt");
    }

    @Test
    @TestMetadata("class.kt")
    public void testClass() throws Exception {
        runTest("analysis/low-level-api-fir/testdata/innerDeclarationsResolve/class.kt");
    }

    @Test
    @TestMetadata("constructorParameter.kt")
    public void testConstructorParameter() throws Exception {
        runTest("analysis/low-level-api-fir/testdata/innerDeclarationsResolve/constructorParameter.kt");
    }

    @Test
    @TestMetadata("enum.kt")
    public void testEnum() throws Exception {
        runTest("analysis/low-level-api-fir/testdata/innerDeclarationsResolve/enum.kt");
    }

    @Test
    @TestMetadata("funWithoutTypes.kt")
    public void testFunWithoutTypes() throws Exception {
        runTest("analysis/low-level-api-fir/testdata/innerDeclarationsResolve/funWithoutTypes.kt");
    }

    @Test
    @TestMetadata("functionValueParameter.kt")
    public void testFunctionValueParameter() throws Exception {
        runTest("analysis/low-level-api-fir/testdata/innerDeclarationsResolve/functionValueParameter.kt");
    }

    @Test
    @TestMetadata("functionWithImplicitType.kt")
    public void testFunctionWithImplicitType() throws Exception {
        runTest("analysis/low-level-api-fir/testdata/innerDeclarationsResolve/functionWithImplicitType.kt");
    }

    @Test
    @TestMetadata("lambdaInImplicitFunBody.kt")
    public void testLambdaInImplicitFunBody() throws Exception {
        runTest("analysis/low-level-api-fir/testdata/innerDeclarationsResolve/lambdaInImplicitFunBody.kt");
    }

    @Test
    @TestMetadata("lambdaInImplicitPropertyBody.kt")
    public void testLambdaInImplicitPropertyBody() throws Exception {
        runTest("analysis/low-level-api-fir/testdata/innerDeclarationsResolve/lambdaInImplicitPropertyBody.kt");
    }

    @Test
    @TestMetadata("lambdasInWithBodyFunction.kt")
    public void testLambdasInWithBodyFunction() throws Exception {
        runTest("analysis/low-level-api-fir/testdata/innerDeclarationsResolve/lambdasInWithBodyFunction.kt");
    }

    @Test
    @TestMetadata("localClass.kt")
    public void testLocalClass() throws Exception {
        runTest("analysis/low-level-api-fir/testdata/innerDeclarationsResolve/localClass.kt");
    }

    @Test
    @TestMetadata("propertyWithGetterAndSetter.kt")
    public void testPropertyWithGetterAndSetter() throws Exception {
        runTest("analysis/low-level-api-fir/testdata/innerDeclarationsResolve/propertyWithGetterAndSetter.kt");
    }

    @Test
    @TestMetadata("propertyWithSetter.kt")
    public void testPropertyWithSetter() throws Exception {
        runTest("analysis/low-level-api-fir/testdata/innerDeclarationsResolve/propertyWithSetter.kt");
    }
}
