/*
 * Copyright 2010-2021 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.analysis.low.level.api.fir.diagnostic.compiler.based;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link GenerateNewCompilerTests.kt}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
public class DiagnosisCompilerFirTestdataTestGenerated extends AbstractDiagnosisCompilerTestDataTest {
    @Nested
    @TestMetadata("compiler/fir/analysis-tests/testData/resolve")
    @TestDataPath("$PROJECT_ROOT")
    public class Resolve {
        @Test
        public void testAllFilesPresentInResolve() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
        }

        @Test
        @TestMetadata("annotationOnDeclarationWithDifferentArguments.kt")
        public void testAnnotationOnDeclarationWithDifferentArguments() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/annotationOnDeclarationWithDifferentArguments.kt");
        }

        @Test
        @TestMetadata("annotationUsedAsAnnotationArgument.kt")
        public void testAnnotationUsedAsAnnotationArgument() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/annotationUsedAsAnnotationArgument.kt");
        }

        @Test
        @TestMetadata("asImports.kt")
        public void testAsImports() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/asImports.kt");
        }

        @Test
        @TestMetadata("bareTypes.kt")
        public void testBareTypes() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/bareTypes.kt");
        }

        @Test
        @TestMetadata("bareTypes2.kt")
        public void testBareTypes2() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/bareTypes2.kt");
        }

        @Test
        @TestMetadata("bareTypesWithFlexibleArguments.kt")
        public void testBareTypesWithFlexibleArguments() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/bareTypesWithFlexibleArguments.kt");
        }

        @Test
        @TestMetadata("cast.kt")
        public void testCast() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/cast.kt");
        }

        @Test
        @TestMetadata("catchParameter.kt")
        public void testCatchParameter() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/catchParameter.kt");
        }

        @Test
        @TestMetadata("classCallInLambda.kt")
        public void testClassCallInLambda() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/classCallInLambda.kt");
        }

        @Test
        @TestMetadata("companion.kt")
        public void testCompanion() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/companion.kt");
        }

        @Test
        @TestMetadata("companionAccessInEnum.kt")
        public void testCompanionAccessInEnum() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/companionAccessInEnum.kt");
        }

        @Test
        @TestMetadata("companionObjectCall.kt")
        public void testCompanionObjectCall() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/companionObjectCall.kt");
        }

        @Test
        @TestMetadata("companionUsesNested.kt")
        public void testCompanionUsesNested() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/companionUsesNested.kt");
        }

        @Test
        @TestMetadata("constantValues.kt")
        public void testConstantValues() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/constantValues.kt");
        }

        @Test
        @TestMetadata("copy.kt")
        public void testCopy() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/copy.kt");
        }

        @Test
        @TestMetadata("covariantArrayAsReceiver.kt")
        public void testCovariantArrayAsReceiver() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/covariantArrayAsReceiver.kt");
        }

        @Test
        @TestMetadata("defaultJavaImportHiding.kt")
        public void testDefaultJavaImportHiding() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/defaultJavaImportHiding.kt");
        }

        @Test
        @TestMetadata("defaultParametersInheritedToJava.kt")
        public void testDefaultParametersInheritedToJava() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/defaultParametersInheritedToJava.kt");
        }

        @Test
        @TestMetadata("definitelyNotNullAmbiguity.kt")
        public void testDefinitelyNotNullAmbiguity() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/definitelyNotNullAmbiguity.kt");
        }

        @Test
        @TestMetadata("delegatedSuperType.kt")
        public void testDelegatedSuperType() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/delegatedSuperType.kt");
        }

        @Test
        @TestMetadata("delegatingConstructorCall.kt")
        public void testDelegatingConstructorCall() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/delegatingConstructorCall.kt");
        }

        @Test
        @TestMetadata("delegatingConstructorsAndTypeAliases.kt")
        public void testDelegatingConstructorsAndTypeAliases() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/delegatingConstructorsAndTypeAliases.kt");
        }

        @Test
        @TestMetadata("derivedClass.kt")
        public void testDerivedClass() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/derivedClass.kt");
        }

        @Test
        @TestMetadata("enum.kt")
        public void testEnum() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/enum.kt");
        }

        @Test
        @TestMetadata("enumWithCompanion.kt")
        public void testEnumWithCompanion() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/enumWithCompanion.kt");
        }

        @Test
        @TestMetadata("extension.kt")
        public void testExtension() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/extension.kt");
        }

        @Test
        @TestMetadata("F.kt")
        public void testF() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/F.kt");
        }

        @Test
        @TestMetadata("fakeRecursiveSupertype.kt")
        public void testFakeRecursiveSupertype() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/fakeRecursiveSupertype.kt");
        }

        @Test
        @TestMetadata("fakeRecursiveTypealias.kt")
        public void testFakeRecursiveTypealias() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/fakeRecursiveTypealias.kt");
        }

        @Test
        @TestMetadata("fib.kt")
        public void testFib() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/fib.kt");
        }

        @Test
        @TestMetadata("flexibleCapturedType.kt")
        public void testFlexibleCapturedType() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/flexibleCapturedType.kt");
        }

        @Test
        @TestMetadata("ft.kt")
        public void testFt() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/ft.kt");
        }

        @Test
        @TestMetadata("funInterfaceDeclaration.kt")
        public void testFunInterfaceDeclaration() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/funInterfaceDeclaration.kt");
        }

        @Test
        @TestMetadata("functionTypeAlias.kt")
        public void testFunctionTypeAlias() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/functionTypeAlias.kt");
        }

        @Test
        @TestMetadata("functionTypes.kt")
        public void testFunctionTypes() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/functionTypes.kt");
        }

        @Test
        @TestMetadata("genericConstructors.kt")
        public void testGenericConstructors() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/genericConstructors.kt");
        }

        @Test
        @TestMetadata("genericFunctions.kt")
        public void testGenericFunctions() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/genericFunctions.kt");
        }

        @Test
        @TestMetadata("genericReceiverPropertyOverride.kt")
        public void testGenericReceiverPropertyOverride() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/genericReceiverPropertyOverride.kt");
        }

        @Test
        @TestMetadata("implicitTypeFromOtherModule.kt")
        public void testImplicitTypeFromOtherModule() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/implicitTypeFromOtherModule.kt");
        }

        @Test
        @TestMetadata("implicitTypeInFakeOverride.kt")
        public void testImplicitTypeInFakeOverride() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/implicitTypeInFakeOverride.kt");
        }

        @Test
        @TestMetadata("implicitTypeWithTypeBound.kt")
        public void testImplicitTypeWithTypeBound() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/implicitTypeWithTypeBound.kt");
        }

        @Test
        @TestMetadata("incorrectDataClass.kt")
        public void testIncorrectDataClass() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/incorrectDataClass.kt");
        }

        @Test
        @TestMetadata("incorrectSuperCall.kt")
        public void testIncorrectSuperCall() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/incorrectSuperCall.kt");
        }

        @Test
        @TestMetadata("inherentlyImportedTypeFromOtherModule.kt")
        public void testInherentlyImportedTypeFromOtherModule() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/inherentlyImportedTypeFromOtherModule.kt");
        }

        @Test
        @TestMetadata("inherentlyImportedTypeFromOtherModule2.kt")
        public void testInherentlyImportedTypeFromOtherModule2() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/inherentlyImportedTypeFromOtherModule2.kt");
        }

        @Test
        @TestMetadata("inherentlyImportedTypeFromOtherModule3.kt")
        public void testInherentlyImportedTypeFromOtherModule3() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/inherentlyImportedTypeFromOtherModule3.kt");
        }

        @Test
        @TestMetadata("intersectionScope.kt")
        public void testIntersectionScope() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/intersectionScope.kt");
        }

        @Test
        @TestMetadata("intersectionTypes.kt")
        public void testIntersectionTypes() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/intersectionTypes.kt");
        }

        @Test
        @TestMetadata("invokeInWhenSubjectVariableInitializer.kt")
        public void testInvokeInWhenSubjectVariableInitializer() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/invokeInWhenSubjectVariableInitializer.kt");
        }

        @Test
        @TestMetadata("invokeOfLambdaWithReceiver.kt")
        public void testInvokeOfLambdaWithReceiver() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/invokeOfLambdaWithReceiver.kt");
        }

        @Test
        @TestMetadata("javaFieldVsAccessor.kt")
        public void testJavaFieldVsAccessor() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/javaFieldVsAccessor.kt");
        }

        @Test
        @TestMetadata("javaStaticScopeInheritance.kt")
        public void testJavaStaticScopeInheritance() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/javaStaticScopeInheritance.kt");
        }

        @Test
        @TestMetadata("kt41984.kt")
        public void testKt41984() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/kt41984.kt");
        }

        @Test
        @TestMetadata("kt41990.kt")
        public void testKt41990() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/kt41990.kt");
        }

        @Test
        @TestMetadata("labelAndReceiverForInfix.kt")
        public void testLabelAndReceiverForInfix() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/labelAndReceiverForInfix.kt");
        }

        @Test
        @TestMetadata("labeledReturnFromNotLabeledUnnamedFunction.kt")
        public void testLabeledReturnFromNotLabeledUnnamedFunction() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/labeledReturnFromNotLabeledUnnamedFunction.kt");
        }

        @Test
        @TestMetadata("lambdaArgInScopeFunction.kt")
        public void testLambdaArgInScopeFunction() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/lambdaArgInScopeFunction.kt");
        }

        @Test
        @TestMetadata("lambdaInLhsOfTypeOperatorCall.kt")
        public void testLambdaInLhsOfTypeOperatorCall() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/lambdaInLhsOfTypeOperatorCall.kt");
        }

        @Test
        @TestMetadata("lambdaPropertyTypeInference.kt")
        public void testLambdaPropertyTypeInference() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/lambdaPropertyTypeInference.kt");
        }

        @Test
        @TestMetadata("localFunctionsHiding.kt")
        public void testLocalFunctionsHiding() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/localFunctionsHiding.kt");
        }

        @Test
        @TestMetadata("localObject.kt")
        public void testLocalObject() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/localObject.kt");
        }

        @Test
        @TestMetadata("nestedClass.kt")
        public void testNestedClass() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/nestedClass.kt");
        }

        @Test
        @TestMetadata("nestedClassContructor.kt")
        public void testNestedClassContructor() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/nestedClassContructor.kt");
        }

        @Test
        @TestMetadata("nestedClassNameClash.kt")
        public void testNestedClassNameClash() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/nestedClassNameClash.kt");
        }

        @Test
        @TestMetadata("NestedOfAliasedType.kt")
        public void testNestedOfAliasedType() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/NestedOfAliasedType.kt");
        }

        @Test
        @TestMetadata("nestedReturnType.kt")
        public void testNestedReturnType() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/nestedReturnType.kt");
        }

        @Test
        @TestMetadata("NestedSuperType.kt")
        public void testNestedSuperType() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/NestedSuperType.kt");
        }

        @Test
        @TestMetadata("objectInnerClass.kt")
        public void testObjectInnerClass() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/objectInnerClass.kt");
        }

        @Test
        @TestMetadata("offOrderMultiBoundGenericOverride.kt")
        public void testOffOrderMultiBoundGenericOverride() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/offOrderMultiBoundGenericOverride.kt");
        }

        @Test
        @TestMetadata("openInInterface.kt")
        public void testOpenInInterface() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/openInInterface.kt");
        }

        @Test
        @TestMetadata("problems2.kt")
        public void testProblems2() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/problems2.kt");
        }

        @Test
        @TestMetadata("propertyFromJavaPlusAssign.kt")
        public void testPropertyFromJavaPlusAssign() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/propertyFromJavaPlusAssign.kt");
        }

        @Test
        @TestMetadata("qualifierWithCompanion.kt")
        public void testQualifierWithCompanion() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/qualifierWithCompanion.kt");
        }

        @Test
        @TestMetadata("rawTypeSam.kt")
        public void testRawTypeSam() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/rawTypeSam.kt");
        }

        @Test
        @TestMetadata("recursiveCallOnWhenWithSealedClass.kt")
        public void testRecursiveCallOnWhenWithSealedClass() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/recursiveCallOnWhenWithSealedClass.kt");
        }

        @Test
        @TestMetadata("recursiveTypeAlias.kt")
        public void testRecursiveTypeAlias() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/recursiveTypeAlias.kt");
        }

        @Test
        @TestMetadata("sealedClass.kt")
        public void testSealedClass() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/sealedClass.kt");
        }

        @Test
        @TestMetadata("settersGetters.kt")
        public void testSettersGetters() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/settersGetters.kt");
        }

        @Test
        @TestMetadata("simpleClass.kt")
        public void testSimpleClass() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/simpleClass.kt");
        }

        @Test
        @TestMetadata("simpleTypeAlias.kt")
        public void testSimpleTypeAlias() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/simpleTypeAlias.kt");
        }

        @Test
        @TestMetadata("spreadOperator.kt")
        public void testSpreadOperator() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/spreadOperator.kt");
        }

        @Test
        @TestMetadata("statusResolveForTypealiasAsSuperClass.kt")
        public void testStatusResolveForTypealiasAsSuperClass() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/statusResolveForTypealiasAsSuperClass.kt");
        }

        @Test
        @TestMetadata("supertypesForAnnotationClass.kt")
        public void testSupertypesForAnnotationClass() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/supertypesForAnnotationClass.kt");
        }

        @Test
        @TestMetadata("syntheticsVsNormalProperties.kt")
        public void testSyntheticsVsNormalProperties() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/syntheticsVsNormalProperties.kt");
        }

        @Test
        @TestMetadata("throwableSubclass.kt")
        public void testThrowableSubclass() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/throwableSubclass.kt");
        }

        @Test
        @TestMetadata("topLevelDestruction.kt")
        public void testTopLevelDestruction() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/topLevelDestruction.kt");
        }

        @Test
        @TestMetadata("treeSet.kt")
        public void testTreeSet() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/treeSet.kt");
        }

        @Test
        @TestMetadata("tryInference.kt")
        public void testTryInference() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/tryInference.kt");
        }

        @Test
        @TestMetadata("TwoDeclarationsInSameFile.kt")
        public void testTwoDeclarationsInSameFile() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/TwoDeclarationsInSameFile.kt");
        }

        @Test
        @TestMetadata("typeAliasWithGeneric.kt")
        public void testTypeAliasWithGeneric() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/typeAliasWithGeneric.kt");
        }

        @Test
        @TestMetadata("typeAliasWithTypeArguments.kt")
        public void testTypeAliasWithTypeArguments() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/typeAliasWithTypeArguments.kt");
        }

        @Test
        @TestMetadata("typeFromGetter.kt")
        public void testTypeFromGetter() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/typeFromGetter.kt");
        }

        @Test
        @TestMetadata("typeParameterInPropertyReceiver.kt")
        public void testTypeParameterInPropertyReceiver() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/typeParameterInPropertyReceiver.kt");
        }

        @Test
        @TestMetadata("typeParameterVsNested.kt")
        public void testTypeParameterVsNested() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/typeParameterVsNested.kt");
        }

        @Test
        @TestMetadata("typesInLocalFunctions.kt")
        public void testTypesInLocalFunctions() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/typesInLocalFunctions.kt");
        }

        @Test
        @TestMetadata("varargInPrimaryConstructor.kt")
        public void testVarargInPrimaryConstructor() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/varargInPrimaryConstructor.kt");
        }

        @Test
        @TestMetadata("visibleVsInvisibleQualifier.kt")
        public void testVisibleVsInvisibleQualifier() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/visibleVsInvisibleQualifier.kt");
        }

        @Test
        @TestMetadata("whenAsReceiver.kt")
        public void testWhenAsReceiver() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/whenAsReceiver.kt");
        }

        @Test
        @TestMetadata("whenElse.kt")
        public void testWhenElse() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/whenElse.kt");
        }

        @Test
        @TestMetadata("whenExpressionType.kt")
        public void testWhenExpressionType() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/whenExpressionType.kt");
        }

        @Test
        @TestMetadata("whenInference.kt")
        public void testWhenInference() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/whenInference.kt");
        }

        @Test
        @TestMetadata("whenWithWhenAsStatement.kt")
        public void testWhenWithWhenAsStatement() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolve/whenWithWhenAsStatement.kt");
        }

        @Nested
        @TestMetadata("compiler/fir/analysis-tests/testData/resolve/arguments")
        @TestDataPath("$PROJECT_ROOT")
        public class Arguments {
            @Test
            public void testAllFilesPresentInArguments() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/arguments"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
            }

            @Test
            @TestMetadata("ambiguityOnJavaOverride.kt")
            public void testAmbiguityOnJavaOverride() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/arguments/ambiguityOnJavaOverride.kt");
            }

            @Test
            @TestMetadata("argParamTypeMismatch.kt")
            public void testArgParamTypeMismatch() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/arguments/argParamTypeMismatch.kt");
            }

            @Test
            @TestMetadata("argumentsOfAnnotations.kt")
            public void testArgumentsOfAnnotations() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/arguments/argumentsOfAnnotations.kt");
            }

            @Test
            @TestMetadata("argumentsOfJavaAnnotation.kt")
            public void testArgumentsOfJavaAnnotation() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/arguments/argumentsOfJavaAnnotation.kt");
            }

            @Test
            @TestMetadata("default.kt")
            public void testDefault() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/arguments/default.kt");
            }

            @Test
            @TestMetadata("defaultFromOverrides.kt")
            public void testDefaultFromOverrides() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/arguments/defaultFromOverrides.kt");
            }

            @Test
            @TestMetadata("definetelyNotNullForTypeParameter.kt")
            public void testDefinetelyNotNullForTypeParameter() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/arguments/definetelyNotNullForTypeParameter.kt");
            }

            @Test
            @TestMetadata("destructuring.kt")
            public void testDestructuring() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/arguments/destructuring.kt");
            }

            @Test
            @TestMetadata("extensionLambdaInDefaultArgument.kt")
            public void testExtensionLambdaInDefaultArgument() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/arguments/extensionLambdaInDefaultArgument.kt");
            }

            @Test
            @TestMetadata("fieldPlusAssign.kt")
            public void testFieldPlusAssign() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/arguments/fieldPlusAssign.kt");
            }

            @Test
            @TestMetadata("incorrectFunctionalType.kt")
            public void testIncorrectFunctionalType() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/arguments/incorrectFunctionalType.kt");
            }

            @Test
            @TestMetadata("integerLiteralTypes.kt")
            public void testIntegerLiteralTypes() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/arguments/integerLiteralTypes.kt");
            }

            @Test
            @TestMetadata("integerOverloads.kt")
            public void testIntegerOverloads() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/arguments/integerOverloads.kt");
            }

            @Test
            @TestMetadata("invoke.kt")
            public void testInvoke() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/arguments/invoke.kt");
            }

            @Test
            @TestMetadata("javaAnnotationsWithArrayValue.kt")
            public void testJavaAnnotationsWithArrayValue() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/arguments/javaAnnotationsWithArrayValue.kt");
            }

            @Test
            @TestMetadata("javaArrayVariance.kt")
            public void testJavaArrayVariance() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/arguments/javaArrayVariance.kt");
            }

            @Test
            @TestMetadata("kt41940.kt")
            public void testKt41940() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/arguments/kt41940.kt");
            }

            @Test
            @TestMetadata("lambda.kt")
            public void testLambda() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/arguments/lambda.kt");
            }

            @Test
            @TestMetadata("lambdaInLambda.kt")
            public void testLambdaInLambda() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/arguments/lambdaInLambda.kt");
            }

            @Test
            @TestMetadata("lambdaInLambda2.kt")
            public void testLambdaInLambda2() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/arguments/lambdaInLambda2.kt");
            }

            @Test
            @TestMetadata("lambdaInUnresolvedCall.kt")
            public void testLambdaInUnresolvedCall() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/arguments/lambdaInUnresolvedCall.kt");
            }

            @Test
            @TestMetadata("namedArrayInAnnotation.kt")
            public void testNamedArrayInAnnotation() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/arguments/namedArrayInAnnotation.kt");
            }

            @Test
            @TestMetadata("nestedClassInAnnotationArgument.kt")
            public void testNestedClassInAnnotationArgument() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/arguments/nestedClassInAnnotationArgument.kt");
            }

            @Test
            @TestMetadata("noParameterForName.kt")
            public void testNoParameterForName() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/arguments/noParameterForName.kt");
            }

            @Test
            @TestMetadata("operatorsOverLiterals.kt")
            public void testOperatorsOverLiterals() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/arguments/operatorsOverLiterals.kt");
            }

            @Test
            @TestMetadata("overloadByReceiver.kt")
            public void testOverloadByReceiver() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/arguments/overloadByReceiver.kt");
            }

            @Test
            @TestMetadata("overloadWithDefault.kt")
            public void testOverloadWithDefault() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/arguments/overloadWithDefault.kt");
            }

            @Test
            @TestMetadata("simple.kt")
            public void testSimple() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/arguments/simple.kt");
            }

            @Test
            @TestMetadata("stringTemplates.kt")
            public void testStringTemplates() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/arguments/stringTemplates.kt");
            }

            @Test
            @TestMetadata("tryInLambda.kt")
            public void testTryInLambda() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/arguments/tryInLambda.kt");
            }

            @Test
            @TestMetadata("typeMismatchOnExpectedJavaMap.kt")
            public void testTypeMismatchOnExpectedJavaMap() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/arguments/typeMismatchOnExpectedJavaMap.kt");
            }

            @Test
            @TestMetadata("untouchedReturnInIf.kt")
            public void testUntouchedReturnInIf() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/arguments/untouchedReturnInIf.kt");
            }

            @Test
            @TestMetadata("vararg.kt")
            public void testVararg() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/arguments/vararg.kt");
            }

            @Test
            @TestMetadata("varargOfLambdasWithReceiver.kt")
            public void testVarargOfLambdasWithReceiver() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/arguments/varargOfLambdasWithReceiver.kt");
            }

            @Test
            @TestMetadata("varargProjection.kt")
            public void testVarargProjection() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/arguments/varargProjection.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/fir/analysis-tests/testData/resolve/arrays")
        @TestDataPath("$PROJECT_ROOT")
        public class Arrays {
            @Test
            public void testAllFilesPresentInArrays() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/arrays"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
            }

            @Test
            @TestMetadata("arraySet.kt")
            public void testArraySet() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/arrays/arraySet.kt");
            }

            @Test
            @TestMetadata("arraySetWithOperation.kt")
            public void testArraySetWithOperation() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/arrays/arraySetWithOperation.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/fir/analysis-tests/testData/resolve/builtins")
        @TestDataPath("$PROJECT_ROOT")
        public class Builtins {
            @Test
            public void testAllFilesPresentInBuiltins() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/builtins"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
            }

            @Test
            @TestMetadata("lists.kt")
            public void testLists() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/builtins/lists.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/fir/analysis-tests/testData/resolve/callResolution")
        @TestDataPath("$PROJECT_ROOT")
        public class CallResolution {
            @Test
            public void testAllFilesPresentInCallResolution() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/callResolution"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
            }

            @Test
            @TestMetadata("arraySetWithPlusAssign.kt")
            public void testArraySetWithPlusAssign() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/callResolution/arraySetWithPlusAssign.kt");
            }

            @Test
            @TestMetadata("companionInvoke.kt")
            public void testCompanionInvoke() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/callResolution/companionInvoke.kt");
            }

            @Test
            @TestMetadata("companionVsSuperStatic.kt")
            public void testCompanionVsSuperStatic() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/callResolution/companionVsSuperStatic.kt");
            }

            @Test
            @TestMetadata("debugExpressionType.kt")
            public void testDebugExpressionType() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/callResolution/debugExpressionType.kt");
            }

            @Test
            @TestMetadata("debugInfoCall.kt")
            public void testDebugInfoCall() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/callResolution/debugInfoCall.kt");
            }

            @Test
            @TestMetadata("errorCandidates.kt")
            public void testErrorCandidates() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/callResolution/errorCandidates.kt");
            }

            @Test
            @TestMetadata("exponentialArraySetWithPlusAssign.kt")
            public void testExponentialArraySetWithPlusAssign() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/callResolution/exponentialArraySetWithPlusAssign.kt");
            }

            @Test
            @TestMetadata("extensionInvokeAfterSafeCall.kt")
            public void testExtensionInvokeAfterSafeCall() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/callResolution/extensionInvokeAfterSafeCall.kt");
            }

            @Test
            @TestMetadata("invokeAmbiguity.kt")
            public void testInvokeAmbiguity() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/callResolution/invokeAmbiguity.kt");
            }

            @Test
            @TestMetadata("invokeWithReceiverAndArgument.kt")
            public void testInvokeWithReceiverAndArgument() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/callResolution/invokeWithReceiverAndArgument.kt");
            }

            @Test
            @TestMetadata("kt37056.kt")
            public void testKt37056() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/callResolution/kt37056.kt");
            }

            @Test
            @TestMetadata("lambdaAsReceiver.kt")
            public void testLambdaAsReceiver() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/callResolution/lambdaAsReceiver.kt");
            }

            @Test
            @TestMetadata("objectInvoke.kt")
            public void testObjectInvoke() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/callResolution/objectInvoke.kt");
            }

            @Test
            @TestMetadata("safeCallOnTypeAlias.kt")
            public void testSafeCallOnTypeAlias() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/callResolution/safeCallOnTypeAlias.kt");
            }

            @Test
            @TestMetadata("superAny.kt")
            public void testSuperAny() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/callResolution/superAny.kt");
            }

            @Test
            @TestMetadata("syntheticPropertiesWrongImplicitReceiver.kt")
            public void testSyntheticPropertiesWrongImplicitReceiver() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/callResolution/syntheticPropertiesWrongImplicitReceiver.kt");
            }

            @Test
            @TestMetadata("twoLocalLambdasWithSameName.kt")
            public void testTwoLocalLambdasWithSameName() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/callResolution/twoLocalLambdasWithSameName.kt");
            }

            @Test
            @TestMetadata("typeAliasWithNotNullBound.kt")
            public void testTypeAliasWithNotNullBound() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/callResolution/typeAliasWithNotNullBound.kt");
            }

            @Test
            @TestMetadata("uselessMultipleBounds.kt")
            public void testUselessMultipleBounds() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/callResolution/uselessMultipleBounds.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/fir/analysis-tests/testData/resolve/cfg")
        @TestDataPath("$PROJECT_ROOT")
        public class Cfg {
            @Test
            public void testAllFilesPresentInCfg() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/cfg"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
            }

            @Test
            @TestMetadata("annotatedLocalClass.kt")
            public void testAnnotatedLocalClass() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/cfg/annotatedLocalClass.kt");
            }

            @Test
            @TestMetadata("binaryOperations.kt")
            public void testBinaryOperations() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/cfg/binaryOperations.kt");
            }

            @Test
            @TestMetadata("booleanOperatorsWithConsts.kt")
            public void testBooleanOperatorsWithConsts() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/cfg/booleanOperatorsWithConsts.kt");
            }

            @Test
            @TestMetadata("complex.kt")
            public void testComplex() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/cfg/complex.kt");
            }

            @Test
            @TestMetadata("defaultArguments.kt")
            public void testDefaultArguments() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/cfg/defaultArguments.kt");
            }

            @Test
            @TestMetadata("emptyWhen.kt")
            public void testEmptyWhen() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/cfg/emptyWhen.kt");
            }

            @Test
            @TestMetadata("flowFromInplaceLambda.kt")
            public void testFlowFromInplaceLambda() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/cfg/flowFromInplaceLambda.kt");
            }

            @Test
            @TestMetadata("initBlock.kt")
            public void testInitBlock() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/cfg/initBlock.kt");
            }

            @Test
            @TestMetadata("initBlockAndInPlaceLambda.kt")
            public void testInitBlockAndInPlaceLambda() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/cfg/initBlockAndInPlaceLambda.kt");
            }

            @Test
            @TestMetadata("innerClassInAnonymousObject.kt")
            public void testInnerClassInAnonymousObject() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/cfg/innerClassInAnonymousObject.kt");
            }

            @Test
            @TestMetadata("inplaceLambdaInControlFlowExpressions.kt")
            public void testInplaceLambdaInControlFlowExpressions() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/cfg/inplaceLambdaInControlFlowExpressions.kt");
            }

            @Test
            @TestMetadata("jumps.kt")
            public void testJumps() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/cfg/jumps.kt");
            }

            @Test
            @TestMetadata("lambdaAsReturnOfLambda.kt")
            public void testLambdaAsReturnOfLambda() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/cfg/lambdaAsReturnOfLambda.kt");
            }

            @Test
            @TestMetadata("lambdaReturningObject.kt")
            public void testLambdaReturningObject() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/cfg/lambdaReturningObject.kt");
            }

            @Test
            @TestMetadata("lambdas.kt")
            public void testLambdas() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/cfg/lambdas.kt");
            }

            @Test
            @TestMetadata("localClassesWithImplicit.kt")
            public void testLocalClassesWithImplicit() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/cfg/localClassesWithImplicit.kt");
            }

            @Test
            @TestMetadata("loops.kt")
            public void testLoops() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/cfg/loops.kt");
            }

            @Test
            @TestMetadata("postponedLambdaInConstructor.kt")
            public void testPostponedLambdaInConstructor() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/cfg/postponedLambdaInConstructor.kt");
            }

            @Test
            @TestMetadata("postponedLambdas.kt")
            public void testPostponedLambdas() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/cfg/postponedLambdas.kt");
            }

            @Test
            @TestMetadata("propertiesAndInitBlocks.kt")
            public void testPropertiesAndInitBlocks() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/cfg/propertiesAndInitBlocks.kt");
            }

            @Test
            @TestMetadata("returnValuesFromLambda.kt")
            public void testReturnValuesFromLambda() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/cfg/returnValuesFromLambda.kt");
            }

            @Test
            @TestMetadata("safeCalls.kt")
            public void testSafeCalls() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/cfg/safeCalls.kt");
            }

            @Test
            @TestMetadata("simple.kt")
            public void testSimple() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/cfg/simple.kt");
            }

            @Test
            @TestMetadata("tryCatch.kt")
            public void testTryCatch() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/cfg/tryCatch.kt");
            }

            @Test
            @TestMetadata("variableInitializedInTryBlock.kt")
            public void testVariableInitializedInTryBlock() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/cfg/variableInitializedInTryBlock.kt");
            }

            @Test
            @TestMetadata("when.kt")
            public void testWhen() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/cfg/when.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/fir/analysis-tests/testData/resolve/constVal")
        @TestDataPath("$PROJECT_ROOT")
        public class ConstVal {
            @Test
            public void testAllFilesPresentInConstVal() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/constVal"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
            }

            @Test
            @TestMetadata("const.kt")
            public void testConst() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/constVal/const.kt");
            }

            @Test
            @TestMetadata("constValNotTopLevelOrObject.kt")
            public void testConstValNotTopLevelOrObject() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/constVal/constValNotTopLevelOrObject.kt");
            }

            @Test
            @TestMetadata("constValWithGetterOrDelegate.kt")
            public void testConstValWithGetterOrDelegate() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/constVal/constValWithGetterOrDelegate.kt");
            }

            @Test
            @TestMetadata("constValWithTypealiasType.kt")
            public void testConstValWithTypealiasType() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/constVal/constValWithTypealiasType.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/fir/analysis-tests/testData/resolve/constructors")
        @TestDataPath("$PROJECT_ROOT")
        public class Constructors {
            @Test
            public void testAllFilesPresentInConstructors() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/constructors"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
            }

            @Test
            @TestMetadata("erroneousDelegatedConstructorCall.kt")
            public void testErroneousDelegatedConstructorCall() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/constructors/erroneousDelegatedConstructorCall.kt");
            }

            @Test
            @TestMetadata("noSuperCallInSupertypes.kt")
            public void testNoSuperCallInSupertypes() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/constructors/noSuperCallInSupertypes.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/fir/analysis-tests/testData/resolve/contracts")
        @TestDataPath("$PROJECT_ROOT")
        public class Contracts {
            @Test
            public void testAllFilesPresentInContracts() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/contracts"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
            }

            @Test
            @TestMetadata("genericContract.kt")
            public void testGenericContract() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/contracts/genericContract.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/fir/analysis-tests/testData/resolve/delegates")
        @TestDataPath("$PROJECT_ROOT")
        public class Delegates {
            @Test
            public void testAllFilesPresentInDelegates() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/delegates"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
            }

            @Test
            @TestMetadata("delegateInference.kt")
            public void testDelegateInference() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/delegates/delegateInference.kt");
            }

            @Test
            @TestMetadata("delegateWithArgInference.kt")
            public void testDelegateWithArgInference() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/delegates/delegateWithArgInference.kt");
            }

            @Test
            @TestMetadata("delegateWithLambda.kt")
            public void testDelegateWithLambda() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/delegates/delegateWithLambda.kt");
            }

            @Test
            @TestMetadata("extensionGenericGetValue.kt")
            public void testExtensionGenericGetValue() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/delegates/extensionGenericGetValue.kt");
            }

            @Test
            @TestMetadata("extensionGetValueWithTypeVariableAsReceiver.kt")
            public void testExtensionGetValueWithTypeVariableAsReceiver() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/delegates/extensionGetValueWithTypeVariableAsReceiver.kt");
            }

            @Test
            @TestMetadata("kt41982.kt")
            public void testKt41982() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/delegates/kt41982.kt");
            }

            @Test
            @TestMetadata("provideDelegate.kt")
            public void testProvideDelegate() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/delegates/provideDelegate.kt");
            }

            @Test
            @TestMetadata("receiverInference.kt")
            public void testReceiverInference() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/delegates/receiverInference.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/fir/analysis-tests/testData/resolve/diagnostics")
        @TestDataPath("$PROJECT_ROOT")
        public class Diagnostics {
            @Test
            @TestMetadata("abstractSuperCall.kt")
            public void testAbstractSuperCall() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/abstractSuperCall.kt");
            }

            @Test
            @TestMetadata("abstractSuperCallInPresenseOfNonAbstractMethodInParent.kt")
            public void testAbstractSuperCallInPresenseOfNonAbstractMethodInParent() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/abstractSuperCallInPresenseOfNonAbstractMethodInParent.kt");
            }

            @Test
            public void testAllFilesPresentInDiagnostics() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/diagnostics"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
            }

            @Test
            @TestMetadata("annotationArgumentKClassLiteralTypeError.kt")
            public void testAnnotationArgumentKClassLiteralTypeError() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/annotationArgumentKClassLiteralTypeError.kt");
            }

            @Test
            @TestMetadata("annotationArgumentMustBeConst.kt")
            public void testAnnotationArgumentMustBeConst() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/annotationArgumentMustBeConst.kt");
            }

            @Test
            @TestMetadata("annotationArgumentMustBeEnumConst.kt")
            public void testAnnotationArgumentMustBeEnumConst() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/annotationArgumentMustBeEnumConst.kt");
            }

            @Test
            @TestMetadata("annotationArgumentMustBeKClassLiteral.kt")
            public void testAnnotationArgumentMustBeKClassLiteral() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/annotationArgumentMustBeKClassLiteral.kt");
            }

            @Test
            @TestMetadata("annotationClassMember.kt")
            public void testAnnotationClassMember() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/annotationClassMember.kt");
            }

            @Test
            @TestMetadata("anonymousObjectByDelegate.kt")
            public void testAnonymousObjectByDelegate() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/anonymousObjectByDelegate.kt");
            }

            @Test
            @TestMetadata("classInSupertypeForEnum.kt")
            public void testClassInSupertypeForEnum() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/classInSupertypeForEnum.kt");
            }

            @Test
            @TestMetadata("conflictingOverloads.kt")
            public void testConflictingOverloads() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/conflictingOverloads.kt");
            }

            @Test
            @TestMetadata("conflictingProjection.kt")
            public void testConflictingProjection() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/conflictingProjection.kt");
            }

            @Test
            @TestMetadata("constructorInInterface.kt")
            public void testConstructorInInterface() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/constructorInInterface.kt");
            }

            @Test
            @TestMetadata("cyclicConstructorDelegationCall.kt")
            public void testCyclicConstructorDelegationCall() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/cyclicConstructorDelegationCall.kt");
            }

            @Test
            @TestMetadata("delegationInInterface.kt")
            public void testDelegationInInterface() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/delegationInInterface.kt");
            }

            @Test
            @TestMetadata("delegationSuperCallInEnumConstructor.kt")
            public void testDelegationSuperCallInEnumConstructor() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/delegationSuperCallInEnumConstructor.kt");
            }

            @Test
            @TestMetadata("explicitDelegationCallRequired.kt")
            public void testExplicitDelegationCallRequired() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/explicitDelegationCallRequired.kt");
            }

            @Test
            @TestMetadata("inapplicableLateinitModifier.kt")
            public void testInapplicableLateinitModifier() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/inapplicableLateinitModifier.kt");
            }

            @Test
            @TestMetadata("incompatibleModifiers.kt")
            public void testIncompatibleModifiers() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/incompatibleModifiers.kt");
            }

            @Test
            @TestMetadata("infixFunctions.kt")
            public void testInfixFunctions() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/infixFunctions.kt");
            }

            @Test
            @TestMetadata("instanceAccessBeforeSuperCall.kt")
            public void testInstanceAccessBeforeSuperCall() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/instanceAccessBeforeSuperCall.kt");
            }

            @Test
            @TestMetadata("interfaceWithSuperclass.kt")
            public void testInterfaceWithSuperclass() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/interfaceWithSuperclass.kt");
            }

            @Test
            @TestMetadata("localAnnotationClass.kt")
            public void testLocalAnnotationClass() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/localAnnotationClass.kt");
            }

            @Test
            @TestMetadata("localEntitytNotAllowed.kt")
            public void testLocalEntitytNotAllowed() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/localEntitytNotAllowed.kt");
            }

            @Test
            @TestMetadata("manyCompanionObjects.kt")
            public void testManyCompanionObjects() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/manyCompanionObjects.kt");
            }

            @Test
            @TestMetadata("methodOfAnyImplementedInInterface.kt")
            public void testMethodOfAnyImplementedInInterface() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/methodOfAnyImplementedInInterface.kt");
            }

            @Test
            @TestMetadata("multipleBounds.kt")
            public void testMultipleBounds() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/multipleBounds.kt");
            }

            @Test
            @TestMetadata("nonConstValInAnnotationArgument.kt")
            public void testNonConstValInAnnotationArgument() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/nonConstValInAnnotationArgument.kt");
            }

            @Test
            @TestMetadata("notASupertype.kt")
            public void testNotASupertype() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/notASupertype.kt");
            }

            @Test
            @TestMetadata("primaryConstructorRequiredForDataClass.kt")
            public void testPrimaryConstructorRequiredForDataClass() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/primaryConstructorRequiredForDataClass.kt");
            }

            @Test
            @TestMetadata("projectionsOnNonClassTypeArguments.kt")
            public void testProjectionsOnNonClassTypeArguments() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/projectionsOnNonClassTypeArguments.kt");
            }

            @Test
            @TestMetadata("propertyTypeMismatchOnOverride.kt")
            public void testPropertyTypeMismatchOnOverride() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/propertyTypeMismatchOnOverride.kt");
            }

            @Test
            @TestMetadata("qualifiedSupertypeExtendedByOtherSupertype.kt")
            public void testQualifiedSupertypeExtendedByOtherSupertype() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/qualifiedSupertypeExtendedByOtherSupertype.kt");
            }

            @Test
            @TestMetadata("redundantModifier.kt")
            public void testRedundantModifier() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/redundantModifier.kt");
            }

            @Test
            @TestMetadata("repeatedModifier.kt")
            public void testRepeatedModifier() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/repeatedModifier.kt");
            }

            @Test
            @TestMetadata("returnTypeMismatchOnOverride.kt")
            public void testReturnTypeMismatchOnOverride() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/returnTypeMismatchOnOverride.kt");
            }

            @Test
            @TestMetadata("sealedClassConstructorCall.kt")
            public void testSealedClassConstructorCall() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/sealedClassConstructorCall.kt");
            }

            @Test
            @TestMetadata("sealedSupertype.kt")
            public void testSealedSupertype() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/sealedSupertype.kt");
            }

            @Test
            @TestMetadata("someOverridesTest.kt")
            public void testSomeOverridesTest() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/someOverridesTest.kt");
            }

            @Test
            @TestMetadata("superCallWithDelegation.kt")
            public void testSuperCallWithDelegation() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/superCallWithDelegation.kt");
            }

            @Test
            @TestMetadata("superIsNotAnExpression.kt")
            public void testSuperIsNotAnExpression() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/superIsNotAnExpression.kt");
            }

            @Test
            @TestMetadata("superNotAvailable.kt")
            public void testSuperNotAvailable() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/superNotAvailable.kt");
            }

            @Test
            @TestMetadata("superclassNotAccessibleFromInterface.kt")
            public void testSuperclassNotAccessibleFromInterface() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/superclassNotAccessibleFromInterface.kt");
            }

            @Test
            @TestMetadata("supertypeInitializedInInterface.kt")
            public void testSupertypeInitializedInInterface() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/supertypeInitializedInInterface.kt");
            }

            @Test
            @TestMetadata("supertypeInitializedWithoutPrimaryConstructor.kt")
            public void testSupertypeInitializedWithoutPrimaryConstructor() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/supertypeInitializedWithoutPrimaryConstructor.kt");
            }

            @Test
            @TestMetadata("testIllegalAnnotationClass.kt")
            public void testTestIllegalAnnotationClass() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/testIllegalAnnotationClass.kt");
            }

            @Test
            @TestMetadata("typeArgumentsNotAllowed.kt")
            public void testTypeArgumentsNotAllowed() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/typeArgumentsNotAllowed.kt");
            }

            @Test
            @TestMetadata("typeOfAnnotationMember.kt")
            public void testTypeOfAnnotationMember() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/typeOfAnnotationMember.kt");
            }

            @Test
            @TestMetadata("typeParametersInEnum.kt")
            public void testTypeParametersInEnum() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/typeParametersInEnum.kt");
            }

            @Test
            @TestMetadata("typeParametersInObject.kt")
            public void testTypeParametersInObject() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/typeParametersInObject.kt");
            }

            @Test
            @TestMetadata("upperBoundViolated.kt")
            public void testUpperBoundViolated() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/upperBoundViolated.kt");
            }

            @Test
            @TestMetadata("valOnAnnotationParameter.kt")
            public void testValOnAnnotationParameter() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/valOnAnnotationParameter.kt");
            }

            @Nested
            @TestMetadata("compiler/fir/analysis-tests/testData/resolve/diagnostics/functionAsExpression")
            @TestDataPath("$PROJECT_ROOT")
            public class FunctionAsExpression {
                @Test
                public void testAllFilesPresentInFunctionAsExpression() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/diagnostics/functionAsExpression"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
                }

                @Test
                @TestMetadata("Parameters.kt")
                public void testParameters() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/diagnostics/functionAsExpression/Parameters.kt");
                }
            }
        }

        @Nested
        @TestMetadata("compiler/fir/analysis-tests/testData/resolve/exhaustiveness")
        @TestDataPath("$PROJECT_ROOT")
        public class Exhaustiveness {
            @Test
            public void testAllFilesPresentInExhaustiveness() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/exhaustiveness"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
            }

            @Nested
            @TestMetadata("compiler/fir/analysis-tests/testData/resolve/exhaustiveness/negative")
            @TestDataPath("$PROJECT_ROOT")
            public class Negative {
                @Test
                public void testAllFilesPresentInNegative() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/exhaustiveness/negative"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
                }

                @Test
                @TestMetadata("missingBooleanBranch.kt")
                public void testMissingBooleanBranch() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/exhaustiveness/negative/missingBooleanBranch.kt");
                }

                @Test
                @TestMetadata("missingElse.kt")
                public void testMissingElse() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/exhaustiveness/negative/missingElse.kt");
                }

                @Test
                @TestMetadata("missingEnumEntry.kt")
                public void testMissingEnumEntry() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/exhaustiveness/negative/missingEnumEntry.kt");
                }

                @Test
                @TestMetadata("missingSealedInheritor.kt")
                public void testMissingSealedInheritor() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/exhaustiveness/negative/missingSealedInheritor.kt");
                }

                @Test
                @TestMetadata("nonExhaustiveWhenWithoutCoercionToUnit.kt")
                public void testNonExhaustiveWhenWithoutCoercionToUnit() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/exhaustiveness/negative/nonExhaustiveWhenWithoutCoercionToUnit.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/fir/analysis-tests/testData/resolve/exhaustiveness/positive")
            @TestDataPath("$PROJECT_ROOT")
            public class Positive {
                @Test
                public void testAllFilesPresentInPositive() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/exhaustiveness/positive"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
                }

                @Test
                @TestMetadata("exhaustiveWhenAndDNNType.kt")
                public void testExhaustiveWhenAndDNNType() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/exhaustiveness/positive/exhaustiveWhenAndDNNType.kt");
                }

                @Test
                @TestMetadata("exhaustiveWhenAndFlexibleType.kt")
                public void testExhaustiveWhenAndFlexibleType() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/exhaustiveness/positive/exhaustiveWhenAndFlexibleType.kt");
                }

                @Test
                @TestMetadata("exhaustiveness_boolean.kt")
                public void testExhaustiveness_boolean() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/exhaustiveness/positive/exhaustiveness_boolean.kt");
                }

                @Test
                @TestMetadata("exhaustiveness_enum.kt")
                public void testExhaustiveness_enum() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/exhaustiveness/positive/exhaustiveness_enum.kt");
                }

                @Test
                @TestMetadata("exhaustiveness_enumJava.kt")
                public void testExhaustiveness_enumJava() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/exhaustiveness/positive/exhaustiveness_enumJava.kt");
                }

                @Test
                @TestMetadata("exhaustiveness_sealedClass.kt")
                public void testExhaustiveness_sealedClass() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/exhaustiveness/positive/exhaustiveness_sealedClass.kt");
                }

                @Test
                @TestMetadata("exhaustiveness_sealedObject.kt")
                public void testExhaustiveness_sealedObject() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/exhaustiveness/positive/exhaustiveness_sealedObject.kt");
                }

                @Test
                @TestMetadata("exhaustiveness_sealedSubClass.kt")
                public void testExhaustiveness_sealedSubClass() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/exhaustiveness/positive/exhaustiveness_sealedSubClass.kt");
                }

                @Test
                @TestMetadata("nestedIfInLambda.kt")
                public void testNestedIfInLambda() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/exhaustiveness/positive/nestedIfInLambda.kt");
                }

                @Test
                @TestMetadata("nonExhaustiveWhenWithCoercionToUnit.kt")
                public void testNonExhaustiveWhenWithCoercionToUnit() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/exhaustiveness/positive/nonExhaustiveWhenWithCoercionToUnit.kt");
                }
            }
        }

        @Nested
        @TestMetadata("compiler/fir/analysis-tests/testData/resolve/expresssions")
        @TestDataPath("$PROJECT_ROOT")
        public class Expresssions {
            @Test
            @TestMetadata("access.kt")
            public void testAccess() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/access.kt");
            }

            @Test
            public void testAllFilesPresentInExpresssions() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/expresssions"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
            }

            @Test
            @TestMetadata("annotationWithReturn.kt")
            public void testAnnotationWithReturn() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/annotationWithReturn.kt");
            }

            @Test
            @TestMetadata("annotations.kt")
            public void testAnnotations() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/annotations.kt");
            }

            @Test
            @TestMetadata("baseQualifier.kt")
            public void testBaseQualifier() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/baseQualifier.kt");
            }

            @Test
            @TestMetadata("blockLocalScopes.kt")
            public void testBlockLocalScopes() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/blockLocalScopes.kt");
            }

            @Test
            @TestMetadata("CallBasedInExpressionGenerator.kt")
            public void testCallBasedInExpressionGenerator() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/CallBasedInExpressionGenerator.kt");
            }

            @Test
            @TestMetadata("checkArguments.kt")
            public void testCheckArguments() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/checkArguments.kt");
            }

            @Test
            @TestMetadata("classifierAccessFromCompanion.kt")
            public void testClassifierAccessFromCompanion() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/classifierAccessFromCompanion.kt");
            }

            @Test
            @TestMetadata("companion.kt")
            public void testCompanion() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/companion.kt");
            }

            @Test
            @TestMetadata("companionExtension.kt")
            public void testCompanionExtension() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/companionExtension.kt");
            }

            @Test
            @TestMetadata("constructor.kt")
            public void testConstructor() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/constructor.kt");
            }

            @Test
            @TestMetadata("dispatchReceiver.kt")
            public void testDispatchReceiver() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/dispatchReceiver.kt");
            }

            @Test
            @TestMetadata("enumEntryUse.kt")
            public void testEnumEntryUse() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/enumEntryUse.kt");
            }

            @Test
            @TestMetadata("enumValues.kt")
            public void testEnumValues() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/enumValues.kt");
            }

            @Test
            @TestMetadata("errCallable.kt")
            public void testErrCallable() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/errCallable.kt");
            }

            @Test
            @TestMetadata("extensionPropertyInLambda.kt")
            public void testExtensionPropertyInLambda() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/extensionPropertyInLambda.kt");
            }

            @Test
            @TestMetadata("genericDecorator.kt")
            public void testGenericDecorator() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/genericDecorator.kt");
            }

            @Test
            @TestMetadata("genericDescriptor.kt")
            public void testGenericDescriptor() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/genericDescriptor.kt");
            }

            @Test
            @TestMetadata("genericDiagnostic.kt")
            public void testGenericDiagnostic() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/genericDiagnostic.kt");
            }

            @Test
            @TestMetadata("genericPropertyAccess.kt")
            public void testGenericPropertyAccess() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/genericPropertyAccess.kt");
            }

            @Test
            @TestMetadata("genericUsedInFunction.kt")
            public void testGenericUsedInFunction() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/genericUsedInFunction.kt");
            }

            @Test
            @TestMetadata("importedReceiver.kt")
            public void testImportedReceiver() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/importedReceiver.kt");
            }

            @Test
            @TestMetadata("innerQualifier.kt")
            public void testInnerQualifier() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/innerQualifier.kt");
            }

            @Test
            @TestMetadata("innerWithSuperCompanion.kt")
            public void testInnerWithSuperCompanion() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/innerWithSuperCompanion.kt");
            }

            @Test
            @TestMetadata("javaFieldCallable.kt")
            public void testJavaFieldCallable() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/javaFieldCallable.kt");
            }

            @Test
            @TestMetadata("lambda.kt")
            public void testLambda() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/lambda.kt");
            }

            @Test
            @TestMetadata("lambdaWithReceiver.kt")
            public void testLambdaWithReceiver() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/lambdaWithReceiver.kt");
            }

            @Test
            @TestMetadata("localClassAccessesContainingClass.kt")
            public void testLocalClassAccessesContainingClass() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/localClassAccessesContainingClass.kt");
            }

            @Test
            @TestMetadata("localConstructor.kt")
            public void testLocalConstructor() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/localConstructor.kt");
            }

            @Test
            @TestMetadata("localExtension.kt")
            public void testLocalExtension() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/localExtension.kt");
            }

            @Test
            @TestMetadata("localImplicitBodies.kt")
            public void testLocalImplicitBodies() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/localImplicitBodies.kt");
            }

            @Test
            @TestMetadata("localInnerClass.kt")
            public void testLocalInnerClass() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/localInnerClass.kt");
            }

            @Test
            @TestMetadata("localObjects.kt")
            public void testLocalObjects() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/localObjects.kt");
            }

            @Test
            @TestMetadata("localScopes.kt")
            public void testLocalScopes() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/localScopes.kt");
            }

            @Test
            @TestMetadata("localTypes.kt")
            public void testLocalTypes() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/localTypes.kt");
            }

            @Test
            @TestMetadata("localWithBooleanNot.kt")
            public void testLocalWithBooleanNot() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/localWithBooleanNot.kt");
            }

            @Test
            @TestMetadata("memberExtension.kt")
            public void testMemberExtension() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/memberExtension.kt");
            }

            @Test
            @TestMetadata("nestedConstructorCallable.kt")
            public void testNestedConstructorCallable() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/nestedConstructorCallable.kt");
            }

            @Test
            @TestMetadata("nestedObjects.kt")
            public void testNestedObjects() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/nestedObjects.kt");
            }

            @Test
            @TestMetadata("nestedVisibility.kt")
            public void testNestedVisibility() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/nestedVisibility.kt");
            }

            @Test
            @TestMetadata("objectOverrideCallViaImport.kt")
            public void testObjectOverrideCallViaImport() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/objectOverrideCallViaImport.kt");
            }

            @Test
            @TestMetadata("objectVsProperty.kt")
            public void testObjectVsProperty() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/objectVsProperty.kt");
            }

            @Test
            @TestMetadata("objects.kt")
            public void testObjects() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/objects.kt");
            }

            @Test
            @TestMetadata("outerMemberAccesses.kt")
            public void testOuterMemberAccesses() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/outerMemberAccesses.kt");
            }

            @Test
            @TestMetadata("outerObject.kt")
            public void testOuterObject() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/outerObject.kt");
            }

            @Test
            @TestMetadata("overriddenJavaGetter.kt")
            public void testOverriddenJavaGetter() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/overriddenJavaGetter.kt");
            }

            @Test
            @TestMetadata("privateObjectLiteral.kt")
            public void testPrivateObjectLiteral() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/privateObjectLiteral.kt");
            }

            @Test
            @TestMetadata("privateVisibility.kt")
            public void testPrivateVisibility() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/privateVisibility.kt");
            }

            @Test
            @TestMetadata("protectedVisibility.kt")
            public void testProtectedVisibility() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/protectedVisibility.kt");
            }

            @Test
            @TestMetadata("qualifiedExpressions.kt")
            public void testQualifiedExpressions() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/qualifiedExpressions.kt");
            }

            @Test
            @TestMetadata("qualifierPriority.kt")
            public void testQualifierPriority() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/qualifierPriority.kt");
            }

            @Test
            @TestMetadata("receiverConsistency.kt")
            public void testReceiverConsistency() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/receiverConsistency.kt");
            }

            @Test
            @TestMetadata("sameReceiver.kt")
            public void testSameReceiver() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/sameReceiver.kt");
            }

            @Test
            @TestMetadata("simple.kt")
            public void testSimple() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/simple.kt");
            }

            @Test
            @TestMetadata("syntheticInImplicitBody.kt")
            public void testSyntheticInImplicitBody() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/syntheticInImplicitBody.kt");
            }

            @Test
            @TestMetadata("syntheticSmartCast.kt")
            public void testSyntheticSmartCast() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/syntheticSmartCast.kt");
            }

            @Test
            @TestMetadata("this.kt")
            public void testThis() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/this.kt");
            }

            @Test
            @TestMetadata("topExtensionVsOuterMember.kt")
            public void testTopExtensionVsOuterMember() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/topExtensionVsOuterMember.kt");
            }

            @Test
            @TestMetadata("typeAliasConstructor.kt")
            public void testTypeAliasConstructor() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/typeAliasConstructor.kt");
            }

            @Test
            @TestMetadata("vararg.kt")
            public void testVararg() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/vararg.kt");
            }

            @Test
            @TestMetadata("when.kt")
            public void testWhen() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/when.kt");
            }

            @Nested
            @TestMetadata("compiler/fir/analysis-tests/testData/resolve/expresssions/inference")
            @TestDataPath("$PROJECT_ROOT")
            public class Inference {
                @Test
                public void testAllFilesPresentInInference() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/expresssions/inference"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
                }

                @Test
                @TestMetadata("id.kt")
                public void testId() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/inference/id.kt");
                }

                @Test
                @TestMetadata("typeParameters.kt")
                public void testTypeParameters() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/inference/typeParameters.kt");
                }

                @Test
                @TestMetadata("typeParameters2.kt")
                public void testTypeParameters2() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/inference/typeParameters2.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/fir/analysis-tests/testData/resolve/expresssions/invoke")
            @TestDataPath("$PROJECT_ROOT")
            public class Invoke {
                @Test
                public void testAllFilesPresentInInvoke() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/expresssions/invoke"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
                }

                @Test
                @TestMetadata("doubleBrackets.kt")
                public void testDoubleBrackets() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/invoke/doubleBrackets.kt");
                }

                @Test
                @TestMetadata("explicitReceiver.kt")
                public void testExplicitReceiver() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/invoke/explicitReceiver.kt");
                }

                @Test
                @TestMetadata("explicitReceiver2.kt")
                public void testExplicitReceiver2() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/invoke/explicitReceiver2.kt");
                }

                @Test
                @TestMetadata("extension.kt")
                public void testExtension() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/invoke/extension.kt");
                }

                @Test
                @TestMetadata("extensionOnObject.kt")
                public void testExtensionOnObject() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/invoke/extensionOnObject.kt");
                }

                @Test
                @TestMetadata("extensionSafeCall.kt")
                public void testExtensionSafeCall() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/invoke/extensionSafeCall.kt");
                }

                @Test
                @TestMetadata("farInvokeExtension.kt")
                public void testFarInvokeExtension() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/invoke/farInvokeExtension.kt");
                }

                @Test
                @TestMetadata("implicitTypeOrder.kt")
                public void testImplicitTypeOrder() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/invoke/implicitTypeOrder.kt");
                }

                @Test
                @TestMetadata("inBrackets.kt")
                public void testInBrackets() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/invoke/inBrackets.kt");
                }

                @Test
                @TestMetadata("incorrectInvokeReceiver.kt")
                public void testIncorrectInvokeReceiver() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/invoke/incorrectInvokeReceiver.kt");
                }

                @Test
                @TestMetadata("propertyFromParameter.kt")
                public void testPropertyFromParameter() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/invoke/propertyFromParameter.kt");
                }

                @Test
                @TestMetadata("propertyWithExtensionType.kt")
                public void testPropertyWithExtensionType() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/invoke/propertyWithExtensionType.kt");
                }

                @Test
                @TestMetadata("simple.kt")
                public void testSimple() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/invoke/simple.kt");
                }

                @Test
                @TestMetadata("threeReceivers.kt")
                public void testThreeReceivers() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/invoke/threeReceivers.kt");
                }

                @Test
                @TestMetadata("threeReceiversCorrect.kt")
                public void testThreeReceiversCorrect() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/invoke/threeReceiversCorrect.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/fir/analysis-tests/testData/resolve/expresssions/operators")
            @TestDataPath("$PROJECT_ROOT")
            public class Operators {
                @Test
                public void testAllFilesPresentInOperators() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/expresssions/operators"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
                }

                @Test
                @TestMetadata("plus.kt")
                public void testPlus() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/operators/plus.kt");
                }

                @Test
                @TestMetadata("plusAndPlusAssign.kt")
                public void testPlusAndPlusAssign() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/operators/plusAndPlusAssign.kt");
                }

                @Test
                @TestMetadata("plusAssign.kt")
                public void testPlusAssign() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/expresssions/operators/plusAssign.kt");
                }
            }
        }

        @Nested
        @TestMetadata("compiler/fir/analysis-tests/testData/resolve/extendedCheckers")
        @TestDataPath("$PROJECT_ROOT")
        public class ExtendedCheckers {
            @Test
            public void testAllFilesPresentInExtendedCheckers() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/extendedCheckers"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
            }

            @Test
            @TestMetadata("ArrayEqualityCanBeReplacedWithEquals.kt")
            public void testArrayEqualityCanBeReplacedWithEquals() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/ArrayEqualityCanBeReplacedWithEquals.kt");
            }

            @Test
            @TestMetadata("CanBeValChecker.kt")
            public void testCanBeValChecker() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/CanBeValChecker.kt");
            }

            @Test
            @TestMetadata("RedundantExplicitTypeChecker.kt")
            public void testRedundantExplicitTypeChecker() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/RedundantExplicitTypeChecker.kt");
            }

            @Test
            @TestMetadata("RedundantModalityModifierChecker.kt")
            public void testRedundantModalityModifierChecker() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/RedundantModalityModifierChecker.kt");
            }

            @Test
            @TestMetadata("RedundantReturnUnitTypeChecker.kt")
            public void testRedundantReturnUnitTypeChecker() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/RedundantReturnUnitTypeChecker.kt");
            }

            @Test
            @TestMetadata("RedundantSetterParameterTypeChecker.kt")
            public void testRedundantSetterParameterTypeChecker() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/RedundantSetterParameterTypeChecker.kt");
            }

            @Test
            @TestMetadata("RedundantSingleExpressionStringTemplateChecker.kt")
            public void testRedundantSingleExpressionStringTemplateChecker() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/RedundantSingleExpressionStringTemplateChecker.kt");
            }

            @Test
            @TestMetadata("RedundantVisibilityDueToOverride.kt")
            public void testRedundantVisibilityDueToOverride() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/RedundantVisibilityDueToOverride.kt");
            }

            @Test
            @TestMetadata("RedundantVisibilityModifierChecker.kt")
            public void testRedundantVisibilityModifierChecker() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/RedundantVisibilityModifierChecker.kt");
            }

            @Test
            @TestMetadata("RedundantVisibilityModifierCheckerForInnerComponents.kt")
            public void testRedundantVisibilityModifierCheckerForInnerComponents() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/RedundantVisibilityModifierCheckerForInnerComponents.kt");
            }

            @Nested
            @TestMetadata("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/canBeReplacedWithOperatorAssignment")
            @TestDataPath("$PROJECT_ROOT")
            public class CanBeReplacedWithOperatorAssignment {
                @Test
                public void testAllFilesPresentInCanBeReplacedWithOperatorAssignment() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/canBeReplacedWithOperatorAssignment"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
                }

                @Test
                @TestMetadata("BasicTest.kt")
                public void testBasicTest() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/canBeReplacedWithOperatorAssignment/BasicTest.kt");
                }

                @Test
                @TestMetadata("ComplexExpression.kt")
                public void testComplexExpression() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/canBeReplacedWithOperatorAssignment/ComplexExpression.kt");
                }

                @Test
                @TestMetadata("flexibleTypeBug.kt")
                public void testFlexibleTypeBug() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/canBeReplacedWithOperatorAssignment/flexibleTypeBug.kt");
                }

                @Test
                @TestMetadata("illegalMultipleOperators.kt")
                public void testIllegalMultipleOperators() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/canBeReplacedWithOperatorAssignment/illegalMultipleOperators.kt");
                }

                @Test
                @TestMetadata("illegalMultipleOperatorsMiddle.kt")
                public void testIllegalMultipleOperatorsMiddle() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/canBeReplacedWithOperatorAssignment/illegalMultipleOperatorsMiddle.kt");
                }

                @Test
                @TestMetadata("invalidSubtraction.kt")
                public void testInvalidSubtraction() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/canBeReplacedWithOperatorAssignment/invalidSubtraction.kt");
                }

                @Test
                @TestMetadata("list.kt")
                public void testList() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/canBeReplacedWithOperatorAssignment/list.kt");
                }

                @Test
                @TestMetadata("logicOperators.kt")
                public void testLogicOperators() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/canBeReplacedWithOperatorAssignment/logicOperators.kt");
                }

                @Test
                @TestMetadata("multipleOperators.kt")
                public void testMultipleOperators() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/canBeReplacedWithOperatorAssignment/multipleOperators.kt");
                }

                @Test
                @TestMetadata("multipleOperatorsRightSideRepeat.kt")
                public void testMultipleOperatorsRightSideRepeat() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/canBeReplacedWithOperatorAssignment/multipleOperatorsRightSideRepeat.kt");
                }

                @Test
                @TestMetadata("mutableList.kt")
                public void testMutableList() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/canBeReplacedWithOperatorAssignment/mutableList.kt");
                }

                @Test
                @TestMetadata("nonCommutativeRepeat.kt")
                public void testNonCommutativeRepeat() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/canBeReplacedWithOperatorAssignment/nonCommutativeRepeat.kt");
                }

                @Test
                @TestMetadata("nonRepeatingAssignment.kt")
                public void testNonRepeatingAssignment() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/canBeReplacedWithOperatorAssignment/nonRepeatingAssignment.kt");
                }

                @Test
                @TestMetadata("OperatorAssignment.kt")
                public void testOperatorAssignment() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/canBeReplacedWithOperatorAssignment/OperatorAssignment.kt");
                }

                @Test
                @TestMetadata("plusAssignConflict.kt")
                public void testPlusAssignConflict() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/canBeReplacedWithOperatorAssignment/plusAssignConflict.kt");
                }

                @Test
                @TestMetadata("rightSideRepeat.kt")
                public void testRightSideRepeat() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/canBeReplacedWithOperatorAssignment/rightSideRepeat.kt");
                }

                @Test
                @TestMetadata("simpleAssign.kt")
                public void testSimpleAssign() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/canBeReplacedWithOperatorAssignment/simpleAssign.kt");
                }

                @Test
                @TestMetadata("validAddition.kt")
                public void testValidAddition() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/canBeReplacedWithOperatorAssignment/validAddition.kt");
                }

                @Test
                @TestMetadata("validSubtraction.kt")
                public void testValidSubtraction() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/canBeReplacedWithOperatorAssignment/validSubtraction.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/emptyRangeChecker")
            @TestDataPath("$PROJECT_ROOT")
            public class EmptyRangeChecker {
                @Test
                public void testAllFilesPresentInEmptyRangeChecker() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/emptyRangeChecker"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
                }

                @Test
                @TestMetadata("NoWarning.kt")
                public void testNoWarning() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/emptyRangeChecker/NoWarning.kt");
                }

                @Test
                @TestMetadata("Warning.kt")
                public void testWarning() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/emptyRangeChecker/Warning.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/RedundantCallOfConversionMethod")
            @TestDataPath("$PROJECT_ROOT")
            public class RedundantCallOfConversionMethod {
                @Test
                public void testAllFilesPresentInRedundantCallOfConversionMethod() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/RedundantCallOfConversionMethod"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
                }

                @Test
                @TestMetadata("booleanToInt.kt")
                public void testBooleanToInt() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/RedundantCallOfConversionMethod/booleanToInt.kt");
                }

                @Test
                @TestMetadata("byte.kt")
                public void testByte() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/RedundantCallOfConversionMethod/byte.kt");
                }

                @Test
                @TestMetadata("char.kt")
                public void testChar() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/RedundantCallOfConversionMethod/char.kt");
                }

                @Test
                @TestMetadata("double.kt")
                public void testDouble() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/RedundantCallOfConversionMethod/double.kt");
                }

                @Test
                @TestMetadata("float.kt")
                public void testFloat() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/RedundantCallOfConversionMethod/float.kt");
                }

                @Test
                @TestMetadata("int.kt")
                public void testInt() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/RedundantCallOfConversionMethod/int.kt");
                }

                @Test
                @TestMetadata("long.kt")
                public void testLong() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/RedundantCallOfConversionMethod/long.kt");
                }

                @Test
                @TestMetadata("nullable.kt")
                public void testNullable() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/RedundantCallOfConversionMethod/nullable.kt");
                }

                @Test
                @TestMetadata("nullable2.kt")
                public void testNullable2() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/RedundantCallOfConversionMethod/nullable2.kt");
                }

                @Test
                @TestMetadata("safeString.kt")
                public void testSafeString() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/RedundantCallOfConversionMethod/safeString.kt");
                }

                @Test
                @TestMetadata("safeString2.kt")
                public void testSafeString2() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/RedundantCallOfConversionMethod/safeString2.kt");
                }

                @Test
                @TestMetadata("short.kt")
                public void testShort() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/RedundantCallOfConversionMethod/short.kt");
                }

                @Test
                @TestMetadata("string.kt")
                public void testString() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/RedundantCallOfConversionMethod/string.kt");
                }

                @Test
                @TestMetadata("StringTemplate.kt")
                public void testStringTemplate() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/RedundantCallOfConversionMethod/StringTemplate.kt");
                }

                @Test
                @TestMetadata("toOtherType.kt")
                public void testToOtherType() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/RedundantCallOfConversionMethod/toOtherType.kt");
                }

                @Test
                @TestMetadata("uByte.kt")
                public void testUByte() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/RedundantCallOfConversionMethod/uByte.kt");
                }

                @Test
                @TestMetadata("uInt.kt")
                public void testUInt() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/RedundantCallOfConversionMethod/uInt.kt");
                }

                @Test
                @TestMetadata("uLong.kt")
                public void testULong() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/RedundantCallOfConversionMethod/uLong.kt");
                }

                @Test
                @TestMetadata("uShort.kt")
                public void testUShort() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/RedundantCallOfConversionMethod/uShort.kt");
                }

                @Test
                @TestMetadata("variable.kt")
                public void testVariable() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/RedundantCallOfConversionMethod/variable.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/unused")
            @TestDataPath("$PROJECT_ROOT")
            public class Unused {
                @Test
                public void testAllFilesPresentInUnused() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/unused"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
                }

                @Test
                @TestMetadata("classProperty.kt")
                public void testClassProperty() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/unused/classProperty.kt");
                }

                @Test
                @TestMetadata("invoke.kt")
                public void testInvoke() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/unused/invoke.kt");
                }

                @Test
                @TestMetadata("lambda.kt")
                public void testLambda() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/unused/lambda.kt");
                }

                @Test
                @TestMetadata("localVariable.kt")
                public void testLocalVariable() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/unused/localVariable.kt");
                }

                @Test
                @TestMetadata("manyLocalVariables.kt")
                public void testManyLocalVariables() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/unused/manyLocalVariables.kt");
                }

                @Test
                @TestMetadata("usedInAnnotationArguments.kt")
                public void testUsedInAnnotationArguments() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/unused/usedInAnnotationArguments.kt");
                }

                @Test
                @TestMetadata("valueIsNeverRead.kt")
                public void testValueIsNeverRead() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/unused/valueIsNeverRead.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/UselessCallOnNotNullChecker")
            @TestDataPath("$PROJECT_ROOT")
            public class UselessCallOnNotNullChecker {
                @Test
                public void testAllFilesPresentInUselessCallOnNotNullChecker() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/UselessCallOnNotNullChecker"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
                }

                @Test
                @TestMetadata("Basic.kt")
                public void testBasic() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/UselessCallOnNotNullChecker/Basic.kt");
                }

                @Test
                @TestMetadata("NotNullType.kt")
                public void testNotNullType() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/UselessCallOnNotNullChecker/NotNullType.kt");
                }

                @Test
                @TestMetadata("NotNullTypeChain.kt")
                public void testNotNullTypeChain() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/UselessCallOnNotNullChecker/NotNullTypeChain.kt");
                }

                @Test
                @TestMetadata("NullOrBlankSafe.kt")
                public void testNullOrBlankSafe() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/UselessCallOnNotNullChecker/NullOrBlankSafe.kt");
                }

                @Test
                @TestMetadata("NullOrEmpty.kt")
                public void testNullOrEmpty() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/UselessCallOnNotNullChecker/NullOrEmpty.kt");
                }

                @Test
                @TestMetadata("NullOrEmptyFake.kt")
                public void testNullOrEmptyFake() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/UselessCallOnNotNullChecker/NullOrEmptyFake.kt");
                }

                @Test
                @TestMetadata("NullOrEmptySafe.kt")
                public void testNullOrEmptySafe() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/UselessCallOnNotNullChecker/NullOrEmptySafe.kt");
                }

                @Test
                @TestMetadata("OrEmptyFake.kt")
                public void testOrEmptyFake() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/UselessCallOnNotNullChecker/OrEmptyFake.kt");
                }

                @Test
                @TestMetadata("SafeCall.kt")
                public void testSafeCall() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/UselessCallOnNotNullChecker/SafeCall.kt");
                }

                @Test
                @TestMetadata("Sequence.kt")
                public void testSequence() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/UselessCallOnNotNullChecker/Sequence.kt");
                }

                @Test
                @TestMetadata("String.kt")
                public void testString() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/extendedCheckers/UselessCallOnNotNullChecker/String.kt");
                }
            }
        }

        @Nested
        @TestMetadata("compiler/fir/analysis-tests/testData/resolve/fromBuilder")
        @TestDataPath("$PROJECT_ROOT")
        public class FromBuilder {
            @Test
            public void testAllFilesPresentInFromBuilder() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/fromBuilder"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
            }

            @Test
            @TestMetadata("complexTypes.kt")
            public void testComplexTypes() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/fromBuilder/complexTypes.kt");
            }

            @Test
            @TestMetadata("enums.kt")
            public void testEnums() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/fromBuilder/enums.kt");
            }

            @Test
            @TestMetadata("noPrimaryConstructor.kt")
            public void testNoPrimaryConstructor() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/fromBuilder/noPrimaryConstructor.kt");
            }

            @Test
            @TestMetadata("simpleClass.kt")
            public void testSimpleClass() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/fromBuilder/simpleClass.kt");
            }

            @Test
            @TestMetadata("typeParameters.kt")
            public void testTypeParameters() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/fromBuilder/typeParameters.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/fir/analysis-tests/testData/resolve/inference")
        @TestDataPath("$PROJECT_ROOT")
        public class Inference {
            @Test
            public void testAllFilesPresentInInference() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/inference"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
            }

            @Test
            @TestMetadata("callableReferenceOnInstance.kt")
            public void testCallableReferenceOnInstance() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/inference/callableReferenceOnInstance.kt");
            }

            @Test
            @TestMetadata("callableReferenceToLocalClass.kt")
            public void testCallableReferenceToLocalClass() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/inference/callableReferenceToLocalClass.kt");
            }

            @Test
            @TestMetadata("callableReferencesAndDefaultParameters.kt")
            public void testCallableReferencesAndDefaultParameters() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/inference/callableReferencesAndDefaultParameters.kt");
            }

            @Test
            @TestMetadata("capturedTypeForJavaTypeParameter.kt")
            public void testCapturedTypeForJavaTypeParameter() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/inference/capturedTypeForJavaTypeParameter.kt");
            }

            @Test
            @TestMetadata("coercionToUnitWithEarlyReturn.kt")
            public void testCoercionToUnitWithEarlyReturn() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/inference/coercionToUnitWithEarlyReturn.kt");
            }

            @Test
            @TestMetadata("definitelyNotNullIntersectionType.kt")
            public void testDefinitelyNotNullIntersectionType() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/inference/definitelyNotNullIntersectionType.kt");
            }

            @Test
            @TestMetadata("dnnThrowJavaCall.kt")
            public void testDnnThrowJavaCall() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/inference/dnnThrowJavaCall.kt");
            }

            @Test
            @TestMetadata("elvisAndUnit.kt")
            public void testElvisAndUnit() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/inference/elvisAndUnit.kt");
            }

            @Test
            @TestMetadata("equals.kt")
            public void testEquals() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/inference/equals.kt");
            }

            @Test
            @TestMetadata("extensionCallableReferences.kt")
            public void testExtensionCallableReferences() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/inference/extensionCallableReferences.kt");
            }

            @Test
            @TestMetadata("integerLiteralAsComparable.kt")
            public void testIntegerLiteralAsComparable() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/inference/integerLiteralAsComparable.kt");
            }

            @Test
            @TestMetadata("intersectionTypesInConstraints.kt")
            public void testIntersectionTypesInConstraints() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/inference/intersectionTypesInConstraints.kt");
            }

            @Test
            @TestMetadata("kt40131.kt")
            public void testKt40131() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/inference/kt40131.kt");
            }

            @Test
            @TestMetadata("kt41989.kt")
            public void testKt41989() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/inference/kt41989.kt");
            }

            @Test
            @TestMetadata("lambdaAsReturnStatementOfLambda.kt")
            public void testLambdaAsReturnStatementOfLambda() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/inference/lambdaAsReturnStatementOfLambda.kt");
            }

            @Test
            @TestMetadata("lambdaInElvis.kt")
            public void testLambdaInElvis() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/inference/lambdaInElvis.kt");
            }

            @Test
            @TestMetadata("lambdaWithoutExpectedType.kt")
            public void testLambdaWithoutExpectedType() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/inference/lambdaWithoutExpectedType.kt");
            }

            @Test
            @TestMetadata("lambdasReturns.kt")
            public void testLambdasReturns() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/inference/lambdasReturns.kt");
            }

            @Test
            @TestMetadata("nestedExtensionFunctionType.kt")
            public void testNestedExtensionFunctionType() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/inference/nestedExtensionFunctionType.kt");
            }

            @Test
            @TestMetadata("nestedLambdas.kt")
            public void testNestedLambdas() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/inference/nestedLambdas.kt");
            }

            @Test
            @TestMetadata("nullableIntegerLiteralType.kt")
            public void testNullableIntegerLiteralType() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/inference/nullableIntegerLiteralType.kt");
            }

            @Test
            @TestMetadata("receiverWithCapturedType.kt")
            public void testReceiverWithCapturedType() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/inference/receiverWithCapturedType.kt");
            }

            @Test
            @TestMetadata("simpleCapturedTypes.kt")
            public void testSimpleCapturedTypes() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/inference/simpleCapturedTypes.kt");
            }

            @Test
            @TestMetadata("typeDepthForTypeAlias.kt")
            public void testTypeDepthForTypeAlias() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/inference/typeDepthForTypeAlias.kt");
            }

            @Test
            @TestMetadata("unitUpperBound.kt")
            public void testUnitUpperBound() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/inference/unitUpperBound.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/fir/analysis-tests/testData/resolve/inlineClasses")
        @TestDataPath("$PROJECT_ROOT")
        public class InlineClasses {
            @Test
            public void testAllFilesPresentInInlineClasses() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/inlineClasses"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
            }

            @Test
            @TestMetadata("inlineClassConstructor.kt")
            public void testInlineClassConstructor() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/inlineClasses/inlineClassConstructor.kt");
            }

            @Test
            @TestMetadata("inlineClassDeclaration.kt")
            public void testInlineClassDeclaration() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/inlineClasses/inlineClassDeclaration.kt");
            }

            @Test
            @TestMetadata("inlineClassMembers.kt")
            public void testInlineClassMembers() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/inlineClasses/inlineClassMembers.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/fir/analysis-tests/testData/resolve/innerClasses")
        @TestDataPath("$PROJECT_ROOT")
        public class InnerClasses {
            @Test
            public void testAllFilesPresentInInnerClasses() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/innerClasses"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
            }

            @Test
            @TestMetadata("inner.kt")
            public void testInner() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/innerClasses/inner.kt");
            }

            @Test
            @TestMetadata("innerTypeFromSuperClassInBody.kt")
            public void testInnerTypeFromSuperClassInBody() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/innerClasses/innerTypeFromSuperClassInBody.kt");
            }

            @Test
            @TestMetadata("innerTypes.kt")
            public void testInnerTypes() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/innerClasses/innerTypes.kt");
            }

            @Test
            @TestMetadata("simple.kt")
            public void testSimple() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/innerClasses/simple.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/fir/analysis-tests/testData/resolve/localClasses")
        @TestDataPath("$PROJECT_ROOT")
        public class LocalClasses {
            @Test
            public void testAllFilesPresentInLocalClasses() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/localClasses"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
            }

            @Test
            @TestMetadata("anonymousInAnonymous.kt")
            public void testAnonymousInAnonymous() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/localClasses/anonymousInAnonymous.kt");
            }

            @Test
            @TestMetadata("implicitInAnonymous.kt")
            public void testImplicitInAnonymous() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/localClasses/implicitInAnonymous.kt");
            }

            @Test
            @TestMetadata("implicitInLocalClasses.kt")
            public void testImplicitInLocalClasses() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/localClasses/implicitInLocalClasses.kt");
            }

            @Test
            @TestMetadata("typesFromSuperClasses.kt")
            public void testTypesFromSuperClasses() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/localClasses/typesFromSuperClasses.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/fir/analysis-tests/testData/resolve/multifile")
        @TestDataPath("$PROJECT_ROOT")
        public class Multifile {
            @Test
            public void testAllFilesPresentInMultifile() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/multifile"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
            }

            @Test
            @TestMetadata("Annotations.kt")
            public void testAnnotations() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/multifile/Annotations.kt");
            }

            @Test
            @TestMetadata("ByteArray.kt")
            public void testByteArray() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/multifile/ByteArray.kt");
            }

            @Test
            @TestMetadata("importFromObject.kt")
            public void testImportFromObject() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/multifile/importFromObject.kt");
            }

            @Test
            @TestMetadata("NestedSuperType.kt")
            public void testNestedSuperType() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/multifile/NestedSuperType.kt");
            }

            @Test
            @TestMetadata("sealedStarImport.kt")
            public void testSealedStarImport() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/multifile/sealedStarImport.kt");
            }

            @Test
            @TestMetadata("simpleAliasedImport.kt")
            public void testSimpleAliasedImport() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/multifile/simpleAliasedImport.kt");
            }

            @Test
            @TestMetadata("simpleImport.kt")
            public void testSimpleImport() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/multifile/simpleImport.kt");
            }

            @Test
            @TestMetadata("simpleImportNested.kt")
            public void testSimpleImportNested() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/multifile/simpleImportNested.kt");
            }

            @Test
            @TestMetadata("simpleImportOuter.kt")
            public void testSimpleImportOuter() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/multifile/simpleImportOuter.kt");
            }

            @Test
            @TestMetadata("simpleStarImport.kt")
            public void testSimpleStarImport() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/multifile/simpleStarImport.kt");
            }

            @Test
            @TestMetadata("TypeAliasExpansion.kt")
            public void testTypeAliasExpansion() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/multifile/TypeAliasExpansion.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/fir/analysis-tests/testData/resolve/overrides")
        @TestDataPath("$PROJECT_ROOT")
        public class Overrides {
            @Test
            public void testAllFilesPresentInOverrides() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/overrides"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
            }

            @Test
            @TestMetadata("generics.kt")
            public void testGenerics() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/overrides/generics.kt");
            }

            @Test
            @TestMetadata("protobufExt.kt")
            public void testProtobufExt() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/overrides/protobufExt.kt");
            }

            @Test
            @TestMetadata("sameValueParametersDifferentReceiver.kt")
            public void testSameValueParametersDifferentReceiver() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/overrides/sameValueParametersDifferentReceiver.kt");
            }

            @Test
            @TestMetadata("simple.kt")
            public void testSimple() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/overrides/simple.kt");
            }

            @Test
            @TestMetadata("simpleFakeOverride.kt")
            public void testSimpleFakeOverride() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/overrides/simpleFakeOverride.kt");
            }

            @Test
            @TestMetadata("simpleMostSpecific.kt")
            public void testSimpleMostSpecific() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/overrides/simpleMostSpecific.kt");
            }

            @Test
            @TestMetadata("supertypeGenerics.kt")
            public void testSupertypeGenerics() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/overrides/supertypeGenerics.kt");
            }

            @Test
            @TestMetadata("supertypeGenericsComplex.kt")
            public void testSupertypeGenericsComplex() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/overrides/supertypeGenericsComplex.kt");
            }

            @Test
            @TestMetadata("three.kt")
            public void testThree() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/overrides/three.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/fir/analysis-tests/testData/resolve/problems")
        @TestDataPath("$PROJECT_ROOT")
        public class Problems {
            @Test
            public void testAllFilesPresentInProblems() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/problems"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
            }

            @Test
            @TestMetadata("compilerPhase.kt")
            public void testCompilerPhase() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/problems/compilerPhase.kt");
            }

            @Test
            @TestMetadata("complexLambdaWithTypeVariableAsExpectedType.kt")
            public void testComplexLambdaWithTypeVariableAsExpectedType() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/problems/complexLambdaWithTypeVariableAsExpectedType.kt");
            }

            @Test
            @TestMetadata("defaultParametersFromDifferentScopes.kt")
            public void testDefaultParametersFromDifferentScopes() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/problems/defaultParametersFromDifferentScopes.kt");
            }

            @Test
            @TestMetadata("definitelyNotNullAndOriginalType.kt")
            public void testDefinitelyNotNullAndOriginalType() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/problems/definitelyNotNullAndOriginalType.kt");
            }

            @Test
            @TestMetadata("doubleGenericDiamond.kt")
            public void testDoubleGenericDiamond() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/problems/doubleGenericDiamond.kt");
            }

            @Test
            @TestMetadata("emptySelectorInQualifiedExpression.kt")
            public void testEmptySelectorInQualifiedExpression() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/problems/emptySelectorInQualifiedExpression.kt");
            }

            @Test
            @TestMetadata("expectConstructor.kt")
            public void testExpectConstructor() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/problems/expectConstructor.kt");
            }

            @Test
            @TestMetadata("fakeTypeMismatchOnExtensionReference.kt")
            public void testFakeTypeMismatchOnExtensionReference() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/problems/fakeTypeMismatchOnExtensionReference.kt");
            }

            @Test
            @TestMetadata("falseIntersection.kt")
            public void testFalseIntersection() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/problems/falseIntersection.kt");
            }

            @Test
            @TestMetadata("flexibleTypeVarAgainstNull.kt")
            public void testFlexibleTypeVarAgainstNull() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/problems/flexibleTypeVarAgainstNull.kt");
            }

            @Test
            @TestMetadata("inaccessibleJavaGetter.kt")
            public void testInaccessibleJavaGetter() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/problems/inaccessibleJavaGetter.kt");
            }

            @Test
            @TestMetadata("innerClassHierarchy.kt")
            public void testInnerClassHierarchy() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/problems/innerClassHierarchy.kt");
            }

            @Test
            @TestMetadata("javaQualifier.kt")
            public void testJavaQualifier() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/problems/javaQualifier.kt");
            }

            @Test
            @TestMetadata("kt42346.kt")
            public void testKt42346() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/problems/kt42346.kt");
            }

            @Test
            @TestMetadata("multipleJavaClassesInOneFile.kt")
            public void testMultipleJavaClassesInOneFile() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/problems/multipleJavaClassesInOneFile.kt");
            }

            @Test
            @TestMetadata("objectDerivedFromInnerClass.kt")
            public void testObjectDerivedFromInnerClass() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/problems/objectDerivedFromInnerClass.kt");
            }

            @Test
            @TestMetadata("questionableSmartCast.kt")
            public void testQuestionableSmartCast() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/problems/questionableSmartCast.kt");
            }

            @Test
            @TestMetadata("recursiveNamedAnnotation.kt")
            public void testRecursiveNamedAnnotation() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/problems/recursiveNamedAnnotation.kt");
            }

            @Test
            @TestMetadata("safeCallInvoke.kt")
            public void testSafeCallInvoke() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/problems/safeCallInvoke.kt");
            }

            @Test
            @TestMetadata("secondaryConstructorCfg.kt")
            public void testSecondaryConstructorCfg() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/problems/secondaryConstructorCfg.kt");
            }

            @Test
            @TestMetadata("symbolsAndDescriptors.kt")
            public void testSymbolsAndDescriptors() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/problems/symbolsAndDescriptors.kt");
            }

            @Test
            @TestMetadata("transform.kt")
            public void testTransform() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/problems/transform.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/fir/analysis-tests/testData/resolve/properties")
        @TestDataPath("$PROJECT_ROOT")
        public class Properties {
            @Test
            public void testAllFilesPresentInProperties() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/properties"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
            }

            @Test
            @TestMetadata("javaAccessorConversion.kt")
            public void testJavaAccessorConversion() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/properties/javaAccessorConversion.kt");
            }

            @Test
            @TestMetadata("javaAccessorsComplex.kt")
            public void testJavaAccessorsComplex() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/properties/javaAccessorsComplex.kt");
            }

            @Test
            @TestMetadata("kotlinOverridesJavaComplex.kt")
            public void testKotlinOverridesJavaComplex() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/properties/kotlinOverridesJavaComplex.kt");
            }

            @Test
            @TestMetadata("noBackingFieldForExtension.kt")
            public void testNoBackingFieldForExtension() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/properties/noBackingFieldForExtension.kt");
            }

            @Test
            @TestMetadata("noBackingFieldInProperty.kt")
            public void testNoBackingFieldInProperty() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/properties/noBackingFieldInProperty.kt");
            }

            @Test
            @TestMetadata("syntheticPropertiesForJavaAnnotations.kt")
            public void testSyntheticPropertiesForJavaAnnotations() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/properties/syntheticPropertiesForJavaAnnotations.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/fir/analysis-tests/testData/resolve/references")
        @TestDataPath("$PROJECT_ROOT")
        public class References {
            @Test
            public void testAllFilesPresentInReferences() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/references"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
            }

            @Test
            @TestMetadata("integerLiteralInLhs.kt")
            public void testIntegerLiteralInLhs() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/references/integerLiteralInLhs.kt");
            }

            @Test
            @TestMetadata("leakedImplicitType.kt")
            public void testLeakedImplicitType() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/references/leakedImplicitType.kt");
            }

            @Test
            @TestMetadata("referenceToExtension.kt")
            public void testReferenceToExtension() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/references/referenceToExtension.kt");
            }

            @Test
            @TestMetadata("referenceToField.kt")
            public void testReferenceToField() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/references/referenceToField.kt");
            }

            @Test
            @TestMetadata("simple.kt")
            public void testSimple() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/references/simple.kt");
            }

            @Test
            @TestMetadata("superMember.kt")
            public void testSuperMember() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/references/superMember.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/fir/analysis-tests/testData/resolve/samConstructors")
        @TestDataPath("$PROJECT_ROOT")
        public class SamConstructors {
            @Test
            public void testAllFilesPresentInSamConstructors() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/samConstructors"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
            }

            @Test
            @TestMetadata("funInterfaceConstructorReference.kt")
            public void testFunInterfaceConstructorReference() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/samConstructors/funInterfaceConstructorReference.kt");
            }

            @Test
            @TestMetadata("genericSam.kt")
            public void testGenericSam() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/samConstructors/genericSam.kt");
            }

            @Test
            @TestMetadata("genericSamInferenceFromExpectType.kt")
            public void testGenericSamInferenceFromExpectType() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/samConstructors/genericSamInferenceFromExpectType.kt");
            }

            @Test
            @TestMetadata("kotlinSam.kt")
            public void testKotlinSam() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/samConstructors/kotlinSam.kt");
            }

            @Test
            @TestMetadata("realConstructorFunction.kt")
            public void testRealConstructorFunction() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/samConstructors/realConstructorFunction.kt");
            }

            @Test
            @TestMetadata("runnable.kt")
            public void testRunnable() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/samConstructors/runnable.kt");
            }

            @Test
            @TestMetadata("simple.kt")
            public void testSimple() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/samConstructors/simple.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/fir/analysis-tests/testData/resolve/samConversions")
        @TestDataPath("$PROJECT_ROOT")
        public class SamConversions {
            @Test
            public void testAllFilesPresentInSamConversions() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/samConversions"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
            }

            @Test
            @TestMetadata("genericSam.kt")
            public void testGenericSam() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/samConversions/genericSam.kt");
            }

            @Test
            @TestMetadata("kotlinSam.kt")
            public void testKotlinSam() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/samConversions/kotlinSam.kt");
            }

            @Test
            @TestMetadata("notSamBecauseOfSupertype.kt")
            public void testNotSamBecauseOfSupertype() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/samConversions/notSamBecauseOfSupertype.kt");
            }

            @Test
            @TestMetadata("runnable.kt")
            public void testRunnable() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/samConversions/runnable.kt");
            }

            @Test
            @TestMetadata("samConversionInConstructorCall.kt")
            public void testSamConversionInConstructorCall() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/samConversions/samConversionInConstructorCall.kt");
            }

            @Test
            @TestMetadata("samSupertype.kt")
            public void testSamSupertype() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/samConversions/samSupertype.kt");
            }

            @Test
            @TestMetadata("samSupertypeWithOverride.kt")
            public void testSamSupertypeWithOverride() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/samConversions/samSupertypeWithOverride.kt");
            }

            @Test
            @TestMetadata("samWithEquals.kt")
            public void testSamWithEquals() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/samConversions/samWithEquals.kt");
            }

            @Test
            @TestMetadata("simple.kt")
            public void testSimple() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/samConversions/simple.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/fir/analysis-tests/testData/resolve/scopes")
        @TestDataPath("$PROJECT_ROOT")
        public class Scopes {
            @Test
            public void testAllFilesPresentInScopes() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/scopes"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
            }

            @Test
            @TestMetadata("explicitOverrideOfTwoMembers.kt")
            public void testExplicitOverrideOfTwoMembers() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/scopes/explicitOverrideOfTwoMembers.kt");
            }

            @Test
            @TestMetadata("explicitOverrideOfTwoMembers_java.kt")
            public void testExplicitOverrideOfTwoMembers_java() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/scopes/explicitOverrideOfTwoMembers_java.kt");
            }

            @Test
            @TestMetadata("getterOverrideAndKotlinProperty.kt")
            public void testGetterOverrideAndKotlinProperty() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/scopes/getterOverrideAndKotlinProperty.kt");
            }

            @Test
            @TestMetadata("intersectionOverrideOfTwoMembers.kt")
            public void testIntersectionOverrideOfTwoMembers() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/scopes/intersectionOverrideOfTwoMembers.kt");
            }

            @Test
            @TestMetadata("intersectionOverrideOfTwoMembers_java.kt")
            public void testIntersectionOverrideOfTwoMembers_java() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/scopes/intersectionOverrideOfTwoMembers_java.kt");
            }

            @Test
            @TestMetadata("javaFunctionAndKotlinPropertyFromDifferentSupertypes.kt")
            public void testJavaFunctionAndKotlinPropertyFromDifferentSupertypes() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/scopes/javaFunctionAndKotlinPropertyFromDifferentSupertypes.kt");
            }

            @Test
            @TestMetadata("kotlinAccessorsLikeFunctionsThrowJavaClass.kt")
            public void testKotlinAccessorsLikeFunctionsThrowJavaClass() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/scopes/kotlinAccessorsLikeFunctionsThrowJavaClass.kt");
            }

            @Test
            @TestMetadata("noIntersectionOverrideOfTwoMembers.kt")
            public void testNoIntersectionOverrideOfTwoMembers() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/scopes/noIntersectionOverrideOfTwoMembers.kt");
            }

            @Test
            @TestMetadata("noIntersectionOverrideOfTwoMembers_java.kt")
            public void testNoIntersectionOverrideOfTwoMembers_java() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/scopes/noIntersectionOverrideOfTwoMembers_java.kt");
            }

            @Test
            @TestMetadata("publicJavaAndPrivateKotlinVar.kt")
            public void testPublicJavaAndPrivateKotlinVar() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/scopes/publicJavaAndPrivateKotlinVar.kt");
            }

            @Test
            @TestMetadata("specialFunctionInJava_1.kt")
            public void testSpecialFunctionInJava_1() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/scopes/specialFunctionInJava_1.kt");
            }

            @Test
            @TestMetadata("specialFunctionInJava_2.kt")
            public void testSpecialFunctionInJava_2() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/scopes/specialFunctionInJava_2.kt");
            }

            @Test
            @TestMetadata("specialFunctionInJava_3.kt")
            public void testSpecialFunctionInJava_3() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/scopes/specialFunctionInJava_3.kt");
            }

            @Test
            @TestMetadata("specialFunctionInJava_4.kt")
            public void testSpecialFunctionInJava_4() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/scopes/specialFunctionInJava_4.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/fir/analysis-tests/testData/resolve/smartcasts")
        @TestDataPath("$PROJECT_ROOT")
        public class Smartcasts {
            @Test
            @TestMetadata("accessToMemberAfterReceiverReassignment.kt")
            public void testAccessToMemberAfterReceiverReassignment() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/accessToMemberAfterReceiverReassignment.kt");
            }

            @Test
            public void testAllFilesPresentInSmartcasts() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/smartcasts"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
            }

            @Test
            @TestMetadata("bangbang.kt")
            public void testBangbang() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/bangbang.kt");
            }

            @Test
            @TestMetadata("casts.kt")
            public void testCasts() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/casts.kt");
            }

            @Test
            @TestMetadata("equalsAndIdentity.kt")
            public void testEqualsAndIdentity() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/equalsAndIdentity.kt");
            }

            @Test
            @TestMetadata("incorrectSmartcastToNothing.kt")
            public void testIncorrectSmartcastToNothing() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/incorrectSmartcastToNothing.kt");
            }

            @Test
            @TestMetadata("kt10240.kt")
            public void testKt10240() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/kt10240.kt");
            }

            @Test
            @TestMetadata("kt37327.kt")
            public void testKt37327() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/kt37327.kt");
            }

            @Test
            @TestMetadata("kt39000.kt")
            public void testKt39000() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/kt39000.kt");
            }

            @Test
            @TestMetadata("kt50788.kt")
            public void testKt50788() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/kt50788.kt");
            }

            @Test
            @TestMetadata("kt50875.kt")
            public void testKt50875() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/kt50875.kt");
            }

            @Test
            @TestMetadata("literalInWhenSubject.kt")
            public void testLiteralInWhenSubject() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/literalInWhenSubject.kt");
            }

            @Test
            @TestMetadata("multipleCasts.kt")
            public void testMultipleCasts() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/multipleCasts.kt");
            }

            @Test
            @TestMetadata("nullability.kt")
            public void testNullability() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/nullability.kt");
            }

            @Test
            @TestMetadata("orInWhenBranch.kt")
            public void testOrInWhenBranch() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/orInWhenBranch.kt");
            }

            @Test
            @TestMetadata("smartCastInInit.kt")
            public void testSmartCastInInit() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/smartCastInInit.kt");
            }

            @Test
            @TestMetadata("smartcastInByClause.kt")
            public void testSmartcastInByClause() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/smartcastInByClause.kt");
            }

            @Test
            @TestMetadata("smartcastOnImplicitReceiverOfCallableReference.kt")
            public void testSmartcastOnImplicitReceiverOfCallableReference() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/smartcastOnImplicitReceiverOfCallableReference.kt");
            }

            @Test
            @TestMetadata("smartcastToNothing.kt")
            public void testSmartcastToNothing() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/smartcastToNothing.kt");
            }

            @Test
            @TestMetadata("smartcastToTypeParameter.kt")
            public void testSmartcastToTypeParameter() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/smartcastToTypeParameter.kt");
            }

            @Test
            @TestMetadata("smartcastsFromEquals_differentModule.kt")
            public void testSmartcastsFromEquals_differentModule() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/smartcastsFromEquals_differentModule.kt");
            }

            @Test
            @TestMetadata("smartcastsFromEquals_sameModule.kt")
            public void testSmartcastsFromEquals_sameModule() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/smartcastsFromEquals_sameModule.kt");
            }

            @Test
            @TestMetadata("unstableSmartcastAndAmbiguity.kt")
            public void testUnstableSmartcastAndAmbiguity() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/unstableSmartcastAndAmbiguity.kt");
            }

            @Nested
            @TestMetadata("compiler/fir/analysis-tests/testData/resolve/smartcasts/booleans")
            @TestDataPath("$PROJECT_ROOT")
            public class Booleans {
                @Test
                public void testAllFilesPresentInBooleans() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/smartcasts/booleans"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
                }

                @Test
                @TestMetadata("booleanElvisBoundSmartcast.kt")
                public void testBooleanElvisBoundSmartcast() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/booleans/booleanElvisBoundSmartcast.kt");
                }

                @Test
                @TestMetadata("booleanOperators.kt")
                public void testBooleanOperators() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/booleans/booleanOperators.kt");
                }

                @Test
                @TestMetadata("equalsToBoolean.kt")
                public void testEqualsToBoolean() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/booleans/equalsToBoolean.kt");
                }

                @Test
                @TestMetadata("jumpFromRhsOfOperator.kt")
                public void testJumpFromRhsOfOperator() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/booleans/jumpFromRhsOfOperator.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/fir/analysis-tests/testData/resolve/smartcasts/boundSmartcasts")
            @TestDataPath("$PROJECT_ROOT")
            public class BoundSmartcasts {
                @Test
                public void testAllFilesPresentInBoundSmartcasts() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/smartcasts/boundSmartcasts"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
                }

                @Test
                @TestMetadata("boundSmartcasts.kt")
                public void testBoundSmartcasts() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/boundSmartcasts/boundSmartcasts.kt");
                }

                @Test
                @TestMetadata("boundSmartcastsInBranches.kt")
                public void testBoundSmartcastsInBranches() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/boundSmartcasts/boundSmartcastsInBranches.kt");
                }

                @Test
                @TestMetadata("functionCallBound.kt")
                public void testFunctionCallBound() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/boundSmartcasts/functionCallBound.kt");
                }

                @Test
                @TestMetadata("thisAssignment.kt")
                public void testThisAssignment() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/boundSmartcasts/thisAssignment.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/fir/analysis-tests/testData/resolve/smartcasts/controlStructures")
            @TestDataPath("$PROJECT_ROOT")
            public class ControlStructures {
                @Test
                public void testAllFilesPresentInControlStructures() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/smartcasts/controlStructures"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
                }

                @Test
                @TestMetadata("elvis.kt")
                public void testElvis() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/controlStructures/elvis.kt");
                }

                @Test
                @TestMetadata("returns.kt")
                public void testReturns() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/controlStructures/returns.kt");
                }

                @Test
                @TestMetadata("simpleIf.kt")
                public void testSimpleIf() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/controlStructures/simpleIf.kt");
                }

                @Test
                @TestMetadata("smartcastFromArgument.kt")
                public void testSmartcastFromArgument() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/controlStructures/smartcastFromArgument.kt");
                }

                @Test
                @TestMetadata("when.kt")
                public void testWhen() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/controlStructures/when.kt");
                }

                @Test
                @TestMetadata("whenSubjectExpression.kt")
                public void testWhenSubjectExpression() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/controlStructures/whenSubjectExpression.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/fir/analysis-tests/testData/resolve/smartcasts/lambdas")
            @TestDataPath("$PROJECT_ROOT")
            public class Lambdas {
                @Test
                public void testAllFilesPresentInLambdas() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/smartcasts/lambdas"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
                }

                @Test
                @TestMetadata("inPlaceLambdas.kt")
                public void testInPlaceLambdas() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/lambdas/inPlaceLambdas.kt");
                }

                @Test
                @TestMetadata("lambdaInWhenBranch.kt")
                public void testLambdaInWhenBranch() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/lambdas/lambdaInWhenBranch.kt");
                }

                @Test
                @TestMetadata("smartcastOnLambda.kt")
                public void testSmartcastOnLambda() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/lambdas/smartcastOnLambda.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/fir/analysis-tests/testData/resolve/smartcasts/loops")
            @TestDataPath("$PROJECT_ROOT")
            public class Loops {
                @Test
                public void testAllFilesPresentInLoops() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/smartcasts/loops"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
                }

                @Test
                @TestMetadata("dataFlowInfoFromWhileCondition.kt")
                public void testDataFlowInfoFromWhileCondition() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/loops/dataFlowInfoFromWhileCondition.kt");
                }

                @Test
                @TestMetadata("endlessLoops.kt")
                public void testEndlessLoops() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/loops/endlessLoops.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/fir/analysis-tests/testData/resolve/smartcasts/problems")
            @TestDataPath("$PROJECT_ROOT")
            public class Problems {
                @Test
                public void testAllFilesPresentInProblems() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/smartcasts/problems"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
                }

                @Test
                @TestMetadata("invoke.kt")
                public void testInvoke() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/problems/invoke.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/fir/analysis-tests/testData/resolve/smartcasts/receivers")
            @TestDataPath("$PROJECT_ROOT")
            public class Receivers {
                @Test
                public void testAllFilesPresentInReceivers() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/smartcasts/receivers"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
                }

                @Test
                @TestMetadata("implicitReceiverAsWhenSubject.kt")
                public void testImplicitReceiverAsWhenSubject() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/receivers/implicitReceiverAsWhenSubject.kt");
                }

                @Test
                @TestMetadata("implicitReceivers.kt")
                public void testImplicitReceivers() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/receivers/implicitReceivers.kt");
                }

                @Test
                @TestMetadata("mixingImplicitAndExplicitReceivers.kt")
                public void testMixingImplicitAndExplicitReceivers() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/receivers/mixingImplicitAndExplicitReceivers.kt");
                }

                @Test
                @TestMetadata("thisOfExtensionProperty.kt")
                public void testThisOfExtensionProperty() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/receivers/thisOfExtensionProperty.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/fir/analysis-tests/testData/resolve/smartcasts/safeCalls")
            @TestDataPath("$PROJECT_ROOT")
            public class SafeCalls {
                @Test
                public void testAllFilesPresentInSafeCalls() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/smartcasts/safeCalls"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
                }

                @Test
                @TestMetadata("assignSafeCall.kt")
                public void testAssignSafeCall() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/safeCalls/assignSafeCall.kt");
                }

                @Test
                @TestMetadata("boundSafeCallAndIsCheck.kt")
                public void testBoundSafeCallAndIsCheck() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/safeCalls/boundSafeCallAndIsCheck.kt");
                }

                @Test
                @TestMetadata("complexIfWithOr.kt")
                public void testComplexIfWithOr() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/safeCalls/complexIfWithOr.kt");
                }

                @Test
                @TestMetadata("safeCallAndEqualityToBool.kt")
                public void testSafeCallAndEqualityToBool() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/safeCalls/safeCallAndEqualityToBool.kt");
                }

                @Test
                @TestMetadata("safeCalls.kt")
                public void testSafeCalls() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/safeCalls/safeCalls.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/fir/analysis-tests/testData/resolve/smartcasts/stability")
            @TestDataPath("$PROJECT_ROOT")
            public class Stability {
                @Test
                public void testAllFilesPresentInStability() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/smartcasts/stability"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
                }

                @Test
                @TestMetadata("overridenOpenVal.kt")
                public void testOverridenOpenVal() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/stability/overridenOpenVal.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/fir/analysis-tests/testData/resolve/smartcasts/variables")
            @TestDataPath("$PROJECT_ROOT")
            public class Variables {
                @Test
                public void testAllFilesPresentInVariables() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/smartcasts/variables"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
                }

                @Test
                @TestMetadata("delayedAssignment.kt")
                public void testDelayedAssignment() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/variables/delayedAssignment.kt");
                }

                @Test
                @TestMetadata("smartcastAfterReassignment.kt")
                public void testSmartcastAfterReassignment() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/smartcasts/variables/smartcastAfterReassignment.kt");
                }
            }
        }

        @Nested
        @TestMetadata("compiler/fir/analysis-tests/testData/resolve/stdlib")
        @TestDataPath("$PROJECT_ROOT")
        public class Stdlib {
            @Test
            public void testAllFilesPresentInStdlib() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/stdlib"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
            }

            @Nested
            @TestMetadata("compiler/fir/analysis-tests/testData/resolve/stdlib/j+k")
            @TestDataPath("$PROJECT_ROOT")
            public class J_k {
                @Test
                public void testAllFilesPresentInJ_k() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/stdlib/j+k"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
                }

                @Test
                @TestMetadata("ArrayInGenericArguments.kt")
                public void testArrayInGenericArguments() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/stdlib/j+k/ArrayInGenericArguments.kt");
                }

                @Test
                @TestMetadata("flexibleWildcard.kt")
                public void testFlexibleWildcard() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolve/stdlib/j+k/flexibleWildcard.kt");
                }
            }
        }

        @Nested
        @TestMetadata("compiler/fir/analysis-tests/testData/resolve/suppress")
        @TestDataPath("$PROJECT_ROOT")
        public class Suppress {
            @Test
            public void testAllFilesPresentInSuppress() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/suppress"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
            }

            @Test
            @TestMetadata("allWarnings.kt")
            public void testAllWarnings() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/suppress/allWarnings.kt");
            }

            @Test
            @TestMetadata("multipleWarnings.kt")
            public void testMultipleWarnings() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/suppress/multipleWarnings.kt");
            }

            @Test
            @TestMetadata("singleError.kt")
            public void testSingleError() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/suppress/singleError.kt");
            }

            @Test
            @TestMetadata("singleWarning.kt")
            public void testSingleWarning() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/suppress/singleWarning.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/fir/analysis-tests/testData/resolve/types")
        @TestDataPath("$PROJECT_ROOT")
        public class Types {
            @Test
            public void testAllFilesPresentInTypes() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/types"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
            }

            @Test
            @TestMetadata("bareWithFlexibleArg.kt")
            public void testBareWithFlexibleArg() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/types/bareWithFlexibleArg.kt");
            }

            @Test
            @TestMetadata("bareWithSubjectTypeAlias.kt")
            public void testBareWithSubjectTypeAlias() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/types/bareWithSubjectTypeAlias.kt");
            }

            @Test
            @TestMetadata("capturedParametersOfInnerClasses.kt")
            public void testCapturedParametersOfInnerClasses() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/types/capturedParametersOfInnerClasses.kt");
            }

            @Test
            @TestMetadata("castToBareType.kt")
            public void testCastToBareType() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/types/castToBareType.kt");
            }

            @Test
            @TestMetadata("typeAliasInArguments.kt")
            public void testTypeAliasInArguments() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/types/typeAliasInArguments.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/fir/analysis-tests/testData/resolve/unqualifiedEnum")
        @TestDataPath("$PROJECT_ROOT")
        public class UnqualifiedEnum {
            @Test
            public void testAllFilesPresentInUnqualifiedEnum() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/unqualifiedEnum"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
            }

            @Test
            @TestMetadata("correctJava.kt")
            public void testCorrectJava() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/unqualifiedEnum/correctJava.kt");
            }

            @Test
            @TestMetadata("incorrectJava.kt")
            public void testIncorrectJava() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/unqualifiedEnum/incorrectJava.kt");
            }

            @Test
            @TestMetadata("nested.kt")
            public void testNested() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/unqualifiedEnum/nested.kt");
            }

            @Test
            @TestMetadata("notInsideBranches.kt")
            public void testNotInsideBranches() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/unqualifiedEnum/notInsideBranches.kt");
            }

            @Test
            @TestMetadata("priority.kt")
            public void testPriority() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/unqualifiedEnum/priority.kt");
            }

            @Test
            @TestMetadata("typeAlias.kt")
            public void testTypeAlias() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/unqualifiedEnum/typeAlias.kt");
            }

            @Test
            @TestMetadata("unqualifiedEnum.kt")
            public void testUnqualifiedEnum() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/unqualifiedEnum/unqualifiedEnum.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/fir/analysis-tests/testData/resolve/visibility")
        @TestDataPath("$PROJECT_ROOT")
        public class Visibility {
            @Test
            public void testAllFilesPresentInVisibility() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/visibility"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
            }

            @Test
            @TestMetadata("exposedFunctionParameterType.kt")
            public void testExposedFunctionParameterType() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/visibility/exposedFunctionParameterType.kt");
            }

            @Test
            @TestMetadata("exposedFunctionReturnType.kt")
            public void testExposedFunctionReturnType() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/visibility/exposedFunctionReturnType.kt");
            }

            @Test
            @TestMetadata("exposedPropertyType.kt")
            public void testExposedPropertyType() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/visibility/exposedPropertyType.kt");
            }

            @Test
            @TestMetadata("exposedSupertype.kt")
            public void testExposedSupertype() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/visibility/exposedSupertype.kt");
            }

            @Test
            @TestMetadata("exposedTypeAlias.kt")
            public void testExposedTypeAlias() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/visibility/exposedTypeAlias.kt");
            }

            @Test
            @TestMetadata("exposedTypeParameters.kt")
            public void testExposedTypeParameters() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/visibility/exposedTypeParameters.kt");
            }

            @Test
            @TestMetadata("intersectionOverrideWithImplicitTypes.kt")
            public void testIntersectionOverrideWithImplicitTypes() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/visibility/intersectionOverrideWithImplicitTypes.kt");
            }

            @Test
            @TestMetadata("kotlinJavaKotlinHierarchy.kt")
            public void testKotlinJavaKotlinHierarchy() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/visibility/kotlinJavaKotlinHierarchy.kt");
            }

            @Test
            @TestMetadata("privateAliasInSamePackage.kt")
            public void testPrivateAliasInSamePackage() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/visibility/privateAliasInSamePackage.kt");
            }

            @Test
            @TestMetadata("protectedInCompanion.kt")
            public void testProtectedInCompanion() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/visibility/protectedInCompanion.kt");
            }

            @Test
            @TestMetadata("singletonConstructors.kt")
            public void testSingletonConstructors() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/visibility/singletonConstructors.kt");
            }

            @Test
            @TestMetadata("superAccessToJavaField.kt")
            public void testSuperAccessToJavaField() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/visibility/superAccessToJavaField.kt");
            }

            @Test
            @TestMetadata("visibilityWithOverrides.kt")
            public void testVisibilityWithOverrides() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/visibility/visibilityWithOverrides.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/fir/analysis-tests/testData/resolve/withAllowedKotlinPackage")
        @TestDataPath("$PROJECT_ROOT")
        public class WithAllowedKotlinPackage {
            @Test
            public void testAllFilesPresentInWithAllowedKotlinPackage() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolve/withAllowedKotlinPackage"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
            }

            @Test
            @TestMetadata("extensionFunctionAddedToStdlib.kt")
            public void testExtensionFunctionAddedToStdlib() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolve/withAllowedKotlinPackage/extensionFunctionAddedToStdlib.kt");
            }
        }
    }

    @Nested
    @TestMetadata("compiler/fir/analysis-tests/testData/resolveWithStdlib")
    @TestDataPath("$PROJECT_ROOT")
    public class ResolveWithStdlib {
        @Test
        @TestMetadata("addAllOnJavaCollection.kt")
        public void testAddAllOnJavaCollection() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/addAllOnJavaCollection.kt");
        }

        @Test
        public void testAllFilesPresentInResolveWithStdlib() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolveWithStdlib"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
        }

        @Test
        @TestMetadata("annotationUseSites.kt")
        public void testAnnotationUseSites() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/annotationUseSites.kt");
        }

        @Test
        @TestMetadata("arrayFilterCapturedType.kt")
        public void testArrayFilterCapturedType() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/arrayFilterCapturedType.kt");
        }

        @Test
        @TestMetadata("arrayFirstOrNull.kt")
        public void testArrayFirstOrNull() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/arrayFirstOrNull.kt");
        }

        @Test
        @TestMetadata("arrayInLocal.kt")
        public void testArrayInLocal() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/arrayInLocal.kt");
        }

        @Test
        @TestMetadata("backingField.kt")
        public void testBackingField() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/backingField.kt");
        }

        @Test
        @TestMetadata("classLiteralForParameter.kt")
        public void testClassLiteralForParameter() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/classLiteralForParameter.kt");
        }

        @Test
        @TestMetadata("cloneArray.kt")
        public void testCloneArray() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/cloneArray.kt");
        }

        @Test
        @TestMetadata("companionLoad.kt")
        public void testCompanionLoad() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/companionLoad.kt");
        }

        @Test
        @TestMetadata("complexPostponedCfg.kt")
        public void testComplexPostponedCfg() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/complexPostponedCfg.kt");
        }

        @Test
        @TestMetadata("components.kt")
        public void testComponents() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/components.kt");
        }

        @Test
        @TestMetadata("concurrent.kt")
        public void testConcurrent() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/concurrent.kt");
        }

        @Test
        @TestMetadata("concurrentMapOfAliases.kt")
        public void testConcurrentMapOfAliases() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/concurrentMapOfAliases.kt");
        }

        @Test
        @TestMetadata("emptyArray.kt")
        public void testEmptyArray() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/emptyArray.kt");
        }

        @Test
        @TestMetadata("enumValuesDeserialized.kt")
        public void testEnumValuesDeserialized() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/enumValuesDeserialized.kt");
        }

        @Test
        @TestMetadata("errorsInUnreachable.kt")
        public void testErrorsInUnreachable() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/errorsInUnreachable.kt");
        }

        @Test
        @TestMetadata("exception.kt")
        public void testException() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/exception.kt");
        }

        @Test
        @TestMetadata("factoryFunctionOverloads.kt")
        public void testFactoryFunctionOverloads() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/factoryFunctionOverloads.kt");
        }

        @Test
        @TestMetadata("fillInStackTrace.kt")
        public void testFillInStackTrace() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/fillInStackTrace.kt");
        }

        @Test
        @TestMetadata("functionAndFunctionN.kt")
        public void testFunctionAndFunctionN() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/functionAndFunctionN.kt");
        }

        @Test
        @TestMetadata("functionX.kt")
        public void testFunctionX() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/functionX.kt");
        }

        @Test
        @TestMetadata("getOnKProperty.kt")
        public void testGetOnKProperty() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/getOnKProperty.kt");
        }

        @Test
        @TestMetadata("getOrPutAmbiguity.kt")
        public void testGetOrPutAmbiguity() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/getOrPutAmbiguity.kt");
        }

        @Test
        @TestMetadata("hashMapTypeAlias.kt")
        public void testHashMapTypeAlias() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/hashMapTypeAlias.kt");
        }

        @Test
        @TestMetadata("hashSet.kt")
        public void testHashSet() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/hashSet.kt");
        }

        @Test
        @TestMetadata("hashTableWithForEach.kt")
        public void testHashTableWithForEach() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/hashTableWithForEach.kt");
        }

        @Test
        @TestMetadata("helloWorld.kt")
        public void testHelloWorld() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/helloWorld.kt");
        }

        @Test
        @TestMetadata("implicitReceiverOrder.kt")
        public void testImplicitReceiverOrder() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/implicitReceiverOrder.kt");
        }

        @Test
        @TestMetadata("inapplicableRemoveAll.kt")
        public void testInapplicableRemoveAll() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/inapplicableRemoveAll.kt");
        }

        @Test
        @TestMetadata("javaEnumSynthetic.kt")
        public void testJavaEnumSynthetic() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/javaEnumSynthetic.kt");
        }

        @Test
        @TestMetadata("javaLangComparator.kt")
        public void testJavaLangComparator() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/javaLangComparator.kt");
        }

        @Test
        @TestMetadata("kotlinComparatorAlias.kt")
        public void testKotlinComparatorAlias() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/kotlinComparatorAlias.kt");
        }

        @Test
        @TestMetadata("listPlusAssign.kt")
        public void testListPlusAssign() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/listPlusAssign.kt");
        }

        @Test
        @TestMetadata("lowPriorityInResolution.kt")
        public void testLowPriorityInResolution() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/lowPriorityInResolution.kt");
        }

        @Test
        @TestMetadata("mapList.kt")
        public void testMapList() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/mapList.kt");
        }

        @Test
        @TestMetadata("multipleImplicitReceivers.kt")
        public void testMultipleImplicitReceivers() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/multipleImplicitReceivers.kt");
        }

        @Test
        @TestMetadata("noneWithForEach.kt")
        public void testNoneWithForEach() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/noneWithForEach.kt");
        }

        @Test
        @TestMetadata("nullableTypeParameter.kt")
        public void testNullableTypeParameter() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/nullableTypeParameter.kt");
        }

        @Test
        @TestMetadata("plusAssignNullable.kt")
        public void testPlusAssignNullable() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/plusAssignNullable.kt");
        }

        @Test
        @TestMetadata("problems.kt")
        public void testProblems() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/problems.kt");
        }

        @Test
        @TestMetadata("rangeTo.kt")
        public void testRangeTo() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/rangeTo.kt");
        }

        @Test
        @TestMetadata("recursiveBug.kt")
        public void testRecursiveBug() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/recursiveBug.kt");
        }

        @Test
        @TestMetadata("reflectionClass.kt")
        public void testReflectionClass() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/reflectionClass.kt");
        }

        @Test
        @TestMetadata("removeIf.kt")
        public void testRemoveIf() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/removeIf.kt");
        }

        @Test
        @TestMetadata("removeOnAbstractMap.kt")
        public void testRemoveOnAbstractMap() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/removeOnAbstractMap.kt");
        }

        @Test
        @TestMetadata("runOnIntegerLiteral.kt")
        public void testRunOnIntegerLiteral() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/runOnIntegerLiteral.kt");
        }

        @Test
        @TestMetadata("samForComparator.kt")
        public void testSamForComparator() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/samForComparator.kt");
        }

        @Test
        @TestMetadata("simpleLazy.kt")
        public void testSimpleLazy() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/simpleLazy.kt");
        }

        @Test
        @TestMetadata("stringConstructors.kt")
        public void testStringConstructors() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/stringConstructors.kt");
        }

        @Test
        @TestMetadata("toSortedMapWithComparator.kt")
        public void testToSortedMapWithComparator() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/toSortedMapWithComparator.kt");
        }

        @Test
        @TestMetadata("topLevelResolve.kt")
        public void testTopLevelResolve() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/topLevelResolve.kt");
        }

        @Test
        @TestMetadata("typeAliasDeserialization.kt")
        public void testTypeAliasDeserialization() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/typeAliasDeserialization.kt");
        }

        @Test
        @TestMetadata("typeAliasWithForEach.kt")
        public void testTypeAliasWithForEach() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/typeAliasWithForEach.kt");
        }

        @Test
        @TestMetadata("typeParameterDerived.kt")
        public void testTypeParameterDerived() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/typeParameterDerived.kt");
        }

        @Test
        @TestMetadata("unaryOperators.kt")
        public void testUnaryOperators() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/unaryOperators.kt");
        }

        @Test
        @TestMetadata("whenAsLambdaReturnStatement.kt")
        public void testWhenAsLambdaReturnStatement() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/whenAsLambdaReturnStatement.kt");
        }

        @Test
        @TestMetadata("withInInitializer.kt")
        public void testWithInInitializer() throws Exception {
            runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/withInInitializer.kt");
        }

        @Nested
        @TestMetadata("compiler/fir/analysis-tests/testData/resolveWithStdlib/callableReferences")
        @TestDataPath("$PROJECT_ROOT")
        public class CallableReferences {
            @Test
            public void testAllFilesPresentInCallableReferences() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolveWithStdlib/callableReferences"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
            }

            @Test
            @TestMetadata("beyoundCalls.kt")
            public void testBeyoundCalls() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/callableReferences/beyoundCalls.kt");
            }

            @Test
            @TestMetadata("coercionToUnit.kt")
            public void testCoercionToUnit() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/callableReferences/coercionToUnit.kt");
            }

            @Test
            @TestMetadata("companions.kt")
            public void testCompanions() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/callableReferences/companions.kt");
            }

            @Test
            @TestMetadata("constructors.kt")
            public void testConstructors() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/callableReferences/constructors.kt");
            }

            @Test
            @TestMetadata("differentLevels.kt")
            public void testDifferentLevels() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/callableReferences/differentLevels.kt");
            }

            @Test
            @TestMetadata("extensionReceiverInference.kt")
            public void testExtensionReceiverInference() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/callableReferences/extensionReceiverInference.kt");
            }

            @Test
            @TestMetadata("genericInReceiver.kt")
            public void testGenericInReceiver() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/callableReferences/genericInReceiver.kt");
            }

            @Test
            @TestMetadata("ifWithCR.kt")
            public void testIfWithCR() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/callableReferences/ifWithCR.kt");
            }

            @Test
            @TestMetadata("implicitTypes.kt")
            public void testImplicitTypes() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/callableReferences/implicitTypes.kt");
            }

            @Test
            @TestMetadata("inferenceFromCallableReferenceType.kt")
            public void testInferenceFromCallableReferenceType() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/callableReferences/inferenceFromCallableReferenceType.kt");
            }

            @Test
            @TestMetadata("inferenceFromExpectedType.kt")
            public void testInferenceFromExpectedType() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/callableReferences/inferenceFromExpectedType.kt");
            }

            @Test
            @TestMetadata("javaStatic.kt")
            public void testJavaStatic() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/callableReferences/javaStatic.kt");
            }

            @Test
            @TestMetadata("manyCandidatesInference.kt")
            public void testManyCandidatesInference() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/callableReferences/manyCandidatesInference.kt");
            }

            @Test
            @TestMetadata("manyInnerCandidates.kt")
            public void testManyInnerCandidates() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/callableReferences/manyInnerCandidates.kt");
            }

            @Test
            @TestMetadata("manyInnerManyOuterCandidates.kt")
            public void testManyInnerManyOuterCandidates() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/callableReferences/manyInnerManyOuterCandidates.kt");
            }

            @Test
            @TestMetadata("manyInnermanyOuterCandidatesAmbiguity.kt")
            public void testManyInnermanyOuterCandidatesAmbiguity() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/callableReferences/manyInnermanyOuterCandidatesAmbiguity.kt");
            }

            @Test
            @TestMetadata("manyOuterCandidates.kt")
            public void testManyOuterCandidates() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/callableReferences/manyOuterCandidates.kt");
            }

            @Test
            @TestMetadata("properties.kt")
            public void testProperties() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/callableReferences/properties.kt");
            }

            @Test
            @TestMetadata("referenceToJavaStdlib.kt")
            public void testReferenceToJavaStdlib() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/callableReferences/referenceToJavaStdlib.kt");
            }

            @Test
            @TestMetadata("sam.kt")
            public void testSam() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/callableReferences/sam.kt");
            }

            @Test
            @TestMetadata("simpleClassReceiver.kt")
            public void testSimpleClassReceiver() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/callableReferences/simpleClassReceiver.kt");
            }

            @Test
            @TestMetadata("simpleExpressionReceiver.kt")
            public void testSimpleExpressionReceiver() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/callableReferences/simpleExpressionReceiver.kt");
            }

            @Test
            @TestMetadata("simpleNoReceiver.kt")
            public void testSimpleNoReceiver() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/callableReferences/simpleNoReceiver.kt");
            }

            @Test
            @TestMetadata("varProperties.kt")
            public void testVarProperties() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/callableReferences/varProperties.kt");
            }

            @Nested
            @TestMetadata("compiler/fir/analysis-tests/testData/resolveWithStdlib/callableReferences/fromBasicDiagnosticTests")
            @TestDataPath("$PROJECT_ROOT")
            public class FromBasicDiagnosticTests {
                @Test
                public void testAllFilesPresentInFromBasicDiagnosticTests() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolveWithStdlib/callableReferences/fromBasicDiagnosticTests"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
                }

                @Test
                @TestMetadata("ambiguityWhenNoApplicableCallableReferenceCandidate.kt")
                public void testAmbiguityWhenNoApplicableCallableReferenceCandidate() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/callableReferences/fromBasicDiagnosticTests/ambiguityWhenNoApplicableCallableReferenceCandidate.kt");
                }

                @Test
                @TestMetadata("applicableCallableReferenceFromDistantScope.kt")
                public void testApplicableCallableReferenceFromDistantScope() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/callableReferences/fromBasicDiagnosticTests/applicableCallableReferenceFromDistantScope.kt");
                }

                @Test
                @TestMetadata("chooseCallableReferenceDependingOnInferredReceiver.kt")
                public void testChooseCallableReferenceDependingOnInferredReceiver() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/callableReferences/fromBasicDiagnosticTests/chooseCallableReferenceDependingOnInferredReceiver.kt");
                }

                @Test
                @TestMetadata("commonSupertypeFromReturnTypesOfCallableReference.kt")
                public void testCommonSupertypeFromReturnTypesOfCallableReference() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/callableReferences/fromBasicDiagnosticTests/commonSupertypeFromReturnTypesOfCallableReference.kt");
                }

                @Test
                @TestMetadata("eagerAndPostponedCallableReferences.kt")
                public void testEagerAndPostponedCallableReferences() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/callableReferences/fromBasicDiagnosticTests/eagerAndPostponedCallableReferences.kt");
                }

                @Test
                @TestMetadata("eagerResolveOfSingleCallableReference.kt")
                public void testEagerResolveOfSingleCallableReference() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/callableReferences/fromBasicDiagnosticTests/eagerResolveOfSingleCallableReference.kt");
                }

                @Test
                @TestMetadata("moreSpecificAmbiguousExtensions.kt")
                public void testMoreSpecificAmbiguousExtensions() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/callableReferences/fromBasicDiagnosticTests/moreSpecificAmbiguousExtensions.kt");
                }

                @Test
                @TestMetadata("multipleOutersAndMultipleCallableReferences.kt")
                public void testMultipleOutersAndMultipleCallableReferences() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/callableReferences/fromBasicDiagnosticTests/multipleOutersAndMultipleCallableReferences.kt");
                }

                @Test
                @TestMetadata("noAmbiguityBetweenTopLevelAndMemberProperty.kt")
                public void testNoAmbiguityBetweenTopLevelAndMemberProperty() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/callableReferences/fromBasicDiagnosticTests/noAmbiguityBetweenTopLevelAndMemberProperty.kt");
                }

                @Test
                @TestMetadata("overloadsBound.kt")
                public void testOverloadsBound() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/callableReferences/fromBasicDiagnosticTests/overloadsBound.kt");
                }

                @Test
                @TestMetadata("postponedResolveOfManyCallableReference.kt")
                public void testPostponedResolveOfManyCallableReference() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/callableReferences/fromBasicDiagnosticTests/postponedResolveOfManyCallableReference.kt");
                }

                @Test
                @TestMetadata("resolveCallableReferencesAfterAllSimpleArguments.kt")
                public void testResolveCallableReferencesAfterAllSimpleArguments() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/callableReferences/fromBasicDiagnosticTests/resolveCallableReferencesAfterAllSimpleArguments.kt");
                }

                @Test
                @TestMetadata("withGenericFun.kt")
                public void testWithGenericFun() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/callableReferences/fromBasicDiagnosticTests/withGenericFun.kt");
                }
            }
        }

        @Nested
        @TestMetadata("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts")
        @TestDataPath("$PROJECT_ROOT")
        public class Contracts {
            @Test
            public void testAllFilesPresentInContracts() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
            }

            @Nested
            @TestMetadata("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromLibrary")
            @TestDataPath("$PROJECT_ROOT")
            public class FromLibrary {
                @Test
                public void testAllFilesPresentInFromLibrary() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromLibrary"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
                }

                @Test
                @TestMetadata("callsInPlace.kt")
                public void testCallsInPlace() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromLibrary/callsInPlace.kt");
                }

                @Test
                @TestMetadata("conditionalEffects.kt")
                public void testConditionalEffects() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromLibrary/conditionalEffects.kt");
                }

                @Test
                @TestMetadata("notIsNullOrEmpty.kt")
                public void testNotIsNullOrEmpty() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromLibrary/notIsNullOrEmpty.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromSource")
            @TestDataPath("$PROJECT_ROOT")
            public class FromSource {
                @Test
                public void testAllFilesPresentInFromSource() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromSource"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
                }

                @Nested
                @TestMetadata("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromSource/bad")
                @TestDataPath("$PROJECT_ROOT")
                public class Bad {
                    @Test
                    public void testAllFilesPresentInBad() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromSource/bad"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
                    }

                    @Nested
                    @TestMetadata("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromSource/bad/callsInPlace")
                    @TestDataPath("$PROJECT_ROOT")
                    public class CallsInPlace {
                        @Test
                        public void testAllFilesPresentInCallsInPlace() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromSource/bad/callsInPlace"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
                        }

                        @Test
                        @TestMetadata("inAnonymousObject.kt")
                        public void testInAnonymousObject() throws Exception {
                            runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromSource/bad/callsInPlace/inAnonymousObject.kt");
                        }

                        @Test
                        @TestMetadata("inLocalClass.kt")
                        public void testInLocalClass() throws Exception {
                            runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromSource/bad/callsInPlace/inLocalClass.kt");
                        }

                        @Test
                        @TestMetadata("inLocalFunction.kt")
                        public void testInLocalFunction() throws Exception {
                            runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromSource/bad/callsInPlace/inLocalFunction.kt");
                        }

                        @Test
                        @TestMetadata("toLocalVariables.kt")
                        public void testToLocalVariables() throws Exception {
                            runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromSource/bad/callsInPlace/toLocalVariables.kt");
                        }
                    }

                    @Nested
                    @TestMetadata("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromSource/bad/returnsImplies")
                    @TestDataPath("$PROJECT_ROOT")
                    public class ReturnsImplies {
                        @Test
                        public void testAllFilesPresentInReturnsImplies() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromSource/bad/returnsImplies"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
                        }

                        @Test
                        @TestMetadata("notNull.kt")
                        public void testNotNull() throws Exception {
                            runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromSource/bad/returnsImplies/notNull.kt");
                        }

                        @Test
                        @TestMetadata("propertyGetter.kt")
                        public void testPropertyGetter() throws Exception {
                            runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromSource/bad/returnsImplies/propertyGetter.kt");
                        }
                    }
                }

                @Nested
                @TestMetadata("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromSource/good")
                @TestDataPath("$PROJECT_ROOT")
                public class Good {
                    @Test
                    public void testAllFilesPresentInGood() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromSource/good"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
                    }

                    @Nested
                    @TestMetadata("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromSource/good/callsInPlace")
                    @TestDataPath("$PROJECT_ROOT")
                    public class CallsInPlace {
                        @Test
                        public void testAllFilesPresentInCallsInPlace() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromSource/good/callsInPlace"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
                        }

                        @Test
                        @TestMetadata("atLeastOnce.kt")
                        public void testAtLeastOnce() throws Exception {
                            runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromSource/good/callsInPlace/atLeastOnce.kt");
                        }

                        @Test
                        @TestMetadata("atMostOnce.kt")
                        public void testAtMostOnce() throws Exception {
                            runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromSource/good/callsInPlace/atMostOnce.kt");
                        }

                        @Test
                        @TestMetadata("contractsUsage.kt")
                        public void testContractsUsage() throws Exception {
                            runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromSource/good/callsInPlace/contractsUsage.kt");
                        }

                        @Test
                        @TestMetadata("exactlyOnce.kt")
                        public void testExactlyOnce() throws Exception {
                            runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromSource/good/callsInPlace/exactlyOnce.kt");
                        }

                        @Test
                        @TestMetadata("flow.kt")
                        public void testFlow() throws Exception {
                            runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromSource/good/callsInPlace/flow.kt");
                        }

                        @Test
                        @TestMetadata("inPlaceLambda.kt")
                        public void testInPlaceLambda() throws Exception {
                            runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromSource/good/callsInPlace/inPlaceLambda.kt");
                        }

                        @Test
                        @TestMetadata("simple.kt")
                        public void testSimple() throws Exception {
                            runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromSource/good/callsInPlace/simple.kt");
                        }

                        @Test
                        @TestMetadata("unknown.kt")
                        public void testUnknown() throws Exception {
                            runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromSource/good/callsInPlace/unknown.kt");
                        }
                    }

                    @Nested
                    @TestMetadata("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromSource/good/returnsImplies")
                    @TestDataPath("$PROJECT_ROOT")
                    public class ReturnsImplies {
                        @Test
                        public void testAllFilesPresentInReturnsImplies() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromSource/good/returnsImplies"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
                        }

                        @Test
                        @TestMetadata("booleanOperators.kt")
                        public void testBooleanOperators() throws Exception {
                            runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromSource/good/returnsImplies/booleanOperators.kt");
                        }

                        @Test
                        @TestMetadata("conditionLogic.kt")
                        public void testConditionLogic() throws Exception {
                            runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromSource/good/returnsImplies/conditionLogic.kt");
                        }

                        @Test
                        @TestMetadata("eqNotEq.kt")
                        public void testEqNotEq() throws Exception {
                            runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromSource/good/returnsImplies/eqNotEq.kt");
                        }

                        @Test
                        @TestMetadata("inapplicable.kt")
                        public void testInapplicable() throws Exception {
                            runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromSource/good/returnsImplies/inapplicable.kt");
                        }

                        @Test
                        @TestMetadata("namedArguments.kt")
                        public void testNamedArguments() throws Exception {
                            runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromSource/good/returnsImplies/namedArguments.kt");
                        }

                        @Test
                        @TestMetadata("notNull.kt")
                        public void testNotNull() throws Exception {
                            runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromSource/good/returnsImplies/notNull.kt");
                        }

                        @Test
                        @TestMetadata("propertyAccessors.kt")
                        public void testPropertyAccessors() throws Exception {
                            runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromSource/good/returnsImplies/propertyAccessors.kt");
                        }

                        @Test
                        @TestMetadata("receivers.kt")
                        public void testReceivers() throws Exception {
                            runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromSource/good/returnsImplies/receivers.kt");
                        }

                        @Test
                        @TestMetadata("safeCall.kt")
                        public void testSafeCall() throws Exception {
                            runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromSource/good/returnsImplies/safeCall.kt");
                        }

                        @Test
                        @TestMetadata("trickyCases.kt")
                        public void testTrickyCases() throws Exception {
                            runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromSource/good/returnsImplies/trickyCases.kt");
                        }

                        @Test
                        @TestMetadata("typePredicate.kt")
                        public void testTypePredicate() throws Exception {
                            runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromSource/good/returnsImplies/typePredicate.kt");
                        }
                    }

                    @Nested
                    @TestMetadata("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromSource/good/variousContracts")
                    @TestDataPath("$PROJECT_ROOT")
                    public class VariousContracts {
                        @Test
                        public void testAllFilesPresentInVariousContracts() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromSource/good/variousContracts"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
                        }

                        @Nested
                        @TestMetadata("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromSource/good/variousContracts/newSyntax")
                        @TestDataPath("$PROJECT_ROOT")
                        public class NewSyntax {
                            @Test
                            public void testAllFilesPresentInNewSyntax() throws Exception {
                                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromSource/good/variousContracts/newSyntax"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
                            }

                            @Test
                            @TestMetadata("functionsWithContract.kt")
                            public void testFunctionsWithContract() throws Exception {
                                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/contracts/fromSource/good/variousContracts/newSyntax/functionsWithContract.kt");
                            }
                        }
                    }
                }
            }
        }

        @Nested
        @TestMetadata("compiler/fir/analysis-tests/testData/resolveWithStdlib/delegates")
        @TestDataPath("$PROJECT_ROOT")
        public class Delegates {
            @Test
            public void testAllFilesPresentInDelegates() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolveWithStdlib/delegates"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
            }

            @Test
            @TestMetadata("annotationArgumentMapping.kt")
            public void testAnnotationArgumentMapping() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/delegates/annotationArgumentMapping.kt");
            }

            @Test
            @TestMetadata("anonymousInDelegate.kt")
            public void testAnonymousInDelegate() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/delegates/anonymousInDelegate.kt");
            }

            @Test
            @TestMetadata("delegateTypeMismatch.kt")
            public void testDelegateTypeMismatch() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/delegates/delegateTypeMismatch.kt");
            }

            @Test
            @TestMetadata("delegateWithAnonymousObject.kt")
            public void testDelegateWithAnonymousObject() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/delegates/delegateWithAnonymousObject.kt");
            }

            @Test
            @TestMetadata("getClassLet.kt")
            public void testGetClassLet() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/delegates/getClassLet.kt");
            }

            @Test
            @TestMetadata("kt41917.kt")
            public void testKt41917() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/delegates/kt41917.kt");
            }

            @Test
            @TestMetadata("mapValuesLazy.kt")
            public void testMapValuesLazy() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/delegates/mapValuesLazy.kt");
            }

            @Test
            @TestMetadata("nullableTypeDelegate.kt")
            public void testNullableTypeDelegate() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/delegates/nullableTypeDelegate.kt");
            }

            @Test
            @TestMetadata("propertyWithFunctionalType.kt")
            public void testPropertyWithFunctionalType() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/delegates/propertyWithFunctionalType.kt");
            }

            @Test
            @TestMetadata("sequentialLazy.kt")
            public void testSequentialLazy() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/delegates/sequentialLazy.kt");
            }

            @Test
            @TestMetadata("simpleDelegateProvider.kt")
            public void testSimpleDelegateProvider() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/delegates/simpleDelegateProvider.kt");
            }

            @Test
            @TestMetadata("simpleDelegatedToMap.kt")
            public void testSimpleDelegatedToMap() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/delegates/simpleDelegatedToMap.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/fir/analysis-tests/testData/resolveWithStdlib/diagnostics")
        @TestDataPath("$PROJECT_ROOT")
        public class Diagnostics {
            @Test
            public void testAllFilesPresentInDiagnostics() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolveWithStdlib/diagnostics"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
            }

            @Test
            @TestMetadata("forLoopChecker.kt")
            public void testForLoopChecker() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/diagnostics/forLoopChecker.kt");
            }

            @Nested
            @TestMetadata("compiler/fir/analysis-tests/testData/resolveWithStdlib/diagnostics/functionReturnTypeMismatchChecker")
            @TestDataPath("$PROJECT_ROOT")
            public class FunctionReturnTypeMismatchChecker {
                @Test
                public void testAllFilesPresentInFunctionReturnTypeMismatchChecker() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolveWithStdlib/diagnostics/functionReturnTypeMismatchChecker"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
                }

                @Test
                @TestMetadata("basic.kt")
                public void testBasic() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/diagnostics/functionReturnTypeMismatchChecker/basic.kt");
                }
            }

            @Nested
            @TestMetadata("compiler/fir/analysis-tests/testData/resolveWithStdlib/diagnostics/initializerTypeMismatchChecker")
            @TestDataPath("$PROJECT_ROOT")
            public class InitializerTypeMismatchChecker {
                @Test
                public void testAllFilesPresentInInitializerTypeMismatchChecker() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolveWithStdlib/diagnostics/initializerTypeMismatchChecker"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
                }

                @Test
                @TestMetadata("functionType.kt")
                public void testFunctionType() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/diagnostics/initializerTypeMismatchChecker/functionType.kt");
                }
            }
        }

        @Nested
        @TestMetadata("compiler/fir/analysis-tests/testData/resolveWithStdlib/inference")
        @TestDataPath("$PROJECT_ROOT")
        public class Inference {
            @Test
            public void testAllFilesPresentInInference() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolveWithStdlib/inference"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
            }

            @Test
            @TestMetadata("builderInference.kt")
            public void testBuilderInference() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/inference/builderInference.kt");
            }

            @Test
            @TestMetadata("builderInferenceAndCoercionToUnit.kt")
            public void testBuilderInferenceAndCoercionToUnit() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/inference/builderInferenceAndCoercionToUnit.kt");
            }

            @Test
            @TestMetadata("builderInferenceFromStdlib.kt")
            public void testBuilderInferenceFromStdlib() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/inference/builderInferenceFromStdlib.kt");
            }

            @Test
            @TestMetadata("complexConstraintSystem.kt")
            public void testComplexConstraintSystem() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/inference/complexConstraintSystem.kt");
            }

            @Test
            @TestMetadata("flexibleTypeInSystem.kt")
            public void testFlexibleTypeInSystem() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/inference/flexibleTypeInSystem.kt");
            }

            @Test
            @TestMetadata("ifElvisReturn.kt")
            public void testIfElvisReturn() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/inference/ifElvisReturn.kt");
            }

            @Test
            @TestMetadata("plusAssignWithLambdaInRhs.kt")
            public void testPlusAssignWithLambdaInRhs() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/inference/plusAssignWithLambdaInRhs.kt");
            }

            @Nested
            @TestMetadata("compiler/fir/analysis-tests/testData/resolveWithStdlib/inference/problems")
            @TestDataPath("$PROJECT_ROOT")
            public class Problems {
                @Test
                public void testAllFilesPresentInProblems() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolveWithStdlib/inference/problems"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
                }

                @Test
                @TestMetadata("buildList.kt")
                public void testBuildList() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/inference/problems/buildList.kt");
                }

                @Test
                @TestMetadata("buildListLazy.kt")
                public void testBuildListLazy() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/inference/problems/buildListLazy.kt");
                }

                @Test
                @TestMetadata("buildSetWithVisitor.kt")
                public void testBuildSetWithVisitor() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/inference/problems/buildSetWithVisitor.kt");
                }

                @Test
                @TestMetadata("expectedType.kt")
                public void testExpectedType() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/inference/problems/expectedType.kt");
                }
            }
        }

        @Nested
        @TestMetadata("compiler/fir/analysis-tests/testData/resolveWithStdlib/initialization")
        @TestDataPath("$PROJECT_ROOT")
        public class Initialization {
            @Test
            public void testAllFilesPresentInInitialization() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolveWithStdlib/initialization"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
            }

            @Test
            @TestMetadata("fromLocalMembers.kt")
            public void testFromLocalMembers() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/initialization/fromLocalMembers.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/fir/analysis-tests/testData/resolveWithStdlib/intellij")
        @TestDataPath("$PROJECT_ROOT")
        public class Intellij {
            @Test
            @TestMetadata("accessInSetter.kt")
            public void testAccessInSetter() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/intellij/accessInSetter.kt");
            }

            @Test
            public void testAllFilesPresentInIntellij() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolveWithStdlib/intellij"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
            }

            @Test
            @TestMetadata("arrayOfImports.kt")
            public void testArrayOfImports() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/intellij/arrayOfImports.kt");
            }

            @Test
            @TestMetadata("baseIntrospector.kt")
            public void testBaseIntrospector() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/intellij/baseIntrospector.kt");
            }

            @Test
            @TestMetadata("DailyAggregatedDoubleFactor.kt")
            public void testDailyAggregatedDoubleFactor() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/intellij/DailyAggregatedDoubleFactor.kt");
            }

            @Test
            @TestMetadata("defaultParameterFromBase.kt")
            public void testDefaultParameterFromBase() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/intellij/defaultParameterFromBase.kt");
            }

            @Test
            @TestMetadata("EnumWithToString.kt")
            public void testEnumWithToString() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/intellij/EnumWithToString.kt");
            }

            @Test
            @TestMetadata("FieldVsSyntheticAccessor.kt")
            public void testFieldVsSyntheticAccessor() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/intellij/FieldVsSyntheticAccessor.kt");
            }

            @Test
            @TestMetadata("hideBySeverity.kt")
            public void testHideBySeverity() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/intellij/hideBySeverity.kt");
            }

            @Test
            @TestMetadata("InnerClassOfThrowableOnObject.kt")
            public void testInnerClassOfThrowableOnObject() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/intellij/InnerClassOfThrowableOnObject.kt");
            }

            @Test
            @TestMetadata("IntersectionWithJavaString.kt")
            public void testIntersectionWithJavaString() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/intellij/IntersectionWithJavaString.kt");
            }

            @Test
            @TestMetadata("ParentOfType.kt")
            public void testParentOfType() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/intellij/ParentOfType.kt");
            }

            @Test
            @TestMetadata("PersistentStateComponent.kt")
            public void testPersistentStateComponent() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/intellij/PersistentStateComponent.kt");
            }

            @Test
            @TestMetadata("typeAliasAmbiguity.kt")
            public void testTypeAliasAmbiguity() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/intellij/typeAliasAmbiguity.kt");
            }

            @Test
            @TestMetadata("UastPatterns.kt")
            public void testUastPatterns() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/intellij/UastPatterns.kt");
            }

            @Test
            @TestMetadata("WithSpeedSearch.kt")
            public void testWithSpeedSearch() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/intellij/WithSpeedSearch.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k")
        @TestDataPath("$PROJECT_ROOT")
        public class J_k {
            @Test
            public void testAllFilesPresentInJ_k() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
            }

            @Test
            @TestMetadata("AnnotationWithEnum.kt")
            public void testAnnotationWithEnum() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k/AnnotationWithEnum.kt");
            }

            @Test
            @TestMetadata("BasicWithAnnotatedJava.kt")
            public void testBasicWithAnnotatedJava() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k/BasicWithAnnotatedJava.kt");
            }

            @Test
            @TestMetadata("BasicWithAnnotatedOverriddenJava.kt")
            public void testBasicWithAnnotatedOverriddenJava() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k/BasicWithAnnotatedOverriddenJava.kt");
            }

            @Test
            @TestMetadata("BasicWithJava.kt")
            public void testBasicWithJava() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k/BasicWithJava.kt");
            }

            @Test
            @TestMetadata("BasicWithJavaFakeOverride.kt")
            public void testBasicWithJavaFakeOverride() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k/BasicWithJavaFakeOverride.kt");
            }

            @Test
            @TestMetadata("BasicWithPrimitiveJava.kt")
            public void testBasicWithPrimitiveJava() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k/BasicWithPrimitiveJava.kt");
            }

            @Test
            @TestMetadata("capturedFlexible.kt")
            public void testCapturedFlexible() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k/capturedFlexible.kt");
            }

            @Test
            @TestMetadata("complexFlexibleInference.kt")
            public void testComplexFlexibleInference() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k/complexFlexibleInference.kt");
            }

            @Test
            @TestMetadata("FieldAccessFromDerived.kt")
            public void testFieldAccessFromDerived() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k/FieldAccessFromDerived.kt");
            }

            @Test
            @TestMetadata("FieldAndGetter.kt")
            public void testFieldAndGetter() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k/FieldAndGetter.kt");
            }

            @Test
            @TestMetadata("fieldOverride.kt")
            public void testFieldOverride() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k/fieldOverride.kt");
            }

            @Test
            @TestMetadata("FieldSubstitution.kt")
            public void testFieldSubstitution() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k/FieldSubstitution.kt");
            }

            @Test
            @TestMetadata("FlexiblePrimitiveOverloading.kt")
            public void testFlexiblePrimitiveOverloading() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k/FlexiblePrimitiveOverloading.kt");
            }

            @Test
            @TestMetadata("flexibleTypeAliases.kt")
            public void testFlexibleTypeAliases() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k/flexibleTypeAliases.kt");
            }

            @Test
            @TestMetadata("FunctionTypeInJava.kt")
            public void testFunctionTypeInJava() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k/FunctionTypeInJava.kt");
            }

            @Test
            @TestMetadata("IntersectionTypesProblem.kt")
            public void testIntersectionTypesProblem() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k/IntersectionTypesProblem.kt");
            }

            @Test
            @TestMetadata("JavaGetPrefixConflict.kt")
            public void testJavaGetPrefixConflict() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k/JavaGetPrefixConflict.kt");
            }

            @Test
            @TestMetadata("JavaInheritsKotlinDerived.kt")
            public void testJavaInheritsKotlinDerived() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k/JavaInheritsKotlinDerived.kt");
            }

            @Test
            @TestMetadata("JavaInheritsKotlinExtension.kt")
            public void testJavaInheritsKotlinExtension() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k/JavaInheritsKotlinExtension.kt");
            }

            @Test
            @TestMetadata("JavaInheritsKotlinProperty.kt")
            public void testJavaInheritsKotlinProperty() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k/JavaInheritsKotlinProperty.kt");
            }

            @Test
            @TestMetadata("JavaInheritsRawKotlin.kt")
            public void testJavaInheritsRawKotlin() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k/JavaInheritsRawKotlin.kt");
            }

            @Test
            @TestMetadata("JavaSyntheticProperty.kt")
            public void testJavaSyntheticProperty() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k/JavaSyntheticProperty.kt");
            }

            @Test
            @TestMetadata("JavaVisibility2.kt")
            public void testJavaVisibility2() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k/JavaVisibility2.kt");
            }

            @Test
            @TestMetadata("KJKComplexHierarchy.kt")
            public void testKJKComplexHierarchy() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k/KJKComplexHierarchy.kt");
            }

            @Test
            @TestMetadata("KJKComplexHierarchyWithNested.kt")
            public void testKJKComplexHierarchyWithNested() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k/KJKComplexHierarchyWithNested.kt");
            }

            @Test
            @TestMetadata("KJKInheritance.kt")
            public void testKJKInheritance() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k/KJKInheritance.kt");
            }

            @Test
            @TestMetadata("KJKInheritanceGeneric.kt")
            public void testKJKInheritanceGeneric() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k/KJKInheritanceGeneric.kt");
            }

            @Test
            @TestMetadata("KotlinClassParameter.kt")
            public void testKotlinClassParameter() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k/KotlinClassParameter.kt");
            }

            @Test
            @TestMetadata("KotlinClassParameterGeneric.kt")
            public void testKotlinClassParameterGeneric() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k/KotlinClassParameterGeneric.kt");
            }

            @Test
            @TestMetadata("kt39076.kt")
            public void testKt39076() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k/kt39076.kt");
            }

            @Test
            @TestMetadata("LoggerInstance.kt")
            public void testLoggerInstance() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k/LoggerInstance.kt");
            }

            @Test
            @TestMetadata("MapCompute.kt")
            public void testMapCompute() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k/MapCompute.kt");
            }

            @Test
            @TestMetadata("MapEntry.kt")
            public void testMapEntry() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k/MapEntry.kt");
            }

            @Test
            @TestMetadata("mapMerge.kt")
            public void testMapMerge() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k/mapMerge.kt");
            }

            @Test
            @TestMetadata("MyException.kt")
            public void testMyException() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k/MyException.kt");
            }

            @Test
            @TestMetadata("MyIterable.kt")
            public void testMyIterable() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k/MyIterable.kt");
            }

            @Test
            @TestMetadata("MyMap.kt")
            public void testMyMap() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k/MyMap.kt");
            }

            @Test
            @TestMetadata("outerInnerClasses.kt")
            public void testOuterInnerClasses() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k/outerInnerClasses.kt");
            }

            @Test
            @TestMetadata("OverrideWithJava.kt")
            public void testOverrideWithJava() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k/OverrideWithJava.kt");
            }

            @Test
            @TestMetadata("RawType.kt")
            public void testRawType() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k/RawType.kt");
            }

            @Test
            @TestMetadata("serializableString.kt")
            public void testSerializableString() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k/serializableString.kt");
            }

            @Test
            @TestMetadata("smartSet.kt")
            public void testSmartSet() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k/smartSet.kt");
            }

            @Test
            @TestMetadata("StaticClassConstructorFromBaseClass.kt")
            public void testStaticClassConstructorFromBaseClass() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k/StaticClassConstructorFromBaseClass.kt");
            }

            @Test
            @TestMetadata("StaticFromBaseClass.kt")
            public void testStaticFromBaseClass() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k/StaticFromBaseClass.kt");
            }

            @Test
            @TestMetadata("StaticGenericMethod.kt")
            public void testStaticGenericMethod() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k/StaticGenericMethod.kt");
            }

            @Test
            @TestMetadata("SyntheticAfterFiltering.kt")
            public void testSyntheticAfterFiltering() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k/SyntheticAfterFiltering.kt");
            }

            @Test
            @TestMetadata("SyntheticWithForEach.kt")
            public void testSyntheticWithForEach() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k/SyntheticWithForEach.kt");
            }

            @Test
            @TestMetadata("typeParameterUse.kt")
            public void testTypeParameterUse() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k/typeParameterUse.kt");
            }

            @Test
            @TestMetadata("UsingObject.kt")
            public void testUsingObject() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/j+k/UsingObject.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/fir/analysis-tests/testData/resolveWithStdlib/multiModule")
        @TestDataPath("$PROJECT_ROOT")
        public class MultiModule {
            @Test
            public void testAllFilesPresentInMultiModule() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolveWithStdlib/multiModule"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
            }

            @Test
            @TestMetadata("Basic.kt")
            public void testBasic() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/multiModule/Basic.kt");
            }

            @Test
            @TestMetadata("FakeOverrides.kt")
            public void testFakeOverrides() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/multiModule/FakeOverrides.kt");
            }

            @Test
            @TestMetadata("MemberType.kt")
            public void testMemberType() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/multiModule/MemberType.kt");
            }

            @Test
            @TestMetadata("Members.kt")
            public void testMembers() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/multiModule/Members.kt");
            }

            @Test
            @TestMetadata("SuperTypes.kt")
            public void testSuperTypes() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/multiModule/SuperTypes.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/fir/analysis-tests/testData/resolveWithStdlib/problems")
        @TestDataPath("$PROJECT_ROOT")
        public class Problems {
            @Test
            public void testAllFilesPresentInProblems() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolveWithStdlib/problems"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
            }

            @Test
            @TestMetadata("capturedTypeInEquality.kt")
            public void testCapturedTypeInEquality() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/problems/capturedTypeInEquality.kt");
            }

            @Test
            @TestMetadata("DeepCopyIrTree.kt")
            public void testDeepCopyIrTree() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/problems/DeepCopyIrTree.kt");
            }

            @Test
            @TestMetadata("definitelyNotNullCast.kt")
            public void testDefinitelyNotNullCast() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/problems/definitelyNotNullCast.kt");
            }

            @Test
            @TestMetadata("EnumMapGet.kt")
            public void testEnumMapGet() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/problems/EnumMapGet.kt");
            }

            @Test
            @TestMetadata("immutableName.kt")
            public void testImmutableName() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/problems/immutableName.kt");
            }

            @Test
            @TestMetadata("invokePriority.kt")
            public void testInvokePriority() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/problems/invokePriority.kt");
            }

            @Test
            @TestMetadata("invokePriorityComplex.kt")
            public void testInvokePriorityComplex() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/problems/invokePriorityComplex.kt");
            }

            @Test
            @TestMetadata("KJKComplexHierarchyNestedLoop.kt")
            public void testKJKComplexHierarchyNestedLoop() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/problems/KJKComplexHierarchyNestedLoop.kt");
            }

            @Test
            @TestMetadata("KtFirCompositeScope.kt")
            public void testKtFirCompositeScope() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/problems/KtFirCompositeScope.kt");
            }

            @Test
            @TestMetadata("lightMember.kt")
            public void testLightMember() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/problems/lightMember.kt");
            }

            @Test
            @TestMetadata("localScopesInAnonymousObject.kt")
            public void testLocalScopesInAnonymousObject() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/problems/localScopesInAnonymousObject.kt");
            }

            @Test
            @TestMetadata("qualifierPriority.kt")
            public void testQualifierPriority() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/problems/qualifierPriority.kt");
            }

            @Test
            @TestMetadata("receiverResolutionInLambda.kt")
            public void testReceiverResolutionInLambda() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/problems/receiverResolutionInLambda.kt");
            }

            @Test
            @TestMetadata("resolveToLocalFromCallSite.kt")
            public void testResolveToLocalFromCallSite() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/problems/resolveToLocalFromCallSite.kt");
            }

            @Test
            @TestMetadata("selfReferenceToCompanionObject.kt")
            public void testSelfReferenceToCompanionObject() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/problems/selfReferenceToCompanionObject.kt");
            }

            @Test
            @TestMetadata("SpecialCallsWithLambdas.kt")
            public void testSpecialCallsWithLambdas() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/problems/SpecialCallsWithLambdas.kt");
            }

            @Test
            @TestMetadata("stringConstructors.kt")
            public void testStringConstructors() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/problems/stringConstructors.kt");
            }

            @Test
            @TestMetadata("TypesEligibleForSimpleVisit.kt")
            public void testTypesEligibleForSimpleVisit() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/problems/TypesEligibleForSimpleVisit.kt");
            }

            @Test
            @TestMetadata("valueOfOrNull.kt")
            public void testValueOfOrNull() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/problems/valueOfOrNull.kt");
            }

            @Test
            @TestMetadata("weakHashMap.kt")
            public void testWeakHashMap() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/problems/weakHashMap.kt");
            }

            @Test
            @TestMetadata("WithValidityAssertion.kt")
            public void testWithValidityAssertion() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/problems/WithValidityAssertion.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/fir/analysis-tests/testData/resolveWithStdlib/properties")
        @TestDataPath("$PROJECT_ROOT")
        public class Properties {
            @Test
            public void testAllFilesPresentInProperties() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolveWithStdlib/properties"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
            }

            @Test
            @TestMetadata("explicitBackingFieldUnsupported.kt")
            public void testExplicitBackingFieldUnsupported() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/properties/explicitBackingFieldUnsupported.kt");
            }

            @Nested
            @TestMetadata("compiler/fir/analysis-tests/testData/resolveWithStdlib/properties/backingField")
            @TestDataPath("$PROJECT_ROOT")
            public class BackingField {
                @Test
                public void testAllFilesPresentInBackingField() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolveWithStdlib/properties/backingField"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
                }

                @Test
                @TestMetadata("backingFieldModifiers.kt")
                public void testBackingFieldModifiers() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/properties/backingField/backingFieldModifiers.kt");
                }

                @Test
                @TestMetadata("backingFieldVisibility.kt")
                public void testBackingFieldVisibility() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/properties/backingField/backingFieldVisibility.kt");
                }

                @Test
                @TestMetadata("backingFieldWithSmartTypeParameters.kt")
                public void testBackingFieldWithSmartTypeParameters() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/properties/backingField/backingFieldWithSmartTypeParameters.kt");
                }

                @Test
                @TestMetadata("explicitBackingFieldInInterface.kt")
                public void testExplicitBackingFieldInInterface() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/properties/backingField/explicitBackingFieldInInterface.kt");
                }

                @Test
                @TestMetadata("explicitBackingFieldType.kt")
                public void testExplicitBackingFieldType() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/properties/backingField/explicitBackingFieldType.kt");
                }

                @Test
                @TestMetadata("explicitBackingFieldsWithDelegates.kt")
                public void testExplicitBackingFieldsWithDelegates() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/properties/backingField/explicitBackingFieldsWithDelegates.kt");
                }

                @Test
                @TestMetadata("filePrivateBackingFieldAccess.kt")
                public void testFilePrivateBackingFieldAccess() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/properties/backingField/filePrivateBackingFieldAccess.kt");
                }

                @Test
                @TestMetadata("lateinitBackingFields.kt")
                public void testLateinitBackingFields() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/properties/backingField/lateinitBackingFields.kt");
                }

                @Test
                @TestMetadata("localVariablesWithBackingFields.kt")
                public void testLocalVariablesWithBackingFields() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/properties/backingField/localVariablesWithBackingFields.kt");
                }

                @Test
                @TestMetadata("overriddenPropertiesWithExplicitBackingFields.kt")
                public void testOverriddenPropertiesWithExplicitBackingFields() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/properties/backingField/overriddenPropertiesWithExplicitBackingFields.kt");
                }

                @Test
                @TestMetadata("propertyTypeNarrowing.kt")
                public void testPropertyTypeNarrowing() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/properties/backingField/propertyTypeNarrowing.kt");
                }

                @Test
                @TestMetadata("randomWeirdBackingFields.kt")
                public void testRandomWeirdBackingFields() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/properties/backingField/randomWeirdBackingFields.kt");
                }

                @Test
                @TestMetadata("redundantExplicitBackingField.kt")
                public void testRedundantExplicitBackingField() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/properties/backingField/redundantExplicitBackingField.kt");
                }

                @Test
                @TestMetadata("untypedPropertyWithBackingFieldUsage.kt")
                public void testUntypedPropertyWithBackingFieldUsage() throws Exception {
                    runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/properties/backingField/untypedPropertyWithBackingFieldUsage.kt");
                }
            }
        }

        @Nested
        @TestMetadata("compiler/fir/analysis-tests/testData/resolveWithStdlib/reinitializations")
        @TestDataPath("$PROJECT_ROOT")
        public class Reinitializations {
            @Test
            public void testAllFilesPresentInReinitializations() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolveWithStdlib/reinitializations"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
            }

            @Test
            @TestMetadata("constructorVarWrite.kt")
            public void testConstructorVarWrite() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/reinitializations/constructorVarWrite.kt");
            }
        }

        @Nested
        @TestMetadata("compiler/fir/analysis-tests/testData/resolveWithStdlib/smartcasts")
        @TestDataPath("$PROJECT_ROOT")
        public class Smartcasts {
            @Test
            public void testAllFilesPresentInSmartcasts() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/fir/analysis-tests/testData/resolveWithStdlib/smartcasts"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
            }

            @Test
            @TestMetadata("assertIs.kt")
            public void testAssertIs() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/smartcasts/assertIs.kt");
            }

            @Test
            @TestMetadata("tryWithLambdaInside.kt")
            public void testTryWithLambdaInside() throws Exception {
                runTest("compiler/fir/analysis-tests/testData/resolveWithStdlib/smartcasts/tryWithLambdaInside.kt");
            }
        }
    }
}
