/*
 * Copyright 2010-2021 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.analysis.low.level.api.fir;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link GenerateNewCompilerTests.kt}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("analysis/low-level-api-fir/testdata/partialRawBuilder")
@TestDataPath("$PROJECT_ROOT")
public class PartialRawFirBuilderTestCaseGenerated extends AbstractPartialRawFirBuilderTestCase {
    @Test
    public void testAllFilesPresentInPartialRawBuilder() throws Exception {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/low-level-api-fir/testdata/partialRawBuilder"), Pattern.compile("^(.+)\\.kt$"), null, true);
    }

    @Test
    @TestMetadata("localFunction.kt")
    public void testLocalFunction() throws Exception {
        runTest("analysis/low-level-api-fir/testdata/partialRawBuilder/localFunction.kt");
    }

    @Test
    @TestMetadata("memberFunction.kt")
    public void testMemberFunction() throws Exception {
        runTest("analysis/low-level-api-fir/testdata/partialRawBuilder/memberFunction.kt");
    }

    @Test
    @TestMetadata("memberProperty.kt")
    public void testMemberProperty() throws Exception {
        runTest("analysis/low-level-api-fir/testdata/partialRawBuilder/memberProperty.kt");
    }

    @Test
    @TestMetadata("paramemtersCatching.kt")
    public void testParamemtersCatching() throws Exception {
        runTest("analysis/low-level-api-fir/testdata/partialRawBuilder/paramemtersCatching.kt");
    }

    @Test
    @TestMetadata("simpleFunction.kt")
    public void testSimpleFunction() throws Exception {
        runTest("analysis/low-level-api-fir/testdata/partialRawBuilder/simpleFunction.kt");
    }

    @Test
    @TestMetadata("simpleVal.kt")
    public void testSimpleVal() throws Exception {
        runTest("analysis/low-level-api-fir/testdata/partialRawBuilder/simpleVal.kt");
    }

    @Test
    @TestMetadata("simpleVar.kt")
    public void testSimpleVar() throws Exception {
        runTest("analysis/low-level-api-fir/testdata/partialRawBuilder/simpleVar.kt");
    }
}
