/*
 * Copyright 2010-2021 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.analysis.low.level.api.fir;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link GenerateNewCompilerTests.kt}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("analysis/low-level-api-fir/testdata/lazyResolve")
@TestDataPath("$PROJECT_ROOT")
public class FirLazyDeclarationResolveTestGenerated extends AbstractFirLazyDeclarationResolveTest {
    @Test
    public void testAllFilesPresentInLazyResolve() throws Exception {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/low-level-api-fir/testdata/lazyResolve"), Pattern.compile("^(.+)\\.kt$"), null, true);
    }

    @Test
    @TestMetadata("annotationParameters.kt")
    public void testAnnotationParameters() throws Exception {
        runTest("analysis/low-level-api-fir/testdata/lazyResolve/annotationParameters.kt");
    }

    @Test
    @TestMetadata("annotations.kt")
    public void testAnnotations() throws Exception {
        runTest("analysis/low-level-api-fir/testdata/lazyResolve/annotations.kt");
    }

    @Test
    @TestMetadata("classMembers.kt")
    public void testClassMembers() throws Exception {
        runTest("analysis/low-level-api-fir/testdata/lazyResolve/classMembers.kt");
    }

    @Test
    @TestMetadata("delegates.kt")
    public void testDelegates() throws Exception {
        runTest("analysis/low-level-api-fir/testdata/lazyResolve/delegates.kt");
    }

    @Test
    @TestMetadata("functionWithParameter.kt")
    public void testFunctionWithParameter() throws Exception {
        runTest("analysis/low-level-api-fir/testdata/lazyResolve/functionWithParameter.kt");
    }

    @Test
    @TestMetadata("parameterOfNonLocalSetter.kt")
    public void testParameterOfNonLocalSetter() throws Exception {
        runTest("analysis/low-level-api-fir/testdata/lazyResolve/parameterOfNonLocalSetter.kt");
    }

    @Test
    @TestMetadata("propertyWithGetter.kt")
    public void testPropertyWithGetter() throws Exception {
        runTest("analysis/low-level-api-fir/testdata/lazyResolve/propertyWithGetter.kt");
    }

    @Test
    @TestMetadata("propertyWithGetterAndSetter.kt")
    public void testPropertyWithGetterAndSetter() throws Exception {
        runTest("analysis/low-level-api-fir/testdata/lazyResolve/propertyWithGetterAndSetter.kt");
    }

    @Test
    @TestMetadata("propertyWithInitializer.kt")
    public void testPropertyWithInitializer() throws Exception {
        runTest("analysis/low-level-api-fir/testdata/lazyResolve/propertyWithInitializer.kt");
    }

    @Test
    @TestMetadata("secondaryConstructor.kt")
    public void testSecondaryConstructor() throws Exception {
        runTest("analysis/low-level-api-fir/testdata/lazyResolve/secondaryConstructor.kt");
    }

    @Test
    @TestMetadata("superTypes.kt")
    public void testSuperTypes() throws Exception {
        runTest("analysis/low-level-api-fir/testdata/lazyResolve/superTypes.kt");
    }

    @Test
    @TestMetadata("superTypesLoop.kt")
    public void testSuperTypesLoop() throws Exception {
        runTest("analysis/low-level-api-fir/testdata/lazyResolve/superTypesLoop.kt");
    }

    @Test
    @TestMetadata("topLevelFunctions.kt")
    public void testTopLevelFunctions() throws Exception {
        runTest("analysis/low-level-api-fir/testdata/lazyResolve/topLevelFunctions.kt");
    }

    @Test
    @TestMetadata("topLevelFunctionsWithExpressionBodyAndExplicitType.kt")
    public void testTopLevelFunctionsWithExpressionBodyAndExplicitType() throws Exception {
        runTest("analysis/low-level-api-fir/testdata/lazyResolve/topLevelFunctionsWithExpressionBodyAndExplicitType.kt");
    }

    @Test
    @TestMetadata("topLevelFunctionsWithImplicitType.kt")
    public void testTopLevelFunctionsWithImplicitType() throws Exception {
        runTest("analysis/low-level-api-fir/testdata/lazyResolve/topLevelFunctionsWithImplicitType.kt");
    }

    @Test
    @TestMetadata("typeParameterOfNonLocalFunction.kt")
    public void testTypeParameterOfNonLocalFunction() throws Exception {
        runTest("analysis/low-level-api-fir/testdata/lazyResolve/typeParameterOfNonLocalFunction.kt");
    }

    @Test
    @TestMetadata("typeParameterOfTopFunction.kt")
    public void testTypeParameterOfTopFunction() throws Exception {
        runTest("analysis/low-level-api-fir/testdata/lazyResolve/typeParameterOfTopFunction.kt");
    }

    @Test
    @TestMetadata("typeParameterOfTopSetter.kt")
    public void testTypeParameterOfTopSetter() throws Exception {
        runTest("analysis/low-level-api-fir/testdata/lazyResolve/typeParameterOfTopSetter.kt");
    }
}
