/*
 * Copyright 2010-2021 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.analysis.api.standalone.fir.test.cases.generated.cases.references;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.standalone.fir.test.AnalysisApiFirStandaloneModeTestConfiguratorFactory;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.AnalysisApiTestConfiguratorFactoryData;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.AnalysisApiTestConfigurator;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.TestModuleKind;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.FrontendKind;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.AnalysisSessionMode;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.AnalysisApiMode;
import org.jetbrains.kotlin.analysis.api.impl.base.test.cases.references.AbstractReferenceResolveTest;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link GenerateNewCompilerTests.kt}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("analysis/analysis-api/testData/referenceResolve")
@TestDataPath("$PROJECT_ROOT")
public class FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated extends AbstractReferenceResolveTest {
    @NotNull
    @Override
    public AnalysisApiTestConfigurator getConfigurator() {
        return AnalysisApiFirStandaloneModeTestConfiguratorFactory.INSTANCE.createConfigurator(
            new AnalysisApiTestConfiguratorFactoryData(
                FrontendKind.Fir,
                TestModuleKind.Source,
                AnalysisSessionMode.Normal,
                AnalysisApiMode.Standalone
            )
        );
    }

    @Test
    public void testAllFilesPresentInReferenceResolve() throws Exception {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/referenceResolve"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
    }

    @Test
    @TestMetadata("AnnotationForClass.kt")
    public void testAnnotationForClass() throws Exception {
        runTest("analysis/analysis-api/testData/referenceResolve/AnnotationForClass.kt");
    }

    @Test
    @TestMetadata("AnnotationInsideFunction.kt")
    public void testAnnotationInsideFunction() throws Exception {
        runTest("analysis/analysis-api/testData/referenceResolve/AnnotationInsideFunction.kt");
    }

    @Test
    @TestMetadata("AnnotationOnFile.kt")
    public void testAnnotationOnFile() throws Exception {
        runTest("analysis/analysis-api/testData/referenceResolve/AnnotationOnFile.kt");
    }

    @Test
    @TestMetadata("AnnotationOnFileWithImport.kt")
    public void testAnnotationOnFileWithImport() throws Exception {
        runTest("analysis/analysis-api/testData/referenceResolve/AnnotationOnFileWithImport.kt");
    }

    @Test
    @TestMetadata("AnnotationTypeParameter.kt")
    public void testAnnotationTypeParameter() throws Exception {
        runTest("analysis/analysis-api/testData/referenceResolve/AnnotationTypeParameter.kt");
    }

    @Test
    @TestMetadata("ClassInTypeConstraint.kt")
    public void testClassInTypeConstraint() throws Exception {
        runTest("analysis/analysis-api/testData/referenceResolve/ClassInTypeConstraint.kt");
    }

    @Test
    @TestMetadata("ClassObjectClassLiteralReference.kt")
    public void testClassObjectClassLiteralReference() throws Exception {
        runTest("analysis/analysis-api/testData/referenceResolve/ClassObjectClassLiteralReference.kt");
    }

    @Test
    @TestMetadata("ClassObjectClassLiteralReferenceWithField.kt")
    public void testClassObjectClassLiteralReferenceWithField() throws Exception {
        runTest("analysis/analysis-api/testData/referenceResolve/ClassObjectClassLiteralReferenceWithField.kt");
    }

    @Test
    @TestMetadata("ClassQualifierForNestedClassConstructorCall.kt")
    public void testClassQualifierForNestedClassConstructorCall() throws Exception {
        runTest("analysis/analysis-api/testData/referenceResolve/ClassQualifierForNestedClassConstructorCall.kt");
    }

    @Test
    @TestMetadata("ClassReferenceInImport.kt")
    public void testClassReferenceInImport() throws Exception {
        runTest("analysis/analysis-api/testData/referenceResolve/ClassReferenceInImport.kt");
    }

    @Test
    @TestMetadata("CtrlClickResolve.kt")
    public void testCtrlClickResolve() throws Exception {
        runTest("analysis/analysis-api/testData/referenceResolve/CtrlClickResolve.kt");
    }

    @Test
    @TestMetadata("DefaultObjectAsExtensionReceiverForFunction.kt")
    public void testDefaultObjectAsExtensionReceiverForFunction() throws Exception {
        runTest("analysis/analysis-api/testData/referenceResolve/DefaultObjectAsExtensionReceiverForFunction.kt");
    }

    @Test
    @TestMetadata("DefaultObjectAsExtensionReceiverForProperty.kt")
    public void testDefaultObjectAsExtensionReceiverForProperty() throws Exception {
        runTest("analysis/analysis-api/testData/referenceResolve/DefaultObjectAsExtensionReceiverForProperty.kt");
    }

    @Test
    @TestMetadata("DefaultObjectAsReceiverForExtensionFunctionOnSuperType.kt")
    public void testDefaultObjectAsReceiverForExtensionFunctionOnSuperType() throws Exception {
        runTest("analysis/analysis-api/testData/referenceResolve/DefaultObjectAsReceiverForExtensionFunctionOnSuperType.kt");
    }

    @Test
    @TestMetadata("DefaultObjectAsReceiverForMemberPropertyInSuperType.kt")
    public void testDefaultObjectAsReceiverForMemberPropertyInSuperType() throws Exception {
        runTest("analysis/analysis-api/testData/referenceResolve/DefaultObjectAsReceiverForMemberPropertyInSuperType.kt");
    }

    @Test
    @TestMetadata("DefaultObjectInShortReferenceFormCall.kt")
    public void testDefaultObjectInShortReferenceFormCall() throws Exception {
        runTest("analysis/analysis-api/testData/referenceResolve/DefaultObjectInShortReferenceFormCall.kt");
    }

    @Test
    @TestMetadata("Deprecated.kt")
    public void testDeprecated() throws Exception {
        runTest("analysis/analysis-api/testData/referenceResolve/Deprecated.kt");
    }

    @Test
    @TestMetadata("EnumValues.kt")
    public void testEnumValues() throws Exception {
        runTest("analysis/analysis-api/testData/referenceResolve/EnumValues.kt");
    }

    @Test
    @TestMetadata("explicitFunctionalInterfaceInvoke_globalVal.kt")
    public void testExplicitFunctionalInterfaceInvoke_globalVal() throws Exception {
        runTest("analysis/analysis-api/testData/referenceResolve/explicitFunctionalInterfaceInvoke_globalVal.kt");
    }

    @Test
    @TestMetadata("explicitFunctionalInterfaceInvoke_parameter.kt")
    public void testExplicitFunctionalInterfaceInvoke_parameter() throws Exception {
        runTest("analysis/analysis-api/testData/referenceResolve/explicitFunctionalInterfaceInvoke_parameter.kt");
    }

    @Test
    @TestMetadata("explicitLambdaParameter.kt")
    public void testExplicitLambdaParameter() throws Exception {
        runTest("analysis/analysis-api/testData/referenceResolve/explicitLambdaParameter.kt");
    }

    @Test
    @TestMetadata("ExternalCompanionObject.kt")
    public void testExternalCompanionObject() throws Exception {
        runTest("analysis/analysis-api/testData/referenceResolve/ExternalCompanionObject.kt");
    }

    @Test
    @TestMetadata("functionCall.kt")
    public void testFunctionCall() throws Exception {
        runTest("analysis/analysis-api/testData/referenceResolve/functionCall.kt");
    }

    @Test
    @TestMetadata("GenericFunctionParameter.kt")
    public void testGenericFunctionParameter() throws Exception {
        runTest("analysis/analysis-api/testData/referenceResolve/GenericFunctionParameter.kt");
    }

    @Test
    @TestMetadata("GenericTypeInFunctionParameter.kt")
    public void testGenericTypeInFunctionParameter() throws Exception {
        runTest("analysis/analysis-api/testData/referenceResolve/GenericTypeInFunctionParameter.kt");
    }

    @Test
    @TestMetadata("implicitExtensionInvoke.kt")
    public void testImplicitExtensionInvoke() throws Exception {
        runTest("analysis/analysis-api/testData/referenceResolve/implicitExtensionInvoke.kt");
    }

    @Test
    @TestMetadata("implicitFunctionInvoke.kt")
    public void testImplicitFunctionInvoke() throws Exception {
        runTest("analysis/analysis-api/testData/referenceResolve/implicitFunctionInvoke.kt");
    }

    @Test
    @TestMetadata("implicitFunctionalInterfaceInvoke.kt")
    public void testImplicitFunctionalInterfaceInvoke() throws Exception {
        runTest("analysis/analysis-api/testData/referenceResolve/implicitFunctionalInterfaceInvoke.kt");
    }

    @Test
    @TestMetadata("implicitLambdaParameter.kt")
    public void testImplicitLambdaParameter() throws Exception {
        runTest("analysis/analysis-api/testData/referenceResolve/implicitLambdaParameter.kt");
    }

    @Test
    @TestMetadata("importAlias.kt")
    public void testImportAlias() throws Exception {
        runTest("analysis/analysis-api/testData/referenceResolve/importAlias.kt");
    }

    @Test
    @TestMetadata("ImportFromRootScope.kt")
    public void testImportFromRootScope() throws Exception {
        runTest("analysis/analysis-api/testData/referenceResolve/ImportFromRootScope.kt");
    }

    @Test
    @TestMetadata("InClassParameter.kt")
    public void testInClassParameter() throws Exception {
        runTest("analysis/analysis-api/testData/referenceResolve/InClassParameter.kt");
    }

    @Test
    @TestMetadata("InClassParameterField.kt")
    public void testInClassParameterField() throws Exception {
        runTest("analysis/analysis-api/testData/referenceResolve/InClassParameterField.kt");
    }

    @Test
    @TestMetadata("InEnumEntry.kt")
    public void testInEnumEntry() throws Exception {
        runTest("analysis/analysis-api/testData/referenceResolve/InEnumEntry.kt");
    }

    @Test
    @TestMetadata("InFunctionParameterType.kt")
    public void testInFunctionParameterType() throws Exception {
        runTest("analysis/analysis-api/testData/referenceResolve/InFunctionParameterType.kt");
    }

    @Test
    @TestMetadata("InMethodParameter.kt")
    public void testInMethodParameter() throws Exception {
        runTest("analysis/analysis-api/testData/referenceResolve/InMethodParameter.kt");
    }

    @Test
    @TestMetadata("InMethodVarargParameter.kt")
    public void testInMethodVarargParameter() throws Exception {
        runTest("analysis/analysis-api/testData/referenceResolve/InMethodVarargParameter.kt");
    }

    @Test
    @TestMetadata("InVaragReferenceInFunctionBody.kt")
    public void testInVaragReferenceInFunctionBody() throws Exception {
        runTest("analysis/analysis-api/testData/referenceResolve/InVaragReferenceInFunctionBody.kt");
    }

    @Test
    @TestMetadata("InVaragReferenceInNamedParameter.kt")
    public void testInVaragReferenceInNamedParameter() throws Exception {
        runTest("analysis/analysis-api/testData/referenceResolve/InVaragReferenceInNamedParameter.kt");
    }

    @Test
    @TestMetadata("JavaAnnotationParameter.kt")
    public void testJavaAnnotationParameter() throws Exception {
        runTest("analysis/analysis-api/testData/referenceResolve/JavaAnnotationParameter.kt");
    }

    @Test
    @TestMetadata("JavaConstructorNotNullParameter.kt")
    public void testJavaConstructorNotNullParameter() throws Exception {
        runTest("analysis/analysis-api/testData/referenceResolve/JavaConstructorNotNullParameter.kt");
    }

    @Test
    @TestMetadata("JavaEnumEntry.kt")
    public void testJavaEnumEntry() throws Exception {
        runTest("analysis/analysis-api/testData/referenceResolve/JavaEnumEntry.kt");
    }

    @Test
    @TestMetadata("JavaEnumValueOf.kt")
    public void testJavaEnumValueOf() throws Exception {
        runTest("analysis/analysis-api/testData/referenceResolve/JavaEnumValueOf.kt");
    }

    @Test
    @TestMetadata("JavaReference.kt")
    public void testJavaReference() throws Exception {
        runTest("analysis/analysis-api/testData/referenceResolve/JavaReference.kt");
    }

    @Test
    @TestMetadata("JavaStaticMethod.kt")
    public void testJavaStaticMethod() throws Exception {
        runTest("analysis/analysis-api/testData/referenceResolve/JavaStaticMethod.kt");
    }

    @Test
    @TestMetadata("KotlinPropertyAssignment.kt")
    public void testKotlinPropertyAssignment() throws Exception {
        runTest("analysis/analysis-api/testData/referenceResolve/KotlinPropertyAssignment.kt");
    }

    @Test
    @TestMetadata("KotlinPropertyWithGetterAndSetterAssignment.kt")
    public void testKotlinPropertyWithGetterAndSetterAssignment() throws Exception {
        runTest("analysis/analysis-api/testData/referenceResolve/KotlinPropertyWithGetterAndSetterAssignment.kt");
    }

    @Test
    @TestMetadata("MultiDeclarationExtension.kt")
    public void testMultiDeclarationExtension() throws Exception {
        runTest("analysis/analysis-api/testData/referenceResolve/MultiDeclarationExtension.kt");
    }

    @Test
    @TestMetadata("MultiDeclarationMember.kt")
    public void testMultiDeclarationMember() throws Exception {
        runTest("analysis/analysis-api/testData/referenceResolve/MultiDeclarationMember.kt");
    }

    @Test
    @TestMetadata("NamedClassObject.kt")
    public void testNamedClassObject() throws Exception {
        runTest("analysis/analysis-api/testData/referenceResolve/NamedClassObject.kt");
    }

    @Test
    @TestMetadata("PackageReference.kt")
    public void testPackageReference() throws Exception {
        runTest("analysis/analysis-api/testData/referenceResolve/PackageReference.kt");
    }

    @Test
    @TestMetadata("PackageReferenceInImport.kt")
    public void testPackageReferenceInImport() throws Exception {
        runTest("analysis/analysis-api/testData/referenceResolve/PackageReferenceInImport.kt");
    }

    @Test
    @TestMetadata("parameterByName.kt")
    public void testParameterByName() throws Exception {
        runTest("analysis/analysis-api/testData/referenceResolve/parameterByName.kt");
    }

    @Test
    @TestMetadata("PlusAssignByHand.kt")
    public void testPlusAssignByHand() throws Exception {
        runTest("analysis/analysis-api/testData/referenceResolve/PlusAssignByHand.kt");
    }

    @Test
    @TestMetadata("PlusAssignOperator.kt")
    public void testPlusAssignOperator() throws Exception {
        runTest("analysis/analysis-api/testData/referenceResolve/PlusAssignOperator.kt");
    }

    @Test
    @TestMetadata("PlusAssignViaPlusOperator.kt")
    public void testPlusAssignViaPlusOperator() throws Exception {
        runTest("analysis/analysis-api/testData/referenceResolve/PlusAssignViaPlusOperator.kt");
    }

    @Test
    @TestMetadata("ReferenceInClassWhereConstraint.kt")
    public void testReferenceInClassWhereConstraint() throws Exception {
        runTest("analysis/analysis-api/testData/referenceResolve/ReferenceInClassWhereConstraint.kt");
    }

    @Test
    @TestMetadata("ReferenceInFunWhereConstraint.kt")
    public void testReferenceInFunWhereConstraint() throws Exception {
        runTest("analysis/analysis-api/testData/referenceResolve/ReferenceInFunWhereConstraint.kt");
    }

    @Test
    @TestMetadata("ReferenceToSam.kt")
    public void testReferenceToSam() throws Exception {
        runTest("analysis/analysis-api/testData/referenceResolve/ReferenceToSam.kt");
    }

    @Test
    @TestMetadata("ResolveClass.kt")
    public void testResolveClass() throws Exception {
        runTest("analysis/analysis-api/testData/referenceResolve/ResolveClass.kt");
    }

    @Test
    @TestMetadata("ResolvePackageInProperty.kt")
    public void testResolvePackageInProperty() throws Exception {
        runTest("analysis/analysis-api/testData/referenceResolve/ResolvePackageInProperty.kt");
    }

    @Test
    @TestMetadata("ResolvePackageInTheEndInProperty.kt")
    public void testResolvePackageInTheEndInProperty() throws Exception {
        runTest("analysis/analysis-api/testData/referenceResolve/ResolvePackageInTheEndInProperty.kt");
    }

    @Test
    @TestMetadata("ResolvePackageInTheMiddleInProperty.kt")
    public void testResolvePackageInTheMiddleInProperty() throws Exception {
        runTest("analysis/analysis-api/testData/referenceResolve/ResolvePackageInTheMiddleInProperty.kt");
    }

    @Test
    @TestMetadata("ResolvePackageInTheTypeNameInProperty.kt")
    public void testResolvePackageInTheTypeNameInProperty() throws Exception {
        runTest("analysis/analysis-api/testData/referenceResolve/ResolvePackageInTheTypeNameInProperty.kt");
    }

    @Test
    @TestMetadata("RetentionValue.kt")
    public void testRetentionValue() throws Exception {
        runTest("analysis/analysis-api/testData/referenceResolve/RetentionValue.kt");
    }

    @Test
    @TestMetadata("SamAdapter.kt")
    public void testSamAdapter() throws Exception {
        runTest("analysis/analysis-api/testData/referenceResolve/SamAdapter.kt");
    }

    @Test
    @TestMetadata("SamConstructor.kt")
    public void testSamConstructor() throws Exception {
        runTest("analysis/analysis-api/testData/referenceResolve/SamConstructor.kt");
    }

    @Test
    @TestMetadata("SamConstructorTypeArguments.kt")
    public void testSamConstructorTypeArguments() throws Exception {
        runTest("analysis/analysis-api/testData/referenceResolve/SamConstructorTypeArguments.kt");
    }

    @Test
    @TestMetadata("SeveralOverrides.kt")
    public void testSeveralOverrides() throws Exception {
        runTest("analysis/analysis-api/testData/referenceResolve/SeveralOverrides.kt");
    }

    @Test
    @TestMetadata("SuperTypePrimaryConstructor.kt")
    public void testSuperTypePrimaryConstructor() throws Exception {
        runTest("analysis/analysis-api/testData/referenceResolve/SuperTypePrimaryConstructor.kt");
    }

    @Test
    @TestMetadata("SuperTypeSecondaryConstructor.kt")
    public void testSuperTypeSecondaryConstructor() throws Exception {
        runTest("analysis/analysis-api/testData/referenceResolve/SuperTypeSecondaryConstructor.kt");
    }

    @Test
    @TestMetadata("superWithLabel_caretAtLabel.kt")
    public void testSuperWithLabel_caretAtLabel() throws Exception {
        runTest("analysis/analysis-api/testData/referenceResolve/superWithLabel_caretAtLabel.kt");
    }

    @Test
    @TestMetadata("superWithLabel_caretAtSuper.kt")
    public void testSuperWithLabel_caretAtSuper() throws Exception {
        runTest("analysis/analysis-api/testData/referenceResolve/superWithLabel_caretAtSuper.kt");
    }

    @Test
    @TestMetadata("SyntheticProperty.kt")
    public void testSyntheticProperty() throws Exception {
        runTest("analysis/analysis-api/testData/referenceResolve/SyntheticProperty.kt");
    }

    @Test
    @TestMetadata("thisWithLabelToFunction_caretAtLabel.kt")
    public void testThisWithLabelToFunction_caretAtLabel() throws Exception {
        runTest("analysis/analysis-api/testData/referenceResolve/thisWithLabelToFunction_caretAtLabel.kt");
    }

    @Test
    @TestMetadata("thisWithLabelToFunction_caretAtThis.kt")
    public void testThisWithLabelToFunction_caretAtThis() throws Exception {
        runTest("analysis/analysis-api/testData/referenceResolve/thisWithLabelToFunction_caretAtThis.kt");
    }

    @Test
    @TestMetadata("thisWithLabelToProperty_caretAtLabel.kt")
    public void testThisWithLabelToProperty_caretAtLabel() throws Exception {
        runTest("analysis/analysis-api/testData/referenceResolve/thisWithLabelToProperty_caretAtLabel.kt");
    }

    @Test
    @TestMetadata("thisWithLabelToProperty_caretAtThis.kt")
    public void testThisWithLabelToProperty_caretAtThis() throws Exception {
        runTest("analysis/analysis-api/testData/referenceResolve/thisWithLabelToProperty_caretAtThis.kt");
    }

    @Test
    @TestMetadata("todo.kt")
    public void testTodo() throws Exception {
        runTest("analysis/analysis-api/testData/referenceResolve/todo.kt");
    }

    @Test
    @TestMetadata("TopLevelClassVsLocalClassConstructor.kt")
    public void testTopLevelClassVsLocalClassConstructor() throws Exception {
        runTest("analysis/analysis-api/testData/referenceResolve/TopLevelClassVsLocalClassConstructor.kt");
    }

    @Test
    @TestMetadata("TopLevelClassVsLocalClassConstructor2.kt")
    public void testTopLevelClassVsLocalClassConstructor2() throws Exception {
        runTest("analysis/analysis-api/testData/referenceResolve/TopLevelClassVsLocalClassConstructor2.kt");
    }

    @Test
    @TestMetadata("TopLevelCompanionObjectVsLocalClassConstructor.kt")
    public void testTopLevelCompanionObjectVsLocalClassConstructor() throws Exception {
        runTest("analysis/analysis-api/testData/referenceResolve/TopLevelCompanionObjectVsLocalClassConstructor.kt");
    }

    @Test
    @TestMetadata("TopLevelCompanionObjectVsLocalClassConstructor2.kt")
    public void testTopLevelCompanionObjectVsLocalClassConstructor2() throws Exception {
        runTest("analysis/analysis-api/testData/referenceResolve/TopLevelCompanionObjectVsLocalClassConstructor2.kt");
    }

    @Test
    @TestMetadata("TopLevelCompanionObjectVsLocalClassQualifier.kt")
    public void testTopLevelCompanionObjectVsLocalClassQualifier() throws Exception {
        runTest("analysis/analysis-api/testData/referenceResolve/TopLevelCompanionObjectVsLocalClassQualifier.kt");
    }

    @Test
    @TestMetadata("TopLevelObjectVsLocalClassConstructor.kt")
    public void testTopLevelObjectVsLocalClassConstructor() throws Exception {
        runTest("analysis/analysis-api/testData/referenceResolve/TopLevelObjectVsLocalClassConstructor.kt");
    }

    @Test
    @TestMetadata("TopLevelObjectVsLocalClassConstructor2.kt")
    public void testTopLevelObjectVsLocalClassConstructor2() throws Exception {
        runTest("analysis/analysis-api/testData/referenceResolve/TopLevelObjectVsLocalClassConstructor2.kt");
    }

    @Test
    @TestMetadata("TopLevelObjectVsLocalClassConstructor3.kt")
    public void testTopLevelObjectVsLocalClassConstructor3() throws Exception {
        runTest("analysis/analysis-api/testData/referenceResolve/TopLevelObjectVsLocalClassConstructor3.kt");
    }

    @Test
    @TestMetadata("TopLevelObjectVsLocalClassConstructor4.kt")
    public void testTopLevelObjectVsLocalClassConstructor4() throws Exception {
        runTest("analysis/analysis-api/testData/referenceResolve/TopLevelObjectVsLocalClassConstructor4.kt");
    }

    @Test
    @TestMetadata("TopLevelObjectVsLocalClassQualifier.kt")
    public void testTopLevelObjectVsLocalClassQualifier() throws Exception {
        runTest("analysis/analysis-api/testData/referenceResolve/TopLevelObjectVsLocalClassQualifier.kt");
    }

    @Test
    @TestMetadata("TypeAlias.kt")
    public void testTypeAlias() throws Exception {
        runTest("analysis/analysis-api/testData/referenceResolve/TypeAlias.kt");
    }

    @Test
    @TestMetadata("TypeAliasAsSupertypeConstructor.kt")
    public void testTypeAliasAsSupertypeConstructor() throws Exception {
        runTest("analysis/analysis-api/testData/referenceResolve/TypeAliasAsSupertypeConstructor.kt");
    }

    @Test
    @TestMetadata("TypeAliasRHS.kt")
    public void testTypeAliasRHS() throws Exception {
        runTest("analysis/analysis-api/testData/referenceResolve/TypeAliasRHS.kt");
    }

    @Test
    @TestMetadata("TypeArgumentBeforeDot.kt")
    public void testTypeArgumentBeforeDot() throws Exception {
        runTest("analysis/analysis-api/testData/referenceResolve/TypeArgumentBeforeDot.kt");
    }

    @Test
    @TestMetadata("ValueParameter.kt")
    public void testValueParameter() throws Exception {
        runTest("analysis/analysis-api/testData/referenceResolve/ValueParameter.kt");
    }

    @Nested
    @TestMetadata("analysis/analysis-api/testData/referenceResolve/arrayAccess")
    @TestDataPath("$PROJECT_ROOT")
    public class ArrayAccess {
        @Test
        public void testAllFilesPresentInArrayAccess() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/referenceResolve/arrayAccess"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
        }

        @Test
        @TestMetadata("get.kt")
        public void testGet() throws Exception {
            runTest("analysis/analysis-api/testData/referenceResolve/arrayAccess/get.kt");
        }

        @Test
        @TestMetadata("getOperator.kt")
        public void testGetOperator() throws Exception {
            runTest("analysis/analysis-api/testData/referenceResolve/arrayAccess/getOperator.kt");
        }

        @Test
        @TestMetadata("set.kt")
        public void testSet() throws Exception {
            runTest("analysis/analysis-api/testData/referenceResolve/arrayAccess/set.kt");
        }

        @Test
        @TestMetadata("setOperator.kt")
        public void testSetOperator() throws Exception {
            runTest("analysis/analysis-api/testData/referenceResolve/arrayAccess/setOperator.kt");
        }

        @Nested
        @TestMetadata("analysis/analysis-api/testData/referenceResolve/arrayAccess/withErrors")
        @TestDataPath("$PROJECT_ROOT")
        public class WithErrors {
            @Test
            public void testAllFilesPresentInWithErrors() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/referenceResolve/arrayAccess/withErrors"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
            }

            @Test
            @TestMetadata("getFunction.kt")
            public void testGetFunction() throws Exception {
                runTest("analysis/analysis-api/testData/referenceResolve/arrayAccess/withErrors/getFunction.kt");
            }

            @Test
            @TestMetadata("setFunction.kt")
            public void testSetFunction() throws Exception {
                runTest("analysis/analysis-api/testData/referenceResolve/arrayAccess/withErrors/setFunction.kt");
            }
        }
    }

    @Nested
    @TestMetadata("analysis/analysis-api/testData/referenceResolve/constructorDelegatingReference")
    @TestDataPath("$PROJECT_ROOT")
    public class ConstructorDelegatingReference {
        @Test
        public void testAllFilesPresentInConstructorDelegatingReference() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/referenceResolve/constructorDelegatingReference"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
        }

        @Test
        @TestMetadata("toPrimary.kt")
        public void testToPrimary() throws Exception {
            runTest("analysis/analysis-api/testData/referenceResolve/constructorDelegatingReference/toPrimary.kt");
        }

        @Test
        @TestMetadata("toSecondary.kt")
        public void testToSecondary() throws Exception {
            runTest("analysis/analysis-api/testData/referenceResolve/constructorDelegatingReference/toSecondary.kt");
        }
    }

    @Nested
    @TestMetadata("analysis/analysis-api/testData/referenceResolve/delegatedPropertyAccessors")
    @TestDataPath("$PROJECT_ROOT")
    public class DelegatedPropertyAccessors {
        @Test
        public void testAllFilesPresentInDelegatedPropertyAccessors() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/referenceResolve/delegatedPropertyAccessors"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
        }

        @Nested
        @TestMetadata("analysis/analysis-api/testData/referenceResolve/delegatedPropertyAccessors/inSource")
        @TestDataPath("$PROJECT_ROOT")
        public class InSource {
            @Test
            public void testAllFilesPresentInInSource() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/referenceResolve/delegatedPropertyAccessors/inSource"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
            }

            @Test
            @TestMetadata("getExtension.kt")
            public void testGetExtension() throws Exception {
                runTest("analysis/analysis-api/testData/referenceResolve/delegatedPropertyAccessors/inSource/getExtension.kt");
            }

            @Test
            @TestMetadata("getMember.kt")
            public void testGetMember() throws Exception {
                runTest("analysis/analysis-api/testData/referenceResolve/delegatedPropertyAccessors/inSource/getMember.kt");
            }

            @Test
            @TestMetadata("getMultipleDeclarations.kt")
            public void testGetMultipleDeclarations() throws Exception {
                runTest("analysis/analysis-api/testData/referenceResolve/delegatedPropertyAccessors/inSource/getMultipleDeclarations.kt");
            }

            @Test
            @TestMetadata("getOneFakeOverride.kt")
            public void testGetOneFakeOverride() throws Exception {
                runTest("analysis/analysis-api/testData/referenceResolve/delegatedPropertyAccessors/inSource/getOneFakeOverride.kt");
            }
        }

        @Nested
        @TestMetadata("analysis/analysis-api/testData/referenceResolve/delegatedPropertyAccessors/inStandardLibrary")
        @TestDataPath("$PROJECT_ROOT")
        public class InStandardLibrary {
            @Test
            public void testAllFilesPresentInInStandardLibrary() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/referenceResolve/delegatedPropertyAccessors/inStandardLibrary"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
            }

            @Test
            @TestMetadata("lazy.kt")
            public void testLazy() throws Exception {
                runTest("analysis/analysis-api/testData/referenceResolve/delegatedPropertyAccessors/inStandardLibrary/lazy.kt");
            }

            @Test
            @TestMetadata("notNull.kt")
            public void testNotNull() throws Exception {
                runTest("analysis/analysis-api/testData/referenceResolve/delegatedPropertyAccessors/inStandardLibrary/notNull.kt");
            }
        }

        @Nested
        @TestMetadata("analysis/analysis-api/testData/referenceResolve/delegatedPropertyAccessors/withErrors")
        @TestDataPath("$PROJECT_ROOT")
        public class WithErrors {
            @Test
            public void testAllFilesPresentInWithErrors() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/referenceResolve/delegatedPropertyAccessors/withErrors"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
            }

            @Test
            @TestMetadata("unresolved.kt")
            public void testUnresolved() throws Exception {
                runTest("analysis/analysis-api/testData/referenceResolve/delegatedPropertyAccessors/withErrors/unresolved.kt");
            }
        }
    }

    @Nested
    @TestMetadata("analysis/analysis-api/testData/referenceResolve/forLoopIn")
    @TestDataPath("$PROJECT_ROOT")
    public class ForLoopIn {
        @Test
        public void testAllFilesPresentInForLoopIn() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/referenceResolve/forLoopIn"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
        }

        @Nested
        @TestMetadata("analysis/analysis-api/testData/referenceResolve/forLoopIn/inBuiltIns")
        @TestDataPath("$PROJECT_ROOT")
        public class InBuiltIns {
            @Test
            public void testAllFilesPresentInInBuiltIns() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/referenceResolve/forLoopIn/inBuiltIns"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
            }

            @Test
            @TestMetadata("extension.kt")
            public void testExtension() throws Exception {
                runTest("analysis/analysis-api/testData/referenceResolve/forLoopIn/inBuiltIns/extension.kt");
            }

            @Test
            @TestMetadata("member.kt")
            public void testMember() throws Exception {
                runTest("analysis/analysis-api/testData/referenceResolve/forLoopIn/inBuiltIns/member.kt");
            }
        }

        @Nested
        @TestMetadata("analysis/analysis-api/testData/referenceResolve/forLoopIn/inLibrary")
        @TestDataPath("$PROJECT_ROOT")
        public class InLibrary {
            @Test
            public void testAllFilesPresentInInLibrary() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/referenceResolve/forLoopIn/inLibrary"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
            }

            @Test
            @TestMetadata("extension.kt")
            public void testExtension() throws Exception {
                runTest("analysis/analysis-api/testData/referenceResolve/forLoopIn/inLibrary/extension.kt");
            }
        }

        @Nested
        @TestMetadata("analysis/analysis-api/testData/referenceResolve/forLoopIn/inSource")
        @TestDataPath("$PROJECT_ROOT")
        public class InSource {
            @Test
            @TestMetadata("allExtensions.kt")
            public void testAllExtensions() throws Exception {
                runTest("analysis/analysis-api/testData/referenceResolve/forLoopIn/inSource/allExtensions.kt");
            }

            @Test
            public void testAllFilesPresentInInSource() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/referenceResolve/forLoopIn/inSource"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
            }

            @Test
            @TestMetadata("allMembers.kt")
            public void testAllMembers() throws Exception {
                runTest("analysis/analysis-api/testData/referenceResolve/forLoopIn/inSource/allMembers.kt");
            }

            @Nested
            @TestMetadata("analysis/analysis-api/testData/referenceResolve/forLoopIn/inSource/withErrors")
            @TestDataPath("$PROJECT_ROOT")
            public class WithErrors {
                @Test
                public void testAllFilesPresentInWithErrors() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/referenceResolve/forLoopIn/inSource/withErrors"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
                }

                @Test
                @TestMetadata("nextMissing.kt")
                public void testNextMissing() throws Exception {
                    runTest("analysis/analysis-api/testData/referenceResolve/forLoopIn/inSource/withErrors/nextMissing.kt");
                }
            }
        }

        @Nested
        @TestMetadata("analysis/analysis-api/testData/referenceResolve/forLoopIn/withErrors")
        @TestDataPath("$PROJECT_ROOT")
        public class WithErrors {
            @Test
            public void testAllFilesPresentInWithErrors() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/referenceResolve/forLoopIn/withErrors"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
            }

            @Test
            @TestMetadata("unresolvedIterator.kt")
            public void testUnresolvedIterator() throws Exception {
                runTest("analysis/analysis-api/testData/referenceResolve/forLoopIn/withErrors/unresolvedIterator.kt");
            }
        }
    }

    @Nested
    @TestMetadata("analysis/analysis-api/testData/referenceResolve/inImport")
    @TestDataPath("$PROJECT_ROOT")
    public class InImport {
        @Test
        public void testAllFilesPresentInInImport() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/referenceResolve/inImport"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
        }

        @Test
        @TestMetadata("javaClass.kt")
        public void testJavaClass() throws Exception {
            runTest("analysis/analysis-api/testData/referenceResolve/inImport/javaClass.kt");
        }

        @Test
        @TestMetadata("javaPackageFirstQualifier.kt")
        public void testJavaPackageFirstQualifier() throws Exception {
            runTest("analysis/analysis-api/testData/referenceResolve/inImport/javaPackageFirstQualifier.kt");
        }

        @Test
        @TestMetadata("javaPackageSecondQualifier.kt")
        public void testJavaPackageSecondQualifier() throws Exception {
            runTest("analysis/analysis-api/testData/referenceResolve/inImport/javaPackageSecondQualifier.kt");
        }

        @Test
        @TestMetadata("kotlinClass.kt")
        public void testKotlinClass() throws Exception {
            runTest("analysis/analysis-api/testData/referenceResolve/inImport/kotlinClass.kt");
        }

        @Test
        @TestMetadata("kotlinPackageFirstQualifier.kt")
        public void testKotlinPackageFirstQualifier() throws Exception {
            runTest("analysis/analysis-api/testData/referenceResolve/inImport/kotlinPackageFirstQualifier.kt");
        }

        @Test
        @TestMetadata("kotlinPackageSecondQualifier.kt")
        public void testKotlinPackageSecondQualifier() throws Exception {
            runTest("analysis/analysis-api/testData/referenceResolve/inImport/kotlinPackageSecondQualifier.kt");
        }

        @Test
        @TestMetadata("kotlinTopLevelFunction.kt")
        public void testKotlinTopLevelFunction() throws Exception {
            runTest("analysis/analysis-api/testData/referenceResolve/inImport/kotlinTopLevelFunction.kt");
        }

        @Test
        @TestMetadata("staticMethodFromJavaClass.kt")
        public void testStaticMethodFromJavaClass() throws Exception {
            runTest("analysis/analysis-api/testData/referenceResolve/inImport/staticMethodFromJavaClass.kt");
        }

        @Test
        @TestMetadata("staticMethodFromJavaClassJavaClass.kt")
        public void testStaticMethodFromJavaClassJavaClass() throws Exception {
            runTest("analysis/analysis-api/testData/referenceResolve/inImport/staticMethodFromJavaClassJavaClass.kt");
        }
    }

    @Nested
    @TestMetadata("analysis/analysis-api/testData/referenceResolve/invoke")
    @TestDataPath("$PROJECT_ROOT")
    public class Invoke {
        @Test
        public void testAllFilesPresentInInvoke() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/referenceResolve/invoke"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
        }

        @Test
        @TestMetadata("lambdaAndParens.kt")
        public void testLambdaAndParens() throws Exception {
            runTest("analysis/analysis-api/testData/referenceResolve/invoke/lambdaAndParens.kt");
        }

        @Test
        @TestMetadata("lambdaNoPar.kt")
        public void testLambdaNoPar() throws Exception {
            runTest("analysis/analysis-api/testData/referenceResolve/invoke/lambdaNoPar.kt");
        }

        @Test
        @TestMetadata("lambdaNoParLabel.kt")
        public void testLambdaNoParLabel() throws Exception {
            runTest("analysis/analysis-api/testData/referenceResolve/invoke/lambdaNoParLabel.kt");
        }

        @Test
        @TestMetadata("lambdaNoParRCurly.kt")
        public void testLambdaNoParRCurly() throws Exception {
            runTest("analysis/analysis-api/testData/referenceResolve/invoke/lambdaNoParRCurly.kt");
        }

        @Test
        @TestMetadata("noParams.kt")
        public void testNoParams() throws Exception {
            runTest("analysis/analysis-api/testData/referenceResolve/invoke/noParams.kt");
        }

        @Test
        @TestMetadata("noParamsRPar.kt")
        public void testNoParamsRPar() throws Exception {
            runTest("analysis/analysis-api/testData/referenceResolve/invoke/noParamsRPar.kt");
        }

        @Test
        @TestMetadata("nonemptyLambdaRPar.kt")
        public void testNonemptyLambdaRPar() throws Exception {
            runTest("analysis/analysis-api/testData/referenceResolve/invoke/nonemptyLambdaRPar.kt");
        }

        @Test
        @TestMetadata("oneParam.kt")
        public void testOneParam() throws Exception {
            runTest("analysis/analysis-api/testData/referenceResolve/invoke/oneParam.kt");
        }

        @Test
        @TestMetadata("oneParamRPar.kt")
        public void testOneParamRPar() throws Exception {
            runTest("analysis/analysis-api/testData/referenceResolve/invoke/oneParamRPar.kt");
        }

        @Nested
        @TestMetadata("analysis/analysis-api/testData/referenceResolve/invoke/withErrors")
        @TestDataPath("$PROJECT_ROOT")
        public class WithErrors {
            @Test
            public void testAllFilesPresentInWithErrors() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/referenceResolve/invoke/withErrors"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
            }

            @Test
            @TestMetadata("lambdaAndParensIncorrectVararg.kt")
            public void testLambdaAndParensIncorrectVararg() throws Exception {
                runTest("analysis/analysis-api/testData/referenceResolve/invoke/withErrors/lambdaAndParensIncorrectVararg.kt");
            }

            @Test
            @TestMetadata("lambdaNoParIncorrectVararg.kt")
            public void testLambdaNoParIncorrectVararg() throws Exception {
                runTest("analysis/analysis-api/testData/referenceResolve/invoke/withErrors/lambdaNoParIncorrectVararg.kt");
            }

            @Test
            @TestMetadata("lambdaNoParLabelIncorrectVararg.kt")
            public void testLambdaNoParLabelIncorrectVararg() throws Exception {
                runTest("analysis/analysis-api/testData/referenceResolve/invoke/withErrors/lambdaNoParLabelIncorrectVararg.kt");
            }

            @Test
            @TestMetadata("lambdaNoParRCurlyIncorrectVararg.kt")
            public void testLambdaNoParRCurlyIncorrectVararg() throws Exception {
                runTest("analysis/analysis-api/testData/referenceResolve/invoke/withErrors/lambdaNoParRCurlyIncorrectVararg.kt");
            }

            @Test
            @TestMetadata("nonemptyLambdaRParIncorrectVararg.kt")
            public void testNonemptyLambdaRParIncorrectVararg() throws Exception {
                runTest("analysis/analysis-api/testData/referenceResolve/invoke/withErrors/nonemptyLambdaRParIncorrectVararg.kt");
            }
        }
    }

    @Nested
    @TestMetadata("analysis/analysis-api/testData/referenceResolve/nestedTypes")
    @TestDataPath("$PROJECT_ROOT")
    public class NestedTypes {
        @Test
        public void testAllFilesPresentInNestedTypes() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/referenceResolve/nestedTypes"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
        }

        @Test
        @TestMetadata("ResolveCompanionInCompanionType.kt")
        public void testResolveCompanionInCompanionType() throws Exception {
            runTest("analysis/analysis-api/testData/referenceResolve/nestedTypes/ResolveCompanionInCompanionType.kt");
        }

        @Test
        @TestMetadata("ResolveEndOfPackageInType.kt")
        public void testResolveEndOfPackageInType() throws Exception {
            runTest("analysis/analysis-api/testData/referenceResolve/nestedTypes/ResolveEndOfPackageInType.kt");
        }

        @Test
        @TestMetadata("ResolveMiddleOfPackageInType.kt")
        public void testResolveMiddleOfPackageInType() throws Exception {
            runTest("analysis/analysis-api/testData/referenceResolve/nestedTypes/ResolveMiddleOfPackageInType.kt");
        }

        @Test
        @TestMetadata("ResolveNamedCompanionInCompanionType.kt")
        public void testResolveNamedCompanionInCompanionType() throws Exception {
            runTest("analysis/analysis-api/testData/referenceResolve/nestedTypes/ResolveNamedCompanionInCompanionType.kt");
        }

        @Test
        @TestMetadata("ResolveStartOfPackageInType.kt")
        public void testResolveStartOfPackageInType() throws Exception {
            runTest("analysis/analysis-api/testData/referenceResolve/nestedTypes/ResolveStartOfPackageInType.kt");
        }

        @Test
        @TestMetadata("ResolveTypeInTheEndOfType.kt")
        public void testResolveTypeInTheEndOfType() throws Exception {
            runTest("analysis/analysis-api/testData/referenceResolve/nestedTypes/ResolveTypeInTheEndOfType.kt");
        }

        @Test
        @TestMetadata("ResolveTypeInTheMiddleOfCompanionType.kt")
        public void testResolveTypeInTheMiddleOfCompanionType() throws Exception {
            runTest("analysis/analysis-api/testData/referenceResolve/nestedTypes/ResolveTypeInTheMiddleOfCompanionType.kt");
        }

        @Test
        @TestMetadata("ResolveTypeInTheMiddleOfFunctionalType.kt")
        public void testResolveTypeInTheMiddleOfFunctionalType() throws Exception {
            runTest("analysis/analysis-api/testData/referenceResolve/nestedTypes/ResolveTypeInTheMiddleOfFunctionalType.kt");
        }

        @Test
        @TestMetadata("ResolveTypeInTheMiddleOfNullableType.kt")
        public void testResolveTypeInTheMiddleOfNullableType() throws Exception {
            runTest("analysis/analysis-api/testData/referenceResolve/nestedTypes/ResolveTypeInTheMiddleOfNullableType.kt");
        }

        @Test
        @TestMetadata("ResolveTypeInTheMiddleOfType.kt")
        public void testResolveTypeInTheMiddleOfType() throws Exception {
            runTest("analysis/analysis-api/testData/referenceResolve/nestedTypes/ResolveTypeInTheMiddleOfType.kt");
        }

        @Test
        @TestMetadata("ResolveTypeInTheStartOfCompanionType.kt")
        public void testResolveTypeInTheStartOfCompanionType() throws Exception {
            runTest("analysis/analysis-api/testData/referenceResolve/nestedTypes/ResolveTypeInTheStartOfCompanionType.kt");
        }

        @Test
        @TestMetadata("ResolveTypeInTheStartOfType.kt")
        public void testResolveTypeInTheStartOfType() throws Exception {
            runTest("analysis/analysis-api/testData/referenceResolve/nestedTypes/ResolveTypeInTheStartOfType.kt");
        }
    }

    @Nested
    @TestMetadata("analysis/analysis-api/testData/referenceResolve/packageReference")
    @TestDataPath("$PROJECT_ROOT")
    public class PackageReference {
        @Test
        public void testAllFilesPresentInPackageReference() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/referenceResolve/packageReference"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
        }

        @Test
        @TestMetadata("javaPackageFirstQualifier.kt")
        public void testJavaPackageFirstQualifier() throws Exception {
            runTest("analysis/analysis-api/testData/referenceResolve/packageReference/javaPackageFirstQualifier.kt");
        }

        @Test
        @TestMetadata("javaPackageSecondQualifier.kt")
        public void testJavaPackageSecondQualifier() throws Exception {
            runTest("analysis/analysis-api/testData/referenceResolve/packageReference/javaPackageSecondQualifier.kt");
        }

        @Test
        @TestMetadata("kotlinPackageFirstQualifier.kt")
        public void testKotlinPackageFirstQualifier() throws Exception {
            runTest("analysis/analysis-api/testData/referenceResolve/packageReference/kotlinPackageFirstQualifier.kt");
        }

        @Test
        @TestMetadata("kotlinPackageSecondQualifier.kt")
        public void testKotlinPackageSecondQualifier() throws Exception {
            runTest("analysis/analysis-api/testData/referenceResolve/packageReference/kotlinPackageSecondQualifier.kt");
        }
    }

    @Nested
    @TestMetadata("analysis/analysis-api/testData/referenceResolve/qualifiedAccess")
    @TestDataPath("$PROJECT_ROOT")
    public class QualifiedAccess {
        @Test
        public void testAllFilesPresentInQualifiedAccess() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/referenceResolve/qualifiedAccess"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
        }

        @Test
        @TestMetadata("callableReference1.kt")
        public void testCallableReference1() throws Exception {
            runTest("analysis/analysis-api/testData/referenceResolve/qualifiedAccess/callableReference1.kt");
        }

        @Test
        @TestMetadata("callableReference2.kt")
        public void testCallableReference2() throws Exception {
            runTest("analysis/analysis-api/testData/referenceResolve/qualifiedAccess/callableReference2.kt");
        }

        @Test
        @TestMetadata("callableReference3.kt")
        public void testCallableReference3() throws Exception {
            runTest("analysis/analysis-api/testData/referenceResolve/qualifiedAccess/callableReference3.kt");
        }

        @Test
        @TestMetadata("nullSafeCallExpression.kt")
        public void testNullSafeCallExpression() throws Exception {
            runTest("analysis/analysis-api/testData/referenceResolve/qualifiedAccess/nullSafeCallExpression.kt");
        }

        @Test
        @TestMetadata("ResolveFirstPackageOfFullyQualifiedReference.kt")
        public void testResolveFirstPackageOfFullyQualifiedReference() throws Exception {
            runTest("analysis/analysis-api/testData/referenceResolve/qualifiedAccess/ResolveFirstPackageOfFullyQualifiedReference.kt");
        }

        @Test
        @TestMetadata("ResolveFullyQualifiedCompanionObject.kt")
        public void testResolveFullyQualifiedCompanionObject() throws Exception {
            runTest("analysis/analysis-api/testData/referenceResolve/qualifiedAccess/ResolveFullyQualifiedCompanionObject.kt");
        }

        @Test
        @TestMetadata("ResolveOuterClassOfFullyQualifiedReference.kt")
        public void testResolveOuterClassOfFullyQualifiedReference() throws Exception {
            runTest("analysis/analysis-api/testData/referenceResolve/qualifiedAccess/ResolveOuterClassOfFullyQualifiedReference.kt");
        }

        @Test
        @TestMetadata("ResolvePackageOfFullyQualifiedReference.kt")
        public void testResolvePackageOfFullyQualifiedReference() throws Exception {
            runTest("analysis/analysis-api/testData/referenceResolve/qualifiedAccess/ResolvePackageOfFullyQualifiedReference.kt");
        }
    }

    @Nested
    @TestMetadata("analysis/analysis-api/testData/referenceResolve/typeParameter")
    @TestDataPath("$PROJECT_ROOT")
    public class TypeParameter {
        @Test
        public void testAllFilesPresentInTypeParameter() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/referenceResolve/typeParameter"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
        }

        @Test
        @TestMetadata("multipleBounds.kt")
        public void testMultipleBounds() throws Exception {
            runTest("analysis/analysis-api/testData/referenceResolve/typeParameter/multipleBounds.kt");
        }

        @Test
        @TestMetadata("reified_argumentInFunctionalType.kt")
        public void testReified_argumentInFunctionalType() throws Exception {
            runTest("analysis/analysis-api/testData/referenceResolve/typeParameter/reified_argumentInFunctionalType.kt");
        }

        @Test
        @TestMetadata("reified_extensionReceiver.kt")
        public void testReified_extensionReceiver() throws Exception {
            runTest("analysis/analysis-api/testData/referenceResolve/typeParameter/reified_extensionReceiver.kt");
        }

        @Test
        @TestMetadata("reified_returnType.kt")
        public void testReified_returnType() throws Exception {
            runTest("analysis/analysis-api/testData/referenceResolve/typeParameter/reified_returnType.kt");
        }

        @Test
        @TestMetadata("reified_valueParameter.kt")
        public void testReified_valueParameter() throws Exception {
            runTest("analysis/analysis-api/testData/referenceResolve/typeParameter/reified_valueParameter.kt");
        }

        @Test
        @TestMetadata("reified_valueParameter_vararg.kt")
        public void testReified_valueParameter_vararg() throws Exception {
            runTest("analysis/analysis-api/testData/referenceResolve/typeParameter/reified_valueParameter_vararg.kt");
        }

        @Test
        @TestMetadata("TypeParameterInAnonymousObject.kt")
        public void testTypeParameterInAnonymousObject() throws Exception {
            runTest("analysis/analysis-api/testData/referenceResolve/typeParameter/TypeParameterInAnonymousObject.kt");
        }

        @Test
        @TestMetadata("TypeParameterInFunctionLiteral.kt")
        public void testTypeParameterInFunctionLiteral() throws Exception {
            runTest("analysis/analysis-api/testData/referenceResolve/typeParameter/TypeParameterInFunctionLiteral.kt");
        }
    }

    @Nested
    @TestMetadata("analysis/analysis-api/testData/referenceResolve/withErrors")
    @TestDataPath("$PROJECT_ROOT")
    public class WithErrors {
        @Test
        public void testAllFilesPresentInWithErrors() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/referenceResolve/withErrors"), Pattern.compile("^([^.]+)\\.kt$"), null, true);
        }

        @Test
        @TestMetadata("AnnotationParameter.kt")
        public void testAnnotationParameter() throws Exception {
            runTest("analysis/analysis-api/testData/referenceResolve/withErrors/AnnotationParameter.kt");
        }

        @Test
        @TestMetadata("ClassNameBeforeDot.kt")
        public void testClassNameBeforeDot() throws Exception {
            runTest("analysis/analysis-api/testData/referenceResolve/withErrors/ClassNameBeforeDot.kt");
        }

        @Test
        @TestMetadata("CollectionLiteralLeft.kt")
        public void testCollectionLiteralLeft() throws Exception {
            runTest("analysis/analysis-api/testData/referenceResolve/withErrors/CollectionLiteralLeft.kt");
        }

        @Test
        @TestMetadata("CollectionLiteralRight.kt")
        public void testCollectionLiteralRight() throws Exception {
            runTest("analysis/analysis-api/testData/referenceResolve/withErrors/CollectionLiteralRight.kt");
        }

        @Test
        @TestMetadata("CoroutineSuspensionPoint.kt")
        public void testCoroutineSuspensionPoint() throws Exception {
            runTest("analysis/analysis-api/testData/referenceResolve/withErrors/CoroutineSuspensionPoint.kt");
        }

        @Test
        @TestMetadata("DeprecatedHidden.kt")
        public void testDeprecatedHidden() throws Exception {
            runTest("analysis/analysis-api/testData/referenceResolve/withErrors/DeprecatedHidden.kt");
        }

        @Test
        @TestMetadata("FakeJavaLang1.kt")
        public void testFakeJavaLang1() throws Exception {
            runTest("analysis/analysis-api/testData/referenceResolve/withErrors/FakeJavaLang1.kt");
        }

        @Test
        @TestMetadata("FakeJavaLang2.kt")
        public void testFakeJavaLang2() throws Exception {
            runTest("analysis/analysis-api/testData/referenceResolve/withErrors/FakeJavaLang2.kt");
        }

        @Test
        @TestMetadata("FakeJavaLang3.kt")
        public void testFakeJavaLang3() throws Exception {
            runTest("analysis/analysis-api/testData/referenceResolve/withErrors/FakeJavaLang3.kt");
        }

        @Test
        @TestMetadata("FakeJavaLang4.kt")
        public void testFakeJavaLang4() throws Exception {
            runTest("analysis/analysis-api/testData/referenceResolve/withErrors/FakeJavaLang4.kt");
        }

        @Test
        @TestMetadata("InObjectClassObject.kt")
        public void testInObjectClassObject() throws Exception {
            runTest("analysis/analysis-api/testData/referenceResolve/withErrors/InObjectClassObject.kt");
        }

        @Test
        @TestMetadata("InSecondClassObject.kt")
        public void testInSecondClassObject() throws Exception {
            runTest("analysis/analysis-api/testData/referenceResolve/withErrors/InSecondClassObject.kt");
        }

        @Test
        @TestMetadata("InvisibleMember.kt")
        public void testInvisibleMember() throws Exception {
            runTest("analysis/analysis-api/testData/referenceResolve/withErrors/InvisibleMember.kt");
        }

        @Test
        @TestMetadata("NoSelectorInDotQualifiedCall.kt")
        public void testNoSelectorInDotQualifiedCall() throws Exception {
            runTest("analysis/analysis-api/testData/referenceResolve/withErrors/NoSelectorInDotQualifiedCall.kt");
        }

        @Test
        @TestMetadata("NoSelectorInDotQualifiedCall_ResolveInsideLambda.kt")
        public void testNoSelectorInDotQualifiedCall_ResolveInsideLambda() throws Exception {
            runTest("analysis/analysis-api/testData/referenceResolve/withErrors/NoSelectorInDotQualifiedCall_ResolveInsideLambda.kt");
        }

        @Test
        @TestMetadata("NoSelectorInSafeQualifiedCall.kt")
        public void testNoSelectorInSafeQualifiedCall() throws Exception {
            runTest("analysis/analysis-api/testData/referenceResolve/withErrors/NoSelectorInSafeQualifiedCall.kt");
        }

        @Test
        @TestMetadata("PropertyPlaceInClassObjectInObject.kt")
        public void testPropertyPlaceInClassObjectInObject() throws Exception {
            runTest("analysis/analysis-api/testData/referenceResolve/withErrors/PropertyPlaceInClassObjectInObject.kt");
        }

        @Test
        @TestMetadata("ResolveClassNameInCallExpression.kt")
        public void testResolveClassNameInCallExpression() throws Exception {
            runTest("analysis/analysis-api/testData/referenceResolve/withErrors/ResolveClassNameInCallExpression.kt");
        }

        @Test
        @TestMetadata("TopLevelClassVsLocalClassQualifier.kt")
        public void testTopLevelClassVsLocalClassQualifier() throws Exception {
            runTest("analysis/analysis-api/testData/referenceResolve/withErrors/TopLevelClassVsLocalClassQualifier.kt");
        }

        @Test
        @TestMetadata("TypeArgumentBeforeDot2.kt")
        public void testTypeArgumentBeforeDot2() throws Exception {
            runTest("analysis/analysis-api/testData/referenceResolve/withErrors/TypeArgumentBeforeDot2.kt");
        }

        @Test
        @TestMetadata("TypeArgumentUnresolvedClass.kt")
        public void testTypeArgumentUnresolvedClass() throws Exception {
            runTest("analysis/analysis-api/testData/referenceResolve/withErrors/TypeArgumentUnresolvedClass.kt");
        }

        @Test
        @TestMetadata("TypeArgumentUnresolvedConstructor.kt")
        public void testTypeArgumentUnresolvedConstructor() throws Exception {
            runTest("analysis/analysis-api/testData/referenceResolve/withErrors/TypeArgumentUnresolvedConstructor.kt");
        }

        @Test
        @TestMetadata("TypeArgumentWrongNumber.kt")
        public void testTypeArgumentWrongNumber() throws Exception {
            runTest("analysis/analysis-api/testData/referenceResolve/withErrors/TypeArgumentWrongNumber.kt");
        }

        @Test
        @TestMetadata("WrongNumberOfTypeArguments.kt")
        public void testWrongNumberOfTypeArguments() throws Exception {
            runTest("analysis/analysis-api/testData/referenceResolve/withErrors/WrongNumberOfTypeArguments.kt");
        }

        @Test
        @TestMetadata("WrongNumberOfTypeArguments2.kt")
        public void testWrongNumberOfTypeArguments2() throws Exception {
            runTest("analysis/analysis-api/testData/referenceResolve/withErrors/WrongNumberOfTypeArguments2.kt");
        }

        @Test
        @TestMetadata("WrongNumberOfTypeArguments3.kt")
        public void testWrongNumberOfTypeArguments3() throws Exception {
            runTest("analysis/analysis-api/testData/referenceResolve/withErrors/WrongNumberOfTypeArguments3.kt");
        }

        @Test
        @TestMetadata("WrongNumberOfTypeArguments4.kt")
        public void testWrongNumberOfTypeArguments4() throws Exception {
            runTest("analysis/analysis-api/testData/referenceResolve/withErrors/WrongNumberOfTypeArguments4.kt");
        }

        @Test
        @TestMetadata("WrongNumberOfTypeArgumentsInSupertype.kt")
        public void testWrongNumberOfTypeArgumentsInSupertype() throws Exception {
            runTest("analysis/analysis-api/testData/referenceResolve/withErrors/WrongNumberOfTypeArgumentsInSupertype.kt");
        }
    }
}
