/*
 * Copyright 2010-2021 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.analysis.api.fir.test.cases.generated.cases.scopes;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.fir.test.configurators.AnalysisApiFirTestConfiguratorFactory;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.AnalysisApiTestConfiguratorFactoryData;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.AnalysisApiTestConfigurator;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.TestModuleKind;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.FrontendKind;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.AnalysisSessionMode;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.AnalysisApiMode;
import org.jetbrains.kotlin.analysis.api.impl.base.test.cases.scopes.AbstractMemberScopeByFqNameTest;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link GenerateNewCompilerTests.kt}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("analysis/analysis-api/testData/scopes/memberScopeByFqName")
@TestDataPath("$PROJECT_ROOT")
public class FirIdeNormalAnalysisSourceModuleMemberScopeByFqNameTestGenerated extends AbstractMemberScopeByFqNameTest {
    @NotNull
    @Override
    public AnalysisApiTestConfigurator getConfigurator() {
        return AnalysisApiFirTestConfiguratorFactory.INSTANCE.createConfigurator(
            new AnalysisApiTestConfiguratorFactoryData(
                FrontendKind.Fir,
                TestModuleKind.Source,
                AnalysisSessionMode.Normal,
                AnalysisApiMode.Ide
            )
        );
    }

    @Test
    public void testAllFilesPresentInMemberScopeByFqName() throws Exception {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/scopes/memberScopeByFqName"), Pattern.compile("^(.+)\\.kt$"), null, true);
    }

    @Test
    @TestMetadata("Int.kt")
    public void testInt() throws Exception {
        runTest("analysis/analysis-api/testData/scopes/memberScopeByFqName/Int.kt");
    }

    @Test
    @TestMetadata("java.lang.String.kt")
    public void testJava_lang_String() throws Exception {
        runTest("analysis/analysis-api/testData/scopes/memberScopeByFqName/java.lang.String.kt");
    }

    @Test
    @TestMetadata("kotlin.Function2.kt")
    public void testKotlin_Function2() throws Exception {
        runTest("analysis/analysis-api/testData/scopes/memberScopeByFqName/kotlin.Function2.kt");
    }

    @Test
    @TestMetadata("MutableList.kt")
    public void testMutableList() throws Exception {
        runTest("analysis/analysis-api/testData/scopes/memberScopeByFqName/MutableList.kt");
    }

    @Nested
    @TestMetadata("analysis/analysis-api/testData/scopes/memberScopeByFqName/withTestCompilerPluginEnabled")
    @TestDataPath("$PROJECT_ROOT")
    public class WithTestCompilerPluginEnabled {
        @Test
        public void testAllFilesPresentInWithTestCompilerPluginEnabled() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("analysis/analysis-api/testData/scopes/memberScopeByFqName/withTestCompilerPluginEnabled"), Pattern.compile("^(.+)\\.kt$"), null, true);
        }

        @Test
        @TestMetadata("customSerlializable.kt")
        public void testCustomSerlializable() throws Exception {
            runTest("analysis/analysis-api/testData/scopes/memberScopeByFqName/withTestCompilerPluginEnabled/customSerlializable.kt");
        }

        @Test
        @TestMetadata("generatedCompanionWithFoo.kt")
        public void testGeneratedCompanionWithFoo() throws Exception {
            runTest("analysis/analysis-api/testData/scopes/memberScopeByFqName/withTestCompilerPluginEnabled/generatedCompanionWithFoo.kt");
        }

        @Test
        @TestMetadata("nestedClassAndMaterializeMember.kt")
        public void testNestedClassAndMaterializeMember() throws Exception {
            runTest("analysis/analysis-api/testData/scopes/memberScopeByFqName/withTestCompilerPluginEnabled/nestedClassAndMaterializeMember.kt");
        }
    }
}
