/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import sun.misc.VM;

public final class Integer
extends Number
implements Comparable<Integer> {
    public static final int MIN_VALUE = -2147483648;
    public static final int MAX_VALUE = 0x7FFFFFFF;
    public static final Class<Integer> TYPE = Class.getPrimitiveClass("int");
    static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    static final char[] DigitTens = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9'};
    static final char[] DigitOnes = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    static final int[] sizeTable = new int[]{9, 99, 999, 9999, 99999, 999999, 9999999, 99999999, 999999999, Integer.MAX_VALUE};
    private final int value;
    public static final int SIZE = 32;
    private static final long serialVersionUID = 1360826667806852920L;

    public static String toString(int n, int n2) {
        if (n2 < 2 || n2 > 36) {
            n2 = 10;
        }
        if (n2 == 10) {
            return Integer.toString(n);
        }
        char[] cArray = new char[33];
        boolean bl = n < 0;
        int n3 = 32;
        if (!bl) {
            n = -n;
        }
        while (n <= -n2) {
            cArray[n3--] = digits[-(n % n2)];
            n /= n2;
        }
        cArray[n3] = digits[-n];
        if (bl) {
            cArray[--n3] = 45;
        }
        return new String(cArray, n3, 33 - n3);
    }

    public static String toHexString(int n) {
        return Integer.toUnsignedString(n, 4);
    }

    public static String toOctalString(int n) {
        return Integer.toUnsignedString(n, 3);
    }

    public static String toBinaryString(int n) {
        return Integer.toUnsignedString(n, 1);
    }

    private static String toUnsignedString(int n, int n2) {
        char[] cArray = new char[32];
        int n3 = 32;
        int n4 = 1 << n2;
        int n5 = n4 - 1;
        do {
            cArray[--n3] = digits[n & n5];
        } while ((n >>>= n2) != 0);
        return new String(cArray, n3, 32 - n3);
    }

    public static String toString(int n) {
        if (n == Integer.MIN_VALUE) {
            return "-2147483648";
        }
        int n2 = n < 0 ? Integer.stringSize(-n) + 1 : Integer.stringSize(n);
        char[] cArray = new char[n2];
        Integer.getChars(n, n2, cArray);
        return new String(cArray, true);
    }

    static void getChars(int n, int n2, char[] cArray) {
        int n3;
        int n4;
        int n5 = n2;
        int n6 = 0;
        if (n < 0) {
            n6 = 45;
            n = -n;
        }
        while (n >= 65536) {
            n4 = n / 100;
            n3 = n - ((n4 << 6) + (n4 << 5) + (n4 << 2));
            n = n4;
            cArray[--n5] = DigitOnes[n3];
            cArray[--n5] = DigitTens[n3];
        }
        do {
            n4 = n * 52429 >>> 19;
            n3 = n - ((n4 << 3) + (n4 << 1));
            cArray[--n5] = digits[n3];
        } while ((n = n4) != 0);
        if (n6 != 0) {
            cArray[--n5] = n6;
        }
    }

    static int stringSize(int n) {
        int n2 = 0;
        while (n > sizeTable[n2]) {
            ++n2;
        }
        return n2 + 1;
    }

    public static int parseInt(String string, int n) throws NumberFormatException {
        if (string == null) {
            throw new NumberFormatException("null");
        }
        if (n < 2) {
            throw new NumberFormatException("radix " + n + " less than Character.MIN_RADIX");
        }
        if (n > 36) {
            throw new NumberFormatException("radix " + n + " greater than Character.MAX_RADIX");
        }
        int n2 = 0;
        boolean bl = false;
        int n3 = 0;
        int n4 = string.length();
        int n5 = -2147483647;
        if (n4 > 0) {
            char c = string.charAt(0);
            if (c < '0') {
                if (c == '-') {
                    bl = true;
                    n5 = Integer.MIN_VALUE;
                } else if (c != '+') {
                    throw NumberFormatException.forInputString(string);
                }
                if (n4 == 1) {
                    throw NumberFormatException.forInputString(string);
                }
                ++n3;
            }
            int n6 = n5 / n;
            while (n3 < n4) {
                int n7;
                if ((n7 = Character.digit(string.charAt(n3++), n)) < 0) {
                    throw NumberFormatException.forInputString(string);
                }
                if (n2 < n6) {
                    throw NumberFormatException.forInputString(string);
                }
                if ((n2 *= n) < n5 + n7) {
                    throw NumberFormatException.forInputString(string);
                }
                n2 -= n7;
            }
        } else {
            throw NumberFormatException.forInputString(string);
        }
        return bl ? n2 : -n2;
    }

    public static int parseInt(String string) throws NumberFormatException {
        return Integer.parseInt(string, 10);
    }

    public static Integer valueOf(String string, int n) throws NumberFormatException {
        return Integer.parseInt(string, n);
    }

    public static Integer valueOf(String string) throws NumberFormatException {
        return Integer.parseInt(string, 10);
    }

    public static Integer valueOf(int n) {
        assert (IntegerCache.high >= 127);
        if (n >= -128 && n <= IntegerCache.high) {
            return IntegerCache.cache[n + 128];
        }
        return new Integer(n);
    }

    public Integer(int n) {
        this.value = n;
    }

    public Integer(String string) throws NumberFormatException {
        this.value = Integer.parseInt(string, 10);
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public short shortValue() {
        return (short)this.value;
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public String toString() {
        return Integer.toString(this.value);
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object object) {
        if (object instanceof Integer) {
            return this.value == (Integer)object;
        }
        return false;
    }

    public static Integer getInteger(String string) {
        return Integer.getInteger(string, null);
    }

    public static Integer getInteger(String string, int n) {
        Integer n2 = Integer.getInteger(string, null);
        return n2 == null ? Integer.valueOf(n) : n2;
    }

    public static Integer getInteger(String string, Integer n) {
        String string2 = null;
        try {
            string2 = System.getProperty(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (string2 != null) {
            try {
                return Integer.decode(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n;
    }

    public static Integer decode(String string) throws NumberFormatException {
        Integer n;
        int n2 = 10;
        int n3 = 0;
        boolean bl = false;
        if (string.length() == 0) {
            throw new NumberFormatException("Zero length string");
        }
        char c = string.charAt(0);
        if (c == '-') {
            bl = true;
            ++n3;
        } else if (c == '+') {
            ++n3;
        }
        if (string.startsWith("0x", n3) || string.startsWith("0X", n3)) {
            n3 += 2;
            n2 = 16;
        } else if (string.startsWith("#", n3)) {
            ++n3;
            n2 = 16;
        } else if (string.startsWith("0", n3) && string.length() > 1 + n3) {
            ++n3;
            n2 = 8;
        }
        if (string.startsWith("-", n3) || string.startsWith("+", n3)) {
            throw new NumberFormatException("Sign character in wrong position");
        }
        try {
            n = Integer.valueOf(string.substring(n3), n2);
            n = bl ? Integer.valueOf(-n.intValue()) : n;
        }
        catch (NumberFormatException numberFormatException) {
            String string2 = bl ? "-" + string.substring(n3) : string.substring(n3);
            n = Integer.valueOf(string2, n2);
        }
        return n;
    }

    @Override
    public int compareTo(Integer n) {
        return Integer.compare(this.value, n.value);
    }

    public static int compare(int n, int n2) {
        return n < n2 ? -1 : (n == n2 ? 0 : 1);
    }

    public static int highestOneBit(int n) {
        n |= n >> 1;
        n |= n >> 2;
        n |= n >> 4;
        n |= n >> 8;
        n |= n >> 16;
        return n - (n >>> 1);
    }

    public static int lowestOneBit(int n) {
        return n & -n;
    }

    public static int numberOfLeadingZeros(int n) {
        if (n == 0) {
            return 32;
        }
        int n2 = 1;
        if (n >>> 16 == 0) {
            n2 += 16;
            n <<= 16;
        }
        if (n >>> 24 == 0) {
            n2 += 8;
            n <<= 8;
        }
        if (n >>> 28 == 0) {
            n2 += 4;
            n <<= 4;
        }
        if (n >>> 30 == 0) {
            n2 += 2;
            n <<= 2;
        }
        return n2 -= n >>> 31;
    }

    public static int numberOfTrailingZeros(int n) {
        if (n == 0) {
            return 32;
        }
        int n2 = 31;
        int n3 = n << 16;
        if (n3 != 0) {
            n2 -= 16;
            n = n3;
        }
        if ((n3 = n << 8) != 0) {
            n2 -= 8;
            n = n3;
        }
        if ((n3 = n << 4) != 0) {
            n2 -= 4;
            n = n3;
        }
        if ((n3 = n << 2) != 0) {
            n2 -= 2;
            n = n3;
        }
        return n2 - (n << 1 >>> 31);
    }

    public static int bitCount(int n) {
        n -= n >>> 1 & 0x55555555;
        n = (n & 0x33333333) + (n >>> 2 & 0x33333333);
        n = n + (n >>> 4) & 0xF0F0F0F;
        n += n >>> 8;
        n += n >>> 16;
        return n & 0x3F;
    }

    public static int rotateLeft(int n, int n2) {
        return n << n2 | n >>> -n2;
    }

    public static int rotateRight(int n, int n2) {
        return n >>> n2 | n << -n2;
    }

    public static int reverse(int n) {
        n = (n & 0x55555555) << 1 | n >>> 1 & 0x55555555;
        n = (n & 0x33333333) << 2 | n >>> 2 & 0x33333333;
        n = (n & 0xF0F0F0F) << 4 | n >>> 4 & 0xF0F0F0F;
        n = n << 24 | (n & 0xFF00) << 8 | n >>> 8 & 0xFF00 | n >>> 24;
        return n;
    }

    public static int signum(int n) {
        return n >> 31 | -n >>> 31;
    }

    public static int reverseBytes(int n) {
        return n >>> 24 | n >> 8 & 0xFF00 | n << 8 & 0xFF0000 | n << 24;
    }

    private static class IntegerCache {
        static final int low = -128;
        static final int high;
        static final Integer[] cache;

        private IntegerCache() {
        }

        static {
            int n;
            int n2 = 127;
            String string = VM.getSavedProperty((String)"java.lang.Integer.IntegerCache.high");
            if (string != null) {
                n = Integer.parseInt(string);
                n = Math.max(n, 127);
                n2 = Math.min(n, 0x7FFFFF7F);
            }
            high = n2;
            cache = new Integer[high - -128 + 1];
            n = -128;
            for (int i = 0; i < cache.length; ++i) {
                IntegerCache.cache[i] = new Integer(n++);
            }
        }
    }
}

