/*
 * Decompiled with CFR 0.152.
 */
package java.sql;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverInfo;
import java.sql.SQLException;
import java.sql.SQLPermission;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Vector;
import java.util.concurrent.CopyOnWriteArrayList;
import sun.reflect.CallerSensitive;
import sun.reflect.Reflection;

public class DriverManager {
    private static final CopyOnWriteArrayList<DriverInfo> registeredDrivers = new CopyOnWriteArrayList();
    private static volatile int loginTimeout = 0;
    private static volatile PrintWriter logWriter = null;
    private static volatile PrintStream logStream = null;
    private static final Object logSync = new Object();
    static final SQLPermission SET_LOG_PERMISSION;

    private DriverManager() {
    }

    public static PrintWriter getLogWriter() {
        return logWriter;
    }

    public static void setLogWriter(PrintWriter out) {
        SecurityManager sec = System.getSecurityManager();
        if (sec != null) {
            sec.checkPermission((Permission)((Object)SET_LOG_PERMISSION));
        }
        logStream = null;
        logWriter = out;
    }

    @CallerSensitive
    public static Connection getConnection(String var0, Properties var1) throws SQLException;

    @CallerSensitive
    public static Connection getConnection(String var0, String var1, String var2) throws SQLException;

    @CallerSensitive
    public static Connection getConnection(String var0) throws SQLException;

    @CallerSensitive
    public static Driver getDriver(String var0) throws SQLException;

    public static synchronized void registerDriver(Driver var0) throws SQLException;

    @CallerSensitive
    public static synchronized void deregisterDriver(Driver var0) throws SQLException;

    @CallerSensitive
    public static Enumeration<Driver> getDrivers() {
        Vector<Driver> result = new Vector<Driver>();
        Class callerClass = Reflection.getCallerClass();
        for (DriverInfo aDriver : registeredDrivers) {
            if (DriverManager.isDriverAllowed(aDriver.driver, callerClass)) {
                result.addElement(aDriver.driver);
                continue;
            }
            DriverManager.println("    skipping: " + aDriver.getClass().getName());
        }
        return result.elements();
    }

    public static void setLoginTimeout(int seconds) {
        loginTimeout = seconds;
    }

    public static int getLoginTimeout() {
        return loginTimeout;
    }

    public static void setLogStream(PrintStream out) {
        SecurityManager sec = System.getSecurityManager();
        if (sec != null) {
            sec.checkPermission((Permission)((Object)SET_LOG_PERMISSION));
        }
        logStream = out;
        logWriter = out != null ? new PrintWriter(out) : null;
    }

    public static PrintStream getLogStream() {
        return logStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void println(String message) {
        Object object = logSync;
        synchronized (object) {
            if (logWriter != null) {
                logWriter.println(message);
                logWriter.flush();
            }
        }
    }

    private static boolean isDriverAllowed(Driver driver, Class<?> caller) {
        ClassLoader callerCL = caller != null ? caller.getClassLoader() : null;
        return DriverManager.isDriverAllowed(driver, callerCL);
    }

    private static boolean isDriverAllowed(Driver driver, ClassLoader classLoader) {
        boolean result = false;
        if (driver != null) {
            Class<?> aClass = null;
            try {
                aClass = Class.forName(driver.getClass().getName(), true, classLoader);
            }
            catch (Exception ex) {
                result = false;
            }
            result = aClass == driver.getClass();
        }
        return result;
    }

    private static void loadInitialDrivers() {
        String drivers;
        try {
            drivers = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty("jdbc.drivers");
                }
            });
        }
        catch (Exception ex) {
            drivers = null;
        }
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                ServiceLoader<Driver> loadedDrivers = ServiceLoader.load(Driver.class);
                Iterator<Driver> driversIterator = loadedDrivers.iterator();
                try {
                    while (driversIterator.hasNext()) {
                        driversIterator.next();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return null;
            }
        });
        DriverManager.println("DriverManager.initialize: jdbc.drivers = " + drivers);
        if (drivers == null || drivers.equals("")) {
            return;
        }
        String[] driversList = drivers.split(":");
        DriverManager.println("number of Drivers:" + driversList.length);
        for (String aDriver : driversList) {
            try {
                DriverManager.println("DriverManager.Initialize: loading " + aDriver);
                Class.forName(aDriver, true, ClassLoader.getSystemClassLoader());
            }
            catch (Exception ex) {
                DriverManager.println("DriverManager.Initialize: load failed: " + ex);
            }
        }
    }

    private static Connection getConnection(String var0, Properties var1, Class<?> var2) throws SQLException;

    static {
        DriverManager.loadInitialDrivers();
        DriverManager.println("JDBC DriverManager initialized");
        SET_LOG_PERMISSION = new SQLPermission("setLog");
    }
}

