/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.security.AccessController;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.SecurityPermission;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import sun.security.jca.GetInstance;
import sun.security.jca.ProviderList;
import sun.security.jca.Providers;
import sun.security.util.Debug;
import sun.security.util.PropertyExpander;

public final class Security {
    private static final Debug sdebug = Debug.getInstance("properties");
    private static Properties props;
    private static final Map<String, Class> spiMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initialize() {
        props = new Properties();
        boolean loadedProps = false;
        boolean overrideAll = false;
        File propFile = Security.securityPropFile("java.security");
        if (propFile.exists()) {
            Object is = null;
            try {
                FileInputStream fis = new FileInputStream(propFile);
                is = new BufferedInputStream(fis);
                props.load((InputStream)is);
                loadedProps = true;
                if (sdebug != null) {
                    sdebug.println("reading security properties file: " + propFile);
                }
            }
            catch (IOException e) {
                if (sdebug != null) {
                    sdebug.println("unable to load security properties from " + propFile);
                    e.printStackTrace();
                }
            }
            finally {
                block38: {
                    if (is != null) {
                        try {
                            ((InputStream)is).close();
                        }
                        catch (IOException ioe) {
                            if (sdebug == null) break block38;
                            sdebug.println("unable to close input stream");
                        }
                    }
                }
            }
        }
        if ("true".equalsIgnoreCase(props.getProperty("security.overridePropertiesFile"))) {
            String extraPropFile = System.getProperty("java.security.properties");
            if (extraPropFile != null && extraPropFile.startsWith("=")) {
                overrideAll = true;
                extraPropFile = extraPropFile.substring(1);
            }
            if (overrideAll) {
                props = new Properties();
                if (sdebug != null) {
                    sdebug.println("overriding other security properties files!");
                }
            }
            if (extraPropFile != null) {
                BufferedInputStream bis = null;
                try {
                    extraPropFile = PropertyExpander.expand(extraPropFile);
                    propFile = new File(extraPropFile);
                    URL propURL = propFile.exists() ? new URL("file:" + propFile.getCanonicalPath()) : new URL(extraPropFile);
                    bis = new BufferedInputStream(propURL.openStream());
                    props.load((InputStream)((Object)bis));
                    loadedProps = true;
                    if (sdebug != null) {
                        sdebug.println("reading security properties file: " + propURL);
                        if (overrideAll) {
                            sdebug.println("overriding other security properties files!");
                        }
                    }
                }
                catch (Exception e) {
                    if (sdebug != null) {
                        sdebug.println("unable to load security properties from " + extraPropFile);
                        e.printStackTrace();
                    }
                }
                finally {
                    block40: {
                        if (bis != null) {
                            try {
                                bis.close();
                            }
                            catch (IOException ioe) {
                                if (sdebug == null) break block40;
                                sdebug.println("unable to close input stream");
                            }
                        }
                    }
                }
            }
        }
        if (!loadedProps) {
            Security.initializeStatic();
            if (sdebug != null) {
                sdebug.println("unable to load security properties -- using defaults");
            }
        }
    }

    private static void initializeStatic() {
        props.put("security.provider.1", "sun.security.provider.Sun");
        props.put("security.provider.2", "sun.security.rsa.SunRsaSign");
        props.put("security.provider.3", "com.sun.net.ssl.internal.ssl.Provider");
        props.put("security.provider.4", "com.sun.crypto.provider.SunJCE");
        props.put("security.provider.5", "sun.security.jgss.SunProvider");
        props.put("security.provider.6", "com.sun.security.sasl.Provider");
    }

    private Security() {
    }

    private static File securityPropFile(String filename) {
        String sep = File.separator;
        return new File(System.getProperty("java.home") + sep + "lib" + sep + "security" + sep + filename);
    }

    private static ProviderProperty getProviderProperty(String key) {
        ProviderProperty entry = null;
        List<Provider> providers = Providers.getProviderList().providers();
        for (int i = 0; i < providers.size(); ++i) {
            String matchKey = null;
            Provider prov = providers.get(i);
            String prop = prov.getProperty(key);
            if (prop == null) {
                Enumeration<Object> e = prov.keys();
                while (e.hasMoreElements() && prop == null) {
                    matchKey = (String)e.nextElement();
                    if (!key.equalsIgnoreCase(matchKey)) continue;
                    prop = prov.getProperty(matchKey);
                    break;
                }
            }
            if (prop == null) continue;
            ProviderProperty newEntry = new ProviderProperty();
            newEntry.className = prop;
            newEntry.provider = prov;
            return newEntry;
        }
        return entry;
    }

    private static String getProviderProperty(String key, Provider provider) {
        String prop = provider.getProperty(key);
        if (prop == null) {
            Enumeration<Object> e = provider.keys();
            while (e.hasMoreElements() && prop == null) {
                String matchKey = (String)e.nextElement();
                if (!key.equalsIgnoreCase(matchKey)) continue;
                prop = provider.getProperty(matchKey);
                break;
            }
        }
        return prop;
    }

    @Deprecated
    public static String getAlgorithmProperty(String algName, String propName) {
        ProviderProperty entry = Security.getProviderProperty("Alg." + propName + "." + algName);
        if (entry != null) {
            return entry.className;
        }
        return null;
    }

    public static synchronized int insertProviderAt(Provider provider, int position) {
        String providerName = provider.getName();
        Security.check("insertProvider." + providerName);
        ProviderList list = Providers.getFullProviderList();
        ProviderList newList = ProviderList.insertAt(list, provider, position - 1);
        if (list == newList) {
            return -1;
        }
        Providers.setProviderList(newList);
        return newList.getIndex(providerName) + 1;
    }

    public static int addProvider(Provider provider) {
        return Security.insertProviderAt(provider, 0);
    }

    public static synchronized void removeProvider(String name) {
        Security.check("removeProvider." + name);
        ProviderList list = Providers.getFullProviderList();
        ProviderList newList = ProviderList.remove(list, name);
        Providers.setProviderList(newList);
    }

    public static Provider[] getProviders() {
        return Providers.getFullProviderList().toArray();
    }

    public static Provider getProvider(String name) {
        return Providers.getProviderList().getProvider(name);
    }

    public static Provider[] getProviders(String filter) {
        String key = null;
        String value = null;
        int index = filter.indexOf(58);
        if (index == -1) {
            key = filter;
            value = "";
        } else {
            key = filter.substring(0, index);
            value = filter.substring(index + 1);
        }
        Hashtable<String, String> hashtableFilter = new Hashtable<String, String>(1);
        hashtableFilter.put(key, value);
        return Security.getProviders(hashtableFilter);
    }

    public static Provider[] getProviders(Map<String, String> filter) {
        Provider[] allProviders = Security.getProviders();
        Set<String> keySet = filter.keySet();
        LinkedHashSet<Object> candidates = new LinkedHashSet(5);
        if (keySet == null || allProviders == null) {
            return allProviders;
        }
        boolean firstSearch = true;
        for (String key : keySet) {
            String value = filter.get(key);
            LinkedHashSet<Provider> newCandidates = Security.getAllQualifyingCandidates(key, value, allProviders);
            if (firstSearch) {
                candidates = newCandidates;
                firstSearch = false;
            }
            if (newCandidates != null && !newCandidates.isEmpty()) {
                Iterator cansIte = candidates.iterator();
                while (cansIte.hasNext()) {
                    Provider prov = (Provider)cansIte.next();
                    if (newCandidates.contains(prov)) continue;
                    cansIte.remove();
                }
                continue;
            }
            candidates = null;
            break;
        }
        if (candidates == null || candidates.isEmpty()) {
            return null;
        }
        Object[] candidatesArray = candidates.toArray();
        Provider[] result = new Provider[candidatesArray.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (Provider)candidatesArray[i];
        }
        return result;
    }

    private static Class getSpiClass(String type) {
        Class<?> clazz = spiMap.get(type);
        if (clazz != null) {
            return clazz;
        }
        try {
            clazz = Class.forName("java.security." + type + "Spi");
            spiMap.put(type, clazz);
            return clazz;
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError("Spi class not found", (Throwable)((Object)e));
        }
    }

    static Object[] getImpl(String algorithm, String type, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (provider == null) {
            return GetInstance.getInstance(type, Security.getSpiClass(type), algorithm).toArray();
        }
        return GetInstance.getInstance(type, Security.getSpiClass(type), algorithm, provider).toArray();
    }

    static Object[] getImpl(String algorithm, String type, String provider, Object params) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException {
        if (provider == null) {
            return GetInstance.getInstance(type, Security.getSpiClass(type), algorithm, params).toArray();
        }
        return GetInstance.getInstance(type, Security.getSpiClass(type), algorithm, params, provider).toArray();
    }

    static Object[] getImpl(String algorithm, String type, Provider provider) throws NoSuchAlgorithmException {
        return GetInstance.getInstance(type, Security.getSpiClass(type), algorithm, provider).toArray();
    }

    static Object[] getImpl(String algorithm, String type, Provider provider, Object params) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        return GetInstance.getInstance(type, Security.getSpiClass(type), algorithm, params, provider).toArray();
    }

    public static String getProperty(String key) {
        String name;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new SecurityPermission("getProperty." + key));
        }
        if ((name = props.getProperty(key)) != null) {
            name = name.trim();
        }
        return name;
    }

    public static void setProperty(String key, String datum) {
        Security.check("setProperty." + key);
        props.put(key, datum);
        Security.invalidateSMCache(key);
    }

    private static void invalidateSMCache(String key) {
        final boolean pa = key.equals("package.access");
        boolean pd = key.equals("package.definition");
        if (pa || pd) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    try {
                        Class<?> cl = Class.forName("java.lang.SecurityManager", false, null);
                        Field f = null;
                        boolean accessible = false;
                        if (pa) {
                            f = cl.getDeclaredField("packageAccessValid");
                            accessible = f.isAccessible();
                            f.setAccessible(true);
                        } else {
                            f = cl.getDeclaredField("packageDefinitionValid");
                            accessible = f.isAccessible();
                            f.setAccessible(true);
                        }
                        f.setBoolean(f, false);
                        f.setAccessible(accessible);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return null;
                }
            });
        }
    }

    private static void check(String directive) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkSecurityAccess(directive);
        }
    }

    private static LinkedHashSet<Provider> getAllQualifyingCandidates(String filterKey, String filterValue, Provider[] allProviders) {
        String[] filterComponents = Security.getFilterComponents(filterKey, filterValue);
        String serviceName = filterComponents[0];
        String algName = filterComponents[1];
        String attrName = filterComponents[2];
        return Security.getProvidersNotUsingCache(serviceName, algName, attrName, filterValue, allProviders);
    }

    private static LinkedHashSet<Provider> getProvidersNotUsingCache(String serviceName, String algName, String attrName, String filterValue, Provider[] allProviders) {
        LinkedHashSet<Provider> candidates = new LinkedHashSet<Provider>(5);
        for (int i = 0; i < allProviders.length; ++i) {
            if (!Security.isCriterionSatisfied(allProviders[i], serviceName, algName, attrName, filterValue)) continue;
            candidates.add(allProviders[i]);
        }
        return candidates;
    }

    private static boolean isCriterionSatisfied(Provider prov, String serviceName, String algName, String attrName, String filterValue) {
        String propValue;
        String key = serviceName + '.' + algName;
        if (attrName != null) {
            key = key + ' ' + attrName;
        }
        if ((propValue = Security.getProviderProperty(key, prov)) == null) {
            String standardName = Security.getProviderProperty("Alg.Alias." + serviceName + "." + algName, prov);
            if (standardName != null) {
                key = serviceName + "." + standardName;
                if (attrName != null) {
                    key = key + ' ' + attrName;
                }
                propValue = Security.getProviderProperty(key, prov);
            }
            if (propValue == null) {
                return false;
            }
        }
        if (attrName == null) {
            return true;
        }
        if (Security.isStandardAttr(attrName)) {
            return Security.isConstraintSatisfied(attrName, filterValue, propValue);
        }
        return filterValue.equalsIgnoreCase(propValue);
    }

    private static boolean isStandardAttr(String attribute) {
        if (attribute.equalsIgnoreCase("KeySize")) {
            return true;
        }
        return attribute.equalsIgnoreCase("ImplementedIn");
    }

    private static boolean isConstraintSatisfied(String attribute, String value, String prop) {
        if (attribute.equalsIgnoreCase("KeySize")) {
            int maxSize;
            int requestedSize = Integer.parseInt(value);
            return requestedSize <= (maxSize = Integer.parseInt(prop));
        }
        if (attribute.equalsIgnoreCase("ImplementedIn")) {
            return value.equalsIgnoreCase(prop);
        }
        return false;
    }

    static String[] getFilterComponents(String filterKey, String filterValue) {
        int algIndex = filterKey.indexOf(46);
        if (algIndex < 0) {
            throw new InvalidParameterException("Invalid filter");
        }
        String serviceName = filterKey.substring(0, algIndex);
        String algName = null;
        String attrName = null;
        if (filterValue.length() == 0) {
            algName = filterKey.substring(algIndex + 1).trim();
            if (algName.length() == 0) {
                throw new InvalidParameterException("Invalid filter");
            }
        } else {
            int attrIndex = filterKey.indexOf(32);
            if (attrIndex == -1) {
                throw new InvalidParameterException("Invalid filter");
            }
            attrName = filterKey.substring(attrIndex + 1).trim();
            if (attrName.length() == 0) {
                throw new InvalidParameterException("Invalid filter");
            }
            if (attrIndex < algIndex || algIndex == attrIndex - 1) {
                throw new InvalidParameterException("Invalid filter");
            }
            algName = filterKey.substring(algIndex + 1, attrIndex);
        }
        String[] result = new String[]{serviceName, algName, attrName};
        return result;
    }

    public static Set<String> getAlgorithms(String serviceName) {
        if (serviceName == null || serviceName.length() == 0 || serviceName.endsWith(".")) {
            return Collections.EMPTY_SET;
        }
        HashSet<String> result = new HashSet<String>();
        Provider[] providers = Security.getProviders();
        for (int i = 0; i < providers.length; ++i) {
            Enumeration<Object> e = providers[i].keys();
            while (e.hasMoreElements()) {
                String currentKey = ((String)e.nextElement()).toUpperCase();
                if (!currentKey.startsWith(serviceName.toUpperCase()) || currentKey.indexOf(" ") >= 0) continue;
                result.add(currentKey.substring(serviceName.length() + 1));
            }
        }
        return Collections.unmodifiableSet(result);
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                Security.initialize();
                return null;
            }
        });
        spiMap = new ConcurrentHashMap<String, Class>();
    }

    private static class ProviderProperty {
        String className;
        Provider provider;

        private ProviderProperty() {
        }
    }
}

