/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import java.util.StringTokenizer;
import sun.net.ApplicationProxy;
import sun.security.action.GetPropertyAction;
import sun.security.util.SecurityConstants;

/*
 * Exception performing whole class analysis.
 */
public final class URL
implements Serializable {
    static final long serialVersionUID = -7627629688361524110L;
    private static final String protocolPathProp = "java.protocol.handler.pkgs";
    private String protocol;
    private String host;
    private int port;
    private String file;
    private transient String query;
    private String authority;
    private transient String path;
    private transient String userInfo;
    private String ref;
    transient InetAddress hostAddress;
    transient URLStreamHandler handler;
    private int hashCode;
    static URLStreamHandlerFactory factory;
    static Hashtable handlers;
    private static Object streamHandlerLock;
    private static final String GOPHER = "gopher";
    private static final String ENABLE_GOPHER_PROP = "jdk.net.registerGopherProtocol";
    private static final boolean enableGopher;
    private static final String JDK_PACKAGE_PREFIX = "sun.net.www.protocol";

    public URL(String var1, String var2, int var3, String var4) throws MalformedURLException;

    public URL(String var1, String var2, String var3) throws MalformedURLException;

    public URL(String var1, String var2, int var3, String var4, URLStreamHandler var5) throws MalformedURLException;

    public URL(String var1) throws MalformedURLException;

    public URL(URL var1, String var2) throws MalformedURLException;

    public URL(URL var1, String var2, URLStreamHandler var3) throws MalformedURLException;

    private boolean isValidProtocol(String protocol) {
        int len = protocol.length();
        if (len < 1) {
            return false;
        }
        char c = protocol.charAt(0);
        if (!Character.isLetter(c)) {
            return false;
        }
        for (int i = 1; i < len; ++i) {
            c = protocol.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '.' || c == '+' || c == '-') continue;
            return false;
        }
        return true;
    }

    private void checkSpecifyHandler(SecurityManager sm) {
        sm.checkPermission(SecurityConstants.SPECIFY_HANDLER_PERMISSION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void set(String protocol, String host, int port, String file, String ref) {
        URL uRL = this;
        synchronized (uRL) {
            this.protocol = protocol;
            this.host = host;
            this.authority = port == -1 ? host : host + ":" + port;
            this.port = port;
            this.file = file;
            this.ref = ref;
            this.hashCode = -1;
            this.hostAddress = null;
            int q = file.lastIndexOf(63);
            if (q != -1) {
                this.query = file.substring(q + 1);
                this.path = file.substring(0, q);
            } else {
                this.path = file;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void set(String protocol, String host, int port, String authority, String userInfo, String path, String query, String ref) {
        URL uRL = this;
        synchronized (uRL) {
            this.protocol = protocol;
            this.host = host;
            this.port = port;
            this.file = query == null ? path : path + "?" + query;
            this.userInfo = userInfo;
            this.path = path;
            this.ref = ref;
            this.hashCode = -1;
            this.hostAddress = null;
            this.query = query;
            this.authority = authority;
        }
    }

    public String getQuery() {
        return this.query;
    }

    public String getPath() {
        return this.path;
    }

    public String getUserInfo() {
        return this.userInfo;
    }

    public String getAuthority() {
        return this.authority;
    }

    public int getPort() {
        return this.port;
    }

    public int getDefaultPort() {
        return this.handler.getDefaultPort();
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getHost() {
        return this.host;
    }

    public String getFile() {
        return this.file;
    }

    public String getRef() {
        return this.ref;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof URL)) {
            return false;
        }
        URL u2 = (URL)obj;
        return this.handler.equals(this, u2);
    }

    public synchronized int hashCode() {
        if (this.hashCode != -1) {
            return this.hashCode;
        }
        this.hashCode = this.handler.hashCode(this);
        return this.hashCode;
    }

    public boolean sameFile(URL other) {
        return this.handler.sameFile(this, other);
    }

    public String toString() {
        return this.toExternalForm();
    }

    public String toExternalForm() {
        return this.handler.toExternalForm(this);
    }

    public URI toURI() throws URISyntaxException {
        return new URI(this.toString());
    }

    public URLConnection openConnection() throws IOException {
        return this.handler.openConnection(this);
    }

    public URLConnection openConnection(Proxy proxy) throws IOException {
        if (proxy == null) {
            throw new IllegalArgumentException("proxy can not be null");
        }
        Proxy p = proxy == Proxy.NO_PROXY ? Proxy.NO_PROXY : ApplicationProxy.create(proxy);
        SecurityManager sm = System.getSecurityManager();
        if (p.type() != Proxy.Type.DIRECT && sm != null) {
            InetSocketAddress epoint = (InetSocketAddress)p.address();
            if (epoint.isUnresolved()) {
                sm.checkConnect(epoint.getHostName(), epoint.getPort());
            } else {
                sm.checkConnect(epoint.getAddress().getHostAddress(), epoint.getPort());
            }
        }
        return this.handler.openConnection(this, p);
    }

    public final InputStream openStream() throws IOException {
        return this.openConnection().getInputStream();
    }

    public final Object getContent() throws IOException {
        return this.openConnection().getContent();
    }

    public final Object getContent(Class[] classes) throws IOException {
        return this.openConnection().getContent(classes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setURLStreamHandlerFactory(URLStreamHandlerFactory fac) {
        Object object = streamHandlerLock;
        synchronized (object) {
            if (factory != null) {
                throw new Error("factory already defined");
            }
            SecurityManager security = System.getSecurityManager();
            if (security != null) {
                security.checkSetFactory();
            }
            handlers.clear();
            factory = fac;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static URLStreamHandler getURLStreamHandler(String protocol) {
        URLStreamHandler handler = (URLStreamHandler)handlers.get(protocol);
        if (handler == null) {
            boolean checkedWithFactory = false;
            if (factory != null) {
                handler = factory.createURLStreamHandler(protocol);
                checkedWithFactory = true;
            }
            if (handler == null) {
                String packagePrefixList = null;
                packagePrefixList = AccessController.doPrivileged(new GetPropertyAction(protocolPathProp, ""));
                if (packagePrefixList != "") {
                    packagePrefixList = packagePrefixList + "|";
                }
                packagePrefixList = packagePrefixList + JDK_PACKAGE_PREFIX;
                StringTokenizer packagePrefixIter = new StringTokenizer(packagePrefixList, "|");
                while (handler == null && packagePrefixIter.hasMoreTokens()) {
                    String packagePrefix = packagePrefixIter.nextToken().trim();
                    if (protocol.equalsIgnoreCase(GOPHER) && packagePrefix.equals(JDK_PACKAGE_PREFIX) && !enableGopher) continue;
                    try {
                        Class<?> cls;
                        block16: {
                            String clsName = packagePrefix + "." + protocol + ".Handler";
                            cls = null;
                            try {
                                cls = Class.forName(clsName);
                            }
                            catch (ClassNotFoundException e) {
                                ClassLoader cl = ClassLoader.getSystemClassLoader();
                                if (cl == null) break block16;
                                cls = cl.loadClass(clsName);
                            }
                        }
                        if (cls == null) continue;
                        handler = (URLStreamHandler)cls.newInstance();
                    }
                    catch (Exception e) {}
                }
            }
            Object object = streamHandlerLock;
            synchronized (object) {
                URLStreamHandler handler2 = null;
                handler2 = (URLStreamHandler)handlers.get(protocol);
                if (handler2 != null) {
                    return handler2;
                }
                if (!checkedWithFactory && factory != null) {
                    handler2 = factory.createURLStreamHandler(protocol);
                }
                if (handler2 != null) {
                    handler = handler2;
                }
                if (handler != null) {
                    handlers.put(protocol, handler);
                }
            }
        }
        return handler;
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
    }

    private synchronized void readObject(ObjectInputStream var1) throws IOException, ClassNotFoundException;

    static {
        handlers = new Hashtable();
        streamHandlerLock = new Object();
        enableGopher = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                String prop = System.getProperty(URL.ENABLE_GOPHER_PROP);
                return prop == null ? false : !prop.equalsIgnoreCase("false");
            }
        });
    }
}

