/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.text.Normalizer;
import sun.nio.cs.ThreadLocalCoders;

/*
 * Exception performing whole class analysis.
 */
public final class URI
implements Comparable<URI>,
Serializable {
    static final long serialVersionUID = -6052424284110960213L;
    private transient String scheme;
    private transient String fragment;
    private transient String authority;
    private transient String userInfo;
    private transient String host;
    private transient int port;
    private transient String path;
    private transient String query;
    private volatile transient String schemeSpecificPart;
    private volatile transient int hash;
    private volatile transient String decodedUserInfo;
    private volatile transient String decodedAuthority;
    private volatile transient String decodedPath;
    private volatile transient String decodedQuery;
    private volatile transient String decodedFragment;
    private volatile transient String decodedSchemeSpecificPart;
    private volatile String string;
    private static final long L_DIGIT = URI.lowMask('0', '9');
    private static final long H_DIGIT = 0L;
    private static final long L_UPALPHA = 0L;
    private static final long H_UPALPHA = URI.highMask('A', 'Z');
    private static final long L_LOWALPHA = 0L;
    private static final long H_LOWALPHA = URI.highMask('a', 'z');
    private static final long L_ALPHA = 0L;
    private static final long H_ALPHA = H_LOWALPHA | H_UPALPHA;
    private static final long L_ALPHANUM = L_DIGIT | 0L;
    private static final long H_ALPHANUM = 0L | H_ALPHA;
    private static final long L_HEX = L_DIGIT;
    private static final long H_HEX = URI.highMask('A', 'F') | URI.highMask('a', 'f');
    private static final long L_MARK = URI.lowMask("-_.!~*'()");
    private static final long H_MARK = URI.highMask("-_.!~*'()");
    private static final long L_UNRESERVED = L_ALPHANUM | L_MARK;
    private static final long H_UNRESERVED = H_ALPHANUM | H_MARK;
    private static final long L_RESERVED = URI.lowMask(";/?:@&=+$,[]");
    private static final long H_RESERVED = URI.highMask(";/?:@&=+$,[]");
    private static final long L_ESCAPED = 1L;
    private static final long H_ESCAPED = 0L;
    private static final long L_URIC = L_RESERVED | L_UNRESERVED | 1L;
    private static final long H_URIC = H_RESERVED | H_UNRESERVED | 0L;
    private static final long L_PCHAR = L_UNRESERVED | 1L | URI.lowMask(":@&=+$,");
    private static final long H_PCHAR = H_UNRESERVED | 0L | URI.highMask(":@&=+$,");
    private static final long L_PATH = L_PCHAR | URI.lowMask(";/");
    private static final long H_PATH = H_PCHAR | URI.highMask(";/");
    private static final long L_DASH = URI.lowMask("-");
    private static final long H_DASH = URI.highMask("-");
    private static final long L_DOT = URI.lowMask(".");
    private static final long H_DOT = URI.highMask(".");
    private static final long L_USERINFO = L_UNRESERVED | 1L | URI.lowMask(";:&=+$,");
    private static final long H_USERINFO = H_UNRESERVED | 0L | URI.highMask(";:&=+$,");
    private static final long L_REG_NAME = L_UNRESERVED | 1L | URI.lowMask("$,;:@&=+");
    private static final long H_REG_NAME = H_UNRESERVED | 0L | URI.highMask("$,;:@&=+");
    private static final long L_SERVER = L_USERINFO | L_ALPHANUM | L_DASH | URI.lowMask(".:@[]");
    private static final long H_SERVER = H_USERINFO | H_ALPHANUM | H_DASH | URI.highMask(".:@[]");
    private static final long L_SERVER_PERCENT = L_SERVER | URI.lowMask("%");
    private static final long H_SERVER_PERCENT = H_SERVER | URI.highMask("%");
    private static final long L_LEFT_BRACKET = URI.lowMask("[");
    private static final long H_LEFT_BRACKET = URI.highMask("[");
    private static final long L_SCHEME = 0L | L_DIGIT | URI.lowMask("+-.");
    private static final long H_SCHEME = H_ALPHA | 0L | URI.highMask("+-.");
    private static final long L_URIC_NO_SLASH = L_UNRESERVED | 1L | URI.lowMask(";?:@&=+$,");
    private static final long H_URIC_NO_SLASH = H_UNRESERVED | 0L | URI.highMask(";?:@&=+$,");
    private static final char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private URI() {
        this.port = -1;
        this.decodedUserInfo = null;
        this.decodedAuthority = null;
        this.decodedPath = null;
        this.decodedQuery = null;
        this.decodedFragment = null;
        this.decodedSchemeSpecificPart = null;
    }

    public URI(String var1) throws URISyntaxException;

    public URI(String var1, String var2, String var3, int var4, String var5, String var6, String var7) throws URISyntaxException;

    public URI(String var1, String var2, String var3, String var4, String var5) throws URISyntaxException;

    public URI(String var1, String var2, String var3, String var4) throws URISyntaxException;

    public URI(String var1, String var2, String var3) throws URISyntaxException;

    public static URI create(String str) {
        try {
            return new URI(str);
        }
        catch (URISyntaxException x) {
            throw new IllegalArgumentException(x.getMessage(), x);
        }
    }

    public URI parseServerAuthority() throws URISyntaxException;

    public URI normalize() {
        return URI.normalize(this);
    }

    public URI resolve(URI uri) {
        return URI.resolve(this, uri);
    }

    public URI resolve(String str) {
        return this.resolve(URI.create(str));
    }

    public URI relativize(URI uri) {
        return URI.relativize(this, uri);
    }

    public URL toURL() throws MalformedURLException {
        if (!this.isAbsolute()) {
            throw new IllegalArgumentException("URI is not absolute");
        }
        return new URL(this.toString());
    }

    public String getScheme() {
        return this.scheme;
    }

    public boolean isAbsolute() {
        return this.scheme != null;
    }

    public boolean isOpaque() {
        return this.path == null;
    }

    public String getRawSchemeSpecificPart() {
        this.defineSchemeSpecificPart();
        return this.schemeSpecificPart;
    }

    public String getSchemeSpecificPart() {
        if (this.decodedSchemeSpecificPart == null) {
            this.decodedSchemeSpecificPart = URI.decode(this.getRawSchemeSpecificPart());
        }
        return this.decodedSchemeSpecificPart;
    }

    public String getRawAuthority() {
        return this.authority;
    }

    public String getAuthority() {
        if (this.decodedAuthority == null) {
            this.decodedAuthority = URI.decode(this.authority);
        }
        return this.decodedAuthority;
    }

    public String getRawUserInfo() {
        return this.userInfo;
    }

    public String getUserInfo() {
        if (this.decodedUserInfo == null && this.userInfo != null) {
            this.decodedUserInfo = URI.decode(this.userInfo);
        }
        return this.decodedUserInfo;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getRawPath() {
        return this.path;
    }

    public String getPath() {
        if (this.decodedPath == null && this.path != null) {
            this.decodedPath = URI.decode(this.path);
        }
        return this.decodedPath;
    }

    public String getRawQuery() {
        return this.query;
    }

    public String getQuery() {
        if (this.decodedQuery == null && this.query != null) {
            this.decodedQuery = URI.decode(this.query);
        }
        return this.decodedQuery;
    }

    public String getRawFragment() {
        return this.fragment;
    }

    public String getFragment() {
        if (this.decodedFragment == null && this.fragment != null) {
            this.decodedFragment = URI.decode(this.fragment);
        }
        return this.decodedFragment;
    }

    public boolean equals(Object ob) {
        if (ob == this) {
            return true;
        }
        if (!(ob instanceof URI)) {
            return false;
        }
        URI that = (URI)ob;
        if (this.isOpaque() != that.isOpaque()) {
            return false;
        }
        if (!URI.equalIgnoringCase(this.scheme, that.scheme)) {
            return false;
        }
        if (!URI.equal(this.fragment, that.fragment)) {
            return false;
        }
        if (this.isOpaque()) {
            return URI.equal(this.schemeSpecificPart, that.schemeSpecificPart);
        }
        if (!URI.equal(this.path, that.path)) {
            return false;
        }
        if (!URI.equal(this.query, that.query)) {
            return false;
        }
        if (this.authority == that.authority) {
            return true;
        }
        if (this.host != null) {
            if (!URI.equal(this.userInfo, that.userInfo)) {
                return false;
            }
            if (!URI.equalIgnoringCase(this.host, that.host)) {
                return false;
            }
            if (this.port != that.port) {
                return false;
            }
        } else if (this.authority != null ? !URI.equal(this.authority, that.authority) : this.authority != that.authority) {
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.hash != 0) {
            return this.hash;
        }
        int h = URI.hashIgnoringCase(0, this.scheme);
        h = URI.hash(h, this.fragment);
        if (this.isOpaque()) {
            h = URI.hash(h, this.schemeSpecificPart);
        } else {
            h = URI.hash(h, this.path);
            h = URI.hash(h, this.query);
            if (this.host != null) {
                h = URI.hash(h, this.userInfo);
                h = URI.hashIgnoringCase(h, this.host);
                h += 1949 * this.port;
            } else {
                h = URI.hash(h, this.authority);
            }
        }
        this.hash = h;
        return h;
    }

    @Override
    public int compareTo(URI that) {
        int c = URI.compareIgnoringCase(this.scheme, that.scheme);
        if (c != 0) {
            return c;
        }
        if (this.isOpaque()) {
            if (that.isOpaque()) {
                c = URI.compare(this.schemeSpecificPart, that.schemeSpecificPart);
                if (c != 0) {
                    return c;
                }
                return URI.compare(this.fragment, that.fragment);
            }
            return 1;
        }
        if (that.isOpaque()) {
            return -1;
        }
        if (this.host != null && that.host != null) {
            c = URI.compare(this.userInfo, that.userInfo);
            if (c != 0) {
                return c;
            }
            c = URI.compareIgnoringCase(this.host, that.host);
            if (c != 0) {
                return c;
            }
            c = this.port - that.port;
            if (c != 0) {
                return c;
            }
        } else {
            c = URI.compare(this.authority, that.authority);
            if (c != 0) {
                return c;
            }
        }
        if ((c = URI.compare(this.path, that.path)) != 0) {
            return c;
        }
        c = URI.compare(this.query, that.query);
        if (c != 0) {
            return c;
        }
        return URI.compare(this.fragment, that.fragment);
    }

    public String toString() {
        this.defineString();
        return this.string;
    }

    public String toASCIIString() {
        this.defineString();
        return URI.encode(this.string);
    }

    private void writeObject(ObjectOutputStream os) throws IOException {
        this.defineString();
        os.defaultWriteObject();
    }

    private void readObject(ObjectInputStream is) throws ClassNotFoundException, IOException {
        this.port = -1;
        is.defaultReadObject();
        try {
            new Parser(this.string).parse(false);
        }
        catch (URISyntaxException x) {
            InvalidObjectException y = new InvalidObjectException("Invalid URI");
            y.initCause(x);
            throw y;
        }
    }

    private static int toLower(char c) {
        if (c >= 'A' && c <= 'Z') {
            return c + 32;
        }
        return c;
    }

    private static boolean equal(String s, String t) {
        if (s == t) {
            return true;
        }
        if (s != null && t != null) {
            if (s.length() != t.length()) {
                return false;
            }
            if (s.indexOf(37) < 0) {
                return s.equals(t);
            }
            int n = s.length();
            int i = 0;
            while (i < n) {
                char c = s.charAt(i);
                char d = t.charAt(i);
                if (c != '%') {
                    if (c != d) {
                        return false;
                    }
                    ++i;
                    continue;
                }
                if (d != '%') {
                    return false;
                }
                if (URI.toLower(s.charAt(++i)) != URI.toLower(t.charAt(i))) {
                    return false;
                }
                if (URI.toLower(s.charAt(++i)) != URI.toLower(t.charAt(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    private static boolean equalIgnoringCase(String s, String t) {
        if (s == t) {
            return true;
        }
        if (s != null && t != null) {
            int n = s.length();
            if (t.length() != n) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                if (URI.toLower(s.charAt(i)) == URI.toLower(t.charAt(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static int hash(int hash, String s) {
        if (s == null) {
            return hash;
        }
        return hash * 127 + s.hashCode();
    }

    private static int hashIgnoringCase(int hash, String s) {
        if (s == null) {
            return hash;
        }
        int h = hash;
        int n = s.length();
        for (int i = 0; i < n; ++i) {
            h = 31 * h + URI.toLower(s.charAt(i));
        }
        return h;
    }

    private static int compare(String s, String t) {
        if (s == t) {
            return 0;
        }
        if (s != null) {
            if (t != null) {
                return s.compareTo(t);
            }
            return 1;
        }
        return -1;
    }

    private static int compareIgnoringCase(String s, String t) {
        if (s == t) {
            return 0;
        }
        if (s != null) {
            if (t != null) {
                int tn;
                int sn = s.length();
                int n = sn < (tn = t.length()) ? sn : tn;
                for (int i = 0; i < n; ++i) {
                    int c = URI.toLower(s.charAt(i)) - URI.toLower(t.charAt(i));
                    if (c == 0) continue;
                    return c;
                }
                return sn - tn;
            }
            return 1;
        }
        return -1;
    }

    private static void checkPath(String var0, String var1, String var2) throws URISyntaxException;

    private void appendAuthority(StringBuffer sb, String authority, String userInfo, String host, int port) {
        if (host != null) {
            boolean needBrackets;
            sb.append("//");
            if (userInfo != null) {
                sb.append(URI.quote(userInfo, L_USERINFO, H_USERINFO));
                sb.append('@');
            }
            boolean bl = needBrackets = host.indexOf(58) >= 0 && !host.startsWith("[") && !host.endsWith("]");
            if (needBrackets) {
                sb.append('[');
            }
            sb.append(host);
            if (needBrackets) {
                sb.append(']');
            }
            if (port != -1) {
                sb.append(':');
                sb.append(port);
            }
        } else if (authority != null) {
            sb.append("//");
            if (authority.startsWith("[")) {
                int end = authority.indexOf("]");
                String doquote = authority;
                String dontquote = "";
                if (end != -1 && authority.indexOf(":") != -1) {
                    if (end == authority.length()) {
                        dontquote = authority;
                        doquote = "";
                    } else {
                        dontquote = authority.substring(0, end + 1);
                        doquote = authority.substring(end + 1);
                    }
                }
                sb.append(dontquote);
                sb.append(URI.quote(doquote, L_REG_NAME | L_SERVER, H_REG_NAME | H_SERVER));
            } else {
                sb.append(URI.quote(authority, L_REG_NAME | L_SERVER, H_REG_NAME | H_SERVER));
            }
        }
    }

    private void appendSchemeSpecificPart(StringBuffer sb, String opaquePart, String authority, String userInfo, String host, int port, String path, String query) {
        if (opaquePart != null) {
            if (opaquePart.startsWith("//[")) {
                int end = opaquePart.indexOf("]");
                if (end != -1 && opaquePart.indexOf(":") != -1) {
                    String doquote;
                    String dontquote;
                    if (end == opaquePart.length()) {
                        dontquote = opaquePart;
                        doquote = "";
                    } else {
                        dontquote = opaquePart.substring(0, end + 1);
                        doquote = opaquePart.substring(end + 1);
                    }
                    sb.append(dontquote);
                    sb.append(URI.quote(doquote, L_URIC, H_URIC));
                }
            } else {
                sb.append(URI.quote(opaquePart, L_URIC, H_URIC));
            }
        } else {
            this.appendAuthority(sb, authority, userInfo, host, port);
            if (path != null) {
                sb.append(URI.quote(path, L_PATH, H_PATH));
            }
            if (query != null) {
                sb.append('?');
                sb.append(URI.quote(query, L_URIC, H_URIC));
            }
        }
    }

    private void appendFragment(StringBuffer sb, String fragment) {
        if (fragment != null) {
            sb.append('#');
            sb.append(URI.quote(fragment, L_URIC, H_URIC));
        }
    }

    private String toString(String scheme, String opaquePart, String authority, String userInfo, String host, int port, String path, String query, String fragment) {
        StringBuffer sb = new StringBuffer();
        if (scheme != null) {
            sb.append(scheme);
            sb.append(':');
        }
        this.appendSchemeSpecificPart(sb, opaquePart, authority, userInfo, host, port, path, query);
        this.appendFragment(sb, fragment);
        return sb.toString();
    }

    private void defineSchemeSpecificPart() {
        if (this.schemeSpecificPart != null) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        this.appendSchemeSpecificPart(sb, null, this.getAuthority(), this.getUserInfo(), this.host, this.port, this.getPath(), this.getQuery());
        if (sb.length() == 0) {
            return;
        }
        this.schemeSpecificPart = sb.toString();
    }

    private void defineString() {
        if (this.string != null) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        if (this.scheme != null) {
            sb.append(this.scheme);
            sb.append(':');
        }
        if (this.isOpaque()) {
            sb.append(this.schemeSpecificPart);
        } else {
            if (this.host != null) {
                boolean needBrackets;
                sb.append("//");
                if (this.userInfo != null) {
                    sb.append(this.userInfo);
                    sb.append('@');
                }
                boolean bl = needBrackets = this.host.indexOf(58) >= 0 && !this.host.startsWith("[") && !this.host.endsWith("]");
                if (needBrackets) {
                    sb.append('[');
                }
                sb.append(this.host);
                if (needBrackets) {
                    sb.append(']');
                }
                if (this.port != -1) {
                    sb.append(':');
                    sb.append(this.port);
                }
            } else if (this.authority != null) {
                sb.append("//");
                sb.append(this.authority);
            }
            if (this.path != null) {
                sb.append(this.path);
            }
            if (this.query != null) {
                sb.append('?');
                sb.append(this.query);
            }
        }
        if (this.fragment != null) {
            sb.append('#');
            sb.append(this.fragment);
        }
        this.string = sb.toString();
    }

    private static String resolvePath(String base, String child, boolean absolute) {
        int i = base.lastIndexOf(47);
        int cn = child.length();
        String path = "";
        if (cn == 0) {
            if (i >= 0) {
                path = base.substring(0, i + 1);
            }
        } else {
            StringBuffer sb = new StringBuffer(base.length() + cn);
            if (i >= 0) {
                sb.append(base.substring(0, i + 1));
            }
            sb.append(child);
            path = sb.toString();
        }
        String np = URI.normalize(path);
        return np;
    }

    private static URI resolve(URI base, URI child) {
        if (child.isOpaque() || base.isOpaque()) {
            return child;
        }
        if (child.scheme == null && child.authority == null && child.path.equals("") && child.fragment != null && child.query == null) {
            if (base.fragment != null && child.fragment.equals(base.fragment)) {
                return base;
            }
            URI ru = new URI();
            ru.scheme = base.scheme;
            ru.authority = base.authority;
            ru.userInfo = base.userInfo;
            ru.host = base.host;
            ru.port = base.port;
            ru.path = base.path;
            ru.fragment = child.fragment;
            ru.query = base.query;
            return ru;
        }
        if (child.scheme != null) {
            return child;
        }
        URI ru = new URI();
        ru.scheme = base.scheme;
        ru.query = child.query;
        ru.fragment = child.fragment;
        if (child.authority == null) {
            String cp;
            ru.authority = base.authority;
            ru.host = base.host;
            ru.userInfo = base.userInfo;
            ru.port = base.port;
            String string = cp = child.path == null ? "" : child.path;
            ru.path = cp.length() > 0 && cp.charAt(0) == '/' ? child.path : URI.resolvePath(base.path, cp, base.isAbsolute());
        } else {
            ru.authority = child.authority;
            ru.host = child.host;
            ru.userInfo = child.userInfo;
            ru.host = child.host;
            ru.port = child.port;
            ru.path = child.path;
        }
        return ru;
    }

    private static URI normalize(URI u) {
        if (u.isOpaque() || u.path == null || u.path.length() == 0) {
            return u;
        }
        String np = URI.normalize(u.path);
        if (np == u.path) {
            return u;
        }
        URI v = new URI();
        v.scheme = u.scheme;
        v.fragment = u.fragment;
        v.authority = u.authority;
        v.userInfo = u.userInfo;
        v.host = u.host;
        v.port = u.port;
        v.path = np;
        v.query = u.query;
        return v;
    }

    private static URI relativize(URI base, URI child) {
        String cp;
        if (child.isOpaque() || base.isOpaque()) {
            return child;
        }
        if (!URI.equalIgnoringCase(base.scheme, child.scheme) || !URI.equal(base.authority, child.authority)) {
            return child;
        }
        String bp = URI.normalize(base.path);
        if (!bp.equals(cp = URI.normalize(child.path))) {
            if (!bp.endsWith("/")) {
                bp = bp + "/";
            }
            if (!cp.startsWith(bp)) {
                return child;
            }
        }
        URI v = new URI();
        v.path = cp.substring(bp.length());
        v.query = child.query;
        v.fragment = child.fragment;
        return v;
    }

    private static int needsNormalization(String path) {
        int p;
        boolean normal = true;
        int ns = 0;
        int end = path.length() - 1;
        for (p = 0; p <= end && path.charAt(p) == '/'; ++p) {
        }
        if (p > 1) {
            normal = false;
        }
        block1: while (p <= end) {
            if (path.charAt(p) == '.' && (p == end || path.charAt(p + 1) == '/' || path.charAt(p + 1) == '.' && (p + 1 == end || path.charAt(p + 2) == '/'))) {
                normal = false;
            }
            ++ns;
            while (p <= end) {
                if (path.charAt(p++) != '/') continue;
                while (p <= end && path.charAt(p) == '/') {
                    normal = false;
                    ++p;
                }
                continue block1;
            }
        }
        return normal ? -1 : ns;
    }

    private static void split(char[] path, int[] segs) {
        int p;
        int end = path.length - 1;
        int i = 0;
        for (p = 0; p <= end && path[p] == '/'; ++p) {
            path[p] = '\u0000';
        }
        block1: while (p <= end) {
            segs[i++] = p++;
            while (p <= end) {
                if (path[p++] != '/') continue;
                path[p - 1] = '\u0000';
                while (p <= end && path[p] == '/') {
                    path[p++] = '\u0000';
                }
                continue block1;
            }
        }
        if (i != segs.length) {
            throw new InternalError();
        }
    }

    private static int join(char[] path, int[] segs) {
        int ns = segs.length;
        int end = path.length - 1;
        int p = 0;
        if (path[p] == '\u0000') {
            path[p++] = 47;
        }
        for (int i = 0; i < ns; ++i) {
            int q = segs[i];
            if (q == -1) continue;
            if (p == q) {
                while (p <= end && path[p] != '\u0000') {
                    ++p;
                }
                if (p > end) continue;
                path[p++] = 47;
                continue;
            }
            if (p < q) {
                while (q <= end && path[q] != '\u0000') {
                    path[p++] = path[q++];
                }
                if (q > end) continue;
                path[p++] = 47;
                continue;
            }
            throw new InternalError();
        }
        return p;
    }

    private static void removeDots(char[] path, int[] segs) {
        int ns = segs.length;
        int end = path.length - 1;
        for (int i = 0; i < ns; ++i) {
            int q;
            int j;
            int dots = 0;
            do {
                int p;
                if (path[p = segs[i]] != '.') continue;
                if (p == end) {
                    dots = 1;
                    break;
                }
                if (path[p + 1] == '\u0000') {
                    dots = 1;
                    break;
                }
                if (path[p + 1] != '.' || p + 1 != end && path[p + 2] != '\u0000') continue;
                dots = 2;
                break;
            } while (++i < ns);
            if (i > ns || dots == 0) break;
            if (dots == 1) {
                segs[i] = -1;
                continue;
            }
            for (j = i - 1; j >= 0 && segs[j] == -1; --j) {
            }
            if (j < 0 || path[q = segs[j]] == '.' && path[q + 1] == '.' && path[q + 2] == '\u0000') continue;
            segs[i] = -1;
            segs[j] = -1;
        }
    }

    private static void maybeAddLeadingDot(char[] path, int[] segs) {
        int p;
        int f;
        if (path[0] == '\u0000') {
            return;
        }
        int ns = segs.length;
        for (f = 0; f < ns && segs[f] < 0; ++f) {
        }
        if (f >= ns || f == 0) {
            return;
        }
        for (p = segs[f]; p < path.length && path[p] != ':' && path[p] != '\u0000'; ++p) {
        }
        if (p >= path.length || path[p] == '\u0000') {
            return;
        }
        path[0] = 46;
        path[1] = '\u0000';
        segs[0] = 0;
    }

    private static String normalize(String ps) {
        int ns = URI.needsNormalization(ps);
        if (ns < 0) {
            return ps;
        }
        char[] path = ps.toCharArray();
        int[] segs = new int[ns];
        URI.split(path, segs);
        URI.removeDots(path, segs);
        URI.maybeAddLeadingDot(path, segs);
        String s = new String(path, 0, URI.join(path, segs));
        if (s.equals(ps)) {
            return ps;
        }
        return s;
    }

    private static long lowMask(String chars) {
        int n = chars.length();
        long m = 0L;
        for (int i = 0; i < n; ++i) {
            char c = chars.charAt(i);
            if (c >= '@') continue;
            m |= 1L << c;
        }
        return m;
    }

    private static long highMask(String chars) {
        int n = chars.length();
        long m = 0L;
        for (int i = 0; i < n; ++i) {
            char c = chars.charAt(i);
            if (c < '@' || c >= '\u0080') continue;
            m |= 1L << c - 64;
        }
        return m;
    }

    private static long lowMask(char first, char last) {
        long m = 0L;
        int f = Math.max(Math.min(first, 63), 0);
        int l = Math.max(Math.min(last, 63), 0);
        for (int i = f; i <= l; ++i) {
            m |= 1L << i;
        }
        return m;
    }

    private static long highMask(char first, char last) {
        long m = 0L;
        int f = Math.max(Math.min(first, 127), 64) - 64;
        int l = Math.max(Math.min(last, 127), 64) - 64;
        for (int i = f; i <= l; ++i) {
            m |= 1L << i;
        }
        return m;
    }

    private static boolean match(char c, long lowMask, long highMask) {
        if (c == '\u0000') {
            return false;
        }
        if (c < '@') {
            return (1L << c & lowMask) != 0L;
        }
        if (c < '\u0080') {
            return (1L << c - 64 & highMask) != 0L;
        }
        return false;
    }

    private static void appendEscape(StringBuffer sb, byte b) {
        sb.append('%');
        sb.append(hexDigits[b >> 4 & 0xF]);
        sb.append(hexDigits[b >> 0 & 0xF]);
    }

    private static void appendEncoded(StringBuffer sb, char c) {
        Buffer bb;
        block4: {
            bb = null;
            try {
                bb = ThreadLocalCoders.encoderFor("UTF-8").encode(CharBuffer.wrap("" + c));
            }
            catch (CharacterCodingException x) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError();
            }
        }
        while (bb.hasRemaining()) {
            int b = ((ByteBuffer)bb).get() & 0xFF;
            if (b >= 128) {
                URI.appendEscape(sb, (byte)b);
                continue;
            }
            sb.append((char)b);
        }
    }

    private static String quote(String s, long lowMask, long highMask) {
        int n = s.length();
        StringBuffer sb = null;
        boolean allowNonASCII = (lowMask & 1L) != 0L;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c < '\u0080') {
                if (!URI.match(c, lowMask, highMask)) {
                    if (sb == null) {
                        sb = new StringBuffer();
                        sb.append(s.substring(0, i));
                    }
                    URI.appendEscape(sb, (byte)c);
                    continue;
                }
                if (sb == null) continue;
                sb.append(c);
                continue;
            }
            if (allowNonASCII && (Character.isSpaceChar(c) || Character.isISOControl(c))) {
                if (sb == null) {
                    sb = new StringBuffer();
                    sb.append(s.substring(0, i));
                }
                URI.appendEncoded(sb, c);
                continue;
            }
            if (sb == null) continue;
            sb.append(c);
        }
        return sb == null ? s : sb.toString();
    }

    private static String encode(String s) {
        ByteBuffer bb;
        block6: {
            int n = s.length();
            if (n == 0) {
                return s;
            }
            int i = 0;
            while (s.charAt(i) < '\u0080') {
                if (++i < n) continue;
                return s;
            }
            String ns = Normalizer.normalize(s, Normalizer.Form.NFC);
            bb = null;
            try {
                bb = ThreadLocalCoders.encoderFor("UTF-8").encode(CharBuffer.wrap(ns));
            }
            catch (CharacterCodingException x) {
                if ($assertionsDisabled) break block6;
                throw new AssertionError();
            }
        }
        StringBuffer sb = new StringBuffer();
        while (bb.hasRemaining()) {
            int b = bb.get() & 0xFF;
            if (b >= 128) {
                URI.appendEscape(sb, (byte)b);
                continue;
            }
            sb.append((char)b);
        }
        return sb.toString();
    }

    private static int decode(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        assert (false);
        return -1;
    }

    private static byte decode(char c1, char c2) {
        return (byte)((URI.decode(c1) & 0xF) << 4 | (URI.decode(c2) & 0xF) << 0);
    }

    private static String decode(String s) {
        if (s == null) {
            return s;
        }
        int n = s.length();
        if (n == 0) {
            return s;
        }
        if (s.indexOf(37) < 0) {
            return s;
        }
        StringBuffer sb = new StringBuffer(n);
        ByteBuffer bb = ByteBuffer.allocate(n);
        CharBuffer cb = CharBuffer.allocate(n);
        CharsetDecoder dec = ThreadLocalCoders.decoderFor("UTF-8").onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        char c = s.charAt(0);
        boolean betweenBrackets = false;
        int i = 0;
        while (i < n) {
            assert (c == s.charAt(i));
            if (c == '[') {
                betweenBrackets = true;
            } else if (betweenBrackets && c == ']') {
                betweenBrackets = false;
            }
            if (c != '%' || betweenBrackets) {
                sb.append(c);
                if (++i >= n) break;
                c = s.charAt(i);
                continue;
            }
            bb.clear();
            int ui = i;
            do {
                assert (n - i >= 2);
                bb.put(URI.decode(s.charAt(++i), s.charAt(++i)));
            } while (++i < n && (c = s.charAt(i)) == '%');
            bb.flip();
            cb.clear();
            dec.reset();
            CoderResult cr = dec.decode(bb, cb, true);
            assert (cr.isUnderflow());
            cr = dec.flush(cb);
            assert (cr.isUnderflow());
            sb.append(cb.flip().toString());
        }
        return sb.toString();
    }

    static /* synthetic */ long access$100() {
        return L_HEX;
    }

    static /* synthetic */ long access$200() {
        return H_HEX;
    }

    static /* synthetic */ boolean access$300(char x0, long x1, long x2) {
        return URI.match(x0, x1, x2);
    }

    static /* synthetic */ long access$400() {
        return H_ALPHA;
    }

    static /* synthetic */ long access$500() {
        return L_SCHEME;
    }

    static /* synthetic */ long access$600() {
        return H_SCHEME;
    }

    static /* synthetic */ String access$702(URI x0, String x1) {
        x0.scheme = x1;
        return x0.scheme;
    }

    static /* synthetic */ long access$800() {
        return L_URIC;
    }

    static /* synthetic */ long access$900() {
        return H_URIC;
    }

    static /* synthetic */ String access$1002(URI x0, String x1) {
        x0.schemeSpecificPart = x1;
        return x0.schemeSpecificPart;
    }

    static /* synthetic */ String access$1102(URI x0, String x1) {
        x0.fragment = x1;
        return x0.fragment;
    }

    static /* synthetic */ long access$1200() {
        return L_PATH;
    }

    static /* synthetic */ long access$1300() {
        return H_PATH;
    }

    static /* synthetic */ String access$1402(URI x0, String x1) {
        x0.path = x1;
        return x0.path;
    }

    static /* synthetic */ String access$1502(URI x0, String x1) {
        x0.query = x1;
        return x0.query;
    }

    static /* synthetic */ long access$1600() {
        return L_SERVER_PERCENT;
    }

    static /* synthetic */ long access$1700() {
        return H_SERVER_PERCENT;
    }

    static /* synthetic */ long access$1800() {
        return L_SERVER;
    }

    static /* synthetic */ long access$1900() {
        return H_SERVER;
    }

    static /* synthetic */ long access$2000() {
        return L_REG_NAME;
    }

    static /* synthetic */ long access$2100() {
        return H_REG_NAME;
    }

    static /* synthetic */ String access$2202(URI x0, String x1) {
        x0.authority = x1;
        return x0.authority;
    }

    static /* synthetic */ String access$2302(URI x0, String x1) {
        x0.userInfo = x1;
        return x0.userInfo;
    }

    static /* synthetic */ int access$2502(URI x0, int x1) {
        x0.port = x1;
        return x0.port;
    }

    static /* synthetic */ long access$2600() {
        return L_USERINFO;
    }

    static /* synthetic */ long access$2700() {
        return H_USERINFO;
    }

    static /* synthetic */ long access$2800() {
        return L_ALPHANUM;
    }

    static /* synthetic */ long access$2900() {
        return H_ALPHANUM;
    }

    static /* synthetic */ long access$3000() {
        return L_DIGIT;
    }

    static /* synthetic */ long access$3100() {
        return L_DOT;
    }

    static /* synthetic */ long access$3200() {
        return H_DOT;
    }

    static /* synthetic */ long access$3300() {
        return L_DASH;
    }

    static /* synthetic */ long access$3400() {
        return H_DASH;
    }

    private class Parser {
        private String input;
        private boolean requireServerAuthority = false;
        private int ipv6byteCount = 0;

        Parser(String s) {
            this.input = s;
            URI.this.string = s;
        }

        private void fail(String var1) throws URISyntaxException;

        private void fail(String var1, int var2) throws URISyntaxException;

        private void failExpecting(String var1, int var2) throws URISyntaxException;

        private void failExpecting(String var1, String var2, int var3) throws URISyntaxException;

        private String substring(int start, int end) {
            return this.input.substring(start, end);
        }

        private char charAt(int p) {
            return this.input.charAt(p);
        }

        private boolean at(int start, int end, char c) {
            return start < end && this.charAt(start) == c;
        }

        private boolean at(int start, int end, String s) {
            int i;
            int p = start;
            int sn = s.length();
            if (sn > end - p) {
                return false;
            }
            for (i = 0; i < sn && this.charAt(p++) == s.charAt(i); ++i) {
            }
            return i == sn;
        }

        private int scan(int start, int end, char c) {
            if (start < end && this.charAt(start) == c) {
                return start + 1;
            }
            return start;
        }

        private int scan(int start, int end, String err, String stop) {
            int p;
            for (p = start; p < end; ++p) {
                char c = this.charAt(p);
                if (err.indexOf(c) >= 0) {
                    return -1;
                }
                if (stop.indexOf(c) >= 0) break;
            }
            return p;
        }

        private int scanEscape(int var1, int var2, char var3) throws URISyntaxException;

        private int scan(int var1, int var2, long var3, long var5) throws URISyntaxException;

        private void checkChars(int var1, int var2, long var3, long var5, String var7) throws URISyntaxException;

        private void checkChar(int var1, long var2, long var4, String var6) throws URISyntaxException;

        void parse(boolean var1) throws URISyntaxException;

        private int parseHierarchical(int var1, int var2) throws URISyntaxException;

        private int parseAuthority(int var1, int var2) throws URISyntaxException;

        private int parseServer(int var1, int var2) throws URISyntaxException;

        private int scanByte(int var1, int var2) throws URISyntaxException;

        private int scanIPv4Address(int var1, int var2, boolean var3) throws URISyntaxException;

        private int takeIPv4Address(int var1, int var2, String var3) throws URISyntaxException;

        private int parseIPv4Address(int start, int n) {
            int p;
            try {
                p = this.scanIPv4Address(start, n, false);
            }
            catch (URISyntaxException x) {
                return -1;
            }
            catch (NumberFormatException nfe) {
                return -1;
            }
            if (p > start && p < n && this.charAt(p) != ':') {
                p = -1;
            }
            if (p > start) {
                URI.this.host = this.substring(start, p);
            }
            return p;
        }

        private int parseHostname(int var1, int var2) throws URISyntaxException;

        private int parseIPv6Reference(int var1, int var2) throws URISyntaxException;

        private int scanHexPost(int var1, int var2) throws URISyntaxException;

        private int scanHexSeq(int var1, int var2) throws URISyntaxException;
    }
}

