/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetUtil;
import java.net.PlainSocketImpl;
import java.net.Proxy;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.SocketImplFactory;
import java.net.SocksSocketImpl;
import java.net.UnknownHostException;
import java.nio.channels.SocketChannel;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.net.ApplicationProxy;

/*
 * Exception performing whole class analysis.
 */
public class Socket
implements Closeable {
    private boolean created;
    private boolean bound;
    private boolean connected;
    private boolean closed;
    private Object closeLock;
    private boolean shutIn;
    private boolean shutOut;
    SocketImpl impl;
    private boolean oldImpl;
    private static SocketImplFactory factory = null;

    public Socket() {
        this.created = false;
        this.bound = false;
        this.connected = false;
        this.closed = false;
        this.closeLock = new Object();
        this.shutIn = false;
        this.shutOut = false;
        this.oldImpl = false;
        this.setImpl();
    }

    public Socket(Proxy proxy) {
        Proxy p;
        this.created = false;
        this.bound = false;
        this.connected = false;
        this.closed = false;
        this.closeLock = new Object();
        this.shutIn = false;
        this.shutOut = false;
        this.oldImpl = false;
        if (proxy == null) {
            throw new IllegalArgumentException("Invalid Proxy");
        }
        Proxy proxy2 = p = proxy == Proxy.NO_PROXY ? Proxy.NO_PROXY : ApplicationProxy.create(proxy);
        if (p.type() == Proxy.Type.SOCKS) {
            SecurityManager security = System.getSecurityManager();
            InetSocketAddress epoint = (InetSocketAddress)p.address();
            if (epoint.getAddress() != null) {
                this.checkAddress(epoint.getAddress(), "Socket");
            }
            if (security != null) {
                if (epoint.isUnresolved()) {
                    epoint = new InetSocketAddress(epoint.getHostName(), epoint.getPort());
                }
                if (epoint.isUnresolved()) {
                    security.checkConnect(epoint.getHostName(), epoint.getPort());
                } else {
                    security.checkConnect(epoint.getAddress().getHostAddress(), epoint.getPort());
                }
            }
            this.impl = new SocksSocketImpl(p);
            this.impl.setSocket(this);
        } else if (p == Proxy.NO_PROXY) {
            if (factory == null) {
                this.impl = new PlainSocketImpl();
                this.impl.setSocket(this);
            } else {
                this.setImpl();
            }
        } else {
            throw new IllegalArgumentException("Invalid Proxy");
        }
    }

    protected Socket(SocketImpl var1) throws SocketException;

    public Socket(String var1, int var2) throws UnknownHostException, IOException;

    public Socket(InetAddress var1, int var2) throws IOException;

    public Socket(String var1, int var2, InetAddress var3, int var4) throws IOException;

    public Socket(InetAddress var1, int var2, InetAddress var3, int var4) throws IOException;

    @Deprecated
    public Socket(String var1, int var2, boolean var3) throws IOException;

    @Deprecated
    public Socket(InetAddress var1, int var2, boolean var3) throws IOException;

    private Socket(SocketAddress var1, SocketAddress var2, boolean var3) throws IOException;

    void createImpl(boolean var1) throws SocketException;

    private void checkOldImpl() {
        if (this.impl == null) {
            return;
        }
        this.oldImpl = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                Class[] cl = new Class[]{SocketAddress.class, Integer.TYPE};
                Class<?> clazz = Socket.this.impl.getClass();
                while (true) {
                    try {
                        clazz.getDeclaredMethod("connect", cl);
                        return Boolean.FALSE;
                    }
                    catch (NoSuchMethodException e) {
                        if (!(clazz = clazz.getSuperclass()).equals(SocketImpl.class)) continue;
                        return Boolean.TRUE;
                    }
                    break;
                }
            }
        });
    }

    void setImpl() {
        if (factory != null) {
            this.impl = factory.createSocketImpl();
            this.checkOldImpl();
        } else {
            this.impl = new SocksSocketImpl();
        }
        if (this.impl != null) {
            this.impl.setSocket(this);
        }
    }

    SocketImpl getImpl() throws SocketException;

    public void connect(SocketAddress var1) throws IOException;

    public void connect(SocketAddress var1, int var2) throws IOException;

    public void bind(SocketAddress var1) throws IOException;

    private void checkAddress(InetAddress addr, String op) {
        if (addr == null) {
            return;
        }
        if (!(addr instanceof Inet4Address) && !(addr instanceof Inet6Address)) {
            throw new IllegalArgumentException(op + ": invalid address type");
        }
    }

    final void postAccept() {
        this.connected = true;
        this.created = true;
        this.bound = true;
    }

    void setCreated() {
        this.created = true;
    }

    void setBound() {
        this.bound = true;
    }

    void setConnected() {
        this.connected = true;
    }

    public InetAddress getInetAddress() {
        if (!this.isConnected()) {
            return null;
        }
        try {
            return this.getImpl().getInetAddress();
        }
        catch (SocketException socketException) {
            return null;
        }
    }

    public InetAddress getLocalAddress() {
        if (!this.isBound()) {
            return InetAddress.anyLocalAddress();
        }
        InetAddress in = null;
        try {
            SecurityManager sm;
            in = (InetAddress)this.getImpl().getOption(15);
            if (!NetUtil.doRevealLocalAddress() && (sm = System.getSecurityManager()) != null) {
                sm.checkConnect(in.getHostAddress(), -1);
            }
            if (in.isAnyLocalAddress()) {
                in = InetAddress.anyLocalAddress();
            }
        }
        catch (SecurityException e) {
            in = InetAddress.getLoopbackAddress();
        }
        catch (Exception e) {
            in = InetAddress.anyLocalAddress();
        }
        return in;
    }

    public int getPort() {
        if (!this.isConnected()) {
            return 0;
        }
        try {
            return this.getImpl().getPort();
        }
        catch (SocketException socketException) {
            return -1;
        }
    }

    public int getLocalPort() {
        if (!this.isBound()) {
            return -1;
        }
        try {
            return this.getImpl().getLocalPort();
        }
        catch (SocketException socketException) {
            return -1;
        }
    }

    public SocketAddress getRemoteSocketAddress() {
        if (!this.isConnected()) {
            return null;
        }
        return new InetSocketAddress(this.getInetAddress(), this.getPort());
    }

    public SocketAddress getLocalSocketAddress() {
        if (!this.isBound()) {
            return null;
        }
        return new InetSocketAddress(this.getLocalAddress(), this.getLocalPort());
    }

    public SocketChannel getChannel() {
        return null;
    }

    public InputStream getInputStream() throws IOException;

    public OutputStream getOutputStream() throws IOException;

    public void setTcpNoDelay(boolean var1) throws SocketException;

    public boolean getTcpNoDelay() throws SocketException;

    public void setSoLinger(boolean var1, int var2) throws SocketException;

    public int getSoLinger() throws SocketException;

    public void sendUrgentData(int var1) throws IOException;

    public void setOOBInline(boolean var1) throws SocketException;

    public boolean getOOBInline() throws SocketException;

    public synchronized void setSoTimeout(int var1) throws SocketException;

    public synchronized int getSoTimeout() throws SocketException;

    public synchronized void setSendBufferSize(int var1) throws SocketException;

    public synchronized int getSendBufferSize() throws SocketException;

    public synchronized void setReceiveBufferSize(int var1) throws SocketException;

    public synchronized int getReceiveBufferSize() throws SocketException;

    public void setKeepAlive(boolean var1) throws SocketException;

    public boolean getKeepAlive() throws SocketException;

    public void setTrafficClass(int var1) throws SocketException;

    public int getTrafficClass() throws SocketException;

    public void setReuseAddress(boolean var1) throws SocketException;

    public boolean getReuseAddress() throws SocketException;

    @Override
    public synchronized void close() throws IOException;

    public void shutdownInput() throws IOException;

    public void shutdownOutput() throws IOException;

    public String toString() {
        try {
            if (this.isConnected()) {
                return "Socket[addr=" + this.getImpl().getInetAddress() + ",port=" + this.getImpl().getPort() + ",localport=" + this.getImpl().getLocalPort() + "]";
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return "Socket[unconnected]";
    }

    public boolean isConnected() {
        return this.connected || this.oldImpl;
    }

    public boolean isBound() {
        return this.bound || this.oldImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        Object object = this.closeLock;
        synchronized (object) {
            return this.closed;
        }
    }

    public boolean isInputShutdown() {
        return this.shutIn;
    }

    public boolean isOutputShutdown() {
        return this.shutOut;
    }

    public static synchronized void setSocketImplFactory(SocketImplFactory var0) throws IOException;

    public void setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
    }
}

