/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetUtil;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.SocketImplFactory;
import java.net.SocksSocketImpl;
import java.nio.channels.ServerSocketChannel;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

/*
 * Exception performing whole class analysis.
 */
public class ServerSocket
implements Closeable {
    private boolean created;
    private boolean bound;
    private boolean closed;
    private Object closeLock;
    private SocketImpl impl;
    private boolean oldImpl;
    private static SocketImplFactory factory = null;

    ServerSocket(SocketImpl impl) {
        this.created = false;
        this.bound = false;
        this.closed = false;
        this.closeLock = new Object();
        this.oldImpl = false;
        this.impl = impl;
        impl.setServerSocket(this);
    }

    public ServerSocket() throws IOException;

    public ServerSocket(int var1) throws IOException;

    public ServerSocket(int var1, int var2) throws IOException;

    public ServerSocket(int var1, int var2, InetAddress var3) throws IOException;

    SocketImpl getImpl() throws SocketException;

    private void checkOldImpl() {
        if (this.impl == null) {
            return;
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws NoSuchMethodException {
                    Class[] cl = new Class[]{SocketAddress.class, Integer.TYPE};
                    ServerSocket.this.impl.getClass().getDeclaredMethod("connect", cl);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            this.oldImpl = true;
        }
    }

    private void setImpl() {
        if (factory != null) {
            this.impl = factory.createSocketImpl();
            this.checkOldImpl();
        } else {
            this.impl = new SocksSocketImpl();
        }
        if (this.impl != null) {
            this.impl.setServerSocket(this);
        }
    }

    void createImpl() throws SocketException;

    public void bind(SocketAddress var1) throws IOException;

    public void bind(SocketAddress var1, int var2) throws IOException;

    public InetAddress getInetAddress() {
        if (!this.isBound()) {
            return null;
        }
        try {
            SecurityManager sm;
            InetAddress in = this.getImpl().getInetAddress();
            if (!NetUtil.doRevealLocalAddress() && (sm = System.getSecurityManager()) != null) {
                sm.checkConnect(in.getHostAddress(), -1);
            }
            return in;
        }
        catch (SecurityException e) {
            return InetAddress.getLoopbackAddress();
        }
        catch (SocketException socketException) {
            return null;
        }
    }

    public int getLocalPort() {
        if (!this.isBound()) {
            return -1;
        }
        try {
            return this.getImpl().getLocalPort();
        }
        catch (SocketException socketException) {
            return -1;
        }
    }

    public SocketAddress getLocalSocketAddress() {
        if (!this.isBound()) {
            return null;
        }
        return new InetSocketAddress(this.getInetAddress(), this.getLocalPort());
    }

    public Socket accept() throws IOException;

    protected final void implAccept(Socket var1) throws IOException;

    @Override
    public void close() throws IOException;

    public ServerSocketChannel getChannel() {
        return null;
    }

    public boolean isBound() {
        return this.bound || this.oldImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        Object object = this.closeLock;
        synchronized (object) {
            return this.closed;
        }
    }

    public synchronized void setSoTimeout(int var1) throws SocketException;

    public synchronized int getSoTimeout() throws IOException;

    public void setReuseAddress(boolean var1) throws SocketException;

    public boolean getReuseAddress() throws SocketException;

    public String toString() {
        if (!this.isBound()) {
            return "ServerSocket[unbound]";
        }
        InetAddress in = !NetUtil.doRevealLocalAddress() && System.getSecurityManager() != null ? InetAddress.getLoopbackAddress() : this.impl.getInetAddress();
        return "ServerSocket[addr=" + in + ",localport=" + this.impl.getLocalPort() + "]";
    }

    void setBound() {
        this.bound = true;
    }

    void setCreated() {
        this.created = true;
    }

    public static synchronized void setSocketFactory(SocketImplFactory var0) throws IOException;

    public synchronized void setReceiveBufferSize(int var1) throws SocketException;

    public synchronized int getReceiveBufferSize() throws SocketException;

    public void setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
    }
}

