/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.net.Inet4Address;
import java.net.InetAddressImpl;
import java.net.InetAddressImplFactory;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import sun.misc.Service;
import sun.misc.Unsafe;
import sun.net.InetAddressCachePolicy;
import sun.net.spi.nameservice.NameService;
import sun.net.spi.nameservice.NameServiceDescriptor;
import sun.security.action.GetBooleanAction;
import sun.security.action.GetPropertyAction;
import sun.security.action.LoadLibraryAction;

public class InetAddress
implements Serializable {
    static final int IPv4 = 1;
    static final int IPv6 = 2;
    static transient boolean preferIPv6Address;
    final transient InetAddressHolder holder = new InetAddressHolder();
    private static List<NameService> nameServices;
    private transient String canonicalHostName = null;
    private static final long serialVersionUID = 3286316764910316507L;
    private static Cache addressCache;
    private static Cache negativeCache;
    private static boolean addressCacheInit;
    static InetAddress[] unknown_array;
    static InetAddressImpl impl;
    private static final HashMap<String, Void> lookupTable;
    private static InetAddress cachedLocalHost;
    private static long cacheTime;
    private static final long maxCacheTime = 5000L;
    private static final Object cacheLock;
    private static final long FIELDS_OFFSET;
    private static final Unsafe UNSAFE;
    private static final ObjectStreamField[] serialPersistentFields;

    InetAddressHolder holder() {
        return this.holder;
    }

    InetAddress() {
    }

    private Object readResolve() throws ObjectStreamException {
        return new Inet4Address(this.holder().getHostName(), this.holder().getAddress());
    }

    public boolean isMulticastAddress() {
        return false;
    }

    public boolean isAnyLocalAddress() {
        return false;
    }

    public boolean isLoopbackAddress() {
        return false;
    }

    public boolean isLinkLocalAddress() {
        return false;
    }

    public boolean isSiteLocalAddress() {
        return false;
    }

    public boolean isMCGlobal() {
        return false;
    }

    public boolean isMCNodeLocal() {
        return false;
    }

    public boolean isMCLinkLocal() {
        return false;
    }

    public boolean isMCSiteLocal() {
        return false;
    }

    public boolean isMCOrgLocal() {
        return false;
    }

    public boolean isReachable(int timeout) throws IOException {
        return this.isReachable(null, 0, timeout);
    }

    public boolean isReachable(NetworkInterface netif, int ttl, int timeout) throws IOException {
        if (ttl < 0) {
            throw new IllegalArgumentException("ttl can't be negative");
        }
        if (timeout < 0) {
            throw new IllegalArgumentException("timeout can't be negative");
        }
        return impl.isReachable(this, timeout, netif, ttl);
    }

    public String getHostName() {
        return this.getHostName(true);
    }

    String getHostName(boolean check) {
        if (this.holder().getHostName() == null) {
            this.holder().hostName = InetAddress.getHostFromNameService(this, check);
        }
        return this.holder().getHostName();
    }

    public String getCanonicalHostName() {
        if (this.canonicalHostName == null) {
            this.canonicalHostName = InetAddress.getHostFromNameService(this, true);
        }
        return this.canonicalHostName;
    }

    private static String getHostFromNameService(InetAddress addr, boolean check) {
        String host = null;
        for (NameService nameService : nameServices) {
            try {
                SecurityManager sec;
                host = nameService.getHostByAddr(addr.getAddress());
                if (check && (sec = System.getSecurityManager()) != null) {
                    sec.checkConnect(host, -1);
                }
                InetAddress[] arr = InetAddress.getAllByName0(host, check);
                boolean ok = false;
                if (arr != null) {
                    for (int i = 0; !ok && i < arr.length; ++i) {
                        ok = addr.equals(arr[i]);
                    }
                }
                if (!ok) {
                    host = addr.getHostAddress();
                    return host;
                }
                break;
            }
            catch (SecurityException e) {
                host = addr.getHostAddress();
                break;
            }
            catch (UnknownHostException e) {
                host = addr.getHostAddress();
            }
        }
        return host;
    }

    public byte[] getAddress() {
        return null;
    }

    public String getHostAddress() {
        return null;
    }

    public int hashCode() {
        return -1;
    }

    public boolean equals(Object obj) {
        return false;
    }

    public String toString() {
        String hostName = this.holder().getHostName();
        return (hostName != null ? hostName : "") + "/" + this.getHostAddress();
    }

    private static void cacheInitIfNeeded() {
        assert (Thread.holdsLock(addressCache));
        if (addressCacheInit) {
            return;
        }
        unknown_array = new InetAddress[1];
        InetAddress.unknown_array[0] = impl.anyLocalAddress();
        addressCache.put(impl.anyLocalAddress().getHostName(), unknown_array);
        addressCacheInit = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cacheAddresses(String hostname, InetAddress[] addresses, boolean success) {
        hostname = hostname.toLowerCase();
        Cache cache = addressCache;
        synchronized (cache) {
            InetAddress.cacheInitIfNeeded();
            if (success) {
                addressCache.put(hostname, addresses);
            } else {
                negativeCache.put(hostname, addresses);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static InetAddress[] getCachedAddresses(String hostname) {
        hostname = hostname.toLowerCase();
        Cache cache = addressCache;
        synchronized (cache) {
            InetAddress.cacheInitIfNeeded();
            CacheEntry entry = addressCache.get(hostname);
            if (entry == null) {
                entry = negativeCache.get(hostname);
            }
            if (entry != null) {
                return entry.addresses;
            }
        }
        return null;
    }

    private static NameService createNSProvider(String provider) {
        if (provider == null) {
            return null;
        }
        NameService nameService = null;
        if (provider.equals("default")) {
            nameService = new NameService(){

                public InetAddress[] lookupAllHostAddr(String host) throws UnknownHostException {
                    return impl.lookupAllHostAddr(host);
                }

                public String getHostByAddr(byte[] addr) throws UnknownHostException {
                    return impl.getHostByAddr(addr);
                }
            };
        } else {
            final String providerName = provider;
            try {
                nameService = AccessController.doPrivileged(new PrivilegedExceptionAction<NameService>(){

                    @Override
                    public NameService run() {
                        Iterator itr = Service.providers(NameServiceDescriptor.class);
                        while (itr.hasNext()) {
                            NameServiceDescriptor nsd = (NameServiceDescriptor)itr.next();
                            if (!providerName.equalsIgnoreCase(nsd.getType() + "," + nsd.getProviderName())) continue;
                            try {
                                return nsd.createNameService();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                System.err.println("Cannot create name service:" + providerName + ": " + e);
                            }
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                // empty catch block
            }
        }
        return nameService;
    }

    public static InetAddress getByAddress(String var0, byte[] var1) throws UnknownHostException;

    public static InetAddress getByName(String var0) throws UnknownHostException;

    private static InetAddress getByName(String var0, InetAddress var1) throws UnknownHostException;

    public static InetAddress[] getAllByName(String var0) throws UnknownHostException;

    private static InetAddress[] getAllByName(String var0, InetAddress var1) throws UnknownHostException;

    public static InetAddress getLoopbackAddress() {
        return impl.loopbackAddress();
    }

    private static int checkNumericZone(String var0) throws UnknownHostException;

    private static InetAddress[] getAllByName0(String var0) throws UnknownHostException;

    static InetAddress[] getAllByName0(String var0, boolean var1) throws UnknownHostException;

    private static InetAddress[] getAllByName0(String var0, InetAddress var1, boolean var2) throws UnknownHostException;

    private static InetAddress[] getAddressesFromNameService(String var0, InetAddress var1) throws UnknownHostException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static InetAddress[] checkLookupTable(String host) {
        HashMap<String, Void> hashMap = lookupTable;
        synchronized (hashMap) {
            if (!lookupTable.containsKey(host)) {
                lookupTable.put(host, null);
                return null;
            }
            while (lookupTable.containsKey(host)) {
                try {
                    lookupTable.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        InetAddress[] addresses = InetAddress.getCachedAddresses(host);
        if (addresses == null) {
            HashMap<String, Void> hashMap2 = lookupTable;
            synchronized (hashMap2) {
                lookupTable.put(host, null);
                return null;
            }
        }
        return addresses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateLookupTable(String host) {
        HashMap<String, Void> hashMap = lookupTable;
        synchronized (hashMap) {
            lookupTable.remove(host);
            lookupTable.notifyAll();
        }
    }

    public static InetAddress getByAddress(byte[] var0) throws UnknownHostException;

    public static InetAddress getLocalHost() throws UnknownHostException;

    private static native void init();

    static InetAddress anyLocalAddress() {
        return impl.anyLocalAddress();
    }

    static InetAddressImpl loadImpl(String implName) {
        Object impl = null;
        String prefix = AccessController.doPrivileged(new GetPropertyAction("impl.prefix", ""));
        try {
            impl = Class.forName("java.net." + prefix + implName).newInstance();
        }
        catch (ClassNotFoundException e) {
            System.err.println("Class not found: java.net." + prefix + implName + ":\ncheck impl.prefix property " + "in your properties file.");
        }
        catch (InstantiationException e) {
            System.err.println("Could not instantiate: java.net." + prefix + implName + ":\ncheck impl.prefix property " + "in your properties file.");
        }
        catch (IllegalAccessException e) {
            System.err.println("Cannot access class: java.net." + prefix + implName + ":\ncheck impl.prefix property " + "in your properties file.");
        }
        if (impl == null) {
            try {
                impl = Class.forName(implName).newInstance();
            }
            catch (Exception e) {
                throw new Error("System property impl.prefix incorrect");
            }
        }
        return impl;
    }

    private void readObjectNoData(ObjectInputStream var1) throws IOException, ClassNotFoundException;

    private void readObject(ObjectInputStream var1) throws IOException, ClassNotFoundException;

    private void writeObject(ObjectOutputStream s) throws IOException {
        if (this.getClass().getClassLoader() != null) {
            throw new SecurityException("invalid address type");
        }
        ObjectOutputStream.PutField pf = s.putFields();
        pf.put("hostName", this.holder().hostName);
        pf.put("address", this.holder().address);
        pf.put("family", this.holder().family);
        s.writeFields();
    }

    static {
        NameService ns;
        preferIPv6Address = false;
        nameServices = null;
        preferIPv6Address = AccessController.doPrivileged(new GetBooleanAction("java.net.preferIPv6Addresses"));
        AccessController.doPrivileged(new LoadLibraryAction("net"));
        InetAddress.init();
        addressCache = new Cache(Cache.Type.Positive);
        negativeCache = new Cache(Cache.Type.Negative);
        addressCacheInit = false;
        lookupTable = new HashMap();
        impl = InetAddressImplFactory.create();
        String provider = null;
        String propPrefix = "sun.net.spi.nameservice.provider.";
        int n = 1;
        nameServices = new ArrayList<NameService>();
        provider = AccessController.doPrivileged(new GetPropertyAction(propPrefix + n));
        while (provider != null) {
            ns = InetAddress.createNSProvider(provider);
            if (ns != null) {
                nameServices.add(ns);
            }
            provider = AccessController.doPrivileged(new GetPropertyAction(propPrefix + ++n));
        }
        if (nameServices.size() == 0) {
            ns = InetAddress.createNSProvider("default");
            nameServices.add(ns);
        }
        cachedLocalHost = null;
        cacheTime = 0L;
        cacheLock = new Object();
        try {
            Unsafe unsafe = Unsafe.getUnsafe();
            FIELDS_OFFSET = unsafe.objectFieldOffset(InetAddress.class.getDeclaredField("holder"));
            UNSAFE = unsafe;
        }
        catch (ReflectiveOperationException e) {
            throw new Error(e);
        }
        serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("hostName", String.class), new ObjectStreamField("address", Integer.TYPE), new ObjectStreamField("family", Integer.TYPE)};
    }

    static final class Cache {
        private LinkedHashMap<String, CacheEntry> cache;
        private Type type;

        public Cache(Type type) {
            this.type = type;
            this.cache = new LinkedHashMap();
        }

        private int getPolicy() {
            if (this.type == Type.Positive) {
                return InetAddressCachePolicy.get();
            }
            return InetAddressCachePolicy.getNegative();
        }

        public Cache put(String host, InetAddress[] addresses) {
            int policy = this.getPolicy();
            if (policy == 0) {
                return this;
            }
            if (policy != -1) {
                LinkedList<String> expired = new LinkedList<String>();
                long now = System.currentTimeMillis();
                for (String key : this.cache.keySet()) {
                    CacheEntry entry = this.cache.get(key);
                    if (entry.expiration < 0L || entry.expiration >= now) break;
                    expired.add(key);
                }
                for (String key : expired) {
                    this.cache.remove(key);
                }
            }
            long expiration = policy == -1 ? -1L : System.currentTimeMillis() + (long)(policy * 1000);
            CacheEntry entry = new CacheEntry(addresses, expiration);
            this.cache.put(host, entry);
            return this;
        }

        public CacheEntry get(String host) {
            int policy = this.getPolicy();
            if (policy == 0) {
                return null;
            }
            CacheEntry entry = this.cache.get(host);
            if (entry != null && policy != -1 && entry.expiration >= 0L && entry.expiration < System.currentTimeMillis()) {
                this.cache.remove(host);
                entry = null;
            }
            return entry;
        }

        static enum Type {
            Positive,
            Negative;

        }
    }

    static final class CacheEntry {
        InetAddress[] addresses;
        long expiration;

        CacheEntry(InetAddress[] addresses, long expiration) {
            this.addresses = addresses;
            this.expiration = expiration;
        }
    }

    static class InetAddressHolder {
        String hostName;
        int address;
        int family;

        InetAddressHolder() {
        }

        InetAddressHolder(String hostName, int address, int family) {
            this.hostName = hostName;
            this.address = address;
            this.family = family;
        }

        void init(String hostName, int family) {
            this.hostName = hostName;
            if (family != -1) {
                this.family = family;
            }
        }

        String getHostName() {
            return this.hostName;
        }

        int getAddress() {
            return this.address;
        }

        int getFamily() {
            return this.family;
        }
    }
}

