/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.Closeable;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocketImpl;
import java.net.DatagramSocketImplFactory;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.DatagramChannel;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

/*
 * Exception performing whole class analysis.
 */
public class DatagramSocket
implements Closeable {
    private boolean created;
    private boolean bound;
    private boolean closed;
    private Object closeLock;
    DatagramSocketImpl impl;
    boolean oldImpl;
    private boolean explicitFilter;
    private int bytesLeftToFilter;
    static final int ST_NOT_CONNECTED = 0;
    static final int ST_CONNECTED = 1;
    static final int ST_CONNECTED_NO_IMPL = 2;
    int connectState;
    InetAddress connectedAddress;
    int connectedPort;
    static Class implClass = null;
    static DatagramSocketImplFactory factory;

    private synchronized void connectInternal(InetAddress var1, int var2) throws SocketException;

    public DatagramSocket() throws SocketException;

    protected DatagramSocket(DatagramSocketImpl impl) {
        this.created = false;
        this.bound = false;
        this.closed = false;
        this.closeLock = new Object();
        this.oldImpl = false;
        this.explicitFilter = false;
        this.connectState = 0;
        this.connectedAddress = null;
        this.connectedPort = -1;
        if (impl == null) {
            throw new NullPointerException();
        }
        this.impl = impl;
        this.checkOldImpl();
    }

    public DatagramSocket(SocketAddress var1) throws SocketException;

    public DatagramSocket(int var1) throws SocketException;

    public DatagramSocket(int var1, InetAddress var2) throws SocketException;

    private void checkOldImpl() {
        if (this.impl == null) {
            return;
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws NoSuchMethodException {
                    Class[] cl = new Class[]{DatagramPacket.class};
                    DatagramSocket.this.impl.getClass().getDeclaredMethod("peekData", cl);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            this.oldImpl = true;
        }
    }

    void createImpl() throws SocketException;

    DatagramSocketImpl getImpl() throws SocketException;

    public synchronized void bind(SocketAddress var1) throws SocketException;

    void checkAddress(InetAddress addr, String op) {
        if (addr == null) {
            return;
        }
        if (!(addr instanceof Inet4Address) && !(addr instanceof Inet6Address)) {
            throw new IllegalArgumentException(op + ": invalid address type");
        }
    }

    public void connect(InetAddress address, int port) {
        try {
            this.connectInternal(address, port);
        }
        catch (SocketException se) {
            throw new Error("connect failed", se);
        }
    }

    public void connect(SocketAddress var1) throws SocketException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        DatagramSocket datagramSocket = this;
        synchronized (datagramSocket) {
            if (this.isClosed()) {
                return;
            }
            if (this.connectState == 1) {
                this.impl.disconnect();
            }
            this.connectedAddress = null;
            this.connectedPort = -1;
            this.connectState = 0;
            this.explicitFilter = false;
        }
    }

    public boolean isBound() {
        return this.bound;
    }

    public boolean isConnected() {
        return this.connectState != 0;
    }

    public InetAddress getInetAddress() {
        return this.connectedAddress;
    }

    public int getPort() {
        return this.connectedPort;
    }

    public SocketAddress getRemoteSocketAddress() {
        if (!this.isConnected()) {
            return null;
        }
        return new InetSocketAddress(this.getInetAddress(), this.getPort());
    }

    public SocketAddress getLocalSocketAddress() {
        if (this.isClosed()) {
            return null;
        }
        if (!this.isBound()) {
            return null;
        }
        return new InetSocketAddress(this.getLocalAddress(), this.getLocalPort());
    }

    public void send(DatagramPacket var1) throws IOException;

    public synchronized void receive(DatagramPacket var1) throws IOException;

    private boolean checkFiltering(DatagramPacket var1) throws SocketException;

    public InetAddress getLocalAddress() {
        if (this.isClosed()) {
            return null;
        }
        InetAddress in = null;
        try {
            SecurityManager s;
            in = (InetAddress)this.getImpl().getOption(15);
            if (in.isAnyLocalAddress()) {
                in = InetAddress.anyLocalAddress();
            }
            if ((s = System.getSecurityManager()) != null) {
                s.checkConnect(in.getHostAddress(), -1);
            }
        }
        catch (Exception e) {
            in = InetAddress.anyLocalAddress();
        }
        return in;
    }

    public int getLocalPort() {
        if (this.isClosed()) {
            return -1;
        }
        try {
            return this.getImpl().getLocalPort();
        }
        catch (Exception e) {
            return 0;
        }
    }

    public synchronized void setSoTimeout(int var1) throws SocketException;

    public synchronized int getSoTimeout() throws SocketException;

    public synchronized void setSendBufferSize(int var1) throws SocketException;

    public synchronized int getSendBufferSize() throws SocketException;

    public synchronized void setReceiveBufferSize(int var1) throws SocketException;

    public synchronized int getReceiveBufferSize() throws SocketException;

    public synchronized void setReuseAddress(boolean var1) throws SocketException;

    public synchronized boolean getReuseAddress() throws SocketException;

    public synchronized void setBroadcast(boolean var1) throws SocketException;

    public synchronized boolean getBroadcast() throws SocketException;

    public synchronized void setTrafficClass(int var1) throws SocketException;

    public synchronized int getTrafficClass() throws SocketException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.closeLock;
        synchronized (object) {
            if (this.isClosed()) {
                return;
            }
            this.impl.close();
            this.closed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        Object object = this.closeLock;
        synchronized (object) {
            return this.closed;
        }
    }

    public DatagramChannel getChannel() {
        return null;
    }

    public static synchronized void setDatagramSocketImplFactory(DatagramSocketImplFactory var0) throws IOException;
}

