/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.lang.reflect.ReflectPermission;
import java.security.AccessController;
import java.security.Permission;
import sun.reflect.Reflection;
import sun.reflect.ReflectionFactory;

public class AccessibleObject
implements AnnotatedElement {
    private static final Permission ACCESS_PERMISSION = new ReflectPermission("suppressAccessChecks");
    boolean override;
    static final ReflectionFactory reflectionFactory = (ReflectionFactory)AccessController.doPrivileged(new ReflectionFactory.GetReflectionFactoryAction());
    volatile Object securityCheckCache;

    public static void setAccessible(AccessibleObject[] array, boolean flag) throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(ACCESS_PERMISSION);
        }
        for (int i = 0; i < array.length; ++i) {
            AccessibleObject.setAccessible0(array[i], flag);
        }
    }

    public void setAccessible(boolean flag) throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(ACCESS_PERMISSION);
        }
        AccessibleObject.setAccessible0(this, flag);
    }

    private static void setAccessible0(AccessibleObject obj, boolean flag) throws SecurityException {
        Constructor c;
        if (obj instanceof Constructor && flag && (c = (Constructor)obj).getDeclaringClass() == Class.class) {
            throw new SecurityException("Can not make a java.lang.Class constructor accessible");
        }
        obj.override = flag;
    }

    public boolean isAccessible() {
        return this.override;
    }

    protected AccessibleObject() {
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        throw new AssertionError((Object)"All subclasses should override this method");
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return this.getAnnotation(annotationClass) != null;
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.getDeclaredAnnotations();
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        throw new AssertionError((Object)"All subclasses should override this method");
    }

    void checkAccess(Class<?> caller, Class<?> clazz, Object obj, int modifiers) throws IllegalAccessException {
        Class[] cache2;
        if (caller == clazz) {
            return;
        }
        Object cache = this.securityCheckCache;
        Class<?> targetClass = clazz;
        if (obj != null && Modifier.isProtected(modifiers) && (targetClass = obj.getClass()) != clazz ? cache instanceof Class[] && (cache2 = (Class[])cache)[1] == targetClass && cache2[0] == caller : cache == caller) {
            return;
        }
        this.slowCheckMemberAccess(caller, clazz, obj, modifiers, targetClass);
    }

    void slowCheckMemberAccess(Class<?> caller, Class<?> clazz, Object obj, int modifiers, Class<?> targetClass) throws IllegalAccessException {
        Class[] cache;
        Class[] classArray;
        Reflection.ensureMemberAccess(caller, clazz, (Object)obj, (int)modifiers);
        if (targetClass == clazz) {
            classArray = caller;
        } else {
            Class[] classArray2 = new Class[2];
            classArray2[0] = caller;
            classArray = classArray2;
            classArray2[1] = targetClass;
        }
        this.securityCheckCache = cache = classArray;
    }
}

