/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.Bits;
import java.io.DataOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectOutput;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamField;
import java.io.OutputStream;
import java.io.SerialCallbackContext;
import java.io.UTFDataFormatException;
import java.lang.ref.ReferenceQueue;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import sun.security.action.GetBooleanAction;

/*
 * Exception performing whole class analysis.
 */
public class ObjectOutputStream
extends OutputStream
implements ObjectOutput {
    private final BlockDataOutputStream bout;
    private final HandleTable handles;
    private final ReplaceTable subs;
    private int protocol;
    private int depth;
    private byte[] primVals;
    private final boolean enableOverride;
    private boolean enableReplace;
    private SerialCallbackContext curContext;
    private PutFieldImpl curPut;
    private final DebugTraceInfoStack debugInfoStack;
    private static final boolean extendedDebugInfo = AccessController.doPrivileged(new GetBooleanAction("sun.io.serialization.extendedDebugInfo"));

    public ObjectOutputStream(OutputStream var1) throws IOException;

    protected ObjectOutputStream() throws IOException, SecurityException;

    public void useProtocolVersion(int var1) throws IOException;

    @Override
    public final void writeObject(Object var1) throws IOException;

    protected void writeObjectOverride(Object var1) throws IOException;

    public void writeUnshared(Object var1) throws IOException;

    public void defaultWriteObject() throws IOException;

    public PutField putFields() throws IOException;

    public void writeFields() throws IOException;

    public void reset() throws IOException;

    protected void annotateClass(Class<?> var1) throws IOException;

    protected void annotateProxyClass(Class<?> var1) throws IOException;

    protected Object replaceObject(Object var1) throws IOException;

    protected boolean enableReplaceObject(boolean enable) throws SecurityException {
        SecurityManager sm;
        if (enable == this.enableReplace) {
            return enable;
        }
        if (enable && (sm = System.getSecurityManager()) != null) {
            sm.checkPermission(SUBSTITUTION_PERMISSION);
        }
        this.enableReplace = enable;
        return !this.enableReplace;
    }

    protected void writeStreamHeader() throws IOException;

    protected void writeClassDescriptor(ObjectStreamClass var1) throws IOException;

    @Override
    public void write(int var1) throws IOException;

    @Override
    public void write(byte[] var1) throws IOException;

    @Override
    public void write(byte[] var1, int var2, int var3) throws IOException;

    @Override
    public void flush() throws IOException;

    protected void drain() throws IOException;

    @Override
    public void close() throws IOException;

    public void writeBoolean(boolean var1) throws IOException;

    public void writeByte(int var1) throws IOException;

    public void writeShort(int var1) throws IOException;

    public void writeChar(int var1) throws IOException;

    public void writeInt(int var1) throws IOException;

    public void writeLong(long var1) throws IOException;

    public void writeFloat(float var1) throws IOException;

    public void writeDouble(double var1) throws IOException;

    public void writeBytes(String var1) throws IOException;

    public void writeChars(String var1) throws IOException;

    public void writeUTF(String var1) throws IOException;

    int getProtocolVersion() {
        return this.protocol;
    }

    void writeTypeString(String var1) throws IOException;

    private void verifySubclass() {
        Class<?> cl = this.getClass();
        if (cl == ObjectOutputStream.class) {
            return;
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return;
        }
        ObjectStreamClass.processQueue(Caches.subclassAuditsQueue, Caches.subclassAudits);
        ObjectStreamClass.WeakClassKey key = new ObjectStreamClass.WeakClassKey(cl, Caches.subclassAuditsQueue);
        Boolean result = (Boolean)Caches.subclassAudits.get(key);
        if (result == null) {
            result = ObjectOutputStream.auditSubclass(cl);
            Caches.subclassAudits.putIfAbsent(key, result);
        }
        if (result.booleanValue()) {
            return;
        }
        sm.checkPermission(SUBCLASS_IMPLEMENTATION_PERMISSION);
    }

    private static boolean auditSubclass(final Class subcl) {
        Boolean result = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                for (Class cl = subcl; cl != ObjectOutputStream.class; cl = cl.getSuperclass()) {
                    try {
                        cl.getDeclaredMethod("writeUnshared", Object.class);
                        return Boolean.FALSE;
                    }
                    catch (NoSuchMethodException ex) {
                        try {
                            cl.getDeclaredMethod("putFields", null);
                            return Boolean.FALSE;
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            continue;
                        }
                    }
                }
                return Boolean.TRUE;
            }
        });
        return result;
    }

    private void clear() {
        this.subs.clear();
        this.handles.clear();
    }

    private void writeObject0(Object var1, boolean var2) throws IOException;

    private void writeNull() throws IOException;

    private void writeHandle(int var1) throws IOException;

    private void writeClass(Class var1, boolean var2) throws IOException;

    private void writeClassDesc(ObjectStreamClass var1, boolean var2) throws IOException;

    private boolean isCustomSubclass() {
        return this.getClass().getClassLoader() != ObjectOutputStream.class.getClassLoader();
    }

    private void writeProxyDesc(ObjectStreamClass var1, boolean var2) throws IOException;

    private void writeNonProxyDesc(ObjectStreamClass var1, boolean var2) throws IOException;

    private void writeString(String var1, boolean var2) throws IOException;

    private void writeArray(Object var1, ObjectStreamClass var2, boolean var3) throws IOException;

    private void writeEnum(Enum var1, ObjectStreamClass var2, boolean var3) throws IOException;

    private void writeOrdinaryObject(Object var1, ObjectStreamClass var2, boolean var3) throws IOException;

    private void writeExternalData(Externalizable var1) throws IOException;

    private void writeSerialData(Object var1, ObjectStreamClass var2) throws IOException;

    private void defaultWriteFields(Object var1, ObjectStreamClass var2) throws IOException;

    private void writeFatalException(IOException var1) throws IOException;

    private static native void floatsToBytes(float[] var0, int var1, byte[] var2, int var3, int var4);

    private static native void doublesToBytes(double[] var0, int var1, byte[] var2, int var3, int var4);

    static /* synthetic */ void access$300(ObjectOutputStream var0, Object var1, boolean var2) throws IOException;

    private static class DebugTraceInfoStack {
        private final List<String> stack = new ArrayList<String>();

        DebugTraceInfoStack() {
        }

        void clear() {
            this.stack.clear();
        }

        void pop() {
            this.stack.remove(this.stack.size() - 1);
        }

        void push(String entry) {
            this.stack.add("\t- " + entry);
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            if (!this.stack.isEmpty()) {
                for (int i = this.stack.size(); i > 0; --i) {
                    buffer.append(this.stack.get(i - 1) + (i != 1 ? "\n" : ""));
                }
            }
            return buffer.toString();
        }
    }

    private static class ReplaceTable {
        private final HandleTable htab;
        private Object[] reps;

        ReplaceTable(int initialCapacity, float loadFactor) {
            this.htab = new HandleTable(initialCapacity, loadFactor);
            this.reps = new Object[initialCapacity];
        }

        void assign(Object obj, Object rep) {
            int index = this.htab.assign(obj);
            while (index >= this.reps.length) {
                this.grow();
            }
            this.reps[index] = rep;
        }

        Object lookup(Object obj) {
            int index = this.htab.lookup(obj);
            return index >= 0 ? this.reps[index] : obj;
        }

        void clear() {
            Arrays.fill(this.reps, 0, this.htab.size(), null);
            this.htab.clear();
        }

        int size() {
            return this.htab.size();
        }

        private void grow() {
            Object[] newReps = new Object[(this.reps.length << 1) + 1];
            System.arraycopy(this.reps, 0, newReps, 0, this.reps.length);
            this.reps = newReps;
        }
    }

    private static class HandleTable {
        private int size;
        private int threshold;
        private final float loadFactor;
        private int[] spine;
        private int[] next;
        private Object[] objs;

        HandleTable(int initialCapacity, float loadFactor) {
            this.loadFactor = loadFactor;
            this.spine = new int[initialCapacity];
            this.next = new int[initialCapacity];
            this.objs = new Object[initialCapacity];
            this.threshold = (int)((float)initialCapacity * loadFactor);
            this.clear();
        }

        int assign(Object obj) {
            if (this.size >= this.next.length) {
                this.growEntries();
            }
            if (this.size >= this.threshold) {
                this.growSpine();
            }
            this.insert(obj, this.size);
            return this.size++;
        }

        int lookup(Object obj) {
            if (this.size == 0) {
                return -1;
            }
            int index = this.hash(obj) % this.spine.length;
            int i = this.spine[index];
            while (i >= 0) {
                if (this.objs[i] == obj) {
                    return i;
                }
                i = this.next[i];
            }
            return -1;
        }

        void clear() {
            Arrays.fill(this.spine, -1);
            Arrays.fill(this.objs, 0, this.size, null);
            this.size = 0;
        }

        int size() {
            return this.size;
        }

        private void insert(Object obj, int handle) {
            int index = this.hash(obj) % this.spine.length;
            this.objs[handle] = obj;
            this.next[handle] = this.spine[index];
            this.spine[index] = handle;
        }

        private void growSpine() {
            this.spine = new int[(this.spine.length << 1) + 1];
            this.threshold = (int)((float)this.spine.length * this.loadFactor);
            Arrays.fill(this.spine, -1);
            for (int i = 0; i < this.size; ++i) {
                this.insert(this.objs[i], i);
            }
        }

        private void growEntries() {
            int newLength = (this.next.length << 1) + 1;
            int[] newNext = new int[newLength];
            System.arraycopy(this.next, 0, newNext, 0, this.size);
            this.next = newNext;
            Object[] newObjs = new Object[newLength];
            System.arraycopy(this.objs, 0, newObjs, 0, this.size);
            this.objs = newObjs;
        }

        private int hash(Object obj) {
            return System.identityHashCode(obj) & Integer.MAX_VALUE;
        }
    }

    private static class BlockDataOutputStream
    extends OutputStream {
        private static final int MAX_BLOCK_SIZE = 1024;
        private static final int MAX_HEADER_SIZE = 5;
        private static final int CHAR_BUF_SIZE = 256;
        private final byte[] buf = new byte[1024];
        private final byte[] hbuf = new byte[5];
        private final char[] cbuf = new char[256];
        private boolean blkmode = false;
        private int pos = 0;
        private final OutputStream out;
        private final DataOutputStream dout;

        BlockDataOutputStream(OutputStream out) {
            this.out = out;
            this.dout = new DataOutputStream(this);
        }

        boolean setBlockDataMode(boolean mode) throws IOException {
            if (this.blkmode == mode) {
                return this.blkmode;
            }
            this.drain();
            this.blkmode = mode;
            return !this.blkmode;
        }

        boolean getBlockDataMode() {
            return this.blkmode;
        }

        @Override
        public void write(int b) throws IOException {
            if (this.pos >= 1024) {
                this.drain();
            }
            this.buf[this.pos++] = (byte)b;
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length, false);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.write(b, off, len, false);
        }

        @Override
        public void flush() throws IOException {
            this.drain();
            this.out.flush();
        }

        @Override
        public void close() throws IOException {
            this.flush();
            this.out.close();
        }

        void write(byte[] b, int off, int len, boolean copy) throws IOException {
            if (!copy && !this.blkmode) {
                this.drain();
                this.out.write(b, off, len);
                return;
            }
            while (len > 0) {
                if (this.pos >= 1024) {
                    this.drain();
                }
                if (len >= 1024 && !copy && this.pos == 0) {
                    this.writeBlockHeader(1024);
                    this.out.write(b, off, 1024);
                    off += 1024;
                    len -= 1024;
                    continue;
                }
                int wlen = Math.min(len, 1024 - this.pos);
                System.arraycopy(b, off, this.buf, this.pos, wlen);
                this.pos += wlen;
                off += wlen;
                len -= wlen;
            }
        }

        void drain() throws IOException {
            if (this.pos == 0) {
                return;
            }
            if (this.blkmode) {
                this.writeBlockHeader(this.pos);
            }
            this.out.write(this.buf, 0, this.pos);
            this.pos = 0;
        }

        private void writeBlockHeader(int len) throws IOException {
            if (len <= 255) {
                this.hbuf[0] = 119;
                this.hbuf[1] = (byte)len;
                this.out.write(this.hbuf, 0, 2);
            } else {
                this.hbuf[0] = 122;
                Bits.putInt((byte[])this.hbuf, (int)1, (int)len);
                this.out.write(this.hbuf, 0, 5);
            }
        }

        public void writeBoolean(boolean v) throws IOException {
            if (this.pos >= 1024) {
                this.drain();
            }
            Bits.putBoolean((byte[])this.buf, (int)this.pos++, (boolean)v);
        }

        public void writeByte(int v) throws IOException {
            if (this.pos >= 1024) {
                this.drain();
            }
            this.buf[this.pos++] = (byte)v;
        }

        public void writeChar(int v) throws IOException {
            if (this.pos + 2 <= 1024) {
                Bits.putChar((byte[])this.buf, (int)this.pos, (char)((char)v));
                this.pos += 2;
            } else {
                this.dout.writeChar(v);
            }
        }

        public void writeShort(int v) throws IOException {
            if (this.pos + 2 <= 1024) {
                Bits.putShort((byte[])this.buf, (int)this.pos, (short)((short)v));
                this.pos += 2;
            } else {
                this.dout.writeShort(v);
            }
        }

        public void writeInt(int v) throws IOException {
            if (this.pos + 4 <= 1024) {
                Bits.putInt((byte[])this.buf, (int)this.pos, (int)v);
                this.pos += 4;
            } else {
                this.dout.writeInt(v);
            }
        }

        public void writeFloat(float v) throws IOException {
            if (this.pos + 4 <= 1024) {
                Bits.putFloat((byte[])this.buf, (int)this.pos, (float)v);
                this.pos += 4;
            } else {
                this.dout.writeFloat(v);
            }
        }

        public void writeLong(long v) throws IOException {
            if (this.pos + 8 <= 1024) {
                Bits.putLong((byte[])this.buf, (int)this.pos, (long)v);
                this.pos += 8;
            } else {
                this.dout.writeLong(v);
            }
        }

        public void writeDouble(double v) throws IOException {
            if (this.pos + 8 <= 1024) {
                Bits.putDouble((byte[])this.buf, (int)this.pos, (double)v);
                this.pos += 8;
            } else {
                this.dout.writeDouble(v);
            }
        }

        public void writeBytes(String s) throws IOException {
            int n;
            int endoff = s.length();
            int cpos = 0;
            int csize = 0;
            for (int off = 0; off < endoff; off += n) {
                if (cpos >= csize) {
                    cpos = 0;
                    csize = Math.min(endoff - off, 256);
                    s.getChars(off, off + csize, this.cbuf, 0);
                }
                if (this.pos >= 1024) {
                    this.drain();
                }
                n = Math.min(csize - cpos, 1024 - this.pos);
                int stop = this.pos + n;
                while (this.pos < stop) {
                    this.buf[this.pos++] = (byte)this.cbuf[cpos++];
                }
            }
        }

        public void writeChars(String s) throws IOException {
            int csize;
            int endoff = s.length();
            for (int off = 0; off < endoff; off += csize) {
                csize = Math.min(endoff - off, 256);
                s.getChars(off, off + csize, this.cbuf, 0);
                this.writeChars(this.cbuf, 0, csize);
            }
        }

        public void writeUTF(String s) throws IOException {
            this.writeUTF(s, this.getUTFLength(s));
        }

        void writeBooleans(boolean[] v, int off, int len) throws IOException {
            int endoff = off + len;
            while (off < endoff) {
                if (this.pos >= 1024) {
                    this.drain();
                }
                int stop = Math.min(endoff, off + (1024 - this.pos));
                while (off < stop) {
                    Bits.putBoolean((byte[])this.buf, (int)this.pos++, (boolean)v[off++]);
                }
            }
        }

        void writeChars(char[] v, int off, int len) throws IOException {
            int limit = 1022;
            int endoff = off + len;
            while (off < endoff) {
                if (this.pos <= limit) {
                    int avail = 1024 - this.pos >> 1;
                    int stop = Math.min(endoff, off + avail);
                    while (off < stop) {
                        Bits.putChar((byte[])this.buf, (int)this.pos, (char)v[off++]);
                        this.pos += 2;
                    }
                    continue;
                }
                this.dout.writeChar(v[off++]);
            }
        }

        void writeShorts(short[] v, int off, int len) throws IOException {
            int limit = 1022;
            int endoff = off + len;
            while (off < endoff) {
                if (this.pos <= limit) {
                    int avail = 1024 - this.pos >> 1;
                    int stop = Math.min(endoff, off + avail);
                    while (off < stop) {
                        Bits.putShort((byte[])this.buf, (int)this.pos, (short)v[off++]);
                        this.pos += 2;
                    }
                    continue;
                }
                this.dout.writeShort(v[off++]);
            }
        }

        void writeInts(int[] v, int off, int len) throws IOException {
            int limit = 1020;
            int endoff = off + len;
            while (off < endoff) {
                if (this.pos <= limit) {
                    int avail = 1024 - this.pos >> 2;
                    int stop = Math.min(endoff, off + avail);
                    while (off < stop) {
                        Bits.putInt((byte[])this.buf, (int)this.pos, (int)v[off++]);
                        this.pos += 4;
                    }
                    continue;
                }
                this.dout.writeInt(v[off++]);
            }
        }

        void writeFloats(float[] v, int off, int len) throws IOException {
            int limit = 1020;
            int endoff = off + len;
            while (off < endoff) {
                if (this.pos <= limit) {
                    int avail = 1024 - this.pos >> 2;
                    int chunklen = Math.min(endoff - off, avail);
                    ObjectOutputStream.floatsToBytes(v, off, this.buf, this.pos, chunklen);
                    off += chunklen;
                    this.pos += chunklen << 2;
                    continue;
                }
                this.dout.writeFloat(v[off++]);
            }
        }

        void writeLongs(long[] v, int off, int len) throws IOException {
            int limit = 1016;
            int endoff = off + len;
            while (off < endoff) {
                if (this.pos <= limit) {
                    int avail = 1024 - this.pos >> 3;
                    int stop = Math.min(endoff, off + avail);
                    while (off < stop) {
                        Bits.putLong((byte[])this.buf, (int)this.pos, (long)v[off++]);
                        this.pos += 8;
                    }
                    continue;
                }
                this.dout.writeLong(v[off++]);
            }
        }

        void writeDoubles(double[] v, int off, int len) throws IOException {
            int limit = 1016;
            int endoff = off + len;
            while (off < endoff) {
                if (this.pos <= limit) {
                    int avail = 1024 - this.pos >> 3;
                    int chunklen = Math.min(endoff - off, avail);
                    ObjectOutputStream.doublesToBytes(v, off, this.buf, this.pos, chunklen);
                    off += chunklen;
                    this.pos += chunklen << 3;
                    continue;
                }
                this.dout.writeDouble(v[off++]);
            }
        }

        long getUTFLength(String s) {
            int csize;
            int len = s.length();
            long utflen = 0L;
            for (int off = 0; off < len; off += csize) {
                csize = Math.min(len - off, 256);
                s.getChars(off, off + csize, this.cbuf, 0);
                for (int cpos = 0; cpos < csize; ++cpos) {
                    char c = this.cbuf[cpos];
                    if (c >= '\u0001' && c <= '\u007f') {
                        ++utflen;
                        continue;
                    }
                    if (c > '\u07ff') {
                        utflen += 3L;
                        continue;
                    }
                    utflen += 2L;
                }
            }
            return utflen;
        }

        void writeUTF(String s, long utflen) throws IOException {
            if (utflen > 65535L) {
                throw new UTFDataFormatException();
            }
            this.writeShort((int)utflen);
            if (utflen == (long)s.length()) {
                this.writeBytes(s);
            } else {
                this.writeUTFBody(s);
            }
        }

        void writeLongUTF(String s) throws IOException {
            this.writeLongUTF(s, this.getUTFLength(s));
        }

        void writeLongUTF(String s, long utflen) throws IOException {
            this.writeLong(utflen);
            if (utflen == (long)s.length()) {
                this.writeBytes(s);
            } else {
                this.writeUTFBody(s);
            }
        }

        private void writeUTFBody(String s) throws IOException {
            int csize;
            int limit = 1021;
            int len = s.length();
            for (int off = 0; off < len; off += csize) {
                csize = Math.min(len - off, 256);
                s.getChars(off, off + csize, this.cbuf, 0);
                for (int cpos = 0; cpos < csize; ++cpos) {
                    char c = this.cbuf[cpos];
                    if (this.pos <= limit) {
                        if (c <= '\u007f' && c != '\u0000') {
                            this.buf[this.pos++] = (byte)c;
                            continue;
                        }
                        if (c > '\u07ff') {
                            this.buf[this.pos + 2] = (byte)(0x80 | c >> 0 & 0x3F);
                            this.buf[this.pos + 1] = (byte)(0x80 | c >> 6 & 0x3F);
                            this.buf[this.pos + 0] = (byte)(0xE0 | c >> 12 & 0xF);
                            this.pos += 3;
                            continue;
                        }
                        this.buf[this.pos + 1] = (byte)(0x80 | c >> 0 & 0x3F);
                        this.buf[this.pos + 0] = (byte)(0xC0 | c >> 6 & 0x1F);
                        this.pos += 2;
                        continue;
                    }
                    if (c <= '\u007f' && c != '\u0000') {
                        this.write(c);
                        continue;
                    }
                    if (c > '\u07ff') {
                        this.write(0xE0 | c >> 12 & 0xF);
                        this.write(0x80 | c >> 6 & 0x3F);
                        this.write(0x80 | c >> 0 & 0x3F);
                        continue;
                    }
                    this.write(0xC0 | c >> 6 & 0x1F);
                    this.write(0x80 | c >> 0 & 0x3F);
                }
            }
        }
    }

    private class PutFieldImpl
    extends PutField {
        private final ObjectStreamClass desc;
        private final byte[] primVals;
        private final Object[] objVals;

        PutFieldImpl(ObjectStreamClass desc) {
            this.desc = desc;
            this.primVals = new byte[desc.getPrimDataSize()];
            this.objVals = new Object[desc.getNumObjFields()];
        }

        @Override
        public void put(String name, boolean val) {
            Bits.putBoolean((byte[])this.primVals, (int)this.getFieldOffset(name, Boolean.TYPE), (boolean)val);
        }

        @Override
        public void put(String name, byte val) {
            this.primVals[this.getFieldOffset((String)name, Byte.TYPE)] = val;
        }

        @Override
        public void put(String name, char val) {
            Bits.putChar((byte[])this.primVals, (int)this.getFieldOffset(name, Character.TYPE), (char)val);
        }

        @Override
        public void put(String name, short val) {
            Bits.putShort((byte[])this.primVals, (int)this.getFieldOffset(name, Short.TYPE), (short)val);
        }

        @Override
        public void put(String name, int val) {
            Bits.putInt((byte[])this.primVals, (int)this.getFieldOffset(name, Integer.TYPE), (int)val);
        }

        @Override
        public void put(String name, float val) {
            Bits.putFloat((byte[])this.primVals, (int)this.getFieldOffset(name, Float.TYPE), (float)val);
        }

        @Override
        public void put(String name, long val) {
            Bits.putLong((byte[])this.primVals, (int)this.getFieldOffset(name, Long.TYPE), (long)val);
        }

        @Override
        public void put(String name, double val) {
            Bits.putDouble((byte[])this.primVals, (int)this.getFieldOffset(name, Double.TYPE), (double)val);
        }

        @Override
        public void put(String name, Object val) {
            this.objVals[this.getFieldOffset((String)name, Object.class)] = val;
        }

        @Override
        public void write(ObjectOutput out) throws IOException {
            if (ObjectOutputStream.this != out) {
                throw new IllegalArgumentException("wrong stream");
            }
            out.write(this.primVals, 0, this.primVals.length);
            ObjectStreamField[] fields = this.desc.getFields(false);
            int numPrimFields = fields.length - this.objVals.length;
            for (int i = 0; i < this.objVals.length; ++i) {
                if (fields[numPrimFields + i].isUnshared()) {
                    throw new IOException("cannot write unshared object");
                }
                out.writeObject(this.objVals[i]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void writeFields() throws IOException {
            ObjectOutputStream.this.bout.write(this.primVals, 0, this.primVals.length, false);
            ObjectStreamField[] fields = this.desc.getFields(false);
            int numPrimFields = fields.length - this.objVals.length;
            for (int i = 0; i < this.objVals.length; ++i) {
                if (extendedDebugInfo) {
                    ObjectOutputStream.this.debugInfoStack.push("field (class \"" + this.desc.getName() + "\", name: \"" + fields[numPrimFields + i].getName() + "\", type: \"" + fields[numPrimFields + i].getType() + "\")");
                }
                try {
                    ObjectOutputStream.access$300(ObjectOutputStream.this, this.objVals[i], fields[numPrimFields + i].isUnshared());
                    continue;
                }
                finally {
                    if (extendedDebugInfo) {
                        ObjectOutputStream.this.debugInfoStack.pop();
                    }
                }
            }
        }

        private int getFieldOffset(String name, Class type) {
            ObjectStreamField field = this.desc.getField(name, type);
            if (field == null) {
                throw new IllegalArgumentException("no such field " + name + " with type " + type);
            }
            return field.getOffset();
        }
    }

    public static abstract class PutField {
        public abstract void put(String var1, boolean var2);

        public abstract void put(String var1, byte var2);

        public abstract void put(String var1, char var2);

        public abstract void put(String var1, short var2);

        public abstract void put(String var1, int var2);

        public abstract void put(String var1, long var2);

        public abstract void put(String var1, float var2);

        public abstract void put(String var1, double var2);

        public abstract void put(String var1, Object var2);

        @Deprecated
        public abstract void write(ObjectOutput var1) throws IOException;
    }

    private static class Caches {
        static final ConcurrentMap<ObjectStreamClass.WeakClassKey, Boolean> subclassAudits = new ConcurrentHashMap<ObjectStreamClass.WeakClassKey, Boolean>();
        static final ReferenceQueue<Class<?>> subclassAuditsQueue = new ReferenceQueue();

        private Caches() {
        }
    }
}

