/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.Bits;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.InvalidObjectException;
import java.io.NotActiveException;
import java.io.ObjectInput;
import java.io.ObjectInputValidation;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamField;
import java.io.OptionalDataException;
import java.io.SerialCallbackContext;
import java.io.StreamCorruptedException;
import java.io.WriteAbortedException;
import java.lang.ref.ReferenceQueue;
import java.lang.reflect.Array;
import java.lang.reflect.Proxy;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import sun.misc.VM;
import sun.reflect.misc.ReflectUtil;

public class ObjectInputStream
extends InputStream
implements ObjectInput {
    private static final int NULL_HANDLE = -1;
    private static final Object unsharedMarker = new Object();
    private static final HashMap<String, Class<?>> primClasses = new HashMap(8, 1.0f);
    private final BlockDataInputStream bin;
    private final ValidationList vlist;
    private int depth;
    private boolean closed;
    private final HandleTable handles;
    private int passHandle = -1;
    private boolean defaultDataEnd = false;
    private byte[] primVals;
    private final boolean enableOverride;
    private boolean enableResolve;
    private SerialCallbackContext curContext;

    public ObjectInputStream(InputStream in) throws IOException {
        this.verifySubclass();
        this.bin = new BlockDataInputStream(in);
        this.handles = new HandleTable(10);
        this.vlist = new ValidationList();
        this.enableOverride = false;
        this.readStreamHeader();
        this.bin.setBlockDataMode(true);
    }

    protected ObjectInputStream() throws IOException, SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SUBCLASS_IMPLEMENTATION_PERMISSION);
        }
        this.bin = null;
        this.handles = null;
        this.vlist = null;
        this.enableOverride = true;
    }

    @Override
    public final Object readObject() throws IOException, ClassNotFoundException;

    protected Object readObjectOverride() throws IOException, ClassNotFoundException;

    public Object readUnshared() throws IOException, ClassNotFoundException;

    public void defaultReadObject() throws IOException, ClassNotFoundException;

    public GetField readFields() throws IOException, ClassNotFoundException;

    public void registerValidation(ObjectInputValidation obj, int prio) throws NotActiveException, InvalidObjectException {
        if (this.depth == 0) {
            throw new NotActiveException("stream inactive");
        }
        this.vlist.register(obj, prio);
    }

    protected Class<?> resolveClass(ObjectStreamClass var1) throws IOException, ClassNotFoundException;

    protected Class<?> resolveProxyClass(String[] var1) throws IOException, ClassNotFoundException;

    protected Object resolveObject(Object obj) throws IOException {
        return obj;
    }

    protected boolean enableResolveObject(boolean enable) throws SecurityException {
        SecurityManager sm;
        if (enable == this.enableResolve) {
            return enable;
        }
        if (enable && (sm = System.getSecurityManager()) != null) {
            sm.checkPermission(SUBSTITUTION_PERMISSION);
        }
        this.enableResolve = enable;
        return !this.enableResolve;
    }

    protected void readStreamHeader() throws IOException, StreamCorruptedException {
        short s0 = this.bin.readShort();
        short s1 = this.bin.readShort();
        if (s0 != -21267 || s1 != 5) {
            throw new StreamCorruptedException(String.format("invalid stream header: %04X%04X", s0, s1));
        }
    }

    protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException;

    @Override
    public int read() throws IOException {
        return this.bin.read();
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        if (buf == null) {
            throw new NullPointerException();
        }
        int endoff = off + len;
        if (off < 0 || len < 0 || endoff > buf.length || endoff < 0) {
            throw new IndexOutOfBoundsException();
        }
        return this.bin.read(buf, off, len, false);
    }

    @Override
    public int available() throws IOException {
        return this.bin.available();
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        if (this.depth == 0) {
            this.clear();
        }
        this.bin.close();
    }

    public boolean readBoolean() throws IOException {
        return this.bin.readBoolean();
    }

    public byte readByte() throws IOException {
        return this.bin.readByte();
    }

    public int readUnsignedByte() throws IOException {
        return this.bin.readUnsignedByte();
    }

    public char readChar() throws IOException {
        return this.bin.readChar();
    }

    public short readShort() throws IOException {
        return this.bin.readShort();
    }

    public int readUnsignedShort() throws IOException {
        return this.bin.readUnsignedShort();
    }

    public int readInt() throws IOException {
        return this.bin.readInt();
    }

    public long readLong() throws IOException {
        return this.bin.readLong();
    }

    public float readFloat() throws IOException {
        return this.bin.readFloat();
    }

    public double readDouble() throws IOException {
        return this.bin.readDouble();
    }

    public void readFully(byte[] buf) throws IOException {
        this.bin.readFully(buf, 0, buf.length, false);
    }

    public void readFully(byte[] buf, int off, int len) throws IOException {
        int endoff = off + len;
        if (off < 0 || len < 0 || endoff > buf.length || endoff < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.bin.readFully(buf, off, len, false);
    }

    public int skipBytes(int len) throws IOException {
        return this.bin.skipBytes(len);
    }

    @Deprecated
    public String readLine() throws IOException {
        return this.bin.readLine();
    }

    public String readUTF() throws IOException {
        return this.bin.readUTF();
    }

    private void verifySubclass() {
        Class<?> cl = this.getClass();
        if (cl == ObjectInputStream.class) {
            return;
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return;
        }
        ObjectStreamClass.processQueue(Caches.subclassAuditsQueue, Caches.subclassAudits);
        ObjectStreamClass.WeakClassKey key = new ObjectStreamClass.WeakClassKey(cl, Caches.subclassAuditsQueue);
        Boolean result = (Boolean)Caches.subclassAudits.get(key);
        if (result == null) {
            result = ObjectInputStream.auditSubclass(cl);
            Caches.subclassAudits.putIfAbsent(key, result);
        }
        if (result.booleanValue()) {
            return;
        }
        sm.checkPermission(SUBCLASS_IMPLEMENTATION_PERMISSION);
    }

    private static boolean auditSubclass(final Class<?> subcl) {
        Boolean result = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                for (Class cl = subcl; cl != ObjectInputStream.class; cl = cl.getSuperclass()) {
                    try {
                        cl.getDeclaredMethod("readUnshared", null);
                        return Boolean.FALSE;
                    }
                    catch (NoSuchMethodException ex) {
                        try {
                            cl.getDeclaredMethod("readFields", null);
                            return Boolean.FALSE;
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            continue;
                        }
                    }
                }
                return Boolean.TRUE;
            }
        });
        return result;
    }

    private void clear() {
        this.handles.clear();
        this.vlist.clear();
    }

    private Object readObject0(boolean unshared) throws IOException {
        byte tc;
        boolean oldMode = this.bin.getBlockDataMode();
        if (oldMode) {
            int remain = this.bin.currentBlockRemaining();
            if (remain > 0) {
                throw new OptionalDataException(remain);
            }
            if (this.defaultDataEnd) {
                throw new OptionalDataException(true);
            }
            this.bin.setBlockDataMode(false);
        }
        while ((tc = this.bin.peekByte()) == 121) {
            this.bin.readByte();
            this.handleReset();
        }
        ++this.depth;
        try {
            switch (tc) {
                case 112: {
                    Object object = this.readNull();
                    return object;
                }
                case 113: {
                    Object object = this.readHandle(unshared);
                    return object;
                }
                case 118: {
                    Class clazz = this.readClass(unshared);
                    return clazz;
                }
                case 114: 
                case 125: {
                    ObjectStreamClass objectStreamClass = this.readClassDesc(unshared);
                    return objectStreamClass;
                }
                case 116: 
                case 124: {
                    Object object = this.checkResolve(this.readString(unshared));
                    return object;
                }
                case 117: {
                    Object object = this.checkResolve(this.readArray(unshared));
                    return object;
                }
                case 126: {
                    Object object = this.checkResolve(this.readEnum(unshared));
                    return object;
                }
                case 115: {
                    Object object = this.checkResolve(this.readOrdinaryObject(unshared));
                    return object;
                }
                case 123: {
                    IOException ex = this.readFatalException();
                    throw new WriteAbortedException("writing aborted", ex);
                }
                case 119: 
                case 122: {
                    if (oldMode) {
                        this.bin.setBlockDataMode(true);
                        this.bin.peek();
                        throw new OptionalDataException(this.bin.currentBlockRemaining());
                    }
                    throw new StreamCorruptedException("unexpected block data");
                }
                case 120: {
                    if (oldMode) {
                        throw new OptionalDataException(true);
                    }
                    throw new StreamCorruptedException("unexpected end of block data");
                }
            }
            throw new StreamCorruptedException(String.format("invalid type code: %02X", tc));
        }
        finally {
            --this.depth;
            this.bin.setBlockDataMode(oldMode);
        }
    }

    private Object checkResolve(Object obj) throws IOException {
        if (!this.enableResolve || this.handles.lookupException(this.passHandle) != null) {
            return obj;
        }
        Object rep = this.resolveObject(obj);
        if (rep != obj) {
            this.handles.setObject(this.passHandle, rep);
        }
        return rep;
    }

    String readTypeString() throws IOException {
        int oldHandle = this.passHandle;
        try {
            byte tc = this.bin.peekByte();
            switch (tc) {
                case 112: {
                    String string = (String)this.readNull();
                    return string;
                }
                case 113: {
                    String string = (String)this.readHandle(false);
                    return string;
                }
                case 116: 
                case 124: {
                    String string = this.readString(false);
                    return string;
                }
            }
            throw new StreamCorruptedException(String.format("invalid type code: %02X", tc));
        }
        finally {
            this.passHandle = oldHandle;
        }
    }

    private Object readNull() throws IOException {
        if (this.bin.readByte() != 112) {
            throw new InternalError();
        }
        this.passHandle = -1;
        return null;
    }

    private Object readHandle(boolean unshared) throws IOException {
        if (this.bin.readByte() != 113) {
            throw new InternalError();
        }
        this.passHandle = this.bin.readInt() - 0x7E0000;
        if (this.passHandle < 0 || this.passHandle >= this.handles.size()) {
            throw new StreamCorruptedException(String.format("invalid handle value: %08X", this.passHandle + 0x7E0000));
        }
        if (unshared) {
            throw new InvalidObjectException("cannot read back reference as unshared");
        }
        Object obj = this.handles.lookupObject(this.passHandle);
        if (obj == unsharedMarker) {
            throw new InvalidObjectException("cannot read back reference to unshared object");
        }
        return obj;
    }

    private Class readClass(boolean unshared) throws IOException {
        if (this.bin.readByte() != 118) {
            throw new InternalError();
        }
        ObjectStreamClass desc = this.readClassDesc(false);
        Class<?> cl = desc.forClass();
        this.passHandle = this.handles.assign(unshared ? unsharedMarker : cl);
        ClassNotFoundException resolveEx = desc.getResolveException();
        if (resolveEx != null) {
            this.handles.markException(this.passHandle, resolveEx);
        }
        this.handles.finish(this.passHandle);
        return cl;
    }

    private ObjectStreamClass readClassDesc(boolean unshared) throws IOException {
        byte tc = this.bin.peekByte();
        switch (tc) {
            case 112: {
                return (ObjectStreamClass)this.readNull();
            }
            case 113: {
                return (ObjectStreamClass)this.readHandle(unshared);
            }
            case 125: {
                return this.readProxyDesc(unshared);
            }
            case 114: {
                return this.readNonProxyDesc(unshared);
            }
        }
        throw new StreamCorruptedException(String.format("invalid type code: %02X", tc));
    }

    private boolean isCustomSubclass() {
        return this.getClass().getClassLoader() != ObjectInputStream.class.getClassLoader();
    }

    private ObjectStreamClass readProxyDesc(boolean unshared) throws IOException {
        if (this.bin.readByte() != 125) {
            throw new InternalError();
        }
        ObjectStreamClass desc = new ObjectStreamClass();
        int descHandle = this.handles.assign(unshared ? unsharedMarker : desc);
        this.passHandle = -1;
        int numIfaces = this.bin.readInt();
        String[] ifaces = new String[numIfaces];
        for (int i = 0; i < numIfaces; ++i) {
            ifaces[i] = this.bin.readUTF();
        }
        Class<?> cl = null;
        ClassNotFoundException resolveEx = null;
        this.bin.setBlockDataMode(true);
        try {
            cl = this.resolveProxyClass(ifaces);
            if (cl == null) {
                resolveEx = new ClassNotFoundException("null class");
            } else {
                if (!Proxy.isProxyClass(cl)) {
                    throw new InvalidClassException("Not a proxy");
                }
                ReflectUtil.checkProxyPackageAccess(this.getClass().getClassLoader(), cl.getInterfaces());
            }
        }
        catch (ClassNotFoundException ex) {
            resolveEx = ex;
        }
        this.skipCustomData();
        desc.initProxy(cl, resolveEx, this.readClassDesc(false));
        this.handles.finish(descHandle);
        this.passHandle = descHandle;
        return desc;
    }

    private ObjectStreamClass readNonProxyDesc(boolean unshared) throws IOException {
        if (this.bin.readByte() != 114) {
            throw new InternalError();
        }
        ObjectStreamClass desc = new ObjectStreamClass();
        int descHandle = this.handles.assign(unshared ? unsharedMarker : desc);
        this.passHandle = -1;
        ObjectStreamClass readDesc = null;
        try {
            readDesc = this.readClassDescriptor();
        }
        catch (ClassNotFoundException ex) {
            throw (IOException)new InvalidClassException("failed to read class descriptor").initCause((Throwable)((Object)ex));
        }
        Class<?> cl = null;
        ClassNotFoundException resolveEx = null;
        this.bin.setBlockDataMode(true);
        boolean checksRequired = this.isCustomSubclass();
        try {
            cl = this.resolveClass(readDesc);
            if (cl == null) {
                resolveEx = new ClassNotFoundException("null class");
            } else if (checksRequired) {
                ReflectUtil.checkPackageAccess(cl);
            }
        }
        catch (ClassNotFoundException ex) {
            resolveEx = ex;
        }
        this.skipCustomData();
        desc.initNonProxy(readDesc, cl, resolveEx, this.readClassDesc(false));
        this.handles.finish(descHandle);
        this.passHandle = descHandle;
        return desc;
    }

    private String readString(boolean unshared) throws IOException {
        String str;
        byte tc = this.bin.readByte();
        switch (tc) {
            case 116: {
                str = this.bin.readUTF();
                break;
            }
            case 124: {
                str = this.bin.readLongUTF();
                break;
            }
            default: {
                throw new StreamCorruptedException(String.format("invalid type code: %02X", tc));
            }
        }
        this.passHandle = this.handles.assign(unshared ? unsharedMarker : str);
        this.handles.finish(this.passHandle);
        return str;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object readArray(boolean unshared) throws IOException {
        if (this.bin.readByte() != 117) {
            throw new InternalError();
        }
        ObjectStreamClass desc = this.readClassDesc(false);
        int len = this.bin.readInt();
        Object array = null;
        Class<?> ccl = null;
        Class<?> cl = desc.forClass();
        if (cl != null) {
            ccl = cl.getComponentType();
            array = Array.newInstance(ccl, len);
        }
        int arrayHandle = this.handles.assign(unshared ? unsharedMarker : array);
        ClassNotFoundException resolveEx = desc.getResolveException();
        if (resolveEx != null) {
            this.handles.markException(arrayHandle, resolveEx);
        }
        if (ccl == null) {
            for (int i = 0; i < len; ++i) {
                this.readObject0(false);
            }
        } else if (ccl.isPrimitive()) {
            if (ccl == Integer.TYPE) {
                this.bin.readInts((int[])array, 0, len);
            } else if (ccl == Byte.TYPE) {
                this.bin.readFully((byte[])array, 0, len, true);
            } else if (ccl == Long.TYPE) {
                this.bin.readLongs((long[])array, 0, len);
            } else if (ccl == Float.TYPE) {
                this.bin.readFloats((float[])array, 0, len);
            } else if (ccl == Double.TYPE) {
                this.bin.readDoubles((double[])array, 0, len);
            } else if (ccl == Short.TYPE) {
                this.bin.readShorts((short[])array, 0, len);
            } else if (ccl == Character.TYPE) {
                this.bin.readChars((char[])array, 0, len);
            } else {
                if (ccl != Boolean.TYPE) throw new InternalError();
                this.bin.readBooleans((boolean[])array, 0, len);
            }
        } else {
            Object[] oa = (Object[])array;
            for (int i = 0; i < len; ++i) {
                oa[i] = this.readObject0(false);
                this.handles.markDependency(arrayHandle, this.passHandle);
            }
        }
        this.handles.finish(arrayHandle);
        this.passHandle = arrayHandle;
        return array;
    }

    private Enum readEnum(boolean unshared) throws IOException {
        if (this.bin.readByte() != 126) {
            throw new InternalError();
        }
        ObjectStreamClass desc = this.readClassDesc(false);
        if (!desc.isEnum()) {
            throw new InvalidClassException("non-enum class: " + desc);
        }
        int enumHandle = this.handles.assign(unshared ? unsharedMarker : null);
        ClassNotFoundException resolveEx = desc.getResolveException();
        if (resolveEx != null) {
            this.handles.markException(enumHandle, resolveEx);
        }
        String name = this.readString(false);
        Enum en = null;
        Class<?> cl = desc.forClass();
        if (cl != null) {
            try {
                en = (Enum)Enum.valueOf(cl, name);
            }
            catch (IllegalArgumentException ex) {
                throw (IOException)new InvalidObjectException("enum constant " + name + " does not exist in " + cl).initCause(ex);
            }
            if (!unshared) {
                this.handles.setObject(enumHandle, en);
            }
        }
        this.handles.finish(enumHandle);
        this.passHandle = enumHandle;
        return en;
    }

    private Object readOrdinaryObject(boolean unshared) throws IOException {
        Object obj;
        if (this.bin.readByte() != 115) {
            throw new InternalError();
        }
        ObjectStreamClass desc = this.readClassDesc(false);
        desc.checkDeserialize();
        Class<?> cl = desc.forClass();
        if (cl == String.class || cl == Class.class || cl == ObjectStreamClass.class) {
            throw new InvalidClassException("invalid class descriptor");
        }
        try {
            obj = desc.isInstantiable() ? desc.newInstance() : null;
        }
        catch (Exception ex) {
            throw (IOException)new InvalidClassException(desc.forClass().getName(), "unable to create instance").initCause(ex);
        }
        this.passHandle = this.handles.assign(unshared ? unsharedMarker : obj);
        ClassNotFoundException resolveEx = desc.getResolveException();
        if (resolveEx != null) {
            this.handles.markException(this.passHandle, resolveEx);
        }
        if (desc.isExternalizable()) {
            this.readExternalData((Externalizable)obj, desc);
        } else {
            this.readSerialData(obj, desc);
        }
        this.handles.finish(this.passHandle);
        if (obj != null && this.handles.lookupException(this.passHandle) == null && desc.hasReadResolveMethod()) {
            Object rep = desc.invokeReadResolve(obj);
            if (unshared && rep.getClass().isArray()) {
                rep = ObjectInputStream.cloneArray(rep);
            }
            if (rep != obj) {
                obj = rep;
                this.handles.setObject(this.passHandle, obj);
            }
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readExternalData(Externalizable obj, ObjectStreamClass desc) throws IOException {
        SerialCallbackContext oldContext = this.curContext;
        this.curContext = null;
        try {
            boolean blocked = desc.hasBlockExternalData();
            if (blocked) {
                this.bin.setBlockDataMode(true);
            }
            if (obj != null) {
                try {
                    obj.readExternal(this);
                }
                catch (ClassNotFoundException ex) {
                    this.handles.markException(this.passHandle, ex);
                }
            }
            if (blocked) {
                this.skipCustomData();
            }
        }
        finally {
            this.curContext = oldContext;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readSerialData(Object obj, ObjectStreamClass desc) throws IOException {
        ObjectStreamClass.ClassDataSlot[] slots = desc.getClassDataLayout();
        for (int i = 0; i < slots.length; ++i) {
            ObjectStreamClass slotDesc = slots[i].desc;
            if (slots[i].hasData) {
                if (obj != null && slotDesc.hasReadObjectMethod() && this.handles.lookupException(this.passHandle) == null) {
                    SerialCallbackContext oldContext = this.curContext;
                    try {
                        this.curContext = new SerialCallbackContext(obj, slotDesc);
                        this.bin.setBlockDataMode(true);
                        slotDesc.invokeReadObject(obj, this);
                    }
                    catch (ClassNotFoundException ex) {
                        this.handles.markException(this.passHandle, ex);
                    }
                    finally {
                        this.curContext.setUsed();
                        this.curContext = oldContext;
                    }
                    this.defaultDataEnd = false;
                } else {
                    this.defaultReadFields(obj, slotDesc);
                }
                if (slotDesc.hasWriteObjectData()) {
                    this.skipCustomData();
                    continue;
                }
                this.bin.setBlockDataMode(false);
                continue;
            }
            if (obj == null || !slotDesc.hasReadObjectNoDataMethod() || this.handles.lookupException(this.passHandle) != null) continue;
            slotDesc.invokeReadObjectNoData(obj);
        }
    }

    private void skipCustomData() throws IOException {
        int oldHandle = this.passHandle;
        block4: while (true) {
            if (this.bin.getBlockDataMode()) {
                this.bin.skipBlockData();
                this.bin.setBlockDataMode(false);
            }
            switch (this.bin.peekByte()) {
                case 119: 
                case 122: {
                    this.bin.setBlockDataMode(true);
                    continue block4;
                }
                case 120: {
                    this.bin.readByte();
                    this.passHandle = oldHandle;
                    return;
                }
            }
            this.readObject0(false);
        }
    }

    private void defaultReadFields(Object obj, ObjectStreamClass desc) throws IOException {
        Class<?> cl = desc.forClass();
        if (cl != null && obj != null && !cl.isInstance(obj)) {
            throw new ClassCastException();
        }
        int primDataSize = desc.getPrimDataSize();
        if (this.primVals == null || this.primVals.length < primDataSize) {
            this.primVals = new byte[primDataSize];
        }
        this.bin.readFully(this.primVals, 0, primDataSize, false);
        if (obj != null) {
            desc.setPrimFieldValues(obj, this.primVals);
        }
        int objHandle = this.passHandle;
        ObjectStreamField[] fields = desc.getFields(false);
        Object[] objVals = new Object[desc.getNumObjFields()];
        int numPrimFields = fields.length - objVals.length;
        for (int i = 0; i < objVals.length; ++i) {
            ObjectStreamField f = fields[numPrimFields + i];
            objVals[i] = this.readObject0(f.isUnshared());
            if (f.getField() == null) continue;
            this.handles.markDependency(objHandle, this.passHandle);
        }
        if (obj != null) {
            desc.setObjFieldValues(obj, objVals);
        }
        this.passHandle = objHandle;
    }

    private IOException readFatalException() throws IOException {
        if (this.bin.readByte() != 123) {
            throw new InternalError();
        }
        this.clear();
        return (IOException)this.readObject0(false);
    }

    private void handleReset() throws StreamCorruptedException {
        if (this.depth > 0) {
            throw new StreamCorruptedException("unexpected reset; recursion depth: " + this.depth);
        }
        this.clear();
    }

    private static native void bytesToFloats(byte[] var0, int var1, float[] var2, int var3, int var4);

    private static native void bytesToDoubles(byte[] var0, int var1, double[] var2, int var3, int var4);

    private static ClassLoader latestUserDefinedLoader() {
        return VM.latestUserDefinedLoader();
    }

    private static Object cloneArray(Object array) {
        if (array instanceof Object[]) {
            return ((Object[])array).clone();
        }
        if (array instanceof boolean[]) {
            return ((boolean[])array).clone();
        }
        if (array instanceof byte[]) {
            return ((byte[])array).clone();
        }
        if (array instanceof char[]) {
            return ((char[])array).clone();
        }
        if (array instanceof double[]) {
            return ((double[])array).clone();
        }
        if (array instanceof float[]) {
            return ((float[])array).clone();
        }
        if (array instanceof int[]) {
            return ((int[])array).clone();
        }
        if (array instanceof long[]) {
            return ((long[])array).clone();
        }
        if (array instanceof short[]) {
            return ((short[])array).clone();
        }
        throw new AssertionError();
    }

    static /* synthetic */ boolean access$500(ObjectInputStream x0) {
        return x0.defaultDataEnd;
    }

    static /* synthetic */ void access$600(ObjectInputStream x0) throws StreamCorruptedException {
        x0.handleReset();
    }

    static /* synthetic */ void access$700(byte[] x0, int x1, float[] x2, int x3, int x4) {
        ObjectInputStream.bytesToFloats(x0, x1, x2, x3, x4);
    }

    static /* synthetic */ void access$800(byte[] x0, int x1, double[] x2, int x3, int x4) {
        ObjectInputStream.bytesToDoubles(x0, x1, x2, x3, x4);
    }

    static {
        primClasses.put("boolean", Boolean.TYPE);
        primClasses.put("byte", Byte.TYPE);
        primClasses.put("char", Character.TYPE);
        primClasses.put("short", Short.TYPE);
        primClasses.put("int", Integer.TYPE);
        primClasses.put("long", Long.TYPE);
        primClasses.put("float", Float.TYPE);
        primClasses.put("double", Double.TYPE);
        primClasses.put("void", Void.TYPE);
    }

    private static class HandleTable {
        private static final byte STATUS_OK = 1;
        private static final byte STATUS_UNKNOWN = 2;
        private static final byte STATUS_EXCEPTION = 3;
        byte[] status;
        Object[] entries;
        HandleList[] deps;
        int lowDep = -1;
        int size = 0;

        HandleTable(int initialCapacity) {
            this.status = new byte[initialCapacity];
            this.entries = new Object[initialCapacity];
            this.deps = new HandleList[initialCapacity];
        }

        int assign(Object obj) {
            if (this.size >= this.entries.length) {
                this.grow();
            }
            this.status[this.size] = 2;
            this.entries[this.size] = obj;
            return this.size++;
        }

        void markDependency(int dependent, int target) {
            if (dependent == -1 || target == -1) {
                return;
            }
            block0 : switch (this.status[dependent]) {
                case 2: {
                    switch (this.status[target]) {
                        case 1: {
                            break block0;
                        }
                        case 3: {
                            this.markException(dependent, (ClassNotFoundException)this.entries[target]);
                            break block0;
                        }
                        case 2: {
                            if (this.deps[target] == null) {
                                this.deps[target] = new HandleList();
                            }
                            this.deps[target].add(dependent);
                            if (this.lowDep >= 0 && this.lowDep <= target) break block0;
                            this.lowDep = target;
                            break block0;
                        }
                        default: {
                            throw new InternalError();
                        }
                    }
                }
                case 3: {
                    break;
                }
                default: {
                    throw new InternalError();
                }
            }
        }

        void markException(int handle, ClassNotFoundException ex) {
            switch (this.status[handle]) {
                case 2: {
                    this.status[handle] = 3;
                    this.entries[handle] = ex;
                    HandleList dlist = this.deps[handle];
                    if (dlist == null) break;
                    int ndeps = dlist.size();
                    for (int i = 0; i < ndeps; ++i) {
                        this.markException(dlist.get(i), ex);
                    }
                    this.deps[handle] = null;
                    break;
                }
                case 3: {
                    break;
                }
                default: {
                    throw new InternalError();
                }
            }
        }

        void finish(int handle) {
            int end;
            if (this.lowDep < 0) {
                end = handle + 1;
            } else if (this.lowDep >= handle) {
                end = this.size;
                this.lowDep = -1;
            } else {
                return;
            }
            block4: for (int i = handle; i < end; ++i) {
                switch (this.status[i]) {
                    case 2: {
                        this.status[i] = 1;
                        this.deps[i] = null;
                        continue block4;
                    }
                    case 1: 
                    case 3: {
                        continue block4;
                    }
                    default: {
                        throw new InternalError();
                    }
                }
            }
        }

        void setObject(int handle, Object obj) {
            switch (this.status[handle]) {
                case 1: 
                case 2: {
                    this.entries[handle] = obj;
                    break;
                }
                case 3: {
                    break;
                }
                default: {
                    throw new InternalError();
                }
            }
        }

        Object lookupObject(int handle) {
            return handle != -1 && this.status[handle] != 3 ? this.entries[handle] : null;
        }

        ClassNotFoundException lookupException(int handle) {
            return handle != -1 && this.status[handle] == 3 ? (ClassNotFoundException)this.entries[handle] : null;
        }

        void clear() {
            Arrays.fill(this.status, 0, this.size, (byte)0);
            Arrays.fill(this.entries, 0, this.size, null);
            Arrays.fill(this.deps, 0, this.size, null);
            this.lowDep = -1;
            this.size = 0;
        }

        int size() {
            return this.size;
        }

        private void grow() {
            int newCapacity = (this.entries.length << 1) + 1;
            byte[] newStatus = new byte[newCapacity];
            Object[] newEntries = new Object[newCapacity];
            HandleList[] newDeps = new HandleList[newCapacity];
            System.arraycopy(this.status, 0, newStatus, 0, this.size);
            System.arraycopy(this.entries, 0, newEntries, 0, this.size);
            System.arraycopy(this.deps, 0, newDeps, 0, this.size);
            this.status = newStatus;
            this.entries = newEntries;
            this.deps = newDeps;
        }

        private static class HandleList {
            private int[] list = new int[4];
            private int size = 0;

            public void add(int handle) {
                if (this.size >= this.list.length) {
                    int[] newList = new int[this.list.length << 1];
                    System.arraycopy(this.list, 0, newList, 0, this.list.length);
                    this.list = newList;
                }
                this.list[this.size++] = handle;
            }

            public int get(int index) {
                if (index >= this.size) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                return this.list[index];
            }

            public int size() {
                return this.size;
            }
        }
    }

    private class BlockDataInputStream
    extends InputStream {
        private static final int MAX_BLOCK_SIZE = 1024;
        private static final int MAX_HEADER_SIZE = 5;
        private static final int CHAR_BUF_SIZE = 256;
        private static final int HEADER_BLOCKED = -2;
        private final byte[] buf = new byte[1024];
        private final byte[] hbuf = new byte[5];
        private final char[] cbuf = new char[256];
        private boolean blkmode = false;
        private int pos = 0;
        private int end = -1;
        private int unread = 0;
        private final PeekInputStream in;
        private final DataInputStream din;

        BlockDataInputStream(InputStream in) {
            this.in = new PeekInputStream(in);
            this.din = new DataInputStream(this);
        }

        boolean setBlockDataMode(boolean var1) throws IOException;

        boolean getBlockDataMode() {
            return this.blkmode;
        }

        void skipBlockData() throws IOException;

        private int readBlockHeader(boolean var1) throws IOException;

        private void refill() throws IOException;

        int currentBlockRemaining() {
            if (this.blkmode) {
                return this.end >= 0 ? this.end - this.pos + this.unread : 0;
            }
            throw new IllegalStateException();
        }

        int peek() throws IOException;

        byte peekByte() throws IOException;

        @Override
        public int read() throws IOException;

        @Override
        public int read(byte[] var1, int var2, int var3) throws IOException;

        @Override
        public long skip(long var1) throws IOException;

        @Override
        public int available() throws IOException;

        @Override
        public void close() throws IOException;

        int read(byte[] var1, int var2, int var3, boolean var4) throws IOException;

        public void readFully(byte[] var1) throws IOException;

        public void readFully(byte[] var1, int var2, int var3) throws IOException;

        public void readFully(byte[] var1, int var2, int var3, boolean var4) throws IOException;

        public int skipBytes(int var1) throws IOException;

        public boolean readBoolean() throws IOException;

        public byte readByte() throws IOException;

        public int readUnsignedByte() throws IOException;

        public char readChar() throws IOException;

        public short readShort() throws IOException;

        public int readUnsignedShort() throws IOException;

        public int readInt() throws IOException;

        public float readFloat() throws IOException;

        public long readLong() throws IOException;

        public double readDouble() throws IOException;

        public String readUTF() throws IOException;

        public String readLine() throws IOException;

        void readBooleans(boolean[] var1, int var2, int var3) throws IOException;

        void readChars(char[] var1, int var2, int var3) throws IOException;

        void readShorts(short[] var1, int var2, int var3) throws IOException;

        void readInts(int[] var1, int var2, int var3) throws IOException;

        void readFloats(float[] var1, int var2, int var3) throws IOException;

        void readLongs(long[] var1, int var2, int var3) throws IOException;

        void readDoubles(double[] var1, int var2, int var3) throws IOException;

        String readLongUTF() throws IOException;

        private String readUTFBody(long var1) throws IOException;

        private long readUTFSpan(StringBuilder var1, long var2) throws IOException;

        private int readUTFChar(StringBuilder var1, long var2) throws IOException;
    }

    private static class PeekInputStream
    extends InputStream {
        private final InputStream in;
        private int peekb = -1;

        PeekInputStream(InputStream in) {
            this.in = in;
        }

        int peek() throws IOException {
            return this.peekb >= 0 ? this.peekb : (this.peekb = this.in.read());
        }

        @Override
        public int read() throws IOException {
            if (this.peekb >= 0) {
                int v = this.peekb;
                this.peekb = -1;
                return v;
            }
            return this.in.read();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int n;
            if (len == 0) {
                return 0;
            }
            if (this.peekb < 0) {
                return this.in.read(b, off, len);
            }
            b[off++] = (byte)this.peekb;
            this.peekb = -1;
            return (n = this.in.read(b, off, --len)) >= 0 ? n + 1 : 1;
        }

        void readFully(byte[] b, int off, int len) throws IOException {
            int count;
            for (int n = 0; n < len; n += count) {
                count = this.read(b, off + n, len - n);
                if (count >= 0) continue;
                throw new EOFException();
            }
        }

        @Override
        public long skip(long n) throws IOException {
            if (n <= 0L) {
                return 0L;
            }
            int skipped = 0;
            if (this.peekb >= 0) {
                this.peekb = -1;
                ++skipped;
                --n;
            }
            return (long)skipped + this.skip(n);
        }

        @Override
        public int available() throws IOException {
            return this.in.available() + (this.peekb >= 0 ? 1 : 0);
        }

        @Override
        public void close() throws IOException {
            this.in.close();
        }
    }

    private static class ValidationList {
        private Callback list;

        ValidationList() {
        }

        void register(ObjectInputValidation obj, int priority) throws InvalidObjectException {
            if (obj == null) {
                throw new InvalidObjectException("null callback");
            }
            Callback prev = null;
            Callback cur = this.list;
            while (cur != null && priority < cur.priority) {
                prev = cur;
                cur = cur.next;
            }
            AccessControlContext acc = AccessController.getContext();
            if (prev != null) {
                prev.next = new Callback(obj, priority, cur, acc);
            } else {
                this.list = new Callback(obj, priority, this.list, acc);
            }
        }

        void doCallbacks() throws InvalidObjectException {
            try {
                while (this.list != null) {
                    AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                        @Override
                        public Void run() throws InvalidObjectException {
                            ((ValidationList)ValidationList.this).list.obj.validateObject();
                            return null;
                        }
                    }, this.list.acc);
                    this.list = this.list.next;
                }
            }
            catch (PrivilegedActionException ex) {
                this.list = null;
                throw (InvalidObjectException)ex.getException();
            }
        }

        public void clear() {
            this.list = null;
        }

        private static class Callback {
            final ObjectInputValidation obj;
            final int priority;
            Callback next;
            final AccessControlContext acc;

            Callback(ObjectInputValidation obj, int priority, Callback next, AccessControlContext acc) {
                this.obj = obj;
                this.priority = priority;
                this.next = next;
                this.acc = acc;
            }
        }
    }

    private class GetFieldImpl
    extends GetField {
        private final ObjectStreamClass desc;
        private final byte[] primVals;
        private final Object[] objVals;
        private final int[] objHandles;

        GetFieldImpl(ObjectStreamClass desc) {
            this.desc = desc;
            this.primVals = new byte[desc.getPrimDataSize()];
            this.objVals = new Object[desc.getNumObjFields()];
            this.objHandles = new int[this.objVals.length];
        }

        @Override
        public ObjectStreamClass getObjectStreamClass() {
            return this.desc;
        }

        @Override
        public boolean defaulted(String name) throws IOException {
            return this.getFieldOffset(name, null) < 0;
        }

        @Override
        public boolean get(String name, boolean val) throws IOException {
            int off = this.getFieldOffset(name, Boolean.TYPE);
            return off >= 0 ? Bits.getBoolean((byte[])this.primVals, (int)off) : val;
        }

        @Override
        public byte get(String name, byte val) throws IOException {
            int off = this.getFieldOffset(name, Byte.TYPE);
            return off >= 0 ? this.primVals[off] : val;
        }

        @Override
        public char get(String name, char val) throws IOException {
            int off = this.getFieldOffset(name, Character.TYPE);
            return off >= 0 ? Bits.getChar((byte[])this.primVals, (int)off) : val;
        }

        @Override
        public short get(String name, short val) throws IOException {
            int off = this.getFieldOffset(name, Short.TYPE);
            return off >= 0 ? Bits.getShort((byte[])this.primVals, (int)off) : val;
        }

        @Override
        public int get(String name, int val) throws IOException {
            int off = this.getFieldOffset(name, Integer.TYPE);
            return off >= 0 ? Bits.getInt((byte[])this.primVals, (int)off) : val;
        }

        @Override
        public float get(String name, float val) throws IOException {
            int off = this.getFieldOffset(name, Float.TYPE);
            return off >= 0 ? Bits.getFloat((byte[])this.primVals, (int)off) : val;
        }

        @Override
        public long get(String name, long val) throws IOException {
            int off = this.getFieldOffset(name, Long.TYPE);
            return off >= 0 ? Bits.getLong((byte[])this.primVals, (int)off) : val;
        }

        @Override
        public double get(String name, double val) throws IOException {
            int off = this.getFieldOffset(name, Double.TYPE);
            return off >= 0 ? Bits.getDouble((byte[])this.primVals, (int)off) : val;
        }

        @Override
        public Object get(String name, Object val) throws IOException {
            int off = this.getFieldOffset(name, Object.class);
            if (off >= 0) {
                int objHandle = this.objHandles[off];
                ObjectInputStream.this.handles.markDependency(ObjectInputStream.this.passHandle, objHandle);
                return ObjectInputStream.this.handles.lookupException(objHandle) == null ? this.objVals[off] : null;
            }
            return val;
        }

        void readFields() throws IOException {
            ObjectInputStream.this.bin.readFully(this.primVals, 0, this.primVals.length, false);
            int oldHandle = ObjectInputStream.this.passHandle;
            ObjectStreamField[] fields = this.desc.getFields(false);
            int numPrimFields = fields.length - this.objVals.length;
            for (int i = 0; i < this.objVals.length; ++i) {
                this.objVals[i] = ObjectInputStream.this.readObject0(fields[numPrimFields + i].isUnshared());
                this.objHandles[i] = ObjectInputStream.this.passHandle;
            }
            ObjectInputStream.this.passHandle = oldHandle;
        }

        private int getFieldOffset(String name, Class type) {
            ObjectStreamField field = this.desc.getField(name, type);
            if (field != null) {
                return field.getOffset();
            }
            if (this.desc.getLocalDesc().getField(name, type) != null) {
                return -1;
            }
            throw new IllegalArgumentException("no such field " + name + " with type " + type);
        }
    }

    public static abstract class GetField {
        public abstract ObjectStreamClass getObjectStreamClass();

        public abstract boolean defaulted(String var1) throws IOException;

        public abstract boolean get(String var1, boolean var2) throws IOException;

        public abstract byte get(String var1, byte var2) throws IOException;

        public abstract char get(String var1, char var2) throws IOException;

        public abstract short get(String var1, short var2) throws IOException;

        public abstract int get(String var1, int var2) throws IOException;

        public abstract long get(String var1, long var2) throws IOException;

        public abstract float get(String var1, float var2) throws IOException;

        public abstract double get(String var1, double var2) throws IOException;

        public abstract Object get(String var1, Object var2) throws IOException;
    }

    private static class Caches {
        static final ConcurrentMap<ObjectStreamClass.WeakClassKey, Boolean> subclassAudits = new ConcurrentHashMap<ObjectStreamClass.WeakClassKey, Boolean>();
        static final ReferenceQueue<Class<?>> subclassAuditsQueue = new ReferenceQueue();

        private Caches() {
        }
    }
}

