/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import sun.misc.IoTrace;
import sun.nio.ch.FileChannelImpl;

public class FileOutputStream
extends OutputStream {
    private final FileDescriptor fd;
    private final String path;
    private final boolean append;
    private FileChannel channel;
    private final Object closeLock = new Object();
    private volatile boolean closed = false;
    private static final ThreadLocal<Boolean> runningFinalize = new ThreadLocal();

    private static boolean isRunningFinalize() {
        Boolean val = runningFinalize.get();
        if (val != null) {
            return val;
        }
        return false;
    }

    public FileOutputStream(String name) throws FileNotFoundException {
        this(name != null ? new File(name) : null, false);
    }

    public FileOutputStream(String name, boolean append) throws FileNotFoundException {
        this(name != null ? new File(name) : null, append);
    }

    public FileOutputStream(File file) throws FileNotFoundException {
        this(file, false);
    }

    public FileOutputStream(File file, boolean append) throws FileNotFoundException {
        String name = file != null ? file.getPath() : null;
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkWrite(name);
        }
        if (name == null) {
            throw new NullPointerException();
        }
        if (file.isInvalid()) {
            throw new FileNotFoundException("Invalid file path");
        }
        this.fd = new FileDescriptor();
        this.append = append;
        this.path = name;
        this.fd.incrementAndGetUseCount();
        this.open(name, append);
    }

    public FileOutputStream(FileDescriptor fdObj) {
        SecurityManager security = System.getSecurityManager();
        if (fdObj == null) {
            throw new NullPointerException();
        }
        if (security != null) {
            security.checkWrite(fdObj);
        }
        this.fd = fdObj;
        this.path = null;
        this.append = false;
        this.fd.incrementAndGetUseCount();
    }

    private native void open(String var1, boolean var2) throws FileNotFoundException;

    private native void write(int var1, boolean var2) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int b) throws IOException {
        Object traceContext = IoTrace.fileWriteBegin((String)this.path);
        int bytesWritten = 0;
        try {
            this.write(b, this.append);
            bytesWritten = 1;
        }
        finally {
            IoTrace.fileWriteEnd((Object)traceContext, (long)bytesWritten);
        }
    }

    private native void writeBytes(byte[] var1, int var2, int var3, boolean var4) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] b) throws IOException {
        Object traceContext = IoTrace.fileWriteBegin((String)this.path);
        int bytesWritten = 0;
        try {
            this.writeBytes(b, 0, b.length, this.append);
            bytesWritten = b.length;
        }
        finally {
            IoTrace.fileWriteEnd((Object)traceContext, (long)bytesWritten);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        Object traceContext = IoTrace.fileWriteBegin((String)this.path);
        int bytesWritten = 0;
        try {
            this.writeBytes(b, off, len, this.append);
            bytesWritten = len;
        }
        finally {
            IoTrace.fileWriteEnd((Object)traceContext, (long)bytesWritten);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        int useCount;
        Object object = this.closeLock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        if (this.channel != null) {
            this.fd.decrementAndGetUseCount();
            this.channel.close();
        }
        if ((useCount = this.fd.decrementAndGetUseCount()) <= 0 || !FileOutputStream.isRunningFinalize()) {
            this.close0();
        }
    }

    public final FileDescriptor getFD() throws IOException {
        if (this.fd != null) {
            return this.fd;
        }
        throw new IOException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileChannel getChannel() {
        FileOutputStream fileOutputStream = this;
        synchronized (fileOutputStream) {
            if (this.channel == null) {
                this.channel = FileChannelImpl.open((FileDescriptor)this.fd, (String)this.path, (boolean)false, (boolean)true, (boolean)this.append, (Object)this);
                this.fd.incrementAndGetUseCount();
            }
            return this.channel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws IOException {
        if (this.fd != null) {
            if (this.fd == FileDescriptor.out || this.fd == FileDescriptor.err) {
                this.flush();
            } else {
                runningFinalize.set(Boolean.TRUE);
                try {
                    this.close();
                }
                finally {
                    runningFinalize.set(Boolean.FALSE);
                }
            }
        }
    }

    private native void close0() throws IOException;

    private static native void initIDs();

    static {
        FileOutputStream.initIDs();
    }
}

