/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import sun.misc.IoTrace;
import sun.nio.ch.FileChannelImpl;

public class FileInputStream
extends InputStream {
    private final FileDescriptor fd;
    private final String path;
    private FileChannel channel = null;
    private final Object closeLock = new Object();
    private volatile boolean closed = false;
    private static final ThreadLocal<Boolean> runningFinalize = new ThreadLocal();

    private static boolean isRunningFinalize() {
        Boolean val = runningFinalize.get();
        if (val != null) {
            return val;
        }
        return false;
    }

    public FileInputStream(String name) throws FileNotFoundException {
        this(name != null ? new File(name) : null);
    }

    public FileInputStream(File file) throws FileNotFoundException {
        String name = file != null ? file.getPath() : null;
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkRead(name);
        }
        if (name == null) {
            throw new NullPointerException();
        }
        if (file.isInvalid()) {
            throw new FileNotFoundException("Invalid file path");
        }
        this.fd = new FileDescriptor();
        this.fd.incrementAndGetUseCount();
        this.path = name;
        this.open(name);
    }

    public FileInputStream(FileDescriptor fdObj) {
        SecurityManager security = System.getSecurityManager();
        if (fdObj == null) {
            throw new NullPointerException();
        }
        if (security != null) {
            security.checkRead(fdObj);
        }
        this.fd = fdObj;
        this.path = null;
        this.fd.incrementAndGetUseCount();
    }

    private native void open(String var1) throws FileNotFoundException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        Object traceContext = IoTrace.fileReadBegin((String)this.path);
        int b = 0;
        try {
            b = this.read0();
            IoTrace.fileReadEnd((Object)traceContext, (long)(b == -1 ? 0L : 1L));
        }
        catch (Throwable throwable) {
            IoTrace.fileReadEnd((Object)traceContext, (long)(b == -1 ? 0L : 1L));
            throw throwable;
        }
        return b;
    }

    private native int read0() throws IOException;

    private native int readBytes(byte[] var1, int var2, int var3) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] b) throws IOException {
        long l;
        Object traceContext = IoTrace.fileReadBegin((String)this.path);
        int bytesRead = 0;
        try {
            bytesRead = this.readBytes(b, 0, b.length);
            l = bytesRead == -1 ? 0L : (long)bytesRead;
        }
        catch (Throwable throwable) {
            IoTrace.fileReadEnd((Object)traceContext, (long)(bytesRead == -1 ? 0L : (long)bytesRead));
            throw throwable;
        }
        IoTrace.fileReadEnd((Object)traceContext, (long)l);
        return bytesRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        long l;
        Object traceContext = IoTrace.fileReadBegin((String)this.path);
        int bytesRead = 0;
        try {
            bytesRead = this.readBytes(b, off, len);
            l = bytesRead == -1 ? 0L : (long)bytesRead;
        }
        catch (Throwable throwable) {
            IoTrace.fileReadEnd((Object)traceContext, (long)(bytesRead == -1 ? 0L : (long)bytesRead));
            throw throwable;
        }
        IoTrace.fileReadEnd((Object)traceContext, (long)l);
        return bytesRead;
    }

    @Override
    public native long skip(long var1) throws IOException;

    @Override
    public native int available() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        int useCount;
        Object object = this.closeLock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        if (this.channel != null) {
            this.fd.decrementAndGetUseCount();
            this.channel.close();
        }
        if ((useCount = this.fd.decrementAndGetUseCount()) <= 0 || !FileInputStream.isRunningFinalize()) {
            this.close0();
        }
    }

    public final FileDescriptor getFD() throws IOException {
        if (this.fd != null) {
            return this.fd;
        }
        throw new IOException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileChannel getChannel() {
        FileInputStream fileInputStream = this;
        synchronized (fileInputStream) {
            if (this.channel == null) {
                this.channel = FileChannelImpl.open((FileDescriptor)this.fd, (String)this.path, (boolean)true, (boolean)false, (Object)this);
                this.fd.incrementAndGetUseCount();
            }
            return this.channel;
        }
    }

    private static native void initIDs();

    private native void close0() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws IOException {
        if (this.fd != null && this.fd != FileDescriptor.in) {
            runningFinalize.set(Boolean.TRUE);
            try {
                this.close();
            }
            finally {
                runningFinalize.set(Boolean.FALSE);
            }
        }
    }

    static {
        FileInputStream.initIDs();
    }
}

