/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterators;
import java.util.WeakHashMap;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipCoder;
import java.util.zip.ZipConstants;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipUtils;
import jdk.internal.misc.JavaUtilZipFileAccess;
import jdk.internal.misc.SharedSecrets;
import jdk.internal.misc.VM;
import jdk.internal.perf.PerfCounter;

public class ZipFile
implements ZipConstants,
Closeable {
    private final String name;
    private volatile boolean closeRequested;
    private Source zsrc;
    private ZipCoder zc;
    private static final int STORED = 0;
    private static final int DEFLATED = 8;
    public static final int OPEN_READ = 1;
    public static final int OPEN_DELETE = 4;
    private final Map<InputStream, Inflater> streams = new WeakHashMap<InputStream, Inflater>();
    private final Deque<Inflater> inflaterCache = new ArrayDeque<Inflater>();
    private String lastEntryName;
    private int lastEntryPos;
    private static boolean isWindows;

    public ZipFile(String name) throws IOException {
        this(new File(name), 1);
    }

    public ZipFile(File file, int mode) throws IOException {
        this(file, mode, StandardCharsets.UTF_8);
    }

    public ZipFile(File file) throws ZipException, IOException {
        this(file, 1);
    }

    public ZipFile(File file, int mode, Charset charset) throws IOException {
        if ((mode & 1) == 0 || (mode & 0xFFFFFFFA) != 0) {
            throw new IllegalArgumentException("Illegal mode: 0x" + Integer.toHexString(mode));
        }
        String name = file.getPath();
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkRead(name);
            if ((mode & 4) != 0) {
                sm.checkDelete(name);
            }
        }
        Objects.requireNonNull(charset, "charset");
        this.zc = ZipCoder.get(charset);
        this.name = name;
        long t0 = System.nanoTime();
        this.zsrc = Source.get(file, (mode & 4) != 0);
        PerfCounter.getZipFileOpenTime().addElapsedTimeFrom(t0);
        PerfCounter.getZipFileCount().increment();
    }

    public ZipFile(String name, Charset charset) throws IOException {
        this(new File(name), 1, charset);
    }

    public ZipFile(File file, Charset charset) throws IOException {
        this(file, 1, charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getComment() {
        ZipFile zipFile = this;
        synchronized (zipFile) {
            this.ensureOpen();
            if (this.zsrc.comment == null) {
                return null;
            }
            return this.zc.toString(this.zsrc.comment);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZipEntry getEntry(String name) {
        Objects.requireNonNull(name, "name");
        ZipFile zipFile = this;
        synchronized (zipFile) {
            this.ensureOpen();
            byte[] bname = this.zc.getBytes(name);
            int pos = this.zsrc.getEntryPos(bname, true);
            if (pos != -1) {
                return this.getZipEntry(name, bname, pos);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getInputStream(ZipEntry entry) throws IOException {
        Objects.requireNonNull(entry, "entry");
        int pos = -1;
        ZipFileInputStream in = null;
        ZipFile zipFile = this;
        synchronized (zipFile) {
            this.ensureOpen();
            pos = Objects.equals(this.lastEntryName, entry.name) ? this.lastEntryPos : (!this.zc.isUTF8() && (entry.flag & 0x800) != 0 ? this.zsrc.getEntryPos(this.zc.getBytesUTF8(entry.name), false) : this.zsrc.getEntryPos(this.zc.getBytes(entry.name), false));
            if (pos == -1) {
                return null;
            }
            in = new ZipFileInputStream(this.zsrc.cen, pos);
            switch (ZipUtils.CENHOW(this.zsrc.cen, pos)) {
                case 0: {
                    Map<InputStream, Inflater> map = this.streams;
                    synchronized (map) {
                        this.streams.put(in, null);
                    }
                    return in;
                }
                case 8: {
                    long size = ZipUtils.CENLEN(this.zsrc.cen, pos) + 2L;
                    if (size > 65536L) {
                        size = 8192L;
                    }
                    if (size <= 0L) {
                        size = 4096L;
                    }
                    Inflater inf = this.getInflater();
                    ZipFileInflaterInputStream is = new ZipFileInflaterInputStream(in, inf, (int)size);
                    Map<InputStream, Inflater> map = this.streams;
                    synchronized (map) {
                        this.streams.put(is, inf);
                    }
                    return is;
                }
            }
            throw new ZipException("invalid compression method");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Inflater getInflater() {
        Deque<Inflater> deque = this.inflaterCache;
        synchronized (deque) {
            Inflater inf;
            while ((inf = this.inflaterCache.poll()) != null) {
                if (inf.ended()) continue;
                return inf;
            }
        }
        return new Inflater(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseInflater(Inflater inf) {
        if (!inf.ended()) {
            inf.reset();
            Deque<Inflater> deque = this.inflaterCache;
            synchronized (deque) {
                this.inflaterCache.add(inf);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public Enumeration<? extends ZipEntry> entries() {
        return new ZipEntryIterator();
    }

    public Stream<? extends ZipEntry> stream() {
        return StreamSupport.stream(Spliterators.spliterator(new ZipEntryIterator(), (long)this.size(), 1297), false);
    }

    private ZipEntry getZipEntry(String name, byte[] bname, int pos) {
        int start;
        byte[] cen = this.zsrc.cen;
        int nlen = ZipUtils.CENNAM(cen, pos);
        int elen = ZipUtils.CENEXT(cen, pos);
        int clen = ZipUtils.CENCOM(cen, pos);
        int flag = ZipUtils.CENFLG(cen, pos);
        if (name == null || bname.length != nlen) {
            name = !this.zc.isUTF8() && (flag & 0x800) != 0 ? this.zc.toStringUTF8(cen, pos + 46, nlen) : this.zc.toString(cen, pos + 46, nlen);
        }
        ZipEntry e = new ZipEntry(name);
        e.flag = flag;
        e.xdostime = ZipUtils.CENTIM(cen, pos);
        e.crc = ZipUtils.CENCRC(cen, pos);
        e.size = ZipUtils.CENLEN(cen, pos);
        e.csize = ZipUtils.CENSIZ(cen, pos);
        e.method = ZipUtils.CENHOW(cen, pos);
        if (elen != 0) {
            start = pos + 46 + nlen;
            e.setExtra0(Arrays.copyOfRange(cen, start, start + elen), true);
        }
        if (clen != 0) {
            start = pos + 46 + nlen + elen;
            e.comment = !this.zc.isUTF8() && (flag & 0x800) != 0 ? this.zc.toStringUTF8(cen, start, clen) : this.zc.toString(cen, start, clen);
        }
        this.lastEntryName = e.name;
        this.lastEntryPos = pos;
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        ZipFile zipFile = this;
        synchronized (zipFile) {
            this.ensureOpen();
            return this.zsrc.total;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.closeRequested) {
            return;
        }
        this.closeRequested = true;
        ZipFile zipFile = this;
        synchronized (zipFile) {
            Object object = this.streams;
            synchronized (object) {
                if (!this.streams.isEmpty()) {
                    HashMap<InputStream, Inflater> copy = new HashMap<InputStream, Inflater>(this.streams);
                    this.streams.clear();
                    for (Map.Entry e : copy.entrySet()) {
                        ((InputStream)e.getKey()).close();
                        Inflater inf = (Inflater)e.getValue();
                        if (inf == null) continue;
                        inf.end();
                    }
                }
            }
            object = this.inflaterCache;
            synchronized (object) {
                Inflater inf;
                while ((inf = this.inflaterCache.poll()) != null) {
                    inf.end();
                }
            }
            if (this.zsrc != null) {
                Source.close(this.zsrc);
                this.zsrc = null;
            }
        }
    }

    protected void finalize() throws IOException {
        this.close();
    }

    private void ensureOpen() {
        if (this.closeRequested) {
            throw new IllegalStateException("zip file closed");
        }
        if (this.zsrc == null) {
            throw new IllegalStateException("The object is not initialized.");
        }
    }

    private void ensureOpenOrZipException() throws IOException {
        if (this.closeRequested) {
            throw new ZipException("ZipFile closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getMetaInfEntryNames() {
        ZipFile zipFile = this;
        synchronized (zipFile) {
            this.ensureOpen();
            if (this.zsrc.metanames == null) {
                return null;
            }
            String[] names = new String[this.zsrc.metanames.length];
            byte[] cen = this.zsrc.cen;
            for (int i = 0; i < names.length; ++i) {
                int pos = this.zsrc.metanames[i];
                names[i] = new String(cen, pos + 46, ZipUtils.CENNAM(cen, pos), StandardCharsets.UTF_8);
            }
            return names;
        }
    }

    static {
        SharedSecrets.setJavaUtilZipFileAccess((JavaUtilZipFileAccess)new JavaUtilZipFileAccess(){

            public boolean startsWithLocHeader(ZipFile zip) {
                return zip.zsrc.startsWithLoc;
            }

            public String[] getMetaInfEntryNames(ZipFile zip) {
                return zip.getMetaInfEntryNames();
            }
        });
        isWindows = VM.getSavedProperty("os.name").contains("Windows");
    }

    private static class Source {
        private final Key key;
        private int refs = 1;
        private RandomAccessFile zfile;
        private byte[] cen;
        private long locpos;
        private byte[] comment;
        private int[] metanames;
        private final boolean startsWithLoc;
        private int[] entries;
        private static final int ZIP_ENDCHAIN = -1;
        private int total;
        private int[] table;
        private int tablelen;
        private static final HashMap<Key, Source> files = new HashMap();
        private static final int BUF_SIZE = 8192;

        private int addEntry(int index, int hash, int next, int pos) {
            this.entries[index++] = hash;
            this.entries[index++] = next;
            this.entries[index++] = pos;
            return index;
        }

        private int getEntryHash(int index) {
            return this.entries[index];
        }

        private int getEntryNext(int index) {
            return this.entries[index + 1];
        }

        private int getEntryPos(int index) {
            return this.entries[index + 2];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Source get(File file, boolean toDelete) throws IOException {
            Key key = new Key(file, Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0]));
            Source src = null;
            HashMap<Key, Source> hashMap = files;
            synchronized (hashMap) {
                src = files.get(key);
                if (src != null) {
                    ++src.refs;
                    return src;
                }
            }
            src = new Source(key, toDelete);
            hashMap = files;
            synchronized (hashMap) {
                if (files.containsKey(key)) {
                    src.close();
                    src = files.get(key);
                    ++src.refs;
                    return src;
                }
                files.put(key, src);
                return src;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void close(Source src) throws IOException {
            HashMap<Key, Source> hashMap = files;
            synchronized (hashMap) {
                if (--src.refs == 0) {
                    files.remove(src.key);
                    src.close();
                }
            }
        }

        private Source(Key key, boolean toDelete) throws IOException {
            this.key = key;
            if (toDelete) {
                if (isWindows) {
                    this.zfile = SharedSecrets.getJavaIORandomAccessFileAccess().openAndDelete(key.file, "r");
                } else {
                    this.zfile = new RandomAccessFile(key.file, "r");
                    key.file.delete();
                }
            } else {
                this.zfile = new RandomAccessFile(key.file, "r");
            }
            try {
                this.initCEN(-1);
                byte[] buf = new byte[4];
                this.readFullyAt(buf, 0, 4, 0L);
                this.startsWithLoc = ZipUtils.LOCSIG(buf) == 67324752L;
            }
            catch (IOException x) {
                try {
                    this.zfile.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw x;
            }
        }

        private void close() throws IOException {
            this.zfile.close();
            this.zfile = null;
            this.cen = null;
            this.entries = null;
            this.table = null;
            this.metanames = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final int readFullyAt(byte[] buf, int off, int len, long pos) throws IOException {
            RandomAccessFile randomAccessFile = this.zfile;
            synchronized (randomAccessFile) {
                int n;
                this.zfile.seek(pos);
                for (int N = len; N > 0; N -= n) {
                    n = Math.min(8192, N);
                    this.zfile.readFully(buf, off, n);
                    off += n;
                }
                return len;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final int readAt(byte[] buf, int off, int len, long pos) throws IOException {
            RandomAccessFile randomAccessFile = this.zfile;
            synchronized (randomAccessFile) {
                this.zfile.seek(pos);
                return this.zfile.read(buf, off, len);
            }
        }

        private static final int hashN(byte[] a, int off, int len) {
            int h = 1;
            while (len-- > 0) {
                h = 31 * h + a[off++];
            }
            return h;
        }

        private static final int hash_append(int hash, byte b) {
            return hash * 31 + b;
        }

        private End findEND() throws IOException {
            long ziplen = this.zfile.length();
            if (ziplen <= 0L) {
                Source.zerror("zip file is empty");
            }
            End end = new End();
            byte[] buf = new byte[128];
            long minHDR = ziplen - 65557L > 0L ? ziplen - 65557L : 0L;
            long minPos = minHDR - (long)(buf.length - 22);
            for (long pos = ziplen - (long)buf.length; pos >= minPos; pos -= (long)(buf.length - 22)) {
                int len;
                int off = 0;
                if (pos < 0L) {
                    off = (int)(-pos);
                    Arrays.fill(buf, 0, off, (byte)0);
                }
                if (this.readFullyAt(buf, off, len = buf.length - off, pos + (long)off) != len) {
                    Source.zerror("zip END header not found");
                }
                for (int i = buf.length - 22; i >= 0; --i) {
                    if (buf[i + 0] != 80 || buf[i + 1] != 75 || buf[i + 2] != 5 || buf[i + 3] != 6) continue;
                    byte[] endbuf = Arrays.copyOfRange(buf, i, i + 22);
                    end.centot = ZipUtils.ENDTOT(endbuf);
                    end.cenlen = ZipUtils.ENDSIZ(endbuf);
                    end.cenoff = ZipUtils.ENDOFF(endbuf);
                    end.endpos = pos + (long)i;
                    int comlen = ZipUtils.ENDCOM(endbuf);
                    if (end.endpos + 22L + (long)comlen != ziplen) {
                        byte[] sbuf = new byte[4];
                        long cenpos = end.endpos - end.cenlen;
                        long locpos = cenpos - end.cenoff;
                        if (cenpos < 0L || locpos < 0L || this.readFullyAt(sbuf, 0, sbuf.length, cenpos) != 4 || ZipUtils.GETSIG(sbuf) != 33639248L || this.readFullyAt(sbuf, 0, sbuf.length, locpos) != 4 || ZipUtils.GETSIG(sbuf) != 67324752L) continue;
                    }
                    if (comlen > 0) {
                        this.comment = new byte[comlen];
                        if (this.readFullyAt(this.comment, 0, comlen, end.endpos + 22L) != comlen) {
                            Source.zerror("zip comment read failed");
                        }
                    }
                    if (end.cenlen == 0xFFFFFFFFL || end.cenoff == 0xFFFFFFFFL || end.centot == 65535) {
                        try {
                            byte[] loc64 = new byte[20];
                            if (this.readFullyAt(loc64, 0, loc64.length, end.endpos - 20L) != loc64.length || ZipUtils.GETSIG(loc64) != 117853008L) {
                                return end;
                            }
                            byte[] end64buf = new byte[56];
                            long end64pos = ZipUtils.ZIP64_LOCOFF(loc64);
                            if (this.readFullyAt(end64buf, 0, end64buf.length, end64pos) != end64buf.length || ZipUtils.GETSIG(end64buf) != 101075792L) {
                                return end;
                            }
                            end.cenlen = ZipUtils.ZIP64_ENDSIZ(end64buf);
                            end.cenoff = ZipUtils.ZIP64_ENDOFF(end64buf);
                            end.centot = (int)ZipUtils.ZIP64_ENDTOT(end64buf);
                            end.endpos = end64pos;
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    return end;
                }
            }
            Source.zerror("zip END header not found");
            return null;
        }

        private void initCEN(int knownTotal) throws IOException {
            if (knownTotal == -1) {
                End end = this.findEND();
                if (end.endpos == 0L) {
                    this.locpos = 0L;
                    this.total = 0;
                    this.entries = new int[0];
                    this.cen = null;
                    return;
                }
                if (end.cenlen > end.endpos) {
                    Source.zerror("invalid END header (bad central directory size)");
                }
                long cenpos = end.endpos - end.cenlen;
                this.locpos = cenpos - end.cenoff;
                if (this.locpos < 0L) {
                    Source.zerror("invalid END header (bad central directory offset)");
                }
                this.cen = new byte[(int)(end.cenlen + 22L)];
                if ((long)this.readFullyAt(this.cen, 0, this.cen.length, cenpos) != end.cenlen + 22L) {
                    Source.zerror("read CEN tables failed");
                }
                this.total = end.centot;
            } else {
                this.total = knownTotal;
            }
            this.entries = new int[this.total * 3];
            this.tablelen = this.total / 2 | 1;
            this.table = new int[this.tablelen];
            Arrays.fill(this.table, -1);
            int idx = 0;
            int hash = 0;
            int next = -1;
            ArrayList<Integer> metanamesList = null;
            int i = 0;
            int hsh = 0;
            int pos = 0;
            int limit = this.cen.length - 22;
            while (pos + 46 <= limit) {
                if (i >= this.total) {
                    this.initCEN(Source.countCENHeaders(this.cen, limit));
                    return;
                }
                if (ZipUtils.CENSIG(this.cen, pos) != 33639248L) {
                    Source.zerror("invalid CEN header (bad signature)");
                }
                int method = ZipUtils.CENHOW(this.cen, pos);
                int nlen = ZipUtils.CENNAM(this.cen, pos);
                int elen = ZipUtils.CENEXT(this.cen, pos);
                int clen = ZipUtils.CENCOM(this.cen, pos);
                if ((ZipUtils.CENFLG(this.cen, pos) & 1) != 0) {
                    Source.zerror("invalid CEN header (encrypted entry)");
                }
                if (method != 0 && method != 8) {
                    Source.zerror("invalid CEN header (bad compression method: " + method + ")");
                }
                if (pos + 46 + nlen > limit) {
                    Source.zerror("invalid CEN header (bad header size)");
                }
                hash = Source.hashN(this.cen, pos + 46, nlen);
                hsh = (hash & Integer.MAX_VALUE) % this.tablelen;
                next = this.table[hsh];
                this.table[hsh] = idx;
                idx = this.addEntry(idx, hash, next, pos);
                if (Source.isMetaName(this.cen, pos + 46, nlen)) {
                    if (metanamesList == null) {
                        metanamesList = new ArrayList<Integer>(4);
                    }
                    metanamesList.add(pos);
                }
                pos += 46 + nlen + elen + clen;
                ++i;
            }
            this.total = i;
            if (metanamesList != null) {
                this.metanames = new int[metanamesList.size()];
                int len = this.metanames.length;
                for (int j = 0; j < len; ++j) {
                    this.metanames[j] = (Integer)metanamesList.get(j);
                }
            }
            if (pos + 22 != this.cen.length) {
                Source.zerror("invalid CEN header (bad header size)");
            }
        }

        private static void zerror(String msg) throws ZipException {
            throw new ZipException(msg);
        }

        private int getEntryPos(byte[] name, boolean addSlash) {
            if (this.total == 0) {
                return -1;
            }
            int hsh = Source.hashN(name, 0, name.length);
            int idx = this.table[(hsh & Integer.MAX_VALUE) % this.tablelen];
            while (true) {
                if (idx != -1) {
                    int pos;
                    if (this.getEntryHash(idx) == hsh && name.length == ZipUtils.CENNAM(this.cen, pos = this.getEntryPos(idx))) {
                        boolean matched = true;
                        int nameoff = pos + 46;
                        for (int i = 0; i < name.length; ++i) {
                            if (name[i] == this.cen[nameoff++]) continue;
                            matched = false;
                            break;
                        }
                        if (matched) {
                            return pos;
                        }
                    }
                    idx = this.getEntryNext(idx);
                    continue;
                }
                if (!addSlash || name.length == 0 || name[name.length - 1] == 47) {
                    return -1;
                }
                name = Arrays.copyOf(name, name.length + 1);
                name[name.length - 1] = 47;
                hsh = Source.hash_append(hsh, (byte)47);
                idx = this.table[(hsh & Integer.MAX_VALUE) % this.tablelen];
                addSlash = false;
            }
        }

        private static boolean isMetaName(byte[] name, int off, int len) {
            return len > 9 && name[off + len - 1] != 47 && (name[off++] | 0x20) == 109 && (name[off++] | 0x20) == 101 && (name[off++] | 0x20) == 116 && (name[off++] | 0x20) == 97 && name[off++] == 45 && (name[off++] | 0x20) == 105 && (name[off++] | 0x20) == 110 && (name[off++] | 0x20) == 102 && name[off] == 47;
        }

        private static int countCENHeaders(byte[] cen, int size) {
            int count = 0;
            int p = 0;
            while (p + 46 <= size) {
                ++count;
                p += 46 + ZipUtils.CENNAM(cen, p) + ZipUtils.CENEXT(cen, p) + ZipUtils.CENCOM(cen, p);
            }
            return count;
        }

        private static class End {
            int centot;
            long cenlen;
            long cenoff;
            long endpos;

            private End() {
            }
        }

        private static class Key {
            BasicFileAttributes attrs;
            File file;

            public Key(File file, BasicFileAttributes attrs) {
                this.attrs = attrs;
                this.file = file;
            }

            public int hashCode() {
                long t = this.attrs.lastModifiedTime().toMillis();
                return (int)(t ^ t >>> 32) + this.file.hashCode();
            }

            public boolean equals(Object obj) {
                if (obj instanceof Key) {
                    Key key = (Key)obj;
                    if (!this.attrs.lastModifiedTime().equals(key.attrs.lastModifiedTime())) {
                        return false;
                    }
                    Object fk = this.attrs.fileKey();
                    if (fk != null) {
                        return fk.equals(key.attrs.fileKey());
                    }
                    return this.file.equals(key.file);
                }
                return false;
            }
        }
    }

    private class ZipFileInputStream
    extends InputStream {
        private volatile boolean closeRequested;
        private long pos;
        protected long rem;
        protected long size;

        ZipFileInputStream(byte[] cen, int cenpos) throws IOException {
            this.rem = ZipUtils.CENSIZ(cen, cenpos);
            this.size = ZipUtils.CENLEN(cen, cenpos);
            this.pos = ZipUtils.CENOFF(cen, cenpos);
            if (this.rem == 0xFFFFFFFFL || this.size == 0xFFFFFFFFL || this.pos == 0xFFFFFFFFL) {
                this.checkZIP64(cen, cenpos);
            }
            this.pos = -(this.pos + ZipFile.this.zsrc.locpos);
        }

        private void checkZIP64(byte[] cen, int cenpos) throws IOException {
            int off = cenpos + 46 + ZipUtils.CENNAM(cen, cenpos);
            int end = off + ZipUtils.CENEXT(cen, cenpos);
            while (off + 4 < end) {
                int sz;
                int tag = ZipUtils.get16(cen, off);
                if ((off += 4) + (sz = ZipUtils.get16(cen, off + 2)) > end) break;
                if (tag == 1) {
                    if (this.size == 0xFFFFFFFFL) {
                        if (sz < 8 || off + 8 > end) break;
                        this.size = ZipUtils.get64(cen, off);
                        sz -= 8;
                        off += 8;
                    }
                    if (this.rem == 0xFFFFFFFFL) {
                        if (sz < 8 || off + 8 > end) break;
                        this.rem = ZipUtils.get64(cen, off);
                        sz -= 8;
                        off += 8;
                    }
                    if (this.pos != 0xFFFFFFFFL || sz < 8 || off + 8 > end) break;
                    this.pos = ZipUtils.get64(cen, off);
                    sz -= 8;
                    off += 8;
                    break;
                }
                off += sz;
            }
        }

        private long initDataOffset() throws IOException {
            if (this.pos <= 0L) {
                byte[] loc = new byte[30];
                this.pos = -this.pos;
                int len = ZipFile.this.zsrc.readFullyAt(loc, 0, loc.length, this.pos);
                if (len != 30) {
                    throw new ZipException("ZipFile error reading zip file");
                }
                if (ZipUtils.LOCSIG(loc) != 67324752L) {
                    throw new ZipException("ZipFile invalid LOC header (bad signature)");
                }
                this.pos += (long)(30 + ZipUtils.LOCNAM(loc) + ZipUtils.LOCEXT(loc));
            }
            return this.pos;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            ZipFile zipFile = ZipFile.this;
            synchronized (zipFile) {
                ZipFile.this.ensureOpenOrZipException();
                this.initDataOffset();
                if (this.rem == 0L) {
                    return -1;
                }
                if ((long)len > this.rem) {
                    len = (int)this.rem;
                }
                if (len <= 0) {
                    return 0;
                }
                len = ZipFile.this.zsrc.readAt(b, off, len, this.pos);
                if (len > 0) {
                    this.pos += (long)len;
                    this.rem -= (long)len;
                }
            }
            if (this.rem == 0L) {
                this.close();
            }
            return len;
        }

        @Override
        public int read() throws IOException {
            byte[] b = new byte[1];
            if (this.read(b, 0, 1) == 1) {
                return b[0] & 0xFF;
            }
            return -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long skip(long n) throws IOException {
            ZipFile zipFile = ZipFile.this;
            synchronized (zipFile) {
                ZipFile.this.ensureOpenOrZipException();
                this.initDataOffset();
                if (n > this.rem) {
                    n = this.rem;
                }
                this.pos += n;
                this.rem -= n;
            }
            if (this.rem == 0L) {
                this.close();
            }
            return n;
        }

        @Override
        public int available() {
            return this.rem > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.rem;
        }

        public long size() {
            return this.size;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            if (this.closeRequested) {
                return;
            }
            this.closeRequested = true;
            this.rem = 0L;
            Map map = ZipFile.this.streams;
            synchronized (map) {
                ZipFile.this.streams.remove(this);
            }
        }

        protected void finalize() {
            this.close();
        }
    }

    private class ZipEntryIterator
    implements Enumeration<ZipEntry>,
    Iterator<ZipEntry> {
        private int i = 0;
        private final int entryCount;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ZipEntryIterator() {
            ZipFile zipFile2 = ZipFile.this;
            synchronized (zipFile2) {
                ZipFile.this.ensureOpen();
                this.entryCount = ZipFile.this.zsrc.total;
            }
        }

        @Override
        public boolean hasMoreElements() {
            return this.hasNext();
        }

        @Override
        public boolean hasNext() {
            return this.i < this.entryCount;
        }

        @Override
        public ZipEntry nextElement() {
            return this.next();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ZipEntry next() {
            ZipFile zipFile = ZipFile.this;
            synchronized (zipFile) {
                ZipFile.this.ensureOpen();
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return ZipFile.this.getZipEntry(null, null, ZipFile.this.zsrc.getEntryPos(this.i++ * 3));
            }
        }

        @Override
        public Iterator<ZipEntry> asIterator() {
            return this;
        }
    }

    private class ZipFileInflaterInputStream
    extends InflaterInputStream {
        private volatile boolean closeRequested;
        private boolean eof;
        private final ZipFileInputStream zfin;

        ZipFileInflaterInputStream(ZipFileInputStream zfin, Inflater inf, int size) {
            super(zfin, inf, size);
            this.eof = false;
            this.zfin = zfin;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            Inflater inf;
            if (this.closeRequested) {
                return;
            }
            this.closeRequested = true;
            super.close();
            Map map = ZipFile.this.streams;
            synchronized (map) {
                inf = (Inflater)ZipFile.this.streams.remove(this);
            }
            if (inf != null) {
                ZipFile.this.releaseInflater(inf);
            }
        }

        @Override
        protected void fill() throws IOException {
            if (this.eof) {
                throw new EOFException("Unexpected end of ZLIB input stream");
            }
            this.len = this.in.read(this.buf, 0, this.buf.length);
            if (this.len == -1) {
                this.buf[0] = 0;
                this.len = 1;
                this.eof = true;
            }
            this.inf.setInput(this.buf, 0, this.len);
        }

        @Override
        public int available() throws IOException {
            if (this.closeRequested) {
                return 0;
            }
            long avail = this.zfin.size() - this.inf.getBytesWritten();
            return avail > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)avail;
        }

        protected void finalize() throws Throwable {
            this.close();
        }
    }
}

