/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import sun.nio.cs.ArrayDecoder;
import sun.nio.cs.ArrayEncoder;

final class ZipCoder {
    private Charset cs;
    private CharsetDecoder dec;
    private CharsetEncoder enc;
    private boolean isUTF8;
    private ZipCoder utf8;

    String toString(byte[] ba, int off, int length) {
        CharBuffer cb;
        CharsetDecoder cd = this.decoder().reset();
        int len = (int)((float)length * cd.maxCharsPerByte());
        char[] ca = new char[len];
        if (len == 0) {
            return new String(ca);
        }
        if (this.isUTF8 && cd instanceof ArrayDecoder) {
            int clen = ((ArrayDecoder)((Object)cd)).decode(ba, off, length, ca);
            if (clen == -1) {
                throw new IllegalArgumentException("MALFORMED");
            }
            return new String(ca, 0, clen);
        }
        ByteBuffer bb = ByteBuffer.wrap(ba, off, length);
        CoderResult cr = cd.decode(bb, cb = CharBuffer.wrap(ca), true);
        if (!cr.isUnderflow()) {
            throw new IllegalArgumentException(cr.toString());
        }
        cr = cd.flush(cb);
        if (!cr.isUnderflow()) {
            throw new IllegalArgumentException(cr.toString());
        }
        return new String(ca, 0, cb.position());
    }

    String toString(byte[] ba, int length) {
        return this.toString(ba, 0, length);
    }

    String toString(byte[] ba) {
        return this.toString(ba, 0, ba.length);
    }

    byte[] getBytes(String s) {
        CharsetEncoder ce = this.encoder().reset();
        char[] ca = s.toCharArray();
        int len = (int)((float)ca.length * ce.maxBytesPerChar());
        byte[] ba = new byte[len];
        if (len == 0) {
            return ba;
        }
        if (this.isUTF8 && ce instanceof ArrayEncoder) {
            int blen = ((ArrayEncoder)((Object)ce)).encode(ca, 0, ca.length, ba);
            if (blen == -1) {
                throw new IllegalArgumentException("MALFORMED");
            }
            return Arrays.copyOf(ba, blen);
        }
        ByteBuffer bb = ByteBuffer.wrap(ba);
        CharBuffer cb = CharBuffer.wrap(ca);
        CoderResult cr = ce.encode(cb, bb, true);
        if (!cr.isUnderflow()) {
            throw new IllegalArgumentException(cr.toString());
        }
        cr = ce.flush(bb);
        if (!cr.isUnderflow()) {
            throw new IllegalArgumentException(cr.toString());
        }
        if (bb.position() == ba.length) {
            return ba;
        }
        return Arrays.copyOf(ba, bb.position());
    }

    byte[] getBytesUTF8(String s) {
        if (this.isUTF8) {
            return this.getBytes(s);
        }
        if (this.utf8 == null) {
            this.utf8 = new ZipCoder(StandardCharsets.UTF_8);
        }
        return this.utf8.getBytes(s);
    }

    String toStringUTF8(byte[] ba, int len) {
        return this.toStringUTF8(ba, 0, len);
    }

    String toStringUTF8(byte[] ba, int off, int len) {
        if (this.isUTF8) {
            return this.toString(ba, off, len);
        }
        if (this.utf8 == null) {
            this.utf8 = new ZipCoder(StandardCharsets.UTF_8);
        }
        return this.utf8.toString(ba, off, len);
    }

    boolean isUTF8() {
        return this.isUTF8;
    }

    private ZipCoder(Charset cs) {
        this.cs = cs;
        this.isUTF8 = cs.name().equals(StandardCharsets.UTF_8.name());
    }

    static ZipCoder get(Charset charset) {
        return new ZipCoder(charset);
    }

    private CharsetDecoder decoder() {
        if (this.dec == null) {
            this.dec = this.cs.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
        }
        return this.dec;
    }

    private CharsetEncoder encoder() {
        if (this.enc == null) {
            this.enc = this.cs.newEncoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
        }
        return this.enc;
    }
}

