/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.nio.ByteBuffer;

public interface Checksum {
    public void update(int var1);

    default public void update(byte[] b) {
        this.update(b, 0, b.length);
    }

    public void update(byte[] var1, int var2, int var3);

    default public void update(ByteBuffer buffer) {
        int pos = buffer.position();
        int limit = buffer.limit();
        if (!1.$assertionsDisabled && pos > limit) {
            throw new AssertionError();
        }
        int rem = limit - pos;
        if (rem <= 0) {
            return;
        }
        if (buffer.hasArray()) {
            this.update(buffer.array(), pos + buffer.arrayOffset(), rem);
        } else {
            byte[] b = new byte[Math.min(buffer.remaining(), 4096)];
            while (buffer.hasRemaining()) {
                int length = Math.min(buffer.remaining(), b.length);
                buffer.get(b, 0, length);
                this.update(b, 0, length);
            }
        }
        buffer.position(limit);
    }

    public long getValue();

    public void reset();

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

