/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.zip.Checksum;
import jdk.internal.HotSpotIntrinsicCandidate;
import sun.nio.ch.DirectBuffer;

public class CRC32
implements Checksum {
    private int crc;

    @Override
    public void update(int b) {
        this.crc = CRC32.update(this.crc, b);
    }

    @Override
    public void update(byte[] b, int off, int len) {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off > b.length - len) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.crc = CRC32.updateBytes(this.crc, b, off, len);
    }

    @Override
    public void update(ByteBuffer buffer) {
        int pos = buffer.position();
        int limit = buffer.limit();
        assert (pos <= limit);
        int rem = limit - pos;
        if (rem <= 0) {
            return;
        }
        if (buffer instanceof DirectBuffer) {
            this.crc = CRC32.updateByteBuffer(this.crc, ((DirectBuffer)((Object)buffer)).address(), pos, rem);
        } else if (buffer.hasArray()) {
            this.crc = CRC32.updateBytes(this.crc, buffer.array(), pos + buffer.arrayOffset(), rem);
        } else {
            byte[] b = new byte[Math.min(buffer.remaining(), 4096)];
            while (buffer.hasRemaining()) {
                int length = Math.min(buffer.remaining(), b.length);
                buffer.get(b, 0, length);
                this.update(b, 0, length);
            }
        }
        buffer.position(limit);
    }

    @Override
    public void reset() {
        this.crc = 0;
    }

    @Override
    public long getValue() {
        return (long)this.crc & 0xFFFFFFFFL;
    }

    @HotSpotIntrinsicCandidate
    private static native int update(int var0, int var1);

    private static int updateBytes(int crc, byte[] b, int off, int len) {
        CRC32.updateBytesCheck(b, off, len);
        return CRC32.updateBytes0(crc, b, off, len);
    }

    @HotSpotIntrinsicCandidate
    private static native int updateBytes0(int var0, byte[] var1, int var2, int var3);

    private static void updateBytesCheck(byte[] b, int off, int len) {
        if (len <= 0) {
            return;
        }
        Objects.requireNonNull(b);
        if (off < 0 || off >= b.length) {
            throw new ArrayIndexOutOfBoundsException(off);
        }
        int endIndex = off + len - 1;
        if (endIndex < 0 || endIndex >= b.length) {
            throw new ArrayIndexOutOfBoundsException(endIndex);
        }
    }

    private static int updateByteBuffer(int alder, long addr, int off, int len) {
        CRC32.updateByteBufferCheck(addr);
        return CRC32.updateByteBuffer0(alder, addr, off, len);
    }

    @HotSpotIntrinsicCandidate
    private static native int updateByteBuffer0(int var0, long var1, int var3, int var4);

    private static void updateByteBufferCheck(long addr) {
        if (addr == 0L) {
            throw new NullPointerException();
        }
    }
}

