/*
 * Decompiled with CFR 0.152.
 */
package java.util.regex;

import java.util.HashMap;
import java.util.regex.ASCII;
import java.util.regex.CharPredicates;
import java.util.regex.Pattern;

class PrintPattern {
    private static HashMap<Pattern.Node, Integer> ids = new HashMap();
    static HashMap<Pattern.CharPredicate, String> pmap = new HashMap();

    PrintPattern() {
    }

    private static void print(Pattern.Node node, String text, int depth) {
        if (!ids.containsKey(node)) {
            ids.put(node, ids.size());
        }
        PrintPattern.print("%6d:%" + (depth == 0 ? "" : Integer.valueOf(depth << 1)) + "s<%s>", ids.get(node), "", text);
        if (ids.containsKey(node.next)) {
            PrintPattern.print(" (=>%d)", ids.get(node.next));
        }
        PrintPattern.print("%n", new Object[0]);
    }

    private static void print(String s, int depth) {
        PrintPattern.print("       %" + (depth == 0 ? "" : Integer.valueOf(depth << 1)) + "s<%s>%n", "", s);
    }

    private static void print(String fmt, Object ... args) {
        System.err.printf(fmt, args);
    }

    private static String toStringCPS(int[] cps) {
        StringBuilder sb = new StringBuilder(cps.length);
        for (int cp : cps) {
            sb.append(PrintPattern.toStringCP(cp));
        }
        return sb.toString();
    }

    private static String toStringCP(int cp) {
        return ASCII.isPrint(cp) ? "" + (char)cp : "\\u" + Integer.toString(cp, 16);
    }

    private static String toStringRange(int min, int max) {
        if (max == Integer.MAX_VALUE) {
            if (min == 0) {
                return " * ";
            }
            if (min == 1) {
                return " + ";
            }
            return "{" + min + ", max}";
        }
        return "{" + min + ", " + max + "}";
    }

    private static String toStringCtype(int type) {
        switch (type) {
            case 256: {
                return "ASCII.UPPER";
            }
            case 512: {
                return "ASCII.LOWER";
            }
            case 1024: {
                return "ASCII.DIGIT";
            }
            case 2048: {
                return "ASCII.SPACE";
            }
            case 4096: {
                return "ASCII.PUNCT";
            }
            case 8192: {
                return "ASCII.CNTRL";
            }
            case 16384: {
                return "ASCII.BLANK";
            }
            case 65536: {
                return "ASCII.UNDER";
            }
            case 65280: {
                return "ASCII.ASCII";
            }
            case 768: {
                return "ASCII.ALPHA";
            }
            case 1792: {
                return "ASCII.ALNUM";
            }
            case 5888: {
                return "ASCII.GRAPH";
            }
            case 67328: {
                return "ASCII.WORD";
            }
            case 32768: {
                return "ASCII.XDIGIT";
            }
        }
        return "ASCII ?";
    }

    private static String toString(Pattern.Node node) {
        String name = node.getClass().getName();
        return name.substring(name.lastIndexOf(36) + 1);
    }

    static void walk(Pattern.Node node, int depth) {
        ++depth;
        while (node != null) {
            String str;
            String name = PrintPattern.toString(node);
            if (node instanceof Pattern.Prolog) {
                PrintPattern.print(node, name, depth);
                Pattern.Loop loop = ((Pattern.Prolog)node).loop;
                name = PrintPattern.toString(loop);
                str = name + " " + PrintPattern.toStringRange(loop.cmin, loop.cmax);
                PrintPattern.print(loop, str, depth);
                PrintPattern.walk(loop.body, depth);
                PrintPattern.print("/" + name, depth);
                node = loop;
            } else {
                if (node instanceof Pattern.Loop) {
                    return;
                }
                if (node instanceof Pattern.Curly) {
                    Pattern.Curly c = (Pattern.Curly)node;
                    str = "Curly " + (Object)((Object)c.type) + " " + PrintPattern.toStringRange(c.cmin, c.cmax);
                    PrintPattern.print(node, str, depth);
                    PrintPattern.walk(c.atom, depth);
                    PrintPattern.print("/Curly", depth);
                } else if (node instanceof Pattern.GroupCurly) {
                    Pattern.GroupCurly gc = (Pattern.GroupCurly)node;
                    str = "GroupCurly " + gc.groupIndex / 2 + ", " + (Object)((Object)gc.type) + " " + PrintPattern.toStringRange(gc.cmin, gc.cmax);
                    PrintPattern.print(node, str, depth);
                    PrintPattern.walk(gc.atom, depth);
                    PrintPattern.print("/GroupCurly", depth);
                } else if (node instanceof Pattern.GroupHead) {
                    Pattern.GroupHead head = (Pattern.GroupHead)node;
                    Pattern.GroupTail tail = head.tail;
                    PrintPattern.print(head, "Group.head " + tail.groupIndex / 2, depth);
                    PrintPattern.walk(head.next, depth);
                    PrintPattern.print(tail, "/Group.tail " + tail.groupIndex / 2, depth);
                    node = tail;
                } else {
                    if (node instanceof Pattern.GroupTail) {
                        return;
                    }
                    if (node instanceof Pattern.Ques) {
                        PrintPattern.print(node, "Ques " + (Object)((Object)((Pattern.Ques)node).type), depth);
                        PrintPattern.walk(((Pattern.Ques)node).atom, depth);
                        PrintPattern.print("/Ques", depth);
                    } else if (node instanceof Pattern.Branch) {
                        Pattern.Branch b = (Pattern.Branch)node;
                        PrintPattern.print(b, name, depth);
                        int i = 0;
                        while (true) {
                            if (b.atoms[i] != null) {
                                PrintPattern.walk(b.atoms[i], depth);
                            } else {
                                PrintPattern.print("  (accepted)", depth);
                            }
                            if (++i == b.size) break;
                            PrintPattern.print("-branch.separator-", depth);
                        }
                        node = b.conn;
                        PrintPattern.print(node, "/Branch", depth);
                    } else {
                        if (node instanceof Pattern.BranchConn) {
                            return;
                        }
                        if (node instanceof Pattern.CharProperty) {
                            str = pmap.get(((Pattern.CharProperty)node).predicate);
                            str = str == null ? PrintPattern.toString(node) : "Single \"" + str + "\"";
                            PrintPattern.print(node, str, depth);
                        } else if (node instanceof Pattern.SliceNode) {
                            str = name + "  \"" + PrintPattern.toStringCPS(((Pattern.SliceNode)node).buffer) + "\"";
                            PrintPattern.print(node, str, depth);
                        } else if (node instanceof Pattern.CharPropertyGreedy) {
                            Pattern.CharPropertyGreedy gcp = (Pattern.CharPropertyGreedy)node;
                            String pstr = pmap.get(gcp.predicate);
                            pstr = pstr == null ? gcp.predicate.toString() : "Single \"" + pstr + "\"";
                            str = name + " " + pstr + (gcp.cmin == 0 ? "*" : "+");
                            PrintPattern.print(node, str, depth);
                        } else if (node instanceof Pattern.BackRef) {
                            str = "GroupBackRef " + ((Pattern.BackRef)node).groupIndex / 2;
                            PrintPattern.print(node, str, depth);
                        } else if (node instanceof Pattern.LastNode) {
                            PrintPattern.print(node, "END", depth);
                        } else {
                            if (node == Pattern.accept) {
                                return;
                            }
                            PrintPattern.print(node, name, depth);
                        }
                    }
                }
            }
            node = node.next;
        }
    }

    public static void main(String[] args) {
        Pattern p = Pattern.compile(args[0]);
        System.out.println("   Pattern: " + p);
        PrintPattern.walk(p.root, 0);
    }

    static {
        pmap.put(Pattern.ALL, "All");
        pmap.put(Pattern.DOT, "Dot");
        pmap.put(Pattern.UNIXDOT, "UnixDot");
        pmap.put(Pattern.VertWS, "VertWS");
        pmap.put(Pattern.HorizWS, "HorizWS");
        pmap.put(CharPredicates.ASCII_DIGIT, "ASCII.DIGIT");
        pmap.put(CharPredicates.ASCII_WORD, "ASCII.WORD");
        pmap.put(CharPredicates.ASCII_SPACE, "ASCII.SPACE");
    }
}

