/*
 * Decompiled with CFR 0.152.
 */
package java.util.regex;

final class Grapheme {
    private static final int OTHER = 0;
    private static final int CR = 1;
    private static final int LF = 2;
    private static final int CONTROL = 3;
    private static final int EXTEND = 4;
    private static final int RI = 5;
    private static final int PREPEND = 6;
    private static final int SPACINGMARK = 7;
    private static final int L = 8;
    private static final int V = 9;
    private static final int T = 10;
    private static final int LV = 11;
    private static final int LVT = 12;
    private static final int FIRST_TYPE = 0;
    private static final int LAST_TYPE = 12;
    private static boolean[][] rules;
    private static final int SYLLABLE_BASE = 44032;
    private static final int LCOUNT = 19;
    private static final int VCOUNT = 21;
    private static final int TCOUNT = 28;
    private static final int NCOUNT = 588;
    private static final int SCOUNT = 11172;

    Grapheme() {
    }

    static boolean isBoundary(int cp1, int cp2) {
        return rules[Grapheme.getType(cp1)][Grapheme.getType(cp2)];
    }

    private static boolean isExcludedSpacingMark(int cp) {
        return cp == 4139 || cp == 4140 || cp == 4152 || cp >= 4194 && cp <= 4196 || cp >= 4194 && cp <= 4205 || cp == 4227 || cp >= 4231 && cp <= 4236 || cp == 4239 || cp >= 4250 && cp <= 4252 || cp == 6753 || cp == 6755 || cp == 6756 || cp == 43643 || cp == 43645;
    }

    private static int getType(int cp) {
        int type = Character.getType(cp);
        switch (type) {
            case 15: {
                if (cp == 13) {
                    return 1;
                }
                if (cp == 10) {
                    return 2;
                }
                return 3;
            }
            case 0: {
                if (cp == 888) {
                    return 0;
                }
            }
            case 13: 
            case 14: 
            case 19: {
                return 3;
            }
            case 16: {
                if (cp == 8204 || cp == 8205) {
                    return 4;
                }
                return 3;
            }
            case 6: 
            case 7: {
                return 4;
            }
            case 8: {
                if (Grapheme.isExcludedSpacingMark(cp)) {
                    return 0;
                }
                return 7;
            }
            case 28: {
                if (cp >= 127462 && cp <= 127487) {
                    return 5;
                }
                return 0;
            }
            case 4: {
                if (cp == 65438 || cp == 65439) {
                    return 4;
                }
                return 0;
            }
            case 5: {
                if (cp == 3635 || cp == 3763) {
                    return 7;
                }
                if (cp >= 4352 && cp <= 4607) {
                    if (cp <= 4447) {
                        return 8;
                    }
                    if (cp <= 4519) {
                        return 9;
                    }
                    return 10;
                }
                int sindex = cp - 44032;
                if (sindex >= 0 && sindex < 11172) {
                    if (sindex % 28 == 0) {
                        return 11;
                    }
                    return 12;
                }
                if (cp >= 43360 && cp <= 43388) {
                    return 8;
                }
                if (cp >= 55216 && cp <= 55238) {
                    return 9;
                }
                if (cp < 55243 || cp > 55291) break;
                return 10;
            }
        }
        return 0;
    }

    static {
        int j;
        int i;
        rules = new boolean[13][13];
        for (i = 0; i <= 12; ++i) {
            for (j = 0; j <= 12; ++j) {
                Grapheme.rules[i][j] = true;
            }
        }
        Grapheme.rules[8][8] = false;
        Grapheme.rules[8][9] = false;
        Grapheme.rules[8][11] = false;
        Grapheme.rules[8][12] = false;
        Grapheme.rules[11][9] = false;
        Grapheme.rules[11][10] = false;
        Grapheme.rules[9][9] = false;
        Grapheme.rules[9][10] = false;
        Grapheme.rules[12][10] = false;
        Grapheme.rules[10][10] = false;
        Grapheme.rules[5][5] = false;
        for (i = 0; i <= 12; ++i) {
            Grapheme.rules[i][4] = false;
            Grapheme.rules[i][7] = false;
            Grapheme.rules[6][i] = false;
        }
        for (i = 0; i <= 12; ++i) {
            for (j = 1; j <= 3; ++j) {
                Grapheme.rules[i][j] = true;
                Grapheme.rules[j][i] = true;
            }
        }
        Grapheme.rules[1][2] = false;
    }
}

