/*
 * Decompiled with CFR 0.152.
 */
package java.util.regex;

import java.util.HashMap;
import java.util.Locale;
import java.util.regex.ASCII;
import java.util.regex.Pattern;

class CharPredicates {
    static final Pattern.CharPredicate ALPHABETIC = Character::isAlphabetic;
    static final Pattern.CharPredicate DIGIT = Character::isDigit;
    static final Pattern.CharPredicate LETTER = Character::isLetter;
    static final Pattern.CharPredicate IDEOGRAPHIC = Character::isIdeographic;
    static final Pattern.CharPredicate LOWERCASE = Character::isLowerCase;
    static final Pattern.CharPredicate UPPERCASE = Character::isUpperCase;
    static final Pattern.CharPredicate TITLECASE = Character::isTitleCase;
    static final Pattern.CharPredicate WHITE_SPACE = ch -> (28672 >> Character.getType(ch) & 1) != 0 || ch >= 9 && ch <= 13 || ch == 133;
    static final Pattern.CharPredicate CONTROL = ch -> Character.getType(ch) == 15;
    static final Pattern.CharPredicate PUNCTUATION = ch -> (1643118592 >> Character.getType(ch) & 1) != 0;
    static final Pattern.CharPredicate HEX_DIGIT = DIGIT.union(ch -> ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102 || ch >= 65296 && ch <= 65305 || ch >= 65313 && ch <= 65318 || ch >= 65345 && ch <= 65350);
    static final Pattern.CharPredicate ASSIGNED = ch -> Character.getType(ch) != 0;
    static final Pattern.CharPredicate NONCHARACTER_CODE_POINT = ch -> (ch & 0xFFFE) == 65534 || ch >= 64976 && ch <= 65007;
    static final Pattern.CharPredicate ALNUM = ALPHABETIC.union(DIGIT);
    static final Pattern.CharPredicate BLANK = ch -> Character.getType(ch) == 12 || ch == 9;
    static final Pattern.CharPredicate GRAPH = ch -> (585729 >> Character.getType(ch) & 1) == 0;
    static final Pattern.CharPredicate PRINT = GRAPH.union(BLANK).and(CONTROL.negate());
    static final Pattern.CharPredicate JOIN_CONTROL = ch -> ch == 8204 || ch == 8205;
    static final Pattern.CharPredicate WORD = ALPHABETIC.union(ch -> (8389568 >> Character.getType(ch) & 1) != 0, JOIN_CONTROL);
    private static final HashMap<String, Pattern.CharPredicate> posix = new HashMap(12);
    private static final HashMap<String, Pattern.CharPredicate> uprops = new HashMap(18);
    private static final HashMap<String, Pattern.CharPredicate> props;
    static final Pattern.BmpCharPredicate ASCII_DIGIT;
    static final Pattern.BmpCharPredicate ASCII_WORD;
    static final Pattern.BmpCharPredicate ASCII_SPACE;

    CharPredicates() {
    }

    private static void defPosix(String name, Pattern.CharPredicate p) {
        posix.put(name, p);
    }

    private static void defUProp(String name, Pattern.CharPredicate p) {
        uprops.put(name, p);
    }

    public static Pattern.CharPredicate forUnicodeProperty(String propName) {
        Pattern.CharPredicate p = uprops.get(propName = propName.toUpperCase(Locale.ROOT));
        if (p != null) {
            return p;
        }
        return posix.get(propName);
    }

    public static Pattern.CharPredicate forPOSIXName(String propName) {
        return posix.get(propName.toUpperCase(Locale.ENGLISH));
    }

    static Pattern.CharPredicate forUnicodeScript(String name) {
        try {
            Character.UnicodeScript script = Character.UnicodeScript.forName(name);
            return ch -> script == Character.UnicodeScript.of(ch);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    static Pattern.CharPredicate forUnicodeBlock(String name) {
        try {
            Character.UnicodeBlock block = Character.UnicodeBlock.forName(name);
            return ch -> block == Character.UnicodeBlock.of(ch);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    static Pattern.CharPredicate forProperty(String name) {
        return props.get(name);
    }

    private static void defProp(String name, Pattern.CharPredicate p) {
        props.put(name, p);
    }

    private static void defCategory(String name, int typeMask) {
        Pattern.CharPredicate p = ch -> (typeMask & 1 << Character.getType(ch)) != 0;
        props.put(name, p);
    }

    private static void defRange(String name, int lower, int upper) {
        Pattern.BmpCharPredicate p = ch -> lower <= ch && ch <= upper;
        props.put(name, p);
    }

    private static void defCtype(String name, int ctype) {
        Pattern.BmpCharPredicate p = ch -> ch < 128 && ASCII.isType(ch, ctype);
        props.put(name, p);
    }

    static {
        CharPredicates.defPosix("ALPHA", ALPHABETIC);
        CharPredicates.defPosix("LOWER", LOWERCASE);
        CharPredicates.defPosix("UPPER", UPPERCASE);
        CharPredicates.defPosix("SPACE", WHITE_SPACE);
        CharPredicates.defPosix("PUNCT", PUNCTUATION);
        CharPredicates.defPosix("XDIGIT", HEX_DIGIT);
        CharPredicates.defPosix("ALNUM", ALNUM);
        CharPredicates.defPosix("CNTRL", CONTROL);
        CharPredicates.defPosix("DIGIT", DIGIT);
        CharPredicates.defPosix("BLANK", BLANK);
        CharPredicates.defPosix("GRAPH", GRAPH);
        CharPredicates.defPosix("PRINT", PRINT);
        CharPredicates.defUProp("ALPHABETIC", ALPHABETIC);
        CharPredicates.defUProp("ASSIGNED", ASSIGNED);
        CharPredicates.defUProp("CONTROL", CONTROL);
        CharPredicates.defUProp("HEXDIGIT", HEX_DIGIT);
        CharPredicates.defUProp("IDEOGRAPHIC", IDEOGRAPHIC);
        CharPredicates.defUProp("JOINCONTROL", JOIN_CONTROL);
        CharPredicates.defUProp("LETTER", LETTER);
        CharPredicates.defUProp("LOWERCASE", LOWERCASE);
        CharPredicates.defUProp("NONCHARACTERCODEPOINT", NONCHARACTER_CODE_POINT);
        CharPredicates.defUProp("TITLECASE", TITLECASE);
        CharPredicates.defUProp("PUNCTUATION", PUNCTUATION);
        CharPredicates.defUProp("UPPERCASE", UPPERCASE);
        CharPredicates.defUProp("WHITESPACE", WHITE_SPACE);
        CharPredicates.defUProp("WORD", WORD);
        CharPredicates.defUProp("WHITE_SPACE", WHITE_SPACE);
        CharPredicates.defUProp("HEX_DIGIT", HEX_DIGIT);
        CharPredicates.defUProp("NONCHARACTER_CODE_POINT", NONCHARACTER_CODE_POINT);
        CharPredicates.defUProp("JOIN_CONTROL", JOIN_CONTROL);
        props = new HashMap(128);
        CharPredicates.defCategory("Cn", 1);
        CharPredicates.defCategory("Lu", 2);
        CharPredicates.defCategory("Ll", 4);
        CharPredicates.defCategory("Lt", 8);
        CharPredicates.defCategory("Lm", 16);
        CharPredicates.defCategory("Lo", 32);
        CharPredicates.defCategory("Mn", 64);
        CharPredicates.defCategory("Me", 128);
        CharPredicates.defCategory("Mc", 256);
        CharPredicates.defCategory("Nd", 512);
        CharPredicates.defCategory("Nl", 1024);
        CharPredicates.defCategory("No", 2048);
        CharPredicates.defCategory("Zs", 4096);
        CharPredicates.defCategory("Zl", 8192);
        CharPredicates.defCategory("Zp", 16384);
        CharPredicates.defCategory("Cc", 32768);
        CharPredicates.defCategory("Cf", 65536);
        CharPredicates.defCategory("Co", 262144);
        CharPredicates.defCategory("Cs", 524288);
        CharPredicates.defCategory("Pd", 0x100000);
        CharPredicates.defCategory("Ps", 0x200000);
        CharPredicates.defCategory("Pe", 0x400000);
        CharPredicates.defCategory("Pc", 0x800000);
        CharPredicates.defCategory("Po", 0x1000000);
        CharPredicates.defCategory("Sm", 0x2000000);
        CharPredicates.defCategory("Sc", 0x4000000);
        CharPredicates.defCategory("Sk", 0x8000000);
        CharPredicates.defCategory("So", 0x10000000);
        CharPredicates.defCategory("Pi", 0x20000000);
        CharPredicates.defCategory("Pf", 0x40000000);
        CharPredicates.defCategory("L", 62);
        CharPredicates.defCategory("M", 448);
        CharPredicates.defCategory("N", 3584);
        CharPredicates.defCategory("Z", 28672);
        CharPredicates.defCategory("C", 884737);
        CharPredicates.defCategory("P", 1643118592);
        CharPredicates.defCategory("S", 0x1E000000);
        CharPredicates.defCategory("LC", 14);
        CharPredicates.defCategory("LD", 574);
        CharPredicates.defRange("L1", 0, 255);
        props.put("all", ch -> true);
        CharPredicates.defRange("ASCII", 0, 127);
        CharPredicates.defCtype("Alnum", 1792);
        CharPredicates.defCtype("Alpha", 768);
        CharPredicates.defCtype("Blank", 16384);
        CharPredicates.defCtype("Cntrl", 8192);
        CharPredicates.defRange("Digit", 48, 57);
        CharPredicates.defCtype("Graph", 5888);
        CharPredicates.defRange("Lower", 97, 122);
        CharPredicates.defRange("Print", 32, 126);
        CharPredicates.defCtype("Punct", 4096);
        CharPredicates.defCtype("Space", 2048);
        CharPredicates.defRange("Upper", 65, 90);
        CharPredicates.defCtype("XDigit", 32768);
        CharPredicates.defProp("javaLowerCase", Character::isLowerCase);
        CharPredicates.defProp("javaUpperCase", Character::isUpperCase);
        CharPredicates.defProp("javaAlphabetic", Character::isAlphabetic);
        CharPredicates.defProp("javaIdeographic", Character::isIdeographic);
        CharPredicates.defProp("javaTitleCase", Character::isTitleCase);
        CharPredicates.defProp("javaDigit", Character::isDigit);
        CharPredicates.defProp("javaDefined", Character::isDefined);
        CharPredicates.defProp("javaLetter", Character::isLetter);
        CharPredicates.defProp("javaLetterOrDigit", Character::isLetterOrDigit);
        CharPredicates.defProp("javaJavaIdentifierStart", Character::isJavaIdentifierStart);
        CharPredicates.defProp("javaJavaIdentifierPart", Character::isJavaIdentifierPart);
        CharPredicates.defProp("javaUnicodeIdentifierStart", Character::isUnicodeIdentifierStart);
        CharPredicates.defProp("javaUnicodeIdentifierPart", Character::isUnicodeIdentifierPart);
        CharPredicates.defProp("javaIdentifierIgnorable", Character::isIdentifierIgnorable);
        CharPredicates.defProp("javaSpaceChar", Character::isSpaceChar);
        CharPredicates.defProp("javaWhitespace", Character::isWhitespace);
        CharPredicates.defProp("javaISOControl", Character::isISOControl);
        CharPredicates.defProp("javaMirrored", Character::isMirrored);
        ASCII_DIGIT = ch -> ch < 128 && ASCII.isDigit(ch);
        ASCII_WORD = ch -> ch < 128 && ASCII.isWord(ch);
        ASCII_SPACE = ch -> ch < 128 && ASCII.isSpace(ch);
    }
}

