/*
 * Decompiled with CFR 0.152.
 */
package java.util.jar;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterators;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarException;
import java.util.jar.JarVerifier;
import java.util.jar.JavaUtilJarAccessImpl;
import java.util.jar.Manifest;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import jdk.internal.misc.JavaUtilJarAccess;
import jdk.internal.misc.SharedSecrets;
import sun.security.action.GetPropertyAction;
import sun.security.util.ManifestEntryVerifier;
import sun.security.util.SignatureFileVerifier;

public class JarFile
extends ZipFile {
    private static final Runtime.Version BASE_VERSION;
    private static final int BASE_VERSION_MAJOR;
    private static final Runtime.Version RUNTIME_VERSION;
    private static final boolean MULTI_RELEASE_ENABLED;
    private static final boolean MULTI_RELEASE_FORCED;
    private SoftReference<Manifest> manRef;
    private JarEntry manEntry;
    private JarVerifier jv;
    private boolean jvInitialized;
    private boolean verify;
    private final Runtime.Version version;
    private final int versionMajor;
    private boolean isMultiRelease;
    private boolean hasClassPathAttribute;
    private volatile boolean hasCheckedSpecialAttributes;
    private static final String META_INF = "META-INF/";
    private static final String META_INF_VERSIONS = "META-INF/versions/";
    public static final String MANIFEST_NAME = "META-INF/MANIFEST.MF";
    private static final byte[] CLASSPATH_CHARS;
    private static final byte[] CLASSPATH_LASTOCC;
    private static final byte[] CLASSPATH_OPTOSFT;
    private static final byte[] MULTIRELEASE_CHARS;
    private static final byte[] MULTIRELEASE_LASTOCC;
    private static final byte[] MULTIRELEASE_OPTOSFT;

    public static Runtime.Version baseVersion() {
        return BASE_VERSION;
    }

    public static Runtime.Version runtimeVersion() {
        return RUNTIME_VERSION;
    }

    public JarFile(String name) throws IOException {
        this(new File(name), true, 1);
    }

    public JarFile(String name, boolean verify) throws IOException {
        this(new File(name), verify, 1);
    }

    public JarFile(File file) throws IOException {
        this(file, true, 1);
    }

    public JarFile(File file, boolean verify) throws IOException {
        this(file, verify, 1);
    }

    public JarFile(File file, boolean verify, int mode) throws IOException {
        this(file, verify, mode, BASE_VERSION);
    }

    public JarFile(File file, boolean verify, int mode, Runtime.Version version) throws IOException {
        super(file, mode);
        this.verify = verify;
        Objects.requireNonNull(version);
        this.version = MULTI_RELEASE_FORCED || version.major() == RUNTIME_VERSION.major() ? RUNTIME_VERSION : (version.major() <= BASE_VERSION_MAJOR ? BASE_VERSION : Runtime.Version.parse(Integer.toString(version.major())));
        this.versionMajor = this.version.major();
    }

    public final Runtime.Version getVersion() {
        return this.isMultiRelease() ? this.version : BASE_VERSION;
    }

    public final boolean isMultiRelease() {
        if (this.isMultiRelease) {
            return true;
        }
        if (MULTI_RELEASE_ENABLED) {
            try {
                this.checkForSpecialAttributes();
            }
            catch (IOException io) {
                this.isMultiRelease = false;
            }
        }
        return this.isMultiRelease;
    }

    public Manifest getManifest() throws IOException {
        return this.getManifestFromReference();
    }

    private Manifest getManifestFromReference() throws IOException {
        JarEntry manEntry;
        Manifest man;
        Manifest manifest = man = this.manRef != null ? this.manRef.get() : null;
        if (man == null && (manEntry = this.getManEntry()) != null) {
            if (this.verify) {
                byte[] b = this.getBytes(manEntry);
                man = new Manifest(new ByteArrayInputStream(b));
                if (!this.jvInitialized) {
                    this.jv = new JarVerifier(b);
                }
            } else {
                man = new Manifest(super.getInputStream(manEntry));
            }
            this.manRef = new SoftReference<Manifest>(man);
        }
        return man;
    }

    private String[] getMetaInfEntryNames() {
        return SharedSecrets.getJavaUtilZipFileAccess().getMetaInfEntryNames((ZipFile)this);
    }

    public JarEntry getJarEntry(String name) {
        return (JarEntry)this.getEntry(name);
    }

    @Override
    public ZipEntry getEntry(String name) {
        ZipEntry vze;
        ZipEntry ze = super.getEntry(name);
        if (ze != null) {
            return new JarFileEntry(ze);
        }
        if (this.isMultiRelease() && (ze = new ZipEntry(name)) != (vze = this.getVersionedEntry(ze))) {
            return new JarFileEntry(name, vze);
        }
        return null;
    }

    public Enumeration<JarEntry> entries() {
        return new JarEntryIterator();
    }

    public Stream<JarEntry> stream() {
        return StreamSupport.stream(Spliterators.spliterator(new JarEntryIterator(), (long)this.size(), 1297), false);
    }

    private ZipEntry searchForVersionedEntry(int version, String name) {
        ZipEntry vze = null;
        String sname = "/" + name;
        for (int i = version; i > BASE_VERSION_MAJOR && (vze = super.getEntry(META_INF_VERSIONS + i + sname)) == null; --i) {
        }
        return vze;
    }

    private ZipEntry getVersionedEntry(ZipEntry ze) {
        String name;
        ZipEntry vze = null;
        if (BASE_VERSION_MAJOR < this.versionMajor && !(name = ze.getName()).startsWith(META_INF)) {
            vze = this.searchForVersionedEntry(this.versionMajor, name);
        }
        return vze == null ? ze : vze;
    }

    String getRealName(JarEntry entry) {
        if (entry instanceof JarFileEntry) {
            return ((JarFileEntry)entry).realName();
        }
        return entry.getName();
    }

    private void maybeInstantiateVerifier() throws IOException {
        if (this.jv != null) {
            return;
        }
        if (this.verify) {
            String[] names = this.getMetaInfEntryNames();
            if (names != null) {
                for (String nameLower : names) {
                    String name = nameLower.toUpperCase(Locale.ENGLISH);
                    if (!name.endsWith(".DSA") && !name.endsWith(".RSA") && !name.endsWith(".EC") && !name.endsWith(".SF")) continue;
                    this.getManifest();
                    return;
                }
            }
            this.verify = false;
        }
    }

    private void initializeVerifier() {
        block10: {
            ManifestEntryVerifier mev = null;
            try {
                String[] names = this.getMetaInfEntryNames();
                if (names != null) {
                    for (String name : names) {
                        byte[] b;
                        String uname = name.toUpperCase(Locale.ENGLISH);
                        if (!MANIFEST_NAME.equals(uname) && !SignatureFileVerifier.isBlockOrSF(uname)) continue;
                        JarEntry e = this.getJarEntry(name);
                        if (e == null) {
                            throw new JarException("corrupted jar file");
                        }
                        if (mev == null) {
                            mev = new ManifestEntryVerifier(this.getManifestFromReference());
                        }
                        if ((b = this.getBytes(e)) == null || b.length <= 0) continue;
                        this.jv.beginEntry(e, mev);
                        this.jv.update(b.length, b, 0, b.length, mev);
                        this.jv.update(-1, null, 0, 0, mev);
                    }
                }
            }
            catch (IOException ex) {
                this.jv = null;
                this.verify = false;
                if (JarVerifier.debug == null) break block10;
                JarVerifier.debug.println("jarfile parsing error!");
                ex.printStackTrace();
            }
        }
        if (this.jv != null) {
            this.jv.doneWithMeta();
            if (JarVerifier.debug != null) {
                JarVerifier.debug.println("done with meta!");
            }
            if (this.jv.nothingToVerify()) {
                if (JarVerifier.debug != null) {
                    JarVerifier.debug.println("nothing to verify!");
                }
                this.jv = null;
                this.verify = false;
            }
        }
    }

    private byte[] getBytes(ZipEntry ze) throws IOException {
        try (InputStream is = super.getInputStream(ze);){
            int bytesRead;
            byte[] b;
            int len = (int)ze.getSize();
            if (len != -1 && len <= 65535) {
                b = new byte[len];
                bytesRead = is.readNBytes(b, 0, len);
            } else {
                b = is.readAllBytes();
                bytesRead = b.length;
            }
            if (len != -1 && len != bytesRead) {
                throw new EOFException("Expected:" + len + ", read:" + bytesRead);
            }
            byte[] byArray = b;
            return byArray;
        }
    }

    @Override
    public synchronized InputStream getInputStream(ZipEntry ze) throws IOException {
        this.maybeInstantiateVerifier();
        if (this.jv == null) {
            return super.getInputStream(ze);
        }
        if (!this.jvInitialized) {
            this.initializeVerifier();
            this.jvInitialized = true;
            if (this.jv == null) {
                return super.getInputStream(ze);
            }
        }
        return new JarVerifier.VerifierStream(this.getManifestFromReference(), this.verifiableEntry(ze), super.getInputStream(ze), this.jv);
    }

    private JarEntry verifiableEntry(ZipEntry ze) {
        if (ze instanceof JarFileEntry) {
            return ((JarFileEntry)ze).realEntry();
        }
        if ((ze = this.getJarEntry(ze.getName())) instanceof JarFileEntry) {
            return ((JarFileEntry)ze).realEntry();
        }
        return (JarEntry)ze;
    }

    private JarEntry getManEntry() {
        if (this.manEntry == null) {
            String[] names;
            ZipEntry manEntry = super.getEntry(MANIFEST_NAME);
            if (manEntry == null && (names = this.getMetaInfEntryNames()) != null) {
                for (String name : names) {
                    if (!MANIFEST_NAME.equals(name.toUpperCase(Locale.ENGLISH))) continue;
                    manEntry = super.getEntry(name);
                    break;
                }
            }
            this.manEntry = manEntry == null ? null : new JarFileEntry(manEntry.getName(), manEntry);
        }
        return this.manEntry;
    }

    boolean hasClassPathAttribute() throws IOException {
        this.checkForSpecialAttributes();
        return this.hasClassPathAttribute;
    }

    private int match(byte[] src, byte[] b, byte[] lastOcc, byte[] optoSft) {
        int len = src.length;
        int last = b.length - len;
        int i = 0;
        block0: while (i <= last) {
            for (int j = len - 1; j >= 0; --j) {
                byte c = b[i + j];
                if (c >= 32 && c <= 122) {
                    if (c >= 97) {
                        c = (byte)(c - 32);
                    }
                    if (c == src[j]) continue;
                    byte badShift = lastOcc[c - 32];
                    i += Math.max(j + 1 - badShift, optoSft[j]);
                    continue block0;
                }
                i += len;
                continue block0;
            }
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkForSpecialAttributes() throws IOException {
        if (this.hasCheckedSpecialAttributes) {
            return;
        }
        JarFile jarFile = this;
        synchronized (jarFile) {
            if (this.hasCheckedSpecialAttributes) {
                return;
            }
            JarEntry manEntry = this.getManEntry();
            if (manEntry != null) {
                int i;
                byte[] b = this.getBytes(manEntry);
                boolean bl = this.hasClassPathAttribute = this.match(CLASSPATH_CHARS, b, CLASSPATH_LASTOCC, CLASSPATH_OPTOSFT) != -1;
                if (MULTI_RELEASE_ENABLED && (i = this.match(MULTIRELEASE_CHARS, b, MULTIRELEASE_LASTOCC, MULTIRELEASE_OPTOSFT)) != -1 && (i += MULTIRELEASE_CHARS.length) < b.length) {
                    byte c;
                    if ((c = b[i++]) == 10 && (i == b.length || b[i] != 32)) {
                        this.isMultiRelease = true;
                    } else if (c == 13) {
                        if (i == b.length) {
                            this.isMultiRelease = true;
                        } else if ((c = b[i++]) == 10) {
                            if (i == b.length || b[i] != 32) {
                                this.isMultiRelease = true;
                            }
                        } else if (c != 32) {
                            this.isMultiRelease = true;
                        }
                    }
                }
            }
            this.hasCheckedSpecialAttributes = true;
        }
    }

    private synchronized void ensureInitialization() {
        try {
            this.maybeInstantiateVerifier();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (this.jv != null && !this.jvInitialized) {
            this.initializeVerifier();
            this.jvInitialized = true;
        }
    }

    JarEntry newEntry(ZipEntry ze) {
        return new JarFileEntry(ze);
    }

    Enumeration<String> entryNames(CodeSource[] cs) {
        this.ensureInitialization();
        if (this.jv != null) {
            return this.jv.entryNames(this, cs);
        }
        boolean includeUnsigned = false;
        for (CodeSource c : cs) {
            if (c.getCodeSigners() != null) continue;
            includeUnsigned = true;
            break;
        }
        if (includeUnsigned) {
            return this.unsignedEntryNames();
        }
        return new Enumeration<String>(){

            @Override
            public boolean hasMoreElements() {
                return false;
            }

            @Override
            public String nextElement() {
                throw new NoSuchElementException();
            }
        };
    }

    Enumeration<JarEntry> entries2() {
        this.ensureInitialization();
        if (this.jv != null) {
            return this.jv.entries2(this, super.entries());
        }
        final Enumeration<? extends ZipEntry> enum_ = super.entries();
        return new Enumeration<JarEntry>(){
            ZipEntry entry;

            @Override
            public boolean hasMoreElements() {
                if (this.entry != null) {
                    return true;
                }
                while (enum_.hasMoreElements()) {
                    ZipEntry ze = (ZipEntry)enum_.nextElement();
                    if (JarVerifier.isSigningRelated(ze.getName())) continue;
                    this.entry = ze;
                    return true;
                }
                return false;
            }

            @Override
            public JarFileEntry nextElement() {
                if (this.hasMoreElements()) {
                    ZipEntry ze = this.entry;
                    this.entry = null;
                    return new JarFileEntry(ze);
                }
                throw new NoSuchElementException();
            }
        };
    }

    CodeSource[] getCodeSources(URL url) {
        this.ensureInitialization();
        if (this.jv != null) {
            return this.jv.getCodeSources(this, url);
        }
        Enumeration<String> unsigned = this.unsignedEntryNames();
        if (unsigned.hasMoreElements()) {
            return new CodeSource[]{JarVerifier.getUnsignedCS(url)};
        }
        return null;
    }

    private Enumeration<String> unsignedEntryNames() {
        final Enumeration<JarEntry> entries = this.entries();
        return new Enumeration<String>(){
            String name;

            @Override
            public boolean hasMoreElements() {
                if (this.name != null) {
                    return true;
                }
                while (entries.hasMoreElements()) {
                    ZipEntry e = (ZipEntry)entries.nextElement();
                    String value = e.getName();
                    if (e.isDirectory() || JarVerifier.isSigningRelated(value)) continue;
                    this.name = value;
                    return true;
                }
                return false;
            }

            @Override
            public String nextElement() {
                if (this.hasMoreElements()) {
                    String value = this.name;
                    this.name = null;
                    return value;
                }
                throw new NoSuchElementException();
            }
        };
    }

    CodeSource getCodeSource(URL url, String name) {
        this.ensureInitialization();
        if (this.jv != null) {
            if (this.jv.eagerValidation) {
                CodeSource cs = null;
                JarEntry je = this.getJarEntry(name);
                cs = je != null ? this.jv.getCodeSource(url, this, je) : this.jv.getCodeSource(url, name);
                return cs;
            }
            return this.jv.getCodeSource(url, name);
        }
        return JarVerifier.getUnsignedCS(url);
    }

    void setEagerValidation(boolean eager) {
        try {
            this.maybeInstantiateVerifier();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (this.jv != null) {
            this.jv.setEagerValidation(eager);
        }
    }

    List<Object> getManifestDigests() {
        this.ensureInitialization();
        if (this.jv != null) {
            return this.jv.getManifestDigests();
        }
        return new ArrayList<Object>();
    }

    static {
        int i;
        String enableMultiRelease;
        SharedSecrets.setJavaUtilJarAccess((JavaUtilJarAccess)new JavaUtilJarAccessImpl());
        BASE_VERSION = Runtime.Version.parse(Integer.toString(8));
        BASE_VERSION_MAJOR = BASE_VERSION.major();
        String jarVersion = GetPropertyAction.privilegedGetProperty("jdk.util.jar.version");
        int runtimeVersion = Runtime.version().major();
        if (jarVersion != null) {
            int jarVer = Integer.parseInt(jarVersion);
            runtimeVersion = jarVer > runtimeVersion ? runtimeVersion : Math.max(jarVer, BASE_VERSION_MAJOR);
        }
        RUNTIME_VERSION = Runtime.Version.parse(Integer.toString(runtimeVersion));
        switch (enableMultiRelease = GetPropertyAction.privilegedGetProperty("jdk.util.jar.enableMultiRelease", "true")) {
            default: {
                MULTI_RELEASE_ENABLED = true;
                MULTI_RELEASE_FORCED = false;
                break;
            }
            case "false": {
                MULTI_RELEASE_ENABLED = false;
                MULTI_RELEASE_FORCED = false;
                break;
            }
            case "force": {
                MULTI_RELEASE_ENABLED = true;
                MULTI_RELEASE_FORCED = true;
            }
        }
        CLASSPATH_CHARS = new byte[]{67, 76, 65, 83, 83, 45, 80, 65, 84, 72, 58, 32};
        MULTIRELEASE_CHARS = new byte[]{77, 85, 76, 84, 73, 45, 82, 69, 76, 69, 65, 83, 69, 58, 32, 84, 82, 85, 69};
        CLASSPATH_LASTOCC = new byte[64];
        CLASSPATH_OPTOSFT = new byte[12];
        JarFile.CLASSPATH_LASTOCC[35] = 1;
        JarFile.CLASSPATH_LASTOCC[44] = 2;
        JarFile.CLASSPATH_LASTOCC[51] = 5;
        JarFile.CLASSPATH_LASTOCC[13] = 6;
        JarFile.CLASSPATH_LASTOCC[48] = 7;
        JarFile.CLASSPATH_LASTOCC[33] = 8;
        JarFile.CLASSPATH_LASTOCC[52] = 9;
        JarFile.CLASSPATH_LASTOCC[40] = 10;
        JarFile.CLASSPATH_LASTOCC[26] = 11;
        JarFile.CLASSPATH_LASTOCC[0] = 12;
        for (i = 0; i < 11; ++i) {
            JarFile.CLASSPATH_OPTOSFT[i] = 12;
        }
        JarFile.CLASSPATH_OPTOSFT[11] = 1;
        MULTIRELEASE_LASTOCC = new byte[64];
        MULTIRELEASE_OPTOSFT = new byte[19];
        JarFile.MULTIRELEASE_LASTOCC[45] = 1;
        JarFile.MULTIRELEASE_LASTOCC[41] = 5;
        JarFile.MULTIRELEASE_LASTOCC[13] = 6;
        JarFile.MULTIRELEASE_LASTOCC[44] = 9;
        JarFile.MULTIRELEASE_LASTOCC[33] = 11;
        JarFile.MULTIRELEASE_LASTOCC[51] = 12;
        JarFile.MULTIRELEASE_LASTOCC[26] = 14;
        JarFile.MULTIRELEASE_LASTOCC[0] = 15;
        JarFile.MULTIRELEASE_LASTOCC[52] = 16;
        JarFile.MULTIRELEASE_LASTOCC[50] = 17;
        JarFile.MULTIRELEASE_LASTOCC[53] = 18;
        JarFile.MULTIRELEASE_LASTOCC[37] = 19;
        for (i = 0; i < 17; ++i) {
            JarFile.MULTIRELEASE_OPTOSFT[i] = 19;
        }
        JarFile.MULTIRELEASE_OPTOSFT[17] = 6;
        JarFile.MULTIRELEASE_OPTOSFT[18] = 1;
    }

    private class JarFileEntry
    extends JarEntry {
        private final String name;

        JarFileEntry(ZipEntry ze) {
            super(JarFile.this.isMultiRelease() ? JarFile.this.getVersionedEntry(ze) : ze);
            this.name = ze.getName();
        }

        JarFileEntry(String name, ZipEntry vze) {
            super(vze);
            this.name = name;
        }

        @Override
        public Attributes getAttributes() throws IOException {
            Manifest man = JarFile.this.getManifest();
            if (man != null) {
                return man.getAttributes(super.getName());
            }
            return null;
        }

        @Override
        public Certificate[] getCertificates() {
            try {
                JarFile.this.maybeInstantiateVerifier();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (this.certs == null && JarFile.this.jv != null) {
                this.certs = JarFile.this.jv.getCerts(JarFile.this, this.realEntry());
            }
            return this.certs == null ? null : (Certificate[])this.certs.clone();
        }

        @Override
        public CodeSigner[] getCodeSigners() {
            try {
                JarFile.this.maybeInstantiateVerifier();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (this.signers == null && JarFile.this.jv != null) {
                this.signers = JarFile.this.jv.getCodeSigners(JarFile.this, this.realEntry());
            }
            return this.signers == null ? null : (CodeSigner[])this.signers.clone();
        }

        JarFileEntry realEntry() {
            if (JarFile.this.isMultiRelease() && JarFile.this.versionMajor != BASE_VERSION_MAJOR) {
                String entryName = super.getName();
                return entryName.equals(this.name) ? this : new JarFileEntry(entryName, this);
            }
            return this;
        }

        String realName() {
            return super.getName();
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    private class JarEntryIterator
    implements Enumeration<JarEntry>,
    Iterator<JarEntry> {
        final Enumeration<? extends ZipEntry> e;

        private JarEntryIterator() {
            this.e = JarFile.super.entries();
        }

        @Override
        public boolean hasNext() {
            return this.e.hasMoreElements();
        }

        @Override
        public JarEntry next() {
            ZipEntry ze = this.e.nextElement();
            return new JarFileEntry(ze.getName(), ze);
        }

        @Override
        public boolean hasMoreElements() {
            return this.hasNext();
        }

        @Override
        public JarEntry nextElement() {
            return this.next();
        }

        @Override
        public Iterator<JarEntry> asIterator() {
            return this;
        }
    }
}

