/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.locks;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReadWriteLock;
import jdk.internal.vm.annotation.ReservedStackAccess;

public class StampedLock
implements Serializable {
    private static final long serialVersionUID = -6001602636862214147L;
    private static final int NCPU = Runtime.getRuntime().availableProcessors();
    private static final int SPINS = NCPU > 1 ? 64 : 1;
    private static final int HEAD_SPINS = NCPU > 1 ? 1024 : 1;
    private static final int MAX_HEAD_SPINS = NCPU > 1 ? 65536 : 1;
    private static final int OVERFLOW_YIELD_RATE = 7;
    private static final int LG_READERS = 7;
    private static final long RUNIT = 1L;
    private static final long WBIT = 128L;
    private static final long RBITS = 127L;
    private static final long RFULL = 126L;
    private static final long ABITS = 255L;
    private static final long SBITS = -128L;
    private static final long ORIGIN = 256L;
    private static final long INTERRUPTED = 1L;
    private static final int WAITING = -1;
    private static final int CANCELLED = 1;
    private static final int RMODE = 0;
    private static final int WMODE = 1;
    private volatile transient WNode whead;
    private volatile transient WNode wtail;
    transient ReadLockView readLockView;
    transient WriteLockView writeLockView;
    transient ReadWriteLockView readWriteLockView;
    private volatile transient long state = 256L;
    private transient int readerOverflow;
    private static final VarHandle STATE;
    private static final VarHandle WHEAD;
    private static final VarHandle WTAIL;
    private static final VarHandle WNEXT;
    private static final VarHandle WSTATUS;
    private static final VarHandle WCOWAIT;

    private boolean casState(long expectedValue, long newValue) {
        return STATE.compareAndSet(this, expectedValue, newValue);
    }

    private long tryWriteLock(long s) {
        long next = s | 0x80L;
        if (this.casState(s, next)) {
            VarHandle.storeStoreFence();
            return next;
        }
        return 0L;
    }

    @ReservedStackAccess
    public long writeLock() {
        long next = this.tryWriteLock();
        return next != 0L ? next : this.acquireWrite(false, 0L);
    }

    @ReservedStackAccess
    public long tryWriteLock() {
        long s = this.state;
        return (s & 0xFFL) == 0L ? this.tryWriteLock(s) : 0L;
    }

    public long tryWriteLock(long time, TimeUnit unit) throws InterruptedException {
        long nanos = unit.toNanos(time);
        if (!Thread.interrupted()) {
            long next = this.tryWriteLock();
            if (next != 0L) {
                return next;
            }
            if (nanos <= 0L) {
                return 0L;
            }
            long deadline = System.nanoTime() + nanos;
            if (deadline == 0L) {
                deadline = 1L;
            }
            if ((next = this.acquireWrite(true, deadline)) != 1L) {
                return next;
            }
        }
        throw new InterruptedException();
    }

    @ReservedStackAccess
    public long writeLockInterruptibly() throws InterruptedException {
        long next;
        if (!Thread.interrupted() && (next = this.acquireWrite(true, 0L)) != 1L) {
            return next;
        }
        throw new InterruptedException();
    }

    @ReservedStackAccess
    public long readLock() {
        long next;
        long s;
        return this.whead == this.wtail && ((s = this.state) & 0xFFL) < 126L && this.casState(s, next = s + 1L) ? next : this.acquireRead(false, 0L);
    }

    @ReservedStackAccess
    public long tryReadLock() {
        long s;
        long m;
        while ((m = (s = this.state) & 0xFFL) != 128L) {
            long next;
            if (!(m < 126L ? this.casState(s, next = s + 1L) : (next = this.tryIncReaderOverflow(s)) != 0L)) continue;
            return next;
        }
        return 0L;
    }

    @ReservedStackAccess
    public long tryReadLock(long time, TimeUnit unit) throws InterruptedException {
        long nanos = unit.toNanos(time);
        if (!Thread.interrupted()) {
            long next;
            long s = this.state;
            long m = s & 0xFFL;
            if (m != 128L && (m < 126L ? this.casState(s, next = s + 1L) : (next = this.tryIncReaderOverflow(s)) != 0L)) {
                return next;
            }
            if (nanos <= 0L) {
                return 0L;
            }
            long deadline = System.nanoTime() + nanos;
            if (deadline == 0L) {
                deadline = 1L;
            }
            if ((next = this.acquireRead(true, deadline)) != 1L) {
                return next;
            }
        }
        throw new InterruptedException();
    }

    @ReservedStackAccess
    public long readLockInterruptibly() throws InterruptedException {
        long next;
        long s;
        if (!Thread.interrupted() && (this.whead == this.wtail && ((s = this.state) & 0xFFL) < 126L && this.casState(s, next = s + 1L) || (next = this.acquireRead(true, 0L)) != 1L)) {
            return next;
        }
        throw new InterruptedException();
    }

    public long tryOptimisticRead() {
        long s = this.state;
        return (s & 0x80L) == 0L ? s & 0xFFFFFFFFFFFFFF80L : 0L;
    }

    public boolean validate(long stamp) {
        VarHandle.acquireFence();
        return (stamp & 0xFFFFFFFFFFFFFF80L) == (this.state & 0xFFFFFFFFFFFFFF80L);
    }

    private static long unlockWriteState(long s) {
        return (s += 128L) == 0L ? 256L : s;
    }

    private long unlockWriteInternal(long s) {
        long next = StampedLock.unlockWriteState(s);
        STATE.setVolatile(this, next);
        WNode h = this.whead;
        if (h != null && h.status != 0) {
            this.release(h);
        }
        return next;
    }

    @ReservedStackAccess
    public void unlockWrite(long stamp) {
        if (this.state != stamp || (stamp & 0x80L) == 0L) {
            throw new IllegalMonitorStateException();
        }
        this.unlockWriteInternal(stamp);
    }

    @ReservedStackAccess
    public void unlockRead(long stamp) {
        long m;
        long s;
        while (((s = this.state) & 0xFFFFFFFFFFFFFF80L) == (stamp & 0xFFFFFFFFFFFFFF80L) && (stamp & 0x7FL) > 0L && (m = s & 0x7FL) > 0L) {
            if (m < 126L) {
                WNode h;
                if (!this.casState(s, s - 1L)) continue;
                if (m == 1L && (h = this.whead) != null && h.status != 0) {
                    this.release(h);
                }
                return;
            }
            if (this.tryDecReaderOverflow(s) == 0L) continue;
            return;
        }
        throw new IllegalMonitorStateException();
    }

    @ReservedStackAccess
    public void unlock(long stamp) {
        if ((stamp & 0x80L) != 0L) {
            this.unlockWrite(stamp);
        } else {
            this.unlockRead(stamp);
        }
    }

    public long tryConvertToWriteLock(long stamp) {
        long s;
        long a = stamp & 0xFFL;
        while (((s = this.state) & 0xFFFFFFFFFFFFFF80L) == (stamp & 0xFFFFFFFFFFFFFF80L)) {
            long next;
            long m = s & 0xFFL;
            if (m == 0L) {
                if (a != 0L) break;
                next = this.tryWriteLock(s);
                if (next == 0L) continue;
                return next;
            }
            if (m == 128L) {
                if (a != m) break;
                return stamp;
            }
            if (m != 1L || a == 0L) break;
            next = s - 1L + 128L;
            if (!this.casState(s, next)) continue;
            VarHandle.storeStoreFence();
            return next;
        }
        return 0L;
    }

    public long tryConvertToReadLock(long stamp) {
        long s;
        while (((s = this.state) & 0xFFFFFFFFFFFFFF80L) == (stamp & 0xFFFFFFFFFFFFFF80L)) {
            long next;
            long a = stamp & 0xFFL;
            if (a >= 128L) {
                if (s != stamp) break;
                next = StampedLock.unlockWriteState(s) + 1L;
                STATE.setVolatile(this, next);
                WNode h = this.whead;
                if (h != null && h.status != 0) {
                    this.release(h);
                }
                return next;
            }
            if (a == 0L) {
                if (!((s & 0xFFL) < 126L ? this.casState(s, next = s + 1L) : (next = this.tryIncReaderOverflow(s)) != 0L)) continue;
                return next;
            }
            if ((s & 0xFFL) == 0L) break;
            return stamp;
        }
        return 0L;
    }

    public long tryConvertToOptimisticRead(long stamp) {
        long s;
        VarHandle.acquireFence();
        while (((s = this.state) & 0xFFFFFFFFFFFFFF80L) == (stamp & 0xFFFFFFFFFFFFFF80L)) {
            long next;
            long a = stamp & 0xFFL;
            if (a >= 128L) {
                if (s != stamp) break;
                return this.unlockWriteInternal(s);
            }
            if (a == 0L) {
                return stamp;
            }
            long m = s & 0xFFL;
            if (m == 0L) break;
            if (m < 126L) {
                WNode h;
                next = s - 1L;
                if (!this.casState(s, next)) continue;
                if (m == 1L && (h = this.whead) != null && h.status != 0) {
                    this.release(h);
                }
                return next & 0xFFFFFFFFFFFFFF80L;
            }
            next = this.tryDecReaderOverflow(s);
            if (next == 0L) continue;
            return next & 0xFFFFFFFFFFFFFF80L;
        }
        return 0L;
    }

    @ReservedStackAccess
    public boolean tryUnlockWrite() {
        long s = this.state;
        if ((s & 0x80L) != 0L) {
            this.unlockWriteInternal(s);
            return true;
        }
        return false;
    }

    @ReservedStackAccess
    public boolean tryUnlockRead() {
        long s;
        long m;
        while ((m = (s = this.state) & 0xFFL) != 0L && m < 128L) {
            if (m < 126L) {
                WNode h;
                if (!this.casState(s, s - 1L)) continue;
                if (m == 1L && (h = this.whead) != null && h.status != 0) {
                    this.release(h);
                }
                return true;
            }
            if (this.tryDecReaderOverflow(s) == 0L) continue;
            return true;
        }
        return false;
    }

    private int getReadLockCount(long s) {
        long readers = s & 0x7FL;
        if (readers >= 126L) {
            readers = 126L + (long)this.readerOverflow;
        }
        return (int)readers;
    }

    public boolean isWriteLocked() {
        return (this.state & 0x80L) != 0L;
    }

    public boolean isReadLocked() {
        return (this.state & 0x7FL) != 0L;
    }

    public int getReadLockCount() {
        return this.getReadLockCount(this.state);
    }

    public String toString() {
        long s = this.state;
        return super.toString() + ((s & 0xFFL) == 0L ? "[Unlocked]" : ((s & 0x80L) != 0L ? "[Write-locked]" : "[Read-locks:" + this.getReadLockCount(s) + "]"));
    }

    public Lock asReadLock() {
        ReadLockView v = this.readLockView;
        if (v != null) {
            return v;
        }
        this.readLockView = new ReadLockView();
        return this.readLockView;
    }

    public Lock asWriteLock() {
        WriteLockView v = this.writeLockView;
        if (v != null) {
            return v;
        }
        this.writeLockView = new WriteLockView();
        return this.writeLockView;
    }

    public ReadWriteLock asReadWriteLock() {
        ReadWriteLockView v = this.readWriteLockView;
        if (v != null) {
            return v;
        }
        this.readWriteLockView = new ReadWriteLockView();
        return this.readWriteLockView;
    }

    final void unstampedUnlockWrite() {
        long s = this.state;
        if ((s & 0x80L) == 0L) {
            throw new IllegalMonitorStateException();
        }
        this.unlockWriteInternal(s);
    }

    final void unstampedUnlockRead() {
        long s;
        long m;
        while ((m = (s = this.state) & 0x7FL) > 0L) {
            if (m < 126L) {
                WNode h;
                if (!this.casState(s, s - 1L)) continue;
                if (m == 1L && (h = this.whead) != null && h.status != 0) {
                    this.release(h);
                }
                return;
            }
            if (this.tryDecReaderOverflow(s) == 0L) continue;
            return;
        }
        throw new IllegalMonitorStateException();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        STATE.setVolatile(this, 256L);
    }

    private long tryIncReaderOverflow(long s) {
        if ((s & 0xFFL) == 126L) {
            if (this.casState(s, s | 0x7FL)) {
                ++this.readerOverflow;
                STATE.setVolatile(this, s);
                return s;
            }
        } else if ((LockSupport.nextSecondarySeed() & 7) == 0) {
            Thread.yield();
        } else {
            Thread.onSpinWait();
        }
        return 0L;
    }

    private long tryDecReaderOverflow(long s) {
        if ((s & 0xFFL) == 126L) {
            if (this.casState(s, s | 0x7FL)) {
                long next;
                int r = this.readerOverflow;
                if (r > 0) {
                    this.readerOverflow = r - 1;
                    next = s;
                } else {
                    next = s - 1L;
                }
                STATE.setVolatile(this, next);
                return next;
            }
        } else if ((LockSupport.nextSecondarySeed() & 7) == 0) {
            Thread.yield();
        } else {
            Thread.onSpinWait();
        }
        return 0L;
    }

    private void release(WNode h) {
        if (h != null) {
            Thread w;
            WSTATUS.compareAndSet(h, -1, 0);
            WNode q = h.next;
            if (q == null || q.status == 1) {
                WNode t = this.wtail;
                while (t != null && t != h) {
                    if (t.status <= 0) {
                        q = t;
                    }
                    t = t.prev;
                }
            }
            if (q != null && (w = q.thread) != null) {
                LockSupport.unpark(w);
            }
        }
    }

    private long acquireWrite(boolean interruptible, long deadline) {
        WNode p;
        WNode node = null;
        int spins = -1;
        while (true) {
            long s;
            long m;
            if ((m = (s = this.state) & 0xFFL) == 0L) {
                long ns = this.tryWriteLock(s);
                if (ns == 0L) continue;
                return ns;
            }
            if (spins < 0) {
                spins = m == 128L && this.wtail == this.whead ? SPINS : 0;
                continue;
            }
            if (spins > 0) {
                --spins;
                Thread.onSpinWait();
                continue;
            }
            p = this.wtail;
            if (p == null) {
                WNode hd = new WNode(1, null);
                if (!WHEAD.weakCompareAndSet(this, null, hd)) continue;
                this.wtail = hd;
                continue;
            }
            if (node == null) {
                node = new WNode(1, p);
                continue;
            }
            if (node.prev != p) {
                node.prev = p;
                continue;
            }
            if (WTAIL.weakCompareAndSet(this, p, node)) break;
        }
        p.next = node;
        boolean wasInterrupted = false;
        int spins2 = -1;
        while (true) {
            Thread wt;
            long time;
            WNode h;
            if ((h = this.whead) == p) {
                if (spins2 < 0) {
                    spins2 = HEAD_SPINS;
                } else if (spins2 < MAX_HEAD_SPINS) {
                    spins2 <<= 1;
                }
                for (int k = spins2; k > 0; --k) {
                    long s = this.state;
                    if ((s & 0xFFL) == 0L) {
                        long ns = this.tryWriteLock(s);
                        if (ns == 0L) continue;
                        this.whead = node;
                        node.prev = null;
                        if (wasInterrupted) {
                            Thread.currentThread().interrupt();
                        }
                        return ns;
                    }
                    Thread.onSpinWait();
                }
            } else if (h != null) {
                WNode c;
                while ((c = h.cowait) != null) {
                    Thread w;
                    if (!WCOWAIT.weakCompareAndSet(h, c, c.cowait) || (w = c.thread) == null) continue;
                    LockSupport.unpark(w);
                }
            }
            if (this.whead != h) continue;
            WNode np = node.prev;
            if (np != p) {
                if (np == null) continue;
                p = np;
                np.next = node;
                continue;
            }
            int ps = p.status;
            if (ps == 0) {
                WSTATUS.compareAndSet(p, 0, -1);
                continue;
            }
            if (ps == 1) {
                WNode pp = p.prev;
                if (pp == null) continue;
                node.prev = pp;
                pp.next = node;
                continue;
            }
            if (deadline == 0L) {
                time = 0L;
            } else {
                time = deadline - System.nanoTime();
                if (time <= 0L) {
                    return this.cancelWaiter(node, node, false);
                }
            }
            node.thread = wt = Thread.currentThread();
            if (p.status < 0 && (p != h || (this.state & 0xFFL) != 0L) && this.whead == h && node.prev == p) {
                if (time == 0L) {
                    LockSupport.park(this);
                } else {
                    LockSupport.parkNanos(this, time);
                }
            }
            node.thread = null;
            if (!Thread.interrupted()) continue;
            if (interruptible) {
                return this.cancelWaiter(node, node, true);
            }
            wasInterrupted = true;
        }
    }

    private long acquireRead(boolean interruptible, long deadline) {
        WNode p;
        WNode h;
        boolean wasInterrupted = false;
        WNode node = null;
        int spins = -1;
        block0: while (true) {
            if ((h = this.whead) == (p = this.wtail)) {
                while (true) {
                    long ns;
                    long s;
                    long m;
                    if ((m = (s = this.state) & 0xFFL) < 126L ? this.casState(s, ns = s + 1L) : m < 128L && (ns = this.tryIncReaderOverflow(s)) != 0L) {
                        if (wasInterrupted) {
                            Thread.currentThread().interrupt();
                        }
                        return ns;
                    }
                    if (m < 128L) continue;
                    if (spins > 0) {
                        --spins;
                        Thread.onSpinWait();
                        continue;
                    }
                    if (spins == 0) {
                        WNode nh = this.whead;
                        WNode np = this.wtail;
                        if (nh == h && np == p || (h = nh) != (p = np)) break;
                    }
                    spins = SPINS;
                }
            }
            if (p == null) {
                WNode hd = new WNode(1, null);
                if (!WHEAD.weakCompareAndSet(this, null, hd)) continue;
                this.wtail = hd;
                continue;
            }
            if (node == null) {
                node = new WNode(0, p);
                continue;
            }
            if (h == p || p.mode != 0) {
                if (node.prev != p) {
                    node.prev = p;
                    continue;
                }
                if (!WTAIL.weakCompareAndSet(this, p, node)) continue;
                break;
            }
            node.cowait = p.cowait;
            if (!WCOWAIT.compareAndSet(p, node.cowait, node)) {
                node.cowait = null;
                continue;
            }
            while (true) {
                Thread wt;
                long time;
                WNode pp;
                Thread w;
                WNode c;
                if ((h = this.whead) != null && (c = h.cowait) != null && WCOWAIT.compareAndSet(h, c, c.cowait) && (w = c.thread) != null) {
                    LockSupport.unpark(w);
                }
                if (Thread.interrupted()) {
                    if (interruptible) {
                        return this.cancelWaiter(node, p, true);
                    }
                    wasInterrupted = true;
                }
                if (h == (pp = p.prev) || h == p || pp == null) {
                    long m;
                    do {
                        long ns;
                        long s;
                        if (!((m = (s = this.state) & 0xFFL) < 126L ? this.casState(s, ns = s + 1L) : m < 128L && (ns = this.tryIncReaderOverflow(s)) != 0L)) continue;
                        if (wasInterrupted) {
                            Thread.currentThread().interrupt();
                        }
                        return ns;
                    } while (m < 128L);
                }
                if (this.whead != h || p.prev != pp) continue;
                if (pp == null || h == p || p.status > 0) {
                    node = null;
                    continue block0;
                }
                if (deadline == 0L) {
                    time = 0L;
                } else {
                    time = deadline - System.nanoTime();
                    if (time <= 0L) {
                        if (wasInterrupted) {
                            Thread.currentThread().interrupt();
                        }
                        return this.cancelWaiter(node, p, false);
                    }
                }
                node.thread = wt = Thread.currentThread();
                if ((h != pp || (this.state & 0xFFL) == 128L) && this.whead == h && p.prev == pp) {
                    if (time == 0L) {
                        LockSupport.park(this);
                    } else {
                        LockSupport.parkNanos(this, time);
                    }
                }
                node.thread = null;
            }
            break;
        }
        p.next = node;
        spins = -1;
        while (true) {
            Thread wt;
            long time;
            if ((h = this.whead) == p) {
                if (spins < 0) {
                    spins = HEAD_SPINS;
                } else if (spins < MAX_HEAD_SPINS) {
                    spins <<= 1;
                }
                int k = spins;
                while (true) {
                    long ns;
                    long s;
                    long m;
                    if ((m = (s = this.state) & 0xFFL) < 126L ? this.casState(s, ns = s + 1L) : m < 128L && (ns = this.tryIncReaderOverflow(s)) != 0L) {
                        WNode c;
                        this.whead = node;
                        node.prev = null;
                        while ((c = node.cowait) != null) {
                            Thread w;
                            if (!WCOWAIT.compareAndSet(node, c, c.cowait) || (w = c.thread) == null) continue;
                            LockSupport.unpark(w);
                        }
                        if (wasInterrupted) {
                            Thread.currentThread().interrupt();
                        }
                        return ns;
                    }
                    if (m < 128L || --k > 0) {
                        Thread.onSpinWait();
                        continue;
                    }
                    break;
                }
            } else if (h != null) {
                WNode c;
                while ((c = h.cowait) != null) {
                    Thread w;
                    if (!WCOWAIT.compareAndSet(h, c, c.cowait) || (w = c.thread) == null) continue;
                    LockSupport.unpark(w);
                }
            }
            if (this.whead != h) continue;
            WNode np = node.prev;
            if (np != p) {
                if (np == null) continue;
                p = np;
                np.next = node;
                continue;
            }
            int ps = p.status;
            if (ps == 0) {
                WSTATUS.compareAndSet(p, 0, -1);
                continue;
            }
            if (ps == 1) {
                WNode pp = p.prev;
                if (pp == null) continue;
                node.prev = pp;
                pp.next = node;
                continue;
            }
            if (deadline == 0L) {
                time = 0L;
            } else {
                time = deadline - System.nanoTime();
                if (time <= 0L) {
                    return this.cancelWaiter(node, node, false);
                }
            }
            node.thread = wt = Thread.currentThread();
            if (p.status < 0 && (p != h || (this.state & 0xFFL) == 128L) && this.whead == h && node.prev == p) {
                if (time == 0L) {
                    LockSupport.park(this);
                } else {
                    LockSupport.parkNanos(this, time);
                }
            }
            node.thread = null;
            if (!Thread.interrupted()) continue;
            if (interruptible) {
                return this.cancelWaiter(node, node, true);
            }
            wasInterrupted = true;
        }
    }

    private long cancelWaiter(WNode node, WNode group, boolean interrupted) {
        WNode h;
        if (node != null && group != null) {
            WNode q;
            node.status = 1;
            WNode p = group;
            while ((q = p.cowait) != null) {
                if (q.status == 1) {
                    WCOWAIT.compareAndSet(p, q, q.cowait);
                    p = group;
                    continue;
                }
                p = q;
            }
            if (group == node) {
                Thread w;
                WNode r = group.cowait;
                while (r != null) {
                    w = r.thread;
                    if (w != null) {
                        LockSupport.unpark(w);
                    }
                    r = r.cowait;
                }
                WNode pred = node.prev;
                while (pred != null) {
                    WNode pp;
                    WNode succ;
                    while ((succ = node.next) == null || succ.status == 1) {
                        WNode q2 = null;
                        WNode t = this.wtail;
                        while (t != null && t != node) {
                            if (t.status != 1) {
                                q2 = t;
                            }
                            t = t.prev;
                        }
                        if (succ != q2 && !WNEXT.compareAndSet(node, succ, succ = q2)) continue;
                        if (succ != null || node != this.wtail) break;
                        WTAIL.compareAndSet(this, node, pred);
                        break;
                    }
                    if (pred.next == node) {
                        WNEXT.compareAndSet(pred, node, succ);
                    }
                    if (succ != null && (w = succ.thread) != null) {
                        succ.thread = null;
                        LockSupport.unpark(w);
                    }
                    if (pred.status != 1 || (pp = pred.prev) == null) break;
                    node.prev = pp;
                    WNEXT.compareAndSet(pp, pred, succ);
                    pred = pp;
                }
            }
        }
        while ((h = this.whead) != null) {
            long s;
            WNode q = h.next;
            if (q == null || q.status == 1) {
                WNode t = this.wtail;
                while (t != null && t != h) {
                    if (t.status <= 0) {
                        q = t;
                    }
                    t = t.prev;
                }
            }
            if (h != this.whead) continue;
            if (q == null || h.status != 0 || ((s = this.state) & 0xFFL) == 128L || s != 0L && q.mode != 0) break;
            this.release(h);
            break;
        }
        return interrupted || Thread.interrupted() ? 1L : 0L;
    }

    static {
        try {
            MethodHandles.Lookup l = MethodHandles.lookup();
            STATE = l.findVarHandle(StampedLock.class, "state", Long.TYPE);
            WHEAD = l.findVarHandle(StampedLock.class, "whead", WNode.class);
            WTAIL = l.findVarHandle(StampedLock.class, "wtail", WNode.class);
            WSTATUS = l.findVarHandle(WNode.class, "status", Integer.TYPE);
            WNEXT = l.findVarHandle(WNode.class, "next", WNode.class);
            WCOWAIT = l.findVarHandle(WNode.class, "cowait", WNode.class);
        }
        catch (ReflectiveOperationException e) {
            throw new Error(e);
        }
    }

    final class ReadWriteLockView
    implements ReadWriteLock {
        ReadWriteLockView() {
        }

        @Override
        public Lock readLock() {
            return StampedLock.this.asReadLock();
        }

        @Override
        public Lock writeLock() {
            return StampedLock.this.asWriteLock();
        }
    }

    final class WriteLockView
    implements Lock {
        WriteLockView() {
        }

        @Override
        public void lock() {
            StampedLock.this.writeLock();
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            StampedLock.this.writeLockInterruptibly();
        }

        @Override
        public boolean tryLock() {
            return StampedLock.this.tryWriteLock() != 0L;
        }

        @Override
        public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
            return StampedLock.this.tryWriteLock(time, unit) != 0L;
        }

        @Override
        public void unlock() {
            StampedLock.this.unstampedUnlockWrite();
        }

        @Override
        public Condition newCondition() {
            throw new UnsupportedOperationException();
        }
    }

    final class ReadLockView
    implements Lock {
        ReadLockView() {
        }

        @Override
        public void lock() {
            StampedLock.this.readLock();
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            StampedLock.this.readLockInterruptibly();
        }

        @Override
        public boolean tryLock() {
            return StampedLock.this.tryReadLock() != 0L;
        }

        @Override
        public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
            return StampedLock.this.tryReadLock(time, unit) != 0L;
        }

        @Override
        public void unlock() {
            StampedLock.this.unstampedUnlockRead();
        }

        @Override
        public Condition newCondition() {
            throw new UnsupportedOperationException();
        }
    }

    static final class WNode {
        volatile WNode prev;
        volatile WNode next;
        volatile WNode cowait;
        volatile Thread thread;
        volatile int status;
        final int mode;

        WNode(int m, WNode p) {
            this.mode = m;
            this.prev = p;
        }
    }
}

