/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.atomic;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.util.Arrays;
import java.util.function.BinaryOperator;
import java.util.function.UnaryOperator;

public class AtomicReferenceArray<E>
implements Serializable {
    private static final long serialVersionUID = -6209656149925076980L;
    private static final VarHandle AA = MethodHandles.arrayElementVarHandle(Object[].class);
    private final Object[] array;

    public AtomicReferenceArray(int length) {
        this.array = new Object[length];
    }

    public AtomicReferenceArray(E[] array) {
        this.array = Arrays.copyOf(array, array.length, Object[].class);
    }

    public final int length() {
        return this.array.length;
    }

    public final E get(int i) {
        return (E)AA.getVolatile(this.array, i);
    }

    public final void set(int i, E newValue) {
        AA.setVolatile(this.array, i, newValue);
    }

    public final void lazySet(int i, E newValue) {
        AA.setRelease(this.array, i, newValue);
    }

    public final E getAndSet(int i, E newValue) {
        return (E)AA.getAndSet(this.array, i, newValue);
    }

    public final boolean compareAndSet(int i, E expectedValue, E newValue) {
        return AA.compareAndSet(this.array, i, expectedValue, newValue);
    }

    @Deprecated(since="9")
    public final boolean weakCompareAndSet(int i, E expectedValue, E newValue) {
        return AA.weakCompareAndSetPlain(this.array, i, expectedValue, newValue);
    }

    public final boolean weakCompareAndSetPlain(int i, E expectedValue, E newValue) {
        return AA.weakCompareAndSetPlain(this.array, i, expectedValue, newValue);
    }

    public final E getAndUpdate(int i, UnaryOperator<E> updateFunction) {
        E prev = this.get(i);
        E next = null;
        boolean haveNext = false;
        while (true) {
            if (!haveNext) {
                next = (E)updateFunction.apply(prev);
            }
            if (this.weakCompareAndSetVolatile(i, prev, next)) {
                return prev;
            }
            haveNext = prev == (prev = this.get(i));
        }
    }

    public final E updateAndGet(int i, UnaryOperator<E> updateFunction) {
        E prev = this.get(i);
        E next = null;
        boolean haveNext = false;
        while (true) {
            if (!haveNext) {
                next = (E)updateFunction.apply(prev);
            }
            if (this.weakCompareAndSetVolatile(i, prev, next)) {
                return next;
            }
            haveNext = prev == (prev = this.get(i));
        }
    }

    public final E getAndAccumulate(int i, E x, BinaryOperator<E> accumulatorFunction) {
        E prev = this.get(i);
        E next = null;
        boolean haveNext = false;
        while (true) {
            if (!haveNext) {
                next = (E)accumulatorFunction.apply(prev, x);
            }
            if (this.weakCompareAndSetVolatile(i, prev, next)) {
                return prev;
            }
            haveNext = prev == (prev = this.get(i));
        }
    }

    public final E accumulateAndGet(int i, E x, BinaryOperator<E> accumulatorFunction) {
        E prev = this.get(i);
        E next = null;
        boolean haveNext = false;
        while (true) {
            if (!haveNext) {
                next = (E)accumulatorFunction.apply(prev, x);
            }
            if (this.weakCompareAndSetVolatile(i, prev, next)) {
                return next;
            }
            haveNext = prev == (prev = this.get(i));
        }
    }

    public String toString() {
        int iMax = this.array.length - 1;
        if (iMax == -1) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        int i = 0;
        while (true) {
            b.append(this.get(i));
            if (i == iMax) {
                return b.append(']').toString();
            }
            b.append(',').append(' ');
            ++i;
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        T[] a = s.readFields().get("array", null);
        if (a == null || !a.getClass().isArray()) {
            throw new InvalidObjectException("Not array type");
        }
        if (a.getClass() != Object[].class) {
            a = Arrays.copyOf((Object[])a, Array.getLength(a), Object[].class);
        }
        Field arrayField = AccessController.doPrivileged(() -> {
            try {
                Field f = AtomicReferenceArray.class.getDeclaredField("array");
                f.setAccessible(true);
                return f;
            }
            catch (ReflectiveOperationException e) {
                throw new Error(e);
            }
        });
        try {
            arrayField.set(this, a);
        }
        catch (IllegalAccessException e) {
            throw new Error(e);
        }
    }

    public final E getPlain(int i) {
        return (E)AA.get(this.array, i);
    }

    public final void setPlain(int i, E newValue) {
        AA.set(this.array, i, newValue);
    }

    public final E getOpaque(int i) {
        return (E)AA.getOpaque(this.array, i);
    }

    public final void setOpaque(int i, E newValue) {
        AA.setOpaque(this.array, i, newValue);
    }

    public final E getAcquire(int i) {
        return (E)AA.getAcquire(this.array, i);
    }

    public final void setRelease(int i, E newValue) {
        AA.setRelease(this.array, i, newValue);
    }

    public final E compareAndExchange(int i, E expectedValue, E newValue) {
        return (E)AA.compareAndExchange(this.array, i, expectedValue, newValue);
    }

    public final E compareAndExchangeAcquire(int i, E expectedValue, E newValue) {
        return (E)AA.compareAndExchangeAcquire(this.array, i, expectedValue, newValue);
    }

    public final E compareAndExchangeRelease(int i, E expectedValue, E newValue) {
        return (E)AA.compareAndExchangeRelease(this.array, i, expectedValue, newValue);
    }

    public final boolean weakCompareAndSetVolatile(int i, E expectedValue, E newValue) {
        return AA.weakCompareAndSet(this.array, i, expectedValue, newValue);
    }

    public final boolean weakCompareAndSetAcquire(int i, E expectedValue, E newValue) {
        return AA.weakCompareAndSetAcquire(this.array, i, expectedValue, newValue);
    }

    public final boolean weakCompareAndSetRelease(int i, E expectedValue, E newValue) {
        return AA.weakCompareAndSetRelease(this.array, i, expectedValue, newValue);
    }
}

