/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.atomic;

import java.io.Serializable;
import java.util.function.IntBinaryOperator;
import java.util.function.IntUnaryOperator;
import jdk.internal.misc.Unsafe;

public class AtomicInteger
extends Number
implements Serializable {
    private static final long serialVersionUID = 6214790243416807050L;
    private static final Unsafe U = Unsafe.getUnsafe();
    private static final long VALUE;
    private volatile int value;

    public AtomicInteger(int initialValue) {
        this.value = initialValue;
    }

    public AtomicInteger() {
    }

    public final int get() {
        return this.value;
    }

    public final void set(int newValue) {
        this.value = newValue;
    }

    public final void lazySet(int newValue) {
        U.putIntRelease(this, VALUE, newValue);
    }

    public final int getAndSet(int newValue) {
        return U.getAndSetInt(this, VALUE, newValue);
    }

    public final boolean compareAndSet(int expectedValue, int newValue) {
        return U.compareAndSwapInt(this, VALUE, expectedValue, newValue);
    }

    @Deprecated(since="9")
    public final boolean weakCompareAndSet(int expectedValue, int newValue) {
        return U.weakCompareAndSwapInt(this, VALUE, expectedValue, newValue);
    }

    public final boolean weakCompareAndSetPlain(int expectedValue, int newValue) {
        return U.weakCompareAndSwapInt(this, VALUE, expectedValue, newValue);
    }

    public final int getAndIncrement() {
        return U.getAndAddInt(this, VALUE, 1);
    }

    public final int getAndDecrement() {
        return U.getAndAddInt(this, VALUE, -1);
    }

    public final int getAndAdd(int delta) {
        return U.getAndAddInt(this, VALUE, delta);
    }

    public final int incrementAndGet() {
        return U.getAndAddInt(this, VALUE, 1) + 1;
    }

    public final int decrementAndGet() {
        return U.getAndAddInt(this, VALUE, -1) - 1;
    }

    public final int addAndGet(int delta) {
        return U.getAndAddInt(this, VALUE, delta) + delta;
    }

    public final int getAndUpdate(IntUnaryOperator updateFunction) {
        int prev = this.get();
        int next = 0;
        boolean haveNext = false;
        while (true) {
            if (!haveNext) {
                next = updateFunction.applyAsInt(prev);
            }
            if (this.weakCompareAndSetVolatile(prev, next)) {
                return prev;
            }
            haveNext = prev == (prev = this.get());
        }
    }

    public final int updateAndGet(IntUnaryOperator updateFunction) {
        int prev = this.get();
        int next = 0;
        boolean haveNext = false;
        while (true) {
            if (!haveNext) {
                next = updateFunction.applyAsInt(prev);
            }
            if (this.weakCompareAndSetVolatile(prev, next)) {
                return next;
            }
            haveNext = prev == (prev = this.get());
        }
    }

    public final int getAndAccumulate(int x, IntBinaryOperator accumulatorFunction) {
        int prev = this.get();
        int next = 0;
        boolean haveNext = false;
        while (true) {
            if (!haveNext) {
                next = accumulatorFunction.applyAsInt(prev, x);
            }
            if (this.weakCompareAndSetVolatile(prev, next)) {
                return prev;
            }
            haveNext = prev == (prev = this.get());
        }
    }

    public final int accumulateAndGet(int x, IntBinaryOperator accumulatorFunction) {
        int prev = this.get();
        int next = 0;
        boolean haveNext = false;
        while (true) {
            if (!haveNext) {
                next = accumulatorFunction.applyAsInt(prev, x);
            }
            if (this.weakCompareAndSetVolatile(prev, next)) {
                return next;
            }
            haveNext = prev == (prev = this.get());
        }
    }

    public String toString() {
        return Integer.toString(this.get());
    }

    @Override
    public int intValue() {
        return this.get();
    }

    @Override
    public long longValue() {
        return this.get();
    }

    @Override
    public float floatValue() {
        return this.get();
    }

    @Override
    public double doubleValue() {
        return this.get();
    }

    public final int getPlain() {
        return U.getInt(this, VALUE);
    }

    public final void setPlain(int newValue) {
        U.putInt(this, VALUE, newValue);
    }

    public final int getOpaque() {
        return U.getIntOpaque(this, VALUE);
    }

    public final void setOpaque(int newValue) {
        U.putIntOpaque(this, VALUE, newValue);
    }

    public final int getAcquire() {
        return U.getIntAcquire(this, VALUE);
    }

    public final void setRelease(int newValue) {
        U.putIntRelease(this, VALUE, newValue);
    }

    public final int compareAndExchange(int expectedValue, int newValue) {
        return U.compareAndExchangeIntVolatile(this, VALUE, expectedValue, newValue);
    }

    public final int compareAndExchangeAcquire(int expectedValue, int newValue) {
        return U.compareAndExchangeIntAcquire(this, VALUE, expectedValue, newValue);
    }

    public final int compareAndExchangeRelease(int expectedValue, int newValue) {
        return U.compareAndExchangeIntRelease(this, VALUE, expectedValue, newValue);
    }

    public final boolean weakCompareAndSetVolatile(int expectedValue, int newValue) {
        return U.weakCompareAndSwapIntVolatile(this, VALUE, expectedValue, newValue);
    }

    public final boolean weakCompareAndSetAcquire(int expectedValue, int newValue) {
        return U.weakCompareAndSwapIntAcquire(this, VALUE, expectedValue, newValue);
    }

    public final boolean weakCompareAndSetRelease(int expectedValue, int newValue) {
        return U.weakCompareAndSwapIntRelease(this, VALUE, expectedValue, newValue);
    }

    static {
        try {
            VALUE = U.objectFieldOffset(AtomicInteger.class.getDeclaredField("value"));
        }
        catch (ReflectiveOperationException e) {
            throw new Error(e);
        }
    }
}

