/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReentrantLock;

public class SynchronousQueue<E>
extends AbstractQueue<E>
implements BlockingQueue<E>,
Serializable {
    private static final long serialVersionUID = -3223113410248163686L;
    static final int MAX_TIMED_SPINS = Runtime.getRuntime().availableProcessors() < 2 ? 0 : 32;
    static final int MAX_UNTIMED_SPINS = MAX_TIMED_SPINS * 16;
    static final long SPIN_FOR_TIMEOUT_THRESHOLD = 1000L;
    private volatile transient Transferer<E> transferer;
    private ReentrantLock qlock;
    private WaitQueue waitingProducers;
    private WaitQueue waitingConsumers;

    public SynchronousQueue() {
        this(false);
    }

    public SynchronousQueue(boolean fair) {
        this.transferer = fair ? new TransferQueue() : new TransferStack();
    }

    @Override
    public void put(E e) throws InterruptedException {
        if (e == null) {
            throw new NullPointerException();
        }
        if (this.transferer.transfer(e, false, 0L) == null) {
            Thread.interrupted();
            throw new InterruptedException();
        }
    }

    @Override
    public boolean offer(E e, long timeout, TimeUnit unit) throws InterruptedException {
        if (e == null) {
            throw new NullPointerException();
        }
        if (this.transferer.transfer(e, true, unit.toNanos(timeout)) != null) {
            return true;
        }
        if (!Thread.interrupted()) {
            return false;
        }
        throw new InterruptedException();
    }

    @Override
    public boolean offer(E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        return this.transferer.transfer(e, true, 0L) != null;
    }

    @Override
    public E take() throws InterruptedException {
        E e = this.transferer.transfer(null, false, 0L);
        if (e != null) {
            return e;
        }
        Thread.interrupted();
        throw new InterruptedException();
    }

    @Override
    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        E e = this.transferer.transfer(null, true, unit.toNanos(timeout));
        if (e != null || !Thread.interrupted()) {
            return e;
        }
        throw new InterruptedException();
    }

    @Override
    public E poll() {
        return this.transferer.transfer(null, true, 0L);
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public int remainingCapacity() {
        return 0;
    }

    @Override
    public void clear() {
    }

    @Override
    public boolean contains(Object o) {
        return false;
    }

    @Override
    public boolean remove(Object o) {
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return c.isEmpty();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return false;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return false;
    }

    @Override
    public E peek() {
        return null;
    }

    @Override
    public Iterator<E> iterator() {
        return Collections.emptyIterator();
    }

    @Override
    public Spliterator<E> spliterator() {
        return Spliterators.emptySpliterator();
    }

    @Override
    public Object[] toArray() {
        return new Object[0];
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (a.length > 0) {
            a[0] = null;
        }
        return a;
    }

    @Override
    public String toString() {
        return "[]";
    }

    @Override
    public int drainTo(Collection<? super E> c) {
        E e;
        if (c == null) {
            throw new NullPointerException();
        }
        if (c == this) {
            throw new IllegalArgumentException();
        }
        int n = 0;
        while ((e = this.poll()) != null) {
            c.add(e);
            ++n;
        }
        return n;
    }

    @Override
    public int drainTo(Collection<? super E> c, int maxElements) {
        E e;
        int n;
        if (c == null) {
            throw new NullPointerException();
        }
        if (c == this) {
            throw new IllegalArgumentException();
        }
        for (n = 0; n < maxElements && (e = this.poll()) != null; ++n) {
            c.add(e);
        }
        return n;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        boolean fair = this.transferer instanceof TransferQueue;
        if (fair) {
            this.qlock = new ReentrantLock(true);
            this.waitingProducers = new FifoWaitQueue();
            this.waitingConsumers = new FifoWaitQueue();
        } else {
            this.qlock = new ReentrantLock();
            this.waitingProducers = new LifoWaitQueue();
            this.waitingConsumers = new LifoWaitQueue();
        }
        s.defaultWriteObject();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.transferer = this.waitingProducers instanceof FifoWaitQueue ? new TransferQueue() : new TransferStack();
    }

    static {
        Class<LockSupport> clazz = LockSupport.class;
    }

    static class FifoWaitQueue
    extends WaitQueue {
        private static final long serialVersionUID = -3623113410248163686L;

        FifoWaitQueue() {
        }
    }

    static class LifoWaitQueue
    extends WaitQueue {
        private static final long serialVersionUID = -3633113410248163686L;

        LifoWaitQueue() {
        }
    }

    static class WaitQueue
    implements Serializable {
        WaitQueue() {
        }
    }

    static final class TransferQueue<E>
    extends Transferer<E> {
        volatile transient QNode head;
        volatile transient QNode tail;
        volatile transient QNode cleanMe;
        private static final VarHandle QHEAD;
        private static final VarHandle QTAIL;
        private static final VarHandle QCLEANME;

        TransferQueue() {
            QNode h;
            this.head = h = new QNode(null, false);
            this.tail = h;
        }

        void advanceHead(QNode h, QNode nh) {
            if (h == this.head && QHEAD.compareAndSet(this, h, nh)) {
                h.next = h;
            }
        }

        void advanceTail(QNode t, QNode nt) {
            if (this.tail == t) {
                QTAIL.compareAndSet(this, t, nt);
            }
        }

        boolean casCleanMe(QNode cmp, QNode val) {
            return this.cleanMe == cmp && QCLEANME.compareAndSet(this, cmp, val);
        }

        @Override
        E transfer(E e, boolean timed, long nanos) {
            QNode m;
            Object x;
            QNode h;
            QNode s = null;
            boolean isData = e != null;
            while (true) {
                QNode t = this.tail;
                h = this.head;
                if (t == null || h == null) continue;
                if (h == t || t.isData == isData) {
                    QNode tn = t.next;
                    if (t != this.tail) continue;
                    if (tn != null) {
                        this.advanceTail(t, tn);
                        continue;
                    }
                    if (timed && nanos <= 0L) {
                        return null;
                    }
                    if (s == null) {
                        s = new QNode(e, isData);
                    }
                    if (!t.casNext(null, s)) continue;
                    this.advanceTail(t, s);
                    x = this.awaitFulfill(s, e, timed, nanos);
                    if (x == s) {
                        this.clean(t, s);
                        return null;
                    }
                    if (!s.isOffList()) {
                        this.advanceHead(t, s);
                        if (x != null) {
                            s.item = s;
                        }
                        s.waiter = null;
                    }
                    return (E)(x != null ? x : e);
                }
                m = h.next;
                if (t != this.tail || m == null || h != this.head) continue;
                x = m.item;
                if (isData != (x != null) && x != m && m.casItem(x, e)) break;
                this.advanceHead(h, m);
            }
            this.advanceHead(h, m);
            LockSupport.unpark(m.waiter);
            return (E)(x != null ? x : e);
        }

        Object awaitFulfill(QNode s, E e, boolean timed, long nanos) {
            int spins;
            long deadline = timed ? System.nanoTime() + nanos : 0L;
            Thread w = Thread.currentThread();
            int n = this.head.next == s ? (timed ? MAX_TIMED_SPINS : MAX_UNTIMED_SPINS) : (spins = 0);
            while (true) {
                Object x;
                if (w.isInterrupted()) {
                    s.tryCancel(e);
                }
                if ((x = s.item) != e) {
                    return x;
                }
                if (timed && (nanos = deadline - System.nanoTime()) <= 0L) {
                    s.tryCancel(e);
                    continue;
                }
                if (spins > 0) {
                    --spins;
                    Thread.onSpinWait();
                    continue;
                }
                if (s.waiter == null) {
                    s.waiter = w;
                    continue;
                }
                if (!timed) {
                    LockSupport.park(this);
                    continue;
                }
                if (nanos <= 1000L) continue;
                LockSupport.parkNanos(this, nanos);
            }
        }

        void clean(QNode pred, QNode s) {
            s.waiter = null;
            while (pred.next == s) {
                QNode sn;
                QNode h = this.head;
                QNode hn = h.next;
                if (hn != null && hn.isCancelled()) {
                    this.advanceHead(h, hn);
                    continue;
                }
                QNode t = this.tail;
                if (t == h) {
                    return;
                }
                QNode tn = t.next;
                if (t != this.tail) continue;
                if (tn != null) {
                    this.advanceTail(t, tn);
                    continue;
                }
                if (s != t && ((sn = s.next) == s || pred.casNext(s, sn))) {
                    return;
                }
                QNode dp = this.cleanMe;
                if (dp != null) {
                    QNode dn;
                    QNode d = dp.next;
                    if (d == null || d == dp || !d.isCancelled() || d != t && (dn = d.next) != null && dn != d && dp.casNext(d, dn)) {
                        this.casCleanMe(dp, null);
                    }
                    if (dp != pred) continue;
                    return;
                }
                if (!this.casCleanMe(null, pred)) continue;
                return;
            }
        }

        static {
            try {
                MethodHandles.Lookup l = MethodHandles.lookup();
                QHEAD = l.findVarHandle(TransferQueue.class, "head", QNode.class);
                QTAIL = l.findVarHandle(TransferQueue.class, "tail", QNode.class);
                QCLEANME = l.findVarHandle(TransferQueue.class, "cleanMe", QNode.class);
            }
            catch (ReflectiveOperationException e) {
                throw new Error(e);
            }
        }

        static final class QNode {
            volatile QNode next;
            volatile Object item;
            volatile Thread waiter;
            final boolean isData;
            private static final VarHandle QITEM;
            private static final VarHandle QNEXT;

            QNode(Object item, boolean isData) {
                this.item = item;
                this.isData = isData;
            }

            boolean casNext(QNode cmp, QNode val) {
                return this.next == cmp && QNEXT.compareAndSet(this, cmp, val);
            }

            boolean casItem(Object cmp, Object val) {
                return this.item == cmp && QITEM.compareAndSet(this, cmp, val);
            }

            void tryCancel(Object cmp) {
                QITEM.compareAndSet(this, cmp, this);
            }

            boolean isCancelled() {
                return this.item == this;
            }

            boolean isOffList() {
                return this.next == this;
            }

            static {
                try {
                    MethodHandles.Lookup l = MethodHandles.lookup();
                    QITEM = l.findVarHandle(QNode.class, "item", Object.class);
                    QNEXT = l.findVarHandle(QNode.class, "next", QNode.class);
                }
                catch (ReflectiveOperationException e) {
                    throw new Error(e);
                }
            }
        }
    }

    static final class TransferStack<E>
    extends Transferer<E> {
        static final int REQUEST = 0;
        static final int DATA = 1;
        static final int FULFILLING = 2;
        volatile SNode head;
        private static final VarHandle SHEAD;

        TransferStack() {
        }

        static boolean isFulfilling(int m) {
            return (m & 2) != 0;
        }

        boolean casHead(SNode h, SNode nh) {
            return h == this.head && SHEAD.compareAndSet(this, h, nh);
        }

        static SNode snode(SNode s, Object e, SNode next, int mode) {
            if (s == null) {
                s = new SNode(e);
            }
            s.mode = mode;
            s.next = next;
            return s;
        }

        @Override
        E transfer(E e, boolean timed, long nanos) {
            int mode;
            SNode s = null;
            int n = mode = e == null ? 0 : 1;
            block0: while (true) {
                SNode mn;
                SNode m;
                SNode h;
                if ((h = this.head) == null || h.mode == mode) {
                    if (timed && nanos <= 0L) {
                        if (h != null && h.isCancelled()) {
                            this.casHead(h, h.next);
                            continue;
                        }
                        return null;
                    }
                    if (!this.casHead(h, s = TransferStack.snode(s, e, h, mode))) continue;
                    m = this.awaitFulfill(s, timed, nanos);
                    if (m == s) {
                        this.clean(s);
                        return null;
                    }
                    h = this.head;
                    if (h != null && h.next == s) {
                        this.casHead(h, s.next);
                    }
                    return (E)(mode == 0 ? m.item : s.item);
                }
                if (!TransferStack.isFulfilling(h.mode)) {
                    if (h.isCancelled()) {
                        this.casHead(h, h.next);
                        continue;
                    }
                    if (!this.casHead(h, s = TransferStack.snode(s, e, h, 2 | mode))) continue;
                    while (true) {
                        if ((m = s.next) == null) {
                            this.casHead(s, null);
                            s = null;
                            continue block0;
                        }
                        mn = m.next;
                        if (m.tryMatch(s)) {
                            this.casHead(s, mn);
                            return (E)(mode == 0 ? m.item : s.item);
                        }
                        s.casNext(m, mn);
                    }
                }
                m = h.next;
                if (m == null) {
                    this.casHead(h, null);
                    continue;
                }
                mn = m.next;
                if (m.tryMatch(h)) {
                    this.casHead(h, mn);
                    continue;
                }
                h.casNext(m, mn);
            }
        }

        SNode awaitFulfill(SNode s, boolean timed, long nanos) {
            int spins;
            long deadline = timed ? System.nanoTime() + nanos : 0L;
            Thread w = Thread.currentThread();
            int n = this.shouldSpin(s) ? (timed ? MAX_TIMED_SPINS : MAX_UNTIMED_SPINS) : (spins = 0);
            while (true) {
                SNode m;
                if (w.isInterrupted()) {
                    s.tryCancel();
                }
                if ((m = s.match) != null) {
                    return m;
                }
                if (timed && (nanos = deadline - System.nanoTime()) <= 0L) {
                    s.tryCancel();
                    continue;
                }
                if (spins > 0) {
                    Thread.onSpinWait();
                    spins = this.shouldSpin(s) ? spins - 1 : 0;
                    continue;
                }
                if (s.waiter == null) {
                    s.waiter = w;
                    continue;
                }
                if (!timed) {
                    LockSupport.park(this);
                    continue;
                }
                if (nanos <= 1000L) continue;
                LockSupport.parkNanos(this, nanos);
            }
        }

        boolean shouldSpin(SNode s) {
            SNode h = this.head;
            return h == s || h == null || TransferStack.isFulfilling(h.mode);
        }

        void clean(SNode s) {
            SNode p;
            s.item = null;
            s.waiter = null;
            SNode past = s.next;
            if (past != null && past.isCancelled()) {
                past = past.next;
            }
            while ((p = this.head) != null && p != past && p.isCancelled()) {
                this.casHead(p, p.next);
            }
            while (p != null && p != past) {
                SNode n = p.next;
                if (n != null && n.isCancelled()) {
                    p.casNext(n, n.next);
                    continue;
                }
                p = n;
            }
        }

        static {
            try {
                MethodHandles.Lookup l = MethodHandles.lookup();
                SHEAD = l.findVarHandle(TransferStack.class, "head", SNode.class);
            }
            catch (ReflectiveOperationException e) {
                throw new Error(e);
            }
        }

        static final class SNode {
            volatile SNode next;
            volatile SNode match;
            volatile Thread waiter;
            Object item;
            int mode;
            private static final VarHandle SMATCH;
            private static final VarHandle SNEXT;

            SNode(Object item) {
                this.item = item;
            }

            boolean casNext(SNode cmp, SNode val) {
                return cmp == this.next && SNEXT.compareAndSet(this, cmp, val);
            }

            boolean tryMatch(SNode s) {
                if (this.match == null && SMATCH.compareAndSet(this, null, s)) {
                    Thread w = this.waiter;
                    if (w != null) {
                        this.waiter = null;
                        LockSupport.unpark(w);
                    }
                    return true;
                }
                return this.match == s;
            }

            void tryCancel() {
                SMATCH.compareAndSet(this, null, this);
            }

            boolean isCancelled() {
                return this.match == this;
            }

            static {
                try {
                    MethodHandles.Lookup l = MethodHandles.lookup();
                    SMATCH = l.findVarHandle(SNode.class, "match", SNode.class);
                    SNEXT = l.findVarHandle(SNode.class, "next", SNode.class);
                }
                catch (ReflectiveOperationException e) {
                    throw new Error(e);
                }
            }
        }
    }

    static abstract class Transferer<E> {
        Transferer() {
        }

        abstract E transfer(E var1, boolean var2, long var3);
    }
}

