/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountedCompleter;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Predicate;
import jdk.internal.vm.annotation.Contended;

public class ForkJoinPool
extends AbstractExecutorService {
    static final int SWIDTH = 16;
    static final int SMASK = 65535;
    static final int MAX_CAP = Short.MAX_VALUE;
    static final int SQMASK = 126;
    static final int UNSIGNALLED = Integer.MIN_VALUE;
    static final int SS_SEQ = 65536;
    static final int QLOCK = 1;
    static final int OWNED = 1;
    static final int FIFO = 65536;
    static final int SHUTDOWN = 262144;
    static final int TERMINATED = 524288;
    static final int STOP = Integer.MIN_VALUE;
    static final int QUIET = 0x40000000;
    static final int DORMANT = -1073741824;
    static final int POLL_LIMIT = 1024;
    public static final ForkJoinWorkerThreadFactory defaultForkJoinWorkerThreadFactory;
    static final RuntimePermission modifyThreadPermission;
    static final ForkJoinPool common;
    static final int COMMON_PARALLELISM;
    private static final int COMMON_MAX_SPARES;
    private static int poolNumberSequence;
    private static final long DEFAULT_KEEPALIVE = 60000L;
    private static final long TIMEOUT_SLOP = 20L;
    private static final int DEFAULT_COMMON_MAX_SPARES = 256;
    private static final int SEED_INCREMENT = -1640531527;
    private static final long SP_MASK = 0xFFFFFFFFL;
    private static final long UC_MASK = -4294967296L;
    private static final int RC_SHIFT = 48;
    private static final long RC_UNIT = 0x1000000000000L;
    private static final long RC_MASK = -281474976710656L;
    private static final int TC_SHIFT = 32;
    private static final long TC_UNIT = 0x100000000L;
    private static final long TC_MASK = 0xFFFF00000000L;
    private static final long ADD_WORKER = 0x800000000000L;
    volatile long stealCount;
    final long keepAlive;
    int indexSeed;
    final int bounds;
    volatile int mode;
    WorkQueue[] workQueues;
    final String workerNamePrefix;
    final ForkJoinWorkerThreadFactory factory;
    final Thread.UncaughtExceptionHandler ueh;
    final Predicate<? super ForkJoinPool> saturate;
    @Contended(value="fjpctl")
    volatile long ctl;
    private static final VarHandle CTL;
    private static final VarHandle MODE;
    private static final VarHandle QA;

    private static void checkPermission() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(modifyThreadPermission);
        }
    }

    private static final synchronized int nextPoolId() {
        return ++poolNumberSequence;
    }

    private boolean createWorker() {
        ForkJoinWorkerThreadFactory fac = this.factory;
        Throwable ex = null;
        ForkJoinWorkerThread wt = null;
        try {
            if (fac != null && (wt = fac.newThread(this)) != null) {
                wt.start();
                return true;
            }
        }
        catch (Throwable rex) {
            ex = rex;
        }
        this.deregisterWorker(wt, ex);
        return false;
    }

    private void tryAddWorker(long c) {
        do {
            long nc = 0xFFFF000000000000L & c + 0x1000000000000L | 0xFFFF00000000L & c + 0x100000000L;
            if (this.ctl != c || !CTL.compareAndSet(this, c, nc)) continue;
            this.createWorker();
            break;
        } while (((c = this.ctl) & 0x800000000000L) != 0L && (int)c == 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final WorkQueue registerWorker(ForkJoinWorkerThread wt) {
        wt.setDaemon(true);
        Thread.UncaughtExceptionHandler handler = this.ueh;
        if (handler != null) {
            wt.setUncaughtExceptionHandler(handler);
        }
        WorkQueue w = new WorkQueue(this, wt);
        int tid = 0;
        int fifo = this.mode & 0x10000;
        String prefix = this.workerNamePrefix;
        if (prefix != null) {
            String string = prefix;
            synchronized (string) {
                int n;
                WorkQueue[] ws = this.workQueues;
                int s = this.indexSeed += -1640531527;
                if (ws != null && (n = ws.length) > 1) {
                    int id;
                    WorkQueue q;
                    int m = n - 1;
                    tid = s & m;
                    int i = m & (s << 1 | 1);
                    int probes = n >>> 1;
                    while ((q = ws[i]) != null && q.phase != 0x40000000) {
                        if (--probes == 0) {
                            i = n | 1;
                            break;
                        }
                        i = i + 2 & m;
                    }
                    w.phase = w.id = (id = i | fifo | s & 0x3FFE0000);
                    if (i < n) {
                        ws[i] = w;
                    } else {
                        int an = n << 1;
                        WorkQueue[] as = new WorkQueue[an];
                        as[i] = w;
                        int am = an - 1;
                        for (int j = 0; j < n; ++j) {
                            WorkQueue v = ws[j];
                            if (v != null) {
                                as[v.id & am & 0x7E] = v;
                            }
                            if (++j >= n) break;
                            as[j] = ws[j];
                        }
                        this.workQueues = as;
                    }
                }
            }
            wt.setName(prefix.concat(Integer.toString(tid)));
        }
        return w;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void deregisterWorker(ForkJoinWorkerThread wt, Throwable ex) {
        WorkQueue w = null;
        int phase = 0;
        if (wt != null && (w = wt.workQueue) != null) {
            String lock = this.workerNamePrefix;
            long ns = (long)w.nsteals & 0xFFFFFFFFL;
            int idx = w.id & 0xFFFF;
            if (lock != null) {
                String string = lock;
                synchronized (string) {
                    WorkQueue[] ws = this.workQueues;
                    if (this.workQueues != null && ws.length > idx && ws[idx] == w) {
                        ws[idx] = null;
                    }
                    this.stealCount += ns;
                }
            }
            phase = w.phase;
        }
        if (phase != 0x40000000) {
            long c;
            while (!CTL.weakCompareAndSet(this, c = this.ctl, 0xFFFF000000000000L & c - 0x1000000000000L | 0xFFFF00000000L & c - 0x100000000L | 0xFFFFFFFFL & c)) {
            }
        }
        if (w != null) {
            w.cancelAll();
        }
        if (!this.tryTerminate(false, false) && w != null && w.array != null) {
            this.signalWork();
        }
        if (ex == null) {
            ForkJoinTask.helpExpungeStaleExceptions();
        } else {
            ForkJoinTask.rethrow(ex);
        }
    }

    final void signalWork() {
        long c;
        while ((c = this.ctl) < 0L) {
            WorkQueue v;
            int i;
            int sp = (int)c;
            if (sp == 0) {
                if ((c & 0x800000000000L) == 0L) break;
                this.tryAddWorker(c);
                break;
            }
            WorkQueue[] ws = this.workQueues;
            if (this.workQueues == null || ws.length <= (i = sp & 0xFFFF) || (v = ws[i]) == null) break;
            int np = sp & Integer.MAX_VALUE;
            int vp = v.phase;
            long nc = (long)v.stackPred & 0xFFFFFFFFL | 0xFFFFFFFF00000000L & c + 0x1000000000000L;
            ForkJoinWorkerThread vt = v.owner;
            if (sp != vp || !CTL.compareAndSet(this, c, nc)) continue;
            v.phase = np;
            if (v.source >= 0) break;
            LockSupport.unpark(vt);
            break;
        }
    }

    private int tryCompensate(WorkQueue w) {
        long nc;
        long c = this.ctl;
        WorkQueue[] ws = this.workQueues;
        short t = (short)(c >>> 32);
        if (t >= 0) {
            int n;
            if (ws == null || (n = ws.length) <= 0 || w == null) {
                return 0;
            }
            int sp = (int)c;
            if (sp != 0) {
                WorkQueue v = ws[sp & n - 1];
                int wp = w.phase;
                long uc = 0xFFFFFFFF00000000L & (wp < 0 ? c + 0x1000000000000L : c);
                int np = sp & Integer.MAX_VALUE;
                if (v != null) {
                    int vp = v.phase;
                    ForkJoinWorkerThread vt = v.owner;
                    long nc2 = (long)v.stackPred & 0xFFFFFFFFL | uc;
                    if (vp == sp && CTL.compareAndSet(this, c, nc2)) {
                        v.phase = np;
                        if (v.source < 0) {
                            LockSupport.unpark(vt);
                        }
                        return wp < 0 ? -1 : 1;
                    }
                }
                return 0;
            }
            if ((int)(c >> 48) - (short)(this.bounds & 0xFFFF) > 0) {
                long nc3 = 0xFFFF000000000000L & c - 0x1000000000000L | 0xFFFFFFFFFFFFL & c;
                return CTL.compareAndSet(this, c, nc3) ? 1 : 0;
            }
            int md = this.mode;
            int pc = md & 0xFFFF;
            int tc = pc + t;
            int bc = 0;
            boolean unstable = false;
            for (int i = 1; i < n; i += 2) {
                Thread.State ts;
                WorkQueue q = ws[i];
                if (q == null) continue;
                if (q.source == 0) {
                    unstable = true;
                    break;
                }
                --tc;
                ForkJoinWorkerThread wt = q.owner;
                if (wt == null || (ts = wt.getState()) != Thread.State.BLOCKED && ts != Thread.State.WAITING) continue;
                ++bc;
            }
            if (unstable || tc != 0 || this.ctl != c) {
                return 0;
            }
            if (t + pc >= Short.MAX_VALUE || t >= this.bounds >>> 16) {
                Predicate<? super ForkJoinPool> sat = this.saturate;
                if (sat != null && sat.test(this)) {
                    return -1;
                }
                if (bc < pc) {
                    Thread.yield();
                    return 0;
                }
                throw new RejectedExecutionException("Thread limit exceeded replacing blocked worker");
            }
        }
        return CTL.compareAndSet(this, c, nc = c + 0x100000000L & 0xFFFF00000000L | c & 0xFFFF0000FFFFFFFFL) && this.createWorker() ? 1 : 0;
    }

    final void runWorker(WorkQueue w) {
        w.growArray();
        int r = w.id ^ ThreadLocalRandom.nextSecondarySeed();
        if (r == 0) {
            r = 1;
        }
        int lastSignalId = 0;
        block0: while (true) {
            int n;
            WorkQueue[] ws = this.workQueues;
            if (this.workQueues == null) break;
            boolean nonempty = false;
            int m = n - 1;
            for (int j = n = ws.length; j > 0; --j) {
                int b;
                WorkQueue q;
                int i = r & m;
                if (i >= 0 && i < n && (q = ws[i]) != null && (b = q.base) - q.top < 0) {
                    int al;
                    ForkJoinTask[] a = q.array;
                    if (q.array != null && (al = a.length) > 0) {
                        int qid = q.id;
                        int index = al - 1 & b;
                        ForkJoinTask t = QA.getAcquire(a, index);
                        if (t != null && b++ == q.base && QA.compareAndSet(a, index, t, null)) {
                            q.base = b;
                            if (q.base - q.top < 0 && qid != lastSignalId) {
                                this.signalWork();
                            }
                            w.source = lastSignalId = qid;
                            t.doExec();
                            if ((w.id & 0x10000) != 0) {
                                w.localPollAndExec(1024);
                            } else {
                                w.localPopAndExec(1024);
                            }
                            ForkJoinWorkerThread thread = w.owner;
                            ++w.nsteals;
                            w.source = 0;
                            if (thread != null) {
                                thread.afterTopLevelExec();
                            }
                        }
                        nonempty = true;
                        continue;
                    }
                }
                if (nonempty) break;
                ++r;
            }
            if (nonempty) {
                r ^= r << 13;
                r ^= r >>> 17;
                r ^= r << 5;
                continue;
            }
            lastSignalId = 0;
            int phase = w.phase;
            if (phase >= 0) {
                long nc;
                long c;
                int np = w.phase = phase + 65536 | Integer.MIN_VALUE;
                do {
                    c = this.ctl;
                    w.stackPred = (int)c;
                } while (!CTL.weakCompareAndSet(this, c, nc = c - 0x1000000000000L & 0xFFFFFFFF00000000L | 0xFFFFFFFFL & (long)np));
                continue;
            }
            int pred = w.stackPred;
            w.source = -1073741824;
            int steps = 0;
            while (true) {
                if (w.phase >= 0) {
                    w.source = 0;
                    continue block0;
                }
                int md = this.mode;
                if (md < 0) {
                    return;
                }
                long c = this.ctl;
                int rc = (md & 0xFFFF) + (int)(c >> 48);
                if (rc <= 0 && (md & 0x40000) != 0 && this.tryTerminate(false, false)) {
                    return;
                }
                if ((++steps & 1) == 0) {
                    Thread.interrupted();
                    continue;
                }
                if (rc <= 0 && pred != 0 && phase == (int)c) {
                    long nc;
                    long d = this.keepAlive + System.currentTimeMillis();
                    LockSupport.parkUntil(this, d);
                    if (this.ctl != c || d - System.currentTimeMillis() > 20L || !CTL.compareAndSet(this, c, nc = 0xFFFFFFFF00000000L & c - 0x100000000L | 0xFFFFFFFFL & (long)pred)) continue;
                    w.phase = 0x40000000;
                    return;
                }
                LockSupport.park(this);
            }
            break;
        }
    }

    final int awaitJoin(WorkQueue w, ForkJoinTask<?> task, long deadline) {
        int s = 0;
        if (!(w == null || task == null || task instanceof CountedCompleter && (s = w.localHelpCC((CountedCompleter)task, 0)) < 0)) {
            w.tryRemoveAndExec(task);
            int src = w.source;
            int id = w.id;
            s = task.status;
            while (s >= 0) {
                long ms;
                boolean nonempty = false;
                int r = ThreadLocalRandom.nextSecondarySeed() | 1;
                WorkQueue[] ws = this.workQueues;
                if (this.workQueues != null) {
                    int n = ws.length;
                    int m = n - 1;
                    for (int j = -n; j < n; j += 2) {
                        int al;
                        int b;
                        WorkQueue q;
                        int i = r + j & m;
                        if (i < 0 || i >= n || (q = ws[i]) == null || q.source != id || (b = q.base) - q.top >= 0) continue;
                        ForkJoinTask[] a = q.array;
                        if (q.array == null || (al = a.length) <= 0) continue;
                        int qid = q.id;
                        int index = al - 1 & b;
                        ForkJoinTask t = QA.getAcquire(a, index);
                        if (t != null && b++ == q.base && id == q.source && QA.compareAndSet(a, index, t, null)) {
                            q.base = b;
                            w.source = qid;
                            t.doExec();
                            w.source = src;
                        }
                        nonempty = true;
                        break;
                    }
                }
                if ((s = task.status) < 0) break;
                if (nonempty) continue;
                if (deadline == 0L) {
                    ms = 0L;
                } else {
                    long ns = deadline - System.nanoTime();
                    if (ns <= 0L) break;
                    ms = TimeUnit.NANOSECONDS.toMillis(ns);
                    if (ms <= 0L) {
                        ms = 1L;
                    }
                }
                int block = this.tryCompensate(w);
                if (block != 0) {
                    task.internalWait(ms);
                    CTL.getAndAdd(this, block > 0 ? 0x1000000000000L : 0L);
                }
                s = task.status;
            }
        }
        return s;
    }

    final void helpQuiescePool(WorkQueue w) {
        int prevSrc = w.source;
        int fifo = w.id & 0x10000;
        int source = prevSrc;
        int released = -1;
        while (true) {
            if (fifo != 0) {
                w.localPollAndExec(0);
            } else {
                w.localPopAndExec(0);
            }
            if (released == -1 && w.phase >= 0) {
                released = 1;
            }
            boolean quiet = true;
            boolean empty = true;
            int r = ThreadLocalRandom.nextSecondarySeed();
            WorkQueue[] ws = this.workQueues;
            if (this.workQueues != null) {
                int n;
                int m = n - 1;
                for (int j = n = ws.length; j > 0; --j) {
                    WorkQueue q;
                    int i = r - j & m;
                    if (i < 0 || i >= n || (q = ws[i]) == null) continue;
                    int b = q.base;
                    if (b - q.top < 0) {
                        int al;
                        ForkJoinTask[] a = q.array;
                        if (q.array != null && (al = a.length) > 0) {
                            int index;
                            ForkJoinTask t;
                            int qid = q.id;
                            if (released == 0) {
                                released = 1;
                                CTL.getAndAdd(this, 0x1000000000000L);
                            }
                            if ((t = QA.getAcquire(a, index = al - 1 & b)) != null && b++ == q.base && QA.compareAndSet(a, index, t, null)) {
                                q.base = b;
                                w.source = source = q.id;
                                t.doExec();
                                w.source = source = prevSrc;
                            }
                            empty = false;
                            quiet = false;
                            break;
                        }
                    }
                    if ((q.source & 0x40000000) != 0) continue;
                    quiet = false;
                }
            }
            if (quiet) {
                if (released == 0) {
                    CTL.getAndAdd(this, 0x1000000000000L);
                }
                break;
            }
            if (!empty) continue;
            if (source != 0x40000000) {
                source = 0x40000000;
                w.source = 0x40000000;
            }
            if (released != 1) continue;
            released = 0;
            CTL.getAndAdd(this, -281474976710656L);
        }
        w.source = prevSrc;
    }

    private ForkJoinTask<?> pollScan(boolean submissionsOnly) {
        block0: while ((this.mode & Integer.MIN_VALUE) == 0) {
            int step;
            int origin;
            int n;
            WorkQueue[] ws = this.workQueues;
            if (this.workQueues == null || (n = ws.length) <= 0) break;
            int m = n - 1;
            int r = ThreadLocalRandom.nextSecondarySeed();
            int h = r >>> 16;
            if (submissionsOnly) {
                origin = r & 0xFFFFFFFE & m;
                step = h & 0xFFFFFFFE | 2;
            } else {
                origin = r & m;
                step = h | 1;
            }
            int k = origin;
            int oldSum = 0;
            int checkSum = 0;
            while (true) {
                WorkQueue q;
                if ((q = ws[k]) != null) {
                    int b = q.base;
                    checkSum += b;
                    if (b - q.top < 0) {
                        int al;
                        ForkJoinTask[] a = q.array;
                        if (q.array != null && (al = a.length) > 0) {
                            int index = al - 1 & b;
                            ForkJoinTask t = QA.getAcquire(a, index);
                            if (t == null || b++ != q.base || !QA.compareAndSet(a, index, t, null)) continue block0;
                            q.base = b;
                            return t;
                        }
                    }
                }
                if ((k = k + step & m) != origin) continue;
                if (oldSum == (oldSum = checkSum)) break block0;
                checkSum = 0;
            }
        }
        return null;
    }

    final ForkJoinTask<?> nextTaskFor(WorkQueue w) {
        ForkJoinTask<?> t;
        if (w != null && (t = (w.id & 0x10000) != 0 ? w.poll() : w.pop()) != null) {
            return t;
        }
        return this.pollScan(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void externalPush(ForkJoinTask<?> task) {
        int r = ThreadLocalRandom.getProbe();
        if (r == 0) {
            ThreadLocalRandom.localInit();
            r = ThreadLocalRandom.getProbe();
        }
        while (true) {
            int n;
            int md = this.mode;
            WorkQueue[] ws = this.workQueues;
            if ((md & 0x40000) != 0 || ws == null || (n = ws.length) <= 0) {
                throw new RejectedExecutionException();
            }
            boolean push = false;
            boolean grow = false;
            WorkQueue q = ws[n - 1 & r & 0x7E];
            if (q == null) {
                String lock = this.workerNamePrefix;
                int qid = (r | 0x40000000) & 0xFFFEFFFE;
                q = new WorkQueue(this, null);
                q.id = qid;
                q.source = 0x40000000;
                q.phase = 1;
                if (lock != null) {
                    String string = lock;
                    synchronized (string) {
                        int i;
                        ws = this.workQueues;
                        if (this.workQueues != null && (n = ws.length) > 0 && ws[i = qid & n - 1 & 0x7E] == null) {
                            ws[i] = q;
                            grow = true;
                            push = true;
                        }
                    }
                }
            } else if (q.tryLockSharedQueue()) {
                int d;
                int al;
                int b = q.base;
                int s = q.top;
                ForkJoinTask<?>[] a = q.array;
                if (q.array != null && (al = a.length) > 0 && al - 1 + (d = b - s) > 0) {
                    a[al - 1 & s] = task;
                    q.top = s + 1;
                    q.phase = 0;
                    if (d < 0 && q.base - s < -1) {
                        break;
                    }
                } else {
                    grow = true;
                }
                push = true;
            }
            if (push) {
                if (grow) {
                    try {
                        int al;
                        q.growArray();
                        int s = q.top;
                        ForkJoinTask<?>[] a = q.array;
                        if (q.array != null && (al = a.length) > 0) {
                            a[al - 1 & s] = task;
                            q.top = s + 1;
                        }
                    }
                    finally {
                        q.phase = 0;
                    }
                }
                this.signalWork();
                break;
            }
            r = ThreadLocalRandom.advanceProbe(r);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private <T> ForkJoinTask<T> externalSubmit(ForkJoinTask<T> task) {
        if (task == null) {
            throw new NullPointerException();
        }
        Thread t = Thread.currentThread();
        if (t instanceof ForkJoinWorkerThread) {
            WorkQueue q;
            ForkJoinWorkerThread w = (ForkJoinWorkerThread)t;
            if (w.pool == this && (q = w.workQueue) != null) {
                q.push(task);
                return task;
            }
        }
        this.externalPush(task);
        return task;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static WorkQueue commonSubmitterQueue() {
        ForkJoinPool p = common;
        int r = ThreadLocalRandom.getProbe();
        if (p == null) return null;
        WorkQueue[] ws = p.workQueues;
        if (p.workQueues == null) return null;
        int n = ws.length;
        if (n <= 0) return null;
        WorkQueue workQueue = ws[n - 1 & r & 0x7E];
        return workQueue;
    }

    final boolean tryExternalUnpush(ForkJoinTask<?> task) {
        WorkQueue w;
        int n;
        int r = ThreadLocalRandom.getProbe();
        WorkQueue[] ws = this.workQueues;
        return this.workQueues != null && (n = ws.length) > 0 && (w = ws[n - 1 & r & 0x7E]) != null && w.trySharedUnpush(task);
    }

    final int externalHelpComplete(CountedCompleter<?> task, int maxTasks) {
        WorkQueue w;
        int n;
        int r = ThreadLocalRandom.getProbe();
        WorkQueue[] ws = this.workQueues;
        return this.workQueues != null && (n = ws.length) > 0 && (w = ws[n - 1 & r & 0x7E]) != null ? w.sharedHelpCC(task, maxTasks) : 0;
    }

    final int helpComplete(WorkQueue w, CountedCompleter<?> task, int maxTasks) {
        return w == null ? 0 : w.localHelpCC(task, maxTasks);
    }

    static int getSurplusQueuedTaskCount() {
        Thread t = Thread.currentThread();
        if (t instanceof ForkJoinWorkerThread) {
            WorkQueue q;
            ForkJoinWorkerThread wt = (ForkJoinWorkerThread)t;
            ForkJoinPool pool = wt.pool;
            if (pool != null && (q = wt.workQueue) != null) {
                int p = pool.mode & 0xFFFF;
                int a = p + (int)(pool.ctl >> 48);
                int n = q.top - q.base;
                return n - (a > (p >>>= 1) ? 0 : (a > (p >>>= 1) ? 1 : (a > (p >>>= 1) ? 2 : (a > (p >>>= 1) ? 4 : 8))));
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryTerminate(boolean now, boolean enable) {
        long oldSum;
        int md;
        while (((md = this.mode) & 0x40000) == 0) {
            if (!enable || this == common) {
                return false;
            }
            MODE.compareAndSet(this, md, md | 0x40000);
        }
        while (((md = this.mode) & Integer.MIN_VALUE) == 0) {
            if (!now) {
                long checkSum;
                WorkQueue[] ws;
                oldSum = 0L;
                do {
                    boolean running = false;
                    checkSum = this.ctl;
                    ws = this.workQueues;
                    if ((md & 0xFFFF) + (int)(checkSum >> 48) > 0) {
                        running = true;
                    } else if (ws != null) {
                        for (int i = 0; i < ws.length; ++i) {
                            WorkQueue w = ws[i];
                            if (w == null) continue;
                            int b = w.base;
                            checkSum += (long)(b + w.id);
                            if (b == w.top && ((i & 1) != 1 || w.source < 0)) continue;
                            running = true;
                            break;
                        }
                    }
                    md = this.mode;
                    if ((md & Integer.MIN_VALUE) != 0) break;
                    if (!running) continue;
                    return false;
                } while (this.workQueues != ws || oldSum != (oldSum = checkSum));
            }
            if ((md & Integer.MIN_VALUE) != 0) continue;
            MODE.compareAndSet(this, md, md | Integer.MIN_VALUE);
        }
        while (((md = this.mode) & 0x80000) == 0) {
            long checkSum;
            WorkQueue[] ws;
            oldSum = 0L;
            do {
                checkSum = this.ctl;
                ws = this.workQueues;
                if (this.workQueues == null) continue;
                for (int i = 0; i < ws.length; ++i) {
                    WorkQueue w = ws[i];
                    if (w == null) continue;
                    ForkJoinWorkerThread wt = w.owner;
                    w.cancelAll();
                    if (wt != null) {
                        try {
                            wt.interrupt();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    checkSum += (long)(w.base + w.id);
                }
            } while (((md = this.mode) & 0x80000) == 0 && (this.workQueues != ws || oldSum != (oldSum = checkSum)));
            if ((md & 0x80000) != 0 || (md & 0xFFFF) + (short)(this.ctl >>> 32) > 0) break;
            if (!MODE.compareAndSet(this, md, md | 0x80000)) continue;
            ForkJoinPool forkJoinPool = this;
            synchronized (forkJoinPool) {
                this.notifyAll();
                break;
            }
        }
        return true;
    }

    public ForkJoinPool() {
        this(Math.min(Short.MAX_VALUE, Runtime.getRuntime().availableProcessors()), defaultForkJoinWorkerThreadFactory, null, false, 0, Short.MAX_VALUE, 1, null, 60000L, TimeUnit.MILLISECONDS);
    }

    public ForkJoinPool(int parallelism) {
        this(parallelism, defaultForkJoinWorkerThreadFactory, null, false, 0, Short.MAX_VALUE, 1, null, 60000L, TimeUnit.MILLISECONDS);
    }

    public ForkJoinPool(int parallelism, ForkJoinWorkerThreadFactory factory, Thread.UncaughtExceptionHandler handler, boolean asyncMode) {
        this(parallelism, factory, handler, asyncMode, 0, Short.MAX_VALUE, 1, null, 60000L, TimeUnit.MILLISECONDS);
    }

    public ForkJoinPool(int parallelism, ForkJoinWorkerThreadFactory factory, Thread.UncaughtExceptionHandler handler, boolean asyncMode, int corePoolSize, int maximumPoolSize, int minimumRunnable, Predicate<? super ForkJoinPool> saturate, long keepAliveTime, TimeUnit unit) {
        if (parallelism <= 0 || parallelism > Short.MAX_VALUE || maximumPoolSize < parallelism || keepAliveTime <= 0L) {
            throw new IllegalArgumentException();
        }
        if (factory == null) {
            throw new NullPointerException();
        }
        long ms = Math.max(unit.toMillis(keepAliveTime), 20L);
        int corep = Math.min(Math.max(corePoolSize, parallelism), Short.MAX_VALUE);
        long c = (long)(-corep) << 32 & 0xFFFF00000000L | (long)(-parallelism) << 48 & 0xFFFF000000000000L;
        int m = parallelism | (asyncMode ? 65536 : 0);
        int maxSpares = Math.min(maximumPoolSize, Short.MAX_VALUE) - parallelism;
        int minAvail = Math.min(Math.max(minimumRunnable, 0), Short.MAX_VALUE);
        int b = minAvail - parallelism & 0xFFFF | maxSpares << 16;
        int n = parallelism > 1 ? parallelism - 1 : 1;
        n |= n >>> 1;
        n |= n >>> 2;
        n |= n >>> 4;
        n |= n >>> 8;
        n |= n >>> 16;
        n = n + 1 << 1;
        this.workerNamePrefix = "ForkJoinPool-" + ForkJoinPool.nextPoolId() + "-worker-";
        this.workQueues = new WorkQueue[n];
        this.factory = factory;
        this.ueh = handler;
        this.saturate = saturate;
        this.keepAlive = ms;
        this.bounds = b;
        this.mode = m;
        this.ctl = c;
        ForkJoinPool.checkPermission();
    }

    private Object newInstanceFromSystemProperty(String property) throws ReflectiveOperationException {
        String className = System.getProperty(property);
        return className == null ? null : ClassLoader.getSystemClassLoader().loadClass(className).getConstructor(new Class[0]).newInstance(new Object[0]);
    }

    private ForkJoinPool(byte forCommonPoolOnly) {
        int parallelism = -1;
        ForkJoinWorkerThreadFactory fac = null;
        Thread.UncaughtExceptionHandler handler = null;
        try {
            String pp = System.getProperty("java.util.concurrent.ForkJoinPool.common.parallelism");
            if (pp != null) {
                parallelism = Integer.parseInt(pp);
            }
            fac = (ForkJoinWorkerThreadFactory)this.newInstanceFromSystemProperty("java.util.concurrent.ForkJoinPool.common.threadFactory");
            handler = (Thread.UncaughtExceptionHandler)this.newInstanceFromSystemProperty("java.util.concurrent.ForkJoinPool.common.exceptionHandler");
        }
        catch (Exception pp) {
            // empty catch block
        }
        if (fac == null) {
            fac = System.getSecurityManager() == null ? defaultForkJoinWorkerThreadFactory : new InnocuousForkJoinWorkerThreadFactory();
        }
        if (parallelism < 0 && (parallelism = Runtime.getRuntime().availableProcessors() - 1) <= 0) {
            parallelism = 1;
        }
        if (parallelism > Short.MAX_VALUE) {
            parallelism = Short.MAX_VALUE;
        }
        long c = (long)(-parallelism) << 32 & 0xFFFF00000000L | (long)(-parallelism) << 48 & 0xFFFF000000000000L;
        int b = 1 - parallelism & 0xFFFF | COMMON_MAX_SPARES << 16;
        int n = parallelism > 1 ? parallelism - 1 : 1;
        n |= n >>> 1;
        n |= n >>> 2;
        n |= n >>> 4;
        n |= n >>> 8;
        n |= n >>> 16;
        n = n + 1 << 1;
        this.workerNamePrefix = "ForkJoinPool.commonPool-worker-";
        this.workQueues = new WorkQueue[n];
        this.factory = fac;
        this.ueh = handler;
        this.saturate = null;
        this.keepAlive = 60000L;
        this.bounds = b;
        this.mode = parallelism;
        this.ctl = c;
    }

    public static ForkJoinPool commonPool() {
        return common;
    }

    public <T> T invoke(ForkJoinTask<T> task) {
        if (task == null) {
            throw new NullPointerException();
        }
        this.externalSubmit(task);
        return task.join();
    }

    public void execute(ForkJoinTask<?> task) {
        this.externalSubmit(task);
    }

    @Override
    public void execute(Runnable task) {
        if (task == null) {
            throw new NullPointerException();
        }
        ForkJoinTask job = task instanceof ForkJoinTask ? (ForkJoinTask)((Object)task) : new ForkJoinTask.RunnableExecuteAction(task);
        this.externalSubmit(job);
    }

    public <T> ForkJoinTask<T> submit(ForkJoinTask<T> task) {
        return this.externalSubmit(task);
    }

    public <T> ForkJoinTask<T> submit(Callable<T> task) {
        return this.externalSubmit(new ForkJoinTask.AdaptedCallable<T>(task));
    }

    public <T> ForkJoinTask<T> submit(Runnable task, T result) {
        return this.externalSubmit(new ForkJoinTask.AdaptedRunnable<T>(task, result));
    }

    public ForkJoinTask<?> submit(Runnable task) {
        if (task == null) {
            throw new NullPointerException();
        }
        ForkJoinTask job = task instanceof ForkJoinTask ? (ForkJoinTask)((Object)task) : new ForkJoinTask.AdaptedRunnableAction(task);
        return this.externalSubmit(job);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) {
        ArrayList<Future<T>> futures = new ArrayList<Future<T>>(tasks.size());
        try {
            for (Callable<T> t : tasks) {
                ForkJoinTask.AdaptedCallable<T> f = new ForkJoinTask.AdaptedCallable<T>(t);
                futures.add(f);
                this.externalSubmit(f);
            }
            int size = futures.size();
            for (int i = 0; i < size; ++i) {
                ((ForkJoinTask)futures.get(i)).quietlyJoin();
            }
            return futures;
        }
        catch (Throwable t) {
            int size = futures.size();
            for (int i = 0; i < size; ++i) {
                ((Future)futures.get(i)).cancel(false);
            }
            throw t;
        }
    }

    public ForkJoinWorkerThreadFactory getFactory() {
        return this.factory;
    }

    public Thread.UncaughtExceptionHandler getUncaughtExceptionHandler() {
        return this.ueh;
    }

    public int getParallelism() {
        int par = this.mode & 0xFFFF;
        return par > 0 ? par : 1;
    }

    public static int getCommonPoolParallelism() {
        return COMMON_PARALLELISM;
    }

    public int getPoolSize() {
        return (this.mode & 0xFFFF) + (short)(this.ctl >>> 32);
    }

    public boolean getAsyncMode() {
        return (this.mode & 0x10000) != 0;
    }

    public int getRunningThreadCount() {
        int rc = 0;
        WorkQueue[] ws = this.workQueues;
        if (this.workQueues != null) {
            for (int i = 1; i < ws.length; i += 2) {
                WorkQueue w = ws[i];
                if (w == null || !w.isApparentlyUnblocked()) continue;
                ++rc;
            }
        }
        return rc;
    }

    public int getActiveThreadCount() {
        int r = (this.mode & 0xFFFF) + (int)(this.ctl >> 48);
        return r <= 0 ? 0 : r;
    }

    public boolean isQuiescent() {
        long c;
        int tc;
        do {
            c = this.ctl;
            int md = this.mode;
            int pc = md & 0xFFFF;
            tc = pc + (short)(c >>> 32);
            int rc = pc + (int)(c >> 48);
            if ((md & 0x80080000) != 0) {
                return true;
            }
            if (rc > 0) {
                return false;
            }
            WorkQueue[] ws = this.workQueues;
            if (this.workQueues == null) continue;
            for (int i = 1; i < ws.length; i += 2) {
                WorkQueue v = ws[i];
                if (v == null) continue;
                if ((v.source & 0x40000000) == 0) {
                    return false;
                }
                --tc;
            }
        } while (tc != 0 || this.ctl != c);
        return true;
    }

    public long getStealCount() {
        long count = this.stealCount;
        WorkQueue[] ws = this.workQueues;
        if (this.workQueues != null) {
            for (int i = 1; i < ws.length; i += 2) {
                WorkQueue w = ws[i];
                if (w == null) continue;
                count += (long)w.nsteals & 0xFFFFFFFFL;
            }
        }
        return count;
    }

    public long getQueuedTaskCount() {
        long count = 0L;
        WorkQueue[] ws = this.workQueues;
        if (this.workQueues != null) {
            for (int i = 1; i < ws.length; i += 2) {
                WorkQueue w = ws[i];
                if (w == null) continue;
                count += (long)w.queueSize();
            }
        }
        return count;
    }

    public int getQueuedSubmissionCount() {
        int count = 0;
        WorkQueue[] ws = this.workQueues;
        if (this.workQueues != null) {
            for (int i = 0; i < ws.length; i += 2) {
                WorkQueue w = ws[i];
                if (w == null) continue;
                count += w.queueSize();
            }
        }
        return count;
    }

    public boolean hasQueuedSubmissions() {
        WorkQueue[] ws = this.workQueues;
        if (this.workQueues != null) {
            for (int i = 0; i < ws.length; i += 2) {
                WorkQueue w = ws[i];
                if (w == null || w.isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    protected ForkJoinTask<?> pollSubmission() {
        return this.pollScan(true);
    }

    protected int drainTasksTo(Collection<? super ForkJoinTask<?>> c) {
        int count = 0;
        WorkQueue[] ws = this.workQueues;
        if (this.workQueues != null) {
            for (int i = 0; i < ws.length; ++i) {
                ForkJoinTask<?> t;
                WorkQueue w = ws[i];
                if (w == null) continue;
                while ((t = w.poll()) != null) {
                    c.add(t);
                    ++count;
                }
            }
        }
        return count;
    }

    public String toString() {
        long qt = 0L;
        long qs = 0L;
        int rc = 0;
        long st = this.stealCount;
        WorkQueue[] ws = this.workQueues;
        if (this.workQueues != null) {
            for (int i = 0; i < ws.length; ++i) {
                WorkQueue w = ws[i];
                if (w == null) continue;
                int size = w.queueSize();
                if ((i & 1) == 0) {
                    qs += (long)size;
                    continue;
                }
                qt += (long)size;
                st += (long)w.nsteals & 0xFFFFFFFFL;
                if (!w.isApparentlyUnblocked()) continue;
                ++rc;
            }
        }
        int md = this.mode;
        int pc = md & 0xFFFF;
        long c = this.ctl;
        int tc = pc + (short)(c >>> 32);
        int ac = pc + (int)(c >> 48);
        if (ac < 0) {
            ac = 0;
        }
        String level = (md & 0x80000) != 0 ? "Terminated" : ((md & Integer.MIN_VALUE) != 0 ? "Terminating" : ((md & 0x40000) != 0 ? "Shutting down" : "Running"));
        return super.toString() + "[" + level + ", parallelism = " + pc + ", size = " + tc + ", active = " + ac + ", running = " + rc + ", steals = " + st + ", tasks = " + qt + ", submissions = " + qs + "]";
    }

    @Override
    public void shutdown() {
        ForkJoinPool.checkPermission();
        this.tryTerminate(false, true);
    }

    @Override
    public List<Runnable> shutdownNow() {
        ForkJoinPool.checkPermission();
        this.tryTerminate(true, true);
        return Collections.emptyList();
    }

    @Override
    public boolean isTerminated() {
        return (this.mode & 0x80000) != 0;
    }

    public boolean isTerminating() {
        int md = this.mode;
        return (md & Integer.MIN_VALUE) != 0 && (md & 0x80000) == 0;
    }

    @Override
    public boolean isShutdown() {
        return (this.mode & 0x40000) != 0;
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (this == common) {
            this.awaitQuiescence(timeout, unit);
            return false;
        }
        long nanos = unit.toNanos(timeout);
        if (this.isTerminated()) {
            return true;
        }
        if (nanos <= 0L) {
            return false;
        }
        long deadline = System.nanoTime() + nanos;
        ForkJoinPool forkJoinPool = this;
        synchronized (forkJoinPool) {
            while (true) {
                if (this.isTerminated()) {
                    return true;
                }
                if (nanos <= 0L) {
                    return false;
                }
                long millis = TimeUnit.NANOSECONDS.toMillis(nanos);
                this.wait(millis > 0L ? millis : 1L);
                nanos = deadline - System.nanoTime();
            }
        }
    }

    public boolean awaitQuiescence(long timeout, TimeUnit unit) {
        long nanos = unit.toNanos(timeout);
        Thread thread = Thread.currentThread();
        if (thread instanceof ForkJoinWorkerThread) {
            ForkJoinWorkerThread wt = (ForkJoinWorkerThread)thread;
            if (wt.pool == this) {
                this.helpQuiescePool(wt.workQueue);
                return true;
            }
        }
        long startTime = System.nanoTime();
        while (true) {
            ForkJoinTask<?> t;
            if ((t = this.pollScan(false)) != null) {
                t.doExec();
                continue;
            }
            if (this.isQuiescent()) {
                return true;
            }
            if (System.nanoTime() - startTime > nanos) {
                return false;
            }
            Thread.yield();
        }
    }

    static void quiesceCommonPool() {
        common.awaitQuiescence(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void managedBlock(ManagedBlocker blocker) throws InterruptedException {
        Thread t = Thread.currentThread();
        if (t instanceof ForkJoinWorkerThread) {
            WorkQueue w;
            ForkJoinWorkerThread wt = (ForkJoinWorkerThread)t;
            ForkJoinPool p = wt.pool;
            if (p != null && (w = wt.workQueue) != null) {
                while (!blocker.isReleasable()) {
                    int block = p.tryCompensate(w);
                    if (block == 0) continue;
                    try {
                        while (!blocker.isReleasable() && !blocker.block()) {
                        }
                        CTL.getAndAdd(p, block > 0 ? 0x1000000000000L : 0L);
                    }
                    catch (Throwable throwable) {
                        CTL.getAndAdd(p, block > 0 ? 0x1000000000000L : 0L);
                        throw throwable;
                    }
                    return;
                }
                return;
            }
        }
        while (!blocker.isReleasable() && !blocker.block()) {
        }
    }

    /*
     * Unable to fully structure code
     */
    static void helpAsyncBlocker(Executor e, ManagedBlocker blocker) {
        block5: {
            block7: {
                block6: {
                    if (blocker == null || !(e instanceof ForkJoinPool)) break block5;
                    p = (ForkJoinPool)e;
                    thread = Thread.currentThread();
                    if (!(thread instanceof ForkJoinWorkerThread)) break block6;
                    wt = (ForkJoinWorkerThread)thread;
                    if (wt.pool != p) break block6;
                    w = wt.workQueue;
                    break block7;
                }
                if ((r = ThreadLocalRandom.getProbe()) == 0) ** GOTO lbl-1000
                ws = p.workQueues;
                if (p.workQueues != null && (n = ws.length) > 0) {
                    w = ws[n - 1 & r & 126];
                } else lbl-1000:
                // 2 sources

                {
                    w = null;
                }
            }
            if (w != null) {
                while (true) {
                    b = w.base;
                    s = w.top;
                    a = w.array;
                    if (w.array == null || (d = b - s) >= 0 || (al = a.length) <= 0) break;
                    index = al - 1 & b;
                    t = ForkJoinPool.QA.getAcquire(a, index);
                    if (blocker.isReleasable()) break;
                    if (b++ != w.base) continue;
                    if (t == null) {
                        if (d != -1) continue;
                        break;
                    }
                    if (!(t instanceof CompletableFuture.AsynchronousCompletionTask)) break;
                    if (!ForkJoinPool.QA.compareAndSet(a, index, t, null)) continue;
                    w.base = b;
                    t.doExec();
                }
            }
        }
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value) {
        return new ForkJoinTask.AdaptedRunnable<T>(runnable, value);
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
        return new ForkJoinTask.AdaptedCallable<T>(callable);
    }

    static {
        try {
            MethodHandles.Lookup l = MethodHandles.lookup();
            CTL = l.findVarHandle(ForkJoinPool.class, "ctl", Long.TYPE);
            MODE = l.findVarHandle(ForkJoinPool.class, "mode", Integer.TYPE);
            QA = MethodHandles.arrayElementVarHandle(ForkJoinTask[].class);
        }
        catch (ReflectiveOperationException e) {
            throw new Error(e);
        }
        Class<LockSupport> ensureLoaded = LockSupport.class;
        int commonMaxSpares = 256;
        try {
            String p = System.getProperty("java.util.concurrent.ForkJoinPool.common.maximumSpares");
            if (p != null) {
                commonMaxSpares = Integer.parseInt(p);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        COMMON_MAX_SPARES = commonMaxSpares;
        defaultForkJoinWorkerThreadFactory = new DefaultForkJoinWorkerThreadFactory();
        modifyThreadPermission = new RuntimePermission("modifyThread");
        common = AccessController.doPrivileged(new PrivilegedAction<ForkJoinPool>(){

            @Override
            public ForkJoinPool run() {
                return new ForkJoinPool(0);
            }
        });
        COMMON_PARALLELISM = Math.max(ForkJoinPool.common.mode & 0xFFFF, 1);
    }

    private static final class InnocuousForkJoinWorkerThreadFactory
    implements ForkJoinWorkerThreadFactory {
        private static final AccessControlContext INNOCUOUS_ACC;

        private InnocuousForkJoinWorkerThreadFactory() {
        }

        @Override
        public final ForkJoinWorkerThread newThread(final ForkJoinPool pool) {
            return AccessController.doPrivileged(new PrivilegedAction<ForkJoinWorkerThread>(){

                @Override
                public ForkJoinWorkerThread run() {
                    return new ForkJoinWorkerThread.InnocuousForkJoinWorkerThread(pool);
                }
            }, INNOCUOUS_ACC);
        }

        static {
            Permissions innocuousPerms = new Permissions();
            innocuousPerms.add(modifyThreadPermission);
            innocuousPerms.add(new RuntimePermission("enableContextClassLoaderOverride"));
            innocuousPerms.add(new RuntimePermission("modifyThreadGroup"));
            INNOCUOUS_ACC = new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, innocuousPerms)});
        }
    }

    public static interface ManagedBlocker {
        public boolean block() throws InterruptedException;

        public boolean isReleasable();
    }

    @Contended
    static final class WorkQueue {
        static final int INITIAL_QUEUE_CAPACITY = 8192;
        static final int MAXIMUM_QUEUE_CAPACITY = 0x4000000;
        volatile int phase;
        int stackPred;
        int nsteals;
        int id;
        volatile int source;
        volatile int base;
        int top;
        ForkJoinTask<?>[] array;
        final ForkJoinPool pool;
        final ForkJoinWorkerThread owner;
        private static final VarHandle PHASE;

        WorkQueue(ForkJoinPool pool, ForkJoinWorkerThread owner) {
            this.pool = pool;
            this.owner = owner;
            this.top = 4096;
            this.base = 4096;
        }

        final int getPoolIndex() {
            return (this.id & 0xFFFF) >>> 1;
        }

        final int queueSize() {
            int n = this.base - this.top;
            return n >= 0 ? 0 : -n;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        final boolean isEmpty() {
            int b = this.base;
            int n = b - this.top;
            if (n >= 0) return true;
            if (n != -1) return false;
            ForkJoinTask<?>[] a = this.array;
            if (this.array == null) return true;
            int al = a.length;
            if (al == 0) return true;
            if (a[al - 1 & b] != null) return false;
            return true;
        }

        final void push(ForkJoinTask<?> task) {
            int al;
            int s = this.top;
            ForkJoinTask[] a = this.array;
            if (this.array != null && (al = a.length) > 0) {
                int index = al - 1 & s;
                ForkJoinPool p = this.pool;
                this.top = s + 1;
                QA.setRelease(a, index, task);
                int d = this.base - s;
                if (d == 0 && p != null) {
                    VarHandle.fullFence();
                    p.signalWork();
                } else if (d + al == 1) {
                    this.growArray();
                }
            }
        }

        final ForkJoinTask<?>[] growArray() {
            int b;
            int t;
            int oldMask;
            int size;
            ForkJoinTask[] oldA = this.array;
            int oldSize = oldA != null ? oldA.length : 0;
            int n = size = oldSize > 0 ? oldSize << 1 : 8192;
            if (size < 8192 || size > 0x4000000) {
                throw new RejectedExecutionException("Queue capacity exceeded");
            }
            this.array = new ForkJoinTask[size];
            ForkJoinTask[] a = this.array;
            if (oldA != null && (oldMask = oldSize - 1) > 0 && (t = this.top) - (b = this.base) > 0) {
                int mask = size - 1;
                do {
                    int index = b & oldMask;
                    ForkJoinTask x = QA.getAcquire(oldA, index);
                    if (x == null || !QA.compareAndSet(oldA, index, x, null)) continue;
                    a[b & mask] = x;
                } while (++b != t);
                VarHandle.releaseFence();
            }
            return a;
        }

        final ForkJoinTask<?> pop() {
            int al;
            int b = this.base;
            int s = this.top;
            ForkJoinTask[] a = this.array;
            if (this.array != null && b != s && (al = a.length) > 0) {
                int index = al - 1 & --s;
                ForkJoinTask t = QA.get(a, index);
                if (t != null && QA.compareAndSet(a, index, t, null)) {
                    this.top = s;
                    VarHandle.releaseFence();
                    return t;
                }
            }
            return null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        final ForkJoinTask<?> poll() {
            while (true) {
                int al;
                int d;
                int b = this.base;
                int s = this.top;
                ForkJoinTask[] a = this.array;
                if (this.array == null || (d = b - s) >= 0 || (al = a.length) <= 0) return null;
                int index = al - 1 & b;
                ForkJoinTask t = QA.getAcquire(a, index);
                if (b++ != this.base) continue;
                if (t != null) {
                    if (!QA.compareAndSet(a, index, t, null)) continue;
                    this.base = b;
                    return t;
                }
                if (d == -1) return null;
            }
        }

        final ForkJoinTask<?> nextLocalTask() {
            return (this.id & 0x10000) != 0 ? this.poll() : this.pop();
        }

        final ForkJoinTask<?> peek() {
            int al;
            ForkJoinTask<?>[] a = this.array;
            return this.array != null && (al = a.length) > 0 ? a[al - 1 & ((this.id & 0x10000) != 0 ? this.base : this.top - 1)] : null;
        }

        final boolean tryUnpush(ForkJoinTask<?> task) {
            int al;
            int b = this.base;
            int s = this.top;
            ForkJoinTask[] a = this.array;
            if (this.array != null && b != s && (al = a.length) > 0) {
                int index = al - 1 & --s;
                if (QA.compareAndSet(a, index, task, null)) {
                    this.top = s;
                    VarHandle.releaseFence();
                    return true;
                }
            }
            return false;
        }

        final void cancelAll() {
            ForkJoinTask<?> t;
            while ((t = this.poll()) != null) {
                ForkJoinTask.cancelIgnoringExceptions(t);
            }
        }

        final void localPopAndExec(int limit) {
            do {
                int al;
                int b = this.base;
                int s = this.top;
                ForkJoinTask[] a = this.array;
                if (this.array == null || b == s || (al = a.length) <= 0) break;
                int index = al - 1 & --s;
                ForkJoinTask t = QA.getAndSet(a, index, null);
                if (t == null) break;
                this.top = s;
                VarHandle.releaseFence();
                t.doExec();
            } while (limit == 0 || --limit != 0);
        }

        final void localPollAndExec(int limit) {
            int polls = 0;
            while (true) {
                int al;
                int d;
                int b = this.base;
                int s = this.top;
                ForkJoinTask[] a = this.array;
                if (this.array == null || (d = b - s) >= 0 || (al = a.length) <= 0) break;
                int index = al - 1 & b++;
                ForkJoinTask t = QA.getAndSet(a, index, null);
                if (t != null) {
                    this.base = b;
                    t.doExec();
                    if (limit == 0 || ++polls != limit) continue;
                    break;
                }
                if (d == -1) break;
                polls = 0;
            }
        }

        final void tryRemoveAndExec(ForkJoinTask<?> task) {
            int s = this.top;
            if (this.base - s < 0) {
                int wal;
                ForkJoinTask[] wa = this.array;
                if (this.array != null && (wal = wa.length) > 0) {
                    int ns;
                    int m = wal - 1;
                    int i = ns = s - 1;
                    while (true) {
                        int index = i & m;
                        ForkJoinTask t = QA.get(wa, index);
                        if (t == null) break;
                        if (t == task) {
                            if (!QA.compareAndSet(wa, index, t, null)) break;
                            this.top = ns;
                            for (int j = i; j != ns; ++j) {
                                int pindex = j + 1 & m;
                                ForkJoinTask f = QA.get(wa, pindex);
                                QA.setVolatile(wa, pindex, null);
                                int jindex = j & m;
                                QA.setRelease(wa, jindex, f);
                            }
                            VarHandle.releaseFence();
                            t.doExec();
                            break;
                        }
                        --i;
                    }
                }
            }
        }

        final int localHelpCC(CountedCompleter<?> task, int limit) {
            int status;
            block2: {
                boolean help;
                status = 0;
                if (task == null || (status = task.status) < 0) break block2;
                block0: do {
                    CountedCompleter<?> t;
                    int al;
                    help = false;
                    int b = this.base;
                    int s = this.top;
                    ForkJoinTask[] a = this.array;
                    if (this.array == null || b == s || (al = a.length) <= 0) continue;
                    int index = al - 1 & s - 1;
                    ForkJoinTask o = QA.get(a, index);
                    if (!(o instanceof CountedCompleter)) continue;
                    CountedCompleter<?> f = t = (CountedCompleter<?>)o;
                    while (f != task) {
                        f = f.completer;
                        if (f != null) continue;
                        continue block0;
                    }
                    if (!QA.compareAndSet(a, index, t, null)) continue;
                    this.top = s - 1;
                    VarHandle.releaseFence();
                    t.doExec();
                    help = true;
                } while ((status = task.status) >= 0 && help && (limit == 0 || --limit != 0));
            }
            return status;
        }

        final boolean tryLockSharedQueue() {
            return PHASE.compareAndSet(this, 0, 1);
        }

        final boolean trySharedUnpush(ForkJoinTask<?> task) {
            int al;
            boolean popped = false;
            int s = this.top - 1;
            ForkJoinTask[] a = this.array;
            if (this.array != null && (al = a.length) > 0) {
                int index = al - 1 & s;
                ForkJoinTask t = QA.get(a, index);
                if (t == task && PHASE.compareAndSet(this, 0, 1)) {
                    if (this.top == s + 1 && this.array == a && QA.compareAndSet(a, index, task, null)) {
                        popped = true;
                        this.top = s;
                    }
                    PHASE.setRelease(this, 0);
                }
            }
            return popped;
        }

        final int sharedHelpCC(CountedCompleter<?> task, int limit) {
            int status;
            block3: {
                boolean help;
                status = 0;
                if (task == null || (status = task.status) < 0) break block3;
                block0: do {
                    CountedCompleter<?> t;
                    int al;
                    help = false;
                    int b = this.base;
                    int s = this.top;
                    ForkJoinTask[] a = this.array;
                    if (this.array == null || b == s || (al = a.length) <= 0) continue;
                    int index = al - 1 & s - 1;
                    ForkJoinTask o = QA.get(a, index);
                    if (!(o instanceof CountedCompleter)) continue;
                    CountedCompleter<?> f = t = (CountedCompleter<?>)o;
                    while (f != task) {
                        f = f.completer;
                        if (f != null) continue;
                        continue block0;
                    }
                    if (!PHASE.compareAndSet(this, 0, 1)) continue;
                    if (this.top == s && this.array == a && QA.compareAndSet(a, index, t, null)) {
                        help = true;
                        this.top = s - 1;
                    }
                    PHASE.setRelease(this, 0);
                    if (!help) continue;
                    t.doExec();
                } while ((status = task.status) >= 0 && help && (limit == 0 || --limit != 0));
            }
            return status;
        }

        final boolean isApparentlyUnblocked() {
            Thread.State s;
            ForkJoinWorkerThread wt = this.owner;
            return wt != null && (s = wt.getState()) != Thread.State.BLOCKED && s != Thread.State.WAITING && s != Thread.State.TIMED_WAITING;
        }

        static {
            try {
                MethodHandles.Lookup l = MethodHandles.lookup();
                PHASE = l.findVarHandle(WorkQueue.class, "phase", Integer.TYPE);
            }
            catch (ReflectiveOperationException e) {
                throw new Error(e);
            }
        }
    }

    private static final class DefaultForkJoinWorkerThreadFactory
    implements ForkJoinWorkerThreadFactory {
        private DefaultForkJoinWorkerThreadFactory() {
        }

        @Override
        public final ForkJoinWorkerThread newThread(ForkJoinPool pool) {
            return new ForkJoinWorkerThread(pool);
        }
    }

    public static interface ForkJoinWorkerThreadFactory {
        public ForkJoinWorkerThread newThread(ForkJoinPool var1);
    }
}

