/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;

public class CopyOnWriteArrayList<E>
implements List<E>,
RandomAccess,
Cloneable,
Serializable {
    private static final long serialVersionUID = 8673264195747942595L;
    final transient Object lock = new Object();
    private volatile transient Object[] array;

    final Object[] getArray() {
        return this.array;
    }

    final void setArray(Object[] a) {
        this.array = a;
    }

    public CopyOnWriteArrayList() {
        this.setArray(new Object[0]);
    }

    public CopyOnWriteArrayList(Collection<? extends E> c) {
        Object[] elements;
        if (c.getClass() == CopyOnWriteArrayList.class) {
            elements = ((CopyOnWriteArrayList)c).getArray();
        } else {
            elements = c.toArray();
            if (elements.getClass() != Object[].class) {
                elements = Arrays.copyOf(elements, elements.length, Object[].class);
            }
        }
        this.setArray(elements);
    }

    public CopyOnWriteArrayList(E[] toCopyIn) {
        this.setArray(Arrays.copyOf(toCopyIn, toCopyIn.length, Object[].class));
    }

    @Override
    public int size() {
        return this.getArray().length;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    private static int indexOf(Object o, Object[] elements, int index, int fence) {
        if (o == null) {
            for (int i = index; i < fence; ++i) {
                if (elements[i] != null) continue;
                return i;
            }
        } else {
            for (int i = index; i < fence; ++i) {
                if (!o.equals(elements[i])) continue;
                return i;
            }
        }
        return -1;
    }

    private static int lastIndexOf(Object o, Object[] elements, int index) {
        if (o == null) {
            for (int i = index; i >= 0; --i) {
                if (elements[i] != null) continue;
                return i;
            }
        } else {
            for (int i = index; i >= 0; --i) {
                if (!o.equals(elements[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public boolean contains(Object o) {
        Object[] elements = this.getArray();
        return CopyOnWriteArrayList.indexOf(o, elements, 0, elements.length) >= 0;
    }

    @Override
    public int indexOf(Object o) {
        Object[] elements = this.getArray();
        return CopyOnWriteArrayList.indexOf(o, elements, 0, elements.length);
    }

    public int indexOf(E e, int index) {
        Object[] elements = this.getArray();
        return CopyOnWriteArrayList.indexOf(e, elements, index, elements.length);
    }

    @Override
    public int lastIndexOf(Object o) {
        Object[] elements = this.getArray();
        return CopyOnWriteArrayList.lastIndexOf(o, elements, elements.length - 1);
    }

    public int lastIndexOf(E e, int index) {
        Object[] elements = this.getArray();
        return CopyOnWriteArrayList.lastIndexOf(e, elements, index);
    }

    public Object clone() {
        try {
            CopyOnWriteArrayList clone = (CopyOnWriteArrayList)super.clone();
            clone.resetLock();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    @Override
    public Object[] toArray() {
        Object[] elements = this.getArray();
        return Arrays.copyOf(elements, elements.length);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        Object[] elements = this.getArray();
        int len = elements.length;
        if (a.length < len) {
            return Arrays.copyOf(elements, len, a.getClass());
        }
        System.arraycopy(elements, 0, a, 0, len);
        if (a.length > len) {
            a[len] = null;
        }
        return a;
    }

    static <E> E elementAt(Object[] a, int index) {
        return (E)a[index];
    }

    static String outOfBounds(int index, int size) {
        return "Index: " + index + ", Size: " + size;
    }

    @Override
    public E get(int index) {
        return CopyOnWriteArrayList.elementAt(this.getArray(), index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E set(int index, E element) {
        Object object = this.lock;
        synchronized (object) {
            Object[] elements = this.getArray();
            E oldValue = CopyOnWriteArrayList.elementAt(elements, index);
            if (oldValue != element) {
                int len = elements.length;
                Object[] newElements = Arrays.copyOf(elements, len);
                newElements[index] = element;
                this.setArray(newElements);
            } else {
                this.setArray(elements);
            }
            return oldValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(E e) {
        Object object = this.lock;
        synchronized (object) {
            Object[] elements = this.getArray();
            int len = elements.length;
            Object[] newElements = Arrays.copyOf(elements, len + 1);
            newElements[len] = e;
            this.setArray(newElements);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(int index, E element) {
        Object object = this.lock;
        synchronized (object) {
            Object[] newElements;
            Object[] elements = this.getArray();
            int len = elements.length;
            if (index > len || index < 0) {
                throw new IndexOutOfBoundsException(CopyOnWriteArrayList.outOfBounds(index, len));
            }
            int numMoved = len - index;
            if (numMoved == 0) {
                newElements = Arrays.copyOf(elements, len + 1);
            } else {
                newElements = new Object[len + 1];
                System.arraycopy(elements, 0, newElements, 0, index);
                System.arraycopy(elements, index, newElements, index + 1, numMoved);
            }
            newElements[index] = element;
            this.setArray(newElements);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E remove(int index) {
        Object object = this.lock;
        synchronized (object) {
            Object[] elements = this.getArray();
            int len = elements.length;
            E oldValue = CopyOnWriteArrayList.elementAt(elements, index);
            int numMoved = len - index - 1;
            if (numMoved == 0) {
                this.setArray(Arrays.copyOf(elements, len - 1));
            } else {
                Object[] newElements = new Object[len - 1];
                System.arraycopy(elements, 0, newElements, 0, index);
                System.arraycopy(elements, index + 1, newElements, index, numMoved);
                this.setArray(newElements);
            }
            return oldValue;
        }
    }

    @Override
    public boolean remove(Object o) {
        Object[] snapshot = this.getArray();
        int index = CopyOnWriteArrayList.indexOf(o, snapshot, 0, snapshot.length);
        return index < 0 ? false : this.remove(o, snapshot, index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean remove(Object o, Object[] snapshot, int index) {
        Object object = this.lock;
        synchronized (object) {
            int len;
            Object[] current;
            block7: {
                current = this.getArray();
                len = current.length;
                if (snapshot != current) {
                    int prefix = Math.min(index, len);
                    for (int i = 0; i < prefix; ++i) {
                        if (current[i] == snapshot[i] || !Objects.equals(o, current[i])) continue;
                        index = i;
                        break block7;
                    }
                    if (index >= len) {
                        return false;
                    }
                    if (current[index] != o && (index = CopyOnWriteArrayList.indexOf(o, current, index, len)) < 0) {
                        return false;
                    }
                }
            }
            Object[] newElements = new Object[len - 1];
            System.arraycopy(current, 0, newElements, 0, index);
            System.arraycopy(current, index + 1, newElements, index, len - index - 1);
            this.setArray(newElements);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeRange(int fromIndex, int toIndex) {
        Object object = this.lock;
        synchronized (object) {
            Object[] elements = this.getArray();
            int len = elements.length;
            if (fromIndex < 0 || toIndex > len || toIndex < fromIndex) {
                throw new IndexOutOfBoundsException();
            }
            int newlen = len - (toIndex - fromIndex);
            int numMoved = len - toIndex;
            if (numMoved == 0) {
                this.setArray(Arrays.copyOf(elements, newlen));
            } else {
                Object[] newElements = new Object[newlen];
                System.arraycopy(elements, 0, newElements, 0, fromIndex);
                System.arraycopy(elements, toIndex, newElements, fromIndex, numMoved);
                this.setArray(newElements);
            }
        }
    }

    public boolean addIfAbsent(E e) {
        Object[] snapshot = this.getArray();
        return CopyOnWriteArrayList.indexOf(e, snapshot, 0, snapshot.length) >= 0 ? false : this.addIfAbsent(e, snapshot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addIfAbsent(E e, Object[] snapshot) {
        Object object = this.lock;
        synchronized (object) {
            Object[] current = this.getArray();
            int len = current.length;
            if (snapshot != current) {
                int common = Math.min(snapshot.length, len);
                for (int i = 0; i < common; ++i) {
                    if (current[i] == snapshot[i] || !Objects.equals(e, current[i])) continue;
                    return false;
                }
                if (CopyOnWriteArrayList.indexOf(e, current, common, len) >= 0) {
                    return false;
                }
            }
            Object[] newElements = Arrays.copyOf(current, len + 1);
            newElements[len] = e;
            this.setArray(newElements);
            return true;
        }
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        Object[] elements = this.getArray();
        int len = elements.length;
        for (Object e : c) {
            if (CopyOnWriteArrayList.indexOf(e, elements, 0, len) >= 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        Objects.requireNonNull(c);
        return this.bulkRemove(e -> c.contains(e));
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        Objects.requireNonNull(c);
        return this.bulkRemove(e -> !c.contains(e));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addAllAbsent(Collection<? extends E> c) {
        Object[] cs = c.toArray();
        if (cs.length == 0) {
            return 0;
        }
        Object object = this.lock;
        synchronized (object) {
            Object[] elements = this.getArray();
            int len = elements.length;
            int added = 0;
            for (int i = 0; i < cs.length; ++i) {
                Object e = cs[i];
                if (CopyOnWriteArrayList.indexOf(e, elements, 0, len) >= 0 || CopyOnWriteArrayList.indexOf(e, cs, 0, added) >= 0) continue;
                cs[added++] = e;
            }
            if (added > 0) {
                Object[] newElements = Arrays.copyOf(elements, len + added);
                System.arraycopy(cs, 0, newElements, len, added);
                this.setArray(newElements);
            }
            return added;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            this.setArray(new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(Collection<? extends E> c) {
        Object[] cs;
        Object[] objectArray = cs = c.getClass() == CopyOnWriteArrayList.class ? ((CopyOnWriteArrayList)c).getArray() : c.toArray();
        if (cs.length == 0) {
            return false;
        }
        Object object = this.lock;
        synchronized (object) {
            Object[] elements = this.getArray();
            int len = elements.length;
            if (len == 0 && cs.getClass() == Object[].class) {
                this.setArray(cs);
            } else {
                Object[] newElements = Arrays.copyOf(elements, len + cs.length);
                System.arraycopy(cs, 0, newElements, len, cs.length);
                this.setArray(newElements);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        Object[] cs = c.toArray();
        Object object = this.lock;
        synchronized (object) {
            Object[] newElements;
            Object[] elements = this.getArray();
            int len = elements.length;
            if (index > len || index < 0) {
                throw new IndexOutOfBoundsException(CopyOnWriteArrayList.outOfBounds(index, len));
            }
            if (cs.length == 0) {
                return false;
            }
            int numMoved = len - index;
            if (numMoved == 0) {
                newElements = Arrays.copyOf(elements, len + cs.length);
            } else {
                newElements = new Object[len + cs.length];
                System.arraycopy(elements, 0, newElements, 0, index);
                System.arraycopy(elements, index, newElements, index + cs.length, numMoved);
            }
            System.arraycopy(cs, 0, newElements, index, cs.length);
            this.setArray(newElements);
            return true;
        }
    }

    @Override
    public void forEach(Consumer<? super E> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        Object[] objectArray = this.getArray();
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            Object x;
            Object e = x = objectArray[i];
            action.accept(e);
        }
    }

    @Override
    public boolean removeIf(Predicate<? super E> filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        return this.bulkRemove(filter);
    }

    private static long[] nBits(int n) {
        return new long[(n - 1 >> 6) + 1];
    }

    private static void setBit(long[] bits, int i) {
        int n = i >> 6;
        bits[n] = bits[n] | 1L << i;
    }

    private static boolean isClear(long[] bits, int i) {
        return (bits[i >> 6] & 1L << i) == 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean bulkRemove(Predicate<? super E> filter) {
        Object object = this.lock;
        synchronized (object) {
            return this.bulkRemove(filter, 0, this.getArray().length);
        }
    }

    boolean bulkRemove(Predicate<? super E> filter, int i, int end) {
        Object[] es = this.getArray();
        while (i < end && !filter.test(CopyOnWriteArrayList.elementAt(es, i))) {
            ++i;
        }
        if (i < end) {
            int beg = i;
            long[] deathRow = CopyOnWriteArrayList.nBits(end - beg);
            int deleted = 1;
            deathRow[0] = 1L;
            for (i = beg + 1; i < end; ++i) {
                if (!filter.test(CopyOnWriteArrayList.elementAt(es, i))) continue;
                CopyOnWriteArrayList.setBit(deathRow, i - beg);
                ++deleted;
            }
            if (es != this.getArray()) {
                throw new ConcurrentModificationException();
            }
            Object[] newElts = Arrays.copyOf(es, es.length - deleted);
            int w = beg;
            for (i = beg; i < end; ++i) {
                if (!CopyOnWriteArrayList.isClear(deathRow, i - beg)) continue;
                newElts[w++] = es[i];
            }
            System.arraycopy(es, i, newElts, w, es.length - i);
            this.setArray(newElts);
            return true;
        }
        if (es != this.getArray()) {
            throw new ConcurrentModificationException();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceAll(UnaryOperator<E> operator) {
        if (operator == null) {
            throw new NullPointerException();
        }
        Object object = this.lock;
        synchronized (object) {
            this.replaceAll(operator, 0, this.getArray().length);
        }
    }

    void replaceAll(UnaryOperator<E> operator, int i, int end) {
        Object[] es = (Object[])this.getArray().clone();
        while (i < end) {
            es[i] = operator.apply(CopyOnWriteArrayList.elementAt(es, i));
            ++i;
        }
        this.setArray(es);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sort(Comparator<? super E> c) {
        Object object = this.lock;
        synchronized (object) {
            this.sort(c, 0, this.getArray().length);
        }
    }

    void sort(Comparator<? super E> c, int i, int end) {
        Object[] es = (Object[])this.getArray().clone();
        Arrays.sort(es, i, end, c);
        this.setArray(es);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        Object[] elements = this.getArray();
        s.writeInt(elements.length);
        for (Object element : elements) {
            s.writeObject(element);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.resetLock();
        int len = s.readInt();
        Object[] elements = new Object[len];
        for (int i = 0; i < len; ++i) {
            elements[i] = s.readObject();
        }
        this.setArray(elements);
    }

    public String toString() {
        return Arrays.toString(this.getArray());
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof List)) {
            return false;
        }
        List list = (List)o;
        Iterator it = list.iterator();
        Object[] elements = this.getArray();
        int len = elements.length;
        for (int i = 0; i < len; ++i) {
            if (it.hasNext() && Objects.equals(elements[i], it.next())) continue;
            return false;
        }
        return !it.hasNext();
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        for (Object x : this.getArray()) {
            hashCode = 31 * hashCode + (x == null ? 0 : x.hashCode());
        }
        return hashCode;
    }

    @Override
    public Iterator<E> iterator() {
        return new COWIterator(this.getArray(), 0);
    }

    @Override
    public ListIterator<E> listIterator() {
        return new COWIterator(this.getArray(), 0);
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        Object[] elements = this.getArray();
        int len = elements.length;
        if (index < 0 || index > len) {
            throw new IndexOutOfBoundsException(CopyOnWriteArrayList.outOfBounds(index, len));
        }
        return new COWIterator(elements, index);
    }

    @Override
    public Spliterator<E> spliterator() {
        return Spliterators.spliterator(this.getArray(), 1040);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        Object object = this.lock;
        synchronized (object) {
            Object[] elements = this.getArray();
            int len = elements.length;
            if (fromIndex < 0 || toIndex > len || fromIndex > toIndex) {
                throw new IndexOutOfBoundsException();
            }
            return new COWSubList(this, fromIndex, toIndex);
        }
    }

    private void resetLock() {
        Field lockField = AccessController.doPrivileged(() -> {
            try {
                Field f = CopyOnWriteArrayList.class.getDeclaredField("lock");
                f.setAccessible(true);
                return f;
            }
            catch (ReflectiveOperationException e) {
                throw new Error(e);
            }
        });
        try {
            lockField.set(this, new Object());
        }
        catch (IllegalAccessException e) {
            throw new Error(e);
        }
    }

    private static class COWSubListIterator<E>
    implements ListIterator<E> {
        private final ListIterator<E> it;
        private final int offset;
        private final int size;

        COWSubListIterator(List<E> l, int index, int offset, int size) {
            this.offset = offset;
            this.size = size;
            this.it = l.listIterator(index + offset);
        }

        @Override
        public boolean hasNext() {
            return this.nextIndex() < this.size;
        }

        @Override
        public E next() {
            if (this.hasNext()) {
                return this.it.next();
            }
            throw new NoSuchElementException();
        }

        @Override
        public boolean hasPrevious() {
            return this.previousIndex() >= 0;
        }

        @Override
        public E previous() {
            if (this.hasPrevious()) {
                return this.it.previous();
            }
            throw new NoSuchElementException();
        }

        @Override
        public int nextIndex() {
            return this.it.nextIndex() - this.offset;
        }

        @Override
        public int previousIndex() {
            return this.it.previousIndex() - this.offset;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void forEachRemaining(Consumer<? super E> action) {
            Objects.requireNonNull(action);
            while (this.nextIndex() < this.size) {
                action.accept(this.it.next());
            }
        }
    }

    private static class COWSubList<E>
    extends AbstractList<E>
    implements RandomAccess {
        private final CopyOnWriteArrayList<E> l;
        private final int offset;
        private int size;
        private Object[] expectedArray;

        COWSubList(CopyOnWriteArrayList<E> list, int fromIndex, int toIndex) {
            this.l = list;
            this.expectedArray = this.l.getArray();
            this.offset = fromIndex;
            this.size = toIndex - fromIndex;
        }

        private void checkForComodification() {
            if (this.l.getArray() != this.expectedArray) {
                throw new ConcurrentModificationException();
            }
        }

        private Object[] getArrayChecked() {
            Object[] a = this.l.getArray();
            if (a != this.expectedArray) {
                throw new ConcurrentModificationException();
            }
            return a;
        }

        private void rangeCheck(int index) {
            if (index < 0 || index >= this.size) {
                throw new IndexOutOfBoundsException(CopyOnWriteArrayList.outOfBounds(index, this.size));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E set(int index, E element) {
            Object object = this.l.lock;
            synchronized (object) {
                this.rangeCheck(index);
                this.checkForComodification();
                E x = this.l.set(this.offset + index, element);
                this.expectedArray = this.l.getArray();
                return x;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E get(int index) {
            Object object = this.l.lock;
            synchronized (object) {
                this.rangeCheck(index);
                this.checkForComodification();
                return this.l.get(this.offset + index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Object object = this.l.lock;
            synchronized (object) {
                this.checkForComodification();
                return this.size;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean add(E element) {
            Object object = this.l.lock;
            synchronized (object) {
                this.checkForComodification();
                this.l.add(this.offset + this.size, element);
                this.expectedArray = this.l.getArray();
                ++this.size;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(int index, E element) {
            Object object = this.l.lock;
            synchronized (object) {
                this.checkForComodification();
                if (index < 0 || index > this.size) {
                    throw new IndexOutOfBoundsException(CopyOnWriteArrayList.outOfBounds(index, this.size));
                }
                this.l.add(this.offset + index, element);
                this.expectedArray = this.l.getArray();
                ++this.size;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(Collection<? extends E> c) {
            Object object = this.l.lock;
            synchronized (object) {
                Object[] oldArray = this.getArrayChecked();
                boolean modified = this.l.addAll(this.offset + this.size, c);
                this.expectedArray = this.l.getArray();
                this.size += this.expectedArray.length - oldArray.length;
                return modified;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.l.lock;
            synchronized (object) {
                this.checkForComodification();
                this.l.removeRange(this.offset, this.offset + this.size);
                this.expectedArray = this.l.getArray();
                this.size = 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E remove(int index) {
            Object object = this.l.lock;
            synchronized (object) {
                this.rangeCheck(index);
                this.checkForComodification();
                E result = this.l.remove(this.offset + index);
                this.expectedArray = this.l.getArray();
                --this.size;
                return result;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(Object o) {
            Object object = this.l.lock;
            synchronized (object) {
                this.checkForComodification();
                int index = this.indexOf(o);
                if (index == -1) {
                    return false;
                }
                this.remove(index);
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Iterator<E> iterator() {
            Object object = this.l.lock;
            synchronized (object) {
                this.checkForComodification();
                return new COWSubListIterator<E>(this.l, 0, this.offset, this.size);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ListIterator<E> listIterator(int index) {
            Object object = this.l.lock;
            synchronized (object) {
                this.checkForComodification();
                if (index < 0 || index > this.size) {
                    throw new IndexOutOfBoundsException(CopyOnWriteArrayList.outOfBounds(index, this.size));
                }
                return new COWSubListIterator<E>(this.l, index, this.offset, this.size);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<E> subList(int fromIndex, int toIndex) {
            Object object = this.l.lock;
            synchronized (object) {
                this.checkForComodification();
                if (fromIndex < 0 || toIndex > this.size || fromIndex > toIndex) {
                    throw new IndexOutOfBoundsException();
                }
                return new COWSubList<E>(this.l, fromIndex + this.offset, toIndex + this.offset);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void forEach(Consumer<? super E> action) {
            int end;
            int i;
            Object[] es;
            if (action == null) {
                throw new NullPointerException();
            }
            Object object = this.l.lock;
            synchronized (object) {
                es = this.getArrayChecked();
                end = i + this.size;
            }
            for (i = this.offset; i < end; ++i) {
                action.accept(CopyOnWriteArrayList.elementAt(es, i));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void replaceAll(UnaryOperator<E> operator) {
            if (operator == null) {
                throw new NullPointerException();
            }
            Object object = this.l.lock;
            synchronized (object) {
                this.checkForComodification();
                this.l.replaceAll(operator, this.offset, this.offset + this.size);
                this.expectedArray = this.l.getArray();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sort(Comparator<? super E> c) {
            Object object = this.l.lock;
            synchronized (object) {
                this.checkForComodification();
                this.l.sort(c, this.offset, this.offset + this.size);
                this.expectedArray = this.l.getArray();
            }
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            Objects.requireNonNull(c);
            return this.bulkRemove(e -> c.contains(e));
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            Objects.requireNonNull(c);
            return this.bulkRemove(e -> !c.contains(e));
        }

        @Override
        public boolean removeIf(Predicate<? super E> filter) {
            Objects.requireNonNull(filter);
            return this.bulkRemove(filter);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean bulkRemove(Predicate<? super E> filter) {
            Object object = this.l.lock;
            synchronized (object) {
                Object[] oldArray = this.getArrayChecked();
                boolean modified = this.l.bulkRemove(filter, this.offset, this.offset + this.size);
                this.expectedArray = this.l.getArray();
                this.size += this.expectedArray.length - oldArray.length;
                return modified;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Spliterator<E> spliterator() {
            Object object = this.l.lock;
            synchronized (object) {
                return Spliterators.spliterator(this.getArrayChecked(), this.offset, this.offset + this.size, 1040);
            }
        }
    }

    static final class COWIterator<E>
    implements ListIterator<E> {
        private final Object[] snapshot;
        private int cursor;

        COWIterator(Object[] elements, int initialCursor) {
            this.cursor = initialCursor;
            this.snapshot = elements;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < this.snapshot.length;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor > 0;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return (E)this.snapshot[this.cursor++];
        }

        @Override
        public E previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            return (E)this.snapshot[--this.cursor];
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void forEachRemaining(Consumer<? super E> action) {
            Objects.requireNonNull(action);
            int size = this.snapshot.length;
            for (int i = this.cursor; i < size; ++i) {
                action.accept(this.snapshot[i]);
            }
            this.cursor = size;
        }
    }
}

