/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public abstract class AbstractExecutorService
implements ExecutorService {
    protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value) {
        return new FutureTask<T>(runnable, value);
    }

    protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
        return new FutureTask<T>(callable);
    }

    @Override
    public Future<?> submit(Runnable task) {
        if (task == null) {
            throw new NullPointerException();
        }
        RunnableFuture<Object> ftask = this.newTaskFor(task, null);
        this.execute(ftask);
        return ftask;
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        if (task == null) {
            throw new NullPointerException();
        }
        RunnableFuture<T> ftask = this.newTaskFor(task, result);
        this.execute(ftask);
        return ftask;
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        if (task == null) {
            throw new NullPointerException();
        }
        RunnableFuture<T> ftask = this.newTaskFor(task);
        this.execute(ftask);
        return ftask;
    }

    private <T> T doInvokeAny(Collection<? extends Callable<T>> tasks, boolean timed, long nanos) throws InterruptedException, ExecutionException, TimeoutException {
        ExecutionException ee;
        ArrayList<Future<T>> futures;
        block16: {
            if (tasks == null) {
                throw new NullPointerException();
            }
            int ntasks = tasks.size();
            if (ntasks == 0) {
                throw new IllegalArgumentException();
            }
            futures = new ArrayList<Future<T>>(ntasks);
            ExecutorCompletionService<T> ecs = new ExecutorCompletionService<T>(this);
            ee = null;
            long deadline = timed ? System.nanoTime() + nanos : 0L;
            Iterator<Callable<T>> it = tasks.iterator();
            futures.add(ecs.submit(it.next()));
            --ntasks;
            int active = 1;
            while (true) {
                Object v;
                Future f;
                if ((f = ecs.poll()) == null) {
                    if (ntasks > 0) {
                        --ntasks;
                        futures.add(ecs.submit(it.next()));
                        ++active;
                    } else {
                        if (active == 0) break;
                        if (timed) {
                            f = ecs.poll(nanos, TimeUnit.NANOSECONDS);
                            if (f == null) {
                                throw new TimeoutException();
                            }
                            nanos = deadline - System.nanoTime();
                        } else {
                            f = ecs.take();
                        }
                    }
                }
                if (f == null) continue;
                --active;
                try {
                    v = f.get();
                }
                catch (ExecutionException eex) {
                    ee = eex;
                    continue;
                }
                catch (RuntimeException rex) {
                    ee = new ExecutionException(rex);
                    continue;
                }
                return (T)v;
                break;
            }
            if (ee != null) break block16;
            ee = new ExecutionException();
        }
        throw ee;
        finally {
            AbstractExecutorService.cancelAll(futures);
        }
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        try {
            return this.doInvokeAny(tasks, false, 0L);
        }
        catch (TimeoutException cannotHappen) {
            assert (false);
            return null;
        }
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.doInvokeAny(tasks, true, unit.toNanos(timeout));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        if (tasks == null) {
            throw new NullPointerException();
        }
        ArrayList<Future<T>> futures = new ArrayList<Future<T>>(tasks.size());
        try {
            Future<T> f;
            for (Callable<T> t : tasks) {
                f = this.newTaskFor(t);
                futures.add(f);
                this.execute((Runnable)((Object)f));
            }
            int size = futures.size();
            for (int i = 0; i < size; ++i) {
                f = futures.get(i);
                if (f.isDone()) continue;
                try {
                    f.get();
                    continue;
                }
                catch (CancellationException cancellationException) {
                    continue;
                }
                catch (ExecutionException executionException) {
                    // empty catch block
                }
            }
            return futures;
        }
        catch (Throwable t) {
            AbstractExecutorService.cancelAll(futures);
            throw t;
        }
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        int j;
        ArrayList<Future<T>> futures;
        block12: {
            if (tasks == null) {
                throw new NullPointerException();
            }
            long nanos = unit.toNanos(timeout);
            long deadline = System.nanoTime() + nanos;
            futures = new ArrayList<Future<T>>(tasks.size());
            j = 0;
            try {
                for (Callable<T> t : tasks) {
                    futures.add(this.newTaskFor(t));
                }
                int size = futures.size();
                for (int i = 0; i < size; ++i) {
                    if ((i == 0 ? nanos : deadline - System.nanoTime()) > 0L) {
                        this.execute((Runnable)((Object)futures.get(i)));
                        continue;
                    }
                    break block12;
                }
                while (j < size) {
                    Future<T> f = futures.get(j);
                    if (!f.isDone()) {
                        try {
                            f.get(deadline - System.nanoTime(), TimeUnit.NANOSECONDS);
                        }
                        catch (CancellationException cancellationException) {
                        }
                        catch (ExecutionException executionException) {
                        }
                        catch (TimeoutException timedOut) {
                            break block12;
                        }
                    }
                    ++j;
                }
                return futures;
            }
            catch (Throwable t) {
                AbstractExecutorService.cancelAll(futures);
                throw t;
            }
        }
        AbstractExecutorService.cancelAll(futures, j);
        return futures;
    }

    private static <T> void cancelAll(ArrayList<Future<T>> futures) {
        AbstractExecutorService.cancelAll(futures, 0);
    }

    private static <T> void cancelAll(ArrayList<Future<T>> futures, int j) {
        int size = futures.size();
        while (j < size) {
            futures.get(j).cancel(true);
            ++j;
        }
    }
}

