/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StreamCorruptedException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.InvalidPropertiesFormatException;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import jdk.internal.util.xml.PropertiesDefaultHandler;

public class Properties
extends Hashtable<Object, Object> {
    private static final long serialVersionUID = 4112578634029874840L;
    protected Properties defaults;
    private transient ConcurrentHashMap<Object, Object> map = new ConcurrentHashMap(8);
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public Properties() {
        this((Properties)null);
    }

    public Properties(Properties defaults) {
        super((Void)null);
        this.defaults = defaults;
    }

    public synchronized Object setProperty(String key, String value) {
        return this.put(key, value);
    }

    public synchronized void load(Reader reader) throws IOException {
        Objects.requireNonNull(reader, "reader parameter is null");
        this.load0(new LineReader(reader));
    }

    public synchronized void load(InputStream inStream) throws IOException {
        Objects.requireNonNull(inStream, "inStream parameter is null");
        this.load0(new LineReader(inStream));
    }

    private void load0(LineReader lr) throws IOException {
        int limit;
        char[] convtBuf = new char[1024];
        while ((limit = lr.readLine()) >= 0) {
            int keyLen;
            char c = '\u0000';
            int valueStart = limit;
            boolean hasSep = false;
            boolean precedingBackslash = false;
            for (keyLen = 0; keyLen < limit; ++keyLen) {
                c = lr.lineBuf[keyLen];
                if (!(c != '=' && c != ':' || precedingBackslash)) {
                    valueStart = keyLen + 1;
                    hasSep = true;
                    break;
                }
                if (!(c != ' ' && c != '\t' && c != '\f' || precedingBackslash)) {
                    valueStart = keyLen + 1;
                    break;
                }
                precedingBackslash = c == '\\' ? !precedingBackslash : false;
            }
            while (valueStart < limit) {
                c = lr.lineBuf[valueStart];
                if (c != ' ' && c != '\t' && c != '\f') {
                    if (hasSep || c != '=' && c != ':') break;
                    hasSep = true;
                }
                ++valueStart;
            }
            String key = this.loadConvert(lr.lineBuf, 0, keyLen, convtBuf);
            String value = this.loadConvert(lr.lineBuf, valueStart, limit - valueStart, convtBuf);
            this.put(key, value);
        }
    }

    private String loadConvert(char[] in, int off, int len, char[] convtBuf) {
        if (convtBuf.length < len) {
            int newLen = len * 2;
            if (newLen < 0) {
                newLen = Integer.MAX_VALUE;
            }
            convtBuf = new char[newLen];
        }
        char[] out = convtBuf;
        int outLen = 0;
        int end = off + len;
        while (off < end) {
            int aChar;
            if ((aChar = in[off++]) == 92) {
                if ((aChar = in[off++]) == 117) {
                    int value = 0;
                    block6: for (int i = 0; i < 4; ++i) {
                        aChar = in[off++];
                        switch (aChar) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                value = (value << 4) + aChar - 48;
                                continue block6;
                            }
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: {
                                value = (value << 4) + 10 + aChar - 97;
                                continue block6;
                            }
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: {
                                value = (value << 4) + 10 + aChar - 65;
                                continue block6;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                            }
                        }
                    }
                    out[outLen++] = (char)value;
                    continue;
                }
                if (aChar == 116) {
                    aChar = 9;
                } else if (aChar == 114) {
                    aChar = 13;
                } else if (aChar == 110) {
                    aChar = 10;
                } else if (aChar == 102) {
                    aChar = 12;
                }
                out[outLen++] = aChar;
                continue;
            }
            out[outLen++] = aChar;
        }
        return new String(out, 0, outLen);
    }

    private String saveConvert(String theString, boolean escapeSpace, boolean escapeUnicode) {
        int len = theString.length();
        int bufLen = len * 2;
        if (bufLen < 0) {
            bufLen = Integer.MAX_VALUE;
        }
        StringBuilder outBuffer = new StringBuilder(bufLen);
        block8: for (int x = 0; x < len; ++x) {
            char aChar = theString.charAt(x);
            if (aChar > '=' && aChar < '\u007f') {
                if (aChar == '\\') {
                    outBuffer.append('\\');
                    outBuffer.append('\\');
                    continue;
                }
                outBuffer.append(aChar);
                continue;
            }
            switch (aChar) {
                case ' ': {
                    if (x == 0 || escapeSpace) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(' ');
                    continue block8;
                }
                case '\t': {
                    outBuffer.append('\\');
                    outBuffer.append('t');
                    continue block8;
                }
                case '\n': {
                    outBuffer.append('\\');
                    outBuffer.append('n');
                    continue block8;
                }
                case '\r': {
                    outBuffer.append('\\');
                    outBuffer.append('r');
                    continue block8;
                }
                case '\f': {
                    outBuffer.append('\\');
                    outBuffer.append('f');
                    continue block8;
                }
                case '!': 
                case '#': 
                case ':': 
                case '=': {
                    outBuffer.append('\\');
                    outBuffer.append(aChar);
                    continue block8;
                }
                default: {
                    if ((aChar < ' ' || aChar > '~') & escapeUnicode) {
                        outBuffer.append('\\');
                        outBuffer.append('u');
                        outBuffer.append(Properties.toHex(aChar >> 12 & 0xF));
                        outBuffer.append(Properties.toHex(aChar >> 8 & 0xF));
                        outBuffer.append(Properties.toHex(aChar >> 4 & 0xF));
                        outBuffer.append(Properties.toHex(aChar & 0xF));
                        continue block8;
                    }
                    outBuffer.append(aChar);
                }
            }
        }
        return outBuffer.toString();
    }

    private static void writeComments(BufferedWriter bw, String comments) throws IOException {
        int current;
        bw.write("#");
        int len = comments.length();
        int last = 0;
        char[] uu = new char[6];
        uu[0] = 92;
        uu[1] = 117;
        for (current = 0; current < len; ++current) {
            char c = comments.charAt(current);
            if (c <= '\u00ff' && c != '\n' && c != '\r') continue;
            if (last != current) {
                bw.write(comments.substring(last, current));
            }
            if (c > '\u00ff') {
                uu[2] = Properties.toHex(c >> 12 & 0xF);
                uu[3] = Properties.toHex(c >> 8 & 0xF);
                uu[4] = Properties.toHex(c >> 4 & 0xF);
                uu[5] = Properties.toHex(c & 0xF);
                bw.write(new String(uu));
            } else {
                bw.newLine();
                if (c == '\r' && current != len - 1 && comments.charAt(current + 1) == '\n') {
                    ++current;
                }
                if (current == len - 1 || comments.charAt(current + 1) != '#' && comments.charAt(current + 1) != '!') {
                    bw.write("#");
                }
            }
            last = current + 1;
        }
        if (last != current) {
            bw.write(comments.substring(last, current));
        }
        bw.newLine();
    }

    @Deprecated
    public void save(OutputStream out, String comments) {
        try {
            this.store(out, comments);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void store(Writer writer, String comments) throws IOException {
        this.store0(writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer), comments, false);
    }

    public void store(OutputStream out, String comments) throws IOException {
        this.store0(new BufferedWriter(new OutputStreamWriter(out, "8859_1")), comments, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void store0(BufferedWriter bw, String comments, boolean escUnicode) throws IOException {
        if (comments != null) {
            Properties.writeComments(bw, comments);
        }
        bw.write("#" + new Date().toString());
        bw.newLine();
        Properties properties = this;
        synchronized (properties) {
            for (Map.Entry<Object, Object> e : this.entrySet()) {
                String key = (String)e.getKey();
                String val = (String)e.getValue();
                key = this.saveConvert(key, true, escUnicode);
                val = this.saveConvert(val, false, escUnicode);
                bw.write(key + "=" + val);
                bw.newLine();
            }
        }
        bw.flush();
    }

    public synchronized void loadFromXML(InputStream in) throws IOException, InvalidPropertiesFormatException {
        Objects.requireNonNull(in);
        PropertiesDefaultHandler handler = new PropertiesDefaultHandler();
        handler.load(this, in);
        in.close();
    }

    public void storeToXML(OutputStream os, String comment) throws IOException {
        this.storeToXML(os, comment, "UTF-8");
    }

    public void storeToXML(OutputStream os, String comment, String encoding) throws IOException {
        Objects.requireNonNull(os);
        Objects.requireNonNull(encoding);
        PropertiesDefaultHandler handler = new PropertiesDefaultHandler();
        handler.store(this, os, comment, encoding);
    }

    public String getProperty(String key) {
        Object oval = this.map.get(key);
        String sval = oval instanceof String ? (String)oval : null;
        return sval == null && this.defaults != null ? this.defaults.getProperty(key) : sval;
    }

    public String getProperty(String key, String defaultValue) {
        String val = this.getProperty(key);
        return val == null ? defaultValue : val;
    }

    public Enumeration<?> propertyNames() {
        Hashtable<String, Object> h = new Hashtable<String, Object>();
        this.enumerate(h);
        return h.keys();
    }

    public Set<String> stringPropertyNames() {
        HashMap<String, String> h = new HashMap<String, String>();
        this.enumerateStringProperties(h);
        return Collections.unmodifiableSet(h.keySet());
    }

    public void list(PrintStream out) {
        out.println("-- listing properties --");
        HashMap<String, Object> h = new HashMap<String, Object>();
        this.enumerate(h);
        for (Map.Entry e : h.entrySet()) {
            String key = (String)e.getKey();
            String val = (String)e.getValue();
            if (val.length() > 40) {
                val = val.substring(0, 37) + "...";
            }
            out.println(key + "=" + val);
        }
    }

    public void list(PrintWriter out) {
        out.println("-- listing properties --");
        HashMap<String, Object> h = new HashMap<String, Object>();
        this.enumerate(h);
        for (Map.Entry e : h.entrySet()) {
            String key = (String)e.getKey();
            String val = (String)e.getValue();
            if (val.length() > 40) {
                val = val.substring(0, 37) + "...";
            }
            out.println(key + "=" + val);
        }
    }

    private void enumerate(Map<String, Object> h) {
        if (this.defaults != null) {
            this.defaults.enumerate(h);
        }
        for (Map.Entry<Object, Object> e : this.entrySet()) {
            String key = (String)e.getKey();
            h.put(key, e.getValue());
        }
    }

    private void enumerateStringProperties(Map<String, String> h) {
        if (this.defaults != null) {
            this.defaults.enumerateStringProperties(h);
        }
        for (Map.Entry<Object, Object> e : this.entrySet()) {
            Object k = e.getKey();
            Object v = e.getValue();
            if (!(k instanceof String) || !(v instanceof String)) continue;
            h.put((String)k, (String)v);
        }
    }

    private static char toHex(int nibble) {
        return hexDigit[nibble & 0xF];
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Enumeration<Object> keys() {
        return Collections.enumeration(this.map.keySet());
    }

    @Override
    public Enumeration<Object> elements() {
        return Collections.enumeration(this.map.values());
    }

    @Override
    public boolean contains(Object value) {
        return this.map.contains(value);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public Object get(Object key) {
        return this.map.get(key);
    }

    @Override
    public synchronized Object put(Object key, Object value) {
        return this.map.put(key, value);
    }

    @Override
    public synchronized Object remove(Object key) {
        return this.map.remove(key);
    }

    @Override
    public synchronized void putAll(Map<?, ?> t) {
        this.map.putAll(t);
    }

    @Override
    public synchronized void clear() {
        this.map.clear();
    }

    @Override
    public synchronized String toString() {
        return this.map.toString();
    }

    @Override
    public Set<Object> keySet() {
        return Collections.synchronizedSet(this.map.keySet(), this);
    }

    @Override
    public Collection<Object> values() {
        return Collections.synchronizedCollection(this.map.values(), this);
    }

    @Override
    public Set<Map.Entry<Object, Object>> entrySet() {
        return Collections.synchronizedSet(new EntrySet(this.map.entrySet()), this);
    }

    @Override
    public synchronized boolean equals(Object o) {
        return this.map.equals(o);
    }

    @Override
    public synchronized int hashCode() {
        return this.map.hashCode();
    }

    @Override
    public Object getOrDefault(Object key, Object defaultValue) {
        return this.map.getOrDefault(key, defaultValue);
    }

    @Override
    public synchronized void forEach(BiConsumer<? super Object, ? super Object> action) {
        this.map.forEach(action);
    }

    @Override
    public synchronized void replaceAll(BiFunction<? super Object, ? super Object, ?> function) {
        this.map.replaceAll(function);
    }

    @Override
    public synchronized Object putIfAbsent(Object key, Object value) {
        return this.map.putIfAbsent(key, value);
    }

    @Override
    public synchronized boolean remove(Object key, Object value) {
        return this.map.remove(key, value);
    }

    @Override
    public synchronized boolean replace(Object key, Object oldValue, Object newValue) {
        return this.map.replace(key, oldValue, newValue);
    }

    @Override
    public synchronized Object replace(Object key, Object value) {
        return this.map.replace(key, value);
    }

    @Override
    public synchronized Object computeIfAbsent(Object key, Function<? super Object, ?> mappingFunction) {
        return this.map.computeIfAbsent(key, mappingFunction);
    }

    @Override
    public synchronized Object computeIfPresent(Object key, BiFunction<? super Object, ? super Object, ?> remappingFunction) {
        return this.map.computeIfPresent(key, remappingFunction);
    }

    @Override
    public synchronized Object compute(Object key, BiFunction<? super Object, ? super Object, ?> remappingFunction) {
        return this.map.compute(key, remappingFunction);
    }

    @Override
    public synchronized Object merge(Object key, Object value, BiFunction<? super Object, ? super Object, ?> remappingFunction) {
        return this.map.merge(key, value, remappingFunction);
    }

    @Override
    protected void rehash() {
    }

    @Override
    public synchronized Object clone() {
        Properties clone = (Properties)this.cloneHashtable();
        clone.map = new ConcurrentHashMap<Object, Object>(this.map);
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void writeHashtable(ObjectOutputStream s) throws IOException {
        ArrayList<Object> entryStack = new ArrayList<Object>(this.map.size() * 2);
        for (Map.Entry<Object, Object> entry : this.map.entrySet()) {
            entryStack.add(entry.getValue());
            entryStack.add(entry.getKey());
        }
        float loadFactor = 0.75f;
        int count = entryStack.size() / 2;
        int length = (int)((float)count / loadFactor) + count / 20 + 3;
        if (length > count && (length & 1) == 0) {
            --length;
        }
        ConcurrentHashMap<Object, Object> concurrentHashMap = this.map;
        synchronized (concurrentHashMap) {
            this.defaultWriteHashtable(s, length, loadFactor);
        }
        s.writeInt(length);
        s.writeInt(count);
        for (int i = entryStack.size() - 1; i >= 0; --i) {
            s.writeObject(entryStack.get(i));
        }
    }

    @Override
    void readHashtable(ObjectInputStream s) throws IOException, ClassNotFoundException {
        int elements;
        s.defaultReadObject();
        int origlength = s.readInt();
        if (elements < 0) {
            throw new StreamCorruptedException("Illegal # of Elements: " + elements);
        }
        this.map = new ConcurrentHashMap(elements);
        for (elements = s.readInt(); elements > 0; --elements) {
            Object key = s.readObject();
            Object value = s.readObject();
            this.map.put(key, value);
        }
    }

    private static class EntrySet
    implements Set<Map.Entry<Object, Object>> {
        private Set<Map.Entry<Object, Object>> entrySet;

        private EntrySet(Set<Map.Entry<Object, Object>> entrySet) {
            this.entrySet = entrySet;
        }

        @Override
        public int size() {
            return this.entrySet.size();
        }

        @Override
        public boolean isEmpty() {
            return this.entrySet.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.entrySet.contains(o);
        }

        @Override
        public Object[] toArray() {
            return this.entrySet.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.entrySet.toArray(a);
        }

        @Override
        public void clear() {
            this.entrySet.clear();
        }

        @Override
        public boolean remove(Object o) {
            return this.entrySet.remove(o);
        }

        @Override
        public boolean add(Map.Entry<Object, Object> e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends Map.Entry<Object, Object>> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.entrySet.containsAll(c);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.entrySet.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.entrySet.retainAll(c);
        }

        @Override
        public Iterator<Map.Entry<Object, Object>> iterator() {
            return this.entrySet.iterator();
        }
    }

    class LineReader {
        byte[] inByteBuf;
        char[] inCharBuf;
        char[] lineBuf = new char[1024];
        int inLimit = 0;
        int inOff = 0;
        InputStream inStream;
        Reader reader;

        public LineReader(InputStream inStream) {
            this.inStream = inStream;
            this.inByteBuf = new byte[8192];
        }

        public LineReader(Reader reader) {
            this.reader = reader;
            this.inCharBuf = new char[8192];
        }

        int readLine() throws IOException {
            int len = 0;
            char c = '\u0000';
            boolean skipWhiteSpace = true;
            boolean isCommentLine = false;
            boolean isNewLine = true;
            boolean appendedLineBegin = false;
            boolean precedingBackslash = false;
            boolean skipLF = false;
            while (true) {
                if (this.inOff >= this.inLimit) {
                    this.inLimit = this.inStream == null ? this.reader.read(this.inCharBuf) : this.inStream.read(this.inByteBuf);
                    this.inOff = 0;
                    if (this.inLimit <= 0) {
                        if (len == 0 || isCommentLine) {
                            return -1;
                        }
                        if (precedingBackslash) {
                            --len;
                        }
                        return len;
                    }
                }
                c = this.inStream != null ? (char)(0xFF & this.inByteBuf[this.inOff++]) : this.inCharBuf[this.inOff++];
                if (skipLF) {
                    skipLF = false;
                    if (c == '\n') continue;
                }
                if (skipWhiteSpace) {
                    if (c == ' ' || c == '\t' || c == '\f' || !appendedLineBegin && (c == '\r' || c == '\n')) continue;
                    skipWhiteSpace = false;
                    appendedLineBegin = false;
                }
                if (isNewLine) {
                    isNewLine = false;
                    if (c == '#' || c == '!') {
                        isCommentLine = true;
                        continue;
                    }
                }
                if (c != '\n' && c != '\r') {
                    this.lineBuf[len++] = c;
                    if (len == this.lineBuf.length) {
                        int newLength = this.lineBuf.length * 2;
                        if (newLength < 0) {
                            newLength = Integer.MAX_VALUE;
                        }
                        char[] buf = new char[newLength];
                        System.arraycopy(this.lineBuf, 0, buf, 0, this.lineBuf.length);
                        this.lineBuf = buf;
                    }
                    if (c == '\\') {
                        precedingBackslash = !precedingBackslash;
                        continue;
                    }
                    precedingBackslash = false;
                    continue;
                }
                if (isCommentLine || len == 0) {
                    isCommentLine = false;
                    isNewLine = true;
                    skipWhiteSpace = true;
                    len = 0;
                    continue;
                }
                if (this.inOff >= this.inLimit) {
                    this.inLimit = this.inStream == null ? this.reader.read(this.inCharBuf) : this.inStream.read(this.inByteBuf);
                    this.inOff = 0;
                    if (this.inLimit <= 0) {
                        if (precedingBackslash) {
                            --len;
                        }
                        return len;
                    }
                }
                if (!precedingBackslash) break;
                --len;
                skipWhiteSpace = true;
                appendedLineBegin = true;
                precedingBackslash = false;
                if (c != '\r') continue;
                skipLF = true;
            }
            return len;
        }
    }
}

