/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.CollSer;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.KeyValueHolder;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import jdk.internal.vm.annotation.Stable;

class ImmutableCollections {
    static final int SALT;
    static final int EXPAND_FACTOR = 2;

    private ImmutableCollections() {
    }

    static UnsupportedOperationException uoe() {
        return new UnsupportedOperationException();
    }

    static {
        long nt = System.nanoTime();
        SALT = (int)(nt >>> 32 ^ nt);
    }

    static final class MapN<K, V>
    extends AbstractImmutableMap<K, V> {
        @Stable
        final Object[] table;
        @Stable
        final int size;

        MapN(Object ... input) {
            if ((input.length & 1) != 0) {
                throw new InternalError("length is odd");
            }
            this.size = input.length >> 1;
            int len = 2 * input.length;
            len = len + 1 & 0xFFFFFFFE;
            this.table = new Object[len];
            for (int i = 0; i < input.length; i += 2) {
                Object k = Objects.requireNonNull(input[i]);
                Object v = Objects.requireNonNull(input[i + 1]);
                int idx = this.probe(k);
                if (idx >= 0) {
                    throw new IllegalArgumentException("duplicate key: " + k);
                }
                int dest = -(idx + 1);
                this.table[dest] = k;
                this.table[dest + 1] = v;
            }
        }

        @Override
        public boolean containsKey(Object o) {
            return this.probe(o) >= 0;
        }

        @Override
        public boolean containsValue(Object o) {
            for (int i = 1; i < this.table.length; i += 2) {
                Object v = this.table[i];
                if (v == null || !o.equals(v)) continue;
                return true;
            }
            return false;
        }

        @Override
        public int hashCode() {
            int hash = 0;
            for (int i = 0; i < this.table.length; i += 2) {
                Object k = this.table[i];
                if (k == null) continue;
                hash += k.hashCode() ^ this.table[i + 1].hashCode();
            }
            return hash;
        }

        @Override
        public V get(Object o) {
            int i = this.probe(o);
            if (i >= 0) {
                return (V)this.table[i + 1];
            }
            return null;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return new AbstractSet<Map.Entry<K, V>>(){

                @Override
                public int size() {
                    return size;
                }

                @Override
                public Iterator<Map.Entry<K, V>> iterator() {
                    return new Iterator<Map.Entry<K, V>>(){
                        int idx = 0;

                        @Override
                        public boolean hasNext() {
                            while (this.idx < table.length) {
                                if (table[this.idx] != null) {
                                    return true;
                                }
                                this.idx += 2;
                            }
                            return false;
                        }

                        @Override
                        public Map.Entry<K, V> next() {
                            if (this.hasNext()) {
                                KeyValueHolder<Object, Object> e = new KeyValueHolder<Object, Object>(table[this.idx], table[this.idx + 1]);
                                this.idx += 2;
                                return e;
                            }
                            throw new NoSuchElementException();
                        }
                    };
                }
            };
        }

        private int probe(Object pk) {
            int idx = Math.floorMod(pk.hashCode() ^ SALT, this.table.length >> 1) << 1;
            Object ek;
            while ((ek = this.table[idx]) != null) {
                if (pk.equals(ek)) {
                    return idx;
                }
                if ((idx += 2) != this.table.length) continue;
                idx = 0;
            }
            return -idx - 1;
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            throw new InvalidObjectException("not serial proxy");
        }

        private Object writeReplace() {
            Object[] array = new Object[2 * this.size];
            int len = this.table.length;
            int dest = 0;
            for (int i = 0; i < len; i += 2) {
                if (this.table[i] == null) continue;
                array[dest++] = this.table[i];
                array[dest++] = this.table[i + 1];
            }
            return new CollSer(3, array);
        }
    }

    static final class Map1<K, V>
    extends AbstractImmutableMap<K, V> {
        @Stable
        private final K k0;
        @Stable
        private final V v0;

        Map1(K k0, V v0) {
            this.k0 = Objects.requireNonNull(k0);
            this.v0 = Objects.requireNonNull(v0);
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return Set.of(new KeyValueHolder<K, V>(this.k0, this.v0));
        }

        @Override
        public boolean containsKey(Object o) {
            return o.equals(this.k0);
        }

        @Override
        public boolean containsValue(Object o) {
            return o.equals(this.v0);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            throw new InvalidObjectException("not serial proxy");
        }

        private Object writeReplace() {
            return new CollSer(3, this.k0, this.v0);
        }

        @Override
        public int hashCode() {
            return this.k0.hashCode() ^ this.v0.hashCode();
        }
    }

    static final class Map0<K, V>
    extends AbstractImmutableMap<K, V> {
        private static final Map0<?, ?> INSTANCE = new Map0();

        static <K, V> Map0<K, V> instance() {
            return INSTANCE;
        }

        private Map0() {
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return Set.of();
        }

        @Override
        public boolean containsKey(Object o) {
            Objects.requireNonNull(o);
            return false;
        }

        @Override
        public boolean containsValue(Object o) {
            Objects.requireNonNull(o);
            return false;
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            throw new InvalidObjectException("not serial proxy");
        }

        private Object writeReplace() {
            return new CollSer(3, new Object[0]);
        }

        @Override
        public int hashCode() {
            return 0;
        }
    }

    static abstract class AbstractImmutableMap<K, V>
    extends AbstractMap<K, V>
    implements Serializable {
        AbstractImmutableMap() {
        }

        @Override
        public void clear() {
            throw ImmutableCollections.uoe();
        }

        @Override
        public V compute(K key, BiFunction<? super K, ? super V, ? extends V> rf) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public V computeIfAbsent(K key, Function<? super K, ? extends V> mf) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> rf) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> rf) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public V put(K key, V value) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> m) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public V putIfAbsent(K key, V value) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public V remove(Object key) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public boolean remove(Object key, Object value) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public V replace(K key, V value) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public boolean replace(K key, V oldValue, V newValue) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public void replaceAll(BiFunction<? super K, ? super V, ? extends V> f) {
            throw ImmutableCollections.uoe();
        }
    }

    static final class SetN<E>
    extends AbstractImmutableSet<E> {
        @Stable
        final E[] elements;
        @Stable
        final int size;

        @SafeVarargs
        SetN(E ... input) {
            this.size = input.length;
            this.elements = new Object[2 * input.length];
            for (int i = 0; i < input.length; ++i) {
                E e = input[i];
                int idx = this.probe(e);
                if (idx >= 0) {
                    throw new IllegalArgumentException("duplicate element: " + e);
                }
                this.elements[-(idx + 1)] = e;
            }
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public boolean contains(Object o) {
            return this.probe(o) >= 0;
        }

        @Override
        public Iterator<E> iterator() {
            return new Iterator<E>(){
                private int idx = 0;

                @Override
                public boolean hasNext() {
                    while (this.idx < elements.length) {
                        if (elements[this.idx] != null) {
                            return true;
                        }
                        ++this.idx;
                    }
                    return false;
                }

                @Override
                public E next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    return elements[this.idx++];
                }
            };
        }

        @Override
        public int hashCode() {
            int h = 0;
            for (E e : this.elements) {
                if (e == null) continue;
                h += e.hashCode();
            }
            return h;
        }

        private int probe(Object pe) {
            int idx = Math.floorMod(pe.hashCode() ^ SALT, this.elements.length);
            E ee;
            while ((ee = this.elements[idx]) != null) {
                if (pe.equals(ee)) {
                    return idx;
                }
                if (++idx != this.elements.length) continue;
                idx = 0;
            }
            return -idx - 1;
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            throw new InvalidObjectException("not serial proxy");
        }

        private Object writeReplace() {
            Object[] array = new Object[this.size];
            int dest = 0;
            for (E o : this.elements) {
                if (o == null) continue;
                array[dest++] = o;
            }
            return new CollSer(2, array);
        }
    }

    static final class Set2<E>
    extends AbstractImmutableSet<E> {
        @Stable
        final E e0;
        @Stable
        final E e1;

        Set2(E e0, E e1) {
            if (e0.equals(Objects.requireNonNull(e1))) {
                throw new IllegalArgumentException("duplicate element: " + e0);
            }
            if (SALT >= 0) {
                this.e0 = e0;
                this.e1 = e1;
            } else {
                this.e0 = e1;
                this.e1 = e0;
            }
        }

        @Override
        public int size() {
            return 2;
        }

        @Override
        public boolean contains(Object o) {
            return o.equals(this.e0) || o.equals(this.e1);
        }

        @Override
        public int hashCode() {
            return this.e0.hashCode() + this.e1.hashCode();
        }

        @Override
        public Iterator<E> iterator() {
            return new Iterator<E>(){
                private int idx = 0;

                @Override
                public boolean hasNext() {
                    return this.idx < 2;
                }

                @Override
                public E next() {
                    if (this.idx == 0) {
                        this.idx = 1;
                        return e0;
                    }
                    if (this.idx == 1) {
                        this.idx = 2;
                        return e1;
                    }
                    throw new NoSuchElementException();
                }
            };
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            throw new InvalidObjectException("not serial proxy");
        }

        private Object writeReplace() {
            return new CollSer(2, this.e0, this.e1);
        }
    }

    static final class Set1<E>
    extends AbstractImmutableSet<E> {
        @Stable
        private final E e0;

        Set1(E e0) {
            this.e0 = Objects.requireNonNull(e0);
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public boolean contains(Object o) {
            return o.equals(this.e0);
        }

        @Override
        public Iterator<E> iterator() {
            return Collections.singletonIterator(this.e0);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            throw new InvalidObjectException("not serial proxy");
        }

        private Object writeReplace() {
            return new CollSer(2, this.e0);
        }

        @Override
        public int hashCode() {
            return this.e0.hashCode();
        }
    }

    static final class Set0<E>
    extends AbstractImmutableSet<E> {
        private static final Set0<?> INSTANCE = new Set0();

        static <T> Set0<T> instance() {
            return INSTANCE;
        }

        private Set0() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean contains(Object o) {
            Objects.requireNonNull(o);
            return false;
        }

        @Override
        public boolean containsAll(Collection<?> o) {
            return o.isEmpty();
        }

        @Override
        public Iterator<E> iterator() {
            return Collections.emptyIterator();
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            throw new InvalidObjectException("not serial proxy");
        }

        private Object writeReplace() {
            return new CollSer(2, new Object[0]);
        }

        @Override
        public int hashCode() {
            return 0;
        }
    }

    static abstract class AbstractImmutableSet<E>
    extends AbstractSet<E>
    implements Serializable {
        AbstractImmutableSet() {
        }

        @Override
        public boolean add(E e) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public void clear() {
            throw ImmutableCollections.uoe();
        }

        @Override
        public boolean remove(Object o) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public boolean removeIf(Predicate<? super E> filter) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw ImmutableCollections.uoe();
        }
    }

    static final class ListN<E>
    extends AbstractImmutableList<E> {
        @Stable
        private final E[] elements;

        @SafeVarargs
        ListN(E ... input) {
            Object[] tmp = new Object[input.length];
            for (int i = 0; i < input.length; ++i) {
                tmp[i] = Objects.requireNonNull(input[i]);
            }
            this.elements = tmp;
        }

        @Override
        public int size() {
            return this.elements.length;
        }

        @Override
        public E get(int index) {
            Objects.checkIndex(index, this.elements.length);
            return this.elements[index];
        }

        @Override
        public boolean contains(Object o) {
            for (E e : this.elements) {
                if (!o.equals(e)) continue;
                return true;
            }
            return false;
        }

        @Override
        public int hashCode() {
            int hash = 1;
            for (E e : this.elements) {
                hash = 31 * hash + e.hashCode();
            }
            return hash;
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            throw new InvalidObjectException("not serial proxy");
        }

        private Object writeReplace() {
            return new CollSer(1, this.elements);
        }
    }

    static final class List2<E>
    extends AbstractImmutableList<E> {
        @Stable
        private final E e0;
        @Stable
        private final E e1;

        List2(E e0, E e1) {
            this.e0 = Objects.requireNonNull(e0);
            this.e1 = Objects.requireNonNull(e1);
        }

        @Override
        public int size() {
            return 2;
        }

        @Override
        public E get(int index) {
            Objects.checkIndex(index, 2);
            if (index == 0) {
                return this.e0;
            }
            return this.e1;
        }

        @Override
        public boolean contains(Object o) {
            return o.equals(this.e0) || o.equals(this.e1);
        }

        @Override
        public int hashCode() {
            int hash = 31 + this.e0.hashCode();
            return 31 * hash + this.e1.hashCode();
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            throw new InvalidObjectException("not serial proxy");
        }

        private Object writeReplace() {
            return new CollSer(1, this.e0, this.e1);
        }
    }

    static final class List1<E>
    extends AbstractImmutableList<E> {
        @Stable
        private final E e0;

        List1(E e0) {
            this.e0 = Objects.requireNonNull(e0);
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public E get(int index) {
            Objects.checkIndex(index, 1);
            return this.e0;
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            throw new InvalidObjectException("not serial proxy");
        }

        private Object writeReplace() {
            return new CollSer(1, this.e0);
        }

        @Override
        public boolean contains(Object o) {
            return o.equals(this.e0);
        }

        @Override
        public int hashCode() {
            return 31 + this.e0.hashCode();
        }
    }

    static final class List0<E>
    extends AbstractImmutableList<E> {
        private static final List0<?> INSTANCE = new List0();

        static <T> List0<T> instance() {
            return INSTANCE;
        }

        private List0() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public E get(int index) {
            Objects.checkIndex(index, 0);
            return null;
        }

        @Override
        public Iterator<E> iterator() {
            return Collections.emptyIterator();
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            throw new InvalidObjectException("not serial proxy");
        }

        private Object writeReplace() {
            return new CollSer(1, new Object[0]);
        }

        @Override
        public boolean contains(Object o) {
            Objects.requireNonNull(o);
            return false;
        }

        @Override
        public boolean containsAll(Collection<?> o) {
            return o.isEmpty();
        }

        @Override
        public int hashCode() {
            return 1;
        }
    }

    static abstract class AbstractImmutableList<E>
    extends AbstractList<E>
    implements RandomAccess,
    Serializable {
        AbstractImmutableList() {
        }

        @Override
        public boolean add(E e) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public boolean addAll(int index, Collection<? extends E> c) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public void clear() {
            throw ImmutableCollections.uoe();
        }

        @Override
        public boolean remove(Object o) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public boolean removeIf(Predicate<? super E> filter) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public void replaceAll(UnaryOperator<E> operator) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw ImmutableCollections.uoe();
        }

        @Override
        public void sort(Comparator<? super E> c) {
            throw ImmutableCollections.uoe();
        }
    }
}

