/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import jdk.internal.HotSpotIntrinsicCandidate;
import jdk.internal.misc.Unsafe;

class ArraysSupport {
    static final Unsafe U = Unsafe.getUnsafe();
    private static final boolean BIG_ENDIAN = U.isBigEndian();
    private static final int LOG2_ARRAY_BOOLEAN_INDEX_SCALE = ArraysSupport.exactLog2(Unsafe.ARRAY_BOOLEAN_INDEX_SCALE);
    private static final int LOG2_ARRAY_BYTE_INDEX_SCALE = ArraysSupport.exactLog2(Unsafe.ARRAY_BYTE_INDEX_SCALE);
    private static final int LOG2_ARRAY_CHAR_INDEX_SCALE = ArraysSupport.exactLog2(Unsafe.ARRAY_CHAR_INDEX_SCALE);
    private static final int LOG2_ARRAY_SHORT_INDEX_SCALE = ArraysSupport.exactLog2(Unsafe.ARRAY_SHORT_INDEX_SCALE);
    private static final int LOG2_ARRAY_INT_INDEX_SCALE = ArraysSupport.exactLog2(Unsafe.ARRAY_INT_INDEX_SCALE);
    private static final int LOG2_ARRAY_LONG_INDEX_SCALE = ArraysSupport.exactLog2(Unsafe.ARRAY_LONG_INDEX_SCALE);
    private static final int LOG2_ARRAY_FLOAT_INDEX_SCALE = ArraysSupport.exactLog2(Unsafe.ARRAY_FLOAT_INDEX_SCALE);
    private static final int LOG2_ARRAY_DOUBLE_INDEX_SCALE = ArraysSupport.exactLog2(Unsafe.ARRAY_DOUBLE_INDEX_SCALE);
    private static final int LOG2_BYTE_BIT_SIZE = ArraysSupport.exactLog2(8);

    private static int exactLog2(int scale) {
        if ((scale & scale - 1) != 0) {
            throw new Error("data type scale not a power of two");
        }
        return Integer.numberOfTrailingZeros(scale);
    }

    private ArraysSupport() {
    }

    @HotSpotIntrinsicCandidate
    static int vectorizedMismatch(Object a, long aOffset, Object b, long bOffset, int length, int log2ArrayIndexScale) {
        int wi;
        int log2ValuesPerWidth = LOG2_ARRAY_LONG_INDEX_SCALE - log2ArrayIndexScale;
        for (wi = 0; wi < length >> log2ValuesPerWidth; ++wi) {
            long bv;
            long bi = (long)wi << LOG2_ARRAY_LONG_INDEX_SCALE;
            long av = U.getLongUnaligned(a, aOffset + bi);
            if (av == (bv = U.getLongUnaligned(b, bOffset + bi))) continue;
            long x = av ^ bv;
            int o = BIG_ENDIAN ? Long.numberOfLeadingZeros(x) >> LOG2_BYTE_BIT_SIZE + log2ArrayIndexScale : Long.numberOfTrailingZeros(x) >> LOG2_BYTE_BIT_SIZE + log2ArrayIndexScale;
            return (wi << log2ValuesPerWidth) + o;
        }
        int tail = length - (wi << log2ValuesPerWidth);
        if (log2ArrayIndexScale < LOG2_ARRAY_INT_INDEX_SCALE) {
            int wordTail = 1 << LOG2_ARRAY_INT_INDEX_SCALE - log2ArrayIndexScale;
            if (tail >= wordTail) {
                int bv;
                long bi = (long)wi << LOG2_ARRAY_LONG_INDEX_SCALE;
                int av = U.getIntUnaligned(a, aOffset + bi);
                if (av != (bv = U.getIntUnaligned(b, bOffset + bi))) {
                    int x = av ^ bv;
                    int o = BIG_ENDIAN ? Integer.numberOfLeadingZeros(x) >> LOG2_BYTE_BIT_SIZE + log2ArrayIndexScale : Integer.numberOfTrailingZeros(x) >> LOG2_BYTE_BIT_SIZE + log2ArrayIndexScale;
                    return (wi << log2ValuesPerWidth) + o;
                }
                tail -= wordTail;
            }
            return ~tail;
        }
        return ~tail;
    }

    static int mismatch(boolean[] a, boolean[] b, int length) {
        int i = 0;
        if (length > 7) {
            i = ArraysSupport.vectorizedMismatch(a, Unsafe.ARRAY_BOOLEAN_BASE_OFFSET, b, Unsafe.ARRAY_BOOLEAN_BASE_OFFSET, length, LOG2_ARRAY_BOOLEAN_INDEX_SCALE);
            if (i >= 0) {
                return i;
            }
            i = length - ~i;
        }
        while (i < length) {
            if (a[i] != b[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    static int mismatch(boolean[] a, int aFromIndex, boolean[] b, int bFromIndex, int length) {
        int i = 0;
        if (length > 7) {
            int aOffset = Unsafe.ARRAY_BOOLEAN_BASE_OFFSET + aFromIndex;
            int bOffset = Unsafe.ARRAY_BOOLEAN_BASE_OFFSET + bFromIndex;
            i = ArraysSupport.vectorizedMismatch(a, aOffset, b, bOffset, length, LOG2_ARRAY_BOOLEAN_INDEX_SCALE);
            if (i >= 0) {
                return i;
            }
            i = length - ~i;
        }
        while (i < length) {
            if (a[aFromIndex + i] != b[bFromIndex + i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    static int mismatch(byte[] a, byte[] b, int length) {
        int i = 0;
        if (length > 7) {
            i = ArraysSupport.vectorizedMismatch(a, Unsafe.ARRAY_BYTE_BASE_OFFSET, b, Unsafe.ARRAY_BYTE_BASE_OFFSET, length, LOG2_ARRAY_BYTE_INDEX_SCALE);
            if (i >= 0) {
                return i;
            }
            i = length - ~i;
        }
        while (i < length) {
            if (a[i] != b[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    static int mismatch(byte[] a, int aFromIndex, byte[] b, int bFromIndex, int length) {
        int i = 0;
        if (length > 7) {
            int aOffset = Unsafe.ARRAY_BYTE_BASE_OFFSET + aFromIndex;
            int bOffset = Unsafe.ARRAY_BYTE_BASE_OFFSET + bFromIndex;
            i = ArraysSupport.vectorizedMismatch(a, aOffset, b, bOffset, length, LOG2_ARRAY_BYTE_INDEX_SCALE);
            if (i >= 0) {
                return i;
            }
            i = length - ~i;
        }
        while (i < length) {
            if (a[aFromIndex + i] != b[bFromIndex + i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    static int mismatch(char[] a, char[] b, int length) {
        int i = 0;
        if (length > 3) {
            i = ArraysSupport.vectorizedMismatch(a, Unsafe.ARRAY_CHAR_BASE_OFFSET, b, Unsafe.ARRAY_CHAR_BASE_OFFSET, length, LOG2_ARRAY_CHAR_INDEX_SCALE);
            if (i >= 0) {
                return i;
            }
            i = length - ~i;
        }
        while (i < length) {
            if (a[i] != b[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    static int mismatch(char[] a, int aFromIndex, char[] b, int bFromIndex, int length) {
        int i = 0;
        if (length > 3) {
            int aOffset = Unsafe.ARRAY_CHAR_BASE_OFFSET + (aFromIndex << LOG2_ARRAY_CHAR_INDEX_SCALE);
            int bOffset = Unsafe.ARRAY_CHAR_BASE_OFFSET + (bFromIndex << LOG2_ARRAY_CHAR_INDEX_SCALE);
            i = ArraysSupport.vectorizedMismatch(a, aOffset, b, bOffset, length, LOG2_ARRAY_CHAR_INDEX_SCALE);
            if (i >= 0) {
                return i;
            }
            i = length - ~i;
        }
        while (i < length) {
            if (a[aFromIndex + i] != b[bFromIndex + i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    static int mismatch(short[] a, short[] b, int length) {
        int i = 0;
        if (length > 3) {
            i = ArraysSupport.vectorizedMismatch(a, Unsafe.ARRAY_SHORT_BASE_OFFSET, b, Unsafe.ARRAY_SHORT_BASE_OFFSET, length, LOG2_ARRAY_SHORT_INDEX_SCALE);
            if (i >= 0) {
                return i;
            }
            i = length - ~i;
        }
        while (i < length) {
            if (a[i] != b[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    static int mismatch(short[] a, int aFromIndex, short[] b, int bFromIndex, int length) {
        int i = 0;
        if (length > 3) {
            int aOffset = Unsafe.ARRAY_SHORT_BASE_OFFSET + (aFromIndex << LOG2_ARRAY_SHORT_INDEX_SCALE);
            int bOffset = Unsafe.ARRAY_SHORT_BASE_OFFSET + (bFromIndex << LOG2_ARRAY_SHORT_INDEX_SCALE);
            i = ArraysSupport.vectorizedMismatch(a, aOffset, b, bOffset, length, LOG2_ARRAY_SHORT_INDEX_SCALE);
            if (i >= 0) {
                return i;
            }
            i = length - ~i;
        }
        while (i < length) {
            if (a[aFromIndex + i] != b[bFromIndex + i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    static int mismatch(int[] a, int[] b, int length) {
        int i = 0;
        if (length > 1) {
            i = ArraysSupport.vectorizedMismatch(a, Unsafe.ARRAY_INT_BASE_OFFSET, b, Unsafe.ARRAY_INT_BASE_OFFSET, length, LOG2_ARRAY_INT_INDEX_SCALE);
            if (i >= 0) {
                return i;
            }
            i = length - ~i;
        }
        while (i < length) {
            if (a[i] != b[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    static int mismatch(int[] a, int aFromIndex, int[] b, int bFromIndex, int length) {
        int i = 0;
        if (length > 1) {
            int aOffset = Unsafe.ARRAY_INT_BASE_OFFSET + (aFromIndex << LOG2_ARRAY_INT_INDEX_SCALE);
            int bOffset = Unsafe.ARRAY_INT_BASE_OFFSET + (bFromIndex << LOG2_ARRAY_INT_INDEX_SCALE);
            i = ArraysSupport.vectorizedMismatch(a, aOffset, b, bOffset, length, LOG2_ARRAY_INT_INDEX_SCALE);
            if (i >= 0) {
                return i;
            }
            i = length - ~i;
        }
        while (i < length) {
            if (a[aFromIndex + i] != b[bFromIndex + i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    static int mismatch(float[] a, float[] b, int length) {
        return ArraysSupport.mismatch(a, 0, b, 0, length);
    }

    static int mismatch(float[] a, int aFromIndex, float[] b, int bFromIndex, int length) {
        int i = 0;
        if (length > 1) {
            int aOffset = Unsafe.ARRAY_FLOAT_BASE_OFFSET + (aFromIndex << LOG2_ARRAY_FLOAT_INDEX_SCALE);
            int bOffset = Unsafe.ARRAY_FLOAT_BASE_OFFSET + (bFromIndex << LOG2_ARRAY_FLOAT_INDEX_SCALE);
            i = ArraysSupport.vectorizedMismatch(a, aOffset, b, bOffset, length, LOG2_ARRAY_FLOAT_INDEX_SCALE);
            if (i >= 0) {
                if (!Float.isNaN(a[aFromIndex + i]) || !Float.isNaN(b[bFromIndex + i])) {
                    return i;
                }
                ++i;
            } else {
                i = length - ~i;
            }
        }
        while (i < length) {
            if (Float.floatToIntBits(a[aFromIndex + i]) != Float.floatToIntBits(b[bFromIndex + i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    static int mismatch(long[] a, long[] b, int length) {
        if (length == 0) {
            return -1;
        }
        int i = ArraysSupport.vectorizedMismatch(a, Unsafe.ARRAY_LONG_BASE_OFFSET, b, Unsafe.ARRAY_LONG_BASE_OFFSET, length, LOG2_ARRAY_LONG_INDEX_SCALE);
        return i >= 0 ? i : -1;
    }

    static int mismatch(long[] a, int aFromIndex, long[] b, int bFromIndex, int length) {
        if (length == 0) {
            return -1;
        }
        int aOffset = Unsafe.ARRAY_LONG_BASE_OFFSET + (aFromIndex << LOG2_ARRAY_LONG_INDEX_SCALE);
        int bOffset = Unsafe.ARRAY_LONG_BASE_OFFSET + (bFromIndex << LOG2_ARRAY_LONG_INDEX_SCALE);
        int i = ArraysSupport.vectorizedMismatch(a, aOffset, b, bOffset, length, LOG2_ARRAY_LONG_INDEX_SCALE);
        return i >= 0 ? i : -1;
    }

    static int mismatch(double[] a, double[] b, int length) {
        return ArraysSupport.mismatch(a, 0, b, 0, length);
    }

    static int mismatch(double[] a, int aFromIndex, double[] b, int bFromIndex, int length) {
        if (length == 0) {
            return -1;
        }
        int aOffset = Unsafe.ARRAY_DOUBLE_BASE_OFFSET + (aFromIndex << LOG2_ARRAY_DOUBLE_INDEX_SCALE);
        int bOffset = Unsafe.ARRAY_DOUBLE_BASE_OFFSET + (bFromIndex << LOG2_ARRAY_DOUBLE_INDEX_SCALE);
        int i = ArraysSupport.vectorizedMismatch(a, aOffset, b, bOffset, length, LOG2_ARRAY_DOUBLE_INDEX_SCALE);
        if (i >= 0) {
            if (!Double.isNaN(a[aFromIndex + i]) || !Double.isNaN(b[bFromIndex + i])) {
                return i;
            }
            ++i;
            while (i < length) {
                if (Double.doubleToLongBits(a[aFromIndex + i]) != Double.doubleToLongBits(b[bFromIndex + i])) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }
}

